unit SelDir;

{
  Inno Setup
  Copyright (C) 1998-99 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Select Directory form
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, NewFCtrl;

type
  TSelDirForm = class(TForm)
    DirEdit: TEdit;
    DirList: TNewDirectoryListBox;
    DriveList: TNewDriveComboBox;
    SelectDirectoryLabel: TLabel;
    OKButton: TButton;
    CancelButton: TButton;
    procedure DirListChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create (AOwner: TComponent); override;
  end;

function SelectDir (var Directory: String; const ParentWnd: HWND): Boolean;

implementation

{$I VERSION.INC}

uses
  ShlObj, {$IFNDEF Delphi3orHigher} Ole2, {$ELSE} ActiveX, {$ENDIF}
  Msgs, MsgIDs, CmnFunc2, Install, Main;

{$R *.DFM}

function BrowseForFolder (var Directory: String; const ParentWnd: HWND): Boolean;
var
  Malloc: IMalloc;
  BrowseInfo: TBrowseInfo;
  DisplayName, Path: array[0..MAX_PATH-1] of Char;
  IDList: PItemIDList;
begin
  if FAILED(SHGetMalloc(Malloc)) then
    Malloc := nil;
  FillChar (BrowseInfo, SizeOf(BrowseInfo), 0);
  with BrowseInfo do begin
    hwndOwner := ParentWnd;
    pszDisplayName := @DisplayName;
    lpszTitle := PChar(SetupMessages[msgSelectDirectoryLabel]);
    ulFlags := BIF_RETURNONLYFSDIRS;
  end;
  IDList := SHBrowseForFolder(BrowseInfo);
  try
    if (IDList = nil) or not SHGetPathFromIDList(IDList, Path) then begin
      Result := False;
      Exit;
    end;
    Directory := Path;
  finally
    if Assigned(Malloc) then
      Malloc.Free (IDList);
  end;
  Result := True;
end;

function SelectDir (var Directory: String; const ParentWnd: HWND): Boolean;
begin
  if not NewGUI then
    with TSelDirForm.Create(Application) do
      try
        try DirList.Directory := Directory; except {ignore any exceptions} end;
        Result := ShowModal = mrOK;
        if Result then Directory := DirEdit.Text;
      finally
        Free;
      end
  else
    Result := BrowseForFolder(Directory, ParentWnd);
end;


{ TSelDirForm }

constructor TSelDirForm.Create (AOwner: TComponent);
var
  OldTextHeight, NewTextHeight: Integer;
begin
  inherited;

  SetFormFont (Self, OldTextHeight, NewTextHeight);

  Caption := SetupMessages[msgSelectDirectory];
  SelectDirectoryLabel.Caption := SetupMessages[msgSelectDirectoryLabel];
  OKButton.Caption := SetupMessages[msgButtonOK];
  CancelButton.Caption := SetupMessages[msgButtonCancel];
  DirEdit.Text := DirList.Directory;
end;

procedure TSelDirForm.DirListChange(Sender: TObject);
begin
  DirEdit.Text := DirList.Directory;
end;

end.
