program Compil32;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Compiler
}

uses
  Windows,
  SysUtils,
  Forms,
  CompForm in 'CompForm.pas' {CompileForm},
  CmnFunc in 'CmnFunc.pas',
  CmnFunc2 in 'CmnFunc2.pas',
  CompMsgs in 'CompMsgs.pas',
  CompInt in 'CompInt.pas',
  CompOptions in 'CompOptions.pas' {OptionsForm};

{$R *.RES}

procedure CheckParams;
  procedure Error;
  begin
    Application.MessageBox (SCompilerCommandLineHelp2, SCompilerFormCaption,
      MB_OK or MB_ICONEXCLAMATION);
    Halt (1);
  end;
var
  P, I: Integer;
  S: String;
begin
  P := ParamCount;
  if P <> 0 then begin
    for I := 1 to P do begin
      S := ParamStr(I);
      if CompareText(S, '/CC') = 0 then
        CommandLineCompile := True
      else
      if (S[1] = '/') or (CommandLineFilename <> '') then
        Error
      else
        CommandLineFilename := ExpandFileName(S);
    end;
  end;
  if CommandLineCompile and (CommandLineFilename = '') then
    Error;
end;

begin
  if Win32Platform = VER_PLATFORM_WIN32s then begin
    Application.MessageBox (SCompilerNotOnWin32s, nil, MB_OK or MB_ICONSTOP);
    Exit;
  end;
  CreateMutex (nil, False, 'InnoSetupCompilerAppMutex');
  CheckParams;

  { The 'with' is so that the Delphi IDE doesn't mess with these }
  with Application do begin
    Title := SCompilerFormCaption;
    HelpFile := ExtractFilePath(ParamStr(0)) + 'isetup.hlp';
  end;

  Application.CreateForm(TCompileForm, CompileForm);
  Application.Run;
end.
