unit NewBevel;

interface

uses
  SysUtils, WinProcs, WinTypes, Messages, Classes, Graphics, Controls,
  Forms, StdCtrls;

type
  TNewDrawEdgeStyle = (deRaised, deSunken, deSoftRaised, deSoftSunken, deThinRaised, deThinSunken);

procedure NewDrawEdge (const Canvas: TCanvas; R: TRect; const Style: TNewDrawEdgeStyle);

type
  TNewBevel = class(TGraphicControl)
  private
    FStyle: TNewDrawEdgeStyle;
    procedure SetStyle (Value: TNewDrawEdgeStyle);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Align;
    property Enabled;
    property Font;
    {property InsideRect: Boolean read FInsideRect write SetInsideRect default False;
    property InsideRectColor: TColor read FInsideRectColor write SetInsideRectColor default clWindow;}
    property ParentShowHint;
    property ShowHint;
    property Style: TNewDrawEdgeStyle read FStyle write SetStyle;
    property Visible;
  end;

procedure Register;

implementation

procedure NewDrawEdge (const Canvas: TCanvas; R: TRect; const Style: TNewDrawEdgeStyle);
{$IFDEF WIN32}
const
  StyleTable: array[TNewDrawEdgeStyle, 0..1] of UINT = (
    (EDGE_RAISED, BF_RECT),
    (EDGE_SUNKEN, BF_RECT),
    (EDGE_RAISED, BF_RECT or BF_SOFT),
    (EDGE_SUNKEN, BF_RECT or BF_SOFT),
    (BDR_RAISEDINNER, BF_RECT),
    (BDR_SUNKENOUTER, BF_RECT));
{$ELSE}
type
  TTableEntry = record
    te1, te2, te3, te4: TColor;
  end;
const
  ColorTable: array[TNewDrawEdgeStyle] of TTableEntry = (
    (te1: clBtnFace; te2: clBtnHighlight; te3: clBtnShadow; te4: clBlack),
    (te1: clBtnShadow; te2: clBlack; te3: clBtnFace; te4: clBtnHighlight),
    (te1: clBtnHighlight; te2: clBtnFace; te3: clBtnShadow; te4: clBlack),
    (te1: clBlack; te2: clBtnShadow; te3: clBtnFace; te4: clBtnHighlight),
    (te1: clBtnHighlight; te2: -1; te3: -1; te4: clBtnShadow),
    (te1: clBtnShadow; te2: -1; te3: -1; te4: clBtnHighlight));
{$ENDIF}
begin
  {$IFDEF WIN32}
  DrawEdge (Canvas.Handle, R, StyleTable[Style,0], StyleTable[Style,1]);
  {$ELSE}
  Dec (R.Right);
  Dec (R.Bottom);
  with ColorTable[Style], Canvas do begin
    if te1 <> -1 then begin
      Pen.Color := te1;
      MoveTo (R.Left, R.Bottom-1); LineTo (R.Left, R.Top-1);
      MoveTo (R.Left, R.Top); LineTo (R.Right+1, R.Top);
    end;
    if te2 <> -1 then begin
      Pen.Color := te2;
      MoveTo (R.Left+1, R.Bottom-2); LineTo (R.Left+1, R.Top);
      MoveTo (R.Left+1, R.Top+1); LineTo (R.Right-1, R.Top+1);
    end;
    if te3 <> -1 then begin
      Pen.Color := te3;
      MoveTo (R.Right-1, R.Top+1); LineTo (R.Right-1, R.Bottom);
      MoveTo (R.Right-1, R.Bottom-1); LineTo (R.Left, R.Bottom-1);
    end;
    if te4 <> -1 then begin
      Pen.Color := te4;
      MoveTo (R.Right, R.Top); LineTo (R.Right, R.Bottom+1);
      MoveTo (R.Right, R.Bottom); LineTo (R.Left-1, R.Bottom);
    end;
  end;
  {$ENDIF}
end;

procedure Register;
begin
  RegisterComponents('JR', [TNewBevel]);
end;

constructor TNewBevel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csOpaque];
  { default values }
  Width := 100;
  Height := 100;
  Style := deSunken;
end;

procedure TNewBevel.SetStyle (Value: TNewDrawEdgeStyle);
begin
  if FStyle <> Value then begin
    FStyle := Value;
    Invalidate;
  end;
end;

procedure TNewBevel.Paint;
var
  R: TRect;
begin
  R := ClientRect;
  NewDrawEdge (Canvas, R, FStyle);
end;

end.
