require 'test/unit'
require File.dirname(__FILE__) + '/../extractor'

class BasicTest < Test::Unit::TestCase
  
  def setup
    @mp3_filename = File.dirname(__FILE__) + '/things_fall_apart.mp3'
  end
  
  def test_extract_types
    metadata = Extractor.extract(@mp3_filename)
    
    metadata.each do |type, keyword|
      assert_kind_of( String, type )
      if keyword.kind_of?(Array)
        keyword.each { |k| assert_kind_of( String, k ) }
      else
        assert_kind_of( String, keyword )
      end
    end
    
  end
  
  
  def test_extract
    metadata = Extractor.extract(@mp3_filename)
    assert_equal(metadata['mimetype'], 'audio/mpeg')
    assert_equal(metadata['artist'], 'The Roots')
  end
  
end
