/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.expr.ApplyExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.ArithOp;
import gnu.kawa.functions.Arithmetic;
import gnu.mapping.Procedure;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MultiplyOp
extends ArithOp {
    public static final MultiplyOp $St = new MultiplyOp("*");

    public MultiplyOp(String string) {
        super(string);
    }

    public Object defaultResult() {
        return IntNum.one();
    }

    public int primitiveOpcode() {
        return 104;
    }

    public static Object apply(Object object2, Object object3) {
        return ((Numeric)object2).mul(object3);
    }

    public Object applyN(Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return IntNum.one();
        }
        Number number = (Number)objectArray[0];
        int n2 = Arithmetic.classifyValue(number);
        block11: for (int i = 1; i < n; ++i) {
            Object object2 = objectArray[i];
            int n3 = Arithmetic.classifyValue(object2);
            n2 = n2 < n3 ? n3 : n2;
            switch (n2) {
                case 1: {
                    int n4 = Arithmetic.asInt(number);
                    int n5 = Arithmetic.asInt(object2);
                    number = new Integer(n4 * n5);
                    continue block11;
                }
                case 2: {
                    long l = Arithmetic.asLong(number);
                    long l2 = Arithmetic.asLong(object2);
                    number = new Long(l * l2);
                    continue block11;
                }
                case 3: {
                    BigInteger bigInteger = Arithmetic.asBigInteger(number);
                    BigInteger bigInteger2 = Arithmetic.asBigInteger(object2);
                    number = bigInteger.multiply(bigInteger2);
                    continue block11;
                }
                case 4: {
                    number = IntNum.times(Arithmetic.asIntNum(number), Arithmetic.asIntNum(object2));
                    continue block11;
                }
                case 5: {
                    BigDecimal bigDecimal = Arithmetic.asBigDecimal(number);
                    BigDecimal bigDecimal2 = Arithmetic.asBigDecimal(object2);
                    number = bigDecimal.multiply(bigDecimal2);
                    continue block11;
                }
                case 6: {
                    number = RatNum.times(Arithmetic.asRatNum(number), Arithmetic.asRatNum(object2));
                    continue block11;
                }
                case 7: {
                    float f = Arithmetic.asFloat(number);
                    float f2 = Arithmetic.asFloat(object2);
                    number = new Float(f * f2);
                    continue block11;
                }
                case 8: {
                    double d = Arithmetic.asDouble(number);
                    double d2 = Arithmetic.asDouble(object2);
                    number = new Double(d * d2);
                    continue block11;
                }
                case 9: {
                    double d = Arithmetic.asDouble(number);
                    double d2 = Arithmetic.asDouble(object2);
                    number = new DFloNum(d * d2);
                    continue block11;
                }
                default: {
                    number = Arithmetic.asNumeric(number).mul(Arithmetic.asNumeric(object2));
                }
            }
        }
        return number;
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        if (!inlineCalls.getCompilation().mustCompile) {
            return applyExp;
        }
        Expression expression = applyExp.inlineIfConstant((Procedure)this, inlineCalls);
        if (expression != applyExp) {
            return expression;
        }
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > 2) {
            return AddOp.pairwise(this, applyExp.getFunction(), expressionArray, inlineCalls);
        }
        if (expressionArray.length == 2) {
            return AddOp.primInline(104, applyExp);
        }
        return applyExp;
    }
}

