/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.EnvironmentKey;
import gnu.mapping.Namespace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class Symbol
implements EnvironmentKey,
Comparable,
Externalizable {
    protected String name;
    Namespace namespace;
    public static final Symbol FUNCTION = Symbol.makeUninterned("(function)");
    public static final Symbol PLIST = Symbol.makeUninterned("(property-list)");

    public final Symbol getKeySymbol() {
        return this;
    }

    public final Object getKeyProperty() {
        return null;
    }

    public boolean matches(EnvironmentKey key) {
        return Symbol.equals(key.getKeySymbol(), this) && key.getKeyProperty() == null;
    }

    public boolean matches(Symbol symbol, Object property) {
        return Symbol.equals(symbol, this) && property == null;
    }

    public final String getNamespaceURI() {
        Namespace ns = this.getNamespace();
        return ns == null ? null : ns.getName();
    }

    public final String getLocalPart() {
        return this.name;
    }

    public final String getPrefix() {
        Namespace ns = this.namespace;
        return ns == null ? "" : ns.prefix;
    }

    public final boolean hasEmptyNamespace() {
        String nsname;
        Namespace ns = this.getNamespace();
        return ns == null || (nsname = ns.getName()) == null || nsname.length() == 0;
    }

    public final String getLocalName() {
        return this.name;
    }

    public final String getName() {
        return this.name;
    }

    public static Symbol make(String uri, String name, String prefix) {
        return Namespace.make(uri, prefix).getSymbol(name.intern());
    }

    public static Symbol make(Object namespace, String name) {
        Namespace ns;
        Namespace namespace2 = ns = namespace instanceof String ? Namespace.getInstance((String)namespace) : (Namespace)namespace;
        if (ns == null || name == null) {
            return Symbol.makeUninterned(name);
        }
        return ns.getSymbol(name.intern());
    }

    public static Symbol parse(String symbol) {
        if (symbol.length() > 0 && symbol.charAt(0) == '{') {
            int rbrace = symbol.lastIndexOf(125);
            if (rbrace <= 0) {
                throw new RuntimeException("missing '}' in property name '" + symbol + "'");
            }
            return Symbol.make(symbol.substring(1, rbrace), symbol.substring(rbrace + 1), "");
        }
        int colon = symbol.indexOf(58);
        if (colon > 0) {
            return Symbol.makeWithUnknownNamespace(symbol.substring(colon + 1), symbol.substring(0, colon));
        }
        return Symbol.make("", symbol, "");
    }

    public static Symbol makeWithUnknownNamespace(String local, String prefix) {
        return Namespace.makeUnknownNamespace(prefix).getSymbol(local.intern());
    }

    public Symbol() {
    }

    public static Symbol makeUninterned(String name) {
        return new Symbol(null, name);
    }

    public Symbol(Namespace ns, String name) {
        this.name = name;
        this.namespace = ns;
    }

    public int compareTo(Object o) {
        Symbol other = (Symbol)o;
        if (this.getNamespaceURI() != other.getNamespaceURI()) {
            throw new IllegalArgumentException("comparing Symbols in different namespaces");
        }
        return this.getLocalName().compareTo(other.getLocalName());
    }

    public static boolean equals(Symbol sym1, Symbol sym2) {
        if (sym1 == sym2) {
            return true;
        }
        if (sym1 == null || sym2 == null) {
            return false;
        }
        if (sym1.name == sym2.name) {
            Namespace namespace1 = sym1.namespace;
            Namespace namespace2 = sym2.namespace;
            return namespace1 != null && namespace2 != null && (namespace1 == namespace2 || namespace1.name == namespace2.name);
        }
        return false;
    }

    public final boolean equals(Object o) {
        return o instanceof Symbol && Symbol.equals(this, (Symbol)o);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public final Namespace getNamespace() {
        return this.namespace;
    }

    public final void setNamespace(Namespace ns) {
        this.namespace = ns;
    }

    public String toString() {
        String uri = this.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return this.getName();
        }
        StringBuffer sbuf = new StringBuffer();
        String prefix = this.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            sbuf.append('{');
            sbuf.append(this.getNamespaceURI());
            sbuf.append('}');
        } else {
            sbuf.append(prefix);
            sbuf.append(':');
        }
        sbuf.append(this.getName());
        return sbuf.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Namespace ns = this.getNamespace();
        out.writeObject(ns);
        out.writeObject(this.getName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.namespace = (Namespace)in.readObject();
        this.name = (String)in.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.namespace == null) {
            return this;
        }
        return Symbol.make(this.namespace, this.getName());
    }
}

