/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.lists.LList;
import gnu.lists.PairWithPosition;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure1or2;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import kawa.lang.Translator;

public class Eval
extends Procedure1or2 {
    public static final Eval eval = new Eval();
    static final String evalFunctionName = "atEvalLevel";

    public static void eval(Object object2, Environment environment, CallContext callContext) throws Throwable {
        PairWithPosition pairWithPosition;
        if (object2 instanceof PairWithPosition) {
            pairWithPosition = new PairWithPosition((PairWithPosition)object2, object2, LList.Empty);
        } else {
            pairWithPosition = new PairWithPosition(object2, LList.Empty);
            pairWithPosition.setFile("<eval>");
        }
        Eval.evalBody(pairWithPosition, environment, new SourceMessages(), callContext);
    }

    public static Object evalBody(Object object2, Environment environment, SourceMessages sourceMessages) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            Eval.evalBody(object2, environment, sourceMessages, callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public static Object eval(Object object2, Environment environment) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            Eval.eval(object2, environment, callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evalBody(Object object2, Environment environment, SourceMessages sourceMessages, CallContext callContext) throws Throwable {
        Language language = Language.getDefaultLanguage();
        Environment environment2 = Environment.getCurrent();
        try {
            if (environment != environment2) {
                Environment.setCurrent(environment);
            }
            Translator translator = new Translator(language, sourceMessages);
            translator.immediate = true;
            ModuleExp moduleExp = new ModuleExp();
            Values values = new Values();
            translator.push(moduleExp);
            Compilation compilation = Compilation.getCurrent();
            try {
                Compilation.setCurrent(translator);
                int n = translator.formStack.size();
                translator.scanBody(object2, moduleExp, false);
                translator.finishModule(moduleExp, n);
            }
            finally {
                Compilation.setCurrent(compilation);
            }
            if (object2 instanceof PairWithPosition) {
                moduleExp.setFile(((PairWithPosition)object2).getFile());
            }
            moduleExp.setName(evalFunctionName);
            ModuleExp.evalModule(environment, callContext, translator);
            if (sourceMessages.seenErrors()) {
                throw new RuntimeException("invalid syntax in eval form:\n" + sourceMessages.toString(20));
            }
        }
        finally {
            if (environment != environment2) {
                Environment.setCurrent(environment2);
            }
        }
    }

    public Object apply1(Object object2) throws Throwable {
        return Eval.eval(object2, Environment.user());
    }

    public Object apply2(Object object2, Object object3) throws Throwable {
        return Eval.eval(object2, (Environment)object3);
    }

    public void apply(CallContext callContext) throws Throwable {
        Procedure.checkArgCount(this, callContext.count);
        Object object2 = callContext.getNextArg();
        Environment environment = (Environment)callContext.getNextArg(null);
        if (environment == null) {
            environment = Environment.user();
        }
        callContext.lastArg();
        Eval.eval(object2, environment, callContext);
    }

    static {
        eval.setName("eval");
    }
}

