/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolUtf8;
import java.io.DataOutputStream;
import java.io.IOException;

public class CpoolString
extends CpoolEntry {
    CpoolUtf8 str;

    CpoolString() {
    }

    CpoolString(ConstantPool constantPool, int n, CpoolUtf8 cpoolUtf8) {
        super(constantPool, n);
        this.str = cpoolUtf8;
    }

    public int getTag() {
        return 8;
    }

    public final CpoolUtf8 getString() {
        return this.str;
    }

    static final int hashCode(CpoolUtf8 cpoolUtf8) {
        return cpoolUtf8.hashCode() ^ 0xF30F;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = CpoolString.hashCode(this.str);
        }
        return this.hash;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(8);
        dataOutputStream.writeShort(this.str.index);
    }

    public void print(ClassTypeWriter classTypeWriter, int n) {
        if (n > 0) {
            classTypeWriter.print("String ");
            if (n == 2) {
                classTypeWriter.printOptionalIndex(this.str);
            }
        }
        classTypeWriter.printConstantTersely(this.str.index, 1);
    }
}

