/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;

public class ArrayType
extends ObjectType {
    public Type elements;

    public ArrayType(Type elements) {
        this(elements, elements.getName() + "[]");
    }

    ArrayType(Type elements, String name) {
        this.this_name = name;
        this.setSignature("[" + elements.getSignature());
        this.elements = elements;
    }

    public Type getImplementationType() {
        Type eltype = this.elements.getImplementationType();
        return this.elements == eltype ? this : ArrayType.make(eltype);
    }

    static ArrayType make(String name) {
        Type elements = Type.getType(name.substring(0, name.length() - 2));
        ArrayType array_type = elements.array_type;
        if (array_type == null) {
            elements.array_type = array_type = new ArrayType(elements, name);
        }
        return array_type;
    }

    public static ArrayType make(Type elements) {
        ArrayType array_type = elements.array_type;
        if (array_type == null) {
            elements.array_type = array_type = new ArrayType(elements, elements.getName() + "[]");
        }
        return array_type;
    }

    public Type getComponentType() {
        return this.elements;
    }

    public String getInternalName() {
        return this.getSignature();
    }

    public int compare(Type other) {
        if (other == nullType) {
            return 1;
        }
        if (other instanceof ArrayType) {
            return this.elements.compare(((ArrayType)other).elements);
        }
        if (other.getName().equals("java.lang.Object") || other == tostring_type) {
            return -1;
        }
        return -3;
    }
}

