/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Interpreter;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.OutPort;
import gnu.text.QueueReader;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Writer;
import kawa.GuiInPort;
import kawa.MessageArea;
import kawa.repl;
import kawa.standard.Scheme;

public class GuiConsole
extends Frame
implements ActionListener {
    private static String CLOSE = "Close";
    private static String EXIT = "Exit";
    private static String NEW = "New";
    private static String NEW_SHARED = "New (Shared)";
    private static String PURGE_MESSAGE = "Purge Buffer";
    static int window_number = 0;
    Interpreter interp;
    Environment environment;
    Future thread;
    QueueReader in_r;
    OutPort out_p;
    OutPort err_p;
    MessageArea message = null;

    public static void main(String[] stringArray) {
        Scheme scheme = new Scheme();
        new GuiConsole(scheme, ((Interpreter)scheme).getNewEnvironment());
    }

    public GuiConsole() {
        this(Interpreter.defaultInterpreter, Environment.getCurrent());
    }

    public GuiConsole(Interpreter interpreter, Environment environment) {
        super("Kawa");
        this.interp = interpreter;
        this.environment = environment;
        this.in_r = new QueueReader();
        this.message = new MessageArea(this.in_r);
        ++window_number;
        repl.exitIncrement();
        this.out_p = new OutPort((Writer)this.message.getStdout(), true, "<msg_stdout>");
        this.err_p = new OutPort((Writer)this.message.getStderr(), true, "<msg_stderr>");
        GuiInPort guiInPort = new GuiInPort(this.in_r, "<msg_stdin>", this.out_p, this.message);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.message);
        this.setupMenus();
        this.setLocation(100 * window_number, 50 * window_number);
        this.setSize(700, 500);
        this.setVisible(true);
        this.thread = new Future(new repl(interpreter), environment, guiInPort, this.out_p, this.err_p);
        this.thread.start();
    }

    void close() {
        this.in_r.appendEOF();
        this.dispose();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread.stop();
        repl.exitDecrement();
    }

    private void setupMenus() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GuiConsole.this.close();
            }
        };
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Utilities");
        menuBar.add(menu);
        menuBar.add(menu2);
        MenuItem menuItem = new MenuItem(NEW);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem(NEW_SHARED);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem(CLOSE);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem(EXIT);
        menuItem.addActionListener(this);
        this.addWindowListener(windowAdapter);
        menu.add(menuItem);
        menuItem = new MenuItem(PURGE_MESSAGE);
        menuItem.addActionListener(this);
        menu2.add(menuItem);
        this.setMenuBar(menuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(NEW)) {
            new GuiConsole(this.interp, this.interp.getNewEnvironment());
        } else if (string.equals(NEW_SHARED)) {
            new GuiConsole(this.interp, this.environment);
        } else if (string.equals(EXIT)) {
            System.exit(0);
        } else if (string.equals(CLOSE)) {
            this.close();
        } else if (string.equals(PURGE_MESSAGE)) {
            this.message.deleteOldText();
        } else {
            OutPort.outDefault().println("Unknown menu action: " + string);
        }
    }
}

