/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.CheckCyclesStatement;
import classycle.dependency.CheckSetStatement;
import classycle.dependency.DependencyProperties;
import classycle.dependency.DependencyStatement;
import classycle.dependency.LayerDefinitionRepository;
import classycle.dependency.LayeringStatement;
import classycle.dependency.Preference;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.ShowStatement;
import classycle.dependency.Statement;
import classycle.util.AndStringPattern;
import classycle.util.NotStringPattern;
import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import classycle.util.WildCardPattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class DependencyDefinitionParser {
    public static final String INDEPENDENT_OF_KEY_WORD = "independentOf";
    public static final String EXCLUDING_KEY_WORD = "excluding";
    public static final String DIRECTLY_INDEPENDENT_OF_KEY_WORD = "directlyIndependentOf";
    public static final String DEPENDENT_ONLY_ON_KEY_WORD = "dependentOnlyOn";
    public static final String CHECK_KEY_WORD = "check";
    public static final String LAYER_KEY_WORD = "layer";
    public static final String SHOW_KEY_WORD = "show";
    public static final String SETS_KEY_WORD = "sets";
    public static final String CLASS_CYCLES_KEY_WORD = "absenceOfClassCycles";
    public static final String PACKAGE_CYCLES_KEY_WORD = "absenceOfPackageCycles";
    public static final String IN_KEY_WORD = "in";
    public static final String LAYERING_OF_KEY_WORD = "layeringOf";
    public static final String STRICT_LAYERING_OF_KEY_WORD = "strictLayeringOf";
    private static final String[] INDEPENDENT = new String[]{"independentOf", "directlyIndependentOf", "dependentOnlyOn"};
    private static final String[] EXCLUDING = new String[]{"excluding"};
    private static final String PROP_DEF_BEGIN = "{";
    private static final String PROP_BEGIN = "${";
    private static final String PROP_END = "}";
    private final DependencyProperties _properties;
    private final ResultRenderer _renderer;
    final SetDefinitionRepository _setDefinitions = new SetDefinitionRepository();
    final LayerDefinitionRepository _layerDefinitions = new LayerDefinitionRepository();
    private final List<Statement> _statements = new ArrayList<Statement>();

    public DependencyDefinitionParser(String dependencyDefinition, DependencyProperties properties, ResultRenderer renderer) {
        this._properties = properties;
        this._renderer = renderer;
        try {
            String line;
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new StringReader(dependencyDefinition));
            int lineNumber = 0;
            int lineNumberOfCurrentLogicalLine = 1;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).startsWith("#")) continue;
                buffer.append(line);
                if (line.endsWith("\\")) {
                    buffer.deleteCharAt(buffer.length() - 1).append(' ');
                    continue;
                }
                String logicalLine = this.replaceProperties(new String(buffer).trim(), lineNumberOfCurrentLogicalLine);
                if (logicalLine.length() > 0) {
                    this.parseLine(logicalLine, lineNumberOfCurrentLogicalLine);
                }
                buffer.setLength(0);
                lineNumberOfCurrentLogicalLine = lineNumber + 1;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    private String replaceProperties(String line, int lineNumber) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < line.length()) {
            int index = line.indexOf(PROP_BEGIN, i);
            if (index >= 0) {
                buffer.append(line.substring(i, index));
                i = line.indexOf(PROP_END, index);
                if (i < 0) {
                    this.throwException("Missing '}'.", lineNumber, -1);
                }
                String name = line.substring(index + PROP_BEGIN.length(), i);
                i += PROP_END.length();
                String property = this._properties.getProperty(name);
                if (property == null) {
                    String message = "Undefines property " + line.substring(index, i);
                    this.throwException(message, lineNumber, -1);
                    continue;
                }
                buffer.append(property);
                continue;
            }
            buffer.append(line.substring(i));
            i = line.length();
        }
        return new String(buffer);
    }

    public Statement[] getStatements() {
        return this._statements.toArray(new Statement[0]);
    }

    private void parseLine(String line, int lineNumber) {
        if (line.startsWith(PROP_DEF_BEGIN)) {
            this.parsePropertyDefinition(line, lineNumber);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(line);
        String[] tokens = new String[tokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokenizer.nextToken();
        }
        String firstToken = tokens[0];
        if (firstToken.startsWith("[")) {
            this.parseSetDefinition(tokens, lineNumber);
        } else if (firstToken.equals(SHOW_KEY_WORD)) {
            this.parseShowStatement(tokens, lineNumber);
        } else if (firstToken.equals(LAYER_KEY_WORD)) {
            this.parseLayerDefinition(tokens, lineNumber);
        } else if (firstToken.equals(CHECK_KEY_WORD)) {
            this.parseCheckStatement(tokens, lineNumber);
        } else {
            this.throwException("Expecting either a property definition, a set name, 'show', 'layer', or 'check'.", lineNumber, 0);
        }
    }

    private void parsePropertyDefinition(String line, int lineNumber) {
        int index = line.indexOf(PROP_END);
        if (index < 0) {
            this.throwException("Missing '}' in property definition.", lineNumber, -1);
        }
        String name = line.substring(PROP_DEF_BEGIN.length(), index);
        String def = line.substring(index + PROP_END.length()).trim();
        if (!def.startsWith("=")) {
            this.throwException("Missing '=' in propety definition.", lineNumber, -1);
        }
        this._properties.setProperty(name, def.substring(1).trim());
    }

    private void parseSetDefinition(String[] tokens, int lineNumber) {
        String setName = tokens[0];
        if (!setName.endsWith("]")) {
            this.throwException("Set name has to end with ']'.", lineNumber, 0);
        }
        if (this._setDefinitions.contains(setName)) {
            this.throwException("Set " + setName + " already defined.", lineNumber, 0);
        }
        this.checkForEqualCharacter(tokens, lineNumber, 1);
        StringPattern[][] lists = this.getLists(tokens, lineNumber, EXCLUDING, 2);
        if (lists[0].length == 0 && lists[1].length == 0) {
            this.throwException("Missing terms in set definition.", lineNumber, 2);
        }
        AndStringPattern definition = new AndStringPattern(new StringPattern[0]);
        if (lists[0].length > 0) {
            definition.appendPattern(this.createOrSequence(lists[0]));
        }
        if (lists[1].length > 0) {
            definition.appendPattern(new NotStringPattern(this.createOrSequence(lists[1])));
        }
        this._setDefinitions.put(setName, definition);
    }

    private void checkForEqualCharacter(String[] tokens, int lineNumber, int index) {
        if (tokens.length < index + 1 || !tokens[index].equals("=")) {
            this.throwException("'=' missing.", lineNumber, index);
        }
    }

    private StringPattern createOrSequence(StringPattern[] patterns) {
        OrStringPattern result = new OrStringPattern(new StringPattern[0]);
        for (int i = 0; i < patterns.length; ++i) {
            result.appendPattern(patterns[i]);
        }
        return result;
    }

    private StringPattern createPattern(String term, int lineNumber, int tokenIndex) {
        StringPattern pattern = this._setDefinitions.getPattern(term);
        if (pattern == null) {
            if (term.startsWith("[") && term.endsWith("]")) {
                this.throwException("Set " + term + " is undefined.", lineNumber, tokenIndex);
            }
            if (term.indexOf(46) < 0 && term.indexOf(42) < 0 && term.length() > 0 && Character.isLowerCase(term.charAt(0))) {
                this.throwException("Patterns without a '.' and a '*' should not start with a lower-case letter: " + term, lineNumber, tokenIndex);
            }
            pattern = new WildCardPattern(term);
        }
        return pattern;
    }

    private void parseLayerDefinition(String[] tokens, int lineNumber) {
        String layerName;
        if (tokens.length < 2) {
            this.throwException("Missing layer name.", lineNumber, 1);
        }
        if (this._layerDefinitions.contains(layerName = tokens[1])) {
            this.throwException("Layer '" + layerName + "' already defined.", lineNumber, 1);
        }
        this.checkForEqualCharacter(tokens, lineNumber, 2);
        if (tokens.length < 4) {
            this.throwException("Missing terms in definition of layer '" + layerName + "'.", lineNumber, 3);
        }
        ArrayList<StringPattern> layer = new ArrayList<StringPattern>();
        for (int i = 3; i < tokens.length; ++i) {
            layer.add(this.createPattern(tokens[i], lineNumber, i));
        }
        StringPattern[] sets = new StringPattern[layer.size()];
        this._layerDefinitions.put(layerName, layer.toArray(sets));
    }

    private void parseShowStatement(String[] tokens, int lineNumber) {
        if (tokens.length < 2) {
            this.throwException("Missing display preference(s).", lineNumber, 1);
        }
        Preference[] preferences = new Preference[tokens.length - 1];
        for (int i = 0; i < preferences.length; ++i) {
            preferences[i] = this._renderer.getPreferenceFactory().get(tokens[i + 1]);
            if (preferences[i] != null) continue;
            this.throwException("Unknown display preference: " + tokens[i + 1], lineNumber, i + 1);
        }
        this._statements.add(new ShowStatement(this._renderer, preferences));
    }

    private void parseCheckStatement(String[] tokens, int lineNumber) {
        if (tokens.length < 2) {
            this.throwException("Missing checking statement.", lineNumber, 1);
        }
        if (tokens[1].equals(STRICT_LAYERING_OF_KEY_WORD) || tokens[1].equals(LAYERING_OF_KEY_WORD)) {
            this.createLayeringStatement(tokens, lineNumber);
        } else if (tokens[1].equals(SETS_KEY_WORD)) {
            this.createCheckSetStatements(tokens, lineNumber);
        } else if (tokens[1].equals(CLASS_CYCLES_KEY_WORD) || tokens[1].equals(PACKAGE_CYCLES_KEY_WORD)) {
            this.createCyclesStatement(tokens, lineNumber);
        } else {
            this.createDependencyStatement(tokens, lineNumber);
        }
    }

    private void createCyclesStatement(String[] tokens, int lineNumber) {
        boolean packageCycles = tokens[1].equals(PACKAGE_CYCLES_KEY_WORD);
        if (tokens.length != 6) {
            this.throwException("Invalid statement.", lineNumber, tokens.length);
        }
        if (!tokens[2].equals(">")) {
            this.throwException("'>' expected.", lineNumber, 2);
        }
        int size = 0;
        try {
            size = Integer.parseInt(tokens[3]);
        }
        catch (NumberFormatException e) {
            this.throwException("Number expected.", lineNumber, 3);
        }
        if (size < 1) {
            this.throwException("Size has to be >= 1", lineNumber, 3);
        }
        if (!tokens[4].equals(IN_KEY_WORD)) {
            this.throwException("'in' expected.", lineNumber, 4);
        }
        StringPattern pattern = this.createPattern(tokens[5], lineNumber, 4);
        this._statements.add(new CheckCyclesStatement(pattern, size, packageCycles, this._setDefinitions));
    }

    private void createCheckSetStatements(String[] tokens, int lineNumber) {
        if (tokens.length < 3) {
            this.throwException("No sets to check.", lineNumber, 2);
        }
        for (int i = 2; i < tokens.length; ++i) {
            StringPattern pattern = this.createPattern(tokens[i], lineNumber, i);
            this._statements.add(new CheckSetStatement(pattern, this._setDefinitions));
        }
    }

    private void createLayeringStatement(String[] tokens, int lineNumber) {
        StringPattern[][] layers = new StringPattern[tokens.length - 2][];
        for (int i = 0; i < layers.length; ++i) {
            String name = tokens[i + 2];
            layers[i] = this._layerDefinitions.getLayer(name);
            if (layers[i] != null) continue;
            this.throwException("Undefined layer '" + name + "'.", lineNumber, i + 2);
        }
        boolean strict = tokens[1].equals(STRICT_LAYERING_OF_KEY_WORD);
        this._statements.add(new LayeringStatement(layers, strict, this._setDefinitions, this._layerDefinitions, this._renderer));
    }

    private void createDependencyStatement(String[] tokens, int lineNumber) {
        StringPattern[][] lists = this.getLists(tokens, lineNumber, INDEPENDENT, 1);
        if (lists[0].length == 0) {
            this.throwException("Missing start sets.", lineNumber, 1);
        }
        if (lists[1].length == 0) {
            this.throwException("Missing end sets. Probably one of the following key words are missing: " + Arrays.asList(INDEPENDENT), lineNumber, tokens.length);
        }
        this._statements.add(new DependencyStatement(lists[0], lists[1], tokens[lists[0].length + 1], this._setDefinitions, this._renderer));
    }

    private StringPattern[][] getLists(String[] tokens, int lineNumber, String[] keyWords, int startIndex) {
        ArrayList<StringPattern> startSets = new ArrayList<StringPattern>();
        ArrayList endSets = new ArrayList();
        ArrayList<StringPattern> currentList = startSets;
        for (int i = startIndex; i < tokens.length; ++i) {
            String token = tokens[i];
            if (this.isAKeyWord(token, keyWords)) {
                if (currentList == endSets) {
                    this.throwException("Invalid appearance of key word '" + token + "'.", lineNumber, i);
                }
                currentList = endSets;
                continue;
            }
            currentList.add(this.createPattern(token, lineNumber, i));
        }
        StringPattern[][] result = new StringPattern[][]{startSets.toArray(new StringPattern[0]), endSets.toArray(new StringPattern[0])};
        return result;
    }

    private boolean isAKeyWord(String token, String[] keyWords) {
        boolean result = false;
        for (int i = 0; i < keyWords.length; ++i) {
            if (!keyWords[i].equals(token)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void throwException(String message, int lineNumber, int tokenIndex) {
        StringBuffer buffer = new StringBuffer("Error in line ");
        buffer.append(lineNumber);
        if (tokenIndex >= 0) {
            buffer.append(" token ").append(tokenIndex + 1);
        }
        buffer.append(": ").append(message);
        throw new IllegalArgumentException(new String(buffer));
    }
}

