/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WaveformZoom
extends EDialog {
    private Panel curPanel;
    private WaveformWindow curWindow;
    private double trueLowY;
    private double trueHighY;
    private double trueScale = 1.0;
    private boolean updatingTextFields = false;
    private ButtonGroup buttonGroup1;
    private JButton cancel;
    private JTextField horizontalHigh;
    private JTextField horizontalLow;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JButton ok;
    private JButton setScaleTo2Pi;
    private JTextField verticalHigh;
    private JRadioButton verticalLinear;
    private JRadioButton verticalLogarithmic;
    private JTextField verticalLow;
    private JTextField verticalScale;
    private JLabel verticalScaleLabel;

    public WaveformZoom(Frame parent, double lowVert, double highVert, double scaleVert, boolean logVert, double lowHoriz, double highHoriz, WaveformWindow curWindow, Panel curPanel) {
        super(parent, true);
        this.curPanel = curPanel;
        this.curWindow = curWindow;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        EDialog.makeTextFieldSelectAllOnTab(this.verticalLow);
        EDialog.makeTextFieldSelectAllOnTab(this.verticalHigh);
        EDialog.makeTextFieldSelectAllOnTab(this.verticalScale);
        EDialog.makeTextFieldSelectAllOnTab(this.horizontalLow);
        EDialog.makeTextFieldSelectAllOnTab(this.horizontalHigh);
        YScaleListener valueListener = new YScaleListener(false);
        YScaleListener scaleListener = new YScaleListener(true);
        this.trueLowY = lowVert;
        this.trueHighY = highVert;
        this.trueScale = scaleVert;
        if (this.trueScale != 0.0 && !logVert) {
            lowVert /= this.trueScale;
            highVert /= this.trueScale;
        }
        this.verticalLow.setText(Double.toString(lowVert));
        this.verticalHigh.setText(Double.toString(highVert));
        this.verticalScale.setText(Double.toString(this.trueScale));
        this.horizontalLow.setText(Double.toString(lowHoriz));
        this.horizontalHigh.setText(Double.toString(highHoriz));
        if (logVert) {
            this.verticalLogarithmic.setSelected(true);
        } else {
            this.verticalLinear.setSelected(true);
        }
        this.verticalLow.getDocument().addDocumentListener(valueListener);
        this.verticalHigh.getDocument().addDocumentListener(valueListener);
        this.verticalScale.getDocument().addDocumentListener(scaleListener);
        this.finishInitialization();
        this.setVisible(true);
    }

    private void linearLogClicked() {
        double lowVert = this.trueLowY;
        double highVert = this.trueHighY;
        if (this.verticalLinear.isSelected()) {
            this.verticalScaleLabel.setEnabled(true);
            this.verticalScale.setEnabled(true);
            this.setScaleTo2Pi.setEnabled(true);
            if (this.trueScale != 0.0) {
                lowVert /= this.trueScale;
                highVert /= this.trueScale;
            }
        } else {
            this.verticalScaleLabel.setEnabled(false);
            this.verticalScale.setEnabled(false);
            this.setScaleTo2Pi.setEnabled(false);
            this.verticalScale.setText("");
        }
        this.updatingTextFields = true;
        this.verticalLow.setText(Double.toString(lowVert));
        this.verticalHigh.setText(Double.toString(highVert));
        this.verticalScale.setText("" + this.trueScale);
        this.updatingTextFields = false;
    }

    private void setScaleTo2Pi() {
        this.verticalScale.setText("6.283185307179586");
    }

    private void okayClicked() {
        double lowHoriz = TextUtils.atof(this.horizontalLow.getText());
        double highHoriz = TextUtils.atof(this.horizontalHigh.getText());
        boolean logVert = this.verticalLogarithmic.isSelected();
        this.curWindow.setZoomExtents(this.trueLowY, this.trueHighY, this.trueScale, logVert, lowHoriz, highHoriz, this.curPanel);
        this.closeDialog(null);
    }

    @Override
    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.verticalLow = new JTextField();
        this.jLabel2 = new JLabel();
        this.verticalHigh = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.horizontalLow = new JTextField();
        this.horizontalHigh = new JTextField();
        this.verticalScaleLabel = new JLabel();
        this.verticalScale = new JTextField();
        this.setScaleTo2Pi = new JButton();
        this.verticalLogarithmic = new JRadioButton();
        this.verticalLinear = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.setTitle("Set Window Extents");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WaveformZoom.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformZoom.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformZoom.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Low:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.verticalLow.setColumns(15);
        this.verticalLow.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.verticalLow, gridBagConstraints);
        this.jLabel2.setText("High:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.verticalHigh.setColumns(15);
        this.verticalHigh.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.verticalHigh, gridBagConstraints);
        this.jLabel3.setText("Vertical axis");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Horizontal axis (time)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.horizontalLow.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.horizontalLow, gridBagConstraints);
        this.horizontalHigh.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.horizontalHigh, gridBagConstraints);
        this.verticalScaleLabel.setText("Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.verticalScaleLabel, gridBagConstraints);
        this.verticalScale.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.verticalScale, gridBagConstraints);
        this.setScaleTo2Pi.setText("Set to 2 Pi");
        this.setScaleTo2Pi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformZoom.this.setScaleTo2PiActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.setScaleTo2Pi, gridBagConstraints);
        this.buttonGroup1.add(this.verticalLogarithmic);
        this.verticalLogarithmic.setText("Logarithmic");
        this.verticalLogarithmic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformZoom.this.verticalLogarithmicActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.verticalLogarithmic, gridBagConstraints);
        this.buttonGroup1.add(this.verticalLinear);
        this.verticalLinear.setText("Linear");
        this.verticalLinear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformZoom.this.verticalLinearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.verticalLinear, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.okayClicked();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void setScaleTo2PiActionPerformed(ActionEvent evt) {
        this.setScaleTo2Pi();
    }

    private void verticalLogarithmicActionPerformed(ActionEvent evt) {
        this.linearLogClicked();
    }

    private void verticalLinearActionPerformed(ActionEvent evt) {
        this.linearLogClicked();
    }

    class YScaleListener
    implements DocumentListener {
        private boolean scaleField;

        public YScaleListener(boolean sf) {
            this.scaleField = sf;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateYScale();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateYScale();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateYScale();
        }

        protected void updateYScale() {
            if (WaveformZoom.this.updatingTextFields) {
                return;
            }
            if (this.scaleField) {
                WaveformZoom.this.trueScale = TextUtils.atof(WaveformZoom.this.verticalScale.getText());
                if (WaveformZoom.this.trueScale == 0.0) {
                    WaveformZoom.this.trueScale = 1.0;
                }
                if (WaveformZoom.this.verticalLinear.isSelected()) {
                    WaveformZoom.this.updatingTextFields = true;
                    WaveformZoom.this.verticalLow.setText(Double.toString(WaveformZoom.this.trueLowY / WaveformZoom.this.trueScale));
                    WaveformZoom.this.verticalHigh.setText(Double.toString(WaveformZoom.this.trueHighY / WaveformZoom.this.trueScale));
                    WaveformZoom.this.updatingTextFields = false;
                }
            } else {
                double lowValue = TextUtils.atof(WaveformZoom.this.verticalLow.getText());
                double highValue = TextUtils.atof(WaveformZoom.this.verticalHigh.getText());
                if (WaveformZoom.this.trueScale != 0.0 && WaveformZoom.this.verticalLinear.isSelected()) {
                    lowValue *= WaveformZoom.this.trueScale;
                    highValue *= WaveformZoom.this.trueScale;
                }
                WaveformZoom.this.trueLowY = lowValue;
                WaveformZoom.this.trueHighY = highValue;
            }
        }
    }
}

