/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.Environment;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.UserInterfaceExec;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Exec
extends Thread {
    private final String[] exec;
    private final String[] envVars;
    private final File dir;
    private final Environment launcherEnvironment;
    private final UserInterfaceExec userInterface;
    private final OutputStream outStreamRedir;
    private final OutputStream errStreamRedir;
    private PrintWriter processWriter;
    private Process p = null;
    private int exitVal;
    private final ArrayList<FinishedListener> finishedListeners;

    public Exec(String[] exec, String[] envVars, File dir, OutputStream outStreamRedir, OutputStream errStreamRedir) {
        this.exec = exec;
        this.envVars = envVars;
        this.dir = dir;
        this.launcherEnvironment = Environment.getThreadEnvironment();
        this.userInterface = new UserInterfaceExec();
        this.outStreamRedir = outStreamRedir;
        this.errStreamRedir = errStreamRedir;
        this.processWriter = null;
        this.finishedListeners = new ArrayList();
        this.exitVal = -1;
        this.setName(exec[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this) {
            Environment.setThreadEnvironment(this.launcherEnvironment);
            Job.setUserInterface(this.userInterface);
        }
        if (this.outStreamRedir instanceof OutputStreamChecker) {
            ((OutputStreamChecker)this.outStreamRedir).setExec(this);
        }
        if (this.errStreamRedir instanceof OutputStreamChecker) {
            ((OutputStreamChecker)this.errStreamRedir).setExec(this);
        }
        try {
            Runtime rt = Runtime.getRuntime();
            ExecProcessReader outReader = null;
            ExecProcessReader errReader = null;
            Exec exec = this;
            synchronized (exec) {
                try {
                    this.p = rt.exec(this.exec, this.envVars, this.dir);
                }
                catch (IOException e) {
                    System.out.println("Error running " + this.exec[0] + ": " + e.getMessage());
                    return;
                }
                outReader = new ExecProcessReader(this.p.getInputStream(), this.outStreamRedir);
                errReader = new ExecProcessReader(this.p.getErrorStream(), this.errStreamRedir);
                outReader.start();
                errReader.start();
                this.processWriter = new PrintWriter(this.p.getOutputStream());
            }
            this.exitVal = this.p.waitFor();
            if (this.outStreamRedir != null) {
                outReader.join();
            }
            if (this.errStreamRedir != null) {
                errReader.join();
            }
            StringBuffer com = new StringBuffer();
            for (int i = 0; i < this.exec.length; ++i) {
                com.append(this.exec[i] + " ");
            }
            Object object = this.finishedListeners;
            synchronized (object) {
                FinishedEvent e = new FinishedEvent(this, com.toString(), this.dir, this.exitVal);
                ArrayList<FinishedListener> copy = new ArrayList<FinishedListener>();
                for (FinishedListener l : this.finishedListeners) {
                    copy.add(l);
                }
                for (FinishedListener l : copy) {
                    l.processFinished(e);
                }
            }
            object = this;
            synchronized (object) {
                if (this.processWriter != null) {
                    this.processWriter.close();
                    this.processWriter = null;
                }
            }
        }
        catch (Exception e) {
            ActivityLogger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String line) {
        Exec exec = this;
        synchronized (exec) {
            if (this.processWriter == null) {
                System.out.println("Can't write to process: No valid process running.");
                return;
            }
            this.processWriter.println(line);
            this.processWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinishedListener(FinishedListener a) {
        ArrayList<FinishedListener> arrayList = this.finishedListeners;
        synchronized (arrayList) {
            this.finishedListeners.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinishedListener(FinishedListener a) {
        ArrayList<FinishedListener> arrayList = this.finishedListeners;
        synchronized (arrayList) {
            this.finishedListeners.remove(a);
        }
    }

    public synchronized void destroyProcess() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public int getExitVal() {
        return this.exitVal;
    }

    public static class OutputStreamChecker
    extends OutputStream
    implements Serializable {
        private OutputStream ostream;
        private String checkFor;
        private StringBuffer lastLine;
        private char[] buf;
        private int bufOffset;
        private boolean found;
        private boolean regexp;
        private String foundLine;
        private File copyToFile;
        private PrintWriter out;
        private List<OutputStreamCheckerListener> listeners;
        private Exec exec = null;

        public OutputStreamChecker(OutputStream ostream, String checkFor) {
            this(ostream, checkFor, false, null);
        }

        public OutputStreamChecker(OutputStream ostream, String checkFor, boolean regexp, File copyToFile) {
            this.ostream = ostream;
            this.checkFor = checkFor;
            this.regexp = regexp;
            this.lastLine = null;
            this.buf = null;
            this.bufOffset = 0;
            this.lastLine = new StringBuffer();
            if (!regexp) {
                this.buf = new char[checkFor.length()];
            }
            this.found = false;
            this.foundLine = null;
            this.out = null;
            this.copyToFile = copyToFile;
            if (copyToFile != null) {
                try {
                    this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.copyToFile)));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    this.out = null;
                }
            }
            this.listeners = new ArrayList<OutputStreamCheckerListener>();
        }

        @Override
        public void write(int b) throws IOException {
            this.ostream.write(b);
            if (this.out != null) {
                this.out.write(b);
            }
            this.lastLine.append((char)b);
            if (this.regexp) {
                if (b == 10 && this.lastLine.toString().matches(this.checkFor)) {
                    this.found = true;
                    this.foundLine = this.lastLine.toString();
                    this.alertListeners(this.foundLine);
                }
            } else {
                this.buf[this.bufOffset] = (char)b;
                ++this.bufOffset;
                if (this.bufOffset >= this.buf.length) {
                    this.bufOffset = 0;
                }
                boolean matched = true;
                for (int i = 0; i < this.buf.length; ++i) {
                    int y = (i + this.bufOffset) % this.buf.length;
                    if (this.checkFor.charAt(i) == this.buf[y]) continue;
                    matched = false;
                    break;
                }
                if (matched) {
                    this.found = true;
                    this.foundLine = this.lastLine.toString();
                    this.alertListeners(this.foundLine);
                }
            }
            if (b == 10) {
                this.lastLine.delete(0, this.lastLine.length());
            }
        }

        public void addOutputStreamCheckerListener(OutputStreamCheckerListener l) {
            this.listeners.add(l);
        }

        public void removeOutputStreamCheckerListener(OutputStreamCheckerListener l) {
            this.listeners.remove(l);
        }

        private void alertListeners(String matched) {
            for (OutputStreamCheckerListener l : this.listeners) {
                l.matchFound(this.exec, matched);
            }
        }

        public boolean getFound() {
            return this.found;
        }

        public String getFoundLine() {
            return this.foundLine;
        }

        @Override
        public void close() {
            if (this.out != null) {
                this.out.close();
            }
        }

        public File getCopyToFile() {
            return this.copyToFile;
        }

        private void setExec(Exec e) {
            this.exec = e;
        }
    }

    public static class ExecProcessReader
    extends Thread {
        private InputStream in;
        private OutputStream redirect;
        private char[] buf;
        private final UserInterfaceExec userInterface = new UserInterfaceExec();

        public ExecProcessReader(InputStream in) {
            this(in, null);
        }

        public ExecProcessReader(InputStream in, OutputStream redirect) {
            this.in = in;
            this.redirect = redirect;
            this.buf = new char[256];
            this.setName("ExecProcessReader");
        }

        @Override
        public void run() {
            if (Thread.currentThread() == this) {
                Job.setUserInterface(this.userInterface);
            }
            try {
                PrintWriter pw = null;
                if (this.redirect != null) {
                    pw = new PrintWriter(this.redirect);
                }
                InputStreamReader input = new InputStreamReader(this.in);
                BufferedReader reader = new BufferedReader(input);
                int read = 0;
                while ((read = reader.read(this.buf)) >= 0) {
                    if (pw == null) continue;
                    pw.write(this.buf, 0, read);
                    pw.flush();
                }
                reader.close();
                input.close();
            }
            catch (IOException e) {
                ActivityLogger.logException(e);
            }
        }
    }

    public static class FinishedEvent {
        private Object source;
        private String exec;
        private int exitValue;
        private File dir;

        public FinishedEvent(Object source, String exec, File dir, int exitValue) {
            this.source = source;
            this.exec = exec;
            this.exitValue = exitValue;
            this.dir = dir;
        }

        public Object getSource() {
            return this.source;
        }

        public String getExec() {
            return this.exec;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public File getWorkingDir() {
            return this.dir;
        }
    }

    public static interface FinishedListener {
        public void processFinished(FinishedEvent var1);
    }

    public static interface OutputStreamCheckerListener {
        public void matchFound(Exec var1, String var2);
    }
}

