/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.Individual;
import com.sun.electric.tool.placement.genetic2.Reference;
import com.sun.electric.tool.placement.genetic2.metrics.BBMetric;
import com.sun.electric.util.math.Orientation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClassicIndividual
extends Individual<ClassicIndividual> {
    private Block[] blocks;
    private double[] badnessComponents = new double[3];
    private double[] hashes;
    Reference ref;
    double[] netLengths;
    private BBMetric m_bb;
    public ReadWriteLock rwLock;
    double p;

    ClassicIndividual(Reference ref, Random rand) {
        super(ref);
        this.ref = ref;
        this.rwLock = new ReentrantReadWriteLock();
        this.m_bb = new BBMetric(this.nodesToPlace, this.allNetworks);
        this.blocks = new Block[this.nodesToPlace.size()];
        this.hashes = new double[3];
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            this.blocks[i] = new Block();
            this.blocks[i].valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(i));
        }
        this.evaluate();
    }

    @Override
    public void setProgress(double p) {
        this.p = p;
    }

    @Override
    public void reboot(Random rand) {
    }

    @Override
    public void writeToPlacement(List<PlacementFrame.PlacementNode> nodesToPlace) {
        for (int i = 0; i < nodesToPlace.size(); ++i) {
            Block b = this.blocks[i];
            PlacementFrame.PlacementNode n = nodesToPlace.get(i);
            n.setPlacement(b.getX(), b.getY());
            n.setOrientation(b.getOrientation());
        }
    }

    @Override
    public int compareTo(ClassicIndividual other) {
        if (this.getBadness() < other.getBadness()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void copyFrom(ClassicIndividual other) {
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].setPos(other.getBlockAt(i).getX(), other.getBlockAt(i).getY());
            this.blocks[i].setOrientation(other.getBlockAt(i).getOrientation());
        }
        this.setBadness(other.badnessComponents);
    }

    @Override
    public void deriveFrom(ClassicIndividual mom, ClassicIndividual dad, Random rand) {
        if (rand.nextDouble() > 0.5) {
            ClassicIndividual t = mom;
            mom = dad;
            dad = t;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            if (rand.nextDouble() > 0.5) {
                this.blocks[i].setPos(mom.getBlockAt(i).getX(), mom.getBlockAt(i).getY());
                this.blocks[i].setOrientation(mom.getBlockAt(i).getOrientation());
                continue;
            }
            this.blocks[i].setPos(dad.getBlockAt(i).getX(), dad.getBlockAt(i).getY());
            this.blocks[i].setOrientation(dad.getBlockAt(i).getOrientation());
        }
        this.mutate(rand);
        this.evaluate();
    }

    @Override
    public double distance(ClassicIndividual other) {
        double distance = 0.0;
        double[] h = other.getHashes();
        return distance += (this.hashes[0] - h[0]) * (this.hashes[0] - h[0]) + (this.hashes[1] - h[1]) * (this.hashes[1] - h[1]) + (this.hashes[2] - h[2]) * (this.hashes[2] - h[2]);
    }

    public Block getBlockAt(int i) {
        return this.blocks[i];
    }

    public void swapBlocks(int a, int b) {
        double ax = this.blocks[a].getX();
        double ay = this.blocks[a].getY();
        this.blocks[a].setPos(this.blocks[b].getX(), this.blocks[b].getY());
        this.blocks[b].setPos(ax, ay);
    }

    @Override
    public void mutate(Random rand) {
        int i;
        int disturbedPositions = Math.abs((int)(rand.nextGaussian() * 3.0));
        int disturbedOrientations = Math.abs((int)(rand.nextGaussian() * 1.0));
        int swaps = Math.abs((int)(rand.nextGaussian() * 1.0));
        for (i = 0; i < disturbedPositions; ++i) {
            this.blocks[rand.nextInt(this.blocks.length)].disturb(this.ref.avgW, rand);
        }
        for (i = 0; i < disturbedOrientations; ++i) {
            this.blocks[rand.nextInt(this.blocks.length)].disturbOrientation(rand);
        }
        for (i = 0; i < swaps; ++i) {
            int pos1 = rand.nextInt(this.blocks.length);
            int pos2 = rand.nextInt(this.blocks.length);
            this.swapBlocks(pos1, pos2);
        }
    }

    public void mutateAndEvaluate(ClassicIndividual original, Random rand) {
        int pos;
        int i;
        HashSet<Integer> changedBlocks = new HashSet<Integer>();
        int disturbedPositions = Math.abs((int)(rand.nextGaussian() * 3.0));
        int disturbedOrientations = Math.abs((int)(rand.nextGaussian() * 1.0));
        int swaps = Math.abs((int)(rand.nextGaussian() * 1.0));
        for (i = 0; i < disturbedPositions; ++i) {
            pos = rand.nextInt(this.blocks.length);
            this.blocks[rand.nextInt(this.blocks.length)].disturb(this.ref.avgW, rand);
            changedBlocks.add(pos);
        }
        for (i = 0; i < disturbedOrientations; ++i) {
            pos = rand.nextInt(this.blocks.length);
            this.blocks[rand.nextInt(this.blocks.length)].disturbOrientation(rand);
            changedBlocks.add(pos);
        }
        for (i = 0; i < swaps; ++i) {
            int pos1 = rand.nextInt(this.blocks.length);
            int pos2 = rand.nextInt(this.blocks.length);
            this.swapBlocks(pos1, pos2);
            changedBlocks.add(pos1);
            changedBlocks.add(pos2);
        }
        if (changedBlocks.size() == 0) {
            return;
        }
        this.badnessComponents[0] = this.m_bb.compute(this.blocks);
        this.badnessComponents[1] = this.calculateChangedOverlap(original, changedBlocks);
        this.badnessComponents[2] = this.getSemiperimeterLength();
    }

    public double calculateChangedOverlap(ClassicIndividual original, HashSet<Integer> changedBlocks) {
        double overlap = original.badnessComponents[1];
        Block otherOrig = new Block();
        Block orig = new Block();
        Iterator<Integer> it = changedBlocks.iterator();
        for (int n = 0; n < changedBlocks.size(); ++n) {
            Block b = this.blocks[it.next()];
            orig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b.getNr()));
            for (int i = 0; i < n; ++i) {
                Block otherBlock = this.blocks[i];
                otherOrig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(otherBlock.getNr()));
                overlap -= orig.intersectionArea(otherOrig);
                overlap += b.intersectionArea(otherBlock);
            }
        }
        return overlap;
    }

    @Override
    public double calculateOverlap() {
        double overlap = 0.0;
        for (int i = 0; i < this.blocks.length; ++i) {
            for (int j = 0; j < i; ++j) {
                overlap += this.blocks[i].intersectionArea(this.blocks[j]);
            }
        }
        return overlap;
    }

    @Override
    public double getBoundingBoxArea() {
        double left = this.blocks[0].getLeft();
        double top = this.blocks[0].getTop();
        double right = this.blocks[0].getRight();
        double bottom = this.blocks[0].getBottom();
        for (Block b : this.blocks) {
            if (b.getLeft() < left) {
                left = b.getLeft();
            }
            if (b.getTop() > top) {
                top = b.getTop();
            }
            if (b.getRight() > right) {
                right = b.getRight();
            }
            if (!(b.getBottom() < bottom)) continue;
            bottom = b.getBottom();
        }
        return (top - bottom) * (right - left);
    }

    @Override
    public double getSemiperimeterLength() {
        double left = this.blocks[0].getLeft();
        double top = this.blocks[0].getTop();
        double right = this.blocks[0].getRight();
        double bottom = this.blocks[0].getBottom();
        for (Block b : this.blocks) {
            if (b.getLeft() < left) {
                left = b.getLeft();
            }
            if (b.getTop() > top) {
                top = b.getTop();
            }
            if (b.getRight() > right) {
                right = b.getRight();
            }
            if (!(b.getBottom() < bottom)) continue;
            bottom = b.getBottom();
        }
        return top - bottom + (right - left);
    }

    @Override
    public double getNetLength() {
        return this.badnessComponents[0];
    }

    @Override
    public void evaluate() {
        this.badnessComponents[0] = this.m_bb.compute(this.blocks);
        this.badnessComponents[1] = this.calculateOverlap();
        this.badnessComponents[2] = this.getSemiperimeterLength();
    }

    public double sqr(double a) {
        return a * a;
    }

    @Override
    public double getBadness() {
        double badness = 0.0;
        badness += this.badnessComponents[0];
        badness += this.badnessComponents[1] * 0.5;
        return badness += this.badnessComponents[2] * 1.0;
    }

    @Override
    public void setBadness(double[] otherComponents) {
        for (int i = 0; i < this.badnessComponents.length; ++i) {
            this.badnessComponents[i] = otherComponents[i];
        }
    }

    @Override
    public double getXHash() {
        double r = 0.0;
        for (Block b : this.blocks) {
            r += b.getX();
        }
        for (r = Math.abs(r); r > 2.0; r /= 10.0) {
        }
        return (Math.sin(r * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getYHash() {
        double r = 0.0;
        for (Block b : this.blocks) {
            r += b.getY();
        }
        for (r = Math.abs(r); r > 2.0; r /= 10.0) {
        }
        return (Math.sin(r * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getRotHash() {
        double r = 0.0;
        for (Block b : this.blocks) {
            Orientation o = b.getOrientation();
            if (o == Orientation.IDENT) {
                r += 0.1;
                continue;
            }
            if (o == Orientation.R) {
                r += 0.2;
                continue;
            }
            if (o == Orientation.RR) {
                r += 0.3;
                continue;
            }
            if (o == Orientation.RRR) {
                r += 0.4;
                continue;
            }
            if (o == Orientation.X) {
                r += 0.5;
                continue;
            }
            if (o == Orientation.XR) {
                r += 0.6;
                continue;
            }
            if (o == Orientation.XRR) {
                r += 0.7;
                continue;
            }
            if (o == Orientation.XRRR) {
                r += 0.8;
                continue;
            }
            if (o == Orientation.Y) {
                r += 0.9;
                continue;
            }
            if (o == Orientation.YR) {
                r += 1.0;
                continue;
            }
            if (o == Orientation.YRR) {
                r += 1.1;
                continue;
            }
            if (o == Orientation.YRRR) {
                r += 1.2;
                continue;
            }
            if (o == Orientation.XY) {
                r += 1.3;
                continue;
            }
            if (o == Orientation.XYR) {
                r += 1.4;
                continue;
            }
            if (o == Orientation.XYRR) {
                r += 1.5;
                continue;
            }
            if (o != Orientation.XYRRR) continue;
            r += 1.6;
        }
        while (r > 2.0) {
            r /= 10.0;
        }
        return (Math.sin(r * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double[] getHashes() {
        return this.hashes;
    }
}

