/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.Orientation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageInductors
extends EModelessDialog
implements DatabaseChangeListener {
    private static double lastAreaFactor = 1.0;
    private static double lastLengthFactor = 1.0;
    private static double lastSquaresPerCorner = 0.5587;
    private static Map<Cell, CellInductance> allInductanceData = new HashMap<Cell, CellInductance>();
    private CellInductance curInductanceData;
    private NodeInst inductorNode;
    private double computedInductance;
    private boolean noHighlightUpdate = false;
    private boolean noInductListUpdate = false;
    private boolean noInductArcsUpdate = false;
    private static final int PRECISION = 3;
    private JButton addArcToInductor;
    private JButton addInductor;
    private JButton analyzeAndAnnotateAll;
    private JButton analyzeInductor;
    private JButton analyzeInductorNewWidth;
    private JButton annotateInductor;
    private JButton applyNewWidth;
    private JTextField areaFactor;
    private JLabel areaFactorSuggestion;
    private JButton clearComputationArea;
    private JButton deleteInductor;
    private JButton detectArcsOnInductor;
    private JLabel fasthenryDefHeightSubdivs;
    private JLabel fasthenryDefThickness;
    private JLabel fasthenryDefWidthSubdivs;
    private JLabel fasthenryDefZHeight;
    private JTextField fasthenryHeightSubdivs;
    private JTextField fasthenryThickness;
    private JTextField fasthenryWidthSubdivs;
    private JTextField fasthenryZHeight;
    private JTextArea inductorInfo;
    private JPanel inductorListPanel;
    private JScrollPane infoScroll;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTextField lengthFactor;
    private JLabel lengthFactorSuggestion;
    private JList<String> listOfArcsOnInductor;
    private JList<String> listOfInductors;
    private JTextField perCornerFactor;
    private JButton recacheCell;
    private JButton removeArcFromInductor;
    private JButton renameAllInductors;
    private JButton renameInductor;
    private JButton shortenArcs;
    private JCheckBox stayCurrent;
    private JButton updateFasthenryData;
    private JButton useAreaFactor;
    private JButton useLengthFactor;
    private JTextField widthValue;

    public static void showInductorManagementDialog() {
        ManageInductors dialog = new ManageInductors(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private ManageInductors(Frame parent) {
        super(parent);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.areaFactor);
        EDialog.makeTextFieldSelectAllOnTab(this.lengthFactor);
        EDialog.makeTextFieldSelectAllOnTab(this.perCornerFactor);
        this.areaFactor.setText("" + lastAreaFactor);
        this.lengthFactor.setText("" + lastLengthFactor);
        this.perCornerFactor.setText("" + lastSquaresPerCorner);
        this.fasthenryDefWidthSubdivs.setText("default=" + SimulationTool.getFastHenryWidthSubdivisions());
        this.fasthenryDefHeightSubdivs.setText("default=" + SimulationTool.getFastHenryHeightSubdivisions());
        this.fasthenryDefThickness.setText("default=" + TextUtils.formatDistance(SimulationTool.getFastHenryDefThickness()));
        this.fasthenryDefZHeight.setText("");
        UserInterfaceMain.addDatabaseChangeListener(this);
        this.listOfInductors.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManageInductors.this.inductorSelected();
            }
        });
        this.listOfArcsOnInductor.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManageInductors.this.inductorArcSelected();
            }
        });
        this.finishInitialization();
        this.showSelected();
        this.pack();
    }

    @Override
    protected void escapePressed() {
        this.closeDialog(null);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.stayCurrent.isSelected()) {
            return;
        }
        this.updateCurrentCell(false);
    }

    private String updateCurrentCell(boolean brief) {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd == null) {
            return null;
        }
        Cell cell = curWnd.getCell();
        if (cell == null) {
            return null;
        }
        if (this.curInductanceData == null) {
            this.curInductanceData = new CellInductance(cell);
            allInductanceData.put(cell, this.curInductanceData);
        }
        if (this.curInductanceData.cell != cell) {
            return null;
        }
        this.curInductanceData.recalculate();
        this.noInductArcsUpdate = true;
        String[] inductorArray = new String[this.curInductanceData.inductorNames.size()];
        int j = 0;
        for (String str : this.curInductanceData.inductorNames) {
            inductorArray[j++] = str;
        }
        String formerSelection = this.listOfInductors.getSelectedValue();
        this.listOfInductors.setListData((String[])inductorArray);
        if (formerSelection != null && this.curInductanceData.inductorNames.contains(formerSelection)) {
            this.listOfInductors.setSelectedValue(formerSelection, true);
        } else if (this.listOfInductors.getComponentCount() > 0) {
            this.listOfInductors.setSelectedIndex(0);
        }
        this.noInductArcsUpdate = false;
        double defaultAreaFactor = TextUtils.atof(this.areaFactor.getText());
        double defaultLengthFactor = TextUtils.atof(this.lengthFactor.getText());
        HashMap<NodeInst, Double> newValues = new HashMap<NodeInst, Double>();
        NodeInst sellectedInductor = null;
        ArrayList<ArcInst> selectedArcs = null;
        ArrayList<ArcInst> deletedArcs = null;
        double selectedAreaFactor = 0.0;
        double selectedLengthFactor = 0.0;
        StringBuffer changedExplanation = new StringBuffer();
        ArrayList<String> unshortenedInductors = new ArrayList<String>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (np.getFunction() != PrimitiveNode.Function.INDUCT) continue;
            ArrayList<ArcInst> arcsOnInductor = new ArrayList<ArcInst>();
            ArrayList<ArcInst> arcsToDelete = new ArrayList<ArcInst>();
            if (this.getArcsOnInductor(ni, ni.getName(), arcsOnInductor, arcsToDelete)) {
                unshortenedInductors.add(ni.getName());
            }
            StringBuffer sb = new StringBuffer();
            double areaFactor = defaultAreaFactor;
            double lengthFactor = defaultLengthFactor;
            Layer lay = this.getLayerWithFactors(ni);
            if (lay != null) {
                double area = lay.getInductanceAreaFactor();
                double length = lay.getInductanceLengthFactor();
                if (area != 0.0) {
                    areaFactor = area;
                }
                if (length != 0.0) {
                    lengthFactor = length;
                }
            }
            double inductance = this.analyzeInductor(sb, ni, arcsOnInductor, areaFactor, lengthFactor, this.calculateInductorWidth(ni, arcsOnInductor));
            Variable exists = ni.getVar(Schematics.SCHEM_INDUCTANCE);
            if (exists == null) continue;
            Object obj = exists.getObject();
            double val = 0.0;
            if (obj instanceof Double) {
                val = (Double)obj;
            }
            if (obj instanceof String) {
                val = Double.parseDouble((String)obj);
            }
            if (val == inductance) continue;
            sellectedInductor = ni;
            newValues.put(ni, inductance);
            selectedArcs = arcsOnInductor;
            deletedArcs = arcsToDelete;
            selectedAreaFactor = areaFactor;
            selectedLengthFactor = lengthFactor;
            if (brief) {
                changedExplanation.append("Updated " + ni.getName() + " inductance from " + TextUtils.formatDouble(val, 3) + " to " + TextUtils.formatDouble(inductance, 3) + "\n");
                continue;
            }
            changedExplanation.append(sb.toString());
        }
        if (newValues.size() > 0) {
            if (newValues.size() == 1) {
                this.noHighlightUpdate = true;
                this.noInductArcsUpdate = true;
                String inductorName = sellectedInductor.getName();
                this.listOfInductors.setSelectedValue(inductorName, true);
                String[] arcNames = new String[selectedArcs.size()];
                for (int i = 0; i < selectedArcs.size(); ++i) {
                    arcNames[i] = ((ArcInst)selectedArcs.get(i)).getName();
                }
                this.listOfArcsOnInductor.clearSelection();
                this.listOfArcsOnInductor.setListData((String[])arcNames);
                new UpdateInductanceNames((List<ArcInst>)selectedArcs, deletedArcs, inductorName, null).startJob();
                this.noHighlightUpdate = false;
                this.noInductArcsUpdate = false;
                if (selectedAreaFactor == 0.0) {
                    this.areaFactorSuggestion.setText("No suggestion");
                    this.useAreaFactor.setEnabled(false);
                } else {
                    this.areaFactorSuggestion.setText("Suggest: " + selectedAreaFactor);
                    this.useAreaFactor.setEnabled(true);
                }
                if (selectedLengthFactor == 0.0) {
                    this.lengthFactorSuggestion.setText("No suggestion");
                    this.useLengthFactor.setEnabled(false);
                } else {
                    this.lengthFactorSuggestion.setText("Suggest: " + selectedLengthFactor);
                    this.useLengthFactor.setEnabled(true);
                }
            }
            if (!brief) {
                this.inductorInfo.setText(changedExplanation.toString());
                System.out.println("Inductance management: Updating " + newValues.size() + " inductor values");
            }
            new AnnotateCellInductance(newValues).startJob();
        }
        if (brief) {
            Object warning = "";
            if (unshortenedInductors.size() > 0) {
                warning = "Inductors with unshortened arcs:";
                for (String indName : unshortenedInductors) {
                    warning = (String)warning + " " + indName;
                }
                warning = (String)warning + "\n";
            }
            if (changedExplanation.length() == 0) {
                return (String)warning + "Nothing changed in cell " + cell.describe(false);
            }
            return (String)warning + "Changes in cell " + cell.describe(false) + ":\n" + changedExplanation.toString();
        }
        return null;
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    private List<ArcInst> getArcNamesOnInductor(String inductorName) {
        ArrayList<ArcInst> selectedArcs = new ArrayList<ArcInst>();
        Iterator<ArcInst> it = this.curInductanceData.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            Variable var = ai.getVar(Schematics.INDUCTOR_NAME);
            if (var == null || !inductorName.equals(var.getPureValue(-1))) continue;
            selectedArcs.add(ai);
        }
        return selectedArcs;
    }

    private void inductorSelected() {
        Layer lay;
        if (this.curInductanceData == null) {
            return;
        }
        if (this.noInductArcsUpdate) {
            return;
        }
        int index = this.listOfInductors.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String inductorName = this.listOfInductors.getSelectedValue();
        List<ArcInst> selectedArcs = this.getArcNamesOnInductor(inductorName);
        String[] arcNames = new String[selectedArcs.size()];
        for (int i = 0; i < selectedArcs.size(); ++i) {
            arcNames[i] = selectedArcs.get(i).getName();
        }
        this.listOfArcsOnInductor.clearSelection();
        this.listOfArcsOnInductor.setListData((String[])arcNames);
        NodeInst inductorNode = null;
        Iterator<NodeInst> it = this.curInductanceData.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance() || !ni.getName().equals(inductorName)) continue;
            inductorNode = ni;
            break;
        }
        this.curInductanceData.suggestedLengthFactor = 0.0;
        this.curInductanceData.suggestedAreaFactor = 0.0;
        if (inductorNode != null && (lay = this.getLayerWithFactors(inductorNode)) != null) {
            double area = lay.getInductanceAreaFactor();
            double length = lay.getInductanceLengthFactor();
            if (area != 0.0) {
                this.curInductanceData.suggestedAreaFactor = area;
            }
            if (length != 0.0) {
                this.curInductanceData.suggestedLengthFactor = length;
            }
        }
        if (this.curInductanceData.suggestedAreaFactor == 0.0) {
            this.areaFactorSuggestion.setText("No suggestion");
            this.useAreaFactor.setEnabled(false);
        } else {
            this.areaFactorSuggestion.setText("Suggest: " + this.curInductanceData.suggestedAreaFactor);
            this.useAreaFactor.setEnabled(true);
        }
        if (this.curInductanceData.suggestedLengthFactor == 0.0) {
            this.lengthFactorSuggestion.setText("No suggestion");
            this.useLengthFactor.setEnabled(false);
        } else {
            this.lengthFactorSuggestion.setText("Suggest: " + this.curInductanceData.suggestedLengthFactor);
            this.useLengthFactor.setEnabled(true);
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd != null && !this.noHighlightUpdate) {
            this.noInductListUpdate = true;
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            for (ArcInst ai : selectedArcs) {
                highlighter.addElectricObject(ai, this.curInductanceData.cell);
            }
            if (inductorNode != null) {
                highlighter.addElectricObject(inductorNode, this.curInductanceData.cell);
                highlighter.addText(inductorNode, this.curInductanceData.cell, NodeInst.NODE_NAME);
            }
            highlighter.finished();
            this.noInductListUpdate = false;
        }
        double thickness = -1.0;
        double zHeight = -1.0;
        int widthSubdivs = -1;
        int heightSubdivs = -1;
        for (ArcInst ai : selectedArcs) {
            Technology tech = ai.getProto().getTechnology();
            Variable var = ai.getVar(Schematics.INDUCTOR_THICKNESS);
            if (var != null) {
                double t = var.getObject() instanceof Integer ? (double)((Integer)var.getObject()).intValue() / tech.getScale() : TextUtils.atof(var.getPureValue(-1));
                thickness = Math.max(thickness, t);
            }
            if ((var = ai.getVar(Schematics.INDUCTOR_WIDTH_SUBDIVS)) != null) {
                int w = TextUtils.atoi(var.getPureValue(-1));
                widthSubdivs = Math.max(widthSubdivs, w);
            }
            if ((var = ai.getVar(Schematics.INDUCTOR_HEIGHT_SUBDIVS)) == null) continue;
            int h = TextUtils.atoi(var.getPureValue(-1));
            heightSubdivs = Math.max(heightSubdivs, h);
        }
        this.fasthenryThickness.setText(thickness < 0.0 ? "" : TextUtils.formatDistance(thickness));
        this.fasthenryZHeight.setText(zHeight < 0.0 ? "" : TextUtils.formatDistance(zHeight));
        this.fasthenryWidthSubdivs.setText((String)(widthSubdivs < 0 ? "" : "" + widthSubdivs));
        this.fasthenryHeightSubdivs.setText((String)(heightSubdivs < 0 ? "" : "" + heightSubdivs));
        this.fasthenryDefZHeight.setText("");
        if (selectedArcs.size() > 0) {
            ArcInst ai = selectedArcs.get(0);
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer layer = poly.getLayer();
                if (layer == null) continue;
                double zDefault = layer.getDepth();
                this.fasthenryDefZHeight.setText("default=" + TextUtils.formatDistance(zDefault));
                break;
            }
        }
    }

    private Layer getLayerWithFactors(NodeInst ni) {
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        Iterator<Layer> it = np.getLayerIterator();
        while (it.hasNext()) {
            Layer lay = it.next();
            double area = lay.getInductanceAreaFactor();
            double length = lay.getInductanceLengthFactor();
            if (area == 0.0 && length == 0.0) continue;
            return lay;
        }
        return null;
    }

    private void useSuggestedAreaFactor() {
        this.areaFactor.setText("" + this.curInductanceData.suggestedAreaFactor);
    }

    private void useSuggestedLengthFactor() {
        this.lengthFactor.setText("" + this.curInductanceData.suggestedLengthFactor);
    }

    private void addNewInductor() {
        String newName;
        while (true) {
            if ((newName = Job.getUserInterface().askForInput("Inductor Name:", "Create New Inductor", "")) == null) {
                return;
            }
            if ((newName = newName.trim()).length() == 0) {
                return;
            }
            if (!this.curInductanceData.inductorNames.contains(newName)) break;
            Job.getUserInterface().showErrorMessage("There is already an inductor called " + newName, "Duplicate Inductor Name");
        }
        this.curInductanceData.addDefinedInductorName(newName);
        this.showSelected();
    }

    private void renameInductor() {
        String inductorName = this.needSelectedInductor();
        if (inductorName == null) {
            return;
        }
        String newName = Job.getUserInterface().askForInput("New Name for Inductor " + inductorName + ":", "Rename Inductor", "");
        if (newName == null) {
            return;
        }
        if ((newName = newName.trim()).length() == 0) {
            return;
        }
        if (this.curInductanceData.inductorNames.contains(newName)) {
            Job.getUserInterface().showErrorMessage("There is already an inductor called " + newName, "Duplicate Inductor Name");
            return;
        }
        String[] inductorNames = new String[]{inductorName};
        String[] newNames = new String[]{newName};
        new RenameInductor(this.curInductanceData.cell, inductorNames, newNames, this).startJob();
    }

    private void renameAllInductors() {
        String namePattern = Job.getUserInterface().askForInput("New name for inductors (use '*' where numbers will go):", "Rename Inductors", "");
        if (namePattern == null) {
            return;
        }
        if ((namePattern = namePattern.trim()).length() == 0) {
            return;
        }
        int starPos = namePattern.indexOf("*");
        if (starPos < 0) {
            Job.getUserInterface().showErrorMessage("Inductor name pattern must have a '*' where the numbers will go", "Bad Pattern Name");
            return;
        }
        String left = namePattern.substring(0, starPos);
        String right = namePattern.substring(starPos + 1);
        int numInds = this.listOfInductors.getModel().getSize();
        ArrayList<String> oldNameList = new ArrayList<String>();
        ArrayList<CallSite> newNameList = new ArrayList<CallSite>();
        for (int i = 0; i < numInds; ++i) {
            String newName;
            String oldName = this.listOfInductors.getModel().getElementAt(i);
            if (oldName.equals(newName = left + (i + 1) + right)) continue;
            oldNameList.add(oldName);
            newNameList.add((CallSite)((Object)newName));
        }
        String[] oldNames = new String[oldNameList.size()];
        for (int i = 0; i < oldNameList.size(); ++i) {
            oldNames[i] = (String)oldNameList.get(i);
        }
        String[] newNames = new String[newNameList.size()];
        for (int i = 0; i < newNameList.size(); ++i) {
            newNames[i] = (String)newNameList.get(i);
        }
        new RenameInductor(this.curInductanceData.cell, oldNames, newNames, this).startJob();
    }

    private void deleteInductor() {
        String inductorName = this.needSelectedInductor();
        if (inductorName == null) {
            return;
        }
        if (this.curInductanceData.inductorNamesonNodes.contains(inductorName)) {
            Job.getUserInterface().showErrorMessage("This inductor is defined by the node named " + inductorName + ". Delete the inductor node or rename it.", "Cannot Delete Inductor");
            return;
        }
        if (this.curInductanceData.inductorNamesDefined.contains(inductorName)) {
            this.curInductanceData.inductorNamesDefined.remove(inductorName);
            this.showSelected();
            return;
        }
        if (this.curInductanceData.inductorNamesonArcs.contains(inductorName)) {
            ArrayList<ArcInst> disconnectedArcs = new ArrayList<ArcInst>();
            Iterator<ArcInst> it = this.curInductanceData.cell.getArcs();
            while (it.hasNext()) {
                String name;
                ArcInst ai = it.next();
                Variable var = ai.getVar(Schematics.INDUCTOR_NAME);
                if (var == null || !(name = var.getPureValue(-1)).equals(inductorName)) continue;
                disconnectedArcs.add(ai);
            }
            new UpdateInductanceNames(null, disconnectedArcs, null, this).startJob();
            return;
        }
    }

    private void shortenCurrentInductor() {
        String inductorName = this.needSelectedInductor();
        if (inductorName == null) {
            return;
        }
        NodeInst ni = this.curInductanceData.cell.findNode(inductorName);
        if (ni == null) {
            return;
        }
        ArrayList<ArcInst> connectedArcs = new ArrayList<ArcInst>();
        ArrayList<ArcInst> disconnectedArcs = new ArrayList<ArcInst>();
        this.getArcsOnInductor(ni, inductorName, connectedArcs, disconnectedArcs);
        new ShortenArcs(connectedArcs).startJob();
    }

    private void showSelected() {
        this.makeInductanceDataCurrent();
        this.curInductanceData.recalculate();
        this.noHighlightUpdate = true;
        this.listOfArcsOnInductor.clearSelection();
        this.listOfArcsOnInductor.setListData((String[])new String[0]);
        TitledBorder border = (TitledBorder)this.inductorListPanel.getBorder();
        if (this.curInductanceData.cell == null) {
            border.setTitle("NO CURRENT CELL");
            this.listOfInductors.setListData((String[])new String[0]);
        } else {
            border.setTitle("Inductors in Cell " + this.curInductanceData.cell.describe(false));
            String[] inductorArray = new String[this.curInductanceData.inductorNames.size()];
            int i = 0;
            for (String str : this.curInductanceData.inductorNames) {
                inductorArray[i++] = str;
            }
            String formerSelection = this.listOfInductors.getSelectedValue();
            this.listOfInductors.setListData((String[])inductorArray);
            if (formerSelection != null && this.curInductanceData.inductorNames.contains(formerSelection)) {
                this.listOfInductors.setSelectedValue(formerSelection, true);
            } else if (this.listOfInductors.getComponentCount() > 0) {
                this.listOfInductors.setSelectedIndex(0);
            }
        }
        this.inductorListPanel.repaint();
        this.noHighlightUpdate = false;
    }

    private void inductorArcSelected() {
        if (this.curInductanceData == null) {
            return;
        }
        String arcName = this.listOfArcsOnInductor.getSelectedValue();
        if (arcName == null) {
            return;
        }
        ArcInst ai = this.curInductanceData.cell.findArc(arcName);
        if (ai == null) {
            return;
        }
        if (this.noHighlightUpdate) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd != null) {
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            highlighter.addElectricObject(ai, this.curInductanceData.cell);
            highlighter.finished();
        }
    }

    private boolean getArcsOnInductor(NodeInst ni, String inductorName, List<ArcInst> arcsToAdd, List<ArcInst> arcsToDelete) {
        double inductorSize = ni.getYSize();
        ArcProto ap = ni.getProto().getPort(0).getBasePort().getConnection();
        PrimitiveNode pnp = ap.findPinProto();
        Iterator<Connection> cIt = ni.getConnections();
        block0: while (cIt.hasNext()) {
            Connection con = cIt.next();
            ArcInst followArc = con.getArc();
            if (followArc.getLambdaBaseWidth() != inductorSize) continue;
            arcsToAdd.add(followArc);
            NodeInst followNode = ni;
            while (true) {
                NodeInst nextNode;
                NodeInst nodeInst = nextNode = followArc.getHeadPortInst().getNodeInst() == followNode ? followArc.getTailPortInst().getNodeInst() : followArc.getHeadPortInst().getNodeInst();
                if (nextNode.getProto() != pnp) continue block0;
                PortInst pi = nextNode.getOnlyPortInst();
                ArcInst otherArc = null;
                Iterator<Connection> c2It = pi.getConnections();
                while (c2It.hasNext()) {
                    Connection con2 = c2It.next();
                    ArcInst ai2 = con2.getArc();
                    if (ai2 == followArc) continue;
                    if (ai2.getLambdaBaseWidth() != inductorSize) {
                        otherArc = null;
                        break;
                    }
                    if (otherArc != null) {
                        otherArc = null;
                        break;
                    }
                    otherArc = ai2;
                }
                if (otherArc == null) continue block0;
                arcsToAdd.add(otherArc);
                followArc = otherArc;
                followNode = nextNode;
            }
        }
        HashSet<ArcInst> connectedArcSet = new HashSet<ArcInst>();
        for (ArcInst ai : arcsToAdd) {
            connectedArcSet.add(ai);
        }
        boolean unshortened = false;
        Iterator<ArcInst> aIt = this.curInductanceData.cell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            if (connectedArcSet.contains(ai)) {
                if (!ai.isHeadExtended() && !ai.isTailExtended()) continue;
                unshortened = true;
                continue;
            }
            Variable var = ai.getVar(Schematics.INDUCTOR_NAME);
            if (var == null || !var.getPureValue(-1).equals(inductorName)) continue;
            arcsToDelete.add(ai);
        }
        return unshortened;
    }

    private void detectArcsOnInductor() {
        String inductorName = this.needSelectedInductor();
        if (inductorName == null) {
            return;
        }
        if (!this.curInductanceData.inductorNamesonNodes.contains(inductorName)) {
            Job.getUserInterface().showErrorMessage("There is no inductor node named " + inductorName + " so the arcs on it cannot be detected.", "Cannot Detect Inductor");
            return;
        }
        NodeInst ni = this.curInductanceData.cell.findNode(inductorName);
        if (ni == null) {
            return;
        }
        ArrayList<ArcInst> connectedArcs = new ArrayList<ArcInst>();
        ArrayList<ArcInst> disconnectedArcs = new ArrayList<ArcInst>();
        this.getArcsOnInductor(ni, inductorName, connectedArcs, disconnectedArcs);
        new UpdateInductanceNames(connectedArcs, disconnectedArcs, inductorName, this).startJob();
    }

    private void addArcToInductor() {
        String inductorName = this.needSelectedInductor();
        if (inductorName == null) {
            return;
        }
        EditWindow curWnd = EditWindow.needCurrent();
        if (curWnd == null) {
            return;
        }
        List<Geometric> arcs = curWnd.getHighlightedEObjs(false, true);
        if (arcs.size() == 0) {
            Job.getUserInterface().showErrorMessage("Must select arcs first to add them to the inductor", "No Arcs Selected");
            return;
        }
        ArrayList<ArcInst> arcSet = new ArrayList<ArcInst>();
        for (Geometric geom : arcs) {
            arcSet.add((ArcInst)geom);
        }
        new UpdateInductanceNames(arcSet, null, inductorName, this).startJob();
    }

    private void removeArcFromInductor() {
        if (this.curInductanceData == null) {
            return;
        }
        String arcName = this.listOfArcsOnInductor.getSelectedValue();
        if (arcName == null) {
            Job.getUserInterface().showErrorMessage("Must first select an arc name from this list in order to remove it", "No Arc Name Selected");
            return;
        }
        ArcInst ai = this.curInductanceData.cell.findArc(arcName);
        if (ai == null) {
            return;
        }
        ArrayList<ArcInst> arcNameToDelete = new ArrayList<ArcInst>();
        arcNameToDelete.add(ai);
        new UpdateInductanceNames(null, arcNameToDelete, null, this).startJob();
    }

    private void updateFastHenryFactors() {
        String inductorName = this.needSelectedInductor();
        if (inductorName == null) {
            return;
        }
        List<ArcInst> inductorArcs = this.getArcsOnInductor();
        if (inductorArcs.size() == 0) {
            Job.getUserInterface().showErrorMessage("Must first assign arcs to the inductor with either 'Detect' or 'Add'", "No Arcs on Selected Inductor");
            return;
        }
        String thicknessStr = this.fasthenryThickness.getText().trim();
        Double thickness = null;
        if (thicknessStr.length() > 0) {
            thickness = TextUtils.atofDistance(thicknessStr);
        }
        String zHeightStr = this.fasthenryZHeight.getText().trim();
        Double zHeight = null;
        if (zHeightStr.length() > 0) {
            zHeight = TextUtils.atofDistance(zHeightStr);
        }
        String widthSubdivsStr = this.fasthenryWidthSubdivs.getText().trim();
        Integer widthSubdivs = null;
        if (widthSubdivsStr.length() > 0) {
            widthSubdivs = TextUtils.atoi(widthSubdivsStr);
        }
        String heightSubdivsStr = this.fasthenryHeightSubdivs.getText().trim();
        Integer heightSubdivs = null;
        if (heightSubdivsStr.length() > 0) {
            heightSubdivs = TextUtils.atoi(heightSubdivsStr);
        }
        new StoreFastHenryFactors(inductorArcs, thickness, zHeight, widthSubdivs, heightSubdivs).startJob();
    }

    private void applyInductorWidth() {
        List<ArcInst> inductorArcs = this.getArcsOnInductor();
        double inductorWidth = TextUtils.atof(this.widthValue.getText());
        new ApplyInductorWidth(this.inductorNode, inductorArcs, inductorWidth).startJob();
    }

    private void analyzeInductors(boolean useOverride) {
        lastAreaFactor = TextUtils.atof(this.areaFactor.getText());
        lastLengthFactor = TextUtils.atof(this.lengthFactor.getText());
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        String inductorName = this.needSelectedInductor();
        if (inductorName == null) {
            return;
        }
        List<ArcInst> inductorArcs = this.getArcsOnInductor();
        this.inductorNode = null;
        if (this.curInductanceData.inductorNamesonNodes.contains(inductorName)) {
            this.inductorNode = this.curInductanceData.cell.findNode(inductorName);
        }
        double inductorWidth = useOverride ? TextUtils.atof(this.widthValue.getText()) : this.calculateInductorWidth(this.inductorNode, inductorArcs);
        StringBuffer sb = new StringBuffer();
        this.computedInductance = this.analyzeInductor(sb, this.inductorNode, inductorArcs, lastAreaFactor, lastLengthFactor, inductorWidth);
        this.inductorInfo.setText(sb.toString());
    }

    double calculateInductorWidth(NodeInst iNode, List<ArcInst> inductorArcs) {
        double inductorWidth = 0.0;
        if (iNode != null) {
            double wid = iNode.getXSize();
            double hei = iNode.getYSize();
            inductorWidth = Math.min(wid, hei);
        } else if (inductorArcs != null && inductorArcs.size() > 0) {
            inductorWidth = Double.MAX_VALUE;
            for (ArcInst ai : inductorArcs) {
                double wid = ai.getLambdaBaseWidth();
                if (!(wid < inductorWidth)) continue;
                inductorWidth = wid;
            }
        }
        if (inductorWidth == 0.0) {
            inductorWidth = 1.0;
        }
        this.widthValue.setText(TextUtils.formatDouble(inductorWidth));
        return inductorWidth;
    }

    private void analyzeAndAnnotateAllInductors() {
        String news = this.updateCurrentCell(true);
        if (news == null) {
            return;
        }
        this.inductorInfo.setText(news);
    }

    double analyzeInductor(StringBuffer explanation, NodeInst inductorNode, List<ArcInst> inductorArcs, double areaFactor, double lengthFactor, double inductorWidth) {
        lastSquaresPerCorner = TextUtils.atof(this.perCornerFactor.getText());
        int cornerCount = 0;
        if (inductorArcs != null) {
            for (int i = 1; i < inductorArcs.size(); ++i) {
                ArcInst ai1 = inductorArcs.get(i);
                NodeInst ni1a = ai1.getHeadPortInst().getNodeInst();
                NodeInst ni1b = ai1.getTailPortInst().getNodeInst();
                for (int j = 0; j < i; ++j) {
                    int angle2;
                    int angle1;
                    ArcInst ai2 = inductorArcs.get(j);
                    NodeInst ni2a = ai2.getHeadPortInst().getNodeInst();
                    NodeInst ni2b = ai2.getTailPortInst().getNodeInst();
                    if (ni2a != ni1a && ni2a != ni1b && ni2b != ni1a && ni2b != ni1b || Math.abs((angle1 = ai1.getAngle() % 1800) - (angle2 = ai2.getAngle() % 1800)) != 900) continue;
                    ++cornerCount;
                }
            }
        }
        explanation.append("======= COMPUTATION OF INDUCTOR" + (String)(inductorNode != null ? ": " + inductorNode.describe(false) : "") + " =======\n");
        explanation.append("Area component:\n");
        double edgeLength = 0.0;
        if (inductorNode != null) {
            edgeLength = Math.max(inductorNode.getXSize(), inductorNode.getYSize());
            explanation.append("  Node " + inductorNode.describe(false) + " edge-length=" + TextUtils.formatDouble(edgeLength, 3) + "\n");
        }
        if (inductorArcs != null) {
            for (ArcInst ai : inductorArcs) {
                double arcEdge = ai.getHeadLocation().distance(ai.getTailLocation());
                edgeLength += arcEdge;
                explanation.append("  Arc " + ai.describe(false) + " edge-length=" + TextUtils.formatDouble(arcEdge, 3) + "\n");
            }
        }
        explanation.append("    Total Edge-length = " + TextUtils.formatDouble(edgeLength, 3) + "\n");
        double squareCount = edgeLength / inductorWidth;
        explanation.append("    Square-count = Edge-length (" + TextUtils.formatDouble(edgeLength, 3) + ") / Inductor width (" + TextUtils.formatDouble(inductorWidth, 3) + ") = " + TextUtils.formatDouble(squareCount, 3) + "\n");
        double cornerComponent = (double)cornerCount * lastSquaresPerCorner;
        explanation.append("    Corner-squares = Corner-count (" + cornerCount + ") x Squares-per-Corner (" + TextUtils.formatDouble(lastSquaresPerCorner, 6) + ") = " + TextUtils.formatDouble(cornerComponent, 3) + "\n");
        double totalSquareComponent = squareCount + cornerComponent;
        explanation.append("    Total-squares = Square-count (" + squareCount + ") + Corner-squares (" + TextUtils.formatDouble(cornerComponent, 3) + ") = " + TextUtils.formatDouble(totalSquareComponent, 3) + "\n");
        double areaComponent = totalSquareComponent * areaFactor;
        explanation.append("    Final Area-component = Total-squares (" + TextUtils.formatDouble(totalSquareComponent, 3) + ") * Area-factor (" + TextUtils.formatDouble(areaFactor, 3) + ") = " + TextUtils.formatDouble(areaComponent, 3) + "\n");
        explanation.append("Length component:\n");
        double lengthComponent = edgeLength * lengthFactor;
        explanation.append("  Edge-length (" + TextUtils.formatDouble(edgeLength, 3) + ") x Length-factor (" + TextUtils.formatDouble(lengthFactor, 3) + ") = " + TextUtils.formatDouble(lengthComponent, 3) + " (in Electric units)\n");
        explanation.append("Computed inductance:\n");
        double denom = lengthComponent + areaComponent;
        double inductance = 0.0;
        if (denom != 0.0) {
            inductance = lengthComponent * areaComponent / denom;
        }
        explanation.append("  (Area-component x length) / (Area-component + length) = " + TextUtils.formatDouble(inductance, 3) + "\n");
        return inductance;
    }

    private void assignValue() {
        HashMap<NodeInst, Double> newValues = new HashMap<NodeInst, Double>();
        newValues.put(this.inductorNode, this.computedInductance);
        new AnnotateCellInductance(newValues).startJob();
    }

    private void makeInductanceDataCurrent() {
        if (this.noInductListUpdate) {
            return;
        }
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd == null) {
            return;
        }
        Cell cell = curWnd.getCell();
        this.curInductanceData = allInductanceData.get(cell);
        if (this.curInductanceData == null) {
            this.curInductanceData = new CellInductance(cell);
            allInductanceData.put(cell, this.curInductanceData);
        }
        this.areaFactorSuggestion.setText("No suggestion");
        this.useAreaFactor.setEnabled(false);
        this.lengthFactorSuggestion.setText("No suggestion");
        this.useLengthFactor.setEnabled(false);
        Highlighter highlighter = curWnd.getHighlighter();
        List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
        for (Geometric g : highlighted) {
            ArcInst ai;
            Variable var;
            String iName = null;
            String aName = null;
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (ni.getFunction() != PrimitiveNode.Function.INDUCT) continue;
                iName = ni.getName();
            } else if (g instanceof ArcInst && (var = (ai = (ArcInst)g).getVar(Schematics.INDUCTOR_NAME)) != null) {
                iName = var.getPureValue(-1);
                aName = ai.getName();
            }
            if (iName == null || !this.curInductanceData.inductorNames.contains(iName)) continue;
            this.noHighlightUpdate = true;
            this.listOfInductors.setSelectedValue(iName, true);
            this.listOfArcsOnInductor.setSelectedValue(aName, true);
            this.noHighlightUpdate = false;
            break;
        }
    }

    private String needSelectedInductor() {
        String inductorName = this.listOfInductors.getSelectedValue();
        if (inductorName == null) {
            Job.getUserInterface().showErrorMessage("Must create an inductor in the top list first", "No Inductor Selected");
            return null;
        }
        return inductorName;
    }

    private List<ArcInst> getArcsOnInductor() {
        ArrayList<ArcInst> inductorArcs = new ArrayList<ArcInst>();
        for (int i = 0; i < this.listOfArcsOnInductor.getModel().getSize(); ++i) {
            String item = this.listOfArcsOnInductor.getModel().getElementAt(i);
            ArcInst ai = this.curInductanceData.cell.findArc(item);
            inductorArcs.add(ai);
        }
        return inductorArcs;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.analyzeInductor = new JButton();
        this.annotateInductor = new JButton();
        this.infoScroll = new JScrollPane();
        this.inductorInfo = new JTextArea();
        this.jLabel6 = new JLabel();
        this.areaFactor = new JTextField();
        this.jLabel1 = new JLabel();
        this.lengthFactor = new JTextField();
        this.jLabel2 = new JLabel();
        this.perCornerFactor = new JTextField();
        this.areaFactorSuggestion = new JLabel();
        this.useAreaFactor = new JButton();
        this.lengthFactorSuggestion = new JLabel();
        this.useLengthFactor = new JButton();
        this.clearComputationArea = new JButton();
        this.jLabel8 = new JLabel();
        this.analyzeInductorNewWidth = new JButton();
        this.widthValue = new JTextField();
        this.applyNewWidth = new JButton();
        this.inductorListPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.listOfInductors = new JList();
        this.addInductor = new JButton();
        this.deleteInductor = new JButton();
        this.renameInductor = new JButton();
        this.jPanel4 = new JPanel();
        this.recacheCell = new JButton();
        this.stayCurrent = new JCheckBox();
        this.analyzeAndAnnotateAll = new JButton();
        this.renameAllInductors = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listOfArcsOnInductor = new JList();
        this.addArcToInductor = new JButton();
        this.removeArcFromInductor = new JButton();
        this.detectArcsOnInductor = new JButton();
        this.shortenArcs = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.fasthenryZHeight = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.fasthenryWidthSubdivs = new JTextField();
        this.fasthenryHeightSubdivs = new JTextField();
        this.fasthenryDefThickness = new JLabel();
        this.fasthenryDefZHeight = new JLabel();
        this.fasthenryDefWidthSubdivs = new JLabel();
        this.fasthenryDefHeightSubdivs = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.fasthenryThickness = new JTextField();
        this.updateFasthenryData = new JButton();
        this.setTitle("Manage Inductors");
        this.setMinimumSize(new Dimension(353, 150));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ManageInductors.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inductance Computation"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.analyzeInductor.setText("Analyze");
        this.analyzeInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.analyzeInductorActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.analyzeInductor, gridBagConstraints);
        this.analyzeInductor.getAccessibleContext().setAccessibleDescription("");
        this.annotateInductor.setText("Annotate");
        this.annotateInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.annotateInductorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.annotateInductor, gridBagConstraints);
        this.infoScroll.setMinimumSize(new Dimension(500, 300));
        this.infoScroll.setPreferredSize(new Dimension(500, 300));
        this.infoScroll.setViewportView(this.inductorInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.infoScroll, gridBagConstraints);
        this.jLabel6.setText("Area factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.3;
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.areaFactor.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.areaFactor, gridBagConstraints);
        this.jLabel1.setText("Length factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.3;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.lengthFactor.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.lengthFactor, gridBagConstraints);
        this.jLabel2.setText("Squares per Corner:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.3;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.perCornerFactor.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.perCornerFactor, gridBagConstraints);
        this.areaFactorSuggestion.setText("No Default Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.areaFactorSuggestion, gridBagConstraints);
        this.useAreaFactor.setText("Use");
        this.useAreaFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.useAreaFactorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.useAreaFactor, gridBagConstraints);
        this.lengthFactorSuggestion.setText("No Default Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.lengthFactorSuggestion, gridBagConstraints);
        this.useLengthFactor.setText("Use");
        this.useLengthFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.useLengthFactorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.useLengthFactor, gridBagConstraints);
        this.clearComputationArea.setText("Clear");
        this.clearComputationArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.clearComputationAreaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.clearComputationArea, gridBagConstraints);
        this.jLabel8.setText("Inductor width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.analyzeInductorNewWidth.setText("Analyze with new Width");
        this.analyzeInductorNewWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.analyzeInductorNewWidthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.analyzeInductorNewWidth, gridBagConstraints);
        this.widthValue.setColumns(5);
        this.widthValue.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.widthValue, gridBagConstraints);
        this.applyNewWidth.setText("Apply new Width");
        this.applyNewWidth.setToolTipText("");
        this.applyNewWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.applyNewWidthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.applyNewWidth, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.inductorListPanel.setBorder(BorderFactory.createTitledBorder("Inductors in Cell"));
        this.inductorListPanel.setLayout(new GridBagLayout());
        this.listOfInductors.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.listOfInductors);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.inductorListPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.addInductor.setText("New...");
        this.addInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.addInductorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.inductorListPanel.add((Component)this.addInductor, gridBagConstraints);
        this.deleteInductor.setText("Delete");
        this.deleteInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.deleteInductorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.inductorListPanel.add((Component)this.deleteInductor, gridBagConstraints);
        this.renameInductor.setText("Rename...");
        this.renameInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.renameInductorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.inductorListPanel.add((Component)this.renameInductor, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.recacheCell.setText("Recache Current Cell");
        this.recacheCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.recacheCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 10);
        this.jPanel4.add((Component)this.recacheCell, gridBagConstraints);
        this.stayCurrent.setText("Update All Inductors in Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel4.add((Component)this.stayCurrent, gridBagConstraints);
        this.analyzeAndAnnotateAll.setText("Analyze & Annotate All");
        this.analyzeAndAnnotateAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.analyzeAndAnnotateAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel4.add((Component)this.analyzeAndAnnotateAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.inductorListPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.renameAllInductors.setText("Rename All...");
        this.renameAllInductors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.renameAllInductorsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.inductorListPanel.add((Component)this.renameAllInductors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.inductorListPanel, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Arcs in Selected Inductor"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.listOfArcsOnInductor.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.listOfArcsOnInductor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addArcToInductor.setText("Add");
        this.addArcToInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.addArcToInductorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.addArcToInductor, gridBagConstraints);
        this.removeArcFromInductor.setText("Remove");
        this.removeArcFromInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.removeArcFromInductorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.removeArcFromInductor, gridBagConstraints);
        this.detectArcsOnInductor.setText("Detect");
        this.detectArcsOnInductor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.detectArcsOnInductorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.detectArcsOnInductor, gridBagConstraints);
        this.shortenArcs.setText("Shorten");
        this.shortenArcs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.shortenArcsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.shortenArcs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("FastHenry Factors"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel3.setText("Thickness:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Z Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.fasthenryZHeight.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.fasthenryZHeight, gridBagConstraints);
        this.jLabel5.setText("Width subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel7.setText("Height subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.fasthenryWidthSubdivs.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.fasthenryWidthSubdivs, gridBagConstraints);
        this.fasthenryHeightSubdivs.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.fasthenryHeightSubdivs, gridBagConstraints);
        this.fasthenryDefThickness.setText("default=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.fasthenryDefThickness, gridBagConstraints);
        this.fasthenryDefZHeight.setText("default=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.fasthenryDefZHeight, gridBagConstraints);
        this.fasthenryDefWidthSubdivs.setText("default=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.fasthenryDefWidthSubdivs, gridBagConstraints);
        this.fasthenryDefHeightSubdivs.setText("default=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.fasthenryDefHeightSubdivs, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.fasthenryThickness.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.fasthenryThickness, gridBagConstraints);
        this.updateFasthenryData.setText("Update FastHenry Factors");
        this.updateFasthenryData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageInductors.this.updateFasthenryDataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.updateFasthenryData, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void analyzeInductorActionPerformed(ActionEvent evt) {
        this.analyzeInductors(false);
    }

    private void annotateInductorActionPerformed(ActionEvent evt) {
        this.assignValue();
    }

    private void deleteInductorActionPerformed(ActionEvent evt) {
        this.deleteInductor();
    }

    private void addInductorActionPerformed(ActionEvent evt) {
        this.addNewInductor();
    }

    private void addArcToInductorActionPerformed(ActionEvent evt) {
        this.addArcToInductor();
    }

    private void removeArcFromInductorActionPerformed(ActionEvent evt) {
        this.removeArcFromInductor();
    }

    private void detectArcsOnInductorActionPerformed(ActionEvent evt) {
        this.detectArcsOnInductor();
    }

    private void updateFasthenryDataActionPerformed(ActionEvent evt) {
        this.updateFastHenryFactors();
    }

    private void renameInductorActionPerformed(ActionEvent evt) {
        this.renameInductor();
    }

    private void recacheCellActionPerformed(ActionEvent evt) {
        this.showSelected();
    }

    private void useAreaFactorActionPerformed(ActionEvent evt) {
        this.useSuggestedAreaFactor();
    }

    private void useLengthFactorActionPerformed(ActionEvent evt) {
        this.useSuggestedLengthFactor();
    }

    private void clearComputationAreaActionPerformed(ActionEvent evt) {
        this.inductorInfo.setText("");
    }

    private void analyzeInductorNewWidthActionPerformed(ActionEvent evt) {
        this.analyzeInductors(true);
    }

    private void applyNewWidthActionPerformed(ActionEvent evt) {
        this.applyInductorWidth();
    }

    private void analyzeAndAnnotateAllActionPerformed(ActionEvent evt) {
        this.analyzeAndAnnotateAllInductors();
    }

    private void renameAllInductorsActionPerformed(ActionEvent evt) {
        this.renameAllInductors();
    }

    private void shortenArcsActionPerformed(ActionEvent evt) {
        this.shortenCurrentInductor();
    }

    private static class CellInductance {
        private Cell cell;
        private Set<String> inductorNamesonNodes;
        private Set<String> inductorNamesonArcs;
        private Set<String> inductorNamesDefined;
        private Set<String> inductorNames;
        private double suggestedAreaFactor;
        private double suggestedLengthFactor;

        public CellInductance(Cell c) {
            this.cell = c;
            this.inductorNamesonNodes = new HashSet<String>();
            this.inductorNamesonArcs = new HashSet<String>();
            this.inductorNamesDefined = new HashSet<String>();
            this.inductorNames = new TreeSet<String>();
        }

        public void recalculate() {
            this.inductorNamesonArcs.clear();
            this.inductorNamesonNodes.clear();
            this.inductorNames.clear();
            if (this.cell == null) {
                return;
            }
            Iterator<Geometric> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Variable var = ai.getVar(Schematics.INDUCTOR_NAME);
                if (var == null) continue;
                this.inductorNamesonArcs.add(var.getPureValue(-1));
                this.inductorNames.add(var.getPureValue(-1));
            }
            it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                NodeProto np = ni.getProto();
                if (np.getFunction() != PrimitiveNode.Function.INDUCT) continue;
                this.inductorNamesonNodes.add(ni.getName());
                this.inductorNames.add(ni.getName());
            }
            ArrayList<String> removeDefinedNames = new ArrayList<String>();
            for (String definedName : this.inductorNamesDefined) {
                if (this.inductorNames.contains(definedName)) {
                    removeDefinedNames.add(definedName);
                    continue;
                }
                this.inductorNames.add(definedName);
            }
            for (String definedName : removeDefinedNames) {
                this.inductorNamesDefined.remove(definedName);
            }
        }

        public void addDefinedInductorName(String name) {
            this.inductorNamesDefined.add(name);
            this.inductorNames.add(name);
        }
    }

    public static class UpdateInductanceNames
    extends Job {
        private List<ArcInst> connectedArcs;
        private List<ArcInst> disconnectedArcs;
        private String nodeName;
        private transient ManageInductors dialog;

        public UpdateInductanceNames(List<ArcInst> arcsPlus, List<ArcInst> arcsMinus, String name, ManageInductors mi) {
            super("Update Inductor Names", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.connectedArcs = arcsPlus;
            this.disconnectedArcs = arcsMinus;
            this.nodeName = name;
            this.dialog = mi;
        }

        @Override
        public boolean doIt() throws JobException {
            TextDescriptor td = this.getEditingPreferences().getNodeTextDescriptor().withOff(0.0, 2.0).withDisplay(AbstractTextDescriptor.Display.SHOWN).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            if (this.connectedArcs != null) {
                for (ArcInst ai : this.connectedArcs) {
                    ai.newVar(Schematics.INDUCTOR_NAME, (Object)this.nodeName, td);
                }
            }
            if (this.disconnectedArcs != null) {
                for (ArcInst ai : this.disconnectedArcs) {
                    ai.delVar(Schematics.INDUCTOR_NAME);
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.dialog != null) {
                this.dialog.inductorSelected();
            }
        }
    }

    public static class AnnotateCellInductance
    extends Job {
        private Map<NodeInst, Double> newValues;

        public AnnotateCellInductance(Map<NodeInst, Double> nv) {
            super("Analyze Cell Inductors", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newValues = nv;
        }

        @Override
        public boolean doIt() throws JobException {
            for (NodeInst ni : this.newValues.keySet()) {
                Double ind = this.newValues.get(ni);
                Variable exists = ni.getVar(Schematics.SCHEM_INDUCTANCE);
                if (exists != null) {
                    ni.newVar(Schematics.SCHEM_INDUCTANCE, (Object)ind, exists.getTextDescriptor());
                    continue;
                }
                ni.newDisplayVar(Schematics.SCHEM_INDUCTANCE, ind, this.getEditingPreferences());
            }
            return true;
        }
    }

    public static class RenameInductor
    extends Job {
        private String[] oldNames;
        private String[] newNames;
        private Cell cell;
        private transient ManageInductors dialog;

        public RenameInductor(Cell c, String[] oNames, String[] nNames, ManageInductors mi) {
            super("Rename Inductor", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = c;
            this.oldNames = oNames;
            this.newNames = nNames;
            this.dialog = mi;
        }

        @Override
        public boolean doIt() throws JobException {
            for (int i = 0; i < this.oldNames.length; ++i) {
                Iterator<NodeInst> nIt = this.cell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = nIt.next();
                    if (!ni.getName().equals(this.oldNames[i])) continue;
                    ni.setName(this.newNames[i]);
                }
                Iterator<ArcInst> aIt = this.cell.getArcs();
                while (aIt.hasNext()) {
                    String iName;
                    ArcInst ai = aIt.next();
                    Variable var = ai.getVar(Schematics.INDUCTOR_NAME);
                    if (var == null || !(iName = var.getPureValue(-1)).equals(this.oldNames[i])) continue;
                    ai.newVar(Schematics.INDUCTOR_NAME, (Object)this.newNames[i], var.getTextDescriptor());
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            for (int i = 0; i < this.oldNames.length; ++i) {
                this.dialog.listOfInductors.setSelectedValue(this.newNames[i], true);
                this.dialog.curInductanceData.inductorNames.remove(this.oldNames[i]);
                this.dialog.curInductanceData.inductorNames.add(this.newNames[i]);
            }
            this.dialog.showSelected();
        }
    }

    public static class ShortenArcs
    extends Job {
        private List<ArcInst> connectedArcs;

        public ShortenArcs(List<ArcInst> arcs) {
            super("Shorten Arcs", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.connectedArcs = arcs;
        }

        @Override
        public boolean doIt() throws JobException {
            for (ArcInst ai : this.connectedArcs) {
                ai.setHeadExtended(false);
                ai.setTailExtended(false);
            }
            return true;
        }
    }

    public static class StoreFastHenryFactors
    extends Job {
        private List<ArcInst> inductorArcs;
        private Double thickness;
        private Double zHeight;
        private Integer widthSubdivs;
        private Integer heightSubdivs;

        public StoreFastHenryFactors(List<ArcInst> arcs, Double th, Double zh, Integer ws, Integer hs) {
            super("Analyze Cell Inductors", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.inductorArcs = arcs;
            this.thickness = th;
            this.zHeight = zh;
            this.widthSubdivs = ws;
            this.heightSubdivs = hs;
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            for (ArcInst ai : this.inductorArcs) {
                if (this.thickness != null) {
                    ai.newVar(Schematics.INDUCTOR_THICKNESS, (Object)this.thickness, ep);
                }
                if (this.zHeight != null) {
                    ai.newVar(Schematics.INDUCTOR_Z, (Object)this.zHeight, ep);
                }
                if (this.widthSubdivs != null) {
                    ai.newVar(Schematics.INDUCTOR_WIDTH_SUBDIVS, (Object)this.widthSubdivs, ep);
                }
                if (this.heightSubdivs == null) continue;
                ai.newVar(Schematics.INDUCTOR_HEIGHT_SUBDIVS, (Object)this.heightSubdivs, ep);
            }
            return true;
        }
    }

    public static class ApplyInductorWidth
    extends Job {
        private NodeInst inductorNode;
        private List<ArcInst> inductorArcs;
        private double newWidth;

        public ApplyInductorWidth(NodeInst in, List<ArcInst> ia, double nw) {
            super("Change Inductor Width", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.inductorNode = in;
            this.inductorArcs = ia;
            this.newWidth = nw;
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.inductorNode != null) {
                double ySize = this.inductorNode.getYSize();
                this.inductorNode.modifyInstance(0.0, 0.0, 0.0, this.newWidth - ySize, Orientation.IDENT);
            }
            for (ArcInst ai : this.inductorArcs) {
                ai.setLambdaBaseWidth(this.newWidth);
            }
            return true;
        }
    }
}

