/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.project.DisplayedCells;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.project.Users;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdateJob
extends Job {
    private ProjectDB pdb;
    private DisplayedCells displayedCells;
    private Map<CellId, Cell> newCells = new HashMap<CellId, Cell>();

    public static void updateProject() {
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        new UpdateJob();
    }

    private UpdateJob() {
        super("Update all Cells from Repository", Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.pdb = Project.projectDB;
        this.displayedCells = new DisplayedCells();
        this.startJob();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean doIt() throws JobException {
        void var4_10;
        HashSet<ProjectLibrary> projectLibs = new HashSet<ProjectLibrary>();
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            ProjectLibrary projectLibrary;
            Library lib = lIt.next();
            if (lib.isHidden() || (projectLibrary = this.pdb.findProjectLibrary(lib)).getProjectDirectory() == null) continue;
            projectLibs.add(projectLibrary);
        }
        ProjectLibrary.lockManyProjectFiles(projectLibs);
        ArrayList<ProjectCell> updatedProjectCells = new ArrayList<ProjectCell>();
        for (ProjectLibrary projectLibrary : projectLibs) {
            this.addNewProjectCells(projectLibrary, updatedProjectCells);
        }
        boolean allLocked = true;
        for (ProjectCell pc : updatedProjectCells) {
            ProjectLibrary pl = pc.getProjectLibrary();
            if (projectLibs.contains(pl)) continue;
            try {
                pl.lockProjectFile();
            }
            catch (JobException e) {
                allLocked = false;
                break;
            }
            projectLibs.add(pl);
        }
        boolean bl = false;
        if (allLocked) {
            Iterator it;
            Project.setChangeStatus(true);
            while ((it = updatedProjectCells.iterator()).hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                var4_10 += this.updateCellFromRepository(this.pdb, pc, updatedProjectCells);
            }
            Project.setChangeStatus(false);
        }
        for (ProjectLibrary pl : projectLibs) {
            pl.releaseProjectFileLock(false);
            this.validateLocks(this.pdb, pl.getLibrary());
        }
        if (var4_10 == false) {
            System.out.println("Project is up-to-date");
        } else {
            System.out.println("Updated " + (int)var4_10 + " cells");
        }
        this.fieldVariableChanged("pdb");
        this.fieldVariableChanged("displayedCells");
        return true;
    }

    @Override
    public void terminateOK() {
        CellChangeJobs.copyExpandedStatus(this.newCells);
        Project.projectDB = this.pdb;
        this.displayedCells.updateWindows();
        WindowFrame.wantToRedoLibraryTree();
    }

    private void validateLocks(ProjectDB pdb, Library lib) {
        EditingPreferences ep = this.getEditingPreferences();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            ProjectCell pc = pdb.findProjectCell(cell);
            if (pc == null) {
                Project.markLocked(cell, false, ep);
                continue;
            }
            if (cell.getVersion() < pc.getVersion()) {
                Project.markLocked(cell, false, ep);
                continue;
            }
            if (pc.getOwner().equals(Project.getCurrentUserName())) {
                Project.markLocked(cell, false, ep);
                continue;
            }
            Project.markLocked(cell, true, ep);
        }
    }

    private int updateCellFromRepository(ProjectDB pdb, ProjectCell pc, List<ProjectCell> updatedProjectCells) {
        EditingPreferences ep = this.getEditingPreferences();
        ProjectLibrary pl = pc.getProjectLibrary();
        Library lib = pl.getLibrary();
        Cell oldCell = lib.findNodeProto(pc.describe());
        Cell newCell = null;
        int total = 0;
        String libName = pl.getProjectDirectory() + File.separator + pc.getCellName() + File.separator + pc.getVersion() + "-" + pc.getView().getFullName() + "." + pc.getLibExtension();
        String tempLibName = Project.getTempLibraryName();
        NetworkTool.setInformationOutput(false);
        Library fLib = LibraryFiles.readLibrary(ep, TextUtils.makeURLToFile(libName), tempLibName, pc.getLibType(), true);
        NetworkTool.setInformationOutput(true);
        if (fLib == null) {
            System.out.println("Cannot read library " + libName);
        } else {
            String cellNameInRepository = pc.describe();
            Cell cur = fLib.findNodeProto(cellNameInRepository);
            if (cur == null) {
                System.out.println("Cannot find cell " + cellNameInRepository + " in library " + libName);
            } else {
                HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
                Iterator<NodeInst> it = cur.getNodes();
                while (it.hasNext()) {
                    ProjectLibrary subPL;
                    ProjectCell subCellPC;
                    Cell foundSubCell;
                    Cell subCell;
                    NodeInst ni = it.next();
                    NodeProto np = ni.getProto();
                    nodePrototypes.put(ni, np);
                    if (!ni.isCellInstance() || (subCell = (Cell)np).getView().isTextView()) continue;
                    Library subLib = lib;
                    String subCellName = Project.describeFullCellName(subCell);
                    Variable var = subCell.getVar(Project.PROJLIBRARYKEY);
                    if (var != null) {
                        String subLibName = (String)var.getObject();
                        subLib = Library.findLibrary(subLibName);
                        if (subCellName.startsWith(subLibName + "__")) {
                            subCellName = subCellName.substring(subLibName.length() + 2);
                        }
                        if (subLib == null) {
                            subLib = Library.newInst(subLibName, null);
                            String projFile = Project.getRepositoryLocation() + File.separator + subLibName + File.separator + "project.proj";
                            File pf = new File(projFile);
                            if (!pf.exists()) {
                                System.out.println("Cannot find project file '" + projFile + "'...retrieve aborted.");
                            } else {
                                subLib.newVar(Project.PROJPATHKEY, (Object)projFile, ep);
                                ProjectLibrary subPL2 = pdb.findProjectLibrary(subLib);
                                this.addNewProjectCells(subPL2, updatedProjectCells);
                            }
                        }
                    }
                    if ((foundSubCell = subLib.findNodeProto(subCellName)) == null && (subCellPC = (subPL = pdb.findProjectLibrary(subLib)).findProjectCellByNameViewVersion(subCell.getName(), subCell.getView(), subCell.getVersion())) != null) {
                        if (subCellPC.getCell() != null) {
                            System.out.println("ERROR: cell " + subCellName + " does not exist, but it appears as " + subCellPC.getCell());
                        }
                        if (!updatedProjectCells.contains(subCellPC)) {
                            System.out.println("ERROR: cell " + subCellName + " needs to be updated but isn't in the list");
                        }
                        total += this.updateCellFromRepository(pdb, subCellPC, updatedProjectCells);
                        foundSubCell = subCellPC.getCell();
                    }
                    nodePrototypes.put(ni, foundSubCell);
                }
                String cellName = Project.describeFullCellName(cur);
                newCell = Cell.copyNodeProtoUsingMapping(cur, lib, cellName, nodePrototypes);
                if (newCell == null) {
                    System.out.println("Cannot copy " + cur + " from new library");
                }
            }
            fLib.kill("delete");
        }
        if (newCell != null) {
            pl.linkProjectCellToCell(pc, newCell);
            if (oldCell != null) {
                if (Project.useNewestVersion(oldCell, newCell, ep)) {
                    System.out.println("Error replacing instances of new " + oldCell);
                } else {
                    ProjectCell oldPC = pl.findProjectCell(oldCell);
                    pl.linkProjectCellToCell(oldPC, null);
                    this.displayedCells.swap(oldCell, newCell);
                    System.out.println("Updated " + newCell);
                }
            } else {
                System.out.println("Added new " + newCell);
            }
            ++total;
        }
        updatedProjectCells.remove(pc);
        return total;
    }

    private void addNewProjectCells(ProjectLibrary pl, List<ProjectCell> updatedProjectCells) {
        Cell oldCell;
        EditingPreferences ep = this.getEditingPreferences();
        HashMap<CallSite, ProjectCell> versionToGet = new HashMap<CallSite, ProjectCell>();
        Iterator<ProjectCell> it = pl.getProjectCells();
        while (it.hasNext()) {
            ProjectCell pc = it.next();
            String cellName = pc.getCellName() + pc.getView().getAbbreviationExtension();
            ProjectCell pcToGet = (ProjectCell)versionToGet.get(cellName);
            if (pcToGet != null) {
                if (pc.getVersion() <= pcToGet.getVersion()) continue;
                if (pc.getOwner().length() > 0) {
                    oldCell = pl.getLibrary().findNodeProto(pc.describeWithVersion());
                    if (oldCell != null) {
                        if (pc.getOwner().equals(Project.getCurrentUserName())) {
                            versionToGet.remove(cellName);
                            continue;
                        }
                        System.out.println("WARNING: " + oldCell + " is checked-out to " + pc.getOwner());
                        continue;
                    }
                    if (!pc.getOwner().equals(Project.getCurrentUserName())) continue;
                    System.out.println("WARNING: Cell " + pl.getLibrary().getName() + ":" + pc.describe() + " is checked-out to you but is missing from this library.  Re-building it.");
                    Project.setChangeStatus(true);
                    oldCell = pl.getLibrary().findNodeProto(pc.describe());
                    Library lib = oldCell.getLibrary();
                    String newName = oldCell.getName() + ";" + pc.getVersion() + pc.getView().getAbbreviationExtension();
                    if (oldCell != null) {
                        newVers = Cell.copyNodeProto(oldCell, lib, newName, true);
                        if (newVers == null) {
                            System.out.println("Error making new version of cell " + oldCell.describe(false));
                            Project.setChangeStatus(false);
                            continue;
                        }
                        this.newCells.put(oldCell.getId(), newVers);
                        if (Project.useNewestVersion(oldCell, newVers, ep)) {
                            System.out.println("Error replacing instances of cell " + oldCell.describe(false));
                            Project.setChangeStatus(false);
                            continue;
                        }
                        pl.ignoreCell(oldCell);
                        pl.linkProjectCellToCell(pc, newVers);
                        Project.markLocked(newVers, false, ep);
                    } else {
                        newVers = Cell.makeInstance(ep, lib, newName);
                        pl.linkProjectCellToCell(pc, newVers);
                    }
                    Project.setChangeStatus(false);
                }
            }
            versionToGet.put((CallSite)((Object)cellName), pc);
        }
        for (String cellName : versionToGet.keySet()) {
            ProjectCell pc = (ProjectCell)versionToGet.get(cellName);
            Cell oldCellAny = pl.getLibrary().findNodeProto(pc.describe());
            oldCell = pl.getLibrary().findNodeProto(pc.describeWithVersion());
            if (oldCellAny != null && oldCellAny.getVersion() > pc.getVersion()) {
                System.out.println("WARNING: " + oldCellAny + " is newer than what is in the repository.  Updating it from the repository version");
            }
            if (oldCell != null) continue;
            updatedProjectCells.add(pc);
        }
    }
}

