/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.bool.DeltaMerge;
import com.sun.electric.database.geometry.bool.LayoutMerger;
import com.sun.electric.database.geometry.bool.LayoutMergerFactory;
import com.sun.electric.database.geometry.bool.PointsSorter;
import com.sun.electric.database.geometry.bool.UnloadPolys;
import com.sun.electric.database.geometry.bool.VectorCache;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.id.CellId;
import com.sun.electric.technology.Layer;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.Orientation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class LayoutMergerHierImpl
implements LayoutMerger {
    final VectorCache vectorCache;
    private final Cell topCell;
    private static final int TMP_FILE_THRESHOLD = 1000000;
    private static final int[] NULL_INT_ARRAY = new int[0];

    LayoutMergerHierImpl(Cell topCell) {
        this.vectorCache = new VectorCache(topCell.getDatabase().backup());
        this.vectorCache.scanLayers(topCell.getId());
        this.topCell = topCell;
    }

    @Override
    public Collection<Layer> getLayers() {
        return this.vectorCache.getLayers();
    }

    @Override
    public boolean canMerge(Layer layer) {
        return !this.vectorCache.isBadLayer(layer);
    }

    Collection<CellTree> downTop(CellTree top) {
        LinkedHashSet<CellTree> result2 = new LinkedHashSet<CellTree>();
        this.downTop(result2, top);
        return result2;
    }

    private void downTop(LinkedHashSet<CellTree> result2, CellTree t) {
        if (!result2.contains(t)) {
            for (CellTree subTree : t.getSubTrees()) {
                if (subTree == null) continue;
                this.downTop(result2, subTree);
            }
            result2.add(t);
        }
    }

    byte[] mergeLocalLayerToByteArray(CellId cellId, Layer layer) throws IOException {
        int numBoxes = this.vectorCache.getNumBoxes(cellId, layer);
        if (numBoxes == 0) {
            return null;
        }
        int[] boxCoords = new int[4];
        PointsSorter ps = new PointsSorter();
        for (int i = 0; i < numBoxes; ++i) {
            this.vectorCache.getBoxes(cellId, layer, i, 1, boxCoords);
            int lx = boxCoords[0];
            int ly = boxCoords[1];
            int hx = boxCoords[2];
            int hy = boxCoords[3];
            ps.put(lx, ly, hx, hy);
        }
        DeltaMerge dm = new DeltaMerge();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        dm.loop(ps, out);
        byte[] ba = bout.toByteArray();
        out.close();
        return ba;
    }

    int[] byteArray2coordArray(byte[] ba) {
        try {
            int i;
            DataInputStream inpS = new DataInputStream(new ByteArrayInputStream(ba));
            ArrayList<Integer> pos = new ArrayList<Integer>();
            ArrayList neg = new ArrayList();
            while (inpS.readBoolean()) {
                int x = inpS.readInt();
                int count2 = inpS.readInt();
                for (i = 0; i < count2; ++i) {
                    int yp = inpS.readInt();
                    int y = yp >> 1;
                    boolean positive = (yp & 1) != 0;
                    ArrayList<Integer> b = positive ? pos : neg;
                    b.add(x);
                    b.add(y);
                }
            }
            assert (pos.size() == neg.size());
            int sz = pos.size();
            int[] result2 = new int[sz * 2];
            for (i = 0; i < sz; ++i) {
                result2[i] = (Integer)pos.get(i);
                result2[sz + i] = (Integer)neg.get(i);
            }
            return result2;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    void mergeLayer(Map<CellId, int[]> mergedCoords, CellId topCellId, Layer layer, boolean rotate, DataOutputStream out) {
        PointsSorter ps = new PointsSorter();
        int[] coordsBuf = new int[1024];
        Orientation topOrient = (rotate ? Orientation.XR : Orientation.IDENT).canonic();
        ElapseTimer timer1 = ElapseTimer.createInstance().start();
        coordsBuf = this.collectLayer(mergedCoords, ps, coordsBuf, topCellId, 0, 0, topOrient);
        timer1.end();
        ElapseTimer timer2 = ElapseTimer.createInstance().start();
        DeltaMerge dm = new DeltaMerge();
        int outPoints = dm.loop(ps, out);
        timer2.end();
        System.out.println(layer + " " + ps.size() + "->" + outPoints + " points" + ", merge=" + timer1 + " sec" + ", tree=" + timer2 + " sec");
    }

    private int[] collectLayer(Map<CellId, int[]> mergedCoords, PointsSorter ps, int[] coordsBuf, CellId cellId, int x, int y, Orientation orient) {
        int[] coords = mergedCoords.get(cellId);
        if (coords.length != 0) {
            if (coordsBuf.length < coords.length) {
                int newLen;
                for (newLen = coordsBuf.length; newLen < coords.length; newLen *= 2) {
                }
                coordsBuf = new int[newLen];
            }
            int numPoints = coords.length / 2;
            assert (numPoints % 2 == 0);
            orient.transformPoints(numPoints, coords, coordsBuf);
            boolean orientRot = orient.getCAngle() != 0 && orient.getCAngle() != 1800;
            boolean positive = !orientRot;
            for (int i = 0; i < numPoints; ++i) {
                if (i * 2 == numPoints) {
                    positive = !positive;
                }
                ps.put(x + coordsBuf[i * 2 + 0], y + coordsBuf[i * 2 + 1], positive);
            }
        }
        List<ImmutableNodeInst> subCells = this.vectorCache.getSubcells(cellId);
        for (ImmutableNodeInst n : subCells) {
            assert (n.orient.isManhattan());
            coordsBuf[0] = (int)n.anchor.getGridX();
            coordsBuf[1] = (int)n.anchor.getGridY();
            orient.transformPoints(1, coordsBuf);
            Orientation subOrient = orient.concatenate(n.orient).canonic();
            CellId subCellId = (CellId)n.protoId;
            coordsBuf = this.collectLayer(mergedCoords, ps, coordsBuf, subCellId, x + coordsBuf[0], y + coordsBuf[1], subOrient);
        }
        return coordsBuf;
    }

    void flattenAndMergeLayer(Layer layer, DataOutputStream out) throws IOException {
        Collection<CellTree> dt = this.downTop(this.topCell.tree());
        LinkedHashMap<CellId, int[]> mergedCoords = new LinkedHashMap<CellId, int[]>();
        for (CellTree t : dt) {
            CellId cellId = t.top.cellRevision.d.cellId;
            byte[] ba = this.mergeLocalLayerToByteArray(cellId, layer);
            if (ba != null) {
                mergedCoords.put(cellId, this.byteArray2coordArray(ba));
                continue;
            }
            mergedCoords.put(cellId, NULL_INT_ARRAY);
        }
        boolean rotate = false;
        this.mergeLayer(mergedCoords, this.topCell.getId(), layer, rotate, out);
    }

    byte[] mergeInMemory(Layer layer) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        this.flattenAndMergeLayer(layer, out);
        out.close();
        return bout.toByteArray();
    }

    File mergeInFile(Layer layer) throws IOException {
        File file = File.createTempFile("Electric", "DRC");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.flattenAndMergeLayer(layer, out);
        out.close();
        return file;
    }

    @Override
    public Iterable<PolyBase.PolyBaseTree> merge(Layer layer) {
        try {
            Iterable<PolyBase.PolyBaseTree> trees;
            boolean inMemory;
            boolean bl = inMemory = this.vectorCache.getNumFlatBoxes(this.topCell.getId(), layer) <= 1000000;
            if (inMemory) {
                byte[] ba = this.mergeInMemory(layer);
                DataInputStream inpS = new DataInputStream(new ByteArrayInputStream(ba));
                UnloadPolys up = new UnloadPolys();
                trees = up.loop(inpS, false);
                inpS.close();
            } else {
                File file = this.mergeInFile(layer);
                DataInputStream inpS = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                UnloadPolys up = new UnloadPolys();
                trees = up.loop(inpS, false);
                inpS.close();
                file.delete();
            }
            return trees;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class Factory
    extends LayoutMergerFactory {
        Factory() {
        }

        @Override
        public LayoutMerger newMerger(Cell topCell) {
            return new LayoutMergerHierImpl(topCell);
        }
    }
}

