/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Eagle
extends Output {
    public static final Variable.Key REF_DES_KEY = Variable.newKey("ATTR_ref_des");
    public static final Variable.Key PKG_TYPE_KEY = Variable.newKey("ATTR_pkg_type");
    public static final Variable.Key PIN_KEY = Variable.newKey("ATTR_pin");
    private List<Output.NetNames> networks;

    private Eagle(EaglePreferences ep) {
    }

    private void writeNetlist(Cell cell, VarContext context, String filePath) {
        if (this.openTextOutputStream(filePath)) {
            return;
        }
        this.networks = new ArrayList<Output.NetNames>();
        EagleNetlister netlister = new EagleNetlister();
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)netlister, Netlist.ShortResistors.ALL);
        this.printWriter.println(";");
        if (this.networks.size() == 0) {
            this.reportError("ERROR: no output produced.  Packages need attribute 'ref_des' and ports need attribute 'pin'");
            return;
        }
        Collections.sort(this.networks, new Output.NetNamesSort());
        int widestNodeName = 0;
        int widestNetName = 0;
        for (Output.NetNames nn : this.networks) {
            int netNameLen;
            int nodeNameLen = nn.nodeName.length();
            if (nodeNameLen > widestNodeName) {
                widestNodeName = nodeNameLen;
            }
            if ((netNameLen = nn.netName.length()) <= widestNetName) continue;
            widestNetName = netNameLen;
        }
        widestNodeName += 4;
        widestNetName += 4;
        for (int i = 0; i < this.networks.size(); ++i) {
            Output.NetNames oNn;
            Output.NetNames nn;
            nn = this.networks.get(i);
            String baseName = nn.netName;
            int endPos = i;
            int j = i + 1;
            while (j < this.networks.size()) {
                oNn = this.networks.get(j);
                if (!oNn.netName.equals(baseName)) break;
                endPos = j++;
            }
            if (endPos == i) continue;
            for (j = i; j <= endPos; ++j) {
                int k;
                oNn = this.networks.get(j);
                if (j == i) {
                    this.printWriter.print("Signal ");
                } else {
                    this.printWriter.print("       ");
                }
                this.printWriter.print("'" + oNn.netName + "'");
                for (k = oNn.netName.length(); k < widestNetName; ++k) {
                    this.printWriter.print(" ");
                }
                this.printWriter.print("'" + oNn.nodeName + "'");
                for (k = oNn.nodeName.length(); k < widestNodeName; ++k) {
                    this.printWriter.print(" ");
                }
                this.printWriter.println("'" + oNn.portName + "' \\");
            }
            this.printWriter.println(";");
        }
        if (this.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    private class EagleNetlister
    extends HierarchyEnumerator.Visitor {
        private EagleNetlister() {
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (!no.isCellInstance()) {
                return false;
            }
            Variable var = no.getVar(REF_DES_KEY);
            if (var == null) {
                return true;
            }
            String context = "";
            Nodable pNo = info.getParentInst();
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null && pNo != null) {
                context = parentInfo.getUniqueNodableName(pNo, ".") + ".";
            }
            String nodeName = context + var.getPureValue(-1);
            String pkgType = no.getProto().getName();
            Variable pkgName = no.getVar(PKG_TYPE_KEY);
            if (pkgName != null) {
                pkgType = pkgName.getPureValue(-1);
            }
            Eagle.this.printWriter.println("ADD " + pkgType + " '" + nodeName + "' (0 0)");
            NodeInst ni = no.getNodeInst();
            Cell altProto = null;
            if (ni.isCellInstance() && ((Cell)ni.getProto()).getView() == View.ICON) {
                altProto = ((Cell)ni.getProto()).contentsView();
            }
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                PortProto pp = pi.getPortProto();
                Name busName = pp.getNameKey();
                String pName = null;
                Variable pVar = pi.getVar(PIN_KEY);
                if (pVar != null) {
                    pName = pVar.getPureValue(-1);
                } else {
                    Export other;
                    if (altProto != null && (other = ((Export)pp).findEquivalent(altProto)) != null) {
                        pp = other;
                    }
                    if ((pVar = ((Export)pp).getVar(PIN_KEY)) != null) {
                        pName = pVar.getPureValue(-1);
                    }
                }
                if (pName == null) continue;
                for (int busIndex = 0; busIndex < busName.busWidth(); ++busIndex) {
                    Name wireName = busName.subname(busIndex);
                    int netId = info.getPortNetID(no, wireName);
                    Output.NetNames nn = new Output.NetNames();
                    nn.netName = info.getUniqueNetName(netId, ".");
                    nn.nodeName = nodeName;
                    nn.portName = pName;
                    Eagle.this.networks.add(nn);
                }
            }
            return false;
        }
    }

    public static class EaglePreferences
    extends Output.OutputPreferences {
        public EaglePreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Eagle out = new Eagle(this);
            out.writeNetlist(cell, context, filePath);
            return out;
        }
    }
}

