/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.staged;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.AdditionalNodeData;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.SpringForce;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.Force2D;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;
import com.sun.electric.util.math.GenMath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalculateForcesStageWorker
extends StageWorker {
    protected Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>> connectivityMap;
    protected List<PlacementFrame.PlacementNetwork> allNetworks;

    public CalculateForcesStageWorker(Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>> connectivity, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.connectivityMap = connectivity;
        this.allNetworks = allNetworks;
    }

    private Force2D calculateForces(PlacementFrame.PlacementNode node) {
        Force2D result2 = new Force2D();
        boolean newList = false;
        AdditionalNodeData data2 = PlacementForceDirectedStaged.getNodeData().get(node);
        if (data2.getNetworks() == null) {
            data2.setNetworks(new HashMap<PlacementFrame.PlacementNetwork, PlacementFrame.PlacementPort>());
            newList = true;
        }
        if (newList) {
            for (PlacementFrame.PlacementNetwork network : this.allNetworks) {
                for (PlacementFrame.PlacementPort port : network.getPortsOnNet()) {
                    if (!node.equals(port.getPlacementNode()) || !newList) continue;
                    data2.getNetworks().put(network, port);
                }
            }
        }
        result2 = new Force2D();
        for (PlacementFrame.PlacementNetwork network : data2.getNetworks().keySet()) {
            for (PlacementFrame.PlacementPort port : network.getPortsOnNet()) {
                if (node == port.getPlacementNode()) continue;
                result2 = result2.add(SpringForce.calculate(data2.getNetworks().get(network), port, 1.0, 0.0));
            }
        }
        return result2;
    }

    @Override
    public void run() {
        while (!this.abort.booleanValue()) {
            try {
                PlacementDTO data2 = this.stage.getInput(this).get();
                List<CheckboardingField> fields = data2.getFieldsList();
                if (fields != null) {
                    for (CheckboardingField field2 : fields) {
                        if (field2 == null || field2.getNode() == null) continue;
                        Force2D force2 = this.calculateForces(field2.getNode());
                        data2.getForces().put(field2.getNode(), force2);
                    }
                }
                this.stage.sendToNextStage(data2);
            }
            catch (EmptyException ex) {
                Thread.yield();
            }
        }
    }
}

