/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.EquivalentSchematicExports;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetlistImpl;
import com.sun.electric.database.network.NetlistShorted;
import com.sun.electric.database.network.NetworkManager;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.IconNodeInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.util.math.GenMath;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class NetSchem
extends NetCell {
    private static final boolean CHECK_EQUIV_PORTS = true;
    NetSchem implementation;
    int[] drawnOffsets;
    IconInst[] iconInsts;
    IdentityHashMap<IconInst, Set<Global>> iconInstExcludeGlobals;
    Global.Set globals = Global.Set.empty;
    int[] portOffsets = new int[1];
    int netNamesOffset;
    Name[] drawnNames;
    int[] drawnWidths;
    private IdentityHashMap<Name, Integer> exportNameMapOffsets;
    private CellTree cellTree;
    private CellId mainSchemId;
    private IdentityHashMap<CellId, EquivalentSchematicExports> eqExports;

    NetSchem(Cell cell) {
        super(cell);
        Cell mainSchematics;
        this.setImplementation(this);
        if (cell.isIcon() && (mainSchematics = cell.getCellGroup().getMainSchematics()) != null) {
            NetSchem mainSchem = new NetSchem(mainSchematics);
            this.setImplementation(mainSchem);
        }
    }

    private void setImplementation(NetSchem implementation) {
        if (this.implementation == implementation) {
            return;
        }
        this.implementation = implementation;
    }

    @Override
    NetSchem getSchem() {
        return this.implementation;
    }

    @Override
    Iterator<Nodable> getNodables() {
        ArrayList<Nodable> nodables = new ArrayList<Nodable>();
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (this.iconInsts[ni.getNodeIndex()] != null) continue;
            nodables.add(ni);
        }
        for (IconInst iconInst : this.iconInsts) {
            if (iconInst == null || iconInst.iconOfParent) continue;
            for (int i = 0; i < iconInst.iconNodables.length; ++i) {
                Nodable proxy = iconInst.iconNodables[i];
                assert (proxy != null);
                nodables.add(proxy);
            }
        }
        return nodables.iterator();
    }

    @Override
    Global.Set getGlobals() {
        return this.globals;
    }

    @Override
    int getNetMapOffset(Global global) {
        return this.globals.indexOf(global);
    }

    @Override
    int getNetMapOffset(Nodable no, Global global) {
        if (no == null) {
            return -1;
        }
        int nodeIndex = no.getNodeInst().getNodeIndex();
        if (nodeIndex < 0 || nodeIndex >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeIndex];
        if (iconInst == null || iconInst.iconOfParent) {
            return -1;
        }
        assert (!(no instanceof NodeInst) || no == iconInst.nodeInst && ((Cell)iconInst.nodeInst.getProto()).isSchematic());
        int indexOfGlobal = iconInst.eq.implementation.globals.indexOf(global);
        if (indexOfGlobal < 0) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + indexOfGlobal;
    }

    @Override
    int getNetMapOffset(Nodable no, int equivPortIndex) {
        int nodeIndex = no.getNodeInst().getNodeIndex();
        if (nodeIndex < 0 || nodeIndex >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeIndex];
        if (iconInst == null || iconInst.iconOfParent) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + equivPortIndex;
    }

    @Override
    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        if (no == null) {
            return -1;
        }
        int nodeIndex = no.getNodeInst().getNodeIndex();
        if (nodeIndex < 0 || nodeIndex >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeIndex];
        if (iconInst == null) {
            int drawn = this.drawns[this.ni_pi[nodeIndex] + portProto.getPortIndex()];
            if (drawn < 0) {
                return -1;
            }
            if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
                return -1;
            }
            assert (portProto.getParent() == ((NodeInst)no).getProto());
            return this.drawnOffsets[drawn] + busIndex;
        }
        if (iconInst.iconOfParent) {
            return -1;
        }
        Cell subCell = (Cell)portProto.getParent();
        assert (no.getProto() == subCell);
        EquivalentSchematicExports eq2 = iconInst.eq;
        if (no instanceof IconNodeInst) {
            Nodable no1 = ((IconNodeInst)no).getNodable(0);
            assert (eq2.cellId == subCell.getId());
            no = no1;
        } else assert (eq2.implementation.cellId == subCell.getId());
        Name exportName = portProto.getNameKey().subname(busIndex);
        int portOffset = eq2.implementation.getExportNameMapOffset(exportName);
        if (portOffset < 0) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + portOffset;
    }

    @Override
    int getNetMapOffset(Nodable no, Name portName) {
        if (no == null) {
            return -1;
        }
        int nodeIndex = no.getNodeInst().getNodeIndex();
        if (nodeIndex < 0 || nodeIndex >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeIndex];
        if (iconInst == null) {
            PortProto portProto = no.getParent().findPortProto(portName);
            int drawn = this.drawns[this.ni_pi[nodeIndex] + portProto.getPortIndex()];
            if (drawn < 0) {
                return -1;
            }
            if (this.drawnWidths[drawn] != 1) {
                throw new IllegalArgumentException();
            }
            assert (portProto.getParent() == ((NodeInst)no).getProto());
            return this.drawnOffsets[drawn];
        }
        if (iconInst.iconOfParent) {
            return -1;
        }
        Cell subCell = (Cell)no.getProto();
        EquivalentSchematicExports eq2 = iconInst.eq;
        if (no instanceof IconNodeInst) {
            Nodable no1 = ((IconNodeInst)no).getNodable(0);
            assert (eq2.cellId == subCell.getId());
            no = no1;
        } else assert (eq2.implementation.cellId == subCell.getId());
        int portOffset = eq2.implementation.getExportNameMapOffset(portName);
        if (portOffset < 0) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + portOffset;
    }

    @Override
    int getBusWidth(Nodable no, PortProto portProto) {
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            int nodeIndex = ni.getNodeIndex();
            int drawn = this.drawns[this.ni_pi[nodeIndex] + portProto.getPortIndex()];
            if (drawn < 0) {
                return 0;
            }
            return this.drawnWidths[drawn];
        }
        return portProto.getNameKey().busWidth();
    }

    @Override
    int getNetMapOffset(Export export, int busIndex) {
        int drawn = this.drawns[export.getPortIndex()];
        if (drawn < 0) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
            return -1;
        }
        return this.drawnOffsets[drawn] + busIndex;
    }

    @Override
    int getNetMapOffset(Name exportName) {
        Integer objResult;
        assert (!exportName.isBus());
        if (this.exportNameMapOffsets == null) {
            this.buildExportNameMapOffsets();
        }
        return (objResult = this.exportNameMapOffsets.get(exportName)) != null ? objResult : -1;
    }

    private void buildExportNameMapOffsets() {
        IdentityHashMap<Name, Integer> map2 = new IdentityHashMap<Name, Integer>();
        for (int exportIndex = 0; exportIndex < this.cell.getNumPorts(); ++exportIndex) {
            Export e = this.cell.getPort(exportIndex);
            for (int busIndex = 0; busIndex < e.getNameKey().busWidth(); ++busIndex) {
                Name exportName = e.getNameKey().subname(busIndex);
                if (map2.containsKey(exportName)) continue;
                map2.put(exportName, this.portOffsets[exportIndex] + busIndex);
            }
        }
        this.exportNameMapOffsets = map2;
    }

    @Override
    int getNetMapOffset(ArcInst ai, int busIndex) {
        int drawn = this.getArcDrawn(ai);
        if (drawn < 0) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
            return -1;
        }
        return this.drawnOffsets[drawn] + busIndex;
    }

    @Override
    Name getBusName(ArcInst ai) {
        int drawn = this.getArcDrawn(ai);
        return this.drawnNames[drawn];
    }

    @Override
    public int getBusWidth(ArcInst ai) {
        int drawn = this.getArcDrawn(ai);
        if (drawn < 0) {
            return 0;
        }
        return this.drawnWidths[drawn];
    }

    private boolean initNodables() {
        int i;
        int numNodes = this.cell.getNumNodes();
        Global.Buf globalBuf = new Global.Buf();
        HashMap nodeInstExcludeGlobal = null;
        for (int i2 = 0; i2 < numNodes; ++i2) {
            PortCharacteristic characteristic;
            NodeInst ni = this.cell.getNode(i2);
            NodeProto np = ni.getProto();
            if (ni.isCellInstance()) {
                String errorMsg;
                String msg;
                Cell subCell = (Cell)np;
                if (!subCell.isIcon() && !subCell.isSchematic()) {
                    if (!ni.getNameKey().isBus()) continue;
                    msg = this.cell + ": Array name <" + ni.getNameKey() + "> can be assigned only to icon nodes";
                    System.out.println(msg);
                    this.networkManager.pushHighlight(ni);
                    this.networkManager.logError(msg, 1);
                    continue;
                }
                if (ni.getNameKey().hasDuplicates()) {
                    msg = this.cell + ": Node name <" + ni.getNameKey() + "> has duplicate subnames";
                    System.out.println(msg);
                    this.networkManager.pushHighlight(ni);
                    this.networkManager.logError(msg, 1);
                }
                if (ni.isIconOfParent()) continue;
                EquivalentSchematicExports eq2 = this.database.backup().getEquivExports(subCell.getId());
                Global.Set gs = eq2.implementation.globals;
                if (eq2.implementation.globalPartitions != null) {
                    int numPortInsts = np.getNumPorts();
                    HashSet<Global> gb = null;
                    for (int j = 0; j < numPortInsts; ++j) {
                        PortInst pi = ni.getPortInst(j);
                        int piOffset = this.getPortInstOffset(pi);
                        int drawn = this.drawns[piOffset];
                        if (drawn < 0 || drawn >= this.numConnectedDrawns) continue;
                        Export e = (Export)pi.getPortProto();
                        Name busName = e.getNameKey();
                        for (int busIndex = 0; busIndex < busName.busWidth(); ++busIndex) {
                            Name exportName = busName.subname(busIndex);
                            Global.Set globalsOnElement = eq2.implementation.globalPartitions.get(exportName);
                            if (globalsOnElement == null) continue;
                            if (gb == null) {
                                gb = new HashSet<Global>();
                            }
                            for (int l = 0; l < globalsOnElement.size(); ++l) {
                                Global g = globalsOnElement.get(l);
                                gb.add(g);
                            }
                        }
                    }
                    if (gb != null) {
                        if (nodeInstExcludeGlobal == null) {
                            nodeInstExcludeGlobal = new HashMap();
                        }
                        nodeInstExcludeGlobal.put(ni, gb);
                        gs = gs.remove(gb.iterator());
                    }
                }
                if ((errorMsg = globalBuf.addToBuf(gs)) == null) continue;
                String msg2 = "Network: " + this.cell + " has globals with conflicting characteristic " + errorMsg;
                System.out.println(msg2);
                this.networkManager.logError(msg2, 0);
                continue;
            }
            Global g = NetSchem.globalInst(ni);
            if (g == null) continue;
            if (g == Global.ground) {
                characteristic = PortCharacteristic.GND;
            } else if (g == Global.power) {
                characteristic = PortCharacteristic.PWR;
            } else {
                characteristic = PortCharacteristic.findCharacteristic(ni.getTechSpecific());
                if (characteristic == null) {
                    String msg = "Network: " + this.cell + " has global " + g.getName() + " with unknown characteristic bits";
                    System.out.println(msg);
                    this.networkManager.pushHighlight(ni);
                    this.networkManager.logError(msg, 0);
                    characteristic = PortCharacteristic.UNKNOWN;
                }
            }
            String errorMsg = globalBuf.addToBuf(g, characteristic);
            if (errorMsg == null) continue;
            String msg = "Network: " + this.cell + " has global with conflicting characteristic " + errorMsg;
            System.out.println(msg);
            this.networkManager.logError(msg, 0);
        }
        Global.Set newGlobals = globalBuf.getBuf();
        boolean changed = false;
        if (this.globals != newGlobals) {
            changed = true;
            this.globals = newGlobals;
            if (NetworkTool.debug) {
                System.out.println(this.cell + " has " + this.globals);
            }
        }
        int mapOffset = this.portOffsets[0] = this.globals.size();
        int numPorts = this.cell.getNumPorts();
        for (i = 1; i <= numPorts; ++i) {
            Export export = this.cell.getPort(i - 1);
            if (NetworkTool.debug) {
                System.out.println(export + " " + this.portOffsets[i - 1]);
            }
            if (this.portOffsets[i] == (mapOffset += export.getNameKey().busWidth())) continue;
            changed = true;
            this.portOffsets[i] = mapOffset;
        }
        if (this.equivPortsN == null || this.equivPortsN.length != mapOffset) {
            this.equivPortsN = new int[mapOffset];
            this.equivPortsP = new int[mapOffset];
            this.equivPortsA = new int[mapOffset];
        }
        for (i = 0; i < this.numDrawns; ++i) {
            this.drawnOffsets[i] = mapOffset;
            mapOffset += this.drawnWidths[i];
            if (!NetworkTool.debug) continue;
            System.out.println("Drawn " + i + " has offset " + this.drawnOffsets[i]);
        }
        this.iconInsts = new IconInst[this.cell.getNumNodes()];
        this.iconInstExcludeGlobals = null;
        for (int n = 0; n < numNodes; ++n) {
            Set gs;
            IconInst iconInst;
            Cell iconCell;
            NodeInst ni = this.cell.getNode(n);
            if (!ni.isCellInstance() || !(iconCell = (Cell)ni.getProto()).isIcon() && !iconCell.isSchematic()) continue;
            this.iconInsts[n] = iconInst = new IconInst(ni, mapOffset);
            if (ni.isIconOfParent()) {
                assert (iconInst.iconOfParent && iconInst.iconNodables == null);
                continue;
            }
            Set set = gs = nodeInstExcludeGlobal != null ? (Set)nodeInstExcludeGlobal.get(ni) : null;
            if (gs != null) {
                if (this.iconInstExcludeGlobals == null) {
                    this.iconInstExcludeGlobals = new IdentityHashMap();
                }
                this.iconInstExcludeGlobals.put(iconInst, gs);
            }
            for (int i3 = 0; i3 < ni.getNameKey().busWidth(); ++i3) {
                Nodable proxy;
                if (ni instanceof IconNodeInst) {
                    proxy = ((IconNodeInst)ni).getNodable(i3);
                } else {
                    assert (ni.getNameKey().busWidth() == 1);
                    proxy = ni;
                }
                iconInst.iconNodables[i3] = proxy;
                assert (iconInst.getNetMapOffset(proxy) == mapOffset);
                mapOffset += iconInst.numExtendedExports;
            }
        }
        this.netNamesOffset = mapOffset;
        if (NetworkTool.debug) {
            System.out.println("netNamesOffset=" + this.netNamesOffset);
        }
        return changed;
    }

    private static Global globalInst(NodeInst ni) {
        String globalName;
        NodeProto np = ni.getProto();
        if (np == Schematics.tech().groundNode) {
            return Global.ground;
        }
        if (np == Schematics.tech().powerNode) {
            return Global.power;
        }
        if (np == Schematics.tech().globalNode && (globalName = ni.getVarValue(Schematics.SCHEM_GLOBAL_NAME, String.class)) != null) {
            return Global.newGlobal(globalName);
        }
        return null;
    }

    void calcDrawnWidths() {
        int i;
        int oldWidth;
        int arcIndex;
        Arrays.fill(this.drawnNames, null);
        Arrays.fill(this.drawnWidths, -1);
        int numPorts = this.cell.getNumPorts();
        int numNodes = this.cell.getNumNodes();
        int numArcs = this.cell.getNumArcs();
        for (int i2 = 0; i2 < numPorts; ++i2) {
            int drawn = this.drawns[i2];
            Name name = this.cell.getPort(i2).getNameKey();
            int newWidth = name.busWidth();
            int oldWidth2 = this.drawnWidths[drawn];
            if (oldWidth2 < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth2 == newWidth) continue;
            this.reportDrawnWidthError(this.cell.getPort(i2), null, this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth2 >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        Iterator<ArcInst> it = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            Name name;
            ArcInst ai = it.next();
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || (name = ai.getNameKey()).isTempname()) continue;
            int newWidth = name.busWidth();
            oldWidth = this.drawnWidths[drawn];
            if (oldWidth < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth == newWidth) continue;
            this.reportDrawnWidthError(null, ai, this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        ArcProto busArc = Schematics.tech().bus_arc;
        Iterator<ArcInst> it2 = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            Name name;
            ArcInst ai = it2.next();
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || !(name = ai.getNameKey()).isTempname() || (oldWidth = this.drawnWidths[drawn]) >= 0) continue;
            this.drawnNames[drawn] = name;
            if (ai.getProto() == busArc) continue;
            this.drawnWidths[drawn] = 1;
        }
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance() && (np.getFunction().isPin() || np == Schematics.tech().offpageNode)) continue;
            int numPortInsts = np.getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                Cell subCell;
                PortInst pi = ni.getPortInst(j);
                int drawn = this.drawns[this.getPortInstOffset(pi)];
                if (drawn < 0) continue;
                int oldWidth3 = this.drawnWidths[drawn];
                int newWidth = 1;
                if (ni.isCellInstance() && ((subCell = (Cell)np).isIcon() || subCell.isSchematic())) {
                    int arraySize = subCell.isIcon() ? ni.getNameKey().busWidth() : 1;
                    int portWidth = pi.getPortProto().getNameKey().busWidth();
                    if (oldWidth3 == portWidth) continue;
                    newWidth = arraySize * portWidth;
                }
                if (oldWidth3 < 0) {
                    this.drawnWidths[drawn] = newWidth;
                    continue;
                }
                if (oldWidth3 == newWidth) continue;
                String msg = "Network: Schematic " + this.cell + " has net <" + this.drawnNames[drawn] + "> with width conflict in connection " + pi.describe(true);
                System.out.println(msg);
                this.networkManager.pushHighlight(pi);
                this.networkManager.logError(msg, 0);
            }
        }
        for (i = 0; i < this.drawnWidths.length; ++i) {
            if (this.drawnWidths[i] < 1) {
                this.drawnWidths[i] = 1;
            }
            if (!NetworkTool.debug) continue;
            System.out.println("Drawn " + i + " " + (this.drawnNames[i] != null ? this.drawnNames[i].toString() : "") + " has width " + this.drawnWidths[i]);
        }
    }

    void reportDrawnWidthError(Export pp, ArcInst ai, String firstname, String badname) {
        int numPorts = this.cell.getNumPorts();
        int numArcs = this.cell.getNumArcs();
        String msg = "Network: Schematic " + this.cell + " has net with conflict width of names <" + firstname + "> and <" + badname + ">";
        System.out.println(msg);
        boolean originalFound = false;
        for (int i = 0; i < numPorts; ++i) {
            String name = this.cell.getPort(i).getName();
            if (!name.equals(firstname)) continue;
            this.networkManager.pushHighlight(this.cell.getPort(i));
            originalFound = true;
            break;
        }
        if (!originalFound) {
            Iterator<ArcInst> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst oai = it.next();
                String name = oai.getName();
                if (!name.equals(firstname)) continue;
                this.networkManager.pushHighlight(oai);
                break;
            }
        }
        if (ai != null) {
            this.networkManager.pushHighlight(ai);
        }
        if (pp != null) {
            this.networkManager.pushHighlight(pp);
        }
        this.networkManager.logError(msg, 0);
    }

    @Override
    void addNetNames(Name name, Export e, ArcInst ai) {
        for (int i = 0; i < name.busWidth(); ++i) {
            this.addNetName(name.subname(i), e, ai);
        }
    }

    private void localConnections(int[] netMap) {
        int numExports = this.cell.getNumPorts();
        for (int k = 0; k < numExports; ++k) {
            Export e = this.cell.getPort(k);
            int portOffset = this.portOffsets[k];
            Name expNm = e.getNameKey();
            int busWidth = expNm.busWidth();
            int drawn = this.drawns[k];
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i = 0; i < busWidth; ++i) {
                Netlist.connectMap(netMap, portOffset + i, drawnOffset + (busWidth == this.drawnWidths[drawn] ? i : i % this.drawnWidths[drawn]));
                GenMath.MutableInteger nn = (GenMath.MutableInteger)this.netNames.get(expNm.subname(i));
                Netlist.connectMap(netMap, portOffset + i, this.netNamesOffset + nn.intValue());
            }
        }
        int numNodes = this.cell.getNumNodes();
        for (int k = 0; k < numNodes; ++k) {
            NodeInst ni = this.cell.getNode(k);
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance()) {
                Global g = NetSchem.globalInst(ni);
                if (g != null) {
                    int drawn = this.drawns[this.ni_pi[k]];
                    Netlist.connectMap(netMap, this.globals.indexOf(g), this.drawnOffsets[drawn]);
                }
                if (np != Schematics.tech().wireConNode) continue;
                this.connectWireCon(netMap, ni);
                continue;
            }
            IconInst iconInst = this.iconInsts[k];
            if (iconInst == null || iconInst.iconOfParent) continue;
            Cell subCell = (Cell)np;
            assert (subCell.isIcon() || subCell.isSchematic());
            EquivalentSchematicExports eq2 = iconInst.eq;
            Name nodeName = ni.getNameKey();
            int arraySize = nodeName.busWidth();
            int numPorts = np.getNumPorts();
            for (int m = 0; m < numPorts; ++m) {
                int width;
                Export e = (Export)np.getPort(m);
                Name busExportName = e.getNameKey();
                int busWidth = busExportName.busWidth();
                int drawn = this.drawns[this.ni_pi[k] + m];
                if (drawn < 0 || (width = this.drawnWidths[drawn]) != busWidth && width != busWidth * arraySize) continue;
                assert (arraySize == iconInst.iconNodables.length);
                for (int arrayIndex = 0; arrayIndex < arraySize; ++arrayIndex) {
                    int nodeOffset = iconInst.netMapOffset + arrayIndex * iconInst.numExtendedExports;
                    int busOffset = this.drawnOffsets[drawn];
                    if (width != busWidth) {
                        busOffset += busWidth * arrayIndex;
                    }
                    for (int j = 0; j < busWidth; ++j) {
                        Name exportName = busExportName.subname(j);
                        int portOffset = eq2.implementation.getExportNameMapOffset(exportName);
                        if (portOffset < 0) continue;
                        Netlist.connectMap(netMap, busOffset + j, nodeOffset + portOffset);
                    }
                }
            }
        }
        int numArcs = this.cell.getNumArcs();
        Iterator<ArcInst> it = this.cell.getArcs();
        for (int arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            ArcInst ai = it.next();
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || !ai.isUsernamed()) continue;
            int busWidth = this.drawnWidths[drawn];
            Name arcNm = ai.getNameKey();
            if (arcNm.busWidth() != busWidth) continue;
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i = 0; i < busWidth; ++i) {
                GenMath.MutableInteger nn = (GenMath.MutableInteger)this.netNames.get(arcNm.subname(i));
                Netlist.connectMap(netMap, drawnOffset + i, this.netNamesOffset + nn.intValue());
            }
        }
        for (IconInst iconInst : this.iconInsts) {
            if (iconInst == null || iconInst.iconOfParent) continue;
            Set<Global> excludeGlobals = null;
            if (this.iconInstExcludeGlobals != null) {
                excludeGlobals = this.iconInstExcludeGlobals.get(iconInst);
            }
            for (int k = 0; k < iconInst.iconNodables.length; ++k) {
                EquivalentSchematicExports eq3 = iconInst.eq.implementation;
                assert (eq3.implementation == eq3);
                int numGlobals = eq3.portOffsets[0];
                if (numGlobals == 0) continue;
                int nodableOffset = iconInst.netMapOffset + k * iconInst.numExtendedExports;
                for (int i = 0; i < numGlobals; ++i) {
                    Global g = eq3.globals.get(i);
                    if (excludeGlobals != null && excludeGlobals.contains(g)) continue;
                    Netlist.connectMap(netMap, this.globals.indexOf(g), nodableOffset + i);
                }
            }
        }
        Netlist.closureMap(netMap);
    }

    private void pushName(Name name) {
        int i;
        Name n;
        Iterator<ElectricObject> it = this.cell.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            n = e.getNameKey();
            for (i = 0; i < n.busWidth(); ++i) {
                if (n.subname(i) != name) continue;
                this.networkManager.pushHighlight(e);
                return;
            }
        }
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            n = ai.getNameKey();
            for (i = 0; i < n.busWidth(); ++i) {
                if (n.subname(i) != name) continue;
                this.networkManager.pushHighlight(ai);
                return;
            }
        }
    }

    private void connectWireCon(int[] netMap, NodeInst ni) {
        ArcInst ai1 = null;
        ArcInst ai2 = null;
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            if (ai1 == null) {
                ai1 = ai;
                continue;
            }
            if (ai2 == null) {
                ai2 = ai;
                continue;
            }
            String msg = "Network: Schematic " + this.cell + " has connector " + ni + " which merges more than two arcs";
            System.out.println(msg);
            this.networkManager.pushHighlight(ni);
            this.networkManager.logError(msg, 0);
            return;
        }
        if (ai2 == null || ai1 == ai2) {
            return;
        }
        int large = this.getArcDrawn(ai1);
        int small = this.getArcDrawn(ai2);
        if (large < 0 || small < 0) {
            return;
        }
        if (this.drawnWidths[small] > this.drawnWidths[large]) {
            int temp = small;
            small = large;
            large = temp;
        }
        for (int i = 0; i < this.drawnWidths[large]; ++i) {
            Netlist.connectMap(netMap, this.drawnOffsets[large] + i, this.drawnOffsets[small] + i % this.drawnWidths[small]);
        }
    }

    private void internalConnections(int[] netMapF, int[] netMapP, int[] netMapA) {
        int numNodes = this.cell.getNumNodes();
        for (int k = 0; k < numNodes; ++k) {
            NodeInst ni = this.cell.getNode(k);
            int nodeOffset = this.ni_pi[k];
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance()) {
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun == PrimitiveNode.Function.RESIST) {
                    Netlist.connectMap(netMapP, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                    Netlist.connectMap(netMapA, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                    continue;
                }
                if (!fun.isComplexResistor()) continue;
                Netlist.connectMap(netMapA, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                continue;
            }
            IconInst iconInst = this.iconInsts[k];
            if (iconInst != null) continue;
            Cell subCell = (Cell)np;
            assert (!subCell.isIcon() && !subCell.isSchematic());
            EquivPorts eq2 = this.cell.tree().getEquivPorts();
            int[] eqN = eq2.getEquivPortsN();
            int[] eqP = eq2.getEquivPortsP();
            int[] eqA = eq2.getEquivPortsA();
            int numPorts = eq2.getNumExports();
            assert (eqN.length == numPorts && eqP.length == numPorts && eqA.length == numPorts);
            for (int i = 0; i < numPorts; ++i) {
                int dj;
                int jA;
                int dj2;
                int jP;
                int dj3;
                int di = this.drawns[nodeOffset + i];
                if (di < 0) continue;
                int jN = eqN[i];
                if (i != jN && (dj3 = this.drawns[nodeOffset + jN]) >= 0) {
                    Netlist.connectMap(netMapF, this.drawnOffsets[di], this.drawnOffsets[dj3]);
                }
                if (i != (jP = eqP[i]) && (dj2 = this.drawns[nodeOffset + jP]) >= 0) {
                    Netlist.connectMap(netMapP, this.drawnOffsets[di], this.drawnOffsets[dj2]);
                }
                if (i == (jA = eqA[i]) || (dj = this.drawns[nodeOffset + jA]) < 0) continue;
                Netlist.connectMap(netMapA, this.drawnOffsets[di], this.drawnOffsets[dj]);
            }
        }
        for (IconInst iconInst : this.iconInsts) {
            if (iconInst == null || iconInst.iconOfParent) continue;
            for (int k = 0; k < iconInst.iconNodables.length; ++k) {
                EquivalentSchematicExports eq3 = iconInst.eq.implementation;
                assert (eq3.implementation == eq3);
                int[] eqN = eq3.getEquivPortsN();
                int[] eqP = eq3.getEquivPortsP();
                int[] eqA = eq3.getEquivPortsA();
                int nodableOffset = iconInst.netMapOffset + k * iconInst.numExtendedExports;
                for (int i = 0; i < eqN.length; ++i) {
                    int jA;
                    int jP;
                    int io = nodableOffset + i;
                    int jF = eqN[i];
                    if (i != jF) {
                        Netlist.connectMap(netMapF, io, nodableOffset + jF);
                    }
                    if (i != (jP = eqP[i])) {
                        Netlist.connectMap(netMapP, io, nodableOffset + jP);
                    }
                    if (i == (jA = eqA[i])) continue;
                    Netlist.connectMap(netMapA, io, nodableOffset + jA);
                }
            }
        }
    }

    private void buildNetworkLists(int[] netMapF) {
        int index;
        this.netlistN = new NetlistImpl(this, this.equivPortsN.length, netMapF);
        int equivPortIndex = 0;
        for (int i = 0; i < this.globals.size(); ++i) {
            Global global = this.globals.get(i);
            int netIndex = this.netlistN.getNetIndex(global);
            this.netlistN.addUserName(netIndex, global.getNameKey(), true);
            this.netlistN.setEquivPortIndexByNetIndex(equivPortIndex++, netIndex);
        }
        Iterator<Export> it = this.cell.getExports();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            for (int busIndex = 0; busIndex < ((Export)((Object)e)).getNameKey().busWidth(); ++busIndex) {
                this.netlistN.setEquivPortIndexByNetIndex(equivPortIndex++, this.netlistN.getNetIndex((Export)((Object)e), busIndex));
            }
        }
        for (Map.Entry e : this.netNames.entrySet()) {
            Name name = (Name)e.getKey();
            index = ((GenMath.MutableInteger)e.getValue()).intValue();
            if (index < 0 || index >= this.exportedNetNameCount) continue;
            this.netlistN.addUserName(this.netlistN.getNetIndexByMap(this.netNamesOffset + index), name, true);
        }
        for (Map.Entry e : this.netNames.entrySet()) {
            Name name = (Name)e.getKey();
            index = ((GenMath.MutableInteger)e.getValue()).intValue();
            if (index < this.exportedNetNameCount) continue;
            this.netlistN.addUserName(this.netlistN.getNetIndexByMap(this.netNamesOffset + index), name, false);
        }
        int numArcs = this.cell.getNumArcs();
        Iterator<Object> it2 = this.cell.getArcs();
        for (int arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            ArcInst ai = it2.next();
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0) continue;
            for (int j = 0; j < this.drawnWidths[drawn]; ++j) {
                String netName;
                int netIndexN = this.netlistN.getNetIndex(ai, j);
                if (netIndexN >= 0 && this.netlistN.hasNames(netIndexN)) {
                    netIndexN = -1;
                }
                if (netIndexN < 0 || this.drawnNames[drawn] == null) continue;
                if (this.drawnWidths[drawn] == 1) {
                    netName = this.drawnNames[drawn].toString();
                } else if (this.drawnNames[drawn].isTempname()) {
                    int busIndex = NetworkTool.isBusAscendingInNetlistEngine() ? j : this.drawnWidths[drawn] - 1 - j;
                    netName = this.drawnNames[drawn].toString() + "[" + busIndex + "]";
                } else {
                    netName = this.drawnNames[drawn].subname(j).toString();
                }
                if (netIndexN < 0) continue;
                this.netlistN.addTempName(netIndexN, netName);
            }
        }
        it2 = this.getNodables();
        while (it2.hasNext()) {
            Nodable no = (Nodable)it2.next();
            NodeProto np = no.getProto();
            int numPorts = np.getNumPorts();
            for (int i = 0; i < numPorts; ++i) {
                PortProto pp = np.getPort(i);
                int busWidth = pp.getNameKey().busWidth();
                for (int k = 0; k < busWidth; ++k) {
                    int netIndexN = this.netlistN.getNetIndex(no, pp, k);
                    if (netIndexN < 0 || this.netlistN.hasNames(netIndexN)) continue;
                    this.netlistN.addTempName(netIndexN, no.getName() + "." + pp.getNameKey().subname(k));
                }
            }
        }
        int numNodes = this.cell.getNumNodes();
        for (int n = 0; n < numNodes; ++n) {
            NodeInst ni = this.cell.getNode(n);
            NodeProto np = ni.getProto();
            int arraySize = ni.getNameKey().busWidth();
            int numPorts = np.getNumPorts();
            for (int i = 0; i < numPorts; ++i) {
                PortProto pp = np.getPort(i);
                int drawn = this.drawns[this.ni_pi[n] + i];
                if (drawn < 0) continue;
                int busWidth = pp.getNameKey().busWidth();
                int drawnWidth = this.drawnWidths[drawn];
                for (int l = 0; l < drawnWidth; ++l) {
                    int netIndexN = this.netlistN.getNetIndexByMap(this.drawnOffsets[drawn] + l);
                    if (netIndexN < 0 || this.netlistN.hasNames(netIndexN)) continue;
                    int arrayIndex = l / busWidth % arraySize;
                    int busIndex = l % busWidth;
                    this.netlistN.addTempName(netIndexN, ni.getNameKey().subname(arrayIndex) + "." + pp.getNameKey().subname(busIndex));
                }
            }
        }
        int numNetworks = this.netlistN.getNumNetworks();
        for (int i = 0; i < numNetworks; ++i) {
            assert (this.netlistN.hasNames(i));
            assert (this.netlistN.isExported(i) == i < this.netlistN.getNumExternalNetworks());
            if (!this.netlistN.isExported(i)) continue;
            int equivPortInd = this.netlistN.getEquivPortIndexByNetIndex(i);
            assert (equivPortInd >= 0 && equivPortInd < equivPortIndex);
        }
    }

    private boolean updateInterface() {
        boolean changed = false;
        for (int i = 0; i < this.equivPortsN.length; ++i) {
            if (this.equivPortsN[i] != this.netlistN.netMap[i]) {
                changed = true;
                this.equivPortsN[i] = this.netlistN.netMap[i];
            }
            if (this.equivPortsP[i] != this.netlistP.netMap[i]) {
                changed = true;
                this.equivPortsP[i] = this.netlistP.netMap[i];
            }
            if (this.equivPortsA[i] == this.netlistA.netMap[i]) continue;
            changed = true;
            this.equivPortsA[i] = this.netlistA.netMap[i];
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSchematic() {
        NetworkManager networkManager = this.networkManager;
        synchronized (networkManager) {
            Snapshot oldSnapshot = (Snapshot)this.expectedSnapshot.get();
            Snapshot newSnapshot = this.database.backup();
            if (oldSnapshot == newSnapshot) {
                return;
            }
            CellId cellId = this.cell.getId();
            assert (cellId.isIcon() || cellId.isSchematic());
            if (this.cellTree != newSnapshot.getCellTree(cellId) || this.mainSchemId != newSnapshot.getMainSchematics(cellId) || this.mainSchemId != cellId && this.mainSchemId != null && !this.eqExports.get(this.mainSchemId).equals(newSnapshot.getEquivExports(this.mainSchemId)) || !this.sameEqivPortsOfSubcells(newSnapshot, this.cell.getId())) {
                this.networkManager.startErrorLogging(this.cell);
                try {
                    this.exportNameMapOffsets = null;
                    this.makeDrawns();
                    this.initNetnames();
                    this.redoNetworks1();
                }
                finally {
                    this.networkManager.finishErrorLogging();
                }
                this.cellTree = newSnapshot.getCellTree(cellId);
                this.mainSchemId = newSnapshot.getMainSchematics(cellId);
                this.eqExports = new IdentityHashMap();
                if (this.mainSchemId != null) {
                    this.eqExports.put(this.mainSchemId, newSnapshot.getEquivExports(this.mainSchemId));
                }
                for (CellTree subTree : this.cellTree.getSubTrees()) {
                    CellId subCellId;
                    if (subTree == null || !(subCellId = subTree.top.cellRevision.d.cellId).isIcon() && !subCellId.isSchematic()) continue;
                    this.eqExports.put(subCellId, newSnapshot.getEquivExports(subCellId));
                }
            }
            this.expectedSnapshot = new WeakReference<Snapshot>(newSnapshot);
        }
    }

    private boolean sameEqivPortsOfSubcells(Snapshot newSnapshot, CellId cellId) {
        for (CellTree subTree : newSnapshot.getCellTree(cellId).getSubTrees()) {
            CellId subCellId;
            if (subTree == null || (!(subCellId = subTree.top.cellRevision.d.cellId).isIcon() ? !subCellId.isSchematic() : cellId.isSchematic() && newSnapshot.getCellGroupIndex(cellId) == newSnapshot.getCellGroupIndex(subCellId))) continue;
            if (newSnapshot.getEquivExports(subCellId).equals(this.eqExports.get(subCellId))) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean redoNetworks1() {
        int numPorts = this.cell.getNumPorts();
        if (this.portOffsets.length != numPorts + 1) {
            this.portOffsets = new int[numPorts + 1];
        }
        if (this.drawnNames == null || this.drawnNames.length != this.numDrawns) {
            this.drawnNames = new Name[this.numDrawns];
            this.drawnWidths = new int[this.numDrawns];
            this.drawnOffsets = new int[this.numDrawns];
        }
        this.calcDrawnWidths();
        boolean changed = this.initNodables();
        int mapSize = this.netNamesOffset + this.netNames.size();
        int[] netMapF = Netlist.initMap(mapSize);
        this.localConnections(netMapF);
        int[] netMapP = (int[])netMapF.clone();
        int[] netMapA = (int[])netMapF.clone();
        this.internalConnections(netMapF, netMapP, netMapA);
        this.buildNetworkLists(netMapF);
        assert (this.equivPortsP.length == this.equivPortsN.length);
        this.netlistP = new NetlistShorted(this.netlistN, Netlist.ShortResistors.PARASITIC, netMapP);
        assert (this.equivPortsA.length == this.equivPortsN.length);
        this.netlistA = new NetlistShorted(this.netlistN, Netlist.ShortResistors.ALL, netMapA);
        if (this.updateInterface()) {
            changed = true;
        }
        EquivalentSchematicExports eq2 = this.cell.getDatabase().backup().getEquivExports(this.cell.getId());
        assert (this.globals.equals(eq2.getGlobals()));
        assert (Arrays.equals(this.equivPortsN, eq2.getEquivPortsN()));
        assert (Arrays.equals(this.equivPortsP, eq2.getEquivPortsP()));
        assert (Arrays.equals(this.equivPortsA, eq2.getEquivPortsA()));
        return changed;
    }

    @Override
    boolean obsolete(Netlist netlist) {
        Netlist newNetlist = this.getNetlist(netlist.shortResistors);
        this.netlistP.expectedSnapshot = this.netlistA.expectedSnapshot = this.expectedSnapshot;
        this.netlistN.expectedSnapshot = this.netlistA.expectedSnapshot;
        return newNetlist != netlist;
    }

    private class IconInst {
        final NodeInst nodeInst;
        final boolean iconOfParent;
        final Nodable[] iconNodables;
        final int netMapOffset;
        final int numExtendedExports;
        final EquivalentSchematicExports eq;

        private IconInst(NodeInst nodeInst, int nodeOffset) {
            Cell proto = (Cell)nodeInst.getProto();
            assert (proto.isIcon() || proto.isSchematic());
            this.nodeInst = nodeInst;
            this.iconOfParent = nodeInst.isIconOfParent();
            this.iconNodables = this.iconOfParent ? null : new Nodable[nodeInst.getNameKey().busWidth()];
            this.netMapOffset = nodeOffset;
            this.eq = this.iconOfParent ? null : nodeInst.getDatabase().backup().getEquivExports(proto.getId());
            this.numExtendedExports = this.iconOfParent ? -1000000 : this.eq.implementation.numExpandedExports;
        }

        private int getNetMapOffset(Nodable proxy) {
            int arrayIndex = proxy.getNodableArrayIndex();
            assert (this.iconNodables[arrayIndex] == proxy);
            return this.netMapOffset + arrayIndex * this.numExtendedExports;
        }
    }
}

