/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeaOfGatesEngine {
    private static final boolean DEBUGSTEPS = false;
    protected static final boolean DEBUGFAILURE = false;
    static final boolean DEBUGLOOPS = false;
    private static final boolean FULLGRAIN = true;
    private static final double PERCENTLIMIT = 7.0;
    private static final double GRANULARITY = 1.0;
    private static final double GRAINSIZE = 1.0;
    private static final int COSTALTERNATINGMETAL = 100;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 15;
    private static final int COSTUNFAVORED = 10;
    private static final int COSTTURNING = 1;
    private static final int COSTOFFGRID = 15;
    protected SearchVertex svAborted = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    protected SearchVertex svExhausted = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    protected SearchVertex svLimited = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    protected Cell cell;
    private Rectangle2D cellBounds;
    private Technology tech;
    private Map<Layer, RTNode> metalTrees;
    private Map<Layer, RTNode> viaTrees;
    private Map<ArcInst, Integer> netIDs;
    private static int numMetalLayers;
    private Layer[] metalLayers;
    private Layer[] viaLayers;
    private ArcProto[] metalArcs;
    private boolean[] favorArcs;
    private boolean[] preventArcs;
    private MetalVias[] metalVias;
    private double[] worstMetalSurround;
    private double[] viaSurround;
    protected double totalWireLength;
    protected static volatile boolean firstFailure;
    protected boolean parallelDij;
    protected ErrorLogger errorLogger;

    public int routeIt(Job job, Cell cell, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesOptions prefs) {
        if (this.initializeDesignRules(cell, prefs)) {
            return 0;
        }
        EditingPreferences ep = cell.getEditingPreferences();
        ElapseTimer timer = ElapseTimer.createInstance().start();
        ElapseTimer debugTimer = ElapseTimer.createInstance().start();
        Job.getUserInterface().startProgressDialog("Routing " + arcsToRoute.size() + " nets", null);
        Job.getUserInterface().setProgressNote("Building blockage information...");
        this.errorLogger = ErrorLogger.newInstance("Routing (Sea of gates)");
        this.metalTrees = new HashMap<Layer, RTNode>();
        this.viaTrees = new HashMap<Layer, RTNode>();
        this.netIDs = new HashMap<ArcInst, Integer>();
        BlockageVisitor visitor = new BlockageVisitor(arcsToRoute);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
        this.addBlockagesAtPorts(arcsToRoute, prefs);
        ArrayList<NeededRoute> allRoutes = new ArrayList<NeededRoute>();
        int numBatches = arcsToRoute.size();
        RouteBatches[] routeBatches = new RouteBatches[numBatches];
        this.makeListOfRoutes(numBatches, routeBatches, allRoutes, arcsToRoute, prefs, ep);
        debugTimer.end();
        System.out.println("### debug time (initialize): " + debugTimer);
        boolean parallel = prefs.useParallelRoutes;
        this.parallelDij = prefs.useParallelFromToRoutes;
        firstFailure = true;
        this.totalWireLength = 0.0;
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        if (numberOfProcessors <= 1) {
            this.parallelDij = false;
        }
        int numberOfThreads = numberOfProcessors;
        if (this.parallelDij) {
            numberOfThreads /= 2;
        }
        if (!parallel) {
            numberOfThreads = 1;
        }
        if (numberOfThreads == 1) {
            parallel = false;
        }
        System.out.println("Sea-of-gates router finding " + allRoutes.size() + " paths on " + numBatches + " networks");
        if (parallel || this.parallelDij) {
            String message = "NOTE: System has " + numberOfProcessors + " processors so";
            if (parallel) {
                message = message + " routing " + numberOfThreads + " paths in parallel";
            }
            if (this.parallelDij) {
                if (parallel) {
                    message = message + " and";
                }
                message = message + " routing both directions of each path in parallel";
            }
            System.out.println(message);
        }
        Environment env = Environment.getThreadEnvironment();
        if (prefs.useSpecificNumberOfThreads) {
            numberOfThreads = prefs.numberOfThreads;
        }
        this.startRouting(numberOfThreads, allRoutes, routeBatches, env, ep, job);
        int numRoutedSegments = 0;
        int totalRoutes = allRoutes.size();
        for (int a = 0; a < totalRoutes; ++a) {
            NeededRoute nr = (NeededRoute)allRoutes.get(a);
            if (nr.winningWF != null && nr.winningWF.vertices != null) {
                ++routeBatches[nr.batchNumber].numRouted;
                ++numRoutedSegments;
                continue;
            }
            ++routeBatches[nr.batchNumber].numUnrouted;
        }
        int numFailedRoutes = 0;
        for (int b = 0; b < numBatches; ++b) {
            if (routeBatches[b] == null) continue;
            if (routeBatches[b].numUnrouted == 0) {
                for (ArcInst aiKill : routeBatches[b].unroutedArcs) {
                    if (!aiKill.isLinked()) continue;
                    aiKill.kill();
                }
                cell.killNodes(routeBatches[b].unroutedNodes);
                continue;
            }
            ++numFailedRoutes;
            List<PortInst> orderedPorts = routeBatches[b].orderedPorts;
            for (ArcInst aiKill : routeBatches[b].unroutedArcs) {
                int headPort = -1;
                int tailPort = -1;
                for (int i = 0; i < orderedPorts.size(); ++i) {
                    PortInst pi = orderedPorts.get(i);
                    if (aiKill.getHeadPortInst() == pi) {
                        headPort = i;
                        continue;
                    }
                    if (aiKill.getTailPortInst() != pi) continue;
                    tailPort = i;
                }
                if (headPort < 0 || tailPort < 0) continue;
                boolean allRouted = true;
                if (headPort > tailPort) {
                    int swap = headPort;
                    headPort = tailPort;
                    tailPort = swap;
                }
                for (NeededRoute nr : allRoutes) {
                    if (nr.batchNumber != b || nr.routeInBatch - 1 < headPort || nr.routeInBatch - 1 >= tailPort || nr.winningWF != null && nr.winningWF.vertices != null) continue;
                    allRouted = false;
                }
                if (!allRouted || !aiKill.isLinked()) continue;
                aiKill.kill();
            }
        }
        this.errorLogger.termLogging(true);
        timer.end();
        Job.getUserInterface().stopProgressDialog();
        System.out.println("Routed " + numRoutedSegments + " out of " + totalRoutes + " segments; total length of routed wires is " + TextUtils.formatDistance(this.totalWireLength) + "; took " + timer);
        if (numFailedRoutes > 0) {
            System.out.println("NOTE: " + numFailedRoutes + " nets were not routed");
        }
        return numRoutedSegments;
    }

    protected void doRouting(List<NeededRoute> allRoutes, RouteBatches[] routeBatches, Job job, Environment env, EditingPreferences ep) {
        int totalRoutes = allRoutes.size();
        for (int r = 0; r < totalRoutes; ++r) {
            if (job != null && job.checkAbort()) {
                System.out.println("Sea-of-gates routing aborted");
                break;
            }
            NeededRoute nr = allRoutes.get(r);
            Job.getUserInterface().setProgressValue(r * 100 / totalRoutes);
            String routeName = nr.routeName;
            if (routeBatches[nr.batchNumber].segsInBatch > 1) {
                routeName = routeName + " (" + nr.routeInBatch + " of " + routeBatches[nr.batchNumber].segsInBatch + ")";
            }
            Job.getUserInterface().setProgressNote("Network " + routeName);
            System.out.println("Routing network " + routeName + "...");
            this.findPath(nr, env, ep);
            if (nr.winningWF == null || nr.winningWF.vertices == null) continue;
            this.createRoute(nr);
        }
    }

    protected abstract void doRoutingParallel(int var1, List<NeededRoute> var2, RouteBatches[] var3, Environment var4, EditingPreferences var5);

    protected void startRouting(int numberOfThreads, List<NeededRoute> allRoutes, RouteBatches[] routeBatches, Environment env, EditingPreferences ep, Job job) {
        if (numberOfThreads >= 1) {
            this.doRoutingParallel(numberOfThreads, allRoutes, routeBatches, env, ep);
        } else {
            this.doRouting(allRoutes, routeBatches, job, env, ep);
        }
    }

    private boolean initializeDesignRules(Cell c, SeaOfGates.SeaOfGatesOptions prefs) {
        int i;
        this.cell = c;
        this.tech = this.cell.getTechnology();
        numMetalLayers = this.tech.getNumMetals();
        this.metalLayers = new Layer[numMetalLayers];
        this.metalArcs = new ArcProto[numMetalLayers];
        this.favorArcs = new boolean[numMetalLayers];
        this.preventArcs = new boolean[numMetalLayers];
        this.viaLayers = new Layer[numMetalLayers - 1];
        this.metalVias = new MetalVias[numMetalLayers - 1];
        for (int i2 = 0; i2 < numMetalLayers - 1; ++i2) {
            this.metalVias[i2] = new MetalVias();
        }
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            int layerIndex;
            Layer lay = it.next();
            if (!lay.getFunction().isMetal() || lay.isPseudoLayer() || (layerIndex = lay.getFunction().getLevel() - 1) >= numMetalLayers) continue;
            this.metalLayers[layerIndex] = lay;
        }
        boolean hasFavorites = false;
        Iterator<ArcProto> it2 = this.tech.getArcs();
        block2: while (it2.hasNext()) {
            ArcProto ap = it2.next();
            for (int i3 = 0; i3 < numMetalLayers; ++i3) {
                if (ap.getLayer(0) != this.metalLayers[i3]) continue;
                this.metalArcs[i3] = ap;
                this.favorArcs[i3] = prefs.isPrevented(ap);
                if (this.favorArcs[i3]) {
                    hasFavorites = true;
                }
                this.preventArcs[i3] = prefs.isPrevented(ap);
                continue block2;
            }
        }
        if (!hasFavorites) {
            for (int i4 = 0; i4 < numMetalLayers; ++i4) {
                this.favorArcs[i4] = true;
            }
        }
        Iterator<PrimitiveNode> it22 = this.tech.getNodes();
        block5: while (it22.hasNext()) {
            PrimitiveNode np = it22.next();
            if (np.isNotUsed() || !np.getFunction().isContact()) continue;
            ArcProto[] conns = np.getPort(0).getConnections();
            for (int i5 = 0; i5 < numMetalLayers - 1; ++i5) {
                if ((conns[0] != this.metalArcs[i5] || conns[1] != this.metalArcs[i5 + 1]) && (conns[1] != this.metalArcs[i5] || conns[0] != this.metalArcs[i5 + 1])) continue;
                this.metalVias[i5].addVia(np, 0);
                boolean square = true;
                boolean offCenter = false;
                NodeInst dummyNi = NodeInst.makeDummyInstance(np);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    Layer conLayer = conPoly.getLayer();
                    Layer.Function lFun = conLayer.getFunction();
                    if (lFun.isMetal()) {
                        Rectangle2D conRect = conPoly.getBounds2D();
                        if (conRect.getWidth() != conRect.getHeight()) {
                            square = false;
                        }
                        if (conRect.getCenterX() == 0.0 && conRect.getCenterY() == 0.0) continue;
                        offCenter = true;
                        continue;
                    }
                    if (!lFun.isContact()) continue;
                    this.viaLayers[i5] = conLayer;
                }
                if (offCenter) {
                    this.metalVias[i5].addVia(np, 90);
                    this.metalVias[i5].addVia(np, 180);
                    this.metalVias[i5].addVia(np, 270);
                    continue block5;
                }
                if (square) continue block5;
                this.metalVias[i5].addVia(np, 90);
                continue block5;
            }
        }
        for (int i6 = 0; i6 < numMetalLayers; ++i6) {
            if (this.metalLayers[i6] == null) {
                System.out.println("ERROR: Cannot find layer for Metal " + (i6 + 1));
                return true;
            }
            if (this.metalArcs[i6] == null) {
                System.out.println("ERROR: Cannot find arc for Metal " + (i6 + 1));
                return true;
            }
            if (i6 >= numMetalLayers - 1) continue;
            if (this.metalVias[i6].getVias().size() == 0) {
                System.out.println("ERROR: Cannot find contact node between Metal " + (i6 + 1) + " and Metal " + (i6 + 2));
                return true;
            }
            if (this.viaLayers[i6] != null) continue;
            System.out.println("ERROR: Cannot find contact layer between Metal " + (i6 + 1) + " and Metal " + (i6 + 2));
            return true;
        }
        this.worstMetalSurround = new double[numMetalLayers];
        GenMath.MutableDouble mutableDist = new GenMath.MutableDouble(0.0);
        for (i = 0; i < numMetalLayers; ++i) {
            if (!DRC.getMaxSurround(this.metalLayers[i], Double.MAX_VALUE, mutableDist)) continue;
            this.worstMetalSurround[i] = mutableDist.doubleValue();
        }
        this.viaSurround = new double[numMetalLayers - 1];
        for (i = 0; i < numMetalLayers - 1; ++i) {
            Layer lay = this.viaLayers[i];
            double spacing = 2.0;
            double arcWidth = this.metalArcs[i].getDefaultLambdaBaseWidth();
            DRCTemplate ruleSpacing = DRC.getSpacingRule(lay, null, lay, null, false, -1, arcWidth, 50.0);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            double width = 0.0;
            DRCTemplate ruleWidth = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                width = ruleWidth.getValue(0);
            }
            List<MetalVia> nps = this.metalVias[i].getVias();
            for (MetalVia mv : nps) {
                NodeInst dummyNi = NodeInst.makeDummyInstance(mv.via);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    if (!conPoly.getLayer().getFunction().isContact()) continue;
                    Rectangle2D bounds = conPoly.getBounds2D();
                    width = Math.max(width, bounds.getWidth());
                    width = Math.max(width, bounds.getHeight());
                }
            }
            this.viaSurround[i] = spacing + width;
        }
        return false;
    }

    protected void makeListOfRoutes(int numBatches, RouteBatches[] routeBatches, List<NeededRoute> allRoutes, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesOptions prefs, EditingPreferences ep) {
        this.doMakeListOfRoutes(0, numBatches, routeBatches, allRoutes, arcsToRoute, prefs);
    }

    protected void doMakeListOfRoutes(int start, int end, RouteBatches[] routeBatches, List<NeededRoute> allRoutes, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesOptions prefs) {
        for (int b = start; b < end; ++b) {
            List<Connection> netEnds;
            List<PortInst> orderedPorts;
            ArcInst ai = arcsToRoute.get(b);
            Netlist netList = this.cell.getNetlist();
            Network net = netList.getNetwork(ai, 0);
            if (net == null) {
                System.out.println("Arc " + ai.describe(false) + " has no network!");
                continue;
            }
            HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
            HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
            Map<Network, ArcInst[]> arcMap = null;
            if (this.cell.getView() != View.SCHEMATIC) {
                arcMap = netList.getArcInstsByNetwork();
            }
            if ((orderedPorts = this.makeOrderedPorts(net, netEnds = Routing.findNetEnds(net, arcMap, arcsToDelete, nodesToDelete, netList, true))) == null) {
                System.out.println("No valid connection points found on the network.");
                continue;
            }
            routeBatches[b] = new RouteBatches();
            routeBatches[b].unroutedArcs = arcsToDelete;
            routeBatches[b].unroutedNodes = nodesToDelete;
            routeBatches[b].orderedPorts = orderedPorts;
            routeBatches[b].segsInBatch = 0;
            double minWidth = this.getMinWidth(orderedPorts, prefs);
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null) {
                netID = netIDI - 1;
            }
            int batchNumber = 1;
            for (int i = 0; i < orderedPorts.size() - 1; ++i) {
                ArrayList<EPoint> lineList;
                ArrayList<PolyBase> polyList;
                String errorMsg;
                SOGBound block;
                ArrayList<Poly> polyList2;
                String errorMsg2;
                PortInst fromPi = orderedPorts.get(i);
                PortInst toPi = orderedPorts.get(i + 1);
                if (this.inValidPort(fromPi) || this.inValidPort(toPi)) continue;
                ArcProto fromArc = null;
                ArcProto[] fromArcs = fromPi.getPortProto().getBasePort().getConnections();
                for (int j = 0; j < fromArcs.length; ++j) {
                    if (!fromArcs[j].getFunction().isMetal()) continue;
                    fromArc = fromArcs[j];
                    break;
                }
                if (fromArc == null) {
                    String errorMsg3 = "Cannot connect port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " because it has no metal connection";
                    System.out.println("ERROR: " + errorMsg3);
                    ArrayList<Poly> polyList3 = new ArrayList<Poly>();
                    polyList3.add(fromPi.getPoly());
                    this.errorLogger.logMessage(errorMsg3, polyList3, this.cell, 0, true);
                    continue;
                }
                ArcProto toArc = null;
                ArcProto[] toArcs = toPi.getPortProto().getBasePort().getConnections();
                for (int j = 0; j < toArcs.length; ++j) {
                    if (!toArcs[j].getFunction().isMetal()) continue;
                    toArc = toArcs[j];
                    break;
                }
                if (toArc == null) {
                    errorMsg2 = "Cannot connect port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " because it has no metal connection";
                    System.out.println("ERROR: " + errorMsg2);
                    polyList2 = new ArrayList<Poly>();
                    polyList2.add(toPi.getPoly());
                    this.errorLogger.logMessage(errorMsg2, polyList2, this.cell, 0, true);
                    continue;
                }
                if (fromArc.getTechnology() != this.tech || toArc.getTechnology() != this.tech) {
                    errorMsg2 = "Route from port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " on arc " + fromArc.describe() + " cannot connect to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " on arc " + toArc.describe() + " because they have different technologies";
                    System.out.println("ERROR: " + errorMsg2);
                    polyList2 = new ArrayList();
                    Poly fromPoly = fromPi.getPoly();
                    Poly toPoly = toPi.getPoly();
                    polyList2.add(fromPoly);
                    polyList2.add(toPoly);
                    ArrayList<EPoint> lineList2 = new ArrayList<EPoint>();
                    lineList2.add(new EPoint(toPoly.getCenterX(), toPoly.getCenterY()));
                    lineList2.add(new EPoint(fromPoly.getCenterX(), fromPoly.getCenterY()));
                    this.errorLogger.logMessageWithLines(errorMsg2, polyList2, lineList2, this.cell, 0, true);
                    continue;
                }
                EPoint fromLoc = fromPi.getPoly().getCenter();
                EPoint toLoc = toPi.getPoly().getCenter();
                double fromX = fromLoc.getX();
                double fromY = fromLoc.getY();
                double toX = toLoc.getX();
                double toY = toLoc.getY();
                if (toLoc.getX() < fromLoc.getX()) {
                    toX = this.upToGrain(toLoc.getX());
                    fromX = this.downToGrain(fromLoc.getX());
                } else if (toLoc.getX() > fromLoc.getX()) {
                    toX = this.downToGrain(toLoc.getX());
                    fromX = this.upToGrain(fromLoc.getX());
                } else {
                    toX = fromX = this.upToGrain(fromLoc.getX());
                }
                if (toLoc.getY() < fromLoc.getY()) {
                    toY = this.upToGrain(toLoc.getY());
                    fromY = this.downToGrain(fromLoc.getY());
                } else if (toLoc.getY() > fromLoc.getY()) {
                    toY = this.downToGrain(toLoc.getY());
                    fromY = this.upToGrain(fromLoc.getY());
                } else {
                    toY = fromY = this.upToGrain(fromLoc.getY());
                }
                int fromZ = fromArc.getFunction().getLevel() - 1;
                int toZ = toArc.getFunction().getLevel() - 1;
                double metalSpacing = Math.max(this.metalArcs[fromZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0;
                Layer lay = this.metalLayers[fromZ];
                DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, this.metalArcs[fromZ].getDefaultLambdaBaseWidth(), -1.0);
                double surround = 0.0;
                if (rule != null) {
                    surround = rule.getValue(0);
                }
                if ((block = this.getMetalBlockage(netID, fromZ, metalSpacing, metalSpacing, surround, fromX, fromY)) != null && (block = this.getMetalBlockage(netID, fromZ, metalSpacing, metalSpacing, surround, fromX = fromLoc.getX(), fromY = fromLoc.getY())) != null) {
                    errorMsg = "Cannot Route to port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " at (" + TextUtils.formatDistance(fromX) + "," + TextUtils.formatDistance(fromY) + ") because it is blocked on layer " + this.metalLayers[fromZ].getName() + " [needs " + TextUtils.formatDistance(metalSpacing + surround) + " all around, blockage is " + TextUtils.formatDistance(block.bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(block.bound.getMaxX()) + " and " + TextUtils.formatDistance(block.bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.bound.getMaxY()) + "]";
                    System.out.println(errorMsg);
                    polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(fromX, fromY, (metalSpacing + surround) * 2.0, (metalSpacing + surround) * 2.0));
                    polyList.add(new PolyBase(block.bound));
                    lineList = new ArrayList<EPoint>();
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMinY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMinY()));
                    this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, this.cell, 0, true);
                    continue;
                }
                metalSpacing = Math.max(this.metalArcs[toZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0;
                lay = this.metalLayers[toZ];
                rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, this.metalArcs[toZ].getDefaultLambdaBaseWidth(), -1.0);
                surround = 0.0;
                if (rule != null) {
                    surround = rule.getValue(0);
                }
                if ((block = this.getMetalBlockage(netID, toZ, metalSpacing, metalSpacing, surround, toX, toY)) != null && (block = this.getMetalBlockage(netID, toZ, metalSpacing, metalSpacing, surround, toX = toLoc.getX(), toY = toLoc.getY())) != null) {
                    errorMsg = "Cannot route to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " at (" + TextUtils.formatDistance(toX) + "," + TextUtils.formatDistance(toY) + ") because it is blocked on layer " + this.metalLayers[toZ].getName() + " [needs " + TextUtils.formatDistance(metalSpacing + surround) + " all around, blockage is " + TextUtils.formatDistance(block.bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(block.bound.getMaxX()) + " and " + TextUtils.formatDistance(block.bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.bound.getMaxY()) + "]";
                    System.out.println("ERROR: " + errorMsg);
                    polyList = new ArrayList();
                    polyList.add(new PolyBase(toX, toY, (metalSpacing + surround) * 2.0, (metalSpacing + surround) * 2.0));
                    polyList.add(new PolyBase(block.bound));
                    lineList = new ArrayList();
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMinY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMinY()));
                    this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, this.cell, 0, true);
                    continue;
                }
                NeededRoute nr = new NeededRoute(net.getName(), fromPi, fromX, fromY, fromZ, toPi, toX, toY, toZ, netID, minWidth, b, batchNumber++, prefs);
                ++routeBatches[b].segsInBatch;
                allRoutes.add(nr);
            }
        }
    }

    private double getMinWidth(List<PortInst> orderedPorts, SeaOfGates.SeaOfGatesOptions prefs) {
        double minWidth = 0.0;
        for (PortInst pi : orderedPorts) {
            double widestAtPort = this.getWidestMetalArcOnPort(pi);
            if (!(widestAtPort > minWidth)) continue;
            minWidth = widestAtPort;
        }
        if (minWidth > prefs.maxArcWidth) {
            minWidth = prefs.maxArcWidth;
        }
        return minWidth;
    }

    private double getWidestMetalArcOnPort(PortInst pi) {
        Export export;
        PortInst exportedInst;
        double width2;
        double width = 0.0;
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (!ai.getProto().getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
            width = width2;
        }
        return width;
    }

    private boolean inValidPort(PortInst pi) {
        ArcProto[] conns = pi.getPortProto().getBasePort().getConnections();
        boolean valid = false;
        for (int j = 0; j < conns.length; ++j) {
            ArcProto ap = conns[j];
            if (ap.getTechnology() != this.tech || !ap.getFunction().isMetal() || this.preventArcs[conns[j].getFunction().getLevel() - 1]) continue;
            valid = true;
            break;
        }
        if (!valid) {
            System.out.println("Cannot connect to port " + pi.getPortProto().getName() + " on node " + pi.getNodeInst().describe(false) + " because all connecting layers have been prevented by Routing Preferences");
            return true;
        }
        return false;
    }

    private void addBlockagesAtPorts(List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesOptions prefs) {
        Netlist netList = this.cell.getNetlist();
        Map<Network, ArcInst[]> arcMap = null;
        if (this.cell.getView() != View.SCHEMATIC) {
            arcMap = netList.getArcInstsByNetwork();
        }
        for (ArcInst ai : arcsToRoute) {
            HashSet<NodeInst> nodesToDelete;
            HashSet<ArcInst> arcsToDelete;
            List<Connection> netEnds;
            Network net;
            List<PortInst> orderedPorts;
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null && (netID = -(netIDI - 1)) > 0) {
                System.out.println("INTERNAL ERROR! net=" + netID + " but should be negative");
            }
            if ((orderedPorts = this.makeOrderedPorts(net = netList.getNetwork(ai, 0), netEnds = Routing.findNetEnds(net, arcMap, arcsToDelete = new HashSet<ArcInst>(), nodesToDelete = new HashSet<NodeInst>(), netList, true))) == null) continue;
            double minWidth = this.getMinWidth(orderedPorts, prefs);
            for (PortInst pi : orderedPorts) {
                Poly poly = pi.getPoly();
                Rectangle2D polyBounds = poly.getBounds2D();
                ArcProto[] poss = pi.getPortProto().getBasePort().getConnections();
                int lowMetal = -1;
                int highMetal = -1;
                for (int i = 0; i < poss.length; ++i) {
                    if (poss[i].getTechnology() != this.tech || !poss[i].getFunction().isMetal()) continue;
                    int level = poss[i].getFunction().getLevel();
                    if (lowMetal < 0) {
                        lowMetal = highMetal = level;
                        continue;
                    }
                    lowMetal = Math.min(lowMetal, level);
                    highMetal = Math.max(highMetal, level);
                }
                if (lowMetal < 0) continue;
                for (int via = lowMetal - 2; via < highMetal; ++via) {
                    if (via < 0 || via >= numMetalLayers - 1) continue;
                    MetalVia mv = this.metalVias[via].getVias().get(0);
                    PrimitiveNode np = mv.via;
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst dummy = NodeInst.makeDummyInstance(np, EPoint.ORIGIN, wid, hei, Orientation.IDENT);
                    Poly[] polys = this.tech.getShapeOfNode(dummy);
                    for (int i = 0; i < polys.length; ++i) {
                        Poly viaPoly = polys[i];
                        Layer layer = viaPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        Rectangle2D viaBounds = viaPoly.getBounds2D();
                        Rectangle2D.Double bounds = new Rectangle2D.Double(viaBounds.getMinX() + polyBounds.getCenterX(), viaBounds.getMinY() + polyBounds.getCenterY(), viaBounds.getWidth(), viaBounds.getHeight());
                        this.addRectangle(bounds, layer, netID);
                    }
                }
            }
        }
    }

    private List<PortInst> makeOrderedPorts(Network net, List<Connection> netEnds) {
        ArrayList<PortInst> portEndList = new ArrayList<PortInst>();
        for (int i = 0; i < netEnds.size(); ++i) {
            PortInst pi = netEnds.get(i).getPortInst();
            if (!pi.getNodeInst().isCellInstance() && ((PrimitiveNode)pi.getNodeInst().getProto()).getTechnology() == Generic.tech() || portEndList.contains(pi)) continue;
            portEndList.add(pi);
        }
        int count2 = portEndList.size();
        if (count2 == 0) {
            return null;
        }
        if (count2 == 1) {
            System.out.println("Error: Network " + net.describe(false) + " has only one end");
            return null;
        }
        PortInst[] portEnds = new PortInst[count2];
        int k = 0;
        for (PortInst pi : portEndList) {
            portEnds[k++] = pi;
        }
        int closest1 = 0;
        int closest2 = 0;
        double closestDist = Double.MAX_VALUE;
        for (int i = 0; i < count2; ++i) {
            Poly poly1 = portEnds[i].getPoly();
            for (int j = i + 1; j < count2; ++j) {
                Poly poly2 = portEnds[j].getPoly();
                double dist = poly1.getCenter().distance(poly2.getCenter());
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closest1 = i;
                closest2 = j;
            }
        }
        ArrayList<PortInst> orderedPorts = new ArrayList<PortInst>();
        orderedPorts.add(portEnds[closest1]);
        orderedPorts.add(portEnds[closest2]);
        portEnds[closest1] = null;
        portEnds[closest2] = null;
        while (true) {
            boolean foundsome = false;
            double closestDist1 = Double.MAX_VALUE;
            double closestDist2 = Double.MAX_VALUE;
            for (int i = 0; i < count2; ++i) {
                if (portEnds[i] == null) continue;
                Poly poly = portEnds[i].getPoly();
                Poly poly1 = ((PortInst)orderedPorts.get(0)).getPoly();
                double dist1 = poly.getCenter().distance(poly1.getCenter());
                if (dist1 < closestDist1) {
                    closestDist1 = dist1;
                    closest1 = i;
                    foundsome = true;
                }
                Poly poly2 = ((PortInst)orderedPorts.get(orderedPorts.size() - 1)).getPoly();
                double dist2 = poly.getCenter().distance(poly2.getCenter());
                if (!(dist2 < closestDist2)) continue;
                closestDist2 = dist2;
                closest2 = i;
                foundsome = true;
            }
            if (!foundsome) break;
            if (closestDist1 < closestDist2) {
                orderedPorts.add(0, portEnds[closest1]);
                portEnds[closest1] = null;
                continue;
            }
            orderedPorts.add(portEnds[closest2]);
            portEnds[closest2] = null;
        }
        return orderedPorts;
    }

    protected void createRoute(NeededRoute nr) {
        Wavefront wf = nr.winningWF;
        PortInst lastPort = wf.to;
        Poly toPoly = wf.to.getPoly();
        if ((toPoly.getCenterX() != wf.toX || toPoly.getCenterY() != wf.toY) && wf.vertices.size() >= 2) {
            NodeInst ni;
            SearchVertex v1 = wf.vertices.get(0);
            SearchVertex v2 = wf.vertices.get(1);
            ArcProto type = this.metalArcs[wf.toZ];
            double width = Math.max(type.getDefaultLambdaBaseWidth(), nr.minWidth);
            PrimitiveNode np = this.metalArcs[wf.toZ].findPinProto();
            if (v1.getX() == v2.getX()) {
                ni = this.makeNodeInst(np, new EPoint(v1.getX(), toPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, nr.netID);
                this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.to, nr.netID);
                lastPort = ni.getOnlyPortInst();
            } else if (v1.getY() == v2.getY()) {
                ni = this.makeNodeInst(np, new EPoint(toPoly.getCenterX(), v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, nr.netID);
                this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.to, nr.netID);
                lastPort = ni.getOnlyPortInst();
            }
        }
        for (int i = 0; i < wf.vertices.size(); ++i) {
            SearchVertex sv = wf.vertices.get(i);
            boolean madeContacts = false;
            while (i < wf.vertices.size() - 1) {
                SearchVertex svNext = wf.vertices.get(i + 1);
                if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), svNext.getZ())].getVias();
                int whichContact = sv.getContactNo();
                MetalVia mv = nps.get(whichContact);
                PrimitiveNode np = mv.via;
                Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                SizeOffset so = np.getProtoSizeOffset();
                double xOffset = so.getLowXOffset() + so.getHighXOffset();
                double yOffset = so.getLowYOffset() + so.getHighYOffset();
                double wid = Math.max(np.getDefWidth() - xOffset, nr.minWidth) + xOffset;
                double hei = Math.max(np.getDefHeight() - yOffset, nr.minWidth) + yOffset;
                NodeInst ni = this.makeNodeInst(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient, this.cell, nr.netID);
                ArcProto type = this.metalArcs[sv.getZ()];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), nr.minWidth);
                this.makeArcInst(type, width, lastPort, ni.getOnlyPortInst(), nr.netID);
                lastPort = ni.getOnlyPortInst();
                madeContacts = true;
                sv = svNext;
                ++i;
            }
            if (madeContacts && i != wf.vertices.size() - 1) continue;
            PrimitiveNode np = this.metalArcs[sv.getZ()].findPinProto();
            PortInst pi = null;
            if (i == wf.vertices.size() - 1) {
                pi = wf.from;
                Poly fromPoly = wf.from.getPoly();
                if ((fromPoly.getCenterX() != sv.getX() || fromPoly.getCenterY() != sv.getY()) && wf.vertices.size() >= 2) {
                    PrimitiveNode pNp;
                    SearchVertex v1 = wf.vertices.get(wf.vertices.size() - 2);
                    SearchVertex v2 = wf.vertices.get(wf.vertices.size() - 1);
                    ArcProto type = this.metalArcs[wf.fromZ];
                    double width = Math.max(type.getDefaultLambdaBaseWidth(), nr.minWidth);
                    if (v1.getX() == v2.getX()) {
                        pNp = this.metalArcs[wf.fromZ].findPinProto();
                        NodeInst ni = this.makeNodeInst(pNp, new EPoint(v1.getX(), fromPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, nr.netID);
                        this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.from, nr.netID);
                        pi = ni.getOnlyPortInst();
                    } else if (v1.getY() == v2.getY()) {
                        pNp = this.metalArcs[wf.fromZ].findPinProto();
                        NodeInst ni = this.makeNodeInst(pNp, new EPoint(fromPoly.getCenterX(), v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, nr.netID);
                        this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.from, nr.netID);
                        pi = ni.getOnlyPortInst();
                    }
                }
            } else {
                NodeInst ni = this.makeNodeInst(np, new EPoint(sv.getX(), sv.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, nr.netID);
                pi = ni.getOnlyPortInst();
            }
            if (lastPort != null) {
                ArcProto type = this.metalArcs[sv.getZ()];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), nr.minWidth);
                this.makeArcInst(type, width, lastPort, pi, nr.netID);
            }
            lastPort = pi;
        }
        Rectangle2D.Double routeBounds = new Rectangle2D.Double(Math.min(wf.fromX, wf.toX), Math.min(wf.fromY, wf.toY), Math.abs(wf.fromX - wf.toX), Math.abs(wf.fromY - wf.toY));
        double lowX = routeBounds.getMinX();
        double highX = routeBounds.getMaxX();
        double lowY = routeBounds.getMinY();
        double highY = routeBounds.getMaxY();
        for (int i = 0; i < wf.vertices.size(); ++i) {
            SearchVertex sv = wf.vertices.get(i);
            if (i == 0) {
                lowX = highX = sv.getX();
                lowY = highY = sv.getY();
                continue;
            }
            if (sv.getX() < lowX) {
                lowX = sv.getX();
            }
            if (sv.getX() > highX) {
                highX = sv.getX();
            }
            if (sv.getY() < lowY) {
                lowY = sv.getY();
            }
            if (!(sv.getY() > highY)) continue;
            highY = sv.getY();
        }
    }

    protected static double getVertexLength(List<SearchVertex> vertices) {
        if (vertices == null) {
            return Double.MAX_VALUE;
        }
        if (vertices.size() == 0) {
            return Double.MAX_VALUE;
        }
        double sum2 = 0.0;
        SearchVertex last2 = null;
        for (SearchVertex sv : vertices) {
            if (last2 != null) {
                sum2 += Math.abs(sv.getX() - last2.getX()) + Math.abs(sv.getY() - last2.getY()) + (double)(Math.abs(sv.getZ() - last2.getZ()) * 10);
            }
            last2 = sv;
        }
        return sum2;
    }

    private NodeInst makeNodeInst(NodeProto np, EPoint loc, double wid, double hei, Orientation orient, Cell cell, int netID) {
        NodeInst ni = NodeInst.makeInstance(np, loc, wid, hei, cell, orient, null);
        if (ni != null) {
            AffineTransform trans = ni.rotateOut();
            Poly[] nodeInstPolyList = this.tech.getShapeOfNode(ni, true, false, null);
            for (int i = 0; i < nodeInstPolyList.length; ++i) {
                Poly poly = nodeInstPolyList[i];
                if (poly.getPort() == null) continue;
                ((PolyBase)poly).transform(trans);
                this.addLayer(poly, GenMath.MATID, netID, false);
            }
        }
        return ni;
    }

    private ArcInst makeArcInst(ArcProto type, double wid, PortInst from2, PortInst to2, int netID) {
        ArcInst ai = ArcInst.makeInstanceBase(type, wid, from2, to2);
        if (ai != null) {
            Poly[] polys = this.tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                this.addLayer(polys[i], GenMath.MATID, netID, false);
            }
            Poly fromPoly = from2.getPoly();
            Poly toPoly = to2.getPoly();
            double length = fromPoly.getCenter().distance(toPoly.getCenter());
            this.totalWireLength += length;
        }
        return ai;
    }

    protected void findPath(NeededRoute nr, Environment env, EditingPreferences ep) {
        Wavefront d1 = nr.dir1;
        if (DBMath.areEquals(d1.toX, d1.fromX) && DBMath.areEquals(d1.toY, d1.fromY) && d1.toZ == d1.fromZ) {
            nr.winningWF = d1;
            nr.winningWF.vertices = new ArrayList<SearchVertex>();
            SearchVertex sv = new SearchVertex(d1.toX, d1.toY, d1.toZ, 0, null, 0, nr.winningWF);
            nr.winningWF.vertices.add(sv);
            nr.cleanSearchMemory();
            return;
        }
        if (this.parallelDij) {
            Semaphore outSem = new Semaphore(0);
            new DijkstraInThread("Route a->b", nr.dir1, nr.dir2, outSem, env, ep);
            new DijkstraInThread("Route b->a", nr.dir2, nr.dir1, outSem, env, ep);
            outSem.acquireUninterruptibly(2);
        } else {
            this.doTwoWayDijkstra(nr);
        }
        Wavefront wf = nr.winningWF;
        double verLength = Double.MAX_VALUE;
        if (wf != null) {
            verLength = SeaOfGatesEngine.getVertexLength(wf.vertices);
        }
        if (verLength == Double.MAX_VALUE) {
            if (wf == null) {
                wf = nr.dir1;
            }
            String errorMsg = wf.vertices == null ? "Search too complex (exceeds complexity limit of " + nr.prefs.complexityLimit + " steps)" : "Failed to route from port " + wf.from.getPortProto().getName() + " of node " + wf.from.getNodeInst().describe(false) + " to port " + wf.to.getPortProto().getName() + " of node " + wf.to.getNodeInst().describe(false);
            System.out.println("ERROR: " + errorMsg);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(wf.toX, wf.toY));
            lineList.add(new EPoint(wf.fromX, wf.fromY));
            this.errorLogger.logMessageWithLines(errorMsg, null, lineList, this.cell, 0, true);
        }
        nr.cleanSearchMemory();
    }

    protected void doTwoWayDijkstra(NeededRoute nr) {
        SearchVertex result2 = null;
        int numSearchVertices = 0;
        while (result2 == null) {
            if (++numSearchVertices > nr.prefs.complexityLimit) {
                return;
            }
            SearchVertex resultA = this.advanceWavefront(nr.dir1);
            SearchVertex resultB = this.advanceWavefront(nr.dir2);
            if (resultA == null && resultB == null) continue;
            result2 = resultA;
            nr.winningWF = nr.dir1;
            if (result2 != null && result2 != this.svExhausted) continue;
            result2 = resultB;
            nr.winningWF = nr.dir2;
        }
        if (result2 == this.svAborted || result2 == this.svExhausted) {
            nr.winningWF = null;
            return;
        }
        List<SearchVertex> realVertices = this.getOptimizedList(result2);
        nr.winningWF.vertices = realVertices;
    }

    SearchVertex advanceWavefront(Wavefront wf) {
        if (wf.active.size() == 0) {
            return this.svExhausted;
        }
        SearchVertex svCurrent = (SearchVertex)wf.active.first();
        wf.active.remove(svCurrent);
        double curX = svCurrent.getX();
        double curY = svCurrent.getY();
        int curZ = svCurrent.getZ();
        if (wf.debug) {
            System.out.print("AT (" + TextUtils.formatDouble(curX) + "," + TextUtils.formatDouble(curY) + ",M" + (curZ + 1) + ")C=" + svCurrent.cost + " WENT");
        }
        block16: for (int i = 0; i < 6; ++i) {
            double inc;
            boolean foundDest;
            double dx = 0.0;
            double dy = 0.0;
            int dz = 0;
            switch (i) {
                case 0: {
                    dx = -1.0;
                    double intermediate = this.upToGrainAlways(curX + dx);
                    if (intermediate == curX + dx) break;
                    dx = intermediate - curX;
                    break;
                }
                case 1: {
                    dx = 1.0;
                    double intermediate = this.downToGrainAlways(curX + dx);
                    if (intermediate == curX + dx) break;
                    dx = intermediate - curX;
                    break;
                }
                case 2: {
                    dy = -1.0;
                    double intermediate = this.upToGrainAlways(curY + dy);
                    if (intermediate == curY + dy) break;
                    dy = intermediate - curY;
                    break;
                }
                case 3: {
                    dy = 1.0;
                    double intermediate = this.downToGrainAlways(curY + dy);
                    if (intermediate == curY + dy) break;
                    dy = intermediate - curY;
                    break;
                }
                case 4: {
                    dz = -1;
                    break;
                }
                case 5: {
                    dz = 1;
                }
            }
            boolean stuck = false;
            if (dz == 0) {
                boolean goFarther = false;
                if (dx != 0.0) {
                    if ((wf.toX - curX) * dx > 0.0) {
                        goFarther = true;
                    }
                } else if ((wf.toY - curY) * dy > 0.0) {
                    goFarther = true;
                }
                if (goFarther) {
                    double jumpSize = this.getJumpSize(curX, curY, curZ, dx, dy, wf);
                    if (dx > 0.0) {
                        if (jumpSize <= 0.0) {
                            stuck = true;
                        }
                        dx = jumpSize;
                    }
                    if (dx < 0.0) {
                        if (jumpSize >= 0.0) {
                            stuck = true;
                        }
                        dx = jumpSize;
                    }
                    if (dy > 0.0) {
                        if (jumpSize <= 0.0) {
                            stuck = true;
                        }
                        dy = jumpSize;
                    }
                    if (dy < 0.0) {
                        if (jumpSize >= 0.0) {
                            stuck = true;
                        }
                        dy = jumpSize;
                    }
                }
            }
            double nX = curX + dx;
            double nY = curY + dy;
            int nZ = curZ + dz;
            if (wf.debug) {
                switch (i) {
                    case 0: {
                        System.out.print("  X-" + TextUtils.formatDouble(Math.abs(dx)));
                        break;
                    }
                    case 1: {
                        System.out.print("  X+" + TextUtils.formatDouble(dx));
                        break;
                    }
                    case 2: {
                        System.out.print("  Y-" + TextUtils.formatDouble(Math.abs(dy)));
                        break;
                    }
                    case 3: {
                        System.out.print("  Y+" + TextUtils.formatDouble(dy));
                        break;
                    }
                    case 4: {
                        System.out.print("  -Z");
                        break;
                    }
                    case 5: {
                        System.out.print("  +Z");
                    }
                }
            }
            if (stuck) {
                if (!wf.debug) continue;
                System.out.print(":CannotMove");
                continue;
            }
            if (nX < wf.nr.minimumSearchBoundX && (dx = (nX = wf.nr.minimumSearchBoundX) - curX) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nX > wf.nr.maximumSearchBoundX && (dx = (nX = wf.nr.maximumSearchBoundX) - curX) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nY < wf.nr.minimumSearchBoundY && (dy = (nY = wf.nr.minimumSearchBoundY) - curY) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nY > wf.nr.maximumSearchBoundY && (dy = (nY = wf.nr.maximumSearchBoundY) - curY) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nZ < 0 || nZ >= numMetalLayers) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (this.preventArcs[nZ]) {
                if (!wf.debug) continue;
                System.out.print(":IllegalArc");
                continue;
            }
            if (wf.getVertex(nX, nY, nZ)) {
                if (!wf.debug) continue;
                System.out.print(":AlreadyVisited");
                continue;
            }
            int whichContact = 0;
            Point2D[] cuts = null;
            if (dz == 0) {
                double width = Math.max(this.metalArcs[nZ].getDefaultLambdaBaseWidth(), wf.nr.minWidth);
                double metalSpacing = width / 2.0;
                boolean allClear = false;
                while (true) {
                    double newNY;
                    double newNX;
                    SOGBound sb;
                    SearchVertex prevPath = svCurrent;
                    double checkX = (curX + nX) / 2.0;
                    double checkY = (curY + nY) / 2.0;
                    double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                    double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                    while (prevPath != null && prevPath.last != null && prevPath.zv == nZ && prevPath.last.zv == nZ) {
                        if (prevPath.xv == prevPath.last.xv && dx == 0.0) {
                            checkY = (prevPath.last.yv + nY) / 2.0;
                            halfHei = metalSpacing + Math.abs(prevPath.last.yv - nY) / 2.0;
                            prevPath = prevPath.last;
                            continue;
                        }
                        if (prevPath.yv != prevPath.last.yv || dy != 0.0) break;
                        checkX = (prevPath.last.xv + nX) / 2.0;
                        halfWid = metalSpacing + Math.abs(prevPath.last.xv - nX) / 2.0;
                        prevPath = prevPath.last;
                    }
                    if ((sb = this.getMetalBlockageAndNotch(wf, nZ, halfWid, halfHei, checkX, checkY, prevPath)) == null) {
                        allClear = true;
                        break;
                    }
                    if (i == 0) {
                        newNX = this.downToGrainAlways(nX + 1.0);
                        if (newNX >= curX) break;
                        dx = newNX - curX;
                    } else if (i == 1) {
                        newNX = this.upToGrainAlways(nX - 1.0);
                        if (newNX <= curX) break;
                        dx = newNX - curX;
                    } else if (i == 2) {
                        double newDY;
                        newNY = this.downToGrainAlways(nY + 1.0);
                        if (newNY >= curY) break;
                        dy = newDY = newNY - curY;
                    } else if (i == 3) {
                        newNY = this.upToGrainAlways(nY - 1.0);
                        if (newNY <= curY) break;
                        dy = newNY - curY;
                    }
                    nX = curX + dx;
                    nY = curY + dy;
                }
                if (!allClear) {
                    double surround;
                    double halfHei;
                    if (!wf.debug) continue;
                    double checkX = (curX + nX) / 2.0;
                    double checkY = (curY + nY) / 2.0;
                    double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                    SOGBound sb = this.getMetalBlockage(wf.nr.netID, nZ, halfWid, halfHei = metalSpacing + Math.abs(dy) / 2.0, surround = this.worstMetalSurround[nZ], checkX, checkY);
                    if (sb != null) {
                        System.out.print(":Blocked");
                        continue;
                    }
                    System.out.print(":BlockedNotch");
                    continue;
                }
            } else {
                int lowMetal = Math.min(curZ, nZ);
                int highMetal = Math.max(curZ, nZ);
                List<MetalVia> nps = this.metalVias[lowMetal].getVias();
                whichContact = -1;
                for (int contactNo = 0; contactNo < nps.size(); ++contactNo) {
                    MetalVia mv = nps.get(contactNo);
                    PrimitiveNode np = mv.via;
                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                    SizeOffset so = np.getProtoSizeOffset();
                    double conWid = Math.max(np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset(), wf.nr.minWidth) + so.getLowXOffset() + so.getHighXOffset();
                    double conHei = Math.max(np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset(), wf.nr.minWidth) + so.getLowYOffset() + so.getHighYOffset();
                    NodeInst dummyNi = NodeInst.makeDummyInstance(np, new EPoint(nX, nY), conWid, conHei, orient);
                    Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                    AffineTransform trans = null;
                    if (orient != Orientation.IDENT) {
                        trans = dummyNi.rotateOut();
                    }
                    int cutCount = 0;
                    for (int p = 0; p < conPolys.length; ++p) {
                        if (!conPolys[p].getLayer().getFunction().isContact()) continue;
                        ++cutCount;
                    }
                    Point2D[] curCuts = new Point2D[cutCount];
                    cutCount = 0;
                    boolean failed = false;
                    for (int p = 0; p < conPolys.length; ++p) {
                        SearchVertex lastSv;
                        double conCY;
                        Rectangle2D conRect;
                        Layer conLayer;
                        Layer.Function lFun;
                        Poly conPoly = conPolys[p];
                        if (trans != null) {
                            conPoly.transform(trans);
                        }
                        if ((lFun = (conLayer = conPoly.getLayer()).getFunction()).isMetal()) {
                            double halfHei;
                            double halfWid;
                            conRect = conPoly.getBounds2D();
                            int metalNo = lFun.getLevel() - 1;
                            if (this.getMetalBlockageAndNotch(wf, metalNo, halfWid = conRect.getWidth() / 2.0, halfHei = conRect.getHeight() / 2.0, conRect.getCenterX(), conRect.getCenterY(), svCurrent) == null) continue;
                            failed = true;
                            break;
                        }
                        if (!lFun.isContact()) continue;
                        double surround = this.viaSurround[lowMetal];
                        conRect = conPoly.getBounds2D();
                        double conCX = conRect.getCenterX();
                        if (this.getViaBlockage(wf.nr.netID, conLayer, surround, surround, conCX, conCY = conRect.getCenterY()) != null) {
                            failed = true;
                            break;
                        }
                        curCuts[cutCount++] = new Point2D.Double(conCX, conCY);
                        SearchVertex sv = svCurrent;
                        while (sv != null && (lastSv = sv.last) != null) {
                            if (Math.min(sv.getZ(), lastSv.getZ()) == lowMetal && Math.max(sv.getZ(), lastSv.getZ()) == highMetal) {
                                Point2D[] svCuts = sv.getCutLayer() == lowMetal ? sv.getCuts() : lastSv.getCuts();
                                if (svCuts != null) {
                                    for (Point2D cutPt : svCuts) {
                                        if (Math.abs(cutPt.getX() - conCX) >= surround || Math.abs(cutPt.getY() - conCY) >= surround) continue;
                                        failed = true;
                                        break;
                                    }
                                }
                                if (failed) break;
                            }
                            sv = sv.last;
                        }
                        if (failed) break;
                    }
                    if (failed) continue;
                    whichContact = contactNo;
                    cuts = curCuts;
                    break;
                }
                if (whichContact < 0) {
                    if (!wf.debug) continue;
                    System.out.print(":Blocked");
                    continue;
                }
            }
            SearchVertex svNext = new SearchVertex(nX, nY, nZ, whichContact, cuts, Math.min(curZ, nZ), wf);
            svNext.last = svCurrent;
            boolean bl = foundDest = DBMath.areEquals(nX, wf.toX) && DBMath.areEquals(nY, wf.toY);
            if (foundDest && nZ == wf.toZ) {
                if (wf.debug) {
                    System.out.print(":FoundDestination");
                }
                return svNext;
            }
            svNext.cost = svCurrent.cost;
            if (dx != 0.0) {
                if (wf.toX == curX) {
                    svNext.cost += 7;
                } else if ((wf.toX - curX) * dx < 0.0) {
                    svNext.cost += 15;
                }
                if (nZ % 2 == 0) {
                    int c = 100 * (int)Math.abs(dx) / (int)this.cellBounds.getWidth();
                    svNext.cost += c;
                }
            }
            if (dy != 0.0) {
                if (wf.toY == curY) {
                    svNext.cost += 7;
                } else if ((wf.toY - curY) * dy < 0.0) {
                    svNext.cost += 15;
                }
                if (nZ % 2 != 0) {
                    int c = 100 * (int)Math.abs(dy) / (int)this.cellBounds.getHeight();
                    svNext.cost += c;
                }
            }
            if (dz != 0) {
                if (wf.toZ == curZ) {
                    svNext.cost += 8;
                } else if ((wf.toZ - curZ) * dz < 0) {
                    svNext.cost += 120;
                }
            } else {
                double jumpSize1 = Math.abs(this.getJumpSize(nX, nY, nZ, dx, dy, wf));
                double jumpSize2 = Math.abs(this.getJumpSize(curX, curY, curZ, -dx, -dy, wf));
                if (jumpSize1 > 1.0 && jumpSize2 > 1.0) {
                    svNext.cost = (int)((double)svNext.cost + jumpSize1 * jumpSize2 / 10.0);
                }
                if (svCurrent.last != null) {
                    boolean xTurn = svCurrent.getX() != svCurrent.last.getX();
                    boolean yTurn = svCurrent.getY() != svCurrent.last.getY();
                    if (xTurn != (dx != 0.0) || yTurn != (dy != 0.0)) {
                        svNext.cost += 1;
                    }
                }
            }
            if (!this.favorArcs[nZ]) {
                svNext.cost = (int)((double)svNext.cost + ((double)(80 * Math.abs(dz)) + 10.0 * Math.abs(dx + dy)));
            }
            if (this.downToGrainAlways(nX) != nX && nX != wf.toX) {
                svNext.cost += 15;
            }
            if (this.downToGrainAlways(nY) != nY && nY != wf.toY) {
                svNext.cost += 15;
            }
            wf.setVertex(nX, nY, nZ);
            wf.active.add(svNext);
            if (wf.debug) {
                System.out.print("(" + TextUtils.formatDouble(svNext.getX()) + "," + TextUtils.formatDouble(svNext.getY()) + ",M" + (svNext.getZ() + 1) + ")C=" + svNext.cost);
            }
            if (dz != 0) continue;
            if (Math.abs(dx) > 1.0) {
                inc = dx < 0.0 ? 1.0 : -1.0;
                double lessDX = dx + inc;
                int cost = svNext.cost;
                int countDown = 0;
                while (true) {
                    double nowX = curX + lessDX;
                    ++cost;
                    if (!wf.getVertex(nowX, nY, nZ)) {
                        SearchVertex svIntermediate = new SearchVertex(nowX, nY, nZ, whichContact, cuts, curZ, wf);
                        svIntermediate.last = svCurrent;
                        svIntermediate.cost = cost;
                        wf.setVertex(nowX, nY, nZ);
                        wf.active.add(svIntermediate);
                    }
                    if (!(inc < 0.0) ? lessDX > -1.0 : (lessDX += inc) < 1.0) break;
                    if (countDown++ < 10) continue;
                    countDown = 0;
                    inc += inc;
                }
            }
            if (!(Math.abs(dy) > 1.0)) continue;
            inc = dy < 0.0 ? 1.0 : -1.0;
            double lessDY = dy + inc;
            int cost = svNext.cost;
            int countDown = 0;
            while (true) {
                double nowY = curY + lessDY;
                ++cost;
                if (!wf.getVertex(nX, nowY, nZ)) {
                    SearchVertex svIntermediate = new SearchVertex(nX, nowY, nZ, whichContact, cuts, curZ, wf);
                    svIntermediate.last = svCurrent;
                    svIntermediate.cost = cost;
                    wf.setVertex(nX, nowY, nZ);
                    wf.active.add(svIntermediate);
                }
                if (!(inc < 0.0) ? lessDY > -1.0 : (lessDY += inc) < 1.0) continue block16;
                if (countDown++ < 10) continue;
                countDown = 0;
                inc += inc;
            }
        }
        if (wf.debug) {
            System.out.println();
        }
        return null;
    }

    List<SearchVertex> getOptimizedList(SearchVertex initialThread) {
        ArrayList<SearchVertex> realVertices = new ArrayList<SearchVertex>();
        SearchVertex thread = initialThread;
        if (thread != null) {
            SearchVertex lastVertex = thread;
            realVertices.add(lastVertex);
            thread = thread.last;
            while (thread != null) {
                if (lastVertex.getZ() != thread.getZ()) {
                    realVertices.add(thread);
                    lastVertex = thread;
                    thread = thread.last;
                    continue;
                }
                double dx = thread.getX() - lastVertex.getX();
                double dy = thread.getY() - lastVertex.getY();
                lastVertex = thread;
                thread = thread.last;
                while (!(thread == null || lastVertex.getZ() != thread.getZ() || thread.getX() - lastVertex.getX() != 0.0 && dx == 0.0 || thread.getY() - lastVertex.getY() != 0.0 && dy == 0.0)) {
                    lastVertex = thread;
                    thread = thread.last;
                }
                realVertices.add(lastVertex);
            }
        }
        return realVertices;
    }

    private double getJumpSize(double curX, double curY, int curZ, double dx, double dy, Wavefront wf) {
        Rectangle2D jumpBound = wf.nr.jumpBound;
        double width = Math.max(this.metalArcs[curZ].getDefaultLambdaBaseWidth(), wf.nr.minWidth);
        double metalToMetal = wf.getSpacingRule(curZ, width, -1.0);
        double metalSpacing = width / 2.0 + metalToMetal;
        double lX = curX - metalSpacing;
        double hX = curX + metalSpacing;
        double lY = curY - metalSpacing;
        double hY = curY + metalSpacing;
        if (dx > 0.0) {
            hX = jumpBound.getMaxX() + metalSpacing;
        } else if (dx < 0.0) {
            lX = jumpBound.getMinX() - metalSpacing;
        } else if (dy > 0.0) {
            hY = jumpBound.getMaxY() + metalSpacing;
        } else if (dy < 0.0) {
            lY = jumpBound.getMinY() - metalSpacing;
        }
        RTNode rtree = this.metalTrees.get(this.metalLayers[curZ]);
        if (rtree != null) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
            RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
            while (sea.hasNext()) {
                Rectangle2D bound;
                SOGBound sBound = (SOGBound)sea.next();
                if (Math.abs(sBound.getNetID()) == wf.nr.netID || (bound = sBound.getBounds()).getMinX() >= hX || bound.getMaxX() <= lX || bound.getMinY() >= hY || bound.getMaxY() <= lY) continue;
                if (dx > 0.0 && bound.getMinX() < hX) {
                    hX = bound.getMinX();
                }
                if (dx < 0.0 && bound.getMaxX() > lX) {
                    lX = bound.getMaxX();
                }
                if (dy > 0.0 && bound.getMinY() < hY) {
                    hY = bound.getMinY();
                }
                if (!(dy < 0.0) || !(bound.getMaxY() > lY)) continue;
                lY = bound.getMaxY();
            }
        }
        if (dx > 0.0) {
            dx = this.downToGrain(hX - metalSpacing) - curX;
            if (curX + dx > wf.toX && curY == wf.toY && curZ == wf.toZ) {
                dx = wf.toX - curX;
            }
            if (curX + dx != wf.toX) {
                dx = this.downToGrainAlways(hX - metalSpacing) - curX;
            }
            return dx;
        }
        if (dx < 0.0) {
            dx = this.upToGrain(lX + metalSpacing) - curX;
            if (curX + dx < wf.toX && curY == wf.toY && curZ == wf.toZ) {
                dx = wf.toX - curX;
            }
            if (curX + dx != wf.toX) {
                dx = this.upToGrainAlways(lX + metalSpacing) - curX;
            }
            return dx;
        }
        if (dy > 0.0) {
            dy = this.downToGrain(hY - metalSpacing) - curY;
            if (curX == wf.toX && curY + dy > wf.toY && curZ == wf.toZ) {
                dy = wf.toY - curY;
            }
            if (curY + dy != wf.toY) {
                dy = this.downToGrainAlways(hY - metalSpacing) - curY;
            }
            return dy;
        }
        if (dy < 0.0) {
            dy = this.upToGrain(lY + metalSpacing) - curY;
            if (curX == wf.toX && curY + dy < wf.toY && curZ == wf.toZ) {
                dy = wf.toY - curY;
            }
            if (curY + dy != wf.toY) {
                dy = this.upToGrainAlways(lY + metalSpacing) - curY;
            }
            return dy;
        }
        return 0.0;
    }

    private double upToGrain(double v) {
        return v;
    }

    private double upToGrainAlways(double v) {
        return Math.ceil(v * 1.0) * 1.0;
    }

    private double downToGrain(double v) {
        return v;
    }

    private double downToGrainAlways(double v) {
        return Math.floor(v * 1.0) * 1.0;
    }

    private SOGBound getMetalBlockageAndNotch(Wavefront wf, int metNo, double halfWidth, double halfHeight, double x, double y, SearchVertex svCurrent) {
        Layer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        int netID = wf.nr.netID;
        double minWidth = wf.nr.minWidth;
        double metLX = x - halfWidth;
        double metHX = x + halfWidth;
        double metLY = y - halfHeight;
        double metHY = y + halfHeight;
        Rectangle2D.Double metBound = new Rectangle2D.Double(metLX, metLY, metHX - metLX, metHY - metLY);
        double metWid = Math.min(halfWidth, halfHeight) * 2.0;
        double metLen = Math.max(halfWidth, halfHeight) * 2.0;
        double surround = this.worstMetalSurround[metNo];
        double lX = metLX - surround;
        double hX = metHX + surround;
        double lY = metLY - surround;
        double hY = metHY + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        ArrayList<Rectangle2D> recsOnPath = new ArrayList<Rectangle2D>();
        if (svCurrent != null) {
            List<SearchVertex> svList = this.getOptimizedList(svCurrent);
            for (int ind = 1; ind < svList.size(); ++ind) {
                Poly poly;
                Rectangle2D bound;
                SearchVertex sv = svList.get(ind);
                SearchVertex lastSv = svList.get(ind - 1);
                if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                if (sv.getZ() != lastSv.getZ()) {
                    List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                    int whichContact = lastSv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst ni = NodeInst.makeDummyInstance(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient);
                    AffineTransform trans = null;
                    if (orient != Orientation.IDENT) {
                        trans = ni.rotateOut();
                    }
                    Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                    for (int i = 0; i < polys.length; ++i) {
                        Rectangle2D bound2;
                        Poly poly2 = polys[i];
                        if (poly2.getLayer() != layer) continue;
                        if (trans != null) {
                            poly2.transform(trans);
                        }
                        if ((bound2 = poly2.getBounds2D()).getMaxX() <= lX || bound2.getMinX() >= hX || bound2.getMaxY() <= lY || bound2.getMinY() >= hY) continue;
                        recsOnPath.add(bound2);
                    }
                    continue;
                }
                ArcProto type = this.metalArcs[metNo];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                Point2D.Double head2 = new Point2D.Double(sv.getX(), sv.getY());
                Point2D.Double tail2 = new Point2D.Double(lastSv.getX(), lastSv.getY());
                int ang = 0;
                if (((Point2D)head2).getX() != ((Point2D)tail2).getX() || ((Point2D)head2).getY() != ((Point2D)tail2).getY()) {
                    ang = GenMath.figureAngle(tail2, head2);
                }
                if ((bound = (poly = Poly.makeEndPointPoly(head2.distance(tail2), width, ang, head2, width / 2.0, tail2, width / 2.0, Poly.Type.FILLED)).getBounds2D()).getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                recsOnPath.add(bound);
            }
        }
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            Rectangle2D.Double drcArea;
            PolyBase poly;
            SOGBound sBound = (SOGBound)sea.next();
            Rectangle2D bound = sBound.getBounds();
            if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
            double drWid = Math.max(Math.min(bound.getWidth(), bound.getHeight()), metWid);
            double drLen = Math.max(Math.max(bound.getWidth(), bound.getHeight()), metLen);
            double spacing = wf.getSpacingRule(metNo, drWid, drLen);
            double lXAllow = metLX - spacing;
            double hXAllow = metHX + spacing;
            double lYAllow = metLY - spacing;
            double hYAllow = metHY + spacing;
            if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lXAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hXAllow) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lYAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hYAllow)) continue;
            if (Math.abs(sBound.getNetID()) == netID) {
                if (sBound.getNetID() < 0 || !this.foundANotch(rtree, metBound, sBound.bound, netID, recsOnPath, spacing)) continue;
                return sBound;
            }
            if (sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(drcArea = new Rectangle2D.Double(lXAllow, lYAllow, hXAllow - lXAllow, hYAllow - lYAllow))) continue;
            return sBound;
        }
        if (svCurrent != null) {
            double spacing = wf.getSpacingRule(metNo, metWid, metLen);
            List<SearchVertex> svList = this.getOptimizedList(svCurrent);
            for (int ind = 1; ind < svList.size(); ++ind) {
                Poly poly;
                Rectangle2D bound;
                SearchVertex sv = svList.get(ind);
                SearchVertex lastSv = svList.get(ind - 1);
                if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                if (sv.getZ() != lastSv.getZ()) {
                    List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                    int whichContact = lastSv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst ni = NodeInst.makeDummyInstance(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient);
                    AffineTransform trans = null;
                    if (orient != Orientation.IDENT) {
                        trans = ni.rotateOut();
                    }
                    Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                    for (int i = 0; i < polys.length; ++i) {
                        Rectangle2D bound3;
                        Poly poly3 = polys[i];
                        if (poly3.getLayer() != layer) continue;
                        if (trans != null) {
                            poly3.transform(trans);
                        }
                        if ((bound3 = poly3.getBounds2D()).getMaxX() <= lX || bound3.getMinX() >= hX || bound3.getMaxY() <= lY || bound3.getMinY() >= hY) continue;
                        SOGBound sBound = new SOGBound(bound3, netID);
                        if (!this.foundANotch(rtree, metBound, bound3, netID, recsOnPath, spacing)) continue;
                        return sBound;
                    }
                    continue;
                }
                ArcProto type = this.metalArcs[metNo];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                Point2D.Double head3 = new Point2D.Double(sv.getX(), sv.getY());
                Point2D.Double tail3 = new Point2D.Double(lastSv.getX(), lastSv.getY());
                int ang = 0;
                if (((Point2D)head3).getX() != ((Point2D)tail3).getX() || ((Point2D)head3).getY() != ((Point2D)tail3).getY()) {
                    ang = GenMath.figureAngle(tail3, head3);
                }
                if ((bound = (poly = Poly.makeEndPointPoly(head3.distance(tail3), width, ang, head3, width / 2.0, tail3, width / 2.0, Poly.Type.FILLED)).getBounds2D()).getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                SOGBound sBound = new SOGBound(bound, netID);
                if (!this.foundANotch(rtree, metBound, bound, netID, recsOnPath, spacing)) continue;
                return sBound;
            }
        }
        return null;
    }

    private boolean foundANotch(RTNode rtree, Rectangle2D metBound, Rectangle2D bound, int netID, List<Rectangle2D> recsOnPath, double dist) {
        boolean vOverlap;
        boolean hOverlap = metBound.getMinX() <= bound.getMaxX() && metBound.getMaxX() >= bound.getMinX();
        boolean bl = vOverlap = metBound.getMinY() <= bound.getMaxY() && metBound.getMaxY() >= bound.getMinY();
        if (hOverlap && vOverlap) {
            return false;
        }
        if (hOverlap) {
            double ptY;
            if (metBound.getCenterY() > bound.getCenterY()) {
                if (metBound.getMinY() - bound.getMaxY() > dist) {
                    return false;
                }
                ptY = (metBound.getMinY() + bound.getMaxY()) / 2.0;
            } else {
                if (bound.getMinY() - metBound.getMaxY() > dist) {
                    return false;
                }
                ptY = (metBound.getMaxY() + bound.getMinY()) / 2.0;
            }
            double pt1X = Math.max(metBound.getMinX(), bound.getMinX());
            double pt2X = Math.min(metBound.getMaxX(), bound.getMaxX());
            double pt3X = (pt1X + pt2X) / 2.0;
            if (!this.pointInRTree(rtree, pt1X, ptY, netID, recsOnPath)) {
                return true;
            }
            if (!this.pointInRTree(rtree, pt2X, ptY, netID, recsOnPath)) {
                return true;
            }
            return !this.pointInRTree(rtree, pt3X, ptY, netID, recsOnPath);
        }
        if (vOverlap) {
            double ptX;
            if (metBound.getCenterX() > bound.getCenterX()) {
                if (metBound.getMinX() - bound.getMaxX() > dist) {
                    return false;
                }
                ptX = (metBound.getMinX() + bound.getMaxX()) / 2.0;
            } else {
                if (bound.getMinX() - metBound.getMaxX() > dist) {
                    return false;
                }
                ptX = (metBound.getMaxX() + bound.getMinX()) / 2.0;
            }
            double pt1Y = Math.max(metBound.getMinY(), bound.getMinY());
            double pt2Y = Math.min(metBound.getMaxY(), bound.getMaxY());
            double pt3Y = (pt1Y + pt2Y) / 2.0;
            if (!this.pointInRTree(rtree, ptX, pt1Y, netID, recsOnPath)) {
                return true;
            }
            if (!this.pointInRTree(rtree, ptX, pt2Y, netID, recsOnPath)) {
                return true;
            }
            return !this.pointInRTree(rtree, ptX, pt3Y, netID, recsOnPath);
        }
        if (metBound.getMinX() > bound.getMaxX() && metBound.getMinY() > bound.getMaxY()) {
            double pt2Y;
            double pt1X = metBound.getMinX();
            double pt1Y = bound.getMaxY();
            double pt2X = bound.getMaxX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMaxX() < bound.getMinX() && metBound.getMinY() > bound.getMaxY()) {
            double pt2Y;
            double pt1X = metBound.getMaxX();
            double pt1Y = bound.getMaxY();
            double pt2X = bound.getMinX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMaxX() < bound.getMinX() && metBound.getMaxY() < bound.getMinY()) {
            double pt2Y;
            double pt1X = metBound.getMaxX();
            double pt1Y = bound.getMinY();
            double pt2X = bound.getMinX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMinX() > bound.getMaxX() && metBound.getMaxY() < bound.getMinY()) {
            double pt2Y;
            double pt1X = metBound.getMinX();
            double pt1Y = bound.getMinY();
            double pt2X = bound.getMaxX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        return false;
    }

    private boolean pointInRTree(RTNode rtree, double x, double y, int netID, List<Rectangle2D> recsOnPath) {
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x, y, 0.0, 0.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGBound sBound = (SOGBound)sea.next();
            if (sBound.netID != netID || sBound.bound.getMinX() > x || sBound.bound.getMaxX() < x || sBound.bound.getMinY() > y || sBound.bound.getMaxY() < y) continue;
            return true;
        }
        for (Rectangle2D bound : recsOnPath) {
            if (bound.getMinX() > x || bound.getMaxX() < x || bound.getMinY() > y || bound.getMaxY() < y) continue;
            return true;
        }
        return false;
    }

    private SOGBound getMetalBlockage(int netID, int metNo, double halfWidth, double halfHeight, double surround, double x, double y) {
        Layer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        double lX = x - halfWidth - surround;
        double hX = x + halfWidth + surround;
        double lY = y - halfHeight - surround;
        double hY = y + halfHeight + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            PolyBase poly;
            SOGBound sBound = (SOGBound)sea.next();
            Rectangle2D bound = sBound.getBounds();
            if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lX) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hX) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lY) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hY) || Math.abs(sBound.getNetID()) == netID || sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(searchArea)) continue;
            return sBound;
        }
        return null;
    }

    private SOGVia getViaBlockage(int netID, Layer layer, double halfWidth, double halfHeight, double x, double y) {
        RTNode rtree = this.viaTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x - halfWidth, y - halfHeight, halfWidth * 2.0, halfHeight * 2.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGVia sLoc = (SOGVia)sea.next();
            if (sLoc.getNetID() == netID && sLoc.loc.getX() == x && sLoc.loc.getY() == y) continue;
            return sLoc;
        }
        return null;
    }

    private void addLayer(PolyBase poly, AffineTransform trans, int netID, boolean canPlacePseudo) {
        if (!canPlacePseudo && poly.isPseudoLayer()) {
            return;
        }
        Layer layer = poly.getLayer();
        if (canPlacePseudo) {
            layer = layer.getNonPseudoLayer();
        } else if (layer.isPseudoLayer()) {
            return;
        }
        Layer.Function fun = layer.getFunction();
        if (fun.isMetal()) {
            poly.transform(trans);
            Rectangle2D bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, layer, netID);
            } else {
                this.addRectangle(bounds, layer, netID);
            }
        } else if (fun.isContact()) {
            Rectangle2D bounds = poly.getBounds2D();
            DBMath.transformRect(bounds, trans);
            this.addVia(new EPoint(bounds.getCenterX(), bounds.getCenterY()), layer, netID);
        }
    }

    private void addRectangle(Rectangle2D bounds, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.metalTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGBound(ERectangle.fromLambda(bounds), netID))) != root2) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addPolygon(PolyBase poly, Layer layer, int netID) {
        Rectangle2D bounds;
        RTNode newRoot;
        RTNode root2 = this.metalTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGPoly(ERectangle.fromLambda(bounds = poly.getBounds2D()), netID, poly))) != root2) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addVia(EPoint loc, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.viaTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.viaTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGVia(loc, netID))) != root2) {
            this.viaTrees.put(layer, newRoot);
        }
    }

    protected static void showSearchVertices(Map<Integer, Set<Integer>>[] planes, boolean horiz, Cell cell) {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        for (int i = 0; i < numMetalLayers; ++i) {
            double offset = i;
            offset -= (double)(numMetalLayers - 2) / 2.0;
            offset /= (double)(numMetalLayers + 2);
            Map<Integer, Set<Integer>> plane = planes[i];
            if (plane == null) continue;
            for (Integer y : plane.keySet()) {
                double yv = y.doubleValue();
                Set<Integer> row = plane.get(y);
                for (Integer x : row) {
                    Point2D.Double pt2;
                    Point2D.Double pt1;
                    double xv = x.doubleValue();
                    if (horiz) {
                        pt1 = new Point2D.Double(xv - 0.5, yv + offset);
                        pt2 = new Point2D.Double(xv + 0.5, yv + offset);
                    } else {
                        pt1 = new Point2D.Double(xv + offset, yv - 0.5);
                        pt2 = new Point2D.Double(xv + offset, yv + 0.5);
                    }
                    wnd.addHighlightLine(pt1, pt2, cell, false, false);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SearchVertex
    implements Comparable<SearchVertex> {
        private double xv;
        private double yv;
        private int zv;
        private int cost;
        private int cutLayer;
        private Point2D[] cuts;
        private SearchVertex last;
        private Wavefront w;

        SearchVertex(double x, double y, int z, int whichContact, Point2D[] cuts, int cl, Wavefront w) {
            this.xv = x;
            this.yv = y;
            this.zv = (z << 8) + (whichContact & 0xFF);
            this.cuts = cuts;
            this.cutLayer = cl;
            this.w = w;
        }

        double getX() {
            return this.xv;
        }

        double getY() {
            return this.yv;
        }

        int getZ() {
            return this.zv >> 8;
        }

        int getContactNo() {
            return this.zv & 0xFF;
        }

        Point2D[] getCuts() {
            return this.cuts;
        }

        void clearCuts() {
            this.cuts = null;
        }

        int getCutLayer() {
            return this.cutLayer;
        }

        @Override
        public int compareTo(SearchVertex svo) {
            int diff2 = this.cost - svo.cost;
            if (diff2 != 0) {
                return diff2;
            }
            if (this.w != null) {
                double otherDist;
                double thisDist = Math.abs(this.xv - this.w.toX) + Math.abs(this.yv - this.w.toY) + (double)Math.abs(this.zv - this.w.toZ);
                if (thisDist < (otherDist = Math.abs(svo.xv - this.w.toX) + Math.abs(svo.yv - this.w.toY) + (double)Math.abs(svo.zv - this.w.toZ))) {
                    return -1;
                }
                if (thisDist > otherDist) {
                    return 1;
                }
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            PrimitiveNode pn1 = mv1.via;
            PrimitiveNode pn2 = mv2.via;
            double sz1 = pn1.getDefWidth() * pn1.getDefHeight();
            if (sz1 < (sz2 = pn2.getDefWidth() * pn2.getDefHeight())) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(PrimitiveNode pn, int o) {
            this.vias.add(new MetalVia(pn, o));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        PrimitiveNode via;
        int orientation;

        MetalVia(PrimitiveNode v, int o) {
            this.via = v;
            this.orientation = o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockageVisitor
    extends HierarchyEnumerator.Visitor {
        private List<ArcInst> arcsToRoute;
        private boolean didTopLevel;

        public BlockageVisitor(List<ArcInst> arcsToRoute) {
            this.arcsToRoute = arcsToRoute;
            this.didTopLevel = false;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Netlist nl = info.getNetlist();
            AffineTransform trans = info.getTransformToRoot();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                int netID = -1;
                Network net = nl.getNetwork(ai, 0);
                if (net != null) {
                    netID = info.getNetID(net);
                }
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i = 0; i < polys.length; ++i) {
                    SeaOfGatesEngine.this.addLayer(polys[i], trans, netID, false);
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni;
            if (info.isRootCell() && !this.didTopLevel) {
                this.didTopLevel = true;
                if (this.arcsToRoute != null) {
                    Netlist nl = info.getNetlist();
                    for (ArcInst ai : this.arcsToRoute) {
                        Network net = nl.getNetwork(ai, 0);
                        int netID = info.getNetID(net);
                        SeaOfGatesEngine.this.netIDs.put(ai, new Integer(netID + 1));
                    }
                }
            }
            if (!(ni = no.getNodeInst()).isCellInstance()) {
                Netlist nl = info.getNetlist();
                AffineTransform trans = info.getTransformToRoot();
                AffineTransform nodeTrans = ni.rotateOut(trans);
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                boolean canPlacePseudo = info.isRootCell();
                if (!ni.hasExports()) {
                    canPlacePseudo = false;
                }
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    Network net;
                    Poly poly = nodeInstPolyList[i];
                    int netID = -1;
                    if (poly.getPort() != null && (net = nl.getNetwork(no, poly.getPort(), 0)) != null) {
                        netID = info.getNetID(net);
                    }
                    SeaOfGatesEngine.this.addLayer(poly, nodeTrans, netID, canPlacePseudo);
                }
            }
            return true;
        }
    }

    private static class SOGVia
    implements RTBounds {
        private Point2D loc;
        private int netID;

        SOGVia(Point2D loc, int netID) {
            this.loc = loc;
            this.netID = netID;
        }

        public Rectangle2D getBounds() {
            return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGVia on net " + this.netID;
        }
    }

    private static class SOGPoly
    extends SOGBound {
        private PolyBase poly;

        SOGPoly(Rectangle2D bound, int netID, PolyBase poly) {
            super(bound, netID);
            this.poly = poly;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    private static class SOGBound
    implements RTBounds {
        private Rectangle2D bound;
        private int netID;

        SOGBound(Rectangle2D bound, int netID) {
            this.bound = bound;
            this.netID = netID;
        }

        public Rectangle2D getBounds() {
            return this.bound;
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGBound on net " + this.netID;
        }
    }

    class DijkstraInThread
    extends Thread {
        private Wavefront wf;
        private Wavefront otherWf;
        private Semaphore whenDone;
        private Environment env;
        private EditingPreferences ep;

        public DijkstraInThread(String name, Wavefront wf, Wavefront otherWf, Semaphore whenDone, Environment env, EditingPreferences ep) {
            super(name);
            this.wf = wf;
            this.otherWf = otherWf;
            this.whenDone = whenDone;
            this.env = env;
            this.ep = ep;
            this.start();
        }

        public void run() {
            Environment.setThreadEnvironment(this.env);
            EditingPreferences.setThreadEditingPreferences(this.ep);
            SearchVertex result2 = null;
            int numSearchVertices = 0;
            while (result2 == null) {
                if (++numSearchVertices > this.wf.nr.prefs.complexityLimit) {
                    result2 = SeaOfGatesEngine.this.svLimited;
                    continue;
                }
                if (this.wf.abort) {
                    result2 = SeaOfGatesEngine.this.svAborted;
                    continue;
                }
                result2 = SeaOfGatesEngine.this.advanceWavefront(this.wf);
            }
            if (result2 != SeaOfGatesEngine.this.svAborted && result2 != SeaOfGatesEngine.this.svExhausted && result2 != SeaOfGatesEngine.this.svLimited) {
                this.wf.vertices = SeaOfGatesEngine.this.getOptimizedList(result2);
                this.wf.nr.winningWF = this.wf;
                this.otherWf.abort = true;
            }
            this.whenDone.release();
        }
    }

    protected class NeededRoute {
        String routeName;
        int netID;
        double minWidth;
        int batchNumber;
        int routeInBatch;
        Rectangle2D routeBounds;
        double minimumSearchBoundX;
        double maximumSearchBoundX;
        double minimumSearchBoundY;
        double maximumSearchBoundY;
        Rectangle2D jumpBound;
        Wavefront dir1;
        Wavefront dir2;
        protected Wavefront winningWF;
        SeaOfGates.SeaOfGatesOptions prefs;

        NeededRoute(String routeName, PortInst from2, double fromX, double fromY, int fromZ, PortInst to2, double toX, double toY, int toZ, int netID, double minWidth, int batchNumber, int routeInBatch, SeaOfGates.SeaOfGatesOptions prefs) {
            this.routeName = routeName;
            this.netID = netID;
            this.minWidth = minWidth;
            this.batchNumber = batchNumber;
            this.routeInBatch = routeInBatch;
            this.prefs = prefs;
            SeaOfGatesEngine.this.cellBounds = SeaOfGatesEngine.this.cell.getBounds();
            this.minimumSearchBoundX = SeaOfGatesEngine.this.downToGrain(SeaOfGatesEngine.this.cellBounds.getMinX());
            this.maximumSearchBoundX = SeaOfGatesEngine.this.upToGrain(SeaOfGatesEngine.this.cellBounds.getMaxX());
            this.minimumSearchBoundY = SeaOfGatesEngine.this.downToGrain(SeaOfGatesEngine.this.cellBounds.getMinY());
            this.maximumSearchBoundY = SeaOfGatesEngine.this.upToGrain(SeaOfGatesEngine.this.cellBounds.getMaxY());
            double maxStrayFromRouteBounds = Math.min(SeaOfGatesEngine.this.cellBounds.getWidth(), SeaOfGatesEngine.this.cellBounds.getHeight()) * 7.0 / 100.0;
            this.routeBounds = new Rectangle2D.Double(Math.min(fromX, toX) - maxStrayFromRouteBounds, Math.min(fromY, toY) - maxStrayFromRouteBounds, Math.abs(fromX - toX) + maxStrayFromRouteBounds * 2.0, Math.abs(fromY - toY) + maxStrayFromRouteBounds * 2.0);
            this.minimumSearchBoundX = this.routeBounds.getMinX();
            this.maximumSearchBoundX = this.routeBounds.getMaxX();
            this.minimumSearchBoundY = this.routeBounds.getMinY();
            this.maximumSearchBoundY = this.routeBounds.getMaxY();
            this.jumpBound = new Rectangle2D.Double(Math.min(fromX, toX), Math.min(fromY, toY), Math.abs(fromX - toX), Math.abs(fromY - toY));
            this.dir1 = new Wavefront(this, from2, fromX, fromY, fromZ, to2, toX, toY, toZ, "a->b", false);
            this.dir2 = new Wavefront(this, to2, toX, toY, toZ, from2, fromX, fromY, fromZ, "b->a", false);
        }

        public void cleanSearchMemory() {
            this.dir1.searchVertexPlanes = null;
            Wavefront.access$702(this.dir1, null);
            this.dir1.active = null;
            if (this.dir1.vertices != null) {
                for (SearchVertex sv : this.dir1.vertices) {
                    sv.clearCuts();
                }
            }
            this.dir2.searchVertexPlanes = null;
            Wavefront.access$702(this.dir2, null);
            this.dir2.active = null;
            if (this.dir2.vertices != null) {
                for (SearchVertex sv : this.dir2.vertices) {
                    sv.clearCuts();
                }
            }
        }
    }

    protected class Wavefront {
        NeededRoute nr;
        String name;
        private TreeSet<SearchVertex> active;
        List<SearchVertex> vertices;
        boolean abort;
        PortInst from;
        PortInst to;
        double fromX;
        double fromY;
        int fromZ;
        double toX;
        double toY;
        int toZ;
        private final boolean debug;
        Map<Integer, Set<Integer>>[] searchVertexPlanes;
        private Map<Double, Set<Double>>[] searchVertexPlanesDBL;
        private Map<Double, Map<Double, Double>>[] layerSurround;

        Wavefront(NeededRoute nr, PortInst from2, double fromX, double fromY, int fromZ, PortInst to2, double toX, double toY, int toZ, String name, boolean debug) {
            this.nr = nr;
            this.from = from2;
            this.fromX = fromX;
            this.fromY = fromY;
            this.fromZ = fromZ;
            this.to = to2;
            this.toX = toX;
            this.toY = toY;
            this.toZ = toZ;
            this.name = name;
            this.debug = debug;
            this.active = new TreeSet();
            this.vertices = null;
            this.abort = false;
            this.searchVertexPlanes = new Map[numMetalLayers];
            this.searchVertexPlanesDBL = new Map[numMetalLayers];
            this.layerSurround = new Map[numMetalLayers];
            for (int i = 0; i < numMetalLayers; ++i) {
                this.layerSurround[i] = new HashMap<Double, Map<Double, Double>>();
            }
            if (debug) {
                System.out.println("----------- SEARCHING FROM (" + TextUtils.formatDouble(fromX) + "," + TextUtils.formatDouble(fromY) + ",M" + (fromZ + 1) + ") TO (" + TextUtils.formatDouble(toX) + "," + TextUtils.formatDouble(toY) + ",M" + (toZ + 1) + ") -----------");
            }
            SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, 0, null, 0, this);
            svStart.cost = 0;
            this.setVertex(fromX, fromY, fromZ);
            this.active.add(svStart);
        }

        public boolean getVertex(double x, double y, int z) {
            Map<Double, Set<Double>> plane = this.searchVertexPlanesDBL[z];
            if (plane == null) {
                return false;
            }
            Set<Double> row = plane.get(new Double(y));
            if (row == null) {
                return false;
            }
            boolean found = row.contains(new Double(x));
            return found;
        }

        public void setVertex(double x, double y, int z) {
            Double iY;
            Set<Double> row;
            Map<Double, Set<Double>> plane = this.searchVertexPlanesDBL[z];
            if (plane == null) {
                this.searchVertexPlanesDBL[z] = plane = new HashMap<Double, Set<Double>>();
            }
            if ((row = plane.get(iY = new Double(y))) == null) {
                row = new HashSet<Double>();
                plane.put(iY, row);
            }
            row.add(new Double(x));
        }

        public double getSpacingRule(int layer, double width, double length) {
            Double value2;
            if (width < 0.0) {
                width = SeaOfGatesEngine.this.metalArcs[layer].getDefaultLambdaBaseWidth();
            }
            if (length < 0.0) {
                length = 50.0;
            }
            Double wid = new Double(SeaOfGatesEngine.this.upToGrain(width));
            Double len = new Double(SeaOfGatesEngine.this.upToGrain(length));
            Map<Double, Double> widMap = this.layerSurround[layer].get(wid);
            if (widMap == null) {
                widMap = new HashMap<Double, Double>();
                this.layerSurround[layer].put(wid, widMap);
            }
            if ((value2 = widMap.get(len)) == null) {
                Layer lay = SeaOfGatesEngine.this.metalLayers[layer];
                DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, width, length);
                double v = 0.0;
                if (rule != null) {
                    v = rule.getValue(0);
                }
                value2 = new Double(v);
                widMap.put(len, value2);
            }
            return value2;
        }

        static /* synthetic */ Map[] access$702(Wavefront x0, Map[] x1) {
            x0.searchVertexPlanesDBL = x1;
            return x1;
        }
    }

    protected static class RouteBatches {
        Set<ArcInst> unroutedArcs;
        Set<NodeInst> unroutedNodes;
        List<PortInst> orderedPorts;
        int segsInBatch;
        int numRouted;
        int numUnrouted;

        protected RouteBatches() {
        }
    }
}

