/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewNodesTab
extends PreferencePanel {
    private boolean newNodesDataChanging = false;
    private Technology selectedTech;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel newNode;
    private JCheckBox nodeCheckCellDates;
    private JCheckBox nodeDisallowModificationComplexNodes;
    private JCheckBox nodeDisallowModificationLockedPrims;
    private JCheckBox nodeDupArrayCopyExports;
    private JCheckBox nodeDupArrayCopyExports1;
    private JCheckBox nodeExtractCopyExports;
    private JCheckBox nodeIncrementRightmostIndex;
    private JCheckBox nodeMoveAfterDuplicate;
    private JCheckBox nodePlaceCellCenter;
    private JComboBox nodePrimitive;
    private JTextField nodePrimitiveXSize;
    private JTextField nodePrimitiveYSize;
    private JCheckBox nodePromptForIndex;
    private JCheckBox nodeReconstructArcsExports;
    private JCheckBox nodeSwitchTechnology;
    private JComboBox technologySelection;

    public NewNodesTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.nodePrimitiveXSize);
        EDialog.makeTextFieldSelectAllOnTab(this.nodePrimitiveYSize);
    }

    public JPanel getUserPreferencesPanel() {
        return this.newNode;
    }

    public String getName() {
        return "Nodes";
    }

    public void init() {
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            this.technologySelection.addItem(tech.getTechName());
        }
        this.technologySelection.setSelectedItem(Technology.getCurrent().getTechName());
        this.selectedTech = null;
        this.newNodesPrimPopupChanged();
        EditingPreferences ep = this.getEditingPreferences();
        this.nodeCheckCellDates.setSelected(User.isCheckCellDates());
        this.nodeSwitchTechnology.setSelected(User.isAutoTechnologySwitch());
        ep.getClass();
        this.nodePlaceCellCenter.setSelected(true);
        this.nodeReconstructArcsExports.setSelected(User.isReconstructArcsAndExportsToDeletedCells());
        this.nodePromptForIndex.setSelected(User.isPromptForIndexWhenDescending());
        this.nodeDisallowModificationComplexNodes.setSelected(User.isDisallowModificationComplexNodes());
        this.nodeDisallowModificationLockedPrims.setSelected(User.isDisallowModificationLockedPrims());
        this.nodeMoveAfterDuplicate.setSelected(User.isMoveAfterDuplicate());
        this.nodeDupArrayCopyExports1.setSelected(User.isDuplicateInPlace());
        this.nodeDupArrayCopyExports.setSelected(User.isDupCopiesExports());
        this.nodeIncrementRightmostIndex.setSelected(User.isIncrementRightmostIndex());
        this.nodeExtractCopyExports.setSelected(User.isExtractCopiesExports());
        this.technologySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewNodesTab.this.newNodesPrimPopupChanged();
            }
        });
        this.nodePrimitive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewNodesTab.this.newNodesPrimPopupChanged();
            }
        });
        this.nodePrimitiveXSize.getDocument().addDocumentListener(new NewNodeDocumentListener(this));
        this.nodePrimitiveYSize.getDocument().addDocumentListener(new NewNodeDocumentListener(this));
    }

    private void newNodesPrimPopupChanged() {
        PrimitiveNode np;
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        if (tech != this.selectedTech) {
            this.selectedTech = tech;
            this.nodePrimitive.removeAllItems();
            Iterator<PrimitiveNode> it = tech.getNodes();
            while (it.hasNext()) {
                np = it.next();
                this.nodePrimitive.addItem(np.getName());
            }
        }
        String primName = (String)this.nodePrimitive.getSelectedItem();
        np = tech.findNodeProto(primName);
        ImmutableNodeInst n = np.getDefaultInst(this.getEditingPreferences());
        this.newNodesDataChanging = true;
        ERectangle base = np.getBaseRectangle();
        double wid = DBMath.gridToLambda(base.getGridWidth() + n.size.getGridX());
        double hei = DBMath.gridToLambda(base.getGridHeight() + n.size.getGridY());
        this.nodePrimitiveXSize.setText(TextUtils.formatDistance(wid, tech));
        this.nodePrimitiveYSize.setText(TextUtils.formatDistance(hei, tech));
        this.newNodesDataChanging = false;
    }

    private void newNodesPrimDataChanged() {
        if (this.newNodesDataChanging) {
            return;
        }
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String primName = (String)this.nodePrimitive.getSelectedItem();
        PrimitiveNode np = tech.findNodeProto(primName);
        ERectangle base = np.getBaseRectangle();
        double wid = TextUtils.atofDistance(this.nodePrimitiveXSize.getText(), tech);
        double hei = TextUtils.atofDistance(this.nodePrimitiveYSize.getText(), tech);
        EPoint size = EPoint.fromGrid(DBMath.lambdaToSizeGrid(wid - base.getWidth()), DBMath.lambdaToSizeGrid(hei - base.getHeight()));
        this.setEditingPreferences(this.getEditingPreferences().withNodeSize(np.getId(), size));
    }

    public void term() {
        boolean currBoolean = this.nodeCheckCellDates.isSelected();
        if (currBoolean != User.isCheckCellDates()) {
            User.setCheckCellDates(currBoolean);
        }
        if ((currBoolean = this.nodeSwitchTechnology.isSelected()) != User.isAutoTechnologySwitch()) {
            User.setAutoTechnologySwitch(currBoolean);
        }
        if ((currBoolean = this.nodeReconstructArcsExports.isSelected()) != User.isReconstructArcsAndExportsToDeletedCells()) {
            User.setReconstructArcsAndExportsToDeletedCells(currBoolean);
        }
        if ((currBoolean = this.nodePromptForIndex.isSelected()) != User.isPromptForIndexWhenDescending()) {
            User.setPromptForIndexWhenDescending(currBoolean);
        }
        if ((currBoolean = this.nodeDisallowModificationComplexNodes.isSelected()) != User.isDisallowModificationComplexNodes()) {
            User.setDisallowModificationComplexNodes(currBoolean);
        }
        if ((currBoolean = this.nodeDisallowModificationLockedPrims.isSelected()) != User.isDisallowModificationLockedPrims()) {
            User.setDisallowModificationLockedPrims(currBoolean);
        }
        if ((currBoolean = this.nodeMoveAfterDuplicate.isSelected()) != User.isMoveAfterDuplicate()) {
            User.setMoveAfterDuplicate(currBoolean);
        }
        if ((currBoolean = this.nodeDupArrayCopyExports1.isSelected()) != User.isDuplicateInPlace()) {
            User.setDuplicateInPlace(currBoolean);
        }
        if ((currBoolean = this.nodeDupArrayCopyExports.isSelected()) != User.isDupCopiesExports()) {
            User.setDupCopiesExports(currBoolean);
        }
        if ((currBoolean = this.nodeIncrementRightmostIndex.isSelected()) != User.isIncrementRightmostIndex()) {
            User.setIncrementRightmostIndex(currBoolean);
        }
        if ((currBoolean = this.nodeExtractCopyExports.isSelected()) != User.isExtractCopiesExports()) {
            User.setExtractCopiesExports(currBoolean);
        }
        EditingPreferences ep = this.getEditingPreferences();
        ep = ep.withPlaceCellCenter(this.nodePlaceCellCenter.isSelected());
    }

    public void reset() {
        this.setEditingPreferences(this.getEditingPreferences().withNodesReset());
        if (User.isFactoryCheckCellDates() != User.isCheckCellDates()) {
            User.setCheckCellDates(User.isFactoryCheckCellDates());
        }
        if (User.isFactoryAutoTechnologySwitch() != User.isAutoTechnologySwitch()) {
            User.setAutoTechnologySwitch(User.isFactoryAutoTechnologySwitch());
        }
        if (User.isFactoryReconstructArcsAndExportsToDeletedCells() != User.isReconstructArcsAndExportsToDeletedCells()) {
            User.setReconstructArcsAndExportsToDeletedCells(User.isFactoryReconstructArcsAndExportsToDeletedCells());
        }
        if (User.isFactoryPromptForIndexWhenDescending() != User.isPromptForIndexWhenDescending()) {
            User.setPromptForIndexWhenDescending(User.isFactoryPromptForIndexWhenDescending());
        }
        if (User.isFactoryDisallowModificationComplexNodes() != User.isDisallowModificationComplexNodes()) {
            User.setDisallowModificationComplexNodes(User.isFactoryDisallowModificationComplexNodes());
        }
        if (User.isFactoryDisallowModificationLockedPrims() != User.isDisallowModificationLockedPrims()) {
            User.setDisallowModificationLockedPrims(User.isFactoryDisallowModificationLockedPrims());
        }
        if (User.isFactoryMoveAfterDuplicate() != User.isMoveAfterDuplicate()) {
            User.setMoveAfterDuplicate(User.isFactoryMoveAfterDuplicate());
        }
        if (User.isFactoryDuplicateInPlace() != User.isDuplicateInPlace()) {
            User.setDuplicateInPlace(User.isFactoryDuplicateInPlace());
        }
        if (User.isFactoryDupCopiesExports() != User.isDupCopiesExports()) {
            User.setDupCopiesExports(User.isFactoryDupCopiesExports());
        }
        if (User.isFactoryIncrementRightmostIndex() != User.isIncrementRightmostIndex()) {
            User.setIncrementRightmostIndex(User.isFactoryIncrementRightmostIndex());
        }
        if (User.isFactoryExtractCopiesExports() != User.isExtractCopiesExports()) {
            User.setExtractCopiesExports(User.isFactoryExtractCopiesExports());
        }
    }

    private void initComponents() {
        this.newNode = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nodePrimitive = new JComboBox();
        this.nodePrimitiveXSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.nodePrimitiveYSize = new JTextField();
        this.technologySelection = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jPanel3 = new JPanel();
        this.nodeCheckCellDates = new JCheckBox();
        this.nodeSwitchTechnology = new JCheckBox();
        this.nodePlaceCellCenter = new JCheckBox();
        this.nodeReconstructArcsExports = new JCheckBox();
        this.nodePromptForIndex = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.nodeDisallowModificationLockedPrims = new JCheckBox();
        this.nodeMoveAfterDuplicate = new JCheckBox();
        this.nodeDupArrayCopyExports = new JCheckBox();
        this.nodeExtractCopyExports = new JCheckBox();
        this.nodeDisallowModificationComplexNodes = new JCheckBox();
        this.nodeDupArrayCopyExports1 = new JCheckBox();
        this.nodeIncrementRightmostIndex = new JCheckBox();
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewNodesTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.newNode.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("For New Primitive Nodes"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Primitive:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.nodePrimitive, gridBagConstraints);
        this.nodePrimitiveXSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.nodePrimitiveXSize, gridBagConstraints);
        this.jLabel2.setText("Default X size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Default Y size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.nodePrimitiveYSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.nodePrimitiveYSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.technologySelection, gridBagConstraints);
        this.jLabel4.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.newNode.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("For Cells"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.nodeCheckCellDates.setText("Check cell dates during editing");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel3.add((Component)this.nodeCheckCellDates, gridBagConstraints);
        this.nodeSwitchTechnology.setText("Switch technology to match current cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel3.add((Component)this.nodeSwitchTechnology, gridBagConstraints);
        this.nodePlaceCellCenter.setText("Place Cell-Center in new cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel3.add((Component)this.nodePlaceCellCenter, gridBagConstraints);
        this.nodeReconstructArcsExports.setText("Reconstruct arcs and exports when deleting instances");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel3.add((Component)this.nodeReconstructArcsExports, gridBagConstraints);
        this.nodePromptForIndex.setText("Always prompt for index when descending into array nodes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel3.add((Component)this.nodePromptForIndex, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.newNode.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("For All Nodes"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.nodeDisallowModificationLockedPrims.setText("Disallow modification of locked primitives");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeDisallowModificationLockedPrims, gridBagConstraints);
        this.nodeMoveAfterDuplicate.setText("Move after Duplicate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeMoveAfterDuplicate, gridBagConstraints);
        this.nodeDupArrayCopyExports.setText("Duplicate/Array/Paste copies exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.jPanel4.add((Component)this.nodeDupArrayCopyExports, gridBagConstraints);
        this.nodeExtractCopyExports.setText("Extract copies exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel4.add((Component)this.nodeExtractCopyExports, gridBagConstraints);
        this.nodeDisallowModificationComplexNodes.setText("Disallow modification of complex nodes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeDisallowModificationComplexNodes, gridBagConstraints);
        this.nodeDupArrayCopyExports1.setText("Duplicate In Place");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeDupArrayCopyExports1, gridBagConstraints);
        this.nodeIncrementRightmostIndex.setText("Increment rightmost array index");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 2, 4);
        this.jPanel4.add((Component)this.nodeIncrementRightmostIndex, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.newNode.add((Component)this.jPanel4, gridBagConstraints);
        this.getContentPane().add((Component)this.newNode, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class NewNodeDocumentListener
    implements DocumentListener {
        NewNodesTab dialog;

        NewNodeDocumentListener(NewNodesTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.newNodesPrimDataChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.newNodesPrimDataChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.newNodesPrimDataChanged();
        }
    }
}

