/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddedTechnologiesTab
extends PreferencePanel {
    private JPanel addedTechnologies;
    private JList addedTechnologiesList;
    private DefaultListModel addedTechnologiesModel;
    private JScrollPane addedTechnologiesPane;
    private Setting softTechnologiesSetting = User.getSoftTechnologiesSetting();
    private JButton removeTech;

    public AddedTechnologiesTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getProjectPreferencesPanel() {
        return this.addedTechnologies;
    }

    public String getName() {
        return "Added Technologies";
    }

    public void init() {
        this.addedTechnologiesModel = new DefaultListModel();
        this.addedTechnologiesList = new JList(this.addedTechnologiesModel);
        this.addedTechnologiesList.setSelectionMode(0);
        this.addedTechnologiesPane.setViewportView(this.addedTechnologiesList);
        for (String techPath : this.getString(this.softTechnologiesSetting).split(";")) {
            if (techPath.length() <= 0) continue;
            this.addedTechnologiesModel.addElement(techPath);
        }
        this.addedTechnologiesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                AddedTechnologiesTab.this.setRemoveButton();
            }
        });
        this.setRemoveButton();
    }

    private void setRemoveButton() {
        this.removeTech.setEnabled(this.addedTechnologiesList.getSelectedIndex() != -1);
    }

    public void term() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.addedTechnologiesModel.size(); ++i) {
            if (i != 0) {
                sb.append(";");
            }
            sb.append(this.addedTechnologiesModel.get(i));
        }
        this.setString(this.softTechnologiesSetting, sb.toString());
    }

    public void reset() {
    }

    private void addTechnology() {
        String fileName = OpenFile.chooseInputFile(FileType.XML, null);
        if (fileName == null) {
            return;
        }
        this.addedTechnologiesModel.addElement(fileName);
        this.setRemoveButton();
    }

    private void removeTechnology() {
        int line = this.addedTechnologiesList.getSelectedIndex();
        if (line < 0) {
            return;
        }
        this.addedTechnologiesModel.remove(line);
        this.setRemoveButton();
    }

    private void initComponents() {
        this.addedTechnologies = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AddedTechnologiesTab.this.closeDialog(evt);
            }
        });
        this.addedTechnologies.setLayout(new GridBagLayout());
        JLabel jLabel1 = new JLabel("Technologies that will be added to Electric when it next runs");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.addedTechnologies.add((Component)jLabel1, gridBagConstraints);
        JLabel jLabel2 = new JLabel("(these are XML files created by the Technology Editor)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.addedTechnologies.add((Component)jLabel2, gridBagConstraints);
        this.addedTechnologiesPane = new JScrollPane();
        this.addedTechnologiesPane.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.addedTechnologies.add((Component)this.addedTechnologiesPane, gridBagConstraints);
        JButton addTech = new JButton("Add");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.addedTechnologies.add((Component)addTech, gridBagConstraints);
        addTech.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddedTechnologiesTab.this.addTechnology();
            }
        });
        this.removeTech = new JButton("Remove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.addedTechnologies.add((Component)this.removeTech, gridBagConstraints);
        this.removeTech.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddedTechnologiesTab.this.removeTechnology();
            }
        });
        this.getContentPane().add((Component)this.addedTechnologies, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

