/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.NewSignal;
import com.sun.electric.tool.simulation.ScalarSample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewSignalSimpleImpl
implements NewSignal<ScalarSample> {
    private NewSignal.Approximation<ScalarSample> pa = null;
    private double tmin;
    private double tmax;
    private int emax;
    public static int misses = 0;
    public static int steps = 0;
    public static int numLookups = 0;

    protected int getEventForTime(double t, boolean justLessThan) {
        int e;
        if (this.pa == null) {
            this.pa = this.getPreferredApproximation();
            this.emax = this.pa.getNumEvents() - 1;
            this.tmin = this.pa.getTime(0);
            this.tmax = this.pa.getTime(this.emax);
        }
        ++numLookups;
        int emin = 0;
        int emax = this.emax;
        double tmin = this.tmin;
        double tmax = this.tmax;
        boolean last = true;
        while (true) {
            if (emin == emax) {
                return emin;
            }
            if (emin + 1 == emax) {
                return justLessThan ? emin : emax;
            }
            double est = (t - tmin) * (double)(emax - emin) / (tmax - tmin);
            e = emin + (last ? (int)Math.ceil(est) : (int)Math.floor(est));
            boolean bl = last = !last;
            if (e <= emin) {
                return emin;
            }
            if (e >= emax) {
                return emax;
            }
            double te = this.pa.getTime(e);
            ++steps;
            if (te < t) {
                emin = e;
                tmin = te;
                continue;
            }
            if (!(te > t)) break;
            emax = e;
            tmax = te;
        }
        return e;
    }

    @Override
    public NewSignal.Approximation<ScalarSample> getPixelatedApproximation(double t0, double t1, int numRegions) {
        return this.getApproximation(t0, t1, numRegions, new ScalarSample(0.0), new ScalarSample(0.0), 0);
    }

    @Override
    public NewSignal.Approximation<ScalarSample> getApproximation(double t0, double t1, int numEvents, ScalarSample v0, ScalarSample v1, int vd) {
        if (vd != 0) {
            throw new RuntimeException("not implemented");
        }
        int e0 = this.getEventForTime(t0, true);
        int e1 = this.getEventForTime(t1, false);
        if (numEvents == 0) {
            throw new RuntimeException("invalid!");
        }
        return new ApproximationSimpleImpl(e0, e1, numEvents, t0, t1);
    }

    protected ScalarSample getSampleForTime(double t, boolean justLessThan) {
        int e = this.getEventForTime(t, justLessThan);
        return (ScalarSample)this.getPreferredApproximation().getSample(e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApproximationSimpleImpl
    implements NewSignal.Approximation<ScalarSample> {
        private final int minEvent;
        private final int maxEvent;
        private final int numEvents;
        private final double t0;
        private final double t1;

        public ApproximationSimpleImpl(int minEvent, int maxEvent, int numEvents, double t0, double t1) {
            this.minEvent = minEvent;
            this.maxEvent = maxEvent;
            this.t0 = t0;
            this.t1 = t1;
            this.numEvents = numEvents;
        }

        @Override
        public int getNumEvents() {
            return this.numEvents;
        }

        @Override
        public double getTime(int event) {
            return this.t0 + (double)event * (this.t1 - this.t0) / (double)(this.numEvents - 1);
        }

        @Override
        public ScalarSample getSample(int event) {
            return NewSignalSimpleImpl.this.getSampleForTime(this.getTime(event), true);
        }

        @Override
        public int getTimeDenominator() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getEventWithMinValue() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getEventWithMaxValue() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getTimeNumerator(int event) {
            throw new RuntimeException("not implemented");
        }
    }
}

