/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.Version;
import com.sun.electric.tool.io.output.JELIB;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DELIB
extends JELIB {
    private HashMap<String, CellFileState> cellFileMap = new HashMap();
    private List<String> deletedCellFiles = new ArrayList<String>();
    private String headerFile;
    private boolean wroteSearchForCells = false;
    private boolean writeHeaderOnly;
    public static final String SEARCH_FOR_CELL_FILES = "____SEARCH_FOR_CELL_FILES____";
    public static final char PLATFORM_INDEPENDENT_FILE_SEPARATOR = '/';

    DELIB(boolean writeHeaderOnly) {
        this.writeHeaderOnly = writeHeaderOnly;
    }

    protected boolean writeLib(Snapshot snapshot, LibId libId, Set<CellId> oldCells) {
        HashSet<String> oldCellFiles = new HashSet<String>();
        for (CellId cellId : oldCells) {
            oldCellFiles.add(DELIB.getCellFile(cellId));
        }
        File delibDir = new File(this.filePath);
        File parent = delibDir.getParentFile();
        if (parent.getName().endsWith(".delib")) {
            System.out.println("Error: Cannot write " + snapshot.getLib((LibId)libId).d.libId.libName + " inside of another DELIB directory");
            return true;
        }
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null) continue;
            CellRevision cellRevision = cellBackup.cellRevision;
            if (cellRevision.d.getLibId() != libId) continue;
            String cellFile = DELIB.getCellFile(cellRevision.d.cellId);
            String string = this.filePath + File.separator + cellFile;
            CellFileState state = this.cellFileMap.get(string);
            if (state == null) {
                state = new CellFileState();
                this.cellFileMap.put(string, state);
            }
            File fd = new File(string);
            if (!cellBackup.modified && fd.exists()) continue;
            state.modified = true;
        }
        for (CellId cellId : oldCells) {
            if (snapshot.getCell(cellId) != null) continue;
            String cellFile = DELIB.getCellFile(cellId);
            String file = this.filePath + File.separator + cellFile;
            CellFileState cellFileState = this.cellFileMap.get(file);
            if (cellFileState == null) continue;
            cellFileState.modified = true;
        }
        boolean b = super.writeLib(snapshot, libId, null, false);
        if (!b && !this.writeHeaderOnly) {
            this.deletedCellFiles.clear();
            for (File file : delibDir.listFiles()) {
                this.checkIfDeleted(file, oldCellFiles);
            }
        }
        return b;
    }

    private void checkIfDeleted(File cellFile, Set<String> oldCellFiles) {
        if (this.cellFileMap.containsKey(cellFile.getAbsolutePath())) {
            return;
        }
        String name = cellFile.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return;
        }
        View view = View.findView(name.substring(dot + 1));
        if (view == null) {
            return;
        }
        if (oldCellFiles == null || !oldCellFiles.contains(cellFile.getName())) {
            return;
        }
        System.out.println("Renaming unlinked (possibly deleted) cell file " + name + " to " + name + ".deleted");
        this.deletedCellFiles.add(cellFile.getAbsolutePath());
        File deletedFileName = new File(cellFile.getAbsolutePath() + ".deleted");
        if (!cellFile.renameTo(deletedFileName)) {
            System.out.println("  Error: Unable to rename unlinked cell file " + name + " to " + name + ".deleted!");
        }
    }

    @Override
    void writeCell(CellRevision cellRevision) {
        if (this.writeHeaderOnly) {
            if (!this.wroteSearchForCells) {
                this.printWriter.println("C____SEARCH_FOR_CELL_FILES____");
                this.wroteSearchForCells = true;
            }
            return;
        }
        String cellFile = DELIB.getCellFile(cellRevision.d.cellId);
        String cellFileAbs = this.filePath + File.separator + cellFile;
        CellFileState state = this.cellFileMap.get(cellFileAbs);
        boolean append = state.appendFile;
        if (state.modified) {
            PrintWriter headerWriter = this.printWriter;
            try {
                this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(cellFileAbs, append)));
            }
            catch (IOException e) {
                System.out.println("Error opening " + cellFileAbs + ", skipping cell: " + e.getMessage());
                this.printWriter = headerWriter;
                return;
            }
            HashSet<LibId> usedLibs = new HashSet<LibId>();
            int[] instCounts = cellRevision.getInstCounts();
            for (int i = 0; i < instCounts.length; ++i) {
                int instCount = instCounts[i];
                if (instCount == 0) continue;
                CellUsage u = cellRevision.d.cellId.getUsageIn(i);
                usedLibs.add(u.protoId.libId);
            }
            LibId libId = cellRevision.d.getLibId();
            this.printWriter.println("H" + DELIB.convertString(libId.libName) + "|" + Version.getVersion());
            super.writeExternalLibraryInfo(libId, usedLibs);
            super.writeCell(cellRevision);
            this.printWriter.close();
            this.printWriter = headerWriter;
        }
        if (!append) {
            state.appendFile = true;
        }
        if (!this.wroteSearchForCells) {
            this.printWriter.println("C____SEARCH_FOR_CELL_FILES____");
            this.wroteSearchForCells = true;
        }
    }

    @Override
    void writeExternalLibraryInfo(LibId libId, Set<LibId> usedLibs) {
    }

    @Override
    protected boolean openTextOutputStream(String filePath) {
        File f = new File(filePath);
        this.filePath = filePath;
        if (f.exists()) {
            if (!f.isDirectory()) {
                System.out.println("Error, file " + f + " is not a directory");
                return true;
            }
        } else if (!f.mkdir()) {
            System.out.println("Failed to make directory: " + f);
            return true;
        }
        this.headerFile = filePath + File.separator + DELIB.getHeaderFile();
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.headerFile)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + this.headerFile + ": " + e.getMessage());
            return true;
        }
        return false;
    }

    public List<String> getDeletedCellFiles() {
        return this.deletedCellFiles;
    }

    public List<String> getWrittenCellFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (String s : this.cellFileMap.keySet()) {
            files.add(s);
        }
        return files;
    }

    public static String getCellSubDir(CellId cellId) {
        return "";
    }

    private static String getCellFile(CellId cellId) {
        String cellName = cellId.cellName.getName();
        View view = cellId.cellName.getView();
        cellName = cellName + "." + view.getAbbreviation();
        cellName = cellName.replace(File.separatorChar, ':');
        return cellName;
    }

    public static String getCellFile(Cell cell) {
        return DELIB.getCellFile(cell.getId());
    }

    public static final String getHeaderFile() {
        return "header";
    }

    private static class CellFileState {
        public boolean modified = false;
        public boolean appendFile = false;

        private CellFileState() {
        }
    }
}

