/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ManipulatePorts
extends EDialog {
    private static final String[] columnNames = new String[]{" ", "Name", "Characteristic", "Connections", "Arcs", "Exports"};
    private NodeInst ni;
    private PortsTable portTable;
    private int sortColumn;
    private boolean sortAscending;
    private JButton deleteExports;
    private JButton deselectAll;
    private JButton done;
    private JSeparator jSeparator1;
    private JScrollPane portPane;
    private JButton reExportPorts;
    private JButton selectAll;
    private JButton showPorts;
    private JLabel title;
    private JButton toggleSelection;

    public static void showDialog() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter h = wnd.getHighlighter();
        NodeInst ni = (NodeInst)h.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        ManipulatePorts dialog = new ManipulatePorts((Frame)TopLevel.getCurrentJFrame(), ni);
        dialog.setVisible(true);
    }

    private ManipulatePorts(Frame parent, NodeInst ni) {
        super(parent, true);
        this.ni = ni;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        this.title.setText("Ports on node " + ni.describe(false));
        this.sortColumn = 1;
        this.sortAscending = true;
        this.portTable = new PortsTable(ni);
        JTableHeader header = this.portTable.getTableHeader();
        header.addMouseListener(new ColumnListener());
        this.portPane.setViewportView(this.portTable);
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void initComponents() {
        this.done = new JButton();
        this.title = new JLabel();
        this.portPane = new JScrollPane();
        this.selectAll = new JButton();
        this.deselectAll = new JButton();
        this.reExportPorts = new JButton();
        this.jSeparator1 = new JSeparator();
        this.deleteExports = new JButton();
        this.showPorts = new JButton();
        this.toggleSelection = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Manipulate Ports");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ManipulatePorts.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.doneActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.title.setText("Ports on node");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.title, gridBagConstraints);
        this.portPane.setMinimumSize(new Dimension(200, 200));
        this.portPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.portPane, gridBagConstraints);
        this.selectAll.setText("Select All Ports");
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.selectAll, gridBagConstraints);
        this.deselectAll.setText("Deselect All Ports");
        this.deselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.deselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deselectAll, gridBagConstraints);
        this.reExportPorts.setText("ReExport Selected Ports");
        this.reExportPorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.reExportPortsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.reExportPorts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.deleteExports.setText("Delect Exports on Selected Ports");
        this.deleteExports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.deleteExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deleteExports, gridBagConstraints);
        this.showPorts.setText("Show Selected Ports");
        this.showPorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.showPortsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showPorts, gridBagConstraints);
        this.toggleSelection.setText("Toggle Selection");
        this.toggleSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.toggleSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.toggleSelection, gridBagConstraints);
        this.pack();
    }

    private void toggleSelectionActionPerformed(ActionEvent evt) {
        this.portTable.toggleSelection();
    }

    private void showPortsActionPerformed(ActionEvent evt) {
        this.portTable.showSelected();
    }

    private void deleteExportsActionPerformed(ActionEvent evt) {
        this.portTable.unExportSelected();
        this.closeDialog(null);
    }

    private void reExportPortsActionPerformed(ActionEvent evt) {
        this.portTable.reExportSelected();
        this.closeDialog(null);
    }

    private void deselectAllActionPerformed(ActionEvent evt) {
        this.portTable.deselectAll();
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.portTable.selectAll();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class ColumnListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int colNumber;
            TableColumnModel colModel = ManipulatePorts.this.portTable.getColumnModel();
            int modelIndex = colModel.getColumn(colNumber = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (ManipulatePorts.this.sortColumn == modelIndex) {
                ManipulatePorts.this.sortAscending = !ManipulatePorts.this.sortAscending;
            } else {
                ManipulatePorts.this.sortColumn = modelIndex;
            }
            PortTableModel model = ManipulatePorts.this.portTable.getModel();
            model.sortTable(modelIndex, ManipulatePorts.this.sortAscending);
            model.fireTableStructureChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PortTableModel
    extends AbstractTableModel {
        private NodeInst ni;
        private List<PortEntry> ports;

        private PortTableModel(NodeInst ni) {
            this.ni = ni;
            this.ports = new ArrayList<PortEntry>();
        }

        public void newVar(PortInst pi) {
            PortEntry ve = new PortEntry(pi);
            this.ports.add(ve);
        }

        public void sortTable(int column, boolean ascending) {
            Collections.sort(this.ports, new PortEntrySort(column, ascending));
            this.fireTableDataChanged();
        }

        public void selectAll() {
            int i = 0;
            for (PortEntry pe : this.ports) {
                pe.setSelected(true);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void deselectAll() {
            int i = 0;
            for (PortEntry pe : this.ports) {
                pe.setSelected(false);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void reExportSelected() {
            ArrayList<PortInst> queuedExports = new ArrayList<PortInst>();
            for (PortEntry pe : this.ports) {
                if (!pe.isSelected()) continue;
                queuedExports.add(pe.getPort());
            }
            new ExportChanges.ReExportPorts(this.ni.getParent(), queuedExports, true, true, false, null);
        }

        public void unExportSelected() {
            ArrayList<Export> queuedExports = new ArrayList<Export>();
            for (PortEntry pe : this.ports) {
                if (!pe.isSelected()) continue;
                Iterator<Export> eIt = pe.getPort().getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    queuedExports.add(e);
                }
            }
            new ExportChanges.DeleteExports(this.ni.getParent(), queuedExports);
        }

        public void showSelected() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            wnd.clearHighlighting();
            for (PortEntry pe : this.ports) {
                if (!pe.isSelected()) continue;
                wnd.addElectricObject(pe.getPort(), this.ni.getParent());
            }
            wnd.finishedHighlighting();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            return this.ports.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PortEntry pe = this.ports.get(rowIndex);
            if (pe == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return new Boolean(pe.isSelected());
                }
                case 1: {
                    return pe.getPort().getPortProto().getName();
                }
                case 2: {
                    return pe.getPort().getPortProto().getCharacteristic().getName();
                }
                case 3: {
                    return pe.getConnections();
                }
                case 4: {
                    return Integer.toString(pe.getNumArcs());
                }
                case 5: {
                    return pe.getExports();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            String colName = columnNames[col];
            if (col == ManipulatePorts.this.sortColumn) {
                colName = ManipulatePorts.this.sortAscending ? colName + " \u21d3" : colName + " \u21d1";
            }
            return colName;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            PortEntry ve = this.ports.get(row);
            if (ve == null) {
                return;
            }
            if (col != 0) {
                return;
            }
            Boolean b = (Boolean)aValue;
            if (ve.isSelected() != b) {
                ve.setSelected(b);
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PortEntrySort
        implements Comparator<PortEntry> {
            private int column;
            private boolean ascending;

            PortEntrySort(int column, boolean ascending) {
                this.column = column;
                this.ascending = ascending;
            }

            @Override
            public int compare(PortEntry p1, PortEntry p2) {
                if (!this.ascending) {
                    PortEntry swap = p1;
                    p1 = p2;
                    p2 = swap;
                }
                String s1 = null;
                String s2 = null;
                switch (this.column) {
                    case 0: {
                        boolean b1 = p1.isSelected();
                        boolean b2 = p2.isSelected();
                        if (b1 == b2) {
                            return 0;
                        }
                        if (b1) {
                            return 1;
                        }
                        return -1;
                    }
                    case 1: {
                        s1 = p1.getPort().getPortProto().getName();
                        s2 = p2.getPort().getPortProto().getName();
                        break;
                    }
                    case 2: {
                        s1 = p1.getPort().getPortProto().getCharacteristic().getName();
                        s2 = p2.getPort().getPortProto().getCharacteristic().getName();
                        return s1.compareTo(s2);
                    }
                    case 3: {
                        s1 = p1.getConnections();
                        s2 = p2.getConnections();
                        break;
                    }
                    case 4: {
                        int i1 = p1.getNumArcs();
                        int i2 = p2.getNumArcs();
                        if (i1 == 12) {
                            return 0;
                        }
                        if (i1 < i2) {
                            return 1;
                        }
                        return -1;
                    }
                    case 5: {
                        s1 = p1.getExports();
                        s2 = p2.getExports();
                    }
                }
                return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
            }
        }

        private class PortEntry {
            private boolean selected;
            private PortInst pi;

            private PortEntry(PortInst pi) {
                this.pi = pi;
            }

            private PortInst getPort() {
                return this.pi;
            }

            private boolean isSelected() {
                return this.selected;
            }

            private void setSelected(boolean s) {
                this.selected = s;
            }

            private String getConnections() {
                ArcProto[] conns = this.pi.getPortProto().getBasePort().getConnections();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < conns.length; ++i) {
                    if (conns[i].getTechnology() == Generic.tech && PortTableModel.this.ni.getProto().getTechnology() != Generic.tech) continue;
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(conns[i].getName());
                }
                return buf.toString();
            }

            private int getNumArcs() {
                int num = 0;
                Iterator<Connection> it = this.pi.getNodeInst().getConnections();
                while (it.hasNext()) {
                    Connection con = it.next();
                    if (con.getPortInst() != this.pi) continue;
                    ++num;
                }
                return num;
            }

            private String getExports() {
                StringBuffer buf = new StringBuffer();
                Iterator<Export> it = this.pi.getNodeInst().getExports();
                while (it.hasNext()) {
                    Export e = it.next();
                    if (e.getOriginalPort() != this.pi) continue;
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(e.getName());
                }
                return buf.toString();
            }
        }
    }

    private class PortsTable
    extends JTable {
        private PortTableModel model;

        public PortsTable(NodeInst ni) {
            this.model = new PortTableModel(ni);
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                this.model.newVar(pi);
            }
            this.model.sortTable(1, true);
            this.setModel(this.model);
            TableColumn tc = this.getColumn(this.getColumnName(0));
            if (tc != null) {
                tc.setPreferredWidth(20);
            }
            if ((tc = this.getColumn(this.getColumnName(1))) != null) {
                tc.setPreferredWidth(120);
            }
            if ((tc = this.getColumn(this.getColumnName(2))) != null) {
                tc.setPreferredWidth(100);
            }
            if ((tc = this.getColumn(this.getColumnName(3))) != null) {
                tc.setPreferredWidth(90);
            }
            if ((tc = this.getColumn(this.getColumnName(4))) != null) {
                tc.setPreferredWidth(30);
            }
            if ((tc = this.getColumn(this.getColumnName(5))) != null) {
                tc.setPreferredWidth(120);
            }
        }

        public void toggleSelection() {
            int[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Boolean b = (Boolean)this.model.getValueAt(rows[i], 0);
                this.model.setValueAt(new Boolean(b == false), rows[i], 0);
            }
        }

        public PortTableModel getModel() {
            return this.model;
        }

        public void selectAll() {
            this.model.selectAll();
        }

        public void deselectAll() {
            this.model.deselectAll();
        }

        public void reExportSelected() {
            this.model.reExportSelected();
        }

        public void unExportSelected() {
            this.model.unExportSelected();
        }

        public void showSelected() {
            this.model.showSelected();
        }
    }
}

