/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccGuiOptions;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.user.ncc.NccMsgsFrame;
import java.util.List;
import javax.swing.SwingUtilities;

public class NccJob
extends Job {
    public static NccResult lastResult;
    private final int numWindows;
    static NccMsgsFrame nccgui;

    private void prln(String s) {
        System.out.println(s);
    }

    private CellContext[] getSchemLayFromCurrentWindow() {
        CellContext curCellCtxt = NccUtils.getCurrentCellContext();
        if (curCellCtxt == null) {
            this.prln("Please open the Cell you wish to NCC");
            return null;
        }
        Cell[] schLay = NccUtils.findSchematicAndLayout(curCellCtxt.cell);
        if (schLay == null) {
            this.prln("current Cell Group doesn't have both schematic and layout Cells");
            return null;
        }
        CellContext[] cc = new CellContext[]{new CellContext(schLay[0], curCellCtxt.context), new CellContext(schLay[1], curCellCtxt.context)};
        return cc;
    }

    private boolean isSchemOrLay(CellContext cc) {
        boolean ok;
        Cell c = cc.cell;
        View v = c.getView();
        boolean bl = ok = c.isSchematic() || v == View.LAYOUT;
        if (!ok) {
            this.prln("Cell: " + NccUtils.fullName(c) + " isn't schematic or layout");
        }
        return ok;
    }

    private boolean isSchem(CellContext cc) {
        return cc.cell.isSchematic();
    }

    private CellContext[] getTwoCellsFromTwoWindows() {
        List cellCtxts = NccUtils.getCellContextsFromWindows();
        if (cellCtxts.size() < 2) {
            this.prln("Two Cells aren't open in two windows");
            return null;
        }
        if (cellCtxts.size() > 2) {
            this.prln("More than two Cells are open in windows. Could you please");
            this.prln("close windows until only two Cells are open. (Sorry JonL.)");
            return null;
        }
        CellContext[] cellContexts = new CellContext[]{(CellContext)cellCtxts.get(0), (CellContext)cellCtxts.get(1)};
        if (!this.isSchemOrLay(cellContexts[0]) || !this.isSchemOrLay(cellContexts[1])) {
            return null;
        }
        if (!this.isSchem(cellContexts[0]) && this.isSchem(cellContexts[1])) {
            CellContext cc = cellContexts[0];
            cellContexts[0] = cellContexts[1];
            cellContexts[1] = cc;
        }
        return cellContexts;
    }

    private CellContext[] getCellsFromWindows(int numWindows) {
        if (numWindows == 2) {
            return this.getTwoCellsFromTwoWindows();
        }
        return this.getSchemLayFromCurrentWindow();
    }

    private NccOptions getOptionsFromNccConfigDialog() {
        NccOptions options = new NccOptions();
        options.operation = NccGuiOptions.getOperation();
        options.checkSizes = NccGuiOptions.getCheckSizes();
        options.relativeSizeTolerance = NccGuiOptions.getRelativeSizeTolerance() / 100.0;
        options.absoluteSizeTolerance = NccGuiOptions.getAbsoluteSizeTolerance();
        options.skipPassed = NccGuiOptions.getSkipPassed();
        options.howMuchStatus = NccGuiOptions.getHowMuchStatus();
        options.haltAfterFirstMismatch = NccGuiOptions.getHaltAfterFirstMismatch();
        options.maxMismatchedEquivRecsToPrint = NccGuiOptions.getMaxMismatchedClasses();
        options.maxMatchedEquivRecsToPrint = NccGuiOptions.getMaxMatchedClasses();
        options.maxEquivRecMembersToPrint = NccGuiOptions.getMaxClassMembers();
        return options;
    }

    public boolean doIt() {
        lastResult = null;
        LayoutLib.error(this.numWindows != 1 && this.numWindows != 2, "numWindows must be 1 or 2");
        CellContext[] cellCtxts = this.getCellsFromWindows(this.numWindows);
        if (cellCtxts == null) {
            return false;
        }
        NccOptions options = this.getOptionsFromNccConfigDialog();
        NccResult result = Ncc.compare(cellCtxts[0].cell, cellCtxts[0].context, cellCtxts[1].cell, cellCtxts[1].context, options, this);
        if (this.checkAbort()) {
            return true;
        }
        lastResult = result;
        nccgui.setMismatches(result.getAllComparisonMismatches(), options);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                nccgui.display();
            }
        });
        return result.match();
    }

    public NccJob(int numWindows) {
        super("Run NCC", NetworkTool.getNetworkTool(), NccGuiOptions.getBackAnnotateLayoutNetNames() ? Job.Type.CHANGE : Job.Type.EXAMINE, null, null, Job.Priority.ANALYSIS);
        this.numWindows = numWindows;
        this.startJob();
    }

    static {
        nccgui = new NccMsgsFrame();
    }
}

