/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ChangeCurrentLib;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class CircuitChanges {
    private static double lastRotationAmount = 90.0;
    private static FlagSet expandFlagBit;
    static /* synthetic */ Class class$com$sun$electric$database$prototype$PortProto;
    static /* synthetic */ Class class$java$lang$String;

    CircuitChanges() {
    }

    public static void rotateObjects(int amount) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        if (amount == 0) {
            String val = JOptionPane.showInputDialog("Amount to rotate", (Object)new Double(lastRotationAmount));
            if (val == null) {
                return;
            }
            double fAmount = TextUtils.atof(val);
            if (fAmount == 0.0) {
                System.out.println("Null rotation amount");
                return;
            }
            lastRotationAmount = fAmount;
            amount = (int)(fAmount * 10.0);
        }
        RotateSelected job = new RotateSelected(cell, amount, false, false);
    }

    public static void mirrorObjects(boolean horizontally) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        RotateSelected job = new RotateSelected(cell, 0, true, horizontally);
    }

    private static void spreadRotateConnection(NodeInst theNi, FlagSet markObj) {
        Iterator it = theNi.getConnections();
        while (it.hasNext()) {
            NodeInst ni;
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (!ai.isBit(markObj)) continue;
            Connection other = ai.getTail();
            if (other == con) {
                other = ai.getHead();
            }
            if ((ni = other.getPortInst().getNodeInst()).isBit(markObj)) continue;
            ni.setBit(markObj);
            CircuitChanges.spreadRotateConnection(ni, markObj);
        }
    }

    public static void alignToGrid() {
        AlignObjects job = new AlignObjects();
    }

    public static void alignNodes(boolean horizontal, int direction) {
        Rectangle2D bounds;
        NodeInst ni;
        int i;
        Cell np = WindowFrame.needCurCell();
        if (np == null) {
            return;
        }
        List list = Highlight.getHighlighted(true, true);
        if (list.size() == 0) {
            System.out.println("First select objects to move");
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Geometric geom = (Geometric)it.next();
            if (geom.getParent() == np) continue;
            System.out.println("All moved objects must be in the same cell");
            return;
        }
        ArrayList<Geometric> nodes = new ArrayList<Geometric>();
        Iterator it2 = list.iterator();
        while (it2.hasNext()) {
            Geometric geom = (Geometric)it2.next();
            if (!(geom instanceof NodeInst)) continue;
            if (CircuitChanges.cantEdit(np, (NodeInst)geom, true)) {
                return;
            }
            nodes.add(geom);
        }
        int total = nodes.size();
        if (total == 0) {
            return;
        }
        NodeInst[] nis = new NodeInst[total];
        double[] dCX = new double[total];
        double[] dCY = new double[total];
        double[] dSX = new double[total];
        double[] dSY = new double[total];
        int[] dRot = new int[total];
        for (int i2 = 0; i2 < total; ++i2) {
            nis[i2] = (NodeInst)nodes.get(i2);
            dSY[i2] = 0.0;
            dSX[i2] = 0.0;
            dRot[i2] = 0;
        }
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        for (i = 0; i < total; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            if (i == 0) {
                lX = bounds.getMinX();
                hX = bounds.getMaxX();
                lY = bounds.getMinY();
                hY = bounds.getMaxY();
                continue;
            }
            if (bounds.getMinX() < lX) {
                lX = bounds.getMinX();
            }
            if (bounds.getMaxX() > hX) {
                hX = bounds.getMaxX();
            }
            if (bounds.getMinY() < lY) {
                lY = bounds.getMinY();
            }
            if (!(bounds.getMaxY() > hY)) continue;
            hY = bounds.getMaxY();
        }
        block14: for (i = 0; i < total; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            dCY[i] = 0.0;
            dCX[i] = 0.0;
            if (horizontal) {
                switch (direction) {
                    case 0: {
                        dCX[i] = lX - bounds.getMinX();
                        break;
                    }
                    case 1: {
                        dCX[i] = hX - bounds.getMaxX();
                        break;
                    }
                    case 2: {
                        dCX[i] = (lX + hX) / 2.0 - bounds.getCenterX();
                    }
                }
                continue;
            }
            switch (direction) {
                case 0: {
                    dCY[i] = hY - bounds.getMaxY();
                    continue block14;
                }
                case 1: {
                    dCY[i] = lY - bounds.getMinY();
                    continue block14;
                }
                case 2: {
                    dCY[i] = (lY + hY) / 2.0 - bounds.getCenterY();
                }
            }
        }
        AlignNodes job = new AlignNodes(nis, dCX, dCY, dSX, dSY, dRot);
    }

    public static void arcRigidCommand() {
        ChangeArcProperties job = new ChangeArcProperties(1);
    }

    public static void arcNotRigidCommand() {
        ChangeArcProperties job = new ChangeArcProperties(2);
    }

    public static void arcFixedAngleCommand() {
        ChangeArcProperties job = new ChangeArcProperties(3);
    }

    public static void arcNotFixedAngleCommand() {
        ChangeArcProperties job = new ChangeArcProperties(4);
    }

    public static void arcDirectionalCommand() {
        ChangeArcProperties job = new ChangeArcProperties(5);
    }

    public static void arcEndsExtendCommand() {
        ChangeArcProperties job = new ChangeArcProperties(6);
    }

    public static void arcReverseCommand() {
        ChangeArcProperties job = new ChangeArcProperties(7);
    }

    public static void arcSkipHeadCommand() {
        ChangeArcProperties job = new ChangeArcProperties(8);
    }

    public static void arcSkipTailCommand() {
        ChangeArcProperties job = new ChangeArcProperties(9);
    }

    public static void toggleNegatedCommand() {
        ToggleNegationJob job = new ToggleNegationJob();
    }

    public static void ripBus() {
        List list = Highlight.getHighlighted(false, true);
        if (list.size() == 0) {
            System.out.println("Must select bus arcs to rip into individual signals");
            return;
        }
        RipTheBus job = new RipTheBus(list);
    }

    public static void deleteSelected() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            ww.deleteSelectedSignals();
            return;
        }
        if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
            DeleteSelectedGeometry job = new DeleteSelectedGeometry();
        } else {
            DeleteSelected deleteSelected = new DeleteSelected();
        }
    }

    public static void eraseObjectsInList(Cell cell, List list) {
        NodeInst ni;
        NodeInst ni2;
        ArcInst ai;
        Geometric geom;
        FlagSet deleteFlag = Geometric.getFlagSet(2);
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni3 = (NodeInst)it.next();
            ni3.setFlagValue(deleteFlag, 0);
        }
        it = list.iterator();
        while (it.hasNext()) {
            geom = (Geometric)it.next();
            if (!(geom instanceof ArcInst)) continue;
            ai = (ArcInst)geom;
            ai.getHead().getPortInst().getNodeInst().setFlagValue(deleteFlag, 1);
            ai.getTail().getPortInst().getNodeInst().setFlagValue(deleteFlag, 1);
        }
        it = list.iterator();
        while (it.hasNext()) {
            geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst) || CircuitChanges.cantEdit(cell, ni2 = (NodeInst)geom, true) || ni2.getFlagValue(deleteFlag) == 0) continue;
            ni2.setFlagValue(deleteFlag, 2);
        }
        it = list.iterator();
        while (it.hasNext()) {
            geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst)) continue;
            ni2 = (NodeInst)geom;
            Iterator sit = ni2.getConnections();
            while (sit.hasNext()) {
                Connection con = (Connection)sit.next();
                ArcInst ai2 = con.getArc();
                Connection otherEnd = ai2.getHead();
                if (ai2.getHead() == con) {
                    otherEnd = ai2.getTail();
                }
                if (otherEnd.getPortInst().getNodeInst().getFlagValue(deleteFlag) != 0) continue;
                otherEnd.getPortInst().getNodeInst().setFlagValue(deleteFlag, 1);
            }
        }
        it = list.iterator();
        while (it.hasNext()) {
            geom = (Geometric)it.next();
            if (!(geom instanceof ArcInst)) continue;
            ai = (ArcInst)geom;
            ai.kill();
        }
        it = list.iterator();
        while (it.hasNext()) {
            geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst)) continue;
            ni2 = (NodeInst)geom;
            Reconnect re = Reconnect.erasePassThru(ni2, false);
            if (re != null) {
                re.reconnectArcs();
            }
            CircuitChanges.eraseNodeInst(ni2);
        }
        ArrayList<NodeInst> nodesToDelete = new ArrayList<NodeInst>();
        Iterator it2 = cell.getNodes();
        while (it2.hasNext()) {
            ni2 = (NodeInst)it2.next();
            if (ni2.getFlagValue(deleteFlag) == 0 || !(ni2.getProto() instanceof PrimitiveNode) || ni2.getProto().getFunction() != NodeProto.Function.PIN || ni2.getNumConnections() != 0 || ni2.getNumExports() != 0) continue;
            nodesToDelete.add(ni2);
        }
        it2 = nodesToDelete.iterator();
        while (it2.hasNext()) {
            ni2 = (NodeInst)it2.next();
            CircuitChanges.eraseNodeInst(ni2);
        }
        ArrayList<NodeInst> nodesToPassThru = new ArrayList<NodeInst>();
        Iterator it3 = cell.getNodes();
        while (it3.hasNext()) {
            ni = (NodeInst)it3.next();
            if (ni.getFlagValue(deleteFlag) == 0 || !(ni.getProto() instanceof PrimitiveNode) || ni.getProto().getFunction() != NodeProto.Function.PIN || ni.getNumExports() != 0 || !ni.isInlinePin()) continue;
            nodesToPassThru.add(ni);
        }
        it3 = nodesToPassThru.iterator();
        while (it3.hasNext()) {
            ni = (NodeInst)it3.next();
            Reconnect re = Reconnect.erasePassThru(ni, false);
            if (re == null) continue;
            re.reconnectArcs();
            CircuitChanges.eraseNodeInst(ni);
        }
        deleteFlag.freeFlagSet();
    }

    private static void eraseNodeInst(NodeInst ni) {
        int numConnectedArcs = ni.getNumConnections();
        if (numConnectedArcs > 0) {
            ArcInst[] arcsToDelete = new ArcInst[numConnectedArcs];
            int i = 0;
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                arcsToDelete[i++] = con.getArc();
            }
            for (int j = 0; j < numConnectedArcs; ++j) {
                ArcInst ai = arcsToDelete[j];
                ai.kill();
            }
        }
        CircuitChanges.undoExport(ni, null);
        ni.kill();
    }

    private static void undoExport(NodeInst ni, Export spt) {
        Export pp;
        int numExports = ni.getNumExports();
        if (numExports == 0) {
            return;
        }
        Export[] exportsToDelete = new Export[numExports];
        int i = 0;
        Iterator it = ni.getExports();
        while (it.hasNext()) {
            pp = (Export)it.next();
            exportsToDelete[i++] = pp;
        }
        for (int j = 0; j < numExports; ++j) {
            pp = exportsToDelete[j];
            if (spt != null && spt != pp) continue;
            pp.kill();
        }
    }

    public static boolean deleteCell(Cell cell, boolean confirm) {
        int response;
        if (cell.isInUse("delete")) {
            return false;
        }
        if (confirm && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to delete cell " + cell.describe() + "?")) != 0) {
            return false;
        }
        DeleteCell job = new DeleteCell(cell);
        return true;
    }

    private static void doKillCell(Cell cell) {
        Library lib = cell.getLibrary();
        if (cell == lib.getCurCell()) {
            lib.setCurCell(null);
        }
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (content == null || content.getCell() != cell) continue;
            if (!(content instanceof EditWindow)) {
                wf.setCellWindow(null);
                continue;
            }
            content.setCell(null, null);
            content.fullRepaint();
        }
        cell.kill();
    }

    public static void renameCellInJob(Cell cell, String newName) {
        RenameCell job = new RenameCell(cell, newName);
    }

    public static void deleteUnusedOldVersions() {
        DeleteUnusedOldCells job = new DeleteUnusedOldCells();
    }

    public static void graphCellsFromCell() {
        Cell top = WindowFrame.needCurCell();
        if (top == null) {
            return;
        }
        GraphCells job = new GraphCells(top);
    }

    public static void graphCellsInLibrary() {
        GraphCells job = new GraphCells(null);
    }

    private static Cell graphMainView(Cell cell) {
        Cell cellInGroup;
        Iterator it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() == View.SCHEMATIC) {
                return cellInGroup;
            }
            if (!cellInGroup.getView().isMultiPageView()) continue;
            return cellInGroup;
        }
        it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    public static void packageIntoCell() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell curCell = wnd.getCell();
        if (curCell == null) {
            System.out.println("No cell in this window");
            return;
        }
        Rectangle2D bounds = Highlight.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must first select circuitry to package");
            return;
        }
        String newCellName = JOptionPane.showInputDialog("New cell name:", (Object)curCell.getName());
        if (newCellName == null) {
            return;
        }
        newCellName = newCellName + "{" + curCell.getView().getAbbreviation() + "}";
        PackageCell job = new PackageCell(curCell, bounds, newCellName);
    }

    public static void extractCells() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ExtractCellInstances job = new ExtractCellInstances();
    }

    private static void extractOneNode(NodeInst topno) {
        PortInst pi;
        NodeInst newNi;
        NodeInst subNi;
        Cell cell = topno.getParent();
        Cell subCell = (Cell)topno.getProto();
        AffineTransform localTrans = topno.translateOut();
        AffineTransform localRot = topno.rotateOut();
        localTrans.preConcatenate(localRot);
        ArrayList nodes = new ArrayList();
        Iterator it = subCell.getNodes();
        while (it.hasNext()) {
            nodes.add(it.next());
        }
        Collections.sort(nodes, new NodesByName());
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        Iterator it2 = nodes.iterator();
        while (it2.hasNext()) {
            NodeInst newNi2;
            NodeInst ni = (NodeInst)it2.next();
            NodeProto np = ni.getProto();
            if (np == Generic.tech.cellCenterNode || np == Generic.tech.essentialBoundsNode) continue;
            Point2D.Double pt = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            localTrans.transform(pt, pt);
            int newAngle = ni.getAngle();
            newAngle = ni.isXMirrored() == ni.isYMirrored() ? (newAngle += topno.getAngle()) : newAngle + 3600 - topno.getAngle();
            if ((newAngle %= 3600) < 0) {
                newAngle += 3600;
            }
            if ((newNi2 = NodeInst.makeInstance(np, pt, ni.getXSize(), ni.getYSize(), newAngle, cell, ni.getName())) == null) {
                return;
            }
            newNodes.put(ni, newNi2);
            newNi2.setNameTextDescriptor(ni.getNameTextDescriptor());
            newNi2.lowLevelSetUserbits(ni.lowLevelGetUserbits());
            ni.copyVars(newNi2);
        }
        ArrayList arcs = new ArrayList();
        Iterator it3 = subCell.getArcs();
        while (it3.hasNext()) {
            arcs.add(it3.next());
        }
        Collections.sort(arcs, new ArcsByName());
        it3 = arcs.iterator();
        while (it3.hasNext()) {
            ArcInst newAi;
            Poly polyTail;
            ArcInst ai = (ArcInst)it3.next();
            NodeInst niTail = (NodeInst)newNodes.get(ai.getTail().getPortInst().getNodeInst());
            NodeInst niHead = (NodeInst)newNodes.get(ai.getHead().getPortInst().getNodeInst());
            if (niTail == null || niHead == null) continue;
            PortInst piTail = niTail.findPortInstFromProto(ai.getTail().getPortInst().getPortProto());
            PortInst piHead = niHead.findPortInstFromProto(ai.getHead().getPortInst().getPortProto());
            Point2D.Double ptTail = new Point2D.Double();
            localTrans.transform(ai.getTail().getLocation(), ptTail);
            Point2D.Double ptHead = new Point2D.Double();
            localTrans.transform(ai.getHead().getLocation(), ptHead);
            Poly polyHead = piHead.getPoly();
            if (!polyHead.isInside(ptHead)) {
                ((Point2D)ptHead).setLocation(polyHead.getCenterX(), polyHead.getCenterY());
            }
            if (!(polyTail = piTail.getPoly()).isInside(ptTail)) {
                ((Point2D)ptTail).setLocation(polyTail.getCenterX(), polyTail.getCenterY());
            }
            if ((newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), piHead, ptHead, piTail, ptTail, ai.getName())) == null) {
                return;
            }
            ai.copyVars(newAi);
        }
        ArrayList<ArcInst> replaceTheseArcs = new ArrayList<ArcInst>();
        Iterator it4 = topno.getConnections();
        while (it4.hasNext()) {
            Connection con = (Connection)it4.next();
            replaceTheseArcs.add(con.getArc());
        }
        it4 = replaceTheseArcs.iterator();
        while (it4.hasNext()) {
            ArcInst ai = (ArcInst)it4.next();
            ArcProto ap = ai.getProto();
            double wid = ai.getWidth();
            String name = ai.getName();
            PortInst[] pis = new PortInst[2];
            Point2D[] pts = new Point2D[2];
            for (int i = 0; i < 2; ++i) {
                Export pp;
                NodeInst subNi2;
                NodeInst newNi3;
                pis[i] = ai.getConnection(i).getPortInst();
                pts[i] = ai.getConnection(i).getLocation();
                if (pis[i].getNodeInst() != topno || (newNi3 = (NodeInst)newNodes.get(subNi2 = (pp = (Export)pis[i].getPortProto()).getOriginalPort().getNodeInst())) == null) continue;
                pis[i] = newNi3.findPortInstFromProto(pp.getOriginalPort().getPortProto());
            }
            if (pis[0] == null || pis[1] == null) continue;
            ai.kill();
            ArcInst newAi = ArcInst.makeInstance(ap, wid, pis[0], pts[0], pis[1], pts[1], name);
            if (newAi == null) {
                return;
            }
            ai.copyVars(newAi);
        }
        ArrayList existingExports = new ArrayList();
        Iterator it5 = topno.getExports();
        while (it5.hasNext()) {
            existingExports.add(it5.next());
        }
        it5 = existingExports.iterator();
        while (it5.hasNext()) {
            Export pp = (Export)it5.next();
            Export subPp = (Export)pp.getOriginalPort().getPortProto();
            subNi = subPp.getOriginalPort().getNodeInst();
            newNi = (NodeInst)newNodes.get(subNi);
            if (newNi == null) continue;
            pi = newNi.findPortInstFromProto(subPp.getOriginalPort().getPortProto());
            pp.move(pi);
        }
        if (User.isExtractCopiesExports()) {
            ArrayList queuedExports = new ArrayList();
            Iterator it6 = subCell.getPorts();
            while (it6.hasNext()) {
                queuedExports.add(it6.next());
            }
            Collections.sort(queuedExports, new ExportsByName());
            it6 = queuedExports.iterator();
            while (it6.hasNext()) {
                Export pp = (Export)it6.next();
                subNi = pp.getOriginalPort().getNodeInst();
                newNi = (NodeInst)newNodes.get(subNi);
                if (newNi == null) continue;
                pi = newNi.findPortInstFromProto(pp.getOriginalPort().getPortProto());
                boolean alreadyDone = false;
                Iterator eIt = newNi.getExports();
                while (eIt.hasNext()) {
                    Export oPp = (Export)eIt.next();
                    if (oPp.getOriginalPort() != pi) continue;
                    alreadyDone = true;
                    break;
                }
                if (alreadyDone) continue;
                String portName = ElectricObject.uniqueObjectName(pp.getName(), cell, class$com$sun$electric$database$prototype$PortProto == null ? CircuitChanges.class$("com.sun.electric.database.prototype.PortProto") : class$com$sun$electric$database$prototype$PortProto);
                Export.newInstance(cell, pi, portName);
            }
        }
        CircuitChanges.eraseNodeInst(topno);
    }

    public static void cleanupPinsCommand(boolean everywhere) {
        Highlight.clear();
        if (everywhere) {
            boolean cleaned = false;
            Iterator it = Library.getCurrent().getCells();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                if (!CircuitChanges.cleanupCell(cell, false)) continue;
                cleaned = true;
            }
            if (!cleaned) {
                System.out.println("Nothing to clean");
            }
        } else {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return;
            }
            CircuitChanges.cleanupCell(cell, true);
        }
        Highlight.finished();
    }

    private static boolean cleanupCell(Cell cell, boolean justThis) {
        ArcInst ai;
        Iterator cIt;
        ArrayList<NodeInst> pinsToRemove = new ArrayList<NodeInst>();
        ArrayList<Reconnect> pinsToPassThrough = new ArrayList<Reconnect>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Reconnect re;
            NodeInst ni = (NodeInst)it.next();
            if (ni.getFunction() != NodeProto.Function.PIN || ni.getNumExports() > 0) continue;
            if (ni.getNumConnections() == 0) {
                boolean hasDisplayable = false;
                Iterator vIt = ni.getVariables();
                while (vIt.hasNext()) {
                    Variable var = (Variable)vIt.next();
                    if (!var.isDisplay()) continue;
                    hasDisplayable = true;
                    break;
                }
                if (hasDisplayable || CircuitChanges.cantEdit(cell, ni, true)) continue;
                pinsToRemove.add(ni);
                continue;
            }
            if (!ni.isInlinePin() || (re = Reconnect.erasePassThru(ni, false)) == null) continue;
            pinsToPassThrough.add(re);
        }
        HashMap<NodeInst, Point2D.Double> pinsToScale = new HashMap<NodeInst, Point2D.Double>();
        Iterator it2 = cell.getNodes();
        while (it2.hasNext()) {
            double overSizeY;
            NodeInst ni = (NodeInst)it2.next();
            if (ni.getFunction() != NodeProto.Function.PIN) continue;
            double overSizeX = ni.getXSize() - ni.getProto().getDefWidth();
            if (overSizeX < 0.0) {
                overSizeX = 0.0;
            }
            if ((overSizeY = ni.getYSize() - ni.getProto().getDefHeight()) < 0.0) {
                overSizeY = 0.0;
            }
            if (overSizeX == 0.0 && overSizeY == 0.0) continue;
            boolean arcsInCenter = true;
            Iterator cIt2 = ni.getConnections();
            while (cIt2.hasNext()) {
                Connection con = (Connection)cIt2.next();
                ArcInst ai2 = con.getArc();
                if (ai2.getHead().getPortInst().getNodeInst() == ni) {
                    if (ai2.getHead().getLocation().getX() != ni.getAnchorCenterX()) {
                        arcsInCenter = false;
                        break;
                    }
                    if (ai2.getHead().getLocation().getY() != ni.getAnchorCenterY()) {
                        arcsInCenter = false;
                        break;
                    }
                }
                if (ai2.getTail().getPortInst().getNodeInst() != ni) continue;
                if (ai2.getTail().getLocation().getX() != ni.getAnchorCenterX()) {
                    arcsInCenter = false;
                    break;
                }
                if (ai2.getTail().getLocation().getY() == ni.getAnchorCenterY()) continue;
                arcsInCenter = false;
                break;
            }
            if (!arcsInCenter) continue;
            double overSizeArc = 0.0;
            Iterator cIt3 = ni.getConnections();
            while (cIt3.hasNext()) {
                Connection con = (Connection)cIt3.next();
                ArcInst ai3 = con.getArc();
                double overSize = ai3.getWidth() - ai3.getProto().getDefaultWidth();
                if (overSize < 0.0) {
                    overSize = 0.0;
                }
                if (!(overSize > overSizeArc)) continue;
                overSizeArc = overSize;
            }
            if (overSizeArc >= overSizeX && overSizeArc >= overSizeY) continue;
            double dSX = 0.0;
            double dSY = 0.0;
            if (overSizeArc < overSizeX) {
                dSX = overSizeX - overSizeArc;
            }
            if (overSizeArc < overSizeY) {
                dSY = overSizeY - overSizeArc;
            }
            pinsToScale.put(ni, new Point2D.Double(-dSX, -dSY));
        }
        ArrayList<NodeInst> textToMove = new ArrayList<NodeInst>();
        Iterator it3 = cell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = (NodeInst)it3.next();
            Point2D pt = ni.invisiblePinWithOffsetText(false);
            if (pt == null) continue;
            textToMove.add(ni);
        }
        int overSizePins = 0;
        Iterator it4 = cell.getNodes();
        while (it4.hasNext()) {
            NodeInst ni = (NodeInst)it4.next();
            if (ni.getFunction() != NodeProto.Function.PIN) continue;
            boolean nodeIsBad = false;
            cIt = ni.getConnections();
            while (cIt.hasNext()) {
                double i;
                Connection con = (Connection)cIt.next();
                ai = con.getArc();
                Poly poly = ai.curvedArcOutline(ai, Poly.Type.CLOSED, i = ai.getWidth() - ai.getProto().getWidthOffset());
                if (poly == null) {
                    poly = ai.makePoly(ai.getLength(), i, Poly.Type.FILLED);
                }
                Iterator oCIt = ni.getConnections();
                while (oCIt.hasNext()) {
                    double dist;
                    Connection oCon = (Connection)oCIt.next();
                    ArcInst oAi = oCon.getArc();
                    if (ai.getArcIndex() <= oAi.getArcIndex()) continue;
                    double oI = oAi.getWidth() - oAi.getProto().getWidthOffset();
                    Poly oPoly = oAi.curvedArcOutline(oAi, Poly.Type.CLOSED, oI);
                    if (oPoly == null) {
                        oPoly = oAi.makePoly(oAi.getLength(), oI, Poly.Type.FILLED);
                    }
                    if ((dist = poly.separation(oPoly)) <= 0.0) continue;
                    nodeIsBad = true;
                    break;
                }
                if (!nodeIsBad) continue;
                break;
            }
            if (!nodeIsBad) continue;
            if (justThis) {
                Highlight.addElectricObject(ni, cell);
            }
            ++overSizePins;
        }
        HashMap<ArcInst, ArcInst> arcsToKill = new HashMap<ArcInst, ArcInst>();
        Iterator it5 = cell.getNodes();
        block9: while (it5.hasNext()) {
            NodeInst ni = (NodeInst)it5.next();
            cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ai = con.getArc();
                int otherEnd = 0;
                if (ai.getConnection(0) == con) {
                    otherEnd = 1;
                }
                boolean foundAnother = false;
                Iterator oCIt = ni.getConnections();
                while (oCIt.hasNext()) {
                    Connection oCon = (Connection)oCIt.next();
                    ArcInst oAi = oCon.getArc();
                    if (ai.getArcIndex() <= oAi.getArcIndex() || con.getPortInst().getPortProto() != oCon.getPortInst().getPortProto() || ai.getProto() != oAi.getProto()) continue;
                    int oOtherEnd = 0;
                    if (oAi.getConnection(0) == oCon) {
                        oOtherEnd = 1;
                    }
                    if (ai.getConnection(otherEnd).getPortInst().getNodeInst() != oAi.getConnection(oOtherEnd).getPortInst().getNodeInst() || ai.getConnection(otherEnd).getPortInst().getPortProto() != oAi.getConnection(oOtherEnd).getPortInst().getPortProto()) continue;
                    arcsToKill.put(oAi, oAi);
                    foundAnother = true;
                    break;
                }
                if (!foundAnother) continue;
                continue block9;
            }
        }
        int zeroSize = 0;
        int negSize = 0;
        Iterator it6 = cell.getNodes();
        while (it6.hasNext()) {
            NodeInst ni = (NodeInst)it6.next();
            if (ni.getProto() == Generic.tech.cellCenterNode || ni.getProto() == Generic.tech.invisiblePinNode || ni.getProto() == Generic.tech.essentialBoundsNode) continue;
            SizeOffset so = ni.getSizeOffset();
            double sX = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
            double sY = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
            if (sX > 0.0 && sY > 0.0) continue;
            if (justThis) {
                Highlight.addElectricObject(ni, cell);
            }
            if (sX < 0.0 || sY < 0.0) {
                ++negSize;
                continue;
            }
            ++zeroSize;
        }
        if (pinsToRemove.size() == 0 && pinsToPassThrough.size() == 0 && pinsToScale.size() == 0 && zeroSize == 0 && negSize == 0 && textToMove.size() == 0 && overSizePins == 0 && arcsToKill.size() == 0) {
            if (justThis) {
                System.out.println("Nothing to clean");
            }
            return false;
        }
        CleanupChanges job = new CleanupChanges(cell, justThis, pinsToRemove, pinsToPassThrough, pinsToScale, textToMove, arcsToKill, zeroSize, negSize, overSizePins);
        return true;
    }

    public static void showNonmanhattanCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        FlagSet cellMark = NodeProto.getFlagSet(1);
        cellMark.clearOnAllCells();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Iterator aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = (ArcInst)aIt.next();
                    ArcProto ap = ai.getProto();
                    if (ap.getTechnology() == Generic.tech || ap.getTechnology() == Artwork.tech || ap.getTechnology() == Schematics.tech) continue;
                    Variable var = ai.getVar(ArcInst.ARC_RADIUS);
                    if (var != null) {
                        cell.setBit(cellMark);
                    }
                    if (ai.getHead().getLocation().getX() == ai.getTail().getLocation().getX() || ai.getHead().getLocation().getY() == ai.getTail().getLocation().getY()) continue;
                    cell.setBit(cellMark);
                }
                Iterator nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = (NodeInst)nIt.next();
                    if (ni.getAngle() % 900 == 0) continue;
                    cell.setBit(cellMark);
                }
            }
        }
        int i = 0;
        Iterator aIt = curCell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = (ArcInst)aIt.next();
            ArcProto ap = ai.getProto();
            if (ap.getTechnology() == Generic.tech || ap.getTechnology() == Artwork.tech || ap.getTechnology() == Schematics.tech) continue;
            boolean nonMan = false;
            Variable var = ai.getVar(ArcInst.ARC_RADIUS);
            if (var != null) {
                nonMan = true;
            }
            if (ai.getHead().getLocation().getX() != ai.getTail().getLocation().getX() && ai.getHead().getLocation().getY() != ai.getTail().getLocation().getY()) {
                nonMan = true;
            }
            if (!nonMan) continue;
            if (i == 0) {
                Highlight.clear();
            }
            Highlight.addElectricObject(ai, curCell);
            ++i;
        }
        Iterator nIt = curCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = (NodeInst)nIt.next();
            if (ni.getAngle() % 900 == 0) continue;
            if (i == 0) {
                Highlight.clear();
            }
            Highlight.addElectricObject(ni, curCell);
            ++i;
        }
        if (i == 0) {
            System.out.println("No nonmanhattan objects in this cell");
        } else {
            Highlight.finished();
            System.out.println(i + " objects are not manhattan in this cell");
        }
        Iterator lIt2 = Library.getLibraries();
        while (lIt2.hasNext()) {
            Library lib = (Library)lIt2.next();
            if (lib.isHidden()) continue;
            int numBad = 0;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                if (!cell.isBit(cellMark) || cell == curCell) continue;
                ++numBad;
            }
            if (numBad == 0) continue;
            if (lib == Library.getCurrent()) {
                int cellsFound = 0;
                String infstr = "";
                Iterator cIt2 = lib.getCells();
                while (cIt2.hasNext()) {
                    Cell cell = (Cell)cIt2.next();
                    if (cell == curCell || !cell.isBit(cellMark)) continue;
                    if (cellsFound > 0) {
                        infstr = infstr + " ";
                    }
                    infstr = infstr + cell.describe();
                    ++cellsFound;
                }
                if (cellsFound == 1) {
                    System.out.println("Found nonmanhattan geometry in cell " + infstr);
                    continue;
                }
                System.out.println("Found nonmanhattan geometry in these cells: " + infstr);
                continue;
            }
            System.out.println("Found nonmanhattan geometry in library " + lib.getName());
        }
        cellMark.freeFlagSet();
    }

    public static void shortenArcsCommand() {
        ShortenArcs job = new ShortenArcs();
    }

    public static void changeCellView(Cell cell, View newView) {
        if (cell.getView() == newView) {
            return;
        }
        Iterator it = cell.getLibrary().getCells();
        while (it.hasNext()) {
            Cell other = (Cell)it.next();
            if (other.getView() != newView || !other.getName().equalsIgnoreCase(cell.getName())) continue;
            int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "There is already a cell with that view.  Is it okay to make it an older version, and make this the newest version?");
            if (response == 0) break;
            return;
        }
        ChangeCellView job = new ChangeCellView(cell, newView);
    }

    public static void newVersionOfCell(Cell cell) {
        NewCellVersion job = new NewCellVersion(cell);
    }

    public static void makeMultiPageSchematicViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        String newSchematicPage = JOptionPane.showInputDialog("Page Number", (Object)"");
        if (newSchematicPage == null) {
            return;
        }
        int pageNo = TextUtils.atoi(newSchematicPage);
        if (pageNo <= 0) {
            System.out.println("Multi-page schematics are numbered starting at page 1");
            return;
        }
        MakeMultiPageView job = new MakeMultiPageView(curCell, pageNo);
    }

    public static void makeIconViewCommand() {
        MakeIconView job = new MakeIconView();
    }

    public static boolean makeIconExport(Export pp, int index, double xPos, double yPos, double xBBPos, double yBBPos, Cell np) {
        NodeInst pinNi;
        PrimitiveNode pinType = Generic.tech.universalPinNode;
        double pinSizeX = 0.0;
        double pinSizeY = 0.0;
        if (User.getIconGenExportTech() != 0) {
            pinType = Schematics.tech.busPinNode;
            pinSizeX = ((NodeProto)pinType).getDefWidth();
            pinSizeY = ((NodeProto)pinType).getDefHeight();
        }
        PrimitiveArc wireType = Schematics.tech.wire_arc;
        if (pp.getBasePort().connectsTo(Schematics.tech.bus_arc)) {
            wireType = Schematics.tech.bus_arc;
            pinType = Schematics.tech.busPinNode;
            pinSizeX = ((NodeProto)pinType).getDefWidth();
            pinSizeY = ((NodeProto)pinType).getDefHeight();
        }
        if (!User.isIconGenDrawLeads()) {
            xPos = xBBPos;
            yPos = yBBPos;
        }
        if ((pinNi = NodeInst.newInstance(pinType, new Point2D.Double(xPos, yPos), pinSizeX, pinSizeY, 0, np, null)) == null) {
            return false;
        }
        PortInst pi = pinNi.getOnlyPortInst();
        Export port = Export.newInstance(np, pi, pp.getName());
        if (port != null) {
            TextDescriptor td = port.getTextDescriptor();
            block0 : switch (User.getIconGenExportStyle()) {
                case 0: {
                    td.setPos(TextDescriptor.Position.CENT);
                    break;
                }
                case 1: {
                    switch (index) {
                        case 0: {
                            td.setPos(TextDescriptor.Position.RIGHT);
                            break;
                        }
                        case 1: {
                            td.setPos(TextDescriptor.Position.LEFT);
                            break;
                        }
                        case 2: {
                            td.setPos(TextDescriptor.Position.DOWN);
                            break;
                        }
                        case 3: {
                            td.setPos(TextDescriptor.Position.UP);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (index) {
                        case 0: {
                            td.setPos(TextDescriptor.Position.LEFT);
                            break block0;
                        }
                        case 1: {
                            td.setPos(TextDescriptor.Position.RIGHT);
                            break block0;
                        }
                        case 2: {
                            td.setPos(TextDescriptor.Position.UP);
                            break block0;
                        }
                        case 3: {
                            td.setPos(TextDescriptor.Position.DOWN);
                        }
                    }
                }
            }
            double xOffset = 0.0;
            double yOffset = 0.0;
            int loc = User.getIconGenExportLocation();
            if (!User.isIconGenDrawLeads()) {
                loc = 0;
            }
            switch (loc) {
                case 0: {
                    xOffset = xBBPos - xPos;
                    yOffset = yBBPos - yPos;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    xOffset = (xPos + xBBPos) / 2.0 - xPos;
                    yOffset = (yPos + yBBPos) / 2.0 - yPos;
                }
            }
            td.setOff(xOffset, yOffset);
            if (pp.isAlwaysDrawn()) {
                port.setAlwaysDrawn();
            } else {
                port.clearAlwaysDrawn();
            }
            port.setCharacteristic(pp.getCharacteristic());
            port.copyVars(pp);
        }
        if (User.isIconGenDrawLeads()) {
            double hei;
            double wid;
            NodeInst ni;
            pinType = wireType.findPinProto();
            if (pinType == Schematics.tech.busPinNode) {
                pinType = Generic.tech.invisiblePinNode;
            }
            if ((ni = NodeInst.newInstance(pinType, new Point2D.Double(xBBPos, yBBPos), wid = ((NodeProto)pinType).getDefWidth(), hei = ((NodeProto)pinType).getDefHeight(), 0, np, null)) != null) {
                PortInst head = ni.getOnlyPortInst();
                PortInst tail = pinNi.getOnlyPortInst();
                ArcInst ai = ArcInst.makeInstance(wireType, wireType.getDefaultWidth(), head, new Point2D.Double(xBBPos, yBBPos), tail, new Point2D.Double(xPos, yPos), null);
                if (ai != null && wireType == Schematics.tech.bus_arc) {
                    ai.clearExtended();
                }
            }
        }
        return true;
    }

    private static int iconPosition(Export pp) {
        PortProto.Characteristic character = pp.getCharacteristic();
        if (pp.isPower()) {
            character = PortProto.Characteristic.PWR;
        }
        if (pp.isGround()) {
            character = PortProto.Characteristic.GND;
        }
        if (character == PortProto.Characteristic.IN) {
            return User.getIconGenInputSide();
        }
        if (character == PortProto.Characteristic.OUT) {
            return User.getIconGenOutputSide();
        }
        if (character == PortProto.Characteristic.BIDIR) {
            return User.getIconGenBidirSide();
        }
        if (character == PortProto.Characteristic.PWR) {
            return User.getIconGenPowerSide();
        }
        if (character == PortProto.Characteristic.GND) {
            return User.getIconGenGroundSide();
        }
        if (character == PortProto.Characteristic.CLK || character == PortProto.Characteristic.C1 || character == PortProto.Characteristic.C2 || character == PortProto.Characteristic.C3 || character == PortProto.Characteristic.C4 || character == PortProto.Characteristic.C5 || character == PortProto.Characteristic.C6) {
            return User.getIconGenClockSide();
        }
        return User.getIconGenInputSide();
    }

    public static void duplicateCell(Cell cell, String newName) {
        DuplicateCell job = new DuplicateCell(cell, newName);
    }

    public static void manyMove(double dX, double dY) {
        ManyMove job = new ManyMove(dX, dY);
    }

    public static Cell copyRecursively(Cell fromCell, String toName, Library toLib, View toView, boolean verbose, boolean move, String subDescript, boolean noRelatedViews, boolean noSubCells, boolean useExisting) {
        Iterator it;
        NodeProto np;
        Cell newFromCell;
        Date fromCellCreationDate = fromCell.getCreationDate();
        Date fromCellRevisionDate = fromCell.getRevisionDate();
        Iterator it2 = toLib.getCells();
        while (it2.hasNext()) {
            newFromCell = (Cell)it2.next();
            if (!newFromCell.getName().equalsIgnoreCase(toName) || newFromCell.getView() != toView || !newFromCell.getCreationDate().equals(fromCell.getCreationDate()) || !newFromCell.getRevisionDate().equals(fromCell.getRevisionDate())) continue;
            if (subDescript == null) break;
            return newFromCell;
        }
        if (!noSubCells) {
            boolean found = true;
            block1: while (found) {
                found = false;
                Iterator it3 = fromCell.getNodes();
                while (it3.hasNext()) {
                    Cell cell;
                    NodeInst ni = (NodeInst)it3.next();
                    np = ni.getProto();
                    if (!(np instanceof Cell) || (cell = (Cell)np).getLibrary() != fromCell.getLibrary() || cell.getLibrary() == toLib || CircuitChanges.inDestLib(cell, toLib)) continue;
                    Cell oNp = CircuitChanges.copyRecursively(cell, cell.getName(), toLib, cell.getView(), verbose, move, "subcell ", noRelatedViews, noSubCells, useExisting);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of subcell " + cell.describe() + " failed");
                        } else {
                            System.out.println("Copy of subcell " + cell.describe() + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block1;
                }
            }
        }
        if (!noRelatedViews) {
            Cell oNp;
            boolean found = true;
            Cell fromCellWalk = fromCell;
            block3: while (found) {
                found = false;
                it = fromCellWalk.getCellGroup().getCells();
                while (it.hasNext()) {
                    np = (Cell)it.next();
                    if (((Cell)np).getView() != View.ICON || CircuitChanges.inDestLib((Cell)np, toLib)) continue;
                    oNp = CircuitChanges.copyRecursively((Cell)np, np.getName(), toLib, ((Cell)np).getView(), verbose, move, "alternate view ", true, noSubCells, useExisting);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + ((Cell)np).describe() + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + ((Cell)np).describe() + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block3;
                }
            }
            found = true;
            block5: while (found) {
                found = false;
                it = fromCellWalk.getCellGroup().getCells();
                while (it.hasNext()) {
                    np = (Cell)it.next();
                    if (((Cell)np).getView() == View.ICON || CircuitChanges.inDestLib((Cell)np, toLib)) continue;
                    oNp = CircuitChanges.copyRecursively((Cell)np, np.getName(), toLib, ((Cell)np).getView(), verbose, move, "alternate view ", true, noSubCells, useExisting);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + ((Cell)np).describe() + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + ((Cell)np).describe() + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block5;
                }
            }
        }
        Object beforeNewFromCell = null;
        newFromCell = null;
        it = toLib.getCells();
        while (it.hasNext()) {
            Cell thisCell = (Cell)it.next();
            if (!thisCell.getName().equalsIgnoreCase(toName) || thisCell.getView() != toView || thisCell.getCreationDate() != fromCellCreationDate || !move && thisCell.getRevisionDate() != fromCellRevisionDate) continue;
            if (subDescript != null) {
                return thisCell;
            }
            newFromCell = thisCell;
            break;
        }
        if (beforeNewFromCell == newFromCell || newFromCell == null) {
            String newName = toName;
            if (toView.getAbbreviation().length() > 0) {
                newName = toName + "{" + toView.getAbbreviation() + "}";
            }
            if ((newFromCell = Cell.copyNodeProto(fromCell, toLib, newName, useExisting)) == null) {
                if (move) {
                    System.out.println("Move of " + subDescript + fromCell.describe() + " failed");
                } else {
                    System.out.println("Copy of " + subDescript + fromCell.describe() + " failed");
                }
                return null;
            }
            if (move) {
                Iterator it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    Library lib = (Library)it4.next();
                    Iterator cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell np2 = (Cell)cIt.next();
                        boolean found = true;
                        block10: while (found) {
                            found = false;
                            Iterator nIt = np2.getNodes();
                            while (nIt.hasNext()) {
                                NodeInst ni = (NodeInst)nIt.next();
                                if (ni.getProto() != fromCell) continue;
                                NodeInst replacedNi = ni.replace(newFromCell, false, false);
                                if (replacedNi == null) {
                                    System.out.println("Error moving node " + ni.describe() + " in cell " + np2.describe());
                                }
                                found = true;
                                continue block10;
                            }
                        }
                    }
                }
                CircuitChanges.doKillCell(fromCell);
                fromCell = null;
            }
            if (verbose) {
                if (Library.getCurrent() != toLib) {
                    String msg = "";
                    msg = move ? msg + "Moved " : msg + "Copied ";
                    msg = msg + subDescript + Library.getCurrent().getName() + ":" + newFromCell.noLibDescribe() + " to library " + toLib.getName();
                    System.out.println(msg);
                } else {
                    System.out.println("Copied " + subDescript + newFromCell.describe());
                }
            }
        }
        return newFromCell;
    }

    private static boolean inDestLib(Cell np, Library lib) {
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell oNp = (Cell)it.next();
            if (!oNp.getName().equalsIgnoreCase(np.getName()) || oNp.getView() != np.getView() || oNp.getCreationDate() != np.getCreationDate() || oNp.getRevisionDate() != np.getRevisionDate()) continue;
            return true;
        }
        return false;
    }

    public static void expandOneLevelDownCommand() {
        CircuitChanges.DoExpandCommands(false, 1);
    }

    public static void expandFullCommand() {
        CircuitChanges.DoExpandCommands(false, Integer.MAX_VALUE);
    }

    public static void expandSpecificCommand() {
        String obj = JOptionPane.showInputDialog("Number of levels to expand", (Object)"1");
        int levels = TextUtils.atoi(obj);
        CircuitChanges.DoExpandCommands(false, levels);
    }

    public static void unexpandOneLevelUpCommand() {
        CircuitChanges.DoExpandCommands(true, 1);
    }

    public static void unexpandFullCommand() {
        CircuitChanges.DoExpandCommands(true, Integer.MAX_VALUE);
    }

    public static void unexpandSpecificCommand() {
        String obj = JOptionPane.showInputDialog("Number of levels to unexpand", (Object)"1");
        int levels = TextUtils.atoi(obj);
        CircuitChanges.DoExpandCommands(true, levels);
    }

    public static void peekCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Rectangle2D bounds = Highlight.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must define an area in which to display");
            return;
        }
        wnd.repaintContents(bounds);
    }

    private static void DoExpandCommands(boolean unExpand, int amount) {
        List list = Highlight.getHighlighted(true, false);
        ExpandUnExpand job = new ExpandUnExpand(list, unExpand, amount);
    }

    private static void doExpand(NodeInst ni, int amount, int sofar) {
        NodeProto np;
        if (!ni.isExpanded()) {
            ni.setExpanded();
            if (++sofar >= amount) {
                return;
            }
        }
        if (!((np = ni.getProto()) instanceof Cell)) {
            return;
        }
        Cell cell = (Cell)np;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst subNi = (NodeInst)it.next();
            NodeProto subNp = subNi.getProto();
            if (!(subNp instanceof Cell)) continue;
            Cell subCell = (Cell)subNp;
            if (subNi.isIconOfParent()) continue;
            CircuitChanges.doExpand(subNi, amount, sofar);
        }
    }

    private static void doUnExpand(NodeInst ni) {
        if (!ni.isExpanded()) {
            return;
        }
        NodeProto np = ni.getProto();
        if (!(np instanceof Cell)) {
            return;
        }
        Cell cell = (Cell)np;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst subNi = (NodeInst)it.next();
            NodeProto subNp = subNi.getProto();
            if (!(subNp instanceof Cell) || subNi.isIconOfParent() || !subNi.isExpanded()) continue;
            CircuitChanges.doUnExpand(subNi);
        }
        if (ni.isBit(expandFlagBit)) {
            ni.clearExpanded();
        }
    }

    private static int setUnExpand(NodeInst ni, int amount) {
        ni.clearBit(expandFlagBit);
        if (!ni.isExpanded()) {
            return 0;
        }
        NodeProto np = ni.getProto();
        int depth = 0;
        if (np instanceof Cell) {
            Cell cell = (Cell)np;
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst subNi = (NodeInst)it.next();
                NodeProto subNp = subNi.getProto();
                if (!(subNp instanceof Cell) || subNi.isIconOfParent() || !subNi.isExpanded()) continue;
                depth = Math.max(depth, CircuitChanges.setUnExpand(subNi, amount));
            }
            if (depth < amount) {
                ni.setBit(expandFlagBit);
            }
        }
        return depth + 1;
    }

    public static NodeInst replaceNodeInst(NodeInst oldNi, NodeProto newNp, boolean ignorePortNames, boolean allowMissingPorts) {
        NodeInst newNi = oldNi.replace(newNp, ignorePortNames, allowMissingPorts);
        if (newNi != null) {
            if (newNp instanceof PrimitiveNode) {
                for (int i = 0; i < PossibleVariables.list.length; ++i) {
                    Variable var;
                    if (newNi.getProto() == PossibleVariables.list[i].pn || (var = newNi.getVar(PossibleVariables.list[i].varKey)) == null) continue;
                    newNi.delVar(PossibleVariables.list[i].varKey);
                }
            }
            CircuitChanges.inheritAttributes(newNi, true);
        }
        return newNi;
    }

    public static void inheritAttributes(NodeInst ni, boolean cleanUp) {
        Variable var;
        Iterator it;
        NodeProto np = ni.getProto();
        if (np instanceof PrimitiveNode) {
            return;
        }
        Cell cell = (Cell)np;
        Iterator it2 = cell.getVariables();
        while (it2.hasNext()) {
            Variable var2 = (Variable)it2.next();
            if (!var2.getTextDescriptor().isInherit()) continue;
            CircuitChanges.inheritCellAttribute(var2, ni, cell, null);
        }
        it2 = cell.getPorts();
        while (it2.hasNext()) {
            Export pp = (Export)it2.next();
            CircuitChanges.inheritExportAttributes(pp, ni, cell);
        }
        Cell cNp = cell.contentsView();
        if (cNp != null) {
            NodeInst icon = null;
            it = cNp.getNodes();
            while (it.hasNext() && (icon = (NodeInst)it.next()).getProto() != cell) {
                icon = null;
            }
            it = cNp.getVariables();
            while (it.hasNext()) {
                var = (Variable)it.next();
                if (!var.getTextDescriptor().isInherit()) continue;
                CircuitChanges.inheritCellAttribute(var, ni, cNp, icon);
            }
            it = cNp.getPorts();
            while (it.hasNext()) {
                Export cpp = (Export)it.next();
                CircuitChanges.inheritExportAttributes(cpp, ni, cNp);
            }
        }
        if (cleanUp) {
            if (cNp == null) {
                cNp = cell;
            }
            boolean found = true;
            block5: while (found) {
                found = false;
                it = ni.getVariables();
                while (it.hasNext()) {
                    var = (Variable)it.next();
                    if (!var.getTextDescriptor().isParam()) continue;
                    Variable oVar = null;
                    Iterator oIt = cNp.getVariables();
                    boolean delete = true;
                    while (oIt.hasNext()) {
                        oVar = (Variable)oIt.next();
                        if (!oVar.getTextDescriptor().isParam() || !oVar.getKey().equals(var.getKey())) continue;
                        delete = false;
                        break;
                    }
                    if (!delete) continue;
                    ni.delVar(var.getKey());
                    found = true;
                    continue block5;
                }
            }
        }
    }

    private static void inheritExportAttributes(PortProto pp, NodeInst ni, Cell np) {
        Iterator it = pp.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.getTextDescriptor().isInherit()) continue;
            Variable.Key attrKey = var.getKey();
            PortInst pi = ni.findPortInstFromProto(pp);
            Variable newVar = pi.getVar(attrKey);
            if (newVar != null || (newVar = pi.newVar(attrKey, CircuitChanges.inheritAddress(pp, var))) == null) continue;
            double lambda = 1.0;
            TextDescriptor descript = new TextDescriptor(null);
            var.setTextDescriptor(descript);
            double dX = descript.getXOff();
            double dY = descript.getYOff();
        }
    }

    private static void inheritCellAttribute(Variable var, NodeInst ni, Cell np, NodeInst icon) {
        Variable.Key key = var.getKey();
        Variable newVar = ni.getVar(key.getName());
        if (newVar != null) {
            if (!var.getTextDescriptor().isInterior()) {
                if (!newVar.isDisplay()) {
                    newVar.setDisplay(true);
                }
            } else if (newVar.isDisplay() && var.describe(-1, -1).equals(newVar.describe(-1, -1))) {
                newVar.setDisplay(false);
            }
        } else {
            newVar = ni.updateVar(var.getKey(), CircuitChanges.inheritAddress(np, var));
        }
        CircuitChanges.updateInheritedVar(newVar, ni, np, icon);
    }

    public static void updateInheritedVar(Variable nivar, NodeInst ni, Cell np, NodeInst icon) {
        Variable posVar;
        if (nivar == null) {
            return;
        }
        Variable var = posVar = np.getVar(nivar.getKey().getName());
        if (icon != null) {
            Iterator it = icon.getVariables();
            while (it.hasNext()) {
                Variable ivar = (Variable)it.next();
                if (!ivar.getKey().equals(nivar.getKey())) continue;
                posVar = ivar;
                break;
            }
        }
        double xc = posVar.getTextDescriptor().getXOff();
        if (posVar == var) {
            xc -= np.getBounds().getCenterX();
        }
        double yc = posVar.getTextDescriptor().getYOff();
        if (posVar == var) {
            yc -= np.getBounds().getCenterY();
        }
        TextDescriptor oldDescript = posVar.getTextDescriptor();
        TextDescriptor newDescript = nivar.getTextDescriptor();
        nivar.setDisplay(posVar.isDisplay());
        newDescript.setInherit(false);
        newDescript.setOff(xc, yc);
        newDescript.setParam(oldDescript.isParam());
        if (oldDescript.isParam()) {
            newDescript.setInterior(false);
            newDescript.setDispPart(oldDescript.getDispPart());
            newDescript.setPos(oldDescript.getPos());
            newDescript.setRotation(oldDescript.getRotation());
            TextDescriptor.Size s = oldDescript.getSize();
            newDescript.setRelSize(s.getSize());
            newDescript.setBold(oldDescript.isBold());
            newDescript.setItalic(oldDescript.isItalic());
            newDescript.setUnderline(oldDescript.isUnderline());
            newDescript.setFace(oldDescript.getFace());
            TextDescriptor.DispPos i = newDescript.getDispPart();
            if (i == TextDescriptor.DispPos.NAMEVALINH || i == TextDescriptor.DispPos.NAMEVALINHALL) {
                newDescript.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
            }
        }
        nivar.setCode(posVar.getCode());
    }

    private static Object inheritAddress(ElectricObject addr, Variable var) {
        int i;
        Object obj = var.getObject();
        if (obj instanceof Object[]) {
            return obj;
        }
        if (!var.isCode() && !(obj instanceof String)) {
            return obj;
        }
        String str = (String)obj;
        int plusPlusPos = str.indexOf("++");
        int minusMinusPos = str.indexOf("--");
        if (plusPlusPos < 0 && minusMinusPos < 0) {
            return obj;
        }
        int incrPoint = Math.max(plusPlusPos, minusMinusPos);
        String retVal = str.substring(0, incrPoint) + str.substring(incrPoint + 2);
        for (i = incrPoint - 1; i > 0 && Character.isDigit(str.charAt(i)); --i) {
        }
        int curVal = TextUtils.atoi(str.substring(++i));
        curVal = str.charAt(incrPoint) == '+' ? ++curVal : --curVal;
        String newIncrString = str.substring(0, i) + curVal + str.substring(incrPoint + 2);
        addr.newVar(var.getKey(), (Object)newIncrString);
        return retVal;
    }

    public static void changeCurrentLibraryCommand() {
        ChangeCurrentLib.showDialog();
    }

    public static void listLibrariesCommand() {
        System.out.println("----- Libraries: -----");
        int k = 0;
        Iterator it = Library.getVisibleLibrariesSortedByName().iterator();
        while (it.hasNext()) {
            Cell subCell;
            NodeInst ni;
            Iterator nIt;
            Cell cell;
            Iterator cIt;
            Library oLib;
            Library lib = (Library)it.next();
            if (lib.isHidden()) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append(lib.getName());
            if (lib.isChangedMajor() || lib.isChangedMinor()) {
                infstr.append("*");
                ++k;
            }
            if (lib.getLibFile() != null) {
                infstr.append(" (disk file: " + lib.getLibFile() + ")");
            }
            System.out.println(infstr.toString());
            HashSet<String> dummyLibs = new HashSet<String>();
            FlagSet fs = Library.getFlagSet(1);
            Iterator lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                oLib = (Library)lIt.next();
                oLib.clearBit(fs);
            }
            Iterator cIt2 = lib.getCells();
            while (cIt2.hasNext()) {
                Cell cell2 = (Cell)cIt2.next();
                Iterator nIt2 = cell2.getNodes();
                while (nIt2.hasNext()) {
                    NodeInst ni2 = (NodeInst)nIt2.next();
                    if (!(ni2.getProto() instanceof Cell)) continue;
                    Cell subCell2 = (Cell)ni2.getProto();
                    Variable var = subCell2.getVar(Input.IO_TRUE_LIBRARY, class$java$lang$String == null ? CircuitChanges.class$("java.lang.String") : class$java$lang$String);
                    if (var != null) {
                        String pt = (String)var.getObject();
                        dummyLibs.add(pt);
                    }
                    subCell2.getLibrary().setBit(fs);
                }
            }
            lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                oLib = (Library)lIt.next();
                if (oLib == lib || !oLib.isBit(fs)) continue;
                System.out.println("   Makes use of cells in library " + oLib.getName());
                infstr = new StringBuffer();
                infstr.append("      These cells make reference to that library:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = (Cell)cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell) || (subCell = (Cell)ni.getProto()).getLibrary() != oLib) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
            Iterator dIt = dummyLibs.iterator();
            while (dIt.hasNext()) {
                String dummyLibName = (String)dIt.next();
                System.out.println("   Has dummy cells that should be in library " + dummyLibName);
                infstr = new StringBuffer();
                infstr.append("      Instances of these dummy cells are in:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = (Cell)cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell)) continue;
                        subCell = (Cell)ni.getProto();
                        Variable var = subCell.getVar(Input.IO_TRUE_LIBRARY, class$java$lang$String == null ? CircuitChanges.class$("java.lang.String") : class$java$lang$String);
                        if (var == null || !((String)var.getObject()).equals(dummyLibName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
        }
        if (k != 0) {
            System.out.println("   (* means library has changed)");
        }
    }

    public static void renameLibraryCommand() {
        CircuitChanges.renameLibrary(Library.getCurrent());
    }

    public static void renameLibrary(Library lib) {
        String val = JOptionPane.showInputDialog("New Name of Library:", (Object)lib.getName());
        if (val == null) {
            return;
        }
        RenameLibrary job = new RenameLibrary(lib, val);
    }

    public static void markAllLibrariesForSavingCommand() {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden()) continue;
            lib.setChangedMajor();
            lib.setChangedMinor();
        }
        System.out.println("All libraries now need to be saved");
    }

    public static void checkAndRepairCommand() {
        int errorCount = 0;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            errorCount += lib.checkAndRepair();
        }
        if (errorCount > 0) {
            System.out.println("Found " + errorCount + " errors");
        } else {
            System.out.println("No errors found");
        }
    }

    public static boolean cantEdit(Cell cell, NodeInst item, boolean giveError) {
        int ret;
        Object[] options;
        if (item != null) {
            if (item.isLocked()) {
                if (!giveError) {
                    return true;
                }
                options = new String[]{"Yes", "No", "Always"};
                ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to locked node " + item.describe() + " are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                if (ret == 1) {
                    return true;
                }
                if (ret == 2) {
                    item.clearLocked();
                }
            }
            if (item.getProto() instanceof PrimitiveNode) {
                if (item.getProto().isLockedPrim() && User.isDisallowModificationLockedPrims()) {
                    if (!giveError) {
                        return true;
                    }
                    options = new String[]{"Yes", "No", "Always"};
                    ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to locked primitives (such as " + item.describe() + ") are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                    if (ret == 1) {
                        return true;
                    }
                    if (ret == 2) {
                        User.setDisallowModificationLockedPrims(false);
                    }
                }
            } else if (cell.isInstancesLocked()) {
                if (!giveError) {
                    return true;
                }
                options = new String[]{"Yes", "No", "Always"};
                ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Instances in cell " + cell.describe() + " are locked.  You cannot move " + item.describe() + ".  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                if (ret == 1) {
                    return true;
                }
                if (ret == 2) {
                    cell.clearInstancesLocked();
                }
            }
        }
        if (cell.isAllLocked()) {
            if (!giveError) {
                return true;
            }
            options = new String[]{"Yes", "No", "Always"};
            ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to cell " + cell.describe() + " are locked.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
            if (ret == 1) {
                return true;
            }
            if (ret == 2) {
                cell.clearAllLocked();
            }
        }
        return false;
    }

    private static class RenameLibrary
    extends Job {
        Library lib;
        String newName;

        protected RenameLibrary(Library lib, String newName) {
            super("Renaming library " + lib.getName(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            String oldName = this.lib.getName();
            if (this.lib.setName(this.newName)) {
                return false;
            }
            System.out.println("Library " + oldName + " renamed to " + this.newName);
            Iterator it = Library.getLibraries();
            block0: while (it.hasNext()) {
                Library oLib = (Library)it.next();
                if (oLib.isHidden() || oLib == this.lib || oLib.isChangedMajor()) continue;
                Iterator cIt = oLib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = (Cell)cIt.next();
                    Iterator nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        Cell subCell;
                        NodeInst ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell) || (subCell = (Cell)ni.getProto()).getLibrary() != this.lib) continue;
                        oLib.setChangedMajor();
                        break;
                    }
                    if (!oLib.isChangedMajor()) continue;
                    continue block0;
                }
            }
            return true;
        }
    }

    private static class PossibleVariables {
        Variable.Key varKey;
        PrimitiveNode pn;
        public static final PossibleVariables[] list = new PossibleVariables[]{new PossibleVariables("ATTR_length", Schematics.tech.transistorNode), new PossibleVariables("ATTR_length", Schematics.tech.transistor4Node), new PossibleVariables("ATTR_width", Schematics.tech.transistorNode), new PossibleVariables("ATTR_width", Schematics.tech.transistor4Node), new PossibleVariables("ATTR_area", Schematics.tech.transistorNode), new PossibleVariables("ATTR_area", Schematics.tech.transistor4Node), new PossibleVariables("SIM_spice_model", Schematics.tech.sourceNode), new PossibleVariables("SIM_spice_model", Schematics.tech.transistorNode), new PossibleVariables("SIM_spice_model", Schematics.tech.transistor4Node), new PossibleVariables("SCHEM_meter_type", Schematics.tech.meterNode), new PossibleVariables("SCHEM_diode", Schematics.tech.diodeNode), new PossibleVariables("SCHEM_capacitance", Schematics.tech.capacitorNode), new PossibleVariables("SCHEM_resistance", Schematics.tech.resistorNode), new PossibleVariables("SCHEM_inductance", Schematics.tech.inductorNode), new PossibleVariables("SCHEM_function", Schematics.tech.bboxNode)};

        private PossibleVariables(String varName, PrimitiveNode pn) {
            this.varKey = ElectricObject.newKey(varName);
            this.pn = pn;
        }
    }

    private static class ExpandUnExpand
    extends Job {
        List list;
        boolean unExpand;
        int amount;

        protected ExpandUnExpand(List list, boolean unExpand, int amount) {
            super("Change Cell Expansion", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.unExpand = unExpand;
            this.amount = amount;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            Iterator it;
            expandFlagBit = Geometric.getFlagSet(1);
            if (this.unExpand) {
                it = this.list.iterator();
                while (it.hasNext()) {
                    ni = (NodeInst)it.next();
                    NodeProto np = ni.getProto();
                    if (!(np instanceof Cell) || !ni.isExpanded()) continue;
                    CircuitChanges.setUnExpand(ni, this.amount);
                }
            }
            it = this.list.iterator();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                if (this.unExpand) {
                    CircuitChanges.doUnExpand(ni);
                } else {
                    CircuitChanges.doExpand(ni, this.amount, 0);
                }
                Undo.redrawObject(ni);
            }
            expandFlagBit.freeFlagSet();
            EditWindow.repaintAllContents();
            return true;
        }
    }

    private static class Reconnect {
        private NodeInst ni;
        private ArrayList reconnectedArcs;

        private Reconnect() {
        }

        public static Reconnect erasePassThru(NodeInst ni, boolean allowdiffs) {
            Cell cell = ni.getParent();
            if (CircuitChanges.cantEdit(cell, ni, true)) {
                return null;
            }
            Reconnect recon = new Reconnect();
            recon.ni = ni;
            recon.reconnectedArcs = new ArrayList();
            Iterator it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = (PortInst)it.next();
                ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
                Iterator it2 = pi.getConnections();
                while (it2.hasNext()) {
                    Connection conn = (Connection)it2.next();
                    ArcInst ai = conn.getArc();
                    if (ai.getHead().getPortInst().getNodeInst() == ai.getTail().getPortInst().getNodeInst()) continue;
                    arcs.add(ai);
                }
                while (arcs.size() > 1) {
                    ArcInst ai1 = (ArcInst)arcs.remove(0);
                    Iterator it22 = arcs.iterator();
                    while (it22.hasNext()) {
                        ArcInst ai2 = (ArcInst)it22.next();
                        ReconnectedArc ra = Reconnect.reconnectArcs(pi, ai1, ai2, allowdiffs);
                        if (ra == null) continue;
                        recon.reconnectedArcs.add(ra);
                    }
                }
            }
            if (recon.reconnectedArcs.size() == 0) {
                return null;
            }
            return recon;
        }

        private static ReconnectedArc reconnectArcs(PortInst pi, ArcInst ai1, ArcInst ai2, boolean allowdiffs) {
            int i;
            if (ai1.getProto() != ai2.getProto()) {
                return null;
            }
            ReconnectedArc ra = new ReconnectedArc();
            ra.ap = ai1.getProto();
            ReconnectedArc.access$1602(ra, new PortInst[2]);
            ReconnectedArc.access$1702(ra, new Point2D[2]);
            ReconnectedArc.access$1802(ra, new ArcInst[2]);
            ((ReconnectedArc)ra).reconAr[0] = ai1;
            ((ReconnectedArc)ra).reconAr[1] = ai2;
            Point2D[] orig = new Point2D[2];
            Point2D[] delta = new Point2D[2];
            for (i = 0; i < 2; ++i) {
                if (ai1.getConnection(i).getPortInst() != pi) {
                    ((ReconnectedArc)ra).reconPi[0] = ai1.getConnection(i).getPortInst();
                    ((ReconnectedArc)ra).recon[0] = ai1.getConnection(i).getLocation();
                } else {
                    orig[0] = ai1.getConnection(i).getLocation();
                }
                if (ai2.getConnection(i).getPortInst() != pi) {
                    ((ReconnectedArc)ra).reconPi[1] = ai2.getConnection(i).getPortInst();
                    ((ReconnectedArc)ra).recon[1] = ai2.getConnection(i).getLocation();
                    continue;
                }
                orig[1] = ai2.getConnection(i).getLocation();
            }
            delta[0] = new Point2D.Double(ra.recon[0].getX() - orig[0].getX(), ra.recon[0].getY() - orig[0].getY());
            delta[1] = new Point2D.Double(ra.recon[1].getX() - orig[1].getX(), ra.recon[1].getY() - orig[1].getY());
            if (!allowdiffs) {
                if (ai1.getWidth() != ai2.getWidth()) {
                    return null;
                }
                if (delta[1].getX() * delta[0].getY() != delta[0].getX() * delta[1].getY()) {
                    return null;
                }
                if (orig[0].getX() != orig[1].getX() || orig[0].getY() != orig[1].getY()) {
                    if (delta[0].getX() != 0.0 || delta[0].getY() != 0.0) {
                        if ((orig[0].getX() - orig[1].getX()) * delta[0].getY() != delta[0].getX() * (orig[0].getY() - orig[1].getY())) {
                            return null;
                        }
                    } else if (delta[1].getX() != 0.0 || delta[1].getY() != 0.0) {
                        if ((orig[0].getX() - orig[1].getX()) * delta[1].getY() != delta[1].getX() * (orig[0].getY() - orig[1].getY())) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
            }
            ra.wid = ai1.getWidth();
            ra.directional = ai1.isDirectional() || ai2.isDirectional();
            ra.ignoreHead = ai1.isSkipHead() || ai2.isSkipHead();
            ra.ignoreTail = ai1.isSkipTail() || ai2.isSkipTail();
            ra.reverseEnd = ai1.isReverseEnds() || ai2.isReverseEnds();
            ra.arcName = null;
            if (ai1.getName() != null && !ai1.getNameKey().isTempname()) {
                ra.arcName = ai1.getName();
                ra.arcNameTD = ai1.getNameTextDescriptor();
            }
            if (ai2.getName() != null && !ai2.getNameKey().isTempname()) {
                ra.arcName = ai2.getName();
                ra.arcNameTD = ai2.getNameTextDescriptor();
            }
            if (ra.directional || ra.negated || ra.ignoreHead || ra.ignoreTail || ra.reverseEnd) {
                for (i = 0; i < 2; ++i) {
                    if (ra.reconAr[i].getConnection(i).getPortInst() != pi) continue;
                    if (ra.reconAr[i].isReverseEnds()) {
                        ra.reverseEnd = false;
                        continue;
                    }
                    ra.reverseEnd = true;
                }
            }
            return ra;
        }

        public List reconnectArcs() {
            ArrayList<ArcInst> newArcs = new ArrayList<ArcInst>();
            Iterator it = this.reconnectedArcs.iterator();
            while (it.hasNext()) {
                ArcInst newAi;
                ReconnectedArc ra = (ReconnectedArc)it.next();
                if (!ra.reconPi[0].getNodeInst().isLinked() || !ra.reconPi[1].getNodeInst().isLinked() || (newAi = ArcInst.makeInstance(ra.ap, ra.wid, ra.reconPi[0], ra.recon[0], ra.reconPi[1], ra.recon[1], null)) == null) continue;
                if (ra.directional) {
                    newAi.setDirectional();
                }
                if (ra.ignoreHead) {
                    newAi.setSkipHead();
                }
                if (ra.ignoreTail) {
                    newAi.setSkipTail();
                }
                if (ra.reverseEnd) {
                    newAi.setReverseEnds();
                }
                if (ra.arcName != null) {
                    newAi.setName(ra.arcName);
                    newAi.setNameTextDescriptor(ra.arcNameTD);
                }
                ra.reconAr[0].copyVars(newAi);
                ra.reconAr[1].copyVars(newAi);
                newArcs.add(newAi);
            }
            return newArcs;
        }
    }

    private static class ReconnectedArc {
        private PortInst[] reconPi;
        private Point2D[] recon;
        private ArcInst[] reconAr;
        private ArcProto ap;
        private double wid;
        private boolean directional;
        private boolean negated;
        private boolean ignoreHead;
        private boolean ignoreTail;
        private boolean reverseEnd;
        private String arcName;
        private TextDescriptor arcNameTD;

        private ReconnectedArc() {
        }

        static /* synthetic */ PortInst[] access$1602(ReconnectedArc x0, PortInst[] x1) {
            x0.reconPi = x1;
            return x1;
        }

        static /* synthetic */ Point2D[] access$1702(ReconnectedArc x0, Point2D[] x1) {
            x0.recon = x1;
            return x1;
        }

        static /* synthetic */ ArcInst[] access$1802(ReconnectedArc x0, ArcInst[] x1) {
            x0.reconAr = x1;
            return x1;
        }
    }

    private static class ManyMove
    extends Job {
        double dX;
        double dY;
        static final boolean verbose = false;

        protected ManyMove(double dX, double dY) {
            super("Move", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dX = dX;
            this.dY = dY;
            this.startJob();
        }

        public boolean doIt() {
            ArcInst ai;
            ElectricObject eobj;
            Highlight h;
            ArcInst ai2;
            Highlight h2;
            NodeInst ni;
            ArcInst ai3;
            ElectricObject eobj2;
            Highlight h3;
            int total = Highlight.getNumHighlights();
            if (total <= 0) {
                return false;
            }
            List highlightedText = Highlight.getHighlightedText(true);
            Iterator oit = Highlight.getHighlights();
            Highlight firstH = (Highlight)oit.next();
            ElectricObject firstEObj = firstH.getElectricObject();
            Cell cell = firstH.getCell();
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            if (total == 1 && firstH.getType() == Highlight.Type.EOBJ && (firstEObj instanceof NodeInst || firstEObj instanceof PortInst)) {
                NodeInst ni2 = firstEObj instanceof PortInst ? ((PortInst)firstEObj).getNodeInst() : (NodeInst)firstEObj;
                if (CircuitChanges.cantEdit(cell, ni2, true)) {
                    return false;
                }
                ni2.modifyInstance(this.dX, this.dY, 0.0, 0.0, 0);
                return true;
            }
            boolean found = false;
            Iterator it = Highlight.getHighlights();
            while (it.hasNext()) {
                int j;
                h3 = (Highlight)it.next();
                if (h3.getType() != Highlight.Type.EOBJ || !((eobj2 = h3.getElectricObject()) instanceof ArcInst) || (ai3 = (ArcInst)eobj2).getHead().getLocation().getX() == ai3.getTail().getLocation().getX() || ai3.getHead().getLocation().getY() == ai3.getTail().getLocation().getY() || !ai3.isFixedAngle() || ai3.isRigid()) continue;
                for (j = 0; j < 2; ++j) {
                    ni = ai3.getConnection(j).getPortInst().getNodeInst();
                    ArcInst oai = null;
                    Iterator pIt = ni.getConnections();
                    while (pIt.hasNext()) {
                        Connection con = (Connection)pIt.next();
                        if (con.getArc() == ai3) continue;
                        if (oai == null) {
                            oai = con.getArc();
                            continue;
                        }
                        oai = null;
                        break;
                    }
                    if (oai == null || oai.getHead().getLocation().getX() != oai.getTail().getLocation().getX() && oai.getHead().getLocation().getY() != oai.getTail().getLocation().getY()) break;
                }
                if (j < 2) continue;
                found = true;
                break;
            }
            if (found) {
                it = Highlight.getHighlights();
                while (it.hasNext()) {
                    int j;
                    h3 = (Highlight)it.next();
                    if (h3.getType() != Highlight.Type.EOBJ || !((eobj2 = h3.getElectricObject()) instanceof ArcInst)) continue;
                    ai3 = (ArcInst)eobj2;
                    double[] deltaXs = new double[2];
                    double[] deltaYs = new double[2];
                    double[] deltaNulls = new double[2];
                    int[] deltaRots = new int[2];
                    NodeInst[] niList = new NodeInst[2];
                    deltaNulls[1] = 0.0;
                    deltaNulls[0] = 0.0;
                    deltaYs[1] = 0.0;
                    deltaXs[1] = 0.0;
                    deltaYs[0] = 0.0;
                    deltaXs[0] = 0.0;
                    int arcangle = ai3.getAngle();
                    for (j = 0; j < 2; ++j) {
                        Point2D iPt;
                        NodeInst ni3;
                        niList[j] = ni3 = ai3.getConnection(j).getPortInst().getNodeInst();
                        ArcInst oai = null;
                        Iterator pIt = ni3.getConnections();
                        while (pIt.hasNext()) {
                            Connection con = (Connection)pIt.next();
                            if (con.getArc() == ai3) continue;
                            oai = con.getArc();
                            break;
                        }
                        if (oai == null) break;
                        if (DBMath.doublesEqual(oai.getHead().getLocation().getX(), oai.getTail().getLocation().getX())) {
                            iPt = DBMath.intersect(oai.getHead().getLocation(), 900, new Point2D.Double(ai3.getHead().getLocation().getX() + this.dX, ai3.getHead().getLocation().getY() + this.dY), arcangle);
                            deltaXs[j] = iPt.getX() - ai3.getConnection(j).getLocation().getX();
                            deltaYs[j] = iPt.getY() - ai3.getConnection(j).getLocation().getY();
                            continue;
                        }
                        if (!DBMath.doublesEqual(oai.getHead().getLocation().getY(), oai.getTail().getLocation().getY())) continue;
                        iPt = DBMath.intersect(oai.getHead().getLocation(), 0, new Point2D.Double(ai3.getHead().getLocation().getX() + this.dX, ai3.getHead().getLocation().getY() + this.dY), arcangle);
                        deltaXs[j] = iPt.getX() - ai3.getConnection(j).getLocation().getX();
                        deltaYs[j] = iPt.getY() - ai3.getConnection(j).getLocation().getY();
                    }
                    if (j < 2) continue;
                    deltaRots[1] = 0;
                    deltaRots[0] = 0;
                    NodeInst.modifyInstances(niList, deltaXs, deltaYs, deltaNulls, deltaNulls, deltaRots);
                }
                return true;
            }
            boolean onlySlidable = true;
            boolean foundArc = false;
            Iterator it2 = Highlight.getHighlights();
            while (it2.hasNext()) {
                h2 = (Highlight)it2.next();
                if (h2.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj3 = h2.getElectricObject();
                if (eobj3 instanceof ArcInst) {
                    ai2 = (ArcInst)eobj3;
                    foundArc = true;
                    if (ai2.isSlidable()) {
                        Connection head = ai2.getHead();
                        Connection tail = ai2.getTail();
                        Point2D.Double newHead = new Point2D.Double(head.getLocation().getX() + this.dX, head.getLocation().getY() + this.dY);
                        Point2D.Double newTail = new Point2D.Double(tail.getLocation().getX() + this.dX, tail.getLocation().getY() + this.dY);
                        if (ai2.stillInPort(head, newHead, true) && ai2.stillInPort(tail, newTail, true)) continue;
                    }
                }
                onlySlidable = false;
            }
            if (foundArc && onlySlidable) {
                it2 = Highlight.getHighlights();
                while (it2.hasNext()) {
                    ElectricObject eobj4;
                    h2 = (Highlight)it2.next();
                    if (h2.getType() != Highlight.Type.EOBJ || !((eobj4 = h2.getElectricObject()) instanceof ArcInst)) continue;
                    ai2 = (ArcInst)eobj4;
                    ai2.modify(0.0, this.dX, this.dY, this.dX, this.dY);
                }
                return true;
            }
            FlagSet flag = Geometric.getFlagSet(1);
            Iterator it3 = cell.getNodes();
            while (it3.hasNext()) {
                NodeInst ni4 = (NodeInst)it3.next();
                ni4.clearBit(flag);
                if (CircuitChanges.cantEdit(cell, ni4, true)) continue;
                ni4.setTempObj(new Point2D.Double(ni4.getAnchorCenterX(), ni4.getAnchorCenterY()));
            }
            it3 = cell.getArcs();
            while (it3.hasNext()) {
                ArcInst ai4 = (ArcInst)it3.next();
                ai4.setTempObj(new Point2D.Double(ai4.getTrueCenterX(), ai4.getTrueCenterY()));
            }
            int numNodes = 0;
            Iterator it4 = Highlight.getHighlights();
            while (it4.hasNext()) {
                h = (Highlight)it4.next();
                if (h.getType() != Highlight.Type.EOBJ) continue;
                eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (eobj instanceof NodeInst) {
                    NodeInst ni5 = (NodeInst)eobj;
                    if (!ni5.isBit(flag)) {
                        ++numNodes;
                    }
                    ni5.setBit(flag);
                    continue;
                }
                if (!(eobj instanceof ArcInst)) continue;
                ai = (ArcInst)eobj;
                NodeInst ni1 = ai.getHead().getPortInst().getNodeInst();
                NodeInst ni2 = ai.getTail().getPortInst().getNodeInst();
                if (!ni1.isBit(flag)) {
                    ++numNodes;
                }
                if (!ni2.isBit(flag)) {
                    ++numNodes;
                }
                ni1.setBit(flag);
                ni2.setBit(flag);
                Layout.setTempRigid(ai, true);
            }
            if (numNodes > 0) {
                NodeInst[] nis = new NodeInst[numNodes];
                double[] dXs = new double[numNodes];
                double[] dYs = new double[numNodes];
                double[] dSize = new double[numNodes];
                int[] dRot = new int[numNodes];
                boolean[] dTrn = new boolean[numNodes];
                numNodes = 0;
                Iterator it5 = cell.getNodes();
                while (it5.hasNext()) {
                    NodeInst ni6 = (NodeInst)it5.next();
                    if (!ni6.isBit(flag)) continue;
                    nis[numNodes] = ni6;
                    dXs[numNodes] = this.dX;
                    dYs[numNodes] = this.dY;
                    dSize[numNodes] = 0.0;
                    dRot[numNodes] = 0;
                    dTrn[numNodes] = false;
                    ++numNodes;
                }
                NodeInst.modifyInstances(nis, dXs, dYs, dSize, dSize, dRot);
            }
            flag.freeFlagSet();
            it4 = Highlight.getHighlights();
            while (it4.hasNext()) {
                Point2D pt;
                h = (Highlight)it4.next();
                if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst) || (pt = (Point2D)(ai = (ArcInst)eobj).getTempObj()).getX() != ai.getTrueCenterX() || pt.getY() != ai.getTrueCenterY()) continue;
                boolean headInPort = false;
                boolean tailInPort = false;
                if (!ai.isRigid() && ai.isSlidable()) {
                    headInPort = ai.stillInPort(ai.getHead(), new Point2D.Double(ai.getHead().getLocation().getX() + this.dX, ai.getHead().getLocation().getY() + this.dY), true);
                    tailInPort = ai.stillInPort(ai.getTail(), new Point2D.Double(ai.getTail().getLocation().getX() + this.dX, ai.getTail().getLocation().getY() + this.dY), true);
                }
                if (headInPort && tailInPort) {
                    ai.modify(0.0, this.dX, this.dY, this.dX, this.dY);
                    continue;
                }
                if (headInPort || tailInPort) continue;
                for (int k = 0; k < 2; ++k) {
                    NodeInst ni7 = k == 0 ? ai.getHead().getPortInst().getNodeInst() : ai.getTail().getPortInst().getNodeInst();
                    Point2D nPt = (Point2D)ni7.getTempObj();
                    if (ni7.getAnchorCenterX() != nPt.getX() || ni7.getAnchorCenterY() != nPt.getY()) continue;
                    Iterator oIt = Highlight.getHighlights();
                    while (oIt.hasNext()) {
                        ArcInst oai;
                        Point2D aPt;
                        ElectricObject oEObj;
                        Highlight oH = (Highlight)oIt.next();
                        if (oH.getType() != Highlight.Type.EOBJ || !((oEObj = oH.getElectricObject()) instanceof ArcInst) || (aPt = (Point2D)(oai = (ArcInst)oEObj).getTempObj()).getX() != oai.getTrueCenterX() || aPt.getY() != oai.getTrueCenterY() || oai.stillInPort(oai.getHead(), new Point2D.Double(ai.getHead().getLocation().getX() + this.dX, ai.getHead().getLocation().getY() + this.dY), true) || oai.stillInPort(oai.getTail(), new Point2D.Double(ai.getTail().getLocation().getX() + this.dX, ai.getTail().getLocation().getY() + this.dY), true)) continue;
                        Layout.setTempRigid(oai, true);
                    }
                    ni7.modifyInstance(this.dX - (ni7.getAnchorCenterX() - nPt.getX()), this.dY - (ni7.getAnchorCenterY() - nPt.getY()), 0.0, 0.0, 0);
                }
            }
            it4 = cell.getNodes();
            while (it4.hasNext()) {
                ni = (NodeInst)it4.next();
                ni.setTempObj(null);
            }
            it4 = cell.getArcs();
            while (it4.hasNext()) {
                ai2 = (ArcInst)it4.next();
                ai2.setTempObj(null);
            }
            this.moveSelectedText(highlightedText);
            return true;
        }

        private void moveSelectedText(List highlightedText) {
            Iterator it = highlightedText.iterator();
            while (it.hasNext()) {
                NodeInst ni;
                TextDescriptor td;
                Variable var;
                Highlight high = (Highlight)it.next();
                Cell np = high.getCell();
                if (np != null && CircuitChanges.cantEdit(np, null, true)) continue;
                ElectricObject eobj = high.getElectricObject();
                if (high.nodeMovesWithText()) {
                    NodeInst ni2 = null;
                    if (eobj instanceof NodeInst) {
                        ni2 = (NodeInst)eobj;
                    }
                    if (eobj instanceof Export) {
                        ni2 = ((Export)eobj).getOriginalPort().getNodeInst();
                    }
                    if (ni2 != null) {
                        ni2.modifyInstance(this.dX, this.dY, 0.0, 0.0, 0);
                        continue;
                    }
                }
                if ((var = high.getVar()) != null) {
                    td = var.getTextDescriptor();
                    if (eobj instanceof NodeInst || eobj instanceof PortInst || eobj instanceof Export) {
                        ni = null;
                        if (eobj instanceof NodeInst) {
                            ni = (NodeInst)eobj;
                        } else if (eobj instanceof PortInst) {
                            ni = ((PortInst)eobj).getNodeInst();
                        } else if (eobj instanceof Export) {
                            ni = ((Export)eobj).getOriginalPort().getNodeInst();
                        }
                        if (ni == null) continue;
                        this.adjustTextDescriptor(td, ni);
                        continue;
                    }
                    td.setOff(td.getXOff() + this.dX, td.getYOff() + this.dY);
                    continue;
                }
                if (high.getName() != null) {
                    td = ((Geometric)eobj).getNameTextDescriptor();
                    if (eobj instanceof NodeInst) {
                        ni = (NodeInst)eobj;
                        this.adjustTextDescriptor(td, ni);
                        continue;
                    }
                    td.setOff(td.getXOff() + this.dX, td.getYOff() + this.dY);
                    continue;
                }
                if (!(eobj instanceof Export)) continue;
                Export pp = (Export)eobj;
                TextDescriptor td2 = pp.getTextDescriptor();
                this.adjustTextDescriptor(td2, pp.getOriginalPort().getNodeInst());
            }
        }

        private void adjustTextDescriptor(TextDescriptor td, NodeInst ni) {
            Point2D.Double curLoc = new Point2D.Double(ni.getAnchorCenterX() + td.getXOff(), ni.getAnchorCenterY() + td.getYOff());
            AffineTransform rotateOut = ni.rotateOut();
            rotateOut.transform(curLoc, curLoc);
            ((Point2D)curLoc).setLocation(((Point2D)curLoc).getX() + this.dX, ((Point2D)curLoc).getY() + this.dY);
            AffineTransform rotateIn = ni.rotateIn();
            rotateIn.transform(curLoc, curLoc);
            td.setOff(((Point2D)curLoc).getX() - ni.getAnchorCenterX(), ((Point2D)curLoc).getY() - ni.getAnchorCenterY());
        }
    }

    private static class DuplicateCell
    extends Job {
        Cell cell;
        String newName;

        protected DuplicateCell(Cell cell, String newName) {
            super("Duplicate cell " + cell.describe(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            Cell dupCell = Cell.copyNodeProto(this.cell, this.cell.getLibrary(), this.newName + "{" + this.cell.getView().getAbbreviation() + "}", false);
            if (dupCell == null) {
                return false;
            }
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (content == null || content.getCell() != this.cell) continue;
                content.setCell(dupCell, VarContext.globalContext);
            }
            EditWindow.repaintAll();
            return true;
        }
    }

    private static class MakeIconView
    extends Job {
        private static boolean reverseIconExportOrder;

        protected MakeIconView() {
            super("Make Icon View", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            int response;
            Cell curCell = WindowFrame.needCurCell();
            if (curCell == null) {
                return false;
            }
            Library lib = curCell.getLibrary();
            if (!curCell.isSchematicView()) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "The current cell must be a schematic in order to generate an icon", "Icon creation failed", 0);
                return false;
            }
            Cell iconCell = curCell.iconView();
            if (iconCell != null && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Warning: Icon " + iconCell.describe() + " already exists.  Create a new version?")) != 0) {
                return false;
            }
            double leadLength = User.getIconGenLeadLength();
            double leadSpacing = User.getIconGenLeadSpacing();
            reverseIconExportOrder = User.isIconGenReverseExportOrder();
            ArrayList exportList = new ArrayList();
            Iterator it = curCell.getPorts();
            while (it.hasNext()) {
                exportList.add(it.next());
            }
            Collections.sort(exportList, new ExportSorted());
            String iconCellName = curCell.getName() + "{ic}";
            iconCell = Cell.makeInstance(lib, iconCellName);
            if (iconCell == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create Icon cell " + iconCellName, "Icon creation failed", 0);
                return false;
            }
            iconCell.setWantExpanded();
            int leftSide = 0;
            int rightSide = 0;
            int bottomSide = 0;
            int topSide = 0;
            Iterator it2 = exportList.iterator();
            while (it2.hasNext()) {
                Export pp = (Export)it2.next();
                if (pp.isBodyOnly()) continue;
                int index = CircuitChanges.iconPosition(pp);
                switch (index) {
                    case 0: {
                        pp.setTempInt(leftSide++);
                        break;
                    }
                    case 1: {
                        pp.setTempInt(rightSide++);
                        break;
                    }
                    case 2: {
                        pp.setTempInt(topSide++);
                        break;
                    }
                    case 3: {
                        pp.setTempInt(bottomSide++);
                    }
                }
            }
            double ySize = (double)Math.max(Math.max(leftSide, rightSide), 5) * leadSpacing;
            double xSize = (double)Math.max(Math.max(topSide, bottomSide), 3) * leadSpacing;
            NodeInst bbNi = null;
            if (User.isIconGenDrawBody()) {
                bbNi = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(0.0, 0.0), xSize, ySize, 0, iconCell, null);
                if (bbNi == null) {
                    return false;
                }
                bbNi.newVar(Artwork.ART_COLOR, (Object)new Integer(10));
                Variable var = bbNi.newVar(Schematics.SCHEM_FUNCTION, (Object)curCell.getName());
                if (var != null) {
                    var.setDisplay(true);
                }
            }
            int total = 0;
            Iterator it3 = exportList.iterator();
            while (it3.hasNext()) {
                Export pp = (Export)it3.next();
                if (pp.isBodyOnly()) continue;
                int index = CircuitChanges.iconPosition(pp);
                double spacing = leadSpacing;
                double xPos = 0.0;
                double yPos = 0.0;
                double xBBPos = 0.0;
                double yBBPos = 0.0;
                switch (index) {
                    case 0: {
                        xBBPos = -xSize / 2.0;
                        xPos = xBBPos - leadLength;
                        if (leftSide * 2 < rightSide) {
                            spacing = leadSpacing * 2.0;
                        }
                        yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(leftSide - 1) * spacing) / 2.0 + (double)pp.getTempInt() * spacing);
                        break;
                    }
                    case 1: {
                        xBBPos = xSize / 2.0;
                        xPos = xBBPos + leadLength;
                        if (rightSide * 2 < leftSide) {
                            spacing = leadSpacing * 2.0;
                        }
                        yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(rightSide - 1) * spacing) / 2.0 + (double)pp.getTempInt() * spacing);
                        break;
                    }
                    case 2: {
                        if (topSide * 2 < bottomSide) {
                            spacing = leadSpacing * 2.0;
                        }
                        xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(topSide - 1) * spacing) / 2.0 + (double)pp.getTempInt() * spacing);
                        yBBPos = ySize / 2.0;
                        yPos = yBBPos + leadLength;
                        break;
                    }
                    case 3: {
                        if (bottomSide * 2 < topSide) {
                            spacing = leadSpacing * 2.0;
                        }
                        xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(bottomSide - 1) * spacing) / 2.0 + (double)pp.getTempInt() * spacing);
                        yBBPos = -ySize / 2.0;
                        yPos = yBBPos - leadLength;
                    }
                }
                if (!CircuitChanges.makeIconExport(pp, index, xPos, yPos, xBBPos, yBBPos, iconCell)) continue;
                ++total;
            }
            if (!User.isIconGenDrawBody() && !User.isIconGenDrawLeads() && User.isPlaceCellCenter() && total <= 1) {
                NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 0.0), xSize, ySize, 0, iconCell, null);
            }
            int exampleLocation = User.getIconGenInstanceLocation();
            Point2D.Double iconPos = new Point2D.Double(0.0, 0.0);
            Rectangle2D cellBounds = curCell.getBounds();
            Rectangle2D iconBounds = iconCell.getBounds();
            double halfWidth = iconBounds.getWidth() / 2.0;
            double halfHeight = iconBounds.getHeight() / 2.0;
            switch (exampleLocation) {
                case 0: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMaxX() + halfWidth, cellBounds.getMaxY() + halfHeight);
                    break;
                }
                case 1: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMaxY() + halfHeight);
                    break;
                }
                case 2: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMaxX() + halfWidth, cellBounds.getMinY() - halfHeight);
                    break;
                }
                case 3: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMinY() - halfHeight);
                }
            }
            EditWindow.gridAlign(iconPos);
            double px = iconCell.getBounds().getWidth();
            double py = iconCell.getBounds().getHeight();
            NodeInst ni = NodeInst.makeInstance(iconCell, iconPos, px, py, 0, curCell, null);
            if (ni != null) {
                Highlight.clear();
                Highlight.addElectricObject(ni, curCell);
                Highlight.finished();
            }
            return true;
        }

        static class ExportSorted
        implements Comparator {
            ExportSorted() {
            }

            public int compare(Object o1, Object o2) {
                Export e1 = (Export)o1;
                Export e2 = (Export)o2;
                String s1 = e1.getName();
                String s2 = e2.getName();
                if (reverseIconExportOrder) {
                    return s2.compareToIgnoreCase(s1);
                }
                return s1.compareToIgnoreCase(s2);
            }
        }
    }

    private static class MakeMultiPageView
    extends Job {
        private Cell cell;
        private int pageNo;

        protected MakeMultiPageView(Cell cell, int pageNo) {
            super("Make Icon View", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.pageNo = pageNo;
            this.startJob();
        }

        public boolean doIt() {
            Cell otherView;
            View v = View.findMultiPageSchematicView(this.pageNo);
            if (v == null) {
                v = View.newMultiPageSchematicInstance(this.pageNo);
            }
            if ((otherView = this.cell.otherView(v)) == null) {
                otherView = Cell.makeInstance(this.cell.getLibrary(), this.cell.getName() + "{p" + this.pageNo + "}");
            }
            WindowFrame.createEditWindow(otherView);
            return true;
        }
    }

    private static class NewCellVersion
    extends Job {
        Cell cell;

        protected NewCellVersion(Cell cell) {
            super("Create new Version of cell " + cell.describe(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            Cell newVersion = this.cell.makeNewVersion();
            if (newVersion == null) {
                return false;
            }
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (content == null || content.getCell() != this.cell) continue;
                content.setCell(newVersion, null);
            }
            EditWindow.repaintAll();
            return true;
        }
    }

    private static class ChangeCellView
    extends Job {
        Cell cell;
        View newView;

        protected ChangeCellView(Cell cell, View newView) {
            super("Change View of Cell" + cell.describe() + " to " + newView.getFullName(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newView = newView;
            this.startJob();
        }

        public boolean doIt() {
            this.cell.setView(this.newView);
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                if (wf.getContent().getCell() != this.cell) continue;
                wf.getContent().setCell(this.cell, VarContext.globalContext);
            }
            EditWindow.repaintAll();
            return true;
        }
    }

    private static class ShortenArcs
    extends Job {
        private ShortenArcs() {
            super("Shorten selected arcs", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            List selected = Highlight.getHighlighted(false, true);
            int l = 0;
            double[] dX = new double[2];
            double[] dY = new double[2];
            Iterator it = selected.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                for (int j = 0; j < 2; ++j) {
                    Poly portPoly = ai.getConnection(j).getPortInst().getPoly();
                    double wid = ai.getWidth() - ai.getProto().getWidthOffset();
                    portPoly.reducePortPoly(ai.getConnection(j).getPortInst(), wid, ai.getAngle());
                    Point2D closest = portPoly.closestPoint(ai.getConnection(1 - j).getLocation());
                    dX[j] = closest.getX() - ai.getConnection(j).getLocation().getX();
                    dY[j] = closest.getY() - ai.getConnection(j).getLocation().getY();
                }
                if (dX[0] == 0.0 && dY[0] == 0.0 && dX[1] == 0.0 && dY[1] == 0.0) continue;
                ai.modify(0.0, dX[0], dY[0], dX[1], dY[1]);
                ++l;
            }
            System.out.println("Shortened " + l + " arcs");
            return true;
        }
    }

    private static class CleanupChanges
    extends Job {
        private Cell cell;
        private boolean justThis;
        private List pinsToRemove;
        private List pinsToPassThrough;
        private HashMap pinsToScale;
        private List textToMove;
        private HashMap arcsToKill;
        private int zeroSize;
        private int negSize;
        private int overSizePins;

        private CleanupChanges(Cell cell, boolean justThis, List pinsToRemove, List pinsToPassThrough, HashMap pinsToScale, List textToMove, HashMap arcsToKill, int zeroSize, int negSize, int overSizePins) {
            super("Cleanup cell " + cell.describe(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.justThis = justThis;
            this.pinsToRemove = pinsToRemove;
            this.pinsToPassThrough = pinsToPassThrough;
            this.pinsToScale = pinsToScale;
            this.textToMove = textToMove;
            this.arcsToKill = arcsToKill;
            this.zeroSize = zeroSize;
            this.negSize = negSize;
            this.overSizePins = overSizePins;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            if (CircuitChanges.cantEdit(this.cell, null, true)) {
                return false;
            }
            Iterator<Object> it = this.pinsToRemove.iterator();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                ni.kill();
            }
            it = this.pinsToPassThrough.iterator();
            while (it.hasNext()) {
                List created;
                Reconnect re = (Reconnect)it.next();
                if (!re.ni.isLinked() || (created = re.reconnectArcs()).size() <= 0) continue;
                re.ni.kill();
            }
            it = this.pinsToScale.keySet().iterator();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                Point2D scale = (Point2D)this.pinsToScale.get(ni);
                ni.modifyInstance(0.0, 0.0, scale.getX(), scale.getY(), 0);
            }
            it = this.textToMove.iterator();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                ni.invisiblePinWithOffsetText(true);
            }
            it = this.arcsToKill.keySet().iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                if (!ai.isLinked()) continue;
                ai.kill();
            }
            String infstr = "";
            if (!this.justThis) {
                infstr = infstr + "Cell " + this.cell.describe() + ":";
            }
            boolean spoke = false;
            if (this.pinsToRemove.size() != 0) {
                infstr = infstr + "Removed " + this.pinsToRemove.size() + " pins";
                spoke = true;
            }
            if (this.arcsToKill.size() != 0) {
                if (spoke) {
                    infstr = infstr + "; ";
                }
                infstr = infstr + "Removed " + this.arcsToKill.size() + " duplicate arcs";
                spoke = true;
            }
            if (this.pinsToScale.size() != 0) {
                if (spoke) {
                    infstr = infstr + "; ";
                }
                infstr = infstr + "Shrunk " + this.pinsToScale.size() + " pins";
                spoke = true;
            }
            if (this.zeroSize != 0) {
                if (spoke) {
                    infstr = infstr + "; ";
                }
                infstr = this.justThis ? infstr + "Highlighted " + this.zeroSize + " zero-size pins" : infstr + "Found " + this.zeroSize + " zero-size pins";
                spoke = true;
            }
            if (this.negSize != 0) {
                if (spoke) {
                    infstr = infstr + "; ";
                }
                infstr = this.justThis ? infstr + "Highlighted " + this.negSize + " negative-size pins" : infstr + "Found " + this.negSize + " negative-size pins";
                spoke = true;
            }
            if (this.overSizePins != 0) {
                if (spoke) {
                    infstr = infstr + "; ";
                }
                infstr = this.justThis ? infstr + "Highlighted " + this.overSizePins + " oversize pins with arcs that don't touch" : infstr + "Found " + this.overSizePins + " oversize pins with arcs that don't touch";
                spoke = true;
            }
            if (this.textToMove.size() != 0) {
                if (spoke) {
                    infstr = infstr + "; ";
                }
                infstr = infstr + "Moved text on " + this.textToMove.size() + " pins with offset text";
            }
            System.out.println(infstr);
            return true;
        }
    }

    private static class ExportsByName
    implements Comparator {
        private ExportsByName() {
        }

        public int compare(Object o1, Object o2) {
            Export e1 = (Export)o1;
            Export e2 = (Export)o2;
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }

    private static class ArcsByName
    implements Comparator {
        private ArcsByName() {
        }

        public int compare(Object o1, Object o2) {
            ArcInst a1 = (ArcInst)o1;
            ArcInst a2 = (ArcInst)o2;
            String s1 = a1.getName();
            String s2 = a2.getName();
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }

    private static class NodesByName
    implements Comparator {
        private NodesByName() {
        }

        public int compare(Object o1, Object o2) {
            NodeInst n1 = (NodeInst)o1;
            NodeInst n2 = (NodeInst)o2;
            String s1 = n1.getName();
            String s2 = n2.getName();
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }

    private static class ExtractCellInstances
    extends Job {
        protected ExtractCellInstances() {
            super("Extract Cell Instances", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            List nodes = Highlight.getHighlighted(true, false);
            Highlight.clear();
            Highlight.finished();
            boolean foundInstance = false;
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                NodeProto np = ni.getProto();
                if (!(np instanceof Cell)) continue;
                foundInstance = true;
                CircuitChanges.extractOneNode(ni);
            }
            if (!foundInstance) {
                System.out.println("Must selecte cell instances to extract");
                return false;
            }
            return true;
        }
    }

    private static class PackageCell
    extends Job {
        Cell curCell;
        Rectangle2D bounds;
        String newCellName;

        protected PackageCell(Cell curCell, Rectangle2D bounds, String newCellName) {
            super("Package Cell", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.bounds = bounds;
            this.newCellName = newCellName;
            this.startJob();
        }

        public boolean doIt() {
            Geometric look;
            Cell cell = Cell.makeInstance(Library.getCurrent(), this.newCellName);
            if (cell == null) {
                return false;
            }
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            Iterator sIt = this.curCell.searchIterator(this.bounds);
            while (sIt.hasNext()) {
                look = (Geometric)sIt.next();
                if (!(look instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)look;
                NodeInst newNi = NodeInst.makeInstance(ni.getProto(), new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), ni.getXSize(), ni.getYSize(), ni.getAngle(), cell, ni.getName());
                if (newNi == null) {
                    return false;
                }
                newNodes.put(ni, newNi);
                newNi.lowLevelSetUserbits(ni.lowLevelGetUserbits());
                ni.copyVars(newNi);
                newNi.setNameTextDescriptor(ni.getNameTextDescriptor());
                Iterator it = ni.getExports();
                while (it.hasNext()) {
                    Export pp = (Export)it.next();
                    PortInst pi = newNi.findPortInstFromProto(pp.getOriginalPort().getPortProto());
                    Export newPp = Export.newInstance(cell, pi, pp.getName());
                    if (newPp == null) continue;
                    newPp.setCharacteristic(pp.getCharacteristic());
                    newPp.setTextDescriptor(pp.getTextDescriptor());
                    pp.copyVars(newPp);
                }
            }
            sIt = this.curCell.searchIterator(this.bounds);
            while (sIt.hasNext()) {
                look = (Geometric)sIt.next();
                if (!(look instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)look;
                NodeInst niTail = (NodeInst)newNodes.get(ai.getTail().getPortInst().getNodeInst());
                NodeInst niHead = (NodeInst)newNodes.get(ai.getHead().getPortInst().getNodeInst());
                if (niTail == null || niHead == null) continue;
                PortInst piTail = niTail.findPortInstFromProto(ai.getTail().getPortInst().getPortProto());
                PortInst piHead = niHead.findPortInstFromProto(ai.getHead().getPortInst().getPortProto());
                ArcInst newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), piHead, ai.getHead().getLocation(), piTail, ai.getTail().getLocation(), ai.getName());
                if (newAi == null) {
                    return false;
                }
                ai.copyVars(newAi);
            }
            System.out.println("Cell " + cell.describe() + " created");
            return true;
        }
    }

    private static class GraphCells
    extends Job {
        private Cell top;

        protected GraphCells(Cell top) {
            super("Graph Cells", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            CellGraphNode cgn;
            Cell cell;
            Library lib;
            double xsc;
            NodeInst titleNi;
            CellGraphNode cgn2;
            Cell cell2;
            Iterator cIt;
            Library lib2;
            CellGraphNode cgn3;
            Cell cell3;
            Iterator cIt2;
            Library lib3;
            Cell trueCell;
            CellGraphNode cgn4;
            Cell cell4;
            Iterator cIt3;
            Cell graphCell = Cell.newInstance(Library.getCurrent(), "CellStructure");
            if (graphCell == null) {
                return false;
            }
            if (graphCell.getNumVersions() > 1) {
                System.out.println("Creating new version of cell: CellStructure");
            } else {
                System.out.println("Creating cell: CellStructure");
            }
            HashMap<Cell, CellGraphNode> cellGraphNodes = new HashMap<Cell, CellGraphNode>();
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib4 = (Library)it.next();
                if (lib4.isHidden()) continue;
                cIt3 = lib4.getCells();
                while (cIt3.hasNext()) {
                    cell4 = (Cell)cIt3.next();
                    cgn4 = new CellGraphNode();
                    cgn4.depth = -1;
                    cellGraphNodes.put(cell4, cgn4);
                }
            }
            if (this.top != null) {
                CellGraphNode cgn5 = (CellGraphNode)cellGraphNodes.get(this.top);
                cgn5.depth = 0;
            } else {
                Iterator cIt4 = Library.getCurrent().getCells();
                while (cIt4.hasNext()) {
                    Cell cell5 = (Cell)cIt4.next();
                    if (cell5.getNumUsagesIn() != 0) continue;
                    CellGraphNode cgn6 = (CellGraphNode)cellGraphNodes.get(cell5);
                    cgn6.depth = 0;
                }
            }
            int maxDepth = 0;
            boolean more = true;
            while (more) {
                more = false;
                Iterator it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    Library lib5 = (Library)it2.next();
                    if (lib5.isHidden()) continue;
                    Iterator cIt5 = lib5.getCells();
                    while (cIt5.hasNext()) {
                        Cell cell6 = (Cell)cIt5.next();
                        CellGraphNode cgn7 = (CellGraphNode)cellGraphNodes.get(cell6);
                        if (cgn7.depth == -1) continue;
                        Iterator nIt = cell6.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst ni = (NodeInst)nIt.next();
                            if (!(ni.getProto() instanceof Cell)) continue;
                            Cell sub = (Cell)ni.getProto();
                            if (ni.isIconOfParent()) continue;
                            CellGraphNode subCgn = (CellGraphNode)cellGraphNodes.get(sub);
                            if (subCgn.depth <= cgn7.depth) {
                                subCgn.depth = cgn7.depth + 1;
                                if (subCgn.depth > maxDepth) {
                                    maxDepth = subCgn.depth;
                                }
                                more = true;
                            }
                            if ((trueCell = sub.contentsView()) == null) continue;
                            CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell);
                            if (trueCgn.depth > cgn7.depth) continue;
                            trueCgn.depth = cgn7.depth + 1;
                            if (trueCgn.depth > maxDepth) {
                                maxDepth = trueCgn.depth;
                            }
                            more = true;
                        }
                    }
                }
                if (more || this.top != null) continue;
                cIt3 = Library.getCurrent().getCells();
                while (cIt3.hasNext()) {
                    cell4 = (Cell)cIt3.next();
                    cgn4 = (CellGraphNode)cellGraphNodes.get(cell4);
                    if (cgn4.depth >= 0) continue;
                    cgn4.depth = 0;
                    more = true;
                }
            }
            double maxWidth = 0.0;
            double[] xval = new double[++maxDepth];
            double[] yoff = new double[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                yoff[i] = 0.0;
                xval[i] = 0.0;
            }
            Iterator it3 = Library.getLibraries();
            while (it3.hasNext()) {
                lib3 = (Library)it3.next();
                if (lib3.isHidden()) continue;
                cIt2 = lib3.getCells();
                while (cIt2.hasNext()) {
                    cell3 = (Cell)cIt2.next();
                    cgn3 = (CellGraphNode)cellGraphNodes.get(cell3);
                    if (cgn3.depth == -1) continue;
                    trueCell = CircuitChanges.graphMainView(cell3);
                    if (trueCell != null && (cell3.getNumUsagesIn() == 0 || cell3.getView() == View.ICON || cell3.getView() == View.LAYOUTSKEL)) {
                        cgn3.depth = -1;
                        continue;
                    }
                    cgn3.x = xval[cgn3.depth];
                    int n = cgn3.depth;
                    xval[n] = xval[n] + (double)cell3.describe().length();
                    if (xval[cgn3.depth] > maxWidth) {
                        maxWidth = xval[cgn3.depth];
                    }
                    cgn3.y = cgn3.depth;
                    cgn3.yoff = 0.0;
                }
            }
            it3 = Library.getLibraries();
            while (it3.hasNext()) {
                lib3 = (Library)it3.next();
                if (lib3.isHidden()) continue;
                cIt2 = lib3.getCells();
                while (cIt2.hasNext()) {
                    cell3 = (Cell)cIt2.next();
                    cgn3 = (CellGraphNode)cellGraphNodes.get(cell3);
                    if (cgn3.depth == -1 || !(xval[(int)cgn3.y] < maxWidth)) continue;
                    double spread = maxWidth / xval[(int)cgn3.y];
                    cgn3.x *= spread;
                }
            }
            double xScale = 0.6666666666666666;
            double yScale = 20.0;
            double yOffset = 0.5;
            Iterator it4 = Library.getLibraries();
            while (it4.hasNext()) {
                lib2 = (Library)it4.next();
                if (lib2.isHidden()) continue;
                cIt = lib2.getCells();
                while (cIt.hasNext()) {
                    cell2 = (Cell)cIt.next();
                    cgn2 = (CellGraphNode)cellGraphNodes.get(cell2);
                    if (cgn2.depth == -1) continue;
                    double x = cgn2.x;
                    double y = cgn2.y;
                    int n = (int)cgn2.y;
                    double d = yoff[n];
                    yoff[n] = d + 1.0;
                    y = -y * yScale + d % 2.0 * yOffset;
                    cgn2.x = x *= xScale;
                    cgn2.y = y;
                }
            }
            if (this.top == null) {
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    lib2 = (Library)it4.next();
                    if (lib2.isHidden()) continue;
                    cIt = lib2.getCells();
                    while (cIt.hasNext()) {
                        Cell trueCell2;
                        cell2 = (Cell)cIt.next();
                        cgn2 = (CellGraphNode)cellGraphNodes.get(cell2);
                        if (cgn2.depth != -1 || cell2.getNumUsagesIn() != 0 && cell2.getView() != View.ICON && cell2.getView() != View.LAYOUTSKEL || (trueCell2 = CircuitChanges.graphMainView(cell2)) == null) continue;
                        CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell2);
                        if (trueCgn.depth == -1) continue;
                        cgn2.pin = null;
                        cgn2.main = trueCgn;
                        cgn2.yoff += yOffset * 2.0;
                        cgn2.x = trueCgn.x;
                        cgn2.y = trueCgn.y + trueCgn.yoff;
                    }
                }
            }
            if ((titleNi = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(xsc = maxWidth * xScale / 2.0, yScale), 0.0, 0.0, 0, graphCell, null)) == null) {
                return false;
            }
            StringBuffer infstr = new StringBuffer();
            if (this.top != null) {
                infstr.append("Structure below cell " + this.top.describe());
            } else {
                infstr.append("Structure of library " + Library.getCurrent().getName());
            }
            Variable var = titleNi.newVar(Artwork.ART_MESSAGE, (Object)infstr.toString());
            if (var != null) {
                var.setDisplay(true);
                var.getTextDescriptor().setRelSize(6.0);
            }
            Iterator it5 = Library.getLibraries();
            while (it5.hasNext()) {
                lib = (Library)it5.next();
                if (lib.isHidden()) continue;
                Iterator cIt6 = lib.getCells();
                while (cIt6.hasNext()) {
                    cell = (Cell)cIt6.next();
                    if (cell == graphCell) continue;
                    cgn = (CellGraphNode)cellGraphNodes.get(cell);
                    if (cgn.depth == -1) continue;
                    double x = cgn.x;
                    double y = cgn.y;
                    NodeInst ni = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(x, y), 0.0, 0.0, 0, graphCell, null);
                    if (ni == null) {
                        return false;
                    }
                    cgn.pin = ni;
                    var = ni.newVar(Artwork.ART_MESSAGE, (Object)cell.describe());
                    if (var == null) continue;
                    var.setDisplay(true);
                    var.getTextDescriptor().setRelSize(1.0);
                }
            }
            it5 = Library.getLibraries();
            while (it5.hasNext()) {
                lib = (Library)it5.next();
                if (lib.isHidden()) continue;
                Iterator cIt7 = lib.getCells();
                while (cIt7.hasNext()) {
                    cell = (Cell)cIt7.next();
                    if (cell == graphCell) continue;
                    cgn = (CellGraphNode)cellGraphNodes.get(cell);
                    if (cgn.depth == -1 || cgn.main == null) continue;
                    PortInst firstPi = cgn.pin.getOnlyPortInst();
                    PortInst secondPi = cgn.main.pin.getOnlyPortInst();
                    ArcInst ai = ArcInst.makeInstance(Artwork.tech.solidArc, 0.0, firstPi, firstPi, null);
                    if (ai == null) {
                        return false;
                    }
                    ai.setRigid();
                    ai.newVar(Artwork.ART_COLOR, (Object)new Integer(0));
                }
            }
            int clock = 0;
            Iterator it6 = Library.getLibraries();
            while (it6.hasNext()) {
                Library lib6 = (Library)it6.next();
                if (lib6.isHidden()) continue;
                Iterator cIt8 = lib6.getCells();
                while (cIt8.hasNext()) {
                    Cell cell7 = (Cell)cIt8.next();
                    if (cell7 == graphCell) continue;
                    Cell trueCell3 = cell7.contentsView();
                    if (trueCell3 == null) {
                        trueCell3 = cell7;
                    }
                    CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell3);
                    if (trueCgn.depth == -1) continue;
                    ++clock;
                    Iterator nIt = trueCell3.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
                        Cell sub = (Cell)ni.getProto();
                        Cell truesubnp = sub.contentsView();
                        if (truesubnp == null) {
                            truesubnp = sub;
                        }
                        CellGraphNode trueSubCgn = (CellGraphNode)cellGraphNodes.get(truesubnp);
                        if (trueSubCgn.clock == clock) continue;
                        trueSubCgn.clock = clock;
                        if (trueSubCgn.depth == -1) continue;
                        PortInst toppinPi = trueCgn.pin.getOnlyPortInst();
                        PortInst niBotPi = trueSubCgn.pin.getOnlyPortInst();
                        ArcInst ai = ArcInst.makeInstance(Artwork.tech.solidArc, Artwork.tech.solidArc.getDefaultWidth(), toppinPi, niBotPi, null);
                        if (ai == null) {
                            return false;
                        }
                        ai.clearFixedAngle();
                        ai.clearRigid();
                        int color = 14;
                        if (trueCgn.y - trueSubCgn.y > yScale + yOffset + yOffset) {
                            color = 10;
                        }
                        ai.newVar(Artwork.ART_COLOR, (Object)new Integer(color));
                    }
                }
            }
            WindowFrame.createEditWindow(graphCell);
            return true;
        }

        private static class CellGraphNode {
            int depth;
            int clock;
            double x;
            double y;
            double yoff;
            NodeInst pin;
            CellGraphNode main;

            private CellGraphNode() {
            }
        }
    }

    private static class DeleteUnusedOldCells
    extends Job {
        protected DeleteUnusedOldCells() {
            super("Delete Unused Old Cells", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            boolean found = true;
            int totalDeleted = 0;
            block0: while (found) {
                found = false;
                Iterator it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell cell = (Cell)it.next();
                    if (cell.getNewestVersion() == cell || cell.getInstancesOf().hasNext()) continue;
                    System.out.println("Deleting cell " + cell.describe());
                    CircuitChanges.doKillCell(cell);
                    found = true;
                    ++totalDeleted;
                    continue block0;
                }
            }
            if (totalDeleted == 0) {
                System.out.println("No unused old cell versions to delete");
            } else {
                System.out.println("Deleted " + totalDeleted + " cells");
                EditWindow.repaintAll();
            }
            return true;
        }
    }

    private static class RenameCell
    extends Job {
        Cell cell;
        String newName;

        protected RenameCell(Cell cell, String newName) {
            super("Rename Cell" + cell.describe(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            this.cell.rename(this.newName);
            return true;
        }
    }

    private static class DeleteCell
    extends Job {
        Cell cell;

        protected DeleteCell(Cell cell) {
            super("Delete Cell" + cell.describe(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            if (this.cell.isInUse("delete")) {
                return false;
            }
            CircuitChanges.doKillCell(this.cell);
            return true;
        }
    }

    private static class DeleteSelectedGeometry
    extends Job {
        protected DeleteSelectedGeometry() {
            super("Delete selected geometry", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            EditWindow wnd = EditWindow.getCurrent();
            Cell cell = null;
            if (wnd != null) {
                cell = wnd.getCell();
            }
            if (cell == null) {
                System.out.println("No current cell");
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            Rectangle2D bounds = Highlight.getHighlightedArea(wnd);
            if (bounds == null) {
                System.out.println("Outline an area first");
                return false;
            }
            double lX = Math.floor(bounds.getMinX());
            double hX = Math.ceil(bounds.getMaxX());
            double lY = Math.floor(bounds.getMinY());
            double hY = Math.ceil(bounds.getMaxY());
            ArrayList arcsInCell = new ArrayList();
            Iterator aIt = cell.getArcs();
            while (aIt.hasNext()) {
                arcsInCell.add(aIt.next());
            }
            aIt = arcsInCell.iterator();
            while (aIt.hasNext()) {
                ArcInst ai1;
                NodeInst ni2;
                PrimitiveNode pin;
                Point2D.Double headPtAdj;
                ArcInst ai = (ArcInst)aIt.next();
                Point2D headPt = ai.getHead().getLocation();
                Point2D tailPt = ai.getTail().getLocation();
                if (tailPt.getX() == headPt.getX() && tailPt.getY() == headPt.getY()) continue;
                double halfWidth = (ai.getWidth() - ai.getProto().getWidthOffset()) / 2.0;
                double lXExt = lX - halfWidth;
                double hXExt = hX + halfWidth;
                double lYExt = lY - halfWidth;
                double hYExt = hY + halfWidth;
                Point2D.Double tailPtAdj = new Point2D.Double(tailPt.getX(), tailPt.getY());
                if (DBMath.clipLine(tailPtAdj, headPtAdj = new Point2D.Double(headPt.getX(), headPt.getY()), lXExt, hXExt, lYExt, hYExt)) continue;
                if (tailPtAdj.distance(headPt) + headPtAdj.distance(tailPt) < headPtAdj.distance(headPt) + tailPtAdj.distance(tailPt)) {
                    Point2D.Double swap = headPtAdj;
                    headPtAdj = tailPtAdj;
                    tailPtAdj = swap;
                }
                if (!tailPt.equals(tailPtAdj)) {
                    pin = ((PrimitiveArc)ai.getProto()).findPinProto();
                    ni2 = NodeInst.makeInstance(pin, tailPtAdj, pin.getDefWidth(), pin.getDefHeight(), 0, cell, null);
                    if (ni2 == null || (ai1 = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), ai.getTail().getPortInst(), ai.getTail().getLocation(), ni2.getOnlyPortInst(), tailPtAdj, ai.getName())) == null) continue;
                    ai.copyVars(ai1);
                }
                if (!headPt.equals(headPtAdj)) {
                    pin = ((PrimitiveArc)ai.getProto()).findPinProto();
                    ni2 = NodeInst.makeInstance(pin, headPtAdj, pin.getDefWidth(), pin.getDefHeight(), 0, cell, null);
                    if (ni2 == null || (ai1 = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), ni2.getOnlyPortInst(), headPtAdj, ai.getHead().getPortInst(), ai.getHead().getLocation(), ai.getName())) == null) continue;
                    ai.copyVars(ai1);
                }
                ai.kill();
            }
            ArrayList<NodeInst> nodesToDelete = new ArrayList<NodeInst>();
            Iterator nIt = cell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                double cX = ni.getTrueCenterX();
                double cY = ni.getTrueCenterY();
                if (cX > hX || cX < lX || cY > hY || cY < lY || CircuitChanges.cantEdit(cell, ni, true)) continue;
                nodesToDelete.add(ni);
            }
            nIt = nodesToDelete.iterator();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                CircuitChanges.eraseNodeInst(ni);
            }
            return true;
        }
    }

    private static class DeleteSelected
    extends Job {
        protected DeleteSelected() {
            super("Delete selected objects", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            if (Highlight.getNumHighlights() == 0) {
                return false;
            }
            Cell cell = WindowFrame.needCurCell();
            if (cell != null && CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            List highlightedText = Highlight.getHighlightedText(true);
            ArrayList<ElectricObject> deleteList = new ArrayList<ElectricObject>();
            Geometric oneGeom = null;
            Iterator it = Highlight.getHighlights();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (!(eobj instanceof Geometric)) continue;
                if (cell != h.getCell()) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "All objects to be deleted must be in the same cell", "Delete failed", 0);
                    return false;
                }
                oneGeom = (Geometric)eobj;
                deleteList.add(eobj);
            }
            Highlight.clear();
            Highlight.finished();
            it = highlightedText.iterator();
            while (it.hasNext()) {
                Highlight high = (Highlight)it.next();
                Variable var = high.getVar();
                ElectricObject eobj = high.getElectricObject();
                if (var != null) {
                    eobj.delVar(var.getKey());
                    continue;
                }
                if (high.getName() != null) {
                    if (!(eobj instanceof Geometric)) continue;
                    Geometric geom = (Geometric)eobj;
                    if (geom instanceof NodeInst) {
                        NodeInst ni = (NodeInst)geom;
                        ni.setName(null);
                        ni.modifyInstance(0.0, 0.0, 0.0, 0.0, 0);
                        continue;
                    }
                    ArcInst ai = (ArcInst)geom;
                    ai.setName(null);
                    ai.modify(0.0, 0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                if (!(eobj instanceof Export)) continue;
                Export pp = (Export)eobj;
                pp.kill();
            }
            if (cell != null) {
                CircuitChanges.eraseObjectsInList(cell, deleteList);
            }
            return true;
        }
    }

    private static class RipTheBus
    extends Job {
        List list;

        protected RipTheBus(List list) {
            super("Rip Bus", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                NodeInst nib;
                NodeInst niw;
                ArcInst ai = (ArcInst)it.next();
                if (ai.getProto() != Schematics.tech.bus_arc) continue;
                Netlist netList = ai.getParent().getUserNetlist();
                int busWidth = netList.getBusWidth(ai);
                String netName = netList.getNetworkName(ai);
                if (netName.length() == 0) {
                    System.out.println("Bus " + ai.describe() + " has no name");
                    continue;
                }
                double stublen = (int)(ai.getLength() / 3.0 + 0.5);
                double lowXBus = 0.0;
                double lowYBus = 0.0;
                int lowEnd = 1;
                double sepX = 0.0;
                double sepY = 0.0;
                double lowX = 0.0;
                double lowY = 0.0;
                if (ai.getHead().getLocation().getX() == ai.getTail().getLocation().getX()) {
                    lowX = ai.getHead().getLocation().getX();
                    lowX = lowX < ai.getParent().getBounds().getCenterX() ? (lowX += stublen) : (lowX -= stublen);
                    if (ai.getConnection(0).getLocation().getY() < ai.getConnection(1).getLocation().getY()) {
                        lowEnd = 0;
                    }
                    lowY = (int)ai.getConnection(lowEnd).getLocation().getY();
                    double highy = (int)ai.getConnection(1 - lowEnd).getLocation().getY();
                    if (highy - lowY >= (double)(busWidth - 1)) {
                        sepY = (int)((highy - lowY) / (double)(busWidth - 1));
                        lowY = (int)((highy - lowY - sepY * (double)(busWidth - 1)) / 2.0 + lowY);
                    } else {
                        lowY = ai.getConnection(lowEnd).getLocation().getY();
                        highy = ai.getConnection(1 - lowEnd).getLocation().getY();
                        sepY = (highy - lowY) / (double)(busWidth - 1);
                    }
                    lowXBus = ai.getTail().getLocation().getX();
                    lowYBus = lowY;
                } else if (ai.getTail().getLocation().getY() == ai.getHead().getLocation().getY()) {
                    lowY = ai.getTail().getLocation().getY();
                    lowY = lowY < ai.getParent().getBounds().getCenterY() ? (lowY += stublen) : (lowY -= stublen);
                    if (ai.getConnection(0).getLocation().getX() < ai.getConnection(1).getLocation().getX()) {
                        lowEnd = 0;
                    }
                    lowX = (int)ai.getConnection(lowEnd).getLocation().getX();
                    double highx = (int)ai.getConnection(1 - lowEnd).getLocation().getX();
                    if (highx - lowX >= (double)(busWidth - 1)) {
                        sepX = (int)((highx - lowX) / (double)(busWidth - 1));
                        lowX = (int)((highx - lowX - sepX * (double)(busWidth - 1)) / 2.0 + lowX);
                    } else {
                        lowX = ai.getConnection(lowEnd).getLocation().getX();
                        highx = ai.getConnection(1 - lowEnd).getLocation().getX();
                        sepX = (highx - lowX) / (double)(busWidth - 1);
                    }
                    lowXBus = lowX;
                    lowYBus = ai.getTail().getLocation().getY();
                } else {
                    System.out.println("Bus " + ai.describe() + " must be horizontal or vertical to be ripped out");
                    continue;
                }
                String[] localStrings = new String[busWidth];
                for (int i = 0; i < busWidth; ++i) {
                    JNetwork subNet = netList.getNetwork(ai, i);
                    localStrings[i] = subNet.hasNames() ? (String)subNet.getNames().next() : subNet.describe();
                }
                Highlight.clear();
                Highlight.finished();
                double sxw = Schematics.tech.wirePinNode.getDefWidth();
                double syw = Schematics.tech.wirePinNode.getDefHeight();
                double sxb = Schematics.tech.busPinNode.getDefWidth();
                double syb = Schematics.tech.busPinNode.getDefHeight();
                PrimitiveArc apW = Schematics.tech.wire_arc;
                PrimitiveArc apB = Schematics.tech.bus_arc;
                NodeInst niBLast = null;
                for (int i = 0; i < busWidth && (niw = NodeInst.makeInstance(Schematics.tech.wirePinNode, new Point2D.Double(lowX, lowY), sxw, syw, 0, ai.getParent(), null)) != null && (nib = NodeInst.makeInstance(Schematics.tech.busPinNode, new Point2D.Double(lowXBus, lowYBus), sxb, syb, 0, ai.getParent(), null)) != null; ++i) {
                    PortInst first;
                    PortInst head = niw.getOnlyPortInst();
                    PortInst tail = nib.getOnlyPortInst();
                    ArcInst aiw = ArcInst.makeInstance(apW, apW.getDefaultWidth(), head, tail, null);
                    if (aiw == null) break;
                    aiw.setName(localStrings[i]);
                    if (i == 0) {
                        first = ai.getConnection(lowEnd).getPortInst();
                        aiw = ArcInst.makeInstance(apB, apB.getDefaultWidth(), first, tail, null);
                    } else {
                        first = niBLast.getOnlyPortInst();
                        aiw = ArcInst.makeInstance(apB, apB.getDefaultWidth(), first, tail, null);
                    }
                    if (aiw == null) break;
                    niBLast = nib;
                    lowX += sepX;
                    lowY += sepY;
                    lowXBus += sepX;
                    lowYBus += sepY;
                }
                PortInst head = niBLast.getOnlyPortInst();
                PortInst tail = ai.getConnection(1 - lowEnd).getPortInst();
                ArcInst aiw = ArcInst.makeInstance(apB, apB.getDefaultWidth(), head, tail, null);
                if (aiw == null) {
                    return false;
                }
                aiw.setName(netName);
                ai.kill();
            }
            return true;
        }
    }

    private static class ToggleNegationJob
    extends Job {
        protected ToggleNegationJob() {
            super("Toggle negation", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            int numSet = 0;
            Iterator it = Highlight.getHighlights();
            while (it.hasNext()) {
                boolean newNegated;
                PrimitivePort pp;
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    PortInst pi = (PortInst)eobj;
                    NodeInst ni = pi.getNodeInst();
                    Iterator cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = (Connection)cIt.next();
                        if (con.getPortInst() != pi || !(pi.getNodeInst().getProto() instanceof PrimitiveNode) || !(pp = (PrimitivePort)pi.getPortProto()).isNegatable()) continue;
                        newNegated = !con.isNegated();
                        con.setNegated(newNegated);
                        ++numSet;
                    }
                }
                if (!(eobj instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)eobj;
                for (int i = 0; i < 2; ++i) {
                    Connection con = ai.getConnection(i);
                    PortInst pi = con.getPortInst();
                    if (!(pi.getNodeInst().getProto() instanceof PrimitiveNode) || !(pp = (PrimitivePort)pi.getPortProto()).isNegatable()) continue;
                    newNegated = !con.isNegated();
                    con.setNegated(newNegated);
                    ++numSet;
                }
            }
            if (numSet == 0) {
                System.out.println("No ports negated");
            } else {
                System.out.println("Negated " + numSet + " ports");
                EditWindow.repaintAllContents();
            }
            return true;
        }
    }

    private static class ChangeArcProperties
    extends Job {
        private int how;

        protected ChangeArcProperties(int how) {
            super("Align objects", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.how = how;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            int numSet = 0;
            int numUnset = 0;
            Iterator it = Highlight.getHighlights();
            while (it.hasNext()) {
                ElectricObject eobj;
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)eobj;
                switch (this.how) {
                    case 1: {
                        if (ai.isRigid()) break;
                        ai.setRigid();
                        ++numSet;
                        break;
                    }
                    case 2: {
                        if (!ai.isRigid()) break;
                        ai.clearRigid();
                        ++numSet;
                        break;
                    }
                    case 3: {
                        if (ai.isFixedAngle()) break;
                        ai.setFixedAngle();
                        ++numSet;
                        break;
                    }
                    case 4: {
                        if (!ai.isFixedAngle()) break;
                        ai.clearFixedAngle();
                        ++numSet;
                        break;
                    }
                    case 5: {
                        if (ai.isDirectional()) {
                            ai.clearDirectional();
                            ++numUnset;
                            break;
                        }
                        ai.setDirectional();
                        ++numSet;
                        break;
                    }
                    case 6: {
                        if (ai.isExtended()) {
                            ai.clearExtended();
                            ++numUnset;
                            break;
                        }
                        ai.setExtended();
                        ++numSet;
                        break;
                    }
                    case 7: {
                        if (ai.isReverseEnds()) {
                            ai.clearReverseEnds();
                            ++numUnset;
                            break;
                        }
                        ai.setReverseEnds();
                        ++numSet;
                        break;
                    }
                    case 8: {
                        if (ai.isSkipHead()) {
                            ai.clearSkipHead();
                            ++numUnset;
                            break;
                        }
                        ai.setSkipHead();
                        ++numSet;
                        break;
                    }
                    case 9: {
                        if (ai.isSkipTail()) {
                            ai.clearSkipTail();
                            ++numUnset;
                            break;
                        }
                        ai.setSkipTail();
                        ++numSet;
                    }
                }
            }
            if (numSet == 0 && numUnset == 0) {
                System.out.println("No changes were made");
            } else {
                String action = "";
                boolean repaintContents = false;
                switch (this.how) {
                    case 1: {
                        action = "Rigid";
                        break;
                    }
                    case 2: {
                        action = "Non-Rigid";
                        break;
                    }
                    case 3: {
                        action = "Fixed-Angle";
                        break;
                    }
                    case 4: {
                        action = "Not-Fixed-Angle";
                        break;
                    }
                    case 5: {
                        action = "Directional";
                        repaintContents = true;
                        break;
                    }
                    case 6: {
                        action = "have ends extended";
                        repaintContents = true;
                        break;
                    }
                    case 7: {
                        action = "reversed";
                        repaintContents = true;
                        break;
                    }
                    case 8: {
                        action = "skip head";
                        repaintContents = true;
                        break;
                    }
                    case 9: {
                        action = "skip tail";
                        repaintContents = true;
                    }
                }
                if (numUnset == 0) {
                    System.out.println("Made " + numSet + " arcs " + action);
                } else if (numSet == 0) {
                    System.out.println("Made " + numUnset + " arcs not " + action);
                } else {
                    System.out.println("Made " + numSet + " arcs " + action + "; and " + numUnset + " arcs not " + action);
                }
                if (repaintContents) {
                    EditWindow.repaintAllContents();
                } else {
                    EditWindow.repaintAll();
                }
            }
            return true;
        }
    }

    private static class AlignNodes
    extends Job {
        NodeInst[] nis;
        double[] dCX;
        double[] dCY;
        double[] dSX;
        double[] dSY;
        int[] dRot;

        protected AlignNodes(NodeInst[] nis, double[] dCX, double[] dCY, double[] dSX, double[] dSY, int[] dRot) {
            super("Align objects", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.nis = nis;
            this.dCX = dCX;
            this.dCY = dCY;
            this.dSX = dSX;
            this.dSY = dSY;
            this.dRot = dRot;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst.modifyInstances(this.nis, this.dCX, this.dCY, this.dSX, this.dSY, this.dRot);
            return true;
        }
    }

    private static class AlignObjects
    extends Job {
        protected AlignObjects() {
            super("Align Objects", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            List list = Highlight.getHighlighted(true, true);
            if (list.size() == 0) {
                System.out.println("Must select something before aligning it to the grid");
                return false;
            }
            double alignment_ratio = User.getAlignmentToGrid();
            if (alignment_ratio <= 0.0) {
                System.out.println("No alignment given: set Alignment Options first");
                return false;
            }
            int adjustedNodes = 0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Connection con;
                NodeInst ni;
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getFunction() == NodeProto.Function.PIN) continue;
                Point2D.Double center = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                EditWindow.gridAlign(center);
                double bodyXOffset = ((Point2D)center).getX() - ni.getAnchorCenterX();
                double bodyYOffset = ((Point2D)center).getY() - ni.getAnchorCenterY();
                double portXOffset = bodyXOffset;
                double portYOffset = bodyYOffset;
                boolean mixedportpos = false;
                boolean firstPort = true;
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    Poly poly = pi.getPoly();
                    Point2D.Double portCenter = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                    EditWindow.gridAlign(portCenter);
                    double pXO = ((Point2D)portCenter).getX() - poly.getCenterX();
                    double pYO = ((Point2D)portCenter).getY() - poly.getCenterY();
                    if (firstPort) {
                        firstPort = false;
                        portXOffset = pXO;
                        portYOffset = pYO;
                        continue;
                    }
                    if (portXOffset == pXO && portYOffset == pYO) continue;
                    mixedportpos = true;
                }
                if (!mixedportpos) {
                    bodyXOffset = portXOffset;
                    bodyYOffset = portYOffset;
                }
                if ((bodyXOffset != 0.0 || bodyYOffset != 0.0) && ni.getProto() instanceof PrimitiveNode) {
                    AffineTransform transr = ni.rotateOut();
                    Technology tech = ni.getProto().getTechnology();
                    Poly[] polyList = tech.getShapeOfNode(ni);
                    for (int j = 0; j < polyList.length; ++j) {
                        Poly poly = polyList[j];
                        poly.transform(transr);
                        Rectangle2D bounds = poly.getBox();
                        if (bounds == null) continue;
                        Point2D.Double polyPoint1 = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
                        Point2D.Double polyPoint2 = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
                        EditWindow.gridAlign(polyPoint1);
                        EditWindow.gridAlign(polyPoint2);
                        if (((Point2D)polyPoint1).getX() == bounds.getMinX() && ((Point2D)polyPoint2).getX() == bounds.getMaxX()) {
                            bodyXOffset = 0.0;
                        }
                        if (((Point2D)polyPoint1).getY() == bounds.getMinY() && ((Point2D)polyPoint2).getY() == bounds.getMaxY()) {
                            bodyYOffset = 0.0;
                        }
                        if (bodyXOffset == 0.0 && bodyYOffset == 0.0) break;
                    }
                }
                if (bodyXOffset == 0.0 && bodyYOffset == 0.0) continue;
                HashMap<ArcInst, Integer> constraints = new HashMap<ArcInst, Integer>();
                Iterator aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    con = (Connection)aIt.next();
                    ArcInst ai = con.getArc();
                    int constr = 0;
                    if (ai.isRigid()) {
                        constr |= 1;
                    }
                    if (ai.isFixedAngle()) {
                        constr |= 2;
                    }
                    constraints.put(ai, new Integer(constr));
                    ai.clearRigid();
                    ai.clearFixedAngle();
                }
                ni.modifyInstance(bodyXOffset, bodyYOffset, 0.0, 0.0, 0);
                ++adjustedNodes;
                aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    con = (Connection)aIt.next();
                    ArcInst ai = con.getArc();
                    Integer constr = (Integer)constraints.get(ai);
                    if (constr == null) continue;
                    if ((constr & 1) != 0) {
                        ai.setRigid();
                    }
                    if ((constr & 2) == 0) continue;
                    ai.setFixedAngle();
                }
            }
            int adjustedArcs = 0;
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                int ang;
                Geometric geom = (Geometric)it2.next();
                if (!(geom instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)geom;
                Point2D origHead = ai.getHead().getLocation();
                Point2D origTail = ai.getTail().getLocation();
                Point2D.Double arcHead = new Point2D.Double(origHead.getX(), origHead.getY());
                Point2D.Double arcTail = new Point2D.Double(origTail.getX(), origTail.getY());
                EditWindow.gridAlign(arcHead);
                EditWindow.gridAlign(arcTail);
                double headXOff = ((Point2D)arcHead).getX() - origHead.getX();
                double headYOff = ((Point2D)arcHead).getY() - origHead.getY();
                double tailXOff = ((Point2D)arcTail).getX() - origTail.getX();
                double tailYOff = ((Point2D)arcTail).getY() - origTail.getY();
                if (headXOff == 0.0 && tailXOff == 0.0 && headYOff == 0.0 && tailYOff == 0.0) continue;
                if (!ai.stillInPort(ai.getHead(), arcHead, false)) {
                    if (!ai.stillInPort(ai.getHead(), origHead, false)) continue;
                    headYOff = 0.0;
                    headXOff = 0.0;
                }
                if (!ai.stillInPort(ai.getTail(), arcTail, false)) {
                    if (!ai.stillInPort(ai.getTail(), origTail, false)) continue;
                    tailYOff = 0.0;
                    tailXOff = 0.0;
                }
                if ((ang = ai.getAngle()) == 0 || ang == 1800) {
                    if (headYOff != tailYOff) {
                        tailYOff = 0.0;
                        headYOff = 0.0;
                    }
                } else if ((ang == 900 || ang == 2700) && headXOff != tailXOff) {
                    tailXOff = 0.0;
                    headXOff = 0.0;
                }
                if (headXOff == 0.0 && tailXOff == 0.0 && headYOff == 0.0 && tailYOff == 0.0) continue;
                int constr = 0;
                if (ai.isRigid()) {
                    constr |= 1;
                }
                if (ai.isFixedAngle()) {
                    constr |= 2;
                }
                ai.clearRigid();
                ai.clearFixedAngle();
                ai.modify(0.0, headXOff, headYOff, tailXOff, tailYOff);
                ++adjustedArcs;
                if ((constr & 1) != 0) {
                    ai.setRigid();
                }
                if ((constr & 2) == 0) continue;
                ai.setFixedAngle();
            }
            if (adjustedNodes == 0 && adjustedArcs == 0) {
                System.out.println("No adjustments necessary");
            } else {
                System.out.println("Adjusted " + adjustedNodes + " nodes and " + adjustedArcs + " arcs");
            }
            return true;
        }
    }

    private static class RotateSelected
    extends Job {
        private Cell cell;
        private int amount;
        private boolean mirror;
        private boolean mirrorH;

        protected RotateSelected(Cell cell, int amount, boolean mirror, boolean mirrorH) {
            super("Rotate selected objects", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.amount = amount;
            this.mirror = mirror;
            this.mirrorH = mirrorH;
            this.startJob();
        }

        public boolean doIt() {
            Geometric geom;
            NodeInst ni;
            FlagSet markObj = Geometric.getFlagSet(1);
            Iterator it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni2 = (NodeInst)it.next();
                ni2.clearBit(markObj);
            }
            int nicount = 0;
            Geometric theNi = null;
            Rectangle2D.Double selectedBounds = new Rectangle2D.Double();
            List highs = Highlight.getHighlighted(true, true);
            Iterator it2 = highs.iterator();
            while (it2.hasNext()) {
                Geometric geom2 = (Geometric)it2.next();
                if (!(geom2 instanceof NodeInst)) continue;
                NodeInst ni3 = (NodeInst)geom2;
                if (CircuitChanges.cantEdit(this.cell, ni3, true)) {
                    markObj.freeFlagSet();
                    return false;
                }
                ni3.setBit(markObj);
                if (nicount == 0) {
                    ((Rectangle2D)selectedBounds).setRect(ni3.getBounds());
                } else {
                    Rectangle2D.union(selectedBounds, ni3.getBounds(), selectedBounds);
                }
                theNi = ni3;
                ++nicount;
            }
            if (nicount <= 0) {
                System.out.println("Must select at least 1 node for rotation");
                markObj.freeFlagSet();
                return false;
            }
            if (nicount > 1) {
                Point2D.Double center = new Point2D.Double(selectedBounds.getCenterX(), selectedBounds.getCenterY());
                theNi = null;
                double bestdist = 2.147483647E9;
                Iterator it3 = this.cell.getNodes();
                while (it3.hasNext()) {
                    ni = (NodeInst)it3.next();
                    if (!ni.isBit(markObj)) continue;
                    double dist = center.distance(ni.getTrueCenter());
                    if (theNi != null && !(dist < bestdist)) continue;
                    theNi = ni;
                    bestdist = dist;
                }
            }
            it2 = this.cell.getNodes();
            while (it2.hasNext()) {
                NodeInst ni4 = (NodeInst)it2.next();
                ni4.clearBit(markObj);
            }
            theNi.setBit(markObj);
            it2 = this.cell.getArcs();
            while (it2.hasNext()) {
                ArcInst ai = (ArcInst)it2.next();
                ai.clearBit(markObj);
            }
            it2 = highs.iterator();
            while (it2.hasNext()) {
                Geometric geom3 = (Geometric)it2.next();
                if (!(geom3 instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)geom3;
                ai.setBit(markObj);
            }
            CircuitChanges.spreadRotateConnection((NodeInst)theNi, markObj);
            ArrayList<NodeInst> niList = new ArrayList<NodeInst>();
            ArrayList<ArcInst> aiList = new ArrayList<ArcInst>();
            Iterator it4 = highs.iterator();
            while (it4.hasNext()) {
                geom = (Geometric)it4.next();
                if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom) == theNi || ni.isBit(markObj)) continue;
                if (((NodeInst)theNi).getNumPortInsts() == 0) {
                    Export thepp;
                    Cell subCell = (Cell)((NodeInst)theNi).getProto();
                    NodeInst subni = NodeInst.makeInstance(Generic.tech.universalPinNode, new Point2D.Double(0.0, 0.0), 0.0, 0.0, 0, subCell, null);
                    if (subni == null || (thepp = Export.newInstance(subCell, subni.getOnlyPortInst(), "temp")) == null) break;
                    niList.add(subni);
                }
                PortInst thepi = ((NodeInst)theNi).getPortInst(0);
                if (ni.getNumPortInsts() == 0) continue;
                ArcInst ai = ArcInst.makeInstance(Generic.tech.invisible_arc, 0.0, ni.getPortInst(0), thepi, null);
                if (ai == null) break;
                ai.setRigid();
                aiList.add(ai);
                CircuitChanges.spreadRotateConnection(ni, markObj);
            }
            it4 = highs.iterator();
            while (it4.hasNext()) {
                geom = (Geometric)it4.next();
                if (!(geom instanceof ArcInst)) continue;
                Layout.setTempRigid((ArcInst)geom, true);
            }
            if (this.mirror) {
                if (this.mirrorH) {
                    double sY = ((NodeInst)theNi).getYSizeWithMirror();
                    ((NodeInst)theNi).modifyInstance(0.0, 0.0, 0.0, -sY - sY, 0);
                } else {
                    double sX = ((NodeInst)theNi).getXSizeWithMirror();
                    ((NodeInst)theNi).modifyInstance(0.0, 0.0, -sX - sX, 0.0, 0);
                }
            } else {
                ((NodeInst)theNi).modifyInstance(0.0, 0.0, 0.0, 0.0, this.amount);
            }
            it = aiList.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ai.kill();
            }
            it = niList.iterator();
            while (it.hasNext()) {
                NodeInst ni5 = (NodeInst)it.next();
                ni5.kill();
            }
            markObj.freeFlagSet();
            return true;
        }
    }
}

