/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.jemNets.Port;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExportChecker {
    private NccGlobals globals;
    private HashMap[] equivPortMaps;

    private Circuit[] getCircuitsHoldingPorts() {
        EquivRecord ports = this.globals.getPorts();
        this.globals.error(!ports.isLeaf(), "globals ports must hold circuits");
        int numCkts = this.globals.getNumNetlistsBeingCompared();
        Circuit[] portCkts = new Circuit[numCkts];
        int i = 0;
        Iterator it = ports.getCircuits();
        while (it.hasNext()) {
            portCkts[i] = (Circuit)it.next();
            ++i;
        }
        return portCkts;
    }

    private HashMap mapFromExportNameToPort(Circuit ckt) {
        HashMap map = new HashMap();
        Iterator it = ckt.getNetObjs();
        while (it.hasNext()) {
            Port p = (Port)it.next();
            Iterator itN = p.getExportNames();
            while (itN.hasNext()) {
                map.put(itN.next(), p);
            }
        }
        return map;
    }

    private void prln(String s) {
        this.globals.println(s);
    }

    private void pr(String s) {
        this.globals.print(s);
    }

    private void printOneToManyError(String design1, String exports1, String design2, String exports2a, String exports2b) {
        this.prln("A single network in: " + design1 + " has Exports with names that ");
        this.pr("match multiple Exports in: " + design2);
        this.prln("However, the " + design2 + " Exports are attached to more than one network.");
        this.prln("    The " + design1 + " Exports are: " + exports1);
        this.prln("    The 1st set of " + design2 + " Exports are: " + exports2a);
        this.prln("    The 2nd set of " + design2 + " Exports are: " + exports2b);
    }

    private boolean matchPortsByName(HashMap p1ToP2, Circuit ports1, String designName1, Circuit ports2, String designName2) {
        boolean match = true;
        HashMap exportName2ToPort2 = this.mapFromExportNameToPort(ports2);
        if (p1ToP2 == null) {
            p1ToP2 = new HashMap<Port, Port>();
        }
        Iterator it = ports1.getNetObjs();
        while (it.hasNext()) {
            Port p1 = (Port)it.next();
            Port p2 = null;
            Iterator itN = p1.getExportNames();
            while (itN.hasNext()) {
                String exportNm1 = (String)itN.next();
                Port p = (Port)exportName2ToPort2.get(exportNm1);
                if (p == null) continue;
                if (p2 == null) {
                    p2 = p;
                    continue;
                }
                if (p == p2) continue;
                this.printOneToManyError(designName1, p1.exportNamesString(), designName2, p.exportNamesString(), p2.exportNamesString());
                match = false;
            }
            if (p2 == null) {
                this.pr("In " + designName1 + " the network with Exports: " + p1.exportNamesString());
                this.prln("    matches no Export with the same name in: " + designName2);
                match = false;
                continue;
            }
            p1ToP2.put(p1, p2);
        }
        return match;
    }

    private boolean matchExportsByName() {
        int numCkts = this.globals.getNumNetlistsBeingCompared();
        String[] rootCellNames = this.globals.getRootCellNames();
        Circuit[] portCkts = this.getCircuitsHoldingPorts();
        this.equivPortMaps = new HashMap[numCkts];
        boolean match = true;
        for (int i = 1; i < numCkts; ++i) {
            match &= this.matchPortsByName(null, portCkts[i], rootCellNames[i], portCkts[0], rootCellNames[0]);
            HashMap p0ToPi = new HashMap();
            match &= this.matchPortsByName(p0ToPi, portCkts[0], rootCellNames[0], portCkts[i], rootCellNames[i]);
            this.equivPortMaps[i] = p0ToPi;
        }
        return match;
    }

    private SubcircuitInfo getInfoForReferenceCell(HierarchyInfo hierInfo) {
        Cell refCell = this.globals.getRootCells()[0];
        SubcircuitInfo refInfo = hierInfo.getSubcircuitInfo(refCell);
        if (refInfo != null) {
            return refInfo;
        }
        Port[] refCktPorts = this.getFirstCktPorts();
        refInfo = new SubcircuitInfo(hierInfo.currentSubcircuitName(), hierInfo.currentSubcircuitID(), refCktPorts);
        hierInfo.addSubcircuitInfo(refCell, refInfo);
        return refInfo;
    }

    private Port[] getFirstCktPorts() {
        Circuit[] portCkts = this.getCircuitsHoldingPorts();
        Circuit firstCkt = portCkts[0];
        Port[] ports = new Port[firstCkt.numNetObjs()];
        int i = 0;
        Iterator it = firstCkt.getNetObjs();
        while (it.hasNext()) {
            ports[i] = (Port)it.next();
            ++i;
        }
        return ports;
    }

    private Map mapExportNameToPortIndex(SubcircuitInfo refCellInfo, Map equivPortMap) {
        HashMap exportNameToPortIndex = new HashMap();
        Port[] firstCktPorts = this.getFirstCktPorts();
        for (int i = 0; i < firstCktPorts.length; ++i) {
            Port firstCktPort = firstCktPorts[i];
            String firstCktPortName = (String)firstCktPort.getExportNames().next();
            int portNdx = refCellInfo.getPortIndex(firstCktPortName);
            Port equivPort = (Port)equivPortMap.get(firstCktPort);
            if (equivPort == null) continue;
            Iterator it = equivPort.getExportNames();
            while (it.hasNext()) {
                exportNameToPortIndex.put(it.next(), new Integer(portNdx));
            }
        }
        return exportNameToPortIndex;
    }

    public ExportChecker(NccGlobals globals) {
        this.globals = globals;
    }

    public boolean matchByName() {
        NccOptions options = this.globals.getOptions();
        boolean verboseSave = options.verbose;
        options.verbose = true;
        boolean match = this.matchExportsByName();
        options.verbose = verboseSave;
        return match;
    }

    public void saveInfoNeededToMakeMeASubcircuit(HierarchyInfo hierInfo) {
        if (hierInfo == null) {
            return;
        }
        Cell[] rootCells = this.globals.getRootCells();
        SubcircuitInfo refCellInfo = this.getInfoForReferenceCell(hierInfo);
        for (int i = 1; i < this.equivPortMaps.length; ++i) {
            Map exportNameToPortIndex = this.mapExportNameToPortIndex(refCellInfo, this.equivPortMaps[i]);
            SubcircuitInfo subInf = new SubcircuitInfo(refCellInfo, exportNameToPortIndex);
            hierInfo.addSubcircuitInfo(rootCells[i], subInf);
        }
    }

    public boolean ensureExportsWithMatchingNamesAreOnEquivalentNets() {
        NccOptions options = this.globals.getOptions();
        boolean verboseSave = options.verbose;
        options.verbose = true;
        boolean match = true;
        String[] rootCellNames = this.globals.getRootCellNames();
        for (int i = 1; i < this.equivPortMaps.length; ++i) {
            HashMap portToPort = this.equivPortMaps[i];
            Iterator it = portToPort.keySet().iterator();
            while (it.hasNext()) {
                EquivRecord ern;
                Port p0 = (Port)it.next();
                Port pn = (Port)portToPort.get(p0);
                EquivRecord er0 = p0.getParent().getParent();
                if (er0 == (ern = pn.getParent().getParent())) continue;
                this.prln("Exports that match by name aren't on equivalent networks\n  Cell1: " + rootCellNames[0] + "\n" + "  Exports1: " + p0.exportNamesString() + "\n" + "  Cell2: " + rootCellNames[i] + "\n" + "  Exports2: " + pn.exportNamesString() + "\n");
                match = false;
            }
        }
        options.verbose = verboseSave;
        return match;
    }
}

