/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;

class ViaStack {
    private PortInst port1;
    private PortInst port2;

    private void swap() {
        PortInst tp = this.port1;
        this.port1 = this.port2;
        this.port2 = tp;
    }

    private void buildStack(int hLo, int hHi, double x, double y, double width, double height, Cell f) {
        PortInst viaBelow = null;
        for (int h = hLo; h < hHi; ++h) {
            PrimitiveNode via = Tech.viaAbove(h);
            double wid = Math.max(width, LayoutLib.getNodeProtoWidth(via));
            double hei = Math.max(height, LayoutLib.getNodeProtoHeight(via));
            PortInst viaAbove = LayoutLib.newNodeInst(via, x, y, wid, hei, 0.0, f).getOnlyPortInst();
            if (viaBelow == null) {
                this.port1 = viaAbove;
            } else {
                LayoutLib.newArcInst(Tech.layerAtHeight(h), 1.0, viaBelow, viaAbove);
            }
            this.port2 = viaAbove;
            viaBelow = viaAbove;
        }
    }

    public ViaStack(ArcProto arc1, ArcProto arc2, double x, double y, double width, Cell f) {
        this(arc1, arc2, x, y, width, width, f);
    }

    public ViaStack(ArcProto arc1, ArcProto arc2, double x, double y, double width, double height, Cell f) {
        int h1 = Tech.layerHeight(arc1);
        int h2 = Tech.layerHeight(arc2);
        int deltaZ = h2 - h1;
        if (arc1 == arc2) {
            PrimitiveNode pin = ((PrimitiveArc)arc1).findOverridablePinProto();
            double defSz = Double.POSITIVE_INFINITY;
            NodeInst pinInst = LayoutLib.newNodeInst(pin, x, y, defSz, defSz, 0.0, f);
            this.port1 = this.port2 = pinInst.getOnlyPortInst();
        } else if (deltaZ > 0) {
            this.buildStack(h1, h2, x, y, width, height, f);
        } else {
            this.buildStack(h2, h1, x, y, width, height, f);
            this.swap();
        }
    }

    public PortInst getPort1() {
        return this.port1;
    }

    public PortInst getPort2() {
        return this.port2;
    }

    public double getCenterX() {
        return this.port1.getBounds().getCenterX();
    }

    public double getCenterY() {
        return this.port1.getBounds().getCenterY();
    }
}

