# Solfege - free ear training software
# Copyright (C) 2007, 2008 Tom Cato Amundsen
# License is GPL, see file COPYING

from __future__ import absolute_import
import unittest
from solfege.utils import Url, string_get_line_at

class TestUrl(unittest.TestCase):
    def setUp(self):
        pass
    def test_all(self):
        url = Url('solfege:practise/lesson-files/melodic-intervals?ask_for_names=[1, 2, 3]')
        self.assert_(url.protocol == 'solfege')
        self.assert_(url.action == 'practise')
        self.assert_(url.lessonfile == 'lesson-files/melodic-intervals')
        self.assert_(url.config == {'ask_for_names': '[1, 2, 3]'})
        url = Url('solfege://home/tom/lessonfiles/melodic-intervals?ask_for_names=[1, 2, 3]')
        self.assert_(url.protocol == 'solfege')
        self.assert_(url.lessonfile == '/home/tom/lessonfiles/melodic-intervals')
        self.assert_(url.config == {'ask_for_names': '[1, 2, 3]'})

class TestStringGetLineAt(unittest.TestCase):
    def test1(self):
        self.assertEquals(string_get_line_at("abc", 1), "abc")
        self.assertEquals(string_get_line_at("\nabc", 1), "abc")
        self.assertEquals(string_get_line_at("abc\n", 0), "abc")
        self.assertEquals(string_get_line_at("abc\n", 2), "abc")
        self.assertEquals(string_get_line_at("abc\n", 3), "abc")
        self.assertEquals(string_get_line_at("abc\n\n", 3), "abc")
        self.assertEquals(string_get_line_at("abc\n\n", 4), "")
        self.assertEquals(string_get_line_at("abc\n\nx", 4), "")
        self.assertEquals(string_get_line_at("abc\n\nx", 5), "x")
        self.assertRaises(IndexError, lambda x: string_get_line_at("", 0), "")
        self.assertEquals(string_get_line_at("  \n\n   \t \n \t abc \n", 3), "")
        self.assertEquals(string_get_line_at("  \n\n   \t \n \t abc \n", 4), "   \t ")

suite = unittest.makeSuite(TestUrl)
suite.addTest(unittest.makeSuite(TestStringGetLineAt))
