#line 2 "lexer.l"
/* cfg_lexer.l -- default lexer for Mailutils configuration files
   Copyright (C) 2007-2012, 2014-2017 Free Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 3, or (at
   your option) any later version.

   GNU Mailutils is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#line 25 "lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define mu_cfg_yyconst const
#else
#define mu_cfg_yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (mu_cfg_yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((mu_cfg_yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE mu_cfg_yyrestart(mu_cfg_yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(mu_cfg_yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct mu_cfg_yy_buffer_state *YY_BUFFER_STATE;
#endif

/* %if-not-reentrant */
extern int mu_cfg_yyleng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *mu_cfg_yyin, *mu_cfg_yyout;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define mu_cfg_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up mu_cfg_yytext. */ \
        int mu_cfg_yyless_macro_arg = (n); \
        YY_LESS_LINENO(mu_cfg_yyless_macro_arg);\
		*mu_cfg_yy_cp = (mu_cfg_yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(mu_cfg_yy_c_buf_p) = mu_cfg_yy_cp = mu_cfg_yy_bp + mu_cfg_yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up mu_cfg_yytext again */ \
		} \
	while ( 0 )

#define unput(c) mu_cfg_yyunput( c, (mu_cfg_yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t mu_cfg_yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct mu_cfg_yy_buffer_state
	{
/* %if-c-only */
	FILE *mu_cfg_yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *mu_cfg_yy_ch_buf;		/* input buffer */
	char *mu_cfg_yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	mu_cfg_yy_size_t mu_cfg_yy_buf_size;

	/* Number of characters read into mu_cfg_yy_ch_buf, not including EOB
	 * characters.
	 */
	int mu_cfg_yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int mu_cfg_yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int mu_cfg_yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int mu_cfg_yy_at_bol;

    int mu_cfg_yy_bs_lineno; /**< The line count. */
    int mu_cfg_yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int mu_cfg_yy_fill_buffer;

	int mu_cfg_yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via mu_cfg_yyrestart()), so that the user can continue scanning by
	 * just pointing mu_cfg_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t mu_cfg_yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t mu_cfg_yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * mu_cfg_yy_buffer_stack = 0; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (mu_cfg_yy_buffer_stack) \
                          ? (mu_cfg_yy_buffer_stack)[(mu_cfg_yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (mu_cfg_yy_buffer_stack)[(mu_cfg_yy_buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* mu_cfg_yy_hold_char holds the character lost when mu_cfg_yytext is formed. */
static char mu_cfg_yy_hold_char;
static int mu_cfg_yy_n_chars;		/* number of characters read into mu_cfg_yy_ch_buf */
int mu_cfg_yyleng;

/* Points to current character in buffer. */
static char *mu_cfg_yy_c_buf_p = (char *) 0;
static int mu_cfg_yy_init = 0;		/* whether we need to initialize */
static int mu_cfg_yy_start = 0;	/* start state number */

/* Flag which is used to allow mu_cfg_yywrap()'s to do buffer switches
 * instead of setting up a fresh mu_cfg_yyin.  A bit of a hack ...
 */
static int mu_cfg_yy_did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void mu_cfg_yyrestart (FILE *input_file  );
void mu_cfg_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE mu_cfg_yy_create_buffer (FILE *file,int size  );
void mu_cfg_yy_delete_buffer (YY_BUFFER_STATE b  );
void mu_cfg_yy_flush_buffer (YY_BUFFER_STATE b  );
void mu_cfg_yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void mu_cfg_yypop_buffer_state (void );

static void mu_cfg_yyensure_buffer_stack (void );
static void mu_cfg_yy_load_buffer_state (void );
static void mu_cfg_yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER mu_cfg_yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE mu_cfg_yy_scan_buffer (char *base,mu_cfg_yy_size_t size  );
YY_BUFFER_STATE mu_cfg_yy_scan_string (mu_cfg_yyconst char *mu_cfg_yy_str  );
YY_BUFFER_STATE mu_cfg_yy_scan_bytes (mu_cfg_yyconst char *bytes,int len  );

/* %endif */

void *mu_cfg_yyalloc (mu_cfg_yy_size_t  );
void *mu_cfg_yyrealloc (void *,mu_cfg_yy_size_t  );
void mu_cfg_yyfree (void *  );

#define mu_cfg_yy_new_buffer mu_cfg_yy_create_buffer

#define mu_cfg_yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        mu_cfg_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            mu_cfg_yy_create_buffer(mu_cfg_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_is_interactive = is_interactive; \
	}

#define mu_cfg_yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        mu_cfg_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            mu_cfg_yy_create_buffer(mu_cfg_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_at_bol)

/* %% [1.0] mu_cfg_yytext/mu_cfg_yyin/mu_cfg_yyout/mu_cfg_yy_state_type/mu_cfg_yylineno etc. def's & init go here */
/* Begin user sect3 */

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

FILE *mu_cfg_yyin = (FILE *) 0, *mu_cfg_yyout = (FILE *) 0;

typedef int mu_cfg_yy_state_type;

extern int mu_cfg_yylineno;

int mu_cfg_yylineno = 1;

extern char *mu_cfg_yytext;
#define mu_cfg_yytext_ptr mu_cfg_yytext

/* %if-c-only Standard (non-C++) definition */

static mu_cfg_yy_state_type mu_cfg_yy_get_previous_state (void );
static mu_cfg_yy_state_type mu_cfg_yy_try_NUL_trans (mu_cfg_yy_state_type current_state  );
static int mu_cfg_yy_get_next_buffer (void );
static void mu_cfg_yy_fatal_error (mu_cfg_yyconst char msg[]  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up mu_cfg_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(mu_cfg_yytext_ptr) = mu_cfg_yy_bp; \
/* %% [2.0] code to fiddle mu_cfg_yytext and mu_cfg_yyleng for mu_cfg_yymore() goes here \ */\
	mu_cfg_yyleng = (size_t) (mu_cfg_yy_cp - mu_cfg_yy_bp); \
	(mu_cfg_yy_hold_char) = *mu_cfg_yy_cp; \
	*mu_cfg_yy_cp = '\0'; \
/* %% [3.0] code to copy mu_cfg_yytext_ptr to mu_cfg_yytext[] goes here, if %array \ */\
	(mu_cfg_yy_c_buf_p) = mu_cfg_yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 30
#define YY_END_OF_BUFFER 31
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct mu_cfg_yy_trans_info
	{
	flex_int32_t mu_cfg_yy_verify;
	flex_int32_t mu_cfg_yy_nxt;
	};
static mu_cfg_yyconst flex_int16_t mu_cfg_yy_accept[94] =
    {   0,
        0,    0,    2,    2,    0,    0,    0,    0,   31,   29,
       26,   27,   29,    8,   28,   12,   12,   29,   12,    2,
        4,    3,   30,   25,   30,   30,   18,   30,   26,    0,
       13,    0,    8,    7,    8,   12,    1,   10,    0,   11,
        2,    3,    3,    5,    0,   25,    0,   18,    0,    0,
        0,   16,   14,   15,    8,   10,    9,   10,    0,    0,
        0,    0,   17,    8,    0,    0,    0,    8,    0,    0,
       21,    0,    0,    8,    0,    0,   19,    0,    8,    0,
       24,    0,    0,    0,   20,    8,    6,    0,   22,    0,
        0,   23,    0

    } ;

static mu_cfg_yyconst flex_int32_t mu_cfg_yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    6,    7,    1,    1,    1,    1,    8,
        8,    9,    1,    8,   10,   11,   12,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   11,    8,   14,
       15,    1,    1,   11,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
        1,   17,    1,    1,   16,    1,   16,   18,   16,   19,

       20,   16,   21,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   22,   16,   16,   16,
       16,   16,    8,    1,    8,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static mu_cfg_yyconst flex_int32_t mu_cfg_yy_meta[23] =
    {   0,
        1,    1,    2,    1,    1,    3,    1,    1,    4,    5,
        6,    6,    7,    1,    6,    8,    9,    8,    8,    8,
        8,    8
    } ;

static mu_cfg_yyconst flex_int16_t mu_cfg_yy_base[118] =
    {   0,
        0,    0,   20,   21,  144,  143,   22,   28,  145,  337,
       31,  337,   20,   24,  337,    0,   29,  129,   37,    0,
      337,   35,  138,  337,   34,  337,  120,    0,   51,   44,
      337,  133,  132,  337,   39,    0,    0,   61,   78,   87,
        0,   45,   77,  337,  131,  337,   84,  337,    0,  115,
      127,  337,  337,  337,   82,  123,  337,    0,    0,   98,
        0,   99,  337,   84,    0,  120,  115,   89,  118,  126,
      337,  120,  109,  104,  137,  111,  337,  110,  109,    0,
      337,  108,   85,   91,  337,   90,  337,   88,  337,   57,
       55,  337,  337,  149,  158,  167,  176,  185,  191,  196,

      204,  213,  222,  231,  240,  249,  258,  265,  274,   24,
      279,  283,  291,  300,  309,  318,  327
    } ;

static mu_cfg_yyconst flex_int16_t mu_cfg_yy_def[118] =
    {   0,
       93,    1,   94,   94,   95,   95,   96,   96,   93,   93,
       93,   93,   97,   98,   93,   99,   99,   93,  100,  101,
       93,  102,  103,   93,  104,   93,  105,  106,   93,   97,
       93,  107,   98,   93,   98,   99,   99,   93,  108,  100,
      101,  102,  102,   93,  103,   93,  104,   93,  106,  105,
       93,   93,   93,   93,   98,  109,   93,   38,  110,  108,
      111,  108,   93,   98,  112,   60,  111,   98,  112,   93,
       93,  113,   93,   98,   93,  113,   93,  114,  115,   75,
       93,  116,   93,  114,   93,  115,   93,  116,   93,  117,
      117,   93,    0,   93,   93,   93,   93,   93,   93,   93,

       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93
    } ;

static mu_cfg_yyconst flex_int16_t mu_cfg_yy_nxt[360] =
    {   0,
       10,   11,   12,   11,   11,   13,   14,   15,   16,   16,
       16,   17,   16,   18,   16,   19,   10,   19,   19,   19,
       19,   19,   21,   21,   26,   31,   34,   27,   22,   22,
       26,   65,   29,   27,   29,   29,   32,   37,   28,   48,
       38,   34,   35,   43,   28,   36,   44,   36,   36,   31,
       49,   36,   29,   93,   29,   29,   93,   92,   55,   92,
       32,   56,   56,   57,   56,   56,   56,   56,   56,   58,
       58,   58,   58,   58,   56,   58,   58,   56,   58,   58,
       58,   58,   58,   59,   34,   43,   34,   60,   44,   48,
       89,   34,   87,   85,   62,   36,   90,   36,   36,   64,

       49,   36,   66,   59,   93,   68,   34,   93,   93,   74,
       89,   87,   85,   77,   62,   93,   70,   71,   79,   70,
       78,   72,   77,   75,   93,   57,   73,   70,   71,   63,
       70,   51,   72,   46,   34,   54,   51,   73,   80,   81,
       46,   80,   39,   82,   93,   24,   24,   93,   83,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   30,   93,   30,   30,
       30,   30,   30,   30,   30,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   36,   36,   36,   36,   36,   40,

       40,   40,   40,   40,   41,   93,   41,   93,   41,   41,
       41,   41,   41,   42,   93,   42,   42,   42,   42,   42,
       42,   42,   45,   45,   45,   45,   45,   45,   45,   45,
       45,   47,   93,   47,   47,   47,   47,   47,   47,   47,
       50,   93,   93,   50,   50,   50,   50,   50,   50,   52,
       93,   52,   52,   52,   52,   52,   52,   52,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   61,   93,   61,
       93,   93,   61,   61,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   67,   93,   67,   67,   69,   93,   69,
       69,   76,   76,   76,   76,   76,   76,   76,   76,   76,

       84,   84,   84,   84,   84,   84,   84,   84,   84,   86,
       86,   86,   86,   86,   86,   86,   86,   86,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   91,   91,   91,
       91,   91,   91,   91,   91,   91,    9,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93
    } ;

static mu_cfg_yyconst flex_int16_t mu_cfg_yy_chk[360] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    3,    4,    7,   13,   14,    7,    3,    4,
        8,  110,   11,    8,   11,   11,   13,   17,    7,   25,
       17,   35,   14,   22,    8,   19,   22,   19,   19,   30,
       25,   19,   29,   42,   29,   29,   42,   91,   35,   90,
       30,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   39,   55,   43,   64,   39,   43,   47,
       88,   68,   86,   84,   39,   40,   83,   40,   40,   55,

       47,   40,   60,   60,   62,   64,   74,   60,   62,   68,
       82,   79,   78,   76,   60,   62,   67,   67,   74,   67,
       73,   67,   72,   69,   66,   56,   67,   70,   70,   51,
       70,   50,   70,   45,   33,   32,   27,   70,   75,   75,
       23,   75,   18,   75,    9,    6,    5,    0,   75,   94,
       94,   94,   94,   94,   94,   94,   94,   94,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   97,    0,   97,   97,
       97,   97,   97,   97,   97,   98,   98,   98,   98,   98,
       98,   98,   98,   98,   99,   99,   99,   99,   99,  100,

      100,  100,  100,  100,  101,    0,  101,    0,  101,  101,
      101,  101,  101,  102,    0,  102,  102,  102,  102,  102,
      102,  102,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  104,    0,  104,  104,  104,  104,  104,  104,  104,
      105,    0,    0,  105,  105,  105,  105,  105,  105,  106,
        0,  106,  106,  106,  106,  106,  106,  106,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  108,    0,  108,
        0,    0,  108,  108,  109,  109,  109,  109,  109,  109,
      109,  109,  109,  111,    0,  111,  111,  112,    0,  112,
      112,  113,  113,  113,  113,  113,  113,  113,  113,  113,

      114,  114,  114,  114,  114,  114,  114,  114,  114,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  117,  117,  117,
      117,  117,  117,  117,  117,  117,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93
    } ;

static mu_cfg_yy_state_type mu_cfg_yy_last_accepting_state;
static char *mu_cfg_yy_last_accepting_cpos;

extern int mu_cfg_yy_flex_debug;
int mu_cfg_yy_flex_debug = 1;

static mu_cfg_yyconst flex_int16_t mu_cfg_yy_rule_linenum[30] =
    {   0,
       83,   84,   85,   86,   87,   89,   94,   95,   96,   97,
       99,  105,  110,  114,  115,  118,  119,  120,  126,  127,
      128,  129,  130,  131,  136,  149,  151,  152,  153
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define mu_cfg_yymore() mu_cfg_yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *mu_cfg_yytext;
#line 1 "lexer.l"

#line 24 "lexer.l"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <mailutils/cctype.h>
#include <mailutils/errno.h>
#include <mailutils/error.h>
#include <mailutils/debug.h>  
#include <mailutils/wordsplit.h>
#include <mailutils/alloc.h>  
#include <mailutils/nls.h>
#include <mailutils/cfg.h>
#include <mailutils/list.h>
#include <mailutils/util.h>
  
#include "parser.h"

void _mu_line_begin (void);
void _mu_line_add (char *text, size_t len);
char *_mu_line_finish (void);

extern void mu_cfg_set_debug (void);
static void
mu_cfg_set_lex_debug (void)
{
  mu_cfg_yy_flex_debug = mu_debug_level_p (MU_DEBCAT_CONFIG, MU_DEBUG_TRACE2);
}
 
static void _mu_line_add_unescape_last (char *text, size_t len);
static void multiline_begin (char *p);
static char *multiline_strip_tabs (char *text);
static void multiline_add (char *s);
static char *multiline_finish (void);
 
static char *multiline_delimiter;
static size_t multiline_delimiter_len;
static int multiline_unescape;         /* Unescape here-document contents */
static int (*char_to_strip)(char);     /* Strip matching characters of each
					  here-document line */
static int isemptystr(int off);

static mu_opool_t pool;

#define YY_NO_INPUT 1

#line 723 "lexer.c"

#define INITIAL 0
#define COMMENT 1
#define ML 2
#define STR 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int mu_cfg_yy_init_globals (void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int mu_cfg_yylex_destroy (void );

int mu_cfg_yyget_debug (void );

void mu_cfg_yyset_debug (int debug_flag  );

YY_EXTRA_TYPE mu_cfg_yyget_extra (void );

void mu_cfg_yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *mu_cfg_yyget_in (void );

void mu_cfg_yyset_in  (FILE * in_str  );

FILE *mu_cfg_yyget_out (void );

void mu_cfg_yyset_out  (FILE * out_str  );

int mu_cfg_yyget_leng (void );

char *mu_cfg_yyget_text (void );

int mu_cfg_yyget_lineno (void );

void mu_cfg_yyset_lineno (int line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int mu_cfg_yywrap (void );
#else
extern int mu_cfg_yywrap (void );
#endif
#endif

/* %not-for-header */

/* %ok-for-header */

/* %endif */

#ifndef mu_cfg_yytext_ptr
static void mu_cfg_yy_flex_strncpy (char *,mu_cfg_yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int mu_cfg_yy_flex_strlen (mu_cfg_yyconst char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int mu_cfg_yyinput (void );
#else
static int input (void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( mu_cfg_yytext, mu_cfg_yyleng, 1, mu_cfg_yyout )
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( mu_cfg_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( mu_cfg_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, mu_cfg_yyin))==0 && ferror(mu_cfg_yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(mu_cfg_yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "mu_cfg_yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef mu_cfg_yyterminate
#define mu_cfg_yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) mu_cfg_yy_fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-mu_cfg_yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int mu_cfg_yylex (void);

#define YY_DECL int mu_cfg_yylex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after mu_cfg_yytext and mu_cfg_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register mu_cfg_yy_state_type mu_cfg_yy_current_state;
	register char *mu_cfg_yy_cp, *mu_cfg_yy_bp;
	register int mu_cfg_yy_act;
    
/* %% [7.0] user's declarations go here */
#line 81 "lexer.l"

         /* C-style comments */
#line 969 "lexer.c"

	if ( !(mu_cfg_yy_init) )
		{
		(mu_cfg_yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (mu_cfg_yy_start) )
			(mu_cfg_yy_start) = 1;	/* first start state */

		if ( ! mu_cfg_yyin )
/* %if-c-only */
			mu_cfg_yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! mu_cfg_yyout )
/* %if-c-only */
			mu_cfg_yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			mu_cfg_yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				mu_cfg_yy_create_buffer(mu_cfg_yyin,YY_BUF_SIZE );
		}

		mu_cfg_yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] mu_cfg_yymore()-related code goes here */
		mu_cfg_yy_cp = (mu_cfg_yy_c_buf_p);

		/* Support of mu_cfg_yytext. */
		*mu_cfg_yy_cp = (mu_cfg_yy_hold_char);

		/* mu_cfg_yy_bp points to the position in mu_cfg_yy_ch_buf of the start of
		 * the current run.
		 */
		mu_cfg_yy_bp = mu_cfg_yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		mu_cfg_yy_current_state = (mu_cfg_yy_start);
mu_cfg_yy_match:
		do
			{
			register YY_CHAR mu_cfg_yy_c = mu_cfg_yy_ec[YY_SC_TO_UI(*mu_cfg_yy_cp)];
			if ( mu_cfg_yy_accept[mu_cfg_yy_current_state] )
				{
				(mu_cfg_yy_last_accepting_state) = mu_cfg_yy_current_state;
				(mu_cfg_yy_last_accepting_cpos) = mu_cfg_yy_cp;
				}
			while ( mu_cfg_yy_chk[mu_cfg_yy_base[mu_cfg_yy_current_state] + mu_cfg_yy_c] != mu_cfg_yy_current_state )
				{
				mu_cfg_yy_current_state = (int) mu_cfg_yy_def[mu_cfg_yy_current_state];
				if ( mu_cfg_yy_current_state >= 94 )
					mu_cfg_yy_c = mu_cfg_yy_meta[(unsigned int) mu_cfg_yy_c];
				}
			mu_cfg_yy_current_state = mu_cfg_yy_nxt[mu_cfg_yy_base[mu_cfg_yy_current_state] + (unsigned int) mu_cfg_yy_c];
			++mu_cfg_yy_cp;
			}
		while ( mu_cfg_yy_base[mu_cfg_yy_current_state] != 337 );

mu_cfg_yy_find_action:
/* %% [10.0] code to find the action number goes here */
		mu_cfg_yy_act = mu_cfg_yy_accept[mu_cfg_yy_current_state];
		if ( mu_cfg_yy_act == 0 )
			{ /* have to back up */
			mu_cfg_yy_cp = (mu_cfg_yy_last_accepting_cpos);
			mu_cfg_yy_current_state = (mu_cfg_yy_last_accepting_state);
			mu_cfg_yy_act = mu_cfg_yy_accept[mu_cfg_yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for mu_cfg_yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( mu_cfg_yy_flex_debug )
			{
			if ( mu_cfg_yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( mu_cfg_yy_act < 30 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)mu_cfg_yy_rule_linenum[mu_cfg_yy_act], mu_cfg_yytext );
			else if ( mu_cfg_yy_act == 30 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         mu_cfg_yytext );
			else if ( mu_cfg_yy_act == 31 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( mu_cfg_yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*mu_cfg_yy_cp = (mu_cfg_yy_hold_char);
			mu_cfg_yy_cp = (mu_cfg_yy_last_accepting_cpos);
			mu_cfg_yy_current_state = (mu_cfg_yy_last_accepting_state);
			goto mu_cfg_yy_find_action;

case 1:
YY_RULE_SETUP
#line 83 "lexer.l"
BEGIN(COMMENT);
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 84 "lexer.l"
/* eat anything that's not a '*' */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 85 "lexer.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 86 "lexer.l"
++mu_cfg_locus.mu_line;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 87 "lexer.l"
BEGIN (INITIAL);
	YY_BREAK
/* End-of-line comments */
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 89 "lexer.l"
{
          mu_debug_parse_spec (mu_cfg_yytext + 7); 
          mu_cfg_set_debug ();
          mu_cfg_set_lex_debug ();
      }
	YY_BREAK
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 94 "lexer.l"
{ mu_cfg_locus.mu_line++; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 95 "lexer.l"
/* end-of-file comment */;
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 96 "lexer.l"
{ mu_cfg_locus.mu_line++; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 97 "lexer.l"
/* end-of-file comment */;
	YY_BREAK
/* Identifiers */
case 11:
YY_RULE_SETUP
#line 99 "lexer.l"
{
                        _mu_line_begin ();
			_mu_line_add (mu_cfg_yytext, mu_cfg_yyleng);
			mu_cfg_yylval.string = _mu_line_finish ();
			return MU_TOK_IDENT; }
	YY_BREAK
/* Strings */
case 12:
YY_RULE_SETUP
#line 105 "lexer.l"
{ _mu_line_begin ();
                        _mu_line_add (mu_cfg_yytext, mu_cfg_yyleng);
                        mu_cfg_yylval.string = _mu_line_finish ();
                        return MU_TOK_STRING; }
	YY_BREAK
/* Quoted strings */
case 13:
YY_RULE_SETUP
#line 110 "lexer.l"
{ _mu_line_begin ();
                        _mu_line_add (mu_cfg_yytext + 1, mu_cfg_yyleng - 2);
                        mu_cfg_yylval.string = _mu_line_finish ();
                        return MU_TOK_QSTRING; }
	YY_BREAK
case 14:
#line 115 "lexer.l"
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 115 "lexer.l"
{ BEGIN (STR);
                        _mu_line_begin ();
		        _mu_line_add_unescape_last (mu_cfg_yytext + 1, mu_cfg_yyleng - 1); }
	YY_BREAK
case 16:
#line 119 "lexer.l"
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 119 "lexer.l"
{ _mu_line_add_unescape_last (mu_cfg_yytext, mu_cfg_yyleng); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 120 "lexer.l"
{ BEGIN (INITIAL);
                        if (mu_cfg_yyleng > 1) 
                          _mu_line_add (mu_cfg_yytext, mu_cfg_yyleng - 1); 
                        mu_cfg_yylval.string = _mu_line_finish ();
		        return MU_TOK_QSTRING; }
	YY_BREAK
/* Multiline strings */
case 19:
/* rule 19 can match eol */
#line 127 "lexer.l"
case 20:
/* rule 20 can match eol */
#line 128 "lexer.l"
case 21:
/* rule 21 can match eol */
#line 129 "lexer.l"
case 22:
/* rule 22 can match eol */
#line 130 "lexer.l"
case 23:
/* rule 23 can match eol */
#line 131 "lexer.l"
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 131 "lexer.l"
{
                        BEGIN (ML);
			multiline_begin (mu_cfg_yytext+2);
			mu_cfg_locus.mu_line++;
		  }
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 136 "lexer.l"
{ char *p = multiline_strip_tabs (mu_cfg_yytext);
	   
           if (!strncmp (p, multiline_delimiter, multiline_delimiter_len)
	       && isemptystr (p + multiline_delimiter_len - mu_cfg_yytext))
	     {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
	       BEGIN (INITIAL);
	       mu_cfg_yylval.string = multiline_finish ();
	       return MU_TOK_MSTRING;
	     }
           mu_cfg_locus.mu_line++;
	   multiline_add (p); } 
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 149 "lexer.l"
;
	YY_BREAK
/* Other tokens */
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 151 "lexer.l"
{ mu_cfg_locus.mu_line++; } 
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 152 "lexer.l"
return mu_cfg_yytext[0];
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 153 "lexer.l"
{ if (mu_isprint (mu_cfg_yytext[0]))
              mu_diag_at_locus (MU_LOG_ERROR, &mu_cfg_locus,
                                _("stray character %c"), mu_cfg_yytext[0]);
           else 
              mu_diag_at_locus (MU_LOG_ERROR, &mu_cfg_locus,
                                _("stray character \\%03o"),
				  (unsigned char) mu_cfg_yytext[0]);
           mu_cfg_error_count++;  
         }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 162 "lexer.l"
ECHO;
	YY_BREAK
#line 1276 "lexer.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(ML):
case YY_STATE_EOF(STR):
	mu_cfg_yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int mu_cfg_yy_amount_of_matched_text = (int) (mu_cfg_yy_cp - (mu_cfg_yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*mu_cfg_yy_cp = (mu_cfg_yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed mu_cfg_yyin at a new source and called
			 * mu_cfg_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(mu_cfg_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_input_file = mu_cfg_yyin;
			YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for mu_cfg_yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since mu_cfg_yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (mu_cfg_yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[(mu_cfg_yy_n_chars)] )
			{ /* This was really a NUL. */
			mu_cfg_yy_state_type mu_cfg_yy_next_state;

			(mu_cfg_yy_c_buf_p) = (mu_cfg_yytext_ptr) + mu_cfg_yy_amount_of_matched_text;

			mu_cfg_yy_current_state = mu_cfg_yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * mu_cfg_yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			mu_cfg_yy_next_state = mu_cfg_yy_try_NUL_trans( mu_cfg_yy_current_state );

			mu_cfg_yy_bp = (mu_cfg_yytext_ptr) + YY_MORE_ADJ;

			if ( mu_cfg_yy_next_state )
				{
				/* Consume the NUL. */
				mu_cfg_yy_cp = ++(mu_cfg_yy_c_buf_p);
				mu_cfg_yy_current_state = mu_cfg_yy_next_state;
				goto mu_cfg_yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up mu_cfg_yy_cp goes here */
				mu_cfg_yy_cp = (mu_cfg_yy_c_buf_p);
				goto mu_cfg_yy_find_action;
				}
			}

		else switch ( mu_cfg_yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(mu_cfg_yy_did_buffer_switch_on_eof) = 0;

				if ( mu_cfg_yywrap( ) )
					{
					/* Note: because we've taken care in
					 * mu_cfg_yy_get_next_buffer() to have set up
					 * mu_cfg_yytext, we can now set up
					 * mu_cfg_yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(mu_cfg_yy_c_buf_p) = (mu_cfg_yytext_ptr) + YY_MORE_ADJ;

					mu_cfg_yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (mu_cfg_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(mu_cfg_yy_c_buf_p) =
					(mu_cfg_yytext_ptr) + mu_cfg_yy_amount_of_matched_text;

				mu_cfg_yy_current_state = mu_cfg_yy_get_previous_state(  );

				mu_cfg_yy_cp = (mu_cfg_yy_c_buf_p);
				mu_cfg_yy_bp = (mu_cfg_yytext_ptr) + YY_MORE_ADJ;
				goto mu_cfg_yy_match;

			case EOB_ACT_LAST_MATCH:
				(mu_cfg_yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[(mu_cfg_yy_n_chars)];

				mu_cfg_yy_current_state = mu_cfg_yy_get_previous_state(  );

				mu_cfg_yy_cp = (mu_cfg_yy_c_buf_p);
				mu_cfg_yy_bp = (mu_cfg_yytext_ptr) + YY_MORE_ADJ;
				goto mu_cfg_yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of mu_cfg_yylex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* mu_cfg_yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int mu_cfg_yy_get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf;
	register char *source = (mu_cfg_yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (mu_cfg_yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[(mu_cfg_yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (mu_cfg_yy_c_buf_p) - (mu_cfg_yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((mu_cfg_yy_c_buf_p) - (mu_cfg_yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_n_chars = (mu_cfg_yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int mu_cfg_yy_c_buf_p_offset =
				(int) ((mu_cfg_yy_c_buf_p) - b->mu_cfg_yy_ch_buf);

			if ( b->mu_cfg_yy_is_our_buffer )
				{
				int new_size = b->mu_cfg_yy_buf_size * 2;

				if ( new_size <= 0 )
					b->mu_cfg_yy_buf_size += b->mu_cfg_yy_buf_size / 8;
				else
					b->mu_cfg_yy_buf_size *= 2;

				b->mu_cfg_yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					mu_cfg_yyrealloc((void *) b->mu_cfg_yy_ch_buf,b->mu_cfg_yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->mu_cfg_yy_ch_buf = 0;

			if ( ! b->mu_cfg_yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(mu_cfg_yy_c_buf_p) = &b->mu_cfg_yy_ch_buf[mu_cfg_yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[number_to_move]),
			(mu_cfg_yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_n_chars = (mu_cfg_yy_n_chars);
		}

	if ( (mu_cfg_yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			mu_cfg_yyrestart(mu_cfg_yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((mu_cfg_yy_size_t) ((mu_cfg_yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		mu_cfg_yy_size_t new_size = (mu_cfg_yy_n_chars) + number_to_move + ((mu_cfg_yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf = (char *) mu_cfg_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in mu_cfg_yy_get_next_buffer()" );
	}

	(mu_cfg_yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[(mu_cfg_yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[(mu_cfg_yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(mu_cfg_yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[0];

	return ret_val;
}

/* mu_cfg_yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static mu_cfg_yy_state_type mu_cfg_yy_get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register mu_cfg_yy_state_type mu_cfg_yy_current_state;
	register char *mu_cfg_yy_cp;
    
/* %% [15.0] code to get the start state into mu_cfg_yy_current_state goes here */
	mu_cfg_yy_current_state = (mu_cfg_yy_start);

	for ( mu_cfg_yy_cp = (mu_cfg_yytext_ptr) + YY_MORE_ADJ; mu_cfg_yy_cp < (mu_cfg_yy_c_buf_p); ++mu_cfg_yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		register YY_CHAR mu_cfg_yy_c = (*mu_cfg_yy_cp ? mu_cfg_yy_ec[YY_SC_TO_UI(*mu_cfg_yy_cp)] : 1);
		if ( mu_cfg_yy_accept[mu_cfg_yy_current_state] )
			{
			(mu_cfg_yy_last_accepting_state) = mu_cfg_yy_current_state;
			(mu_cfg_yy_last_accepting_cpos) = mu_cfg_yy_cp;
			}
		while ( mu_cfg_yy_chk[mu_cfg_yy_base[mu_cfg_yy_current_state] + mu_cfg_yy_c] != mu_cfg_yy_current_state )
			{
			mu_cfg_yy_current_state = (int) mu_cfg_yy_def[mu_cfg_yy_current_state];
			if ( mu_cfg_yy_current_state >= 94 )
				mu_cfg_yy_c = mu_cfg_yy_meta[(unsigned int) mu_cfg_yy_c];
			}
		mu_cfg_yy_current_state = mu_cfg_yy_nxt[mu_cfg_yy_base[mu_cfg_yy_current_state] + (unsigned int) mu_cfg_yy_c];
		}

	return mu_cfg_yy_current_state;
}

/* mu_cfg_yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = mu_cfg_yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static mu_cfg_yy_state_type mu_cfg_yy_try_NUL_trans  (mu_cfg_yy_state_type mu_cfg_yy_current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register int mu_cfg_yy_is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	register char *mu_cfg_yy_cp = (mu_cfg_yy_c_buf_p);

	register YY_CHAR mu_cfg_yy_c = 1;
	if ( mu_cfg_yy_accept[mu_cfg_yy_current_state] )
		{
		(mu_cfg_yy_last_accepting_state) = mu_cfg_yy_current_state;
		(mu_cfg_yy_last_accepting_cpos) = mu_cfg_yy_cp;
		}
	while ( mu_cfg_yy_chk[mu_cfg_yy_base[mu_cfg_yy_current_state] + mu_cfg_yy_c] != mu_cfg_yy_current_state )
		{
		mu_cfg_yy_current_state = (int) mu_cfg_yy_def[mu_cfg_yy_current_state];
		if ( mu_cfg_yy_current_state >= 94 )
			mu_cfg_yy_c = mu_cfg_yy_meta[(unsigned int) mu_cfg_yy_c];
		}
	mu_cfg_yy_current_state = mu_cfg_yy_nxt[mu_cfg_yy_base[mu_cfg_yy_current_state] + (unsigned int) mu_cfg_yy_c];
	mu_cfg_yy_is_jam = (mu_cfg_yy_current_state == 93);

	return mu_cfg_yy_is_jam ? 0 : mu_cfg_yy_current_state;
}

/* %if-c-only */

/* %endif */

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int mu_cfg_yyinput (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(mu_cfg_yy_c_buf_p) = (mu_cfg_yy_hold_char);

	if ( *(mu_cfg_yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* mu_cfg_yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (mu_cfg_yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_ch_buf[(mu_cfg_yy_n_chars)] )
			/* This was really a NUL. */
			*(mu_cfg_yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (mu_cfg_yy_c_buf_p) - (mu_cfg_yytext_ptr);
			++(mu_cfg_yy_c_buf_p);

			switch ( mu_cfg_yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because mu_cfg_yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					mu_cfg_yyrestart(mu_cfg_yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( mu_cfg_yywrap( ) )
						return EOF;

					if ( ! (mu_cfg_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return mu_cfg_yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(mu_cfg_yy_c_buf_p) = (mu_cfg_yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (mu_cfg_yy_c_buf_p);	/* cast for 8-bit char's */
	*(mu_cfg_yy_c_buf_p) = '\0';	/* preserve mu_cfg_yytext */
	(mu_cfg_yy_hold_char) = *++(mu_cfg_yy_c_buf_p);

/* %% [19.0] update BOL and mu_cfg_yylineno */

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void mu_cfg_yyrestart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        mu_cfg_yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            mu_cfg_yy_create_buffer(mu_cfg_yyin,YY_BUF_SIZE );
	}

	mu_cfg_yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	mu_cfg_yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void mu_cfg_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		mu_cfg_yypop_buffer_state();
	 *		mu_cfg_yypush_buffer_state(new_buffer);
     */
	mu_cfg_yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mu_cfg_yy_c_buf_p) = (mu_cfg_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buf_pos = (mu_cfg_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_n_chars = (mu_cfg_yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	mu_cfg_yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (mu_cfg_yywrap()) processing, but the only time this flag
	 * is looked at is after mu_cfg_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(mu_cfg_yy_did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void mu_cfg_yy_load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(mu_cfg_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_n_chars;
	(mu_cfg_yytext_ptr) = (mu_cfg_yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buf_pos;
	mu_cfg_yyin = YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_input_file;
	(mu_cfg_yy_hold_char) = *(mu_cfg_yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE mu_cfg_yy_create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) mu_cfg_yyalloc(sizeof( struct mu_cfg_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in mu_cfg_yy_create_buffer()" );

	b->mu_cfg_yy_buf_size = size;

	/* mu_cfg_yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->mu_cfg_yy_ch_buf = (char *) mu_cfg_yyalloc(b->mu_cfg_yy_buf_size + 2  );
	if ( ! b->mu_cfg_yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in mu_cfg_yy_create_buffer()" );

	b->mu_cfg_yy_is_our_buffer = 1;

	mu_cfg_yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with mu_cfg_yy_create_buffer()
 * 
 */
/* %if-c-only */
    void mu_cfg_yy_delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->mu_cfg_yy_is_our_buffer )
		mu_cfg_yyfree((void *) b->mu_cfg_yy_ch_buf  );

	mu_cfg_yyfree((void *) b  );
}

/* %if-c-only */

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* %endif */

/* %if-c++-only */
/* %endif */

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a mu_cfg_yyrestart() or at EOF.
 */
/* %if-c-only */
    static void mu_cfg_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	mu_cfg_yy_flush_buffer(b );

	b->mu_cfg_yy_input_file = file;
	b->mu_cfg_yy_fill_buffer = 1;

    /* If b is the current buffer, then mu_cfg_yy_init_buffer was _probably_
     * called from mu_cfg_yyrestart() or through mu_cfg_yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->mu_cfg_yy_bs_lineno = 1;
        b->mu_cfg_yy_bs_column = 0;
    }

/* %if-c-only */

        b->mu_cfg_yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void mu_cfg_yy_flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->mu_cfg_yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->mu_cfg_yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->mu_cfg_yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->mu_cfg_yy_buf_pos = &b->mu_cfg_yy_ch_buf[0];

	b->mu_cfg_yy_at_bol = 1;
	b->mu_cfg_yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		mu_cfg_yy_load_buffer_state( );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void mu_cfg_yypush_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	mu_cfg_yyensure_buffer_stack();

	/* This block is copied from mu_cfg_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mu_cfg_yy_c_buf_p) = (mu_cfg_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_buf_pos = (mu_cfg_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->mu_cfg_yy_n_chars = (mu_cfg_yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(mu_cfg_yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from mu_cfg_yy_switch_to_buffer. */
	mu_cfg_yy_load_buffer_state( );
	(mu_cfg_yy_did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void mu_cfg_yypop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	mu_cfg_yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((mu_cfg_yy_buffer_stack_top) > 0)
		--(mu_cfg_yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		mu_cfg_yy_load_buffer_state( );
		(mu_cfg_yy_did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void mu_cfg_yyensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int num_to_alloc;
    
	if (!(mu_cfg_yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(mu_cfg_yy_buffer_stack) = (struct mu_cfg_yy_buffer_state**)mu_cfg_yyalloc
								(num_to_alloc * sizeof(struct mu_cfg_yy_buffer_state*)
								);
		if ( ! (mu_cfg_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in mu_cfg_yyensure_buffer_stack()" );
								  
		memset((mu_cfg_yy_buffer_stack), 0, num_to_alloc * sizeof(struct mu_cfg_yy_buffer_state*));
				
		(mu_cfg_yy_buffer_stack_max) = num_to_alloc;
		(mu_cfg_yy_buffer_stack_top) = 0;
		return;
	}

	if ((mu_cfg_yy_buffer_stack_top) >= ((mu_cfg_yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (mu_cfg_yy_buffer_stack_max) + grow_size;
		(mu_cfg_yy_buffer_stack) = (struct mu_cfg_yy_buffer_state**)mu_cfg_yyrealloc
								((mu_cfg_yy_buffer_stack),
								num_to_alloc * sizeof(struct mu_cfg_yy_buffer_state*)
								);
		if ( ! (mu_cfg_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in mu_cfg_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((mu_cfg_yy_buffer_stack) + (mu_cfg_yy_buffer_stack_max), 0, grow_size * sizeof(struct mu_cfg_yy_buffer_state*));
		(mu_cfg_yy_buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE mu_cfg_yy_scan_buffer  (char * base, mu_cfg_yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) mu_cfg_yyalloc(sizeof( struct mu_cfg_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in mu_cfg_yy_scan_buffer()" );

	b->mu_cfg_yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->mu_cfg_yy_buf_pos = b->mu_cfg_yy_ch_buf = base;
	b->mu_cfg_yy_is_our_buffer = 0;
	b->mu_cfg_yy_input_file = 0;
	b->mu_cfg_yy_n_chars = b->mu_cfg_yy_buf_size;
	b->mu_cfg_yy_is_interactive = 0;
	b->mu_cfg_yy_at_bol = 1;
	b->mu_cfg_yy_fill_buffer = 0;
	b->mu_cfg_yy_buffer_status = YY_BUFFER_NEW;

	mu_cfg_yy_switch_to_buffer(b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to mu_cfg_yylex() will
 * scan from a @e copy of @a str.
 * @param mu_cfg_yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       mu_cfg_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE mu_cfg_yy_scan_string (mu_cfg_yyconst char * mu_cfg_yystr )
{
    
	return mu_cfg_yy_scan_bytes(mu_cfg_yystr,strlen(mu_cfg_yystr) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to mu_cfg_yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE mu_cfg_yy_scan_bytes  (mu_cfg_yyconst char * mu_cfg_yybytes, int  _mu_cfg_yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	mu_cfg_yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _mu_cfg_yybytes_len + 2;
	buf = (char *) mu_cfg_yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in mu_cfg_yy_scan_bytes()" );

	for ( i = 0; i < _mu_cfg_yybytes_len; ++i )
		buf[i] = mu_cfg_yybytes[i];

	buf[_mu_cfg_yybytes_len] = buf[_mu_cfg_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = mu_cfg_yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in mu_cfg_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->mu_cfg_yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void mu_cfg_yy_fatal_error (mu_cfg_yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine mu_cfg_yyless() so it works in section 3 code. */

#undef mu_cfg_yyless
#define mu_cfg_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up mu_cfg_yytext. */ \
        int mu_cfg_yyless_macro_arg = (n); \
        YY_LESS_LINENO(mu_cfg_yyless_macro_arg);\
		mu_cfg_yytext[mu_cfg_yyleng] = (mu_cfg_yy_hold_char); \
		(mu_cfg_yy_c_buf_p) = mu_cfg_yytext + mu_cfg_yyless_macro_arg; \
		(mu_cfg_yy_hold_char) = *(mu_cfg_yy_c_buf_p); \
		*(mu_cfg_yy_c_buf_p) = '\0'; \
		mu_cfg_yyleng = mu_cfg_yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int mu_cfg_yyget_lineno  (void)
{
        
    return mu_cfg_yylineno;
}

/** Get the input stream.
 * 
 */
FILE *mu_cfg_yyget_in  (void)
{
        return mu_cfg_yyin;
}

/** Get the output stream.
 * 
 */
FILE *mu_cfg_yyget_out  (void)
{
        return mu_cfg_yyout;
}

/** Get the length of the current token.
 * 
 */
int mu_cfg_yyget_leng  (void)
{
        return mu_cfg_yyleng;
}

/** Get the current token.
 * 
 */

char *mu_cfg_yyget_text  (void)
{
        return mu_cfg_yytext;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param line_number
 * 
 */
void mu_cfg_yyset_lineno (int  line_number )
{
    
    mu_cfg_yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see mu_cfg_yy_switch_to_buffer
 */
void mu_cfg_yyset_in (FILE *  in_str )
{
        mu_cfg_yyin = in_str ;
}

void mu_cfg_yyset_out (FILE *  out_str )
{
        mu_cfg_yyout = out_str ;
}

int mu_cfg_yyget_debug  (void)
{
        return mu_cfg_yy_flex_debug;
}

void mu_cfg_yyset_debug (int  bdebug )
{
        mu_cfg_yy_flex_debug = bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int mu_cfg_yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from mu_cfg_yylex_destroy(), so don't allocate here.
     */

    (mu_cfg_yy_buffer_stack) = 0;
    (mu_cfg_yy_buffer_stack_top) = 0;
    (mu_cfg_yy_buffer_stack_max) = 0;
    (mu_cfg_yy_c_buf_p) = (char *) 0;
    (mu_cfg_yy_init) = 0;
    (mu_cfg_yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    mu_cfg_yyin = stdin;
    mu_cfg_yyout = stdout;
#else
    mu_cfg_yyin = (FILE *) 0;
    mu_cfg_yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * mu_cfg_yylex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* mu_cfg_yylex_destroy is for both reentrant and non-reentrant scanners. */
int mu_cfg_yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		mu_cfg_yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		mu_cfg_yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	mu_cfg_yyfree((mu_cfg_yy_buffer_stack) );
	(mu_cfg_yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * mu_cfg_yylex() is called, initialization will occur. */
    mu_cfg_yy_init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef mu_cfg_yytext_ptr
static void mu_cfg_yy_flex_strncpy (char* s1, mu_cfg_yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int mu_cfg_yy_flex_strlen (mu_cfg_yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *mu_cfg_yyalloc (mu_cfg_yy_size_t  size )
{
	return (void *) malloc( size );
}

void *mu_cfg_yyrealloc  (void * ptr, mu_cfg_yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void mu_cfg_yyfree (void * ptr )
{
	free( (char *) ptr );	/* see mu_cfg_yyrealloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-mu_cfg_yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "mu_cfg_yytables"
/* %endif */

/* %ok-for-header */

#line 162 "lexer.l"



int
mu_cfg_yywrap ()
{
  return 1;
}

static void
unescape_to_line (int c)
{
  if (c != '\n')
    {
      char t = mu_wordsplit_c_unquote_char (c);
      if (t == c && t != '\\' && t != '\"')
        {
          mu_diag_at_locus (MU_LOG_ERROR, &mu_cfg_locus, 
	                    _("unknown escape sequence '\\%c'"), c);
          mu_cfg_error_count++;
	}
      mu_opool_append_char (pool, t);
    }
}

void
_mu_line_add (char *text, size_t len)
{
  mu_opool_append (pool, text, len);
}

void
_mu_line_add_unescape_last (char *text, size_t len)
{
  mu_opool_append (pool, text, len - 2);
  unescape_to_line (text[len - 1]);
}

void
_mu_line_begin ()
{
  if (!pool)
    mu_opool_create (&pool, MU_OPOOL_ENOMEMABRT);
  else
    mu_opool_clear (pool);
}

char *
_mu_line_finish ()
{
  mu_opool_append_char (pool, 0);
  return mu_opool_finish (pool, NULL);
}



static int
is_tab (char c)
{
    return c == '\t';
}
 
static int
is_ws (char c)
{
    return c == '\t' || c == ' ';
}

static int
isemptystr (int off)
{
  for (; mu_cfg_yytext[off] && mu_isspace (mu_cfg_yytext[off]); off++)
    ;
  if (mu_cfg_yytext[off] == ';')
    {
      int i;
      for (i = off + 1; mu_cfg_yytext[i]; i++) 
	if (!mu_isspace (mu_cfg_yytext[i]))
	  return 0;
      mu_cfg_yyless (off);
      return 1;
    }
  return mu_cfg_yytext[off] == 0;
}

static void
multiline_begin (char *p)
{
  if (*p == '-')
    {
      if (*++p == ' ')
	{
	  char_to_strip = is_ws;
	  p++;
	}
      else
	char_to_strip = is_tab;
    }
  else
    char_to_strip = NULL;
  if (*p == '\\')
    {
      p++;
      multiline_unescape = 0;
    }
  else if (*p == '"')
    {
      char *q;
      
      p++;
      multiline_unescape = 0;
      q = strchr (p, '"');
      multiline_delimiter_len = q - p;
    }
  else
    {
	multiline_delimiter_len = strcspn (p, " \t");
	multiline_unescape = 1;
    }

  /* Remove trailing newline */
  multiline_delimiter_len--;
  multiline_delimiter = mu_alloc (multiline_delimiter_len + 1);
  memcpy (multiline_delimiter, p, multiline_delimiter_len);
  multiline_delimiter[multiline_delimiter_len] = 0;
  _mu_line_begin ();
}

static char *
multiline_strip_tabs (char *text)
{
  if (char_to_strip)
    for (; *text && char_to_strip (*text); text++)
      ;
  return text;
}

static void
multiline_add (char *s)
{
  if (multiline_unescape)
    {
      for (; *s; s++)
	{
	  if (*s == '\\')
	    {
	      unescape_to_line (s[1]);
	      ++s;
	    }
	  else
	    _mu_line_add (s, 1);
	}
    }
  else
    _mu_line_add (s, strlen (s));
}

static char *
multiline_finish ()
{
  return _mu_line_finish ();
}


int
mu_cfg_parse_file (mu_cfg_tree_t **return_tree, const char *file, int flags)
{
  struct stat st;
  FILE *fp;
  int rc;
  char *full_name = mu_tilde_expansion (file, MU_HIERARCHY_DELIMITER, NULL);

  if (flags & MU_CF_VERBOSE)
    mu_diag_output (MU_DIAG_INFO, _("opening configuration file %s"),
		    full_name);
  if (stat (full_name, &st))
    {
      if (errno != ENOENT)
	mu_error (_("cannot stat `%s': %s"), full_name, mu_strerror (errno));
      else if (flags & MU_CF_VERBOSE)
	mu_diag_output (MU_DIAG_INFO, _("configuration file %s doesn't exist"),
			full_name);
      free (full_name);
      return ENOENT;
    }
  else if (!S_ISREG (st.st_mode))
    {
      if (flags & MU_CF_VERBOSE)
	mu_diag_output (MU_DIAG_INFO, _("%s: not a regular file"), full_name);
      free (full_name);
      return ENOENT;
    } 
      
  fp = fopen (full_name, "r");
  if (!fp)
    {
      mu_error (_("cannot open config file `%s': %s"), full_name,
		mu_strerror (errno));
      free (full_name);
      return errno;
    }

  if (flags & MU_CF_VERBOSE)
    mu_diag_output (MU_DIAG_INFO, _("parsing file `%s'"), full_name);

  mu_cfg_set_lex_debug ();

  /* Initialize locus: */
  /* 1. Save file name in the lexer object pool and point `file' member
     to this copy. Free full_name: it is not used after that. */
  _mu_line_begin ();
  _mu_line_add (full_name, strlen (full_name));
  mu_cfg_locus.mu_file = _mu_line_finish ();
  free (full_name); 
  /* 2. Initialize line number */
  mu_cfg_locus.mu_line = 1;
  
  /* Parse configuration */
  mu_cfg_yyrestart (fp);
  rc = mu_cfg_parse (return_tree);
  fclose (fp);
  if (flags & MU_CF_VERBOSE)
    mu_diag_output (MU_DIAG_INFO, _("finished parsing file `%s'"),
		    mu_cfg_locus.mu_file);

  return rc == 0 ? 0 : MU_ERR_FAILURE;
}

mu_opool_t 
mu_cfg_lexer_pool ()
{
  mu_opool_t p = pool;
  pool = NULL;
  return p;
}

