/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999, 2001, 2002, 2003, 2005, 2007, 2010, 2011 Free
   Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils.  If not, see <http://www.gnu.org/licenses/>. */

#include "mail.h"

/*
 * prev[ious] [message]
 * -
 */

int
mail_previous (int argc, char **argv)
{
  size_t n;
  mu_message_t msg;

  if (argc < 2)
    {
      int rc = 1;

      n = get_cursor ();
      if (n)
        while (--n > 0)
	  {
	    if (util_isdeleted (n))
	      continue;
	    rc = util_get_message (mbox, n, &msg);
	    if (rc == 0)
	      break;
	  }

      if (rc)
	{
	  mu_error (_("No applicable message"));
	  return 1;
	}
    }
  else
    {
      msgset_t *list = NULL;
      int rc = msgset_parse (argc, argv, MSG_NODELETED|MSG_SILENT, &list);
      if (!rc)
	{
	  n = list->msg_part[0];
	  msgset_free (list);
	  if (util_get_message (mbox, n, &msg))
	    return 1;
	}
      else
	{
	  mu_error (_("No applicable message"));
	  return 1;
	}
    }
  set_cursor (n);
  util_do_command ("print");
  return 0;
}
