;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015, 2016 Ludovic Courtès <ludo@gnu.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url

            %storedir
            %localstatedir
            %sysconfdir
            %sbindir

            %store-directory
            %state-directory
            %config-directory
            %guix-register-program

            %system
            %libgcrypt
            %libz
            %nix-instantiate
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.  When adding a substitution variable
;;; here, make sure to equip (guix scripts pull) to substitute it.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "0.14.0")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "https://www.gnu.org/software/guix/")

(define %storedir
  "/gnu/store")

(define %localstatedir
  "/var")

(define %sysconfdir
  "/etc")

(define %sbindir
  "/gnu/store/pii5cimi72lj5l7793h54g5sg0sr2apl-guix-0.14.0/sbin")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      %storedir))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `nix/local.mk'.
  (or (getenv "NIX_STATE_DIR")
      (string-append %localstatedir "/guix")))

(define %config-directory
  ;; This must match `GUIX_CONFIGURATION_DIRECTORY' as defined in `nix/local.mk'.
  (or (getenv "GUIX_CONFIGURATION_DIRECTORY")
      (string-append %sysconfdir "/guix")))

(define %guix-register-program
  ;; The 'guix-register' program.
  (or (getenv "GUIX_REGISTER")
      (string-append %sbindir "/guix-register")))

(define %system
  "x86_64-linux")

(define %libgcrypt
  "/gnu/store/qfzl5frp52wdz1vbdj958sz35yfl94xi-libgcrypt-1.8.1/lib/libgcrypt")

(define %libz
  "/gnu/store/navpkpm1jf6zf8zmi54wl5w3b2ddv1sw-zlib-1.2.11/lib/libz")

(define %nix-instantiate
  "nix-instantiate")

(define %gzip
  "/gnu/store/5rk1b2riamhzk8s1hs83mb1i8vdif0vd-gzip-1.8/bin/gzip")

(define %bzip2
  "/gnu/store/wd01nlc7apixl4kyvhpzasxprqymw32s-bzip2-1.0.6/bin/bzip2")

(define %xz
  "/gnu/store/b1dg82khbvr2abaa346vv7r93ryqrb3j-xz-5.2.2/bin/xz")

;;; config.scm ends here
