/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.database;

import gnu.prolog.database.Predicate;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public abstract class Predicate_assert
extends ExecuteOnlyCode {
    protected abstract void assertPred(Predicate var1, CompoundTerm var2);

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term clause = args[0];
        Term head = null;
        Term body = null;
        if (clause instanceof VariableTerm) {
            PrologException.instantiationError();
        } else if (clause instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)clause;
            if (ct.tag == TermConstants.clauseTag) {
                head = ct.args[0].dereference();
                body = ct.args[1].dereference();
                body = Predicate_assert.prepareBody(body, body);
            } else {
                head = ct;
                body = TermConstants.trueAtom;
            }
        } else if (clause instanceof AtomTerm) {
            head = clause;
            body = TermConstants.trueAtom;
        } else {
            PrologException.typeError(TermConstants.callableAtom, clause);
        }
        CompoundTermTag predTag = null;
        if (head instanceof VariableTerm) {
            PrologException.instantiationError();
        } else if (head instanceof CompoundTerm) {
            predTag = ((CompoundTerm)head).tag;
        } else if (head instanceof AtomTerm) {
            predTag = CompoundTermTag.get((AtomTerm)head, 0);
        } else {
            PrologException.typeError(TermConstants.callableAtom, head);
        }
        Predicate p = interpreter.getEnvironment().getModule().getDefinedPredicate(predTag);
        if (p == null) {
            p = interpreter.getEnvironment().getModule().createDefinedPredicate(predTag);
            p.setType(2);
            p.setDynamic();
        } else if (p.getType() == 2) {
            if (!p.isDynamic()) {
                PrologException.permissionError(TermConstants.modifyAtom, TermConstants.staticProcedureAtom, predTag.getPredicateIndicator());
            }
        } else {
            PrologException.permissionError(TermConstants.modifyAtom, TermConstants.staticProcedureAtom, predTag.getPredicateIndicator());
        }
        this.assertPred(p, (CompoundTerm)new CompoundTerm(TermConstants.clauseTag, head, body).clone());
        return 1;
    }

    public static Term prepareBody(Term body, Term term) throws PrologException {
        if (body instanceof VariableTerm) {
            return new CompoundTerm(TermConstants.callTag, body);
        }
        if (body instanceof AtomTerm) {
            return body;
        }
        if (body instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)body;
            if (ct.tag == TermConstants.conjunctionTag || ct.tag == TermConstants.disjunctionTag || ct.tag == TermConstants.ifTag) {
                return new CompoundTerm(ct.tag, Predicate_assert.prepareBody(ct.args[0].dereference(), term), Predicate_assert.prepareBody(ct.args[1].dereference(), term));
            }
            return body;
        }
        PrologException.typeError(TermConstants.callableAtom, term);
        return null;
    }
}

