/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.database.Pair;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.Random;

public class Evaluate {
    public static final CompoundTermTag add2 = CompoundTermTag.get("+", 2);
    public static final CompoundTermTag sub2 = CompoundTermTag.get("-", 2);
    public static final CompoundTermTag mul2 = CompoundTermTag.get("*", 2);
    public static final CompoundTermTag intdiv2 = CompoundTermTag.get("//", 2);
    public static final CompoundTermTag div2 = CompoundTermTag.get("/", 2);
    public static final CompoundTermTag rem2 = CompoundTermTag.get("rem", 2);
    public static final CompoundTermTag mod2 = CompoundTermTag.get("mod", 2);
    public static final CompoundTermTag neg1 = CompoundTermTag.get("-", 1);
    public static final CompoundTermTag abs1 = CompoundTermTag.get("abs", 1);
    public static final CompoundTermTag sqrt1 = CompoundTermTag.get("sqrt", 1);
    public static final CompoundTermTag sign1 = CompoundTermTag.get("sign", 1);
    public static final CompoundTermTag intpart1 = CompoundTermTag.get("float_integer_part", 1);
    public static final CompoundTermTag fractpart1 = CompoundTermTag.get("float_fractional_part", 1);
    public static final CompoundTermTag float1 = CompoundTermTag.get("float", 1);
    public static final CompoundTermTag floor1 = CompoundTermTag.get("floor", 1);
    public static final CompoundTermTag truncate1 = CompoundTermTag.get("truncate", 1);
    public static final CompoundTermTag round1 = CompoundTermTag.get("round", 1);
    public static final CompoundTermTag ceiling1 = CompoundTermTag.get("ceiling", 1);
    public static final CompoundTermTag power2 = CompoundTermTag.get("**", 2);
    public static final CompoundTermTag sin1 = CompoundTermTag.get("sin", 1);
    public static final CompoundTermTag cos1 = CompoundTermTag.get("cos", 1);
    public static final CompoundTermTag atan1 = CompoundTermTag.get("atan", 1);
    public static final CompoundTermTag exp1 = CompoundTermTag.get("exp", 1);
    public static final CompoundTermTag log1 = CompoundTermTag.get("log", 1);
    public static final CompoundTermTag brshift2 = CompoundTermTag.get(">>", 2);
    public static final CompoundTermTag blshift2 = CompoundTermTag.get("<<", 2);
    public static final CompoundTermTag band2 = CompoundTermTag.get("/\\", 2);
    public static final CompoundTermTag bor2 = CompoundTermTag.get("\\/", 2);
    public static final CompoundTermTag bnot1 = CompoundTermTag.get("\\", 1);
    public static final CompoundTermTag random1 = CompoundTermTag.get("random", 1);
    private static final Random random = new Random();
    public static final CompoundTermTag evaluationError = CompoundTermTag.get("evaluation_error", 1);
    public static final AtomTerm floatAtom = AtomTerm.get("float");

    private Evaluate() {
    }

    private static void zeroDivizor() throws PrologException {
        throw PrologException.getError(new CompoundTerm(evaluationError, TermConstants.zeroDivizorAtom));
    }

    private static void intOverflow() throws PrologException {
        throw PrologException.getError(new CompoundTerm(evaluationError, TermConstants.intOverflowAtom));
    }

    private static void floatOverflow() throws PrologException {
        throw PrologException.getError(new CompoundTerm(evaluationError, TermConstants.floatOverflowAtom));
    }

    private static void undefined() throws PrologException {
        throw PrologException.getError(new CompoundTerm(evaluationError, TermConstants.undefinedAtom));
    }

    private static Pair<Double, Double> toDouble(Term arg0, Term arg1) {
        double d0 = 0.0;
        double d1 = 0.0;
        if (arg0 instanceof IntegerTerm && arg1 instanceof IntegerTerm) {
            IntegerTerm i0 = (IntegerTerm)arg0;
            IntegerTerm i1 = (IntegerTerm)arg1;
            d0 = i0.value;
            d1 = i1.value;
        } else if (arg0 instanceof FloatTerm && arg1 instanceof IntegerTerm) {
            FloatTerm f0 = (FloatTerm)arg0;
            IntegerTerm i1 = (IntegerTerm)arg1;
            d0 = f0.value;
            d1 = i1.value;
        } else if (arg0 instanceof IntegerTerm && arg1 instanceof FloatTerm) {
            IntegerTerm i0 = (IntegerTerm)arg0;
            FloatTerm f1 = (FloatTerm)arg1;
            d0 = i0.value;
            d1 = f1.value;
        } else if (arg0 instanceof FloatTerm && arg1 instanceof FloatTerm) {
            FloatTerm f0 = (FloatTerm)arg0;
            FloatTerm f1 = (FloatTerm)arg1;
            d0 = f0.value;
            d1 = f1.value;
        }
        return new Pair<Double, Double>(d0, d1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Term evaluate(Term term) throws PrologException {
        if (term instanceof FloatTerm) {
            return term;
        }
        if (term instanceof IntegerTerm) {
            return term;
        }
        if (term instanceof VariableTerm) {
            PrologException.instantiationError();
        } else if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            CompoundTermTag tag = ct.tag;
            int arity = tag.arity;
            Term[] sargs = ct.args;
            Term[] args = new Term[arity];
            for (int i = 0; i < arity; ++i) {
                args[i] = Evaluate.evaluate(sargs[i].dereference());
            }
            if (tag == add2) {
                Term arg0 = args[0];
                Term arg1 = args[1];
                if (arg0 instanceof IntegerTerm && arg1 instanceof IntegerTerm) {
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    long res = (long)i0.value + (long)i1.value;
                    if (res > Integer.MAX_VALUE || res < Integer.MIN_VALUE) {
                        Evaluate.intOverflow();
                    }
                    return IntegerTerm.get((int)res);
                }
                if (arg0 instanceof FloatTerm && arg1 instanceof IntegerTerm) {
                    FloatTerm f0 = (FloatTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    double res = f0.value + (double)i1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
                if (arg0 instanceof IntegerTerm && arg1 instanceof FloatTerm) {
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    FloatTerm f1 = (FloatTerm)arg1;
                    double res = (double)i0.value + f1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
                if (arg0 instanceof FloatTerm && arg1 instanceof FloatTerm) {
                    FloatTerm f0 = (FloatTerm)arg0;
                    FloatTerm f1 = (FloatTerm)arg1;
                    double res = f0.value + f1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
            } else if (tag == sub2) {
                Term arg0 = args[0];
                Term arg1 = args[1];
                if (arg0 instanceof IntegerTerm && arg1 instanceof IntegerTerm) {
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    long res = (long)i0.value - (long)i1.value;
                    if (res > Integer.MAX_VALUE || res < Integer.MIN_VALUE) {
                        Evaluate.intOverflow();
                    }
                    return IntegerTerm.get((int)res);
                }
                if (arg0 instanceof FloatTerm && arg1 instanceof IntegerTerm) {
                    FloatTerm f0 = (FloatTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    double res = f0.value - (double)i1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
                if (arg0 instanceof IntegerTerm && arg1 instanceof FloatTerm) {
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    FloatTerm f1 = (FloatTerm)arg1;
                    double res = (double)i0.value - f1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
                if (arg0 instanceof FloatTerm && arg1 instanceof FloatTerm) {
                    FloatTerm f0 = (FloatTerm)arg0;
                    FloatTerm f1 = (FloatTerm)arg1;
                    double res = f0.value - f1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
            } else if (tag == mul2) {
                Term arg0 = args[0];
                Term arg1 = args[1];
                if (arg0 instanceof IntegerTerm && arg1 instanceof IntegerTerm) {
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    long res = (long)i0.value * (long)i1.value;
                    if (res > Integer.MAX_VALUE || res < Integer.MIN_VALUE) {
                        Evaluate.intOverflow();
                    }
                    return IntegerTerm.get((int)res);
                }
                if (arg0 instanceof FloatTerm && arg1 instanceof IntegerTerm) {
                    FloatTerm f0 = (FloatTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    double res = f0.value * (double)i1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
                if (arg0 instanceof IntegerTerm && arg1 instanceof FloatTerm) {
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    FloatTerm f1 = (FloatTerm)arg1;
                    double res = (double)i0.value * f1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
                if (arg0 instanceof FloatTerm && arg1 instanceof FloatTerm) {
                    FloatTerm f0 = (FloatTerm)arg0;
                    FloatTerm f1 = (FloatTerm)arg1;
                    double res = f0.value * f1.value;
                    if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
            } else {
                if (tag == intdiv2) {
                    Term arg0 = args[0];
                    Term arg1 = args[1];
                    if (!(arg0 instanceof IntegerTerm)) {
                        PrologException.typeError(TermConstants.integerAtom, arg0);
                    }
                    if (!(arg1 instanceof IntegerTerm)) {
                        PrologException.typeError(TermConstants.integerAtom, arg1);
                    }
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    if (i1.value == 0) {
                        Evaluate.zeroDivizor();
                    }
                    int res = i0.value / i1.value;
                    return IntegerTerm.get(res);
                }
                if (tag == div2) {
                    double res;
                    Pair<Double, Double> doubles = Evaluate.toDouble(args[0], args[1]);
                    double d0 = (Double)doubles.left;
                    double d1 = (Double)doubles.right;
                    if (d1 == 0.0) {
                        Evaluate.zeroDivizor();
                    }
                    if (Double.isInfinite(res = d0 / d1)) {
                        Evaluate.floatOverflow();
                    }
                    return new FloatTerm(res);
                }
                if (tag == rem2) {
                    Term arg0 = args[0];
                    Term arg1 = args[1];
                    if (!(arg0 instanceof IntegerTerm)) {
                        PrologException.typeError(TermConstants.integerAtom, arg0);
                    }
                    if (!(arg1 instanceof IntegerTerm)) {
                        PrologException.typeError(TermConstants.integerAtom, arg1);
                    }
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    if (i1.value == 0) {
                        Evaluate.zeroDivizor();
                    }
                    int res = i0.value % i1.value;
                    return IntegerTerm.get(res);
                }
                if (tag == mod2) {
                    Term arg0 = args[0];
                    Term arg1 = args[1];
                    if (!(arg0 instanceof IntegerTerm)) {
                        PrologException.typeError(TermConstants.integerAtom, arg0);
                    }
                    if (!(arg1 instanceof IntegerTerm)) {
                        PrologException.typeError(TermConstants.integerAtom, arg1);
                    }
                    IntegerTerm i0 = (IntegerTerm)arg0;
                    IntegerTerm i1 = (IntegerTerm)arg1;
                    if (i1.value == 0) {
                        Evaluate.zeroDivizor();
                    }
                    int res = i0.value - (int)Math.floor((double)i0.value / (double)i1.value) * i1.value;
                    return IntegerTerm.get(res);
                }
                if (tag == neg1) {
                    Term arg0 = args[0];
                    if (arg0 instanceof IntegerTerm) {
                        IntegerTerm i0 = (IntegerTerm)arg0;
                        if (i0.value == Integer.MIN_VALUE) {
                            Evaluate.intOverflow();
                        }
                        return IntegerTerm.get(-i0.value);
                    }
                    if (arg0 instanceof FloatTerm) {
                        FloatTerm f0 = (FloatTerm)arg0;
                        double res = -f0.value;
                        if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                            Evaluate.floatOverflow();
                        }
                        return new FloatTerm(res);
                    }
                } else if (tag == abs1) {
                    Term arg0 = args[0];
                    if (arg0 instanceof IntegerTerm) {
                        IntegerTerm i0 = (IntegerTerm)arg0;
                        if (i0.value == Integer.MIN_VALUE) {
                            Evaluate.intOverflow();
                        }
                        return IntegerTerm.get(Math.abs(i0.value));
                    }
                    if (arg0 instanceof FloatTerm) {
                        FloatTerm f0 = (FloatTerm)arg0;
                        double res = Math.abs(f0.value);
                        if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                            Evaluate.floatOverflow();
                        }
                        return new FloatTerm(res);
                    }
                } else {
                    if (tag == sqrt1) {
                        double d0 = 0.0;
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            d0 = i0.value;
                        } else if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            d0 = f0.value;
                        }
                        double res = Math.sqrt(d0);
                        if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                            Evaluate.floatOverflow();
                        }
                        return new FloatTerm(res);
                    }
                    if (tag == sign1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            return IntegerTerm.get(i0.value >= 0 ? 1 : -1);
                        }
                        if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            double res = f0.value >= 0.0 ? 1.0 : -1.0;
                            return new FloatTerm(res);
                        }
                    } else if (tag == intpart1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            PrologException.typeError(floatAtom, arg0);
                        } else if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            int sign = f0.value >= 0.0 ? 1 : -1;
                            double res = (double)sign * Math.floor(Math.abs(f0.value));
                            return new FloatTerm(res);
                        }
                    } else if (tag == fractpart1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            PrologException.typeError(floatAtom, arg0);
                        } else if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            int sign = f0.value >= 0.0 ? 1 : -1;
                            double res = f0.value - (double)sign * Math.floor(Math.abs(f0.value));
                            return new FloatTerm(res);
                        }
                    } else if (tag == float1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            return new FloatTerm(i0.value);
                        }
                        if (arg0 instanceof FloatTerm) {
                            return arg0;
                        }
                    } else if (tag == floor1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            PrologException.typeError(floatAtom, arg0);
                        } else if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            double res = Math.floor(f0.value);
                            if (res < -2.147483648E9 || res > 2.147483647E9) {
                                Evaluate.intOverflow();
                            }
                            return IntegerTerm.get((int)Math.round(res));
                        }
                    } else if (tag == truncate1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            PrologException.typeError(floatAtom, arg0);
                        } else if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            int sign = f0.value >= 0.0 ? 1 : -1;
                            double res = (double)sign * Math.floor(Math.abs(f0.value));
                            if (res < -2.147483648E9 || res > 2.147483647E9) {
                                Evaluate.intOverflow();
                            }
                            return IntegerTerm.get((int)Math.round(res));
                        }
                    } else if (tag == round1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            PrologException.typeError(floatAtom, arg0);
                        } else if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            double res = Math.floor(f0.value + 0.5);
                            if (res < -2.147483648E9 || res > 2.147483647E9) {
                                Evaluate.intOverflow();
                            }
                            return IntegerTerm.get((int)Math.round(res));
                        }
                    } else if (tag == ceiling1) {
                        Term arg0 = args[0];
                        if (arg0 instanceof IntegerTerm) {
                            PrologException.typeError(floatAtom, arg0);
                        } else if (arg0 instanceof FloatTerm) {
                            FloatTerm f0 = (FloatTerm)arg0;
                            double res = -Math.floor(-f0.value);
                            if (res < -2.147483648E9 || res > 2.147483647E9) {
                                Evaluate.intOverflow();
                            }
                            return IntegerTerm.get((int)Math.round(res));
                        }
                    } else {
                        if (tag == power2) {
                            double res;
                            Pair<Double, Double> doubles = Evaluate.toDouble(args[0], args[1]);
                            double d0 = (Double)doubles.left;
                            double d1 = (Double)doubles.right;
                            if (d0 == 0.0 && d1 < 0.0) {
                                Evaluate.undefined();
                            }
                            if ((res = Math.pow(d0, d1)) == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                                Evaluate.floatOverflow();
                            }
                            return new FloatTerm(res);
                        }
                        if (tag == sin1) {
                            double d0 = 0.0;
                            Term arg0 = args[0];
                            if (arg0 instanceof IntegerTerm) {
                                IntegerTerm i0 = (IntegerTerm)arg0;
                                d0 = i0.value;
                            } else if (arg0 instanceof FloatTerm) {
                                FloatTerm f0 = (FloatTerm)arg0;
                                d0 = f0.value;
                            }
                            double res = Math.sin(d0);
                            return new FloatTerm(res);
                        }
                        if (tag == cos1) {
                            double d0 = 0.0;
                            Term arg0 = args[0];
                            if (arg0 instanceof IntegerTerm) {
                                IntegerTerm i0 = (IntegerTerm)arg0;
                                d0 = i0.value;
                            } else if (arg0 instanceof FloatTerm) {
                                FloatTerm f0 = (FloatTerm)arg0;
                                d0 = f0.value;
                            }
                            double res = Math.cos(d0);
                            return new FloatTerm(res);
                        }
                        if (tag == atan1) {
                            double d0 = 0.0;
                            Term arg0 = args[0];
                            if (arg0 instanceof IntegerTerm) {
                                IntegerTerm i0 = (IntegerTerm)arg0;
                                d0 = i0.value;
                            } else if (arg0 instanceof FloatTerm) {
                                FloatTerm f0 = (FloatTerm)arg0;
                                d0 = f0.value;
                            }
                            double res = Math.atan(d0);
                            return new FloatTerm(res);
                        }
                        if (tag == exp1) {
                            double d0 = 0.0;
                            Term arg0 = args[0];
                            if (arg0 instanceof IntegerTerm) {
                                IntegerTerm i0 = (IntegerTerm)arg0;
                                d0 = i0.value;
                            } else if (arg0 instanceof FloatTerm) {
                                FloatTerm f0 = (FloatTerm)arg0;
                                d0 = f0.value;
                            }
                            double res = Math.exp(d0);
                            if (res == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                                Evaluate.floatOverflow();
                            }
                            return new FloatTerm(res);
                        }
                        if (tag == log1) {
                            double res;
                            double d0 = 0.0;
                            Term arg0 = args[0];
                            if (arg0 instanceof IntegerTerm) {
                                IntegerTerm i0 = (IntegerTerm)arg0;
                                d0 = i0.value;
                            } else if (arg0 instanceof FloatTerm) {
                                FloatTerm f0 = (FloatTerm)arg0;
                                d0 = f0.value;
                            }
                            if (d0 <= 0.0) {
                                Evaluate.undefined();
                            }
                            if ((res = Math.log(d0)) == Double.POSITIVE_INFINITY || res == Double.NEGATIVE_INFINITY) {
                                Evaluate.floatOverflow();
                            }
                            return new FloatTerm(res);
                        }
                        if (tag == brshift2) {
                            Term arg0 = args[0];
                            Term arg1 = args[1];
                            Evaluate.typeTestInt(arg0);
                            Evaluate.typeTestInt(arg1);
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            IntegerTerm i1 = (IntegerTerm)arg1;
                            int res = i0.value >> i1.value;
                            return IntegerTerm.get(res);
                        }
                        if (tag == blshift2) {
                            Term arg0 = args[0];
                            Term arg1 = args[1];
                            Evaluate.typeTestInt(arg0);
                            Evaluate.typeTestInt(arg1);
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            IntegerTerm i1 = (IntegerTerm)arg1;
                            int res = i0.value << i1.value;
                            return IntegerTerm.get(res);
                        }
                        if (tag == band2) {
                            Term arg0 = args[0];
                            Term arg1 = args[1];
                            Evaluate.typeTestInt(arg0);
                            Evaluate.typeTestInt(arg1);
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            IntegerTerm i1 = (IntegerTerm)arg1;
                            int res = i0.value & i1.value;
                            return IntegerTerm.get(res);
                        }
                        if (tag == bor2) {
                            Term arg0 = args[0];
                            Term arg1 = args[1];
                            Evaluate.typeTestInt(arg0);
                            Evaluate.typeTestInt(arg1);
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            IntegerTerm i1 = (IntegerTerm)arg1;
                            int res = i0.value | i1.value;
                            return IntegerTerm.get(res);
                        }
                        if (tag == bnot1) {
                            Term arg0 = args[0];
                            Evaluate.typeTestInt(arg0);
                            IntegerTerm i0 = (IntegerTerm)arg0;
                            int res = ~i0.value;
                            return IntegerTerm.get(res);
                        }
                        if (tag == random1) {
                            double rand;
                            Term arg0 = args[0];
                            if (!(arg0 instanceof IntegerTerm)) {
                                Evaluate.undefined();
                            }
                            IntegerTerm limit = (IntegerTerm)arg0;
                            Random res = random;
                            synchronized (res) {
                                rand = random.nextDouble();
                            }
                            int res2 = (int)(rand * (double)limit.value);
                            return IntegerTerm.get(res2);
                        }
                        PrologException.typeError(TermConstants.evaluableAtom, tag.getPredicateIndicator());
                    }
                }
            }
        } else {
            if (term instanceof AtomTerm) {
                term = new CompoundTerm(CompoundTermTag.divide2, term, IntegerTerm.int_0);
            }
            PrologException.typeError(TermConstants.evaluableAtom, term);
        }
        return null;
    }

    protected static void typeTestInt(Term term) throws PrologException {
        if (term instanceof IntegerTerm) {
            return;
        }
        if (term instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        PrologException.typeError(TermConstants.integerAtom, term);
    }
}

