/* A Bison parser, made by GNU Bison 3.7.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30705

/* Bison version string.  */
#define YYBISON_VERSION "3.7.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 28 "../../cobc/parser.y"

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef	HAVE_STRINGS_H
#include <strings.h>
#endif

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"
#include "libcob/coblocal.h"

#define _PARSER_H	/* work around bad Windows SDK header */

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error_always ("%s", x)

#define emit_statement(x) \
do { \
  if (!skip_statements) { \
	CB_ADD_TO_CHAIN (x, current_program->exec_list); \
  } \
}  ONCE_COB

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_JSON		10U
#define TERM_MODIFY		11U
#define TERM_MULTIPLY		12U
#define TERM_PERFORM		13U
#define TERM_READ		14U
#define TERM_RECEIVE		15U
#define TERM_RETURN		16U
#define TERM_REWRITE		17U
#define TERM_SEARCH		18U
#define TERM_START		19U
#define TERM_STRING		20U
#define TERM_SUBTRACT		21U
#define TERM_UNSTRING		22U
#define TERM_WRITE		23U
#define TERM_XML		24U
#define TERM_MAX		25U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitions and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;    /* program in parse/syntax check/codegen */
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
struct cb_statement		*current_statement = NULL;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_force_literal = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;
unsigned int			cobc_in_xml_generate_body = 0;
unsigned int			cobc_in_json_generate_body = 0;
unsigned int			cobc_areacheck = 0;
unsigned int			cobc_in_area_a = 0;

/* Local variables */

enum inspect_rep_keyword {
	INSPECT_REP_DEFAULT,
	INSPECT_REP_ALL,
	INSPECT_REP_LEADING,
	INSPECT_REP_FIRST,
	INSPECT_REP_TRAILING,
};

union examine_keyword {
	/* EXAMINE TALLYING/REPLACING options */
	enum {
		EXAMINE_TAL_ALL,
		EXAMINE_TAL_LEADING,
		EXAMINE_TAL_UNTIL_FIRST,
	} tallying;
	enum {
		EXAMINE_REP_ALL,
		EXAMINE_REP_LEADING,
		EXAMINE_REP_FIRST,
		EXAMINE_REP_UNTIL_FIRST,
	} replacing;
};

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

enum key_clause_type {
	NO_KEY,
	RECORD_KEY,
	RELATIVE_KEY
};

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*control_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;
static struct cb_key_component	*key_component_list;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static const char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		within_typedef_definition;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static enum inspect_rep_keyword	inspect_keyword;
static union examine_keyword	examine_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static enum cb_call_mode	call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;
static enum key_clause_type	key_type;

static int			ext_dyn_specified;
static enum cb_assign_device	assign_device;

static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static unsigned int		exhibit_changed;
static unsigned int		exhibit_named;

static cb_tree			ml_suppress_list;
static cb_tree			xml_encoding;
static int			with_xml_dec;
static int			with_attrs;

static cb_tree			default_collation;
static cb_tree			alphanumeric_collation;
static cb_tree			national_collation;

static enum cb_ml_suppress_category	ml_suppress_category;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

static const char		*backup_source_file = NULL;
static int			backup_source_line = 0;

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)
#define	COBC_HD_SOURCE_COMPUTER		(1U << 16)
#define	COBC_HD_OBJECT_COMPUTER		(1U << 17)
#define	COBC_HD_REPOSITORY		(1U << 18)

/* Static functions */

/* Area A enforcement */

static COB_INLINE void
check_area_a (cb_tree word) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check_x (word, _("'%s' should start in Area A"),
					  CB_NAME (word));
	}
}

static COB_INLINE void
check_area_a_of (const char * const item) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check (_("'%s' should start in Area A"), item);
	}
}

static COB_INLINE void
check_non_area_a (cb_tree stmt) {
	if (cobc_in_area_a && cobc_areacheck) {
		if (stmt)
			(void) cb_syntax_check_x (stmt, _("start of statement in Area A"));
		else
			(void) cb_syntax_check (_("start of statement in Area A"));
	}
}

/* Collating sequences */

/* Known collating sequences/alphabets */
enum cb_colseq {
	CB_COLSEQ_NATIVE,
	CB_COLSEQ_ASCII,
	CB_COLSEQ_EBCDIC,
};
enum cb_colseq cb_default_colseq = CB_COLSEQ_NATIVE;

/* Decipher character conversion table names */
int cb_deciph_default_colseq_name (const char * const name)
{
	if (! cb_strcasecmp (name, "ASCII")) {
		cb_default_colseq = CB_COLSEQ_ASCII;
	} else if (! cb_strcasecmp (name, "EBCDIC")) {
		cb_default_colseq = CB_COLSEQ_EBCDIC;
	} else if (! cb_strcasecmp (name, "NATIVE")) {
		cb_default_colseq = CB_COLSEQ_NATIVE;
	} else {
		return 1;
	}
	return 0;
}

static cb_tree
build_colseq_tree (const char *alphabet_name,
		      int alphabet_type,
		      int alphabet_target)
{
	const cb_tree name = cb_build_reference (alphabet_name);
	struct cb_alphabet_name * alpha;
	alpha = CB_ALPHABET_NAME (cb_build_alphabet_name (name));
	alpha->alphabet_type = alphabet_type;
	alpha->alphabet_target = alphabet_target;
	return name;
}

static cb_tree
build_colseq (enum cb_colseq colseq)
{
	switch (colseq) {
	case CB_COLSEQ_NATIVE:
		return NULL;
	case CB_COLSEQ_ASCII:
		return build_colseq_tree ("ASCII",
				      CB_ALPHABET_ASCII,
				      CB_ALPHABET_ALPHANUMERIC);
	case CB_COLSEQ_EBCDIC:
		return build_colseq_tree ("EBCDIC",
				      CB_ALPHABET_EBCDIC,
				      CB_ALPHABET_ALPHANUMERIC);
	/* LCOV_EXCL_START */
	default:
		cobc_err_msg (_("call to '%s' with invalid parameter '%s'"),
			"build_colseq", "colseq");
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */

}


/* Statements */

static void
begin_statement (enum cob_statement statement, const unsigned int term)
{
	if (check_unreached) {
		cb_warning (cb_warn_unreachable,
			_("unreachable statement '%s'"),
			cb_statement_name[statement]);
	}
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (statement);
	CB_TREE (current_statement)->source_file = cb_source_file;
	CB_TREE (current_statement)->source_line = cb_source_line;
	current_statement->flag_in_debug = in_debugging;
	check_non_area_a (CB_TREE (current_statement));
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
}

static void
restore_backup_pos (cb_tree item)
{
	item->source_file = backup_source_file;
	item->source_line = backup_source_line;
}

static void
begin_statement_from_backup_pos (enum cob_statement statement, const unsigned int term)
{
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (statement);
	restore_backup_pos (CB_TREE (current_statement));
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	if (check_unreached) {
		cb_warning_x (cb_warn_unreachable, CB_TREE (current_statement),
			_("unreachable statement '%s'"),
			cb_statement_name[statement]);
	}
}

/* create a new statement with base attributes of current_statement
   and set this as new current_statement */
static void
begin_implicit_statement (void)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (current_statement->statement);
	new_statement->common = current_statement->common;
	new_statement->flag_in_debug = !!in_debugging;
	new_statement->flag_implicit = 1;
	current_statement->body = cb_list_add (current_statement->body,
					    CB_TREE (new_statement));
	current_statement = new_statement;
}

# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
static
void print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

/* functions for storing current position and
   assigning it to a cb_tree after its parsing is finished */
static COB_INLINE
void backup_current_pos (void)
{
	backup_source_file = cb_source_file;
	backup_source_line = cb_source_line;
}

#if 0 /* currently not used */
static COB_INLINE
void set_pos_from_backup (cb_tree x)
{
	x->source_file = backup_source_file;
	x->source_line = backup_source_line;
}
#endif

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention, int override_source_line)
{
	cb_tree		l;
	cb_tree		label;
	cb_tree		entry_conv;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name, 0, cb_fold_call);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	if (override_source_line) {
		label->source_line = override_source_line;
	}
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	cb_validate_parameters_and_returning (current_program, using_list);

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		struct cb_label *check = CB_LABEL (CB_PURPOSE (l));
		if (strcmp (name, check->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR(entry_conv, using_list)));
}

/* Main entry point and the number of its main parameters */
static void
emit_main_entry (struct cb_program *program, cb_tree using_list)
{
	if (using_list) {
		program->num_proc_params = cb_list_length (using_list);
	}

	emit_entry (program->program_id, 0, using_list, NULL, 0);
	if (program->source_name) {
		emit_entry (program->source_name, 1, using_list, NULL, 0);
	}
}

static void
emit_entry_goto (const char *name)
{
	cb_tree		l;
	cb_tree		label;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	CB_LABEL (label)->name = name;
	CB_LABEL (label)->orig_name = name;
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	CB_LABEL (label)->flag_entry_for_goto = 1;
	label->source_line = backup_source_line;	/* CHECKME: is that correct? */
	emit_statement (label);

	for (l = current_program->entry_list_goto; l; l = CB_CHAIN (l)) {
		struct cb_label *real_label = CB_LABEL (CB_VALUE (l));
		if (strcmp (name, real_label->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY FOR GO TO '%s' duplicated"), name);
		}
	}

	if (current_program->entry_list_goto) {
		current_program->entry_list_goto =
			cb_list_add (current_program->entry_list_goto, label);
	} else {
		current_program->entry_list_goto = CB_LIST_INIT (label);
	}
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", cb_statement_name[current_statement->statement]);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SORT file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

/* note: same message in field.c */
static int
emit_duplicate_clause_message (const char *clause)
{
	return cb_syntax_check (_("duplicate %s clause"), clause);
}

static int
check_repeated (const char *clause, const cob_flags_t bitval,
			cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		return emit_duplicate_clause_message (clause);
	}
	*already_seen |= bitval;
	return 0;
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_syntax_check (_("cannot specify both %s and %s"), clause, conflicting)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s is ignored"), clause);
	}
}


static void
error_if_no_page_lines_limit (const char *phrase)
{
	if (!current_report->lines && !current_report->t_lines) {
		cb_error (_("Cannot specify %s without number of lines on page"),
			  phrase);
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage != CB_STORAGE_LINKAGE) {
			cb_error_x (CB_TREE(current_field), _("'%s' is not in LINKAGE SECTION"),
				cb_name (CB_TREE(current_field)));
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_syntax_check (_("TO phrase without DEPENDING phrase"))) {
					cb_note (COBC_WARN_FILLER, 0,
						 _("maximum number of occurrences assumed to be exact number"));
					current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
				current_field->occurs_max = current_field->occurs_min;
			}
		} else {
			current_field->occurs_max = 0;	/* UNBOUNDED */
		}
	} else {
		current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _("OCCURS DEPENDING ON without TO phrase"));
		}
	}
	/* LCOV_EXCL_START */
	if (current_field->occurs_max > COB_MAX_FIELD_SIZE) {
		/* testing here to give an early error; unlikely to be reached
		   with 64bit compilers so no own msgid for now; should be added
		   when the maximum field size is changed to be configurable */
		cb_error_x (CB_TREE (current_field),
			_("'%s' cannot be larger than %d bytes"),
			current_field->name, COB_MAX_FIELD_SIZE);
		current_field->occurs_min = current_field->occurs_max = 1;
	}
	/* LCOV_EXCL_STOP */
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	/* LCOV_EXCL_START */
	default:
		s = _("unknown");
		break;
	/* LCOV_EXCL_STOP */
	}
	if (cb_syntax_check (_("%s header missing"), s)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s header assumed"), s);
	}
}

static void
program_init_without_program_id (void)
{
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
		strlen (demangle_name));
	current_program->program_name = (char *)CB_LITERAL (l)->data;
	current_program->program_id
		= cb_build_program_id (current_program->program_name, 0);
	current_program->prog_type = COB_MODULE_TYPE_PROGRAM;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

/*
  TO-DO: Refactor header checks - have several header_checks: division_header,
  section_header, paragraph_header, sentence_type
*/
static void
set_conf_section_part (const cob_flags_t part)
{
	header_check &= ~COBC_HD_SOURCE_COMPUTER;
	header_check &= ~COBC_HD_OBJECT_COMPUTER;
	header_check &= ~COBC_HD_SPECIAL_NAMES;
	header_check &= ~COBC_HD_REPOSITORY;
	header_check |= part;
}

static const char *
get_conf_section_part_name (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return "SOURCE-COMPUTER";
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return "OBJECT-COMPUTER";
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return "SPECIAL-NAMES";
	} else if (part == COBC_HD_REPOSITORY) {
		return "REPOSITORY";
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static int
get_conf_section_part_order (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return 1;
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return 2;
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return 3;
	} else if (part == COBC_HD_REPOSITORY) {
		return 4;
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static void
check_conf_section_order (const cob_flags_t part)
{
	const cob_flags_t	prev_part
		= header_check & (COBC_HD_SOURCE_COMPUTER
				  | COBC_HD_OBJECT_COMPUTER
				  | COBC_HD_SPECIAL_NAMES
				  | COBC_HD_REPOSITORY);
#define MESSAGE_LEN 100
	char			message[MESSAGE_LEN] = { '\0' };

	if (prev_part == 0) {
		return;
	}

	if (prev_part == part) {
		cb_error (_("duplicate %s"), get_conf_section_part_name (part));
	} else if (get_conf_section_part_order (part) < get_conf_section_part_order (prev_part)) {
		snprintf (message, MESSAGE_LEN, _("%s incorrectly after %s"),
			  get_conf_section_part_name (part),
			  get_conf_section_part_name (prev_part));
		cb_verify (cb_incorrect_conf_sec_order, message);
	}
}

#undef MESSAGE_LEN

/* check if a given register is available; if it is,
   enforce code generation and add a
   "receiving" entry for it when xref is requested */
static void
cb_set_register_receiving (struct cb_field *reg_field, int mandatory)
{
	if (!reg_field) {
		if (mandatory) {
			cb_error ("missing register definition");
		}
		return;
	}
	reg_field->count++;

	if (cb_listing_xref) {
		cobc_xref_set_receiving (CB_TREE (reg_field));
	}
}

static enum cb_handler_type
get_handler_type_from_statement (struct cb_statement *statement)
{
	if (statement->statement == STMT_DISPLAY) {
		return DISPLAY_HANDLER;
	}
	if (statement->statement == STMT_XML_GENERATE
	 || statement->statement == STMT_XML_PARSE) {
		return XML_HANDLER;
	}
	if (statement->statement == STMT_JSON_GENERATE
	 || statement->statement == STMT_JSON_PARSE) {
		return JSON_HANDLER;
	}
#if 0 /* not merged yet */
	if (statement->statement == STMT_DELETE_FILE) {
		return DELETE_FILE_HANDLER;
	}
#endif
	if (statement->statement == STMT_SEND
	 || statement->statement == STMT_RECEIVE) {
		return MCS_HANDLER;
	}
	return NO_HANDLER;
}

static void
build_words_for_nested_programs (void)
{
	cb_tree		x;
	cb_tree		y;

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}

	/* Inherit class names from parent */
	for (x = current_program->class_name_list; x; x = CB_CHAIN(x)) {
		y = cb_build_reference (cb_name(CB_VALUE(x)));
		cb_define (y, CB_VALUE(x));
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = INSPECT_REP_DEFAULT;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_force_literal = 0;
	cobc_in_xml_generate_body = 0;
	cobc_in_json_generate_body = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	cb_tree		l;

	/*
	  Error if we find a program or prototype with the same name as the
	  given program or prototype, respectively.
	*/
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		const struct cb_program	*elt_program = CB_PROGRAM (CB_VALUE (l));
		const char	*elt_name = elt_program->program_name;
		const char	*elt_id = elt_program->orig_program_id;
		/*
		  If we find a program's matching prototype or a prototype's
		  matching definition, nothing needs to be done.
		*/
		if (program->flag_prototype != elt_program->flag_prototype) {
			continue;
		}

		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program name '%s'"),
				    elt_name);
			return;
		} else if (strcmp (prog_id, elt_id) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list, CB_TREE (program));
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == COB_MODULE_TYPE_FUNCTION
		/* CHECKME: That would be valid in a function-definition according to COBOL2014
		  --> How is it intended to work? */
		 && !program->flag_prototype) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_main_entry (program, NULL);
		}
	}
	program->last_source_line = backup_source_line;

	if (program->nested_level == 0
	 || defined_prog_list == NULL) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		if (CB_PROGRAM (l->value)->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = CB_LIST (defined_prog_list);
		while (l) {
			/* The nested_level check is for the pathological case
			   where two nested programs have the same name */
			if (0 == strcmp (program->orig_program_id,
			         CB_PROGRAM (l->value)->orig_program_id)
			    && program->nested_level == CB_PROGRAM (l->value)->nested_level) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const unsigned char type, const int prototype)
{
	const char	*external_name = NULL;

	setup_program_start ();

	/* finish last program/function */
	if (!first_prog) {
		backup_source_file = cb_source_file;
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		if (depth) {
			build_words_for_nested_programs();
		}
		cb_source_file = "register-definition";
		cb_set_intr_when_compiled ();
		cb_build_registers ();
		cb_add_external_defined_registers ();
		cb_source_file = backup_source_file;
	} else {
		first_prog = 0;
	}

	/* set internal name */
	if (CB_LITERAL_P (id)) {
		current_program->program_name = (char *)CB_LITERAL (id)->data;
	} else {
		current_program->program_name = CB_NAME (id);
	}
	stack_progid[depth] = current_program->program_name;
	current_program->prog_type = type;
	current_program->flag_prototype = prototype;

	if (depth != 0 && type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	/* set external name if specified */
	if (as_literal) {
		external_name = (const char *)CB_LITERAL (as_literal)->data;
	} else {
		external_name = current_program->program_name;
	}

	/* build encoded external PROGRAM-ID */
	current_program->program_id
		= cb_build_program_id (external_name, type == COB_MODULE_TYPE_FUNCTION);

	if (type == COB_MODULE_TYPE_PROGRAM) {
		if (!main_flag_set
		 && !current_program->flag_prototype) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* COB_MODULE_TYPE_FUNCTION */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
		cb_define (id, CB_TREE (current_program));
	}

	/* Initalize default COLLATING SEQUENCE */
	default_collation = build_colseq (cb_default_colseq);

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set currency symbol used in picture (compile time) and - if no currency
   string is explicitly set (which is currently not implemented) - as currency string
   (run time for display and [de-]editing)*/
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("currency symbol must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
#if 0 /* note: MicroFocus also dissalows L (VAX) and G (OSVS) */
	case 'L':
	case 'G':
	case 'l':
	case 'g':
#endif
		cb_error_x (x, _("invalid character '%c' in currency symbol"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const int type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	 && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == COB_MODULE_TYPE_PROGRAM
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == COB_MODULE_TYPE_PROGRAM) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* COB_MODULE_TYPE_FUNCTION */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_record_delimiter_incompatible (const int organization,
					const char *organization_name)
{
	int	is_compatible;

	if (!current_file->flag_delimiter) {
		return;
	}

	if (organization == COB_ORG_LINE_SEQUENTIAL) {
		is_compatible = current_file->organization == COB_ORG_SEQUENTIAL
			|| current_file->organization == COB_ORG_LINE_SEQUENTIAL;
	} else {
		is_compatible = current_file->organization == organization;
	}

	if (!is_compatible) {
		cb_error (_("ORGANIZATION %s is incompatible with RECORD DELIMITER"),
			  organization_name);
	}
}

static int
set_current_field (cb_tree level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);
	/* Free tree associated with level number */
	cobc_parse_free (level);

	if (CB_INVALID_TREE (x)) {
		return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
		if (current_field->level == 1 || current_field->level == 77) {
			within_typedef_definition = 0;
		}
	}

	return 0;
}

static void
setup_external_definition (cb_tree x, const int type)
{
	/* note: syntax checks for conflicting clauses
	         are done in inherit_external_definition */

	if (x != cb_error_node) {
		struct cb_field *f = CB_FIELD (cb_ref (x));

		/* additional checks if the definition isn't provided by type */
		if (type != 1 /* called with SAME AS / LIKE data-name */ ) {
			if (f->level == 88) {
				cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
				x = cb_error_node;
			}
			/* note: the following are not explicit specified but implied with
			   LIKE as ILE-COBOL does not have those sections */
			if (f->storage == CB_STORAGE_SCREEN) {
				cb_error (_("SCREEN item cannot be used here"));
				x = cb_error_node;
			} else if (f->storage == CB_STORAGE_REPORT) {
				cb_error (_("REPORT item cannot be used here"));
				x = cb_error_node;
			}
			if (type == 0) {
				/* rules that apply only to SAME AS */
				if (f->flag_is_typedef) {
					cb_error (_("TYPEDEF item cannot be used here"));
					x = cb_error_node;
				}
			}
		}

		if (current_field->level == 77) {
			if (type != 2 /* called with LIKE */
			 && f->children) {
				cb_error (_("elementary item expected"));
				x = cb_error_node;
			}
		} else {
			struct cb_field *p;
			for (p = current_field; p; p = p->parent) {
				if (p == f) {
					cb_error (_("item may not reference itself"));
					x = cb_error_node;
					break;
				}
			}
			for (p = f->parent; p; p = p->parent) {
				if (p->usage != CB_USAGE_DISPLAY) {
					cb_error (_("item may not be subordinate to any item with USAGE clause"));
				} else if (p->flag_sign_clause) {
					cb_error (_("item may not be subordinate to any item with SIGN clause"));
				} else {
					continue;
				}
				x = cb_error_node;
				break;
			}
		}
	}

	if (x == cb_error_node) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		current_field->external_definition = cb_error_node;
	} else {
		current_field->external_definition = cb_ref (x);
	}
}

static void
setup_external_definition_type (cb_tree x)
{
	if (!check_repeated ("TYPE TO", SYN_CLAUSE_31, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("SAME AS", "TYPE TO");
		}
		setup_external_definition (x, 1);
	}
}

/* verifies that no conflicting clauses are used and
   inherits the definition of the original field specified
   by SAME AS or by type_name */
static void
inherit_external_definition (cb_tree lvl)
{
	/* note: REDEFINES (clause 1) is allowed with RM/COBOL but not COBOL 2002+ */
	static const cob_flags_t	allowed_clauses =
		SYN_CLAUSE_1 | SYN_CLAUSE_2 | SYN_CLAUSE_3 | SYN_CLAUSE_7 | SYN_CLAUSE_12;
	cob_flags_t	tested = check_pic_duplicate & ~(allowed_clauses);
	if (tested != SYN_CLAUSE_30 && tested != SYN_CLAUSE_31
	 && tested != 0 /* USAGE as TYPE TO */) {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		cb_error_x (CB_TREE(current_field), _("illegal combination of %s with other clauses"),
			fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	} else {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		int new_level = lvl ? cb_get_level (lvl) : 0;
		int old_level = current_field->level;
		copy_into_field (fld, current_field);
		if (new_level > 1 && new_level < 66 && new_level > old_level) {
			cb_error_x (lvl, _("entry following %s may not be subordinate to it"),
				fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		}
	}
}

static cb_tree
get_finalized_description_tree (void)
{
	struct cb_field *p;

	/* finalize last field if target of SAME AS / TYPEDEF */
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		inherit_external_definition (NULL);
	}

	/* validate the complete current "block" */
	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	return CB_TREE (description_field);
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
		*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
		   cb_tree timeout, cb_tree prompt, cb_tree size_is)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
}

static void
set_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == CHARACTERS_PHRASE
		 || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between ALL/LEADING/TRAILING words"));
		}
		/* fall through */
	case CHARACTERS_PHRASE:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (! ( previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		     || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

	/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
	/* LCOV_EXCL_STOP */
	}

	previous_tallying_phrase = phrase;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & ( COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		    | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
	        && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static cb_tree
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (x == cb_error_node) {
		return cb_error_node;
	}
	if (!CB_REF_OR_FIELD_P(x)) {
		return x;
	}

	f = CB_FIELD_PTR (x);

	if (f->level == 88) {
#if 0	/* note: we may consider to support the extension (if existing) to
		         reference a condition-name target by the condition-name */
		if (cb_verify (cb_condition_references_data, _("use of condition-name in place of data-name"))) {
			return CB_TREE (f->parent);
		}
#else
		cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
		/* invalidate field to prevent same error in typeck.c (validate_one) */
		/* FIXME: If we really need the additional check here then we missed
		          a call to cb_validate_one() somewhere */
		return cb_error_node;
#endif
	} else {
		return x;
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	 || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *l)
{
	return cb_list_length (CB_TREE(l)) == 1
		&& is_screen_field (l->value);
}

static int
contains_only_screen_fields (struct cb_list *l)
{
	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (!is_screen_field (l->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *l)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (is_screen_field (l->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (struct	cb_list *l, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	/* TODO: Separate CGI DISPLAYs here */
	if (contains_only_screen_fields (l)) {
		if (!contains_one_screen_field (l)
		 || attr_ptr) {
			cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens (l)) {
		cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (struct cb_list *l, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (struct cb_list *l, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	const enum cb_display_type	type =
		deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (CB_TREE(l), _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	const int	is_numeric_literal = CB_NUMERIC_LITERAL_P (x);
	const int	is_field_with_usage_not_display =
		CB_REFERENCE_P (x) && CB_FIELD (cb_ref (x))
		&& CB_FIELD (cb_ref (x))->usage != CB_USAGE_DISPLAY;

	if (is_numeric_literal) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (is_field_with_usage_not_display) {
		cb_error_x (x, _("'%s' is not USAGE DISPLAY"), cb_name (x));
	}
}

static void
check_validate_item (cb_tree x)
{
	struct cb_field	*f;
	enum cb_class	tree_class;

	if (CB_INVALID_TREE(x) || x->tag != CB_TAG_REFERENCE) {
		return;
	}
	x = cb_ref (x);
	if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
		cb_error (_("invalid target for %s"), "VALIDATE");
		return;
	}

	f = CB_FIELD (x);
	tree_class = CB_TREE_CLASS(f);
	if (is_screen_field(x)) {
		cb_error (_("SCREEN item cannot be used here"));
	} else if (f->level == 66) {
		cb_error (_("RENAMES item may not be used here"));
	} else if (f->flag_any_length) {
		cb_error (_("ANY LENGTH item not allowed here"));
	} else if (tree_class == CB_CLASS_INDEX
		|| tree_class == CB_CLASS_OBJECT
		|| tree_class == CB_CLASS_POINTER) {
		cb_error (_("item '%s' has wrong class for VALIDATE"), cb_name (x));
	}
}

static void
error_if_following_every_clause (void)
{
	if (ml_suppress_list
	 && CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list))->target == CB_ML_SUPPRESS_TYPE) {
		cb_error (_("WHEN clause must follow EVERY clause"));
	}
}

static void
prepend_to_ml_suppress_list (cb_tree suppress_entry)
{
	cb_tree	new_list_head = CB_LIST_INIT (suppress_entry);
	cb_list_append (new_list_head, ml_suppress_list);
	ml_suppress_list = new_list_head;
}

static void
add_identifier_to_ml_suppress_conds (cb_tree identifier)
{
	cb_tree suppress_id = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_id)->target = CB_ML_SUPPRESS_IDENTIFIER;
	CB_ML_SUPPRESS (suppress_id)->identifier = identifier;
	prepend_to_ml_suppress_list (suppress_id);
}

static void
add_when_to_ml_suppress_conds (cb_tree when_list)
{
	struct cb_ml_suppress_clause	*last_suppress_clause;
	cb_tree	suppress_all;

	/*
	  If the preceding clause in SUPPRESS was an identifier, the WHEN
	  belongs to the identifier. If EVERY was preceding, the WHEN belongs to
	  the EVERY. Otherwise, the WHEN acts on the entire record.
	*/
	if (ml_suppress_list) {
		last_suppress_clause = CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list));
		if ( (last_suppress_clause->target == CB_ML_SUPPRESS_IDENTIFIER
		   || last_suppress_clause->target == CB_ML_SUPPRESS_TYPE)
		  && !last_suppress_clause->when_list) {
			last_suppress_clause->when_list = when_list;
			return;
		}
	}

	suppress_all = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_all)->when_list = when_list;
	prepend_to_ml_suppress_list (suppress_all);
}

static void
add_type_to_ml_suppress_conds (enum cb_ml_suppress_category category,
			       enum cb_ml_type ml_type)
{
	cb_tree	suppress_type = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_type)->target = CB_ML_SUPPRESS_TYPE;
	CB_ML_SUPPRESS (suppress_type)->category = category;
	CB_ML_SUPPRESS (suppress_type)->ml_type = ml_type;
	prepend_to_ml_suppress_list (suppress_type);
}

static void
set_record_size (cb_tree min, cb_tree max)
{
	int record_min, record_max;

	if (min) {
		record_min = cb_get_int (min);
		if (record_min < 0) {
			/* already handled by integer check */
		} else {
			current_file->record_min = record_min;
		}
	} else {
		record_min = 0;
	}
	if (!max) {
		return;
	}

	record_max = cb_get_int (max);
	if (record_max < 0) {
		/* already handled by integer check */
		return;
	} else if (record_max == 0) {
		/* Note: standard COBOL does not allow zero at all, use the related
		         configuration option */
		if (cb_records_mismatch_record_clause >= CB_ERROR) {
			cb_error (_("non-zero value expected"));
		}
		return;
	}
	if (current_file->organization == COB_ORG_INDEXED
	 && record_max > MAX_FD_RECORD_IDX)  {
		cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
			MAX_FD_RECORD_IDX);
		current_file->record_max = MAX_FD_RECORD_IDX;
	} else if (record_max > MAX_FD_RECORD)  {
		cb_error (_("RECORD size exceeds maximum allowed (%d)"),
			MAX_FD_RECORD);
		current_file->record_max = MAX_FD_RECORD;
	} else {
		if (record_max <= record_min)  {
			cb_error (_("RECORD clause invalid"));
		}
		current_file->record_max = record_max;
	}
}


#line 2395 "parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    TOKEN_EOF = 0,                 /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    THREEDIMENSIONAL = 258,        /* "3D"  */
    ABSENT = 259,                  /* ABSENT  */
    ACCEPT = 260,                  /* ACCEPT  */
    ACCESS = 261,                  /* ACCESS  */
    ACTIVEX = 262,                 /* "ACTIVE-X"  */
    ACTIVE_CLASS = 263,            /* "ACTIVE-CLASS"  */
    ACTION = 264,                  /* ACTION  */
    ACTUAL = 265,                  /* ACTUAL  */
    ADD = 266,                     /* ADD  */
    ADDRESS = 267,                 /* ADDRESS  */
    ADJUSTABLE_COLUMNS = 268,      /* "ADJUSTABLE-COLUMNS"  */
    ADVANCING = 269,               /* ADVANCING  */
    AFTER = 270,                   /* AFTER  */
    ALIGNED = 271,                 /* ALIGNED  */
    ALIGNMENT = 272,               /* ALIGNMENT  */
    ALL = 273,                     /* ALL  */
    ALLOCATE = 274,                /* ALLOCATE  */
    ALLOWING = 275,                /* ALLOWING  */
    ALPHABET = 276,                /* ALPHABET  */
    ALPHABETIC = 277,              /* ALPHABETIC  */
    ALPHABETIC_LOWER = 278,        /* "ALPHABETIC-LOWER"  */
    ALPHABETIC_UPPER = 279,        /* "ALPHABETIC-UPPER"  */
    ALPHANUMERIC = 280,            /* ALPHANUMERIC  */
    ALPHANUMERIC_EDITED = 281,     /* "ALPHANUMERIC-EDITED"  */
    ALSO = 282,                    /* ALSO  */
    ALTER = 283,                   /* ALTER  */
    ALTERNATE = 284,               /* ALTERNATE  */
    AND = 285,                     /* AND  */
    ANY = 286,                     /* ANY  */
    APPLY = 287,                   /* APPLY  */
    ARE = 288,                     /* ARE  */
    AREA = 289,                    /* AREA  */
    AREAS = 290,                   /* AREAS  */
    ARGUMENT_NUMBER = 291,         /* "ARGUMENT-NUMBER"  */
    ARGUMENT_VALUE = 292,          /* "ARGUMENT-VALUE"  */
    ARITHMETIC = 293,              /* ARITHMETIC  */
    AS = 294,                      /* AS  */
    ASCENDING = 295,               /* ASCENDING  */
    ASCII = 296,                   /* ASCII  */
    ASSIGN = 297,                  /* ASSIGN  */
    AT = 298,                      /* AT  */
    AT_END = 299,                  /* "AT END"  */
    ATTRIBUTE = 300,               /* ATTRIBUTE  */
    ATTRIBUTES = 301,              /* ATTRIBUTES  */
    AUTHOR = 302,                  /* AUTHOR  */
    AUTO = 303,                    /* AUTO  */
    AUTO_DECIMAL = 304,            /* "AUTO-DECIMAL"  */
    AUTO_SPIN = 305,               /* "AUTO-SPIN"  */
    AUTOMATIC = 306,               /* AUTOMATIC  */
    AWAY_FROM_ZERO = 307,          /* "AWAY-FROM-ZERO"  */
    B_AND = 308,                   /* "B-AND"  */
    B_NOT = 309,                   /* "B-NOT"  */
    B_OR = 310,                    /* "B-OR"  */
    B_XOR = 311,                   /* "B-XOR"  */
    B_SHIFT_L = 312,               /* "B-SHIFT-L"  */
    B_SHIFT_R = 313,               /* "B-SHIFT-R"  */
    B_SHIFT_LC = 314,              /* "B-SHIFT-LC"  */
    B_SHIFT_RC = 315,              /* "B-SHIFT-RC"  */
    BACKGROUND_COLOR = 316,        /* "BACKGROUND-COLOR"  */
    BACKGROUND_HIGH = 317,         /* "BACKGROUND-HIGH"  */
    BACKGROUND_LOW = 318,          /* "BACKGROUND-LOW"  */
    BACKGROUND_STANDARD = 319,     /* "BACKGROUND-STANDARD"  */
    BACKWARD = 320,                /* BACKWARD  */
    BAR = 321,                     /* BAR  */
    BASED = 322,                   /* BASED  */
    BEFORE = 323,                  /* BEFORE  */
    BELL = 324,                    /* BELL  */
    BINARY = 325,                  /* BINARY  */
    BINARY_C_LONG = 326,           /* "BINARY-C-LONG"  */
    BINARY_CHAR = 327,             /* "BINARY-CHAR"  */
    BINARY_DOUBLE = 328,           /* "BINARY-DOUBLE"  */
    BINARY_LONG = 329,             /* "BINARY-LONG"  */
    BINARY_SEQUENTIAL = 330,       /* "BINARY-SEQUENTIAL"  */
    BINARY_SHORT = 331,            /* "BINARY-SHORT"  */
    BIT = 332,                     /* BIT  */
    BITMAP = 333,                  /* BITMAP  */
    BITMAP_END = 334,              /* "BITMAP-END"  */
    BITMAP_HANDLE = 335,           /* "BITMAP-HANDLE"  */
    BITMAP_NUMBER = 336,           /* "BITMAP-NUMBER"  */
    BITMAP_START = 337,            /* "BITMAP-START"  */
    BITMAP_TIMER = 338,            /* "BITMAP-TIMER"  */
    BITMAP_TRAILING = 339,         /* "BITMAP-TRAILING"  */
    BITMAP_TRANSPARENT_COLOR = 340, /* "BITMAP-TRANSPARENT-COLOR"  */
    BITMAP_WIDTH = 341,            /* "BITMAP-WIDTH"  */
    BLANK = 342,                   /* BLANK  */
    BLINK = 343,                   /* BLINK  */
    BLOCK = 344,                   /* BLOCK  */
    BOOLEAN = 345,                 /* BOOLEAN  */
    BOTTOM = 346,                  /* BOTTOM  */
    BOX = 347,                     /* BOX  */
    BOXED = 348,                   /* BOXED  */
    BULK_ADDITION = 349,           /* "BULK-ADDITION"  */
    BUSY = 350,                    /* BUSY  */
    BUTTONS = 351,                 /* BUTTONS  */
    BY = 352,                      /* BY  */
    BYTE_LENGTH = 353,             /* "BYTE-LENGTH"  */
    C = 354,                       /* C  */
    CALENDAR_FONT = 355,           /* "CALENDAR-FONT"  */
    CALL = 356,                    /* CALL  */
    CANCEL = 357,                  /* CANCEL  */
    CANCEL_BUTTON = 358,           /* "CANCEL-BUTTON"  */
    CAPACITY = 359,                /* CAPACITY  */
    CARD_PUNCH = 360,              /* "CARD-PUNCH"  */
    CARD_READER = 361,             /* "CARD-READER"  */
    CASSETTE = 362,                /* CASSETTE  */
    CCOL = 363,                    /* CCOL  */
    CD = 364,                      /* CD  */
    CELL = 365,                    /* CELL  */
    CELL_COLOR = 366,              /* "CELL-COLOR"  */
    CELL_DATA = 367,               /* "CELL-DATA"  */
    CELL_FONT = 368,               /* "CELL-FONT"  */
    CELL_PROTECTION = 369,         /* "CELL-PROTECTION"  */
    CENTER = 370,                  /* CENTER  */
    CENTERED = 371,                /* CENTERED  */
    CENTERED_HEADINGS = 372,       /* "CENTERED-HEADINGS"  */
    CENTURY_DATE = 373,            /* "CENTURY-DATE"  */
    CF = 374,                      /* CF  */
    CH = 375,                      /* CH  */
    CHAINING = 376,                /* CHAINING  */
    CHANGED = 377,                 /* CHANGED  */
    CHARACTER = 378,               /* CHARACTER  */
    CHARACTERS = 379,              /* CHARACTERS  */
    CHECK_BOX = 380,               /* "CHECK-BOX"  */
    CLASS = 381,                   /* CLASS  */
    CLASSIFICATION = 382,          /* CLASSIFICATION  */
    CLASS_NAME = 383,              /* "class-name"  */
    CLEAR_SELECTION = 384,         /* "CLEAR-SELECTION"  */
    CLINE = 385,                   /* CLINE  */
    CLINES = 386,                  /* CLINES  */
    CLOSE = 387,                   /* CLOSE  */
    COBOL = 388,                   /* COBOL  */
    CODE = 389,                    /* CODE  */
    CODE_SET = 390,                /* "CODE-SET"  */
    COLLATING = 391,               /* COLLATING  */
    COL = 392,                     /* COL  */
    COLOR = 393,                   /* COLOR  */
    COLORS = 394,                  /* COLORS  */
    COLS = 395,                    /* COLS  */
    COLUMN = 396,                  /* COLUMN  */
    COLUMN_COLOR = 397,            /* "COLUMN-COLOR"  */
    COLUMN_DIVIDERS = 398,         /* "COLUMN-DIVIDERS"  */
    COLUMN_FONT = 399,             /* "COLUMN-FONT"  */
    COLUMN_HEADINGS = 400,         /* "COLUMN-HEADINGS"  */
    COLUMN_PROTECTION = 401,       /* "COLUMN-PROTECTION"  */
    COLUMNS = 402,                 /* COLUMNS  */
    COMBO_BOX = 403,               /* "COMBO-BOX"  */
    COMMA = 404,                   /* COMMA  */
    COMMAND_LINE = 405,            /* "COMMAND-LINE"  */
    COMMA_DELIM = 406,             /* "comma delimiter"  */
    COMMIT = 407,                  /* COMMIT  */
    COMMON = 408,                  /* COMMON  */
    COMMUNICATION = 409,           /* COMMUNICATION  */
    COMP = 410,                    /* COMP  */
    COMPUTE = 411,                 /* COMPUTE  */
    COMP_0 = 412,                  /* "COMP-0"  */
    COMP_1 = 413,                  /* "COMP-1"  */
    COMP_2 = 414,                  /* "COMP-2"  */
    COMP_3 = 415,                  /* "COMP-3"  */
    COMP_4 = 416,                  /* "COMP-4"  */
    COMP_5 = 417,                  /* "COMP-5"  */
    COMP_6 = 418,                  /* "COMP-6"  */
    COMP_N = 419,                  /* "COMP-N"  */
    COMP_X = 420,                  /* "COMP-X"  */
    CONCATENATE_FUNC = 421,        /* "FUNCTION CONCATENATE"  */
    CONDITION = 422,               /* CONDITION  */
    CONFIGURATION = 423,           /* CONFIGURATION  */
    CONSTANT = 424,                /* CONSTANT  */
    CONTAINS = 425,                /* CONTAINS  */
    CONTENT = 426,                 /* CONTENT  */
    CONTENT_LENGTH_FUNC = 427,     /* "FUNCTION CONTENT-LENGTH"  */
    CONTENT_OF_FUNC = 428,         /* "FUNCTION CONTENT-OF"  */
    CONTINUE = 429,                /* CONTINUE  */
    CONTROL = 430,                 /* CONTROL  */
    CONTROLS = 431,                /* CONTROLS  */
    CONVERSION = 432,              /* CONVERSION  */
    CONVERTING = 433,              /* CONVERTING  */
    COPY = 434,                    /* COPY  */
    COPY_SELECTION = 435,          /* "COPY-SELECTION"  */
    CORE_INDEX = 436,              /* "CORE-INDEX"  */
    CORRESPONDING = 437,           /* CORRESPONDING  */
    COUNT = 438,                   /* COUNT  */
    CRT = 439,                     /* CRT  */
    CRT_UNDER = 440,               /* "CRT-UNDER"  */
    CSIZE = 441,                   /* CSIZE  */
    CURRENCY = 442,                /* CURRENCY  */
    CURRENT_DATE_FUNC = 443,       /* "FUNCTION CURRENT-DATE"  */
    CURSOR = 444,                  /* CURSOR  */
    CURSOR_COL = 445,              /* "CURSOR-COL"  */
    CURSOR_COLOR = 446,            /* "CURSOR-COLOR"  */
    CURSOR_FRAME_WIDTH = 447,      /* "CURSOR-FRAME-WIDTH"  */
    CURSOR_ROW = 448,              /* "CURSOR-ROW"  */
    CURSOR_X = 449,                /* "CURSOR-X"  */
    CURSOR_Y = 450,                /* "CURSOR-Y"  */
    CUSTOM_PRINT_TEMPLATE = 451,   /* "CUSTOM-PRINT-TEMPLATE"  */
    CYCLE = 452,                   /* CYCLE  */
    CYL_INDEX = 453,               /* "CYL-INDEX"  */
    CYL_OVERFLOW = 454,            /* "CYL-OVERFLOW"  */
    DASHED = 455,                  /* DASHED  */
    DATA = 456,                    /* DATA  */
    DATA_COLUMNS = 457,            /* "DATA-COLUMNS"  */
    DATA_TYPES = 458,              /* "DATA-TYPES"  */
    DATE = 459,                    /* DATE  */
    DATE_COMPILED = 460,           /* "DATE-COMPILED"  */
    DATE_ENTRY = 461,              /* "DATE-ENTRY"  */
    DATE_MODIFIED = 462,           /* "DATE-MODIFIED"  */
    DATE_WRITTEN = 463,            /* "DATE-WRITTEN"  */
    DAY = 464,                     /* DAY  */
    DAY_OF_WEEK = 465,             /* "DAY-OF-WEEK"  */
    DE = 466,                      /* DE  */
    DEBUGGING = 467,               /* DEBUGGING  */
    DECIMAL_POINT = 468,           /* "DECIMAL-POINT"  */
    DECLARATIVES = 469,            /* DECLARATIVES  */
    DEFAULT = 470,                 /* DEFAULT  */
    DEFAULT_BUTTON = 471,          /* "DEFAULT-BUTTON"  */
    DEFAULT_FONT = 472,            /* "DEFAULT-FONT"  */
    DELETE = 473,                  /* DELETE  */
    DELIMITED = 474,               /* DELIMITED  */
    DELIMITER = 475,               /* DELIMITER  */
    DEPENDING = 476,               /* DEPENDING  */
    DESCENDING = 477,              /* DESCENDING  */
    DESTINATION = 478,             /* DESTINATION  */
    DESTROY = 479,                 /* DESTROY  */
    DETAIL = 480,                  /* DETAIL  */
    DISABLE = 481,                 /* DISABLE  */
    DISC = 482,                    /* DISC  */
    DISK = 483,                    /* DISK  */
    DISP = 484,                    /* DISP  */
    DISPLAY = 485,                 /* DISPLAY  */
    DISPLAY_COLUMNS = 486,         /* "DISPLAY-COLUMNS"  */
    DISPLAY_FORMAT = 487,          /* "DISPLAY-FORMAT"  */
    DISPLAY_OF_FUNC = 488,         /* "FUNCTION DISPLAY-OF"  */
    DIVIDE = 489,                  /* DIVIDE  */
    DIVIDERS = 490,                /* DIVIDERS  */
    DIVIDER_COLOR = 491,           /* "DIVIDER-COLOR"  */
    DIVISION = 492,                /* DIVISION  */
    DOTDASH = 493,                 /* DOTDASH  */
    DOTTED = 494,                  /* DOTTED  */
    DRAG_COLOR = 495,              /* "DRAG-COLOR"  */
    DROP_DOWN = 496,               /* "DROP-DOWN"  */
    DROP_LIST = 497,               /* "DROP-LIST"  */
    DOWN = 498,                    /* DOWN  */
    DUPLICATES = 499,              /* DUPLICATES  */
    DYNAMIC = 500,                 /* DYNAMIC  */
    EBCDIC = 501,                  /* EBCDIC  */
    EC = 502,                      /* EC  */
    ECHO = 503,                    /* ECHO  */
    EGI = 504,                     /* EGI  */
    EIGHTY_EIGHT = 505,            /* "level-number 88"  */
    ENABLE = 506,                  /* ENABLE  */
    ELEMENT = 507,                 /* ELEMENT  */
    ELSE = 508,                    /* ELSE  */
    EMI = 509,                     /* EMI  */
    ENCRYPTION = 510,              /* ENCRYPTION  */
    ENCODING = 511,                /* ENCODING  */
    END = 512,                     /* END  */
    END_ACCEPT = 513,              /* "END-ACCEPT"  */
    END_ADD = 514,                 /* "END-ADD"  */
    END_CALL = 515,                /* "END-CALL"  */
    END_COMPUTE = 516,             /* "END-COMPUTE"  */
    END_COLOR = 517,               /* "END-COLOR"  */
    END_DELETE = 518,              /* "END-DELETE"  */
    END_DISPLAY = 519,             /* "END-DISPLAY"  */
    END_DIVIDE = 520,              /* "END-DIVIDE"  */
    END_EVALUATE = 521,            /* "END-EVALUATE"  */
    END_FUNCTION = 522,            /* "END FUNCTION"  */
    END_IF = 523,                  /* "END-IF"  */
    END_JSON = 524,                /* "END-JSON"  */
    END_MODIFY = 525,              /* "END-MODIFY"  */
    END_MULTIPLY = 526,            /* "END-MULTIPLY"  */
    END_PERFORM = 527,             /* "END-PERFORM"  */
    END_PROGRAM = 528,             /* "END PROGRAM"  */
    END_READ = 529,                /* "END-READ"  */
    END_RECEIVE = 530,             /* "END-RECEIVE"  */
    END_RETURN = 531,              /* "END-RETURN"  */
    END_REWRITE = 532,             /* "END-REWRITE"  */
    END_SEARCH = 533,              /* "END-SEARCH"  */
    END_SEND = 534,                /* "END-SEND"  */
    END_START = 535,               /* "END-START"  */
    END_STRING = 536,              /* "END-STRING"  */
    END_SUBTRACT = 537,            /* "END-SUBTRACT"  */
    END_UNSTRING = 538,            /* "END-UNSTRING"  */
    END_WRITE = 539,               /* "END-WRITE"  */
    END_XML = 540,                 /* "END-XML"  */
    ENGRAVED = 541,                /* ENGRAVED  */
    ENSURE_VISIBLE = 542,          /* "ENSURE-VISIBLE"  */
    ENTRY = 543,                   /* ENTRY  */
    ENTRY_CONVENTION = 544,        /* "ENTRY-CONVENTION"  */
    ENTRY_FIELD = 545,             /* "ENTRY-FIELD"  */
    ENTRY_REASON = 546,            /* "ENTRY-REASON"  */
    ENVIRONMENT = 547,             /* ENVIRONMENT  */
    ENVIRONMENT_NAME = 548,        /* "ENVIRONMENT-NAME"  */
    ENVIRONMENT_VALUE = 549,       /* "ENVIRONMENT-VALUE"  */
    EOL = 550,                     /* EOL  */
    EOP = 551,                     /* EOP  */
    EOS = 552,                     /* EOS  */
    EQUAL = 553,                   /* EQUAL  */
    ERASE = 554,                   /* ERASE  */
    ERROR = 555,                   /* ERROR  */
    ESCAPE = 556,                  /* ESCAPE  */
    ESCAPE_BUTTON = 557,           /* "ESCAPE-BUTTON"  */
    ESI = 558,                     /* ESI  */
    EVALUATE = 559,                /* EVALUATE  */
    EVENT = 560,                   /* EVENT  */
    EVENT_LIST = 561,              /* "EVENT-LIST"  */
    EVENT_STATUS = 562,            /* "EVENT STATUS"  */
    EVERY = 563,                   /* EVERY  */
    EXAMINE = 564,                 /* EXAMINE  */
    EXCEPTION = 565,               /* EXCEPTION  */
    EXCEPTION_CONDITION = 566,     /* "EXCEPTION CONDITION"  */
    EXCEPTION_VALUE = 567,         /* "EXCEPTION-VALUE"  */
    EXPAND = 568,                  /* EXPAND  */
    EXCLUSIVE = 569,               /* EXCLUSIVE  */
    EXHIBIT = 570,                 /* EXHIBIT  */
    EXIT = 571,                    /* EXIT  */
    EXPONENTIATION = 572,          /* "exponentiation operator"  */
    EXTEND = 573,                  /* EXTEND  */
    EXTENDED_SEARCH = 574,         /* "EXTENDED-SEARCH"  */
    EXTERNAL = 575,                /* EXTERNAL  */
    EXTERNAL_FORM = 576,           /* "EXTERNAL-FORM"  */
    F = 577,                       /* F  */
    FACTORY = 578,                 /* FACTORY  */
    FD = 579,                      /* FD  */
    FH__FCD = 580,                 /* "FH--FCD"  */
    FH__KEYDEF = 581,              /* "FH--KEYDEF"  */
    FILE_CONTROL = 582,            /* "FILE-CONTROL"  */
    FILE_ID = 583,                 /* "FILE-ID"  */
    FILE_LIMIT = 584,              /* "FILE-LIMIT"  */
    FILE_LIMITS = 585,             /* "FILE-LIMITS"  */
    FILE_NAME = 586,               /* "FILE-NAME"  */
    FILE_POS = 587,                /* "FILE-POS"  */
    FILL_COLOR = 588,              /* "FILL-COLOR"  */
    FILL_COLOR2 = 589,             /* "FILL-COLOR2"  */
    FILL_PERCENT = 590,            /* "FILL-PERCENT"  */
    FILLER = 591,                  /* FILLER  */
    FINAL = 592,                   /* FINAL  */
    FINISH_REASON = 593,           /* "FINISH-REASON"  */
    FIRST = 594,                   /* FIRST  */
    FIXED = 595,                   /* FIXED  */
    FIXED_FONT = 596,              /* "FIXED-FONT"  */
    FIXED_WIDTH = 597,             /* "FIXED-WIDTH"  */
    FLAT = 598,                    /* FLAT  */
    FLAT_BUTTONS = 599,            /* "FLAT-BUTTONS"  */
    FLOAT_BINARY_128 = 600,        /* "FLOAT-BINARY-128"  */
    FLOAT_BINARY_32 = 601,         /* "FLOAT-BINARY-32"  */
    FLOAT_BINARY_64 = 602,         /* "FLOAT-BINARY-64"  */
    FLOAT_DECIMAL_16 = 603,        /* "FLOAT-DECIMAL-16"  */
    FLOAT_DECIMAL_34 = 604,        /* "FLOAT-DECIMAL-34"  */
    FLOAT_DECIMAL_7 = 605,         /* "FLOAT-DECIMAL-7"  */
    FLOAT_EXTENDED = 606,          /* "FLOAT-EXTENDED"  */
    FLOAT_LONG = 607,              /* "FLOAT-LONG"  */
    FLOAT_SHORT = 608,             /* "FLOAT-SHORT"  */
    FLOATING = 609,                /* FLOATING  */
    FONT = 610,                    /* FONT  */
    FOOTING = 611,                 /* FOOTING  */
    FOR = 612,                     /* FOR  */
    FOREGROUND_COLOR = 613,        /* "FOREGROUND-COLOR"  */
    FOREVER = 614,                 /* FOREVER  */
    FORMAT = 615,                  /* FORMAT  */
    FORMATTED_DATE_FUNC = 616,     /* "FUNCTION FORMATTED-DATE"  */
    FORMATTED_DATETIME_FUNC = 617, /* "FUNCTION FORMATTED-DATETIME"  */
    FORMATTED_TIME_FUNC = 618,     /* "FUNCTION FORMATTED-TIME"  */
    FRAME = 619,                   /* FRAME  */
    FRAMED = 620,                  /* FRAMED  */
    FREE = 621,                    /* FREE  */
    FROM = 622,                    /* FROM  */
    FROM_CRT = 623,                /* "FROM CRT"  */
    FULL = 624,                    /* FULL  */
    FULL_HEIGHT = 625,             /* "FULL-HEIGHT"  */
    FUNCTION = 626,                /* FUNCTION  */
    FUNCTION_ID = 627,             /* "FUNCTION-ID"  */
    FUNCTION_NAME = 628,           /* "intrinsic function name"  */
    GENERATE = 629,                /* GENERATE  */
    GIVING = 630,                  /* GIVING  */
    GLOBAL = 631,                  /* GLOBAL  */
    GO = 632,                      /* GO  */
    GO_BACK = 633,                 /* "GO-BACK"  */
    GO_FORWARD = 634,              /* "GO-FORWARD"  */
    GO_HOME = 635,                 /* "GO-HOME"  */
    GO_SEARCH = 636,               /* "GO-SEARCH"  */
    GOBACK = 637,                  /* GOBACK  */
    GRAPHICAL = 638,               /* GRAPHICAL  */
    GREATER = 639,                 /* GREATER  */
    GREATER_OR_EQUAL = 640,        /* "GREATER OR EQUAL"  */
    GRID = 641,                    /* GRID  */
    GROUP = 642,                   /* GROUP  */
    GROUP_VALUE = 643,             /* "GROUP-VALUE"  */
    HANDLE = 644,                  /* HANDLE  */
    HAS_CHILDREN = 645,            /* "HAS-CHILDREN"  */
    HEADING = 646,                 /* HEADING  */
    HEADING_COLOR = 647,           /* "HEADING-COLOR"  */
    HEADING_DIVIDER_COLOR = 648,   /* "HEADING-DIVIDER-COLOR"  */
    HEADING_FONT = 649,            /* "HEADING-FONT"  */
    HEAVY = 650,                   /* HEAVY  */
    HEIGHT_IN_CELLS = 651,         /* "HEIGHT-IN-CELLS"  */
    HIDDEN_DATA = 652,             /* "HIDDEN-DATA"  */
    HIGHLIGHT = 653,               /* HIGHLIGHT  */
    HIGH_COLOR = 654,              /* "HIGH-COLOR"  */
    HIGH_VALUE = 655,              /* "HIGH-VALUE"  */
    HOT_TRACK = 656,               /* "HOT-TRACK"  */
    HSCROLL = 657,                 /* HSCROLL  */
    HSCROLL_POS = 658,             /* "HSCROLL-POS"  */
    ICON = 659,                    /* ICON  */
    ID = 660,                      /* ID  */
    IDENTIFIED = 661,              /* IDENTIFIED  */
    IDENTIFICATION = 662,          /* IDENTIFICATION  */
    IF = 663,                      /* IF  */
    IGNORE = 664,                  /* IGNORE  */
    IGNORING = 665,                /* IGNORING  */
    IN = 666,                      /* IN  */
    INDEPENDENT = 667,             /* INDEPENDENT  */
    INDEX = 668,                   /* INDEX  */
    INDEXED = 669,                 /* INDEXED  */
    INDICATE = 670,                /* INDICATE  */
    INITIALIZE = 671,              /* INITIALIZE  */
    INITIALIZED = 672,             /* INITIALIZED  */
    INITIATE = 673,                /* INITIATE  */
    INPUT = 674,                   /* INPUT  */
    INPUT_OUTPUT = 675,            /* "INPUT-OUTPUT"  */
    INQUIRE = 676,                 /* INQUIRE  */
    INSERTION_INDEX = 677,         /* "INSERTION-INDEX"  */
    INSERT_ROWS = 678,             /* "INSERT-ROWS"  */
    INSPECT = 679,                 /* INSPECT  */
    INSTALLATION = 680,            /* INSTALLATION  */
    INTERMEDIATE = 681,            /* INTERMEDIATE  */
    INTO = 682,                    /* INTO  */
    INTRINSIC = 683,               /* INTRINSIC  */
    INVALID = 684,                 /* INVALID  */
    INVALID_KEY = 685,             /* "INVALID KEY"  */
    IS = 686,                      /* IS  */
    ITEM = 687,                    /* ITEM  */
    ITEM_TEXT = 688,               /* "ITEM-TEXT"  */
    ITEM_TO_ADD = 689,             /* "ITEM-TO_ADD"  */
    ITEM_TO_DELETE = 690,          /* "ITEM-TO_DELETE"  */
    ITEM_TO_EMPTY = 691,           /* "ITEM-TO_EMPTY"  */
    ITEM_VALUE = 692,              /* "ITEM-VALUE"  */
    I_O = 693,                     /* "I-O"  */
    I_O_CONTROL = 694,             /* "I-O-CONTROL"  */
    JSON = 695,                    /* JSON  */
    JUSTIFIED = 696,               /* JUSTIFIED  */
    KEPT = 697,                    /* KEPT  */
    KEY = 698,                     /* KEY  */
    KEYBOARD = 699,                /* KEYBOARD  */
    LABEL = 700,                   /* LABEL  */
    LABEL_OFFSET = 701,            /* "LABEL-OFFSET"  */
    LARGE_FONT = 702,              /* "LARGE-FONT"  */
    LARGE_OFFSET = 703,            /* "LARGE-OFFSET"  */
    LAST = 704,                    /* LAST  */
    LAST_ROW = 705,                /* "LAST-ROW"  */
    LAYOUT_DATA = 706,             /* "LAYOUT-DATA"  */
    LAYOUT_MANAGER = 707,          /* "LAYOUT-MANAGER"  */
    LEADING = 708,                 /* LEADING  */
    LEADING_SHIFT = 709,           /* "LEADING-SHIFT"  */
    LEAVE = 710,                   /* LEAVE  */
    LEFT = 711,                    /* LEFT  */
    LEFTLINE = 712,                /* LEFTLINE  */
    LEFT_TEXT = 713,               /* "LEFT-TEXT"  */
    LENGTH = 714,                  /* LENGTH  */
    LENGTH_OF = 715,               /* "LENGTH OF"  */
    LENGTH_FUNC = 716,             /* "FUNCTION LENGTH/BYTE-LENGTH"  */
    LESS = 717,                    /* LESS  */
    LESS_OR_EQUAL = 718,           /* "LESS OR EQUAL"  */
    LEVEL_NUMBER = 719,            /* "level-number"  */
    LIKE = 720,                    /* LIKE  */
    LIMIT = 721,                   /* LIMIT  */
    LIMITS = 722,                  /* LIMITS  */
    LINAGE = 723,                  /* LINAGE  */
    LINAGE_COUNTER = 724,          /* "LINAGE-COUNTER"  */
    LINE = 725,                    /* LINE  */
    LINE_COUNTER = 726,            /* "LINE-COUNTER"  */
    LINE_LIMIT = 727,              /* "LINE LIMIT"  */
    LINE_SEQUENTIAL = 728,         /* "LINE-SEQUENTIAL"  */
    LINES = 729,                   /* LINES  */
    LINES_AT_ROOT = 730,           /* "LINES-AT-ROOT"  */
    LINKAGE = 731,                 /* LINKAGE  */
    LIST_BOX = 732,                /* "LIST-BOX"  */
    LITERAL = 733,                 /* "Literal"  */
    LM_RESIZE = 734,               /* "LM-RESIZE"  */
    LOC = 735,                     /* LOC  */
    LOCALE = 736,                  /* LOCALE  */
    LOCALE_DATE_FUNC = 737,        /* "FUNCTION LOCALE-DATE"  */
    LOCALE_TIME_FUNC = 738,        /* "FUNCTION LOCALE-TIME"  */
    LOCALE_TIME_FROM_FUNC = 739,   /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
    LOCAL_STORAGE = 740,           /* "LOCAL-STORAGE"  */
    LOCK = 741,                    /* LOCK  */
    LOCK_HOLDING = 742,            /* "LOCK-HOLDING"  */
    LONG_DATE = 743,               /* "LONG-DATE"  */
    LOWER = 744,                   /* LOWER  */
    LOWERED = 745,                 /* LOWERED  */
    LOWER_CASE_FUNC = 746,         /* "FUNCTION LOWER-CASE"  */
    LOWLIGHT = 747,                /* LOWLIGHT  */
    LOW_COLOR = 748,               /* "LOW-COLOR"  */
    LOW_VALUE = 749,               /* "LOW-VALUE"  */
    MAGNETIC_TAPE = 750,           /* "MAGNETIC-TAPE"  */
    MANUAL = 751,                  /* MANUAL  */
    MASS_UPDATE = 752,             /* "MASS-UPDATE"  */
    MASTER_INDEX = 753,            /* "MASTER-INDEX"  */
    MAX_LINES = 754,               /* "MAX-LINES"  */
    MAX_PROGRESS = 755,            /* "MAX-PROGRESS"  */
    MAX_TEXT = 756,                /* "MAX-TEXT"  */
    MAX_VAL = 757,                 /* "MAX-VAL"  */
    MEMORY = 758,                  /* MEMORY  */
    MEDIUM_FONT = 759,             /* "MEDIUM-FONT"  */
    MENU = 760,                    /* MENU  */
    MERGE = 761,                   /* MERGE  */
    MESSAGE = 762,                 /* MESSAGE  */
    MICROSECOND_TIME = 763,        /* "MICROSECOND-TIME"  */
    MINUS = 764,                   /* MINUS  */
    MIN_VAL = 765,                 /* "MIN-VAL"  */
    MNEMONIC_NAME = 766,           /* "Mnemonic name"  */
    MODE = 767,                    /* MODE  */
    MODIFY = 768,                  /* MODIFY  */
    MODULES = 769,                 /* MODULES  */
    MOVE = 770,                    /* MOVE  */
    MULTILINE = 771,               /* MULTILINE  */
    MULTIPLE = 772,                /* MULTIPLE  */
    MULTIPLY = 773,                /* MULTIPLY  */
    NAME = 774,                    /* NAME  */
    NAMED = 775,                   /* NAMED  */
    NAMESPACE = 776,               /* NAMESPACE  */
    NAMESPACE_PREFIX = 777,        /* "NAMESPACE-PREFIX"  */
    NATIONAL = 778,                /* NATIONAL  */
    NATIONAL_EDITED = 779,         /* "NATIONAL-EDITED"  */
    NATIONAL_OF_FUNC = 780,        /* "FUNCTION NATIONAL-OF"  */
    NATIVE = 781,                  /* NATIVE  */
    NAVIGATE_URL = 782,            /* "NAVIGATE-URL"  */
    NEAREST_AWAY_FROM_ZERO = 783,  /* "NEAREST-AWAY-FROM-ZERO"  */
    NEAREST_EVEN = 784,            /* "NEAREST-EVEN"  */
    NEAREST_TOWARD_ZERO = 785,     /* "NEAREST-TOWARD-ZERO"  */
    NEGATIVE = 786,                /* NEGATIVE  */
    NESTED = 787,                  /* NESTED  */
    NEW = 788,                     /* NEW  */
    NEXT = 789,                    /* NEXT  */
    NEXT_ITEM = 790,               /* "NEXT-ITEM"  */
    NEXT_GROUP = 791,              /* "NEXT GROUP"  */
    NEXT_PAGE = 792,               /* "NEXT PAGE"  */
    NO = 793,                      /* NO  */
    NO_ADVANCING = 794,            /* "NO ADVANCING"  */
    NO_AUTOSEL = 795,              /* "NO-AUTOSEL"  */
    NO_AUTO_DEFAULT = 796,         /* "NO-AUTO-DEFAULT"  */
    NO_BOX = 797,                  /* "NO-BOX"  */
    NO_DATA = 798,                 /* "NO DATA"  */
    NO_DIVIDERS = 799,             /* "NO-DIVIDERS"  */
    NO_ECHO = 800,                 /* "NO-ECHO"  */
    NO_F4 = 801,                   /* "NO-F4"  */
    NO_FOCUS = 802,                /* "NO-FOCUS"  */
    NO_GROUP_TAB = 803,            /* "NO-GROUP-TAB"  */
    NO_KEY_LETTER = 804,           /* "NO-KEY-LETTER"  */
    NO_SEARCH = 805,               /* "NO-SEARCH"  */
    NO_UPDOWN = 806,               /* "NO-UPDOWN"  */
    NOMINAL = 807,                 /* NOMINAL  */
    NONE = 808,                    /* NONE  */
    NONNUMERIC = 809,              /* NONNUMERIC  */
    NORMAL = 810,                  /* NORMAL  */
    NOT = 811,                     /* NOT  */
    NOTAB = 812,                   /* NOTAB  */
    NOTHING = 813,                 /* NOTHING  */
    NOTIFY = 814,                  /* NOTIFY  */
    NOTIFY_CHANGE = 815,           /* "NOTIFY-CHANGE"  */
    NOTIFY_DBLCLICK = 816,         /* "NOTIFY-DBLCLICK"  */
    NOTIFY_SELCHANGE = 817,        /* "NOTIFY-SELCHANGE"  */
    NOT_AT_END = 818,              /* "NOT AT END"  */
    NOT_EOP = 819,                 /* "NOT AT EOP"  */
    NOT_ON_ESCAPE = 820,           /* "NOT ON ESCAPE"  */
    NOT_EQUAL = 821,               /* "NOT EQUAL"  */
    NOT_ON_EXCEPTION = 822,        /* "NOT ON EXCEPTION"  */
    NOT_INVALID_KEY = 823,         /* "NOT INVALID KEY"  */
    NOT_ON_OVERFLOW = 824,         /* "NOT ON OVERFLOW"  */
    NOT_SIZE_ERROR = 825,          /* "NOT SIZE ERROR"  */
    NUM_COL_HEADINGS = 826,        /* "NUM-COL-HEADINGS"  */
    NUM_ROWS = 827,                /* "NUM-ROWS"  */
    NUMBER = 828,                  /* NUMBER  */
    NUMBERS = 829,                 /* NUMBERS  */
    NUMERIC = 830,                 /* NUMERIC  */
    NUMERIC_EDITED = 831,          /* "NUMERIC-EDITED"  */
    NUMVALC_FUNC = 832,            /* "FUNCTION NUMVAL-C"  */
    OBJECT = 833,                  /* OBJECT  */
    OBJECT_COMPUTER = 834,         /* "OBJECT-COMPUTER"  */
    OCCURS = 835,                  /* OCCURS  */
    OF = 836,                      /* OF  */
    OFF = 837,                     /* OFF  */
    OK_BUTTON = 838,               /* "OK-BUTTON"  */
    OMITTED = 839,                 /* OMITTED  */
    ON = 840,                      /* ON  */
    ONLY = 841,                    /* ONLY  */
    ON_ESCAPE = 842,               /* "ON ESCAPE"  */
    ON_EXCEPTION = 843,            /* "ON EXCEPTION"  */
    OPEN = 844,                    /* OPEN  */
    OPTIONAL = 845,                /* OPTIONAL  */
    OPTIONS = 846,                 /* OPTIONS  */
    OR = 847,                      /* OR  */
    ORDER = 848,                   /* ORDER  */
    ORGANIZATION = 849,            /* ORGANIZATION  */
    OTHER = 850,                   /* OTHER  */
    OTHERS = 851,                  /* OTHERS  */
    OUTPUT = 852,                  /* OUTPUT  */
    OVERLAP_LEFT = 853,            /* "OVERLAP-LEFT"  */
    OVERLAP_TOP = 854,             /* "OVERLAP-TOP"  */
    OVERLINE = 855,                /* OVERLINE  */
    PACKED_DECIMAL = 856,          /* "PACKED-DECIMAL"  */
    PADDING = 857,                 /* PADDING  */
    PASCAL = 858,                  /* PASCAL  */
    PAGE = 859,                    /* PAGE  */
    PAGE_COUNTER = 860,            /* "PAGE-COUNTER"  */
    PAGE_SETUP = 861,              /* "PAGE-SETUP"  */
    PAGED = 862,                   /* PAGED  */
    PARAGRAPH = 863,               /* PARAGRAPH  */
    PARENT = 864,                  /* PARENT  */
    PARSE = 865,                   /* PARSE  */
    PASSWORD = 866,                /* PASSWORD  */
    PERFORM = 867,                 /* PERFORM  */
    PERMANENT = 868,               /* PERMANENT  */
    PH = 869,                      /* PH  */
    PF = 870,                      /* PF  */
    PHYSICAL = 871,                /* PHYSICAL  */
    PICTURE = 872,                 /* PICTURE  */
    PICTURE_SYMBOL = 873,          /* "PICTURE SYMBOL"  */
    PIXEL = 874,                   /* PIXEL  */
    PLACEMENT = 875,               /* PLACEMENT  */
    PLUS = 876,                    /* PLUS  */
    POINTER = 877,                 /* POINTER  */
    POP_UP = 878,                  /* "POP-UP"  */
    POS = 879,                     /* POS  */
    POSITION = 880,                /* POSITION  */
    POSITION_SHIFT = 881,          /* "POSITION-SHIFT"  */
    POSITIVE = 882,                /* POSITIVE  */
    PRESENT = 883,                 /* PRESENT  */
    PREVIOUS = 884,                /* PREVIOUS  */
    PRINT = 885,                   /* PRINT  */
    PRINT_CONTROL = 886,           /* "PRINT-CONTROL"  */
    PRINT_NO_PROMPT = 887,         /* "PRINT-NO-PROMPT"  */
    PRINT_PREVIEW = 888,           /* "PRINT-PREVIEW"  */
    PRINTER = 889,                 /* PRINTER  */
    PRINTER_1 = 890,               /* "PRINTER-1"  */
    PRINTING = 891,                /* PRINTING  */
    PRIORITY = 892,                /* PRIORITY  */
    PROCEDURE = 893,               /* PROCEDURE  */
    PROCEDURES = 894,              /* PROCEDURES  */
    PROCEED = 895,                 /* PROCEED  */
    PROCESSING = 896,              /* PROCESSING  */
    PROGRAM = 897,                 /* PROGRAM  */
    PROGRAM_ID = 898,              /* "PROGRAM-ID"  */
    PROGRAM_NAME = 899,            /* "program name"  */
    PROGRAM_POINTER = 900,         /* "PROGRAM-POINTER"  */
    PROGRESS = 901,                /* PROGRESS  */
    PROHIBITED = 902,              /* PROHIBITED  */
    PROMPT = 903,                  /* PROMPT  */
    PROPERTIES = 904,              /* PROPERTIES  */
    PROPERTY = 905,                /* PROPERTY  */
    PROTECTED = 906,               /* PROTECTED  */
    PROTOTYPE = 907,               /* PROTOTYPE  */
    PURGE = 908,                   /* PURGE  */
    PUSH_BUTTON = 909,             /* "PUSH-BUTTON"  */
    QUERY_INDEX = 910,             /* "QUERY-INDEX"  */
    QUEUE = 911,                   /* QUEUE  */
    QUOTE = 912,                   /* QUOTE  */
    RADIO_BUTTON = 913,            /* "RADIO-BUTTON"  */
    RAISE = 914,                   /* RAISE  */
    RAISED = 915,                  /* RAISED  */
    RAISING = 916,                 /* RAISING  */
    RANDOM = 917,                  /* RANDOM  */
    RD = 918,                      /* RD  */
    READ = 919,                    /* READ  */
    READERS = 920,                 /* READERS  */
    READ_ONLY = 921,               /* "READ-ONLY"  */
    READY_TRACE = 922,             /* "READY TRACE"  */
    RECEIVE = 923,                 /* RECEIVE  */
    RECEIVED = 924,                /* RECEIVED  */
    RECORD = 925,                  /* RECORD  */
    RECORD_DATA = 926,             /* "RECORD-DATA"  */
    RECORD_OVERFLOW = 927,         /* "RECORD-OVERFLOW"  */
    RECORD_TO_ADD = 928,           /* "RECORD-TO-ADD"  */
    RECORD_TO_DELETE = 929,        /* "RECORD-TO-DELETE"  */
    RECORDING = 930,               /* RECORDING  */
    RECORDS = 931,                 /* RECORDS  */
    RECURSIVE = 932,               /* RECURSIVE  */
    REDEFINES = 933,               /* REDEFINES  */
    REEL = 934,                    /* REEL  */
    REFERENCE = 935,               /* REFERENCE  */
    REFERENCES = 936,              /* REFERENCES  */
    REFRESH = 937,                 /* REFRESH  */
    REGION_COLOR = 938,            /* "REGION-COLOR"  */
    RELATION = 939,                /* RELATION  */
    RELATIVE = 940,                /* RELATIVE  */
    RELEASE = 941,                 /* RELEASE  */
    REMAINDER = 942,               /* REMAINDER  */
    REMARKS = 943,                 /* REMARKS  */
    REMOVAL = 944,                 /* REMOVAL  */
    RENAMES = 945,                 /* RENAMES  */
    REORG_CRITERIA = 946,          /* "REORG-CRITERIA"  */
    REPEATED = 947,                /* REPEATED  */
    REPLACE = 948,                 /* REPLACE  */
    REPLACING = 949,               /* REPLACING  */
    REPORT = 950,                  /* REPORT  */
    REPORTING = 951,               /* REPORTING  */
    REPORTS = 952,                 /* REPORTS  */
    REPOSITORY = 953,              /* REPOSITORY  */
    REQUIRED = 954,                /* REQUIRED  */
    REREAD = 955,                  /* REREAD  */
    RERUN = 956,                   /* RERUN  */
    RESERVE = 957,                 /* RESERVE  */
    RESET = 958,                   /* RESET  */
    RESET_TRACE = 959,             /* "RESET TRACE"  */
    RESET_GRID = 960,              /* "RESET-GRID"  */
    RESET_LIST = 961,              /* "RESET-LIST"  */
    RESET_TABS = 962,              /* "RESET-TABS"  */
    RETRY = 963,                   /* RETRY  */
    RETURN = 964,                  /* RETURN  */
    RETURNING = 965,               /* RETURNING  */
    REVERSE = 966,                 /* REVERSE  */
    REVERSE_FUNC = 967,            /* "FUNCTION REVERSE"  */
    REVERSE_VIDEO = 968,           /* "REVERSE-VIDEO"  */
    REVERSED = 969,                /* REVERSED  */
    REWIND = 970,                  /* REWIND  */
    REWRITE = 971,                 /* REWRITE  */
    RF = 972,                      /* RF  */
    RH = 973,                      /* RH  */
    RIGHT = 974,                   /* RIGHT  */
    RIGHT_ALIGN = 975,             /* "RIGHT-ALIGN"  */
    RIMMED = 976,                  /* RIMMED  */
    ROLLBACK = 977,                /* ROLLBACK  */
    ROUNDED = 978,                 /* ROUNDED  */
    ROUNDING = 979,                /* ROUNDING  */
    ROW_COLOR = 980,               /* "ROW-COLOR"  */
    ROW_COLOR_PATTERN = 981,       /* "ROW-COLOR-PATTERN"  */
    ROW_DIVIDERS = 982,            /* "ROW-DIVIDERS"  */
    ROW_FONT = 983,                /* "ROW-FONT"  */
    ROW_HEADINGS = 984,            /* "ROW-HEADINGS"  */
    ROW_PROTECTION = 985,          /* "ROW-PROTECTION"  */
    RUN = 986,                     /* RUN  */
    S = 987,                       /* S  */
    SAME = 988,                    /* SAME  */
    SAVE_AS = 989,                 /* "SAVE-AS"  */
    SAVE_AS_NO_PROMPT = 990,       /* "SAVE-AS-NO-PROMPT"  */
    SCREEN = 991,                  /* SCREEN  */
    SCREEN_CONTROL = 992,          /* "SCREEN CONTROL"  */
    SCROLL = 993,                  /* SCROLL  */
    SCROLL_BAR = 994,              /* "SCROLL-BAR"  */
    SD = 995,                      /* SD  */
    SEARCH = 996,                  /* SEARCH  */
    SEARCH_OPTIONS = 997,          /* "SEARCH-OPTIONS"  */
    SEARCH_TEXT = 998,             /* "SEARCH-TEXT"  */
    SECONDS = 999,                 /* SECONDS  */
    SECTION = 1000,                /* SECTION  */
    SECURE = 1001,                 /* SECURE  */
    SECURITY = 1002,               /* SECURITY  */
    SEGMENT = 1003,                /* SEGMENT  */
    SEGMENT_LIMIT = 1004,          /* "SEGMENT-LIMIT"  */
    SELECT = 1005,                 /* SELECT  */
    SELECTION_INDEX = 1006,        /* "SELECTION-INDEX"  */
    SELECTION_TEXT = 1007,         /* "SELECTION-TEXT"  */
    SELECT_ALL = 1008,             /* "SELECTION-ALL"  */
    SELF_ACT = 1009,               /* "SELF-ACT"  */
    SEMI_COLON = 1010,             /* "semi-colon"  */
    SEND = 1011,                   /* SEND  */
    SENTENCE = 1012,               /* SENTENCE  */
    SEPARATE = 1013,               /* SEPARATE  */
    SEPARATION = 1014,             /* SEPARATION  */
    SEQUENCE = 1015,               /* SEQUENCE  */
    SEQUENTIAL = 1016,             /* SEQUENTIAL  */
    SET = 1017,                    /* SET  */
    SEVENTY_EIGHT = 1018,          /* "level-number 78"  */
    SHADING = 1019,                /* SHADING  */
    SHADOW = 1020,                 /* SHADOW  */
    SHARING = 1021,                /* SHARING  */
    SHORT_DATE = 1022,             /* "SHORT-DATE"  */
    SHOW_LINES = 1023,             /* "SHOW-LINES"  */
    SHOW_NONE = 1024,              /* "SHOW-NONE"  */
    SHOW_SEL_ALWAYS = 1025,        /* "SHOW-SEL-ALWAYS"  */
    SIGN = 1026,                   /* SIGN  */
    SIGNED = 1027,                 /* SIGNED  */
    SIGNED_INT = 1028,             /* "SIGNED-INT"  */
    SIGNED_LONG = 1029,            /* "SIGNED-LONG"  */
    SIGNED_SHORT = 1030,           /* "SIGNED-SHORT"  */
    SIXTY_SIX = 1031,              /* "level-number 66"  */
    SIZE = 1032,                   /* SIZE  */
    SIZE_ERROR = 1033,             /* "SIZE ERROR"  */
    SMALL_FONT = 1034,             /* "SMALL-FONT"  */
    SORT = 1035,                   /* SORT  */
    SORT_MERGE = 1036,             /* "SORT-MERGE"  */
    SORT_ORDER = 1037,             /* "SORT-ORDER"  */
    SOURCE = 1038,                 /* SOURCE  */
    SOURCE_COMPUTER = 1039,        /* "SOURCE-COMPUTER"  */
    SPACE = 1040,                  /* SPACE  */
    SPECIAL_NAMES = 1041,          /* "SPECIAL-NAMES"  */
    SPINNER = 1042,                /* SPINNER  */
    SQUARE = 1043,                 /* SQUARE  */
    STANDARD = 1044,               /* STANDARD  */
    STANDARD_1 = 1045,             /* "STANDARD-1"  */
    STANDARD_2 = 1046,             /* "STANDARD-2"  */
    STANDARD_BINARY = 1047,        /* "STANDARD-BINARY"  */
    STANDARD_DECIMAL = 1048,       /* "STANDARD-DECIMAL"  */
    START = 1049,                  /* START  */
    START_X = 1050,                /* "START-X"  */
    START_Y = 1051,                /* "START-Y"  */
    STATIC = 1052,                 /* STATIC  */
    STATIC_LIST = 1053,            /* "STATIC-LIST"  */
    STATUS = 1054,                 /* STATUS  */
    STATUS_BAR = 1055,             /* "STATUS-BAR"  */
    STATUS_TEXT = 1056,            /* "STATUS-TEXT"  */
    STDCALL = 1057,                /* STDCALL  */
    STEP = 1058,                   /* STEP  */
    STOP = 1059,                   /* STOP  */
    STRING = 1060,                 /* STRING  */
    STRONG = 1061,                 /* STRONG  */
    STYLE = 1062,                  /* STYLE  */
    SUB_QUEUE_1 = 1063,            /* "SUB-QUEUE-1"  */
    SUB_QUEUE_2 = 1064,            /* "SUB-QUEUE-2"  */
    SUB_QUEUE_3 = 1065,            /* "SUB-QUEUE-3"  */
    SUBSTITUTE_FUNC = 1066,        /* "FUNCTION SUBSTITUTE"  */
    SUBSTITUTE_CASE_FUNC = 1067,   /* "FUNCTION SUBSTITUTE-CASE"  */
    SUBTRACT = 1068,               /* SUBTRACT  */
    SUBWINDOW = 1069,              /* SUBWINDOW  */
    SUM = 1070,                    /* SUM  */
    SUPPRESS = 1071,               /* SUPPRESS  */
    SUPPRESS_XML = 1072,           /* "SUPPRESS"  */
    SYMBOLIC = 1073,               /* SYMBOLIC  */
    SYNCHRONIZED = 1074,           /* SYNCHRONIZED  */
    SYSTEM_DEFAULT = 1075,         /* "SYSTEM-DEFAULT"  */
    SYSTEM_INFO = 1076,            /* "SYSTEM-INFO"  */
    SYSTEM_OFFSET = 1077,          /* "SYSTEM-OFFSET"  */
    TAB = 1078,                    /* TAB  */
    TAB_TO_ADD = 1079,             /* "TAB-TO-ADD"  */
    TAB_TO_DELETE = 1080,          /* "TAB-TO-DELETE"  */
    TABLE = 1081,                  /* TABLE  */
    TALLYING = 1082,               /* TALLYING  */
    TEMPORARY = 1083,              /* TEMPORARY  */
    TAPE = 1084,                   /* TAPE  */
    TERMINAL = 1085,               /* TERMINAL  */
    TERMINATE = 1086,              /* TERMINATE  */
    TERMINAL_INFO = 1087,          /* "TERMINAL-INFO"  */
    TERMINATION_VALUE = 1088,      /* "TERMINATION-VALUE"  */
    TEST = 1089,                   /* TEST  */
    TEXT = 1090,                   /* TEXT  */
    THAN = 1091,                   /* THAN  */
    THEN = 1092,                   /* THEN  */
    THREAD = 1093,                 /* THREAD  */
    THREADS = 1094,                /* THREADS  */
    THRU = 1095,                   /* THRU  */
    THUMB_POSITION = 1096,         /* "THUMB-POSITION"  */
    TILED_HEADINGS = 1097,         /* "TILED-HEADINGS"  */
    TIME = 1098,                   /* TIME  */
    TIME_OUT = 1099,               /* "TIME-OUT"  */
    TIMES = 1100,                  /* TIMES  */
    TITLE = 1101,                  /* TITLE  */
    TITLE_POSITION = 1102,         /* "TITLE-POSITION"  */
    TO = 1103,                     /* TO  */
    TOK_AMPER = 1104,              /* "&"  */
    TOK_CLOSE_PAREN = 1105,        /* ")"  */
    TOK_COLON = 1106,              /* ":"  */
    TOK_DIV = 1107,                /* "/"  */
    TOK_DOT = 1108,                /* "."  */
    TOK_EQUAL = 1109,              /* "="  */
    TOK_EXTERN = 1110,             /* "EXTERN"  */
    TOK_FALSE = 1111,              /* "FALSE"  */
    TOK_FILE = 1112,               /* "FILE"  */
    TOK_GREATER = 1113,            /* ">"  */
    TOK_INITIAL = 1114,            /* "INITIAL"  */
    TOK_LESS = 1115,               /* "<"  */
    TOK_MINUS = 1116,              /* "-"  */
    TOK_MUL = 1117,                /* "*"  */
    TOK_NULL = 1118,               /* "NULL"  */
    TOK_OVERFLOW = 1119,           /* "OVERFLOW"  */
    TOK_OPEN_PAREN = 1120,         /* "("  */
    TOK_PLUS = 1121,               /* "+"  */
    TOK_TRUE = 1122,               /* "TRUE"  */
    TOP = 1123,                    /* TOP  */
    TOWARD_GREATER = 1124,         /* "TOWARD-GREATER"  */
    TOWARD_LESSER = 1125,          /* "TOWARD-LESSER"  */
    TRACK = 1126,                  /* TRACK  */
    TRACKS = 1127,                 /* TRACKS  */
    TRACK_AREA = 1128,             /* "TRACK-AREA"  */
    TRACK_LIMIT = 1129,            /* "TRACK-LIMIT"  */
    TRADITIONAL_FONT = 1130,       /* "TRADITIONAL-FONT"  */
    TRAILING = 1131,               /* TRAILING  */
    TRAILING_SHIFT = 1132,         /* "TRAILING-SHIFT"  */
    TRANSFORM = 1133,              /* TRANSFORM  */
    TRANSPARENT = 1134,            /* TRANSPARENT  */
    TREE_VIEW = 1135,              /* "TREE-VIEW"  */
    TRIM_FUNC = 1136,              /* "FUNCTION TRIM"  */
    TRUNCATION = 1137,             /* TRUNCATION  */
    TYPE = 1138,                   /* TYPE  */
    TYPEDEF = 1139,                /* TYPEDEF  */
    U = 1140,                      /* U  */
    UCS_4 = 1141,                  /* "UCS-4"  */
    UNBOUNDED = 1142,              /* UNBOUNDED  */
    UNDERLINE = 1143,              /* UNDERLINE  */
    UNFRAMED = 1144,               /* UNFRAMED  */
    UNIT = 1145,                   /* UNIT  */
    UNLOCK = 1146,                 /* UNLOCK  */
    UNSIGNED = 1147,               /* UNSIGNED  */
    UNSIGNED_INT = 1148,           /* "UNSIGNED-INT"  */
    UNSIGNED_LONG = 1149,          /* "UNSIGNED-LONG"  */
    UNSIGNED_SHORT = 1150,         /* "UNSIGNED-SHORT"  */
    UNSORTED = 1151,               /* UNSORTED  */
    UNSTRING = 1152,               /* UNSTRING  */
    UNTIL = 1153,                  /* UNTIL  */
    UP = 1154,                     /* UP  */
    UPDATE = 1155,                 /* UPDATE  */
    UPDATERS = 1156,               /* UPDATERS  */
    UPON = 1157,                   /* UPON  */
    UPON_ARGUMENT_NUMBER = 1158,   /* "UPON ARGUMENT-NUMBER"  */
    UPON_COMMAND_LINE = 1159,      /* "UPON COMMAND-LINE"  */
    UPON_ENVIRONMENT_NAME = 1160,  /* "UPON ENVIRONMENT-NAME"  */
    UPON_ENVIRONMENT_VALUE = 1161, /* "UPON ENVIRONMENT-VALUE"  */
    UPPER = 1162,                  /* UPPER  */
    UPPER_CASE_FUNC = 1163,        /* "FUNCTION UPPER-CASE"  */
    USAGE = 1164,                  /* USAGE  */
    USE = 1165,                    /* USE  */
    USE_ALT = 1166,                /* "USE-ALT"  */
    USE_RETURN = 1167,             /* "USE-RETURN"  */
    USE_TAB = 1168,                /* "USE-TAB"  */
    USER = 1169,                   /* USER  */
    USER_DEFAULT = 1170,           /* "USER-DEFAULT"  */
    USER_FUNCTION_NAME = 1171,     /* "user function name"  */
    USING = 1172,                  /* USING  */
    UTF_8 = 1173,                  /* "UTF-8"  */
    UTF_16 = 1174,                 /* "UTF-16"  */
    V = 1175,                      /* V  */
    VALID = 1176,                  /* VALID  */
    VALIDATE = 1177,               /* VALIDATE  */
    VAL_STATUS = 1178,             /* "VAL-STATUS"  */
    VALIDATE_STATUS = 1179,        /* "VALIDATE-STATUS"  */
    VALIDATING = 1180,             /* VALIDATING  */
    VALUE = 1181,                  /* VALUE  */
    VALUE_FORMAT = 1182,           /* "VALUE-FORMAT"  */
    VALUES = 1183,                 /* VALUES  */
    VARIABLE = 1184,               /* VARIABLE  */
    VARIANT = 1185,                /* VARIANT  */
    VARYING = 1186,                /* VARYING  */
    VERTICAL = 1187,               /* VERTICAL  */
    VERY_HEAVY = 1188,             /* "VERY-HEAVY"  */
    VIRTUAL_WIDTH = 1189,          /* "VIRTUAL-WIDTH"  */
    VOLATILE = 1190,               /* VOLATILE  */
    VPADDING = 1191,               /* VPADDING  */
    VSCROLL = 1192,                /* VSCROLL  */
    VSCROLL_BAR = 1193,            /* "VSCROLL-BAR"  */
    VSCROLL_POS = 1194,            /* "VSCROLL-POS"  */
    VTOP = 1195,                   /* VTOP  */
    WAIT = 1196,                   /* WAIT  */
    WEB_BROWSER = 1197,            /* "WEB-BROWSER"  */
    WHEN = 1198,                   /* WHEN  */
    WHEN_COMPILED_FUNC = 1199,     /* "FUNCTION WHEN-COMPILED"  */
    WHEN_XML = 1200,               /* "WHEN"  */
    WIDTH = 1201,                  /* WIDTH  */
    WIDTH_IN_CELLS = 1202,         /* "WIDTH-IN-CELLS"  */
    WINAPI = 1203,                 /* WINAPI  */
    WINDOW = 1204,                 /* WINDOW  */
    WITH = 1205,                   /* WITH  */
    WORD = 1206,                   /* "Identifier"  */
    WORDS = 1207,                  /* WORDS  */
    WORKING_STORAGE = 1208,        /* "WORKING-STORAGE"  */
    WRAP = 1209,                   /* WRAP  */
    WRITE = 1210,                  /* WRITE  */
    WRITE_ONLY = 1211,             /* "WRITE-ONLY"  */
    WRITE_VERIFY = 1212,           /* "WRITE-VERIFY"  */
    WRITERS = 1213,                /* WRITERS  */
    X = 1214,                      /* X  */
    XML = 1215,                    /* XML  */
    XML_DECLARATION = 1216,        /* "XML-DECLARATION"  */
    XML_SCHEMA = 1217,             /* "XML-SCHEMA"  */
    Y = 1218,                      /* Y  */
    YYYYDDD = 1219,                /* YYYYDDD  */
    YYYYMMDD = 1220,               /* YYYYMMDD  */
    ZERO = 1221,                   /* ZERO  */
    LEVEL_NUMBER_IN_AREA_A = 1222, /* "level-number (Area A)"  */
    WORD_IN_AREA_A = 1223,         /* "Identifier (Area A)"  */
    SHIFT_PREFER = 1224            /* SHIFT_PREFER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_THREEDIMENSIONAL = 3,           /* "3D"  */
  YYSYMBOL_ABSENT = 4,                     /* ABSENT  */
  YYSYMBOL_ACCEPT = 5,                     /* ACCEPT  */
  YYSYMBOL_ACCESS = 6,                     /* ACCESS  */
  YYSYMBOL_ACTIVEX = 7,                    /* "ACTIVE-X"  */
  YYSYMBOL_ACTIVE_CLASS = 8,               /* "ACTIVE-CLASS"  */
  YYSYMBOL_ACTION = 9,                     /* ACTION  */
  YYSYMBOL_ACTUAL = 10,                    /* ACTUAL  */
  YYSYMBOL_ADD = 11,                       /* ADD  */
  YYSYMBOL_ADDRESS = 12,                   /* ADDRESS  */
  YYSYMBOL_ADJUSTABLE_COLUMNS = 13,        /* "ADJUSTABLE-COLUMNS"  */
  YYSYMBOL_ADVANCING = 14,                 /* ADVANCING  */
  YYSYMBOL_AFTER = 15,                     /* AFTER  */
  YYSYMBOL_ALIGNED = 16,                   /* ALIGNED  */
  YYSYMBOL_ALIGNMENT = 17,                 /* ALIGNMENT  */
  YYSYMBOL_ALL = 18,                       /* ALL  */
  YYSYMBOL_ALLOCATE = 19,                  /* ALLOCATE  */
  YYSYMBOL_ALLOWING = 20,                  /* ALLOWING  */
  YYSYMBOL_ALPHABET = 21,                  /* ALPHABET  */
  YYSYMBOL_ALPHABETIC = 22,                /* ALPHABETIC  */
  YYSYMBOL_ALPHABETIC_LOWER = 23,          /* "ALPHABETIC-LOWER"  */
  YYSYMBOL_ALPHABETIC_UPPER = 24,          /* "ALPHABETIC-UPPER"  */
  YYSYMBOL_ALPHANUMERIC = 25,              /* ALPHANUMERIC  */
  YYSYMBOL_ALPHANUMERIC_EDITED = 26,       /* "ALPHANUMERIC-EDITED"  */
  YYSYMBOL_ALSO = 27,                      /* ALSO  */
  YYSYMBOL_ALTER = 28,                     /* ALTER  */
  YYSYMBOL_ALTERNATE = 29,                 /* ALTERNATE  */
  YYSYMBOL_AND = 30,                       /* AND  */
  YYSYMBOL_ANY = 31,                       /* ANY  */
  YYSYMBOL_APPLY = 32,                     /* APPLY  */
  YYSYMBOL_ARE = 33,                       /* ARE  */
  YYSYMBOL_AREA = 34,                      /* AREA  */
  YYSYMBOL_AREAS = 35,                     /* AREAS  */
  YYSYMBOL_ARGUMENT_NUMBER = 36,           /* "ARGUMENT-NUMBER"  */
  YYSYMBOL_ARGUMENT_VALUE = 37,            /* "ARGUMENT-VALUE"  */
  YYSYMBOL_ARITHMETIC = 38,                /* ARITHMETIC  */
  YYSYMBOL_AS = 39,                        /* AS  */
  YYSYMBOL_ASCENDING = 40,                 /* ASCENDING  */
  YYSYMBOL_ASCII = 41,                     /* ASCII  */
  YYSYMBOL_ASSIGN = 42,                    /* ASSIGN  */
  YYSYMBOL_AT = 43,                        /* AT  */
  YYSYMBOL_AT_END = 44,                    /* "AT END"  */
  YYSYMBOL_ATTRIBUTE = 45,                 /* ATTRIBUTE  */
  YYSYMBOL_ATTRIBUTES = 46,                /* ATTRIBUTES  */
  YYSYMBOL_AUTHOR = 47,                    /* AUTHOR  */
  YYSYMBOL_AUTO = 48,                      /* AUTO  */
  YYSYMBOL_AUTO_DECIMAL = 49,              /* "AUTO-DECIMAL"  */
  YYSYMBOL_AUTO_SPIN = 50,                 /* "AUTO-SPIN"  */
  YYSYMBOL_AUTOMATIC = 51,                 /* AUTOMATIC  */
  YYSYMBOL_AWAY_FROM_ZERO = 52,            /* "AWAY-FROM-ZERO"  */
  YYSYMBOL_B_AND = 53,                     /* "B-AND"  */
  YYSYMBOL_B_NOT = 54,                     /* "B-NOT"  */
  YYSYMBOL_B_OR = 55,                      /* "B-OR"  */
  YYSYMBOL_B_XOR = 56,                     /* "B-XOR"  */
  YYSYMBOL_B_SHIFT_L = 57,                 /* "B-SHIFT-L"  */
  YYSYMBOL_B_SHIFT_R = 58,                 /* "B-SHIFT-R"  */
  YYSYMBOL_B_SHIFT_LC = 59,                /* "B-SHIFT-LC"  */
  YYSYMBOL_B_SHIFT_RC = 60,                /* "B-SHIFT-RC"  */
  YYSYMBOL_BACKGROUND_COLOR = 61,          /* "BACKGROUND-COLOR"  */
  YYSYMBOL_BACKGROUND_HIGH = 62,           /* "BACKGROUND-HIGH"  */
  YYSYMBOL_BACKGROUND_LOW = 63,            /* "BACKGROUND-LOW"  */
  YYSYMBOL_BACKGROUND_STANDARD = 64,       /* "BACKGROUND-STANDARD"  */
  YYSYMBOL_BACKWARD = 65,                  /* BACKWARD  */
  YYSYMBOL_BAR = 66,                       /* BAR  */
  YYSYMBOL_BASED = 67,                     /* BASED  */
  YYSYMBOL_BEFORE = 68,                    /* BEFORE  */
  YYSYMBOL_BELL = 69,                      /* BELL  */
  YYSYMBOL_BINARY = 70,                    /* BINARY  */
  YYSYMBOL_BINARY_C_LONG = 71,             /* "BINARY-C-LONG"  */
  YYSYMBOL_BINARY_CHAR = 72,               /* "BINARY-CHAR"  */
  YYSYMBOL_BINARY_DOUBLE = 73,             /* "BINARY-DOUBLE"  */
  YYSYMBOL_BINARY_LONG = 74,               /* "BINARY-LONG"  */
  YYSYMBOL_BINARY_SEQUENTIAL = 75,         /* "BINARY-SEQUENTIAL"  */
  YYSYMBOL_BINARY_SHORT = 76,              /* "BINARY-SHORT"  */
  YYSYMBOL_BIT = 77,                       /* BIT  */
  YYSYMBOL_BITMAP = 78,                    /* BITMAP  */
  YYSYMBOL_BITMAP_END = 79,                /* "BITMAP-END"  */
  YYSYMBOL_BITMAP_HANDLE = 80,             /* "BITMAP-HANDLE"  */
  YYSYMBOL_BITMAP_NUMBER = 81,             /* "BITMAP-NUMBER"  */
  YYSYMBOL_BITMAP_START = 82,              /* "BITMAP-START"  */
  YYSYMBOL_BITMAP_TIMER = 83,              /* "BITMAP-TIMER"  */
  YYSYMBOL_BITMAP_TRAILING = 84,           /* "BITMAP-TRAILING"  */
  YYSYMBOL_BITMAP_TRANSPARENT_COLOR = 85,  /* "BITMAP-TRANSPARENT-COLOR"  */
  YYSYMBOL_BITMAP_WIDTH = 86,              /* "BITMAP-WIDTH"  */
  YYSYMBOL_BLANK = 87,                     /* BLANK  */
  YYSYMBOL_BLINK = 88,                     /* BLINK  */
  YYSYMBOL_BLOCK = 89,                     /* BLOCK  */
  YYSYMBOL_BOOLEAN = 90,                   /* BOOLEAN  */
  YYSYMBOL_BOTTOM = 91,                    /* BOTTOM  */
  YYSYMBOL_BOX = 92,                       /* BOX  */
  YYSYMBOL_BOXED = 93,                     /* BOXED  */
  YYSYMBOL_BULK_ADDITION = 94,             /* "BULK-ADDITION"  */
  YYSYMBOL_BUSY = 95,                      /* BUSY  */
  YYSYMBOL_BUTTONS = 96,                   /* BUTTONS  */
  YYSYMBOL_BY = 97,                        /* BY  */
  YYSYMBOL_BYTE_LENGTH = 98,               /* "BYTE-LENGTH"  */
  YYSYMBOL_C = 99,                         /* C  */
  YYSYMBOL_CALENDAR_FONT = 100,            /* "CALENDAR-FONT"  */
  YYSYMBOL_CALL = 101,                     /* CALL  */
  YYSYMBOL_CANCEL = 102,                   /* CANCEL  */
  YYSYMBOL_CANCEL_BUTTON = 103,            /* "CANCEL-BUTTON"  */
  YYSYMBOL_CAPACITY = 104,                 /* CAPACITY  */
  YYSYMBOL_CARD_PUNCH = 105,               /* "CARD-PUNCH"  */
  YYSYMBOL_CARD_READER = 106,              /* "CARD-READER"  */
  YYSYMBOL_CASSETTE = 107,                 /* CASSETTE  */
  YYSYMBOL_CCOL = 108,                     /* CCOL  */
  YYSYMBOL_CD = 109,                       /* CD  */
  YYSYMBOL_CELL = 110,                     /* CELL  */
  YYSYMBOL_CELL_COLOR = 111,               /* "CELL-COLOR"  */
  YYSYMBOL_CELL_DATA = 112,                /* "CELL-DATA"  */
  YYSYMBOL_CELL_FONT = 113,                /* "CELL-FONT"  */
  YYSYMBOL_CELL_PROTECTION = 114,          /* "CELL-PROTECTION"  */
  YYSYMBOL_CENTER = 115,                   /* CENTER  */
  YYSYMBOL_CENTERED = 116,                 /* CENTERED  */
  YYSYMBOL_CENTERED_HEADINGS = 117,        /* "CENTERED-HEADINGS"  */
  YYSYMBOL_CENTURY_DATE = 118,             /* "CENTURY-DATE"  */
  YYSYMBOL_CF = 119,                       /* CF  */
  YYSYMBOL_CH = 120,                       /* CH  */
  YYSYMBOL_CHAINING = 121,                 /* CHAINING  */
  YYSYMBOL_CHANGED = 122,                  /* CHANGED  */
  YYSYMBOL_CHARACTER = 123,                /* CHARACTER  */
  YYSYMBOL_CHARACTERS = 124,               /* CHARACTERS  */
  YYSYMBOL_CHECK_BOX = 125,                /* "CHECK-BOX"  */
  YYSYMBOL_CLASS = 126,                    /* CLASS  */
  YYSYMBOL_CLASSIFICATION = 127,           /* CLASSIFICATION  */
  YYSYMBOL_CLASS_NAME = 128,               /* "class-name"  */
  YYSYMBOL_CLEAR_SELECTION = 129,          /* "CLEAR-SELECTION"  */
  YYSYMBOL_CLINE = 130,                    /* CLINE  */
  YYSYMBOL_CLINES = 131,                   /* CLINES  */
  YYSYMBOL_CLOSE = 132,                    /* CLOSE  */
  YYSYMBOL_COBOL = 133,                    /* COBOL  */
  YYSYMBOL_CODE = 134,                     /* CODE  */
  YYSYMBOL_CODE_SET = 135,                 /* "CODE-SET"  */
  YYSYMBOL_COLLATING = 136,                /* COLLATING  */
  YYSYMBOL_COL = 137,                      /* COL  */
  YYSYMBOL_COLOR = 138,                    /* COLOR  */
  YYSYMBOL_COLORS = 139,                   /* COLORS  */
  YYSYMBOL_COLS = 140,                     /* COLS  */
  YYSYMBOL_COLUMN = 141,                   /* COLUMN  */
  YYSYMBOL_COLUMN_COLOR = 142,             /* "COLUMN-COLOR"  */
  YYSYMBOL_COLUMN_DIVIDERS = 143,          /* "COLUMN-DIVIDERS"  */
  YYSYMBOL_COLUMN_FONT = 144,              /* "COLUMN-FONT"  */
  YYSYMBOL_COLUMN_HEADINGS = 145,          /* "COLUMN-HEADINGS"  */
  YYSYMBOL_COLUMN_PROTECTION = 146,        /* "COLUMN-PROTECTION"  */
  YYSYMBOL_COLUMNS = 147,                  /* COLUMNS  */
  YYSYMBOL_COMBO_BOX = 148,                /* "COMBO-BOX"  */
  YYSYMBOL_COMMA = 149,                    /* COMMA  */
  YYSYMBOL_COMMAND_LINE = 150,             /* "COMMAND-LINE"  */
  YYSYMBOL_COMMA_DELIM = 151,              /* "comma delimiter"  */
  YYSYMBOL_COMMIT = 152,                   /* COMMIT  */
  YYSYMBOL_COMMON = 153,                   /* COMMON  */
  YYSYMBOL_COMMUNICATION = 154,            /* COMMUNICATION  */
  YYSYMBOL_COMP = 155,                     /* COMP  */
  YYSYMBOL_COMPUTE = 156,                  /* COMPUTE  */
  YYSYMBOL_COMP_0 = 157,                   /* "COMP-0"  */
  YYSYMBOL_COMP_1 = 158,                   /* "COMP-1"  */
  YYSYMBOL_COMP_2 = 159,                   /* "COMP-2"  */
  YYSYMBOL_COMP_3 = 160,                   /* "COMP-3"  */
  YYSYMBOL_COMP_4 = 161,                   /* "COMP-4"  */
  YYSYMBOL_COMP_5 = 162,                   /* "COMP-5"  */
  YYSYMBOL_COMP_6 = 163,                   /* "COMP-6"  */
  YYSYMBOL_COMP_N = 164,                   /* "COMP-N"  */
  YYSYMBOL_COMP_X = 165,                   /* "COMP-X"  */
  YYSYMBOL_CONCATENATE_FUNC = 166,         /* "FUNCTION CONCATENATE"  */
  YYSYMBOL_CONDITION = 167,                /* CONDITION  */
  YYSYMBOL_CONFIGURATION = 168,            /* CONFIGURATION  */
  YYSYMBOL_CONSTANT = 169,                 /* CONSTANT  */
  YYSYMBOL_CONTAINS = 170,                 /* CONTAINS  */
  YYSYMBOL_CONTENT = 171,                  /* CONTENT  */
  YYSYMBOL_CONTENT_LENGTH_FUNC = 172,      /* "FUNCTION CONTENT-LENGTH"  */
  YYSYMBOL_CONTENT_OF_FUNC = 173,          /* "FUNCTION CONTENT-OF"  */
  YYSYMBOL_CONTINUE = 174,                 /* CONTINUE  */
  YYSYMBOL_CONTROL = 175,                  /* CONTROL  */
  YYSYMBOL_CONTROLS = 176,                 /* CONTROLS  */
  YYSYMBOL_CONVERSION = 177,               /* CONVERSION  */
  YYSYMBOL_CONVERTING = 178,               /* CONVERTING  */
  YYSYMBOL_COPY = 179,                     /* COPY  */
  YYSYMBOL_COPY_SELECTION = 180,           /* "COPY-SELECTION"  */
  YYSYMBOL_CORE_INDEX = 181,               /* "CORE-INDEX"  */
  YYSYMBOL_CORRESPONDING = 182,            /* CORRESPONDING  */
  YYSYMBOL_COUNT = 183,                    /* COUNT  */
  YYSYMBOL_CRT = 184,                      /* CRT  */
  YYSYMBOL_CRT_UNDER = 185,                /* "CRT-UNDER"  */
  YYSYMBOL_CSIZE = 186,                    /* CSIZE  */
  YYSYMBOL_CURRENCY = 187,                 /* CURRENCY  */
  YYSYMBOL_CURRENT_DATE_FUNC = 188,        /* "FUNCTION CURRENT-DATE"  */
  YYSYMBOL_CURSOR = 189,                   /* CURSOR  */
  YYSYMBOL_CURSOR_COL = 190,               /* "CURSOR-COL"  */
  YYSYMBOL_CURSOR_COLOR = 191,             /* "CURSOR-COLOR"  */
  YYSYMBOL_CURSOR_FRAME_WIDTH = 192,       /* "CURSOR-FRAME-WIDTH"  */
  YYSYMBOL_CURSOR_ROW = 193,               /* "CURSOR-ROW"  */
  YYSYMBOL_CURSOR_X = 194,                 /* "CURSOR-X"  */
  YYSYMBOL_CURSOR_Y = 195,                 /* "CURSOR-Y"  */
  YYSYMBOL_CUSTOM_PRINT_TEMPLATE = 196,    /* "CUSTOM-PRINT-TEMPLATE"  */
  YYSYMBOL_CYCLE = 197,                    /* CYCLE  */
  YYSYMBOL_CYL_INDEX = 198,                /* "CYL-INDEX"  */
  YYSYMBOL_CYL_OVERFLOW = 199,             /* "CYL-OVERFLOW"  */
  YYSYMBOL_DASHED = 200,                   /* DASHED  */
  YYSYMBOL_DATA = 201,                     /* DATA  */
  YYSYMBOL_DATA_COLUMNS = 202,             /* "DATA-COLUMNS"  */
  YYSYMBOL_DATA_TYPES = 203,               /* "DATA-TYPES"  */
  YYSYMBOL_DATE = 204,                     /* DATE  */
  YYSYMBOL_DATE_COMPILED = 205,            /* "DATE-COMPILED"  */
  YYSYMBOL_DATE_ENTRY = 206,               /* "DATE-ENTRY"  */
  YYSYMBOL_DATE_MODIFIED = 207,            /* "DATE-MODIFIED"  */
  YYSYMBOL_DATE_WRITTEN = 208,             /* "DATE-WRITTEN"  */
  YYSYMBOL_DAY = 209,                      /* DAY  */
  YYSYMBOL_DAY_OF_WEEK = 210,              /* "DAY-OF-WEEK"  */
  YYSYMBOL_DE = 211,                       /* DE  */
  YYSYMBOL_DEBUGGING = 212,                /* DEBUGGING  */
  YYSYMBOL_DECIMAL_POINT = 213,            /* "DECIMAL-POINT"  */
  YYSYMBOL_DECLARATIVES = 214,             /* DECLARATIVES  */
  YYSYMBOL_DEFAULT = 215,                  /* DEFAULT  */
  YYSYMBOL_DEFAULT_BUTTON = 216,           /* "DEFAULT-BUTTON"  */
  YYSYMBOL_DEFAULT_FONT = 217,             /* "DEFAULT-FONT"  */
  YYSYMBOL_DELETE = 218,                   /* DELETE  */
  YYSYMBOL_DELIMITED = 219,                /* DELIMITED  */
  YYSYMBOL_DELIMITER = 220,                /* DELIMITER  */
  YYSYMBOL_DEPENDING = 221,                /* DEPENDING  */
  YYSYMBOL_DESCENDING = 222,               /* DESCENDING  */
  YYSYMBOL_DESTINATION = 223,              /* DESTINATION  */
  YYSYMBOL_DESTROY = 224,                  /* DESTROY  */
  YYSYMBOL_DETAIL = 225,                   /* DETAIL  */
  YYSYMBOL_DISABLE = 226,                  /* DISABLE  */
  YYSYMBOL_DISC = 227,                     /* DISC  */
  YYSYMBOL_DISK = 228,                     /* DISK  */
  YYSYMBOL_DISP = 229,                     /* DISP  */
  YYSYMBOL_DISPLAY = 230,                  /* DISPLAY  */
  YYSYMBOL_DISPLAY_COLUMNS = 231,          /* "DISPLAY-COLUMNS"  */
  YYSYMBOL_DISPLAY_FORMAT = 232,           /* "DISPLAY-FORMAT"  */
  YYSYMBOL_DISPLAY_OF_FUNC = 233,          /* "FUNCTION DISPLAY-OF"  */
  YYSYMBOL_DIVIDE = 234,                   /* DIVIDE  */
  YYSYMBOL_DIVIDERS = 235,                 /* DIVIDERS  */
  YYSYMBOL_DIVIDER_COLOR = 236,            /* "DIVIDER-COLOR"  */
  YYSYMBOL_DIVISION = 237,                 /* DIVISION  */
  YYSYMBOL_DOTDASH = 238,                  /* DOTDASH  */
  YYSYMBOL_DOTTED = 239,                   /* DOTTED  */
  YYSYMBOL_DRAG_COLOR = 240,               /* "DRAG-COLOR"  */
  YYSYMBOL_DROP_DOWN = 241,                /* "DROP-DOWN"  */
  YYSYMBOL_DROP_LIST = 242,                /* "DROP-LIST"  */
  YYSYMBOL_DOWN = 243,                     /* DOWN  */
  YYSYMBOL_DUPLICATES = 244,               /* DUPLICATES  */
  YYSYMBOL_DYNAMIC = 245,                  /* DYNAMIC  */
  YYSYMBOL_EBCDIC = 246,                   /* EBCDIC  */
  YYSYMBOL_EC = 247,                       /* EC  */
  YYSYMBOL_ECHO = 248,                     /* ECHO  */
  YYSYMBOL_EGI = 249,                      /* EGI  */
  YYSYMBOL_EIGHTY_EIGHT = 250,             /* "level-number 88"  */
  YYSYMBOL_ENABLE = 251,                   /* ENABLE  */
  YYSYMBOL_ELEMENT = 252,                  /* ELEMENT  */
  YYSYMBOL_ELSE = 253,                     /* ELSE  */
  YYSYMBOL_EMI = 254,                      /* EMI  */
  YYSYMBOL_ENCRYPTION = 255,               /* ENCRYPTION  */
  YYSYMBOL_ENCODING = 256,                 /* ENCODING  */
  YYSYMBOL_END = 257,                      /* END  */
  YYSYMBOL_END_ACCEPT = 258,               /* "END-ACCEPT"  */
  YYSYMBOL_END_ADD = 259,                  /* "END-ADD"  */
  YYSYMBOL_END_CALL = 260,                 /* "END-CALL"  */
  YYSYMBOL_END_COMPUTE = 261,              /* "END-COMPUTE"  */
  YYSYMBOL_END_COLOR = 262,                /* "END-COLOR"  */
  YYSYMBOL_END_DELETE = 263,               /* "END-DELETE"  */
  YYSYMBOL_END_DISPLAY = 264,              /* "END-DISPLAY"  */
  YYSYMBOL_END_DIVIDE = 265,               /* "END-DIVIDE"  */
  YYSYMBOL_END_EVALUATE = 266,             /* "END-EVALUATE"  */
  YYSYMBOL_END_FUNCTION = 267,             /* "END FUNCTION"  */
  YYSYMBOL_END_IF = 268,                   /* "END-IF"  */
  YYSYMBOL_END_JSON = 269,                 /* "END-JSON"  */
  YYSYMBOL_END_MODIFY = 270,               /* "END-MODIFY"  */
  YYSYMBOL_END_MULTIPLY = 271,             /* "END-MULTIPLY"  */
  YYSYMBOL_END_PERFORM = 272,              /* "END-PERFORM"  */
  YYSYMBOL_END_PROGRAM = 273,              /* "END PROGRAM"  */
  YYSYMBOL_END_READ = 274,                 /* "END-READ"  */
  YYSYMBOL_END_RECEIVE = 275,              /* "END-RECEIVE"  */
  YYSYMBOL_END_RETURN = 276,               /* "END-RETURN"  */
  YYSYMBOL_END_REWRITE = 277,              /* "END-REWRITE"  */
  YYSYMBOL_END_SEARCH = 278,               /* "END-SEARCH"  */
  YYSYMBOL_END_SEND = 279,                 /* "END-SEND"  */
  YYSYMBOL_END_START = 280,                /* "END-START"  */
  YYSYMBOL_END_STRING = 281,               /* "END-STRING"  */
  YYSYMBOL_END_SUBTRACT = 282,             /* "END-SUBTRACT"  */
  YYSYMBOL_END_UNSTRING = 283,             /* "END-UNSTRING"  */
  YYSYMBOL_END_WRITE = 284,                /* "END-WRITE"  */
  YYSYMBOL_END_XML = 285,                  /* "END-XML"  */
  YYSYMBOL_ENGRAVED = 286,                 /* ENGRAVED  */
  YYSYMBOL_ENSURE_VISIBLE = 287,           /* "ENSURE-VISIBLE"  */
  YYSYMBOL_ENTRY = 288,                    /* ENTRY  */
  YYSYMBOL_ENTRY_CONVENTION = 289,         /* "ENTRY-CONVENTION"  */
  YYSYMBOL_ENTRY_FIELD = 290,              /* "ENTRY-FIELD"  */
  YYSYMBOL_ENTRY_REASON = 291,             /* "ENTRY-REASON"  */
  YYSYMBOL_ENVIRONMENT = 292,              /* ENVIRONMENT  */
  YYSYMBOL_ENVIRONMENT_NAME = 293,         /* "ENVIRONMENT-NAME"  */
  YYSYMBOL_ENVIRONMENT_VALUE = 294,        /* "ENVIRONMENT-VALUE"  */
  YYSYMBOL_EOL = 295,                      /* EOL  */
  YYSYMBOL_EOP = 296,                      /* EOP  */
  YYSYMBOL_EOS = 297,                      /* EOS  */
  YYSYMBOL_EQUAL = 298,                    /* EQUAL  */
  YYSYMBOL_ERASE = 299,                    /* ERASE  */
  YYSYMBOL_ERROR = 300,                    /* ERROR  */
  YYSYMBOL_ESCAPE = 301,                   /* ESCAPE  */
  YYSYMBOL_ESCAPE_BUTTON = 302,            /* "ESCAPE-BUTTON"  */
  YYSYMBOL_ESI = 303,                      /* ESI  */
  YYSYMBOL_EVALUATE = 304,                 /* EVALUATE  */
  YYSYMBOL_EVENT = 305,                    /* EVENT  */
  YYSYMBOL_EVENT_LIST = 306,               /* "EVENT-LIST"  */
  YYSYMBOL_EVENT_STATUS = 307,             /* "EVENT STATUS"  */
  YYSYMBOL_EVERY = 308,                    /* EVERY  */
  YYSYMBOL_EXAMINE = 309,                  /* EXAMINE  */
  YYSYMBOL_EXCEPTION = 310,                /* EXCEPTION  */
  YYSYMBOL_EXCEPTION_CONDITION = 311,      /* "EXCEPTION CONDITION"  */
  YYSYMBOL_EXCEPTION_VALUE = 312,          /* "EXCEPTION-VALUE"  */
  YYSYMBOL_EXPAND = 313,                   /* EXPAND  */
  YYSYMBOL_EXCLUSIVE = 314,                /* EXCLUSIVE  */
  YYSYMBOL_EXHIBIT = 315,                  /* EXHIBIT  */
  YYSYMBOL_EXIT = 316,                     /* EXIT  */
  YYSYMBOL_EXPONENTIATION = 317,           /* "exponentiation operator"  */
  YYSYMBOL_EXTEND = 318,                   /* EXTEND  */
  YYSYMBOL_EXTENDED_SEARCH = 319,          /* "EXTENDED-SEARCH"  */
  YYSYMBOL_EXTERNAL = 320,                 /* EXTERNAL  */
  YYSYMBOL_EXTERNAL_FORM = 321,            /* "EXTERNAL-FORM"  */
  YYSYMBOL_F = 322,                        /* F  */
  YYSYMBOL_FACTORY = 323,                  /* FACTORY  */
  YYSYMBOL_FD = 324,                       /* FD  */
  YYSYMBOL_FH__FCD = 325,                  /* "FH--FCD"  */
  YYSYMBOL_FH__KEYDEF = 326,               /* "FH--KEYDEF"  */
  YYSYMBOL_FILE_CONTROL = 327,             /* "FILE-CONTROL"  */
  YYSYMBOL_FILE_ID = 328,                  /* "FILE-ID"  */
  YYSYMBOL_FILE_LIMIT = 329,               /* "FILE-LIMIT"  */
  YYSYMBOL_FILE_LIMITS = 330,              /* "FILE-LIMITS"  */
  YYSYMBOL_FILE_NAME = 331,                /* "FILE-NAME"  */
  YYSYMBOL_FILE_POS = 332,                 /* "FILE-POS"  */
  YYSYMBOL_FILL_COLOR = 333,               /* "FILL-COLOR"  */
  YYSYMBOL_FILL_COLOR2 = 334,              /* "FILL-COLOR2"  */
  YYSYMBOL_FILL_PERCENT = 335,             /* "FILL-PERCENT"  */
  YYSYMBOL_FILLER = 336,                   /* FILLER  */
  YYSYMBOL_FINAL = 337,                    /* FINAL  */
  YYSYMBOL_FINISH_REASON = 338,            /* "FINISH-REASON"  */
  YYSYMBOL_FIRST = 339,                    /* FIRST  */
  YYSYMBOL_FIXED = 340,                    /* FIXED  */
  YYSYMBOL_FIXED_FONT = 341,               /* "FIXED-FONT"  */
  YYSYMBOL_FIXED_WIDTH = 342,              /* "FIXED-WIDTH"  */
  YYSYMBOL_FLAT = 343,                     /* FLAT  */
  YYSYMBOL_FLAT_BUTTONS = 344,             /* "FLAT-BUTTONS"  */
  YYSYMBOL_FLOAT_BINARY_128 = 345,         /* "FLOAT-BINARY-128"  */
  YYSYMBOL_FLOAT_BINARY_32 = 346,          /* "FLOAT-BINARY-32"  */
  YYSYMBOL_FLOAT_BINARY_64 = 347,          /* "FLOAT-BINARY-64"  */
  YYSYMBOL_FLOAT_DECIMAL_16 = 348,         /* "FLOAT-DECIMAL-16"  */
  YYSYMBOL_FLOAT_DECIMAL_34 = 349,         /* "FLOAT-DECIMAL-34"  */
  YYSYMBOL_FLOAT_DECIMAL_7 = 350,          /* "FLOAT-DECIMAL-7"  */
  YYSYMBOL_FLOAT_EXTENDED = 351,           /* "FLOAT-EXTENDED"  */
  YYSYMBOL_FLOAT_LONG = 352,               /* "FLOAT-LONG"  */
  YYSYMBOL_FLOAT_SHORT = 353,              /* "FLOAT-SHORT"  */
  YYSYMBOL_FLOATING = 354,                 /* FLOATING  */
  YYSYMBOL_FONT = 355,                     /* FONT  */
  YYSYMBOL_FOOTING = 356,                  /* FOOTING  */
  YYSYMBOL_FOR = 357,                      /* FOR  */
  YYSYMBOL_FOREGROUND_COLOR = 358,         /* "FOREGROUND-COLOR"  */
  YYSYMBOL_FOREVER = 359,                  /* FOREVER  */
  YYSYMBOL_FORMAT = 360,                   /* FORMAT  */
  YYSYMBOL_FORMATTED_DATE_FUNC = 361,      /* "FUNCTION FORMATTED-DATE"  */
  YYSYMBOL_FORMATTED_DATETIME_FUNC = 362,  /* "FUNCTION FORMATTED-DATETIME"  */
  YYSYMBOL_FORMATTED_TIME_FUNC = 363,      /* "FUNCTION FORMATTED-TIME"  */
  YYSYMBOL_FRAME = 364,                    /* FRAME  */
  YYSYMBOL_FRAMED = 365,                   /* FRAMED  */
  YYSYMBOL_FREE = 366,                     /* FREE  */
  YYSYMBOL_FROM = 367,                     /* FROM  */
  YYSYMBOL_FROM_CRT = 368,                 /* "FROM CRT"  */
  YYSYMBOL_FULL = 369,                     /* FULL  */
  YYSYMBOL_FULL_HEIGHT = 370,              /* "FULL-HEIGHT"  */
  YYSYMBOL_FUNCTION = 371,                 /* FUNCTION  */
  YYSYMBOL_FUNCTION_ID = 372,              /* "FUNCTION-ID"  */
  YYSYMBOL_FUNCTION_NAME = 373,            /* "intrinsic function name"  */
  YYSYMBOL_GENERATE = 374,                 /* GENERATE  */
  YYSYMBOL_GIVING = 375,                   /* GIVING  */
  YYSYMBOL_GLOBAL = 376,                   /* GLOBAL  */
  YYSYMBOL_GO = 377,                       /* GO  */
  YYSYMBOL_GO_BACK = 378,                  /* "GO-BACK"  */
  YYSYMBOL_GO_FORWARD = 379,               /* "GO-FORWARD"  */
  YYSYMBOL_GO_HOME = 380,                  /* "GO-HOME"  */
  YYSYMBOL_GO_SEARCH = 381,                /* "GO-SEARCH"  */
  YYSYMBOL_GOBACK = 382,                   /* GOBACK  */
  YYSYMBOL_GRAPHICAL = 383,                /* GRAPHICAL  */
  YYSYMBOL_GREATER = 384,                  /* GREATER  */
  YYSYMBOL_GREATER_OR_EQUAL = 385,         /* "GREATER OR EQUAL"  */
  YYSYMBOL_GRID = 386,                     /* GRID  */
  YYSYMBOL_GROUP = 387,                    /* GROUP  */
  YYSYMBOL_GROUP_VALUE = 388,              /* "GROUP-VALUE"  */
  YYSYMBOL_HANDLE = 389,                   /* HANDLE  */
  YYSYMBOL_HAS_CHILDREN = 390,             /* "HAS-CHILDREN"  */
  YYSYMBOL_HEADING = 391,                  /* HEADING  */
  YYSYMBOL_HEADING_COLOR = 392,            /* "HEADING-COLOR"  */
  YYSYMBOL_HEADING_DIVIDER_COLOR = 393,    /* "HEADING-DIVIDER-COLOR"  */
  YYSYMBOL_HEADING_FONT = 394,             /* "HEADING-FONT"  */
  YYSYMBOL_HEAVY = 395,                    /* HEAVY  */
  YYSYMBOL_HEIGHT_IN_CELLS = 396,          /* "HEIGHT-IN-CELLS"  */
  YYSYMBOL_HIDDEN_DATA = 397,              /* "HIDDEN-DATA"  */
  YYSYMBOL_HIGHLIGHT = 398,                /* HIGHLIGHT  */
  YYSYMBOL_HIGH_COLOR = 399,               /* "HIGH-COLOR"  */
  YYSYMBOL_HIGH_VALUE = 400,               /* "HIGH-VALUE"  */
  YYSYMBOL_HOT_TRACK = 401,                /* "HOT-TRACK"  */
  YYSYMBOL_HSCROLL = 402,                  /* HSCROLL  */
  YYSYMBOL_HSCROLL_POS = 403,              /* "HSCROLL-POS"  */
  YYSYMBOL_ICON = 404,                     /* ICON  */
  YYSYMBOL_ID = 405,                       /* ID  */
  YYSYMBOL_IDENTIFIED = 406,               /* IDENTIFIED  */
  YYSYMBOL_IDENTIFICATION = 407,           /* IDENTIFICATION  */
  YYSYMBOL_IF = 408,                       /* IF  */
  YYSYMBOL_IGNORE = 409,                   /* IGNORE  */
  YYSYMBOL_IGNORING = 410,                 /* IGNORING  */
  YYSYMBOL_IN = 411,                       /* IN  */
  YYSYMBOL_INDEPENDENT = 412,              /* INDEPENDENT  */
  YYSYMBOL_INDEX = 413,                    /* INDEX  */
  YYSYMBOL_INDEXED = 414,                  /* INDEXED  */
  YYSYMBOL_INDICATE = 415,                 /* INDICATE  */
  YYSYMBOL_INITIALIZE = 416,               /* INITIALIZE  */
  YYSYMBOL_INITIALIZED = 417,              /* INITIALIZED  */
  YYSYMBOL_INITIATE = 418,                 /* INITIATE  */
  YYSYMBOL_INPUT = 419,                    /* INPUT  */
  YYSYMBOL_INPUT_OUTPUT = 420,             /* "INPUT-OUTPUT"  */
  YYSYMBOL_INQUIRE = 421,                  /* INQUIRE  */
  YYSYMBOL_INSERTION_INDEX = 422,          /* "INSERTION-INDEX"  */
  YYSYMBOL_INSERT_ROWS = 423,              /* "INSERT-ROWS"  */
  YYSYMBOL_INSPECT = 424,                  /* INSPECT  */
  YYSYMBOL_INSTALLATION = 425,             /* INSTALLATION  */
  YYSYMBOL_INTERMEDIATE = 426,             /* INTERMEDIATE  */
  YYSYMBOL_INTO = 427,                     /* INTO  */
  YYSYMBOL_INTRINSIC = 428,                /* INTRINSIC  */
  YYSYMBOL_INVALID = 429,                  /* INVALID  */
  YYSYMBOL_INVALID_KEY = 430,              /* "INVALID KEY"  */
  YYSYMBOL_IS = 431,                       /* IS  */
  YYSYMBOL_ITEM = 432,                     /* ITEM  */
  YYSYMBOL_ITEM_TEXT = 433,                /* "ITEM-TEXT"  */
  YYSYMBOL_ITEM_TO_ADD = 434,              /* "ITEM-TO_ADD"  */
  YYSYMBOL_ITEM_TO_DELETE = 435,           /* "ITEM-TO_DELETE"  */
  YYSYMBOL_ITEM_TO_EMPTY = 436,            /* "ITEM-TO_EMPTY"  */
  YYSYMBOL_ITEM_VALUE = 437,               /* "ITEM-VALUE"  */
  YYSYMBOL_I_O = 438,                      /* "I-O"  */
  YYSYMBOL_I_O_CONTROL = 439,              /* "I-O-CONTROL"  */
  YYSYMBOL_JSON = 440,                     /* JSON  */
  YYSYMBOL_JUSTIFIED = 441,                /* JUSTIFIED  */
  YYSYMBOL_KEPT = 442,                     /* KEPT  */
  YYSYMBOL_KEY = 443,                      /* KEY  */
  YYSYMBOL_KEYBOARD = 444,                 /* KEYBOARD  */
  YYSYMBOL_LABEL = 445,                    /* LABEL  */
  YYSYMBOL_LABEL_OFFSET = 446,             /* "LABEL-OFFSET"  */
  YYSYMBOL_LARGE_FONT = 447,               /* "LARGE-FONT"  */
  YYSYMBOL_LARGE_OFFSET = 448,             /* "LARGE-OFFSET"  */
  YYSYMBOL_LAST = 449,                     /* LAST  */
  YYSYMBOL_LAST_ROW = 450,                 /* "LAST-ROW"  */
  YYSYMBOL_LAYOUT_DATA = 451,              /* "LAYOUT-DATA"  */
  YYSYMBOL_LAYOUT_MANAGER = 452,           /* "LAYOUT-MANAGER"  */
  YYSYMBOL_LEADING = 453,                  /* LEADING  */
  YYSYMBOL_LEADING_SHIFT = 454,            /* "LEADING-SHIFT"  */
  YYSYMBOL_LEAVE = 455,                    /* LEAVE  */
  YYSYMBOL_LEFT = 456,                     /* LEFT  */
  YYSYMBOL_LEFTLINE = 457,                 /* LEFTLINE  */
  YYSYMBOL_LEFT_TEXT = 458,                /* "LEFT-TEXT"  */
  YYSYMBOL_LENGTH = 459,                   /* LENGTH  */
  YYSYMBOL_LENGTH_OF = 460,                /* "LENGTH OF"  */
  YYSYMBOL_LENGTH_FUNC = 461,              /* "FUNCTION LENGTH/BYTE-LENGTH"  */
  YYSYMBOL_LESS = 462,                     /* LESS  */
  YYSYMBOL_LESS_OR_EQUAL = 463,            /* "LESS OR EQUAL"  */
  YYSYMBOL_LEVEL_NUMBER = 464,             /* "level-number"  */
  YYSYMBOL_LIKE = 465,                     /* LIKE  */
  YYSYMBOL_LIMIT = 466,                    /* LIMIT  */
  YYSYMBOL_LIMITS = 467,                   /* LIMITS  */
  YYSYMBOL_LINAGE = 468,                   /* LINAGE  */
  YYSYMBOL_LINAGE_COUNTER = 469,           /* "LINAGE-COUNTER"  */
  YYSYMBOL_LINE = 470,                     /* LINE  */
  YYSYMBOL_LINE_COUNTER = 471,             /* "LINE-COUNTER"  */
  YYSYMBOL_LINE_LIMIT = 472,               /* "LINE LIMIT"  */
  YYSYMBOL_LINE_SEQUENTIAL = 473,          /* "LINE-SEQUENTIAL"  */
  YYSYMBOL_LINES = 474,                    /* LINES  */
  YYSYMBOL_LINES_AT_ROOT = 475,            /* "LINES-AT-ROOT"  */
  YYSYMBOL_LINKAGE = 476,                  /* LINKAGE  */
  YYSYMBOL_LIST_BOX = 477,                 /* "LIST-BOX"  */
  YYSYMBOL_LITERAL = 478,                  /* "Literal"  */
  YYSYMBOL_LM_RESIZE = 479,                /* "LM-RESIZE"  */
  YYSYMBOL_LOC = 480,                      /* LOC  */
  YYSYMBOL_LOCALE = 481,                   /* LOCALE  */
  YYSYMBOL_LOCALE_DATE_FUNC = 482,         /* "FUNCTION LOCALE-DATE"  */
  YYSYMBOL_LOCALE_TIME_FUNC = 483,         /* "FUNCTION LOCALE-TIME"  */
  YYSYMBOL_LOCALE_TIME_FROM_FUNC = 484,    /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
  YYSYMBOL_LOCAL_STORAGE = 485,            /* "LOCAL-STORAGE"  */
  YYSYMBOL_LOCK = 486,                     /* LOCK  */
  YYSYMBOL_LOCK_HOLDING = 487,             /* "LOCK-HOLDING"  */
  YYSYMBOL_LONG_DATE = 488,                /* "LONG-DATE"  */
  YYSYMBOL_LOWER = 489,                    /* LOWER  */
  YYSYMBOL_LOWERED = 490,                  /* LOWERED  */
  YYSYMBOL_LOWER_CASE_FUNC = 491,          /* "FUNCTION LOWER-CASE"  */
  YYSYMBOL_LOWLIGHT = 492,                 /* LOWLIGHT  */
  YYSYMBOL_LOW_COLOR = 493,                /* "LOW-COLOR"  */
  YYSYMBOL_LOW_VALUE = 494,                /* "LOW-VALUE"  */
  YYSYMBOL_MAGNETIC_TAPE = 495,            /* "MAGNETIC-TAPE"  */
  YYSYMBOL_MANUAL = 496,                   /* MANUAL  */
  YYSYMBOL_MASS_UPDATE = 497,              /* "MASS-UPDATE"  */
  YYSYMBOL_MASTER_INDEX = 498,             /* "MASTER-INDEX"  */
  YYSYMBOL_MAX_LINES = 499,                /* "MAX-LINES"  */
  YYSYMBOL_MAX_PROGRESS = 500,             /* "MAX-PROGRESS"  */
  YYSYMBOL_MAX_TEXT = 501,                 /* "MAX-TEXT"  */
  YYSYMBOL_MAX_VAL = 502,                  /* "MAX-VAL"  */
  YYSYMBOL_MEMORY = 503,                   /* MEMORY  */
  YYSYMBOL_MEDIUM_FONT = 504,              /* "MEDIUM-FONT"  */
  YYSYMBOL_MENU = 505,                     /* MENU  */
  YYSYMBOL_MERGE = 506,                    /* MERGE  */
  YYSYMBOL_MESSAGE = 507,                  /* MESSAGE  */
  YYSYMBOL_MICROSECOND_TIME = 508,         /* "MICROSECOND-TIME"  */
  YYSYMBOL_MINUS = 509,                    /* MINUS  */
  YYSYMBOL_MIN_VAL = 510,                  /* "MIN-VAL"  */
  YYSYMBOL_MNEMONIC_NAME = 511,            /* "Mnemonic name"  */
  YYSYMBOL_MODE = 512,                     /* MODE  */
  YYSYMBOL_MODIFY = 513,                   /* MODIFY  */
  YYSYMBOL_MODULES = 514,                  /* MODULES  */
  YYSYMBOL_MOVE = 515,                     /* MOVE  */
  YYSYMBOL_MULTILINE = 516,                /* MULTILINE  */
  YYSYMBOL_MULTIPLE = 517,                 /* MULTIPLE  */
  YYSYMBOL_MULTIPLY = 518,                 /* MULTIPLY  */
  YYSYMBOL_NAME = 519,                     /* NAME  */
  YYSYMBOL_NAMED = 520,                    /* NAMED  */
  YYSYMBOL_NAMESPACE = 521,                /* NAMESPACE  */
  YYSYMBOL_NAMESPACE_PREFIX = 522,         /* "NAMESPACE-PREFIX"  */
  YYSYMBOL_NATIONAL = 523,                 /* NATIONAL  */
  YYSYMBOL_NATIONAL_EDITED = 524,          /* "NATIONAL-EDITED"  */
  YYSYMBOL_NATIONAL_OF_FUNC = 525,         /* "FUNCTION NATIONAL-OF"  */
  YYSYMBOL_NATIVE = 526,                   /* NATIVE  */
  YYSYMBOL_NAVIGATE_URL = 527,             /* "NAVIGATE-URL"  */
  YYSYMBOL_NEAREST_AWAY_FROM_ZERO = 528,   /* "NEAREST-AWAY-FROM-ZERO"  */
  YYSYMBOL_NEAREST_EVEN = 529,             /* "NEAREST-EVEN"  */
  YYSYMBOL_NEAREST_TOWARD_ZERO = 530,      /* "NEAREST-TOWARD-ZERO"  */
  YYSYMBOL_NEGATIVE = 531,                 /* NEGATIVE  */
  YYSYMBOL_NESTED = 532,                   /* NESTED  */
  YYSYMBOL_NEW = 533,                      /* NEW  */
  YYSYMBOL_NEXT = 534,                     /* NEXT  */
  YYSYMBOL_NEXT_ITEM = 535,                /* "NEXT-ITEM"  */
  YYSYMBOL_NEXT_GROUP = 536,               /* "NEXT GROUP"  */
  YYSYMBOL_NEXT_PAGE = 537,                /* "NEXT PAGE"  */
  YYSYMBOL_NO = 538,                       /* NO  */
  YYSYMBOL_NO_ADVANCING = 539,             /* "NO ADVANCING"  */
  YYSYMBOL_NO_AUTOSEL = 540,               /* "NO-AUTOSEL"  */
  YYSYMBOL_NO_AUTO_DEFAULT = 541,          /* "NO-AUTO-DEFAULT"  */
  YYSYMBOL_NO_BOX = 542,                   /* "NO-BOX"  */
  YYSYMBOL_NO_DATA = 543,                  /* "NO DATA"  */
  YYSYMBOL_NO_DIVIDERS = 544,              /* "NO-DIVIDERS"  */
  YYSYMBOL_NO_ECHO = 545,                  /* "NO-ECHO"  */
  YYSYMBOL_NO_F4 = 546,                    /* "NO-F4"  */
  YYSYMBOL_NO_FOCUS = 547,                 /* "NO-FOCUS"  */
  YYSYMBOL_NO_GROUP_TAB = 548,             /* "NO-GROUP-TAB"  */
  YYSYMBOL_NO_KEY_LETTER = 549,            /* "NO-KEY-LETTER"  */
  YYSYMBOL_NO_SEARCH = 550,                /* "NO-SEARCH"  */
  YYSYMBOL_NO_UPDOWN = 551,                /* "NO-UPDOWN"  */
  YYSYMBOL_NOMINAL = 552,                  /* NOMINAL  */
  YYSYMBOL_NONE = 553,                     /* NONE  */
  YYSYMBOL_NONNUMERIC = 554,               /* NONNUMERIC  */
  YYSYMBOL_NORMAL = 555,                   /* NORMAL  */
  YYSYMBOL_NOT = 556,                      /* NOT  */
  YYSYMBOL_NOTAB = 557,                    /* NOTAB  */
  YYSYMBOL_NOTHING = 558,                  /* NOTHING  */
  YYSYMBOL_NOTIFY = 559,                   /* NOTIFY  */
  YYSYMBOL_NOTIFY_CHANGE = 560,            /* "NOTIFY-CHANGE"  */
  YYSYMBOL_NOTIFY_DBLCLICK = 561,          /* "NOTIFY-DBLCLICK"  */
  YYSYMBOL_NOTIFY_SELCHANGE = 562,         /* "NOTIFY-SELCHANGE"  */
  YYSYMBOL_NOT_AT_END = 563,               /* "NOT AT END"  */
  YYSYMBOL_NOT_EOP = 564,                  /* "NOT AT EOP"  */
  YYSYMBOL_NOT_ON_ESCAPE = 565,            /* "NOT ON ESCAPE"  */
  YYSYMBOL_NOT_EQUAL = 566,                /* "NOT EQUAL"  */
  YYSYMBOL_NOT_ON_EXCEPTION = 567,         /* "NOT ON EXCEPTION"  */
  YYSYMBOL_NOT_INVALID_KEY = 568,          /* "NOT INVALID KEY"  */
  YYSYMBOL_NOT_ON_OVERFLOW = 569,          /* "NOT ON OVERFLOW"  */
  YYSYMBOL_NOT_SIZE_ERROR = 570,           /* "NOT SIZE ERROR"  */
  YYSYMBOL_NUM_COL_HEADINGS = 571,         /* "NUM-COL-HEADINGS"  */
  YYSYMBOL_NUM_ROWS = 572,                 /* "NUM-ROWS"  */
  YYSYMBOL_NUMBER = 573,                   /* NUMBER  */
  YYSYMBOL_NUMBERS = 574,                  /* NUMBERS  */
  YYSYMBOL_NUMERIC = 575,                  /* NUMERIC  */
  YYSYMBOL_NUMERIC_EDITED = 576,           /* "NUMERIC-EDITED"  */
  YYSYMBOL_NUMVALC_FUNC = 577,             /* "FUNCTION NUMVAL-C"  */
  YYSYMBOL_OBJECT = 578,                   /* OBJECT  */
  YYSYMBOL_OBJECT_COMPUTER = 579,          /* "OBJECT-COMPUTER"  */
  YYSYMBOL_OCCURS = 580,                   /* OCCURS  */
  YYSYMBOL_OF = 581,                       /* OF  */
  YYSYMBOL_OFF = 582,                      /* OFF  */
  YYSYMBOL_OK_BUTTON = 583,                /* "OK-BUTTON"  */
  YYSYMBOL_OMITTED = 584,                  /* OMITTED  */
  YYSYMBOL_ON = 585,                       /* ON  */
  YYSYMBOL_ONLY = 586,                     /* ONLY  */
  YYSYMBOL_ON_ESCAPE = 587,                /* "ON ESCAPE"  */
  YYSYMBOL_ON_EXCEPTION = 588,             /* "ON EXCEPTION"  */
  YYSYMBOL_OPEN = 589,                     /* OPEN  */
  YYSYMBOL_OPTIONAL = 590,                 /* OPTIONAL  */
  YYSYMBOL_OPTIONS = 591,                  /* OPTIONS  */
  YYSYMBOL_OR = 592,                       /* OR  */
  YYSYMBOL_ORDER = 593,                    /* ORDER  */
  YYSYMBOL_ORGANIZATION = 594,             /* ORGANIZATION  */
  YYSYMBOL_OTHER = 595,                    /* OTHER  */
  YYSYMBOL_OTHERS = 596,                   /* OTHERS  */
  YYSYMBOL_OUTPUT = 597,                   /* OUTPUT  */
  YYSYMBOL_OVERLAP_LEFT = 598,             /* "OVERLAP-LEFT"  */
  YYSYMBOL_OVERLAP_TOP = 599,              /* "OVERLAP-TOP"  */
  YYSYMBOL_OVERLINE = 600,                 /* OVERLINE  */
  YYSYMBOL_PACKED_DECIMAL = 601,           /* "PACKED-DECIMAL"  */
  YYSYMBOL_PADDING = 602,                  /* PADDING  */
  YYSYMBOL_PASCAL = 603,                   /* PASCAL  */
  YYSYMBOL_PAGE = 604,                     /* PAGE  */
  YYSYMBOL_PAGE_COUNTER = 605,             /* "PAGE-COUNTER"  */
  YYSYMBOL_PAGE_SETUP = 606,               /* "PAGE-SETUP"  */
  YYSYMBOL_PAGED = 607,                    /* PAGED  */
  YYSYMBOL_PARAGRAPH = 608,                /* PARAGRAPH  */
  YYSYMBOL_PARENT = 609,                   /* PARENT  */
  YYSYMBOL_PARSE = 610,                    /* PARSE  */
  YYSYMBOL_PASSWORD = 611,                 /* PASSWORD  */
  YYSYMBOL_PERFORM = 612,                  /* PERFORM  */
  YYSYMBOL_PERMANENT = 613,                /* PERMANENT  */
  YYSYMBOL_PH = 614,                       /* PH  */
  YYSYMBOL_PF = 615,                       /* PF  */
  YYSYMBOL_PHYSICAL = 616,                 /* PHYSICAL  */
  YYSYMBOL_PICTURE = 617,                  /* PICTURE  */
  YYSYMBOL_PICTURE_SYMBOL = 618,           /* "PICTURE SYMBOL"  */
  YYSYMBOL_PIXEL = 619,                    /* PIXEL  */
  YYSYMBOL_PLACEMENT = 620,                /* PLACEMENT  */
  YYSYMBOL_PLUS = 621,                     /* PLUS  */
  YYSYMBOL_POINTER = 622,                  /* POINTER  */
  YYSYMBOL_POP_UP = 623,                   /* "POP-UP"  */
  YYSYMBOL_POS = 624,                      /* POS  */
  YYSYMBOL_POSITION = 625,                 /* POSITION  */
  YYSYMBOL_POSITION_SHIFT = 626,           /* "POSITION-SHIFT"  */
  YYSYMBOL_POSITIVE = 627,                 /* POSITIVE  */
  YYSYMBOL_PRESENT = 628,                  /* PRESENT  */
  YYSYMBOL_PREVIOUS = 629,                 /* PREVIOUS  */
  YYSYMBOL_PRINT = 630,                    /* PRINT  */
  YYSYMBOL_PRINT_CONTROL = 631,            /* "PRINT-CONTROL"  */
  YYSYMBOL_PRINT_NO_PROMPT = 632,          /* "PRINT-NO-PROMPT"  */
  YYSYMBOL_PRINT_PREVIEW = 633,            /* "PRINT-PREVIEW"  */
  YYSYMBOL_PRINTER = 634,                  /* PRINTER  */
  YYSYMBOL_PRINTER_1 = 635,                /* "PRINTER-1"  */
  YYSYMBOL_PRINTING = 636,                 /* PRINTING  */
  YYSYMBOL_PRIORITY = 637,                 /* PRIORITY  */
  YYSYMBOL_PROCEDURE = 638,                /* PROCEDURE  */
  YYSYMBOL_PROCEDURES = 639,               /* PROCEDURES  */
  YYSYMBOL_PROCEED = 640,                  /* PROCEED  */
  YYSYMBOL_PROCESSING = 641,               /* PROCESSING  */
  YYSYMBOL_PROGRAM = 642,                  /* PROGRAM  */
  YYSYMBOL_PROGRAM_ID = 643,               /* "PROGRAM-ID"  */
  YYSYMBOL_PROGRAM_NAME = 644,             /* "program name"  */
  YYSYMBOL_PROGRAM_POINTER = 645,          /* "PROGRAM-POINTER"  */
  YYSYMBOL_PROGRESS = 646,                 /* PROGRESS  */
  YYSYMBOL_PROHIBITED = 647,               /* PROHIBITED  */
  YYSYMBOL_PROMPT = 648,                   /* PROMPT  */
  YYSYMBOL_PROPERTIES = 649,               /* PROPERTIES  */
  YYSYMBOL_PROPERTY = 650,                 /* PROPERTY  */
  YYSYMBOL_PROTECTED = 651,                /* PROTECTED  */
  YYSYMBOL_PROTOTYPE = 652,                /* PROTOTYPE  */
  YYSYMBOL_PURGE = 653,                    /* PURGE  */
  YYSYMBOL_PUSH_BUTTON = 654,              /* "PUSH-BUTTON"  */
  YYSYMBOL_QUERY_INDEX = 655,              /* "QUERY-INDEX"  */
  YYSYMBOL_QUEUE = 656,                    /* QUEUE  */
  YYSYMBOL_QUOTE = 657,                    /* QUOTE  */
  YYSYMBOL_RADIO_BUTTON = 658,             /* "RADIO-BUTTON"  */
  YYSYMBOL_RAISE = 659,                    /* RAISE  */
  YYSYMBOL_RAISED = 660,                   /* RAISED  */
  YYSYMBOL_RAISING = 661,                  /* RAISING  */
  YYSYMBOL_RANDOM = 662,                   /* RANDOM  */
  YYSYMBOL_RD = 663,                       /* RD  */
  YYSYMBOL_READ = 664,                     /* READ  */
  YYSYMBOL_READERS = 665,                  /* READERS  */
  YYSYMBOL_READ_ONLY = 666,                /* "READ-ONLY"  */
  YYSYMBOL_READY_TRACE = 667,              /* "READY TRACE"  */
  YYSYMBOL_RECEIVE = 668,                  /* RECEIVE  */
  YYSYMBOL_RECEIVED = 669,                 /* RECEIVED  */
  YYSYMBOL_RECORD = 670,                   /* RECORD  */
  YYSYMBOL_RECORD_DATA = 671,              /* "RECORD-DATA"  */
  YYSYMBOL_RECORD_OVERFLOW = 672,          /* "RECORD-OVERFLOW"  */
  YYSYMBOL_RECORD_TO_ADD = 673,            /* "RECORD-TO-ADD"  */
  YYSYMBOL_RECORD_TO_DELETE = 674,         /* "RECORD-TO-DELETE"  */
  YYSYMBOL_RECORDING = 675,                /* RECORDING  */
  YYSYMBOL_RECORDS = 676,                  /* RECORDS  */
  YYSYMBOL_RECURSIVE = 677,                /* RECURSIVE  */
  YYSYMBOL_REDEFINES = 678,                /* REDEFINES  */
  YYSYMBOL_REEL = 679,                     /* REEL  */
  YYSYMBOL_REFERENCE = 680,                /* REFERENCE  */
  YYSYMBOL_REFERENCES = 681,               /* REFERENCES  */
  YYSYMBOL_REFRESH = 682,                  /* REFRESH  */
  YYSYMBOL_REGION_COLOR = 683,             /* "REGION-COLOR"  */
  YYSYMBOL_RELATION = 684,                 /* RELATION  */
  YYSYMBOL_RELATIVE = 685,                 /* RELATIVE  */
  YYSYMBOL_RELEASE = 686,                  /* RELEASE  */
  YYSYMBOL_REMAINDER = 687,                /* REMAINDER  */
  YYSYMBOL_REMARKS = 688,                  /* REMARKS  */
  YYSYMBOL_REMOVAL = 689,                  /* REMOVAL  */
  YYSYMBOL_RENAMES = 690,                  /* RENAMES  */
  YYSYMBOL_REORG_CRITERIA = 691,           /* "REORG-CRITERIA"  */
  YYSYMBOL_REPEATED = 692,                 /* REPEATED  */
  YYSYMBOL_REPLACE = 693,                  /* REPLACE  */
  YYSYMBOL_REPLACING = 694,                /* REPLACING  */
  YYSYMBOL_REPORT = 695,                   /* REPORT  */
  YYSYMBOL_REPORTING = 696,                /* REPORTING  */
  YYSYMBOL_REPORTS = 697,                  /* REPORTS  */
  YYSYMBOL_REPOSITORY = 698,               /* REPOSITORY  */
  YYSYMBOL_REQUIRED = 699,                 /* REQUIRED  */
  YYSYMBOL_REREAD = 700,                   /* REREAD  */
  YYSYMBOL_RERUN = 701,                    /* RERUN  */
  YYSYMBOL_RESERVE = 702,                  /* RESERVE  */
  YYSYMBOL_RESET = 703,                    /* RESET  */
  YYSYMBOL_RESET_TRACE = 704,              /* "RESET TRACE"  */
  YYSYMBOL_RESET_GRID = 705,               /* "RESET-GRID"  */
  YYSYMBOL_RESET_LIST = 706,               /* "RESET-LIST"  */
  YYSYMBOL_RESET_TABS = 707,               /* "RESET-TABS"  */
  YYSYMBOL_RETRY = 708,                    /* RETRY  */
  YYSYMBOL_RETURN = 709,                   /* RETURN  */
  YYSYMBOL_RETURNING = 710,                /* RETURNING  */
  YYSYMBOL_REVERSE = 711,                  /* REVERSE  */
  YYSYMBOL_REVERSE_FUNC = 712,             /* "FUNCTION REVERSE"  */
  YYSYMBOL_REVERSE_VIDEO = 713,            /* "REVERSE-VIDEO"  */
  YYSYMBOL_REVERSED = 714,                 /* REVERSED  */
  YYSYMBOL_REWIND = 715,                   /* REWIND  */
  YYSYMBOL_REWRITE = 716,                  /* REWRITE  */
  YYSYMBOL_RF = 717,                       /* RF  */
  YYSYMBOL_RH = 718,                       /* RH  */
  YYSYMBOL_RIGHT = 719,                    /* RIGHT  */
  YYSYMBOL_RIGHT_ALIGN = 720,              /* "RIGHT-ALIGN"  */
  YYSYMBOL_RIMMED = 721,                   /* RIMMED  */
  YYSYMBOL_ROLLBACK = 722,                 /* ROLLBACK  */
  YYSYMBOL_ROUNDED = 723,                  /* ROUNDED  */
  YYSYMBOL_ROUNDING = 724,                 /* ROUNDING  */
  YYSYMBOL_ROW_COLOR = 725,                /* "ROW-COLOR"  */
  YYSYMBOL_ROW_COLOR_PATTERN = 726,        /* "ROW-COLOR-PATTERN"  */
  YYSYMBOL_ROW_DIVIDERS = 727,             /* "ROW-DIVIDERS"  */
  YYSYMBOL_ROW_FONT = 728,                 /* "ROW-FONT"  */
  YYSYMBOL_ROW_HEADINGS = 729,             /* "ROW-HEADINGS"  */
  YYSYMBOL_ROW_PROTECTION = 730,           /* "ROW-PROTECTION"  */
  YYSYMBOL_RUN = 731,                      /* RUN  */
  YYSYMBOL_S = 732,                        /* S  */
  YYSYMBOL_SAME = 733,                     /* SAME  */
  YYSYMBOL_SAVE_AS = 734,                  /* "SAVE-AS"  */
  YYSYMBOL_SAVE_AS_NO_PROMPT = 735,        /* "SAVE-AS-NO-PROMPT"  */
  YYSYMBOL_SCREEN = 736,                   /* SCREEN  */
  YYSYMBOL_SCREEN_CONTROL = 737,           /* "SCREEN CONTROL"  */
  YYSYMBOL_SCROLL = 738,                   /* SCROLL  */
  YYSYMBOL_SCROLL_BAR = 739,               /* "SCROLL-BAR"  */
  YYSYMBOL_SD = 740,                       /* SD  */
  YYSYMBOL_SEARCH = 741,                   /* SEARCH  */
  YYSYMBOL_SEARCH_OPTIONS = 742,           /* "SEARCH-OPTIONS"  */
  YYSYMBOL_SEARCH_TEXT = 743,              /* "SEARCH-TEXT"  */
  YYSYMBOL_SECONDS = 744,                  /* SECONDS  */
  YYSYMBOL_SECTION = 745,                  /* SECTION  */
  YYSYMBOL_SECURE = 746,                   /* SECURE  */
  YYSYMBOL_SECURITY = 747,                 /* SECURITY  */
  YYSYMBOL_SEGMENT = 748,                  /* SEGMENT  */
  YYSYMBOL_SEGMENT_LIMIT = 749,            /* "SEGMENT-LIMIT"  */
  YYSYMBOL_SELECT = 750,                   /* SELECT  */
  YYSYMBOL_SELECTION_INDEX = 751,          /* "SELECTION-INDEX"  */
  YYSYMBOL_SELECTION_TEXT = 752,           /* "SELECTION-TEXT"  */
  YYSYMBOL_SELECT_ALL = 753,               /* "SELECTION-ALL"  */
  YYSYMBOL_SELF_ACT = 754,                 /* "SELF-ACT"  */
  YYSYMBOL_SEMI_COLON = 755,               /* "semi-colon"  */
  YYSYMBOL_SEND = 756,                     /* SEND  */
  YYSYMBOL_SENTENCE = 757,                 /* SENTENCE  */
  YYSYMBOL_SEPARATE = 758,                 /* SEPARATE  */
  YYSYMBOL_SEPARATION = 759,               /* SEPARATION  */
  YYSYMBOL_SEQUENCE = 760,                 /* SEQUENCE  */
  YYSYMBOL_SEQUENTIAL = 761,               /* SEQUENTIAL  */
  YYSYMBOL_SET = 762,                      /* SET  */
  YYSYMBOL_SEVENTY_EIGHT = 763,            /* "level-number 78"  */
  YYSYMBOL_SHADING = 764,                  /* SHADING  */
  YYSYMBOL_SHADOW = 765,                   /* SHADOW  */
  YYSYMBOL_SHARING = 766,                  /* SHARING  */
  YYSYMBOL_SHORT_DATE = 767,               /* "SHORT-DATE"  */
  YYSYMBOL_SHOW_LINES = 768,               /* "SHOW-LINES"  */
  YYSYMBOL_SHOW_NONE = 769,                /* "SHOW-NONE"  */
  YYSYMBOL_SHOW_SEL_ALWAYS = 770,          /* "SHOW-SEL-ALWAYS"  */
  YYSYMBOL_SIGN = 771,                     /* SIGN  */
  YYSYMBOL_SIGNED = 772,                   /* SIGNED  */
  YYSYMBOL_SIGNED_INT = 773,               /* "SIGNED-INT"  */
  YYSYMBOL_SIGNED_LONG = 774,              /* "SIGNED-LONG"  */
  YYSYMBOL_SIGNED_SHORT = 775,             /* "SIGNED-SHORT"  */
  YYSYMBOL_SIXTY_SIX = 776,                /* "level-number 66"  */
  YYSYMBOL_SIZE = 777,                     /* SIZE  */
  YYSYMBOL_SIZE_ERROR = 778,               /* "SIZE ERROR"  */
  YYSYMBOL_SMALL_FONT = 779,               /* "SMALL-FONT"  */
  YYSYMBOL_SORT = 780,                     /* SORT  */
  YYSYMBOL_SORT_MERGE = 781,               /* "SORT-MERGE"  */
  YYSYMBOL_SORT_ORDER = 782,               /* "SORT-ORDER"  */
  YYSYMBOL_SOURCE = 783,                   /* SOURCE  */
  YYSYMBOL_SOURCE_COMPUTER = 784,          /* "SOURCE-COMPUTER"  */
  YYSYMBOL_SPACE = 785,                    /* SPACE  */
  YYSYMBOL_SPECIAL_NAMES = 786,            /* "SPECIAL-NAMES"  */
  YYSYMBOL_SPINNER = 787,                  /* SPINNER  */
  YYSYMBOL_SQUARE = 788,                   /* SQUARE  */
  YYSYMBOL_STANDARD = 789,                 /* STANDARD  */
  YYSYMBOL_STANDARD_1 = 790,               /* "STANDARD-1"  */
  YYSYMBOL_STANDARD_2 = 791,               /* "STANDARD-2"  */
  YYSYMBOL_STANDARD_BINARY = 792,          /* "STANDARD-BINARY"  */
  YYSYMBOL_STANDARD_DECIMAL = 793,         /* "STANDARD-DECIMAL"  */
  YYSYMBOL_START = 794,                    /* START  */
  YYSYMBOL_START_X = 795,                  /* "START-X"  */
  YYSYMBOL_START_Y = 796,                  /* "START-Y"  */
  YYSYMBOL_STATIC = 797,                   /* STATIC  */
  YYSYMBOL_STATIC_LIST = 798,              /* "STATIC-LIST"  */
  YYSYMBOL_STATUS = 799,                   /* STATUS  */
  YYSYMBOL_STATUS_BAR = 800,               /* "STATUS-BAR"  */
  YYSYMBOL_STATUS_TEXT = 801,              /* "STATUS-TEXT"  */
  YYSYMBOL_STDCALL = 802,                  /* STDCALL  */
  YYSYMBOL_STEP = 803,                     /* STEP  */
  YYSYMBOL_STOP = 804,                     /* STOP  */
  YYSYMBOL_STRING = 805,                   /* STRING  */
  YYSYMBOL_STRONG = 806,                   /* STRONG  */
  YYSYMBOL_STYLE = 807,                    /* STYLE  */
  YYSYMBOL_SUB_QUEUE_1 = 808,              /* "SUB-QUEUE-1"  */
  YYSYMBOL_SUB_QUEUE_2 = 809,              /* "SUB-QUEUE-2"  */
  YYSYMBOL_SUB_QUEUE_3 = 810,              /* "SUB-QUEUE-3"  */
  YYSYMBOL_SUBSTITUTE_FUNC = 811,          /* "FUNCTION SUBSTITUTE"  */
  YYSYMBOL_SUBSTITUTE_CASE_FUNC = 812,     /* "FUNCTION SUBSTITUTE-CASE"  */
  YYSYMBOL_SUBTRACT = 813,                 /* SUBTRACT  */
  YYSYMBOL_SUBWINDOW = 814,                /* SUBWINDOW  */
  YYSYMBOL_SUM = 815,                      /* SUM  */
  YYSYMBOL_SUPPRESS = 816,                 /* SUPPRESS  */
  YYSYMBOL_SUPPRESS_XML = 817,             /* "SUPPRESS"  */
  YYSYMBOL_SYMBOLIC = 818,                 /* SYMBOLIC  */
  YYSYMBOL_SYNCHRONIZED = 819,             /* SYNCHRONIZED  */
  YYSYMBOL_SYSTEM_DEFAULT = 820,           /* "SYSTEM-DEFAULT"  */
  YYSYMBOL_SYSTEM_INFO = 821,              /* "SYSTEM-INFO"  */
  YYSYMBOL_SYSTEM_OFFSET = 822,            /* "SYSTEM-OFFSET"  */
  YYSYMBOL_TAB = 823,                      /* TAB  */
  YYSYMBOL_TAB_TO_ADD = 824,               /* "TAB-TO-ADD"  */
  YYSYMBOL_TAB_TO_DELETE = 825,            /* "TAB-TO-DELETE"  */
  YYSYMBOL_TABLE = 826,                    /* TABLE  */
  YYSYMBOL_TALLYING = 827,                 /* TALLYING  */
  YYSYMBOL_TEMPORARY = 828,                /* TEMPORARY  */
  YYSYMBOL_TAPE = 829,                     /* TAPE  */
  YYSYMBOL_TERMINAL = 830,                 /* TERMINAL  */
  YYSYMBOL_TERMINATE = 831,                /* TERMINATE  */
  YYSYMBOL_TERMINAL_INFO = 832,            /* "TERMINAL-INFO"  */
  YYSYMBOL_TERMINATION_VALUE = 833,        /* "TERMINATION-VALUE"  */
  YYSYMBOL_TEST = 834,                     /* TEST  */
  YYSYMBOL_TEXT = 835,                     /* TEXT  */
  YYSYMBOL_THAN = 836,                     /* THAN  */
  YYSYMBOL_THEN = 837,                     /* THEN  */
  YYSYMBOL_THREAD = 838,                   /* THREAD  */
  YYSYMBOL_THREADS = 839,                  /* THREADS  */
  YYSYMBOL_THRU = 840,                     /* THRU  */
  YYSYMBOL_THUMB_POSITION = 841,           /* "THUMB-POSITION"  */
  YYSYMBOL_TILED_HEADINGS = 842,           /* "TILED-HEADINGS"  */
  YYSYMBOL_TIME = 843,                     /* TIME  */
  YYSYMBOL_TIME_OUT = 844,                 /* "TIME-OUT"  */
  YYSYMBOL_TIMES = 845,                    /* TIMES  */
  YYSYMBOL_TITLE = 846,                    /* TITLE  */
  YYSYMBOL_TITLE_POSITION = 847,           /* "TITLE-POSITION"  */
  YYSYMBOL_TO = 848,                       /* TO  */
  YYSYMBOL_TOK_AMPER = 849,                /* "&"  */
  YYSYMBOL_TOK_CLOSE_PAREN = 850,          /* ")"  */
  YYSYMBOL_TOK_COLON = 851,                /* ":"  */
  YYSYMBOL_TOK_DIV = 852,                  /* "/"  */
  YYSYMBOL_TOK_DOT = 853,                  /* "."  */
  YYSYMBOL_TOK_EQUAL = 854,                /* "="  */
  YYSYMBOL_TOK_EXTERN = 855,               /* "EXTERN"  */
  YYSYMBOL_TOK_FALSE = 856,                /* "FALSE"  */
  YYSYMBOL_TOK_FILE = 857,                 /* "FILE"  */
  YYSYMBOL_TOK_GREATER = 858,              /* ">"  */
  YYSYMBOL_TOK_INITIAL = 859,              /* "INITIAL"  */
  YYSYMBOL_TOK_LESS = 860,                 /* "<"  */
  YYSYMBOL_TOK_MINUS = 861,                /* "-"  */
  YYSYMBOL_TOK_MUL = 862,                  /* "*"  */
  YYSYMBOL_TOK_NULL = 863,                 /* "NULL"  */
  YYSYMBOL_TOK_OVERFLOW = 864,             /* "OVERFLOW"  */
  YYSYMBOL_TOK_OPEN_PAREN = 865,           /* "("  */
  YYSYMBOL_TOK_PLUS = 866,                 /* "+"  */
  YYSYMBOL_TOK_TRUE = 867,                 /* "TRUE"  */
  YYSYMBOL_TOP = 868,                      /* TOP  */
  YYSYMBOL_TOWARD_GREATER = 869,           /* "TOWARD-GREATER"  */
  YYSYMBOL_TOWARD_LESSER = 870,            /* "TOWARD-LESSER"  */
  YYSYMBOL_TRACK = 871,                    /* TRACK  */
  YYSYMBOL_TRACKS = 872,                   /* TRACKS  */
  YYSYMBOL_TRACK_AREA = 873,               /* "TRACK-AREA"  */
  YYSYMBOL_TRACK_LIMIT = 874,              /* "TRACK-LIMIT"  */
  YYSYMBOL_TRADITIONAL_FONT = 875,         /* "TRADITIONAL-FONT"  */
  YYSYMBOL_TRAILING = 876,                 /* TRAILING  */
  YYSYMBOL_TRAILING_SHIFT = 877,           /* "TRAILING-SHIFT"  */
  YYSYMBOL_TRANSFORM = 878,                /* TRANSFORM  */
  YYSYMBOL_TRANSPARENT = 879,              /* TRANSPARENT  */
  YYSYMBOL_TREE_VIEW = 880,                /* "TREE-VIEW"  */
  YYSYMBOL_TRIM_FUNC = 881,                /* "FUNCTION TRIM"  */
  YYSYMBOL_TRUNCATION = 882,               /* TRUNCATION  */
  YYSYMBOL_TYPE = 883,                     /* TYPE  */
  YYSYMBOL_TYPEDEF = 884,                  /* TYPEDEF  */
  YYSYMBOL_U = 885,                        /* U  */
  YYSYMBOL_UCS_4 = 886,                    /* "UCS-4"  */
  YYSYMBOL_UNBOUNDED = 887,                /* UNBOUNDED  */
  YYSYMBOL_UNDERLINE = 888,                /* UNDERLINE  */
  YYSYMBOL_UNFRAMED = 889,                 /* UNFRAMED  */
  YYSYMBOL_UNIT = 890,                     /* UNIT  */
  YYSYMBOL_UNLOCK = 891,                   /* UNLOCK  */
  YYSYMBOL_UNSIGNED = 892,                 /* UNSIGNED  */
  YYSYMBOL_UNSIGNED_INT = 893,             /* "UNSIGNED-INT"  */
  YYSYMBOL_UNSIGNED_LONG = 894,            /* "UNSIGNED-LONG"  */
  YYSYMBOL_UNSIGNED_SHORT = 895,           /* "UNSIGNED-SHORT"  */
  YYSYMBOL_UNSORTED = 896,                 /* UNSORTED  */
  YYSYMBOL_UNSTRING = 897,                 /* UNSTRING  */
  YYSYMBOL_UNTIL = 898,                    /* UNTIL  */
  YYSYMBOL_UP = 899,                       /* UP  */
  YYSYMBOL_UPDATE = 900,                   /* UPDATE  */
  YYSYMBOL_UPDATERS = 901,                 /* UPDATERS  */
  YYSYMBOL_UPON = 902,                     /* UPON  */
  YYSYMBOL_UPON_ARGUMENT_NUMBER = 903,     /* "UPON ARGUMENT-NUMBER"  */
  YYSYMBOL_UPON_COMMAND_LINE = 904,        /* "UPON COMMAND-LINE"  */
  YYSYMBOL_UPON_ENVIRONMENT_NAME = 905,    /* "UPON ENVIRONMENT-NAME"  */
  YYSYMBOL_UPON_ENVIRONMENT_VALUE = 906,   /* "UPON ENVIRONMENT-VALUE"  */
  YYSYMBOL_UPPER = 907,                    /* UPPER  */
  YYSYMBOL_UPPER_CASE_FUNC = 908,          /* "FUNCTION UPPER-CASE"  */
  YYSYMBOL_USAGE = 909,                    /* USAGE  */
  YYSYMBOL_USE = 910,                      /* USE  */
  YYSYMBOL_USE_ALT = 911,                  /* "USE-ALT"  */
  YYSYMBOL_USE_RETURN = 912,               /* "USE-RETURN"  */
  YYSYMBOL_USE_TAB = 913,                  /* "USE-TAB"  */
  YYSYMBOL_USER = 914,                     /* USER  */
  YYSYMBOL_USER_DEFAULT = 915,             /* "USER-DEFAULT"  */
  YYSYMBOL_USER_FUNCTION_NAME = 916,       /* "user function name"  */
  YYSYMBOL_USING = 917,                    /* USING  */
  YYSYMBOL_UTF_8 = 918,                    /* "UTF-8"  */
  YYSYMBOL_UTF_16 = 919,                   /* "UTF-16"  */
  YYSYMBOL_V = 920,                        /* V  */
  YYSYMBOL_VALID = 921,                    /* VALID  */
  YYSYMBOL_VALIDATE = 922,                 /* VALIDATE  */
  YYSYMBOL_VAL_STATUS = 923,               /* "VAL-STATUS"  */
  YYSYMBOL_VALIDATE_STATUS = 924,          /* "VALIDATE-STATUS"  */
  YYSYMBOL_VALIDATING = 925,               /* VALIDATING  */
  YYSYMBOL_VALUE = 926,                    /* VALUE  */
  YYSYMBOL_VALUE_FORMAT = 927,             /* "VALUE-FORMAT"  */
  YYSYMBOL_VALUES = 928,                   /* VALUES  */
  YYSYMBOL_VARIABLE = 929,                 /* VARIABLE  */
  YYSYMBOL_VARIANT = 930,                  /* VARIANT  */
  YYSYMBOL_VARYING = 931,                  /* VARYING  */
  YYSYMBOL_VERTICAL = 932,                 /* VERTICAL  */
  YYSYMBOL_VERY_HEAVY = 933,               /* "VERY-HEAVY"  */
  YYSYMBOL_VIRTUAL_WIDTH = 934,            /* "VIRTUAL-WIDTH"  */
  YYSYMBOL_VOLATILE = 935,                 /* VOLATILE  */
  YYSYMBOL_VPADDING = 936,                 /* VPADDING  */
  YYSYMBOL_VSCROLL = 937,                  /* VSCROLL  */
  YYSYMBOL_VSCROLL_BAR = 938,              /* "VSCROLL-BAR"  */
  YYSYMBOL_VSCROLL_POS = 939,              /* "VSCROLL-POS"  */
  YYSYMBOL_VTOP = 940,                     /* VTOP  */
  YYSYMBOL_WAIT = 941,                     /* WAIT  */
  YYSYMBOL_WEB_BROWSER = 942,              /* "WEB-BROWSER"  */
  YYSYMBOL_WHEN = 943,                     /* WHEN  */
  YYSYMBOL_WHEN_COMPILED_FUNC = 944,       /* "FUNCTION WHEN-COMPILED"  */
  YYSYMBOL_WHEN_XML = 945,                 /* "WHEN"  */
  YYSYMBOL_WIDTH = 946,                    /* WIDTH  */
  YYSYMBOL_WIDTH_IN_CELLS = 947,           /* "WIDTH-IN-CELLS"  */
  YYSYMBOL_WINAPI = 948,                   /* WINAPI  */
  YYSYMBOL_WINDOW = 949,                   /* WINDOW  */
  YYSYMBOL_WITH = 950,                     /* WITH  */
  YYSYMBOL_WORD = 951,                     /* "Identifier"  */
  YYSYMBOL_WORDS = 952,                    /* WORDS  */
  YYSYMBOL_WORKING_STORAGE = 953,          /* "WORKING-STORAGE"  */
  YYSYMBOL_WRAP = 954,                     /* WRAP  */
  YYSYMBOL_WRITE = 955,                    /* WRITE  */
  YYSYMBOL_WRITE_ONLY = 956,               /* "WRITE-ONLY"  */
  YYSYMBOL_WRITE_VERIFY = 957,             /* "WRITE-VERIFY"  */
  YYSYMBOL_WRITERS = 958,                  /* WRITERS  */
  YYSYMBOL_X = 959,                        /* X  */
  YYSYMBOL_XML = 960,                      /* XML  */
  YYSYMBOL_XML_DECLARATION = 961,          /* "XML-DECLARATION"  */
  YYSYMBOL_XML_SCHEMA = 962,               /* "XML-SCHEMA"  */
  YYSYMBOL_Y = 963,                        /* Y  */
  YYSYMBOL_YYYYDDD = 964,                  /* YYYYDDD  */
  YYSYMBOL_YYYYMMDD = 965,                 /* YYYYMMDD  */
  YYSYMBOL_ZERO = 966,                     /* ZERO  */
  YYSYMBOL_LEVEL_NUMBER_IN_AREA_A = 967,   /* "level-number (Area A)"  */
  YYSYMBOL_WORD_IN_AREA_A = 968,           /* "Identifier (Area A)"  */
  YYSYMBOL_SHIFT_PREFER = 969,             /* SHIFT_PREFER  */
  YYSYMBOL_YYACCEPT = 970,                 /* $accept  */
  YYSYMBOL_start = 971,                    /* start  */
  YYSYMBOL_972_1 = 972,                    /* $@1  */
  YYSYMBOL_compilation_group = 973,        /* compilation_group  */
  YYSYMBOL_nested_list = 974,              /* nested_list  */
  YYSYMBOL_975_2 = 975,                    /* $@2  */
  YYSYMBOL_source_element_list = 976,      /* source_element_list  */
  YYSYMBOL_source_element = 977,           /* source_element  */
  YYSYMBOL_simple_prog = 978,              /* simple_prog  */
  YYSYMBOL_979_3 = 979,                    /* $@3  */
  YYSYMBOL_program_definition = 980,       /* program_definition  */
  YYSYMBOL_function_definition = 981,      /* function_definition  */
  YYSYMBOL__end_program_list = 982,        /* _end_program_list  */
  YYSYMBOL_end_program_list = 983,         /* end_program_list  */
  YYSYMBOL_end_program = 984,              /* end_program  */
  YYSYMBOL_985_4 = 985,                    /* $@4  */
  YYSYMBOL_end_function = 986,             /* end_function  */
  YYSYMBOL_987_5 = 987,                    /* $@5  */
  YYSYMBOL_program_prototype = 988,        /* program_prototype  */
  YYSYMBOL_989_6 = 989,                    /* $@6  */
  YYSYMBOL_990_7 = 990,                    /* $@7  */
  YYSYMBOL_function_prototype = 991,       /* function_prototype  */
  YYSYMBOL_992_8 = 992,                    /* $@8  */
  YYSYMBOL_993_9 = 993,                    /* $@9  */
  YYSYMBOL__prototype_procedure_division_header = 994, /* _prototype_procedure_division_header  */
  YYSYMBOL_995_10 = 995,                   /* $@10  */
  YYSYMBOL_control = 996,                  /* control  */
  YYSYMBOL__control_division = 997,        /* _control_division  */
  YYSYMBOL_998_11 = 998,                   /* $@11  */
  YYSYMBOL__default_section = 999,         /* _default_section  */
  YYSYMBOL_1000_12 = 1000,                 /* $@12  */
  YYSYMBOL__default_clauses = 1001,        /* _default_clauses  */
  YYSYMBOL__default_accept_clause = 1002,  /* _default_accept_clause  */
  YYSYMBOL_1003_13 = 1003,                 /* $@13  */
  YYSYMBOL__default_display_clause = 1004, /* _default_display_clause  */
  YYSYMBOL_1005_14 = 1005,                 /* $@14  */
  YYSYMBOL__program_body = 1006,           /* _program_body  */
  YYSYMBOL_1007_15 = 1007,                 /* $@15  */
  YYSYMBOL_1008_16 = 1008,                 /* $@16  */
  YYSYMBOL__identification_header = 1009,  /* _identification_header  */
  YYSYMBOL_identification_header = 1010,   /* identification_header  */
  YYSYMBOL_1011_17 = 1011,                 /* $@17  */
  YYSYMBOL_identification_or_id = 1012,    /* identification_or_id  */
  YYSYMBOL_program_id_header = 1013,       /* program_id_header  */
  YYSYMBOL_program_id_paragraph = 1014,    /* program_id_paragraph  */
  YYSYMBOL_function_id_header = 1015,      /* function_id_header  */
  YYSYMBOL_function_id_paragraph = 1016,   /* function_id_paragraph  */
  YYSYMBOL_program_id_name = 1017,         /* program_id_name  */
  YYSYMBOL_end_program_name = 1018,        /* end_program_name  */
  YYSYMBOL__as_literal = 1019,             /* _as_literal  */
  YYSYMBOL__program_type = 1020,           /* _program_type  */
  YYSYMBOL_program_type_clause = 1021,     /* program_type_clause  */
  YYSYMBOL_init_or_recurse_and_common = 1022, /* init_or_recurse_and_common  */
  YYSYMBOL_init_or_recurse = 1023,         /* init_or_recurse  */
  YYSYMBOL__options_paragraph = 1024,      /* _options_paragraph  */
  YYSYMBOL__options_clauses = 1025,        /* _options_clauses  */
  YYSYMBOL__arithmetic_clause = 1026,      /* _arithmetic_clause  */
  YYSYMBOL_arithmetic_choice = 1027,       /* arithmetic_choice  */
  YYSYMBOL__default_rounded_clause = 1028, /* _default_rounded_clause  */
  YYSYMBOL__entry_convention_clause = 1029, /* _entry_convention_clause  */
  YYSYMBOL_convention_type = 1030,         /* convention_type  */
  YYSYMBOL__intermediate_rounding_clause = 1031, /* _intermediate_rounding_clause  */
  YYSYMBOL_intermediate_rounding_choice = 1032, /* intermediate_rounding_choice  */
  YYSYMBOL__environment_division = 1033,   /* _environment_division  */
  YYSYMBOL__environment_header = 1034,     /* _environment_header  */
  YYSYMBOL_environment = 1035,             /* environment  */
  YYSYMBOL_environment_header = 1036,      /* environment_header  */
  YYSYMBOL__configuration_section = 1037,  /* _configuration_section  */
  YYSYMBOL__configuration_header = 1038,   /* _configuration_header  */
  YYSYMBOL_configuration = 1039,           /* configuration  */
  YYSYMBOL_configuration_header = 1040,    /* configuration_header  */
  YYSYMBOL__configuration_paragraphs = 1041, /* _configuration_paragraphs  */
  YYSYMBOL_configuration_paragraphs = 1042, /* configuration_paragraphs  */
  YYSYMBOL_configuration_paragraph = 1043, /* configuration_paragraph  */
  YYSYMBOL__source_computer_paragraph = 1044, /* _source_computer_paragraph  */
  YYSYMBOL_source_computer_paragraph = 1045, /* source_computer_paragraph  */
  YYSYMBOL_1046_18 = 1046,                 /* $@18  */
  YYSYMBOL__source_computer_entry = 1047,  /* _source_computer_entry  */
  YYSYMBOL__with_debugging_mode = 1048,    /* _with_debugging_mode  */
  YYSYMBOL_object_computer_paragraph = 1049, /* object_computer_paragraph  */
  YYSYMBOL_1050_19 = 1050,                 /* $@19  */
  YYSYMBOL__object_computer_entry = 1051,  /* _object_computer_entry  */
  YYSYMBOL_object_clauses_list = 1052,     /* object_clauses_list  */
  YYSYMBOL_object_clauses = 1053,          /* object_clauses  */
  YYSYMBOL_object_computer_memory = 1054,  /* object_computer_memory  */
  YYSYMBOL_object_computer_sequence = 1055, /* object_computer_sequence  */
  YYSYMBOL_program_collating_sequence = 1056, /* program_collating_sequence  */
  YYSYMBOL_1057_20 = 1057,                 /* $@20  */
  YYSYMBOL_program_coll_sequence_values = 1058, /* program_coll_sequence_values  */
  YYSYMBOL_object_computer_segment = 1059, /* object_computer_segment  */
  YYSYMBOL_object_computer_class = 1060,   /* object_computer_class  */
  YYSYMBOL_locale_class = 1061,            /* locale_class  */
  YYSYMBOL_computer_words = 1062,          /* computer_words  */
  YYSYMBOL__repository_paragraph = 1063,   /* _repository_paragraph  */
  YYSYMBOL_repository_paragraph = 1064,    /* repository_paragraph  */
  YYSYMBOL_1065_21 = 1065,                 /* $@21  */
  YYSYMBOL__repository_entry = 1066,       /* _repository_entry  */
  YYSYMBOL_repository_list = 1067,         /* repository_list  */
  YYSYMBOL_repository_name = 1068,         /* repository_name  */
  YYSYMBOL_repository_name_list = 1069,    /* repository_name_list  */
  YYSYMBOL_special_names_header = 1070,    /* special_names_header  */
  YYSYMBOL_special_names_sentence = 1071,  /* special_names_sentence  */
  YYSYMBOL_special_name_list = 1072,       /* special_name_list  */
  YYSYMBOL_special_name = 1073,            /* special_name  */
  YYSYMBOL_mnemonic_name_clause = 1074,    /* mnemonic_name_clause  */
  YYSYMBOL_1075_22 = 1075,                 /* $@22  */
  YYSYMBOL_word_or_terminal = 1076,        /* word_or_terminal  */
  YYSYMBOL_mnemonic_choices = 1077,        /* mnemonic_choices  */
  YYSYMBOL__special_name_mnemonic_on_off = 1078, /* _special_name_mnemonic_on_off  */
  YYSYMBOL_on_off_clauses = 1079,          /* on_off_clauses  */
  YYSYMBOL_on_off_clauses_1 = 1080,        /* on_off_clauses_1  */
  YYSYMBOL_alphabet_name_clause = 1081,    /* alphabet_name_clause  */
  YYSYMBOL_1082_23 = 1082,                 /* @23  */
  YYSYMBOL_alphabet_definition = 1083,     /* alphabet_definition  */
  YYSYMBOL_1084_24 = 1084,                 /* @24  */
  YYSYMBOL_1085_25 = 1085,                 /* @25  */
  YYSYMBOL_alphabet_target_alphanumeric = 1086, /* alphabet_target_alphanumeric  */
  YYSYMBOL_alphabet_target_national = 1087, /* alphabet_target_national  */
  YYSYMBOL_alphabet_type_alphanumeric = 1088, /* alphabet_type_alphanumeric  */
  YYSYMBOL_alphabet_type_national = 1089,  /* alphabet_type_national  */
  YYSYMBOL_alphabet_type_common = 1090,    /* alphabet_type_common  */
  YYSYMBOL_alphabet_literal_list = 1091,   /* alphabet_literal_list  */
  YYSYMBOL_alphabet_literal = 1092,        /* alphabet_literal  */
  YYSYMBOL_1093_26 = 1093,                 /* @26  */
  YYSYMBOL_alphabet_also_sequence = 1094,  /* alphabet_also_sequence  */
  YYSYMBOL_alphabet_lits = 1095,           /* alphabet_lits  */
  YYSYMBOL_space_or_zero = 1096,           /* space_or_zero  */
  YYSYMBOL__alphnat_target = 1097,         /* _alphnat_target  */
  YYSYMBOL__in_alphabet = 1098,            /* _in_alphabet  */
  YYSYMBOL_symbolic_characters_clause = 1099, /* symbolic_characters_clause  */
  YYSYMBOL_symbolic_collection = 1100,     /* symbolic_collection  */
  YYSYMBOL_symbolic_chars_list = 1101,     /* symbolic_chars_list  */
  YYSYMBOL_symbolic_chars_phrase = 1102,   /* symbolic_chars_phrase  */
  YYSYMBOL_char_list = 1103,               /* char_list  */
  YYSYMBOL_integer_list = 1104,            /* integer_list  */
  YYSYMBOL_symbolic_constant_clause = 1105, /* symbolic_constant_clause  */
  YYSYMBOL_symbolic_constant_list = 1106,  /* symbolic_constant_list  */
  YYSYMBOL_symbolic_constant = 1107,       /* symbolic_constant  */
  YYSYMBOL_class_name_clause = 1108,       /* class_name_clause  */
  YYSYMBOL_class_item_list = 1109,         /* class_item_list  */
  YYSYMBOL_class_item = 1110,              /* class_item  */
  YYSYMBOL_locale_clause = 1111,           /* locale_clause  */
  YYSYMBOL_xml_schema_clause = 1112,       /* xml_schema_clause  */
  YYSYMBOL_1113_27 = 1113,                 /* @27  */
  YYSYMBOL_schema_definition = 1114,       /* schema_definition  */
  YYSYMBOL_currency_sign_clause = 1115,    /* currency_sign_clause  */
  YYSYMBOL__with_pic_symbol = 1116,        /* _with_pic_symbol  */
  YYSYMBOL_decimal_point_clause = 1117,    /* decimal_point_clause  */
  YYSYMBOL_numeric_sign_clause = 1118,     /* numeric_sign_clause  */
  YYSYMBOL_cursor_clause = 1119,           /* cursor_clause  */
  YYSYMBOL_crt_status_clause = 1120,       /* crt_status_clause  */
  YYSYMBOL_screen_control = 1121,          /* screen_control  */
  YYSYMBOL_event_status = 1122,            /* event_status  */
  YYSYMBOL_top_clause = 1123,              /* top_clause  */
  YYSYMBOL_1124_28 = 1124,                 /* $@28  */
  YYSYMBOL__input_output_section = 1125,   /* _input_output_section  */
  YYSYMBOL_input_output = 1126,            /* input_output  */
  YYSYMBOL__input_output_header = 1127,    /* _input_output_header  */
  YYSYMBOL__file_control_header = 1128,    /* _file_control_header  */
  YYSYMBOL__file_control_sequence = 1129,  /* _file_control_sequence  */
  YYSYMBOL_file_control_entry = 1130,      /* file_control_entry  */
  YYSYMBOL_1131_29 = 1131,                 /* $@29  */
  YYSYMBOL_1132_30 = 1132,                 /* $@30  */
  YYSYMBOL__select_clauses_or_error = 1133, /* _select_clauses_or_error  */
  YYSYMBOL__select_clause_sequence = 1134, /* _select_clause_sequence  */
  YYSYMBOL_select_clause = 1135,           /* select_clause  */
  YYSYMBOL_assign_clause = 1136,           /* assign_clause  */
  YYSYMBOL__assign_device_or_line_adv_file = 1137, /* _assign_device_or_line_adv_file  */
  YYSYMBOL_assign_device = 1138,           /* assign_device  */
  YYSYMBOL_general_device_name = 1139,     /* general_device_name  */
  YYSYMBOL_line_seq_device_name = 1140,    /* line_seq_device_name  */
  YYSYMBOL_line_adv_file = 1141,           /* line_adv_file  */
  YYSYMBOL__ext_clause = 1142,             /* _ext_clause  */
  YYSYMBOL_ext_clause = 1143,              /* ext_clause  */
  YYSYMBOL_assignment_name = 1144,         /* assignment_name  */
  YYSYMBOL_access_mode_clause = 1145,      /* access_mode_clause  */
  YYSYMBOL_access_mode = 1146,             /* access_mode  */
  YYSYMBOL_alternate_record_key_clause = 1147, /* alternate_record_key_clause  */
  YYSYMBOL__password_clause = 1148,        /* _password_clause  */
  YYSYMBOL_password_clause = 1149,         /* password_clause  */
  YYSYMBOL_1150_31 = 1150,                 /* $@31  */
  YYSYMBOL_encryption_clause = 1151,       /* encryption_clause  */
  YYSYMBOL__suppress_clause = 1152,        /* _suppress_clause  */
  YYSYMBOL_collating_sequence_clause = 1153, /* collating_sequence_clause  */
  YYSYMBOL_collating_sequence = 1154,      /* collating_sequence  */
  YYSYMBOL_1155_32 = 1155,                 /* $@32  */
  YYSYMBOL_coll_sequence_values = 1156,    /* coll_sequence_values  */
  YYSYMBOL_collating_sequence_clause_key = 1157, /* collating_sequence_clause_key  */
  YYSYMBOL_alphabet_name = 1158,           /* alphabet_name  */
  YYSYMBOL_file_status_clause = 1159,      /* file_status_clause  */
  YYSYMBOL__file_or_sort = 1160,           /* _file_or_sort  */
  YYSYMBOL_lock_mode_clause = 1161,        /* lock_mode_clause  */
  YYSYMBOL_1162_33 = 1162,                 /* $@33  */
  YYSYMBOL_lock_mode = 1163,               /* lock_mode  */
  YYSYMBOL__lock_with = 1164,              /* _lock_with  */
  YYSYMBOL__with_rollback = 1165,          /* _with_rollback  */
  YYSYMBOL_with_rollback = 1166,           /* with_rollback  */
  YYSYMBOL__with_mass_update = 1167,       /* _with_mass_update  */
  YYSYMBOL_organization_clause = 1168,     /* organization_clause  */
  YYSYMBOL_organization = 1169,            /* organization  */
  YYSYMBOL_padding_character_clause = 1170, /* padding_character_clause  */
  YYSYMBOL_record_delimiter_clause = 1171, /* record_delimiter_clause  */
  YYSYMBOL_1172_34 = 1172,                 /* $@34  */
  YYSYMBOL_record_delimiter_option = 1173, /* record_delimiter_option  */
  YYSYMBOL_record_key_clause = 1174,       /* record_key_clause  */
  YYSYMBOL__split_keys = 1175,             /* _split_keys  */
  YYSYMBOL_source_is = 1176,               /* source_is  */
  YYSYMBOL_split_key_list = 1177,          /* split_key_list  */
  YYSYMBOL_1178_35 = 1178,                 /* $@35  */
  YYSYMBOL_split_key = 1179,               /* split_key  */
  YYSYMBOL_relative_key_clause = 1180,     /* relative_key_clause  */
  YYSYMBOL_reserve_clause = 1181,          /* reserve_clause  */
  YYSYMBOL_no_or_integer = 1182,           /* no_or_integer  */
  YYSYMBOL_sharing_clause = 1183,          /* sharing_clause  */
  YYSYMBOL_sharing_option = 1184,          /* sharing_option  */
  YYSYMBOL_file_limit_clause = 1185,       /* file_limit_clause  */
  YYSYMBOL_thru_list = 1186,               /* thru_list  */
  YYSYMBOL_actual_key_clause = 1187,       /* actual_key_clause  */
  YYSYMBOL_nominal_key_clause = 1188,      /* nominal_key_clause  */
  YYSYMBOL_track_area_clause = 1189,       /* track_area_clause  */
  YYSYMBOL_track_limit_clause = 1190,      /* track_limit_clause  */
  YYSYMBOL__i_o_control = 1191,            /* _i_o_control  */
  YYSYMBOL_i_o_control_header = 1192,      /* i_o_control_header  */
  YYSYMBOL__i_o_control_entries = 1193,    /* _i_o_control_entries  */
  YYSYMBOL_i_o_control_list = 1194,        /* i_o_control_list  */
  YYSYMBOL_i_o_control_clause = 1195,      /* i_o_control_clause  */
  YYSYMBOL_same_clause = 1196,             /* same_clause  */
  YYSYMBOL__same_option = 1197,            /* _same_option  */
  YYSYMBOL_apply_clause = 1198,            /* apply_clause  */
  YYSYMBOL_obsolete_dos_vs_apply_phrase = 1199, /* obsolete_dos_vs_apply_phrase  */
  YYSYMBOL_multiple_file_tape_clause = 1200, /* multiple_file_tape_clause  */
  YYSYMBOL_1201_36 = 1201,                 /* $@36  */
  YYSYMBOL_multiple_file_list = 1202,      /* multiple_file_list  */
  YYSYMBOL_multiple_file = 1203,           /* multiple_file  */
  YYSYMBOL__multiple_file_position = 1204, /* _multiple_file_position  */
  YYSYMBOL_rerun_clause = 1205,            /* rerun_clause  */
  YYSYMBOL__on_assignment = 1206,          /* _on_assignment  */
  YYSYMBOL_rerun_event = 1207,             /* rerun_event  */
  YYSYMBOL__prototype_environment_division = 1208, /* _prototype_environment_division  */
  YYSYMBOL__prototype_special_names_paragraph = 1209, /* _prototype_special_names_paragraph  */
  YYSYMBOL__prototype_special_names_sentence_list = 1210, /* _prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_names_sentence_list = 1211, /* prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_name_list = 1212, /* prototype_special_name_list  */
  YYSYMBOL_prototype_special_name = 1213,  /* prototype_special_name  */
  YYSYMBOL__data_division = 1214,          /* _data_division  */
  YYSYMBOL_1215_37 = 1215,                 /* $@37  */
  YYSYMBOL__data_division_header = 1216,   /* _data_division_header  */
  YYSYMBOL_data = 1217,                    /* data  */
  YYSYMBOL_data_division_header = 1218,    /* data_division_header  */
  YYSYMBOL_tok_file = 1219,                /* tok_file  */
  YYSYMBOL__file_section_header = 1220,    /* _file_section_header  */
  YYSYMBOL__file_description_sequence = 1221, /* _file_description_sequence  */
  YYSYMBOL_file_description = 1222,        /* file_description  */
  YYSYMBOL_file_description_entry = 1223,  /* file_description_entry  */
  YYSYMBOL_1224_38 = 1224,                 /* $@38  */
  YYSYMBOL_file_type = 1225,               /* file_type  */
  YYSYMBOL__file_description_clause_sequence = 1226, /* _file_description_clause_sequence  */
  YYSYMBOL_file_description_clause = 1227, /* file_description_clause  */
  YYSYMBOL_block_contains_clause = 1228,   /* block_contains_clause  */
  YYSYMBOL__records_or_characters = 1229,  /* _records_or_characters  */
  YYSYMBOL_record_clause = 1230,           /* record_clause  */
  YYSYMBOL__record_depending = 1231,       /* _record_depending  */
  YYSYMBOL__from_integer = 1232,           /* _from_integer  */
  YYSYMBOL__to_integer = 1233,             /* _to_integer  */
  YYSYMBOL_label_records_clause = 1234,    /* label_records_clause  */
  YYSYMBOL_value_of_clause = 1235,         /* value_of_clause  */
  YYSYMBOL_file_id = 1236,                 /* file_id  */
  YYSYMBOL_valueof_name = 1237,            /* valueof_name  */
  YYSYMBOL_data_records_clause = 1238,     /* data_records_clause  */
  YYSYMBOL_linage_clause = 1239,           /* linage_clause  */
  YYSYMBOL__linage_sequence = 1240,        /* _linage_sequence  */
  YYSYMBOL_linage_lines = 1241,            /* linage_lines  */
  YYSYMBOL_linage_footing = 1242,          /* linage_footing  */
  YYSYMBOL_linage_top = 1243,              /* linage_top  */
  YYSYMBOL_linage_bottom = 1244,           /* linage_bottom  */
  YYSYMBOL_recording_mode_clause = 1245,   /* recording_mode_clause  */
  YYSYMBOL_recording_mode = 1246,          /* recording_mode  */
  YYSYMBOL_u_or_s = 1247,                  /* u_or_s  */
  YYSYMBOL_code_set_clause = 1248,         /* code_set_clause  */
  YYSYMBOL__for_sub_records_clause = 1249, /* _for_sub_records_clause  */
  YYSYMBOL_report_clause = 1250,           /* report_clause  */
  YYSYMBOL_report_keyword = 1251,          /* report_keyword  */
  YYSYMBOL_rep_name_list = 1252,           /* rep_name_list  */
  YYSYMBOL_communication = 1253,           /* communication  */
  YYSYMBOL__communication_section = 1254,  /* _communication_section  */
  YYSYMBOL_1255_39 = 1255,                 /* $@39  */
  YYSYMBOL__communication_description_sequence = 1256, /* _communication_description_sequence  */
  YYSYMBOL_communication_description = 1257, /* communication_description  */
  YYSYMBOL_cd = 1258,                      /* cd  */
  YYSYMBOL_communication_description_entry = 1259, /* communication_description_entry  */
  YYSYMBOL_1260_40 = 1260,                 /* $@40  */
  YYSYMBOL__communication_description_clause_sequence = 1261, /* _communication_description_clause_sequence  */
  YYSYMBOL_communication_description_clause = 1262, /* communication_description_clause  */
  YYSYMBOL__input_cd_clauses = 1263,       /* _input_cd_clauses  */
  YYSYMBOL_named_input_cd_clauses = 1264,  /* named_input_cd_clauses  */
  YYSYMBOL_named_input_cd_clause = 1265,   /* named_input_cd_clause  */
  YYSYMBOL_unnamed_input_cd_clauses = 1266, /* unnamed_input_cd_clauses  */
  YYSYMBOL__output_cd_clauses = 1267,      /* _output_cd_clauses  */
  YYSYMBOL_output_cd_clauses = 1268,       /* output_cd_clauses  */
  YYSYMBOL_output_cd_clause = 1269,        /* output_cd_clause  */
  YYSYMBOL__i_o_cd_clauses = 1270,         /* _i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clauses = 1271,    /* named_i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clause = 1272,     /* named_i_o_cd_clause  */
  YYSYMBOL_unnamed_i_o_cd_clauses = 1273,  /* unnamed_i_o_cd_clauses  */
  YYSYMBOL_working_storage = 1274,         /* working_storage  */
  YYSYMBOL__working_storage_section = 1275, /* _working_storage_section  */
  YYSYMBOL_1276_41 = 1276,                 /* $@41  */
  YYSYMBOL__record_description_list = 1277, /* _record_description_list  */
  YYSYMBOL_1278_42 = 1278,                 /* $@42  */
  YYSYMBOL_record_description_list = 1279, /* record_description_list  */
  YYSYMBOL_data_description = 1280,        /* data_description  */
  YYSYMBOL_1281_43 = 1281,                 /* $@43  */
  YYSYMBOL_level_number = 1282,            /* level_number  */
  YYSYMBOL__filler = 1283,                 /* _filler  */
  YYSYMBOL__entry_name = 1284,             /* _entry_name  */
  YYSYMBOL_user_entry_name = 1285,         /* user_entry_name  */
  YYSYMBOL__const_global = 1286,           /* _const_global  */
  YYSYMBOL_lit_or_length = 1287,           /* lit_or_length  */
  YYSYMBOL_con_source = 1288,              /* con_source  */
  YYSYMBOL_fp32_usage = 1289,              /* fp32_usage  */
  YYSYMBOL_fp64_usage = 1290,              /* fp64_usage  */
  YYSYMBOL_fp128_usage = 1291,             /* fp128_usage  */
  YYSYMBOL_pointer_len = 1292,             /* pointer_len  */
  YYSYMBOL_renames_entry = 1293,           /* renames_entry  */
  YYSYMBOL__renames_thru = 1294,           /* _renames_thru  */
  YYSYMBOL_condition_name_entry = 1295,    /* condition_name_entry  */
  YYSYMBOL_1296_44 = 1296,                 /* $@44  */
  YYSYMBOL__user_entry_name = 1297,        /* _user_entry_name  */
  YYSYMBOL_constant_entry = 1298,          /* constant_entry  */
  YYSYMBOL_1299_45 = 1299,                 /* $@45  */
  YYSYMBOL_constant_source = 1300,         /* constant_source  */
  YYSYMBOL_constant_78_source = 1301,      /* constant_78_source  */
  YYSYMBOL_constant_expression_list = 1302, /* constant_expression_list  */
  YYSYMBOL_constant_expression = 1303,     /* constant_expression  */
  YYSYMBOL__data_description_clause_sequence = 1304, /* _data_description_clause_sequence  */
  YYSYMBOL_data_description_clause_sequence = 1305, /* data_description_clause_sequence  */
  YYSYMBOL_data_description_clause = 1306, /* data_description_clause  */
  YYSYMBOL_redefines_clause = 1307,        /* redefines_clause  */
  YYSYMBOL_like_clause = 1308,             /* like_clause  */
  YYSYMBOL__length_modifier = 1309,        /* _length_modifier  */
  YYSYMBOL_length_modifier = 1310,         /* length_modifier  */
  YYSYMBOL_same_as_clause = 1311,          /* same_as_clause  */
  YYSYMBOL_typedef_clause = 1312,          /* typedef_clause  */
  YYSYMBOL__strong = 1313,                 /* _strong  */
  YYSYMBOL_external_clause = 1314,         /* external_clause  */
  YYSYMBOL__as_extname = 1315,             /* _as_extname  */
  YYSYMBOL__global_clause = 1316,          /* _global_clause  */
  YYSYMBOL_global_clause = 1317,           /* global_clause  */
  YYSYMBOL_special_names_clause = 1318,    /* special_names_clause  */
  YYSYMBOL_1319_46 = 1319,                 /* $@46  */
  YYSYMBOL_special_names_target = 1320,    /* special_names_target  */
  YYSYMBOL_select_when_clause = 1321,      /* select_when_clause  */
  YYSYMBOL_1322_47 = 1322,                 /* $@47  */
  YYSYMBOL_when_choice = 1323,             /* when_choice  */
  YYSYMBOL_format_clause = 1324,           /* format_clause  */
  YYSYMBOL_format_choice = 1325,           /* format_choice  */
  YYSYMBOL_volatile_clause = 1326,         /* volatile_clause  */
  YYSYMBOL_picture_clause = 1327,          /* picture_clause  */
  YYSYMBOL_1328_48 = 1328,                 /* $@48  */
  YYSYMBOL__pic_locale_format_or_depending_on_or_byte_length = 1329, /* _pic_locale_format_or_depending_on_or_byte_length  */
  YYSYMBOL__is_locale_name = 1330,         /* _is_locale_name  */
  YYSYMBOL_locale_name = 1331,             /* locale_name  */
  YYSYMBOL_type_to_clause = 1332,          /* type_to_clause  */
  YYSYMBOL_usage_clause = 1333,            /* usage_clause  */
  YYSYMBOL__usage_is = 1334,               /* _usage_is  */
  YYSYMBOL_usage = 1335,                   /* usage  */
  YYSYMBOL_conflict_usage = 1336,          /* conflict_usage  */
  YYSYMBOL__object_reference_type = 1337,  /* _object_reference_type  */
  YYSYMBOL__factory_of = 1338,             /* _factory_of  */
  YYSYMBOL__only = 1339,                   /* _only  */
  YYSYMBOL_double_usage = 1340,            /* double_usage  */
  YYSYMBOL_long_double = 1341,             /* long_double  */
  YYSYMBOL__font_name = 1342,              /* _font_name  */
  YYSYMBOL__layout_name = 1343,            /* _layout_name  */
  YYSYMBOL_sign_clause = 1344,             /* sign_clause  */
  YYSYMBOL_byte_length_clause = 1345,      /* byte_length_clause  */
  YYSYMBOL_report_occurs_clause = 1346,    /* report_occurs_clause  */
  YYSYMBOL_report_occurs_step = 1347,      /* report_occurs_step  */
  YYSYMBOL_occurs_clause = 1348,           /* occurs_clause  */
  YYSYMBOL__occurs_from_integer = 1349,    /* _occurs_from_integer  */
  YYSYMBOL__occurs_to_integer = 1350,      /* _occurs_to_integer  */
  YYSYMBOL__occurs_integer_to = 1351,      /* _occurs_integer_to  */
  YYSYMBOL__occurs_depending = 1352,       /* _occurs_depending  */
  YYSYMBOL__capacity_in = 1353,            /* _capacity_in  */
  YYSYMBOL__occurs_initialized = 1354,     /* _occurs_initialized  */
  YYSYMBOL__occurs_keys_and_indexed = 1355, /* _occurs_keys_and_indexed  */
  YYSYMBOL_1356_49 = 1356,                 /* $@49  */
  YYSYMBOL_occurs_keys = 1357,             /* occurs_keys  */
  YYSYMBOL_occurs_key_list = 1358,         /* occurs_key_list  */
  YYSYMBOL_occurs_key_field = 1359,        /* occurs_key_field  */
  YYSYMBOL_ascending_or_descending = 1360, /* ascending_or_descending  */
  YYSYMBOL__occurs_indexed = 1361,         /* _occurs_indexed  */
  YYSYMBOL_occurs_indexed = 1362,          /* occurs_indexed  */
  YYSYMBOL_occurs_index_list = 1363,       /* occurs_index_list  */
  YYSYMBOL_occurs_index = 1364,            /* occurs_index  */
  YYSYMBOL_justified_clause = 1365,        /* justified_clause  */
  YYSYMBOL_synchronized_clause = 1366,     /* synchronized_clause  */
  YYSYMBOL__left_or_right = 1367,          /* _left_or_right  */
  YYSYMBOL_blank_clause = 1368,            /* blank_clause  */
  YYSYMBOL_based_clause = 1369,            /* based_clause  */
  YYSYMBOL_value_clause = 1370,            /* value_clause  */
  YYSYMBOL_value_table_item_list = 1371,   /* value_table_item_list  */
  YYSYMBOL_value_table_item = 1372,        /* value_table_item  */
  YYSYMBOL_value_from_subscripts_is_are = 1373, /* value_from_subscripts_is_are  */
  YYSYMBOL_from_subscripts = 1374,         /* from_subscripts  */
  YYSYMBOL__to_subscripts = 1375,          /* _to_subscripts  */
  YYSYMBOL_from_to_subscripts = 1376,      /* from_to_subscripts  */
  YYSYMBOL__repeated_phrase = 1377,        /* _repeated_phrase  */
  YYSYMBOL_repeated_phrase = 1378,         /* repeated_phrase  */
  YYSYMBOL_subscripts = 1379,              /* subscripts  */
  YYSYMBOL_value_is_are = 1380,            /* value_is_are  */
  YYSYMBOL_value_item_list = 1381,         /* value_item_list  */
  YYSYMBOL_value_item = 1382,              /* value_item  */
  YYSYMBOL_value_clause_report = 1383,     /* value_clause_report  */
  YYSYMBOL_value_clause_condition = 1384,  /* value_clause_condition  */
  YYSYMBOL_1385_50 = 1385,                 /* $@50  */
  YYSYMBOL_value_item_list_in_alphabet = 1386, /* value_item_list_in_alphabet  */
  YYSYMBOL_value_item_condition_list = 1387, /* value_item_condition_list  */
  YYSYMBOL_value_item_condition = 1388,    /* value_item_condition  */
  YYSYMBOL__false_or_content_validation = 1389, /* _false_or_content_validation  */
  YYSYMBOL_false_is = 1390,                /* false_is  */
  YYSYMBOL_content_validation = 1391,      /* content_validation  */
  YYSYMBOL_valid_or_invalid = 1392,        /* valid_or_invalid  */
  YYSYMBOL__when_condition = 1393,         /* _when_condition  */
  YYSYMBOL_validate_status_clause = 1394,  /* validate_status_clause  */
  YYSYMBOL_when_error_choice = 1395,       /* when_error_choice  */
  YYSYMBOL__on_choice = 1396,              /* _on_choice  */
  YYSYMBOL_default_clause = 1397,          /* default_clause  */
  YYSYMBOL_x_or_none = 1398,               /* x_or_none  */
  YYSYMBOL_class_clause = 1399,            /* class_clause  */
  YYSYMBOL_class_option = 1400,            /* class_option  */
  YYSYMBOL_destination_clause = 1401,      /* destination_clause  */
  YYSYMBOL_present_when_clause = 1402,     /* present_when_clause  */
  YYSYMBOL_invalid_when_clause = 1403,     /* invalid_when_clause  */
  YYSYMBOL_any_length_clause = 1404,       /* any_length_clause  */
  YYSYMBOL_external_form_clause = 1405,    /* external_form_clause  */
  YYSYMBOL_identified_by_clause = 1406,    /* identified_by_clause  */
  YYSYMBOL_local_storage = 1407,           /* local_storage  */
  YYSYMBOL__local_storage_section = 1408,  /* _local_storage_section  */
  YYSYMBOL_1409_51 = 1409,                 /* $@51  */
  YYSYMBOL_linkage = 1410,                 /* linkage  */
  YYSYMBOL__linkage_section = 1411,        /* _linkage_section  */
  YYSYMBOL_1412_52 = 1412,                 /* $@52  */
  YYSYMBOL__report_section = 1413,         /* _report_section  */
  YYSYMBOL_1414_53 = 1414,                 /* $@53  */
  YYSYMBOL_1415_54 = 1415,                 /* $@54  */
  YYSYMBOL__report_description_sequence = 1416, /* _report_description_sequence  */
  YYSYMBOL_report_description = 1417,      /* report_description  */
  YYSYMBOL_1418_55 = 1418,                 /* $@55  */
  YYSYMBOL_1419_56 = 1419,                 /* $@56  */
  YYSYMBOL__report_description_options = 1420, /* _report_description_options  */
  YYSYMBOL_report_description_option = 1421, /* report_description_option  */
  YYSYMBOL_control_clause = 1422,          /* control_clause  */
  YYSYMBOL_control_field_list = 1423,      /* control_field_list  */
  YYSYMBOL_control_final_tag = 1424,       /* control_final_tag  */
  YYSYMBOL_control_identifier_list = 1425, /* control_identifier_list  */
  YYSYMBOL_control_identifier = 1426,      /* control_identifier  */
  YYSYMBOL_page_limit_clause = 1427,       /* page_limit_clause  */
  YYSYMBOL_page_line_column = 1428,        /* page_line_column  */
  YYSYMBOL_page_limit_cols = 1429,         /* page_limit_cols  */
  YYSYMBOL_integer_or_zero_or_ident = 1430, /* integer_or_zero_or_ident  */
  YYSYMBOL__page_heading_list = 1431,      /* _page_heading_list  */
  YYSYMBOL_page_detail = 1432,             /* page_detail  */
  YYSYMBOL_heading_clause = 1433,          /* heading_clause  */
  YYSYMBOL_first_detail = 1434,            /* first_detail  */
  YYSYMBOL_last_heading = 1435,            /* last_heading  */
  YYSYMBOL_last_detail = 1436,             /* last_detail  */
  YYSYMBOL_footing_clause = 1437,          /* footing_clause  */
  YYSYMBOL__report_group_description_list = 1438, /* _report_group_description_list  */
  YYSYMBOL_report_group_description_entry = 1439, /* report_group_description_entry  */
  YYSYMBOL_1440_57 = 1440,                 /* $@57  */
  YYSYMBOL__report_group_options = 1441,   /* _report_group_options  */
  YYSYMBOL_report_group_option = 1442,     /* report_group_option  */
  YYSYMBOL_type_is_clause = 1443,          /* type_is_clause  */
  YYSYMBOL_type_option = 1444,             /* type_option  */
  YYSYMBOL__control_heading_final = 1445,  /* _control_heading_final  */
  YYSYMBOL__or_page = 1446,                /* _or_page  */
  YYSYMBOL__control_footing_final = 1447,  /* _control_footing_final  */
  YYSYMBOL_next_group_clause = 1448,       /* next_group_clause  */
  YYSYMBOL_next_group_plus = 1449,         /* next_group_plus  */
  YYSYMBOL_next_page = 1450,               /* next_page  */
  YYSYMBOL_sum_clause_list = 1451,         /* sum_clause_list  */
  YYSYMBOL__reset_clause = 1452,           /* _reset_clause  */
  YYSYMBOL_data_or_final = 1453,           /* data_or_final  */
  YYSYMBOL_present_when_condition = 1454,  /* present_when_condition  */
  YYSYMBOL_present_absent = 1455,          /* present_absent  */
  YYSYMBOL__page_or_id = 1456,             /* _page_or_id  */
  YYSYMBOL_page_or_ids = 1457,             /* page_or_ids  */
  YYSYMBOL_data_varying_clause = 1458,     /* data_varying_clause  */
  YYSYMBOL_data_varying_list = 1459,       /* data_varying_list  */
  YYSYMBOL_data_varying = 1460,            /* data_varying  */
  YYSYMBOL__var_from = 1461,               /* _var_from  */
  YYSYMBOL__var_by = 1462,                 /* _var_by  */
  YYSYMBOL_line_clause = 1463,             /* line_clause  */
  YYSYMBOL_line_keyword_clause = 1464,     /* line_keyword_clause  */
  YYSYMBOL__line_clause_options = 1465,    /* _line_clause_options  */
  YYSYMBOL_line_clause_option = 1466,      /* line_clause_option  */
  YYSYMBOL_column_clause = 1467,           /* column_clause  */
  YYSYMBOL_col_keyword_clause = 1468,      /* col_keyword_clause  */
  YYSYMBOL__orientation = 1469,            /* _orientation  */
  YYSYMBOL__left_right_center = 1470,      /* _left_right_center  */
  YYSYMBOL_col_or_plus = 1471,             /* col_or_plus  */
  YYSYMBOL_column_integer_list = 1472,     /* column_integer_list  */
  YYSYMBOL_column_integer = 1473,          /* column_integer  */
  YYSYMBOL_source_clause = 1474,           /* source_clause  */
  YYSYMBOL_group_indicate_clause = 1475,   /* group_indicate_clause  */
  YYSYMBOL__screen_section = 1476,         /* _screen_section  */
  YYSYMBOL_1477_58 = 1477,                 /* $@58  */
  YYSYMBOL_1478_59 = 1478,                 /* $@59  */
  YYSYMBOL__screen_description_list = 1479, /* _screen_description_list  */
  YYSYMBOL_screen_description_list = 1480, /* screen_description_list  */
  YYSYMBOL_screen_description = 1481,      /* screen_description  */
  YYSYMBOL_1482_60 = 1482,                 /* $@60  */
  YYSYMBOL_1483_61 = 1483,                 /* $@61  */
  YYSYMBOL_1484_62 = 1484,                 /* $@62  */
  YYSYMBOL__screen_options = 1485,         /* _screen_options  */
  YYSYMBOL_screen_option = 1486,           /* screen_option  */
  YYSYMBOL_screen_value_clause = 1487,     /* screen_value_clause  */
  YYSYMBOL__value_is = 1488,               /* _value_is  */
  YYSYMBOL_control_definition = 1489,      /* control_definition  */
  YYSYMBOL_control_type_name = 1490,       /* control_type_name  */
  YYSYMBOL_control_type = 1491,            /* control_type  */
  YYSYMBOL_control_item = 1492,            /* control_item  */
  YYSYMBOL__control_attributes = 1493,     /* _control_attributes  */
  YYSYMBOL_control_attributes = 1494,      /* control_attributes  */
  YYSYMBOL_control_attribute = 1495,       /* control_attribute  */
  YYSYMBOL_control_style = 1496,           /* control_style  */
  YYSYMBOL_control_property = 1497,        /* control_property  */
  YYSYMBOL_control_style_name = 1498,      /* control_style_name  */
  YYSYMBOL_control_property_name = 1499,   /* control_property_name  */
  YYSYMBOL_control_style_name_generic = 1500, /* control_style_name_generic  */
  YYSYMBOL_control_property_name_generic = 1501, /* control_property_name_generic  */
  YYSYMBOL_control_style_name_label = 1502, /* control_style_name_label  */
  YYSYMBOL_control_property_name_label = 1503, /* control_property_name_label  */
  YYSYMBOL_control_style_name_entry_field = 1504, /* control_style_name_entry_field  */
  YYSYMBOL_control_property_name_entry_field = 1505, /* control_property_name_entry_field  */
  YYSYMBOL_control_style_name_push_button = 1506, /* control_style_name_push_button  */
  YYSYMBOL_control_property_name_push_button = 1507, /* control_property_name_push_button  */
  YYSYMBOL_control_style_name_check_box = 1508, /* control_style_name_check_box  */
  YYSYMBOL_control_property_name_radio_button = 1509, /* control_property_name_radio_button  */
  YYSYMBOL_control_style_name_list_box = 1510, /* control_style_name_list_box  */
  YYSYMBOL_control_property_name_list_box = 1511, /* control_property_name_list_box  */
  YYSYMBOL_control_style_name_combo_box = 1512, /* control_style_name_combo_box  */
  YYSYMBOL_control_style_name_frame = 1513, /* control_style_name_frame  */
  YYSYMBOL_control_property_name_frame = 1514, /* control_property_name_frame  */
  YYSYMBOL_control_style_name_tab_control = 1515, /* control_style_name_tab_control  */
  YYSYMBOL_control_property_name_tab_control = 1516, /* control_property_name_tab_control  */
  YYSYMBOL_control_style_name_bar = 1517,  /* control_style_name_bar  */
  YYSYMBOL_control_property_name_bar = 1518, /* control_property_name_bar  */
  YYSYMBOL_control_property_name_bitmap = 1519, /* control_property_name_bitmap  */
  YYSYMBOL_control_style_name_grid = 1520, /* control_style_name_grid  */
  YYSYMBOL_control_property_name_grid = 1521, /* control_property_name_grid  */
  YYSYMBOL_control_style_name_tree_view = 1522, /* control_style_name_tree_view  */
  YYSYMBOL_control_property_name_tree_view = 1523, /* control_property_name_tree_view  */
  YYSYMBOL_control_property_name_web_browser = 1524, /* control_property_name_web_browser  */
  YYSYMBOL_control_style_name_activex = 1525, /* control_style_name_activex  */
  YYSYMBOL_control_property_name_activex = 1526, /* control_property_name_activex  */
  YYSYMBOL_control_style_name_date_entry = 1527, /* control_style_name_date_entry  */
  YYSYMBOL_control_property_name_date_entry = 1528, /* control_property_name_date_entry  */
  YYSYMBOL_control_style_type = 1529,      /* control_style_type  */
  YYSYMBOL_control_property_type = 1530,   /* control_property_type  */
  YYSYMBOL_changeable_control_properties = 1531, /* changeable_control_properties  */
  YYSYMBOL_changeable_control_property = 1532, /* changeable_control_property  */
  YYSYMBOL_changeable_window_properties = 1533, /* changeable_window_properties  */
  YYSYMBOL_changeable_window_property = 1534, /* changeable_window_property  */
  YYSYMBOL_eol = 1535,                     /* eol  */
  YYSYMBOL_eos = 1536,                     /* eos  */
  YYSYMBOL__plus = 1537,                   /* _plus  */
  YYSYMBOL_plus = 1538,                    /* plus  */
  YYSYMBOL_plus_tokens = 1539,             /* plus_tokens  */
  YYSYMBOL_minus = 1540,                   /* minus  */
  YYSYMBOL_minus_tokens = 1541,            /* minus_tokens  */
  YYSYMBOL_control_size = 1542,            /* control_size  */
  YYSYMBOL_control_size_unit = 1543,       /* control_size_unit  */
  YYSYMBOL__cell = 1544,                   /* _cell  */
  YYSYMBOL_screen_line_number = 1545,      /* screen_line_number  */
  YYSYMBOL__screen_line_plus_minus = 1546, /* _screen_line_plus_minus  */
  YYSYMBOL_screen_col_number = 1547,       /* screen_col_number  */
  YYSYMBOL__screen_col_plus_minus = 1548,  /* _screen_col_plus_minus  */
  YYSYMBOL_screen_occurs_clause = 1549,    /* screen_occurs_clause  */
  YYSYMBOL_screen_global_clause = 1550,    /* screen_global_clause  */
  YYSYMBOL__prototype_data_division = 1551, /* _prototype_data_division  */
  YYSYMBOL__procedure_division = 1552,     /* _procedure_division  */
  YYSYMBOL_procedure_division = 1553,      /* procedure_division  */
  YYSYMBOL_1554_63 = 1554,                 /* $@63  */
  YYSYMBOL_1555_64 = 1555,                 /* $@64  */
  YYSYMBOL_1556_65 = 1556,                 /* $@65  */
  YYSYMBOL_1557_66 = 1557,                 /* $@66  */
  YYSYMBOL_1558_67 = 1558,                 /* $@67  */
  YYSYMBOL__procedure_using_chaining = 1559, /* _procedure_using_chaining  */
  YYSYMBOL_1560_68 = 1560,                 /* $@68  */
  YYSYMBOL_1561_69 = 1561,                 /* $@69  */
  YYSYMBOL_procedure_param_list = 1562,    /* procedure_param_list  */
  YYSYMBOL_procedure_param = 1563,         /* procedure_param  */
  YYSYMBOL__procedure_type = 1564,         /* _procedure_type  */
  YYSYMBOL__size_optional = 1565,          /* _size_optional  */
  YYSYMBOL_using_size_clause = 1566,       /* using_size_clause  */
  YYSYMBOL_size_is_integer = 1567,         /* size_is_integer  */
  YYSYMBOL__acu_size = 1568,               /* _acu_size  */
  YYSYMBOL__procedure_optional = 1569,     /* _procedure_optional  */
  YYSYMBOL__procedure_returning = 1570,    /* _procedure_returning  */
  YYSYMBOL__procedure_declaratives = 1571, /* _procedure_declaratives  */
  YYSYMBOL_1572_70 = 1572,                 /* $@70  */
  YYSYMBOL_1573_71 = 1573,                 /* $@71  */
  YYSYMBOL_1574_72 = 1574,                 /* $@72  */
  YYSYMBOL__procedure_list = 1575,         /* _procedure_list  */
  YYSYMBOL_procedure = 1576,               /* procedure  */
  YYSYMBOL_1577_73 = 1577,                 /* $@73  */
  YYSYMBOL_proc_name = 1578,               /* proc_name  */
  YYSYMBOL_section_header = 1579,          /* section_header  */
  YYSYMBOL_1580_74 = 1580,                 /* $@74  */
  YYSYMBOL__use_statement = 1581,          /* _use_statement  */
  YYSYMBOL_paragraph_header = 1582,        /* paragraph_header  */
  YYSYMBOL_invalid_statement = 1583,       /* invalid_statement  */
  YYSYMBOL__segment = 1584,                /* _segment  */
  YYSYMBOL_statement_list = 1585,          /* statement_list  */
  YYSYMBOL_1586_75 = 1586,                 /* @75  */
  YYSYMBOL_1587_76 = 1587,                 /* @76  */
  YYSYMBOL_statements = 1588,              /* statements  */
  YYSYMBOL_1589_77 = 1589,                 /* $@77  */
  YYSYMBOL_statement = 1590,               /* statement  */
  YYSYMBOL_1591_78 = 1591,                 /* $@78  */
  YYSYMBOL_accept_statement = 1592,        /* accept_statement  */
  YYSYMBOL_1593_79 = 1593,                 /* $@79  */
  YYSYMBOL_accept_body = 1594,             /* accept_body  */
  YYSYMBOL_1595_80 = 1595,                 /* $@80  */
  YYSYMBOL_1596_81 = 1596,                 /* $@81  */
  YYSYMBOL_accp_identifier = 1597,         /* accp_identifier  */
  YYSYMBOL_field_with_pos_specifier = 1598, /* field_with_pos_specifier  */
  YYSYMBOL_1599_82 = 1599,                 /* $@82  */
  YYSYMBOL__pos_specifier = 1600,          /* _pos_specifier  */
  YYSYMBOL_pos_specifier = 1601,           /* pos_specifier  */
  YYSYMBOL_pos_specifier_value = 1602,     /* pos_specifier_value  */
  YYSYMBOL_identifier_or_numeric_literal = 1603, /* identifier_or_numeric_literal  */
  YYSYMBOL__accept_clauses = 1604,         /* _accept_clauses  */
  YYSYMBOL_accept_clauses = 1605,          /* accept_clauses  */
  YYSYMBOL_accept_clause = 1606,           /* accept_clause  */
  YYSYMBOL_accept_from_screen_clauses = 1607, /* accept_from_screen_clauses  */
  YYSYMBOL_accept_from_screen_clause = 1608, /* accept_from_screen_clause  */
  YYSYMBOL_lines_or_number = 1609,         /* lines_or_number  */
  YYSYMBOL_at_line_column = 1610,          /* at_line_column  */
  YYSYMBOL_line_number = 1611,             /* line_number  */
  YYSYMBOL_column_number = 1612,           /* column_number  */
  YYSYMBOL_mode_is_block = 1613,           /* mode_is_block  */
  YYSYMBOL_accp_attr = 1614,               /* accp_attr  */
  YYSYMBOL__key_dest = 1615,               /* _key_dest  */
  YYSYMBOL_key_dest = 1616,                /* key_dest  */
  YYSYMBOL_no_echo = 1617,                 /* no_echo  */
  YYSYMBOL_reverse_video = 1618,           /* reverse_video  */
  YYSYMBOL_update_default = 1619,          /* update_default  */
  YYSYMBOL__end_accept = 1620,             /* _end_accept  */
  YYSYMBOL_add_statement = 1621,           /* add_statement  */
  YYSYMBOL_1622_83 = 1622,                 /* $@83  */
  YYSYMBOL_add_body = 1623,                /* add_body  */
  YYSYMBOL__add_to = 1624,                 /* _add_to  */
  YYSYMBOL__end_add = 1625,                /* _end_add  */
  YYSYMBOL_allocate_statement = 1626,      /* allocate_statement  */
  YYSYMBOL_1627_84 = 1627,                 /* $@84  */
  YYSYMBOL_allocate_body = 1628,           /* allocate_body  */
  YYSYMBOL__loc = 1629,                    /* _loc  */
  YYSYMBOL__allocate_returning = 1630,     /* _allocate_returning  */
  YYSYMBOL_alter_statement = 1631,         /* alter_statement  */
  YYSYMBOL_1632_85 = 1632,                 /* $@85  */
  YYSYMBOL_alter_body = 1633,              /* alter_body  */
  YYSYMBOL_alter_entry = 1634,             /* alter_entry  */
  YYSYMBOL__proceed_to = 1635,             /* _proceed_to  */
  YYSYMBOL_call_statement = 1636,          /* call_statement  */
  YYSYMBOL_1637_86 = 1637,                 /* $@86  */
  YYSYMBOL_call_body = 1638,               /* call_body  */
  YYSYMBOL_1639_87 = 1639,                 /* $@87  */
  YYSYMBOL__conv_linkage = 1640,           /* _conv_linkage  */
  YYSYMBOL_1641_88 = 1641,                 /* $@88  */
  YYSYMBOL_conv_linkage_option = 1642,     /* conv_linkage_option  */
  YYSYMBOL__mnemonic_conv = 1643,          /* _mnemonic_conv  */
  YYSYMBOL_mnemonic_conv = 1644,           /* mnemonic_conv  */
  YYSYMBOL_program_or_prototype = 1645,    /* program_or_prototype  */
  YYSYMBOL__id_or_lit_or_func_as = 1646,   /* _id_or_lit_or_func_as  */
  YYSYMBOL_nested_or_prototype = 1647,     /* nested_or_prototype  */
  YYSYMBOL_call_using = 1648,              /* call_using  */
  YYSYMBOL_1649_89 = 1649,                 /* $@89  */
  YYSYMBOL_call_param_list = 1650,         /* call_param_list  */
  YYSYMBOL_call_param = 1651,              /* call_param  */
  YYSYMBOL__call_type = 1652,              /* _call_type  */
  YYSYMBOL_call_returning = 1653,          /* call_returning  */
  YYSYMBOL_return_give = 1654,             /* return_give  */
  YYSYMBOL_null_or_omitted = 1655,         /* null_or_omitted  */
  YYSYMBOL_call_exception_phrases = 1656,  /* call_exception_phrases  */
  YYSYMBOL__call_on_exception = 1657,      /* _call_on_exception  */
  YYSYMBOL_call_on_exception = 1658,       /* call_on_exception  */
  YYSYMBOL__call_not_on_exception = 1659,  /* _call_not_on_exception  */
  YYSYMBOL_call_not_on_exception = 1660,   /* call_not_on_exception  */
  YYSYMBOL__end_call = 1661,               /* _end_call  */
  YYSYMBOL_cancel_statement = 1662,        /* cancel_statement  */
  YYSYMBOL_1663_90 = 1663,                 /* $@90  */
  YYSYMBOL_cancel_body = 1664,             /* cancel_body  */
  YYSYMBOL_cancel_list = 1665,             /* cancel_list  */
  YYSYMBOL_id_or_lit_or_program_name = 1666, /* id_or_lit_or_program_name  */
  YYSYMBOL_close_statement = 1667,         /* close_statement  */
  YYSYMBOL_1668_91 = 1668,                 /* $@91  */
  YYSYMBOL_close_body = 1669,              /* close_body  */
  YYSYMBOL_close_files = 1670,             /* close_files  */
  YYSYMBOL__close_option = 1671,           /* _close_option  */
  YYSYMBOL_close_window = 1672,            /* close_window  */
  YYSYMBOL_1673_92 = 1673,                 /* $@92  */
  YYSYMBOL__close_display_option = 1674,   /* _close_display_option  */
  YYSYMBOL_compute_statement = 1675,       /* compute_statement  */
  YYSYMBOL_1676_93 = 1676,                 /* $@93  */
  YYSYMBOL_compute_body = 1677,            /* compute_body  */
  YYSYMBOL__end_compute = 1678,            /* _end_compute  */
  YYSYMBOL_commit_statement = 1679,        /* commit_statement  */
  YYSYMBOL_continue_statement = 1680,      /* continue_statement  */
  YYSYMBOL_1681_94 = 1681,                 /* $@94  */
  YYSYMBOL__continue_after_phrase = 1682,  /* _continue_after_phrase  */
  YYSYMBOL_1683_95 = 1683,                 /* $@95  */
  YYSYMBOL_destroy_statement = 1684,       /* destroy_statement  */
  YYSYMBOL_1685_96 = 1685,                 /* $@96  */
  YYSYMBOL_destroy_body = 1686,            /* destroy_body  */
  YYSYMBOL_delete_statement = 1687,        /* delete_statement  */
  YYSYMBOL_1688_97 = 1688,                 /* $@97  */
  YYSYMBOL_delete_body = 1689,             /* delete_body  */
  YYSYMBOL_delete_file_list = 1690,        /* delete_file_list  */
  YYSYMBOL__end_delete = 1691,             /* _end_delete  */
  YYSYMBOL_disable_statement = 1692,       /* disable_statement  */
  YYSYMBOL_1693_98 = 1693,                 /* $@98  */
  YYSYMBOL_enable_disable_handling = 1694, /* enable_disable_handling  */
  YYSYMBOL__enable_disable_key = 1695,     /* _enable_disable_key  */
  YYSYMBOL_communication_mode = 1696,      /* communication_mode  */
  YYSYMBOL_display_statement = 1697,       /* display_statement  */
  YYSYMBOL_1698_99 = 1698,                 /* $@99  */
  YYSYMBOL_display_body = 1699,            /* display_body  */
  YYSYMBOL_screen_or_device_display = 1700, /* screen_or_device_display  */
  YYSYMBOL_display_list = 1701,            /* display_list  */
  YYSYMBOL_display_atom = 1702,            /* display_atom  */
  YYSYMBOL_1703_100 = 1703,                /* $@100  */
  YYSYMBOL_disp_list = 1704,               /* disp_list  */
  YYSYMBOL__with_display_attr = 1705,      /* _with_display_attr  */
  YYSYMBOL_display_attrs = 1706,           /* display_attrs  */
  YYSYMBOL_display_clauses = 1707,         /* display_clauses  */
  YYSYMBOL_display_clause = 1708,          /* display_clause  */
  YYSYMBOL__display_upon = 1709,           /* _display_upon  */
  YYSYMBOL_display_upon = 1710,            /* display_upon  */
  YYSYMBOL_crt_under = 1711,               /* crt_under  */
  YYSYMBOL_display_erase = 1712,           /* display_erase  */
  YYSYMBOL_1713_101 = 1713,                /* $@101  */
  YYSYMBOL_display_pos_specifier = 1714,   /* display_pos_specifier  */
  YYSYMBOL_field_or_literal_or_erase_with_pos_specifier = 1715, /* field_or_literal_or_erase_with_pos_specifier  */
  YYSYMBOL_1716_102 = 1716,                /* $@102  */
  YYSYMBOL_field_or_literal_or_erase_list = 1717, /* field_or_literal_or_erase_list  */
  YYSYMBOL_field_or_literal_or_erase = 1718, /* field_or_literal_or_erase  */
  YYSYMBOL_display_message_box = 1719,     /* display_message_box  */
  YYSYMBOL_1720_103 = 1720,                /* $@103  */
  YYSYMBOL__display_message_clauses = 1721, /* _display_message_clauses  */
  YYSYMBOL_display_message_clauses = 1722, /* display_message_clauses  */
  YYSYMBOL_display_message_clause = 1723,  /* display_message_clause  */
  YYSYMBOL_display_window = 1724,          /* display_window  */
  YYSYMBOL_1725_104 = 1725,                /* $@104  */
  YYSYMBOL_1726_105 = 1726,                /* $@105  */
  YYSYMBOL_sub_or_window = 1727,           /* sub_or_window  */
  YYSYMBOL_display_floating_window = 1728, /* display_floating_window  */
  YYSYMBOL_1729_106 = 1729,                /* $@106  */
  YYSYMBOL_1730_107 = 1730,                /* $@107  */
  YYSYMBOL_display_initial_window = 1731,  /* display_initial_window  */
  YYSYMBOL_1732_108 = 1732,                /* $@108  */
  YYSYMBOL_initial_type = 1733,            /* initial_type  */
  YYSYMBOL__graphical = 1734,              /* _graphical  */
  YYSYMBOL__upon_window_handle = 1735,     /* _upon_window_handle  */
  YYSYMBOL_window_handle = 1736,           /* window_handle  */
  YYSYMBOL_display_window_clauses = 1737,  /* display_window_clauses  */
  YYSYMBOL_display_window_clause = 1738,   /* display_window_clause  */
  YYSYMBOL_shadow = 1739,                  /* shadow  */
  YYSYMBOL_boxed = 1740,                   /* boxed  */
  YYSYMBOL__top_or_bottom = 1741,          /* _top_or_bottom  */
  YYSYMBOL__left_or_centered_or_right = 1742, /* _left_or_centered_or_right  */
  YYSYMBOL_no_scroll_wrap = 1743,          /* no_scroll_wrap  */
  YYSYMBOL_pop_up_or_handle = 1744,        /* pop_up_or_handle  */
  YYSYMBOL_pop_up_area = 1745,             /* pop_up_area  */
  YYSYMBOL_handle_is_in = 1746,            /* handle_is_in  */
  YYSYMBOL_disp_attr = 1747,               /* disp_attr  */
  YYSYMBOL__end_display = 1748,            /* _end_display  */
  YYSYMBOL_divide_statement = 1749,        /* divide_statement  */
  YYSYMBOL_1750_109 = 1750,                /* $@109  */
  YYSYMBOL_divide_body = 1751,             /* divide_body  */
  YYSYMBOL__end_divide = 1752,             /* _end_divide  */
  YYSYMBOL_enable_statement = 1753,        /* enable_statement  */
  YYSYMBOL_1754_110 = 1754,                /* $@110  */
  YYSYMBOL_entry = 1755,                   /* entry  */
  YYSYMBOL_entry_statement = 1756,         /* entry_statement  */
  YYSYMBOL_1757_111 = 1757,                /* $@111  */
  YYSYMBOL_1758_112 = 1758,                /* $@112  */
  YYSYMBOL_entry_body = 1759,              /* entry_body  */
  YYSYMBOL_entry_goto_body = 1760,         /* entry_goto_body  */
  YYSYMBOL_evaluate_statement = 1761,      /* evaluate_statement  */
  YYSYMBOL_1762_113 = 1762,                /* $@113  */
  YYSYMBOL_evaluate_body = 1763,           /* evaluate_body  */
  YYSYMBOL_evaluate_subject_list = 1764,   /* evaluate_subject_list  */
  YYSYMBOL_evaluate_subject = 1765,        /* evaluate_subject  */
  YYSYMBOL_evaluate_condition_list = 1766, /* evaluate_condition_list  */
  YYSYMBOL_evaluate_case_list = 1767,      /* evaluate_case_list  */
  YYSYMBOL_evaluate_case = 1768,           /* evaluate_case  */
  YYSYMBOL_evaluate_other = 1769,          /* evaluate_other  */
  YYSYMBOL_evaluate_when_list = 1770,      /* evaluate_when_list  */
  YYSYMBOL_1771_114 = 1771,                /* $@114  */
  YYSYMBOL_1772_115 = 1772,                /* $@115  */
  YYSYMBOL_evaluate_object_list = 1773,    /* evaluate_object_list  */
  YYSYMBOL_evaluate_object = 1774,         /* evaluate_object  */
  YYSYMBOL__evaluate_thru_expr = 1775,     /* _evaluate_thru_expr  */
  YYSYMBOL__end_evaluate = 1776,           /* _end_evaluate  */
  YYSYMBOL_exhibit_statement = 1777,       /* exhibit_statement  */
  YYSYMBOL_1778_116 = 1778,                /* $@116  */
  YYSYMBOL_exhibit_body = 1779,            /* exhibit_body  */
  YYSYMBOL_1780_117 = 1780,                /* $@117  */
  YYSYMBOL__changed = 1781,                /* _changed  */
  YYSYMBOL__named = 1782,                  /* _named  */
  YYSYMBOL__erase = 1783,                  /* _erase  */
  YYSYMBOL_exhibit_target_list = 1784,     /* exhibit_target_list  */
  YYSYMBOL_exhibit_target = 1785,          /* exhibit_target  */
  YYSYMBOL_exit_statement = 1786,          /* exit_statement  */
  YYSYMBOL_1787_118 = 1787,                /* $@118  */
  YYSYMBOL_exit_body = 1788,               /* exit_body  */
  YYSYMBOL_goback_exit_body = 1789,        /* goback_exit_body  */
  YYSYMBOL_free_statement = 1790,          /* free_statement  */
  YYSYMBOL_1791_119 = 1791,                /* $@119  */
  YYSYMBOL_free_body = 1792,               /* free_body  */
  YYSYMBOL_generate_statement = 1793,      /* generate_statement  */
  YYSYMBOL_1794_120 = 1794,                /* $@120  */
  YYSYMBOL_generate_body = 1795,           /* generate_body  */
  YYSYMBOL_goto_statement = 1796,          /* goto_statement  */
  YYSYMBOL_1797_121 = 1797,                /* $@121  */
  YYSYMBOL_go_body = 1798,                 /* go_body  */
  YYSYMBOL_goto_depending = 1799,          /* goto_depending  */
  YYSYMBOL_goback_statement = 1800,        /* goback_statement  */
  YYSYMBOL_1801_122 = 1801,                /* $@122  */
  YYSYMBOL_if_statement = 1802,            /* if_statement  */
  YYSYMBOL_1803_123 = 1803,                /* $@123  */
  YYSYMBOL_if_else_statements = 1804,      /* if_else_statements  */
  YYSYMBOL__if_then = 1805,                /* _if_then  */
  YYSYMBOL_if_true = 1806,                 /* if_true  */
  YYSYMBOL_if_false = 1807,                /* if_false  */
  YYSYMBOL__end_if = 1808,                 /* _end_if  */
  YYSYMBOL_initialize_statement = 1809,    /* initialize_statement  */
  YYSYMBOL_1810_124 = 1810,                /* $@124  */
  YYSYMBOL_initialize_body = 1811,         /* initialize_body  */
  YYSYMBOL__initialize_filler = 1812,      /* _initialize_filler  */
  YYSYMBOL__initialize_value = 1813,       /* _initialize_value  */
  YYSYMBOL__initialize_replacing = 1814,   /* _initialize_replacing  */
  YYSYMBOL_initialize_replacing_list = 1815, /* initialize_replacing_list  */
  YYSYMBOL_initialize_replacing_item = 1816, /* initialize_replacing_item  */
  YYSYMBOL_initialize_category = 1817,     /* initialize_category  */
  YYSYMBOL__initialize_default = 1818,     /* _initialize_default  */
  YYSYMBOL_initiate_statement = 1819,      /* initiate_statement  */
  YYSYMBOL_1820_125 = 1820,                /* $@125  */
  YYSYMBOL_initiate_body = 1821,           /* initiate_body  */
  YYSYMBOL_inquire_statement = 1822,       /* inquire_statement  */
  YYSYMBOL_1823_126 = 1823,                /* $@126  */
  YYSYMBOL_inquire_body = 1824,            /* inquire_body  */
  YYSYMBOL_inspect_statement = 1825,       /* inspect_statement  */
  YYSYMBOL_1826_127 = 1826,                /* $@127  */
  YYSYMBOL_inspect_body = 1827,            /* inspect_body  */
  YYSYMBOL__backward = 1828,               /* _backward  */
  YYSYMBOL_send_identifier = 1829,         /* send_identifier  */
  YYSYMBOL_inspect_format_variant = 1830,  /* inspect_format_variant  */
  YYSYMBOL_examine_statement = 1831,       /* examine_statement  */
  YYSYMBOL_1832_128 = 1832,                /* $@128  */
  YYSYMBOL_examine_format_variant = 1833,  /* examine_format_variant  */
  YYSYMBOL_1834_129 = 1834,                /* $@129  */
  YYSYMBOL_examine_tallying_keyword = 1835, /* examine_tallying_keyword  */
  YYSYMBOL_examine_replacing_keyword = 1836, /* examine_replacing_keyword  */
  YYSYMBOL__examine_tallying_replacing = 1837, /* _examine_tallying_replacing  */
  YYSYMBOL_single_character_value = 1838,  /* single_character_value  */
  YYSYMBOL_inspect_tallying = 1839,        /* inspect_tallying  */
  YYSYMBOL_1840_130 = 1840,                /* $@130  */
  YYSYMBOL_inspect_replacing = 1841,       /* inspect_replacing  */
  YYSYMBOL_inspect_converting = 1842,      /* inspect_converting  */
  YYSYMBOL_tallying_list = 1843,           /* tallying_list  */
  YYSYMBOL_tallying_item = 1844,           /* tallying_item  */
  YYSYMBOL_replacing_list = 1845,          /* replacing_list  */
  YYSYMBOL_replacing_item = 1846,          /* replacing_item  */
  YYSYMBOL_rep_keyword = 1847,             /* rep_keyword  */
  YYSYMBOL_replacing_region = 1848,        /* replacing_region  */
  YYSYMBOL_inspect_region = 1849,          /* inspect_region  */
  YYSYMBOL_inspect_before = 1850,          /* inspect_before  */
  YYSYMBOL_inspect_after = 1851,           /* inspect_after  */
  YYSYMBOL_json = 1852,                    /* json  */
  YYSYMBOL_json_generate_statement = 1853, /* json_generate_statement  */
  YYSYMBOL_1854_131 = 1854,                /* $@131  */
  YYSYMBOL_json_generate_body = 1855,      /* json_generate_body  */
  YYSYMBOL_1856_132 = 1856,                /* $@132  */
  YYSYMBOL_1857_133 = 1857,                /* $@133  */
  YYSYMBOL__json_suppress = 1858,          /* _json_suppress  */
  YYSYMBOL_json_suppress_list = 1859,      /* json_suppress_list  */
  YYSYMBOL_json_suppress_entry = 1860,     /* json_suppress_entry  */
  YYSYMBOL__end_json = 1861,               /* _end_json  */
  YYSYMBOL_json_parse_statement = 1862,    /* json_parse_statement  */
  YYSYMBOL_1863_134 = 1863,                /* $@134  */
  YYSYMBOL_json_parse_body = 1864,         /* json_parse_body  */
  YYSYMBOL__with_detail = 1865,            /* _with_detail  */
  YYSYMBOL_merge_statement = 1866,         /* merge_statement  */
  YYSYMBOL_1867_135 = 1867,                /* $@135  */
  YYSYMBOL_modify_statement = 1868,        /* modify_statement  */
  YYSYMBOL_1869_136 = 1869,                /* $@136  */
  YYSYMBOL_modify_body = 1870,             /* modify_body  */
  YYSYMBOL__end_modify = 1871,             /* _end_modify  */
  YYSYMBOL_move_statement = 1872,          /* move_statement  */
  YYSYMBOL_1873_137 = 1873,                /* $@137  */
  YYSYMBOL_move_body = 1874,               /* move_body  */
  YYSYMBOL_multiply_statement = 1875,      /* multiply_statement  */
  YYSYMBOL_1876_138 = 1876,                /* $@138  */
  YYSYMBOL_multiply_body = 1877,           /* multiply_body  */
  YYSYMBOL__end_multiply = 1878,           /* _end_multiply  */
  YYSYMBOL_open_statement = 1879,          /* open_statement  */
  YYSYMBOL_1880_139 = 1880,                /* $@139  */
  YYSYMBOL_open_body = 1881,               /* open_body  */
  YYSYMBOL_open_file_entry = 1882,         /* open_file_entry  */
  YYSYMBOL__open_exclusive = 1883,         /* _open_exclusive  */
  YYSYMBOL_open_mode = 1884,               /* open_mode  */
  YYSYMBOL__open_sharing = 1885,           /* _open_sharing  */
  YYSYMBOL__open_option = 1886,            /* _open_option  */
  YYSYMBOL_lock_allowing = 1887,           /* lock_allowing  */
  YYSYMBOL_open_lock_option = 1888,        /* open_lock_option  */
  YYSYMBOL_allowing_option = 1889,         /* allowing_option  */
  YYSYMBOL_allowing_all = 1890,            /* allowing_all  */
  YYSYMBOL_open_option_sequential = 1891,  /* open_option_sequential  */
  YYSYMBOL_osvs_input_mode = 1892,         /* osvs_input_mode  */
  YYSYMBOL_perform_statement = 1893,       /* perform_statement  */
  YYSYMBOL_1894_140 = 1894,                /* $@140  */
  YYSYMBOL_perform_body = 1895,            /* perform_body  */
  YYSYMBOL_1896_141 = 1896,                /* $@141  */
  YYSYMBOL_1897_142 = 1897,                /* $@142  */
  YYSYMBOL__end_perform = 1898,            /* _end_perform  */
  YYSYMBOL_end_perform_or_dot = 1899,      /* end_perform_or_dot  */
  YYSYMBOL_perform_procedure = 1900,       /* perform_procedure  */
  YYSYMBOL__perform_option = 1901,         /* _perform_option  */
  YYSYMBOL_perform_test = 1902,            /* perform_test  */
  YYSYMBOL_cond_or_exit = 1903,            /* cond_or_exit  */
  YYSYMBOL_perform_varying_list = 1904,    /* perform_varying_list  */
  YYSYMBOL_perform_varying = 1905,         /* perform_varying  */
  YYSYMBOL__by_phrase = 1906,              /* _by_phrase  */
  YYSYMBOL_purge_statement = 1907,         /* purge_statement  */
  YYSYMBOL_1908_143 = 1908,                /* $@143  */
  YYSYMBOL_raise_statement = 1909,         /* raise_statement  */
  YYSYMBOL_1910_144 = 1910,                /* $@144  */
  YYSYMBOL_raise_body = 1911,              /* raise_body  */
  YYSYMBOL_exception_name = 1912,          /* exception_name  */
  YYSYMBOL_read_statement = 1913,          /* read_statement  */
  YYSYMBOL_1914_145 = 1914,                /* $@145  */
  YYSYMBOL_read_body = 1915,               /* read_body  */
  YYSYMBOL__read_into = 1916,              /* _read_into  */
  YYSYMBOL__lock_phrases = 1917,           /* _lock_phrases  */
  YYSYMBOL_ignoring_lock = 1918,           /* ignoring_lock  */
  YYSYMBOL_advancing_lock_or_retry = 1919, /* advancing_lock_or_retry  */
  YYSYMBOL__retry_phrase = 1920,           /* _retry_phrase  */
  YYSYMBOL_retry_phrase = 1921,            /* retry_phrase  */
  YYSYMBOL_retry_options = 1922,           /* retry_options  */
  YYSYMBOL__extended_with_lock = 1923,     /* _extended_with_lock  */
  YYSYMBOL_extended_with_lock = 1924,      /* extended_with_lock  */
  YYSYMBOL__read_key = 1925,               /* _read_key  */
  YYSYMBOL_read_handler = 1926,            /* read_handler  */
  YYSYMBOL__end_read = 1927,               /* _end_read  */
  YYSYMBOL_ready_statement = 1928,         /* ready_statement  */
  YYSYMBOL_receive_statement = 1929,       /* receive_statement  */
  YYSYMBOL_1930_146 = 1930,                /* $@146  */
  YYSYMBOL_receive_body = 1931,            /* receive_body  */
  YYSYMBOL_message_or_segment = 1932,      /* message_or_segment  */
  YYSYMBOL__data_sentence_phrases = 1933,  /* _data_sentence_phrases  */
  YYSYMBOL__no_data_sentence = 1934,       /* _no_data_sentence  */
  YYSYMBOL_no_data_sentence = 1935,        /* no_data_sentence  */
  YYSYMBOL__with_data_sentence = 1936,     /* _with_data_sentence  */
  YYSYMBOL_with_data_sentence = 1937,      /* with_data_sentence  */
  YYSYMBOL__end_receive = 1938,            /* _end_receive  */
  YYSYMBOL_release_statement = 1939,       /* release_statement  */
  YYSYMBOL_1940_147 = 1940,                /* $@147  */
  YYSYMBOL_release_body = 1941,            /* release_body  */
  YYSYMBOL_reset_statement = 1942,         /* reset_statement  */
  YYSYMBOL_return_statement = 1943,        /* return_statement  */
  YYSYMBOL_1944_148 = 1944,                /* $@148  */
  YYSYMBOL_return_body = 1945,             /* return_body  */
  YYSYMBOL__end_return = 1946,             /* _end_return  */
  YYSYMBOL_rewrite_statement = 1947,       /* rewrite_statement  */
  YYSYMBOL_1948_149 = 1948,                /* $@149  */
  YYSYMBOL_rewrite_body = 1949,            /* rewrite_body  */
  YYSYMBOL__with_lock = 1950,              /* _with_lock  */
  YYSYMBOL_with_lock = 1951,               /* with_lock  */
  YYSYMBOL__end_rewrite = 1952,            /* _end_rewrite  */
  YYSYMBOL_rollback_statement = 1953,      /* rollback_statement  */
  YYSYMBOL_search = 1954,                  /* search  */
  YYSYMBOL_search_statement = 1955,        /* search_statement  */
  YYSYMBOL_1956_150 = 1956,                /* $@150  */
  YYSYMBOL_1957_151 = 1957,                /* $@151  */
  YYSYMBOL_search_body = 1958,             /* search_body  */
  YYSYMBOL_search_all_body = 1959,         /* search_all_body  */
  YYSYMBOL__search_varying = 1960,         /* _search_varying  */
  YYSYMBOL__search_at_end = 1961,          /* _search_at_end  */
  YYSYMBOL_end_pos_token = 1962,           /* end_pos_token  */
  YYSYMBOL_search_whens = 1963,            /* search_whens  */
  YYSYMBOL_search_when = 1964,             /* search_when  */
  YYSYMBOL__end_search = 1965,             /* _end_search  */
  YYSYMBOL_end_search_pos_token = 1966,    /* end_search_pos_token  */
  YYSYMBOL_send_statement = 1967,          /* send_statement  */
  YYSYMBOL_1968_152 = 1968,                /* $@152  */
  YYSYMBOL_send_body = 1969,               /* send_body  */
  YYSYMBOL_send_body_mcs = 1970,           /* send_body_mcs  */
  YYSYMBOL_message_tag_data_item = 1971,   /* message_tag_data_item  */
  YYSYMBOL__from_identifier = 1972,        /* _from_identifier  */
  YYSYMBOL_from_identifier = 1973,         /* from_identifier  */
  YYSYMBOL_send_body_cd = 1974,            /* send_body_cd  */
  YYSYMBOL_with_indicator = 1975,          /* with_indicator  */
  YYSYMBOL__replacing_line = 1976,         /* _replacing_line  */
  YYSYMBOL_set_statement = 1977,           /* set_statement  */
  YYSYMBOL_1978_153 = 1978,                /* $@153  */
  YYSYMBOL_set_body = 1979,                /* set_body  */
  YYSYMBOL_on_or_off = 1980,               /* on_or_off  */
  YYSYMBOL_up_or_down = 1981,              /* up_or_down  */
  YYSYMBOL_set_environment = 1982,         /* set_environment  */
  YYSYMBOL_set_attr = 1983,                /* set_attr  */
  YYSYMBOL_set_attr_clause = 1984,         /* set_attr_clause  */
  YYSYMBOL_set_attr_one = 1985,            /* set_attr_one  */
  YYSYMBOL_set_to = 1986,                  /* set_to  */
  YYSYMBOL_set_up_down = 1987,             /* set_up_down  */
  YYSYMBOL_set_to_on_off_sequence = 1988,  /* set_to_on_off_sequence  */
  YYSYMBOL_set_to_on_off = 1989,           /* set_to_on_off  */
  YYSYMBOL_set_to_true_false_sequence = 1990, /* set_to_true_false_sequence  */
  YYSYMBOL_set_to_true_false = 1991,       /* set_to_true_false  */
  YYSYMBOL_set_last_exception_to_off = 1992, /* set_last_exception_to_off  */
  YYSYMBOL_set_thread_priority = 1993,     /* set_thread_priority  */
  YYSYMBOL_sort_statement = 1994,          /* sort_statement  */
  YYSYMBOL_1995_154 = 1995,                /* $@154  */
  YYSYMBOL_sort_body = 1996,               /* sort_body  */
  YYSYMBOL_1997_155 = 1997,                /* @155  */
  YYSYMBOL__sort_key_list = 1998,          /* _sort_key_list  */
  YYSYMBOL__key_sort_list = 1999,          /* _key_sort_list  */
  YYSYMBOL__sort_duplicates = 2000,        /* _sort_duplicates  */
  YYSYMBOL__sort_collating = 2001,         /* _sort_collating  */
  YYSYMBOL_sort_input = 2002,              /* sort_input  */
  YYSYMBOL_sort_output = 2003,             /* sort_output  */
  YYSYMBOL_start_statement = 2004,         /* start_statement  */
  YYSYMBOL_2005_156 = 2005,                /* $@156  */
  YYSYMBOL_start_body = 2006,              /* start_body  */
  YYSYMBOL__sizelen_clause = 2007,         /* _sizelen_clause  */
  YYSYMBOL__start_key = 2008,              /* _start_key  */
  YYSYMBOL_start_op = 2009,                /* start_op  */
  YYSYMBOL_not_equal_op = 2010,            /* not_equal_op  */
  YYSYMBOL__end_start = 2011,              /* _end_start  */
  YYSYMBOL_stop = 2012,                    /* stop  */
  YYSYMBOL_stop_statement = 2013,          /* stop_statement  */
  YYSYMBOL_2014_157 = 2014,                /* $@157  */
  YYSYMBOL_stop_returning = 2015,          /* stop_returning  */
  YYSYMBOL__status_x = 2016,               /* _status_x  */
  YYSYMBOL_stop_argument = 2017,           /* stop_argument  */
  YYSYMBOL_stop_literal = 2018,            /* stop_literal  */
  YYSYMBOL_string_statement = 2019,        /* string_statement  */
  YYSYMBOL_2020_158 = 2020,                /* $@158  */
  YYSYMBOL_string_body = 2021,             /* string_body  */
  YYSYMBOL_string_items = 2022,            /* string_items  */
  YYSYMBOL_2023_159 = 2023,                /* $@159  */
  YYSYMBOL_string_item_list = 2024,        /* string_item_list  */
  YYSYMBOL_string_item = 2025,             /* string_item  */
  YYSYMBOL__string_delimited = 2026,       /* _string_delimited  */
  YYSYMBOL_string_delimiter = 2027,        /* string_delimiter  */
  YYSYMBOL__with_pointer = 2028,           /* _with_pointer  */
  YYSYMBOL__end_string = 2029,             /* _end_string  */
  YYSYMBOL_subtract_statement = 2030,      /* subtract_statement  */
  YYSYMBOL_2031_160 = 2031,                /* $@160  */
  YYSYMBOL_subtract_body = 2032,           /* subtract_body  */
  YYSYMBOL__end_subtract = 2033,           /* _end_subtract  */
  YYSYMBOL_suppress_statement = 2034,      /* suppress_statement  */
  YYSYMBOL_2035_161 = 2035,                /* $@161  */
  YYSYMBOL__printing = 2036,               /* _printing  */
  YYSYMBOL_terminate_statement = 2037,     /* terminate_statement  */
  YYSYMBOL_2038_162 = 2038,                /* $@162  */
  YYSYMBOL_terminate_body = 2039,          /* terminate_body  */
  YYSYMBOL_transform_statement = 2040,     /* transform_statement  */
  YYSYMBOL_2041_163 = 2041,                /* $@163  */
  YYSYMBOL_transform_body = 2042,          /* transform_body  */
  YYSYMBOL_unlock_statement = 2043,        /* unlock_statement  */
  YYSYMBOL_2044_164 = 2044,                /* $@164  */
  YYSYMBOL_unlock_body = 2045,             /* unlock_body  */
  YYSYMBOL_unstring_statement = 2046,      /* unstring_statement  */
  YYSYMBOL_2047_165 = 2047,                /* $@165  */
  YYSYMBOL_unstring_body = 2048,           /* unstring_body  */
  YYSYMBOL__unstring_delimited = 2049,     /* _unstring_delimited  */
  YYSYMBOL_unstring_delimited_list = 2050, /* unstring_delimited_list  */
  YYSYMBOL_unstring_delimited_item = 2051, /* unstring_delimited_item  */
  YYSYMBOL_unstring_into = 2052,           /* unstring_into  */
  YYSYMBOL_unstring_into_item = 2053,      /* unstring_into_item  */
  YYSYMBOL__unstring_into_delimiter = 2054, /* _unstring_into_delimiter  */
  YYSYMBOL__unstring_tallying = 2055,      /* _unstring_tallying  */
  YYSYMBOL__end_unstring = 2056,           /* _end_unstring  */
  YYSYMBOL_validate_statement = 2057,      /* validate_statement  */
  YYSYMBOL_2058_166 = 2058,                /* $@166  */
  YYSYMBOL_validate_fields = 2059,         /* validate_fields  */
  YYSYMBOL_use_statement = 2060,           /* use_statement  */
  YYSYMBOL_2061_167 = 2061,                /* $@167  */
  YYSYMBOL_use_phrase = 2062,              /* use_phrase  */
  YYSYMBOL_use_file_exception = 2063,      /* use_file_exception  */
  YYSYMBOL__use_global = 2064,             /* _use_global  */
  YYSYMBOL_use_file_exception_target = 2065, /* use_file_exception_target  */
  YYSYMBOL_use_for_debugging = 2066,       /* use_for_debugging  */
  YYSYMBOL_debugging_list = 2067,          /* debugging_list  */
  YYSYMBOL_debugging_target = 2068,        /* debugging_target  */
  YYSYMBOL__all_refs = 2069,               /* _all_refs  */
  YYSYMBOL_use_at_start_end = 2070,        /* use_at_start_end  */
  YYSYMBOL_program_start_end = 2071,       /* program_start_end  */
  YYSYMBOL_use_before_reporting = 2072,    /* use_before_reporting  */
  YYSYMBOL_use_after_exception = 2073,     /* use_after_exception  */
  YYSYMBOL_use_exception_list = 2074,      /* use_exception_list  */
  YYSYMBOL_use_exception = 2075,           /* use_exception  */
  YYSYMBOL_use_ex_keyw = 2076,             /* use_ex_keyw  */
  YYSYMBOL_write_statement = 2077,         /* write_statement  */
  YYSYMBOL_2078_168 = 2078,                /* $@168  */
  YYSYMBOL_write_body = 2079,              /* write_body  */
  YYSYMBOL_from_option = 2080,             /* from_option  */
  YYSYMBOL_write_option = 2081,            /* write_option  */
  YYSYMBOL_before_or_after = 2082,         /* before_or_after  */
  YYSYMBOL_write_handler = 2083,           /* write_handler  */
  YYSYMBOL__end_write = 2084,              /* _end_write  */
  YYSYMBOL_xml = 2085,                     /* xml  */
  YYSYMBOL_xml_generate_statement = 2086,  /* xml_generate_statement  */
  YYSYMBOL_2087_169 = 2087,                /* $@169  */
  YYSYMBOL_xml_generate_body = 2088,       /* xml_generate_body  */
  YYSYMBOL_2089_170 = 2089,                /* $@170  */
  YYSYMBOL_2090_171 = 2090,                /* $@171  */
  YYSYMBOL__with_encoding_xml_dec_and_attrs = 2091, /* _with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attrs = 2092, /* with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attr = 2093, /* with_encoding_xml_dec_and_attr  */
  YYSYMBOL_encoding_xml_dec_and_attr = 2094, /* encoding_xml_dec_and_attr  */
  YYSYMBOL__xml_gen_namespace = 2095,      /* _xml_gen_namespace  */
  YYSYMBOL__xml_gen_namespace_prefix = 2096, /* _xml_gen_namespace_prefix  */
  YYSYMBOL__xml_name_of = 2097,            /* _xml_name_of  */
  YYSYMBOL_identifier_name_list = 2098,    /* identifier_name_list  */
  YYSYMBOL_identifier_is_name = 2099,      /* identifier_is_name  */
  YYSYMBOL__json_name_of = 2100,           /* _json_name_of  */
  YYSYMBOL_json_identifier_name_list = 2101, /* json_identifier_name_list  */
  YYSYMBOL_json_identifier_is_name = 2102, /* json_identifier_is_name  */
  YYSYMBOL__type_of = 2103,                /* _type_of  */
  YYSYMBOL_identifier_type_list = 2104,    /* identifier_type_list  */
  YYSYMBOL_identifier_is_type = 2105,      /* identifier_is_type  */
  YYSYMBOL__xml_type = 2106,               /* _xml_type  */
  YYSYMBOL_ml_type = 2107,                 /* ml_type  */
  YYSYMBOL__xml_gen_suppress = 2108,       /* _xml_gen_suppress  */
  YYSYMBOL_xml_suppress_list = 2109,       /* xml_suppress_list  */
  YYSYMBOL_xml_suppress_entry = 2110,      /* xml_suppress_entry  */
  YYSYMBOL_xml_suppress_generic_opt = 2111, /* xml_suppress_generic_opt  */
  YYSYMBOL_xml_suppress_when_list = 2112,  /* xml_suppress_when_list  */
  YYSYMBOL__end_xml = 2113,                /* _end_xml  */
  YYSYMBOL_xml_parse_statement = 2114,     /* xml_parse_statement  */
  YYSYMBOL_2115_172 = 2115,                /* $@172  */
  YYSYMBOL_xml_parse_body = 2116,          /* xml_parse_body  */
  YYSYMBOL_2117_173 = 2117,                /* $@173  */
  YYSYMBOL__with_encoding = 2118,          /* _with_encoding  */
  YYSYMBOL__returning_national = 2119,     /* _returning_national  */
  YYSYMBOL__validating_with = 2120,        /* _validating_with  */
  YYSYMBOL_schema_file_or_record_name = 2121, /* schema_file_or_record_name  */
  YYSYMBOL__accept_exception_phrases = 2122, /* _accept_exception_phrases  */
  YYSYMBOL__accp_on_exception = 2123,      /* _accp_on_exception  */
  YYSYMBOL_accp_on_exception = 2124,       /* accp_on_exception  */
  YYSYMBOL_escape_or_exception = 2125,     /* escape_or_exception  */
  YYSYMBOL__accp_not_on_exception = 2126,  /* _accp_not_on_exception  */
  YYSYMBOL_accp_not_on_exception = 2127,   /* accp_not_on_exception  */
  YYSYMBOL_not_escape_or_not_exception = 2128, /* not_escape_or_not_exception  */
  YYSYMBOL__common_exception_phrases = 2129, /* _common_exception_phrases  */
  YYSYMBOL__common_on_exception = 2130,    /* _common_on_exception  */
  YYSYMBOL_common_on_exception = 2131,     /* common_on_exception  */
  YYSYMBOL__common_not_on_exception = 2132, /* _common_not_on_exception  */
  YYSYMBOL_common_not_on_exception = 2133, /* common_not_on_exception  */
  YYSYMBOL_on_size_error_phrases = 2134,   /* on_size_error_phrases  */
  YYSYMBOL__on_size_error = 2135,          /* _on_size_error  */
  YYSYMBOL_on_size_error = 2136,           /* on_size_error  */
  YYSYMBOL__not_on_size_error = 2137,      /* _not_on_size_error  */
  YYSYMBOL_not_on_size_error = 2138,       /* not_on_size_error  */
  YYSYMBOL__on_overflow_phrases = 2139,    /* _on_overflow_phrases  */
  YYSYMBOL__on_overflow = 2140,            /* _on_overflow  */
  YYSYMBOL_on_overflow = 2141,             /* on_overflow  */
  YYSYMBOL__not_on_overflow = 2142,        /* _not_on_overflow  */
  YYSYMBOL_not_on_overflow = 2143,         /* not_on_overflow  */
  YYSYMBOL_return_at_end = 2144,           /* return_at_end  */
  YYSYMBOL_read_at_end = 2145,             /* read_at_end  */
  YYSYMBOL__at_end_clause = 2146,          /* _at_end_clause  */
  YYSYMBOL_at_end_clause = 2147,           /* at_end_clause  */
  YYSYMBOL__not_at_end_clause = 2148,      /* _not_at_end_clause  */
  YYSYMBOL_not_at_end_clause = 2149,       /* not_at_end_clause  */
  YYSYMBOL_at_eop_clauses = 2150,          /* at_eop_clauses  */
  YYSYMBOL__at_eop_clause = 2151,          /* _at_eop_clause  */
  YYSYMBOL_at_eop_clause = 2152,           /* at_eop_clause  */
  YYSYMBOL__not_at_eop_clause = 2153,      /* _not_at_eop_clause  */
  YYSYMBOL_not_at_eop_clause = 2154,       /* not_at_eop_clause  */
  YYSYMBOL__invalid_key_phrases = 2155,    /* _invalid_key_phrases  */
  YYSYMBOL_invalid_key_phrases = 2156,     /* invalid_key_phrases  */
  YYSYMBOL__invalid_key_sentence = 2157,   /* _invalid_key_sentence  */
  YYSYMBOL_invalid_key_sentence = 2158,    /* invalid_key_sentence  */
  YYSYMBOL__not_invalid_key_sentence = 2159, /* _not_invalid_key_sentence  */
  YYSYMBOL_not_invalid_key_sentence = 2160, /* not_invalid_key_sentence  */
  YYSYMBOL__thread_start = 2161,           /* _thread_start  */
  YYSYMBOL__thread_handle = 2162,          /* _thread_handle  */
  YYSYMBOL_thread_reference_optional = 2163, /* thread_reference_optional  */
  YYSYMBOL__scroll_lines = 2164,           /* _scroll_lines  */
  YYSYMBOL__count_in = 2165,               /* _count_in  */
  YYSYMBOL_condition = 2166,               /* condition  */
  YYSYMBOL_expr = 2167,                    /* expr  */
  YYSYMBOL_partial_expr = 2168,            /* partial_expr  */
  YYSYMBOL_2169_174 = 2169,                /* $@174  */
  YYSYMBOL_expr_tokens = 2170,             /* expr_tokens  */
  YYSYMBOL_expr_token = 2171,              /* expr_token  */
  YYSYMBOL_condition_no_is = 2172,         /* condition_no_is  */
  YYSYMBOL_expr_no_is = 2173,              /* expr_no_is  */
  YYSYMBOL_partial_expr_no_is = 2174,      /* partial_expr_no_is  */
  YYSYMBOL_2175_175 = 2175,                /* $@175  */
  YYSYMBOL_expr_tokens_no_is = 2176,       /* expr_tokens_no_is  */
  YYSYMBOL_expr_token_no_is = 2177,        /* expr_token_no_is  */
  YYSYMBOL__not_expr = 2178,               /* _not_expr  */
  YYSYMBOL_not_expr = 2179,                /* not_expr  */
  YYSYMBOL_condition_or_class = 2180,      /* condition_or_class  */
  YYSYMBOL_eq = 2181,                      /* eq  */
  YYSYMBOL_gt = 2182,                      /* gt  */
  YYSYMBOL_lt = 2183,                      /* lt  */
  YYSYMBOL_ge = 2184,                      /* ge  */
  YYSYMBOL_le = 2185,                      /* le  */
  YYSYMBOL_exp_list = 2186,                /* exp_list  */
  YYSYMBOL__e_sep = 2187,                  /* _e_sep  */
  YYSYMBOL_exp = 2188,                     /* exp  */
  YYSYMBOL_exp_term = 2189,                /* exp_term  */
  YYSYMBOL_exp_factor = 2190,              /* exp_factor  */
  YYSYMBOL_exp_unary = 2191,               /* exp_unary  */
  YYSYMBOL_exp_atom = 2192,                /* exp_atom  */
  YYSYMBOL_line_linage_page_counter = 2193, /* line_linage_page_counter  */
  YYSYMBOL_arithmetic_x_list = 2194,       /* arithmetic_x_list  */
  YYSYMBOL_arithmetic_x = 2195,            /* arithmetic_x  */
  YYSYMBOL_record_name = 2196,             /* record_name  */
  YYSYMBOL_file_or_record_name = 2197,     /* file_or_record_name  */
  YYSYMBOL_table_name = 2198,              /* table_name  */
  YYSYMBOL_file_name_list = 2199,          /* file_name_list  */
  YYSYMBOL_file_file_name_list = 2200,     /* file_file_name_list  */
  YYSYMBOL_file_name = 2201,               /* file_name  */
  YYSYMBOL_cd_name = 2202,                 /* cd_name  */
  YYSYMBOL_report_name = 2203,             /* report_name  */
  YYSYMBOL_mnemonic_name_list = 2204,      /* mnemonic_name_list  */
  YYSYMBOL_mnemonic_name = 2205,           /* mnemonic_name  */
  YYSYMBOL_entry_name_list = 2206,         /* entry_name_list  */
  YYSYMBOL_entry_name = 2207,              /* entry_name  */
  YYSYMBOL_procedure_name_list = 2208,     /* procedure_name_list  */
  YYSYMBOL_procedure_name = 2209,          /* procedure_name  */
  YYSYMBOL_label = 2210,                   /* label  */
  YYSYMBOL_integer_label = 2211,           /* integer_label  */
  YYSYMBOL_reference_list = 2212,          /* reference_list  */
  YYSYMBOL_reference = 2213,               /* reference  */
  YYSYMBOL__reference = 2214,              /* _reference  */
  YYSYMBOL_single_reference_list = 2215,   /* single_reference_list  */
  YYSYMBOL_single_reference = 2216,        /* single_reference  */
  YYSYMBOL_optional_reference_list = 2217, /* optional_reference_list  */
  YYSYMBOL_optional_reference = 2218,      /* optional_reference  */
  YYSYMBOL_reference_or_literal = 2219,    /* reference_or_literal  */
  YYSYMBOL_undefined_word = 2220,          /* undefined_word  */
  YYSYMBOL_unique_word = 2221,             /* unique_word  */
  YYSYMBOL_target_x_list = 2222,           /* target_x_list  */
  YYSYMBOL_target_x = 2223,                /* target_x  */
  YYSYMBOL__x_list = 2224,                 /* _x_list  */
  YYSYMBOL_x_list = 2225,                  /* x_list  */
  YYSYMBOL_x = 2226,                       /* x  */
  YYSYMBOL_call_x = 2227,                  /* call_x  */
  YYSYMBOL_x_common = 2228,                /* x_common  */
  YYSYMBOL_length_of_register = 2229,      /* length_of_register  */
  YYSYMBOL_report_x_list = 2230,           /* report_x_list  */
  YYSYMBOL_expr_x = 2231,                  /* expr_x  */
  YYSYMBOL_arith_x = 2232,                 /* arith_x  */
  YYSYMBOL_arith_nonzero_x = 2233,         /* arith_nonzero_x  */
  YYSYMBOL_numeric_literal = 2234,         /* numeric_literal  */
  YYSYMBOL_non_numeric_literal = 2235,     /* non_numeric_literal  */
  YYSYMBOL_nonzero_numeric_literal = 2236, /* nonzero_numeric_literal  */
  YYSYMBOL_prog_or_entry = 2237,           /* prog_or_entry  */
  YYSYMBOL_alnum_or_id = 2238,             /* alnum_or_id  */
  YYSYMBOL_simple_display_value = 2239,    /* simple_display_value  */
  YYSYMBOL_inspect_from = 2240,            /* inspect_from  */
  YYSYMBOL_inspect_to = 2241,              /* inspect_to  */
  YYSYMBOL_simple_value = 2242,            /* simple_value  */
  YYSYMBOL_simple_all_value = 2243,        /* simple_all_value  */
  YYSYMBOL_id_or_lit = 2244,               /* id_or_lit  */
  YYSYMBOL_id_or_lit_or_func = 2245,       /* id_or_lit_or_func  */
  YYSYMBOL_id_or_lit_or_length_or_func = 2246, /* id_or_lit_or_length_or_func  */
  YYSYMBOL_num_id_or_lit = 2247,           /* num_id_or_lit  */
  YYSYMBOL_positive_id_or_lit = 2248,      /* positive_id_or_lit  */
  YYSYMBOL_pos_num_id_or_lit_or_zero = 2249, /* pos_num_id_or_lit_or_zero  */
  YYSYMBOL_pos_num_id_or_lit = 2250,       /* pos_num_id_or_lit  */
  YYSYMBOL_from_parameter = 2251,          /* from_parameter  */
  YYSYMBOL_sub_identifier = 2252,          /* sub_identifier  */
  YYSYMBOL_table_identifier = 2253,        /* table_identifier  */
  YYSYMBOL_sub_identifier_1 = 2254,        /* sub_identifier_1  */
  YYSYMBOL_display_identifier = 2255,      /* display_identifier  */
  YYSYMBOL_numeric_identifier = 2256,      /* numeric_identifier  */
  YYSYMBOL_identifier_or_file_name = 2257, /* identifier_or_file_name  */
  YYSYMBOL_identifier_field = 2258,        /* identifier_field  */
  YYSYMBOL_type_name = 2259,               /* type_name  */
  YYSYMBOL_identifier = 2260,              /* identifier  */
  YYSYMBOL_identifier_1 = 2261,            /* identifier_1  */
  YYSYMBOL_identifier_list = 2262,         /* identifier_list  */
  YYSYMBOL_validate_for_identifier_list = 2263, /* validate_for_identifier_list  */
  YYSYMBOL_for_identifier = 2264,          /* for_identifier  */
  YYSYMBOL_target_identifier = 2265,       /* target_identifier  */
  YYSYMBOL_target_identifier_1 = 2266,     /* target_identifier_1  */
  YYSYMBOL_target_identifier_single = 2267, /* target_identifier_single  */
  YYSYMBOL_display_identifier_or_alphabet_name = 2268, /* display_identifier_or_alphabet_name  */
  YYSYMBOL_qualified_word = 2269,          /* qualified_word  */
  YYSYMBOL_unqualified_word = 2270,        /* unqualified_word  */
  YYSYMBOL_2271_176 = 2271,                /* $@176  */
  YYSYMBOL_unqualified_word_check = 2272,  /* unqualified_word_check  */
  YYSYMBOL_subref = 2273,                  /* subref  */
  YYSYMBOL_refmod = 2274,                  /* refmod  */
  YYSYMBOL_integer = 2275,                 /* integer  */
  YYSYMBOL_symbolic_integer = 2276,        /* symbolic_integer  */
  YYSYMBOL_unsigned_pos_integer = 2277,    /* unsigned_pos_integer  */
  YYSYMBOL_integer_or_zero = 2278,         /* integer_or_zero  */
  YYSYMBOL_class_value = 2279,             /* class_value  */
  YYSYMBOL_figurative_constant = 2280,     /* figurative_constant  */
  YYSYMBOL_literal = 2281,                 /* literal  */
  YYSYMBOL_basic_literal = 2282,           /* basic_literal  */
  YYSYMBOL_basic_value = 2283,             /* basic_value  */
  YYSYMBOL_zero_spaces_high_low_values = 2284, /* zero_spaces_high_low_values  */
  YYSYMBOL_function = 2285,                /* function  */
  YYSYMBOL_func_no_parm = 2286,            /* func_no_parm  */
  YYSYMBOL_func_one_parm = 2287,           /* func_one_parm  */
  YYSYMBOL_func_multi_parm = 2288,         /* func_multi_parm  */
  YYSYMBOL_func_refmod = 2289,             /* func_refmod  */
  YYSYMBOL_func_args = 2290,               /* func_args  */
  YYSYMBOL_trim_args = 2291,               /* trim_args  */
  YYSYMBOL_length_arg = 2292,              /* length_arg  */
  YYSYMBOL_2293_177 = 2293,                /* $@177  */
  YYSYMBOL_numvalc_args = 2294,            /* numvalc_args  */
  YYSYMBOL_locale_dt_args = 2295,          /* locale_dt_args  */
  YYSYMBOL_formatted_datetime_args = 2296, /* formatted_datetime_args  */
  YYSYMBOL_formatted_time_args = 2297,     /* formatted_time_args  */
  YYSYMBOL_not_const_word = 2298,          /* not_const_word  */
  YYSYMBOL_flag_all = 2299,                /* flag_all  */
  YYSYMBOL_flag_duplicates = 2300,         /* flag_duplicates  */
  YYSYMBOL__flag_initialized = 2301,       /* _flag_initialized  */
  YYSYMBOL__flag_initialized_to = 2302,    /* _flag_initialized_to  */
  YYSYMBOL__to_init_val = 2303,            /* _to_init_val  */
  YYSYMBOL__flag_next = 2304,              /* _flag_next  */
  YYSYMBOL__flag_not = 2305,               /* _flag_not  */
  YYSYMBOL_flag_optional = 2306,           /* flag_optional  */
  YYSYMBOL_flag_rounded = 2307,            /* flag_rounded  */
  YYSYMBOL_round_mode = 2308,              /* round_mode  */
  YYSYMBOL_round_choice = 2309,            /* round_choice  */
  YYSYMBOL_flag_separate = 2310,           /* flag_separate  */
  YYSYMBOL__from_idx_to_idx = 2311,        /* _from_idx_to_idx  */
  YYSYMBOL__dest_index = 2312,             /* _dest_index  */
  YYSYMBOL_error_stmt_recover = 2313,      /* error_stmt_recover  */
  YYSYMBOL_verb = 2314,                    /* verb  */
  YYSYMBOL_scope_terminator = 2315,        /* scope_terminator  */
  YYSYMBOL__dot = 2316,                    /* _dot  */
  YYSYMBOL__dot_or_else_end_of_file_control = 2317, /* _dot_or_else_end_of_file_control  */
  YYSYMBOL_level_number_in_area_a = 2318,  /* level_number_in_area_a  */
  YYSYMBOL__dot_or_else_end_of_file_description = 2319, /* _dot_or_else_end_of_file_description  */
  YYSYMBOL__dot_or_else_end_of_communication_description = 2320, /* _dot_or_else_end_of_communication_description  */
  YYSYMBOL__dot_or_else_end_of_report_description = 2321, /* _dot_or_else_end_of_report_description  */
  YYSYMBOL__dot_or_else_end_of_report_group_description = 2322, /* _dot_or_else_end_of_report_group_description  */
  YYSYMBOL__dot_or_else_end_of_record_description = 2323, /* _dot_or_else_end_of_record_description  */
  YYSYMBOL__file_control_end_delimiter = 2324, /* _file_control_end_delimiter  */
  YYSYMBOL__file_description_end_delimiter = 2325, /* _file_description_end_delimiter  */
  YYSYMBOL__record_description_end_delimiter = 2326, /* _record_description_end_delimiter  */
  YYSYMBOL__dot_or_else_area_a = 2327,     /* _dot_or_else_area_a  */
  YYSYMBOL__advancing = 2328,              /* _advancing  */
  YYSYMBOL__after = 2329,                  /* _after  */
  YYSYMBOL__are = 2330,                    /* _are  */
  YYSYMBOL__area = 2331,                   /* _area  */
  YYSYMBOL__areas = 2332,                  /* _areas  */
  YYSYMBOL__as = 2333,                     /* _as  */
  YYSYMBOL__at = 2334,                     /* _at  */
  YYSYMBOL__before = 2335,                 /* _before  */
  YYSYMBOL__binary = 2336,                 /* _binary  */
  YYSYMBOL__box = 2337,                    /* _box  */
  YYSYMBOL__by = 2338,                     /* _by  */
  YYSYMBOL__character = 2339,              /* _character  */
  YYSYMBOL__characters = 2340,             /* _characters  */
  YYSYMBOL__collating = 2341,              /* _collating  */
  YYSYMBOL__contains = 2342,               /* _contains  */
  YYSYMBOL__controls = 2343,               /* _controls  */
  YYSYMBOL__control = 2344,                /* _control  */
  YYSYMBOL__data = 2345,                   /* _data  */
  YYSYMBOL__end_of = 2346,                 /* _end_of  */
  YYSYMBOL__every = 2347,                  /* _every  */
  YYSYMBOL__file = 2348,                   /* _file  */
  YYSYMBOL__for = 2349,                    /* _for  */
  YYSYMBOL__from = 2350,                   /* _from  */
  YYSYMBOL__in = 2351,                     /* _in  */
  YYSYMBOL__in_equal = 2352,               /* _in_equal  */
  YYSYMBOL__in_order = 2353,               /* _in_order  */
  YYSYMBOL__index = 2354,                  /* _index  */
  YYSYMBOL__indicate = 2355,               /* _indicate  */
  YYSYMBOL__initial = 2356,                /* _initial  */
  YYSYMBOL__into = 2357,                   /* _into  */
  YYSYMBOL__is = 2358,                     /* _is  */
  YYSYMBOL__is_equal = 2359,               /* _is_equal  */
  YYSYMBOL__is_are = 2360,                 /* _is_are  */
  YYSYMBOL__is_are_equal = 2361,           /* _is_are_equal  */
  YYSYMBOL__is_in = 2362,                  /* _is_in  */
  YYSYMBOL__key = 2363,                    /* _key  */
  YYSYMBOL__line = 2364,                   /* _line  */
  YYSYMBOL__line_or_lines = 2365,          /* _line_or_lines  */
  YYSYMBOL__limits = 2366,                 /* _limits  */
  YYSYMBOL__lines = 2367,                  /* _lines  */
  YYSYMBOL__lock = 2368,                   /* _lock  */
  YYSYMBOL__message = 2369,                /* _message  */
  YYSYMBOL__mode = 2370,                   /* _mode  */
  YYSYMBOL__new = 2371,                    /* _new  */
  YYSYMBOL__number = 2372,                 /* _number  */
  YYSYMBOL__number_or_numbers = 2373,      /* _number_or_numbers  */
  YYSYMBOL__of = 2374,                     /* _of  */
  YYSYMBOL__on = 2375,                     /* _on  */
  YYSYMBOL__on_for = 2376,                 /* _on_for  */
  YYSYMBOL__onoff_status = 2377,           /* _onoff_status  */
  YYSYMBOL__other = 2378,                  /* _other  */
  YYSYMBOL__others = 2379,                 /* _others  */
  YYSYMBOL__procedure = 2380,              /* _procedure  */
  YYSYMBOL__program = 2381,                /* _program  */
  YYSYMBOL__protected = 2382,              /* _protected  */
  YYSYMBOL__record = 2383,                 /* _record  */
  YYSYMBOL__records = 2384,                /* _records  */
  YYSYMBOL__right = 2385,                  /* _right  */
  YYSYMBOL__sign = 2386,                   /* _sign  */
  YYSYMBOL__signed = 2387,                 /* _signed  */
  YYSYMBOL__sign_is = 2388,                /* _sign_is  */
  YYSYMBOL__size = 2389,                   /* _size  */
  YYSYMBOL__standard = 2390,               /* _standard  */
  YYSYMBOL__status = 2391,                 /* _status  */
  YYSYMBOL__symbolic = 2392,               /* _symbolic  */
  YYSYMBOL__tape = 2393,                   /* _tape  */
  YYSYMBOL__terminal = 2394,               /* _terminal  */
  YYSYMBOL__then = 2395,                   /* _then  */
  YYSYMBOL__times = 2396,                  /* _times  */
  YYSYMBOL__to = 2397,                     /* _to  */
  YYSYMBOL__up = 2398,                     /* _up  */
  YYSYMBOL__when = 2399,                   /* _when  */
  YYSYMBOL__when_set_to = 2400,            /* _when_set_to  */
  YYSYMBOL__with = 2401,                   /* _with  */
  YYSYMBOL__with_for = 2402,               /* _with_for  */
  YYSYMBOL__exception = 2403,              /* _exception  */
  YYSYMBOL_at_end = 2404,                  /* at_end  */
  YYSYMBOL_on_escape = 2405,               /* on_escape  */
  YYSYMBOL_on_exception = 2406,            /* on_exception  */
  YYSYMBOL_column_or_col = 2407,           /* column_or_col  */
  YYSYMBOL_columns_or_cols = 2408,         /* columns_or_cols  */
  YYSYMBOL_column_or_cols = 2409,          /* column_or_cols  */
  YYSYMBOL_column_or_col_or_position_or_pos = 2410, /* column_or_col_or_position_or_pos  */
  YYSYMBOL_comp_equal = 2411,              /* comp_equal  */
  YYSYMBOL_exception_or_error = 2412,      /* exception_or_error  */
  YYSYMBOL_file_limit_or_limits = 2413,    /* file_limit_or_limits  */
  YYSYMBOL_in_of = 2414,                   /* in_of  */
  YYSYMBOL_label_option = 2415,            /* label_option  */
  YYSYMBOL_line_or_lines = 2416,           /* line_or_lines  */
  YYSYMBOL_lock_records = 2417,            /* lock_records  */
  YYSYMBOL_object_char_or_word_or_modules = 2418, /* object_char_or_word_or_modules  */
  YYSYMBOL_records = 2419,                 /* records  */
  YYSYMBOL_reel_or_unit = 2420,            /* reel_or_unit  */
  YYSYMBOL_size_or_length = 2421,          /* size_or_length  */
  YYSYMBOL_length_of = 2422,               /* length_of  */
  YYSYMBOL_track_or_tracks = 2423,         /* track_or_tracks  */
  YYSYMBOL_using_or_varying = 2424,        /* using_or_varying  */
  YYSYMBOL_detail_keyword = 2425,          /* detail_keyword  */
  YYSYMBOL_ch_keyword = 2426,              /* ch_keyword  */
  YYSYMBOL_cf_keyword = 2427,              /* cf_keyword  */
  YYSYMBOL_ph_keyword = 2428,              /* ph_keyword  */
  YYSYMBOL_pf_keyword = 2429,              /* pf_keyword  */
  YYSYMBOL_rh_keyword = 2430,              /* rh_keyword  */
  YYSYMBOL_rf_keyword = 2431,              /* rf_keyword  */
  YYSYMBOL_control_keyword = 2432          /* control_keyword  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   20700

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  970
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1463
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3485
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4923

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   1224


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  3449,  3449,  3449,  3486,  3487,  3491,  3491,  3501,  3502,
    3506,  3507,  3508,  3509,  3513,  3513,  3525,  3536,  3544,  3548,
    3552,  3553,  3558,  3557,  3571,  3570,  3585,  3620,  3583,  3640,
    3669,  3638,  3684,  3686,  3686,  3698,  3699,  3702,  3701,  3708,
    3710,  3710,  3718,  3720,  3725,  3727,  3727,  3735,  3737,  3737,
    3750,  3754,  3748,  3766,  3767,  3771,  3771,  3781,  3781,  3785,
    3793,  3825,  3832,  3844,  3855,  3862,  3863,  3870,  3871,  3875,
    3876,  3880,  3884,  3888,  3889,  3896,  3897,  3901,  3905,  3911,
    3913,  3921,  3928,  3930,  3934,  3941,  3945,  3949,  3965,  3968,
    3978,  3980,  3987,  3991,  3995,  4001,  4003,  4010,  4014,  4018,
    4022,  4031,  4036,  4037,  4040,  4042,  4051,  4055,  4056,  4059,
    4061,  4071,  4073,  4077,  4078,  4082,  4083,  4084,  4085,  4086,
    4091,  4092,  4097,  4096,  4107,  4108,  4111,  4112,  4125,  4124,
    4138,  4139,  4140,  4141,  4145,  4146,  4150,  4151,  4152,  4153,
    4157,  4165,  4174,  4173,  4181,  4185,  4191,  4195,  4200,  4207,
    4217,  4231,  4242,  4246,  4250,  4254,  4261,  4262,  4266,  4267,
    4272,  4271,  4284,  4286,  4287,  4294,  4295,  4299,  4303,  4309,
    4310,  4317,  4324,  4329,  4340,  4355,  4358,  4359,  4362,  4366,
    4367,  4368,  4369,  4370,  4371,  4372,  4373,  4374,  4375,  4376,
    4377,  4378,  4379,  4380,  4388,  4387,  4406,  4408,  4411,  4422,
    4445,  4453,  4456,  4457,  4461,  4468,  4483,  4504,  4503,  4528,
    4527,  4536,  4535,  4545,  4547,  4551,  4555,  4556,  4562,  4568,
    4574,  4583,  4584,  4591,  4598,  4608,  4614,  4622,  4632,  4636,
    4643,  4647,  4652,  4651,  4662,  4666,  4673,  4674,  4675,  4676,
    4677,  4678,  4682,  4683,  4688,  4691,  4695,  4703,  4706,  4717,
    4743,  4751,  4755,  4766,  4786,  4794,  4805,  4806,  4813,  4827,
    4828,  4832,  4851,  4882,  4883,  4887,  4891,  4912,  4934,  4933,
    4957,  4964,  4976,  5043,  5046,  5055,  5074,  5090,  5108,  5126,
    5143,  5161,  5160,  5188,  5194,  5195,  5196,  5205,  5206,  5214,
    5215,  5219,  5221,  5219,  5267,  5268,  5274,  5275,  5284,  5285,
    5286,  5287,  5288,  5289,  5290,  5291,  5292,  5293,  5294,  5295,
    5296,  5297,  5298,  5299,  5300,  5301,  5302,  5303,  5326,  5336,
    5346,  5357,  5368,  5399,  5402,  5406,  5410,  5414,  5419,  5423,
    5431,  5437,  5443,  5453,  5454,  5455,  5456,  5460,  5461,  5462,
    5463,  5464,  5465,  5466,  5470,  5478,  5482,  5490,  5494,  5501,
    5502,  5508,  5515,  5516,  5517,  5524,  5579,  5582,  5587,  5586,
    5598,  5611,  5614,  5618,  5628,  5639,  5638,  5646,  5650,  5656,
    5660,  5665,  5672,  5682,  5693,  5703,  5707,  5711,  5715,  5724,
    5735,  5737,  5738,  5744,  5744,  5751,  5755,  5759,  5766,  5767,
    5768,  5772,  5778,  5779,  5783,  5789,  5790,  5806,  5807,  5811,
    5817,  5823,  5829,  5842,  5853,  5852,  5861,  5872,  5886,  5899,
    5915,  5954,  5957,  5964,  5965,  5969,  5969,  5973,  5978,  5996,
    6007,  6014,  6015,  6021,  6034,  6035,  6036,  6042,  6050,  6051,
    6057,  6067,  6077,  6087,  6097,  6098,  6105,  6113,  6114,  6115,
    6122,  6123,  6127,  6128,  6129,  6130,  6136,  6164,  6165,  6166,
    6167,  6173,  6178,  6182,  6186,  6187,  6194,  6195,  6196,  6197,
    6198,  6199,  6200,  6201,  6208,  6207,  6223,  6224,  6228,  6231,
    6232,  6238,  6242,  6246,  6247,  6251,  6253,  6254,  6262,  6266,
    6267,  6271,  6272,  6276,  6277,  6281,  6282,  6283,  6293,  6290,
    6304,  6305,  6308,  6310,  6318,  6319,  6320,  6328,  6329,  6333,
    6353,  6352,  6376,  6383,  6388,  6395,  6396,  6400,  6410,  6425,
    6426,  6427,  6428,  6429,  6430,  6431,  6432,  6433,  6440,  6447,
    6447,  6447,  6453,  6462,  6478,  6490,  6491,  6495,  6496,  6500,
    6501,  6508,  6519,  6524,  6535,  6536,  6540,  6541,  6547,  6558,
    6576,  6577,  6581,  6582,  6583,  6587,  6594,  6601,  6610,  6619,
    6620,  6621,  6622,  6623,  6632,  6633,  6639,  6678,  6679,  6688,
    6703,  6704,  6708,  6722,  6740,  6741,  6743,  6742,  6760,  6761,
    6765,  6780,  6783,  6782,  6804,  6805,  6809,  6810,  6811,  6814,
    6816,  6817,  6821,  6822,  6826,  6827,  6828,  6829,  6830,  6831,
    6832,  6833,  6834,  6835,  6836,  6840,  6844,  6846,  6850,  6851,
    6855,  6856,  6857,  6858,  6859,  6860,  6861,  6864,  6866,  6867,
    6871,  6872,  6876,  6877,  6878,  6879,  6880,  6881,  6885,  6890,
    6891,  6894,  6892,  6909,  6913,  6913,  6926,  6927,  6931,  6932,
    6933,  6935,  6934,  6954,  6971,  6984,  6990,  6992,  6996,  7003,
    7007,  7018,  7021,  7033,  7034,  7036,  7040,  7044,  7050,  7054,
    7058,  7062,  7066,  7070,  7074,  7082,  7086,  7090,  7098,  7102,
    7106,  7110,  7121,  7122,  7126,  7127,  7131,  7132,  7136,  7137,
    7141,  7185,  7188,  7196,  7195,  7209,  7215,  7219,  7247,  7246,
    7261,  7270,  7277,  7288,  7292,  7299,  7300,  7304,  7305,  7306,
    7307,  7308,  7309,  7310,  7311,  7312,  7313,  7316,  7318,  7322,
    7326,  7330,  7331,  7332,  7333,  7334,  7335,  7336,  7337,  7338,
    7339,  7340,  7341,  7342,  7343,  7344,  7345,  7346,  7347,  7348,
    7349,  7350,  7351,  7352,  7353,  7354,  7355,  7356,  7357,  7358,
    7359,  7369,  7390,  7404,  7405,  7408,  7417,  7436,  7460,  7461,
    7471,  7499,  7502,  7510,  7511,  7515,  7540,  7539,  7551,  7559,
    7576,  7588,  7606,  7605,  7616,  7617,  7623,  7630,  7631,  7632,
    7638,  7656,  7655,  7672,  7674,  7688,  7729,  7734,  7737,  7744,
    7758,  7769,  7770,  7771,  7805,  7811,  7812,  7816,  7820,  7825,
    7832,  7836,  7841,  7850,  7854,  7859,  7863,  7867,  7871,  7875,
    7879,  7883,  7887,  7891,  7896,  7900,  7905,  7910,  7914,  7918,
    7922,  7927,  7931,  7936,  7940,  7945,  7950,  7955,  7959,  7963,
    7971,  7975,  7979,  7987,  7991,  7995,  7999,  8003,  8007,  8011,
    8015,  8019,  8027,  8035,  8039,  8043,  8047,  8051,  8055,  8060,
    8069,  8076,  8078,  8079,  8080,  8083,  8085,  8089,  8090,  8094,
    8095,  8099,  8102,  8104,  8105,  8106,  8107,  8108,  8109,  8112,
    8114,  8120,  8127,  8139,  8154,  8163,  8164,  8173,  8180,  8192,
    8210,  8211,  8215,  8216,  8220,  8221,  8224,  8225,  8230,  8231,
    8238,  8239,  8245,  8247,  8249,  8248,  8253,  8254,  8258,  8280,
    8281,  8285,  8310,  8311,  8314,  8316,  8320,  8327,  8328,  8333,
    8351,  8362,  8382,  8383,  8384,  8391,  8402,  8429,  8443,  8451,
    8472,  8483,  8497,  8498,  8502,  8534,  8535,  8539,  8543,  8544,
    8548,  8555,  8556,  8560,  8561,  8565,  8569,  8577,  8578,  8582,
    8583,  8587,  8592,  8602,  8601,  8609,  8621,  8622,  8626,  8627,
    8631,  8633,  8634,  8638,  8649,  8656,  8657,  8660,  8662,  8671,
    8679,  8680,  8684,  8685,  8686,  8687,  8693,  8700,  8701,  8707,
    8714,  8715,  8716,  8717,  8718,  8719,  8720,  8726,  8737,  8746,
    8756,  8765,  8780,  8803,  8822,  8823,  8825,  8824,  8848,  8849,
    8851,  8850,  8868,  8869,  8871,  8869,  8881,  8882,  8888,  8890,
    8888,  8916,  8917,  8918,  8925,  8931,  8936,  8937,  8943,  8950,
    8951,  8952,  8956,  8963,  8964,  8968,  8978,  9017,  9028,  9029,
    9043,  9056,  9057,  9060,  9061,  9066,  9067,  9068,  9069,  9070,
    9071,  9083,  9097,  9111,  9125,  9139,  9152,  9153,  9158,  9157,
    9170,  9181,  9182,  9186,  9187,  9188,  9189,  9190,  9191,  9192,
    9193,  9194,  9195,  9196,  9197,  9198,  9199,  9200,  9201,  9202,
    9206,  9213,  9217,  9221,  9222,  9223,  9230,  9234,  9242,  9245,
    9253,  9263,  9264,  9269,  9272,  9277,  9281,  9289,  9296,  9305,
    9310,  9317,  9318,  9319,  9323,  9330,  9331,  9332,  9339,  9343,
    9350,  9355,  9361,  9368,  9374,  9384,  9388,  9395,  9397,  9401,
    9405,  9409,  9413,  9420,  9421,  9426,  9463,  9466,  9474,  9477,
    9484,  9495,  9496,  9499,  9501,  9505,  9509,  9523,  9538,  9541,
    9543,  9547,  9551,  9555,  9562,  9584,  9588,  9589,  9593,  9614,
    9622,  9631,  9632,  9634,  9632,  9654,  9655,  9659,  9660,  9664,
    9667,  9666,  9717,  9728,  9716,  9772,  9792,  9794,  9798,  9803,
    9808,  9812,  9816,  9821,  9826,  9831,  9836,  9845,  9849,  9853,
    9857,  9861,  9867,  9871,  9876,  9882,  9886,  9891,  9896,  9901,
    9906,  9911,  9916,  9925,  9929,  9933,  9939,  9943,  9947,  9951,
    9955,  9959,  9963,  9967,  9978,  9983,  9988,  9992,  9993,  9994,
    9995,  9996,  9997,  9998,  9999, 10008, 10013, 10024, 10037, 10038,
   10042, 10043, 10050, 10051, 10052, 10053, 10054, 10055, 10056, 10057,
   10058, 10061, 10064, 10065, 10066, 10067, 10068, 10069, 10076, 10077,
   10082, 10083, 10086, 10088, 10092, 10093, 10097, 10098, 10099, 10103,
   10104, 10108, 10109, 10113, 10114, 10115, 10116, 10117, 10120, 10121,
   10122, 10123, 10124, 10126, 10127, 10129, 10130, 10134, 10135, 10136,
   10137, 10139, 10141, 10143, 10144, 10145, 10146, 10147, 10148, 10149,
   10150, 10151, 10157, 10158, 10159, 10160, 10161, 10162, 10163, 10164,
   10165, 10166, 10170, 10171, 10176, 10177, 10178, 10179, 10180, 10184,
   10192, 10193, 10194, 10195, 10196, 10197, 10198, 10199, 10200, 10201,
   10202, 10204, 10206, 10207, 10208, 10212, 10213, 10214, 10215, 10216,
   10217, 10218, 10219, 10220, 10221, 10226, 10227, 10228, 10229, 10230,
   10231, 10232, 10233, 10234, 10235, 10240, 10241, 10252, 10253, 10277,
   10278, 10295, 10298, 10299, 10300, 10303, 10307, 10308, 10309, 10310,
   10311, 10312, 10313, 10314, 10315, 10316, 10317, 10318, 10319, 10320,
   10321, 10322, 10328, 10329, 10330, 10350, 10351, 10352, 10353, 10354,
   10355, 10356, 10357, 10361, 10362, 10363, 10364, 10365, 10366, 10372,
   10373, 10374, 10375, 10376, 10377, 10378, 10379, 10384, 10386, 10387,
   10388, 10393, 10394, 10395, 10399, 10400, 10401, 10402, 10403, 10404,
   10415, 10416, 10417, 10418, 10423, 10426, 10427, 10428, 10429, 10430,
   10432, 10437, 10438, 10439, 10445, 10446, 10447, 10448, 10449, 10450,
   10451, 10452, 10453, 10454, 10458, 10459, 10460, 10461, 10462, 10463,
   10464, 10465, 10466, 10467, 10468, 10469, 10470, 10471, 10473, 10474,
   10475, 10476, 10477, 10478, 10479, 10480, 10481, 10482, 10483, 10484,
   10485, 10486, 10487, 10488, 10489, 10492, 10493, 10494, 10502, 10503,
   10504, 10508, 10509, 10510, 10514, 10515, 10518, 10519, 10520, 10523,
   10532, 10533, 10534, 10535, 10536, 10537, 10538, 10539, 10540, 10541,
   10542, 10543, 10544, 10546, 10547, 10548, 10549, 10550, 10551, 10552,
   10553, 10554, 10555, 10562, 10566, 10570, 10571, 10572, 10573, 10574,
   10575, 10576, 10577, 10583, 10584, 10585, 10590, 10591, 10596, 10601,
   10602, 10606, 10607, 10612, 10613, 10617, 10618, 10619, 10624, 10625,
   10629, 10630, 10634, 10635, 10639, 10643, 10643, 10647, 10651, 10651,
   10655, 10659, 10660, 10664, 10665, 10669, 10677, 10679, 10683, 10690,
   10700, 10703, 10707, 10714, 10726, 10732, 10734, 10741, 10750, 10754,
   10756, 10766, 10789, 10754, 10815, 10815, 10851, 10855, 10854, 10868,
   10867, 10887, 10888, 10893, 10915, 10917, 10921, 10932, 10934, 10938,
   10946, 10955, 10963, 10969, 10973, 11017, 11019, 11027, 11030, 11043,
   11048, 11058, 11093, 11095, 11102, 11104, 11094, 11135, 11136, 11140,
   11141, 11143, 11142, 11161, 11162, 11173, 11177, 11186, 11185, 11231,
   11232, 11236, 11281, 11304, 11307, 11336, 11342, 11335, 11358, 11358,
   11397, 11405, 11406, 11407, 11408, 11409, 11410, 11411, 11412, 11413,
   11414, 11415, 11416, 11417, 11418, 11419, 11420, 11421, 11422, 11423,
   11424, 11425, 11426, 11427, 11428, 11429, 11430, 11431, 11432, 11433,
   11434, 11436, 11437, 11438, 11439, 11440, 11441, 11442, 11443, 11444,
   11445, 11446, 11447, 11448, 11449, 11450, 11452, 11453, 11454, 11455,
   11456, 11457, 11458, 11459, 11460, 11461, 11462, 11463, 11464, 11465,
   11466, 11467, 11468, 11469, 11470, 11471, 11473, 11472, 11488, 11500,
   11499, 11510, 11509, 11544, 11543, 11554, 11558, 11562, 11568, 11574,
   11579, 11584, 11589, 11594, 11600, 11606, 11610, 11616, 11620, 11624,
   11629, 11633, 11637, 11641, 11645, 11649, 11653, 11657, 11671, 11678,
   11679, 11686, 11686, 11697, 11699, 11703, 11707, 11711, 11718, 11722,
   11726, 11733, 11734, 11738, 11740, 11744, 11745, 11749, 11750, 11754,
   11758, 11759, 11768, 11769, 11774, 11775, 11779, 11780, 11784, 11800,
   11816, 11829, 11837, 11845, 11852, 11858, 11864, 11869, 11875, 11880,
   11885, 11898, 11903, 11908, 11914, 11920, 11926, 11933, 11937, 11941,
   11945, 11949, 11960, 11965, 11971, 11976, 11981, 11986, 11992, 11998,
   12003, 12009, 12015, 12021, 12028, 12033, 12038, 12045, 12052, 12058,
   12061, 12061, 12065, 12076, 12077, 12078, 12082, 12083, 12084, 12088,
   12089, 12093, 12097, 12116, 12115, 12124, 12128, 12135, 12139, 12147,
   12148, 12152, 12156, 12167, 12166, 12176, 12180, 12191, 12193, 12206,
   12207, 12215, 12214, 12223, 12224, 12228, 12234, 12234, 12241, 12240,
   12257, 12256, 12340, 12344, 12343, 12359, 12363, 12367, 12375, 12378,
   12386, 12394, 12398, 12402, 12406, 12410, 12414, 12433, 12439, 12459,
   12463, 12473, 12477, 12482, 12486, 12485, 12502, 12503, 12508, 12516,
   12520, 12542, 12544, 12548, 12561, 12578, 12581, 12585, 12589, 12594,
   12617, 12618, 12622, 12623, 12627, 12631, 12635, 12646, 12650, 12657,
   12661, 12669, 12673, 12680, 12687, 12691, 12702, 12701, 12713, 12714,
   12723, 12727, 12734, 12735, 12745, 12744, 12752, 12753, 12757, 12764,
   12772, 12773, 12774, 12775, 12776, 12781, 12780, 12792, 12793, 12801,
   12800, 12809, 12816, 12820, 12830, 12842, 12841, 12863, 12866, 12866,
   12881, 12880, 12889, 12896, 12907, 12906, 12915, 12919, 12926, 12933,
   12941, 12945, 12956, 12955, 12964, 12967, 12969, 12975, 12977, 12978,
   12979, 12980, 12988, 12987, 12999, 13003, 13007, 13011, 13015, 13016,
   13020, 13021, 13022, 13023, 13024, 13025, 13029, 13037, 13048, 13049,
   13054, 13053, 13100, 13104, 13110, 13112, 13116, 13117, 13121, 13122,
   13126, 13130, 13135, 13139, 13140, 13145, 13148, 13152, 13156, 13160,
   13164, 13171, 13172, 13177, 13176, 13193, 13200, 13200, 13212, 13216,
   13223, 13224, 13225, 13235, 13234, 13252, 13254, 13258, 13259, 13263,
   13267, 13268, 13269, 13270, 13275, 13280, 13274, 13294, 13295, 13300,
   13307, 13299, 13326, 13325, 13348, 13349, 13350, 13354, 13355, 13360,
   13363, 13370, 13383, 13395, 13402, 13403, 13409, 13410, 13414, 13415,
   13416, 13417, 13418, 13419, 13423, 13426, 13430, 13431, 13432, 13436,
   13437, 13438, 13439, 13443, 13444, 13449, 13450, 13454, 13464, 13480,
   13485, 13491, 13497, 13502, 13507, 13513, 13519, 13525, 13531, 13538,
   13542, 13546, 13550, 13554, 13559, 13564, 13569, 13574, 13580, 13585,
   13590, 13597, 13607, 13611, 13622, 13621, 13630, 13634, 13638, 13642,
   13646, 13653, 13657, 13668, 13667, 13677, 13680, 13679, 13687, 13686,
   13696, 13720, 13733, 13732, 13759, 13769, 13770, 13775, 13786, 13797,
   13811, 13819, 13827, 13828, 13833, 13839, 13849, 13861, 13867, 13877,
   13890, 13889, 13901, 13899, 13913, 13914, 13919, 13994, 13995, 13996,
   13997, 14001, 14002, 14006, 14010, 14020, 14019, 14033, 14032, 14073,
   14073, 14074, 14074, 14075, 14075, 14078, 14087, 14098, 14099, 14107,
   14106, 14118, 14122, 14140, 14154, 14177, 14200, 14221, 14244, 14248,
   14256, 14257, 14267, 14266, 14275, 14286, 14285, 14294, 14309, 14308,
   14321, 14326, 14337, 14341, 14352, 14352, 14367, 14366, 14375, 14379,
   14385, 14392, 14395, 14402, 14408, 14414, 14419, 14431, 14430, 14438,
   14446, 14447, 14451, 14452, 14453, 14458, 14461, 14468, 14472, 14480,
   14487, 14488, 14489, 14490, 14491, 14492, 14493, 14505, 14508, 14518,
   14517, 14525, 14534, 14547, 14546, 14558, 14559, 14566, 14565, 14574,
   14583, 14584, 14588, 14589, 14590, 14594, 14595, 14596, 14597, 14604,
   14603, 14613, 14612, 14662, 14693, 14694, 14695, 14699, 14700, 14701,
   14702, 14706, 14707, 14711, 14718, 14733, 14732, 14753, 14763, 14771,
   14775, 14782, 14787, 14792, 14797, 14802, 14807, 14815, 14816, 14820,
   14825, 14831, 14833, 14834, 14835, 14836, 14840, 14868, 14871, 14875,
   14879, 14883, 14890, 14897, 14905, 14908, 14907, 14921, 14926, 14919,
   14937, 14938, 14942, 14943, 14947, 14955, 14959, 14969, 14968, 14980,
   14991, 14992, 14999, 14998, 15011, 15010, 15023, 15024, 15028, 15032,
   15043, 15042, 15050, 15054, 15065, 15064, 15073, 15077, 15084, 15088,
   15099, 15098, 15107, 15108, 15112, 15140, 15141, 15145, 15146, 15147,
   15148, 15152, 15153, 15157, 15158, 15159, 15163, 15164, 15172, 15173,
   15177, 15178, 15184, 15193, 15194, 15195, 15200, 15201, 15202, 15206,
   15213, 15229, 15230, 15231, 15237, 15236, 15248, 15260, 15257, 15274,
   15271, 15287, 15295, 15302, 15306, 15319, 15325, 15337, 15340, 15345,
   15349, 15363, 15370, 15371, 15375, 15376, 15379, 15380, 15385, 15428,
   15432, 15442, 15441, 15454, 15453, 15461, 15466, 15475, 15490, 15489,
   15499, 15528, 15529, 15533, 15537, 15541, 15545, 15552, 15553, 15557,
   15561, 15564, 15566, 15570, 15579, 15580, 15581, 15585, 15586, 15590,
   15594, 15598, 15606, 15607, 15611, 15612, 15616, 15620, 15630, 15641,
   15640, 15649, 15654, 15655, 15659, 15660, 15661, 15665, 15666, 15670,
   15674, 15675, 15679, 15683, 15687, 15697, 15696, 15704, 15714, 15725,
   15724, 15733, 15740, 15744, 15755, 15754, 15766, 15775, 15778, 15782,
   15786, 15793, 15797, 15807, 15817, 15820, 15819, 15826, 15825, 15834,
   15842, 15851, 15852, 15857, 15860, 15868, 15874, 15878, 15885, 15893,
   15897, 15912, 15922, 15921, 15929, 15930, 15936, 15954, 15965, 15967,
   15971, 15990, 15994, 16001, 16002, 16003, 16004, 16007, 16009, 16016,
   16015, 16029, 16030, 16031, 16032, 16033, 16034, 16035, 16036, 16040,
   16041, 16045, 16046, 16052, 16061, 16068, 16069, 16073, 16077, 16081,
   16087, 16093, 16097, 16101, 16105, 16114, 16118, 16122, 16126, 16130,
   16139, 16148, 16149, 16153, 16162, 16163, 16167, 16171, 16180, 16189,
   16201, 16200, 16210, 16208, 16261, 16262, 16279, 16280, 16283, 16284,
   16293, 16296, 16301, 16306, 16316, 16333, 16338, 16348, 16366, 16365,
   16375, 16388, 16391, 16399, 16402, 16407, 16412, 16420, 16421, 16422,
   16423, 16424, 16425, 16434, 16435, 16439, 16443, 16452, 16455, 16454,
   16465, 16472, 16480, 16494, 16501, 16505, 16509, 16517, 16528, 16529,
   16533, 16537, 16544, 16545, 16546, 16547, 16554, 16553, 16562, 16569,
   16569, 16579, 16580, 16584, 16598, 16599, 16604, 16605, 16609, 16610,
   16614, 16618, 16629, 16628, 16637, 16641, 16645, 16649, 16657, 16661,
   16671, 16671, 16683, 16684, 16691, 16690, 16698, 16707, 16720, 16719,
   16727, 16739, 16738, 16746, 16763, 16762, 16772, 16780, 16781, 16786,
   16787, 16792, 16799, 16800, 16805, 16812, 16813, 16817, 16818, 16822,
   16826, 16836, 16835, 16850, 16855, 16867, 16866, 16875, 16876, 16877,
   16878, 16879, 16883, 16911, 16914, 16926, 16936, 16941, 16946, 16951,
   16959, 16999, 17000, 17004, 17064, 17074, 17097, 17098, 17099, 17100,
   17104, 17113, 17119, 17129, 17156, 17160, 17161, 17165, 17171, 17187,
   17188, 17195, 17194, 17206, 17216, 17217, 17222, 17225, 17229, 17233,
   17240, 17241, 17245, 17246, 17247, 17251, 17255, 17263, 17266, 17265,
   17279, 17290, 17277, 17301, 17303, 17307, 17308, 17312, 17316, 17328,
   17337, 17347, 17350, 17360, 17363, 17371, 17374, 17383, 17387, 17394,
   17402, 17405, 17412, 17416, 17423, 17427, 17435, 17438, 17447, 17451,
   17458, 17466, 17469, 17473, 17474, 17475, 17478, 17480, 17488, 17489,
   17493, 17498, 17503, 17510, 17515, 17520, 17528, 17532, 17539, 17543,
   17554, 17553, 17582, 17577, 17597, 17600, 17608, 17609, 17613, 17614,
   17619, 17620, 17636, 17637, 17638, 17648, 17652, 17659, 17667, 17668,
   17672, 17673, 17677, 17685, 17686, 17691, 17692, 17693, 17703, 17707,
   17714, 17722, 17723, 17727, 17737, 17738, 17739, 17749, 17753, 17760,
   17768, 17769, 17773, 17783, 17784, 17785, 17795, 17799, 17806, 17814,
   17815, 17819, 17830, 17831, 17843, 17845, 17854, 17858, 17865, 17873,
   17874, 17878, 17888, 17889, 17899, 17903, 17910, 17918, 17919, 17923,
   17933, 17934, 17938, 17939, 17949, 17953, 17960, 17968, 17969, 17973,
   17984, 17987, 17996, 17999, 18007, 18011, 18020, 18024, 18031, 18032,
   18044, 18049, 18057, 18064, 18064, 18075, 18076, 18080, 18081, 18083,
   18085, 18087, 18088, 18090, 18091, 18092, 18093, 18094, 18096, 18097,
   18098, 18099, 18100, 18101, 18102, 18103, 18104, 18105, 18106, 18110,
   18115, 18123, 18130, 18130, 18141, 18142, 18146, 18147, 18148, 18149,
   18151, 18152, 18154, 18155, 18156, 18157, 18158, 18160, 18161, 18162,
   18163, 18164, 18165, 18166, 18167, 18168, 18169, 18172, 18174, 18178,
   18181, 18183, 18184, 18185, 18186, 18187, 18188, 18190, 18191, 18192,
   18193, 18194, 18198, 18199, 18203, 18204, 18208, 18209, 18213, 18214,
   18218, 18222, 18228, 18232, 18238, 18240, 18241, 18245, 18246, 18247,
   18251, 18252, 18253, 18254, 18255, 18256, 18257, 18258, 18259, 18260,
   18264, 18268, 18272, 18273, 18274, 18275, 18278, 18279, 18289, 18301,
   18310, 18326, 18335, 18351, 18366, 18367, 18372, 18381, 18387, 18397,
   18411, 18436, 18440, 18461, 18465, 18486, 18498, 18512, 18526, 18527,
   18532, 18538, 18539, 18544, 18553, 18555, 18560, 18574, 18575, 18576,
   18583, 18594, 18595, 18599, 18607, 18608, 18612, 18613, 18617, 18629,
   18633, 18640, 18649, 18650, 18656, 18665, 18676, 18693, 18697, 18704,
   18705, 18706, 18713, 18714, 18718, 18722, 18729, 18730, 18734, 18735,
   18739, 18740, 18741, 18742, 18746, 18750, 18754, 18758, 18762, 18783,
   18793, 18797, 18804, 18805, 18806, 18810, 18811, 18812, 18813, 18814,
   18818, 18822, 18829, 18830, 18831, 18832, 18836, 18840, 18847, 18859,
   18871, 18885, 18886, 18890, 18891, 18895, 18902, 18903, 18910, 18911,
   18918, 18919, 18920, 18924, 18925, 18929, 18933, 18937, 18941, 18942,
   18946, 18950, 18951, 18955, 18959, 18960, 18969, 18973, 18978, 18979,
   18985, 18989, 18993, 18997, 18998, 19004, 19008, 19012, 19013, 19017,
   19024, 19034, 19053, 19074, 19093, 19111, 19118, 19125, 19132, 19142,
   19146, 19153, 19157, 19164, 19186, 19199, 19206, 19210, 19214, 19218,
   19224, 19225, 19241, 19267, 19271, 19279, 19279, 19292, 19297, 19305,
   19313, 19317, 19327, 19342, 19364, 19384, 19388, 19395, 19409, 19417,
   19418, 19419, 19420, 19421, 19422, 19426, 19430, 19446, 19450, 19456,
   19456, 19459, 19460, 19461, 19462, 19468, 19472, 19476, 19480, 19484,
   19488, 19493, 19498, 19502, 19506, 19510, 19514, 19518, 19522, 19529,
   19530, 19534, 19535, 19536, 19537, 19541, 19542, 19543, 19544, 19545,
   19549, 19553, 19557, 19564, 19568, 19572, 19579, 19586, 19593, 19603,
   19603, 19619, 19626, 19636, 19643, 19653, 19657, 19670, 19674, 19689,
   19697, 19698, 19702, 19703, 19704, 19708, 19709, 19714, 19717, 19725,
   19728, 19736, 19738, 19739, 19743, 19744, 19748, 19749, 19750, 19755,
   19758, 19771, 19775, 19783, 19787, 19791, 19795, 19799, 19803, 19807,
   19811, 19818, 19819, 19823, 19824, 19834, 19835, 19844, 19848, 19852,
   19856, 19863, 19864, 19865, 19866, 19867, 19868, 19869, 19870, 19871,
   19872, 19873, 19874, 19875, 19876, 19877, 19878, 19879, 19880, 19881,
   19882, 19883, 19884, 19885, 19886, 19887, 19888, 19889, 19890, 19891,
   19892, 19893, 19894, 19895, 19896, 19897, 19898, 19899, 19900, 19901,
   19902, 19903, 19904, 19905, 19906, 19907, 19908, 19909, 19910, 19911,
   19912, 19913, 19914, 19918, 19919, 19920, 19921, 19922, 19923, 19924,
   19925, 19926, 19927, 19928, 19929, 19930, 19931, 19932, 19933, 19934,
   19935, 19936, 19937, 19938, 19939, 19940, 19944, 19945, 19952, 19953,
   19962, 19971, 19972, 19973, 19982, 19985, 19988, 19991, 19992, 19993,
   20002, 20002, 20002, 20002, 20005, 20005, 20005, 20008, 20008, 20008,
   20008, 20009, 20009, 20009, 20012, 20013, 20018, 20030, 20030, 20031,
   20031, 20032, 20032, 20033, 20033, 20034, 20034, 20034, 20035, 20035,
   20036, 20036, 20037, 20037, 20038, 20038, 20039, 20039, 20040, 20040,
   20041, 20041, 20042, 20042, 20043, 20043, 20044, 20044, 20045, 20045,
   20046, 20046, 20047, 20047, 20048, 20048, 20049, 20049, 20050, 20050,
   20051, 20051, 20052, 20052, 20053, 20053, 20054, 20054, 20054, 20055,
   20055, 20055, 20056, 20056, 20057, 20057, 20058, 20058, 20059, 20059,
   20060, 20060, 20061, 20061, 20061, 20062, 20062, 20062, 20063, 20063,
   20063, 20063, 20064, 20064, 20064, 20065, 20065, 20066, 20066, 20067,
   20067, 20067, 20068, 20068, 20068, 20069, 20069, 20070, 20070, 20071,
   20071, 20072, 20072, 20073, 20073, 20074, 20074, 20075, 20075, 20076,
   20076, 20077, 20077, 20078, 20078, 20078, 20079, 20079, 20079, 20079,
   20080, 20080, 20081, 20081, 20082, 20082, 20083, 20083, 20084, 20084,
   20085, 20085, 20086, 20086, 20086, 20087, 20087, 20088, 20088, 20089,
   20089, 20090, 20090, 20090, 20091, 20091, 20092, 20092, 20093, 20093,
   20094, 20094, 20095, 20095, 20096, 20096, 20097, 20097, 20098, 20098,
   20099, 20099, 20100, 20100, 20101, 20101, 20102, 20102, 20103, 20103,
   20104, 20104, 20104, 20106, 20106, 20110, 20110, 20111, 20111, 20112,
   20112, 20113, 20113, 20114, 20114, 20115, 20115, 20116, 20116, 20116,
   20116, 20117, 20117, 20118, 20118, 20119, 20119, 20120, 20120, 20121,
   20121, 20122, 20122, 20123, 20123, 20124, 20124, 20124, 20125, 20125,
   20126, 20126, 20127, 20127, 20128, 20128, 20129, 20129, 20130, 20130,
   20133, 20133, 20134, 20134, 20135, 20135, 20136, 20136, 20137, 20137,
   20138, 20138, 20139, 20139, 20140, 20140
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"3D\"", "ABSENT",
  "ACCEPT", "ACCESS", "\"ACTIVE-X\"", "\"ACTIVE-CLASS\"", "ACTION",
  "ACTUAL", "ADD", "ADDRESS", "\"ADJUSTABLE-COLUMNS\"", "ADVANCING",
  "AFTER", "ALIGNED", "ALIGNMENT", "ALL", "ALLOCATE", "ALLOWING",
  "ALPHABET", "ALPHABETIC", "\"ALPHABETIC-LOWER\"", "\"ALPHABETIC-UPPER\"",
  "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"", "ALSO", "ALTER", "ALTERNATE",
  "AND", "ANY", "APPLY", "ARE", "AREA", "AREAS", "\"ARGUMENT-NUMBER\"",
  "\"ARGUMENT-VALUE\"", "ARITHMETIC", "AS", "ASCENDING", "ASCII", "ASSIGN",
  "AT", "\"AT END\"", "ATTRIBUTE", "ATTRIBUTES", "AUTHOR", "AUTO",
  "\"AUTO-DECIMAL\"", "\"AUTO-SPIN\"", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"B-AND\"", "\"B-NOT\"", "\"B-OR\"", "\"B-XOR\"", "\"B-SHIFT-L\"",
  "\"B-SHIFT-R\"", "\"B-SHIFT-LC\"", "\"B-SHIFT-RC\"",
  "\"BACKGROUND-COLOR\"", "\"BACKGROUND-HIGH\"", "\"BACKGROUND-LOW\"",
  "\"BACKGROUND-STANDARD\"", "BACKWARD", "BAR", "BASED", "BEFORE", "BELL",
  "BINARY", "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SEQUENTIAL\"", "\"BINARY-SHORT\"", "BIT",
  "BITMAP", "\"BITMAP-END\"", "\"BITMAP-HANDLE\"", "\"BITMAP-NUMBER\"",
  "\"BITMAP-START\"", "\"BITMAP-TIMER\"", "\"BITMAP-TRAILING\"",
  "\"BITMAP-TRANSPARENT-COLOR\"", "\"BITMAP-WIDTH\"", "BLANK", "BLINK",
  "BLOCK", "BOOLEAN", "BOTTOM", "BOX", "BOXED", "\"BULK-ADDITION\"",
  "BUSY", "BUTTONS", "BY", "\"BYTE-LENGTH\"", "C", "\"CALENDAR-FONT\"",
  "CALL", "CANCEL", "\"CANCEL-BUTTON\"", "CAPACITY", "\"CARD-PUNCH\"",
  "\"CARD-READER\"", "CASSETTE", "CCOL", "CD", "CELL", "\"CELL-COLOR\"",
  "\"CELL-DATA\"", "\"CELL-FONT\"", "\"CELL-PROTECTION\"", "CENTER",
  "CENTERED", "\"CENTERED-HEADINGS\"", "\"CENTURY-DATE\"", "CF", "CH",
  "CHAINING", "CHANGED", "CHARACTER", "CHARACTERS", "\"CHECK-BOX\"",
  "CLASS", "CLASSIFICATION", "\"class-name\"", "\"CLEAR-SELECTION\"",
  "CLINE", "CLINES", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING",
  "COL", "COLOR", "COLORS", "COLS", "COLUMN", "\"COLUMN-COLOR\"",
  "\"COLUMN-DIVIDERS\"", "\"COLUMN-FONT\"", "\"COLUMN-HEADINGS\"",
  "\"COLUMN-PROTECTION\"", "COLUMNS", "\"COMBO-BOX\"", "COMMA",
  "\"COMMAND-LINE\"", "\"comma delimiter\"", "COMMIT", "COMMON",
  "COMMUNICATION", "COMP", "COMPUTE", "\"COMP-0\"", "\"COMP-1\"",
  "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"", "\"COMP-5\"", "\"COMP-6\"",
  "\"COMP-N\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"", "CONDITION",
  "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "\"FUNCTION CONTENT-LENGTH\"", "\"FUNCTION CONTENT-OF\"", "CONTINUE",
  "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "\"COPY-SELECTION\"", "\"CORE-INDEX\"", "CORRESPONDING", "COUNT", "CRT",
  "\"CRT-UNDER\"", "CSIZE", "CURRENCY", "\"FUNCTION CURRENT-DATE\"",
  "CURSOR", "\"CURSOR-COL\"", "\"CURSOR-COLOR\"", "\"CURSOR-FRAME-WIDTH\"",
  "\"CURSOR-ROW\"", "\"CURSOR-X\"", "\"CURSOR-Y\"",
  "\"CUSTOM-PRINT-TEMPLATE\"", "CYCLE", "\"CYL-INDEX\"",
  "\"CYL-OVERFLOW\"", "DASHED", "DATA", "\"DATA-COLUMNS\"",
  "\"DATA-TYPES\"", "DATE", "\"DATE-COMPILED\"", "\"DATE-ENTRY\"",
  "\"DATE-MODIFIED\"", "\"DATE-WRITTEN\"", "DAY", "\"DAY-OF-WEEK\"", "DE",
  "DEBUGGING", "\"DECIMAL-POINT\"", "DECLARATIVES", "DEFAULT",
  "\"DEFAULT-BUTTON\"", "\"DEFAULT-FONT\"", "DELETE", "DELIMITED",
  "DELIMITER", "DEPENDING", "DESCENDING", "DESTINATION", "DESTROY",
  "DETAIL", "DISABLE", "DISC", "DISK", "DISP", "DISPLAY",
  "\"DISPLAY-COLUMNS\"", "\"DISPLAY-FORMAT\"", "\"FUNCTION DISPLAY-OF\"",
  "DIVIDE", "DIVIDERS", "\"DIVIDER-COLOR\"", "DIVISION", "DOTDASH",
  "DOTTED", "\"DRAG-COLOR\"", "\"DROP-DOWN\"", "\"DROP-LIST\"", "DOWN",
  "DUPLICATES", "DYNAMIC", "EBCDIC", "EC", "ECHO", "EGI",
  "\"level-number 88\"", "ENABLE", "ELEMENT", "ELSE", "EMI", "ENCRYPTION",
  "ENCODING", "END", "\"END-ACCEPT\"", "\"END-ADD\"", "\"END-CALL\"",
  "\"END-COMPUTE\"", "\"END-COLOR\"", "\"END-DELETE\"", "\"END-DISPLAY\"",
  "\"END-DIVIDE\"", "\"END-EVALUATE\"", "\"END FUNCTION\"", "\"END-IF\"",
  "\"END-JSON\"", "\"END-MODIFY\"", "\"END-MULTIPLY\"", "\"END-PERFORM\"",
  "\"END PROGRAM\"", "\"END-READ\"", "\"END-RECEIVE\"", "\"END-RETURN\"",
  "\"END-REWRITE\"", "\"END-SEARCH\"", "\"END-SEND\"", "\"END-START\"",
  "\"END-STRING\"", "\"END-SUBTRACT\"", "\"END-UNSTRING\"",
  "\"END-WRITE\"", "\"END-XML\"", "ENGRAVED", "\"ENSURE-VISIBLE\"",
  "ENTRY", "\"ENTRY-CONVENTION\"", "\"ENTRY-FIELD\"", "\"ENTRY-REASON\"",
  "ENVIRONMENT", "\"ENVIRONMENT-NAME\"", "\"ENVIRONMENT-VALUE\"", "EOL",
  "EOP", "EOS", "EQUAL", "ERASE", "ERROR", "ESCAPE", "\"ESCAPE-BUTTON\"",
  "ESI", "EVALUATE", "EVENT", "\"EVENT-LIST\"", "\"EVENT STATUS\"",
  "EVERY", "EXAMINE", "EXCEPTION", "\"EXCEPTION CONDITION\"",
  "\"EXCEPTION-VALUE\"", "EXPAND", "EXCLUSIVE", "EXHIBIT", "EXIT",
  "\"exponentiation operator\"", "EXTEND", "\"EXTENDED-SEARCH\"",
  "EXTERNAL", "\"EXTERNAL-FORM\"", "F", "FACTORY", "FD", "\"FH--FCD\"",
  "\"FH--KEYDEF\"", "\"FILE-CONTROL\"", "\"FILE-ID\"", "\"FILE-LIMIT\"",
  "\"FILE-LIMITS\"", "\"FILE-NAME\"", "\"FILE-POS\"", "\"FILL-COLOR\"",
  "\"FILL-COLOR2\"", "\"FILL-PERCENT\"", "FILLER", "FINAL",
  "\"FINISH-REASON\"", "FIRST", "FIXED", "\"FIXED-FONT\"",
  "\"FIXED-WIDTH\"", "FLAT", "\"FLAT-BUTTONS\"", "\"FLOAT-BINARY-128\"",
  "\"FLOAT-BINARY-32\"", "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"",
  "\"FLOAT-DECIMAL-34\"", "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"",
  "\"FLOAT-LONG\"", "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING",
  "FOR", "\"FOREGROUND-COLOR\"", "FOREVER", "FORMAT",
  "\"FUNCTION FORMATTED-DATE\"", "\"FUNCTION FORMATTED-DATETIME\"",
  "\"FUNCTION FORMATTED-TIME\"", "FRAME", "FRAMED", "FREE", "FROM",
  "\"FROM CRT\"", "FULL", "\"FULL-HEIGHT\"", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "GENERATE", "GIVING", "GLOBAL", "GO",
  "\"GO-BACK\"", "\"GO-FORWARD\"", "\"GO-HOME\"", "\"GO-SEARCH\"",
  "GOBACK", "GRAPHICAL", "GREATER", "\"GREATER OR EQUAL\"", "GRID",
  "GROUP", "\"GROUP-VALUE\"", "HANDLE", "\"HAS-CHILDREN\"", "HEADING",
  "\"HEADING-COLOR\"", "\"HEADING-DIVIDER-COLOR\"", "\"HEADING-FONT\"",
  "HEAVY", "\"HEIGHT-IN-CELLS\"", "\"HIDDEN-DATA\"", "HIGHLIGHT",
  "\"HIGH-COLOR\"", "\"HIGH-VALUE\"", "\"HOT-TRACK\"", "HSCROLL",
  "\"HSCROLL-POS\"", "ICON", "ID", "IDENTIFIED", "IDENTIFICATION", "IF",
  "IGNORE", "IGNORING", "IN", "INDEPENDENT", "INDEX", "INDEXED",
  "INDICATE", "INITIALIZE", "INITIALIZED", "INITIATE", "INPUT",
  "\"INPUT-OUTPUT\"", "INQUIRE", "\"INSERTION-INDEX\"", "\"INSERT-ROWS\"",
  "INSPECT", "INSTALLATION", "INTERMEDIATE", "INTO", "INTRINSIC",
  "INVALID", "\"INVALID KEY\"", "IS", "ITEM", "\"ITEM-TEXT\"",
  "\"ITEM-TO_ADD\"", "\"ITEM-TO_DELETE\"", "\"ITEM-TO_EMPTY\"",
  "\"ITEM-VALUE\"", "\"I-O\"", "\"I-O-CONTROL\"", "JSON", "JUSTIFIED",
  "KEPT", "KEY", "KEYBOARD", "LABEL", "\"LABEL-OFFSET\"", "\"LARGE-FONT\"",
  "\"LARGE-OFFSET\"", "LAST", "\"LAST-ROW\"", "\"LAYOUT-DATA\"",
  "\"LAYOUT-MANAGER\"", "LEADING", "\"LEADING-SHIFT\"", "LEAVE", "LEFT",
  "LEFTLINE", "\"LEFT-TEXT\"", "LENGTH", "\"LENGTH OF\"",
  "\"FUNCTION LENGTH/BYTE-LENGTH\"", "LESS", "\"LESS OR EQUAL\"",
  "\"level-number\"", "LIKE", "LIMIT", "LIMITS", "LINAGE",
  "\"LINAGE-COUNTER\"", "LINE", "\"LINE-COUNTER\"", "\"LINE LIMIT\"",
  "\"LINE-SEQUENTIAL\"", "LINES", "\"LINES-AT-ROOT\"", "LINKAGE",
  "\"LIST-BOX\"", "\"Literal\"", "\"LM-RESIZE\"", "LOC", "LOCALE",
  "\"FUNCTION LOCALE-DATE\"", "\"FUNCTION LOCALE-TIME\"",
  "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"", "\"LOCAL-STORAGE\"", "LOCK",
  "\"LOCK-HOLDING\"", "\"LONG-DATE\"", "LOWER", "LOWERED",
  "\"FUNCTION LOWER-CASE\"", "LOWLIGHT", "\"LOW-COLOR\"", "\"LOW-VALUE\"",
  "\"MAGNETIC-TAPE\"", "MANUAL", "\"MASS-UPDATE\"", "\"MASTER-INDEX\"",
  "\"MAX-LINES\"", "\"MAX-PROGRESS\"", "\"MAX-TEXT\"", "\"MAX-VAL\"",
  "MEMORY", "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE",
  "\"MICROSECOND-TIME\"", "MINUS", "\"MIN-VAL\"", "\"Mnemonic name\"",
  "MODE", "MODIFY", "MODULES", "MOVE", "MULTILINE", "MULTIPLE", "MULTIPLY",
  "NAME", "NAMED", "NAMESPACE", "\"NAMESPACE-PREFIX\"", "NATIONAL",
  "\"NATIONAL-EDITED\"", "\"FUNCTION NATIONAL-OF\"", "NATIVE",
  "\"NAVIGATE-URL\"", "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEW", "NEXT",
  "\"NEXT-ITEM\"", "\"NEXT GROUP\"", "\"NEXT PAGE\"", "NO",
  "\"NO ADVANCING\"", "\"NO-AUTOSEL\"", "\"NO-AUTO-DEFAULT\"",
  "\"NO-BOX\"", "\"NO DATA\"", "\"NO-DIVIDERS\"", "\"NO-ECHO\"",
  "\"NO-F4\"", "\"NO-FOCUS\"", "\"NO-GROUP-TAB\"", "\"NO-KEY-LETTER\"",
  "\"NO-SEARCH\"", "\"NO-UPDOWN\"", "NOMINAL", "NONE", "NONNUMERIC",
  "NORMAL", "NOT", "NOTAB", "NOTHING", "NOTIFY", "\"NOTIFY-CHANGE\"",
  "\"NOTIFY-DBLCLICK\"", "\"NOTIFY-SELCHANGE\"", "\"NOT AT END\"",
  "\"NOT AT EOP\"", "\"NOT ON ESCAPE\"", "\"NOT EQUAL\"",
  "\"NOT ON EXCEPTION\"", "\"NOT INVALID KEY\"", "\"NOT ON OVERFLOW\"",
  "\"NOT SIZE ERROR\"", "\"NUM-COL-HEADINGS\"", "\"NUM-ROWS\"", "NUMBER",
  "NUMBERS", "NUMERIC", "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"",
  "OBJECT", "\"OBJECT-COMPUTER\"", "OCCURS", "OF", "OFF", "\"OK-BUTTON\"",
  "OMITTED", "ON", "ONLY", "\"ON ESCAPE\"", "\"ON EXCEPTION\"", "OPEN",
  "OPTIONAL", "OPTIONS", "OR", "ORDER", "ORGANIZATION", "OTHER", "OTHERS",
  "OUTPUT", "\"OVERLAP-LEFT\"", "\"OVERLAP-TOP\"", "OVERLINE",
  "\"PACKED-DECIMAL\"", "PADDING", "PASCAL", "PAGE", "\"PAGE-COUNTER\"",
  "\"PAGE-SETUP\"", "PAGED", "PARAGRAPH", "PARENT", "PARSE", "PASSWORD",
  "PERFORM", "PERMANENT", "PH", "PF", "PHYSICAL", "PICTURE",
  "\"PICTURE SYMBOL\"", "PIXEL", "PLACEMENT", "PLUS", "POINTER",
  "\"POP-UP\"", "POS", "POSITION", "\"POSITION-SHIFT\"", "POSITIVE",
  "PRESENT", "PREVIOUS", "PRINT", "\"PRINT-CONTROL\"",
  "\"PRINT-NO-PROMPT\"", "\"PRINT-PREVIEW\"", "PRINTER", "\"PRINTER-1\"",
  "PRINTING", "PRIORITY", "PROCEDURE", "PROCEDURES", "PROCEED",
  "PROCESSING", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROGRESS", "PROHIBITED", "PROMPT", "PROPERTIES",
  "PROPERTY", "PROTECTED", "PROTOTYPE", "PURGE", "\"PUSH-BUTTON\"",
  "\"QUERY-INDEX\"", "QUEUE", "QUOTE", "\"RADIO-BUTTON\"", "RAISE",
  "RAISED", "RAISING", "RANDOM", "RD", "READ", "READERS", "\"READ-ONLY\"",
  "\"READY TRACE\"", "RECEIVE", "RECEIVED", "RECORD", "\"RECORD-DATA\"",
  "\"RECORD-OVERFLOW\"", "\"RECORD-TO-ADD\"", "\"RECORD-TO-DELETE\"",
  "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES", "REEL", "REFERENCE",
  "REFERENCES", "REFRESH", "\"REGION-COLOR\"", "RELATION", "RELATIVE",
  "RELEASE", "REMAINDER", "REMARKS", "REMOVAL", "RENAMES",
  "\"REORG-CRITERIA\"", "REPEATED", "REPLACE", "REPLACING", "REPORT",
  "REPORTING", "REPORTS", "REPOSITORY", "REQUIRED", "REREAD", "RERUN",
  "RESERVE", "RESET", "\"RESET TRACE\"", "\"RESET-GRID\"",
  "\"RESET-LIST\"", "\"RESET-TABS\"", "RETRY", "RETURN", "RETURNING",
  "REVERSE", "\"FUNCTION REVERSE\"", "\"REVERSE-VIDEO\"", "REVERSED",
  "REWIND", "REWRITE", "RF", "RH", "RIGHT", "\"RIGHT-ALIGN\"", "RIMMED",
  "ROLLBACK", "ROUNDED", "ROUNDING", "\"ROW-COLOR\"",
  "\"ROW-COLOR-PATTERN\"", "\"ROW-DIVIDERS\"", "\"ROW-FONT\"",
  "\"ROW-HEADINGS\"", "\"ROW-PROTECTION\"", "RUN", "S", "SAME",
  "\"SAVE-AS\"", "\"SAVE-AS-NO-PROMPT\"", "SCREEN", "\"SCREEN CONTROL\"",
  "SCROLL", "\"SCROLL-BAR\"", "SD", "SEARCH", "\"SEARCH-OPTIONS\"",
  "\"SEARCH-TEXT\"", "SECONDS", "SECTION", "SECURE", "SECURITY", "SEGMENT",
  "\"SEGMENT-LIMIT\"", "SELECT", "\"SELECTION-INDEX\"",
  "\"SELECTION-TEXT\"", "\"SELECTION-ALL\"", "\"SELF-ACT\"",
  "\"semi-colon\"", "SEND", "SENTENCE", "SEPARATE", "SEPARATION",
  "SEQUENCE", "SEQUENTIAL", "SET", "\"level-number 78\"", "SHADING",
  "SHADOW", "SHARING", "\"SHORT-DATE\"", "\"SHOW-LINES\"", "\"SHOW-NONE\"",
  "\"SHOW-SEL-ALWAYS\"", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"level-number 66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"",
  "\"SORT-ORDER\"", "SOURCE", "\"SOURCE-COMPUTER\"", "SPACE",
  "\"SPECIAL-NAMES\"", "SPINNER", "SQUARE", "STANDARD", "\"STANDARD-1\"",
  "\"STANDARD-2\"", "\"STANDARD-BINARY\"", "\"STANDARD-DECIMAL\"", "START",
  "\"START-X\"", "\"START-Y\"", "STATIC", "\"STATIC-LIST\"", "STATUS",
  "\"STATUS-BAR\"", "\"STATUS-TEXT\"", "STDCALL", "STEP", "STOP", "STRING",
  "STRONG", "STYLE", "\"SUB-QUEUE-1\"", "\"SUB-QUEUE-2\"",
  "\"SUB-QUEUE-3\"", "\"FUNCTION SUBSTITUTE\"",
  "\"FUNCTION SUBSTITUTE-CASE\"", "SUBTRACT", "SUBWINDOW", "SUM",
  "SUPPRESS", "\"SUPPRESS\"", "SYMBOLIC", "SYNCHRONIZED",
  "\"SYSTEM-DEFAULT\"", "\"SYSTEM-INFO\"", "\"SYSTEM-OFFSET\"", "TAB",
  "\"TAB-TO-ADD\"", "\"TAB-TO-DELETE\"", "TABLE", "TALLYING", "TEMPORARY",
  "TAPE", "TERMINAL", "TERMINATE", "\"TERMINAL-INFO\"",
  "\"TERMINATION-VALUE\"", "TEST", "TEXT", "THAN", "THEN", "THREAD",
  "THREADS", "THRU", "\"THUMB-POSITION\"", "\"TILED-HEADINGS\"", "TIME",
  "\"TIME-OUT\"", "TIMES", "TITLE", "\"TITLE-POSITION\"", "TO", "\"&\"",
  "\")\"", "\":\"", "\"/\"", "\".\"", "\"=\"", "\"EXTERN\"", "\"FALSE\"",
  "\"FILE\"", "\">\"", "\"INITIAL\"", "\"<\"", "\"-\"", "\"*\"",
  "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"", "\"TRUE\"", "TOP",
  "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "TRACK", "TRACKS",
  "\"TRACK-AREA\"", "\"TRACK-LIMIT\"", "\"TRADITIONAL-FONT\"", "TRAILING",
  "\"TRAILING-SHIFT\"", "TRANSFORM", "TRANSPARENT", "\"TREE-VIEW\"",
  "\"FUNCTION TRIM\"", "TRUNCATION", "TYPE", "TYPEDEF", "U", "\"UCS-4\"",
  "UNBOUNDED", "UNDERLINE", "UNFRAMED", "UNIT", "UNLOCK", "UNSIGNED",
  "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"", "\"UNSIGNED-SHORT\"",
  "UNSORTED", "UNSTRING", "UNTIL", "UP", "UPDATE", "UPDATERS", "UPON",
  "\"UPON ARGUMENT-NUMBER\"", "\"UPON COMMAND-LINE\"",
  "\"UPON ENVIRONMENT-NAME\"", "\"UPON ENVIRONMENT-VALUE\"", "UPPER",
  "\"FUNCTION UPPER-CASE\"", "USAGE", "USE", "\"USE-ALT\"",
  "\"USE-RETURN\"", "\"USE-TAB\"", "USER", "\"USER-DEFAULT\"",
  "\"user function name\"", "USING", "\"UTF-8\"", "\"UTF-16\"", "V",
  "VALID", "VALIDATE", "\"VAL-STATUS\"", "\"VALIDATE-STATUS\"",
  "VALIDATING", "VALUE", "\"VALUE-FORMAT\"", "VALUES", "VARIABLE",
  "VARIANT", "VARYING", "VERTICAL", "\"VERY-HEAVY\"", "\"VIRTUAL-WIDTH\"",
  "VOLATILE", "VPADDING", "VSCROLL", "\"VSCROLL-BAR\"", "\"VSCROLL-POS\"",
  "VTOP", "WAIT", "\"WEB-BROWSER\"", "WHEN", "\"FUNCTION WHEN-COMPILED\"",
  "\"WHEN\"", "WIDTH", "\"WIDTH-IN-CELLS\"", "WINAPI", "WINDOW", "WITH",
  "\"Identifier\"", "WORDS", "\"WORKING-STORAGE\"", "WRAP", "WRITE",
  "\"WRITE-ONLY\"", "\"WRITE-VERIFY\"", "WRITERS", "X", "XML",
  "\"XML-DECLARATION\"", "\"XML-SCHEMA\"", "Y", "YYYYDDD", "YYYYMMDD",
  "ZERO", "\"level-number (Area A)\"", "\"Identifier (Area A)\"",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "$@4",
  "end_function", "$@5", "program_prototype", "$@6", "$@7",
  "function_prototype", "$@8", "$@9",
  "_prototype_procedure_division_header", "$@10", "control",
  "_control_division", "$@11", "_default_section", "$@12",
  "_default_clauses", "_default_accept_clause", "$@13",
  "_default_display_clause", "$@14", "_program_body", "$@15", "$@16",
  "_identification_header", "identification_header", "$@17",
  "identification_or_id", "program_id_header", "program_id_paragraph",
  "function_id_header", "function_id_paragraph", "program_id_name",
  "end_program_name", "_as_literal", "_program_type",
  "program_type_clause", "init_or_recurse_and_common", "init_or_recurse",
  "_options_paragraph", "_options_clauses", "_arithmetic_clause",
  "arithmetic_choice", "_default_rounded_clause",
  "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "environment",
  "environment_header", "_configuration_section", "_configuration_header",
  "configuration", "configuration_header", "_configuration_paragraphs",
  "configuration_paragraphs", "configuration_paragraph",
  "_source_computer_paragraph", "source_computer_paragraph", "$@18",
  "_source_computer_entry", "_with_debugging_mode",
  "object_computer_paragraph", "$@19", "_object_computer_entry",
  "object_clauses_list", "object_clauses", "object_computer_memory",
  "object_computer_sequence", "program_collating_sequence", "$@20",
  "program_coll_sequence_values", "object_computer_segment",
  "object_computer_class", "locale_class", "computer_words",
  "_repository_paragraph", "repository_paragraph", "$@21",
  "_repository_entry", "repository_list", "repository_name",
  "repository_name_list", "special_names_header", "special_names_sentence",
  "special_name_list", "special_name", "mnemonic_name_clause", "$@22",
  "word_or_terminal", "mnemonic_choices", "_special_name_mnemonic_on_off",
  "on_off_clauses", "on_off_clauses_1", "alphabet_name_clause", "@23",
  "alphabet_definition", "@24", "@25", "alphabet_target_alphanumeric",
  "alphabet_target_national", "alphabet_type_alphanumeric",
  "alphabet_type_national", "alphabet_type_common",
  "alphabet_literal_list", "alphabet_literal", "@26",
  "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "_alphnat_target", "_in_alphabet", "symbolic_characters_clause",
  "symbolic_collection", "symbolic_chars_list", "symbolic_chars_phrase",
  "char_list", "integer_list", "symbolic_constant_clause",
  "symbolic_constant_list", "symbolic_constant", "class_name_clause",
  "class_item_list", "class_item", "locale_clause", "xml_schema_clause",
  "@27", "schema_definition", "currency_sign_clause", "_with_pic_symbol",
  "decimal_point_clause", "numeric_sign_clause", "cursor_clause",
  "crt_status_clause", "screen_control", "event_status", "top_clause",
  "$@28", "_input_output_section", "input_output", "_input_output_header",
  "_file_control_header", "_file_control_sequence", "file_control_entry",
  "$@29", "$@30", "_select_clauses_or_error", "_select_clause_sequence",
  "select_clause", "assign_clause", "_assign_device_or_line_adv_file",
  "assign_device", "general_device_name", "line_seq_device_name",
  "line_adv_file", "_ext_clause", "ext_clause", "assignment_name",
  "access_mode_clause", "access_mode", "alternate_record_key_clause",
  "_password_clause", "password_clause", "$@31", "encryption_clause",
  "_suppress_clause", "collating_sequence_clause", "collating_sequence",
  "$@32", "coll_sequence_values", "collating_sequence_clause_key",
  "alphabet_name", "file_status_clause", "_file_or_sort",
  "lock_mode_clause", "$@33", "lock_mode", "_lock_with", "_with_rollback",
  "with_rollback", "_with_mass_update", "organization_clause",
  "organization", "padding_character_clause", "record_delimiter_clause",
  "$@34", "record_delimiter_option", "record_key_clause", "_split_keys",
  "source_is", "split_key_list", "$@35", "split_key",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "file_limit_clause", "thru_list",
  "actual_key_clause", "nominal_key_clause", "track_area_clause",
  "track_limit_clause", "_i_o_control", "i_o_control_header",
  "_i_o_control_entries", "i_o_control_list", "i_o_control_clause",
  "same_clause", "_same_option", "apply_clause",
  "obsolete_dos_vs_apply_phrase", "multiple_file_tape_clause", "$@36",
  "multiple_file_list", "multiple_file", "_multiple_file_position",
  "rerun_clause", "_on_assignment", "rerun_event",
  "_prototype_environment_division", "_prototype_special_names_paragraph",
  "_prototype_special_names_sentence_list",
  "prototype_special_names_sentence_list", "prototype_special_name_list",
  "prototype_special_name", "_data_division", "$@37",
  "_data_division_header", "data", "data_division_header", "tok_file",
  "_file_section_header", "_file_description_sequence", "file_description",
  "file_description_entry", "$@38", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "communication", "_communication_section", "$@39",
  "_communication_description_sequence", "communication_description", "cd",
  "communication_description_entry", "$@40",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses", "working_storage",
  "_working_storage_section", "$@41", "_record_description_list", "$@42",
  "record_description_list", "data_description", "$@43", "level_number",
  "_filler", "_entry_name", "user_entry_name", "_const_global",
  "lit_or_length", "con_source", "fp32_usage", "fp64_usage", "fp128_usage",
  "pointer_len", "renames_entry", "_renames_thru", "condition_name_entry",
  "$@44", "_user_entry_name", "constant_entry", "$@45", "constant_source",
  "constant_78_source", "constant_expression_list", "constant_expression",
  "_data_description_clause_sequence", "data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "like_clause",
  "_length_modifier", "length_modifier", "same_as_clause",
  "typedef_clause", "_strong", "external_clause", "_as_extname",
  "_global_clause", "global_clause", "special_names_clause", "$@46",
  "special_names_target", "select_when_clause", "$@47", "when_choice",
  "format_clause", "format_choice", "volatile_clause", "picture_clause",
  "$@48", "_pic_locale_format_or_depending_on_or_byte_length",
  "_is_locale_name", "locale_name", "type_to_clause", "usage_clause",
  "_usage_is", "usage", "conflict_usage", "_object_reference_type",
  "_factory_of", "_only", "double_usage", "long_double", "_font_name",
  "_layout_name", "sign_clause", "byte_length_clause",
  "report_occurs_clause", "report_occurs_step", "occurs_clause",
  "_occurs_from_integer", "_occurs_to_integer", "_occurs_integer_to",
  "_occurs_depending", "_capacity_in", "_occurs_initialized",
  "_occurs_keys_and_indexed", "$@49", "occurs_keys", "occurs_key_list",
  "occurs_key_field", "ascending_or_descending", "_occurs_indexed",
  "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "_left_or_right",
  "blank_clause", "based_clause", "value_clause", "value_table_item_list",
  "value_table_item", "value_from_subscripts_is_are", "from_subscripts",
  "_to_subscripts", "from_to_subscripts", "_repeated_phrase",
  "repeated_phrase", "subscripts", "value_is_are", "value_item_list",
  "value_item", "value_clause_report", "value_clause_condition", "$@50",
  "value_item_list_in_alphabet", "value_item_condition_list",
  "value_item_condition", "_false_or_content_validation", "false_is",
  "content_validation", "valid_or_invalid", "_when_condition",
  "validate_status_clause", "when_error_choice", "_on_choice",
  "default_clause", "x_or_none", "class_clause", "class_option",
  "destination_clause", "present_when_clause", "invalid_when_clause",
  "any_length_clause", "external_form_clause", "identified_by_clause",
  "local_storage", "_local_storage_section", "$@51", "linkage",
  "_linkage_section", "$@52", "_report_section", "$@53", "$@54",
  "_report_description_sequence", "report_description", "$@55", "$@56",
  "_report_description_options", "report_description_option",
  "control_clause", "control_field_list", "control_final_tag",
  "control_identifier_list", "control_identifier", "page_limit_clause",
  "page_line_column", "page_limit_cols", "integer_or_zero_or_ident",
  "_page_heading_list", "page_detail", "heading_clause", "first_detail",
  "last_heading", "last_detail", "footing_clause",
  "_report_group_description_list", "report_group_description_entry",
  "$@57", "_report_group_options", "report_group_option", "type_is_clause",
  "type_option", "_control_heading_final", "_or_page",
  "_control_footing_final", "next_group_clause", "next_group_plus",
  "next_page", "sum_clause_list", "_reset_clause", "data_or_final",
  "present_when_condition", "present_absent", "_page_or_id", "page_or_ids",
  "data_varying_clause", "data_varying_list", "data_varying", "_var_from",
  "_var_by", "line_clause", "line_keyword_clause", "_line_clause_options",
  "line_clause_option", "column_clause", "col_keyword_clause",
  "_orientation", "_left_right_center", "col_or_plus",
  "column_integer_list", "column_integer", "source_clause",
  "group_indicate_clause", "_screen_section", "$@58", "$@59",
  "_screen_description_list", "screen_description_list",
  "screen_description", "$@60", "$@61", "$@62", "_screen_options",
  "screen_option", "screen_value_clause", "_value_is",
  "control_definition", "control_type_name", "control_type",
  "control_item", "_control_attributes", "control_attributes",
  "control_attribute", "control_style", "control_property",
  "control_style_name", "control_property_name",
  "control_style_name_generic", "control_property_name_generic",
  "control_style_name_label", "control_property_name_label",
  "control_style_name_entry_field", "control_property_name_entry_field",
  "control_style_name_push_button", "control_property_name_push_button",
  "control_style_name_check_box", "control_property_name_radio_button",
  "control_style_name_list_box", "control_property_name_list_box",
  "control_style_name_combo_box", "control_style_name_frame",
  "control_property_name_frame", "control_style_name_tab_control",
  "control_property_name_tab_control", "control_style_name_bar",
  "control_property_name_bar", "control_property_name_bitmap",
  "control_style_name_grid", "control_property_name_grid",
  "control_style_name_tree_view", "control_property_name_tree_view",
  "control_property_name_web_browser", "control_style_name_activex",
  "control_property_name_activex", "control_style_name_date_entry",
  "control_property_name_date_entry", "control_style_type",
  "control_property_type", "changeable_control_properties",
  "changeable_control_property", "changeable_window_properties",
  "changeable_window_property", "eol", "eos", "_plus", "plus",
  "plus_tokens", "minus", "minus_tokens", "control_size",
  "control_size_unit", "_cell", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause",
  "_prototype_data_division", "_procedure_division", "procedure_division",
  "$@63", "$@64", "$@65", "$@66", "$@67", "_procedure_using_chaining",
  "$@68", "$@69", "procedure_param_list", "procedure_param",
  "_procedure_type", "_size_optional", "using_size_clause",
  "size_is_integer", "_acu_size", "_procedure_optional",
  "_procedure_returning", "_procedure_declaratives", "$@70", "$@71",
  "$@72", "_procedure_list", "procedure", "$@73", "proc_name",
  "section_header", "$@74", "_use_statement", "paragraph_header",
  "invalid_statement", "_segment", "statement_list", "@75", "@76",
  "statements", "$@77", "statement", "$@78", "accept_statement", "$@79",
  "accept_body", "$@80", "$@81", "accp_identifier",
  "field_with_pos_specifier", "$@82", "_pos_specifier", "pos_specifier",
  "pos_specifier_value", "identifier_or_numeric_literal",
  "_accept_clauses", "accept_clauses", "accept_clause",
  "accept_from_screen_clauses", "accept_from_screen_clause",
  "lines_or_number", "at_line_column", "line_number", "column_number",
  "mode_is_block", "accp_attr", "_key_dest", "key_dest", "no_echo",
  "reverse_video", "update_default", "_end_accept", "add_statement",
  "$@83", "add_body", "_add_to", "_end_add", "allocate_statement", "$@84",
  "allocate_body", "_loc", "_allocate_returning", "alter_statement",
  "$@85", "alter_body", "alter_entry", "_proceed_to", "call_statement",
  "$@86", "call_body", "$@87", "_conv_linkage", "$@88",
  "conv_linkage_option", "_mnemonic_conv", "mnemonic_conv",
  "program_or_prototype", "_id_or_lit_or_func_as", "nested_or_prototype",
  "call_using", "$@89", "call_param_list", "call_param", "_call_type",
  "call_returning", "return_give", "null_or_omitted",
  "call_exception_phrases", "_call_on_exception", "call_on_exception",
  "_call_not_on_exception", "call_not_on_exception", "_end_call",
  "cancel_statement", "$@90", "cancel_body", "cancel_list",
  "id_or_lit_or_program_name", "close_statement", "$@91", "close_body",
  "close_files", "_close_option", "close_window", "$@92",
  "_close_display_option", "compute_statement", "$@93", "compute_body",
  "_end_compute", "commit_statement", "continue_statement", "$@94",
  "_continue_after_phrase", "$@95", "destroy_statement", "$@96",
  "destroy_body", "delete_statement", "$@97", "delete_body",
  "delete_file_list", "_end_delete", "disable_statement", "$@98",
  "enable_disable_handling", "_enable_disable_key", "communication_mode",
  "display_statement", "$@99", "display_body", "screen_or_device_display",
  "display_list", "display_atom", "$@100", "disp_list",
  "_with_display_attr", "display_attrs", "display_clauses",
  "display_clause", "_display_upon", "display_upon", "crt_under",
  "display_erase", "$@101", "display_pos_specifier",
  "field_or_literal_or_erase_with_pos_specifier", "$@102",
  "field_or_literal_or_erase_list", "field_or_literal_or_erase",
  "display_message_box", "$@103", "_display_message_clauses",
  "display_message_clauses", "display_message_clause", "display_window",
  "$@104", "$@105", "sub_or_window", "display_floating_window", "$@106",
  "$@107", "display_initial_window", "$@108", "initial_type", "_graphical",
  "_upon_window_handle", "window_handle", "display_window_clauses",
  "display_window_clause", "shadow", "boxed", "_top_or_bottom",
  "_left_or_centered_or_right", "no_scroll_wrap", "pop_up_or_handle",
  "pop_up_area", "handle_is_in", "disp_attr", "_end_display",
  "divide_statement", "$@109", "divide_body", "_end_divide",
  "enable_statement", "$@110", "entry", "entry_statement", "$@111",
  "$@112", "entry_body", "entry_goto_body", "evaluate_statement", "$@113",
  "evaluate_body", "evaluate_subject_list", "evaluate_subject",
  "evaluate_condition_list", "evaluate_case_list", "evaluate_case",
  "evaluate_other", "evaluate_when_list", "$@114", "$@115",
  "evaluate_object_list", "evaluate_object", "_evaluate_thru_expr",
  "_end_evaluate", "exhibit_statement", "$@116", "exhibit_body", "$@117",
  "_changed", "_named", "_erase", "exhibit_target_list", "exhibit_target",
  "exit_statement", "$@118", "exit_body", "goback_exit_body",
  "free_statement", "$@119", "free_body", "generate_statement", "$@120",
  "generate_body", "goto_statement", "$@121", "go_body", "goto_depending",
  "goback_statement", "$@122", "if_statement", "$@123",
  "if_else_statements", "_if_then", "if_true", "if_false", "_end_if",
  "initialize_statement", "$@124", "initialize_body", "_initialize_filler",
  "_initialize_value", "_initialize_replacing",
  "initialize_replacing_list", "initialize_replacing_item",
  "initialize_category", "_initialize_default", "initiate_statement",
  "$@125", "initiate_body", "inquire_statement", "$@126", "inquire_body",
  "inspect_statement", "$@127", "inspect_body", "_backward",
  "send_identifier", "inspect_format_variant", "examine_statement",
  "$@128", "examine_format_variant", "$@129", "examine_tallying_keyword",
  "examine_replacing_keyword", "_examine_tallying_replacing",
  "single_character_value", "inspect_tallying", "$@130",
  "inspect_replacing", "inspect_converting", "tallying_list",
  "tallying_item", "replacing_list", "replacing_item", "rep_keyword",
  "replacing_region", "inspect_region", "inspect_before", "inspect_after",
  "json", "json_generate_statement", "$@131", "json_generate_body",
  "$@132", "$@133", "_json_suppress", "json_suppress_list",
  "json_suppress_entry", "_end_json", "json_parse_statement", "$@134",
  "json_parse_body", "_with_detail", "merge_statement", "$@135",
  "modify_statement", "$@136", "modify_body", "_end_modify",
  "move_statement", "$@137", "move_body", "multiply_statement", "$@138",
  "multiply_body", "_end_multiply", "open_statement", "$@139", "open_body",
  "open_file_entry", "_open_exclusive", "open_mode", "_open_sharing",
  "_open_option", "lock_allowing", "open_lock_option", "allowing_option",
  "allowing_all", "open_option_sequential", "osvs_input_mode",
  "perform_statement", "$@140", "perform_body", "$@141", "$@142",
  "_end_perform", "end_perform_or_dot", "perform_procedure",
  "_perform_option", "perform_test", "cond_or_exit",
  "perform_varying_list", "perform_varying", "_by_phrase",
  "purge_statement", "$@143", "raise_statement", "$@144", "raise_body",
  "exception_name", "read_statement", "$@145", "read_body", "_read_into",
  "_lock_phrases", "ignoring_lock", "advancing_lock_or_retry",
  "_retry_phrase", "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "_end_read",
  "ready_statement", "receive_statement", "$@146", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "_end_receive", "release_statement", "$@147", "release_body",
  "reset_statement", "return_statement", "$@148", "return_body",
  "_end_return", "rewrite_statement", "$@149", "rewrite_body",
  "_with_lock", "with_lock", "_end_rewrite", "rollback_statement",
  "search", "search_statement", "$@150", "$@151", "search_body",
  "search_all_body", "_search_varying", "_search_at_end", "end_pos_token",
  "search_whens", "search_when", "_end_search", "end_search_pos_token",
  "send_statement", "$@152", "send_body", "send_body_mcs",
  "message_tag_data_item", "_from_identifier", "from_identifier",
  "send_body_cd", "with_indicator", "_replacing_line", "set_statement",
  "$@153", "set_body", "on_or_off", "up_or_down", "set_environment",
  "set_attr", "set_attr_clause", "set_attr_one", "set_to", "set_up_down",
  "set_to_on_off_sequence", "set_to_on_off", "set_to_true_false_sequence",
  "set_to_true_false", "set_last_exception_to_off", "set_thread_priority",
  "sort_statement", "$@154", "sort_body", "@155", "_sort_key_list",
  "_key_sort_list", "_sort_duplicates", "_sort_collating", "sort_input",
  "sort_output", "start_statement", "$@156", "start_body",
  "_sizelen_clause", "_start_key", "start_op", "not_equal_op",
  "_end_start", "stop", "stop_statement", "$@157", "stop_returning",
  "_status_x", "stop_argument", "stop_literal", "string_statement",
  "$@158", "string_body", "string_items", "$@159", "string_item_list",
  "string_item", "_string_delimited", "string_delimiter", "_with_pointer",
  "_end_string", "subtract_statement", "$@160", "subtract_body",
  "_end_subtract", "suppress_statement", "$@161", "_printing",
  "terminate_statement", "$@162", "terminate_body", "transform_statement",
  "$@163", "transform_body", "unlock_statement", "$@164", "unlock_body",
  "unstring_statement", "$@165", "unstring_body", "_unstring_delimited",
  "unstring_delimited_list", "unstring_delimited_item", "unstring_into",
  "unstring_into_item", "_unstring_into_delimiter", "_unstring_tallying",
  "_end_unstring", "validate_statement", "$@166", "validate_fields",
  "use_statement", "$@167", "use_phrase", "use_file_exception",
  "_use_global", "use_file_exception_target", "use_for_debugging",
  "debugging_list", "debugging_target", "_all_refs", "use_at_start_end",
  "program_start_end", "use_before_reporting", "use_after_exception",
  "use_exception_list", "use_exception", "use_ex_keyw", "write_statement",
  "$@168", "write_body", "from_option", "write_option", "before_or_after",
  "write_handler", "_end_write", "xml", "xml_generate_statement", "$@169",
  "xml_generate_body", "$@170", "$@171",
  "_with_encoding_xml_dec_and_attrs", "with_encoding_xml_dec_and_attrs",
  "with_encoding_xml_dec_and_attr", "encoding_xml_dec_and_attr",
  "_xml_gen_namespace", "_xml_gen_namespace_prefix", "_xml_name_of",
  "identifier_name_list", "identifier_is_name", "_json_name_of",
  "json_identifier_name_list", "json_identifier_is_name", "_type_of",
  "identifier_type_list", "identifier_is_type", "_xml_type", "ml_type",
  "_xml_gen_suppress", "xml_suppress_list", "xml_suppress_entry",
  "xml_suppress_generic_opt", "xml_suppress_when_list", "_end_xml",
  "xml_parse_statement", "$@172", "xml_parse_body", "$@173",
  "_with_encoding", "_returning_national", "_validating_with",
  "schema_file_or_record_name", "_accept_exception_phrases",
  "_accp_on_exception", "accp_on_exception", "escape_or_exception",
  "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_common_exception_phrases",
  "_common_on_exception", "common_on_exception",
  "_common_not_on_exception", "common_not_on_exception",
  "on_size_error_phrases", "_on_size_error", "on_size_error",
  "_not_on_size_error", "not_on_size_error", "_on_overflow_phrases",
  "_on_overflow", "on_overflow", "_not_on_overflow", "not_on_overflow",
  "return_at_end", "read_at_end", "_at_end_clause", "at_end_clause",
  "_not_at_end_clause", "not_at_end_clause", "at_eop_clauses",
  "_at_eop_clause", "at_eop_clause", "_not_at_eop_clause",
  "not_at_eop_clause", "_invalid_key_phrases", "invalid_key_phrases",
  "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "_count_in", "condition", "expr", "partial_expr", "$@174", "expr_tokens",
  "expr_token", "condition_no_is", "expr_no_is", "partial_expr_no_is",
  "$@175", "expr_tokens_no_is", "expr_token_no_is", "_not_expr",
  "not_expr", "condition_or_class", "eq", "gt", "lt", "ge", "le",
  "exp_list", "_e_sep", "exp", "exp_term", "exp_factor", "exp_unary",
  "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_file_name_list", "file_name", "cd_name",
  "report_name", "mnemonic_name_list", "mnemonic_name", "entry_name_list",
  "entry_name", "procedure_name_list", "procedure_name", "label",
  "integer_label", "reference_list", "reference", "_reference",
  "single_reference_list", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "unique_word", "target_x_list", "target_x", "_x_list", "x_list", "x",
  "call_x", "x_common", "length_of_register", "report_x_list", "expr_x",
  "arith_x", "arith_nonzero_x", "numeric_literal", "non_numeric_literal",
  "nonzero_numeric_literal", "prog_or_entry", "alnum_or_id",
  "simple_display_value", "inspect_from", "inspect_to", "simple_value",
  "simple_all_value", "id_or_lit", "id_or_lit_or_func",
  "id_or_lit_or_length_or_func", "num_id_or_lit", "positive_id_or_lit",
  "pos_num_id_or_lit_or_zero", "pos_num_id_or_lit", "from_parameter",
  "sub_identifier", "table_identifier", "sub_identifier_1",
  "display_identifier", "numeric_identifier", "identifier_or_file_name",
  "identifier_field", "type_name", "identifier", "identifier_1",
  "identifier_list", "validate_for_identifier_list", "for_identifier",
  "target_identifier", "target_identifier_1", "target_identifier_single",
  "display_identifier_or_alphabet_name", "qualified_word",
  "unqualified_word", "$@176", "unqualified_word_check", "subref",
  "refmod", "integer", "symbolic_integer", "unsigned_pos_integer",
  "integer_or_zero", "class_value", "figurative_constant", "literal",
  "basic_literal", "basic_value", "zero_spaces_high_low_values",
  "function", "func_no_parm", "func_one_parm", "func_multi_parm",
  "func_refmod", "func_args", "trim_args", "length_arg", "$@177",
  "numvalc_args", "locale_dt_args", "formatted_datetime_args",
  "formatted_time_args", "not_const_word", "flag_all", "flag_duplicates",
  "_flag_initialized", "_flag_initialized_to", "_to_init_val",
  "_flag_next", "_flag_not", "flag_optional", "flag_rounded", "round_mode",
  "round_choice", "flag_separate", "_from_idx_to_idx", "_dest_index",
  "error_stmt_recover", "verb", "scope_terminator", "_dot",
  "_dot_or_else_end_of_file_control", "level_number_in_area_a",
  "_dot_or_else_end_of_file_description",
  "_dot_or_else_end_of_communication_description",
  "_dot_or_else_end_of_report_description",
  "_dot_or_else_end_of_report_group_description",
  "_dot_or_else_end_of_record_description", "_file_control_end_delimiter",
  "_file_description_end_delimiter", "_record_description_end_delimiter",
  "_dot_or_else_area_a", "_advancing", "_after", "_are", "_area", "_areas",
  "_as", "_at", "_before", "_binary", "_box", "_by", "_character",
  "_characters", "_collating", "_contains", "_controls", "_control",
  "_data", "_end_of", "_every", "_file", "_for", "_from", "_in",
  "_in_equal", "_in_order", "_index", "_indicate", "_initial", "_into",
  "_is", "_is_equal", "_is_are", "_is_are_equal", "_is_in", "_key",
  "_line", "_line_or_lines", "_limits", "_lines", "_lock", "_message",
  "_mode", "_new", "_number", "_number_or_numbers", "_of", "_on",
  "_on_for", "_onoff_status", "_other", "_others", "_procedure",
  "_program", "_protected", "_record", "_records", "_right", "_sign",
  "_signed", "_sign_is", "_size", "_standard", "_status", "_symbolic",
  "_tape", "_terminal", "_then", "_times", "_to", "_up", "_when",
  "_when_set_to", "_with", "_with_for", "_exception", "at_end",
  "on_escape", "on_exception", "column_or_col", "columns_or_cols",
  "column_or_cols", "column_or_col_or_position_or_pos", "comp_equal",
  "exception_or_error", "file_limit_or_limits", "in_of", "label_option",
  "line_or_lines", "lock_records", "object_char_or_word_or_modules",
  "records", "reel_or_unit", "size_or_length", "length_of",
  "track_or_tracks", "using_or_varying", "detail_keyword", "ch_keyword",
  "cf_keyword", "ph_keyword", "pf_keyword", "rh_keyword", "rf_keyword",
  "control_keyword", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973,   974,
     975,   976,   977,   978,   979,   980,   981,   982,   983,   984,
     985,   986,   987,   988,   989,   990,   991,   992,   993,   994,
     995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,  1004,
    1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1052,  1053,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,
    1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,
    1175,  1176,  1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    1185,  1186,  1187,  1188,  1189,  1190,  1191,  1192,  1193,  1194,
    1195,  1196,  1197,  1198,  1199,  1200,  1201,  1202,  1203,  1204,
    1205,  1206,  1207,  1208,  1209,  1210,  1211,  1212,  1213,  1214,
    1215,  1216,  1217,  1218,  1219,  1220,  1221,  1222,  1223,  1224
};
#endif

#define YYPACT_NINF (-3889)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-3453)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -3889,   516,  1533, -3889, -3889, -3889,   367, -3889,   936, -3889,
    1311,  2240,   713, -3889,  1686,   775, -3889, -3889,  1473, -3889,
   -3889, -3889, -3889, -3889,    40, -3889, -3889,  1769, -3889, -3889,
    1836,  1825, -3889, -3889, -3889, -3889, -3889, -3889,  1235,   936,
    1257,   936,  2016,  1891, -3889,  2145,  2167, -3889,  1973,  2035,
    1663, -3889,   775,  2196,  1453,  2204,  1453,  2202,   775, -3889,
    1655,  1761,  2234, -3889, -3889,  1678,  2305, -3889, -3889, -3889,
    1841,  2256,   170,   170,  1800,  1831,  1891,  1891,  1891,   170,
    1840,   775,   775,  1891,   775,   775,  2170, -3889, -3889, -3889,
     170, -3889,  2035, -3889, -3889, -3889, -3889, -3889, -3889,  1195,
   -3889, -3889, -3889, -3889, -3889,  2197, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,   775, -3889,
   -3889, -3889, -3889, -3889,  2581, -3889, -3889,  2204, -3889,  2581,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2147,  1891,
    2237,  1096, -3889,  1922, -3889,   775,   775,   775, -3889, -3889,
   -3889, -3889,  1132,  1891, -3889,  1891,  1720,  2529,  1720,  1891,
    1891, -3889, -3889,  1720, -3889, -3889, -3889,  1739,   -55,  1891,
   -3889, -3889, -3889, -3889, -3889,  1751,   167, -3889, -3889,  1951,
    2225,   771,  1531, -3889,   861,  1531, -3889,  1891,   140,  1987,
     775, -3889, -3889, -3889, -3889,   775,  1047, -3889, -3889, -3889,
    1145,  1132, -3889,  1891,   525,  1720,  2244,  1086, -3889, -3889,
   -3889, -3889,  2249,  1853,   571,  1100, -3889,  1787, -3889,  1739,
   -3889,  1891,  1789,   170,   279, -3889, -3889, -3889, -3889, -3889,
    1699,   997,  1891,   165, -3889, -3889, -3889, -3889, -3889, -3889,
    1904, -3889,  1905,   242, -3889, -3889,   775, -3889,  2119,   775,
     353, -3889, -3889, -3889, -3889,  1891, -3889,  2536,  5520, 12356,
   -3889, -3889, -3889,  1822, -3889,   112,   178,   775, -3889, -3889,
   -3889,   535, -3889, -3889, -3889,   650,  1715, -3889, -3889, -3889,
    -248, -3889, -3889,  1720, -3889,  2018, -3889,  2000, -3889,  1891,
   -3889, -3889,   728, -3889, -3889, -3889, -3889, -3889,   746,  2651,
    2645,   193,  1834, -3889,   208, -3889, -3889,    33, -3889,   492,
   -3889,  1789, -3889,   154, -3889, -3889,  1838, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1937, -3889,
     997, -3889,  2357,   170,   170, -3889,  1699,   187, -3889,  -181,
   -3889,   775, -3889, -3889,  2148, -3889,  2636, -3889,   775, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1635,
   -3889, -3889, 12925, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  2438, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  1179, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
    2780, -3889, -3889, -3889, -3889, -3889,  1733, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1191, -3889, -3889,
   -3889, -3889, -3889,  2056,  2646, -3889,    72,   968, -3889, -3889,
   -3889,     2,  1879, -3889,  2214,  1369, -3889,  1000, -3889, -3889,
   -3889, -3889, -3889, -3889,  1891,  1891, -3889, -3889, -3889,  1546,
   -3889,  1963, -3889, -3889, -3889,  2188, -3889, -3889, -3889,  1891,
    2329, -3889, -3889, -3889, -3889,   788,  1891, -3889, -3889,  2051,
    2384, -3889,  2581,  1347,  2581,  1960, -3889, -3889,  1965,  2602,
   -3889, -3889, -3889, -3889, -3889,  2345, -3889,  1838,   170, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  2594, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,   485, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,   745, 12464,
   19263,   -23,   485,   185,  1713,  1116,  2810,  1269,   202,   -36,
    7043, 16986,   -36,  -342,  2787,  2704,   913,  1116,  1720,  1980,
    1312, 10263,  1116,  1881,   261,  2766,  1720,   261, 15802, 16986,
    2076,  2523,   340,  1887,   -33,  1888,  1887,  1720,  1888,  1384,
    -363,   322,  1720,  1888, -3889, 15646,  2207,  1881,  1720,  1888,
    9236,  1720,  1384,  2463,   485, -3889, -3889, -3889,  1720, -3889,
   -3889, -3889, -3889, -3889,  1720, -3889, -3889, -3889, -3889, -3889,
   -3889,  1979, -3889, -3889,   200,  1043, -3889,  2101,  2362,  1739,
    1739,  1739,   622,  1043,  8609, -3889, -3889, -3889,  -114, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2258, -3889,
     170,  2214,  1980,  1980,  2269,  2214,  2214,  1980,  2214,  2214,
    1980,  2214,  2214,  1994, -3889,  2556,   300, -3889, -3889, -3889,
    2832,   974, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
    1875,  2012, -3889, -3889,  1715,  2389,  2329, -3889, -3889,   783,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2358,
   -3889,  2345, -3889, -3889, -3889,  1891, -3889,  2019,  1686,  1686,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1919, -3889, -3889,
    1819,  2613, -3889, 19624,  2008,  2367,  2508,  2269, -3889, -3889,
   -3889,  1720, -3889, -3889,  2011,  2015,  2017, -3889, -3889,  2020,
    1086,  1086,  2022,  2025,  2026, -3889, -3889,  2027,  1086, -3889,
   -3889, -3889,  1720,  2028, -3889,  2017, -3889,  2622, -3889, 16064,
   -3889, -3889, 19734, -3889, -3889, -3889,  2029,  2030,  2036, -3889,
   19542, 19542, 19263, 19542, -3889,   137,  1244, -3889,  2566, -3889,
   -3889, 19734, -3889, -3889,  2467,  1613,  1937, -3889, -3889,   -23,
   -3889,  2040, -3889,  1086, -3889,  2640,   340, -3889, -3889, -3889,
   -3889,   815, -3889, -3889, -3889, -3889, -3889,  1888, -3889,  1477,
    2269,  2641, -3889,  1392, -3889,  2189, -3889, -3889,  1979,  1937,
   -3889, -3889,  1888,  2648,  2239,  2737, -3889, -3889,  1720,  2084,
    2085, -3889, -3889, -3889,  1887, -3889,  2533, -3889,  1842,  2825,
   -3889, -3889, -3889, -3889, -3889,  2654,  1599, 16156, -3889, -3889,
   -3889, -3889,  1969,  2008, -3889, -3889, -3889, -3889, -3889,  2533,
   15192,  1850,  1857,  2746,  2661,   288, -3889, -3889, -3889,  2662,
     157, -3889, -3889, -3889, 15554,  -204, -3889, -3889, -3889, -3889,
   -3889,  2407, -3889, -3889,  2732,  1312, -3889, -3889, -3889,  1116,
   -3889, -3889, -3889, -3889, -3889,  2644, -3889,   -27, -3889, 16986,
   -3889, -3889,  2096, -3889, -3889,   385, -3889,  1881, -3889, -3889,
    1720, 14145,  1058, -3889,  1198, -3889, -3889,  2787, -3889, -3889,
   -3889,  2069, 13365,  1058,  2665, 16986, -3889,  2088,  2666,  2841,
   -3889, -3889,  2115, -3889,  1592, -3889, -3889,  4866,  2102, -3889,
   -3889,  1988, -3889, -3889,  2667,   -39,  2668,   904, -3889,  2577,
   -3889,  2670,  2239,  1996,  2671, -3889,  2577, 16986, -3889,  2676,
   -3889,  2582, 19734,  2652, -3889, -3889, -3889, -3889, -3889, -3889,
    2454, -3889,  1116, -3889, -3889, -3889,  2331,  -115, -3889,  1035,
    2921, -3889,   190, -3889,  2690,  2055,  2691,  2544, 16986,  1720,
    1720,  2695, 16221, -3889, -3889,  1881, -3889, -3889,  2849, -3889,
   -3889,  1843, -3889,  2697,  2765, -3889, -3889,  1720, -3889,  2701,
    2577,  2143,  2514, -3889,  1720,  1720,  1720,  2716,  2064, -3889,
   15401, -3889, 19263,  2131, -3889,  1720,  1720, -3889,   223, -3889,
   -3889,   830, -3889, -3889, -3889,  7949, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,   775, -3889,  2253,
    2524, -3889, -3889, -3889,  2309,  1043, -3889,  2150, -3889, -3889,
   -3889,  2833, -3889, -3889,  2629, -3889, -3889,  1720,  1720,  2329,
   -3889,  2329,  1888,  1888,  2329,  1888,  1888,  1720,  1888,  1888,
   -3889,  2172, -3889,  1284, -3889, -3889, -3889, -3889,  2647, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,  1556, -3889,   183, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,   115, -3889, -3889, -3889, -3889, -3889,
   -3889,  2058,   -52, -3889, -3889,  -391,  1891, -3889,  1836, -3889,
   -3889, -3889,   122, -3889, -3889, 19624,   951, -3889, -3889,  1891,
   -3889, 19624, -3889, -3889, -3889,  1304,  2165,  8430,    71,  1720,
   -3889,  2824,  4481,    -3,  2162, 19263, 19263, 18167,  2029, -3889,
    2061,  2063, 19263, 19263, 19263, 19734,  2065,  2163, 19734,  2029,
   -3889, -3889, 17032,  2642, -3889, -3889,  1937, -3889, 19263, -3889,
   19734, 19263, -3889, -3889,  1708, -3889,  2601, 19263, 19263, 19263,
   19263, 19263, 19263, 19263, 19263, 19263, 19263, 19263, 19263, -3889,
    1937, -3889, -3889,  2539, -3889,  2381,  2545, -3889, -3889,  9236,
   -3889,  1720,  1477, -3889, -3889, -3889,   994,  1029,  1720, -3889,
   -3889, -3889, -3889, -3889, 19263,  2512, -3889,  2131, -3889, 19263,
     146, -3889, -3889, -3889, -3889,  2317, -3889, -3889, -3889, -3889,
   -3889, -3889,  -104,  1969, -3889,  2077, -3889, 16986, -3889, -3889,
   -3889, -3889, -3889, -3889,  2460,  1259, -3889, -3889, -3889, 15192,
     297,  5507, -3889,  1395,  2127,  2081,  1599,  1599,  1599,  1599,
   16156, -3889, -3889, 16986, 17032, -3889, -3889,  -342, -3889, -3889,
    2091, -3889,    12, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889,  -162, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, 14636, -3889, -3889, -3889,  1293,   216, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  2557,    25,  2726, -3889, -3889,
   -3889,  2784,  2174,  2702, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
     -47, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,  2329, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,   -47, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, 14145, -3889,   -47,   -47,   -47,  1058, -3889,   231,   230,
   19263, -3889, -3889,   882, 11772, -3889, -3889,   155, 17483,  1058,
   -3889, -3889,  2192,  1116, -3889, -3889, 17032, -3889, -3889, -3889,
   -3889, -3889,  2277,  2269, -3889,  -330, -3889,  2656,  2656,  1413,
    2206,  1917,  2205, -3889,  1517, -3889, -3889,  2213, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  2239, -3889, -3889, -3889, -3889,
    2625,  2787, -3889, -3889, -3889,  2626, -3889, -3889, -3889,  2317,
    2582, -3889,  1720,  2099,    14,  2211, -3889, -3889,  1937, -3889,
    2216, -3889, -3889,   533,  2217,  1699, -3889, -3889,  7649, -3889,
    2964,  1457,   191, -3889, -3889, -3889,  1891, -3889,   -90, -3889,
   -3889,  1720, 16986, -3889,  2843,  2700,  2703, -3889, -3889, 17032,
   -3889,  2712, -3889, -3889, -3889, -3889, -3889,  2971,  2655, -3889,
   -3889, -3889,  1993, -3889,  1919,  2800,  2717,  2800,  2658,  2716,
    1438, -3889, -3889,  1720,  1438, 16986, -3889, -3889,  1080,   195,
    1721, 19263, -3889,  2786,  2719,  2786,     6, -3889, -3889, -3889,
     173,   112, -3889,   775, -3889,  2338,  2394,  1776,  1803, -3889,
   -3889, -3889, 13879,  1803,  2922,  1891,  1855,  1855,  1891,    60,
    2147,  1891,  3058,  2515, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,   170, -3889,  1210, 10229,  1720, -3889,
    2214,  2214,  1552,  1888, -3889,  1888,  2214,  1888,  1888,  2214,
    1888,  1888, -3889,  2922,  2269,  2269,  2419,  1888, -3889, -3889,
   -3889,  1556, -3889, -3889, -3889, -3889,  1086, -3889, -3889,   656,
   -3889, -3889,  -391,  2314,  2167,  2167,    98, -3889, -3889,  2390,
    2054, -3889, -3889, -3889, -3889,  3014, -3889, -3889, -3889,  2532,
   -3889, -3889, -3889, -3889,  2532,   303, -3889,  1891, -3889, -3889,
   -3889, -3889, -3889,  1891, -3889, -3889,  1891, -3889,  1891, -3889,
   -3889, -3889, -3889, -3889,   289, -3889, -3889, -3889,    93, -3889,
   -3889, -3889, -3889, -3889, -3889,    41, -3889, -3889, -3889,  3092,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2669,  2332,   332,
   -3889,  2959,  1594, -3889, -3889, -3889, -3889, -3889,  2054, -3889,
   -3889, -3889,  2146,  2151, -3889, 19734,  2054,  2674,  2315,  2320,
    2540, -3889, -3889, -3889, -3889, -3889, -3889,  2604, -3889, -3889,
   -3889, -3889, -3889, -3889,   737, -3889,  1720,   212,  1714,  2270,
     265,  2271, -3889,   377, -3889,   878, 19734, -3889, -3889,   445,
    2274,  2278,  2281,   403, -3889,  1937, -3889,  2283, -3889,  1720,
     464,  2288, -3889,  2269,  2752,  1959, -3889,   -16,    -9,  1116,
    1844,  2289,   510, -3889,  2292,  2539,  1244,  1244, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2329,  2431,
    2294,   -23, -3889, -3889,  1394,  3105,   814, -3889, -3889,  2430,
    2457, -3889,  1707,  1891, -3889, -3889,  1536, -3889, -3889,  2350,
      42, -3889, -3889, -3889,  2708, -3889, -3889, 16986, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,    90, -3889, -3889,  5572, -3889,
   -3889,  5423,   882, -3889, -3889, -3889, -3889,   -37, -3889,  1891,
   -3889,   600,   882, -3889, -3889, -3889, -3889,    53,  1891, -3889,
   -3889, -3889,  5507, -3889, -3889,  1395, -3889, -3889,  1937,  1720,
   -3889, -3889, -3889, -3889, -3889, -3889,  1599,  2772,  1959,  2778,
   -3889,  9620,  2559, -3889, -3889, -3889, -3889, -3889, -3889,  2190,
    1293, -3889, -3889, -3889, -3889, -3889,  1980, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2819,   973,
     224,  2008, -3889,   219, -3889,  2214, -3889, -3889, -3889, -3889,
   -3889,  2891, -3889,  1980, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  2469,  1980, -3889, -3889, -3889,  1720, -3889, -3889,  1720,
   -3889,  1720,  1720,  1720, -3889,  1658,   214, -3889, -3889,  2473,
   -3889, -3889,   250,  1443,  2924, -3889, -3889,   792, -3889, -3889,
   -3889, -3889, 16313, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  1116,  1116,  1959,  2794,
    2099,  2317,  1917,  2760,  7108,    37, 10106,  1720,   -23,  2319,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1993,
    2626,  1720, -3889, -3889, -3889, -3889,  1720,   330,   666,  2465,
   -3889,  1993,    57, 19734,  2595,  1600,   956, -3889,  2269,   737,
    2592, -3889, -3889, -3889, 16986,  1699,  1699,  1699,  1699,  1699,
    1699,  1699,  1699,  1457, -3889,   161,    42,   967,  -203, -3889,
    2971, -3889,  1720,  1720,  1959,  2803,  1658, -3889,  3161,  1720,
    1397, -3889, -3889,  2317,  3166,  2706,  2268, -3889, -3889,  1720,
   -3889,  1720, -3889, -3889, -3889,  2243, -3889, -3889, -3889,  2246,
   -3889,  2391,  2391, -3889, -3889, -3889, 19263, 18512,  1721, -3889,
   -3889,  1720, -3889,  2481,  2936,  2329, -3889, -3889, -3889, -3889,
     775, -3889,  2458,  1891,  3058,  3782, -3889,  2267, -3889,  2822,
    1720,  1084, -3889,  2259,  1891,  1891,  1891,   512,  2260,  2482,
    1720,   215, -3889,  2264,  1720,  3169,  2266,  2779,  1079,  1980,
    1891,  1891,  1738,   398,  2261, -3889, -3889, 17440, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, 11868, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
    3782, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  1158,   892,  1362,  2835, -3889,  2329,   167,  1217,  1217,
    2262,  1376,   846,  2329,  2284,  1891, -3889, -3889, -3889,     9,
     667, -3889, -3889, -3889,   974, -3889,  7288, -3889,  1888,  1888,
   -3889, -3889,  2214, -3889,  1888,  1888,  1888,   938,  1888, -3889,
    1888,  1556, -3889,  2058,  1891,  1891,  2272, -3889,  2433, -3889,
    2524,  2583,  2583, -3889, -3889, -3889,  2753,   144,   144,   765,
   -3889, -3889, -3889, -3889, -3889, -3889,  2149,  1720,  1858, -3889,
   -3889, -3889, -3889, -3889,   951,   951, -3889, -3889, -3889, -3889,
     951,   951,   303,   951, -3889, -3889, -3889,  1891,   792, -3889,
     792, -3889,   303,  2760,  1891,  2372,   681,  2750,  2750, -3889,
   -3889, -3889,  2054, -3889, -3889, -3889, -3889, -3889, -3889,   204,
   -3889, -3889, -3889, -3889,  2189, 18637,  2029, 18694,  2029, -3889,
    2382,  2029, -3889,  1720,  2029,  2029,  2029, 19734,  2029,  2189,
     906,  2029,    -3, -3889, -3889, -3889,  2663,  2456,   344,  2861,
    1959, 19113,  2029,  2029,   491, -3889,  2431, -3889,  1116, -3889,
   -3889, -3889,  2656, -3889, -3889, -3889, -3889, -3889,  2699, -3889,
   -3889, -3889,   353, -3889, -3889, 19263, -3889, -3889, -3889, -3889,
    2672,  2809,   883,  2127,   759, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,   951, -3889, -3889,   951, -3889,
   -3889, -3889, -3889,    -4,  2985,   951,   792,   792,   951, -3889,
   -3889, -3889,  4153,  4153, -3889,  1116, -3889,  1116, -3889, -3889,
   -3889, -3889,  3216, -3889,  2404,   106,  9620, -3889, -3889, -3889,
   -3889, -3889,  3149, -3889, -3889, -3889,  2908,   973,  2950, -3889,
   -3889, -3889,  1720, -3889, -3889, -3889,  2998,  2327,  1631,   256,
    2328, -3889, -3889, -3889, -3889, -3889,  2408, -3889, -3889,  1937,
   -3889,  3158, -3889, -3889, -3889,  1876, -3889,  1658,  4031, -3889,
   -3889, -3889,  2497, -3889, -3889,  2674,  1082, -3889, -3889, -3889,
   16986, -3889,  1116, -3889,  1116,   281,  1888, -3889,  1720, -3889,
   -3889,    52, -3889, -3889, -3889,  3245, -3889,  2896, -3889, -3889,
   -3889,   416,   226, -3889, -3889, -3889,  2705,  1438, -3889,    42,
   -3889,  1685,  1720,  2572, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,   176, -3889, 16986, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,    59, -3889,
    1720, -3889, -3889,  1610, -3889, -3889, -3889, 19263,  -182,  2653,
   16471,  2189,  2189, -3889,  1116,  2425, -3889,  2684, -3889, 19734,
   -3889,  3059,  2453, -3889,   666, -3889,   976, -3889, -3889, -3889,
   -3889,  3099,    28, -3889, -3889, 10263, -3889,  2246, -3889, 16986,
   16986,  1714, -3889,  1756,  3099,  2761,  2361, 19734,  2437, -3889,
    3182,   112, -3889,  2547, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2455, -3889, -3889,
    3782, -3889,  1891, -3889,  2461, -3889, -3889, -3889,  2330,   292,
   16673,  1116, -3889, -3889, -3889,  3093, 11135, -3889, -3889,  2435,
   -3889,  3198,  2416,  2459,  1504, 11135, -3889, -3889,  1720, -3889,
   -3889, -3889, -3889, -3889,  2354,  6396,  1116,  2441,  3782,  2441,
    3782,  2941,  2261, -3889, -3889, -3889,  -289,  -266,  1176,  1298,
    1365,  3294, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  5401, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  4013, -3889,  3272, -3889,
    2971, -3889,  2506,  2555,  2555,  2363, -3889,  3782, -3889,  2468,
    2958, -3889, -3889, -3889,  2262, -3889, -3889, -3889, -3889, -3889,
   -3889,  2844,   134,  2760,  1367,  1891, -3889, -3889,  1891, -3889,
   -3889,  2147,  2674,  2239,  1980, -3889, -3889, -3889, -3889,  2561,
    2674,  1891,  3197,   311,   -99,    27,  2099, -3889, -3889,  1891,
    1891, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
    2526, -3889,  2845, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2567,  3258,  1217,
    1888,  1888,  1888,  1888,  1888,  1888, -3889,  2710, -3889, -3889,
    3302, -3889, -3889, -3889, -3889, -3889,  1961,  2632, -3889, -3889,
    2204,  2202, -3889,   158, -3889,  1215,  -296,   158, -3889, -3889,
     173, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,   883, -3889,  2050, -3889,
   -3889,  1720,   956, -3889, -3889,  2483, -3889, -3889, -3889,  1891,
     793, -3889, -3889,  -146, -3889, -3889, -3889, -3889,  2029, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  2970, -3889, -3889, -3889,
    2963, -3889, -3889, -3889, -3889, -3889, -3889,  2965, -3889, -3889,
    1807, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1919,  3109,
   -3889,  1447, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
     882,   882,   882,   882, 16986, -3889,   759, -3889,  6820, -3889,
   -3889, -3889, -3889,  2269, -3889, -3889, -3889, -3889, -3889, -3889,
    2117,   951,  2832, -3889, -3889, -3889, 10551, -3889, -3889, -3889,
     232, -3889, -3889, -3889, -3889,  5654, 10551,  1959,  2657,  1959,
    2659,  9620, -3889, -3889, -3889, -3889, -3889,  3216,   973, -3889,
    2660, -3889,   491, -3889, -3889, -3889, -3889,  1631, -3889,  3093,
   -3889, -3889,  1980, -3889,   491, 19734, -3889, -3889,  3244, -3889,
    2120, -3889, -3889,  4031, -3889,  2120,  2990,  2991,   206, -3889,
   -3889,  2749, -3889, -3889, 16830,  1959,  2754,  2754,  2767, -3889,
    2006, -3889,  3080, -3889, -3889, -3889,  1720, 16986,  2214,  2870,
    2912, -3889,   934, -3889, -3889, -3889,   -54, -3889, -3889, -3889,
    3157,  2817, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2876,
   -3889, -3889,  2893, -3889,  2269,  2269, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889,  1714, -3889, -3889, -3889,  2797,  2503,  1891,
   -3889, -3889, -3889,  -146,  2970,  1959,   491,  3161, -3889,  2760,
    3099,  2760,  -182,  1755, -3889, -3889,  2164,   159,  2760, -3889,
    2850,  3143, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,  2099,  2729, -3889,  2464, -3889, -3889,   170,   112,
   -3889,   112,   775,  2627,   323,   277, -3889,  2628,  1720, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,  1116, -3889, -3889, -3889, -3889, -3889, -3889, 14993,
    2895, -3889, -3889,  2760,  3009,  2537,  2329,  2537,  2329,  2214,
     -89, -3889, -3889, -3889, -3889, 10749, -3889, -3889, -3889,  2698,
   -3889, -3889,  2259,  2899,  1891,  4013,  4071,  3058,  3782, -3889,
    3152, 19690,  3284, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  3903,   -98, -3889, -3889,
   -3889,  2906, -3889,   883,  1139, -3889, -3889,  3197, -3889, -3889,
   -3889,  3782, -3889,  2329,   156,  1720, -3889, -3889, -3889, -3889,
    2329, -3889,  2000, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,   897,   897,  1891,  1891,  2674,  1798, -3889,  1891,  1604,
    1891,  1891,  1891,  1891, -3889,  2591, -3889,   281,   846,  2329,
    1891,  2147,  2806, -3889,  2631,   846,  1888, -3889,  2329, -3889,
    1556,  1689,  1515, -3889, -3889, -3889, -3889,  1961,   141, -3889,
   -3889, -3889,  3151, -3889, -3889, -3889,  1891,  2616,  2804, -3889,
   -3889, -3889, -3889,  3176, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,   956, -3889, -3889, -3889,  2982,  3173, -3889,  2268,
   -3889, -3889, -3889,  4153, 16986, 16986, 16986, 16986, -3889, -3889,
   -3889, -3889, -3889,  1720, -3889,   882, -3889, -3889, -3889, -3889,
    2552,  1243, -3889, -3889,  1116, -3889,  1116, -3889, -3889, -3889,
    3303, -3889,   392, -3889, -3889, -3889, -3889, -3889,  3305,  3191,
    2120, -3889, -3889,  2120,   491,  2548,  2548, -3889,  3393,  3341,
   -3889, -3889, -3889,  2774,  1888,    69,   283,  1720, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,   162, -3889, -3889, -3889, -3889,
   -3889,  2872, -3889,   840, -3889, -3889,  2877,  1343, -3889, -3889,
   -3889,  3317,  2932, -3889,  1891,  1281, -3889, -3889,   980,  2943,
    2944, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  1888,  1888, -3889, -3889, -3889, -3889, -3889, -3889,  1720,
   -3889,  3173, -3889, -3889, -3889,  1720, -3889,  1720, -3889, -3889,
   -3889, -3889, -3889,  2863,  3135, -3889, -3889, -3889, -3889,  5440,
   -3889,  8829,    73,  1720,  2850,  2269,  2615, -3889, -3889, -3889,
     152,  1433,  2796, -3889, -3889,  2584, -3889, -3889, -3889, -3889,
     775, -3889,  2673, -3889, -3889, -3889,   171,  2580, -3889,  2269,
   -3889,  3782, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   14993, -3889,  3113, -3889, -3889, -3889,  2589,  2489,  2329,  2593,
   -3889,  3221, -3889,  3222, -3889,  1720,  2675,  2494, -3889, -3889,
   -3889,   175,  2864,   192,   577, -3889, -3889, -3889, -3889, -3889,
    2799,  2441,  2598, -3889, -3889, 19690, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,  1121, -3889, -3889,  2969, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,  2537,  3193, -3889, -3889,  2664, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1720,   238,  2849,
      96, -3889, -3889, -3889, -3889,   566,  1720,  1891, -3889, -3889,
    4276, -3889,  1720, -3889, -3889,   846, -3889,  1720,  1720, -3889,
   -3889, -3889, -3889,  2849,  1552,  1720,  1891,  1720, -3889,   846,
    2611, -3889, -3889,  2930,  3429,   404, -3889, -3889,   122,  1407,
    1891, -3889, -3889,  2504, -3889, -3889, -3889, -3889,   956,  2982,
    -146,  1196, 10551, -3889, -3889, -3889, -3889, -3889,  1720,   882,
   -3889, -3889,  -146,  -146,   973, -3889, -3889, -3889, -3889, 16986,
   -3889, -3889, -3889,  2120, -3889, 16986, 16986, -3889, -3889,  1891,
    1888,  1888,  2823, -3889, -3889,   664,   167, -3889, -3889,  2866,
   -3889, -3889, -3889, -3889, -3889, -3889,  2742, -3889, -3889, -3889,
   -3889,  8172,  2562, -3889,  1720, -3889, -3889,  2705,  1438, -3889,
   -3889, -3889, -3889, -3889, -3889,  -146, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, 16986, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  2615,  1720,  1720,  1599,  2945,
     152, -3889,   179,  2519, -3889, -3889,  1891,  1576, -3889, -3889,
   -3889, -3889,  2617, -3889, -3889,  2528,  1891,  1720, -3889, -3889,
   -3889, -3889, -3889, -3889,  2329,  3055,  2214,  2214,   361, -3889,
    1891, -3889, -3889,  2269, -3889, -3889,  2306,   220,  3118, -3889,
    3177, -3889,  2899, -3889,  2441, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,   846,
     846, -3889, -3889, -3889, -3889,  3120,  3260, -3889,  2468,  2329,
   -3889, -3889, -3889, -3889, -3889,  1720, -3889, -3889, -3889, -3889,
    3112, -3889, -3889, -3889, -3889,  3471, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889,   309,  1664, -3889, -3889, -3889, -3889, -3889,
     120,  -297, -3889, -3889, -3889,  1720,  1401,  1891,  2677,   846,
    1891,  1891, -3889,  2390, -3889, -3889, -3889,  1126,   730,   173,
   -3889,  2678,   956, -3889,   893,   228, -3889, 16986, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,   -23,  1888,  1891,  1891,  1891,
     167, -3889, -3889, -3889, 19734, -3889, -3889, -3889, -3889, 10263,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1720, -3889,  1891,
    1720, -3889, -3889, -3889,  1891,  2976, -3889, -3889, 19734, -3889,
   -3889, -3889,   -23, -3889, -3889, -3889, -3889, -3889, -3889,  2186,
   -3889, -3889, -3889, -3889,  1988,  2859,  3290,  1241,  2840,   383,
   -3889, 10263, -3889,   323, -3889, -3889,   361,  1720,  1720,  2971,
   -3889,  3090, -3889,  1443,  2674,  1910,  2329, -3889, -3889,  2919,
   -3889, -3889, -3889,  1720, -3889, -3889, -3889, -3889, -3889,  3463,
    2214, -3889,  2849, -3889,  -297,  1720,  1994, -3889, -3889, -3889,
   -3889,  1720, -3889, -3889, -3889, -3889, -3889,  1891, -3889,  2897,
   -3889, -3889, -3889,   817,  -120,   817, -3889,   167,   846, -3889,
   -3889, -3889,   775, -3889, -3889,  3004, -3889,   266,   956, -3889,
   -3889, -3889, -3889,  2942,   724, -3889,  2269, -3889, -3889, -3889,
   -3889, -3889,  1720, -3889, -3889,   -23,   167,   167, -3889, -3889,
    1937, -3889, -3889,  1599, -3889,   423, -3889, 19734,  2269,  2633,
   -3889, -3889,  2814,  2722,  2679,  1988, -3889,    50,  2214, -3889,
   -3889, -3889,   756, -3889, -3889,  9108, -3889, -3889,   383,  2681,
   -3889, -3889, -3889,   361, -3889, -3889, -3889, -3889,  1891,  1443,
   -3889, -3889, -3889,  1720, -3889, -3889,   846,  1720,  3260,    13,
   -3889, -3889, -3889, -3889, -3889,    13, -3889,  1720,  1720,  1246,
   -3889, -3889,  2790, -3889,  3017, -3889, -3889, -3889, -3889, -3889,
   -3889,  2743,    24, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  1720, -3889, -3889,  1689,  1515, -3889, -3889, -3889,  3000,
    1720,  2269,  2707,  1599,  1720, -3889,   211,  1888,  2683, -3889,
   -3889, -3889, -3889,   205,   463,  1159,  1881,  2682,  2842,  2685,
   -3889, -3889,  2272, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  2897,  1209,  1891, -3889, -3889, -3889, -3889, -3889,  2940,
   -3889, -3889,  1891, -3889, -3889,  3005,  3502,  1891, -3889,  1720,
   -3889,  1891,  1720,   260, -3889, -3889, -3889, -3889, -3889,  2894,
   -3889,  1888,  1818,   205, -3889, -3889,   121,  3086,  3088,  3310,
    3078, -3889,   463, -3889,  2223,  1299, -3889, -3889, -3889,  3772,
   -3889, -3889,  2272, -3889,  2727, -3889,  3298,  1720,   -68,   303,
    3331,  1891,  1891, 19734, -3889,   492,  1720, -3889,  1891,  1629,
     946,   260, -3889, -3889,  1599, -3889,  2214, -3889, -3889, -3889,
    2967,  1720, -3889,  1891,  2966,  1720,  1891,  1891,  1891,  1891,
   -3889,  3106,    83,  3107, -3889,  3095, -3889,  2417, -3889, -3889,
    1720,  3373,  1846,  3114,   174,  3115,  3100, -3889,  1636, -3889,
   -3889,  1720,  2730,   294, 18000,   792, -3889, -3889, -3889,  2618,
   -3889, -3889, -3889,  1880, -3889, -3889,  1129, -3889, -3889,   167,
     167, -3889, -3889, -3889,  2057, -3889, -3889, -3889,  2057,  2057,
   -3889, -3889, -3889, -3889, -3889, -3889,  2973, -3889, -3889, -3889,
     903, -3889, -3889,  1720,  2329, -3889,  1720,  1720,  1720,  1720,
    1891,  1891,  1891,  1891,  1891, -3889,  1720,  1891,  1891,  1891,
    1891,  1891,  1891,  1891,  1891,  1891,  1891,  1891, -3889,  1720,
    1891,  1043,  1955, -3889,  1891, -3889, -3889, -3889, -3889,   837,
   -3889,  2532,  2532,  1891,   882,   600,  1891,  2787, -3889, -3889,
   -3889, -3889,  2532,   882, -3889,  3315,  2329, -3889,  3443, -3889,
   -3889,   882, -3889, -3889,  1720, -3889, -3889,  1720,  1891, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  1838, -3889, -3889, -3889,
   -3889,  3192,  2532, -3889, -3889, -3889, 11772,   164,  1129, -3889,
   -3889,   173, -3889, -3889, -3889, -3889, -3889, -3889,   946, -3889,
   -3889, -3889, -3889, -3889,  1888, -3889,  2537, -3889, -3889, -3889,
   -3889,  1720,  1720,  1720,  1720,  1720,  1720,  1720,  1720,  1720,
    1720,  1720,  1720,  1720,  1720,  1720,  1720,  1720,  1720,  1720,
   -3889, -3889,  1217,  1217,  2182, -3889, -3889, -3889, -3889,  3194,
    3435,   -44,   951, -3889, -3889, -3889,  1891, -3889,  1891,   951,
     792, -3889, -3889,   951, -3889, -3889,   951,  2537,  1891,   792,
   -3889, -3889, -3889,  1937, -3889, -3889, -3889, 11772,  1838, -3889,
   -3889, -3889, -3889, -3889, -3889,  3090, -3889, -3889, -3889, -3889,
   -3889,  1720, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889,  1720, -3889, -3889, -3889,  1217,  1217,   992,
     111, -3889,  1891, -3889, -3889,  1720,  1720, -3889, -3889, -3889,
    1098,  1098, -3889, -3889, -3889, -3889, -3889,   438, -3889,   883,
   -3889, -3889, 18363, -3889, -3889, -3889,  1720,  1720, -3889, -3889,
   -3889, -3889, -3889,  1368, -3889, -3889, -3889,  6425, -3889,   883,
    1720, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
     951, -3889, -3889,   951, -3889, -3889, -3889, -3889, -3889,  1720,
   -3889,  2279,   996,  1018, -3889, -3889,   992,  1043, -3889, -3889,
   -3889, -3889, -3889,  1720,   307,  1891,  1891,  2251,  1891, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  1768, -3889, -3889, -3889,
    1720, -3889, -3889,  1891,   992,   992, -3889,  3180,  1891,  1891,
     992,  3077,  1720,   992, -3889, -3889, -3889,   992,   992, -3889,
   -3889, -3889, -3889,  3159,  2109,  3058,  1891,  2329, -3889,  1891,
    2269,   -80, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  3782,
   -3889, -3889, -3889, -3889, -3889, -3889,   218, -3889, -3889,  1114,
   -3889,  1033, -3889, -3889, -3889, -3889, -3889,  2109,  1720, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  1217, -3889,  2023,  2593,
   19690, 19690,  2869,  3782,  3045,  3045,  2368, 10263, -3889, -3889,
    1114,  -125, -3889, -3889, -3889,  2329,  -125, -3889,   310, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  2329, -3889,  2537,  2189,
   19375, -3889, -3889,  1865,  1929, -3889, -3889,  2060, -3889, -3889,
   -3889, -3889,  1046,  1046, -3889, -3889, -3889, -3889, -3889,  1118,
    1118,  3045,  3045, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  1217, -3889, -3889,  3222, -3889,  2214,  1720, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,   -43,   203, -3889,
   -3889, -3889,  1118, -3889, -3889,  2975,  2979, -3889,  2777,    61,
   -3889,  2993, -3889,  2993, -3889,  2993, -3889,  2993, -3889, -3889,
   -3889,  2329, -3889, -3889, -3889, -3889,  2984, -3889, -3889, -3889,
   -3889, -3889, -3889
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,    14,     1,     3,     5,    36,     4,    79,    35,
       0,    53,     0,    15,   102,  3227,    58,    57,    53,     8,
      10,    11,    12,    13,     0,    54,    55,    82,   104,    50,
     107,     0,   103,  3226,    37,     9,    61,    59,     0,    79,
       0,    79,     0,  3320,    80,    88,   490,   109,   285,   111,
       0,   108,  3227,    39,     0,    18,     0,     0,  3227,  3321,
       0,     0,    90,   492,    51,   495,     0,   491,   284,   101,
       0,   287,     0,     0,     0,  3387,  3320,  3320,  3320,     0,
       0,  3227,  3227,  3320,  3227,  3227,  3282,   197,   281,   196,
       0,   106,   112,   113,   115,   116,   119,   117,   118,     0,
     176,   179,   194,   180,   181,   247,   182,   184,   183,   187,
     185,   186,   188,   189,   190,   191,   192,   193,  3227,   105,
      40,    38,    64,    63,    67,    22,    16,    19,    20,    67,
      24,    17,    56,    84,    85,    86,    87,    83,  3351,  3320,
      95,  1514,   494,     0,   497,  3227,  3227,  3227,   289,  2925,
    2924,   207,   244,  3320,  3388,  3320,     0,     0,     0,  3320,
    3320,   128,   160,     0,   122,   174,  3283,     0,  3300,  3320,
     268,   114,   178,   175,   177,  3320,     0,   249,   110,     0,
       0,  3320,     0,    21,  3320,     0,  3352,  3320,     0,     0,
    3227,  1509,    52,  1508,  1568,  3227,   488,   493,   286,   288,
     434,   213,  3301,  3320,     0,     0,     0,  3033,   277,  2913,
     275,   280,     0,     0,   130,   162,   279,   124,   640,   258,
     259,  3320,     0,     0,     0,  3042,  2430,  2429,   195,   201,
     204,  3366,  3320,     0,   378,   377,   375,   376,   374,   248,
       0,    68,     0,     0,    66,    65,  3227,    62,     0,  3227,
       0,    92,    94,    93,    91,  3320,    81,     0,     0,     0,
     496,   503,   504,   620,   498,   623,     0,  3227,   291,   290,
     283,   437,   208,   209,   211,     0,     0,   245,   246,   278,
     273,  3447,  3448,     0,   267,     0,  3281,  3394,  3377,  3320,
     156,   129,  3376,   134,   136,   137,   138,   139,  3376,     0,
    3284,     0,     0,   161,     0,   165,   123,   126,   260,     0,
    2926,   250,   251,  3325,   254,   282,     0,  3052,  3059,  3053,
    3051,  3049,  3054,   271,  3050,   269,  3060,   270,  3055,  3057,
    3366,  3369,  3368,     0,     0,   198,   202,    42,    60,    71,
      74,  3227,    78,    77,  3376,    72,    73,    23,  3227,    25,
    3133,  3134,  3135,  3136,  3137,  3138,  3139,  3140,    89,     0,
    1510,  3255,     0,  1639,  1753,  1763,  1771,  1778,  1836,  1844,
    1864,  1859,  1865,  1874,  1870,  1882,  1892,  2024,  2033,  2035,
    2042,  2169,  2075,  2089,  2102,  2105,  2108,  2114,  2116,  2127,
    2149,  2153,  2157,  2214,  2232,  2234,  2240,  2244,  1636,  2250,
    2284,  2311,  2313,  2318,  2348,  2349,  2365,  2368,  2369,  2374,
    2383,  2384,  2402,  2419,  2460,  2478,  2497,  2516,  2532,  2540,
    2544,  3254,  2548,  2551,  2554,  2571,  2611,  2627,  3256,  1570,
    1571,  1572,  1573,  1574,  1575,  1576,  1577,  1579,  1578,  1580,
    1582,  1581,  1583,  1584,  1585,  1586,  2036,  1587,  1588,  1590,
    1591,  1592,  1593,  1594,  1595,  1596,  1597,  1598,  1599,  1600,
    1589,     0,  1601,  1602,  1603,  1604,  1605,  1606,  1607,  1608,
    1609,  1610,  1611,  1612,  1613,  1614,  1615,  1616,  1617,  1618,
    2385,  1619,  1620,  1621,  1622,  1623,     0,  1624,  1625,  1626,
    1627,  1628,  1629,  1630,  1631,  1632,  1633,     0,  1634,  1635,
    1547,  1569,   619,     0,   565,   499,  3109,     0,  2895,   500,
     436,  3126,     0,   464,  3361,   447,   435,     0,   440,   442,
     443,   455,   444,   445,  3320,  3320,   214,   215,  3047,   247,
     263,   265,  3048,  3419,   272,     0,  3034,   276,  3395,  3320,
       0,   133,   135,   131,   157,  3376,  3320,  3285,   141,     0,
       0,   172,    67,     0,    67,     0,   163,   166,     0,     0,
     261,   252,  3327,  3326,   255,     0,  3056,     0,     0,  3367,
     205,   199,   200,   203,    45,    41,    47,    76,    26,    70,
      75,    29,    97,    98,    99,   100,    96,  1788,  3151,  3152,
    3153,  3154,  3155,  3156,  3157,  3158,  3159,  3160,  3161,  3162,
    3163,  3149,  3203,  3204,  3205,  3206,  3207,  3208,  3209,  3210,
    3211,  3212,  3213,  3214,  3215,  3216,  3217,  3218,  3219,  3220,
    3221,  3222,  3223,  3224,  3225,  3164,  3165,  3167,  3166,  3168,
    3169,  3170,  3171,  3172,  3173,  3174,  3176,  3175,  3177,  3178,
    3179,  3180,  3181,  3182,  3183,  3184,  3185,  3186,  3187,  3188,
    3189,  3190,  3191,  3192,  3193,  3194,  3195,  3196,  3197,  3147,
    3198,  3199,  3200,  3201,  3202,  1638,  3148,  3150,  1671,     0,
    3030,     0,  1788,     0,     0,     0,  1867,     0,     0,  1887,
    1936,     0,  1887,  2773,     0,  2079,  2091,     0,     0,  3410,
    2098,     0,     0,     0,     0,  2160,     0,     0,     0,     0,
       0,  2255,  2760,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2519,     0,  2542,     0,     0,     0,
       0,     0,     0,     0,  1788,  2215,  2227,  2387,     0,  2500,
    2512,  2515,  2498,  2513,  2765,  2514,  2501,  2510,  2502,  2511,
    3014,  3018,  2628,  2680,  1568,     0,   564,     0,   965,   675,
       0,     0,   625,     0,     0,   629,   630,   628,     0,  3244,
    3246,  3231,  3245,  3230,  3232,   502,  3233,   505,     0,  3127,
       0,  3361,  3410,  3410,  3359,  3361,  3361,  3410,  3361,  3361,
    3410,  3361,  3361,  3298,  3362,  3296,     0,   448,   449,   450,
    3263,     0,  3242,  3241,  3243,  3240,  3228,   441,   438,  3229,
       0,     0,   262,   264,     0,     0,     0,   150,   132,  3035,
     142,   167,   168,   171,   173,   169,   170,   164,   125,     0,
    3043,   253,   256,  3058,   206,  3320,    48,     0,   475,   475,
    1793,  1796,  1795,  1790,  1791,  1794,  1792,  1782,  1789,  1670,
    3033,  1751,  1641,  1683,     0,  3349,  1669,  3359,  3085,  3083,
    3086,     0,  3079,  3087,     0,     0,  3093,  3464,  3465,     0,
    2878,  2880,     0,     0,     0,  3082,  2948,     0,  2882,  3084,
    3088,  3089,     0,     0,  3081,  3093,  3080,  1761,  2942,  1759,
    2934,  2937,     0,  2936,  2940,  2941,  3090,     0,     0,  2949,
       0,     0,     0,     0,  1764,     0,  2859,  2869,  2871,  2875,
    2958,     0,  2877,  2955,  3115,  3031,  2956,  2957,  2910,  1772,
    1773,     0,  2906,  2908,  2907,  1834,  2760,  1839,  2986,  1843,
    1837,  1838,  1840,  1842,  2985,  1855,  1845,  1846,  1847,  1850,
    3359,  1862,  3025,     0,  2884,  3129,  2929,  3024,  3029,  2930,
    1868,  1866,     0,  1880,  3380,  3288,  1871,  3019,  1873,  3404,
       0,  1889,  1891,  1883,     0,  1933,  1967,  1966,  3059,  3276,
    1913,  1965,  1958,  1964,  1957,  2022,  2705,  2932,  1908,  1910,
    1900,  1901,  1914,     0,  1902,  1903,  1954,  1904,  1905,  1967,
    1907,     0,  2936,     0,  2031,     0,  2034,  2049,  2048,  2073,
       0,  2045,  2047,  2772,  3320,     0,  2162,  2163,  2164,  2080,
    2076,  2081,  2093,  2097,  2095,  2098,  2096,  2090,  2103,  2104,
    2927,  2106,  2107,  3411,  2109,  2904,  1821,     0,  1820,     0,
    2115,  2771,  2121,  2770,  2128,  2130,  2897,  2150,  2151,  1201,
    1973,     0,     0,  2154,  1200,  2161,  2158,     0,  2233,  2464,
    3006,  3007,  3124,     0,  2238,     0,  2241,     0,  2248,     0,
    1637,  2256,  2251,  2252,     0,  3305,  2285,  2297,     0,  2896,
    2312,     0,  2314,  2316,  2346,  3121,  2363,     0,  2366,  2614,
    2887,  2372,  3380,     0,  2381,  2888,  2614,     0,  2403,     0,
    2405,  2408,     0,     0,  2900,  2420,  2421,  2422,  2423,  2424,
    2425,  2451,  2426,  2454,  2427,  2428,     0,     0,  2898,     0,
       0,  3005,  3029,  2461,  2495,  2483,  2530,     0,     0,     0,
       0,  2538,     0,  2543,  2541,  2545,  2546,  2549,  3282,  3009,
    2552,  3382,  2988,  2569,  2557,  2987,  2989,  2572,  2573,  2625,
    2614,     0,     0,  2037,     0,     0,     0,  2399,  2391,  2890,
    2503,  2764,     0,  3016,  3017,     0,     0,  1554,     0,  1555,
    1548,     0,  1549,  1550,  1553,     0,  3249,  3247,  3251,  3250,
    3248,  3252,  3253,  3237,  3238,   621,  3239,  3227,   964,     0,
     969,   676,   673,   678,     0,     0,   626,     0,   637,   638,
     631,   639,   634,   635,  3320,  3128,   292,     0,     0,     0,
    3360,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3299,  3402,  3297,     0,   349,   472,   350,  3264,  3300,   439,
     220,   219,   240,   236,  3035,   241,   225,   239,   237,   217,
     218,   238,   210,   216,   227,   228,   230,   222,   223,   224,
     212,   221,   266,   274,     0,   153,   155,   154,   151,   152,
    2918,     0,  3300,   127,   257,     0,  3320,    43,   476,    27,
      30,  1783,  1516,  1752,  1640,  1683,  3271,  3273,  1688,  3320,
    1667,  1684,  1685,  1687,  1689,     0,     0,  3290,     0,     0,
    3350,     0,     0,     0,     0,     0,     0,     0,  3090,  3099,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3090,
    1762,  1754,     0,     0,  2935,  2943,  2944,  2945,     0,  3065,
       0,     0,  2874,  2873,     0,  2872,  3117,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2959,
    2960,  2961,  3116,  1767,  1774,  1776,     0,  1835,  1779,  1799,
    1841,     0,  1850,  3460,  3461,  1848,     0,  1851,     0,  1863,
    1860,  3442,  3441,  2885,     0,  3131,  2886,  3027,  3028,     0,
    2705,  1878,  1881,  1875,  3381,  2331,  3289,  1872,  3020,  3405,
    1888,  1890,  1885,  1914,  1968,     0,  3277,     0,  2023,  1893,
    3430,  1565,  3429,  1898,  2711,  2708,  1565,  1909,  1906,  2933,
    3418,     0,  1935,     0,  1969,     0,  2705,  2705,  2705,  2705,
       0,  2032,  2025,     0,     0,  2074,  2043,  2773,  2060,  2044,
    2051,  2052,  1565,  2789,  2791,  2794,  2792,  2793,  2795,  2796,
    2797,  2798,  2787,  3321,  2829,  2790,  2782,  2786,  2784,  2785,
    2781,  2783,  2774,  2775,  2788,  2777,     0,     0,  2171,  2170,
    2082,  2077,  2094,  2092,  2928,     0,  2112,  3423,  2100,  2099,
    2122,  2123,  2132,     0,  2152,  1972,  1282,  1311,  1279,  1361,
    1296,  1295,  1360,  1362,  1384,  1363,  1347,  1430,  1464,  1380,
    1409,  1383,  1406,  1452,  1355,  1378,  1374,  1381,  1404,  1450,
    1281,  1284,  1391,  1388,  1280,  1387,  1386,  1436,  1308,  1390,
    1309,  1465,  1313,  1373,  1402,  1399,  1426,  1417,  1454,  1253,
    1427,  1437,  1400,  1335,  1337,  1336,  1403,  1438,  1439,  1440,
    1441,  1299,  1300,  1429,  1392,  1394,  1393,  1398,  1333,  1414,
    1307,  1416,  1423,  1424,  1315,  1317,  1428,  1320,  1259,  1412,
    3306,  1358,  1334,  1306,  1276,  1435,  1275,  1278,  1277,  1433,
    1425,  1401,  1385,  1446,  1421,  1422,  1357,  1443,  1444,  1445,
    1434,  1449,     0,  1310,  1411,  1407,  1410,  1442,  1397,  1408,
    1316,  1349,  1379,  1375,  1371,  1382,  1405,  1447,  1448,  1415,
    1318,  1319,  1283,  1451,  1312,  1356,  1314,  1395,  1396,  1432,
    1348,  1350,  1252,  1321,  1338,  1359,  1431,  1463,  1389,  1372,
    1413,  1354,  1377,  1376,  3306,  1212,  1227,  1228,  1229,  1230,
    1231,  1232,  1233,  1234,  1235,  1236,  1237,  1238,  1239,  1240,
    1241,  2155,  1469,  3306,  3306,  3306,  2156,  1473,     0,  2468,
       0,  3008,  3125,  3322,  2236,  1204,  1206,  3328,     0,  2237,
    2239,  2235,     0,     0,  2249,  2245,     0,  2253,  2260,  2257,
    2259,  2258,  2261,  3359,  2299,  2910,  2991,  2762,  2762,     0,
    2295,     0,     0,  2990,  2907,   643,  2992,     0,  2761,  2317,
    2315,  2347,  2319,  3122,  3123,  3380,  2364,  2350,  2352,  2353,
       0,     0,  2367,  2373,  2370,  2321,  2889,  2382,  2375,  2331,
       0,  2404,     0,  3418,  2411,     0,  2975,  2980,  2981,  2982,
       0,  2452,  2455,     0,     0,     0,  2899,  2432,     0,  2431,
       0,     0,  3027,  2496,  2479,  2485,  3320,  2486,  2481,  2531,
    2517,     0,  2520,  2521,  2524,     0,     0,  2539,  2533,     0,
    2547,     0,  3383,  3384,  2553,  2570,  2555,  3278,     0,  2574,
    2626,  2612,  2616,  2038,  1782,  2225,     0,  2225,     0,  2399,
    2393,  2401,  2386,     0,  2393,     0,  2499,  2505,     0,  2854,
    2852,     0,  3015,  2678,     0,  2678,  2684,  1562,  1557,  1561,
       0,   623,   566,  3227,   968,     0,   972,     0,   743,  3109,
     627,   633,   775,   641,  3286,  3320,     0,     0,  3320,  3286,
    3351,  3320,  3261,     0,   506,   509,   510,   511,   512,   513,
     514,   515,   516,   517,     0,   501,     0,     0,   451,  2911,
    3361,  3361,     0,   459,  2891,   452,  3361,   453,   461,  3361,
     454,   463,  3403,  3286,  3359,  3359,     0,     0,   226,   229,
     232,     0,  3455,  3457,  3456,   140,  3037,  3036,   143,     0,
    3035,    46,     0,   120,  1505,  1505,     0,  1519,  1517,  1539,
    2692,  2995,  1700,  2993,  2994,     0,  1686,  3438,  3437,  3355,
    3440,  3439,  1698,  1699,  3355,     0,  1704,  3320,  1718,  1719,
    1720,  1706,  1708,  3320,  3291,  1709,  3320,  1750,  3320,  1711,
    1714,  1712,  1713,  1715,     0,  1744,  1745,  1722,  1724,  3379,
    1725,  1748,  1746,  1747,  1716,  3412,  1727,  1717,  1705,  3259,
    1729,  1749,  1732,  1690,  1721,  1726,  1731,     0,     0,     0,
    2968,     0,  1678,  1682,  1681,  1672,  1668,  1663,  2692,  3434,
    3433,  1660,  1650,  1652,  1653,     0,  2692,  3335,     0,     0,
       0,  1696,  1658,  1643,  1648,  1647,  1657,     0,  1666,  1645,
    1665,  1646,  2972,  2971,     0,  2947,     0,  2854,  2852,     0,
    2854,     0,  3095,  2854,  3077,     0,     0,  2879,  2881,  2854,
       0,     0,     0,  2854,  2952,  2953,  2954,     0,  2883,     0,
    2854,     0,  3078,  3359,  3025,  2714,  1760,  3029,  2930,     0,
       0,     0,  2854,  2876,  3119,  1767,  2858,  2857,  2862,  2863,
    2864,  2865,  2866,  2867,  2868,  2861,  2860,  2870,     0,  1769,
       0,     0,  2909,  1780,     0,  1797,  1857,  1849,  1854,     0,
       0,  2931,  2714,  3320,  3130,  3026,     0,  1877,  1879,  3300,
    2750,  2332,  2333,  1884,     0,  1934,  1959,  1943,  2713,  1566,
    2706,  2712,  2707,  2709,  2710,     0,  1923,  1922,  1911,  1918,
    1920,     0,  3322,  2010,  2011,  2012,  1999,     0,  2002,  3320,
    2003,  3294,  3322,  2006,  2007,  2013,  2008,  3412,  3320,  2009,
    2016,  2014,  1915,  1916,  1942,  1937,  1938,  1940,  1941,     0,
    1955,  1962,  1896,  1897,  1894,  1895,  2705,     0,  2714,     0,
    2046,     0,  2060,  2053,  2050,  2055,  2056,  2062,  2054,     0,
    2828,  2776,  2839,  2840,  2841,  2830,  3410,  2847,  2850,  2849,
    2851,  2843,  2836,  2838,  2837,  2842,  2844,  2846,  2848,  2778,
    2831,  2832,  2833,  2834,  2835,  2177,  2179,  2178,     0,     0,
       0,  1673,  2903,  2112,  2901,  3361,  2110,  2905,  3424,  2101,
    2124,  2125,  1565,  3410,  2140,  2141,  2143,  2145,  2146,  2142,
    2144,  2135,  3410,  2131,  3307,  3308,     0,  1211,  1468,     0,
    1470,     0,     0,     0,  1474,     0,  2201,  2185,  2159,  2166,
    2167,  2168,  2470,     0,     0,  3323,  3324,     0,  1205,  3330,
    3329,  3331,     0,  1247,  1370,  1331,  1274,  1290,  1341,  1260,
    1364,  1339,  1288,  1256,  1369,  1456,  1366,  1352,  1285,  1353,
    1351,  1322,  1324,  1327,  1286,  1340,  1294,  1343,  1292,  1332,
    1329,  1245,  1344,  1365,  1254,  1298,  1419,  1457,  1268,  1326,
    1262,  1269,  1289,  1261,  1345,  1459,  1346,  1257,  1305,  1460,
    1244,  1251,  1271,  1302,  1303,  1272,  1287,  1248,  1249,  1304,
    1242,  1325,  1270,  1255,  1461,  1328,  1367,  1250,  1455,  1418,
    1462,  1420,  1273,  1291,  1323,  1243,  1368,  1458,  1258,  1293,
    1301,  1267,  1453,  1265,  1266,  1342,  1330,  1263,  1264,  1297,
    1246,  1210,  1213,  1214,  1215,  1216,  1217,  1218,  1219,  1220,
    1221,  1222,  1223,  1224,  1225,  1226,     0,  2242,  2714,     0,
    3418,  2331,     0,  3304,  2297,  2287,     0,     0,     0,     0,
     652,   648,   651,   650,   649,   654,   839,   666,   662,   664,
     665,   667,   663,   841,   840,   655,  2969,   668,   669,   644,
     658,   659,   660,   653,   656,   657,   647,   646,  2298,     0,
    2321,     0,  2615,  3002,  3003,  3004,     0,     0,  2377,     0,
    2410,  2616,     0,     0,     0,     0,     0,  2453,  3359,     0,
       0,  2457,  2456,  2448,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2434,  2435,  3124,  2750,     0,  2528,  2522,
    3278,  2523,     0,     0,  2714,     0,     0,  3279,  3110,     0,
    2528,  2621,  2620,  2331,  3257,     0,  1803,  2226,  2216,     0,
    2228,     0,  2388,  3425,  3426,     0,  2395,  2400,  2392,     0,
    2504,  3398,  3398,  2855,  2856,  3039,     0,     0,     0,  2679,
    2629,     0,  2681,  2686,     0,  1563,  1552,   622,   568,   966,
    3227,   973,  1111,  3320,  3261,     0,   674,     0,   744,     0,
       0,     0,   896,  3414,  3320,  3320,  3320,     0,     0,  3385,
       0,   864,   761,     0,     0,  3268,     0,  3392,   892,  3410,
    3320,  3320,  3320,  3261,     0,   760,   632,   775,   699,   701,
     704,   702,   703,   705,   707,   706,   722,   723,   721,   708,
     710,   709,     0,   711,   712,   713,   714,   715,   716,   717,
       0,   724,   725,   726,   729,   727,   728,   718,   719,   720,
     730,     0,     0,  3268,     0,  3287,     0,     0,  3325,  3325,
       0,     0,     0,     0,     0,  3320,   560,  3262,   561,     0,
       0,   562,   507,   508,     0,   293,  3380,  2912,     0,     0,
    3466,  3467,  3361,  2892,     0,     0,     0,     0,     0,   473,
     446,     0,   231,     0,  3320,  3320,   144,    49,     0,   121,
     969,    32,    32,  1786,  1787,  1785,     0,  1524,  1524,     0,
    1511,  3428,  2703,  2704,  3427,  1642,  2700,  1740,  2695,  1565,
    2698,  2699,  1703,  3356,     0,     0,  3044,  1691,  2996,  2997,
       0,     0,     0,     0,  1707,  1743,  1730,  3320,  2766,  3413,
    2766,  3260,     0,  3304,  3320,     0,     0,     0,     0,  1664,
    1649,  1651,  2692,  1661,  3336,  1654,  1655,  1656,  1697,  3270,
    1659,  2974,  2946,  2973,  3129,     0,  3090,     0,  3090,  3094,
       0,  3090,  3100,     0,  3090,  3090,  3090,     0,  3090,  3129,
       0,  3090,     0,  1565,  1565,  1755,  2720,  2717,  3027,  3028,
    2714,     0,  3090,  3090,     0,  3118,  1769,  1768,     0,  1765,
    1777,  1775,  2762,  1801,  1802,  1798,  1800,  1856,     0,  1853,
    1852,  1861,     0,  1869,  2336,     0,  1565,  1565,  1876,  2751,
    2757,  2754,     0,  1969,  1945,  1568,  1931,  1932,  1929,  1928,
    1930,  1927,  1919,  1921,  1924,     0,  2000,  2001,     0,  1478,
    1480,  2004,  2005,     0,     0,     0,  2766,  2766,     0,  1917,
    1939,  1970,  3418,  3418,  1899,     0,  2026,     0,  2070,  2067,
    2069,  2068,  2061,  2064,  2071,  1565,     0,  2780,  2779,  2845,
    2180,  2183,     0,  2184,  2174,  2175,     0,     0,  2083,  1674,
    2111,  2902,     0,  1565,  2126,  2117,  2120,     0,     0,  2147,
       0,  1472,  1471,  1477,  1476,  1475,     0,  3032,  2976,  2977,
    2202,     0,  2204,  2203,  2205,  2187,  2197,     0,     0,  2165,
    2471,  2462,     0,   882,   883,  3335,  3309,  1209,  1467,  1466,
       0,  1207,  2243,  2246,     0,     0,     0,   645,     0,  2286,
    1565,     0,  2304,  2300,  2305,  2301,  2306,     0,  2296,   661,
    2303,  2323,  2354,  2322,  1565,  2371,  2739,     0,  1565,  2750,
    2378,     0,     0,  2417,  2416,  2415,  2414,  2413,  2433,  2458,
    2999,  2459,  2998,  3000,  3001,     0,  2445,     0,  2450,  2437,
    2438,  2439,  2443,  2440,  2444,  2441,  2442,  2436,  3125,  2494,
       0,  2492,  2487,     0,  2480,  3463,  3462,     0,  2723,     0,
       0,  3129,  3129,  2534,     0,     0,  3111,  2558,  2559,     0,
    2562,  2565,  2567,  2563,  2377,  3258,     0,  2041,  2039,  1804,
    2040,  2768,  2230,  2773,  1565,     0,  2389,  2396,  3399,  2508,
    2508,  2853,  3040,     0,  2768,     0,  2688,     0,     0,  1564,
     567,   623,   970,     0,  1112,   489,   917,   918,   694,   696,
     695,   689,   693,   691,   692,   688,   690,   687,   929,   923,
     925,   926,  3320,   745,   671,   960,   961,  3415,     0,     0,
       0,     0,   757,   758,   759,  3292,     0,  3386,   890,   733,
    3012,   868,     0,   862,   763,     0,   731,  3269,     0,   752,
    3393,   893,   894,   891,     0,     0,     0,     0,     0,     0,
       0,  1086,  1082,  1083,   700,   777,  3389,  3389,  3389,  3389,
    3389,   778,   780,   781,   782,   785,   786,   787,   788,   790,
     789,   792,   825,   823,   824,   826,   827,   791,   797,   793,
     828,   794,   795,   796,   808,   809,   807,   811,   812,   810,
     829,   771,   783,   784,   687,   921,   911,   919,   741,   962,
    3278,   746,   738,  3141,  3141,     0,   677,     0,   642,   529,
     557,  3458,  3459,  2921,   538,  2919,  3450,  3449,   531,  2923,
    2922,  3345,  3282,  3304,     0,  3320,   535,   534,  3320,   563,
     295,  3351,  3335,  3380,  3410,   360,  3445,  3446,   399,     0,
    3335,  3320,  3280,  3335,   401,     0,  3418,   382,   381,  3320,
    3320,   297,   298,   303,   308,   317,   305,   364,   306,   309,
       0,   310,     0,   300,   398,   301,   302,   307,   304,   299,
     311,   312,   313,   314,   315,   316,   294,     0,  3274,  3325,
     456,   457,     0,   460,   462,   465,   466,   469,   474,   471,
     233,   234,  3038,  3035,  3035,   145,   479,   158,  1506,    33,
       0,     0,  1784,  1520,  1521,  1527,     0,  1518,  1540,  1541,
       0,  2693,  2701,  1565,  1741,  1742,  3010,  2694,  2696,  2702,
    1701,  1702,  1735,  1733,  1710,  1734,     0,  1737,     0,  1736,
    1738,     0,     0,  1677,  1676,     0,  1680,  1679,  1662,  3320,
    1644,  1692,  1694,  2714,  3106,  3075,  3108,  3076,  3090,  3069,
    3104,  3072,  3073,  3074,  3102,  3071,  3143,  3097,  3098,  3068,
    2931,  2722,  2719,  2715,  2721,  2716,  2718,  3026,  1756,  3091,
       0,  3066,  3067,  3120,  2983,  2984,  1766,  1770,  1782,     0,
    3132,     0,  2756,  2759,  2752,  2758,  2753,  2755,  1886,  1960,
    3322,  3322,  3322,  3322,     0,  1944,  1946,  1947,     0,  2019,
    2017,  1479,  1481,  3359,  2018,  2021,  2020,  2015,  1988,  1985,
    3332,     0,  3263,  1984,  1987,  1978,  1956,  1974,  1980,  1981,
    1991,  1982,  1976,  1995,  1996,     0,  1963,  2714,  2884,  2714,
    2884,     0,  2773,  2066,  2058,  2059,  2057,  2063,     0,  2176,
    2181,  2084,     0,  2113,  2119,  2124,  2133,  2136,  2137,  3292,
    3407,  2129,  3410,  2134,     0,     0,  2198,  2200,     0,  2193,
    2207,  2194,  2195,  2186,  2189,  2207,     0,  2980,  2472,   365,
    2466,     0,  3310,  2469,     0,  2714,  3370,  3370,     0,  2262,
    2263,  2763,  2291,  2293,  2294,  2290,     0,     0,  3361,     0,
    2342,  2324,  2337,  2330,  2326,  2339,     0,  1565,  1565,  2351,
    2360,  2357,  2741,  2732,  2740,  2733,  2738,  2376,  2379,     0,
    2406,  2407,  3337,  2412,  3359,  3359,  2449,  2493,  2484,  2488,
    2489,  2490,  2491,  2482,  1565,  1565,  2518,  2729,  2726,  3320,
    2526,  2525,  2527,  2714,  3143,  2714,     0,  3110,  2561,  3304,
    2768,  3304,  2723,  2622,  2619,  2618,  3339,  1811,  3304,  2217,
    2650,     0,  1565,  2394,  1565,  2397,  2506,  2509,  2507,  3041,
    2630,  2687,  3418,     0,  2685,  1559,   571,   569,     0,   623,
     967,   623,  3227,     0,     0,   930,   927,     0,     0,   670,
     895,   951,   952,   953,   954,   955,   950,   956,   949,   948,
     946,   947,   957,  3293,   756,  2800,   959,  2799,  2801,     0,
       0,   732,   734,  3304,   860,  3408,   865,  3408,     0,  3361,
     767,   762,   766,   958,   736,     0,  3013,   770,   774,     0,
     773,   772,  3414,     0,  3320,     0,   897,  3261,   898,   902,
     911,     0,  1088,  1084,  3390,   822,   821,   814,   813,   820,
     819,   818,   817,   816,   815,   779,     0,  3410,   901,   912,
     920,     0,   740,     0,     0,   739,   737,  3280,   851,   852,
     681,   680,   685,     0,   519,     0,   556,  2920,  3346,   540,
       0,   522,  3394,   549,   551,   555,   554,   550,   552,   548,
     553,     0,     0,  3320,  3320,  3335,   345,   402,  3320,  3380,
    3320,  3320,  3320,  3320,   421,  3265,   422,     0,     0,     0,
    3320,  3351,   365,  3275,     0,     0,   458,   467,     0,   468,
       0,   146,   147,   485,   486,   487,   478,   480,     0,   483,
     477,   159,     0,    28,    31,  1522,  3320,     0,  1537,  1528,
    1533,  1525,  1526,  1542,  2697,  1723,  3451,  3452,  2767,  1739,
    1728,  1675,     0,  1693,  1757,  3070,  3312,  3145,  3092,  1803,
    1858,  2335,  2334,  3418,     0,     0,     0,     0,  1953,  1948,
    3295,  3334,  3333,     0,  1977,  3322,  1975,  1990,  1989,  1992,
       0,     0,  1983,  2028,     0,  2027,     0,  2065,  2072,  2173,
       0,  2172,  1925,  2085,  2087,  2088,  1565,  2138,     0,     0,
    2207,  2978,  2979,  2207,     0,  3316,  3316,  2192,  2208,  2209,
    2190,  2196,  2191,     0,     0,  2475,  3320,  2465,  3311,  1208,
    2247,  3371,   424,   425,   426,     0,  2283,  3422,  2281,  2282,
    2280,  3421,  2254,  2264,  2265,  2267,     0,     0,  2292,  2288,
    2307,  2309,     0,  2327,  3320,  2750,  2325,  2338,     0,     0,
       0,  2341,  2362,  2359,  2355,  2361,  2356,  2358,  2380,  3338,
    2418,     0,     0,  2731,  2728,  2724,  2730,  2725,  2727,     0,
    2536,  3145,  2535,  2550,  2560,     0,  2564,     0,  2556,  1565,
    1565,  2613,  2624,  2747,  2744,  2623,  3340,  3341,  2617,  1805,
    1806,     0,     0,     0,  2650,  3359,  2220,  2231,  2390,  2398,
    2633,     0,     0,  2575,  1558,     0,   572,   570,   971,   974,
    3227,   928,     0,   924,   931,   932,     0,     0,   684,  3359,
     679,   682,   672,  2817,  2819,  2822,  2820,  2821,  2823,  2824,
    2825,  2826,  2816,  2818,  2811,  2815,  2813,  2814,  2810,  2812,
    2803,  2804,     0,  2807,  2806,  2970,     0,     0,     0,   862,
    3409,     0,   863,   866,   853,     0,     0,     0,   755,   753,
     754,   831,   942,     0,  2854,   915,   906,   900,   905,   903,
       0,     0,   908,   899,  1087,     0,  1085,  1195,  1191,  1192,
    1185,  1189,  1197,  1183,   842,  1190,  1182,   849,  1188,   802,
    1184,  1186,  1187,  1196,   799,   801,  1193,   803,  1194,   798,
     806,   805,  3408,     0,   742,   963,     0,   748,   751,   750,
     747,  3142,   686,   530,   521,   520,   518,   558,   539,  3282,
     527,   536,   533,   537,   532,     0,     0,  3320,   348,   347,
     323,   346,     0,   401,   397,     0,   404,     0,     0,  3266,
    3267,   420,   423,  3282,     0,     0,  3320,     0,   400,   427,
       0,   470,   235,     0,     0,     0,   481,   484,  1516,     0,
    3320,  1532,  1538,     0,  1543,  1512,  1695,  3313,     0,  3312,
    2714,  1815,  1961,  1952,  1951,  1949,  1950,  1998,     0,  3322,
    1993,  1994,  2714,  2714,     0,  2078,  1926,  2086,  2118,     0,
    2148,  2188,  2199,  2207,  3317,     0,     0,  2210,  2211,  3320,
    2473,     0,     0,  2463,   366,     0,     0,  2467,  2278,  3372,
    2275,  2277,  2276,  2269,  2274,  2266,     0,  2272,  2270,  2271,
    2268,     0,     0,  2329,     0,  2320,  2345,  2739,  2736,  2344,
    2328,  2340,  2446,  2447,  2529,  2714,  2566,  2568,  2746,  2749,
    2742,  2748,  2743,  2745,  1807,  1808,     0,  1809,  2939,  2938,
    3011,  1813,  1812,  1814,  2769,  2220,     0,     0,  2705,  2641,
    2634,  2635,     0,     0,  2689,  2690,  3320,  2583,  1560,   574,
     976,  1113,     0,   936,   935,   937,  3320,     0,  2805,  2809,
    2808,   735,   869,   861,     0,   870,  3361,  3361,   872,   765,
    3320,   769,   768,  3359,   832,   830,     0,     0,     0,   940,
       0,   910,     0,   907,     0,   904,  1089,   843,   844,   848,
     847,   846,   845,   800,   850,   804,   913,   914,   749,     0,
       0,   541,   542,   543,   544,     0,   525,  3303,   529,     0,
     353,   354,   352,   351,   430,     0,   337,   338,   339,   333,
     334,   328,   340,   341,   329,     0,   342,   343,   332,   330,
     331,   336,   335,     0,   322,   326,   327,   324,   431,   403,
       0,   411,   419,   432,   433,  2914,     0,  3320,     0,     0,
    3320,  3320,   482,  1539,  1529,  1530,  1534,     0,  1535,     0,
    1547,     0,     0,  1758,  1824,  3318,  1997,     0,  2030,  2029,
    2182,  2139,  2206,  2213,  2212,     0,  2476,  3320,  3320,  3320,
     367,  3373,  2273,  2279,     0,  2310,  2963,  2962,  2964,     0,
    2343,  2734,  2735,  2737,  2537,  1810,  2218,  2651,  2652,  3320,
    2221,  2222,  2224,  2229,  3320,  2645,  2636,  2640,     0,  2639,
    2637,  2691,     0,  3271,  2610,  2609,  2584,  2576,  2577,  3259,
    2578,  2579,  2580,  2581,     0,     0,     0,  3300,   975,  1115,
    3417,     0,   934,     0,   683,   871,   872,     0,     0,  3278,
     857,   877,   878,   879,  3335,   876,     0,   836,   833,   837,
     944,   943,   945,     0,   941,   916,   909,   547,   546,  3270,
    3361,   523,  3282,   528,   411,     0,  3298,  3468,  3469,   319,
     318,     0,   408,   407,   406,   409,   405,  3320,   413,   356,
     415,  2915,   379,   388,   395,   388,   384,     0,     0,   428,
    3035,  3035,  3227,  1531,  1523,     0,  1547,  1568,     0,  3146,
    1565,  1565,  1781,  1831,  1827,  1565,  3359,  3319,  1818,  1823,
    1822,  1817,     0,  1979,  2474,     0,     0,     0,   368,  2965,
    2966,  2967,  2308,  2705,  2653,     0,  2223,     0,  3359,  2656,
    2638,  2682,     0,  3396,  2607,  2604,  2605,     0,  3361,   575,
     573,  3234,  3316,   978,   977,     0,  1119,  1114,  1116,     0,
     938,   933,   859,   872,   867,  3035,   873,   880,  3320,     0,
     764,   838,   834,   939,  3021,  3023,     0,     0,   525,  3112,
     321,   344,   320,   414,   358,  3112,   357,   412,     0,  3347,
     386,   391,     0,   387,     0,   385,   373,   429,   148,   149,
      34,     0,  1568,  3144,  1833,  1830,  1825,  1832,  1826,  1828,
    1829,     0,  1816,  2477,   369,   370,  2219,  2655,  2654,  2643,
       0,  3359,  2666,  2705,     0,  3397,     0,     0,  2608,  2606,
    2602,  2601,  2600,     0,   596,     0,     0,     0,  1120,     0,
    1117,   858,   886,   887,   889,  3035,   875,  3022,   545,   526,
     524,   356,     0,  3320,   410,   417,   418,   416,  3348,     0,
     394,   396,  3320,  1544,  1819,     0,     0,  3320,  2642,  2646,
    2647,  3320,     0,     0,  2631,  2683,  2603,  3444,  3443,  3374,
    2893,     0,  2596,  2590,  2591,  2593,  3320,     0,     0,     0,
       0,   577,   597,   598,   579,   607,   979,  1125,  1126,     0,
    1118,   888,   881,  2916,   361,  3114,     0,     0,     0,     0,
       0,  3320,  3320,     0,  2648,     0,  2657,  2658,  3320,     0,
       0,  2667,  2668,  2670,  2705,  3375,  3361,  2894,  2599,  2594,
    2597,     0,  2592,  3320,     0,     0,  3320,  3320,  3320,  3320,
     599,     0,  3350,     0,  3401,     0,   576,   580,   582,   581,
       0,     0,     0,     0,     0,     0,     0,   578,   608,   610,
     609,     0,     0,     0,   775,     0,  1123,  1180,  2917,     0,
     355,  3113,   359,     0,  3453,  3454,   392,  1536,  1545,     0,
       0,  2644,  2649,  2659,     0,  2663,  2665,  2664,  2661,  2661,
    2675,  2671,  3063,  3064,  3061,  3062,  2672,  2676,  2669,  2632,
       0,  2598,  2595,     0,     0,   605,     0,     0,     0,     0,
    3320,  3320,  3320,  3320,  3320,   583,     0,  3320,  3320,  3320,
    3320,  3320,  3320,  3320,  3320,  3320,  3320,  3320,   611,     0,
    3320,     0,  3320,  1149,  3320,  1137,  1138,  1139,  1130,  3414,
    1131,  3355,  3355,  3320,  3322,  3294,  3320,     0,  1154,  1147,
    1134,  1148,  3355,  3322,  1135,     0,     0,  1146,  1156,  1153,
    1151,  3322,  1136,  1150,     0,  1157,  1145,     0,  3320,  1172,
    1166,  1170,  1169,  1167,  1127,  1171,     0,  1173,  1168,  1152,
    1140,     0,  3355,  1181,  1199,  1198,  1202,     0,   392,   389,
     393,     0,   371,   372,  2660,  2674,  2662,  2673,     0,  2589,
    2586,  2588,  2587,  2582,  2585,   600,  3408,   604,   602,   606,
     601,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     983,  3235,  3325,  3325,  3342,   982,   986,   987,  1016,     0,
       0,     0,     0,  1128,  1129,  1162,  3320,  1160,  3320,     0,
       0,  1132,  1133,     0,  1175,  1158,     0,  3408,  3320,     0,
    1176,  1174,  1179,  1177,  1504,  1161,  1126,  1203,     0,   242,
     243,   363,   390,  1546,  2677,   884,   592,   588,   589,   593,
     591,     0,   594,   584,   590,   585,   586,   587,   616,   612,
     613,   617,   615,     0,   614,  3484,  3485,  3325,  3325,     0,
     980,   984,  3320,   992,   988,   990,   991,   993,   995,  1165,
    1500,  1496,  1163,  1143,  1144,  1164,  1159,  1493,  1503,     0,
    1142,  1141,   775,   362,   603,   885,     0,     0,  3343,  3344,
    3046,  1003,   998,  3339,  1002,  3045,  1001,     0,  1017,     0,
     989,   994,  1488,  1485,  1489,  1486,  1501,  1484,  1502,  1487,
       0,  1497,  1498,     0,  1494,  1492,  1490,  1491,  1155,     0,
     618,   996,  3340,  3341,   997,  1000,     0,     0,  1018,   639,
     985,  1499,  1495,     0,     0,  3320,  3320,     0,  3320,  1004,
    1005,  1006,  1007,  1008,  1009,   999,     0,  1020,  3236,  1021,
       0,  3471,  3470,  3320,     0,     0,  3473,     0,  3320,  3320,
       0,   775,     0,     0,  1015,  1011,  3472,     0,     0,  1010,
    1076,  3432,  3431,  3314,  3355,  3261,  3320,     0,  1075,  3320,
    3359,  3320,  1026,  1028,  1027,  1029,  1038,  1030,  1032,     0,
    1035,  1022,  1023,  1024,  1034,  1036,     0,  1039,  1025,  1093,
    1031,     0,  1033,  1037,  1019,  3435,  3436,  3355,     0,  1012,
    1014,  1013,  3315,  1110,  3358,  3357,  3325,  1092,     0,   862,
       0,     0,     0,   922,  3353,  3353,     0,     0,  1095,  1090,
    1093,     0,  1483,  1097,  1105,  1106,     0,  1108,  1099,   595,
    1091,  1063,  1061,  1062,  1057,  1060,     0,  1058,  3408,  3129,
    1065,  2950,  3475,     0,     0,  3477,  3479,     0,  3483,  3481,
    1040,  1045,  3363,  3363,  1042,  1046,  1041,  1047,  3354,  1077,
    1077,  3353,  3353,  1070,  1094,  1096,  1107,  1104,  1103,  1101,
    1102,  3325,  1100,  1059,   866,  1109,  3361,     0,  1064,  2951,
    3474,  3478,  3476,  3482,  3480,  3365,  3364,  1048,  1053,  1081,
    1079,  1071,  1077,  1080,  1073,     0,     0,  1098,   855,     0,
    1067,  1051,  1043,  1051,  1056,  1051,  1044,  1051,  1078,  1072,
    1074,     0,   854,  1069,  1066,  1068,     0,  1050,  1049,  1055,
    1054,   856,  1052
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  3572, -3889, -3889,
   -3889, -3889, -3889, -3889,  -108, -3889,   540, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,  1081, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  2680, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  3536,  3410,  1336,
   -3889, -3889, -3889,  3262, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,  3583, -3889, -3889, -3889,
    2355, -3889, -3889,  3510, -3889,  1781, -3889, -3889, -3889, -3889,
   -3889, -3889,  3307,   150, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,  3390, -3889,   561, -3889, -3889, -3889,  3306, -3889,
    1101, -3889, -3889,  3515, -3889, -3889,  -994, -3889, -3889,  3280,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
    2816, -3889,  2395, -3889, -3889,  -736, -3889,  3450,  3091, -3889,
   -3889, -3889,  3311, -3889, -3889, -3889, -3889,  3406, -3889, -3889,
    3102,   444, -3889, -3889, -3889,  1528, -3889,  2462, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  -673, -3889,
   -3889, -3889, -3889, -3889,  1143, -3889, -3889, -3889, -2310, -3889,
   -3889, -3889, -3889, -3889,  -513,  -903, -2371, -3889, -3889,   198,
   -3889, -3889, -3889, -3889, -3889,  -486, -3889, -3889, -3889,  -599,
   -3889, -3889, -3889, -3889,   194, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  3123, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889,   608, -3889, -3889, -3889, -3889,  2818, -3889,
   -3889, -3889,   181, -2004, -3889, -3889, -3889, -3889,  3606, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  -575, -3889,  -314, -3889, -3889, -3889,   227, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  -741, -3889, -3889, -3889,  -687,
   -3889, -3889,  -750, -3889, -3889, -3889, -3889, -1658, -3889, -3889,
    2914, -3889, -3371, -3889, -3521,  -713, -3889, -1027,  1405, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3631, -3889,
   -3889, -3889,   343, -2261, -3889, -3889,  1248, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1918, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -2769, -3889, -3889,
   -3889, -3889, -1073, -2400, -3889, -3889, -3889, -3889, -3889, -3889,
    1238,  1239, -3889, -3889, -2394, -3889, -3889, -3889, -3889, -3889,
   -3542, -3889, -1197, -3889, -3889, -3616, -3889,  -537,  -420, -3889,
    1542, -3889, -3749, -3889,  -606, -2377, -3889, -3889, -2355, -3889,
   -3889, -3889,   312, -3889, -3889, -3889, -2738,   313,   314, -3889,
   -1064, -2796, -2401, -3889, -3889, -3889, -3889, -3889,   831, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  1182, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  -959, -2218, -3889, -3889, -1018,
   -2065, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -2311, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -2453, -3889, -1051, -3889,
     799, -3889, -3889, -3889, -3889, -1118, -3889, -3889, -3889, -3889,
   -3889, -3889, -1121, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  -502, -3889, -3889, -3889,  -909, -3889, -3889, -3889, -3889,
    -641, -3889,  3012, -3889,  -826, -1604, -3889,  -695, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,  2110,  2686,   779,  -783,  -782, -3889, -2577, -3889,
    -947, -3889, -3889, -3889, -3889,  -786, -3889,  -815, -3889, -3889,
   -3889,  1893, -3889, -3889, -3889, -3889, -3889, -3889, -3889,   -79,
   -3889, -3889,  1202,  -417, -3889, -3889,    92,   244, -3889, -3889,
    -288, -3889, -3889, -3889, -3889, -3575, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -1031, -3889, -3889,  -172, -3889,
    3465, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  -827, -1618, -3889,  2471, -3889,  2466, -3889,   638, -3889,
    -738, -3889, -3889, -1104, -3889, -3889,   649,  2470, -1253,  1869,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1770,
    1130, -3889, -3889, -3889,  2830, -3889, -3889, -3889, -3889, -3889,
   -1595, -3889, -3889,  1693, -3889, -3889, -3889, -3889,   243, -3889,
   -3889,   114, -3889, -3889, -1111, -3889, -3889, -3889,  -423, -3889,
    -418, -3889, -3889, -3889, -3889, -3889,  2826, -3889, -3889, -3889,
   -3889,  2414, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,  3066, -3889, -3889, -3889, -3889, -3889,
    2364, -3889,  2785, -3889, -3889,  2388, -3889, -3889,  1737, -3889,
     225, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1711, -3889,
   -3889, -3889, -3889,   612, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889,  2782,  1131,  3065, -2470, -2841, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -1866, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  2366, -3889, -3889,  2371, -3889,
   -3889, -3889, -3889,  1090,   586, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,   241, -3889, -3889, -3889,  2763,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  1671,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889,   580, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,   579,  2335, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  2741,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -2528, -3889,
   -3889,  1641, -3889, -3889,   569, -3889,  1071, -3889, -3889, -2210,
     239,   245, -3889, -3889, -3889, -3889, -3889, -3889,  -106, -3889,
    -273,  2068, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889,  2738, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,   229, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3559,  1527, -3889, -3889, -3889,   556, -3889, -3889, -3889, -3889,
   -3889,  2781,  2735, -3889, -3889, -3889,  1497, -3889, -3889, -3889,
   -1400,  1048, -3889, -3889,   559, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,   552, -3889,   554, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
     991, -2077, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,  2072, -3889,   981, -3889,  2078, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889,  2140, -3889, -3889, -3889, -3889, -3889, -3889,
     -25, -3889, -3889, -3889, -3889,  1478, -3889, -3889, -3889,  2724,
   -3889,  2723, -3889, -3889, -3889, -3889,  3108, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889,   987, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889,  2116, -3889, -3889,  1469, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889,   534, -3889,  1476, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889, -3889, -3889, -3889, -3889, -3889,  -510, -3889,
   -3889, -3889, -3889, -3889, -3889,  -368, -3889, -3889, -3889, -3889,
    -589,  1518,  1532, -3889, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -3889,   -70, -3889, -3889, -3889, -3889, -3889,  -487,
     201, -3889,  -221, -3889, -3889,  -532,  -602, -3888, -3889, -3889,
    -531, -3889, -3889,  2094, -3889, -3889, -3889, -3889, -3889, -3889,
   -3889, -3889, -1646, -3889,  1313, -3889, -3889,  1317, -3889, -1297,
   -3889,  2474, -3889,  2472, -1869, -3889,  1254, -3889,  1249,   560,
   -3889,   575, -3889,   578, -3889, -3889, -3889, -2597,   -11, -2170,
   -3889, -3889,   233, -3889,   235, -2195,   568, -3889,  1228, -3889,
    1232,  2947, -1473,  3153, -1074, -2459, -2227,  -637, -1912, -3889,
   -3889,  2443, -2133, -3889, -3889, -3889, -3889,   186, -3889, -1350,
   -1354, -1530,  1074,  1075,  1076,  1078,  1290, -1749,  -485,  1428,
    1545, -3889,  1796,  -572, -1175,  -620,  -691,  3150,  2739, -1045,
   -3889,  -251,  1837,  -704, -3889, -1022, -3889,  1771, -3889,  -562,
   -3889,  2551,   458,  -151, -3889, -3889, -1187, -3889,   914, -1943,
     -21,  3570,  -592,  -610, -3889,  -591,  -450,    -2, -2146,   501,
   -3889, -1156, -3250, -3889,   236, -3889,    26, -3889,  1566,  -966,
   -1956, -2880, -2724, -3889,  -662,  2564, -3889, -2366, -2434, -2919,
     -59,  -611,  -690,  -742,  -584, -3889, -2635, -3889, -2767, -3889,
    3832,  -710, -3889, -3889,  -333, -3889, -3619, -3889, -1593,  1416,
   -3736, -3889,  1388,  -776,  -812,  -175,  3073, -3030, -2242,  3094,
      80,  -223,  4070,  -313,  -653,  -664, -3889, -3889, -3889, -1179,
    3021, -3889, -3889, -3889, -3889,  1459, -3889, -3889,  2141, -3889,
    -334, -3889, -3889, -3889, -3889,  1567, -3889, -2501, -3889,  1282,
     949,   621,   298, -3889, -3889, -3889,   -50,  -715,  -243,  2731,
   -3889,  -571,  -835,  -728, -3889, -3889, -3889, -1726, -3889,  -161,
   -2352,   755, -3889,  1456, -2038, -3889, -3889, -3889, -1684, -1774,
   -1107, -1665,   683, -3889, -3889,   722, -3889, -3889,  -202,  -173,
   -3889, -2107,  1028, -3889,   113, -3889, -3279, -3889,   -17, -1948,
   -2388, -3889, -3889, -2590, -3889,  -760, -3889, -3889, -3889,  3081,
   -1691, -2365, -1777,  -872,  -843,  -731,  -925,  3599,   705, -3889,
   -3889,  3589, -3889,  -859, -3889, -3889, -3889,  -141, -3889,   513,
   -3889,  1562, -2857, -3889, -3889, -3889, -3230,  -666,  1899,   567,
   -3889,  -237, -3889, -3889,   909, -3889, -1773, -3889, -1263, -3889,
    2687, -3889, -3889, -3889,  -654, -3889,  -745,  -483, -3889,  2175,
    1444, -3889, -3889,   160, -3889, -3236,  -869, -3889, -3889, -3889,
   -3889, -3889, -3889
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,     4,     5,     6,    18,    19,     7,     8,
      20,    21,   126,   127,   128,   182,   131,   185,    22,   828,
    1824,    23,   829,  1825,  3050,  3472,    10,    11,    53,   121,
     179,   575,   576,   825,   827,  1246,    13,    46,   141,    24,
      25,    42,    26,    38,    39,    40,    41,   124,   246,   181,
     242,   344,   345,   346,    14,    44,    45,   137,    62,   140,
     254,   190,   586,    29,    30,    31,  1248,    48,    49,    50,
      51,    91,    92,    93,  2508,    94,   217,   306,   558,    95,
     214,   291,   292,   293,   294,   295,   548,  1242,  1818,   296,
     297,  1238,   298,  3470,    96,   215,   303,   304,   305,   553,
      97,    98,    99,   100,   101,   175,   102,   228,   572,   229,
     230,   103,   201,   272,   524,   525,   273,   274,  1222,  1230,
    1223,  1224,  1225,  2501,  3040,  2681,  4621,   203,   177,   104,
     105,   311,   312,   313,   821,   106,   219,   220,   107,   529,
     530,  3463,   109,   224,   325,  3464,   534,  3465,   112,   113,
     114,   115,   116,   117,   169,    69,    70,    71,   148,   200,
     269,   511,  1787,  2485,  2486,  3001,  3002,  3993,  3994,  3995,
    3996,  3997,  3770,  3771,  1205,  3003,  3973,  3004,  4235,  4236,
    4303,  3005,  4420,  3006,  2720,  3556,  3844,  3008,   239,  3009,
    3010,  3011,  3012,  4146,  4240,  4539,  4241,  4243,  3013,  3014,
    3015,  3016,  4000,  4136,  3017,  4139,  4140,  4237,  4238,  4305,
    3018,  3019,  3445,  3020,  3229,  3021,  3789,  3022,  3023,  3024,
    3025,   270,   271,   516,   517,   518,   519,   790,   520,   521,
     522,   783,  3035,  3036,  3459,   523,   785,  1805,  1249,  3047,
    3466,  3467,  3468,  3469,    64,   263,    65,    66,  2510,   143,
     144,   196,   264,   265,   767,   266,  1184,  1774,  1775,  3756,
    1776,  4121,  3968,  3414,  1777,  1778,  2978,  3762,  1779,  1780,
    3758,  3961,  3962,  3963,  3964,  1781,  3429,  3430,  1782,  3416,
    1783,  1784,  2480,   747,   748,  2388,  2840,  3317,  3318,  3319,
    3909,  4087,  4199,  4396,  4397,  4398,  4399,  4341,  4342,  4343,
    4407,  4408,  4409,  4410,   503,   504,  1751,   505,   506,   752,
     753,  1762,   754,  1179,  1180,   221,  2463,  2944,  2289,  2290,
    2291,  2292,  2293,   755,  3329,   756,  1757,  1172,   757,  1758,
    2956,  3660,  3411,  2945,  2426,  2427,  2428,  2429,  2430,  3351,
    3352,  2431,  2432,  3406,  2433,  3402,  2397,  2434,  2435,  3404,
    3750,  2436,  3365,  3699,  2437,  2875,  2438,  2439,  2884,  3361,
    3696,  3932,  2440,  2441,  2442,  2941,  3371,  3935,  3936,  4222,
    2294,  2295,  3953,  3955,  2443,  3362,  4776,  4912,  2444,  3689,
    3357,  2882,  3928,  3354,  4096,  4100,  4219,  4101,  4102,  4103,
    4104,  4674,  4105,  4292,  4293,  2445,  2446,  2893,  2447,  2448,
    2449,  3378,  3379,  2450,  3712,  3945,  3374,  3398,  3399,  3704,
    2395,  2946,  3400,  4780,  2396,  3325,  2859,  2860,  2861,  3653,
    3654,  3655,  3915,  4092,  2451,  3702,  3938,  2452,  3340,  2453,
    3338,  2454,  2455,  2456,  2457,  2458,  2459,  1169,  1170,  2841,
    1755,  1756,  3321,  2392,  2843,  3910,  4088,  4204,  4286,  4413,
    4482,  4585,  4586,  4654,  4655,  4656,  4657,  4587,  4681,  4682,
    4683,  4711,  4729,  4730,  4731,  4732,  4733,  4734,  4650,  4688,
    4739,  4751,  4781,  4782,  4850,  4902,  4917,  4906,  4783,  4834,
    4835,  4784,  4878,  4914,  4785,  4786,  4891,  4892,  2460,  2902,
    2903,  3382,  3716,  4788,  4789,  4819,  4820,  4790,  4791,  4871,
    4872,  4823,  4824,  4825,  4792,  4793,  2845,  3323,  4089,  4207,
    4208,  4209,  4348,  4349,  4536,  4414,  4524,  4525,  4526,  4416,
    3741,  4533,  1031,  4616,  1614,  1615,  1616,  1617,  2241,  1585,
    2242,  1586,  2243,  1587,  2244,  1588,  2245,  1589,  2246,  1590,
    2247,  1591,  2248,  2249,  1592,  2250,  1593,  2251,  1594,  1595,
    2252,  1596,  2253,  1597,  1598,  2254,  1599,  2255,  1600,  2727,
    2127,  1601,  1602,  1606,  1607,  2651,  2652,  4821,  4822,  4697,
    4698,  4699,  4666,  4706,  4707,  4597,  4703,  4595,  4700,  4527,
    4528,  2511,   192,   193,   257,   587,  3060,  4020,   194,  1829,
    2518,  2517,  3053,  3054,  3055,  3478,  3479,  3480,  4154,  3803,
    2520,  3805,  4019,  4360,  4541,   744,  1150,  1750,  1151,  1152,
    2385,  3644,  1153,  1154,  2838,  2008,  2009,  2635,  1155,   259,
     429,   700,   430,   668,   841,  1255,  2569,   842,   843,   844,
    2688,  1269,  1891,  1892,  1260,  1261,  1262,  3090,  3091,  1919,
    3165,  1842,  1843,  1264,  1883,  3063,  3064,  4529,  2041,  1886,
    1254,   431,   669,   877,  1293,  1291,   432,   670,   894,  1979,
    2609,   433,   671,   909,   910,  1981,   434,   672,   915,  2612,
    1252,  1826,  2516,   837,   838,  1983,  1984,  2615,  2820,  3297,
    3629,  3630,  3631,  4024,  1019,  4171,  4162,  4258,  4163,  4256,
    4164,  1328,   435,   673,   920,   921,   922,   436,   674,   926,
     927,  1335,   928,  1331,  2617,   437,   675,   931,  1340,   438,
     439,   676,   941,  1349,   440,   678,   946,   441,   677,   943,
    1350,  1353,   442,   679,   953,  2003,   954,   443,   680,   965,
     966,   967,   968,  1380,   969,  1382,  2042,  2018,  2019,  3825,
    2020,  2640,   970,  1363,   971,   972,   973,  2045,  2046,   974,
    2634,  3145,  3146,  3147,   975,  1384,  2662,   976,   977,  2633,
    3503,   978,  2663,   979,  1365,  2050,  1032,  3166,  3167,  3168,
    3169,  3170,  3520,  3171,  3172,  3173,  3174,  2043,  1369,   444,
     681,   984,  1392,   445,   682,   446,   447,   724,  2355,  1133,
    2818,   448,   683,   989,   990,   991,  1399,  1400,  1401,  2064,
    1402,  2061,  2676,  2672,  2673,  3183,  1396,   449,   685,  1000,
    2101,  1001,  1431,  3192,  3532,  3533,   450,   686,  1007,  1020,
     451,   687,  1008,   452,   688,  1011,   453,   689,  1014,  2106,
     454,   690,   455,   691,  2111,  1441,  2112,  2693,  2695,   456,
     692,  1024,  1442,  2121,  2699,  3197,  3198,  3199,  3201,   457,
     693,  1027,   458,   694,  1033,   459,   695,  1036,  1037,   995,
    2138,   460,   684,  1429,  2100,  2687,  2099,  3531,  2682,  2139,
    2718,  2140,  2141,  3213,  3214,  2715,  2716,  2717,  3207,  3547,
    3548,  3549,   461,   462,  1134,  1725,  3634,  4183,  3898,  4060,
    4061,  2358,   463,  1135,  1727,  3300,   464,   696,   465,   697,
    1044,  1621,   466,   698,  1046,   467,   699,  1048,  1625,   468,
     701,  1052,  1053,  1054,  1632,  2261,  3572,  3573,  3860,  3853,
    3854,  3574,  3575,   469,   702,  1056,  2740,  2741,  3579,  3235,
    1637,  1638,  1639,  2743,  2745,  2746,  3862,   470,   703,   471,
     704,  1062,  4194,   472,   705,  1064,  2307,  3240,  3241,  3242,
    2000,  2001,  2002,  3586,  3244,  3585,  3865,  1652,   473,   474,
     706,  1066,  1660,  3249,  3596,  3250,  3594,  3251,  1657,   475,
     707,  1068,   476,   477,   708,  1071,  1664,   478,   709,  1074,
    2759,  2760,  1668,   479,   480,   481,   728,  1136,  1137,  1729,
    1734,  2365,  2824,  2826,  2827,  1732,  2367,   482,   710,  1078,
    1079,  3260,  1673,  1674,  1080,  2311,  3263,   483,   711,  1085,
     231,  1690,  1086,  1087,  2333,  2334,  1088,  1089,  1090,  1091,
    1092,  1093,  1094,  1095,   484,   712,  1038,  3218,  1609,  3557,
    2142,  2721,  3555,  3843,   485,   713,  1104,  2336,  1698,  2790,
    2791,  1694,   486,   487,  1140,  1736,  3306,   736,   737,   488,
     714,  1106,  1107,  1108,  1702,  1703,  2341,  3281,  2798,  1700,
     489,   715,  1111,  1708,   490,   716,  1114,   491,   717,  1115,
     492,   718,  1117,   493,   719,  1120,   494,   720,  1123,  1718,
    2807,  2808,  2350,  2810,  3290,  3292,  1716,   495,   721,  1127,
    3645,  3907,  4077,  4078,  4079,  4553,  4080,  4333,  4334,  4381,
    4081,  4282,  4082,  4083,  4195,  4196,  4084,   496,   722,  1129,
    1662,  2353,  2354,  3621,  1721,   497,   498,  1145,  1743,  3640,
    4374,  3899,  3900,  3901,  4070,  4065,  4318,  4189,  4319,  4320,
    3636,  4057,  4058,  4272,  4366,  4367,  4545,  4546,  4324,  4371,
    4372,  4441,  4446,  2380,   499,  1146,  1745,  4273,  2383,  2836,
    3313,  3904,  2525,  3067,  2526,  2527,  3061,  2528,  2529,  1373,
    2012,  1374,  2010,  1375,  2595,  3115,  2596,  3113,  2597,  3276,
    3607,  3277,  3605,  3278,  2755,  3866,  4052,  2756,  3253,  3254,
    3622,  3882,  3623,  3880,  3624,  2628,  2629,  3136,  2630,  3134,
    2631,  1057,  2264,   738,  3077,  3299,  1022,  1023,   993,   994,
    1422,  1423,  3346,  3347,  3348,  3349,  3680,  3681,  2069,  1424,
    3683,  2090,  2091,  2092,  2093,  2094,  1739,  2376,  1928,   896,
     897,   898,   899,   878,   933,  1343,  1075,  1076,  1138,  1793,
    4278,  1794,   845,  1028,  1097,  1098,  2103,  2104,  1436,  1640,
     912,   913,  1788,  2970,  4142,  4352,  1239,  2964,  2965,  2971,
     151,   314,  1009,   935,  1378,   980,   880,  3887,   881,   882,
    4840,  1943,   902,  4045,  1893,  2296,  3686,  1924,  2572,  3215,
    2706,  3540,  1676,  3123,   923,  1124,  1642,  1832,  2537,  2771,
    2772,  2302,  1833,  1039,  1101,  1118,  3065,  3889,  2879,  3367,
     883,   740,   948,  4223,  4224,   936,   937,   904,  2708,   741,
    1240,  1241,  1817,  1143,  1144,  1834,   822,  2539,  4686,   531,
     326,   884,   328,   329,  4447,   885,   886,   887,   888,  1299,
    1278,  1951,  1935,  1936,  1947,  1940,  1929,  1931,   758,  2809,
    4301,  1323,  1965,  2605,  1655,  1618,   770,  1346,  1994,   358,
    3408,  3497,  3810,   665,   666,   667,    34,   798,  1164,   765,
    4200,  4580,  4737,  4581,   799,   766,  1166,   500,  2816,  2552,
    2478,  1208,  3781,  2888,  1265,  1266,  3454,  1367,  3056,   299,
     168,   549,  2466,  1357,  1887,  3344,  2653,  1203,  1201,   204,
    3969,  1058,  2126,  3223,  3808,  4803,  3835,  4172,  1426,  2147,
     565,  2152,  3513,  2565,  3600,  3628,  4649,  3419,  4309,  4401,
     187,  4859,  4596,  4806,  1191,   786,  4887,   333,  3562,  4042,
    4376,   300,  1888,  3028,  1714,  2878,   155,  3386,  2462,   539,
    4276,  2829,  4402,  1803,  1360,  3202,  3691,  2654,  2550,  2868,
    3657,  3175,  3577,  2109,  2758,  2530,  1376,  4795,  4715,  4797,
    4532,  1344,  4329,  3029,   283,  2968,  3488,  4426,  1815,  2470,
    1337,  2797,   889,  2492,  4131,  4743,  4749,  4853,  4854,  4855,
    4856,  4857,  4591
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     232,   327,   119,   566,  1273,   208,   907,   211,   132,  1921,
    2148,  1711,   216,  1116,  1885,   509,  1069,  1165,   981,   183,
     998,  1100,   258,  1015,  2386,  1176,    60,  1808,   275,  1735,
    1636,   161,   162,  2348,   164,   165,  1171,  1173,  1174,  2744,
    1187,  1181,  2847,   535,  1192,  1193,   992,  1195,  1196,  2947,
    1198,  1199,   152,  1997,   279,   934,  1126,  2531,   159,   156,
     157,   158,  2534,  2070,  1226,  1226,   163,  2535,   178,   170,
     559,  2900,  2089,  3093,  2645,  1686,  1209,  1010,   879,  2475,
    2961,  2962,  1010,  3216,  2655,  1355,   560,  1338,  3106,  2052,
    2053,  2054,  2055,  2387,  2547,   197,   198,   199,   900,  1934,
    1025,  1010,  3375,   932,  3380,  1263,  1188,  1189,  3074,   911,
    1952,  1194,  1040,  3314,  1197,   932,  1675,  1955,  3080,  1099,
     932,  3364,   188,  2621,  1112,  2531,  1348,  3693,  1040,  2356,
    1287,  3714,  1950,  2531,  2858,  3220,   205,  2757,   206,   932,
     256,  2794,   212,   213,  1961,   260,  1383,  3925,  1795,  2674,
    1797,  1798,   223,  1800,  1801,  2644,  2738,  2960,   233,  3190,
    3255,  3377,  1347,  3490,   243,  2265,   149,   248,  3070,  3071,
     250,   149,  1295,   361,  3072,  3073,  2659,  3075,  2575,   507,
    3848,  2577,  4618,  -835,  1397,   895,   276,   562,  2149,  2666,
    2583,  1319,   574,  3176,  2587,  4132,   347,  2513, -3418,   349,
   -1515,  2590,   315,   917,   309,   330,  1280,  1281,   234,   555,
    1810,   550,   336,  1665,  1286,   334,   286,   510,  1297,  2058,
     945,  4904,  1889,  4332,  1747,  4067,   907,   907,   907,   907,
    2465,   985,  2710,  4814,  2095, -3007, -3008,  1321,   359,  1812,
    4166,  2347,  2684,  1827,  3891, -3418,  2105,  1256,  1047,  1049,
    1920,  1821,  2559, -3418,   823,  2347,  2347, -3418,   166,  1326,
    2563,  1306, -3418, -2409,   764,  1611, -1513,  3836, -2409,  2308,
   -3361,  2555,   540,   251,  2636,  2637,  2017,  1061,  2065,  3149,
    3754,  4313,  3150,  1061,  2548,  1922,  4815,  4461,  1040,  3154,
    1348,   578,  3157,  4653,  4901,  4481,  2656,   316,   581,  3226,
    3283,  3284,   202,  -835,  4383,   202,  2764,  4280, -3300, -2289,
     562,  2765,   570,   571,  3331,  3332,  3333, -2409,   900,   900,
     900,   900,   749,  1444,  3233,  3516,  1692,   316,    75,  3959,
   -3278,  1742, -3335,   234,   930,  3516,  1584,  2975,  2711, -3418,
    1256,   316,    59,  3705,  2564,  2014,  2373,   911,  3517,   335,
    1182,    59,  4216,   225,    77,  3589,   532,  2076,  2544, -3018,
    2766,   932,  -624,  2373,  2124,   807, -3055,  3742,  1706, -3418,
   -3418,  2068,  3184,   998,  2363,  3310,  1379, -3418,  4474,    59,
    2536, -3381,  3334,   949,  3481,  1393,   547,  3274,  3590,  2733,
    2805,  4110,  3434,  1646,  1414,   339,  1084,   930,  4913,  1434,
    3438,  2723,   950,  3442,  3443,   350,  3613,  1304, -3418,  2135,
     316,  1710,    36,   235,  2976,  1434,  2373,   -44,  1679, -3418,
    3335,  1633,  1437,   929,  2593,  4868,   944,  3247,  -981,  1294,
    3238,  2477,  3258,  2646, -3270,  4068,  1029,   932, -3270,    87,
    2105,   316,   542,   983,  3841,  4157,  3081,  1760,  -981,  4423,
    3296,  2258, -3361,   932,  1065,   908,  1370,  1072,  4206,  2076,
    2881,   997,  1105,  3967,  1922,  3946,  3151, -1515,  1121,  -981,
    -981, -3406,  2626, -1515, -3418,  2803,  4174,  2722,   907,  4294,
    4212,  4440,  1010,  3384,  3259,  1077,  4137,  1669,  1226,  1434,
    1427,    59,  3939,   108,  4225,  1653,   342,  3376,  3933,  2947,
    1683,  3264,  3265,   908,  1857,   225,  3384,   800,   801,   316,
     316,  4327,  3956,  4191,   987, -3059,     3,  1263,  4741, -3059,
     932,  4328,   806,  1263, -3280,   988,  1040,   932,  2373,   809,
    1294,  3441,  4742, -1513,  2344,  1995,   108,  2545,   235, -1513,
    4905,  1722,     9,   108,  1425,   930,  4544,   824,  4704,  1890,
     277, -3418,    59,  2712,  2373,  2096,  4294,  4138,   768,  3337,
      89,   951,   340,  1925,  3257,  3444,   551,   512,  4369,  1439,
     900, -3280, -1515,  3806, -3302, -3109,  -624,  4206,  3216,   301,
    4111,  4252,  3710,  2724,   830,   563,  2150,  2364,  1059,  2872,
    1654,    75,   769,  4133, -3418,  1622,  2373,  4291,  3304,  2858,
    3913,  1084,  4424,  3385,  4225, -1515,  1267, -1515,  4425,   532,
    2627,   907,   907,   907,  1082,  2373,  4263,    77,   907,   907,
     907,  1946,    79,  1428,  1946,  3553,  3387,  1670,  1991,  1813,
    3482,  1234,  2594,  2506,   907,  2873,  1946,   907, -1513,  1923,
     202,  3455,  2016,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,  4167,  2800,  1740,  1704,  4816,
    3529,  2373,  1294,   918,  3833,  1126,  3842,  2713,   149,  2097,
    -981, -1513,   934, -1513,  3245,   526,  1332,  2685,   343,   317,
     907,  2504,  3275,    37,  4288,   907,  4336, -3418,  3518,  4038,
    1737,  1351,  1336,   225,   286,   542,  3412,  2102, -3280,  2647,
    3849,  2514,   533,   900,   900,   900, -3325, -3376,   563,   317,
     900,   900,   900,  1371,    59,  1394,  2678,  2788,  4205, -3016,
    1954, -3418,   317,   317,  2638,  -981,   900,  2789,  2373,   900,
    3940,  3118,  3152,  1685,  1372,   900,   900,   900,   900,   900,
     900,   900,   900,   900,   900,   900,   900,   533, -1524,  1186,
    1013,  1055,  3363,  3892,  2564,  2531,  -559,   318,  -981,  2664,
     992,  3208,  2500,  4337,  2674,  2899,  4869, -3270,  1013,  3248,
    -981,  1083,   900,   319,   934,  4099,  2007,   900,  1204,  -981,
    2582,  2536,   857,   858,  2600,   317,  4168,   318,  1443,  2531,
    2262,   860,   317,   861,   952,  3514,  2300,  1939,  1939,  1939,
     318,   318,  -559,   319, -2827,  2792, -3300,  2125,  1245,  1259,
    1890,  3970,  4169,  1960,   997,   784,   319,   319,  1923,  3227,
    1647,  3027,  1954,   317, -3278, -3418,  3239,  3850,  2507,   919,
     533,  3616,  3755,  1084,  1645,   750,  1256,  4205, -3278, -3278,
     567,  4680,  1956, -1515,  4281,  3767,   533, -3109,   751,  1142,
     302,   286, -3335,  1183,   860, -3280,   861, -3410, -3418,  1992,
     533,  2736, -3320,   318,  1996,  2066,  3422,  3336,  -559,   286,
     318, -3410,   749, -3280,  2107,  -624,  4675,  1147,  2143,   319,
    1995,   351,   352,   353,   532,    79,   319,  3591,  -624,  4021,
   -2289,   317,   317,  2754,   341,  2649,  -244,  2650,  -981, -3320,
    2515,   318, -3418,  1738,  4112,  3234,  1584,   207,   207, -1513,
    4134,   286,  4115,  2086,  2017, -3280,  3088,   319,   207,   342,
      87, -3270, -3270,  4285,   207,  2136,  4462,   868,   207,  1294,
   -3270,  2297,  -981,   317, -3270, -1524,   320,  3656,  3085,  2562,
    2549,   764,   252,  2057,  2059,  3228,   907,  4384,   207,  4619,
    2374,  3519,  2549,  2814, -3418,  2067,   533,   236,   237,  3185,
    2977,  2497,  2498,   533, -2409, -2409,   320,  2374, -1556,   318,
     318,  3516,  1425,  3943,  3140,  1148,   207,  2947,   533,   320,
     320,  3089,  3420,   533,   544,   319,   319,  -559,  3867,  -981,
     868, -3320,  1149,  2641,  3796,   253,   831,  2305,  1307,  3893,
     354,   791,   860,  1308,   861,  3551,   934,  4267,   207,  2151,
   -3284,   318,   207,  1010,  1791,  2086,  1792,  4475,  1267,  1796,
    2374,  2639,   207,  1811,  1267,  3708,   421,   319,  1806,  4870,
    -981,  2257,   512,  3812,  1370,  1807,  1789,  1790,   900,  1828,
     -44,    89,   320,  -559, -3280,  2375,  1799,   930,   278,   320,
   -1524,   932,   513,  1147,  1954,  1142,  1741,  4705,  2137,  2488,
    2489,   556, -3105,  3851,   321,  2494,  3412,  1814,  2495,  1819,
   -3278,  4135, -3381,  1434,   287,  2502, -1556,   907, -3109,  -624,
     320,  2696,   236,   237, -3278, -3278, -3109,  2874,   832,   934,
    2714,  4170,  3914,  3200,   321,  1336, -1507,   508,  -559,  1998,
    1398,   343,   533,  4159, -3406,   310,  3960,   321,   321, -1524,
    2592,   932,  -559, -3418,  2098, -3107,   150,  1752,   238,  1147,
    3852,   150,  2686,  3554,  1999,  2004,  3934,   207,   930,   508,
    4620,  -559,  2374, -3416,  1016,  -559,   207,  1954,   868,  3128,
    4069,   428,   322,  2021,   552,  2599,   750,  -981,   320,   320,
    3752,  1148, -3418,   207,   207,  2538,   207, -3300,  2374,  1890,
     734,  4817,  2503,  3141,  1990,  3245,  4718,  1786,  1149,   900,
     321,   901,   322,   527,  4153,   792,  2259,   321, -3304,  2505,
     533,  2598,  3615,  3320,  3617,   322,   322,  4039,   533,  1881,
     320,  3633,  3504,  3505,  3506,  3507,   172,  1156, -3325,  2015,
    2374,   792,    59,  1370, -3418,  4370,  4116,  2589,   321,  1741,
    1030,   207,   207,   288,  2573,  2571,    72,  1148,  3440,  2374,
    3652,  4549,   355,   356,  3494,  1820,  4127,  2579,  3971,  1822,
     323,   287,  3700, -3418,  1149,   357,   514,  1636,  2323,  4253,
    4128,  1679,  1835,   238,  -981,   324,  3687,   533,   322,   287,
     562,   207,  1704, -3101,   207,   322,  2378,  4012,  3267,  2345,
     207,  -981,  4338, -3270,  1235,  2374,  3403,  4838,   515,  2674,
     225,  4053,  1946,   207,  2689,   324,   321,   321,  1687,  4687,
    2016,  4339,   833,   207,  1002,  2370,   322,   834,   324,   324,
    3433,   287,    59,   918,  2015, -3103,  4030,  1309,  4340,  1310,
    1311,  1312,  1313,  1314,  1315,  -559,  1307,  4593,  3523,  3522,
    3525,  1308,  1372,  2145, -3096,  2072,  2073,  2074,   321,  3045,
     289,    73,  4550,  3746,  2969,  2363,  4625,  3972,  3747,   839,
    3831, -3376,  2374,  3832,  3483,   533,   207,  -559,  3947,   934,
     835,  4551,  -559,   207,  4190,  2953,  4442,  2768,   813,  3058,
   -3109,   324, -3418,  4284,   322,   322,  3560, -3418,   324,  3107,
    2603,   918,  -559, -1507,  -559,  1040,   533,  2128,  2857, -1507,
     288,   261,  2144,  1212,  2692,  3761, -3418,  4668, -3418,    74,
    2371,  2315,    75,   932,    76,   750,   202,   932,   288,   324,
    3869,   901,   901,   901,   901,  1156,   322,  3095,   751,  3097,
    3752,  2887,  3099,  4885,   930,  3101,  3102,  3103,    77,  3105,
    2679,  1658,  3109,   793,  3610,  3868,  3612, -3270, -3270,  2611,
   -3418,  2075,  3590,  3121,  3122,  2707,  2795,  3941,   331,   225,
     288,  3104,   759,   836,   225,   317,  2312,  3857,  2304,   793,
    4443,  1837,   207,  3030,  3031,  1838,  3748,  2697,  1013,  3033,
    3034,  1213,  4143,  4355,   225,  4014,  2700,   324,   324,   919,
    4160,  2337,  3948,  4269,  3797,   184,  3258,  1215, -1507,  1018,
     225,   301, -3418,    -7, -3451,  2775,  3079,   289,  2948,  2949,
    1988,  1372,  2363,  2723,   207,  3888,   932,  1084,  4412,   202,
    3177,  4748,  3179,  3221,  2580,   289, -3452,   281,  3069,   324,
    4552, -1507,    78, -1507,   860,  3783,   861,  1157,  1899,  2384,
    1603,   225,  3790,   318,  4218,  1900,   317,   513,  3259,  1158,
    -559,  1003,   290,  3144,  -559,  1004,  2325,    12,  1159,   319,
    2482,  3084,  1989,  3499,  2863,  2891,  4040,   289,  2364, -3418,
   -3300,  1804,  2493,  2865,  2493,  2326,  2493,  2493,    15,  2493,
    2493,  4412,  2297,   725,  3570,  1005,  4403,  1294,  1641,  3225,
    4839,  4841,  3111,  3112,  2950,   742,    27,  3818,  3949,  1370,
    3089,  1016,   209,  4594,   209,  1748,  4851,   110,  4344,   209,
    3294,   541,  3155,  3156,   267,   860,  2483,   861,  4161, -3109,
    4879,  2076, -1482,  -559,   318,  3132,  3133,  4345,   202,   543,
    1646,  2802,  3358,  1236,   225,  3142,   760,  4692,  4874,  2573,
     319,  3541,   794,  3632,  4452,  3834,   533,  1333,   150,  4073,
     110,   209,  4015,  4032,   -69,  3950,  2773,   110,    33,  3285,
    1217,  4886,   207,  3751,  -559,  2372,  2707,  2487,   794,  4431,
     868,   808,  3143,   901,  3186,  4519,  1010,  1434,   563,  1679,
   -1971,  4818,  1659,  2114,  4693, -3300,  2115,  2116,  1006,  2866,
    2317,  3647,  3194,  3648,  2732,  2724, -3018,   282, -3018, -3018,
   -3018, -3018, -3018, -3018,  4435,  3222,    79,  2077,  2078,  2335,
     533,  1160,  -325,  1749,   932,   932,   932,  1016,   207,  3423,
    1341,  3230,   320,  3541,  2044,  2364,   840,   544,  1237,   536,
    2880,   514,  2731,  2389,  2886,  1157,  2748,  3424,    -6,  3232,
    4889,  2626,   907,   907,   247,  4144,  3059,  1158, -3300,  4693,
     814,   868,  4890,  3252,   795,  3359,  1159,  3256,  2581,  2955,
    4178,  4444,  4308,   515,   191,  4693,  2146, -3018,  1161, -1507,
    3888,  2399,   302,   207,  2796,  2461,  2464,  4356,  2467,  2618,
     795,  2472,  2474,  2894,  2476,  2079,  2080,  4161,  1218,  1040,
    3786,  3032,   225,  2481,   533,  3041,   207,  4239,  2954,  2980,
      80,  3026,   932,   320,  1839,   815,   901,   901,   901,  1162,
    2867,  2021,  3108,   901,   901,   901,  3117,   262, -3300,   726,
     533,  3797,   317,  3303,  3295,   317,   332,   207,  2892,   901,
    4436,   743,   901,  2607,   900,   900,  4404,    43,   901,   901,
     901,   901,   901,   901,   901,   901,   901,   901,   901,   901,
     321,   761,  4182,  4074,  2081,   762,  2625,   796,  1334,  3858,
    2540,  3092,  3999,  2857,   207,  1604,  2541,  4246,  4712,  2542,
    3859,  2543,  4713,  3288,  2754,   901,  4008,  1372,   207,  2627,
     901, -3418,  2538,   796,   508,  2327,  3461,  3462,  2773,  2082,
    2773,   860,  2538,   861,  4210,  3421,  4264,  4265,  2083,  4085,
     318,  4027,   202,   318,  2778, -3418,  3749,  2084,    16,  1160,
      17,  4437,  3110,  1688,   533,   225,   319,  4075,   812,   319,
     816,  2831,  2833,  4403,  2710,   268,  1163,  4145,   322,  4695,
    3951,   321,   207,  4519,  1605,    -6,  1018,   207,  1899,  1370,
    1628,   907,  4445,   907,  2328,  1900,  1210,  1831,  2269,  3495,
    2085,  3591,  2770,  1946,   207,  4427,  2613,   207,  1840,  1841,
   -3018,   122,    83,   202,  1689,   763,  1161,   907,    -6,  1221,
      -6,  4023,  1831,   207,  2951,  3632,   317, -3451,  3384,  2329,
    -874,  3541,  4076,  4028,  4029,  3942,  1212,   176,  4680,  4694,
    2966,   907, -3451, -3418,  4695,  4663,  2773,  2773, -3419, -3452,
    3138,   930,  2729,  1017,  4670, -1971,  2622,  1162,    28,   322,
    4695,  3820,  4772,  4813, -3452,  3360,   207,  3456,  2270,  2271,
    2272,  2273,  3476,  2274,  2077,  2078,  3952,   868,  3127,  3682,
    2711,   324, -2896,   900,    47,   900,  4054,  2707,  2351,   244,
     763,  1629,  2648,    86,  4520, -3418,  4117,  4118,  2988, -3418,
    4521,  2658,  1018,  2735,   528,    87,  3565,  1647,   932,   900,
    1630,   771,  3484,   729,  1213,  3144,   932,  4522,  2614,   787,
     319,  1645,  2952,  3768, -1971,  3178,   202,  3180,   173,   320,
    1215,  3619,   320,   900,  1679,  4540,    72,  2330,   317,  4523,
     772,  2352,    52,    88,  -325,  1925,  4149,   207,  3389,   207,
    3384,  2761,  2079,  2080,  2989,  2275,  2276,   773,   774,   533,
   -1482,  4226,   324,  4696,  4701,  3396,   905,   914,    54, -3418,
    2831,   938,  2831,   932,  1163,   932,  1316,   123,  4405,  3425,
   -3420,  2799,  4435,   938,  1012,  2897,  1317,  3477,   938,  1156,
      56,   901,  1041,  2799,   934,   317,  3120,  4394,  3769,  4542,
    4543,  1211,  1434,  1070,  3435,  1070,   942,  1102,  1041, -3400,
    4582,  4583,  -874,   907,  4406,  3545,   318,  3384,  1070,  3224,
    3131,  2774,  -325,  4404,  1139,  1679,    89,  2086,    75,   788,
     789,  2087,   319,  2088,  2117,  2118,  1333,    90,  -325,  2521,
     932,    73,   932,   582,   583,  2967,  1371,  4540,  1370,    59,
    2331,  3258,  1645,  1679,    77,   245,    -6,   321,  2880, -3320,
     321,   133,    59,  4438,   934,  2626,  3302,  1372,  3546,  1631,
    3391,  3501,  2113,   528,  4645,  4646,  2114,  3821,   775,  2115,
    2116,  2551,  1206,   320,  4439,  4247,  2119,  2120,   763,   319,
    2839,   730, -3300,  1217,  4826,  2712,  3592,  3593, -3270,    74,
     508,  4880,    75,  3259,    76,   900,  4659,  1645,  4436,   225,
     281,  4836,   932,  4662,    59,  3566,  2883,  4665,   317,  3543,
    4667,  1073,   901,  3603,  3604,  3037,  1342,  3039,    77,  2493,
     207,  4165,  3426,    58,  4192,   322,  4756,  3393,   322,  4678,
    4679,  1010,  2277,  2278,  2279,  2280,  2281,  2282,  2283,  2284,
    2285,  3638,  4520,  3639,  1354,  1212, -2201,  2593,  4521,  3342,
    2623,   226,   584,  4298,   227,  4881,  3372,  3427,  1041,  3773,
    3903,  2959,  3502,  4156,   166,  4522,  3428,  3651,  2972,   932,
    2779,  2780,  2781,  2782,  2783,  2784,  2785,  2786,  1307,  4437,
    3510,  2266,  3273,  1308,  4108,   320,   318,  4523,  3436,  3620,
    4882,  -325,    59,  2627,   932,   914, -2896,  3266,  3920,  2713,
    3682,   321,   319,   226,  4721,   207,   227,  4722,  4875,   167,
    2842,  1218,    78,   207,  2267,  2332,   207,   533,   207,   938,
    3282,  4774,  3092,  1213, -2201,  2521,  1214,  4775,   324,   317,
      61,   324, -3018,  3567,  1370,   916,   776,  1334,    63,  1215,
   -2201,  4746,   320,  2774,  4777,  2774,  2846,   777,  2947,  3307,
    3307,  3125,  1142,  4861,   207,  2134,    59,  2869,  2870,  2871,
     731,  4165,  2773,    68,  1695,  2286,  4778,  1307,  2134,  4378,
     282,  1216,  1308,  2895,  2896,  2898, -3349,  4894,   118,   322,
    2461,   120,  1212,  4807,  3485,  4215,  4883,  1132,  4830,  1157,
    3341,  3601,  3602,  2490,  2491,   938,  4747,   533,   860,  1051,
     861,  1158,  3100, -2255,  4109,  4405,  4862,   318,  4691,  4908,
    1159,   938,    79,   321,   134,  2524,  1372,   135,   136,  -325,
    4860,  4884,  2473,   319,  4394,  2557,  2321,  4379,  2974,  2979,
    2558,  3568,  4741,  3148,   732, -3018, -3400,  2322,  2087,   130,
    2088,  4406,  4691,  1644, -3018, -3018,  4742,   125,  1142, -3018,
    4391,  2774,  2774,  4897,   138,  2594,  2496,  3043,  3044,  3078,
    1213,  3078, -3420,  1214,  2707,   320,  4895,  4896,  1696,  4380,
     321,   225,  4468, -3420,  1697,  3828,  1215,  3582,   938,  3840,
     778,   111,   324,  1712,  3246,   938,    79,   585,   733,  1713,
    3486,   322,  1221,   139,  3487,  2468,  1041,  -325,  3511,  2593,
    3076,  2469,  1217, -2201, -2255,   142,  3539,  3082,  1216,  2287,
    1060,  1679,   145,  1067, -3418,  3528,  4600,  1081,  3512,  1679,
    4424,   779,  1139, -2255,   111,  4606,  4425,  4831,  1963,  4584,
    4832,   111,  2288,  4609,   868,  1927,  1930,  1933,  1307,  1307,
     780,   734,  2377,  1308,  1308,  1307,  2707,  2761,   322,  4865,
    1308,  -325,  1307,   147,  4867,  3301,   146,  1308,  3878,  3879,
    4863,  1962,  4918,  1160,  4919,  -325,  4920,  3078,  3078,   153,
   -3349,  4063,   154,   209,   209,   932,  3309,   932,   176,   207,
      80,   160,  2129,   209,    81,  -325,   320,  1307,  4724,  2522,
     180,  2523,  1308,   321,   324,  3779,  3780,  4833,  3695,  4469,
    -325,  2131,  2132,  2133,  3626,  4725,  3475,  1645,  3627,  2366,
    3475,  2524,  1372,  2366,  4693,    16,   316,    17,  4647,  4648,
    1161,  4736,  3966,   932,  4470,  4471,  4472,  3498,  2848,   186,
    1218, -2201,   925,   189,   508,  1219,  1220,   195,  1307,  1217,
    4726,   207,  1041,  1308,  4391,  1645,  4003,  1645,   210,  4754,
    4755,   324,  2533,  4804,   207,  4759,  1302,  1303,  4799,  1305,
     218,  1162,  4800,  4801,  3508,  2601,   240,  2117,  2118,   735,
    4025,   322,  2393,   241,  2394,  1307,  3569,   202,  1957,  2624,
    1308,   255, -2255,   932,  2522,  4598,  2523,   907,  1764,    55,
    3570,    57,   280,  1645,  3792,  4598,  1633,   284,  4727,   285,
    4392,  3743,  1434,    82,  1645,  1966,  1967,  2594,   290, -2201,
     310,  3745,  1941,  1942,   321, -2986, -2986, -2986, -2986,  2119,
    2120,  4728,  2714,  1386,  1387,  1388,  1389,   337,   338,  3447,
   -2985, -2985, -2985, -2985,  1765,  1641,  3388,  3390,  3392,  3394,
     932,   348,    83,   360,  1294,   502,   537,   538,   546,  2493,
    2493,   547,  2493,  2493,  3037,   554,   567,  3581,   569,   580,
     288,  1362,  3896,  3086,  3087,   723,  4036,  1218,   727,   784,
     746,   745,  2773,   804,   324,   316,   805,   225,  1163,   900,
    1957,   810,   811,   817,   819,  4623,  3917,   316,   818,    84,
    3446,    85,   322,   820,   826,   940,   999, -2201,  1013,  2848,
    1766,  1035,  1026,  1050,  2707,   781,   782,  1051,  1059,   508,
    1131,  1221, -2201,  1113,  1142,  3327,  1167,  1168,  1185, -1122,
    1190,  1200,   914,    86,  1968,  1969,  1970,  1971,  1972,  1973,
    1974,  1975,  1976,  1977,  1202,    87,  1207,  1233,   207,  1251,
    1243,  1253,  1247,  1268,  1270,  1272,  1275,   901,   901, -3400,
    1276,  1290,  1277,  1318,  1322,  1279,  4266,  1282,  1325,  4695,
    1283,  1284,  1285,  1288,  1298,  1300,  1641,  1633,  1227,  3684,
    1327,  1301,  1339,    88,  3822,   533,  3823,  2774, -1122,  1354,
     207,  1352,  1345,  1356,  1359,  1361,  1364,  1366,  1368,  1381,
   -1122,  3890,   763,  1390,  4392,   324,  1391,  1430,  1395,  1432,
    1228,  1229,  1435,  1440,  1610,  1620,  1623,  1624,  1626,  1649,
    1648,  1651,  3473,  1656,  1661,  2849,  1663,  1666,  1667,  1672,
    3905,  1641,   932,   848,   932,  1671,  3571,   508,  3431,   849,
     850,  3432,  1680,  4248,  4249,  1084,  1691, -1122,  1684,  3535,
    1693,  1701,  1699,   166,  3439,   852,  4325,  1707,  1221,  2493,
    1715,  3542,  3448,  3449,  1717,  1720,    89,  4805,  4842,  4746,
   -1122,  1723,  1724,  3576,  1731,  1733,  1741,    90,  1753,  1759,
    1754,  1802,  1763,  1761,   202,  3588, -3400,  1896,  1845,  1816,
    1926,  1949,  1937,  2148,  1938,  4228,  1948,  1959,  1964,  1978,
    4805,  1980,  4393,   908,  1993,  1999,  2006,  1371,   317,  2049,
    2051, -3400, -3400, -3400,  2062,  2102,  2108,  2110,  2123,   938,
    2256,  4394,  1957,  2260,  4843,  2263,  2268,  2299, -1122,   533,
    2298,   907,  2301,  2306,  3813,  3814,  3815,  3816,  4395,  2313,
      59,  2324,  2340,  3542,  2314,  2316,  4211,  2342,  2347,  2357,
    2343,  2379,  3492, -3400,  1767,  3641,   901,  4449,   901,  2346,
    4741,  4760,  2349,  2390,  2359,  2361,  2381,   857,   858,  2391,
    4107,  2477,  2465,   759,  4742,  2499,  2479,  1768,    84,   938,
    2519,  1645,   901,  2532,  1645,  2533,   318,  2551,  4353,  2554,
    2556,  2560,  2553,  2568,  2566,  2561,  2849,  2564,  2773,  2567,
    2576,  2578,   319,  2570,  2584,  1957,   901, -2942,  2585,  4254,
    4255,  2586, -1122,  2588,  4260,  2072,  2073,  2074,  2591,  2602,
    2604,  2608,  2610,   900,  2616,  2619,  2620,  2665,   853,   854,
     855,  2632,  1645,  2667,  2675,  1645,  2677,  1645,  2680,  2694,
     856,  4530,  3658,  2698,  2403,  4418,  3711,  2136,  2726,  2734,
     316,  1055,  2749,  2777,   207,  2762,  3890,  2769,  2804,  2806,
    2815,  3692,  2848,  3694,  2817,  2819,  2823,   317,  1645,  2825,
    2828,  2835,  2837,  2862,  2844,  4097,  4098,  4048,  2863,   317,
   -3400,  2877,  2867,  2876,   209,  2493, -1122,  2885,  2887,  2889,
    2890,  2958,  2901,  2963,  4761,  2973,  4393,  1899,  4762,    85,
    2850,  3049,  3083, -3035,  1900, -3400, -3400, -3400,  1890,  3052,
    3684,  1156,  3098,  2593,  2594,  4394, -3017,  3129,  3753,  2626,
    2627,  2075,  3153,  3181,  3182,  3759,  3188,  3189,   859,  3191,
    1633,  3195,  4395,  3196,  3203,  3205,  3204,  3219,   857,   858,
    3236,  1041,  3609,  3237,  1789,   318,  3262,   760,  2754,   862,
     863,   864,  3649,  3286,  3784,  3279,  3287,   318,   865,  3289,
    3291,   319,  3298,  3791,  3311,   320,  3312, -1122,  3793,  3794,
    3315,  3316,  3322,   319,  3343,  3324,  3330,  3646,   901,  1769,
    3350,  3328,  3353,  3355,  1770,  3366,  3373,  3356,  3381,  3535,
    3395,  3401,  3405,  3407,  3410,  3415,  3413,  2774,  3418, -1122,
     286,  3542,  3437,  4261,  1771,  3450,  1772,  3452,  3453,  3460,
      82,  3451,  2773,  3491,  4179,  3458,  3576,  3496, -2947,  3500,
   -3015,  3544,  3558,  3697,  3524,  4270,  3526,  3552, -3010,  3561,
    3872,  3873,  3578,  3564,  3530,  3584,  3583,  3706,  3247,  4201,
    3248,  1641,  3598,  3599,   867,  1041,  3274,  3275,  3637,  3635,
    3642,   938,  3650,  3685,  3643,   938,  3688,  2536,  3701,  4031,
    4181,  3715,  3690,  3845,  3744,  4033,  4034,  3787,  3798,  4227,
    3804,  2850,  3788,  3800,  3802,  3807,  3809,   914,  3819,  1641,
    3824,  1641,  3829,  3902,  1679,  4554,  3830,  3834,  3545,  3546,
   -3419,  2076,  3839,   321,  3861,  3856,  3765,  3766,  3863,  4530,
   -1122,  3772,  3659,  3775,  3776,  3777,  3778,  3620,  4322,  3870,
    3871,  3619,  3897,  3785,  3906,  3912,  3916,  3908,  1645,  3921,
    3922,  3924,  3926,  3927,   320,  3931,  3944,  1641,  3954,  3937,
    3957,  4009,  3930,  4010,  4011,  4018,   320,  4043,  1641,  3799,
    4049,  4037,  4041,  3958,  4763,  4090,  4064,  4283,  2773,  2849,
    4071,  4091,  4095,  4844,   938,  4113,  4119,  4114,  2851,  4125,
    2852,  4120,   761,  4845,  4846,  4126,   762,  1645,  4796,  2853,
    2854,   322,  1181,  2855,  2856,  4188, -1122,  2077,  2078,   869,
   -1122,  4197,  4198,  4203,  4099,  4221,  4073,  4251,  4234,  4160,
    4274,  4275,  4310,  3923,  4311,  2683,  4271,  4148,  2409,  3711,
    4312,  3965,  4317,  1679,  4323,  4358,  4158,  4362,  4361,  4386,
   -3391,  4387,  4375,  4388,  4290,  4347,  4277,  4389,  4350,  3846,
    4331,  1157,  4421,  4419,  3929,  4428,  4454,  4764,  4451,  4460,
    4463,  4765,   317,  1158,  4464,  1773,  4467,  4473,  4476,  4477,
    4480,  4537,  1159,  2545,  4847,  4548,  4608,  3864,  4614,  4652,
    4651,  4756,   321,  4335,  4802,  2079,  2080,  4173,  4858,  4909,
    4911, -1122,  4346,  4910,   321,  4916,  4848,  4849,  4922,  2493,
      35,  3474,   129,  3051,   324,   249,   763,    32,   870,   871,
    3911,   577,   171,  1823,  2509,   545,  2487,   307,  3471,  3046,
     557,   857,   858,  4766,   174,  3974,   573,  1231,   222,  1809,
     802,  3998,   561,  4335,  4016,   308,  4001,  4002,  4354,  3007,
     318,   803,  4245,  2774,  4005,  4622,  4007,  3774,  4229,  4307,
     797,  3782, -1122,  3457,  2081,  4450,   319,  1250,  3795,  2851,
     322,  2852,    67,  4300,  4122,  4390,  4465,  4767,  4478,  3764,
    2853,  2854,   322,  3902,  2855,  2856,  1175,  2737,   873,  2538,
    3661,  2880,   938,   938,   938,  2904,  2398,  4898,  4773,  2082,
    2942,  2943,  4296,  4217,   914,  2725,  4351,  4779,  2083,  3707,
    3709,  3326,  3048,  3713,  2412,   874,  4690,  2084,  4735,  1679,
    4787,  3383,  4864,   875,  4866,  4768,  4289,  4672,  4417,  1042,
    4617,  2130,  4601,  4602,  4702,  1160,  4605,  4615,  2512,  4013,
    3057,  3801, -1122,  3886,   501,  4152,  1830,  1836,  3493,  1619,
    3489,   876,  1041,  2546,  4086,  2606,  3126,  1884,   207,  1324,
    2085,  4259,  3811,  3884,  2850,  4257,  1987,  1330,   986,  3692,
    3975,  2005,  1377,   324,  2056,  2642,  2660,  3826,  3509,  1041,
     938,  1385,  1043,  2060,  3139,   324,  3187,  3527,  1433,  4006,
    4130,  2063,  1161,  3827,  2690,  3536,  3537,  2122,  1608,  3717,
    2719,  4155,  3550,  4017, -1122,  2493,  3206,  4186,  3838,  4056,
    1627,  2739,  3580,  3837,  4123,  2360,  1650,  2751,  1438,  3243,
     316,  3587,  3855,  3597,  3595,  3293,  2369,  2362,  3305,   320,
    2309,  2787,  2848,  1162,  1681,  1682,  2864,  3308,  2339,  2812,
    1103,  3614,  4035,  4382,  4124,  1641,  2813,  4279,  1641,  2763,
    4066,  2750,  4364,  2305,  4433,  3895,  4184,  4547,  3718,  2382,
    4448,  3068,  4016,  3062,  3397,  3114,  2011,  2774,  2417,  2013,
    3719,  3116,  3618,  3608,  4141,  3606,  4051,  3883,  3881,  3137,
    4769,  3625,  3135,  1329,  1096,  2071,  3918,  3269,  3270,  3271,
    1645,  3272,  1130,  3757,  2691,  1730,  1641,  1982,  3417,  1641,
    1633,  1641,   901,   564,  4055,  2776,  4604,  4046,   209,  4072,
    4297,  3042,  4770,  1985,  1244,  4624,  1289,  3720,  1232,  4093,
    2400,  4304,  2793,  3409,  3130,  3611,  4242,  4244,  4242,  3875,
    3717,  4588,  1641,  4106,  4202,  1785,  4794,  3515,  4193,  2957,
    3721,  3538,  4022,  4714,  4231,  4828,  1271,  4811,  4888,   568,
    1163,  4220,  3563,   579,  2830,  3760,  2657,   321,  4716,  3703,
    4538,  3038,  2471,  4852,  4004,     0,  4213,  4214,     0,     0,
    1041,  1041,  1844, -3391,     0,     0,  1041,  1041,  1041,  1041,
    4771,     0,  4268,     0,  1041,     0,  1041,  2086,  1041,  3718,
       0,  2087,     0,  2088,  4719,     0,     0,     0,  3722,     0,
       0,  3719,     0,  2774,     0,     0,  2420,     0,     0,  4738,
    4147,     0,  4302,  4150,  4151,     0,     0,     0,  4302,   209,
       0,     0,  2851,  2393,  2852,  2394,     0,  4708,  2424,     0,
       0,     0,     0,  2853,  2854,   322,   938,  2855,  2856,     0,
    4175,  4176,  4177,  4738,   938,     0,  4330,  4720,  3720,     0,
       0,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4185,  2848,   763,     0,     0,  4187,     0,  3209,
       0,  3721,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1041,  3723,     0,  1041,     0,     0,     0,     0,     0,
       0,  1041,  1041,  1041,  1041,     0,  4299,     0,     0,  3919,
    4377,   938,     0,   938,     0,     0,  4306,  4306,     0,  -919,
       0,  4315,  4316,     0,     0,     0,     0,     0,     0,  2849,
       0,  -919,  4250,  2683,     0,  2894,     0,     0,     0,  3722,
       0,  1633,     0,     0,     0,     0,     0,     0,   324,     0,
    4233,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3725,     0,     0,     0,
       0,     0,  4432,     0,     0,  4899,   907,   907,   938,     0,
     938,     0,     0,     0,     0,  3210,     0,     0,     0,     0,
       0,     0,  1641,     0,     0,     0,     0,     0,     0,  -919,
       0,     0,     0,     0,     0,     0,   907,     0,     0,     0,
       0,     0,   317,     0,     0,     0,     0,     0,     0,  4242,
       0,     0,     0,  3723,     0,     0,  1256,   848,     0,     0,
       0,  4295,     0,   849,   850,     0,  4422,     0,     0,     0,
       0,  1641,     0,     0,     0,     0,   901,  3726,     0,   852,
     938,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1041,     0,     0,     0,     0,     0,   900,   900,
    4535,   857,   858,     0,  3158,  4590,  3159,     0,     0,  3728,
       0,     0,     0,     0,     0,     0,     0,     0,  3724,     0,
     318,     0,     0,     0,     0,     0,     0,  3725,   900, -1986,
       0,     0,     0,     0,  2304,     0,   319,     0,     0,  4556,
       0,     0,     0,     0,     0,     0,  4357,   938,     0,     0,
   -3270,     0,     0,     0, -3270,  4359,     0,     0,     0,     0,
    4363,  4242,     0,  2493,  4365,  4673,     0,     0,     0,     0,
       0,     0,   938,     0,     0,     0,     0,     0,   739,  4385,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2849,  4607,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4429,  4430,     0,     0,  3726,     0,
    4415,  4434,     0,     0,     0,  3727,     0,     0,     0,     0,
       0,     0,  4044,     0,     0,     0,  4453,     0,     0,  4456,
    4457,  4458,  4459,     0,  2850,     0,     0,     0,     0,     0,
    3728,  3976,  3977,  3978,     0,     0,     0,     0,  -919,     0,
       0,     0,   853,   854,   855,     0,     0,  4531,     0,     0,
       0,     0,     0,     0,   856,     0,     0,     0,  3729,     0,
       0,     0,     0,   317,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4664,  3730,     0,     0,     0,
    3731,   317,     0,     0,  4671,     0,     0,     0,     0,   320,
       0,     0,     0,  4561,  4562,  4563,  4564,  4565,     0,     0,
    4567,  4568,  4569,  4570,  4571,  4572,  4573,  4574,  4575,  4576,
    4577,     0,     0,  4579,     0,  4589,     0,  4592,     0,     0,
       0,  -919,   857,   858,  4685,     0,  4599,     0,     0,  4603,
       0,     0,     0,     0,  3211,     0,     0,     0,     0,     0,
       0,   318,   859,     0,     0,     0,     0,     0,  1041,     0,
     846,  4612,   903,  3979,  3980,   924,  3981,   319,     0,   318,
     947,  3732,   982,   862,   863,   864,   996,  1897,  1898,     0,
       0,     0,   865,     0,     0,   319,  1034,     0,     0,  1034,
    -919,  -919,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,  4685,  3160,     0,     0,     0,     0,     0,     0,  -919,
    1119,     0,  1125,  1128,     0,     0,  1645,  3730,     0,     0,
       0,  3731,     0,     0,     0,  -919,  1141,   321,     0,  4685,
    4685,     0,  3733,     0,     0,  4685,     0,  1041,  4685,  4660,
       0,  4661,  4685,  4685,     0,     0,     0,     0,     0,     0,
    1645,  4669,  4809,   938,  1641,   938,     0,     0,     0,     0,
       0,     0,     0,     0,  2683,  2850,     0,     0,   867, -1986,
       0,     0,     0,     0,     0,     0,  4827,     0,     0,     0,
       0,  1899,     0, -3270,     0,     0,     0,  3161,  1900,     0,
       0,  1901,  2851,  4837,  2852,  4689,     0,     0,     0,     0,
       0,   938,  3732,  2853,  2854,   322,  4685,  2855,  2856,     0,
    4827,  4685,  3736,     0,     0,  4531,     0,     0,     0,     0,
       0,  4873,     0,  -919,     0,     0,     0,     0,     0,     0,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1274,     0,  1902,     0,     0,   320,     0,
    1903,  1904,     0,     0,     0,  3982,  3983,     0,     0,     0,
       0,   938,     0,  3733,     0,  3397,     0,     0,  4744,  4745,
       0,  4750,     0,     0,  3738,     0,     0,  3734,     0,     0,
    3984,     0,   903,   903,   903,   903,  4753,     0,  -919,     0,
       0,  4757,  4758,     0,     0,     0,  4921,     0,     0,     0,
     906,  3735,     0,   869,  3662,   939,  3985,     0,   324,  4808,
       0,     0,  4810,   924,  4812,     0,     0,   939,   938,     0,
       0,     0,   939,  -919,     0,     0,     0,     0,     0,     0,
       0,  3986,     0,  1905,     0,  1906,  3162, -3270, -3270,     0,
    1358,   939,  1907,  3736,     0,     0,     0,     0,     0,     0,
       0,  1908,     0,     0,     0,     0,     0,     0,   321,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   209,     0,  3737,     0,     0,     0,     0,     0,     0,
       0,     0,   870,   871,     0,  3738,     0,  3763,  3763,  1063,
       0,     0,  3739,     0,  3740,     0,  -919,     0,     0,     0,
       0,     0,  1445,  2851,   209,  2852,     0,     0,     0,   996,
       0,   209, -1986,  3987,  2853,  2854,   322,     0,  2855,  2856,
       0,     0,     0,     0,   316,     0,     0,     0,     0,  1643,
       0,     0,     0,     0,   322,     0,     0,     0,     0,     0,
    1909,     0,     0,     0,     0,     0,  3988,  3212,  1041,     0,
    3989,  3990,   873,     0,  1677,     0,     0,     0,  3163,     0,
       0,  -919,     0,  -919,     0,     0,     0,     0,     0,     0,
       0,     0,  -919,  -919,  -919,     0,  -919,  -919,  3991,   874,
     938,  1705,   938,     0,     0,     0,     0,   875,     0,     0,
       0,  1910,  1296,     0,     0,  1911,     0,     0,     0,  1719,
     906,   906,   906,   906,  1633,     0,  1726,  1728,     0,     0,
       0,  1320,     0,  3847,   903,   876,     0,  1744,  1746,   324,
       0,     0,   207,     0,     0,     0,     0,     0,     0,  1912,
       0,     0,  1084,     0,     0,     0,     0,   324,     0, -1986,
       0,     0,     0,   939,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3164,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   848,     0,     0,     0,     0,  -919,   849,   850,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   852,     0,     0,  1070,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   939,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   939,     0,     0,     0,     0,
    1894,  1895,     0,   533,     0,  3992,     0,   903,   903,   903,
       0,   209,     0,     0,   903,   903,   903,  1944,     0,     0,
    1944,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     903,     0,  1944,   903,     0,     0,     0,     0,     0,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,     0,  1678,     0,     0,     0,     0,     0,     0,     0,
       0,  1125,   939,  1986,     0,     0,     0,     0,     0,   939,
       0,     0,     0,   209,     0,     0,   903,     0,     0,     0,
       0,   903,   209,     0,     0,     0,     0,     0,   209,     0,
       0,   209,     0,   209,   209,     0,     0,     0,     0,     0,
       0,   209,     0,   209,     0,   209,     0,     0,     0,     0,
       0,     0,   906,     0,     0,  2047,     0,  1913,     0,     0,
       0,     0,     0,     0,  1041,  1634,     0,   853,   854,   855,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   856,
    2683,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1641,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1914,     0,     0,     0,     0,     0,     0,     0,
       0,   901,   901,  1915,  1641,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1916,   857,   858,   859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   901,     0,     0,  1635,   906,   906,   906,   862,   863,
     864,     0,   906,   906,   906,  1945,     0,   865,  1945,     0,
     319,     0,  1958,     0,     0,     0,     0,     0,   906,     0,
    1945,   906,     0,     0,     0,   209,   209,   906,   906,   906,
     906,   906,   906,   906,   906,   906,   906,   906,   906,     0,
       0,   209,     0,     0,     0,  1917,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3359,  4129,
       0,     0,     0,     0,   906,     0,     0,     0,     0,   906,
       0,   209,     0,     0,     0,   209,     0,     0,     0,     0,
       0,     0,  1918,     0,     0,     0,     0,     0,  1041,     0,
       0,     0,   903,   867,     0,     0,     0,     0,     0,     0,
       0,   914, -1811,  2048,     0,     0,     0,     0, -1811,     0,
       0,     0,     0,     0,  1958,     0,     0, -3359,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3359,
       0,     0,     0,     0,  2022,  2023,  2024,  2025,   914,     0,
       0,     0,  2026,  2303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2310,     0,     0,     0,     0,     0,
    2027,  2028,     0,   209,   209,     0,     0,     0,     0,     0,
     361,   362,     0,   320,     0,   363, -3359,     0,     0,   938,
       0,   364,     0,  2338,     0,     0,     0,  2347,     0,   365,
       0,  4230,     0,     0,     0,     0,     0,  4232,   366, -3359,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2029,     0,     0,   209,  2368,     0,     0,  2022,  2023,
    2024,  2025,     0,   903,  1041,     0,  2026,     0,   869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   914,     0,     0,  2027,  2028,     0,     0,     0,     0,
    2030,     0,     0,     0,     0,     0, -1811, -3359,     0,     0,
       0, -3278, -1811, -1811,     0,  1256,     0,     0,     0,     0,
       0,   367,   368,     0,     0,     0,     0,     0, -1811,     0,
       0,     0,     0, -3418, -3418, -3418, -3418,     0,     0,   938,
       0, -3418,   209,   209,     0,  2029,     0,     0,     0,     0,
       0,   321,   369,   209,   209,     0,     0,     0,     0, -3418,
   -3418,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   370,     0,     0,     0,   371,   870,   871,     0,
     906,     0,     0,     0,  2030,     0,     0,     0,     0,     0,
       0, -3359,     0,   939,   372,     0,  1958,     0,     0,     0,
   -3418,     0,     0,     0,     0,     0,     0,     0,     0, -3270,
   -3418,     0,     0, -3270,     0,  2022,  2023,  2024,  2025,     0,
       0,  1894,  2031,  2026,     0,     0,     0,     0,     0,   322,
       0,     0,     0,     0,     0,     0,     0,  1677,   373,     0,
       0,  2027,  2028,     0,   374,     0,   375,   873,     0, -3418,
     376,     0,     0,   939,   377,     0, -3359,     0,  2574,     0,
       0,     0,     0,     0, -2302, -3359,     0,     0,  1944,     0,
       0,   378,     0,   209,   874,  1041,     0,     0,     0,  1958,
       0,  2032,   875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2029,     0,     0,     0,     0, -2302,     0,     0,
       0, -1811, -1811, -1811,     0,     0,  2031,     0,   379,     0,
     876,   906,     0, -1811,     0,     0,   533,   207,     0,     0,
       0,  2033,     0,     0,   380,     0,     0,     0,     0,   381,
       0,  2030,   324,     0,     0,   382,   383,     0,     0,     0,
   -1811,     0,     0,     0,     0,     0, -3359,     0,     0,     0,
       0,     0,     0, -3359,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2032,     0,     0,     0,     0,
       0, -3418,     0,     0,     0,     0,     0,  2047, -3359,     0,
       0,  2661,     0,     0,     0,     0,   384,     0,     0,     0,
       0,     0,     0,     0,   385,     0,     0,   386,     0, -1811,
   -1811, -1811,   387,     0,     0,  2033, -3359,     0,     0, -1811,
       0, -1811,     0,     0,     0,  2034,     0,     0, -1811,     0,
       0,     0, -1811, -1811, -1811,     0,     0,     0,   388,     0,
   -3418, -1811,     0,     0, -1811,     0,   389,     0,   390,     0,
       0,   391,     0,     0,   392,     0,     0,     0,     0,     0,
       0, -1811,     0,  2031,     0,     0,     0,     0,  2701,     0,
     393,  2702,  2643,  2703,  2704,  2705,     0,     0,     0,     0,
   -3418,     0,     0,     0,     0,  1678,     0,     0,     0,  2728,
       0,     0,  1190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2034,
       0,     0,     0,     0,     0,     0,  1945,     0,  1041,     0,
       0,     0,  2032,     0,     0,  1041,     0, -1811,     0,  1041,
       0,     0,  1041,  2035, -1811,   939,   394,     0,     0,   939,
       0,     0,     0,   395,     0,   396,     0,     0,   397,     0,
       0,     0, -3270,     0,     0, -1811,     0,     0,     0,     0,
       0,     0,  2033,     0,   398, -3359,     0,     0,     0, -3359,
       0,     0,     0,     0, -3418,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1259,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1643, -1811,     0,  2747,
       0,     0,     0,     0,     0,     0,     0,  2035,     0,   399,
       0, -3418,     0,     0,     0,  2048,  1041,     0,     0,  1041,
   -3278,     0,     0,     0,     0,     0,     0,     0,   939,     0,
       0,     0,   400,  2752,  1871,     0,  1872,  1873,  2753,     0,
   -3359,     0,     0,     0,  2767,  1677,  2034,     0,     0,     0,
       0,     0, -1811,     0,     0,     0,  2036,     0,     0,     0,
       0,  2037,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3418,   401,  2801,     0,     0,     0,     0,   402,
       0,  2811,  2811,     0,   403,     0,     0,   404,   405,     0,
       0,  2821,  3521,  2822,     0,     0, -3270, -3270,     0,     0,
    2038, -3359,     0,     0,     0,  2709,   406,     0,   903,   903,
       0,     0,  2039,  2834,     0, -3359,     0, -1811,  1871,     0,
    1872,  1873,     0,     0,   407, -1811,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,   409,     0,     0, -3359,
    2036,     0,   410,     0,     0,  2037,     0,     0,     0,     0,
       0, -1811, -1811,     0,  2035,     0,     0,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,     0,     0,
       0, -3359,   413, -3418,  2038, -3418, -3418,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2039,     0,     0,     0,
     414,     0,     0, -1811,     0, -3418,     0,     0,     0,     0,
   -3418,  2040,     0,     0,   415,     0,     0,     0,     0,     0,
       0, -1811,     0,     0,   416,   417,   939,   939,   939,     0,
       0, -3359, -1811,   418,     0,     0,   419,     0,     0,     0,
       0,     0,     0, -3359,     0,     0,     0,     0, -1811, -3418,
   -3359,   420, -3359,     0,     0,     0, -1811,     0,     0,  3066,
       0, -3418,     0,     0,     0,  1871, -3278,  1872,  1873,     0,
       0,     0,     0,   421,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1678, -1811,     0,     0,  2036,  1894,     0,
       0, -1811,  2037,     0,     0,  2040,     0,  3368,   422,     0,
       0,     0,     0,     0,     0,     0, -1811,   903,     0,   903,
       0,   423,     0,     0,   939,     0,  2709,   424,     0,  1944,
       0,     0,     0,     0,     0,     0,  4717,     0,     0,  -636,
       0,  2038,     0,   903,     0,     0,  3124,     0,     0,     0,
       0,     0,   425,  2039,     0,     0,   906,   906,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   903,     0,     0,
   -3418,     0,     0,     0,   924,     0,  -776,  -776,  -776,  -776,
    -776,     0,  -776,  -776,  2015,   426,     0,     0,     0,     0,
     427,     0,     0,     0,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,  -636,  -636,  -636,  -636,  -636,
       0,  -636,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   533,     0,  3193,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2040,     0,     0,     0,     0,     0,     0,     0,
    3217,  -776,     0,  -776,  -776,  -776,  -776,  -776,  -776,  -776,
    -776,  -776,  -636,     0,     0,  -636,  -636,     0,     0,     0,
    3231,     0,  -636,     0,     0,     0,     0,     0,     0,  -636,
    -636,     0,  -636,  -636,  -636,  -636,  -636,  -636,  -636,  -636,
    -636,     0,     0,     0,  3261,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3268,     0,     0,     0,  -776,     0,     0,   903,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1677,     0,     0,     0,   906,     0,   906,     0,     0,
       0,     0,     0,     0,     0,  -636,     0,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1677,
     939,   906,     0,     0,     0,     0,     0,     0,   939,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   906,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   939,     0,   939,     0,     0,
       0,  -776,  -776,  -776,  -776,  -776,     0,  -776,  -776,  -776,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1178,     0,     0,     0,     0,     0,     0,     0,     0,
    -636,  -636,  -636,  -636,  -636,     0,  -636,  -636,  -636,     0,
       0,     0,     0,     0,     0,  -776,     0,  2709,  1678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   939,     0,   939,     0,     0,     0,     0,  -776,
       0,     0,  -636,     0,  -636,     0,     0,     0,     0,     0,
   -1567,   362,     0,     0,     0,   363,     0,     0,     0,     0,
       0,   364,     0,     0,     0,     0,     0,     0,  -636,   365,
       0,     0,     0,     0,     0,     0,     0,     0,   366,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1567,     0,  -636,   906,     0,     0,
       0,     0,     0,     0,   939,     0,     0,     0,  -636,  1678,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -636,
       0,     0,     0,     0,     0,  -636,     0,     0,     0,  -636,
       0,  -636,     0,     0,     0,     0,     0,  1678,   924,     0,
    -636,     0,     0,  3066,     0,     0,     0,     0,     0,  -776,
       0,   367,   368,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   939,     0,     0,     0,     0,     0,     0,  -636,     0,
       0,     0,   369,     0,     0,     0,     0,     0,     0,     0,
       0,  -636,     0,     0,     0,     0,   939,     0,     0,     0,
       0,     0,   370,     0,  3369,     0,   371,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,  -776,     0,     0,
       0,     0,     0,     0,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -776,     0,
       0, -1567,     0,     0,  3534,     0,  -636,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1677,   373,     0,
       0,  -776,  -636,     0,   374,  3217,   375,  -636,     0,     0,
     376,     0,     0,  -636,   377,   847,     0,     0,     0,     0,
       0,   316,     0,  -636,     0,     0,     0,     0,  2747,     0,
    -636,   378,     0, -1567,     0,     0,     0, -1567, -1567, -1567,
   -1567, -1567,     0, -1567, -1567, -1567, -1567,     0, -1567, -1567,
       0, -1567, -1567,     0, -1567, -1567, -1567, -1567, -1567,     0,
   -1567, -1567, -1567, -1567, -1567, -1567,     0,     0,   379,     0,
       0,     0,     0,     0,     0,     0, -1567,     0,     0,     0,
    -636, -1567,     0,     0,   380,     0,   316,     0,     0,   381,
   -1567,     0,     0,     0,     0,   382,   383,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -636,     0,     0,     0,     0,     0,     0,     0,  -776,
    -776,  -776,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   384,     0,     0,     0,
       0,     0,     0,     0,   385,     0,  -636,   386,  -636,  -636,
    -636,     0,   387,     0,     0,     0,  1633,     0,  -636,   848,
       0,     0,     0,   903,     0,   849,   850,     0,     0,     0,
   -3418,     0,     0,     0,     0,     0,     0,     0,   388,     0,
       0,   852,     0,     0,     0,   924,   389,     0,   390,     0,
    -636,   391,     0,     0,   392,     0,     0,   939,     0,   939,
   -1567,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   848,  1678,     0,     0,  -636,     0,
     849,   850,     0,  1678,     0,     0,     0,     0,     0,  -776,
    -776,  -776,     0,     0,  2981,   939,   852,     0,  2982,     0,
       0,  -636,     0,     0,     0,     0,     0,     0,  -636,     0,
       0,     0,     0,     0,  -776,     0,     0,  2983,  -636,  -636,
    -636,     0,     0,     0,     0,     0,   394,     0,     0,     0,
    2984,     0,     0,   395,  -636,   396,     0,     0,   397,     0,
       0,     0,   955,  -636,     0,  3817,     0,  3370,     0,     0,
       0,  -636,     0,  -636,   398,   939,  -636,     0,     0,     0,
       0,     0,     0, -1567,  3534,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   218,     0,     0,     0,
       0,     0,     0, -1567, -1567, -1567,     0, -1567, -1567, -1567,
   -1567,     0,  -636,     0,     0,     0,     0,   956,     0,     0,
       0,     0,     0,     0,   853,   854,   855, -1567, -1567,   399,
       0,     0,   939,     0,     0,     0,   856,     0,     0,     0,
       0,     0,     0,     0,   547,     0,     0,     0,     0,     0,
       0,     0,   400,     0,     0,     0,     0,     0,     0,     0,
       0,  3874,     0,   317,     0,     0,     0,  3876,     0,  3877,
       0,   906,     0,     0,     0,   957,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3894,     0,  1634,     0,   853,
     854,   855,     0,   401,     0,     0,     0,     0,     0,   402,
       0,   856,     0,     0,   403,     0,     0,   404,   405,   792,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   857,   858,   859,     0,   406,     0,   317,     0,
       0,     0,   860,     0,   861,     0,     0,     0,     0,     0,
       0,   958,     0,     0,   407,   862,   863,   864,     0,   408,
       0,     0,     0,     0,   865,     0,   409,   319,     0,     0,
       0,     0,   410,  2985,     0,     0,     0,   903,     0,     0,
     959,     0,     0,     0,   866,     0,     0,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,   857,   858,   859,
       0,     0,     0,     0,     0,     0,   412,     0,     0,     0,
       0,     0,   413,     0,     0,     0,   318,     0,     0,     0,
     862,   863,   864,     0,   939,     0,   939,     0, -1567,   865,
     414,     0,   319,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   415,     0,     0,  2986,  2987,     0,
     867,     0,     0,     0,   416,   417,     0,   960,     0,     0,
       0,     0,     0,   418,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   868,     0,
    4026,   420,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2318,     0,     0,     0,     0,     0,   316,     0,     0,
       0,     0,     0, -1567,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1567,   867,     0,     0,     0,     0,
       0,     0,     0,  4047,     0,     0,  4050,     0,   422,     0,
     320,     0,  2988,     0,     0,     0,     0,     0,     0,     0,
       0,   423,     0,     0,     0,     0,     0,   424,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   793,  4059,  4062,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,     0,     0,     0,     0,     0,     0,  4094,
       0,     0,     0,     0,     0,   869,     0,     0,  2989,     0,
       0,     0,     0, -1567,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,  -383,   426,     0,     0,     0,     0,
     427,     0,     0,     0,     0,   906,     0,     0, -1567,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   848,     0,     0,     0,     0,
     869,   849,   850,     0,     0,     0,     0,     0,   321,     0,
       0,     0,   961,     0,     0,     0,     0,   852,     0,     0,
    2990,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   870,   871,     0,   962,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2991,     0,     0,     0,     0,     0,     0,  4059,
    2992,     0,  4062,   321,     0,     0,     0,     0,     0,     0,
    1677,     0,   963,     0,     0,     0,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   870,
     871,     0,     0,     0,   873,     0,   794,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2319,     0,     0,
       0,     0, -3418,     0,     0,     0,     0,     0,     0, -1551,
     362,   874,     0,     0,   363,     0,     0,     0,  2993,   875,
     364,     0,     0,     0,     0,     0,     0,     0,   365,     0,
       0,   322,     0,  2994,     0,     0,     0,   366,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   876,     0,   873,
    2995,     0,   964,   533,   207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4262,     0, -2302,     0,     0,   324,
     853,   854,   855,     0,     0,     0,   874,     0,     0,  1677,
       0,     0,   856,     0,   875,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   795, -2302,
       0,     0,     0,     0,     0,     0,     0,     0, -3284,   317,
     367,   368,   876,     0,  2996,     0,     0,     0,   533,   207,
       0,     0,     0,     0,     0,     0,     0,     0,  2997,     0,
       0,     0,     0,     0,   324,     0,     0,     0,     0,     0,
       0,   369,     0,     0,     0,     0,     0,  -380,     0,     0,
       0,     0,     0,  4314,     0,     0,     0,     0,     0,     0,
       0,   370,  4321,     0,     0,   371,  4326,     0,   857,   858,
     859,     0,     0,     0,  4180,     0,     0,     0,   860,     0,
     861,     0,     0,   372,     0,     0,     0,   318,     0,     0,
       0,   862,   863,   864,     0,     0,     0,     0,  1678,     0,
     865,   796,     0,   319,     0,  2998,     0,     0,     0,     0,
       0,  4321,     0,     0,  4368,  4373,     0,     0,     0,     0,
     866,  2999,  3000,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,   374,     0,   375,  4400,  4411,     0,   376,
       0,     0,     0,   377,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1677,     0,     0,  4368,     0,
     378,     0,     0,  4373,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4455,     0,     0,
       0,     0,     0,     0,     0,     0,   867,     0,     0,     0,
       0,     0,  4466,     0,     0,     0,     0,   379,     0,     0,
       0,     0,     0,  4479,     0,     0,     0,  4534,     0,     0,
       0,     0,     0,   380,   868,     0,     0,  1678,   381,     0,
       0,     0,     0,     0,   382,   383,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4555,     0,     0,  4557,  4558,
    4559,  4560,     0,     0,     0,     0,     0,     0,  4566,     0,
       0,     0,     0,     0,     0,     0,   320,     0,     0,     0,
       0,  4578,     0,     0,     0,   384,     0,     0,     0,     0,
       0,     0,     0,   385,     0,     0,   386,     0,     0,  2303,
       0,   387,     0,     0,     0,     0,     0,     0,   848,     0,
       0,     0,     0,     0,   849,   850,  4610,     0,     0,  4611,
       0,     0,     0,     0,     0,     0,     0,   388,     0,     0,
     852,   869,     0,     0,     0,   389,     0,   390,     0,     0,
     391,     0,     0,   392,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   393,
       0,     0,     0,  4626,  4627,  4628,  4629,  4630,  4631,  4632,
    4633,  4634,  4635,  4636,  4637,  4638,  4639,  4640,  4641,  4642,
    4643,  4644,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4658,     0,     0,  2320,     0,     0,     0,
       0,     0,  3066,  1678,   321,     0,     0,     0,     0,     0,
       0,  3066,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,     0,     0,     0,
     870,   871,   395,  4676,   396,     0,     0,   397,     0,     0,
       0,     0,     0,     0,     0,  4677,     0,     0,  1846,     0,
       0,  4684,     0,   398,     0,     0,     0,  4658,  4658,     0,
       0,  1847,  1848,  1849,  1850,     0,     0,     0,     0,  1851,
       0,   924,     0,     0,     0,  2321,     0,     0,  4709,  4710,
       0,     0,   322,     0,     0,     0,  2322,     0,  1852,     0,
       0,   924,  4658,     0,     0,     0,     0,     0,     0,     0,
     873,     0,     0,   853,   854,   855,     0,     0,   399,     0,
       0,  4723,     0,     0,     0,   856,     0,     0,  4684,     0,
       0,     0,     0,     0,     0,  4740,     0,   874,     0,     0,
       0,   400,     0,     0,     0,   875,     0,     0,  1853,     0,
       0,     0,  4752,     0,     0,     0,  4684,  4684,     0,     0,
       0,     0,  4684,     0,  4798,  4684,     0,     0,     0,  4684,
    4684,     0,     0,   876,     0,     0,  4613,     0,     0,     0,
     207,     0,   401,     0,     0,  1854,     0,  1855,   402,     0,
    1177,     0,     0,   403,     0,   324,   404,   405,     0,  1856,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4829,   857,   858,   859,     0,   406,     0,     0,     0,     0,
    -636,     0,   903,   903,     0,  1857,     0,     0,     0,     0,
    3685,     0,     0,   407,   862,   863,   864,     0,   408,     0,
       0,     0,     0,   865,     0,   409,     0,     0,     0,     0,
       0,   410,   903,     0,     0,     0,  -636,     0,     0,  -636,
    -636,  -636,  -636,  -636,     0,  -636,  -636,     0,     0,     0,
     411,  4893,  4893,     0,     0,     0,  -636,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,     0,     0,  4900,
       0,   413,     0,     0,     0,     0,     0,     0,     0,  4903,
    4907,     0,     0,     0,  4893,     0,     0,     0,     0,   414,
       0,  4915,     0,     0,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,   415,     0,     0,     0,     0,     0,   867,
       0,     0,     0,   416,   417,     0,     0,     0,     0,     0,
       0,     0,   418,  -636,  -636,   419,  -636,  -636,  -636,  -636,
    -636,  -636,  -636,  -636,  -636,     0,     0,     0,     0,     0,
     420,     0,     0,     0,     0,     0,     0,     0,  1858,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1859,
       0,     0, -1551,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -636,     0,     0,   422,  1860,     0,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,  -636,
     423,   847,     0,     0,     0,     0,   424,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,     0,     0,     0,     0,     0,     0,     0,     0,
     906,   906,     0,     0,   869,     0,     0,  1861,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   426,     0,     0,     0,     0,   427,
     906,     0,     0,     0,     0,     0,     0, -1551,     0,  1862,
       0,     0,  1863,     0,     0,     0,     0,     0,     0,  -636,
    -636,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1178,     0,     0,     0,     0,
       0,     0,     0,     0,  -636,  -636,  -636,  -636,  -636,     0,
    -636,  -636,  -636,     0,     0,     0,     0,     0,  1864,  -636,
       0,     0,     0,     0,     0,  1865,     0,     0,     0,     0,
       0,     0,     0,   870,   871,  -636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   848,     0,     0,  -636,     0,
       0,   849,   850,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1866,     0,     0,  -636,     0,   852,     0,     0,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,     0,
    1867,     0,     0,     0,     0,     0,     0,     0,  -636,     0,
    -636,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -636,     0,     0,   873,     0,     0,     0,     0,     0,     0,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -636,  -636,     0,     0,     0,  1868,     0,
     874,  1869,     0,     0,     0,  -636,     0,     0,   875,     0,
       0,     0,     0,     0,  -636,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4287,
       0,     0,     0,     0,     0,  -636,   876,     0,     0,     0,
       0,     0,     0,   207,     0,     0,     0,     0,     0,  1870,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,  1871,     0,  1872,  1873,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -636,     0,     0,     0,
       0,     0,     0,  1874,     0,     0,     0,     0,  1875,  -636,
    -636,  -636,  -636,     0,  -636,     0,  1876,  -636,  -636,  -636,
    -636,  -636,  -636,     0,  -636,  -636,  -636,     0,     0,  -636,
     853,   854,   855,     0,     0,  -636,  -636,     0,     0,     0,
       0,     0,   856,     0,     0,     0,     0, -3378,     0,     0,
    -636,     0,     0,     0,     0,     0,  -636,     0,     0,  1877,
       0,     0,     0,     0,     0,     0,  -636,     0,     0,   317,
       0,  -636,     0,  -636,     0,     0,     0,  -636,  -636,     0,
       0,     0,     0,     0,     0,  -636,  -636,  -636,     0,  -636,
       0,     0,     0,  1878,  -636,     0,  -636,     0,     0,     0,
       0,     0,     0,  -636,     0,  -636,  -636,  -636,  -636,  -636,
    -636,  -636,  -636,  -636,  1879,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -636,   857,   858,
     859,     0,     0,     0,  -636,     0,     0,     0,   860,     0,
     861,     0,     0,     0,  -636,     0,     0,   318,     0,     0,
       0,   862,   863,   864,  -636,     0,     0,     0,  1880,     0,
     865,     0,     0,   319,     0,     0,     0,     0,     0,     0,
    1881,     0,     0,     0,     0,     0,     0,  1882,  -636,     0,
     866,     0,  -636,     0,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -636,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -636,     0,  -636,  -636,  -636,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -636,     0,     0,  -636,     0,
       0,     0,   848,     0,     0,     0,   867,  -636,   849,   850,
       0,     0,     0,  3885,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   852,     0,     0,     0,  -636,     0,
       0,     0,     0,     0,   868,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1178,     0,     0,     0,     0,     0,
       0,     0,     0,  -636,  -636,  -636,  -636,  -636,     0,  -636,
    -636,  -636,  -636,     0,     0,     0,  -636,     0,     0,     0,
       0,     0,  -636,     0,     0,  -636,     0,  -636,     0,     0,
       0,     0,     0,     0,  -636,  -636,   320,     0,     0,     0,
       0,     0,  -636,  -636,  -636,     0,     0,  -636,     0,     0,
       0,     0,  -636,  -636,  -636,     0,  -636,     0,  -636,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -636,     0,
       0,  -636,     0,     0,     0,     0,     0,  -636,     0,     0,
       0,     0,     0,  -636,     0,  -636,     0,  -636,     0,  -636,
    -636,   869,     0,     0,  -636,     0,     0,     0,     0,  -636,
       0,     0,     0,  -636,     0,     0,     0,     0,     0,     0,
     218,  -636,     0,     0,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -636,     0,  -636,     0,
       0,     0,  -636,     0,     0,  -636,  -636,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   853,   854,   855,
    -636,     0,  -636,     0,     0,     0,  3476,     0,     0,   856,
       0,     0,     0,     0,   321,     0,     0,     0,     0,     0,
       0,  2668,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -636, -2773,     0,     0,     0,     0,     0, -2773,     0,
     870,   871, -2773, -2773, -2773,     0,  -636,     0,     0,     0,
   -2773,  2669,     0,  -636,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2773, -2773, -2773, -2773, -2773, -2773, -2773,
   -2773,     0,     0,     0,     0,     0,  -636,     0,  -636,     0,
    -636,     0,   322,     0,     0,     0,     0,   859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -636,  -636,
     873,     0,     0,     0,  1122,     0,     0,     0,   862,   863,
     864,  3477,     0,     0,     0,  -636,     0,   865,     0,     0,
    -636,     0,  -636,  -636,     0,     0,     0,   874,     0,     0,
       0,     0,     0,     0,     0,   875,     0,     0, -2773,     0,
       0,     0,     0,  -636,     0,     0,  -636,     0,     0,     0,
       0,     0,  -636,     0,     0,  -636,  -636,     0,     0,     0,
       0,     0,     0,   876,     0,     0,     0,     0,     0,     0,
     207,     0,     0,     0,     0,     0, -2773,     0,     0,     0,
       0,     0, -2773, -2773,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -636, -2773,     0,
       0,     0,     0,   867,     0,     0,     0,     0,     0,  -636,
       0,  -636,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -636,     0,     0,
       0,     0,     0,     0,  -636,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -636,
       0,  -636,  -636,  -636,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,  -636,     0,     0,     0,  -636,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -636,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2773,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -636,     0,     0,     0,     0,     0, -2773,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   869,     0,
       0,     0,     0,     0,     0,     0,  -636,     0,     0,     0,
       0,  -636,     0,     0,     0,     0,     0,  -636,     0,     0,
       0,  -636,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2773, -2773, -2773,  -636,     0,     0,     0,  -636,     0,
       0,     0,     0, -2773,     0,     0,  -636,     0,     0,     0,
       0,  -636,  -636,  -636, -2773, -2773,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -636,     0,     0,
   -2773,     0,     0,     0,     0,  -636,  -636,     0,     0,     0,
       0,     0,     0,     0,  -636,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,   871,     0,
    -636, -2773,     0,     0,     0,     0,     0,     0,     0,   218,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -636,     0,     0,     0,     0, -2773,
   -2773, -2773, -2773, -2773,     0,     0,     0,     0,     0, -2773,
       0, -2773,     0,     0,     0,     0,     0,     0, -2773,     0,
       0,     0, -2773, -2773, -2773,     0,     0,  1021,     0,     0,
       0, -2773,     0,     0, -2773,     0,     0,   873, -2773,     0,
       0,     0,     0,     0, -2773,     0,     0,     0, -2773, -2773,
   -2773, -2773,     0,     0,     0,     0, -2773,     0,     0,     0,
       0,     0,     0,     0,   874,     0,     0,     0,     0,     0,
       0, -2773,   875,     0,     0,     0,     0,     0,     0, -2773,
   -2773, -2773, -2773, -2773, -2773, -2773, -2773,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2773,     0,     0,     0,
     876,     0,     0,     0,     0,     0, -2773,   207,     0,     0,
       0,     0,     0,     0,     0, -2773,     0, -2773,     0,     0,
       0,     0,     0,     0, -2773,     0,     0,     0,     0,     0,
       0,     0, -2773,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2773,     0,     0,     0,     0,
    2484,     0,     0,     0, -2773,  -296,     0,     0,     0,  -296,
       0,     0,     0,     0,     0,     0,     0, -2773,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -296,     0,
       0,     0,     0,     0,  1021,     0,     0,     0,     0,     0,
       0,  -296, -2773,     0,     0, -2773,     0, -2773, -2773, -2773,
       0, -2773,     0,     0,     0, -2773, -2773, -2773,     0,     0,
       0,     0,     0, -2773, -2773,     0,     0,     0,     0,  -296,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2773, -2773, -2773, -2773,
   -2773, -2773, -2773, -2773,     0,     0,     0,     0,     0,     0,
       0,     0, -2773,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -296,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2773,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2773, -2773,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2742, -2773,     0,     0,     0,     0,     0, -2773,
    -296, -2773, -2773,     0,     0, -2773, -2773,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2773,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2773, -2773, -2773,
   -2773,     0, -2773,     0, -2773,     0,  2670,     0, -2773, -2773,
   -2773, -2773, -2773, -2773,  -296, -2773, -2773,  2671,     0,     0,
   -2773, -2773,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2773,     0,     0,     0,     0, -2773,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2773,     0,
       0,     0,     0,     0,     0,     0, -2773, -2773,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -296,  -296,
       0, -2773,     0,     0, -2773, -2773, -2773, -2773, -2773, -2773,
       0, -2773,     0,     0,     0, -2773,     0, -2773,     0,     0,
   -2773,     0,     0,     0, -2773,     0, -2773,     0, -2773, -2773,
   -2773,     0,     0,     0,  1256,     0,     0, -2773,     0,     0,
   -2773,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3418, -3418, -3418, -3418,     0, -2773,     0,     0,
   -3418,     0,     0,     0, -2773, -2773, -2773,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2773, -2773, -3418, -3418,
       0,     0,  3158,  -296,  3159,     0,     0, -2773, -2773,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2773, -2773,     0,     0,     0, -1986,  -296,     0,
       0,     0, -2773,     0,     0,     0,     0,     0,     0,     0,
       0, -2773,     0, -2773,     0,     0,     0,     0, -3270, -3418,
   -2773,     0, -3270,     0, -2773,     0,     0,     0, -2773,  -296,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2773,     0,     0,     0,  -296,     0,     0,     0,     0,
       0,     0, -2773, -2773, -2773, -2773, -2773,     0, -3418,     0,
       0,     0, -2773, -2773, -2773,     0,     0,     0,     0,     0,
       0, -2773,     0,     0,     0, -2773, -2773, -2773,     0,     0,
    3345,     0,     0,     0, -2773,     0,     0, -2773,     0,     0,
       0, -2802,     0, -2773,     0,     0,     0, -2802,     0,     0,
       0, -2802, -2802, -2802, -2773,     0,     0,     0,     0, -2802,
       0,  -296,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2773,     0,     0,     0,     0,     0,
       0,     0, -2802, -2802, -2802, -2802, -2802, -2802, -2802, -2802,
       0,     0,     0,     0,     0,     0,     0,     0, -2773, -2773,
       0,     0,     0,  -296,     0,     0,     0,     0,     0, -2773,
       0,  -296,     0,     0,     0,     0,     0,     0, -2773,     0,
   -2773,     0,     0,     0,     0,     0,     0, -2773,     0,     0,
   -3418,     0,     0,     0,     0, -2773,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -296, -2773,     0,
       0,     0,     0,     0,     0,     0,     0, -2802,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2773, -2773,     0,     0,     0,     0,     0,     0,     0,  -296,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3418,
       0,     0,     0,     0,  -296, -2802,     0, -2773, -2773,     0,
   -2773, -2802, -2802,     0,     0,     0,     0,     0,     0,     0,
       0,  -296,     0,     0,     0,     0,     0, -2802,     0,     0,
    3160,     0,     0,     0,     0,     0,     0,     0,     0, -3418,
       0,     0,     0,     0,     0,     0, -2773,     0, -2773,     0,
   -2773,     0,     0,     0, -2773,     0, -2773, -2773, -2773, -2773,
       0, -2773, -2773,     0,     0, -2773,     0,     0,     0,  -296,
       0,     0,     0,     0,     0,     0,     0, -2773,     0,  -296,
    -296,     0,     0,     0,     0,  -296,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1986,     0,  -296,
       0,     0,     0,     0, -2773,     0,     0,     0,     0,     0,
       0, -3270, -2773,     0,     0,  3161,     0,     0,  -296,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3418,     0,     0,     0, -2802, -2773,     0,
   -2773,     0,     0,     0,     0,     0,     0, -2773,     0,     0,
       0,     0,     0,     0,     0,     0, -2802,     0,     0,     0,
       0,     0, -2773,     0, -2773, -2773,     0,     0,     0,     0,
       0,     0,  -296,     0,     0,     0,  -296,     0,     0, -3418,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -296,  -296,     0,     0,     0,     0,     0,     0,
   -2802, -2802, -2802, -2773,     0, -2773,     0, -2773,     0,     0,
       0, -2773, -2802, -2773, -2773, -2773, -2773,     0, -2773, -2773,
       0,     0,     0, -2802, -2802,     0,  3345,     0,     0,     0,
       0,     0,     0,     0, -2773,     0,     0, -2802,     0, -2802,
       0, -3418,     0, -2802,     0,     0,     0, -2802, -2802, -2802,
       0,     0,     0,     0,     0, -2802,     0,     0,     0,     0,
       0, -2773,     0,     0,  3162, -3270, -3270,     0,     0, -2773,
       0,     0,     0,     0,     0,     0,     0,     0, -2802, -2802,
   -2802, -2802, -2802, -2802, -2802, -2802,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2773, -2802, -2802,
   -2802, -2802, -2802,     0, -2773,     0,     0,     0, -2802,     0,
   -2802,     0,     0,     0,     0,     0,     0, -2802,     0, -2773,
       0, -2802, -2802, -2802,     0,     0,     0,     0,     0,     0,
   -2802,     0,     0, -2802,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2802,     0, -3418, -2802, -3418, -3418,     0,     0,     0,     0,
   -1986,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2802,     0,     0,     0, -3418,     0,     0,     0,     0, -3418,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2802,     0,     0,     0, -2802,     0, -2802, -2802,     0,
       0,     0,     0,     0,     0, -2802,  3163,     0,     0,     0,
       0,     0,     0, -2802, -2802,     0, -2802,     0, -3418,     0,
       0,     0,     0, -2802,     0,     0,     0,     0,     0,     0,
   -3418, -2802,     0,     0,  3698,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2802,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1986,     0,     0,
       0,     0,     0,     0,     0,     0, -2802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2802,     0,     0,     0,     0,     0, -3418,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2802,     0,     0,     0,     0,     0,     0,     0,
       0, -2802,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2802, -2802, -2802,     0,
       0,   533,     0,     0,     0,     0,     0,     0, -2802,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2802,
   -2802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2802, -2802,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2802, -2802,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2802, -2802, -2802, -2802, -2802, -2802,
       0, -2802,     0, -2802, -2802,     0, -2802, -2802,     0, -2802,
   -2802, -2802, -2802, -2802, -2802, -2802,     0, -2802, -2802, -2802,
       0,     0,     0,     0,     0,     0, -2802,     0,     0, -2802,
   -2802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2802,     0,     0,
       0,     0,     0,     0,     0, -2802, -2802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2802,     0, -2802,     0,     0,     0,     0,     0,     0,
   -2802, -2802,     0,     0,     0,     0,     0,     0,     0,     0,
   -2802,     0, -2802,     0,     0, -2802,     0,     0,     0, -2802,
       0,     0,     0,     0,     0,     0,     0, -2802,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2802,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3124,     0,     0,     0,     0,
       0,  1446,     0,     0,     0, -3124,     0,     0,     0,  1447,
       0,     0, -2802,     0,     0,     0,     0,     0,     0,     0,
       0, -3124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1448, -3124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2802,     0,     0,
   -3124,  1449,  1450,  1451,  1452,  1453,  1454,  1455,  1456,     0,
       0,     0,     0, -3124, -3124, -3124,     0,  1457, -3124,     0,
       0,     0,  1458,     0,     0, -3124,     0,     0,     0,     0,
       0,     0,     0,  1459,  1460,  1461,  1462, -3124,     0, -3124,
   -3124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1463,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1464,     0,     0,  1465,  1466,  1467, -3124,  1468,     0,
   -2802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2905,  2906,
    2907,  2908,  2909,     0,  2910,  2911, -2802, -2802,     0,     0,
       0,     0,  1469,     0,     0,     0,     0,     0,     0,     0,
       0,  1470,  1471,  1472,  1473,  1474,  1475,  1476,  1477,     0,
       0,     0, -3124,     0,  1478,  1479,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2802,     0, -2802, -3124, -2802,
       0,     0,     0, -2802,     0, -2802, -2802, -2802, -2802,     0,
   -2802, -2802,     0,  1480,  1481,     0,     0,  1482,  1483,     0,
   -3124, -3124,  1484, -3124, -3124,     0, -2802,     0,     0,     0,
       0,     0,     0,  2912,     0,  2913,  2914,  2276,  2915,  2916,
    2917,  2918,  2919,  2920,  1485,     0,     0,     0,     0,     0,
       0,     0,     0, -2802,     0,     0,     0,     0,     0,     0,
       0, -2802,     0,     0,     0,     0,     0,     0, -3124,  1486,
       0,     0,     0,  1487,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3124,     0,     0,     0,  1488, -2802,
       0,     0,     0,     0,  1489,  1490, -2802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2921,     0,
       0, -2802,     0,  1491,  1492,  1493,  1494,  1495,     0,     0,
    1496,     0,     0,     0, -3124, -3124, -3124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3124,     0,     0,
       0,     0, -3124,     0,     0,     0,     0,     0,     0,     0,
    1497,  1498,  1499,  1500,     0,     0,     0,     0,     0,  1501,
    1502,     0,  1503,     0,  1504,  1505,  1506, -3124, -3124,  1507,
       0,  1508,     0, -3124, -3124,  1509,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1510,  1511,     0,     0,     0,     0,
       0,     0,     0,     0,  1512,  1513,  1514,  1515,  1516,  1517,
       0,     0,     0,  2922,  2923,  2924,  2925,  2926,  1518,  2283,
    2284,  2927,  1519,     0,     0,     0,  1521,     0, -3124,     0,
   -3124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2928,     0,     0,
   -3124, -3124, -3124,     0,     0,  1522,     0,     0,     0,  1523,
       0,  1524,  1525,  1526,  1527,     0,     0,     0,     0,     0,
       0,  2929,  1528,     0,     0,     0,     0,     0, -3124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1529,
       0,     0,     0,     0,     0,     0,     0,  1530,     0,     0,
       0,     0, -3124, -3124, -3124,     0, -3124,     0, -3124, -3124,
       0, -3124, -3124, -3124,     0,     0,     0,     0,  1612, -3124,
       0, -3124, -3124, -3124, -3124,     0,     0,     0,     0,     0,
       0,     0,     0,  1531,  1532,     0,     0, -3124,     0,     0,
       0,     0,     0,     0,     0, -3124,     0,   362,     0,     0,
       0,   363,     0,     0,     0,     0,     0,   364,     0,     0,
   -3124, -3124,     0,     0,     0,   365,     0,     0,  1533, -3124,
       0,  1534,     0,     0,   366, -3124,     0,     0,     0,     0,
       0,  2930,  1535,     0,     0,     0,     0,     0,  1536,     0,
       0,     0,  1537,     0,  1538,  1539,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1540,     0,
       0,  1541,  1542,     0,     0,     0,     0,  1543,     0,     0,
       0,     0, -3124,     0,     0,     0,     0,     0, -3124,     0,
       0,     0,     0,  1544,     0,  1545,  1546,     0,     0,     0,
       0,     0,     0,     0,  1547,  1548,     0,   367,   368,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2931,
       0,     0,     0,     0,     0,     0,   847,  1549,  1550,  1551,
       0,     0,   316,     0,     0,     0,     0,     0,   369,     0,
    2932, -3124, -3124, -3124,     0,     0,     0,  1552,  1553,  1554,
    1555, -3124,  1556,     0,     0,     0,  1557,  1558,   370,     0,
       0,     0,   371,  2933,  1559,  1560,     0,     0,     0,     0,
       0,     0,     0,  1561,  1562,  1563, -3124,     0,     0,     0,
     372,  1564,     0,     0,     0,     0,  1565,     0,     0, -3124,
   -3124, -3124, -3124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1566,     0,     0,     0,     0, -3124,
   -3124,     0,     0,     0,     0,     0,     0,  1567,  1568,     0,
   -3124,     0,     0,  1569,   373,     0,     0,     0,     0,  1613,
     374,     0,   375,     0,     0,     0,   376,     0,     0,     0,
     377,     0,     0,     0,     0,     0,  1570,  1571,     0,     0,
   -3124,     0,     0,     0,     0,  1572,     0,   378,     0,     0,
       0,     0,     0,  1573, -3124, -3124,     0,     0,     0,  1574,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     848,     0,     0,     0,     0,     0,   849,   850,     0,     0,
       0,  2934,  2935,  2936,   379,     0,   851,     0,     0,  1575,
       0, -3124,   852,     0,     0,  1576,     0,     0,     0,     0,
     380, -3124,     0,     0,     0,   381,     0,     0, -3124,     0,
       0,   382,   383,     0,     0,     0,     0,     0,     0, -3124,
       0,     0,     0, -3124, -3124, -3124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1577,
       0,     0,     0,     0, -3124, -3124,  1578,     0,  1579, -3124,
   -3124,  1580, -3124,     0,     0,     0,     0,     0,  1581, -3124,
       0,     0,   384,     0,     0,     0,     0,     0,     0,     0,
     385,  1582,     0,   386,     0,  1583,     0,     0,   387,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2937,  2938,  2939,   388,     0,     0,     0,     0,     0,
       0,     0,   389,     0,   390,     0,     0,   391,     0,     0,
     392,     0,     0,     0,     0,     0,  2940,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   853,   854,   855,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   856,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   317,     0,     0,     0,     0,   395,
       0,   396,     0,     0,   397,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     398,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   857,   858,   859,     0,     0,     0,     0,
     588,     0,     0,   860,     0,   861,   589,     0,     0,     0,
       0,     0,   318,     0,   590,   399,   862,   863,   864,     0,
       0,     0,     0,   591,     0,   865,     0,     0,   319,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   400,     0,
       0,     0,     0,     0,     0,   866,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   401,
       0,     0,     0,     0,     0,   402,     0,     0,     0,     0,
     403,     0,     0,   404,   405,     0,   592,   593,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   867,   406,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   594,     0,     0,
     407,     0,     0,     0,     0,   408,     0,     0,     0,   868,
       0,     0,   409,     0,     0,     0,     0,   595,   410,     0,
       0,   596,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   411,     0,   597,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,     0,     0,     0,     0,   413,     0,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   414,     0,     0,     0,
       0,     0,     0,   598,     0,     0,     0,     0,     0,     0,
     415,     0,     0,     0,     0,   599,     0,     0,     0,   600,
     416,   417,     0,     0,     0,     0,     0,     0,     0,   418,
       0,     0,   419,     0,     0,     0,   869,     0,   601,     0,
       0,     0,     0,   602,   603,   604,   605,   420,   606,   607,
     608,   609,     0,   610,     0,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   620,   621,   622,   623,
     624,     0,     0,   625,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   626,
       0,     0,     0,     0,   422,     0,     0,     0,     0,     0,
     627,   628,     0,     0,     0,     0,     0,   423,     0,   321,
       0,     0,     0,   424,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   870,   871,     0,   425,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     872,   629,     0,     0,     0,     0,     0,     0,     0,   630,
       0,     0,   631,     0,     0,     0,     0,   632,     0,     0,
       0,   426,     0,     0,     0,     0,   427,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   322,     0,     0,
       0,     0,     0,   633,     0,     0,     0,     0,     0,     0,
       0,   634,     0,   635,     0,   873,   636,     0,     0,   637,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   874,     0,  1446,     0,     0,     0,     0,     0,
     875,     0,  1447,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   876,     0,
       0,     0,     0,     0,  1448,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   638,     0,     0,     0,     0,     0,     0,   639,     0,
     640,     0,     0,   641,  1449,  1450,  1451,  1452,  1453,  1454,
    1455,  1456,     0,     0,     0,     0,     0,     0,     0,   642,
    1457,     0,     0,     0,     0,  1458,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1459,  1460,  1461,  1462,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1463,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1464,     0,     0,  1465,  1466,  1467,
       0,  1468,     0,     0,   643,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   644,     0,     0,
       0,     0,     0,     0,     0,  1469,     0,     0,     0,     0,
       0,     0,     0,     0,  1470,  1471,  1472,  1473,  1474,  1475,
    1476,  1477,     0,     0,     0,     0,     0,  1478,  1479,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   645,
       0,     0,     0,     0,     0,     0,  1480,  1481,     0,     0,
    1482,  1483,     0,     0,     0,  1484,     0,     0,     0,     0,
       0,   646,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1485,     0,     0,
       0,     0,     0,     0,   647,     0,     0,     0,     0,     0,
       0,   648,     0,     0,     0,     0,     0,   649,     0,     0,
       0,     0,  1486,     0,     0,     0,  1487,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   650,     0,     0,     0,
       0,  1488,     0,     0,     0,     0,     0,  1489,  1490,     0,
       0,     0,     0,     0,     0,     0,     0,   651,     0,     0,
       0,     0,     0,     0,     0,     0,  1491,  1492,  1493,  1494,
    1495,     0,     0,  1496,     0,   652,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   653,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   654,
     655,     0,     0,     0,     0,     0,     0,     0,   656,     0,
       0,   657,     0,  1497,  1498,  1499,  1500,     0,     0,     0,
       0,     0,  1501,  1502,     0,  1503,   658,  1504,  1505,  1506,
       0,     0,  1507,     0,  1508,     0,     0,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   659,     0,
       0,     0,     0,     0,     0,     0,     0,  1510,  1511,     0,
       0,     0,     0,     0,     0,     0,     0,  1512,  1513,  1514,
    1515,  1516,  1517,   660,     0,     0,     0,     0,     0,     0,
       0,  1518,     0,     0,     0,  1519,   661,     0,     0,  1521,
       0,     0,   662,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1522,     0,
       0,     0,  1523,     0,  1524,  1525,  1526,  1527,     0,     0,
       0,     0,     0,     0,     0,  1528,     0,     0,     0,     0,
     663,     0,     0,     0,     0,   664,     0,     0,     0,     0,
       0,     0,  1529,     0,     0,     0,     0,     0,     0,     0,
    1530,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2401,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1612,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1531,  1532,     0,     0,
       0,     0,     0,     0,     0,     0,  2402,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2403,     0,     0,     0,
       0,  1533,     0,     0,  1534,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1535,     0,     0,     0,     0,
       0,  1536,     0,     0,     0,  1537,     0,  1538,  1539,     0,
       0,     0,     0,     0,     0,  2404,     0,     0,     0,     0,
       0,  1540,     0,     0,  1541,  1542,     0,     0,     0,     0,
    1543,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -697,     0,     0,  1544,     0,  1545,  1546,
       0,     0,     0,     0,     0,     0,     0,  1547,  1548,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1549,  1550,  1551,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1552,  1553,  1554,  1555,  2405,  1556,     0,     0,     0,  1557,
    1558,     0,  2406,     0,     0,     0,     0,  1559,  1560,     0,
       0,     0,     0,     0,     0,     0,  1561,  1562,  1563,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,     0,  1565,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1566,     0,     0,
       0,     0,     0,     0,  1446,     0,     0,     0,     0,     0,
    1567,  1568,  1447,     0,     0,     0,  1569,     0,     0,     0,
       0,     0,  1613,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1570,
    1571,     0,     0,     0,  1448,     0,     0,     0,  1572, -3320,
   -3320,     0,     0,     0,     0,     0,  1573,     0,     0,     0,
       0,     0,  1574,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1449,  1450,  1451,  1452,  1453,  1454,
    1455,  1456,     0,     0,     0,     0,     0,     0,     0,  2407,
    1457,     0,  1575,     0,     0,  1458,     0,     0,  1576,     0,
       0,     0,     0,     0,     0, -3320,  1459,  1460,  1461,  1462,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1463,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1464, -3320,     0,  1465,  1466,  1467,
       0,  1468,  1577,     0,     0,     0,     0,     0,     0,  1578,
       0,  1579,     0,     0,  1580,     0,     0,     0,  2408,     0,
      59,  1581,     0,     0,     0,     0,     0,     0,     0,     0,
    2409,     0,     0,     0,  1582,  1469,     0,     0,  1583,     0,
       0,     0, -3391,     0,  1470,  1471,  1472,  1473,  1474,  1475,
    1476,  1477,     0,  -697,  2410,     0,     0,  1478,  1479,     0,
       0,     0,     0,     0,     0,  -697,     0,     0,     0,     0,
       0,     0,     0,     0,  -697,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1480,  1481,     0,     0,
    1482,  1483,     0,     0,     0,  1484,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1485,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1486,     0,     0,     0,  1487,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1488,     0,     0,     0,     0,     0,  1489,  1490,  2411,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1491,  1492,  1493,  1494,
    1495,     0,     0,  1496,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2412,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2413,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -697,     0,     0,
       0,     0,     0,  1497,  1498,  1499,  1500,     0,     0,     0,
       0,     0,  1501,  1502,     0,  1503,     0,  1504,  1505,  1506,
       0,     0,  1507,     0,  1508,     0,     0,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,     0,  2414,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1510,  1511,     0,
       0,     0,     0,     0,  -697,     0,     0,  1512,  1513,  1514,
    1515,  1516,  1517,     0,     0,     0,     0,     0,     0,     0,
       0,  1518,     0,     0,     0,  1519,  1520,     0,     0,  1521,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2415,     0,     0,  -697,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2416,
       0,     0,     0,     0,     0,     0,     0,     0,  1522,     0,
       0,     0,  1523,     0,  1524,  1525,  1526,  1527,   847,     0,
    2417,     0,     0,     0,   316,  1528,     0,     0, -3320, -3320,
   -3320,     0,     0,     0,     0, -3320,  1403,     0,     0,     0,
       0,     0,  1529,     0,     0,     0,     0,     0,     0,     0,
    1530,     0,     0,     0,     0,     0,     0,     0,     0,  1404,
    1405,  1406,  1407,  1408,  1409,  1410,  1411,     0,  2418,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1531,  1532,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -697,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1533,     0,     0,  1534, -3391,     0,     0,     0,     0,
       0,     0,  2419, -3320, -3320,  1535,     0,     0,     0,     0,
       0,  1536,     0,     0,     0,  1537,     0,  1538,  1539,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2420,     0,
       0,  1540,     0,     0,  1541,  1542,     0,     0,     0,     0,
    1543,     0,   848,  2421,     0,  2422,     0,  2423,   849,   850,
    2424,     0,     0,     0,  2425,     0,  1544,     0,  1545,  1546,
       0,     0,     0,     0,   852,     0,     0,  1547,  1548,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -697,     0,     0,     0,
    1549,  1550,  1551,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1552,  1553,  1554,  1555,     0,  1556,     0,     0,     0,  1557,
    1558,     0,     0,     0,     0,     0,     0,  1559,  1560,     0,
       0,     0,     0,     0,     0,     0,  1561,  1562,  1563,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,     0,  1565,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1566,     0,     0,
       0,     0,     0,     0, -3320,     0,     0,     0,     0,     0,
    1567,  1568,     0,     0,     0,     0,  1569,     0,     0,     0,
       0,     0,     0,  1412,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1570,
    1571,     0,     0,     0,     0,     0,     0,     0,  1572,     0,
       0,     0,     0,     0,     0,     0,  1573,     0,     0,     0,
       0,     0,  1574,     0,     0,     0,     0,   853,   854,   855,
       0,     0,     0,     0,     0,   847,     0,     0,     0,   856,
       0,   316,     0,     0,     0,  2072,  2073,  2074,     0,     0,
   -3320, -3320,  1575,  3663,     0,     0,     0,     0,  1576,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3664,  3665,  3666,  3667,
    3668,  3669,  3670,  3671,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1413,     0,     0,
       0,     0,  1577,     0,     0,     0,     0,     0,     0,  1578,
       0,  1579,     0,     0,  1580,     0,     0,     0,     0,     0,
       0,  1581,     0,     0,     0,   857,   858,   859, -3320, -3320,
       0,     0,     0,     0,  1582,   860,     0,   861,  1583,     0,
       0,     0,     0,     0,   318,     0,     0,     0,   862,   863,
     864,  2075,     0,     0,     0,     0,     0,   865,     0,     0,
     319,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   866,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   848,
       0,     0,     0,     0,     0,   849,   850, -3320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1414,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3320,     0,   847,     0,     0,     0,     0,     0,
     316, -3320,     0,   867,     0,     0,     0,     0,     0,     0,
   -3320,     0,     0,     0,     0,     0,     0,     0,  1415,     0,
       0,     0,     0,     0,     0, -1912,     0,     0,     0,     0,
       0,   868,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1912, -1912, -1912, -1912,     0,     0,     0,
       0, -1912,     0, -3320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1912,
   -1912,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2076,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1912,
   -1912,     0,     0, -1912,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   869,     0,
       0,     0,     0,     0,   853,   854,   855,     0,   848,     0,
       0,     0,     0,     0,   849,   850,   856,     0,     0, -1912,
       0,     0,     0,     0,     0,     0,     0,  2077,  2078,     0,
     852,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   847,     0,     0,     0,     0,     0,   316,
       0,   321,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,   871,     0,
       0,     0,   857,   858,   859,  2079,  2080,     0,     0,     0,
       0,     0,   860,     0,   861,     0,     0,     0,     0,     0,
       0,   318,     0,     0,     0,   862,   863,   864,     0,     0,
       0,     0,     0,     0,   865,     0,  1416,   319,  1417,     0,
   -3320, -1912,     0,     0, -3320,     0, -3320,  1418,  1419,   322,
       0,  1420,  1421,     0,   866,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   873,     0,     0,
       0,     0,     0,     0,  2081,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   874,     0,     0,     0,     0,  1414,
   -1912,     0,   875,   853,   854,   855,     0,     0,     0,  2082,
       0,     0,     0,     0,     0,   856,   847,   848,  2083,     0,
     867,     0,   316,   849,   850,     0,     0,  2084,     0,     0,
     876,     0,     0,     0,  1403,  3673,     0,   207,     0,   852,
   -1912,     0,   317,     0,     0,     0,     0,     0,   868,     0,
       0,     0,   324,     0,     0,     0,     0,  1404,  1405,  1406,
    1407,  1408,  1409,  1410,  1411,     0,     0,     0,     0,     0,
    2085,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     320,   857,   858,   859,     0,     0,     0,     0,   847,     0,
       0,   860, -1912,   861,   316,     0,     0,     0,     0,     0,
     318,     0,     0,     0,   862,   863,   864,     0,     0,     0,
       0,     0,     0,   865, -1912,     0,   319,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3418,     0,   866, -1912,   869,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     848,     0,     0,     0,     0,     0,   849,   850,     0,     0,
       0, -1912,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   852,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   853,   854,   855,     0,     0,     0,     0,   867,
       0,     0,     0,     0,   856,     0,  1016,     0,   321,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1912,     0,     0,     0,     0,   868,     0,     0,
       0,   317,     0,     0,   870,   871,     0,     0,     0,     0,
       0,     0,   848,     0,   847,     0, -1912, -1912,   849,   850,
     316,     0,     0,     0,     0,     0,     0,     0,  1109,     0,
       0,     0,     0,     0,   852,     0,     0,     0,     0,     0,
       0,     0,     0,  3674,     0,  3675,     0,  2086,     0,   320,
       0,  2087,     0,  2088,  3676,  3677,   322,     0,  3678,  3679,
     857,   858,   859,     0,     0,     0,     0,     0,     0,     0,
     860,  1412,   861,     0,   873,     0,     0,     0,     0,   318,
       0,     0,     0,   862,   863,   864,     0,     0,     0,     0,
       0,     0,   865,     0,     0,   319,     0,     0,     0,     0,
       0,   874,     0, -1912,   869, -1912, -1912,     0,     0,   875,
       0,     0,   866,     0,     0,   853,   854,   855,     0,     0,
       0,     0,     0,     0,     0, -1912,     0,   856,     0,     0,
   -1912,     0,     0,     0,     0,     0,     0,   876,     0,     0,
       0,     0,     0,     0,   207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,     0, -3418,     0,     0,   324,
       0,     0,     0,     0,     0,     0,     0,     0,   848, -1912,
       0,     0,     0,     0,   849,   850,     0,   321,   867,     0,
       0, -1912,     0,     0,  1045,  1413,     0,     0,     0,     0,
     852,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   870,   871,     0,   868,   853,   854,   855,
       0,     0,     0,   857,   858,   859,     0,     0,     0,   856,
       0,     0,     0,   860,     0,   861,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,   862,   863,   864,     0,
       0,     0,     0,     0,     0,   865,   317,     0,   319,     0,
       0,     0,     0,     0,     0,   322,     0,     0,   320,     0,
       0,     0,     0,     0,     0,   866,     0,     0,     0,     0,
       0,     0,     0,   873,     0,     0,   847,     0,     0,     0,
   -1912,     0,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1912,     0,     0,     0,     0,     0,
     874,     0,     0,     0,     0,   857,   858,   859,   875,     0,
    1414,  1018,     0,   869,     0,   860,     0,   861,     0,     0,
       0,     0,     0,     0,   318,     0,     0,     0,   862,   863,
     864,   867,     0,     0,     0,     0,   876,   865,     0,     0,
     319,     0, -1912,   207,     0,     0,  1415,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   866,   324,   868,
       0,     0,     0,   853,   854,   855,     0,     0,   847,     0,
       0,     0,     0,     0,   316,   856,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,     0,     0,     0,     0,     0,     0,     0,
       0,   320,   870,   871,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   867,     0,     0,     0,     0,     0,     0,
     848,     0,     0,   847,     0,     0,   849,   850,     0,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   868,   852,     0,     0,     0,     0,     0,     0,     0,
       0,   857,   858,   859,   322,     0,   869,     0,     0,     0,
       0,   860,     0,   861,     0,     0,     0,     0,     0,     0,
     318,     0,   873,     0,   862,   863,   864,     0,     0,     0,
       0,     0,     0,   865,     0,     0,   319,     0,     0,     0,
       0,     0,     0,   320,     0,     0,     0,     0,     0,   874,
       0,     0,     0,   866,     0,     0,     0,   875,     0,     0,
       0,     0,   848,     0,     0,   847,     0,     0,   849,   850,
       0,   316,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,     0,     0,   852,   876,     0,     0,     0,     0,
       0,   533,   207,     0,     0,     0,     0,     0,   869,     0,
       0,     0,     0,     0,     0,   870,   871,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   867,
       0,     0,     0,     0,     0,     0,     0,   848,     0,     0,
       0,     0,     0,   849,   850,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1416,     0,  1417,   868,     0,   852,
       0,     0,     0,     0,     0,  1418,  1419,   322,     0,  1420,
    1421,     0,     0,     0,     0,   853,   854,   855,     0,     0,
       0,   321,     0,     0,     0,   873,     0,   856,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,   871,   320,
       0,     0,   874,     0,   317,     0,     0,     0,     0,     0,
     875,     0,  1110,     0,     0,     0,     0,     0,     0,   848,
       0,     0,     0,   847,     0,   849,   850,     0,     0,   316,
       0,     0,     0,     0,     0,     0,     0,     0,   876,     0,
       0,   852,     0,     0,     0,   207,     0,     0,     0,   322,
       0,     0,     0,     0,   869,     0,     0,   853,   854,   855,
     324,     0,     0,   857,   858,   859,     0,   873,     0,   856,
       0,     0,     0,   860,     0,   861,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,   862,   863,   864,     0,
       0,     0,     0,     0,   874,   865,   317,     0,   319,     0,
       0,     0,   875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   866,     0,     0,     0,     0,
       0,     0,   853,   854,   855,     0,     0,   321,  1709,     0,
     876,     0,     0,     0,   856,     0,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324,   870,   871,   857,   858,   859,     0,     0,
       0,   317,     0,     0,     0,   860,     0,   861,     0,     0,
       0,     0,     0,     0,   318,     0,     0,   848,   862,   863,
     864,   867,     0,   849,   850,     0,     0,   865,     0,     0,
     319,     0,     0,     0,     0,     0,     0,     0,     0,   852,
       0,     0,     0,     0,     0,   322,     0,   866,     0,   868,
       0,     0,     0,     0,   853,   854,   855,     0,     0,     0,
     857,   858,   859,   873,     0,   847,   856,     0,     0,     0,
     860,   316,   861,     0,     0,     0,     0,     0,     0,   318,
       0,     0,     0,   862,   863,   864,     0,     0,     0,     0,
     874,     0,   865,   317,     0,   319,     0,     0,   875,     0,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   866,   867,     0,     0,     0,     0,     0,     0,
     960,     0,     0,     0,     0,     0,   876,     0,     0,     0,
       0,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,   868,     0,     0,     0,     0,     0,     0,   324,     0,
       0,     0,   857,   858,   859,     0,   869,     0,     0,     0,
       0,     0,   860,     0,   861,     0,     0,     0,     0,     0,
       0,   318,     0,     0,     0,   862,   863,   864,   867,     0,
       0,     0,     0,     0,   865,     0,     0,   319,     0,     0,
       0,     0,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   866,     0,   868,     0,     0,     0,
       0,     0,   853,   854,   855,     0,     0,     0,     0,   848,
       0,     0,   847,     0,   856,   849,   850,     0,   316,   321,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   852,     0,     0,     0,     0,     0,     0,   869,     0,
       0,   317,     0,     0,     0,   870,   871,     0,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     867,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1292,     0,     0,     0,     0,     0,   868,     0,
       0,     0,     0,     0,     0,     0,     0,   322,     0,     0,
     857,   858,   859,   869,     0,     0,     0,     0,     0,     0,
     860,   321,   861,     0,     0,   873,     0,     0,     0,   318,
       0,     0,     0,   862,   863,   864,     0,     0,     0,     0,
       0,     0,   865,     0,     0,   319,     0,   870,   871,     0,
     320,     0,   874,     0,     0,     0,     0,     0,     0,     0,
     875,     0,   866,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   848,     0,   847,     0,
       0,     0,   849,   850,   316,     0,   321,     0,   876,     0,
       0,     0,     0,     0,     0,   207,     0,     0,   852,   322,
       0,     0,     0,     0,     0,   869,     0,     0,     0,     0,
     324,     0,   870,   871,   853,   854,   855,   873,     0,     0,
       0,     0,     0,     0,  1953,     0,   856,     0,   867,     0,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   874,     0,     0,     0,     0,     0,
       0,     0,   875,   317,     0,     0,   868,     0,     0,     0,
       0,     0,     0,     0,   322,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
     876,     0,   873,     0,     0,     0,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324,     0,   870,   871,     0,     0,   320,   874,
       0,     0,   857,   858,   859,     0,     0,   875,     0,     0,
       0,     0,   860,     0,   861,     0,     0,     0,     0,     0,
       0,   318,   848,     0,     0,   862,   863,   864,   849,   850,
       0,     0,     0,     0,   865,   876,     0,   319,     0,     0,
       0,     0,   207,     0,   852,     0,   322,     0,  2730,     0,
       0,     0,     0,   869,   866,     0,     0,   324,     0,     0,
       0,   853,   854,   855,   873,     0,     0,     0,   848,     0,
       0,     0,     0,   856,   849,   850,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     852,   874,     0,     0,     0,     0,  3339,     0,     0,   875,
     317,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3280,     0,
     867,     0,     0,     0,     0,     0,   321,   876,     0,     0,
       0,     0,     0,     0,   207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   868,   324,
       0,     0,   870,   871,     0,     0,     0,     0,     0,   857,
     858,   859,     0,     0,     0,     0,     0,     0,     0,   860,
       0,   861,     0,     0,     0,     0,     0,     0,   318,     0,
       0,     0,   862,   863,   864,     0,     0,     0,     0,     0,
       0,   865,     0,     0,   319,     0,     0,     0,     0,     0,
     320,     0,     0,     0,   322,     0,     0,     0,     0,     0,
       0,   866,     0,     0,     0,     0,     0,   853,   854,   855,
       0,     0,   873,     0,     0,     0,     0,     0,     0,   856,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   874,
       0,     0,     0,     0,     0,   869,   317,   875,     0,     0,
       0,     0,     0,   853,   854,   855,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   856,     0,   867,     0,     0,
       0,     0,     0,     0,     0,   876,     0,     0,     0,     0,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,     0,     0,   868,     0,   324,     0,     0,
       0,     0,     0,     0,     0,   857,   858,   859,     0,     0,
       0,     0,     0,     0,     0,   860,     0,   861,   321,     0,
       0,     0,     0,     0,   318,     0,     0,     0,   862,   863,
     864,  2401,     0,     0,     0,     0,     0,   865,     0,     0,
     319,     0,     0,     0,   870,   871,  2153,   320,     0,     0,
       0,   857,   858,   859,     0,     0,  2154,   866,     0,     0,
       0,   860,     0,   861,     0,     0,     0,  2402,     0,     0,
     318,     0,  2155,     0,   862,   863,   864,     0,     0,     0,
       0,     0,     0,   865,     0,     0,   319,  2403,     0,     0,
       0,     0,     0,  2156,     0,     0,   322,     0,     0,     0,
       0,     0,   869,   866,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   873,     0,     0,     0,     0,     0,
       0,  2157,     0,   867,     0,     0,  2404,     0,     0,     0,
       0,     0,     0,     0,  2158,  2159,  2160,     0,     0,  2161,
       0,   874,     0,     0,     0,     0,  2162,     0,     0,   875,
       0,   868,     0,     0,  -698,     0,     0,     0,  2163,     0,
    2164,  2165,     0,     0,     0,     0,     0,     0,     0,   867,
       0,     0,     0,     0,     0,   321,     0,   876,     0,     0,
       0,     0,     0,     0,   207,     0,     0,     0,  2166,     0,
       0,     0,     0,     0,     0,     0,     0,   868,     0,   324,
       0,   870,   871,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2405,     0,     0,     0,     0,
       0,     0,     0,  2406,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3559,     0,     0,  2167,     0,     0,     0,     0,     0,   320,
       0,     0,     0,   322,     0,     0,     0,     0,   869,  2168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   873,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2169,  2170,     0,  2171,  2172,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   874,     0,
       0,     0,     0,     0,   869,     0,   875,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3320, -3320,     0,     0,     0,     0,     0,     0,     0,  2173,
       0,   321,     0,     0,   876,     0,     0,     0,     0,     0,
       0,   207,     0,     0,     0,  2174,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   324,   870,   871,     0,
    2407,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3320,   321,     0,     0,
       0,     0,     0,     0,     0,  2175,  2176,  2177,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   870,   871,     0, -3320,     0,  2178,   322,
       0,     0,     0,  2179,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   873,     0,  2408,
       0,    59,     0,     0,     0,     0,     0,     0,  2180,  2181,
       0,  2409,     0,     0,  2182,  2183,     0,     0,     0,     0,
       0,     0,     0, -3391,   874,   322,     0,     0,     0,     0,
       0,     0,   875,     0,  -698,  2410,     0,     0,     0,     0,
       0,     0,     0,   873,     0,     0,  -698,     0,     0,     0,
       0,     0,     0,     0,     0,  -698,     0,     0,     0,     0,
     876,     0,     0,     0,     0,     0,     0,   207,     0,  2184,
     874,  2185,     0,     0,     0,     0,     0,     0,   875,     0,
       0,     0,   324,     0,     0,     0,     0,     0,  2186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2187,  2188,  2189,     0,     0,   876,     0,     0,     0,
       0,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   324,  2190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2411,     0,     0,  2191,  2192,  2193,     0,  2194,     0,  2195,
    2196,     0,  2197,  2198,  2199,     0,     0,     0,     0,     0,
    2200,     0,  2201,  2202,  2203,  2204,     0,     0,  4483,     0,
       0,     0,     0,     0,     0,     0,     0,  2412,  2205,     0,
       0,  4484,  4485,  4486,  4487,     0,  2206,     0,  2413,  4488,
       0,     0,     0,     0,     0,     0,     0,     0,  -698,     0,
       0,  2207,  2208,     0,     0,     0,     0,  4489,  4490,     0,
    2209,     0,     0,     0,     0,     0,  2210,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4491,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2414,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4492,     0,     0,     0,     0,  -698,     0,  1837,  4493,     0,
       0,  1838,     0,  2211,     0,     0,     0,     0,     0,  2212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2415,     0,     0,  -698,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4494,     0,     0,     0,
    2416,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2213,  2214,  2215,     0,     0,     0,     0,     0,
       0,  2417,  2216,     0,     0,     0,     0,     0,     0,     0,
       0,   890,     0,     0,     0,     0, -3320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2217,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2218,  2219,  2220,  2221,     0,     0,     0,     0,     0,  2418,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2222,  2223,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2224,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -698,     0,     0,     0,     0,     0,  4495,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2225,     0,     0,     0,     0, -3391,     0,     0,     0,
       0,     0,     0,  2419, -3320,  2226,  2227,     0,     0,     0,
       0,     0,     0,   848,     0,     0,     0,     0,     0,   849,
     850,     0,     0,     0,     0,     0,     0,     0,     0,  2420,
       0,     0,     0,     0,     0,   852,     0,     0,  4496,     0,
       0,     0,  2228,     0,  2421,     0,  2422,  4497,  2423,  4498,
       0,  2424,  2229,     0,     0,  2425, -3320,     0,     0,  2230,
       0,     0,     0,     0,     0,     0,  4499,     0,     0,     0,
    2231,     0,     0,     0,  2232,  2233,  2234,     0,  4500,     0,
   -1178,     0,     0,     0,     0,     0,     0,  -698,     0,     0,
       0,  4483,     0,     0,     0,  2235,  2236,     0,     0,     0,
    2237,  2238,     0,  2239,  4484,  4485,  4486,  4487,     0,     0,
    2240,    59,  4488,     0,     0,     0,     0,     0,     0,     0,
       0,  2409,     0,     0,     0,     0,     0,     0,     0,     0,
    4489,  4490,     0, -3391,     0,     0,     0,  4501,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4502,  4491,     0,     0,  4503,     0,     0,     0, -1178,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4504,  4492, -1178,     0,     0,     0,     0,     0,
    1837,  4493,     0,     0,  1838,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   853,   854,
     855,     0,     0,     0,     0,     0,     0,     0,  4505,     0,
     856,     0,     0,     0,     0,  1865,     0,     0,     0,  4494,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   890,   317,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4506,     0,  1866,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4507,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2412,     0,     0,
       0,     0,     0,     0,  1840,  1841,   857,   858,   859,     0,
       0,     0,     0,     0,     0,     0,   860,     0,   861,     0,
       0,     0,     0,     0,     0,   318,     0,     0,  4508,   862,
     863,   864,     0,     0,     0,     0,     0, -1178,   865,     0,
       0,   319,  4495,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   848,     0,
       0,     0,     0,     0,   849,   850,     0,     0,     0,     0,
       0,   890,     0,     0,     0,     0,     0,     0,     0,  4509,
     852,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1871,     0,  1872,  1873,     0,     0,     0,     0,     0,
       0,  4496,     0,     0,     0,     0,     0,     0,     0,     0,
    4497,     0,  4498,     0,     0,     0,     0,     0,     0, -3320,
       0,     0,     0,     0,   867,     0,  4510,     0,   890,  4499,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4500,     0, -1178,     0,     0,     0,     0,     0,     0,
       0,  2417,   868,     0,     0,     0,     0,  4511,     0,     0,
       0,     0,     0,     0,     0, -1178,     0,     0,     0,  4512,
       0,     0,     0,     0,    59,     0,     0,     0,     0,     0,
       0,     0,     0,   848,  2409,     0,     0,     0,     0,   849,
     850,     0,     0,     0,     0,     0, -3391,     0,     0,     0,
    4501,     0,     0,  4513,   320,   852,     0,     0,     0,     0,
       0,     0,     0,  4502,     0,     0,     0,  4503,     0,     0,
       0, -1178,     0,     0,     0,     0,     0,     0,  4514,     0,
       0,     0,     0, -1121,     0,  4504,     0, -1178,     0,  4515,
     848,     0,     0, -1178,     0,     0,   849,   850,     0,     0,
       0,     0,     0,   853,   854,   855, -3391,     0,     0,   869,
       0,     0,   852,     0,     0,   856,     0,     0,  4516,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4505,     0,     0,     0,     0,     0,     0,  1865,  2420,
       0,     0,   317,     0,     0,     0,     0,  4517,     0,     0,
       0,     0,     0,     0,     0,     0,  4518,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4506,     0,  1866,     0,     0,     0,     0,
       0,     0,   321,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4507,     0,     0, -1178,     0,     0,     0,
       0,   857,   858,   859,     0,     0,     0,     0,   870,   871,
    2412,   860,     0,   861,     0,     0,     0,  1840,  1841,     0,
     318,     0,     0,     0,   862,   863,   864,     0,   853,   854,
     855,     0,     0,   865,     0,     0,   319,     0,     0,     0,
     856,  4508,     0,     0,     0,     0,     0,  1932,     0,     0,
   -1178,     0,     0,     0,     0,     0,     0,     0,   891,     0,
     322,     0,   892,   893,     0,     0,     0,   317,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   873,     0,
       0,     0,     0,     0,     0,   853,   854,   855,     0,     0,
       0,     0,  4509,     0,     0,     0,     0,   856,     0,     0,
       0,     0,     0,     0,  1871,   874,  1872,  1873,     0,     0,
       0,     0,     0,   875,     0,     0,     0,     0,     0,   867,
       0,     0,     0,     0,   317,     0,   857,   858,   859,     0,
       0,     0,     0,     0,     0,     0,   860,     0,   861,  4510,
       0,   876,     0,     0,     0,   318,     0,   868,   207,   862,
     863,   864,     0,     0,     0,     0,     0,     0,   865,     0,
       0,   319,     0,   324,  2417,     0,     0,     0,     0,     0,
    4511,     0,     0,     0,     0,     0,     0,     0, -1178,     0,
       0,     0,  4512,   857,   858,   859,     0,     0,     0,     0,
       0,     0,     0,   860,     0,   861,     0,   890,     0,   320,
       0,     0,   318,     0,     0,     0,   862,   863,   864,     0,
       0,     0,     0,     0,     0,   865,  4513,     0,   319,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4514,     0,     0,   867,     0, -1124,     0,     0,     0,
       0,     0,  4515,     0,   869,     0, -1178,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3391,
       0,     0,   868,     0,     0,     0,     0,     0,     0,     0,
       0,  4516,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   867,  2420,     0,     0,     0,     0,     0,     0,   848,
    4517,     0,     0,     0,     0,   849,   850,     0,     0,  4518,
       0,     0,     0,     0,   320,     0,     0,   321,     0,   868,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   890,     0,     0,
       0,     0,     0,   870,   871,     0,     0,     0,     0, -1178,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   869,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2832,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   891,     0,   322,     0,   892,   893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   873,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   869,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     874,     0,   321,     0,     0,     0,     0,     0,   875,   848,
       0,     0,     0,     0,     0,   849,   850,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   870,   871,
       0,   852,     0,     0,     0,     0,   876,     0,     0,  3094,
       0,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   853,   854,   855,     0,   324,   321,
       0,     0,     0,     0,     0,     0,   856,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   891,     0,
     322,     0,   892,   893,     0,   870,   871,     0,     0,     0,
       0,     0,     0,   317,     0,     0,  3096,     0,   873,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   848,     0,     0,     0,   874,     0,   849,   850,     0,
       0,     0,     0,   875,     0,   891,     0,   322,     0,   892,
     893,     0,     0,   852,     0,     0,     0,     0,     0,     0,
       0,     0,   857,   858,   859,   873,     0,     0,     0,     0,
       0,   876,   860,     0,   861,     0,     0,     0,   207,     0,
       0,   318,     0,     0,     0,   862,   863,   864,     0,     0,
       0,     0,   874,   324,   865,     0,     0,   319,     0,     0,
     875,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   853,   854,   855,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   856,     0,   876,     0,
       0,     0,     0,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,     0,     0,   317,     0,     0,     0,  1256,     0,     0,
       0,     0, -3418,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3418, -3418, -3418, -3418,     0,
     867,     0,  1257, -3418,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   848,     0,
       0,     0, -3418,     0,   849,   850,     0,     0,   868,     0,
       0,     0,   857,   858,   859,     0,     0,     0,     0,     0,
     852,     0,   860,     0,   861,     0,   853,   854,   855,     0,
       0,   318,     0,     0,     0,   862,   863,   864,   856,     0,
       0,     0,     0,     0,   865,     0,     0,   319,     0,     0,
       0, -3270, -3418,     0,     0, -3270,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   317,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3418,
       0, -3418,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3418,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   869,     0,     0,     0,     0,
       0,     0,     0,     0,   857,   858,   859,     0,     0, -3418,
     867,     0,     0,     0,   860,     0,   861,     0,     0,     0,
       0,     0,     0,   318,     0,     0,   848,   862,   863,   864,
       0,     0,   849,   850,     0,     0,   865,     0,   868,   319,
       0,     0,     0,     0,     0,     0,     0,     0,   852,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
     848,     0,     0,   853,   854,   855,   849,   850,     0,     0,
       0,     0,     0,     0,     0,   856,     0,     0,     0,     0,
     320,     0,   852,     0,   870,   871,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   867,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   891,   869,   322,     0,   892,   893,
     868,     0, -3418,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1258, -3418,   873,     0,     0,     0,     0,     0,
       0,   857,   858,   859,     0,     0,     0,     0,     0,     0,
       0,   860,     0,   861,     0,     0,     0,     0,     0,     0,
     318,   874, -3418,     0,   862,   863,   864,     0,     0,   875,
       0,     0,   320,   865,     0,     0,   319,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   853,   854,   855,     0,     0,     0,   876,     0,     0,
       0,     0,     0,   856,   207,     0,     0, -3418,     0,     0,
       0,     0,     0,     0,   870,   871,     0,     0,  4876,   324,
       0, -3418,     0,     0,     0,     0,     0,   869,     0,     0,
     317,     0,     0,     0, -3270,   853,   854,   855,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   856,     0,     0,
       0,     0,     0, -3418,     0,     0, -3418,     0,     0,   867,
       0,     0,     0,     0,   891,     0,   322,     0,   892,   893,
       0,     0,     0,     0,   317,     0,  1259,     0,     0,     0,
       0,     0,     0,     0,   873,     0,     0,   868,     0,   857,
     858,   859,     0,     0,     0,     0,     0,     0,     0,   860,
     321,   861, -3418,     0,     0,     0,     0,     0,   318, -3418,
       0,   874,   862,   863,   864,     0,     0,     0,     0,   875,
       0,   865,     0,     0,   319,     0,   870,   871,     0,     0,
       0,     0,     0,     0,     0,   859,     0,     0,     0,   320,
       0,     0,     0,     0,     0,     0, -3418,   876,     0,     0,
       0,     0,   318,     0,   207,     0,   862,   863,   864,     0,
       0,     0,     0,     0, -3418,   865,     0,     0,   319,   324,
       0,     0,     0,     0,     0,     0,     0,     0,   322,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3270, -3270,
       0,     0,     0,     0,   869,     0,   873,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   867,     0,     0,
       0,     0, -3418,     0,     0, -3418,     0,  4877,     0,     0,
       0,     0,     0,   874,     0,     0,     0,     0,     0,     0,
       0,   875,     0,     0,     0,   868,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   867,     0,     0,     0,     0,     0,     0,     0,   876,
       0,     0,     0, -3418,     0,     0,   207,   321,     0,     0,
       0,     0,     0,     0,     0, -3418,     0, -3418, -3418,     0,
       0,   324,     0,     0,     0,     0,     0,   320,     0,     0,
       0,     0,     0,   870,   871,     0,     0, -3418,     0,     0,
       0,     0, -3418,     0,     0,     0,     0,     0,     0,     0,
   -3418,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3418,   869,     0,     0,   322,     0,   892,     0,     0,
       0,     0,     0, -3418,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   873,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   869, -3418,     0,     0,
     874,     0,     0,     0,     0,     0,     0,     0,   875,     0,
       0,     0,     0,     0,     0,     0,     0, -3272, -3418,     0,
       0,     0,     0,     0,     0,   321,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   876,     0,     0,     0,
       0,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,   870,   871,     0,     0,     0,     0,     0,   324,     0,
       0,     0, -3418,     0,     0,     0,     0,     0,     0,   321,
       0,     0,     0,     0, -3418,     0,     0,     0,     0,     0,
       0, -3418,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   870,   871,     0,     0,     0,
       0,     0,     0,   322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   873,     0,     0,   533,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   322,   874,     0,
       0,     0,     0,     0,     0,     0,   875,     0,     0,     0,
       0,     0,     0,     0,     0,   873,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   876,     0,     0,     0,     0,     0,
       0,   207,   874,     0,     0,     0,     0,     0,     0,     0,
     875,     0,     0,     0,     0,     0,   324,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   876,     0,
       0,     0,     0,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324
};

static const yytype_int16 yycheck[] =
{
     175,   224,    52,   316,   847,   156,   670,   158,    58,  1272,
    1614,  1118,   163,   717,  1267,   266,   707,   745,   680,   127,
     684,   711,   194,   689,  1750,   753,    43,  1214,   201,  1140,
    1057,    81,    82,  1717,    84,    85,   749,   750,   751,  2266,
     771,   754,  2394,   280,   775,   776,   683,   778,   779,  2450,
     781,   782,    73,  1350,   205,   675,   720,  1830,    79,    76,
      77,    78,  1839,  1413,   800,   801,    83,  1844,   118,    90,
     307,  2423,  1426,  2574,  2022,  1097,   791,   687,   669,  1770,
    2468,  2469,   692,  2718,  2032,   944,   309,   930,  2589,  1386,
    1387,  1388,  1389,  1751,  1868,   145,   146,   147,   670,  1278,
     692,   711,  2898,   675,  2900,   843,   772,   773,  2542,   671,
    1289,   777,   696,  2837,   780,   687,  1082,  1292,  2552,   711,
     692,  2888,   139,  1992,   715,  1898,   938,  3357,   712,  1724,
     872,  3381,  1288,  1906,  2395,  2725,   153,  2307,   155,   711,
     190,  2336,   159,   160,  1300,   195,   973,  3689,  1193,  2061,
    1195,  1196,   169,  1198,  1199,  2021,  2263,  2467,   175,  2687,
    2757,  2899,   938,  3082,   181,  1638,     1,   184,  2534,  2535,
     187,     1,   882,     0,  2540,  2541,  2042,  2543,  1927,     1,
      18,  1930,    18,     8,    27,   670,   203,    33,    33,  2058,
    1939,   901,     5,  2663,  1943,    75,   246,    99,    46,   249,
       0,  1950,   223,    18,   221,   230,   860,   861,    41,     1,
      27,    18,   233,  1072,   868,   232,   123,   267,   882,  1394,
      18,    18,   151,    18,     1,    46,   890,   891,   892,   893,
     170,   681,    18,    15,    18,    45,    45,   901,   255,   124,
      12,    97,    18,   121,   171,   212,   221,    43,   698,   699,
    1272,  1245,  1898,   225,   567,    97,    97,   244,   124,   913,
    1906,   124,   256,   249,   507,  1041,     0,  3546,   254,  1669,
      40,  1889,   289,   133,   184,   185,  1380,   310,   266,  2645,
     124,   257,  2648,   310,   243,   288,    68,   204,   872,  2655,
    1102,   341,  2658,   337,   337,     1,   243,    18,   348,    18,
    2801,  2802,   357,   128,   183,   357,   249,   257,    25,   272,
      33,   254,   333,   334,    22,    23,    24,   303,   890,   891,
     892,   893,   250,  1027,   272,  3166,  1102,    18,   187,    91,
     171,  1143,   431,    41,    12,  3176,  1031,   328,   124,   443,
      43,    18,   431,  3373,   443,  1376,   151,   909,   116,   184,
     464,   431,  4101,   478,   213,   409,   276,   298,    69,   375,
     303,   933,   250,   151,   411,   540,   375,  3397,  1110,   459,
     618,  1402,   266,  1037,    44,  2834,   967,   497,   204,   431,
     478,    70,    90,   419,   680,    97,   136,   569,   442,  2258,
    2346,   171,  2982,  1057,   556,   153,   511,    12,   337,  1009,
    2990,    40,   438,  2993,  2994,    52,  3286,   892,   256,   178,
      18,  1115,   372,   246,   405,  1025,   151,   230,  1082,   622,
     128,    98,   449,   674,   570,   115,   677,   201,   134,   879,
      14,    33,   486,   470,   137,   256,   175,  1009,   141,   830,
     221,    18,   292,   680,   375,  4020,  2553,  1175,   154,   517,
    2816,  1626,   222,  1025,   705,   478,   310,   708,  4089,   298,
     245,   684,   713,   367,   288,  3715,   470,   267,   719,   175,
     176,   215,   430,   273,   244,  2344,  4035,  2142,  1142,  4215,
    4096,  4369,  1092,   772,   538,   848,   783,  1076,  1224,  1099,
     694,   431,   300,    49,  4113,   534,   677,  2898,   323,  2900,
    1092,   325,   326,   478,   215,   478,   772,   524,   525,    18,
      18,   300,  3742,  4072,   856,   845,     0,  1255,   211,   849,
    1092,   310,   539,  1261,   431,   867,  1110,  1099,   151,   546,
     980,   220,   225,   267,  1709,  1347,    92,   248,   246,   273,
     337,  1130,   175,    99,   994,    12,  4434,   568,   110,   478,
      25,   538,   431,   339,   151,   339,  4292,   854,   556,  2869,
     951,   597,   320,  1273,  2759,   538,   373,    32,   308,  1019,
    1142,   478,   372,  3492,   478,   464,   464,  4208,  3213,   371,
     360,  4156,  3378,   222,    99,   431,   431,   257,   951,    77,
     629,   187,   590,   473,   356,  1045,   151,  4213,  2825,  2860,
     429,   511,   670,   892,  4223,   405,   843,   407,   676,   529,
     568,  1275,  1276,  1277,   292,   151,  4175,   213,  1282,  1283,
    1284,  1285,   481,   827,  1288,   419,   892,  1077,  1338,   514,
     926,   806,   778,  1820,  1298,   123,  1300,  1301,   372,   642,
     357,  3029,  1380,  1307,  1308,  1309,  1310,  1311,  1312,  1313,
    1314,  1315,  1316,  1317,  1318,   427,  2340,  1142,  1108,   441,
    3188,   151,  1112,   478,  3544,  1329,   597,   453,     1,   453,
     376,   405,  1292,   407,  2751,    25,   927,   453,   859,   400,
    1344,    25,   864,   643,  4205,  1349,   223,   777,   456,    25,
    1140,   942,   929,   478,   123,   545,  2957,   478,   127,   736,
     538,   603,   950,  1275,  1276,  1277,   429,   136,   431,   400,
    1282,  1283,  1284,   567,   431,   427,  2070,   556,  4089,   375,
    1292,   336,   400,   400,   634,   431,  1298,   566,   151,  1301,
     538,  2600,   736,   848,   588,  1307,  1308,  1309,  1310,  1311,
    1312,  1313,  1314,  1315,  1316,  1317,  1318,   950,   590,   770,
     848,   411,  2885,   680,   443,  2528,    89,   478,   464,  2056,
    1397,  2717,  1807,   300,  2676,   367,   456,   470,   848,   543,
     476,   449,  1344,   494,  1394,   414,  1367,  1349,   478,   485,
    1936,   478,   459,   460,  1959,   400,   558,   478,  1025,  2562,
    1633,   469,   400,   471,   830,  3161,  1655,  1282,  1283,  1284,
     478,   478,   135,   494,   966,  2335,   523,   854,   825,   512,
     478,   245,   584,  1298,  1037,   585,   494,   494,   642,   538,
    1057,  2486,  1394,   400,   680,   409,   410,   665,  1822,   644,
     950,  3290,   676,   511,  1057,   763,    43,  4208,   680,   680,
     849,   966,  1292,   643,   794,  3435,   950,   464,   776,   865,
     642,   123,   951,   967,   469,   127,   471,   257,   442,  1344,
     950,  2261,   951,   478,  1349,   853,  2973,   575,   201,   123,
     478,   951,   250,   127,  1436,   763,  4625,   853,  1609,   494,
    1692,   528,   529,   530,   804,   481,   494,   941,   776,  3808,
     853,   400,   400,   563,   652,   295,   951,   297,   604,   951,
     802,   478,   486,  1140,   684,   853,  1601,   951,   951,   643,
     790,   123,  3942,   854,  2018,   127,  2562,   494,   951,   677,
     830,   624,   625,  4202,   951,   694,   843,   605,   951,  1379,
     137,  1641,   638,   400,   141,   777,   657,  3325,  2556,  1905,
     899,  1184,   802,  1393,  1394,   664,  1610,   826,   951,   785,
     755,   719,   899,  2353,   538,   943,   950,   790,   791,   853,
     951,  1804,  1805,   950,   950,   951,   657,   755,   745,   478,
     478,  3812,  1422,  3711,   215,   951,   951,  3378,   950,   657,
     657,   777,   848,   950,   951,   494,   494,   320,  3585,   695,
     605,   931,   968,  2015,   853,   855,   511,  1661,   861,   926,
     647,     1,   469,   866,   471,  3215,  1626,   584,   951,   854,
     760,   478,   951,  1623,  1189,   854,  1191,   843,  1255,  1194,
     755,  2015,   951,   840,  1261,  3377,   853,   494,  1203,   719,
     736,  1623,    32,  3503,   310,  1208,  1187,  1188,  1610,   917,
     853,   951,   657,   376,   951,   850,  1197,    12,   523,   657,
     892,  1623,   517,   853,  1626,   865,   865,   619,   827,  1790,
    1791,   853,   850,   901,   785,  1796,  3327,   952,  1799,  1242,
     926,   951,   761,  1683,   503,  1811,   853,  1741,   967,   967,
     657,  2112,   790,   791,   926,   926,   464,   575,   603,  1709,
     876,   863,   921,   837,   785,  1332,     0,   951,   431,  1350,
     943,   859,   950,  4022,   848,   951,   868,   785,   785,   951,
    1953,  1683,   445,   961,   898,   850,   951,  1167,   951,   853,
     958,   951,   898,   917,   708,  1362,   951,   951,    12,   951,
     966,   464,   755,   856,   375,   468,   951,  1709,   605,  2612,
     961,   968,   863,  1380,   951,  1957,   763,   853,   657,   657,
    3411,   951,   486,   951,   951,  1845,   951,    25,   755,   478,
     838,   943,  1816,   404,  1337,  3242,  4687,  1184,   968,  1741,
     785,   670,   863,   523,    48,   201,  1626,   785,   838,   523,
     950,  1957,  3289,  2841,  3291,   863,   863,   523,   950,   900,
     657,  3298,  3140,  3141,  3142,  3143,     1,   154,   921,   902,
     755,   201,   431,   310,   538,   945,  3944,  1949,   785,   865,
     949,   951,   951,   642,  1924,   478,    21,   951,  2992,   755,
     943,   318,   869,   870,  3093,  1242,   917,   850,   662,  1246,
     951,   503,  3365,   503,   968,   882,   701,  2264,  1688,  4158,
     931,  1905,  1259,   951,   950,   966,  3353,   950,   863,   503,
      33,   951,  1702,   850,   951,   863,  1741,   853,  2788,  1709,
     951,   967,   799,   470,   481,   755,  2950,  4809,   733,  3181,
     478,  3868,  1936,   951,  2101,   966,   785,   785,   243,  4650,
    2018,   818,   797,   951,   371,  1735,   863,   802,   966,   966,
    2981,   503,   431,   478,   902,   850,  3824,    53,   835,    55,
      56,    57,    58,    59,    60,   638,   861,   470,  3177,  3175,
    3179,   866,   588,   431,   850,    22,    23,    24,   785,  2506,
     749,   126,   419,   184,   478,    44,  4556,   761,   189,   584,
    3540,   760,   755,  3543,  3060,   950,   951,   670,   217,  1959,
     855,   438,   675,   951,  4068,   453,   400,  2313,     1,   584,
     967,   966,   538,   597,   863,   863,  3225,   941,   966,   453,
     850,   478,   695,   267,   697,  1949,   950,  1542,  2395,   273,
     642,   324,  1609,   400,  2105,   478,   442,  4607,   538,   184,
     300,   848,   187,  1955,   189,   763,   357,  1959,   642,   966,
    3585,   890,   891,   892,   893,   154,   863,  2576,   776,  2578,
    3661,    39,  2581,   357,    12,  2584,  2585,  2586,   213,  2588,
    2076,   507,  2591,   439,  3283,  3585,  3285,   624,   625,  1981,
     486,   128,   442,  2602,  2603,  2135,   459,   850,   431,   478,
     642,  2587,   464,   948,   478,   400,  1673,    94,  1661,   439,
     494,   137,   951,  2488,  2489,   141,   307,  2113,   848,  2494,
    2495,   478,    51,   244,   478,    48,  2122,   966,   966,   644,
     567,  1698,   341,  4187,  3468,   129,   486,   494,   372,   710,
     478,   371,   538,     0,   478,  2318,  2550,   749,   320,   321,
     486,   588,    44,    40,   951,  3631,  2058,   511,  4345,   357,
    2665,  4727,  2667,   411,   616,   749,   478,   411,  2529,   966,
     597,   405,   307,   407,   469,  3448,   471,   464,   140,  1746,
     452,   478,  3455,   478,  4104,   147,   400,   517,   538,   476,
     853,   608,   951,  2634,   857,   612,    69,   591,   485,   494,
     320,   850,   538,  3128,   376,   456,  3846,   749,   257,   722,
      25,   257,  1793,   459,  1795,    88,  1797,  1798,   237,  1800,
    1801,  4408,  2262,   374,   714,   642,   257,  2007,  1057,  2734,
    4810,  4811,  2593,  2594,   406,   374,   853,  3515,   447,   310,
     777,   375,   156,   736,   158,   745,  4812,    49,   419,   163,
     604,   853,  2656,  2657,   439,   469,   376,   471,   864,   967,
    4840,   298,   478,   926,   478,  2626,  2627,   438,   357,   853,
    2264,  2343,    98,   820,   478,   846,   638,   509,  4838,  2319,
     494,  3204,   638,  3297,  4381,   859,   950,   679,   951,    43,
      92,   205,   215,  3833,   853,   504,  2316,    99,   853,  2804,
     657,   585,   951,  3407,   967,   555,  2346,  1788,   638,  4363,
     605,   853,   883,  1142,  2675,  4414,  2256,  2257,   431,  2313,
     452,   537,   748,    22,   621,   523,    25,    26,   745,   575,
    1685,  3319,  2693,  3321,  2256,   222,    53,   581,    55,    56,
      57,    58,    59,    60,    45,   593,   481,   384,   385,  1696,
     950,   638,    18,   853,  2256,  2257,  2258,   375,   951,   322,
     298,  2736,   657,  3286,   299,   257,   951,   951,   915,   283,
    2410,   701,  2152,  1753,  2414,   464,  2268,   340,   175,  2740,
     592,   430,  2376,  2377,   853,   314,   951,   476,   689,   621,
     373,   605,   604,  2754,   750,   221,   485,  2758,   850,   367,
    4040,   785,   486,   733,   638,   621,   854,   124,   695,   643,
    3886,  1758,   642,   951,   777,  1762,  1763,   538,  1765,  1986,
     750,  1768,  1769,  2419,  1771,   462,   463,   864,   785,  2343,
    3451,  2492,   478,  1784,   950,  2501,   951,   950,   876,  2484,
     575,  2486,  2344,   657,   470,   428,  1275,  1276,  1277,   736,
     943,  2018,   876,  1282,  1283,  1284,  2598,   740,   212,   610,
     950,  3795,   400,  2824,  2816,   400,   799,   951,   719,  1298,
     171,   610,  1301,  1978,  2376,  2377,   507,    38,  1307,  1308,
    1309,  1310,  1311,  1312,  1313,  1314,  1315,  1316,  1317,  1318,
     785,   853,  4049,   247,   531,   857,  1999,   853,   890,   486,
    1847,  2569,  3775,  2860,   951,   777,  1853,  4147,   470,  1856,
     497,  1858,   474,  2809,   563,  1344,  3789,   588,   951,   568,
    1349,   722,  2542,   853,   951,   398,  3043,  3044,  2548,   566,
    2550,   469,  2552,   471,  4091,  2972,  4176,  4177,   575,  3907,
     478,  3819,   357,   478,  2324,   941,   737,   584,   405,   638,
     407,   252,  2592,   848,   950,   478,   494,   311,   552,   494,
     554,  2376,  2377,   257,    18,   750,   853,   496,   863,   866,
     779,   785,   951,  4672,   846,   372,   710,   951,   140,   310,
     318,  2575,   966,  2577,   457,   147,    41,   966,     1,  3098,
     627,   941,   966,  2587,   951,  4359,   532,   951,   624,   625,
     317,   478,   737,   357,   899,   967,   695,  2601,   405,   966,
     407,  3810,   966,   951,   786,  3629,   400,   951,   772,   492,
      40,  3544,   376,  3822,  3823,  3704,   400,   411,   966,   861,
     584,  2625,   966,   486,   866,  4600,  2656,  2657,   722,   951,
    2632,    12,  2147,   661,  4609,   777,  1993,   736,   292,   863,
     866,   738,  4751,  4779,   966,   481,   951,  3032,    71,    72,
      73,    74,   777,    76,   384,   385,   875,   605,  2608,  3349,
     124,   966,   183,  2575,   168,  2577,  3875,  2717,    15,   478,
     967,   419,  2029,   818,  4414,   538,  3959,  3960,   414,   622,
    4414,  2038,   710,  2260,   478,   830,    20,  2264,  2600,  2601,
     438,   152,  3063,   300,   478,  3146,  2608,  4414,   644,   670,
     494,  2264,   884,   245,   846,  2665,   357,  2667,   853,   657,
     494,   296,   657,  2625,  2718,  4426,    21,   600,   400,  4414,
     181,    68,   237,   868,   400,  2775,  4009,   951,   892,   951,
     772,  2308,   462,   463,   470,   158,   159,   198,   199,   950,
     966,  4119,   966,  4660,  4661,  2928,   670,   671,   853,   134,
    2575,   675,  2577,  2665,   853,  2667,   852,   644,   799,   732,
      94,  2338,    45,   687,   688,   367,   862,   892,   692,   154,
     853,  1610,   696,  2350,  2734,   400,  2601,   818,   320,  4429,
    4430,   246,  2732,   707,  2983,   709,   857,   711,   712,   830,
     175,   176,   222,  2797,   835,    15,   478,   772,   722,  2730,
    2625,  2316,   478,   507,   728,  2809,   951,   854,   187,   780,
     781,   858,   494,   860,   523,   524,   679,   962,   494,   301,
    2732,   126,  2734,   528,   529,   789,   567,  4538,   310,   431,
     713,   486,  2395,  2837,   213,   644,   643,   785,  2888,   376,
     785,   526,   431,   554,  2804,   430,  2823,   588,    68,   597,
     892,   744,    18,   478,  4582,  4583,    22,   954,   319,    25,
      26,    15,   786,   657,   575,  4148,   575,   576,   967,   494,
    2385,   478,   523,   657,  4791,   339,  3247,  3248,   642,   184,
     951,   356,   187,   538,   189,  2797,  4592,  2450,   171,   478,
     411,  4808,  2804,  4599,   431,   229,  2411,  4603,   400,  3205,
    4606,   857,  1741,  3274,  3275,  2496,   854,  2498,   213,  2500,
     951,  4024,   885,   237,    68,   863,   391,   892,   863,  4647,
    4648,  2871,   345,   346,   347,   348,   349,   350,   351,   352,
     353,  3302,  4672,  3304,   670,   400,   400,   570,  4672,  2871,
     744,   582,   647,  4226,   585,   356,  2896,   920,   872,   685,
     857,  2466,   845,  4019,   124,  4672,   929,  3324,  2473,  2871,
    2325,  2326,  2327,  2328,  2329,  2330,  2331,  2332,   861,   252,
    3153,   898,  2797,   866,     8,   657,   478,  4672,  2984,   564,
     391,   657,   431,   568,  2896,   909,   507,  2777,  3682,   453,
    3680,   785,   494,   582,  4700,   951,   585,  4703,  4839,   169,
    2390,   785,   307,   951,   931,   888,   951,   950,   951,   933,
    2800,  4751,  3090,   478,   478,   301,   481,  4751,   966,   400,
     215,   966,   845,   357,   310,   672,   487,   890,   201,   494,
     494,   120,   657,  2548,  4751,  2550,  2393,   498,  4779,  2829,
    2830,  2604,   865,    15,   951,  1606,   431,  2404,  2405,  2406,
     657,  4164,  3082,   420,   339,   478,  4751,   861,  1619,   581,
     581,   526,   866,  2420,  2421,  2422,   183,  4860,   745,   863,
    2427,   215,   400,  4765,  3076,  4099,   356,   724,  4806,   464,
    2870,  3264,  3265,   871,   872,  1009,   175,   950,   469,   314,
     471,   476,  2583,   318,   128,   799,    68,   478,  4656,  4892,
     485,  1025,   481,   785,   789,   587,   588,   792,   793,   785,
    4815,   391,  1769,   494,   818,   861,   856,   639,  2475,  2480,
     866,   455,   211,  2635,   731,   852,   830,   867,   858,   267,
     860,   835,  4690,  1057,   861,   862,   225,   273,   865,   866,
     257,  2656,  2657,  4871,   723,   778,  1803,  2504,  2505,  2548,
     478,  2550,   486,   481,  3204,   657,  4861,  4862,   443,   681,
     785,   478,   656,   497,   449,  3536,   494,  3238,  1092,  3554,
     631,    49,   966,   670,  2751,  1099,   481,   882,   785,   676,
     470,   863,   966,   289,   474,   670,  1110,   863,   411,   570,
    2547,   676,   657,   657,   419,   857,  3202,  2554,   526,   622,
     703,  3205,   237,   706,   538,  3182,  4494,   710,   431,  3213,
     670,   672,  1136,   438,    92,  4503,   676,   534,   850,   604,
     537,    99,   645,  4511,   605,  1275,  1276,  1277,   861,   861,
     691,   838,   851,   866,   866,   861,  3286,  2814,   863,  4821,
     866,   917,   861,   327,  4826,  2822,   745,   866,  3619,  3620,
    4817,  1301,  4903,   638,  4905,   931,  4907,  2656,  2657,   799,
     183,  3898,   771,  1187,  1188,  3177,   850,  3179,   411,   951,
     575,   771,  1584,  1197,   579,   951,   657,   861,   339,   565,
      39,   567,   866,   785,   966,    34,    35,   604,  3359,   783,
     966,  1603,  1604,  1605,   470,   356,  3053,  2860,   474,  1730,
    3057,   587,   588,  1734,   621,   405,    18,   407,   466,   467,
     695,  4716,  3759,  3225,   808,   809,   810,   850,    30,   512,
     785,   785,   949,   426,   951,   790,   791,   745,   861,   657,
     391,   951,  1256,   866,   257,  2898,  3783,  2900,   149,  4744,
    4745,   966,   573,   574,   951,  4750,   890,   891,  4753,   893,
     951,   736,  4757,  4758,  3144,   851,   745,   523,   524,   966,
    3811,   863,   926,   478,   928,   861,   700,   357,  1292,   359,
     866,   724,   597,  3285,   565,  4492,   567,  3381,    89,    39,
     714,    41,   478,  2946,  3460,  4502,    98,   478,   449,   876,
     507,  3397,  3342,   698,  2957,  1307,  1308,   778,   951,   863,
     951,  3403,  1283,  1284,   785,   903,   904,   905,   906,   575,
     576,   472,   876,   903,   904,   905,   906,   853,   853,  2996,
     903,   904,   905,   906,   135,  2264,  2907,  2908,  2909,  2910,
    3342,   652,   737,   237,  3224,   953,   758,   777,   127,  3030,
    3031,   136,  3033,  3034,  3035,   951,   849,  3237,   431,   153,
     642,   954,  3635,  2557,  2558,   357,  3841,   785,    18,   585,
     154,   745,  3492,   840,   966,    18,   618,   478,   853,  3381,
    1394,   760,   428,   853,   212,  4541,  3659,    18,   853,   784,
    2995,   786,   863,   478,   230,    15,   122,   951,   848,    30,
     201,    65,   951,   757,  3544,   956,   957,   314,   951,   951,
     377,   966,   966,   636,   865,  2862,   745,   485,   590,     7,
     581,   857,  1436,   818,  1309,  1310,  1311,  1312,  1313,  1314,
    1315,  1316,  1317,  1318,   308,   830,    34,   478,   951,   950,
     512,   258,   853,   865,   507,   367,   865,  2376,  2377,   656,
     865,   259,   865,   317,   417,   865,  4183,   865,   848,   866,
     865,   865,   865,   865,   865,   865,  2395,    98,   886,  3349,
     260,   865,   261,   868,  3524,   950,  3526,  3082,    66,   670,
     951,   263,   723,   176,   830,   830,   383,    92,   264,   950,
      78,  3631,   967,   177,   507,   966,   265,   520,   266,   197,
     918,   919,   288,   837,   865,   270,   848,   271,    97,   951,
     838,   274,  3050,   275,   367,   317,   276,   951,   277,   367,
    3641,  2450,  3524,   166,  3526,   279,   950,   951,  2975,   172,
     173,  2978,   310,  4150,  4151,   511,    45,   125,   637,  3192,
     280,   427,   281,   124,  2991,   188,  4273,   282,   966,  3230,
     283,  3204,  2999,  3000,   219,   284,   951,  4764,   119,   120,
     148,   848,   478,  3230,   278,   931,   865,   962,   745,   690,
     476,   829,   169,   853,   357,  3242,   783,   183,   843,   951,
     848,   848,   951,  4617,   951,  4122,   951,   375,   417,   480,
    4797,   640,   799,   478,   512,   708,   949,   567,   400,   902,
     949,   808,   809,   810,   943,   478,   310,   253,   336,  1623,
     848,   818,  1626,   766,   175,   389,   840,   834,   206,   950,
     845,  3715,   427,   427,  3504,  3505,  3506,  3507,   835,   848,
     431,    97,   219,  3286,   848,   848,  4093,   367,    97,   269,
     367,   285,  3089,   656,   445,  3312,  2575,  4374,  2577,   367,
     211,     4,   427,   745,   367,   427,   367,   459,   460,   695,
    3933,    33,   170,   464,   225,   676,   581,   468,   784,  1683,
     710,  3324,  2601,    89,  3327,   573,   478,    15,  4295,   777,
     151,   965,   443,   573,   799,   964,   317,   443,  3808,   799,
     850,   850,   494,   519,   850,  1709,  2625,   375,   850,  4160,
    4161,   850,   290,   850,  4165,    22,    23,    24,   850,   850,
     848,   710,   848,  3715,    39,   715,   689,   375,   361,   362,
     363,   443,  3375,   375,   595,  3378,   966,  3380,   339,   268,
     373,  4414,   534,   694,    87,  4352,   367,   694,   244,   375,
      18,   411,   853,   581,   951,   710,  3886,   582,   375,    18,
      14,  3356,    30,  3358,   478,   917,   943,   400,  3411,   943,
     799,   710,   256,   926,   736,  3926,  3927,  3861,   376,   400,
     783,   719,   943,   943,  1788,  3456,   364,   943,    39,   943,
     431,   376,   951,   951,   137,   931,   799,   140,   141,   786,
     592,   638,   850,   951,   147,   808,   809,   810,   478,   476,
    3680,   154,   850,   570,   778,   818,   375,   538,  3413,   430,
     568,   128,   257,    27,   840,  3420,    97,   339,   461,   299,
      98,   253,   835,   926,   926,    97,   848,   760,   459,   460,
      15,  1845,  3279,   367,  3415,   478,   694,   638,   563,   482,
     483,   484,  3322,   848,  3449,   622,   592,   478,   491,   220,
     827,   494,   183,  3458,   523,   657,   925,   445,  3461,  3462,
     853,   109,   745,   494,   201,   840,   966,  3318,  2797,   670,
     865,   840,   104,   887,   675,   951,   865,   848,   367,  3532,
      16,    39,   806,   758,   951,   357,   848,  3492,   474,   477,
     123,  3544,   761,  4166,   695,   799,   697,   760,    70,    27,
     698,   486,  4022,   850,  4044,   625,  3573,   367,   375,   230,
     375,    97,   593,  3360,   687,  4188,   687,   357,   357,   595,
    3601,  3602,   272,   586,   694,   443,   486,  3374,   201,  4087,
     543,  2860,   486,   470,   577,  1949,   569,   864,   225,   519,
     641,  1955,   745,   478,   910,  1959,   367,   478,   680,  3829,
    4044,    97,   845,  3556,   478,  3835,  3836,   581,   237,  4120,
     214,   592,   761,   777,   590,   413,   223,  1981,   846,  2898,
      97,  2900,    97,  3640,  4068,  4450,   215,   859,    15,    68,
     538,   298,   638,   785,    97,   538,  3433,  3434,   486,  4672,
     578,  3438,   794,  3440,  3441,  3442,  3443,   564,  4271,   486,
     486,   296,   817,  3450,   638,   762,   856,   853,  3661,   850,
     951,   848,   221,   221,   657,   951,   848,  2946,   479,   585,
     257,   840,   777,   523,    25,   951,   657,   715,  2957,  3476,
     898,   638,   596,   799,   387,   848,   521,  4198,  4158,   317,
     951,   943,   417,   604,  2058,   357,   356,   300,   850,   367,
     852,   221,   853,   614,   615,    14,   857,  3710,  4751,   861,
     862,   863,  4205,   865,   866,   519,   654,   384,   385,   712,
     658,   642,   212,   663,   414,   586,    43,   503,   611,   567,
     696,   789,   722,  3688,   497,  2099,   883,   840,   441,   367,
     777,  3758,   522,  4187,   817,   585,   848,    25,   523,   443,
     453,   443,   638,   223,   853,   853,   857,   459,   853,  3556,
     857,   464,   244,   816,  3695,   214,   580,   470,   581,   443,
     443,   474,   400,   476,   459,   926,   183,   443,   443,   459,
     830,   943,   485,   248,   695,   592,   123,  3584,   376,   134,
     376,   391,   785,  4283,   415,   462,   463,  4027,   533,   604,
     803,   739,  4286,   604,   785,   592,   717,   718,   604,  3840,
      18,  3051,    56,  2512,   966,   185,   967,    14,   811,   812,
    3650,   339,    92,  1248,  1823,   298,  3757,   217,  3047,  2508,
     304,   459,   460,   536,    99,  3766,   336,   801,   168,  1224,
     529,  3772,   311,  4333,  3799,   219,  3777,  3778,  4301,  2486,
     478,   529,  4145,  3808,  3785,  4538,  3787,  3439,  4124,  4238,
     517,  3447,   800,  3035,   531,  4376,   494,   829,  3467,   850,
     863,   852,    46,  4228,  3968,  4342,  4397,   580,  4408,  3432,
     861,   862,   863,  3900,   865,   866,   752,  2262,   881,  4359,
    3327,  4381,  2256,  2257,  2258,  2427,  1758,  4874,  4751,   566,
    2442,  2442,  4219,  4103,  2268,  2143,  4292,  4751,   575,  3375,
    3378,  2860,  2510,  3380,   617,   908,  4655,   584,  4716,  4363,
    4751,  2902,  4820,   916,  4825,   628,  4208,  4616,  4349,   697,
    4536,  1601,  4495,  4495,  4661,   638,  4502,  4532,  1825,  3798,
    2518,  3477,   880,  3631,   259,  4013,  1255,  1261,  3090,  1043,
    3081,   944,  2316,  1864,  3907,  1965,  2606,  1267,   951,   909,
     627,  4164,  3499,  3629,   592,  4163,  1332,   921,   682,  3924,
    3767,  1363,   967,   966,  1390,  2018,  2045,  3532,  3146,  2343,
    2344,   979,   697,  1397,  2633,   966,  2676,  3181,  1005,  3786,
    3993,  1400,   695,  3532,  2103,  3195,  3197,  1442,  1037,     7,
    2139,  4018,  3213,  3800,   942,  4036,  2715,  4060,  3549,  3895,
    1052,  2264,  3236,  3548,  3969,  1727,  1061,  2300,  1017,  2751,
      18,  3242,  3573,  3251,  3250,  2814,  1734,  1729,  2827,   657,
    1670,  2333,    30,   736,  1090,  1092,  2400,  2830,  1702,  2350,
     712,  3287,  3839,  4333,  3975,  3324,  2350,  4195,  3327,  2311,
    3900,  2299,  4319,  4497,  4366,  3634,  4057,  4439,    66,  1745,
    4371,  2528,  4017,  2526,   692,  2596,  1374,  4022,   771,  1375,
      78,  2597,  3292,  3278,  4005,  3277,  3867,  3624,  3623,  2631,
     783,  3293,  2630,   916,   711,  1422,  3680,  2793,  2793,  2793,
    4093,  2793,   722,  3415,  2103,  1136,  3375,  1326,  2964,  3378,
      98,  3380,  3381,   313,  3886,  2319,  4497,  3861,  2472,  3906,
    4223,  2503,   815,  1329,   821,  4548,   875,   125,   804,  3916,
    1759,  4235,  2335,  2954,  2622,  3284,  4143,  4144,  4145,  3611,
       7,  4482,  3411,  3930,  4087,  1184,  4751,  3162,  4079,  2463,
     148,  3199,  3809,  4683,  4126,  4797,   845,  4770,  4853,   330,
     853,  4106,  3227,   344,  2372,  3422,  2037,   785,  4683,  3372,
    4423,  2497,  1767,  4812,  3784,    -1,  4097,  4098,    -1,    -1,
    2534,  2535,  1265,   876,    -1,    -1,  2540,  2541,  2542,  2543,
     883,    -1,  4185,    -1,  2548,    -1,  2550,   854,  2552,    66,
      -1,   858,    -1,   860,  4687,    -1,    -1,    -1,   206,    -1,
      -1,    78,    -1,  4158,    -1,    -1,   909,    -1,    -1,  4717,
    4007,    -1,  4229,  4010,  4011,    -1,    -1,    -1,  4235,  2583,
      -1,    -1,   850,   926,   852,   928,    -1,  4669,   931,    -1,
      -1,    -1,    -1,   861,   862,   863,  2600,   865,   866,    -1,
    4037,  4038,  4039,  4751,  2608,    -1,  4277,  4689,   125,    -1,
      -1,    18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4059,    30,   967,    -1,    -1,  4064,    -1,    18,
      -1,   148,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2645,   290,    -1,  2648,    -1,    -1,    -1,    -1,    -1,
      -1,  2655,  2656,  2657,  2658,    -1,  4227,    -1,    -1,   966,
    4331,  2665,    -1,  2667,    -1,    -1,  4237,  4238,    -1,    18,
      -1,  4264,  4265,    -1,    -1,    -1,    -1,    -1,    -1,   317,
      -1,    30,  4152,  2687,    -1,  4771,    -1,    -1,    -1,   206,
      -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,   966,    -1,
    4137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,
      -1,    -1,  4365,    -1,    -1,  4876,  4810,  4811,  2732,    -1,
    2734,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,
      -1,    -1,  3661,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,    -1,    -1,  4840,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,  4426,
      -1,    -1,    -1,   290,    -1,    -1,    43,   166,    -1,    -1,
      -1,  4218,    -1,   172,   173,    -1,  4357,    -1,    -1,    -1,
      -1,  3710,    -1,    -1,    -1,    -1,  3715,   445,    -1,   188,
    2804,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2816,    -1,    -1,    -1,    -1,    -1,  4810,  4811,
    4415,   459,   460,    -1,    91,  4482,    93,    -1,    -1,   477,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,    -1,
     478,    -1,    -1,    -1,    -1,    -1,    -1,   364,  4840,   116,
      -1,    -1,    -1,    -1,  4497,    -1,   494,    -1,    -1,  4454,
      -1,    -1,    -1,    -1,    -1,    -1,  4303,  2871,    -1,    -1,
     137,    -1,    -1,    -1,   141,  4312,    -1,    -1,    -1,    -1,
    4317,  4538,    -1,  4554,  4321,  4618,    -1,    -1,    -1,    -1,
      -1,    -1,  2896,    -1,    -1,    -1,    -1,    -1,   486,  4336,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     317,  4506,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4361,  4362,    -1,    -1,   445,    -1,
     578,  4368,    -1,    -1,    -1,   452,    -1,    -1,    -1,    -1,
      -1,    -1,  3861,    -1,    -1,    -1,  4383,    -1,    -1,  4386,
    4387,  4388,  4389,    -1,   592,    -1,    -1,    -1,    -1,    -1,
     477,   105,   106,   107,    -1,    -1,    -1,    -1,   317,    -1,
      -1,    -1,   361,   362,   363,    -1,    -1,  4414,    -1,    -1,
      -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,   505,    -1,
      -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4600,   654,    -1,    -1,    -1,
     658,   400,    -1,    -1,  4609,    -1,    -1,    -1,    -1,   657,
      -1,    -1,    -1,  4460,  4461,  4462,  4463,  4464,    -1,    -1,
    4467,  4468,  4469,  4470,  4471,  4472,  4473,  4474,  4475,  4476,
    4477,    -1,    -1,  4480,    -1,  4482,    -1,  4484,    -1,    -1,
      -1,   400,   459,   460,  4649,    -1,  4493,    -1,    -1,  4496,
      -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,
      -1,   478,   461,    -1,    -1,    -1,    -1,    -1,  3082,    -1,
     668,  4518,   670,   227,   228,   673,   230,   494,    -1,   478,
     678,   739,   680,   482,   483,   484,   684,    36,    37,    -1,
      -1,    -1,   491,    -1,    -1,   494,   694,    -1,    -1,   697,
     459,   460,    -1,    -1,    -1,    -1,   704,    -1,    -1,    -1,
      -1,  4716,   389,    -1,    -1,    -1,    -1,    -1,    -1,   478,
     718,    -1,   720,   721,    -1,    -1,  4779,   654,    -1,    -1,
      -1,   658,    -1,    -1,    -1,   494,   734,   785,    -1,  4744,
    4745,    -1,   800,    -1,    -1,  4750,    -1,  3161,  4753,  4596,
      -1,  4598,  4757,  4758,    -1,    -1,    -1,    -1,    -1,    -1,
    4813,  4608,  4767,  3177,  4093,  3179,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3188,   592,    -1,    -1,   577,   456,
      -1,    -1,    -1,    -1,    -1,    -1,  4791,    -1,    -1,    -1,
      -1,   140,    -1,   470,    -1,    -1,    -1,   474,   147,    -1,
      -1,   150,   850,  4808,   852,  4652,    -1,    -1,    -1,    -1,
      -1,  3225,   739,   861,   862,   863,  4821,   865,   866,    -1,
    4825,  4826,   880,    -1,    -1,  4672,    -1,    -1,    -1,    -1,
      -1,  4836,    -1,   592,    -1,    -1,    -1,    -1,    -1,    -1,
     657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   851,    -1,   204,    -1,    -1,   657,    -1,
     209,   210,    -1,    -1,    -1,   419,   420,    -1,    -1,    -1,
      -1,  3285,    -1,   800,    -1,   692,    -1,    -1,  4725,  4726,
      -1,  4728,    -1,    -1,   942,    -1,    -1,   814,    -1,    -1,
     444,    -1,   890,   891,   892,   893,  4743,    -1,   657,    -1,
      -1,  4748,  4749,    -1,    -1,    -1,  4911,    -1,    -1,    -1,
     670,   838,    -1,   712,  3328,   675,   470,    -1,   966,  4766,
      -1,    -1,  4769,   921,  4771,    -1,    -1,   687,  3342,    -1,
      -1,    -1,   692,   692,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   495,    -1,   292,    -1,   294,   623,   624,   625,    -1,
     948,   711,   301,   880,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,    -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3415,    -1,   930,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   811,   812,    -1,   942,    -1,  3431,  3432,  1017,
      -1,    -1,   949,    -1,   951,    -1,   785,    -1,    -1,    -1,
      -1,    -1,  1030,   850,  3448,   852,    -1,    -1,    -1,  1037,
      -1,  3455,   719,   597,   861,   862,   863,    -1,   865,   866,
      -1,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,  1057,
      -1,    -1,    -1,    -1,   863,    -1,    -1,    -1,    -1,    -1,
     419,    -1,    -1,    -1,    -1,    -1,   630,   876,  3492,    -1,
     634,   635,   881,    -1,  1082,    -1,    -1,    -1,   765,    -1,
      -1,   850,    -1,   852,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   861,   862,   863,    -1,   865,   866,   662,   908,
    3524,  1109,  3526,    -1,    -1,    -1,    -1,   916,    -1,    -1,
      -1,   470,   882,    -1,    -1,   474,    -1,    -1,    -1,  1127,
     890,   891,   892,   893,    98,    -1,  1134,  1135,    -1,    -1,
      -1,   901,    -1,  3557,  1142,   944,    -1,  1145,  1146,   966,
      -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,    -1,   508,
      -1,    -1,   511,    -1,    -1,    -1,    -1,   966,    -1,   846,
      -1,    -1,    -1,   933,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   868,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,    -1,   966,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,  3641,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1009,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1025,    -1,    -1,    -1,    -1,
    1268,  1269,    -1,   950,    -1,   829,    -1,  1275,  1276,  1277,
      -1,  3695,    -1,    -1,  1282,  1283,  1284,  1285,    -1,    -1,
    1288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1298,    -1,  1300,  1301,    -1,    -1,    -1,    -1,    -1,  1307,
    1308,  1309,  1310,  1311,  1312,  1313,  1314,  1315,  1316,  1317,
    1318,    -1,  1082,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1329,  1092,  1331,    -1,    -1,    -1,    -1,    -1,  1099,
      -1,    -1,    -1,  3757,    -1,    -1,  1344,    -1,    -1,    -1,
      -1,  1349,  3766,    -1,    -1,    -1,    -1,    -1,  3772,    -1,
      -1,  3775,    -1,  3777,  3778,    -1,    -1,    -1,    -1,    -1,
      -1,  3785,    -1,  3787,    -1,  3789,    -1,    -1,    -1,    -1,
      -1,    -1,  1142,    -1,    -1,  1383,    -1,   736,    -1,    -1,
      -1,    -1,    -1,    -1,  3808,   359,    -1,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,
    3824,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   821,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4810,  4811,   832,  4813,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   843,   459,   460,   461,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4840,    -1,    -1,   478,  1275,  1276,  1277,   482,   483,
     484,    -1,  1282,  1283,  1284,  1285,    -1,   491,  1288,    -1,
     494,    -1,  1292,    -1,    -1,    -1,    -1,    -1,  1298,    -1,
    1300,  1301,    -1,    -1,    -1,  3959,  3960,  1307,  1308,  1309,
    1310,  1311,  1312,  1313,  1314,  1315,  1316,  1317,  1318,    -1,
      -1,  3975,    -1,    -1,    -1,   914,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     7,  3993,
      -1,    -1,    -1,    -1,  1344,    -1,    -1,    -1,    -1,  1349,
      -1,  4005,    -1,    -1,    -1,  4009,    -1,    -1,    -1,    -1,
      -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,  4022,    -1,
      -1,    -1,  1610,   577,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4035,    12,  1383,    -1,    -1,    -1,    -1,    18,    -1,
      -1,    -1,    -1,    -1,  1394,    -1,    -1,    66,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,  4072,    -1,
      -1,    -1,    69,  1661,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1672,    -1,    -1,    -1,    -1,    -1,
      87,    88,    -1,  4097,  4098,    -1,    -1,    -1,    -1,    -1,
       0,     1,    -1,   657,    -1,     5,   125,    -1,    -1,  4113,
      -1,    11,    -1,  1701,    -1,    -1,    -1,    97,    -1,    19,
      -1,  4125,    -1,    -1,    -1,    -1,    -1,  4131,    28,   148,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,  4148,  1733,    -1,    -1,    61,    62,
      63,    64,    -1,  1741,  4158,    -1,    69,    -1,   712,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4175,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,    -1,   166,   206,    -1,    -1,
      -1,   171,   172,   173,    -1,    43,    -1,    -1,    -1,    -1,
      -1,   101,   102,    -1,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,    -1,    61,    62,    63,    64,    -1,    -1,  4223,
      -1,    69,  4226,  4227,    -1,   138,    -1,    -1,    -1,    -1,
      -1,   785,   132,  4237,  4238,    -1,    -1,    -1,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   152,    -1,    -1,    -1,   156,   811,   812,    -1,
    1610,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,    -1,
      -1,   290,    -1,  1623,   174,    -1,  1626,    -1,    -1,    -1,
     834,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,    -1,    -1,   141,    -1,    61,    62,    63,    64,    -1,
      -1,  1889,   299,    69,    -1,    -1,    -1,    -1,    -1,   863,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1905,   218,    -1,
      -1,    87,    88,    -1,   224,    -1,   226,   881,    -1,   177,
     230,    -1,    -1,  1683,   234,    -1,   355,    -1,  1926,    -1,
      -1,    -1,    -1,    -1,   898,   364,    -1,    -1,  1936,    -1,
      -1,   251,    -1,  4357,   908,  4359,    -1,    -1,    -1,  1709,
      -1,   358,   916,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,    -1,    -1,   931,    -1,    -1,
      -1,   361,   362,   363,    -1,    -1,   299,    -1,   288,    -1,
     944,  1741,    -1,   373,    -1,    -1,   950,   951,    -1,    -1,
      -1,   398,    -1,    -1,   304,    -1,    -1,    -1,    -1,   309,
      -1,   177,   966,    -1,    -1,   315,   316,    -1,    -1,    -1,
     400,    -1,    -1,    -1,    -1,    -1,   445,    -1,    -1,    -1,
      -1,    -1,    -1,   452,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,    -1,    -1,
      -1,   299,    -1,    -1,    -1,    -1,    -1,  2045,   477,    -1,
      -1,  2049,    -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   374,    -1,    -1,   377,    -1,   459,
     460,   461,   382,    -1,    -1,   398,   505,    -1,    -1,   469,
      -1,   471,    -1,    -1,    -1,   492,    -1,    -1,   478,    -1,
      -1,    -1,   482,   483,   484,    -1,    -1,    -1,   408,    -1,
     358,   491,    -1,    -1,   494,    -1,   416,    -1,   418,    -1,
      -1,   421,    -1,    -1,   424,    -1,    -1,    -1,    -1,    -1,
      -1,   511,    -1,   299,    -1,    -1,    -1,    -1,  2126,    -1,
     440,  2129,   539,  2131,  2132,  2133,    -1,    -1,    -1,    -1,
     398,    -1,    -1,    -1,    -1,  1905,    -1,    -1,    -1,  2147,
      -1,    -1,   581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,
      -1,    -1,    -1,    -1,    -1,    -1,  1936,    -1,  4592,    -1,
      -1,    -1,   358,    -1,    -1,  4599,    -1,   577,    -1,  4603,
      -1,    -1,  4606,   600,   584,  1955,   506,    -1,    -1,  1959,
      -1,    -1,    -1,   513,    -1,   515,    -1,    -1,   518,    -1,
      -1,    -1,   470,    -1,    -1,   605,    -1,    -1,    -1,    -1,
      -1,    -1,   398,    -1,   534,   654,    -1,    -1,    -1,   658,
      -1,    -1,    -1,    -1,   492,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   512,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2264,   657,    -1,  2267,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   600,    -1,   589,
      -1,   539,    -1,    -1,    -1,  2045,  4700,    -1,    -1,  4703,
     680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2058,    -1,
      -1,    -1,   612,  2301,   711,    -1,   713,   714,  2306,    -1,
     739,    -1,    -1,    -1,  2312,  2313,   492,    -1,    -1,    -1,
      -1,    -1,   712,    -1,    -1,    -1,   733,    -1,    -1,    -1,
      -1,   738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   600,   653,  2342,    -1,    -1,    -1,    -1,   659,
      -1,  2349,  2350,    -1,   664,    -1,    -1,   667,   668,    -1,
      -1,  2359,   538,  2361,    -1,    -1,   624,   625,    -1,    -1,
     777,   800,    -1,    -1,    -1,  2135,   686,    -1,  2376,  2377,
      -1,    -1,   789,  2381,    -1,   814,    -1,   777,   711,    -1,
     713,   714,    -1,    -1,   704,   785,    -1,    -1,    -1,   709,
      -1,    -1,    -1,    -1,    -1,    -1,   716,    -1,    -1,   838,
     733,    -1,   722,    -1,    -1,   738,    -1,    -1,    -1,    -1,
      -1,   811,   812,    -1,   600,    -1,    -1,    -1,    -1,    -1,
      -1,   741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,
      -1,   880,   762,   711,   777,   713,   714,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,
     780,    -1,    -1,   863,    -1,   733,    -1,    -1,    -1,    -1,
     738,   888,    -1,    -1,   794,    -1,    -1,    -1,    -1,    -1,
      -1,   881,    -1,    -1,   804,   805,  2256,  2257,  2258,    -1,
      -1,   930,   892,   813,    -1,    -1,   816,    -1,    -1,    -1,
      -1,    -1,    -1,   942,    -1,    -1,    -1,    -1,   908,   777,
     949,   831,   951,    -1,    -1,    -1,   916,    -1,    -1,  2527,
      -1,   789,    -1,    -1,    -1,   711,   926,   713,   714,    -1,
      -1,    -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2313,   944,    -1,    -1,   733,  2556,    -1,
      -1,   951,   738,    -1,    -1,   888,    -1,     1,   878,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   966,  2575,    -1,  2577,
      -1,   891,    -1,    -1,  2344,    -1,  2346,   897,    -1,  2587,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,     4,
      -1,   777,    -1,  2601,    -1,    -1,  2604,    -1,    -1,    -1,
      -1,    -1,   922,   789,    -1,    -1,  2376,  2377,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2625,    -1,    -1,
     888,    -1,    -1,    -1,  2632,    -1,    70,    71,    72,    73,
      74,    -1,    76,    77,   902,   955,    -1,    -1,    -1,    -1,
     960,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   968,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   950,    -1,  2692,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   888,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2718,   155,    -1,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   137,    -1,    -1,   140,   141,    -1,    -1,    -1,
    2738,    -1,   147,    -1,    -1,    -1,    -1,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,   162,   163,   164,
     165,    -1,    -1,    -1,  2762,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2790,    -1,    -1,    -1,   230,    -1,    -1,  2797,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2809,    -1,    -1,    -1,  2575,    -1,  2577,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   230,    -1,  2587,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2837,
    2600,  2601,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2625,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2665,    -1,  2667,    -1,    -1,
      -1,   345,   346,   347,   348,   349,    -1,   351,   352,   353,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   336,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     345,   346,   347,   348,   349,    -1,   351,   352,   353,    -1,
      -1,    -1,    -1,    -1,    -1,   389,    -1,  2717,  2718,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2732,    -1,  2734,    -1,    -1,    -1,    -1,   413,
      -1,    -1,   387,    -1,   389,    -1,    -1,    -1,    -1,    -1,
       0,     1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,   413,    19,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,   441,  2797,    -1,    -1,
      -1,    -1,    -1,    -1,  2804,    -1,    -1,    -1,   453,  2809,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   464,
      -1,    -1,    -1,    -1,    -1,   470,    -1,    -1,    -1,   474,
      -1,   476,    -1,    -1,    -1,    -1,    -1,  2837,  3076,    -1,
     485,    -1,    -1,  3081,    -1,    -1,    -1,    -1,    -1,   523,
      -1,   101,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2871,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,    -1,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,    -1,    -1,  2896,    -1,    -1,    -1,
      -1,    -1,   152,    -1,   578,    -1,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   174,    -1,    -1,   601,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   622,    -1,
      -1,   201,    -1,    -1,  3192,    -1,   601,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3205,   218,    -1,
      -1,   645,   617,    -1,   224,  3213,   226,   622,    -1,    -1,
     230,    -1,    -1,   628,   234,    12,    -1,    -1,    -1,    -1,
      -1,    18,    -1,   638,    -1,    -1,    -1,    -1,  3236,    -1,
     645,   251,    -1,   253,    -1,    -1,    -1,   257,   258,   259,
     260,   261,    -1,   263,   264,   265,   266,    -1,   268,   269,
      -1,   271,   272,    -1,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,    -1,    -1,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,
     695,   301,    -1,    -1,   304,    -1,    18,    -1,    -1,   309,
     310,    -1,    -1,    -1,    -1,   315,   316,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   736,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   773,
     774,   775,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   374,    -1,   771,   377,   773,   774,
     775,    -1,   382,    -1,    -1,    -1,    98,    -1,   783,   166,
      -1,    -1,    -1,  3381,    -1,   172,   173,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,
      -1,   188,    -1,    -1,    -1,  3403,   416,    -1,   418,    -1,
     815,   421,    -1,    -1,   424,    -1,    -1,  3177,    -1,  3179,
     430,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   166,  3205,    -1,    -1,   853,    -1,
     172,   173,    -1,  3213,    -1,    -1,    -1,    -1,    -1,   893,
     894,   895,    -1,    -1,     6,  3225,   188,    -1,    10,    -1,
      -1,   876,    -1,    -1,    -1,    -1,    -1,    -1,   883,    -1,
      -1,    -1,    -1,    -1,   918,    -1,    -1,    29,   893,   894,
     895,    -1,    -1,    -1,    -1,    -1,   506,    -1,    -1,    -1,
      42,    -1,    -1,   513,   909,   515,    -1,    -1,   518,    -1,
      -1,    -1,   299,   918,    -1,  3513,    -1,   951,    -1,    -1,
      -1,   926,    -1,   928,   534,  3285,   931,    -1,    -1,    -1,
      -1,    -1,    -1,   543,  3532,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   951,    -1,    -1,    -1,
      -1,    -1,    -1,   563,   564,   565,    -1,   567,   568,   569,
     570,    -1,   967,    -1,    -1,    -1,    -1,   354,    -1,    -1,
      -1,    -1,    -1,    -1,   361,   362,   363,   587,   588,   589,
      -1,    -1,  3342,    -1,    -1,    -1,   373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   612,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3609,    -1,   400,    -1,    -1,    -1,  3615,    -1,  3617,
      -1,  3381,    -1,    -1,    -1,   412,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3633,    -1,   359,    -1,   361,
     362,   363,    -1,   653,    -1,    -1,    -1,    -1,    -1,   659,
      -1,   373,    -1,    -1,   664,    -1,    -1,   667,   668,   201,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   459,   460,   461,    -1,   686,    -1,   400,    -1,
      -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,
      -1,   478,    -1,    -1,   704,   482,   483,   484,    -1,   709,
      -1,    -1,    -1,    -1,   491,    -1,   716,   494,    -1,    -1,
      -1,    -1,   722,   255,    -1,    -1,    -1,  3715,    -1,    -1,
     507,    -1,    -1,    -1,   511,    -1,    -1,    -1,    -1,    -1,
      -1,   741,    -1,    -1,    -1,    -1,    -1,   459,   460,   461,
      -1,    -1,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,
      -1,    -1,   762,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,   483,   484,    -1,  3524,    -1,  3526,    -1,   778,   491,
     780,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   794,    -1,    -1,   329,   330,    -1,
     577,    -1,    -1,    -1,   804,   805,    -1,   584,    -1,    -1,
      -1,    -1,    -1,   813,    -1,    -1,   816,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   605,    -1,
    3818,   831,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   864,   577,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3861,    -1,    -1,  3864,    -1,   878,    -1,
     657,    -1,   414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   891,    -1,    -1,    -1,    -1,    -1,   897,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   439,  3896,  3897,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   922,    -1,    -1,    -1,    -1,    -1,    -1,  3917,
      -1,    -1,    -1,    -1,    -1,   712,    -1,    -1,   470,    -1,
      -1,    -1,    -1,   943,    -1,   657,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   486,   955,    -1,    -1,    -1,    -1,
     960,    -1,    -1,    -1,    -1,  3715,    -1,    -1,   968,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,
     712,   172,   173,    -1,    -1,    -1,    -1,    -1,   785,    -1,
      -1,    -1,   789,    -1,    -1,    -1,    -1,   188,    -1,    -1,
     552,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   811,   812,    -1,   814,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   594,    -1,    -1,    -1,    -1,    -1,    -1,  4057,
     602,    -1,  4060,   785,    -1,    -1,    -1,    -1,    -1,    -1,
    4068,    -1,   859,    -1,    -1,    -1,   863,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   811,
     812,    -1,    -1,    -1,   881,    -1,   638,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   288,    -1,    -1,
      -1,    -1,   834,    -1,    -1,    -1,    -1,    -1,    -1,     0,
       1,   908,    -1,    -1,     5,    -1,    -1,    -1,   670,   916,
      11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,
      -1,   863,    -1,   685,    -1,    -1,    -1,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   944,    -1,   881,
     702,    -1,   949,   950,   951,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4172,    -1,   898,    -1,    -1,   966,
     361,   362,   363,    -1,    -1,    -1,   908,    -1,    -1,  4187,
      -1,    -1,   373,    -1,   916,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   750,   931,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   760,   400,
     101,   102,   944,    -1,   766,    -1,    -1,    -1,   950,   951,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   780,    -1,
      -1,    -1,    -1,    -1,   966,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,    -1,    -1,    -1,   799,    -1,    -1,
      -1,    -1,    -1,  4261,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   152,  4270,    -1,    -1,   156,  4274,    -1,   459,   460,
     461,    -1,    -1,    -1,  4044,    -1,    -1,    -1,   469,    -1,
     471,    -1,    -1,   174,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,   483,   484,    -1,    -1,    -1,    -1,  4068,    -1,
     491,   853,    -1,   494,    -1,   857,    -1,    -1,    -1,    -1,
      -1,  4319,    -1,    -1,  4322,  4323,    -1,    -1,    -1,    -1,
     511,   873,   874,    -1,    -1,    -1,    -1,   218,    -1,    -1,
      -1,    -1,    -1,   224,    -1,   226,  4344,  4345,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4363,    -1,    -1,  4366,    -1,
     251,    -1,    -1,  4371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4385,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,    -1,
      -1,    -1,  4400,    -1,    -1,    -1,    -1,   288,    -1,    -1,
      -1,    -1,    -1,  4411,    -1,    -1,    -1,  4415,    -1,    -1,
      -1,    -1,    -1,   304,   605,    -1,    -1,  4187,   309,    -1,
      -1,    -1,    -1,    -1,   315,   316,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4453,    -1,    -1,  4456,  4457,
    4458,  4459,    -1,    -1,    -1,    -1,    -1,    -1,  4466,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   657,    -1,    -1,    -1,
      -1,  4479,    -1,    -1,    -1,   366,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   374,    -1,    -1,   377,    -1,    -1,  4497,
      -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,  4514,    -1,    -1,  4517,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,
     188,   712,    -1,    -1,    -1,   416,    -1,   418,    -1,    -1,
     421,    -1,    -1,   424,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   440,
      -1,    -1,    -1,  4561,  4562,  4563,  4564,  4565,  4566,  4567,
    4568,  4569,  4570,  4571,  4572,  4573,  4574,  4575,  4576,  4577,
    4578,  4579,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4591,    -1,    -1,   777,    -1,    -1,    -1,
      -1,    -1,  4600,  4363,   785,    -1,    -1,    -1,    -1,    -1,
      -1,  4609,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   506,    -1,    -1,    -1,    -1,
     811,   812,   513,  4631,   515,    -1,    -1,   518,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4643,    -1,    -1,    48,    -1,
      -1,  4649,    -1,   534,    -1,    -1,    -1,  4655,  4656,    -1,
      -1,    61,    62,    63,    64,    -1,    -1,    -1,    -1,    69,
      -1,  4669,    -1,    -1,    -1,   856,    -1,    -1,  4676,  4677,
      -1,    -1,   863,    -1,    -1,    -1,   867,    -1,    88,    -1,
      -1,  4689,  4690,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     881,    -1,    -1,   361,   362,   363,    -1,    -1,   589,    -1,
      -1,  4709,    -1,    -1,    -1,   373,    -1,    -1,  4716,    -1,
      -1,    -1,    -1,    -1,    -1,  4723,    -1,   908,    -1,    -1,
      -1,   612,    -1,    -1,    -1,   916,    -1,    -1,   138,    -1,
      -1,    -1,  4740,    -1,    -1,    -1,  4744,  4745,    -1,    -1,
      -1,    -1,  4750,    -1,  4752,  4753,    -1,    -1,    -1,  4757,
    4758,    -1,    -1,   944,    -1,    -1,  4526,    -1,    -1,    -1,
     951,    -1,   653,    -1,    -1,   175,    -1,   177,   659,    -1,
       1,    -1,    -1,   664,    -1,   966,   667,   668,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4798,   459,   460,   461,    -1,   686,    -1,    -1,    -1,    -1,
      31,    -1,  4810,  4811,    -1,   215,    -1,    -1,    -1,    -1,
     478,    -1,    -1,   704,   482,   483,   484,    -1,   709,    -1,
      -1,    -1,    -1,   491,    -1,   716,    -1,    -1,    -1,    -1,
      -1,   722,  4840,    -1,    -1,    -1,    67,    -1,    -1,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    -1,    -1,
     741,  4859,  4860,    -1,    -1,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,  4877,
      -1,   762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4887,
    4888,    -1,    -1,    -1,  4892,    -1,    -1,    -1,    -1,   780,
      -1,  4899,    -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   794,    -1,    -1,    -1,    -1,    -1,   577,
      -1,    -1,    -1,   804,   805,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   813,   154,   155,   816,   157,   158,   159,   160,
     161,   162,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
     831,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   369,
      -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   215,    -1,    -1,   878,   398,    -1,
      -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,   230,
     891,    12,    -1,    -1,    -1,    -1,   897,    18,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   922,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4810,  4811,    -1,    -1,   712,    -1,    -1,   457,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   955,    -1,    -1,    -1,    -1,   960,
    4840,    -1,    -1,    -1,    -1,    -1,    -1,   968,    -1,   489,
      -1,    -1,   492,    -1,    -1,    -1,    -1,    -1,    -1,   320,
     321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   336,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   345,   346,   347,   348,   349,    -1,
     351,   352,   353,    -1,    -1,    -1,    -1,    -1,   538,   360,
      -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   811,   812,   376,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,   389,    -1,
      -1,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   582,    -1,    -1,   406,    -1,   188,    -1,    -1,
      -1,    -1,   413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     600,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   429,    -1,
     431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     441,    -1,    -1,   881,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   464,   465,    -1,    -1,    -1,   648,    -1,
     908,   651,    -1,    -1,    -1,   476,    -1,    -1,   916,    -1,
      -1,    -1,    -1,    -1,   485,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,    -1,    -1,    -1,     7,   944,    -1,    -1,    -1,
      -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,   699,
      -1,    -1,   523,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   711,    -1,   713,   714,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    -1,    -1,    -1,
      -1,    -1,    -1,   733,    -1,    -1,    -1,    -1,   738,    61,
      62,    63,    64,    -1,    66,    -1,   746,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    78,    -1,    -1,   580,
     361,   362,   363,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,   373,    -1,    -1,    -1,    -1,   777,    -1,    -1,
     601,    -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,   789,
      -1,    -1,    -1,    -1,    -1,    -1,   617,    -1,    -1,   400,
      -1,   622,    -1,   125,    -1,    -1,    -1,   628,   130,    -1,
      -1,    -1,    -1,    -1,    -1,   137,   138,   638,    -1,   141,
      -1,    -1,    -1,   823,   645,    -1,   148,    -1,    -1,    -1,
      -1,    -1,    -1,   155,    -1,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   844,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   678,   459,   460,
     461,    -1,    -1,    -1,   186,    -1,    -1,    -1,   469,    -1,
     471,    -1,    -1,    -1,   695,    -1,    -1,   478,    -1,    -1,
      -1,   482,   483,   484,   206,    -1,    -1,    -1,   888,    -1,
     491,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,
     900,    -1,    -1,    -1,    -1,    -1,    -1,   907,   230,    -1,
     511,    -1,   733,    -1,    -1,   736,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   750,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     771,    -1,   773,   774,   775,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   786,    -1,    -1,   290,    -1,
      -1,    -1,   166,    -1,    -1,    -1,   577,   299,   172,   173,
      -1,    -1,    -1,   584,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,   819,    -1,
      -1,    -1,    -1,    -1,   605,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   336,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   345,   346,   347,   348,   349,    -1,   351,
     352,   353,   853,    -1,    -1,    -1,   358,    -1,    -1,    -1,
      -1,    -1,   364,    -1,    -1,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,   376,   876,   657,    -1,    -1,    -1,
      -1,    -1,   883,   884,   386,    -1,    -1,   389,    -1,    -1,
      -1,    -1,   893,   894,   895,    -1,   398,    -1,   400,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   909,    -1,
      -1,   413,    -1,    -1,    -1,    -1,    -1,   918,    -1,    -1,
      -1,    -1,    -1,   924,    -1,   926,    -1,   928,    -1,   431,
     931,   712,    -1,    -1,   935,    -1,    -1,    -1,    -1,   441,
      -1,    -1,    -1,   445,    -1,    -1,    -1,    -1,    -1,    -1,
     951,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   967,    -1,   470,    -1,
      -1,    -1,   474,    -1,    -1,   477,   478,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
     492,    -1,   494,    -1,    -1,    -1,   777,    -1,    -1,   373,
      -1,    -1,    -1,    -1,   785,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,
     811,   812,    22,    23,    24,    -1,   538,    -1,    -1,    -1,
      30,    31,    -1,   545,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      60,    -1,    -1,    -1,    -1,    -1,   578,    -1,   580,    -1,
     582,    -1,   863,    -1,    -1,    -1,    -1,   461,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   600,   601,
     881,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,   483,
     484,   892,    -1,    -1,    -1,   617,    -1,   491,    -1,    -1,
     622,    -1,   624,   625,    -1,    -1,    -1,   908,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   916,    -1,    -1,   128,    -1,
      -1,    -1,    -1,   645,    -1,    -1,   648,    -1,    -1,    -1,
      -1,    -1,   654,    -1,    -1,   657,   658,    -1,    -1,    -1,
      -1,    -1,    -1,   944,    -1,    -1,    -1,    -1,    -1,    -1,
     951,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
      -1,    -1,   172,   173,    -1,   966,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   699,   188,    -1,
      -1,    -1,    -1,   577,    -1,    -1,    -1,    -1,    -1,   711,
      -1,   713,   714,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   739,    -1,    -1,
      -1,    -1,    -1,    -1,   746,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   771,
      -1,   773,   774,   775,    -1,   777,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   785,    -1,    -1,    -1,   789,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   800,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   298,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   823,    -1,    -1,    -1,    -1,    -1,   317,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   712,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,    -1,    -1,
      -1,   853,    -1,    -1,    -1,    -1,    -1,   859,    -1,    -1,
      -1,   863,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   361,   362,   363,   876,    -1,    -1,    -1,   880,    -1,
      -1,    -1,    -1,   373,    -1,    -1,   888,    -1,    -1,    -1,
      -1,   893,   894,   895,   384,   385,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   909,    -1,    -1,
     400,    -1,    -1,    -1,    -1,   917,   918,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   926,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   811,   812,    -1,
     942,   431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   951,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   966,    -1,    -1,    -1,    -1,   459,
     460,   461,   462,   463,    -1,    -1,    -1,    -1,    -1,   469,
      -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,   483,   484,    -1,    -1,     1,    -1,    -1,
      -1,   491,    -1,    -1,   494,    -1,    -1,   881,    12,    -1,
      -1,    -1,    -1,    -1,    18,    -1,    -1,    -1,    22,    23,
      24,   511,    -1,    -1,    -1,    -1,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   908,    -1,    -1,    -1,    -1,    -1,
      -1,   531,   916,    -1,    -1,    -1,    -1,    -1,    -1,    53,
      54,    55,    56,    57,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,
     944,    -1,    -1,    -1,    -1,    -1,   566,   951,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   575,    -1,   577,    -1,    -1,
      -1,    -1,    -1,    -1,   584,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   592,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   605,    -1,    -1,    -1,    -1,
       1,    -1,    -1,    -1,   128,     6,    -1,    -1,    -1,    10,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   627,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,    -1,
      -1,    42,   166,    -1,    -1,    12,    -1,   657,   172,   173,
      -1,    18,    -1,    -1,    -1,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,   188,    -1,    -1,    -1,    -1,    70,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   712,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   128,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   298,   785,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   316,   317,    -1,    -1,    -1,    -1,    -1,   166,
     201,   811,   812,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
     850,    -1,   852,    -1,   854,    -1,   856,    -1,   858,   373,
     860,   861,   862,   863,   255,   865,   866,   867,    -1,    -1,
     384,   385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   881,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   908,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   916,   431,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,   330,
      -1,   298,    -1,    -1,   944,   459,   460,   461,   462,   463,
      -1,   951,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,
     317,    -1,    -1,    -1,   478,    -1,   966,    -1,   482,   483,
     484,    -1,    -1,    -1,    43,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    61,    62,    63,    64,    -1,   511,    -1,    -1,
      69,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   373,   531,    87,    88,
      -1,    -1,    91,   414,    93,    -1,    -1,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   556,   400,    -1,    -1,    -1,   116,   439,    -1,
      -1,    -1,   566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   575,    -1,   577,    -1,    -1,    -1,    -1,   137,   138,
     584,    -1,   141,    -1,   431,    -1,    -1,    -1,   592,   470,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   605,    -1,    -1,    -1,   486,    -1,    -1,    -1,    -1,
      -1,    -1,   459,   460,   461,   462,   463,    -1,   177,    -1,
      -1,    -1,   469,   627,   471,    -1,    -1,    -1,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,
       1,    -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,
      -1,    12,    -1,   657,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    22,    23,    24,   511,    -1,    -1,    -1,    -1,    30,
      -1,   552,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   531,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    53,    54,    55,    56,    57,    58,    59,    60,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   712,   556,
      -1,    -1,    -1,   594,    -1,    -1,    -1,    -1,    -1,   566,
      -1,   602,    -1,    -1,    -1,    -1,    -1,    -1,   575,    -1,
     577,    -1,    -1,    -1,    -1,    -1,    -1,   584,    -1,    -1,
     299,    -1,    -1,    -1,    -1,   592,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   638,   605,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     627,   785,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   670,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
      -1,    -1,    -1,    -1,   685,   166,    -1,   811,   812,    -1,
     657,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   702,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,
     389,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   398,
      -1,    -1,    -1,    -1,    -1,    -1,   850,    -1,   852,    -1,
     854,    -1,    -1,    -1,   858,    -1,   860,   861,   862,   863,
      -1,   865,   866,    -1,    -1,   712,    -1,    -1,    -1,   750,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   881,    -1,   760,
     761,    -1,    -1,    -1,    -1,   766,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,   780,
      -1,    -1,    -1,    -1,   908,    -1,    -1,    -1,    -1,    -1,
      -1,   470,   916,    -1,    -1,   474,    -1,    -1,   799,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   492,    -1,    -1,    -1,   298,   785,    -1,
     944,    -1,    -1,    -1,    -1,    -1,    -1,   951,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   317,    -1,    -1,    -1,
      -1,    -1,   966,    -1,   811,   812,    -1,    -1,    -1,    -1,
      -1,    -1,   853,    -1,    -1,    -1,   857,    -1,    -1,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   873,   874,    -1,    -1,    -1,    -1,    -1,    -1,
     361,   362,   363,   850,    -1,   852,    -1,   854,    -1,    -1,
      -1,   858,   373,   860,   861,   862,   863,    -1,   865,   866,
      -1,    -1,    -1,   384,   385,    -1,     1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   881,    -1,    -1,    12,    -1,   400,
      -1,   600,    -1,    18,    -1,    -1,    -1,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    -1,    -1,    -1,    -1,
      -1,   908,    -1,    -1,   623,   624,   625,    -1,    -1,   916,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    53,    54,
      55,    56,    57,    58,    59,    60,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   944,   459,   460,
     461,   462,   463,    -1,   951,    -1,    -1,    -1,   469,    -1,
     471,    -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,   966,
      -1,   482,   483,   484,    -1,    -1,    -1,    -1,    -1,    -1,
     491,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     511,    -1,   711,   128,   713,   714,    -1,    -1,    -1,    -1,
     719,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     531,    -1,    -1,    -1,   733,    -1,    -1,    -1,    -1,   738,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,   556,    -1,   172,   173,    -1,
      -1,    -1,    -1,    -1,    -1,   566,   765,    -1,    -1,    -1,
      -1,    -1,    -1,   188,   575,    -1,   577,    -1,   777,    -1,
      -1,    -1,    -1,   584,    -1,    -1,    -1,    -1,    -1,    -1,
     789,   592,    -1,    -1,   595,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   605,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   627,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   846,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   657,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   868,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   298,    -1,    -1,    -1,    -1,    -1,   888,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   317,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   712,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,    -1,
      -1,   950,    -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   384,
     385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   785,   400,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     811,   812,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   459,   460,   461,   462,   463,   850,
      -1,   852,    -1,   854,   469,    -1,   471,   858,    -1,   860,
     861,   862,   863,   478,   865,   866,    -1,   482,   483,   484,
      -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,   494,
     881,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   511,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   908,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   916,   531,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   556,    -1,   944,    -1,    -1,    -1,    -1,    -1,    -1,
     951,   566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     575,    -1,   577,    -1,    -1,   966,    -1,    -1,    -1,   584,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   592,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,
      -1,    -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   712,    -1,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    -1,
      -1,    -1,    -1,    91,    92,    93,    -1,    95,    96,    -1,
      -1,    -1,   100,    -1,    -1,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,   115,    -1,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,   142,   143,   144,   145,   146,    -1,
     785,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    -1,    76,    77,   811,   812,    -1,    -1,
      -1,    -1,   180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
      -1,    -1,   200,    -1,   202,   203,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   850,    -1,   852,   216,   854,
      -1,    -1,    -1,   858,    -1,   860,   861,   862,   863,    -1,
     865,   866,    -1,   231,   232,    -1,    -1,   235,   236,    -1,
     238,   239,   240,   241,   242,    -1,   881,    -1,    -1,    -1,
      -1,    -1,    -1,   155,    -1,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   262,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   908,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   916,    -1,    -1,    -1,    -1,    -1,    -1,   286,   287,
      -1,    -1,    -1,   291,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,    -1,   306,   944,
      -1,    -1,    -1,    -1,   312,   313,   951,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,    -1,
      -1,   966,    -1,   331,   332,   333,   334,   335,    -1,    -1,
     338,    -1,    -1,    -1,   342,   343,   344,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   365,    -1,    -1,
      -1,    -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     378,   379,   380,   381,    -1,    -1,    -1,    -1,    -1,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,   397,
      -1,   399,    -1,   401,   402,   403,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   422,   423,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   432,   433,   434,   435,   436,   437,
      -1,    -1,    -1,   345,   346,   347,   348,   349,   446,   351,
     352,   353,   450,    -1,    -1,    -1,   454,    -1,   456,    -1,
     458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   475,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   389,    -1,    -1,
     488,   489,   490,    -1,    -1,   493,    -1,    -1,    -1,   497,
      -1,   499,   500,   501,   502,    -1,    -1,    -1,    -1,    -1,
      -1,   413,   510,    -1,    -1,    -1,    -1,    -1,   516,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   527,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   535,    -1,    -1,
      -1,    -1,   540,   541,   542,    -1,   544,    -1,   546,   547,
      -1,   549,   550,   551,    -1,    -1,    -1,    -1,   556,   557,
      -1,   559,   560,   561,   562,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   571,   572,    -1,    -1,   575,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   583,    -1,     1,    -1,    -1,
      -1,     5,    -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,
     598,   599,    -1,    -1,    -1,    19,    -1,    -1,   606,   607,
      -1,   609,    -1,    -1,    28,   613,    -1,    -1,    -1,    -1,
      -1,   523,   620,    -1,    -1,    -1,    -1,    -1,   626,    -1,
      -1,    -1,   630,    -1,   632,   633,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   646,    -1,
      -1,   649,   650,    -1,    -1,    -1,    -1,   655,    -1,    -1,
      -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,   666,    -1,
      -1,    -1,    -1,   671,    -1,   673,   674,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   682,   683,    -1,   101,   102,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   601,
      -1,    -1,    -1,    -1,    -1,    -1,    12,   705,   706,   707,
      -1,    -1,    18,    -1,    -1,    -1,    -1,    -1,   132,    -1,
     622,   719,   720,   721,    -1,    -1,    -1,   725,   726,   727,
     728,   729,   730,    -1,    -1,    -1,   734,   735,   152,    -1,
      -1,    -1,   156,   645,   742,   743,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   751,   752,   753,   754,    -1,    -1,    -1,
     174,   759,    -1,    -1,    -1,    -1,   764,    -1,    -1,   767,
     768,   769,   770,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   782,    -1,    -1,    -1,    -1,   787,
     788,    -1,    -1,    -1,    -1,    -1,    -1,   795,   796,    -1,
     798,    -1,    -1,   801,   218,    -1,    -1,    -1,    -1,   807,
     224,    -1,   226,    -1,    -1,    -1,   230,    -1,    -1,    -1,
     234,    -1,    -1,    -1,    -1,    -1,   824,   825,    -1,    -1,
     828,    -1,    -1,    -1,    -1,   833,    -1,   251,    -1,    -1,
      -1,    -1,    -1,   841,   842,   843,    -1,    -1,    -1,   847,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,
      -1,   773,   774,   775,   288,    -1,   182,    -1,    -1,   877,
      -1,   879,   188,    -1,    -1,   883,    -1,    -1,    -1,    -1,
     304,   889,    -1,    -1,    -1,   309,    -1,    -1,   896,    -1,
      -1,   315,   316,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,   911,   912,   913,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,
      -1,    -1,    -1,    -1,   932,   933,   934,    -1,   936,   937,
     938,   939,   940,    -1,    -1,    -1,    -1,    -1,   946,   947,
      -1,    -1,   366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     374,   959,    -1,   377,    -1,   963,    -1,    -1,   382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   893,   894,   895,   408,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   416,    -1,   418,    -1,    -1,   421,    -1,    -1,
     424,    -1,    -1,    -1,    -1,    -1,   918,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   440,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   506,    -1,   400,    -1,    -1,    -1,    -1,   513,
      -1,   515,    -1,    -1,   518,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     534,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,
       5,    -1,    -1,   469,    -1,   471,    11,    -1,    -1,    -1,
      -1,    -1,   478,    -1,    19,   589,   482,   483,   484,    -1,
      -1,    -1,    -1,    28,    -1,   491,    -1,    -1,   494,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   612,    -1,
      -1,    -1,    -1,    -1,    -1,   511,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   653,
      -1,    -1,    -1,    -1,    -1,   659,    -1,    -1,    -1,    -1,
     664,    -1,    -1,   667,   668,    -1,   101,   102,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   577,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     704,    -1,    -1,    -1,    -1,   709,    -1,    -1,    -1,   605,
      -1,    -1,   716,    -1,    -1,    -1,    -1,   152,   722,    -1,
      -1,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   741,    -1,   174,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   756,    -1,    -1,    -1,    -1,    -1,   762,    -1,
      -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   780,    -1,    -1,    -1,
      -1,    -1,    -1,   218,    -1,    -1,    -1,    -1,    -1,    -1,
     794,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,
     804,   805,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   813,
      -1,    -1,   816,    -1,    -1,    -1,   712,    -1,   253,    -1,
      -1,    -1,    -1,   258,   259,   260,   261,   831,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   304,
      -1,    -1,    -1,    -1,   878,    -1,    -1,    -1,    -1,    -1,
     315,   316,    -1,    -1,    -1,    -1,    -1,   891,    -1,   785,
      -1,    -1,    -1,   897,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   811,   812,    -1,   922,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     826,   366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   374,
      -1,    -1,   377,    -1,    -1,    -1,    -1,   382,    -1,    -1,
      -1,   955,    -1,    -1,    -1,    -1,   960,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   863,    -1,    -1,
      -1,    -1,    -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   416,    -1,   418,    -1,   881,   421,    -1,    -1,   424,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   908,    -1,     9,    -1,    -1,    -1,    -1,    -1,
     916,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   944,    -1,
      -1,    -1,    -1,    -1,    49,   951,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     966,   506,    -1,    -1,    -1,    -1,    -1,    -1,   513,    -1,
     515,    -1,    -1,   518,    79,    80,    81,    82,    83,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   534,
      95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,
      -1,   146,    -1,    -1,   589,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,    -1,    -1,    -1,    -1,   202,   203,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   664,
      -1,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,    -1,
     235,   236,    -1,    -1,    -1,   240,    -1,    -1,    -1,    -1,
      -1,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,
      -1,    -1,    -1,    -1,   709,    -1,    -1,    -1,    -1,    -1,
      -1,   716,    -1,    -1,    -1,    -1,    -1,   722,    -1,    -1,
      -1,    -1,   287,    -1,    -1,    -1,   291,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   741,    -1,    -1,    -1,
      -1,   306,    -1,    -1,    -1,    -1,    -1,   312,   313,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   762,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   331,   332,   333,   334,
     335,    -1,    -1,   338,    -1,   780,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   794,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   804,
     805,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   813,    -1,
      -1,   816,    -1,   378,   379,   380,   381,    -1,    -1,    -1,
      -1,    -1,   387,   388,    -1,   390,   831,   392,   393,   394,
      -1,    -1,   397,    -1,   399,    -1,    -1,    -1,   403,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   853,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   422,   423,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   432,   433,   434,
     435,   436,   437,   878,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   446,    -1,    -1,    -1,   450,   891,    -1,    -1,   454,
      -1,    -1,   897,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   493,    -1,
      -1,    -1,   497,    -1,   499,   500,   501,   502,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   510,    -1,    -1,    -1,    -1,
     955,    -1,    -1,    -1,    -1,   960,    -1,    -1,    -1,    -1,
      -1,    -1,   527,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     535,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   571,   572,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,
      -1,   606,    -1,    -1,   609,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   620,    -1,    -1,    -1,    -1,
      -1,   626,    -1,    -1,    -1,   630,    -1,   632,   633,    -1,
      -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,
      -1,   646,    -1,    -1,   649,   650,    -1,    -1,    -1,    -1,
     655,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   154,    -1,    -1,   671,    -1,   673,   674,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   682,   683,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     705,   706,   707,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     725,   726,   727,   728,   215,   730,    -1,    -1,    -1,   734,
     735,    -1,   223,    -1,    -1,    -1,    -1,   742,   743,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   751,   752,   753,    -1,
      -1,    -1,    -1,    -1,   759,    -1,    -1,    -1,    -1,   764,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   782,    -1,    -1,
      -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
     795,   796,    17,    -1,    -1,    -1,   801,    -1,    -1,    -1,
      -1,    -1,   807,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   824,
     825,    -1,    -1,    -1,    49,    -1,    -1,    -1,   833,   320,
     321,    -1,    -1,    -1,    -1,    -1,   841,    -1,    -1,    -1,
      -1,    -1,   847,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   360,
      95,    -1,   877,    -1,    -1,   100,    -1,    -1,   883,    -1,
      -1,    -1,    -1,    -1,    -1,   376,   111,   112,   113,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   139,   406,    -1,   142,   143,   144,
      -1,   146,   927,    -1,    -1,    -1,    -1,    -1,    -1,   934,
      -1,   936,    -1,    -1,   939,    -1,    -1,    -1,   429,    -1,
     431,   946,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     441,    -1,    -1,    -1,   959,   180,    -1,    -1,   963,    -1,
      -1,    -1,   453,    -1,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,   464,   465,    -1,    -1,   202,   203,    -1,
      -1,    -1,    -1,    -1,    -1,   476,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   485,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,    -1,
     235,   236,    -1,    -1,    -1,   240,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   287,    -1,    -1,    -1,   291,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   306,    -1,    -1,    -1,    -1,    -1,   312,   313,   580,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   331,   332,   333,   334,
     335,    -1,    -1,   338,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   617,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   628,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   638,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,   381,    -1,    -1,    -1,
      -1,    -1,   387,   388,    -1,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,   399,    -1,    -1,    -1,   403,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   678,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   422,   423,    -1,
      -1,    -1,    -1,    -1,   695,    -1,    -1,   432,   433,   434,
     435,   436,   437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   446,    -1,    -1,    -1,   450,   451,    -1,    -1,   454,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   733,    -1,    -1,   736,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   750,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   493,    -1,
      -1,    -1,   497,    -1,   499,   500,   501,   502,    12,    -1,
     771,    -1,    -1,    -1,    18,   510,    -1,    -1,    22,    23,
      24,    -1,    -1,    -1,    -1,   786,    30,    -1,    -1,    -1,
      -1,    -1,   527,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     535,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    53,
      54,    55,    56,    57,    58,    59,    60,    -1,   819,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   571,   572,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   606,    -1,    -1,   609,   876,    -1,    -1,    -1,    -1,
      -1,    -1,   883,   884,   128,   620,    -1,    -1,    -1,    -1,
      -1,   626,    -1,    -1,    -1,   630,    -1,   632,   633,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   909,    -1,
      -1,   646,    -1,    -1,   649,   650,    -1,    -1,    -1,    -1,
     655,    -1,   166,   924,    -1,   926,    -1,   928,   172,   173,
     931,    -1,    -1,    -1,   935,    -1,   671,    -1,   673,   674,
      -1,    -1,    -1,    -1,   188,    -1,    -1,   682,   683,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   967,    -1,    -1,    -1,
     705,   706,   707,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     725,   726,   727,   728,    -1,   730,    -1,    -1,    -1,   734,
     735,    -1,    -1,    -1,    -1,    -1,    -1,   742,   743,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   751,   752,   753,    -1,
      -1,    -1,    -1,    -1,   759,    -1,    -1,    -1,    -1,   764,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   782,    -1,    -1,
      -1,    -1,    -1,    -1,   298,    -1,    -1,    -1,    -1,    -1,
     795,   796,    -1,    -1,    -1,    -1,   801,    -1,    -1,    -1,
      -1,    -1,    -1,   317,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   824,
     825,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   833,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   841,    -1,    -1,    -1,
      -1,    -1,   847,    -1,    -1,    -1,    -1,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    12,    -1,    -1,    -1,   373,
      -1,    18,    -1,    -1,    -1,    22,    23,    24,    -1,    -1,
     384,   385,   877,    30,    -1,    -1,    -1,    -1,   883,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   431,    -1,    -1,
      -1,    -1,   927,    -1,    -1,    -1,    -1,    -1,    -1,   934,
      -1,   936,    -1,    -1,   939,    -1,    -1,    -1,    -1,    -1,
      -1,   946,    -1,    -1,    -1,   459,   460,   461,   462,   463,
      -1,    -1,    -1,    -1,   959,   469,    -1,   471,   963,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,   483,
     484,   128,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,   531,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    12,    -1,    -1,    -1,    -1,    -1,
      18,   575,    -1,   577,    -1,    -1,    -1,    -1,    -1,    -1,
     584,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   592,    -1,
      -1,    -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,    -1,
      -1,   605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    61,    62,    63,    64,    -1,    -1,    -1,
      -1,    69,    -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   298,    -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     317,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   712,    -1,
      -1,    -1,    -1,    -1,   361,   362,   363,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,   373,    -1,    -1,   177,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   384,   385,    -1,
     188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,    18,
      -1,   785,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   811,   812,    -1,
      -1,    -1,   459,   460,   461,   462,   463,    -1,    -1,    -1,
      -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,
      -1,    -1,    -1,    -1,   491,    -1,   850,   494,   852,    -1,
     854,   299,    -1,    -1,   858,    -1,   860,   861,   862,   863,
      -1,   865,   866,    -1,   511,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   881,    -1,    -1,
      -1,    -1,    -1,    -1,   531,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   908,    -1,    -1,    -1,    -1,   556,
     358,    -1,   916,   361,   362,   363,    -1,    -1,    -1,   566,
      -1,    -1,    -1,    -1,    -1,   373,    12,   166,   575,    -1,
     577,    -1,    18,   172,   173,    -1,    -1,   584,    -1,    -1,
     944,    -1,    -1,    -1,    30,   592,    -1,   951,    -1,   188,
     398,    -1,   400,    -1,    -1,    -1,    -1,    -1,   605,    -1,
      -1,    -1,   966,    -1,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,    -1,    -1,    -1,    -1,    -1,
     627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     657,   459,   460,   461,    -1,    -1,    -1,    -1,    12,    -1,
      -1,   469,   470,   471,    18,    -1,    -1,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,    -1,
      -1,    -1,    -1,   491,   492,    -1,   494,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   300,    -1,   511,   512,   712,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,
      -1,   539,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   361,   362,   363,    -1,    -1,    -1,    -1,   577,
      -1,    -1,    -1,    -1,   373,    -1,   375,    -1,   785,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   600,    -1,    -1,    -1,    -1,   605,    -1,    -1,
      -1,   400,    -1,    -1,   811,   812,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    12,    -1,   624,   625,   172,   173,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   850,    -1,   852,    -1,   854,    -1,   657,
      -1,   858,    -1,   860,   861,   862,   863,    -1,   865,   866,
     459,   460,   461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     469,   317,   471,    -1,   881,    -1,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,   483,   484,    -1,    -1,    -1,    -1,
      -1,    -1,   491,    -1,    -1,   494,    -1,    -1,    -1,    -1,
      -1,   908,    -1,   711,   712,   713,   714,    -1,    -1,   916,
      -1,    -1,   511,    -1,    -1,   361,   362,   363,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   733,    -1,   373,    -1,    -1,
     738,    -1,    -1,    -1,    -1,    -1,    -1,   944,    -1,    -1,
      -1,    -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   400,    -1,   555,    -1,    -1,   966,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,   777,
      -1,    -1,    -1,    -1,   172,   173,    -1,   785,   577,    -1,
      -1,   789,    -1,    -1,   182,   431,    -1,    -1,    -1,    -1,
     188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   811,   812,    -1,   605,   361,   362,   363,
      -1,    -1,    -1,   459,   460,   461,    -1,    -1,    -1,   373,
      -1,    -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,    -1,    -1,    -1,   491,   400,    -1,   494,    -1,
      -1,    -1,    -1,    -1,    -1,   863,    -1,    -1,   657,    -1,
      -1,    -1,    -1,    -1,    -1,   511,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   881,    -1,    -1,    12,    -1,    -1,    -1,
     888,    -1,    18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   902,    -1,    -1,    -1,    -1,    -1,
     908,    -1,    -1,    -1,    -1,   459,   460,   461,   916,    -1,
     556,   710,    -1,   712,    -1,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,   483,
     484,   577,    -1,    -1,    -1,    -1,   944,   491,    -1,    -1,
     494,    -1,   950,   951,    -1,    -1,   592,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,   966,   605,
      -1,    -1,    -1,   361,   362,   363,    -1,    -1,    12,    -1,
      -1,    -1,    -1,    -1,    18,   373,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   657,   811,   812,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   577,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    12,    -1,    -1,   172,   173,    -1,    18,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   605,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   459,   460,   461,   863,    -1,   712,    -1,    -1,    -1,
      -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,
     478,    -1,   881,    -1,   482,   483,   484,    -1,    -1,    -1,
      -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,    -1,
      -1,    -1,    -1,   657,    -1,    -1,    -1,    -1,    -1,   908,
      -1,    -1,    -1,   511,    -1,    -1,    -1,   916,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    12,    -1,    -1,   172,   173,
      -1,    18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   785,
      -1,    -1,    -1,    -1,   188,   944,    -1,    -1,    -1,    -1,
      -1,   950,   951,    -1,    -1,    -1,    -1,    -1,   712,    -1,
      -1,    -1,    -1,    -1,    -1,   811,   812,   966,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   850,    -1,   852,   605,    -1,   188,
      -1,    -1,    -1,    -1,    -1,   861,   862,   863,    -1,   865,
     866,    -1,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,
      -1,   785,    -1,    -1,    -1,   881,    -1,   373,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   811,   812,   657,
      -1,    -1,   908,    -1,   400,    -1,    -1,    -1,    -1,    -1,
     916,    -1,   826,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    12,    -1,   172,   173,    -1,    -1,    18,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   944,    -1,
      -1,   188,    -1,    -1,    -1,   951,    -1,    -1,    -1,   863,
      -1,    -1,    -1,    -1,   712,    -1,    -1,   361,   362,   363,
     966,    -1,    -1,   459,   460,   461,    -1,   881,    -1,   373,
      -1,    -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,    -1,    -1,   908,   491,   400,    -1,   494,    -1,
      -1,    -1,   916,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   511,    -1,    -1,    -1,    -1,
      -1,    -1,   361,   362,   363,    -1,    -1,   785,   367,    -1,
     944,    -1,    -1,    -1,   373,    -1,    -1,   951,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   966,   811,   812,   459,   460,   461,    -1,    -1,
      -1,   400,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,   166,   482,   483,
     484,   577,    -1,   172,   173,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,
      -1,    -1,    -1,    -1,    -1,   863,    -1,   511,    -1,   605,
      -1,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,    -1,
     459,   460,   461,   881,    -1,    12,   373,    -1,    -1,    -1,
     469,    18,   471,    -1,    -1,    -1,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,   483,   484,    -1,    -1,    -1,    -1,
     908,    -1,   491,   400,    -1,   494,    -1,    -1,   916,    -1,
      -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   511,   577,    -1,    -1,    -1,    -1,    -1,    -1,
     584,    -1,    -1,    -1,    -1,    -1,   944,    -1,    -1,    -1,
      -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   605,    -1,    -1,    -1,    -1,    -1,    -1,   966,    -1,
      -1,    -1,   459,   460,   461,    -1,   712,    -1,    -1,    -1,
      -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,   577,    -1,
      -1,    -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,
      -1,    -1,    -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   511,    -1,   605,    -1,    -1,    -1,
      -1,    -1,   361,   362,   363,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    12,    -1,   373,   172,   173,    -1,    18,   785,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,   712,    -1,
      -1,   400,    -1,    -1,    -1,   811,   812,    -1,   657,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   848,    -1,    -1,    -1,    -1,    -1,   605,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   863,    -1,    -1,
     459,   460,   461,   712,    -1,    -1,    -1,    -1,    -1,    -1,
     469,   785,   471,    -1,    -1,   881,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,   483,   484,    -1,    -1,    -1,    -1,
      -1,    -1,   491,    -1,    -1,   494,    -1,   811,   812,    -1,
     657,    -1,   908,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     916,    -1,   511,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    12,    -1,
      -1,    -1,   172,   173,    18,    -1,   785,    -1,   944,    -1,
      -1,    -1,    -1,    -1,    -1,   951,    -1,    -1,   188,   863,
      -1,    -1,    -1,    -1,    -1,   712,    -1,    -1,    -1,    -1,
     966,    -1,   811,   812,   361,   362,   363,   881,    -1,    -1,
      -1,    -1,    -1,    -1,    12,    -1,   373,    -1,   577,    -1,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   908,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   916,   400,    -1,    -1,   605,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   863,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,
     944,    -1,   881,    -1,    -1,    -1,    -1,   951,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   966,    -1,   811,   812,    -1,    -1,   657,   908,
      -1,    -1,   459,   460,   461,    -1,    -1,   916,    -1,    -1,
      -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,
      -1,   478,   166,    -1,    -1,   482,   483,   484,   172,   173,
      -1,    -1,    -1,    -1,   491,   944,    -1,   494,    -1,    -1,
      -1,    -1,   951,    -1,   188,    -1,   863,    -1,   865,    -1,
      -1,    -1,    -1,   712,   511,    -1,    -1,   966,    -1,    -1,
      -1,   361,   362,   363,   881,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,   373,   172,   173,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     188,   908,    -1,    -1,    -1,    -1,   553,    -1,    -1,   916,
     400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,    -1,
     577,    -1,    -1,    -1,    -1,    -1,   785,   944,    -1,    -1,
      -1,    -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   605,   966,
      -1,    -1,   811,   812,    -1,    -1,    -1,    -1,    -1,   459,
     460,   461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   469,
      -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,   483,   484,    -1,    -1,    -1,    -1,    -1,
      -1,   491,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,
     657,    -1,    -1,    -1,   863,    -1,    -1,    -1,    -1,    -1,
      -1,   511,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
      -1,    -1,   881,    -1,    -1,    -1,    -1,    -1,    -1,   373,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   908,
      -1,    -1,    -1,    -1,    -1,   712,   400,   916,    -1,    -1,
      -1,    -1,    -1,   361,   362,   363,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   373,    -1,   577,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   944,    -1,    -1,    -1,    -1,
      -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,   605,    -1,   966,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   459,   460,   461,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,   471,   785,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,   483,
     484,    31,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,    -1,   811,   812,     3,   657,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,    13,   511,    -1,    -1,
      -1,   469,    -1,   471,    -1,    -1,    -1,    67,    -1,    -1,
     478,    -1,    29,    -1,   482,   483,   484,    -1,    -1,    -1,
      -1,    -1,    -1,   491,    -1,    -1,   494,    87,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    -1,   863,    -1,    -1,    -1,
      -1,    -1,   712,   511,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   881,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    -1,   577,    -1,    -1,   126,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    93,    -1,    -1,    96,
      -1,   908,    -1,    -1,    -1,    -1,   103,    -1,    -1,   916,
      -1,   605,    -1,    -1,   154,    -1,    -1,    -1,   115,    -1,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,
      -1,    -1,    -1,    -1,    -1,   785,    -1,   944,    -1,    -1,
      -1,    -1,    -1,    -1,   951,    -1,    -1,    -1,   145,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   605,    -1,   966,
      -1,   811,   812,   657,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     850,    -1,    -1,   200,    -1,    -1,    -1,    -1,    -1,   657,
      -1,    -1,    -1,   863,    -1,    -1,    -1,    -1,   712,   216,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   881,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   238,   239,    -1,   241,   242,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   908,    -1,
      -1,    -1,    -1,    -1,   712,    -1,   916,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,
      -1,   785,    -1,    -1,   944,    -1,    -1,    -1,    -1,    -1,
      -1,   951,    -1,    -1,    -1,   302,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   966,   811,   812,    -1,
     360,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   376,   785,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   342,   343,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   811,   812,    -1,   406,    -1,   365,   863,
      -1,    -1,    -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   881,    -1,   429,
      -1,   431,    -1,    -1,    -1,    -1,    -1,    -1,   395,   396,
      -1,   441,    -1,    -1,   401,   402,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   453,   908,   863,    -1,    -1,    -1,    -1,
      -1,    -1,   916,    -1,   464,   465,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   881,    -1,    -1,   476,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   485,    -1,    -1,    -1,    -1,
     944,    -1,    -1,    -1,    -1,    -1,    -1,   951,    -1,   456,
     908,   458,    -1,    -1,    -1,    -1,    -1,    -1,   916,    -1,
      -1,    -1,   966,    -1,    -1,    -1,    -1,    -1,   475,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   488,   489,   490,    -1,    -1,   944,    -1,    -1,    -1,
      -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   966,   516,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     580,    -1,    -1,   540,   541,   542,    -1,   544,    -1,   546,
     547,    -1,   549,   550,   551,    -1,    -1,    -1,    -1,    -1,
     557,    -1,   559,   560,   561,   562,    -1,    -1,    48,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   617,   575,    -1,
      -1,    61,    62,    63,    64,    -1,   583,    -1,   628,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   638,    -1,
      -1,   598,   599,    -1,    -1,    -1,    -1,    87,    88,    -1,
     607,    -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   678,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     130,    -1,    -1,    -1,    -1,   695,    -1,   137,   138,    -1,
      -1,   141,    -1,   660,    -1,    -1,    -1,    -1,    -1,   666,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   733,    -1,    -1,   736,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,
     750,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   719,   720,   721,    -1,    -1,    -1,    -1,    -1,
      -1,   771,   729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    54,    -1,    -1,    -1,    -1,   786,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   754,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     767,   768,   769,   770,    -1,    -1,    -1,    -1,    -1,   819,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     787,   788,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   798,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,   299,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   828,    -1,    -1,    -1,    -1,   876,    -1,    -1,    -1,
      -1,    -1,    -1,   883,   884,   842,   843,    -1,    -1,    -1,
      -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,
     173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   909,
      -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,   358,    -1,
      -1,    -1,   879,    -1,   924,    -1,   926,   367,   928,   369,
      -1,   931,   889,    -1,    -1,   935,   376,    -1,    -1,   896,
      -1,    -1,    -1,    -1,    -1,    -1,   386,    -1,    -1,    -1,
     907,    -1,    -1,    -1,   911,   912,   913,    -1,   398,    -1,
     400,    -1,    -1,    -1,    -1,    -1,    -1,   967,    -1,    -1,
      -1,    48,    -1,    -1,    -1,   932,   933,    -1,    -1,    -1,
     937,   938,    -1,   940,    61,    62,    63,    64,    -1,    -1,
     947,   431,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    88,    -1,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     470,   108,    -1,    -1,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   492,   130,   494,    -1,    -1,    -1,    -1,    -1,
     137,   138,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,   362,
     363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   538,    -1,
     373,    -1,    -1,    -1,    -1,   545,    -1,    -1,    -1,   186,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    54,   400,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     580,    -1,   582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     600,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   617,    -1,    -1,
      -1,    -1,    -1,    -1,   624,   625,   459,   460,   461,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   469,    -1,   471,    -1,
      -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,   648,   482,
     483,   484,    -1,    -1,    -1,    -1,    -1,   657,   491,    -1,
      -1,   494,   299,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,
      -1,    54,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   699,
     188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   711,    -1,   713,   714,    -1,    -1,    -1,    -1,    -1,
      -1,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,    -1,    -1,    -1,   577,    -1,   746,    -1,    54,   386,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   398,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   771,   605,    -1,    -1,    -1,    -1,   777,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   785,    -1,    -1,    -1,   789,
      -1,    -1,    -1,    -1,   431,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   166,   441,    -1,    -1,    -1,    -1,   172,
     173,    -1,    -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,
     457,    -1,    -1,   823,   657,   188,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   470,    -1,    -1,    -1,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,
      -1,    -1,    -1,   853,    -1,   492,    -1,   494,    -1,   859,
     166,    -1,    -1,   863,    -1,    -1,   172,   173,    -1,    -1,
      -1,    -1,    -1,   361,   362,   363,   876,    -1,    -1,   712,
      -1,    -1,   188,    -1,    -1,   373,    -1,    -1,   888,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   538,    -1,    -1,    -1,    -1,    -1,    -1,   545,   909,
      -1,    -1,   400,    -1,    -1,    -1,    -1,   917,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   926,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   580,    -1,   582,    -1,    -1,    -1,    -1,
      -1,    -1,   785,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   600,    -1,    -1,   966,    -1,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,    -1,    -1,   811,   812,
     617,   469,    -1,   471,    -1,    -1,    -1,   624,   625,    -1,
     478,    -1,    -1,    -1,   482,   483,   484,    -1,   361,   362,
     363,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,    -1,
     373,   648,    -1,    -1,    -1,    -1,    -1,   850,    -1,    -1,
     657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   861,    -1,
     863,    -1,   865,   866,    -1,    -1,    -1,   400,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   881,    -1,
      -1,    -1,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,
      -1,    -1,   699,    -1,    -1,    -1,    -1,   373,    -1,    -1,
      -1,    -1,    -1,    -1,   711,   908,   713,   714,    -1,    -1,
      -1,    -1,    -1,   916,    -1,    -1,    -1,    -1,    -1,   577,
      -1,    -1,    -1,    -1,   400,    -1,   459,   460,   461,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   469,    -1,   471,   746,
      -1,   944,    -1,    -1,    -1,   478,    -1,   605,   951,   482,
     483,   484,    -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,
      -1,   494,    -1,   966,   771,    -1,    -1,    -1,    -1,    -1,
     777,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,
      -1,    -1,   789,   459,   460,   461,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   469,    -1,   471,    -1,    54,    -1,   657,
      -1,    -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,    -1,    -1,    -1,   491,   823,    -1,   494,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   848,    -1,    -1,   577,    -1,   853,    -1,    -1,    -1,
      -1,    -1,   859,    -1,   712,    -1,   863,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   876,
      -1,    -1,   605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   888,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   577,   909,    -1,    -1,    -1,    -1,    -1,    -1,   166,
     917,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,   926,
      -1,    -1,    -1,    -1,   657,    -1,    -1,   785,    -1,   605,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    54,    -1,    -1,
      -1,    -1,    -1,   811,   812,    -1,    -1,    -1,    -1,   966,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   712,
      -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   850,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   861,    -1,   863,    -1,   865,   866,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   881,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   712,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     908,    -1,   785,    -1,    -1,    -1,    -1,    -1,   916,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   811,   812,
      -1,   188,    -1,    -1,    -1,    -1,   944,    -1,    -1,   822,
      -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   361,   362,   363,    -1,   966,   785,
      -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   861,    -1,
     863,    -1,   865,   866,    -1,   811,   812,    -1,    -1,    -1,
      -1,    -1,    -1,   400,    -1,    -1,   822,    -1,   881,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,   908,    -1,   172,   173,    -1,
      -1,    -1,    -1,   916,    -1,   861,    -1,   863,    -1,   865,
     866,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   459,   460,   461,   881,    -1,    -1,    -1,    -1,
      -1,   944,   469,    -1,   471,    -1,    -1,    -1,   951,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,
      -1,    -1,   908,   966,   491,    -1,    -1,   494,    -1,    -1,
     916,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,   944,    -1,
      -1,    -1,    -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     966,    -1,    -1,   400,    -1,    -1,    -1,    43,    -1,    -1,
      -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    61,    62,    63,    64,    -1,
     577,    -1,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    88,    -1,   172,   173,    -1,    -1,   605,    -1,
      -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,
     188,    -1,   469,    -1,   471,    -1,   361,   362,   363,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,   373,    -1,
      -1,    -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,
      -1,   137,   138,    -1,    -1,   141,    -1,    -1,    -1,    -1,
     657,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,
      -1,   177,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   712,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   459,   460,   461,    -1,    -1,   215,
     577,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,    -1,
      -1,    -1,    -1,   478,    -1,    -1,   166,   482,   483,   484,
      -1,    -1,   172,   173,    -1,    -1,   491,    -1,   605,   494,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,
     166,    -1,    -1,   361,   362,   363,   172,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,    -1,
     657,    -1,   188,    -1,   811,   812,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   850,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   861,   712,   863,    -1,   865,   866,
     605,    -1,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   368,   369,   881,    -1,    -1,    -1,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,
     478,   908,   398,    -1,   482,   483,   484,    -1,    -1,   916,
      -1,    -1,   657,   491,    -1,    -1,   494,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,
      -1,   361,   362,   363,    -1,    -1,    -1,   944,    -1,    -1,
      -1,    -1,    -1,   373,   951,    -1,    -1,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   811,   812,    -1,    -1,   703,   966,
      -1,   457,    -1,    -1,    -1,    -1,    -1,   712,    -1,    -1,
     400,    -1,    -1,    -1,   470,   361,   362,   363,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,
      -1,    -1,    -1,   489,    -1,    -1,   492,    -1,    -1,   577,
      -1,    -1,    -1,    -1,   861,    -1,   863,    -1,   865,   866,
      -1,    -1,    -1,    -1,   400,    -1,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   881,    -1,    -1,   605,    -1,   459,
     460,   461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   469,
     785,   471,   538,    -1,    -1,    -1,    -1,    -1,   478,   545,
      -1,   908,   482,   483,   484,    -1,    -1,    -1,    -1,   916,
      -1,   491,    -1,    -1,   494,    -1,   811,   812,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   461,    -1,    -1,    -1,   657,
      -1,    -1,    -1,    -1,    -1,    -1,   582,   944,    -1,    -1,
      -1,    -1,   478,    -1,   951,    -1,   482,   483,   484,    -1,
      -1,    -1,    -1,    -1,   600,   491,    -1,    -1,   494,   966,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   863,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   624,   625,
      -1,    -1,    -1,    -1,   712,    -1,   881,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,
      -1,    -1,   648,    -1,    -1,   651,    -1,   902,    -1,    -1,
      -1,    -1,    -1,   908,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   916,    -1,    -1,    -1,   605,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   944,
      -1,    -1,    -1,   699,    -1,    -1,   951,   785,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   711,    -1,   713,   714,    -1,
      -1,   966,    -1,    -1,    -1,    -1,    -1,   657,    -1,    -1,
      -1,    -1,    -1,   811,   812,    -1,    -1,   733,    -1,    -1,
      -1,    -1,   738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     746,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   777,   712,    -1,    -1,   863,    -1,   865,    -1,    -1,
      -1,    -1,    -1,   789,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   881,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   712,   823,    -1,    -1,
     908,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   916,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   843,   844,    -1,
      -1,    -1,    -1,    -1,    -1,   785,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   944,    -1,    -1,    -1,
      -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   811,   812,    -1,    -1,    -1,    -1,    -1,   966,    -1,
      -1,    -1,   888,    -1,    -1,    -1,    -1,    -1,    -1,   785,
      -1,    -1,    -1,    -1,   900,    -1,    -1,    -1,    -1,    -1,
      -1,   907,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   811,   812,    -1,    -1,    -1,
      -1,    -1,    -1,   863,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   881,    -1,    -1,   950,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   863,   908,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   916,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   881,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   944,    -1,    -1,    -1,    -1,    -1,
      -1,   951,   908,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     916,    -1,    -1,    -1,    -1,    -1,   966,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   944,    -1,
      -1,    -1,    -1,    -1,    -1,   951,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     966
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   971,   972,     0,   973,   974,   975,   978,   979,   175,
     996,   997,   591,  1006,  1024,   237,   405,   407,   976,   977,
     980,   981,   988,   991,  1009,  1010,  1012,   853,   292,  1033,
    1034,  1035,  1036,   853,  2316,   977,   372,   643,  1013,  1014,
    1015,  1016,  1011,    38,  1025,  1026,  1007,   168,  1037,  1038,
    1039,  1040,   237,   998,   853,  1006,   853,  1006,   237,   431,
    2358,   215,  1028,   201,  1214,  1216,  1217,  1218,   420,  1125,
    1126,  1127,    21,   126,   184,   187,   189,   213,   307,   481,
     575,   579,   698,   737,   784,   786,   818,   830,   868,   951,
     962,  1041,  1042,  1043,  1045,  1049,  1064,  1070,  1071,  1072,
    1073,  1074,  1076,  1081,  1099,  1100,  1105,  1108,  1111,  1112,
    1115,  1117,  1118,  1119,  1120,  1121,  1122,  1123,   745,  2316,
     215,   999,   478,   644,  1017,   273,   982,   983,   984,  1017,
     267,   986,  2316,   526,   789,   792,   793,  1027,   723,   289,
    1029,  1008,   857,  1219,  1220,   237,   745,   327,  1128,     1,
     951,  2220,  2220,   799,   771,  2386,  2358,  2358,  2358,  2220,
     771,  2316,  2316,  2358,  2316,  2316,   124,   169,  2340,  1124,
    2220,  1043,     1,   853,  1073,  1075,   411,  1098,  2316,  1000,
      39,  1019,   985,   984,  1019,   987,   512,  2370,  2358,   426,
    1031,   638,  1552,  1553,  1558,   745,  1221,  2316,  2316,  2316,
    1129,  1082,   357,  1097,  2349,  2358,  2358,   951,  2213,  2269,
     149,  2213,  2358,  2358,  1050,  1065,  2213,  1046,   951,  1106,
    1107,  1285,  1097,  2358,  1113,   478,   582,   585,  1077,  1079,
    1080,  1980,  2275,  2358,    41,   246,   790,   791,   951,  1158,
     745,   478,  1020,  2358,   478,   644,  1018,   853,  2358,  1018,
    2358,   133,   802,   855,  1030,   724,  2316,  1554,  1588,  1589,
    2316,   324,   740,  1215,  1222,  1223,  1225,   439,   750,  1130,
    1191,  1192,  1083,  1086,  1087,  2349,  2358,    25,   523,  2213,
     478,   411,   581,  2414,   478,   876,   123,   503,   642,   749,
     951,  1051,  1052,  1053,  1054,  1055,  1059,  1060,  1062,  2339,
    2381,   371,   642,  1066,  1067,  1068,  1047,  1062,  1107,  2358,
     951,  1101,  1102,  1103,  2221,  2220,    18,   400,   478,   494,
     657,   785,   863,   951,   966,  1114,  2280,  2281,  2282,  2283,
    1980,   431,   799,  2377,  2358,   184,  2220,   853,   853,   153,
     320,   652,   677,   859,  1021,  1022,  1023,  2316,   652,  2316,
      52,   528,   529,   530,   647,   869,   870,   882,  2309,  2358,
     237,     0,     1,     5,    11,    19,    28,   101,   102,   132,
     152,   156,   174,   218,   224,   226,   230,   234,   251,   288,
     304,   309,   315,   316,   366,   374,   377,   382,   408,   416,
     418,   421,   424,   440,   506,   513,   515,   518,   534,   589,
     612,   653,   659,   664,   667,   668,   686,   704,   709,   716,
     722,   741,   756,   762,   780,   794,   804,   805,   813,   816,
     831,   853,   878,   891,   897,   922,   955,   960,   968,  1590,
    1592,  1621,  1626,  1631,  1636,  1662,  1667,  1675,  1679,  1680,
    1684,  1687,  1692,  1697,  1749,  1753,  1755,  1756,  1761,  1777,
    1786,  1790,  1793,  1796,  1800,  1802,  1809,  1819,  1822,  1825,
    1831,  1852,  1853,  1862,  1866,  1868,  1872,  1875,  1879,  1893,
    1907,  1909,  1913,  1928,  1929,  1939,  1942,  1943,  1947,  1953,
    1954,  1955,  1967,  1977,  1994,  2004,  2012,  2013,  2019,  2030,
    2034,  2037,  2040,  2043,  2046,  2057,  2077,  2085,  2086,  2114,
    2327,  1590,   953,  1274,  1275,  1277,  1278,     1,   951,  2201,
    2316,  1131,    32,   517,   701,   733,  1193,  1194,  1195,  1196,
    1198,  1199,  1200,  1205,  1084,  1085,    25,   523,   478,  1109,
    1110,  2279,  2280,   950,  1116,  2401,  2269,   758,   777,  2389,
    2358,   853,  1053,   853,   951,  1052,   127,   136,  1056,  2341,
      18,   373,   951,  1069,   951,     1,   853,  1068,  1048,  2401,
    2281,  1102,    33,   431,  2221,  2360,  2283,   849,  2377,   431,
    2220,  2220,  1078,  1079,     5,  1001,  1002,  1023,  2316,  2381,
     153,  2316,   528,   529,   647,   882,  1032,  1555,     5,    11,
      19,    28,   101,   102,   132,   152,   156,   174,   218,   230,
     234,   253,   258,   259,   260,   261,   263,   264,   265,   266,
     268,   270,   271,   272,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   288,   304,   315,   316,   366,
     374,   377,   382,   408,   416,   418,   421,   424,   506,   513,
     515,   518,   534,   589,   612,   664,   686,   709,   716,   722,
     741,   762,   780,   794,   804,   805,   813,   816,   831,   853,
     878,   891,   897,   955,   960,  2313,  2314,  2315,  1593,  1622,
    1627,  1632,  1637,  1663,  1668,  1676,  1681,  1688,  1685,  1693,
    1698,  1750,  1754,  1762,  1832,  1778,  1787,  1791,  1794,  1797,
    1801,  1803,  1810,  1820,  1823,  1826,  1867,  1869,  1873,  1876,
    1591,  1880,  1894,  1908,  1910,  1914,  1930,  1940,  1944,  1948,
    1968,  1978,  1995,  2005,  2020,  2031,  2035,  2038,  2041,  2044,
    2047,  2058,  2078,   357,  1757,   374,   610,    18,  1956,   300,
     478,   657,   731,   785,   838,   966,  2017,  2018,  2163,  2260,
    2261,  2269,   374,   610,  1575,   745,   154,  1253,  1254,   250,
     763,   776,  1279,  1280,  1282,  1293,  1295,  1298,  2298,   464,
     638,   853,   857,   967,  2318,  2319,  2325,  1224,   556,   590,
    2306,   152,   181,   198,   199,   319,   487,   498,   631,   672,
     691,   956,   957,  1201,   585,  1206,  2375,   670,   780,   781,
    1197,     1,   201,   439,   638,   750,   853,  1195,  2317,  2324,
    2358,  2358,  1098,  1110,   840,   618,  2358,  2275,   853,  2358,
     760,   428,  1019,     1,   373,   428,  1019,   853,   853,   212,
     478,  1104,  2276,  2283,  2220,  1003,   230,  1004,   989,   992,
      99,   511,   603,   797,   802,   855,   948,  1643,  1644,   584,
     951,  1594,  1597,  1598,  1599,  2202,  2260,    12,   166,   172,
     173,   182,   188,   361,   362,   363,   373,   459,   460,   461,
     469,   471,   482,   483,   484,   491,   511,   577,   605,   712,
     811,   812,   826,   881,   908,   916,   944,  1623,  2193,  2225,
    2226,  2228,  2229,  2260,  2281,  2285,  2286,  2287,  2288,  2422,
      54,   861,   865,   866,  1628,  2188,  2189,  2190,  2191,  2192,
    2193,  2229,  2232,  2260,  2267,  2269,  2282,  2285,   478,  1633,
    1634,  2209,  2210,  2211,  2269,  1638,  1643,    18,   478,   644,
    1664,  1665,  1666,  2244,  2260,   949,  1669,  1670,  1672,  2201,
      12,  1677,  2193,  2194,  2195,  2223,  2265,  2266,  2269,  2282,
      15,  1682,   857,  1689,  2201,    18,  1686,  2260,  2262,   419,
     438,   597,   830,  1694,  1696,   299,   354,   412,   478,   507,
     584,   789,   814,   859,   949,  1699,  1700,  1701,  1702,  1704,
    1712,  1714,  1715,  1716,  1719,  1724,  1727,  1728,  1731,  1733,
    2225,  2244,  2260,  2401,  1751,  2226,  1694,   856,   867,  1763,
    1764,  1765,  2167,  2168,  2169,  1829,  2260,  2281,  2285,   122,
    1779,  1781,   371,   608,   612,   642,   745,  1788,  1792,  2222,
    2223,  1795,  2269,   848,  1798,  2397,   375,   661,   710,  1654,
    1789,     1,  2166,  2167,  1811,  2222,   951,  1821,  2203,   175,
     949,  1492,  1736,  1824,  2260,    65,  1827,  1828,  1996,  2253,
    2254,  2269,  1492,  1736,  1870,   182,  1874,  2226,  1877,  2226,
     757,   314,  1881,  1882,  1883,   411,  1895,  2161,  2351,   951,
    2202,   310,  1911,  2260,  1915,  2201,  1931,  2202,  1941,  2196,
    2269,  1945,  2201,   857,  1949,  2196,  2197,   848,  1969,  1970,
    1974,  2202,   292,   449,   511,  1979,  1982,  1983,  1986,  1987,
    1988,  1989,  1990,  1991,  1992,  1993,  2163,  2204,  2205,  2222,
    2252,  2254,  2269,  1996,  2006,  2201,  2021,  2022,  2023,   182,
     826,  2032,  2225,   636,  2036,  2039,  2203,  2042,  2255,  2260,
    2045,  2201,   478,  2048,  2245,  2260,  2285,  2059,  2260,  2079,
    2197,   377,  1643,  1759,  1854,  1863,  1957,  1958,  2198,  2269,
    2014,  2260,   865,  2273,  2274,  2087,  2115,   853,   951,   968,
    1576,  1578,  1579,  1582,  1583,  1588,   154,   464,   476,   485,
     638,   695,   736,   853,  2318,  2323,  2326,   745,   485,  1407,
    1408,  1285,  1297,  1285,  1285,  1280,  2323,     1,   336,  1283,
    1284,  1285,   464,   967,  1226,   590,  2220,  2375,  2397,  2397,
     581,  2374,  2375,  2375,  2397,  2375,  2375,  2397,  2375,  2375,
     857,  2348,   308,  2347,   478,  1144,  2269,    34,  2331,  2317,
      41,   246,   400,   478,   481,   494,   526,   657,   785,   790,
     791,   966,  1088,  1090,  1091,  1092,  1095,   886,   918,   919,
    1089,  1090,  2279,   478,  2275,   481,   820,   915,  1061,  2216,
    2270,  2271,  1057,   512,  2276,  2358,  1005,   853,  1036,  1208,
    1208,   950,  1640,   258,  1620,  1595,    43,    68,   368,   512,
    1604,  1605,  1606,  1610,  1613,  2334,  2335,  2401,   865,  1601,
     507,  2369,   367,  2374,  2260,   865,   865,   865,  2290,   865,
    2414,  2414,   865,   865,   865,   865,  2414,  2253,   865,  2290,
     259,  1625,   848,  1624,  2226,  2261,  2282,  2285,   865,  2289,
     865,   865,  2192,  2192,  2188,  2192,   124,   861,   866,    53,
      55,    56,    57,    58,    59,    60,   852,   862,   317,  2261,
    2282,  2285,   417,  2301,  1634,   848,  2414,   260,  1661,  2161,
    1666,  1673,  2201,   679,   890,  1671,  2401,  2420,  2374,   261,
    1678,   298,   854,  2195,  2411,   723,  2307,  2273,  2274,  1683,
    1690,  2201,   263,  1691,   670,  2383,   176,  2343,  2260,   830,
    2394,   830,  2202,  1713,   383,  1734,    92,  2337,   264,  1748,
     310,   567,   588,  2129,  2131,  2133,  2406,  1702,  2224,  2225,
    1703,   950,  1705,  1601,  1725,  1734,   903,   904,   905,   906,
     177,   265,  1752,    97,   427,   266,  1776,    27,   943,  1766,
    1767,  1768,  1770,    30,    53,    54,    55,    56,    57,    58,
      59,    60,   317,   431,   556,   592,   850,   852,   861,   862,
     865,   866,  2170,  2171,  2179,  2226,  2358,   694,   827,  1833,
     520,  1782,   197,  1789,  2223,   288,  2208,   449,  1911,  2226,
     837,  1805,  1812,  2401,  2203,  2260,     9,    17,    49,    79,
      80,    81,    82,    83,    84,    85,    86,    95,   100,   111,
     112,   113,   114,   129,   139,   142,   143,   144,   146,   180,
     189,   190,   191,   192,   193,   194,   195,   196,   202,   203,
     231,   232,   235,   236,   240,   262,   287,   291,   306,   312,
     313,   331,   332,   333,   334,   335,   338,   378,   379,   380,
     381,   387,   388,   390,   392,   393,   394,   397,   399,   403,
     422,   423,   432,   433,   434,   435,   436,   437,   446,   450,
     451,   454,   493,   497,   499,   500,   501,   502,   510,   527,
     535,   571,   572,   606,   609,   620,   626,   630,   632,   633,
     646,   649,   650,   655,   671,   673,   674,   682,   683,   705,
     706,   707,   725,   726,   727,   728,   730,   734,   735,   742,
     743,   751,   752,   753,   759,   764,   782,   795,   796,   801,
     824,   825,   833,   841,   847,   877,   883,   927,   934,   936,
     939,   946,   959,   963,  1497,  1499,  1501,  1503,  1505,  1507,
    1509,  1511,  1514,  1516,  1518,  1519,  1521,  1523,  1524,  1526,
    1528,  1531,  1532,   452,   777,   846,  1533,  1534,  1829,  1998,
     865,  2273,   556,   807,  1494,  1495,  1496,  1497,  2305,  1533,
     270,  1871,  2226,   848,   271,  1878,    97,  1882,   318,   419,
     438,   597,  1884,    98,   359,   478,  1287,  1900,  1901,  1902,
    2209,  2229,  2246,  2260,  2269,  2281,  2285,  2401,   838,   951,
    1912,   274,  1927,   534,   629,  2304,   275,  1938,   507,   748,
    1932,   367,  2080,   276,  1946,  2383,   951,   277,  1952,  2080,
    2226,   279,   367,  1972,  1973,  2239,  2242,  2260,  2282,  2285,
     310,  1989,  1991,  2222,   637,   848,  2205,   243,   848,   899,
    1981,    45,  2273,   280,  2011,   339,   443,   449,  2008,   281,
    2029,   427,  2024,  2025,  2226,  2260,  2253,   282,  2033,   367,
    2203,  2340,   670,   676,  2384,   283,  2056,   219,  2049,  2260,
     284,  2084,  2080,   848,   478,  1855,  2260,  1864,  2260,  1959,
    2198,   278,  1965,   931,  1960,  1654,  2015,  2226,  2401,  2186,
    2188,   865,  2274,  2088,  2260,  2116,  2260,     1,   745,   853,
    1577,  1276,  2316,   745,   476,  1410,  1411,  1296,  1299,   690,
    2323,   853,  1281,   169,    89,   135,   201,   445,   468,   670,
     675,   695,   697,   926,  1227,  1228,  1230,  1234,  1235,  1238,
    1239,  1245,  1248,  1250,  1251,  2319,  2358,  1132,  2212,  2213,
    2213,  2275,  2275,  2199,  2201,  2199,  2275,  2199,  2199,  2213,
    2199,  2199,   829,  2393,   257,  1207,  2275,  2349,  2216,  1092,
      27,   840,   124,   514,   952,  2418,   951,  2272,  1058,  2349,
    2358,  1076,  2358,  1040,   990,   993,  1641,   121,   917,  1559,
    1604,   966,  2247,  2252,  2275,  2358,  1606,   137,   141,   470,
     624,   625,  1611,  1612,  2410,   843,    48,    61,    62,    63,
      64,    69,    88,   138,   175,   177,   189,   215,   358,   369,
     398,   457,   489,   492,   538,   545,   582,   600,   648,   651,
     699,   711,   713,   714,   733,   738,   746,   789,   823,   844,
     888,   900,   907,  1614,  1617,  1618,  1619,  2344,  2382,   151,
     478,  1602,  1603,  2234,  2260,  2260,   183,    36,    37,   140,
     147,   150,   204,   209,   210,   292,   294,   301,   310,   419,
     470,   474,   508,   736,   821,   832,   843,   914,   951,  1609,
    2205,  2408,   288,   642,  2237,  2261,   848,  2186,  2188,  2296,
    2186,  2297,   850,  2186,  2289,  2292,  2293,   951,   951,  2188,
    2295,  2295,  2295,  2231,  2260,  2282,  2285,  2294,   951,   848,
    2231,  2291,  2289,    12,  2193,  2194,  2226,  2269,  2282,   375,
    2188,  2231,  2186,   850,   417,  2302,  2189,  2189,  2190,  2190,
    2190,  2190,  2190,  2190,  2190,  2190,  2190,  2190,   480,  1629,
     640,  1635,  2211,  1645,  1646,  2245,  2260,  1671,   486,   538,
    2349,  2261,  2188,   512,  2308,  2274,  2188,  2129,  2201,   708,
    1920,  1921,  1922,  1695,  2401,  1705,   949,  2225,  1585,  1586,
    2132,  2133,  2130,  2131,  1585,   902,  1610,  1613,  1707,  1708,
    1710,  2401,    61,    62,    63,    64,    69,    87,    88,   138,
     177,   299,   358,   398,   492,   600,   733,   738,   777,   789,
     888,  1618,  1706,  1747,   299,  1717,  1718,  2260,  2282,   902,
    1735,   949,  2129,  2129,  2129,  2129,  1700,  2226,  2194,  2226,
    1765,  1771,   943,  1768,  1769,   266,   853,   943,  1585,  2178,
    2179,  2171,    22,    23,    24,   128,   298,   384,   385,   462,
     463,   531,   566,   575,   584,   627,   854,   858,   860,  2180,
    2181,  2182,  2183,  2184,  2185,    18,   339,   453,   898,  1836,
    1834,  1780,   478,  2206,  2207,   221,  1799,  2209,   310,  2403,
     253,  1804,  1806,    18,    22,    25,    26,   523,   524,   575,
     576,  1813,  1817,   336,   411,   854,  2352,  1530,  2275,  2352,
    1532,  2352,  2352,  2352,  1534,   178,   694,   827,  1830,  1839,
    1841,  1842,  2000,  2375,  2401,   431,   854,  2359,  1495,    33,
     431,   854,  2361,     3,    13,    29,    50,    78,    91,    92,
      93,    96,   103,   115,   117,   118,   145,   200,   216,   238,
     239,   241,   242,   286,   302,   342,   343,   344,   365,   370,
     395,   396,   401,   402,   456,   458,   475,   488,   489,   490,
     516,   540,   541,   542,   544,   546,   547,   549,   550,   551,
     557,   559,   560,   561,   562,   575,   583,   598,   599,   607,
     613,   660,   666,   719,   720,   721,   729,   754,   767,   768,
     769,   770,   787,   788,   798,   828,   842,   843,   879,   889,
     896,   907,   911,   912,   913,   932,   933,   937,   938,   940,
     947,  1498,  1500,  1502,  1504,  1506,  1508,  1510,  1512,  1513,
    1515,  1517,  1520,  1522,  1525,  1527,   848,  2222,  2194,  2226,
     766,  1885,  2374,   389,  2162,  2162,   898,   931,   840,     1,
      71,    72,    73,    74,    76,   158,   159,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   478,   622,   645,  1288,
    1289,  1290,  1291,  1292,  1340,  1341,  2235,  2261,   845,   834,
    2383,   427,  2251,  2260,  2281,  2285,   427,  1916,  1920,  1973,
    2260,  1975,  2401,   848,   848,   848,   848,  1980,    12,   288,
     777,   856,   867,  2226,    97,    69,    88,   398,   457,   492,
     600,   713,   888,  1984,  1985,  2358,  2007,  2401,  2260,  2025,
     219,  2026,   367,   367,  2194,  2226,   367,    97,  2338,   427,
    2052,    15,    68,  2081,  2082,  1758,  1640,   269,  1861,   367,
    1861,   427,  1965,    44,   257,  1961,  2404,  1966,  2260,  1961,
    2226,   300,   555,   151,   755,   850,  2187,   851,  2188,   285,
    2113,   367,  2113,  2118,  2401,  1580,  2327,  1277,  1255,  2316,
     745,   695,  1413,   926,   928,  1380,  1384,  1316,  1317,  2358,
    2298,    31,    67,    87,   126,   215,   223,   360,   429,   441,
     465,   580,   617,   628,   678,   733,   750,   771,   819,   883,
     909,   924,   926,   928,   931,   935,  1304,  1305,  1306,  1307,
    1308,  1311,  1312,  1314,  1317,  1318,  1321,  1324,  1326,  1327,
    1332,  1333,  1334,  1344,  1348,  1365,  1366,  1368,  1369,  1370,
    1373,  1394,  1397,  1399,  1401,  1402,  1403,  1404,  1405,  1406,
    1458,  2358,  2388,  1286,  2358,   170,  2342,  2358,   670,   676,
    2419,  2419,  2358,  2342,  2358,  2370,  2358,    33,  2330,   581,
    1252,  2220,   320,   376,     1,  1133,  1134,  2213,  2375,  2375,
     871,   872,  2423,  2201,  2375,  2375,  2342,  2374,  2374,   676,
    2199,  1093,  1095,  2414,    25,   523,  2216,  1076,  1044,  1045,
    1218,  1551,  1551,    99,   603,   802,  1642,  1561,  1560,   710,
    1570,   301,   565,   567,   587,  2122,  2124,  2125,  2127,  2128,
    2405,  2406,    89,   573,  2372,  2372,   478,  2248,  2252,  2277,
    2358,  2358,  2358,  2358,    69,   248,  1619,  2339,   243,   899,
    2398,    15,  2329,   443,   777,  1602,   151,   861,   866,  2122,
     965,   964,  2239,  2122,   443,  2363,   799,   799,   573,  1596,
     519,   478,  2238,  2261,  2260,  2187,   850,  2187,   850,   850,
     616,   850,  2231,  2187,   850,   850,   850,  2187,   850,  2253,
    2187,   850,  2374,   570,   778,  2134,  2136,  2138,  2273,  2274,
    2194,   851,   850,   850,   848,  2303,  1629,  2275,   710,  1630,
     848,  2209,  1639,   532,   644,  1647,    39,  1674,  2401,   715,
     689,  2134,  2358,   744,   359,  2349,   430,   568,  2155,  2156,
    2158,  2160,   443,  1729,  1720,  1587,   184,   185,   634,  1076,
    1711,  2205,  1708,   539,  1747,  2359,   470,   736,  2358,   295,
     297,  1535,  1536,  2346,  2397,  2359,   243,  2398,  2358,  1747,
    1718,  2260,  1726,  1732,  2129,   375,  2134,   375,     1,    31,
     856,   867,  1773,  1774,  2168,   595,  1772,   966,  2180,  2397,
     339,  1095,  1838,  2269,    18,   453,   898,  1835,  1600,  1601,
    1799,  2207,  2375,  1807,   268,  1808,  1585,  2397,   694,  1814,
    2397,  2260,  2260,  2260,  2260,  2260,  2240,  2261,  2268,  2282,
      18,   124,   339,   453,   876,  1845,  1846,  1847,  1840,  1841,
    1154,  2001,  2341,    40,   222,  1360,   244,  1529,  2260,  2275,
     865,  2226,  2222,  2134,   375,  2401,  1920,  1288,  2351,  1901,
    1896,  1897,   316,  1903,  2166,  1904,  1905,  2260,  2209,   853,
    2082,  1916,  2260,  2260,   563,  2144,  2147,  2149,  2404,  1950,
    1951,  2401,   710,  2081,   249,   254,   303,  2260,  2239,   582,
     966,  2249,  2250,  2252,  2275,  2374,  2238,   581,  2226,  1980,
    1980,  1980,  1980,  1980,  1980,  1980,  1980,  1985,   556,   566,
    2009,  2010,  2181,  2305,  2155,   459,   777,  2421,  2028,  2401,
    2338,  2260,  2253,  2134,   375,  2240,    18,  2050,  2051,  2299,
    2053,  2260,  2028,  2053,  1920,    14,  2328,   478,  1760,   917,
    1648,  2260,  2260,   943,  1962,   943,  1963,  1964,   799,  2391,
    2391,  2188,   850,  2188,  2260,   710,  2119,   256,  1584,  2275,
    1256,  1409,  2316,  1414,   736,  1476,  2358,  2330,    30,   317,
     592,   850,   852,   861,   862,   865,   866,  1287,  1303,  1386,
    1387,  1388,   926,   376,  2269,   459,   575,   943,  2399,  2358,
    2358,  2358,    77,   123,   575,  1325,   943,   719,  2385,  2258,
    2261,   245,  1351,  2275,  1328,   943,  2261,    39,  2333,   943,
     431,   456,   719,  1367,  2397,  2358,  2358,   367,  2358,   367,
    2330,   951,  1459,  1460,  1306,    70,    71,    72,    73,    74,
      76,    77,   155,   157,   158,   160,   161,   162,   163,   164,
     165,   230,   345,   346,   347,   348,   349,   353,   389,   413,
     523,   601,   622,   645,   773,   774,   775,   893,   894,   895,
     918,  1335,  1340,  1341,  1287,  1303,  1381,  1382,   320,   321,
     406,   786,   884,   453,   876,   367,  1300,  2333,   376,  2275,
    1158,  2360,  2360,   951,  2217,  2218,   584,   789,  2415,   478,
    2213,  2219,  2275,   931,  2358,   328,   405,   951,  1236,  2220,
    2317,     6,    10,    29,    42,   255,   329,   330,   414,   470,
     552,   594,   602,   670,   685,   702,   766,   780,   857,   873,
     874,  1135,  1136,  1145,  1147,  1151,  1153,  1154,  1157,  1159,
    1160,  1161,  1162,  1168,  1169,  1170,  1171,  1174,  1180,  1181,
    1183,  1185,  1187,  1188,  1189,  1190,  2317,  2341,  2383,  2413,
    2199,  2199,  2375,  2199,  2199,  1202,  1203,  2201,  2420,  2201,
    1094,  1095,  2272,  2358,  2358,  2216,  1070,  1209,  1411,   638,
     994,   994,   476,  1562,  1563,  1564,  2338,  1562,   584,   951,
    1556,  2126,  2127,  1615,  1616,  2256,  2260,  2123,  2124,  1585,
    2247,  2247,  2247,  2247,  2248,  2247,  2358,  2164,  2250,  2164,
    2248,  2351,  2358,   850,   850,  1602,  2234,  2234,  2122,   777,
    1607,  1608,  1610,  2307,   822,  2289,   822,  2289,   850,  2289,
    2213,  2289,  2289,  2289,  2231,  2289,  2307,   453,   876,  2289,
    2261,  1585,  1585,  2137,  2138,  2135,  2136,  2274,  2134,   850,
    2188,  2289,  2289,  2243,  2260,  2281,  1630,  2223,  2162,   538,
    2309,  2188,  1585,  1585,  2159,  2160,  2157,  2158,  2244,  1735,
     215,   404,   846,   883,  1654,  1721,  1722,  1723,  1588,  2247,
    2247,   470,   736,   257,  2247,  2164,  2164,  2247,    91,    93,
     389,   474,   623,   765,   868,  1610,  1737,  1738,  1739,  1740,
    1741,  1743,  1744,  1745,  1746,  2401,  1737,  2194,  2195,  2194,
    2195,    27,   840,  1775,   266,   853,  1585,  1773,    97,   339,
    1838,   299,  1783,  2260,  1585,   253,   926,  1815,  1816,  1817,
     837,  1818,  2395,   926,   848,    97,  1846,  1848,  2240,    18,
     124,   453,   876,  1843,  1844,  2239,  2256,  2260,  1997,   760,
    2363,   411,   593,  2353,  2225,  2194,    18,   538,   664,  1184,
    2199,  2260,  1585,   272,   853,  1899,    15,   367,    14,   410,
    1917,  1918,  1919,  1921,  1924,  1951,  2401,   201,   543,  1933,
    1935,  1937,  1585,  2148,  2149,  2147,  1585,  2155,   486,   538,
    1971,  2260,   694,  1976,   325,   326,  2226,  2181,  2260,  2182,
    2183,  2184,  2185,  2188,   569,   864,  2139,  2141,  2143,   622,
     777,  2027,  2226,  2307,  2307,  2194,   848,   592,  2239,   220,
    2054,   827,  2055,  1950,   604,  2205,  2247,  1649,   183,  2165,
    1865,  2401,  2167,  1585,  2166,  1963,  2016,  2226,  2016,   850,
    2165,   523,   925,  2120,  2242,   853,   109,  1257,  1258,  1259,
    1277,  1412,   745,  1477,   840,  1385,  1388,  2358,   840,  1294,
     966,    22,    23,    24,    90,   128,   575,  1158,  1400,   553,
    1398,  2226,  2222,   201,  2345,     1,  2172,  2173,  2174,  2175,
     865,  1309,  1310,   104,  1353,   887,   848,  1350,    98,   221,
     481,  1329,  1345,  2172,  2258,  1322,   951,  2259,     1,   578,
     951,  1336,  2223,   865,  1376,  1381,  1382,  1376,  1371,  1372,
    1381,   367,  1461,  1460,   772,   892,  2387,   892,  2387,   892,
    2387,   892,  2387,   892,  2387,    16,  2374,   692,  1377,  1378,
    1382,    39,  1315,  2338,  1319,   806,  1313,   758,  2310,  2310,
     951,  1302,  1303,   848,  1233,   357,  1249,  2218,   474,  2367,
     848,  2340,  2351,   322,   340,   732,   885,   920,   929,  1246,
    1247,  2358,  2358,  2370,  2363,  2383,  2397,   761,  2363,  2358,
    2339,   220,  2363,  2363,   538,  1182,  2275,  2401,  2358,  2358,
     799,   486,   760,    70,  2336,  2360,  2199,  1203,   625,  1204,
      27,  2216,  2216,  1111,  1115,  1117,  1210,  1211,  1212,  1213,
    1063,  1064,   995,   984,   986,  1563,   777,   892,  1565,  1566,
    1567,   680,   926,  2327,  1585,  2244,   470,   474,  2416,  1616,
    2249,   850,  2358,  1608,  2134,  2289,   367,  2311,   850,  1640,
     230,   744,   845,  1730,  2359,  2359,  2359,  2359,  2226,  1723,
    2374,   411,   431,  2362,  2247,  2331,  1738,   116,   456,   719,
    1742,   538,  1747,  2134,   687,  2134,   687,  1774,  2167,  1838,
     694,  1837,  1784,  1785,  2260,  2281,  1807,  1816,  2345,  2397,
    2241,  2268,  2281,  2239,    97,    15,    68,  1849,  1850,  1851,
    1844,  1849,   357,   419,   917,  2002,  1155,  1999,   593,   850,
    2134,   595,  2378,  2378,   586,    20,   229,   357,   455,   700,
     714,   950,  1886,  1887,  1891,  1892,  2401,  2402,   272,  1898,
    1905,  2226,  2375,   486,   443,  1925,  1923,  1924,  2401,   409,
     442,   941,  1585,  1585,  1936,  1937,  1934,  1935,   486,   470,
    2364,  2374,  2374,  1585,  1585,  2142,  2143,  2140,  2141,  2358,
    2134,  2311,  2134,  2241,  2051,  2351,  2165,  2351,  2139,   296,
     564,  2083,  2150,  2152,  2154,  2156,   470,   474,  2365,  1650,
    1651,  1652,  2338,  2351,  1856,   519,  2100,   225,  1585,  1585,
    2089,  2401,   641,   910,  1581,  2060,  2220,  1277,  1277,  2316,
     745,  1287,   943,  1389,  1390,  1391,  2360,  2400,   534,   794,
    1301,  1302,  2269,    30,    53,    54,    55,    56,    57,    58,
      59,    60,   317,   592,   850,   852,   861,   862,   865,   866,
    2176,  2177,  2179,  2180,  2226,   478,  2236,  2351,   367,  1349,
     845,  2396,  2275,  2396,  2275,  2375,  1330,  2358,   595,  1323,
    2172,   680,  1395,  2399,  1379,  2277,  2358,  1378,  2330,  1372,
    1381,   367,  1374,  1377,  2232,    97,  1462,     7,    66,    78,
     125,   148,   206,   290,   355,   364,   445,   452,   477,   505,
     654,   658,   739,   800,   814,   838,   880,   930,   942,   949,
     951,  1490,  2277,  2397,   478,  2244,   184,   189,   307,   737,
    1320,  2339,  1303,  2275,   124,   676,  1229,  2212,  1240,  2275,
    2389,   478,  1237,  2269,  1237,  2358,  2358,  2363,   245,   320,
    1142,  1143,  2358,   685,  1169,  2358,  2358,  2358,  2358,    34,
      35,  2332,  1184,  2219,  2275,  2358,  2370,   581,   761,  1186,
    2219,  2275,  1095,  2349,  2349,  1212,   853,  1213,   237,  2358,
     777,  1567,   590,  1569,   214,  1571,  2249,   413,  2354,   223,
    2312,  1648,  1737,  2226,  2226,  2226,  2226,  2260,  2359,   846,
     738,   954,  2195,  2195,    97,  1709,  1710,  1785,  1585,    97,
     215,  1849,  1849,  2241,   859,  2356,  2356,  1851,  1850,   638,
    2199,   375,   597,  2003,  1156,  2349,  2358,  2269,    18,   538,
     665,   901,   958,  1889,  1890,  1891,   538,    94,   486,   497,
    1888,    97,  1906,   486,  2358,  1926,  2145,  2147,  2149,  2155,
     486,   486,  2201,  2201,  2260,  2312,  2260,  2260,  1585,  1585,
    2153,  2154,  2151,  2152,  1651,   584,  1566,  2227,  2228,  2257,
    2261,   171,   680,   926,  2260,  2100,  2374,   817,  1858,  2091,
    2092,  2093,  2401,   857,  2121,  2196,   638,  2061,   853,  1260,
    1415,  2316,   762,   429,   921,  1392,   856,  2374,  2177,   966,
    2180,   850,   951,  2275,   848,  1350,   221,   221,  1352,  2213,
     777,   951,  1331,   323,   951,  1337,  1338,   585,  1396,   300,
     538,   850,  2187,  1376,   848,  1375,  2232,   217,   341,   447,
     504,   779,   875,  1342,   479,  1343,  2396,   257,   799,    91,
     868,  1241,  1242,  1243,  1244,  2401,  2340,   367,  1232,  2350,
     245,   662,   761,  1146,  2213,  2358,   105,   106,   107,   227,
     228,   230,   419,   420,   444,   470,   495,   597,   630,   634,
     635,   662,   829,  1137,  1138,  1139,  1140,  1141,  2213,  2219,
    1172,  2213,  2213,  2340,  2423,  2213,  2358,  2213,  2219,   840,
     523,    25,   853,  1559,    48,   215,  2275,  2358,   951,  1572,
    1557,  2249,  2354,  2134,  1653,  1654,  2260,  2359,  2134,  2134,
    1838,  2226,  1849,  2226,  2226,  2358,  2199,   638,    25,   523,
    1158,   596,  2379,   715,  2229,  2233,  2236,  2260,  2285,   898,
    2260,  2148,  2146,  2147,  2134,  2227,  1858,  2101,  2102,  2260,
    1859,  1860,  2260,  2129,   521,  2095,  2093,    46,   256,   961,
    2094,   951,  2358,    43,   247,   311,   376,  2062,  2063,  2064,
    2066,  2070,  2072,  2073,  2076,  2334,  2349,  1261,  1416,  1478,
     848,   943,  1393,  2358,  2260,   417,  1354,  2375,  2375,   414,
    1355,  1357,  1358,  1359,  1360,  1362,  2358,  2374,     8,   128,
     171,   360,   684,   357,   300,  2277,  1376,  2219,  2219,   356,
     221,  1231,  1233,  2275,  2213,   367,    14,   917,   931,  2269,
    2281,  2424,    75,   473,   790,   951,  1173,   783,   854,  1175,
    1176,  2213,  2214,    51,   314,   496,  1163,  2358,   840,  2219,
    2358,  2358,  1570,    48,  1568,  2401,  2327,  1575,   848,  2249,
     567,   864,  1656,  1658,  1660,  2406,    12,   427,   558,   584,
     863,  1655,  2357,  2226,  1900,  2358,  2358,  2358,  1158,  2261,
    2282,  2285,  2166,  1857,  2102,  2358,  1860,  2358,   519,  2097,
    2242,  1900,    68,  2329,  1912,  2074,  2075,   642,   212,  1262,
    2320,  2323,  2349,   663,  1417,  1282,  1298,  1479,  1480,  1481,
    2166,  1287,  1355,  2213,  2213,  2338,  1362,  1358,  2363,  1356,
    2275,   586,  1339,  2263,  2264,  2266,  2334,  2375,  2340,  1175,
    2269,  2348,  2269,  2358,   611,  1148,  1149,  1177,  1178,   950,
    1164,  1166,  2401,  1167,  2401,  1164,  1158,  2219,  2216,  2216,
    2316,   503,  1575,  2249,  1585,  1585,  1659,  1660,  1657,  1658,
    1585,  2374,  2260,  1900,  1158,  1158,  2129,   584,  2281,  2242,
    2374,   883,  2103,  2117,   696,   789,  2390,   857,  2200,  2075,
     257,   794,  2071,  2375,   597,  2356,  1418,     1,  1284,  1481,
     853,  1355,  1363,  1364,  2270,  2358,  1357,  2264,  2219,  2213,
    1231,  2300,  2401,  1150,  2300,  1179,  2213,  1179,   486,  2368,
     722,   497,   777,   257,  2260,  2349,  2349,   522,  2096,  2098,
    2099,  2260,  2374,   817,  2108,  2129,  2260,   300,   310,  2412,
    2201,   857,    18,  2067,  2068,  2261,   223,   300,   799,   818,
     835,  1267,  1268,  1269,   419,   438,  2203,   853,  1482,  1483,
     853,  1364,  2215,  2216,  1148,   244,   538,  2358,   585,  2358,
    1573,   523,    25,  2358,  2099,  2358,  2104,  2105,  2260,   308,
     945,  2109,  2110,  2260,  2090,   638,  2380,  2201,   581,   639,
     681,  2069,  2068,   183,   826,  2358,   443,   443,   223,   459,
    1269,   257,   507,   799,   818,   835,  1263,  1264,  1265,  1266,
    2260,  2369,  2392,   257,   507,   799,   835,  1270,  1271,  1272,
    1273,  2260,  2392,  1419,  1485,   578,  1489,  1490,  2216,   816,
    1152,   244,  2213,   517,   670,   676,  2417,  2248,   214,  2358,
    2358,  2242,  2281,  2105,  2358,    45,   171,   252,   554,   575,
    2107,  2111,   400,   494,   785,   966,  2112,  2284,  2110,  2129,
    2375,   581,  2258,  2358,   580,  2260,  2358,  2358,  2358,  2358,
     443,   204,   843,   443,   459,  1265,  2260,   183,   656,   783,
     808,   809,   810,   443,   204,   843,   443,   459,  1272,  2260,
     830,     1,  1420,    48,    61,    62,    63,    64,    69,    87,
      88,   108,   130,   138,   186,   299,   358,   367,   369,   386,
     398,   457,   470,   474,   492,   538,   580,   600,   648,   699,
     746,   777,   789,   823,   848,   859,   888,   917,   926,  1327,
    1333,  1344,  1365,  1368,  1486,  1487,  1488,  1549,  1550,  1617,
    1618,  2358,  2410,  1491,  2260,  2275,  1484,   943,  2417,  1165,
    1166,  1574,  1158,  1158,  2107,  2106,  2107,  2106,   592,   318,
     419,   438,   597,  2065,  2199,  2260,  2275,  2260,  2260,  2260,
    2260,  2358,  2358,  2358,  2358,  2358,  2260,  2358,  2358,  2358,
    2358,  2358,  2358,  2358,  2358,  2358,  2358,  2358,  2260,  2358,
    2321,  2323,   175,   176,   604,  1421,  1422,  1427,  2321,  2358,
    2401,  2432,  2358,   470,   736,  1547,  2372,  1545,  2372,  2358,
    2359,  1535,  1536,  2358,  2251,  1545,  2359,  2275,   123,  2359,
    2260,  2260,  2358,  2282,   376,  1547,  1493,  1494,    18,   785,
     966,  1096,  1165,  2327,  2284,  2396,  2260,  2260,  2260,  2260,
    2260,  2260,  2260,  2260,  2260,  2260,  2260,  2260,  2260,  2260,
    2260,  2260,  2260,  2260,  2260,  2360,  2360,   466,   467,  2366,
    1438,   376,   134,   337,  1423,  1424,  1425,  1426,  2260,  2247,
    2358,  2358,  2247,  2256,  2275,  2247,  1542,  2247,  2396,  2358,
    2256,  2275,  1485,  2283,  1361,  1362,  2260,  2260,  2360,  2360,
     966,  1428,  1429,  1430,  2260,  2275,  2278,  1282,  1439,  2358,
    1425,  1426,   509,   621,   861,   866,  1538,  1539,  1540,  1541,
    1548,  1538,  1540,  1546,   110,   619,  1543,  1544,  2244,  2260,
    2260,  1431,   470,   474,  2365,  2408,  2416,     1,  1284,  1285,
    2244,  2247,  2247,  2260,   339,   356,   391,   449,   472,  1432,
    1433,  1434,  1435,  1436,  1437,  1429,  1430,  2322,  2323,  1440,
    2260,   211,   225,  2425,  2358,  2358,   120,   175,  2425,  2426,
    2358,  1441,  2260,  2358,  1430,  1430,   391,  2358,  2358,  1430,
       4,   137,   141,   387,   470,   474,   536,   580,   628,   783,
     815,   883,  1327,  1332,  1333,  1344,  1346,  1365,  1368,  1380,
    1383,  1442,  1443,  1448,  1451,  1454,  1455,  1458,  1463,  1464,
    1467,  1468,  1474,  1475,  2322,  2407,  2408,  2409,  2260,  1430,
    1430,  1430,   415,  2355,   574,  2372,  2373,  2330,  2358,  2275,
    2358,  2374,  2358,  1381,    15,    68,   441,   943,   537,  1465,
    1466,  1537,  1538,  1471,  1472,  1473,  1538,  2275,  2373,  2260,
    2360,   534,   537,   604,  1449,  1450,  1538,  2275,  1350,  2232,
    2230,  2232,   119,   175,   604,   614,   615,   695,   717,   718,
    1444,  2425,  2426,  2427,  2428,  2429,  2430,  2431,   533,  2371,
    2371,    15,    68,  2166,  1465,  2278,  1472,  2278,   115,   456,
     719,  1469,  1470,  2275,  2396,  2307,   703,   902,  1452,  2232,
     356,   356,   391,   356,   391,   357,   585,  2376,  2376,   592,
     604,  1456,  1457,  2260,  1456,  2371,  2371,  2360,  1352,  2375,
    2260,   337,  1445,  2260,    18,   337,  1447,  2260,  1456,   604,
     604,   803,  1347,   337,  1453,  2260,   592,  1446,  1446,  1446,
    1446,  2275,   604
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   970,   972,   971,   973,   973,   975,   974,   976,   976,
     977,   977,   977,   977,   979,   978,   980,   981,   982,   982,
     983,   983,   985,   984,   987,   986,   989,   990,   988,   992,
     993,   991,   994,   995,   994,   996,   997,   998,   997,   999,
    1000,   999,  1001,  1001,  1002,  1003,  1002,  1004,  1005,  1004,
    1007,  1008,  1006,  1009,  1009,  1011,  1010,  1012,  1012,  1013,
    1014,  1015,  1016,  1017,  1017,  1018,  1018,  1019,  1019,  1020,
    1020,  1021,  1021,  1021,  1021,  1022,  1022,  1023,  1023,  1024,
    1024,  1025,  1026,  1026,  1027,  1027,  1027,  1027,  1028,  1028,
    1029,  1029,  1030,  1030,  1030,  1031,  1031,  1032,  1032,  1032,
    1032,  1033,  1034,  1034,  1035,  1036,  1037,  1038,  1038,  1039,
    1040,  1041,  1041,  1042,  1042,  1043,  1043,  1043,  1043,  1043,
    1044,  1044,  1046,  1045,  1047,  1047,  1048,  1048,  1050,  1049,
    1051,  1051,  1051,  1051,  1052,  1052,  1053,  1053,  1053,  1053,
    1054,  1055,  1057,  1056,  1058,  1058,  1058,  1058,  1058,  1058,
    1059,  1060,  1061,  1061,  1061,  1061,  1062,  1062,  1063,  1063,
    1065,  1064,  1066,  1066,  1066,  1067,  1067,  1068,  1068,  1068,
    1068,  1068,  1069,  1069,  1070,  1071,  1072,  1072,  1072,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1073,  1075,  1074,  1076,  1076,  1077,  1077,
    1077,  1077,  1078,  1078,  1079,  1080,  1080,  1082,  1081,  1084,
    1083,  1085,  1083,  1086,  1086,  1087,  1088,  1088,  1088,  1088,
    1088,  1089,  1089,  1089,  1089,  1090,  1090,  1090,  1091,  1091,
    1092,  1092,  1093,  1092,  1094,  1094,  1095,  1095,  1095,  1095,
    1095,  1095,  1096,  1096,  1097,  1097,  1097,  1098,  1098,  1099,
    1100,  1101,  1101,  1102,  1103,  1103,  1104,  1104,  1105,  1106,
    1106,  1107,  1108,  1109,  1109,  1110,  1110,  1111,  1113,  1112,
    1114,  1114,  1115,  1116,  1116,  1117,  1118,  1119,  1120,  1121,
    1122,  1124,  1123,  1125,  1126,  1127,  1127,  1128,  1128,  1129,
    1129,  1131,  1132,  1130,  1133,  1133,  1134,  1134,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1136,  1136,
    1136,  1136,  1136,  1137,  1137,  1137,  1138,  1138,  1138,  1138,
    1138,  1138,  1138,  1139,  1139,  1139,  1139,  1140,  1140,  1140,
    1140,  1140,  1140,  1140,  1141,  1142,  1142,  1143,  1143,  1144,
    1144,  1145,  1146,  1146,  1146,  1147,  1148,  1148,  1150,  1149,
    1151,  1152,  1152,  1152,  1153,  1155,  1154,  1156,  1156,  1156,
    1156,  1156,  1156,  1157,  1158,  1158,  1158,  1158,  1158,  1159,
    1160,  1160,  1160,  1162,  1161,  1163,  1163,  1163,  1164,  1164,
    1164,  1164,  1165,  1165,  1166,  1167,  1167,  1168,  1168,  1169,
    1169,  1169,  1169,  1170,  1172,  1171,  1173,  1173,  1173,  1173,
    1174,  1175,  1175,  1176,  1176,  1178,  1177,  1177,  1179,  1180,
    1181,  1182,  1182,  1183,  1184,  1184,  1184,  1185,  1186,  1186,
    1187,  1188,  1189,  1190,  1191,  1191,  1192,  1193,  1193,  1193,
    1194,  1194,  1195,  1195,  1195,  1195,  1196,  1197,  1197,  1197,
    1197,  1198,  1198,  1198,  1198,  1198,  1199,  1199,  1199,  1199,
    1199,  1199,  1199,  1199,  1201,  1200,  1202,  1202,  1203,  1204,
    1204,  1205,  1206,  1207,  1207,  1208,  1208,  1208,  1209,  1210,
    1210,  1211,  1211,  1212,  1212,  1213,  1213,  1213,  1215,  1214,
    1216,  1216,  1217,  1218,  1219,  1220,  1220,  1221,  1221,  1222,
    1224,  1223,  1223,  1225,  1225,  1226,  1226,  1227,  1227,  1227,
    1227,  1227,  1227,  1227,  1227,  1227,  1227,  1227,  1228,  1229,
    1229,  1229,  1230,  1230,  1230,  1231,  1231,  1232,  1232,  1233,
    1233,  1234,  1235,  1235,  1236,  1236,  1237,  1237,  1238,  1239,
    1240,  1240,  1241,  1241,  1241,  1242,  1243,  1244,  1245,  1246,
    1246,  1246,  1246,  1246,  1247,  1247,  1248,  1249,  1249,  1250,
    1251,  1251,  1252,  1252,  1253,  1254,  1255,  1254,  1256,  1256,
    1257,  1258,  1260,  1259,  1261,  1261,  1262,  1262,  1262,  1263,
    1263,  1263,  1264,  1264,  1265,  1265,  1265,  1265,  1265,  1265,
    1265,  1265,  1265,  1265,  1265,  1266,  1267,  1267,  1268,  1268,
    1269,  1269,  1269,  1269,  1269,  1269,  1269,  1270,  1270,  1270,
    1271,  1271,  1272,  1272,  1272,  1272,  1272,  1272,  1273,  1274,
    1275,  1276,  1275,  1277,  1278,  1277,  1279,  1279,  1280,  1280,
    1280,  1281,  1280,  1280,  1282,  1282,  1283,  1283,  1284,  1284,
    1285,  1286,  1286,  1287,  1287,  1287,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1289,  1289,  1290,  1290,  1291,  1291,  1292,  1292,
    1293,  1294,  1294,  1296,  1295,  1297,  1297,  1298,  1299,  1298,
    1300,  1300,  1301,  1301,  1301,  1302,  1302,  1303,  1303,  1303,
    1303,  1303,  1303,  1303,  1303,  1303,  1303,  1304,  1304,  1305,
    1305,  1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,
    1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,
    1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,
    1306,  1307,  1308,  1309,  1309,  1310,  1311,  1312,  1313,  1313,
    1314,  1315,  1315,  1316,  1316,  1317,  1319,  1318,  1320,  1320,
    1320,  1320,  1322,  1321,  1323,  1323,  1324,  1325,  1325,  1325,
    1326,  1328,  1327,  1329,  1329,  1329,  1329,  1330,  1330,  1331,
    1332,  1333,  1333,  1333,  1333,  1334,  1334,  1335,  1335,  1335,
    1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,
    1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,
    1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,
    1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,
    1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,  1335,
    1336,  1337,  1337,  1337,  1337,  1338,  1338,  1339,  1339,  1340,
    1340,  1341,  1342,  1342,  1342,  1342,  1342,  1342,  1342,  1343,
    1343,  1344,  1344,  1345,  1346,  1347,  1347,  1348,  1348,  1348,
    1349,  1349,  1350,  1350,  1351,  1351,  1352,  1352,  1353,  1353,
    1354,  1354,  1355,  1355,  1356,  1355,  1355,  1355,  1357,  1358,
    1358,  1359,  1360,  1360,  1361,  1361,  1362,  1363,  1363,  1364,
    1365,  1366,  1367,  1367,  1367,  1368,  1369,  1370,  1370,  1370,
    1370,  1370,  1371,  1371,  1372,  1373,  1373,  1374,  1375,  1375,
    1376,  1377,  1377,  1378,  1378,  1379,  1379,  1380,  1380,  1381,
    1381,  1382,  1383,  1385,  1384,  1386,  1387,  1387,  1388,  1388,
    1389,  1389,  1389,  1390,  1391,  1392,  1392,  1393,  1393,  1394,
    1395,  1395,  1396,  1396,  1396,  1396,  1397,  1398,  1398,  1399,
    1400,  1400,  1400,  1400,  1400,  1400,  1400,  1401,  1402,  1403,
    1404,  1404,  1405,  1406,  1407,  1408,  1409,  1408,  1410,  1411,
    1412,  1411,  1413,  1414,  1415,  1413,  1416,  1416,  1418,  1419,
    1417,  1420,  1420,  1420,  1421,  1421,  1421,  1421,  1422,  1423,
    1423,  1423,  1424,  1425,  1425,  1426,  1427,  1428,  1428,  1428,
    1429,  1430,  1430,  1431,  1431,  1432,  1432,  1432,  1432,  1432,
    1432,  1433,  1434,  1435,  1436,  1437,  1438,  1438,  1440,  1439,
    1439,  1441,  1441,  1442,  1442,  1442,  1442,  1442,  1442,  1442,
    1442,  1442,  1442,  1442,  1442,  1442,  1442,  1442,  1442,  1442,
    1443,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1445,  1445,
    1445,  1446,  1446,  1447,  1447,  1447,  1447,  1448,  1449,  1449,
    1449,  1450,  1450,  1450,  1451,  1452,  1452,  1452,  1453,  1453,
    1454,  1454,  1454,  1454,  1454,  1455,  1455,  1456,  1456,  1457,
    1457,  1457,  1458,  1459,  1459,  1460,  1461,  1461,  1462,  1462,
    1463,  1464,  1464,  1465,  1465,  1466,  1466,  1467,  1468,  1469,
    1469,  1470,  1470,  1470,  1471,  1471,  1472,  1472,  1473,  1474,
    1475,  1476,  1477,  1478,  1476,  1479,  1479,  1480,  1480,  1481,
    1482,  1481,  1483,  1484,  1481,  1481,  1485,  1485,  1486,  1486,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1487,  1488,  1488,
    1489,  1489,  1490,  1490,  1490,  1490,  1490,  1490,  1490,  1490,
    1490,  1490,  1490,  1490,  1490,  1490,  1490,  1490,  1491,  1491,
    1492,  1492,  1493,  1493,  1494,  1494,  1495,  1495,  1495,  1496,
    1496,  1497,  1497,  1498,  1498,  1498,  1498,  1498,  1498,  1498,
    1498,  1498,  1498,  1498,  1498,  1498,  1498,  1499,  1499,  1499,
    1499,  1499,  1499,  1499,  1499,  1499,  1499,  1499,  1499,  1499,
    1499,  1499,  1500,  1500,  1500,  1500,  1500,  1500,  1500,  1500,
    1500,  1500,  1501,  1501,  1502,  1502,  1502,  1502,  1502,  1503,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1505,  1505,  1505,  1505,  1505,
    1505,  1505,  1505,  1505,  1505,  1506,  1506,  1506,  1506,  1506,
    1506,  1506,  1506,  1506,  1506,  1507,  1507,  1508,  1508,  1509,
    1509,  1510,  1510,  1510,  1510,  1510,  1511,  1511,  1511,  1511,
    1511,  1511,  1511,  1511,  1511,  1511,  1511,  1511,  1511,  1511,
    1511,  1511,  1512,  1512,  1512,  1513,  1513,  1513,  1513,  1513,
    1513,  1513,  1513,  1514,  1514,  1514,  1514,  1514,  1514,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1516,  1516,  1516,
    1516,  1517,  1517,  1517,  1518,  1518,  1518,  1518,  1518,  1518,
    1519,  1519,  1519,  1519,  1520,  1520,  1520,  1520,  1520,  1520,
    1520,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,
    1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,
    1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,
    1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,
    1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1522,  1522,
    1522,  1523,  1523,  1523,  1523,  1523,  1523,  1523,  1523,  1523,
    1524,  1524,  1524,  1524,  1524,  1524,  1524,  1524,  1524,  1524,
    1524,  1524,  1524,  1524,  1524,  1524,  1524,  1524,  1524,  1524,
    1524,  1524,  1524,  1525,  1526,  1527,  1527,  1527,  1527,  1527,
    1527,  1527,  1527,  1528,  1528,  1528,  1529,  1529,  1530,  1531,
    1531,  1532,  1532,  1533,  1533,  1534,  1534,  1534,  1535,  1535,
    1536,  1536,  1537,  1537,  1538,  1539,  1539,  1540,  1541,  1541,
    1542,  1543,  1543,  1544,  1544,  1545,  1546,  1546,  1546,  1547,
    1548,  1548,  1548,  1549,  1550,  1551,  1551,  1552,  1552,  1554,
    1555,  1556,  1557,  1553,  1558,  1553,  1559,  1560,  1559,  1561,
    1559,  1562,  1562,  1563,  1564,  1564,  1564,  1565,  1565,  1566,
    1566,  1566,  1566,  1566,  1567,  1568,  1568,  1569,  1569,  1570,
    1570,  1570,  1571,  1572,  1573,  1574,  1571,  1575,  1575,  1576,
    1576,  1577,  1576,  1576,  1576,  1578,  1578,  1580,  1579,  1581,
    1581,  1582,  1583,  1584,  1584,  1586,  1587,  1585,  1589,  1588,
    1588,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,
    1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,
    1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,
    1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,
    1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,
    1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,  1590,
    1590,  1590,  1590,  1590,  1590,  1590,  1591,  1590,  1590,  1593,
    1592,  1595,  1594,  1596,  1594,  1594,  1594,  1594,  1594,  1594,
    1594,  1594,  1594,  1594,  1594,  1594,  1594,  1594,  1594,  1594,
    1594,  1594,  1594,  1594,  1594,  1594,  1594,  1594,  1594,  1597,
    1597,  1599,  1598,  1600,  1600,  1601,  1601,  1601,  1602,  1602,
    1602,  1603,  1603,  1604,  1604,  1605,  1605,  1606,  1606,  1606,
    1606,  1606,  1607,  1607,  1608,  1608,  1609,  1609,  1610,  1610,
    1610,  1611,  1612,  1613,  1614,  1614,  1614,  1614,  1614,  1614,
    1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,
    1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,
    1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,  1614,
    1615,  1615,  1616,  1617,  1617,  1617,  1618,  1618,  1618,  1619,
    1619,  1620,  1620,  1622,  1621,  1623,  1623,  1623,  1623,  1624,
    1624,  1625,  1625,  1627,  1626,  1628,  1628,  1629,  1629,  1630,
    1630,  1632,  1631,  1633,  1633,  1634,  1635,  1635,  1637,  1636,
    1639,  1638,  1640,  1641,  1640,  1642,  1642,  1642,  1643,  1643,
    1644,  1644,  1644,  1644,  1644,  1644,  1644,  1645,  1645,  1646,
    1646,  1647,  1647,  1648,  1649,  1648,  1650,  1650,  1651,  1651,
    1651,  1652,  1652,  1652,  1652,  1653,  1653,  1653,  1653,  1653,
    1654,  1654,  1655,  1655,  1656,  1656,  1656,  1657,  1657,  1658,
    1658,  1659,  1659,  1660,  1661,  1661,  1663,  1662,  1664,  1664,
    1665,  1665,  1666,  1666,  1668,  1667,  1669,  1669,  1670,  1670,
    1671,  1671,  1671,  1671,  1671,  1673,  1672,  1674,  1674,  1676,
    1675,  1677,  1678,  1678,  1679,  1681,  1680,  1682,  1683,  1682,
    1685,  1684,  1686,  1686,  1688,  1687,  1689,  1689,  1690,  1690,
    1691,  1691,  1693,  1692,  1694,  1695,  1695,  1696,  1696,  1696,
    1696,  1696,  1698,  1697,  1699,  1699,  1699,  1699,  1699,  1699,
    1699,  1699,  1699,  1699,  1699,  1699,  1700,  1700,  1701,  1701,
    1703,  1702,  1704,  1704,  1705,  1705,  1706,  1706,  1707,  1707,
    1708,  1708,  1708,  1708,  1708,  1709,  1709,  1710,  1710,  1710,
    1710,  1711,  1711,  1713,  1712,  1714,  1716,  1715,  1717,  1717,
    1718,  1718,  1718,  1720,  1719,  1721,  1721,  1722,  1722,  1723,
    1723,  1723,  1723,  1723,  1725,  1726,  1724,  1727,  1727,  1729,
    1730,  1728,  1732,  1731,  1733,  1733,  1733,  1734,  1734,  1735,
    1735,  1736,  1736,  1736,  1737,  1737,  1738,  1738,  1738,  1738,
    1738,  1738,  1738,  1738,  1739,  1740,  1741,  1741,  1741,  1742,
    1742,  1742,  1742,  1743,  1743,  1744,  1744,  1745,  1746,  1747,
    1747,  1747,  1747,  1747,  1747,  1747,  1747,  1747,  1747,  1747,
    1747,  1747,  1747,  1747,  1747,  1747,  1747,  1747,  1747,  1747,
    1747,  1747,  1748,  1748,  1750,  1749,  1751,  1751,  1751,  1751,
    1751,  1752,  1752,  1754,  1753,  1755,  1757,  1756,  1758,  1756,
    1759,  1760,  1762,  1761,  1763,  1764,  1764,  1765,  1765,  1765,
    1766,  1766,  1767,  1767,  1768,  1768,  1768,  1769,  1769,  1769,
    1771,  1770,  1772,  1770,  1773,  1773,  1774,  1774,  1774,  1774,
    1774,  1775,  1775,  1776,  1776,  1778,  1777,  1780,  1779,  1781,
    1781,  1782,  1782,  1783,  1783,  1784,  1784,  1785,  1785,  1787,
    1786,  1788,  1788,  1788,  1788,  1788,  1788,  1788,  1789,  1789,
    1789,  1789,  1791,  1790,  1792,  1794,  1793,  1795,  1797,  1796,
    1798,  1798,  1799,  1799,  1801,  1800,  1803,  1802,  1804,  1804,
    1804,  1805,  1805,  1806,  1807,  1808,  1808,  1810,  1809,  1811,
    1812,  1812,  1813,  1813,  1813,  1814,  1814,  1815,  1815,  1816,
    1817,  1817,  1817,  1817,  1817,  1817,  1817,  1818,  1818,  1820,
    1819,  1821,  1821,  1823,  1822,  1824,  1824,  1826,  1825,  1827,
    1828,  1828,  1829,  1829,  1829,  1830,  1830,  1830,  1830,  1832,
    1831,  1834,  1833,  1833,  1835,  1835,  1835,  1836,  1836,  1836,
    1836,  1837,  1837,  1838,  1838,  1840,  1839,  1841,  1842,  1843,
    1843,  1844,  1844,  1844,  1844,  1844,  1844,  1845,  1845,  1846,
    1846,  1847,  1847,  1847,  1847,  1847,  1848,  1849,  1849,  1849,
    1849,  1849,  1850,  1851,  1852,  1854,  1853,  1856,  1857,  1855,
    1858,  1858,  1859,  1859,  1860,  1861,  1861,  1863,  1862,  1864,
    1865,  1865,  1867,  1866,  1869,  1868,  1870,  1870,  1871,  1871,
    1873,  1872,  1874,  1874,  1876,  1875,  1877,  1877,  1878,  1878,
    1880,  1879,  1881,  1881,  1882,  1883,  1883,  1884,  1884,  1884,
    1884,  1885,  1885,  1886,  1886,  1886,  1886,  1886,  1887,  1887,
    1888,  1888,  1888,  1889,  1889,  1889,  1890,  1890,  1890,  1891,
    1891,  1892,  1892,  1892,  1894,  1893,  1895,  1896,  1895,  1897,
    1895,  1898,  1898,  1899,  1899,  1900,  1900,  1901,  1901,  1901,
    1901,  1901,  1902,  1902,  1903,  1903,  1904,  1904,  1905,  1906,
    1906,  1908,  1907,  1910,  1909,  1911,  1911,  1912,  1914,  1913,
    1915,  1916,  1916,  1917,  1917,  1917,  1917,  1918,  1918,  1919,
    1919,  1920,  1920,  1921,  1922,  1922,  1922,  1923,  1923,  1924,
    1924,  1924,  1925,  1925,  1926,  1926,  1927,  1927,  1928,  1930,
    1929,  1931,  1932,  1932,  1933,  1933,  1933,  1934,  1934,  1935,
    1936,  1936,  1937,  1938,  1938,  1940,  1939,  1941,  1942,  1944,
    1943,  1945,  1946,  1946,  1948,  1947,  1949,  1950,  1950,  1951,
    1951,  1952,  1952,  1953,  1954,  1956,  1955,  1957,  1955,  1958,
    1959,  1960,  1960,  1961,  1961,  1962,  1963,  1963,  1964,  1965,
    1965,  1966,  1968,  1967,  1969,  1969,  1970,  1971,  1972,  1972,
    1973,  1974,  1974,  1975,  1975,  1975,  1975,  1976,  1976,  1978,
    1977,  1979,  1979,  1979,  1979,  1979,  1979,  1979,  1979,  1980,
    1980,  1981,  1981,  1982,  1983,  1984,  1984,  1985,  1985,  1985,
    1985,  1985,  1985,  1985,  1985,  1986,  1986,  1986,  1986,  1986,
    1987,  1988,  1988,  1989,  1990,  1990,  1991,  1991,  1992,  1993,
    1995,  1994,  1997,  1996,  1998,  1998,  1999,  1999,  2000,  2000,
    2001,  2001,  2002,  2002,  2002,  2003,  2003,  2003,  2005,  2004,
    2006,  2007,  2007,  2008,  2008,  2008,  2008,  2009,  2009,  2009,
    2009,  2009,  2009,  2010,  2010,  2011,  2011,  2012,  2014,  2013,
    2013,  2013,  2013,  2015,  2015,  2015,  2015,  2015,  2016,  2016,
    2017,  2017,  2018,  2018,  2018,  2018,  2020,  2019,  2021,  2023,
    2022,  2024,  2024,  2025,  2026,  2026,  2027,  2027,  2028,  2028,
    2029,  2029,  2031,  2030,  2032,  2032,  2032,  2032,  2033,  2033,
    2035,  2034,  2036,  2036,  2038,  2037,  2039,  2039,  2041,  2040,
    2042,  2044,  2043,  2045,  2047,  2046,  2048,  2049,  2049,  2050,
    2050,  2051,  2052,  2052,  2053,  2054,  2054,  2055,  2055,  2056,
    2056,  2058,  2057,  2059,  2059,  2061,  2060,  2062,  2062,  2062,
    2062,  2062,  2063,  2064,  2064,  2065,  2065,  2065,  2065,  2065,
    2066,  2067,  2067,  2068,  2068,  2068,  2069,  2069,  2069,  2069,
    2070,  2071,  2071,  2072,  2073,  2074,  2074,  2075,  2075,  2076,
    2076,  2078,  2077,  2079,  2080,  2080,  2081,  2081,  2081,  2081,
    2082,  2082,  2083,  2083,  2083,  2084,  2084,  2085,  2087,  2086,
    2089,  2090,  2088,  2091,  2091,  2092,  2092,  2093,  2094,  2094,
    2094,  2095,  2095,  2096,  2096,  2097,  2097,  2098,  2098,  2099,
    2100,  2100,  2101,  2101,  2102,  2102,  2103,  2103,  2104,  2104,
    2105,  2106,  2106,  2107,  2107,  2107,  2108,  2108,  2109,  2109,
    2110,  2110,  2110,  2111,  2111,  2111,  2112,  2112,  2113,  2113,
    2115,  2114,  2117,  2116,  2118,  2118,  2119,  2119,  2120,  2120,
    2121,  2121,  2122,  2122,  2122,  2123,  2123,  2124,  2125,  2125,
    2126,  2126,  2127,  2128,  2128,  2129,  2129,  2129,  2130,  2130,
    2131,  2132,  2132,  2133,  2134,  2134,  2134,  2135,  2135,  2136,
    2137,  2137,  2138,  2139,  2139,  2139,  2140,  2140,  2141,  2142,
    2142,  2143,  2144,  2144,  2145,  2145,  2146,  2146,  2147,  2148,
    2148,  2149,  2150,  2150,  2151,  2151,  2152,  2153,  2153,  2154,
    2155,  2155,  2156,  2156,  2157,  2157,  2158,  2159,  2159,  2160,
    2161,  2161,  2162,  2162,  2163,  2163,  2164,  2164,  2165,  2165,
    2166,  2166,  2167,  2169,  2168,  2170,  2170,  2171,  2171,  2171,
    2171,  2171,  2171,  2171,  2171,  2171,  2171,  2171,  2171,  2171,
    2171,  2171,  2171,  2171,  2171,  2171,  2171,  2171,  2171,  2172,
    2172,  2173,  2175,  2174,  2176,  2176,  2177,  2177,  2177,  2177,
    2177,  2177,  2177,  2177,  2177,  2177,  2177,  2177,  2177,  2177,
    2177,  2177,  2177,  2177,  2177,  2177,  2177,  2178,  2178,  2179,
    2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,
    2180,  2180,  2180,  2180,  2181,  2181,  2182,  2182,  2183,  2183,
    2184,  2185,  2186,  2186,  2187,  2187,  2187,  2188,  2188,  2188,
    2189,  2189,  2189,  2189,  2189,  2189,  2189,  2189,  2189,  2189,
    2190,  2190,  2191,  2191,  2191,  2191,  2192,  2192,  2193,  2193,
    2193,  2193,  2193,  2193,  2194,  2194,  2195,  2196,  2197,  2197,
    2198,  2199,  2199,  2200,  2200,  2201,  2202,  2203,  2204,  2204,
    2205,  2206,  2206,  2207,  2208,  2208,  2209,  2210,  2210,  2210,
    2211,  2212,  2212,  2213,  2214,  2214,  2215,  2215,  2216,  2217,
    2217,  2218,  2219,  2219,  2220,  2220,  2221,  2222,  2222,  2223,
    2223,  2223,  2224,  2224,  2225,  2225,  2226,  2226,  2227,  2227,
    2228,  2228,  2228,  2228,  2228,  2228,  2228,  2228,  2228,  2229,
    2230,  2230,  2231,  2231,  2231,  2232,  2232,  2232,  2232,  2232,
    2232,  2232,  2233,  2233,  2233,  2233,  2233,  2233,  2234,  2235,
    2236,  2237,  2237,  2238,  2238,  2239,  2240,  2240,  2241,  2241,
    2242,  2242,  2242,  2243,  2243,  2244,  2244,  2245,  2245,  2245,
    2246,  2246,  2246,  2247,  2247,  2247,  2248,  2248,  2249,  2249,
    2250,  2250,  2251,  2251,  2251,  2252,  2253,  2254,  2254,  2255,
    2256,  2257,  2258,  2259,  2260,  2261,  2261,  2261,  2261,  2262,
    2262,  2263,  2263,  2264,  2265,  2265,  2266,  2266,  2266,  2266,
    2267,  2267,  2268,  2269,  2269,  2271,  2270,  2272,  2272,  2273,
    2274,  2274,  2275,  2276,  2277,  2278,  2278,  2279,  2279,  2280,
    2280,  2280,  2280,  2280,  2280,  2281,  2281,  2282,  2282,  2283,
    2283,  2284,  2284,  2284,  2284,  2285,  2285,  2285,  2285,  2285,
    2285,  2285,  2285,  2285,  2285,  2285,  2285,  2285,  2285,  2286,
    2286,  2287,  2287,  2287,  2287,  2288,  2288,  2288,  2288,  2288,
    2289,  2289,  2289,  2290,  2290,  2290,  2291,  2291,  2291,  2293,
    2292,  2294,  2294,  2295,  2295,  2296,  2296,  2297,  2297,  2298,
    2299,  2299,  2300,  2300,  2300,  2301,  2301,  2302,  2302,  2303,
    2303,  2304,  2304,  2304,  2305,  2305,  2306,  2306,  2306,  2307,
    2307,  2308,  2308,  2309,  2309,  2309,  2309,  2309,  2309,  2309,
    2309,  2310,  2310,  2311,  2311,  2312,  2312,  2313,  2313,  2313,
    2313,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,
    2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,
    2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,
    2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,
    2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,  2314,
    2314,  2314,  2314,  2315,  2315,  2315,  2315,  2315,  2315,  2315,
    2315,  2315,  2315,  2315,  2315,  2315,  2315,  2315,  2315,  2315,
    2315,  2315,  2315,  2315,  2315,  2315,  2316,  2316,  2317,  2317,
    2318,  2319,  2319,  2319,  2320,  2321,  2322,  2323,  2323,  2323,
    2324,  2324,  2324,  2324,  2325,  2325,  2325,  2326,  2326,  2326,
    2326,  2326,  2326,  2326,  2327,  2327,  2327,  2328,  2328,  2329,
    2329,  2330,  2330,  2331,  2331,  2332,  2332,  2332,  2333,  2333,
    2334,  2334,  2335,  2335,  2336,  2336,  2337,  2337,  2338,  2338,
    2339,  2339,  2340,  2340,  2341,  2341,  2342,  2342,  2343,  2343,
    2344,  2344,  2345,  2345,  2346,  2346,  2347,  2347,  2348,  2348,
    2349,  2349,  2350,  2350,  2351,  2351,  2352,  2352,  2352,  2353,
    2353,  2353,  2354,  2354,  2355,  2355,  2356,  2356,  2357,  2357,
    2358,  2358,  2359,  2359,  2359,  2360,  2360,  2360,  2361,  2361,
    2361,  2361,  2362,  2362,  2362,  2363,  2363,  2364,  2364,  2365,
    2365,  2365,  2366,  2366,  2366,  2367,  2367,  2368,  2368,  2369,
    2369,  2370,  2370,  2371,  2371,  2372,  2372,  2373,  2373,  2374,
    2374,  2375,  2375,  2376,  2376,  2376,  2377,  2377,  2377,  2377,
    2378,  2378,  2379,  2379,  2380,  2380,  2381,  2381,  2382,  2382,
    2383,  2383,  2384,  2384,  2384,  2385,  2385,  2386,  2386,  2387,
    2387,  2388,  2388,  2388,  2389,  2389,  2390,  2390,  2391,  2391,
    2392,  2392,  2393,  2393,  2394,  2394,  2395,  2395,  2396,  2396,
    2397,  2397,  2398,  2398,  2399,  2399,  2400,  2400,  2401,  2401,
    2402,  2402,  2402,  2403,  2403,  2404,  2404,  2405,  2405,  2406,
    2406,  2407,  2407,  2408,  2408,  2409,  2409,  2410,  2410,  2410,
    2410,  2411,  2411,  2412,  2412,  2413,  2413,  2414,  2414,  2415,
    2415,  2416,  2416,  2417,  2417,  2418,  2418,  2418,  2419,  2419,
    2420,  2420,  2421,  2421,  2422,  2422,  2423,  2423,  2424,  2424,
    2425,  2425,  2426,  2426,  2427,  2427,  2428,  2428,  2429,  2429,
    2430,  2430,  2431,  2431,  2432,  2432
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     3,     1,     2,
       1,     1,     1,     1,     0,     2,     4,     4,     0,     1,
       1,     2,     0,     4,     0,     4,     0,     0,    14,     0,
       0,    14,     0,     0,     6,     1,     0,     0,     5,     0,
       0,     5,     0,     3,     0,     0,     4,     0,     0,     4,
       0,     0,     6,     0,     1,     0,     4,     1,     1,     1,
       6,     1,     5,     1,     1,     1,     1,     0,     2,     0,
       3,     1,     1,     1,     1,     2,     2,     1,     1,     0,
       3,     5,     0,     3,     1,     1,     1,     1,     0,     5,
       0,     3,     1,     1,     1,     0,     4,     1,     1,     1,
       1,     3,     0,     1,     1,     3,     2,     0,     1,     1,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       0,     1,     0,     4,     0,     3,     0,     3,     0,     4,
       0,     2,     3,     2,     1,     2,     1,     1,     1,     1,
       5,     2,     0,     4,     2,     3,     4,     4,     8,     8,
       3,     4,     1,     1,     1,     1,     1,     2,     0,     1,
       0,     4,     0,     2,     3,     1,     2,     3,     3,     3,
       3,     3,     1,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     3,     1,     1,     2,     3,
       3,     1,     0,     1,     1,     3,     4,     0,     4,     0,
       4,     0,     4,     0,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     2,
       1,     3,     0,     4,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     2,     0,     2,     2,
       4,     1,     2,     3,     1,     2,     1,     2,     3,     1,
       2,     3,     6,     1,     2,     1,     3,     4,     0,     4,
       1,     1,     5,     0,     3,     3,     5,     3,     4,     3,
       3,     0,     4,     4,     1,     0,     3,     0,     2,     0,
       2,     0,     0,     6,     2,     2,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     5,     5,
       6,     6,     4,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     0,     1,     1,     1,     1,
       1,     4,     1,     1,     1,     9,     0,     1,     0,     4,
       1,     0,     4,     3,     1,     0,     4,     2,     3,     4,
       4,     8,     8,     6,     1,     1,     1,     1,     1,     5,
       0,     1,     1,     0,     5,     2,     2,     2,     0,     5,
       6,     1,     0,     1,     2,     0,     2,     3,     1,     1,
       3,     1,     2,     4,     0,     5,     1,     1,     1,     1,
       7,     0,     2,     1,     2,     0,     2,     2,     1,     4,
       3,     1,     1,     3,     2,     2,     2,     3,     3,     4,
       4,     4,     4,     4,     0,     2,     2,     0,     2,     3,
       1,     2,     1,     1,     1,     1,     5,     0,     1,     1,
       1,     4,     4,     4,     4,     1,     6,     6,     7,     4,
       6,     4,     6,     4,     0,     6,     1,     2,     2,     0,
       2,     6,     2,     2,     3,     0,     1,     5,     2,     0,
       1,     2,     3,     1,     2,     1,     1,     1,     0,    10,
       0,     1,     1,     3,     1,     0,     3,     0,     2,     2,
       0,     5,     3,     1,     1,     0,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     5,     0,
       1,     1,     4,     7,     9,     0,     3,     0,     2,     0,
       2,     3,     5,     5,     1,     1,     1,     1,     3,     5,
       0,     2,     1,     1,     1,     4,     2,     2,     4,     1,
       1,     1,     1,     1,     1,     1,     4,     0,     2,     2,
       2,     2,     1,     2,     1,     0,     0,     5,     0,     2,
       2,     1,     0,     5,     0,     2,     4,     3,     4,     0,
       1,     1,     1,     2,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,    11,     0,     1,     1,     2,
       4,     4,     4,     6,     4,     3,     4,     0,     1,     1,
       1,     2,     4,     4,     4,     4,     4,     4,     6,     1,
       0,     0,     5,     0,     0,     2,     2,     3,     1,     1,
       1,     0,     4,     3,     2,     2,     0,     1,     1,     1,
       1,     0,     2,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       6,     0,     2,     0,     4,     0,     1,     5,     0,     7,
       2,     2,     1,     3,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     0,     1,     3,     3,     3,     0,     1,
       3,     0,     2,     0,     1,     2,     0,     4,     1,     2,
       1,     1,     0,     4,     1,     1,     3,     1,     1,     1,
       1,     0,     3,     0,     5,     3,     1,     0,     2,     1,
       3,     2,     3,     3,     3,     0,     2,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       4,     3,     3,     3,     4,     3,     3,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       3,     0,     1,     2,     3,     0,     2,     0,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     0,
       1,     3,     3,     2,     6,     0,     2,     6,     8,     7,
       0,     2,     0,     2,     0,     2,     0,     3,     0,     3,
       0,     1,     0,     2,     0,     3,     1,     1,     1,     1,
       2,     4,     1,     1,     0,     1,     3,     1,     2,     1,
       2,     2,     0,     1,     1,     3,     1,     3,     3,     4,
       4,     3,     1,     2,     3,     4,     4,     2,     0,     2,
       3,     0,     1,     3,     3,     1,     3,     2,     2,     1,
       2,     1,     2,     0,     4,     1,     1,     2,     3,     1,
       0,     1,     1,     4,     3,     1,     1,     0,     2,     7,
       2,     3,     0,     2,     2,     2,     3,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       2,     2,     2,     4,     1,     0,     0,     5,     1,     0,
       0,     5,     0,     0,     0,     6,     0,     2,     0,     0,
       7,     0,     2,     2,     2,     4,     1,     1,     2,     2,
       1,     1,     1,     1,     2,     1,     4,     2,     1,     3,
       2,     1,     1,     0,     2,     1,     1,     1,     1,     1,
       3,     3,     4,     4,     4,     3,     0,     2,     0,     5,
       3,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     3,     3,     1,     1,     1,     0,     2,
       2,     0,     2,     0,     2,     2,     1,     3,     1,     2,
       1,     1,     1,     1,     4,     0,     3,     2,     1,     1,
       3,     4,     5,     4,     5,     1,     1,     0,     2,     1,
       1,     1,     2,     1,     2,     3,     0,     2,     0,     2,
       2,     3,     2,     0,     2,     1,     2,     2,     4,     0,
       1,     1,     1,     1,     2,     1,     1,     2,     1,     4,
       2,     0,     0,     0,     6,     0,     1,     2,     3,     1,
       0,     4,     0,     0,     7,     3,     0,     2,     2,     2,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     1,     1,     2,     3,
       2,     2,     2,     3,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     0,     2,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     2,     1,     3,     5,     3,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     3,     1,     2,     3,     3,     3,     1,     2,
       1,     2,     0,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     0,     1,     4,     0,     1,     1,     4,
       0,     1,     1,     3,     2,     0,     2,     0,     1,     0,
       0,     0,     0,    13,     0,     4,     0,     0,     3,     0,
       3,     1,     2,     5,     0,     2,     2,     0,     1,     3,
       3,     4,     2,     1,     3,     0,     5,     0,     1,     0,
       2,     2,     0,     0,     0,     0,     9,     0,     2,     1,
       1,     0,     3,     1,     1,     1,     1,     0,     6,     0,
       2,     2,     2,     0,     1,     0,     0,     3,     0,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     3,     2,     0,
       4,     0,     4,     0,     5,     3,     3,     3,     3,     4,
       3,     4,     3,     3,     4,     4,     4,     3,     3,     4,
       3,     4,     5,     3,     4,     3,     3,     2,     3,     1,
       1,     0,     3,     0,     1,     5,     4,     4,     1,     3,
       3,     1,     1,     0,     1,     1,     2,     1,     1,     1,
       2,     3,     1,     2,     1,     3,     1,     2,     2,     2,
       2,     3,     3,     3,     1,     1,     1,     2,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     1,     1,     1,     1,     4,     1,
       2,     1,     1,     3,     3,     3,     3,     3,     3,     4,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     0,     4,     4,     5,     6,     8,     0,
       2,     0,     1,     0,     3,     4,     5,     0,     2,     0,
       2,     0,     3,     1,     2,     4,     0,     2,     0,     4,
       0,     9,     0,     0,     4,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       2,     1,     1,     0,     0,     3,     1,     2,     2,     2,
       3,     0,     2,     2,     2,     0,     3,     2,     2,     4,
       1,     1,     1,     1,     0,     2,     2,     0,     1,     2,
       2,     0,     1,     2,     0,     1,     0,     3,     1,     1,
       1,     2,     1,     1,     0,     3,     1,     1,     2,     3,
       0,     1,     3,     3,     2,     0,     4,     0,     3,     0,
       4,     4,     0,     1,     1,     0,     3,     0,     0,     4,
       0,     3,     2,     1,     0,     4,     4,     3,     1,     2,
       0,     1,     0,     3,     3,     0,     3,     0,     2,     1,
       2,     1,     0,     4,     3,     3,     3,     3,     2,     4,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     2,
       0,     3,     1,     1,     0,     2,     1,     2,     1,     2,
       1,     2,     1,     1,     2,     0,     1,     2,     2,     2,
       2,     1,     1,     0,     3,     2,     0,     3,     1,     2,
       1,     1,     1,     0,     5,     0,     1,     1,     2,     3,
       3,     3,     3,     2,     0,     0,     5,     1,     1,     0,
       0,     7,     0,     5,     1,     1,     1,     0,     1,     0,
       2,     1,     2,     1,     1,     2,     1,     2,     1,     5,
       1,     1,     1,     2,     1,     1,     0,     1,     1,     1,
       1,     0,     1,     3,     3,     1,     1,     4,     3,     1,
       2,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     3,     3,     3,
       3,     3,     0,     1,     0,     4,     4,     6,     6,     8,
       8,     0,     1,     0,     3,     1,     0,     3,     0,     6,
       4,     1,     0,     4,     2,     1,     3,     1,     1,     1,
       2,     1,     1,     2,     2,     2,     2,     3,     3,     3,
       0,     3,     0,     4,     1,     3,     2,     1,     1,     1,
       1,     0,     2,     0,     1,     0,     3,     0,     7,     0,
       1,     0,     1,     0,     1,     1,     2,     1,     1,     0,
       3,     0,     2,     1,     2,     1,     1,     1,     0,     2,
       2,     3,     0,     3,     1,     0,     3,     1,     0,     3,
       3,     4,     0,     3,     0,     3,     0,     6,     5,     3,
       2,     0,     1,     0,     0,     0,     1,     0,     3,     5,
       0,     2,     0,     3,     3,     0,     2,     1,     2,     4,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     0,
       3,     1,     2,     0,     3,     2,     2,     0,     3,     3,
       0,     1,     1,     1,     1,     2,     1,     1,     1,     0,
       4,     0,     5,     5,     1,     1,     2,     1,     1,     1,
       2,     0,     3,     1,     1,     0,     3,     2,     5,     1,
       2,     2,     2,     1,     1,     1,     2,     1,     2,     4,
       2,     0,     1,     1,     1,     1,     4,     0,     1,     1,
       2,     2,     3,     3,     1,     0,     5,     0,     0,     9,
       0,     2,     1,     2,     1,     0,     1,     0,     5,     7,
       0,     2,     0,     3,     0,     4,     2,     2,     0,     1,
       0,     3,     3,     4,     0,     4,     4,     6,     0,     1,
       0,     3,     1,     2,     6,     0,     1,     1,     1,     1,
       1,     0,     3,     0,     1,     1,     2,     1,     2,     2,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     3,
       1,     1,     1,     1,     0,     3,     4,     0,     6,     0,
       5,     0,     1,     1,     1,     1,     3,     0,     2,     1,
       3,     3,     0,     3,     1,     1,     1,     3,     6,     0,
       2,     0,     3,     0,     3,     2,     1,     1,     0,     4,
       7,     0,     2,     0,     1,     2,     1,     2,     3,     3,
       1,     0,     1,     1,     4,     4,     2,     0,     1,     1,
       3,     2,     0,     3,     1,     1,     0,     1,     1,     0,
       4,     5,     1,     1,     0,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     1,     0,     3,     2,     1,     0,
       4,     4,     0,     1,     0,     4,     5,     0,     1,     2,
       3,     0,     1,     1,     1,     0,     4,     0,     5,     4,
       5,     0,     2,     0,     3,     0,     1,     2,     3,     0,
       2,     0,     0,     3,     2,     1,     5,     1,     0,     1,
       2,     2,     5,     2,     2,     2,     2,     0,     2,     0,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     3,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     4,     7,     7,     3,     5,
       4,     1,     2,     3,     1,     2,     3,     3,     4,     4,
       0,     3,     0,     7,     0,     5,     0,     2,     0,     3,
       0,     1,     0,     2,     4,     0,     2,     4,     0,     4,
       4,     0,     3,     0,     4,     1,     1,     1,     2,     2,
       2,     2,     1,     2,     1,     0,     1,     1,     0,     4,
       2,     2,     2,     0,     2,     1,     4,     4,     0,     1,
       1,     1,     1,     1,     1,     1,     0,     4,     5,     0,
       2,     1,     2,     2,     0,     3,     1,     1,     0,     4,
       0,     1,     0,     4,     4,     6,     6,     8,     0,     1,
       0,     3,     0,     1,     0,     3,     1,     2,     0,     3,
       6,     0,     3,     2,     0,     4,     6,     0,     3,     1,
       3,     2,     2,     2,     3,     0,     3,     0,     3,     0,
       1,     0,     3,     1,     2,     0,     3,     1,     1,     1,
       1,     1,     7,     0,     1,     1,     1,     1,     1,     1,
       4,     1,     2,     1,     2,     3,     0,     1,     2,     1,
       3,     1,     1,     4,     2,     1,     2,     1,     2,     1,
       1,     0,     4,     6,     0,     2,     0,     4,     3,     3,
       1,     1,     0,     1,     1,     0,     1,     1,     0,     5,
       0,     0,    12,     0,     1,     1,     2,     2,     2,     1,
       1,     0,     4,     0,     3,     0,     3,     1,     2,     3,
       0,     3,     1,     2,     3,     3,     0,     3,     1,     2,
       3,     0,     1,     1,     1,     1,     0,     2,     1,     2,
       1,     2,     2,     2,     2,     1,     1,     3,     0,     1,
       0,     5,     0,    10,     0,     3,     0,     2,     0,     3,
       1,     2,     0,     2,     2,     0,     1,     3,     1,     1,
       0,     1,     2,     1,     1,     0,     2,     2,     0,     1,
       2,     0,     1,     2,     0,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     2,     2,     0,     1,     2,     0,
       1,     2,     2,     2,     2,     2,     0,     1,     2,     0,
       1,     2,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     1,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     2,     0,     3,     2,     1,     0,     2,     0,     3,
       1,     1,     1,     0,     2,     1,     2,     1,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     2,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     0,     1,     1,     3,     3,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       3,     1,     2,     2,     2,     1,     3,     1,     1,     3,
       1,     3,     1,     3,     1,     2,     2,     1,     1,     2,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     2,
       1,     1,     2,     1,     0,     2,     1,     1,     1,     3,
       1,     1,     2,     1,     0,     1,     1,     2,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     3,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     4,     3,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     3,     2,     2,     1,     1,
       2,     1,     2,     1,     1,     1,     3,     2,     2,     1,
       0,     1,     1,     1,     3,     0,     2,     1,     3,     3,
       4,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     2,     5,     5,     5,     5,
       6,     5,     5,     5,     5,     5,     5,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     4,     5,     0,     3,     2,     1,     3,     3,     0,
       2,     1,     3,     1,     3,     1,     3,     1,     3,     0,
       0,     1,     0,     3,     2,     0,     1,     0,     2,     0,
       2,     0,     1,     1,     0,     1,     0,     1,     2,     0,
       2,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     0,     5,     0,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     3,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       1,     2,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     1,     1,     0,     1,
       1,     1,     0,     1,     1,     0,     1,     0,     1,     0,
       1,     1,     0,     2,     2,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     1,     0,
       1,     0,     1,     0,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     2,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     3,     0,     1,
       0,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     2,     1,     2,     1,     2,     1,
       2,     1,     2,     1,     2,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= TOKEN_EOF)
    {
      yychar = TOKEN_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 3449 "../../cobc/parser.y"
  {
	clear_initial_values ();
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;

	current_program = cb_build_program (NULL, 0);

	backup_source_file = cb_source_file;
	cb_source_file = "register-definition";
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
	cb_source_file = backup_source_file;
  }
#line 14869 "parser.c"
    break;

  case 3: /* start: $@1 compilation_group  */
#line 3465 "../../cobc/parser.y"
  {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		emit_main_entry (current_program, NULL);
	}
  }
#line 14892 "parser.c"
    break;

  case 6: /* $@2: %empty  */
#line 3491 "../../cobc/parser.y"
  {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 14902 "parser.c"
    break;

  case 14: /* $@3: %empty  */
#line 3513 "../../cobc/parser.y"
  {
	program_init_without_program_id ();
  }
#line 14910 "parser.c"
    break;

  case 15: /* simple_prog: $@3 _program_body  */
#line 3518 "../../cobc/parser.y"
  {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 14919 "parser.c"
    break;

  case 18: /* _end_program_list: %empty  */
#line 3544 "../../cobc/parser.y"
  {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 14928 "parser.c"
    break;

  case 22: /* $@4: %empty  */
#line 3558 "../../cobc/parser.y"
  {
	check_area_a_of ("END PROGRAM");
	backup_current_pos ();
  }
#line 14937 "parser.c"
    break;

  case 23: /* end_program: "END PROGRAM" $@4 end_program_name _dot  */
#line 3563 "../../cobc/parser.y"
  {
	first_nested_program = 0;
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_PROGRAM);
  }
#line 14946 "parser.c"
    break;

  case 24: /* $@5: %empty  */
#line 3571 "../../cobc/parser.y"
  {
	backup_current_pos ();
  }
#line 14954 "parser.c"
    break;

  case 25: /* end_function: "END FUNCTION" $@5 end_program_name _dot  */
#line 3575 "../../cobc/parser.y"
  {
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_FUNCTION);
  }
#line 14962 "parser.c"
    break;

  case 26: /* $@6: %empty  */
#line 3585 "../../cobc/parser.y"
  {
	/* Error if program_id_name is a literal */

	/* Check that we either have no previous program or it was also a prototype */
	if (current_program->next_program && !current_program->flag_prototype) {
		/* Technically, prototypes must come before all other *source units*.  */
		cb_error (_("prototypes must be come before any program/function definitions"));
	}

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("PROGRAM PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 15001 "parser.c"
    break;

  case 27: /* $@7: %empty  */
#line 3620 "../../cobc/parser.y"
  {
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 15011 "parser.c"
    break;

  case 28: /* program_prototype: _identification_header program_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@6 _prototype_environment_division $@7 _prototype_data_division _prototype_procedure_division_header end_program  */
#line 3628 "../../cobc/parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 15021 "parser.c"
    break;

  case 29: /* $@8: %empty  */
#line 3640 "../../cobc/parser.y"
  {
	/* Error if program_id_name is a literal */

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("FUNCTION PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 15054 "parser.c"
    break;

  case 30: /* $@9: %empty  */
#line 3669 "../../cobc/parser.y"
  {
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 15064 "parser.c"
    break;

  case 31: /* function_prototype: _identification_header function_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@8 _prototype_environment_division $@9 _prototype_data_division _prototype_procedure_division_header end_function  */
#line 3677 "../../cobc/parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 15074 "parser.c"
    break;

  case 33: /* $@10: %empty  */
#line 3686 "../../cobc/parser.y"
            { check_area_a_of ("PROCEDURE DIVISION"); }
#line 15080 "parser.c"
    break;

  case 34: /* _prototype_procedure_division_header: PROCEDURE $@10 DIVISION _procedure_using_chaining _procedure_returning _dot  */
#line 3688 "../../cobc/parser.y"
  {
	cb_validate_parameters_and_returning (current_program, yyvsp[-2]);
	current_program->num_proc_params = cb_list_length (yyvsp[-2]);
	/* add pseudo-entry as it contains the actual USING parameters */
	emit_main_entry (current_program, yyvsp[-2]);
  }
#line 15091 "parser.c"
    break;

  case 35: /* control: CONTROL  */
#line 3698 "../../cobc/parser.y"
                 { check_area_a_of ("CONTROL DIVISION"); }
#line 15097 "parser.c"
    break;

  case 37: /* $@11: %empty  */
#line 3702 "../../cobc/parser.y"
  {
	  cb_verify (cb_control_division, "CONTROL DIVISION");
  }
#line 15105 "parser.c"
    break;

  case 40: /* $@12: %empty  */
#line 3710 "../../cobc/parser.y"
          { check_area_a_of ("DEFAULT SECTION"); }
#line 15111 "parser.c"
    break;

  case 41: /* _default_section: DEFAULT $@12 SECTION "." _default_clauses  */
#line 3713 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15119 "parser.c"
    break;

  case 45: /* $@13: %empty  */
#line 3727 "../../cobc/parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 15125 "parser.c"
    break;

  case 46: /* _default_accept_clause: ACCEPT $@13 _is word_or_terminal  */
#line 3729 "../../cobc/parser.y"
  {
	  CB_PENDING ("ACCEPT statement in DEFAULT SECTION");
	  /* TODO: setup_default_accept ($3); */
  }
#line 15134 "parser.c"
    break;

  case 48: /* $@14: %empty  */
#line 3737 "../../cobc/parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 15140 "parser.c"
    break;

  case 49: /* _default_display_clause: DISPLAY $@14 _is word_or_terminal  */
#line 3739 "../../cobc/parser.y"
  {
	  CB_PENDING ("DISPLAY statement in DEFAULT SECTION");
	  /* TODO: setup_default_display ($3); */
  }
#line 15149 "parser.c"
    break;

  case 50: /* $@15: %empty  */
#line 3750 "../../cobc/parser.y"
  {
	cb_validate_program_environment (current_program);
  }
#line 15157 "parser.c"
    break;

  case 51: /* $@16: %empty  */
#line 3754 "../../cobc/parser.y"
  {
	/* note:
	   we also validate all references we found so far here */
	cb_validate_program_data (current_program);
	within_typedef_definition = 0;
  }
#line 15168 "parser.c"
    break;

  case 55: /* $@17: %empty  */
#line 3771 "../../cobc/parser.y"
                       { check_area_a_of ("IDENTIFICATION DIVISION"); }
#line 15174 "parser.c"
    break;

  case 56: /* identification_header: identification_or_id $@17 DIVISION _dot  */
#line 3773 "../../cobc/parser.y"
  {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 15183 "parser.c"
    break;

  case 59: /* program_id_header: "PROGRAM-ID"  */
#line 3786 "../../cobc/parser.y"
  {
	cobc_in_id = 1;
	save_tree = NULL;
  }
#line 15192 "parser.c"
    break;

  case 60: /* program_id_paragraph: program_id_header "." program_id_name _as_literal _program_type "."  */
#line 3794 "../../cobc/parser.y"
  {
	if (setup_program (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 0)) {
		YYABORT;
	}


	setup_prototype (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 1);

	if (yyvsp[-1]) {
		if (!current_program->nested_level) {
			cb_error (_("COMMON may only be used in a contained program"));
		} else {
			current_program->flag_common = 1;
			cb_add_common_prog (current_program);
		}
	}

	/* TODO: do that more clean, this and above was only moved here
	         to fix a shift/reduce conflict with program prototype */
	if (save_tree == cb_int1) {
		current_program->flag_initial = 1;
	} else if (save_tree == cb_int2) {
		current_program->flag_recursive = 1;
	}

	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15225 "parser.c"
    break;

  case 61: /* function_id_header: "FUNCTION-ID"  */
#line 3826 "../../cobc/parser.y"
  {
	cobc_in_id = 1;
  }
#line 15233 "parser.c"
    break;

  case 62: /* function_id_paragraph: function_id_header "." program_id_name _as_literal "."  */
#line 3833 "../../cobc/parser.y"
  {
	if (setup_program (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 0)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15246 "parser.c"
    break;

  case 63: /* program_id_name: "program name"  */
#line 3845 "../../cobc/parser.y"
  {
	if (CB_REFERENCE_P (yyvsp[0]) && CB_WORD_COUNT (yyvsp[0]) > 0) {
		redefinition_error (yyvsp[0]);
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	yyval = yyvsp[0];
  }
#line 15261 "parser.c"
    break;

  case 64: /* program_id_name: "Literal"  */
#line 3856 "../../cobc/parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15269 "parser.c"
    break;

  case 66: /* end_program_name: "Literal"  */
#line 3864 "../../cobc/parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15277 "parser.c"
    break;

  case 67: /* _as_literal: %empty  */
#line 3870 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 15283 "parser.c"
    break;

  case 68: /* _as_literal: AS "Literal"  */
#line 3871 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 15289 "parser.c"
    break;

  case 69: /* _program_type: %empty  */
#line 3875 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 15295 "parser.c"
    break;

  case 70: /* _program_type: _is program_type_clause _program  */
#line 3876 "../../cobc/parser.y"
                                        { yyval = yyvsp[-1]; }
#line 15301 "parser.c"
    break;

  case 71: /* program_type_clause: COMMON  */
#line 3881 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 15309 "parser.c"
    break;

  case 72: /* program_type_clause: init_or_recurse_and_common  */
#line 3885 "../../cobc/parser.y"
  {
	yyval = cb_int2;
  }
#line 15317 "parser.c"
    break;

  case 74: /* program_type_clause: EXTERNAL  */
#line 3890 "../../cobc/parser.y"
  {
	CB_PENDING (_("CALL prototypes"));
  }
#line 15325 "parser.c"
    break;

  case 77: /* init_or_recurse: "INITIAL"  */
#line 3902 "../../cobc/parser.y"
  {
	save_tree = cb_int1;
  }
#line 15333 "parser.c"
    break;

  case 78: /* init_or_recurse: RECURSIVE  */
#line 3906 "../../cobc/parser.y"
  {
	save_tree = cb_int2;
  }
#line 15341 "parser.c"
    break;

  case 80: /* _options_paragraph: OPTIONS "." _options_clauses  */
#line 3915 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15349 "parser.c"
    break;

  case 84: /* arithmetic_choice: NATIVE  */
#line 3935 "../../cobc/parser.y"
  {
/* FIXME: the IBM-compatible ARITHMETIC should only be disabled
          for the specified program (and its nested programs)
   note: ibm-strict.conf has no OPTIONS paragraph, but ibm.conf does */
	cb_arithmetic_osvs = 0;
  }
#line 15360 "parser.c"
    break;

  case 85: /* arithmetic_choice: STANDARD  */
#line 3942 "../../cobc/parser.y"
  {
	CB_PENDING ("STANDARD ARITHMETIC");
  }
#line 15368 "parser.c"
    break;

  case 86: /* arithmetic_choice: "STANDARD-BINARY"  */
#line 3946 "../../cobc/parser.y"
  {
	CB_PENDING ("STANDARD-BINARY ARITHMETIC");
  }
#line 15376 "parser.c"
    break;

  case 87: /* arithmetic_choice: "STANDARD-DECIMAL"  */
#line 3950 "../../cobc/parser.y"
  {
	CB_PENDING ("STANDARD-DECIMAL ARITHMETIC");
  }
#line 15384 "parser.c"
    break;

  case 88: /* _default_rounded_clause: %empty  */
#line 3965 "../../cobc/parser.y"
  {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 15392 "parser.c"
    break;

  case 89: /* _default_rounded_clause: DEFAULT ROUNDED _mode _is round_choice  */
#line 3969 "../../cobc/parser.y"
  {
	if (yyvsp[0]) {
		default_rounded_mode = yyvsp[0];
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 15404 "parser.c"
    break;

  case 91: /* _entry_convention_clause: "ENTRY-CONVENTION" _is convention_type  */
#line 3981 "../../cobc/parser.y"
  {
	current_program->entry_convention = yyvsp[0];
  }
#line 15412 "parser.c"
    break;

  case 92: /* convention_type: COBOL  */
#line 3988 "../../cobc/parser.y"
  {
	yyval = cb_int (CB_CONV_COBOL);
  }
#line 15420 "parser.c"
    break;

  case 93: /* convention_type: "EXTERN"  */
#line 3992 "../../cobc/parser.y"
  {
	yyval = cb_int0;
  }
#line 15428 "parser.c"
    break;

  case 94: /* convention_type: STDCALL  */
#line 3996 "../../cobc/parser.y"
  {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 15436 "parser.c"
    break;

  case 96: /* _intermediate_rounding_clause: INTERMEDIATE ROUNDING _is intermediate_rounding_choice  */
#line 4004 "../../cobc/parser.y"
  {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 15444 "parser.c"
    break;

  case 97: /* intermediate_rounding_choice: "NEAREST-AWAY-FROM-ZERO"  */
#line 4011 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 15452 "parser.c"
    break;

  case 98: /* intermediate_rounding_choice: "NEAREST-EVEN"  */
#line 4015 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 15460 "parser.c"
    break;

  case 99: /* intermediate_rounding_choice: PROHIBITED  */
#line 4019 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 15468 "parser.c"
    break;

  case 100: /* intermediate_rounding_choice: TRUNCATION  */
#line 4023 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 15476 "parser.c"
    break;

  case 104: /* environment: ENVIRONMENT  */
#line 4040 "../../cobc/parser.y"
                         { check_area_a_of ("ENVIRONMENT DIVISION"); }
#line 15482 "parser.c"
    break;

  case 105: /* environment_header: environment DIVISION _dot  */
#line 4043 "../../cobc/parser.y"
  {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 15490 "parser.c"
    break;

  case 109: /* configuration: CONFIGURATION  */
#line 4059 "../../cobc/parser.y"
                             { check_area_a_of ("CONFIGURATION SECTION"); }
#line 15496 "parser.c"
    break;

  case 110: /* configuration_header: configuration SECTION _dot  */
#line 4062 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 15508 "parser.c"
    break;

  case 122: /* $@18: %empty  */
#line 4097 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SOURCE_COMPUTER);
	set_conf_section_part (COBC_HD_SOURCE_COMPUTER);
  }
#line 15519 "parser.c"
    break;

  case 127: /* _with_debugging_mode: _with DEBUGGING MODE  */
#line 4113 "../../cobc/parser.y"
  {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 15530 "parser.c"
    break;

  case 128: /* $@19: %empty  */
#line 4125 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_OBJECT_COMPUTER);
	set_conf_section_part (COBC_HD_OBJECT_COMPUTER);
  }
#line 15541 "parser.c"
    break;

  case 129: /* object_computer_paragraph: "OBJECT-COMPUTER" _dot $@19 _object_computer_entry  */
#line 4132 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15549 "parser.c"
    break;

  case 140: /* object_computer_memory: MEMORY _size _is integer object_char_or_word_or_modules  */
#line 4158 "../../cobc/parser.y"
  {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 15557 "parser.c"
    break;

  case 141: /* object_computer_sequence: _program program_collating_sequence  */
#line 4166 "../../cobc/parser.y"
  {
	current_program->collating_sequence = alphanumeric_collation;
	current_program->collating_sequence_n = national_collation;
  }
#line 15566 "parser.c"
    break;

  case 142: /* $@20: %empty  */
#line 4174 "../../cobc/parser.y"
  {
	alphanumeric_collation = national_collation = NULL;
  }
#line 15574 "parser.c"
    break;

  case 144: /* program_coll_sequence_values: _is single_reference  */
#line 4182 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 15582 "parser.c"
    break;

  case 145: /* program_coll_sequence_values: _is single_reference single_reference  */
#line 4186 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15592 "parser.c"
    break;

  case 146: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference  */
#line 4192 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 15600 "parser.c"
    break;

  case 147: /* program_coll_sequence_values: _for NATIONAL _is single_reference  */
#line 4196 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15609 "parser.c"
    break;

  case 148: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference _for NATIONAL _is single_reference  */
#line 4202 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15619 "parser.c"
    break;

  case 149: /* program_coll_sequence_values: _for NATIONAL _is single_reference _for ALPHANUMERIC _is single_reference  */
#line 4209 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 15629 "parser.c"
    break;

  case 150: /* object_computer_segment: "SEGMENT-LIMIT" _is integer  */
#line 4218 "../../cobc/parser.y"
  {
	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			yyval = NULL;
		}
	}
	/* Ignore */
  }
#line 15644 "parser.c"
    break;

  case 151: /* object_computer_class: _character CLASSIFICATION _is locale_class  */
#line 4232 "../../cobc/parser.y"
  {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = yyvsp[0];
	}
  }
#line 15656 "parser.c"
    break;

  case 152: /* locale_class: single_reference  */
#line 4243 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 15664 "parser.c"
    break;

  case 153: /* locale_class: LOCALE  */
#line 4247 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 15672 "parser.c"
    break;

  case 154: /* locale_class: "USER-DEFAULT"  */
#line 4251 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 15680 "parser.c"
    break;

  case 155: /* locale_class: "SYSTEM-DEFAULT"  */
#line 4255 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 15688 "parser.c"
    break;

  case 160: /* $@21: %empty  */
#line 4272 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_REPOSITORY);
	set_conf_section_part (COBC_HD_REPOSITORY);
  }
#line 15699 "parser.c"
    break;

  case 161: /* repository_paragraph: REPOSITORY _dot $@21 _repository_entry  */
#line 4279 "../../cobc/parser.y"
  {
	cobc_in_repository = 0;
  }
#line 15707 "parser.c"
    break;

  case 164: /* _repository_entry: repository_list error "."  */
#line 4288 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 15715 "parser.c"
    break;

  case 167: /* repository_name: FUNCTION ALL INTRINSIC  */
#line 4300 "../../cobc/parser.y"
  {
	functions_are_all = 1;
  }
#line 15723 "parser.c"
    break;

  case 168: /* repository_name: FUNCTION "Identifier" _as_literal  */
#line 4304 "../../cobc/parser.y"
  {
	if (yyvsp[-1] != cb_error_node) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_FUNCTION, 0);
	}
  }
#line 15733 "parser.c"
    break;

  case 170: /* repository_name: PROGRAM "Identifier" _as_literal  */
#line 4311 "../../cobc/parser.y"
  {
	  if (yyvsp[-1] != cb_error_node
	      && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 0);
	}
  }
#line 15744 "parser.c"
    break;

  case 171: /* repository_name: FUNCTION repository_name_list error  */
#line 4318 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 15752 "parser.c"
    break;

  case 172: /* repository_name_list: "intrinsic function name"  */
#line 4325 "../../cobc/parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 15761 "parser.c"
    break;

  case 173: /* repository_name_list: repository_name_list "intrinsic function name"  */
#line 4330 "../../cobc/parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 15770 "parser.c"
    break;

  case 174: /* special_names_header: "SPECIAL-NAMES" _dot  */
#line 4341 "../../cobc/parser.y"
  {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SPECIAL_NAMES);
	set_conf_section_part (COBC_HD_SPECIAL_NAMES);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	cobc_cs_check = CB_CS_SPECIAL_NAMES;
  }
#line 15786 "parser.c"
    break;

  case 194: /* $@22: %empty  */
#line 4388 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name with special translation
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name_translated (yyvsp[0]);
	}
  }
#line 15805 "parser.c"
    break;

  case 196: /* word_or_terminal: "Identifier"  */
#line 4406 "../../cobc/parser.y"
           { yyval = yyvsp[0]; }
#line 15811 "parser.c"
    break;

  case 197: /* word_or_terminal: TERMINAL  */
#line 4408 "../../cobc/parser.y"
           { yyval = cb_build_reference ("TERMINAL"); }
#line 15817 "parser.c"
    break;

  case 198: /* mnemonic_choices: _is CRT  */
#line 4412 "../../cobc/parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 15831 "parser.c"
    break;

  case 199: /* mnemonic_choices: integer _is undefined_word  */
#line 4423 "../../cobc/parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE (yyvsp[0])) {
			const char *name = CB_NAME (yyvsp[0]);
			CB_SYSTEM_NAME(save_tree)->value = yyvsp[-2];
			cb_define (yyvsp[0], save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					yyvsp[0], save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (cb_strcasecmp (name, "EXTERN" ) == 0
			 || cb_strcasecmp (name, "STDCALL") == 0
			 || cb_strcasecmp (name, "WINAPI") == 0
			 || cb_strcasecmp (name, "STATIC" ) == 0
			 || cb_strcasecmp (name, "C"      ) == 0
			 || cb_strcasecmp (name, "PASCAL" ) == 0) {
				remove_context_sensitivity (name, CB_CS_CALL);
			}
		}
	}
  }
#line 15858 "parser.c"
    break;

  case 200: /* mnemonic_choices: _is undefined_word _special_name_mnemonic_on_off  */
#line 4446 "../../cobc/parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[-1])) {
		cb_define (yyvsp[-1], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[-1], save_tree);
	}
  }
#line 15870 "parser.c"
    break;

  case 204: /* on_off_clauses: on_off_clauses_1  */
#line 4462 "../../cobc/parser.y"
  {
	  check_on_off_duplicate = 0;
  }
#line 15878 "parser.c"
    break;

  case 205: /* on_off_clauses_1: on_or_off _onoff_status undefined_word  */
#line 4469 "../../cobc/parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 15897 "parser.c"
    break;

  case 206: /* on_off_clauses_1: on_off_clauses_1 on_or_off _onoff_status undefined_word  */
#line 4484 "../../cobc/parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 15916 "parser.c"
    break;

  case 207: /* @23: %empty  */
#line 4504 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_alphabet_name (yyvsp[0]);
	}
  }
#line 15933 "parser.c"
    break;

  case 208: /* alphabet_name_clause: ALPHABET undefined_word @23 alphabet_definition  */
#line 4517 "../../cobc/parser.y"
  {
	if (yyvsp[-1]) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 15945 "parser.c"
    break;

  case 209: /* @24: %empty  */
#line 4528 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME (yyvsp[-1])->alphabet_target = CB_ALPHABET_ALPHANUMERIC;
	}
  }
#line 15956 "parser.c"
    break;

  case 211: /* @25: %empty  */
#line 4536 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME(yyvsp[-1])->alphabet_target = CB_ALPHABET_NATIONAL;
	}
  }
#line 15967 "parser.c"
    break;

  case 217: /* alphabet_type_alphanumeric: "STANDARD-1"  */
#line 4557 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 15977 "parser.c"
    break;

  case 218: /* alphabet_type_alphanumeric: "STANDARD-2"  */
#line 4563 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 15987 "parser.c"
    break;

  case 219: /* alphabet_type_alphanumeric: EBCDIC  */
#line 4569 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 15997 "parser.c"
    break;

  case 220: /* alphabet_type_alphanumeric: ASCII  */
#line 4575 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 16007 "parser.c"
    break;

  case 222: /* alphabet_type_national: "UCS-4"  */
#line 4585 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UCS-4");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UCS_4;
	}
  }
#line 16018 "parser.c"
    break;

  case 223: /* alphabet_type_national: "UTF-8"  */
#line 4592 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-8");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_8;
	}
  }
#line 16029 "parser.c"
    break;

  case 224: /* alphabet_type_national: "UTF-16"  */
#line 4599 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-16");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_16;
	}
  }
#line 16040 "parser.c"
    break;

  case 225: /* alphabet_type_common: NATIVE  */
#line 4609 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 16050 "parser.c"
    break;

  case 226: /* alphabet_type_common: LOCALE single_reference  */
#line 4615 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (2)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->alphabet_type = CB_ALPHABET_LOCALE;
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->custom_list = yyvsp[0];
		CB_PENDING_X (yyvsp[(-1) - (2)], "LOCALE ALPHABET");
	}
  }
#line 16062 "parser.c"
    break;

  case 227: /* alphabet_type_common: alphabet_literal_list  */
#line 4623 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->custom_list = yyvsp[0];
	}
  }
#line 16073 "parser.c"
    break;

  case 228: /* alphabet_literal_list: alphabet_literal  */
#line 4633 "../../cobc/parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 16081 "parser.c"
    break;

  case 229: /* alphabet_literal_list: alphabet_literal_list alphabet_literal  */
#line 4637 "../../cobc/parser.y"
  {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 16089 "parser.c"
    break;

  case 230: /* alphabet_literal: alphabet_lits  */
#line 4644 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16097 "parser.c"
    break;

  case 231: /* alphabet_literal: alphabet_lits THRU alphabet_lits  */
#line 4648 "../../cobc/parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 16105 "parser.c"
    break;

  case 232: /* @26: %empty  */
#line 4652 "../../cobc/parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[-1]);
  }
#line 16113 "parser.c"
    break;

  case 233: /* alphabet_literal: alphabet_lits ALSO @26 alphabet_also_sequence  */
#line 4656 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
  }
#line 16121 "parser.c"
    break;

  case 234: /* alphabet_also_sequence: alphabet_lits  */
#line 4663 "../../cobc/parser.y"
  {
	cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 16129 "parser.c"
    break;

  case 235: /* alphabet_also_sequence: alphabet_also_sequence ALSO alphabet_lits  */
#line 4667 "../../cobc/parser.y"
  {
	cb_list_add (yyvsp[-3], yyvsp[0]);
  }
#line 16137 "parser.c"
    break;

  case 236: /* alphabet_lits: "Literal"  */
#line 4673 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 16143 "parser.c"
    break;

  case 237: /* alphabet_lits: SPACE  */
#line 4674 "../../cobc/parser.y"
                                { yyval = cb_space; }
#line 16149 "parser.c"
    break;

  case 238: /* alphabet_lits: ZERO  */
#line 4675 "../../cobc/parser.y"
                                { yyval = cb_zero; }
#line 16155 "parser.c"
    break;

  case 239: /* alphabet_lits: QUOTE  */
#line 4676 "../../cobc/parser.y"
                                { yyval = cb_quote; }
#line 16161 "parser.c"
    break;

  case 240: /* alphabet_lits: "HIGH-VALUE"  */
#line 4677 "../../cobc/parser.y"
                        { yyval = cb_norm_high; /* -> special case, not cb_high */ }
#line 16167 "parser.c"
    break;

  case 241: /* alphabet_lits: "LOW-VALUE"  */
#line 4678 "../../cobc/parser.y"
                                { yyval = cb_norm_low; }
#line 16173 "parser.c"
    break;

  case 242: /* space_or_zero: SPACE  */
#line 4682 "../../cobc/parser.y"
                                { yyval = cb_space; }
#line 16179 "parser.c"
    break;

  case 243: /* space_or_zero: ZERO  */
#line 4683 "../../cobc/parser.y"
                                { yyval = cb_zero; }
#line 16185 "parser.c"
    break;

  case 244: /* _alphnat_target: %empty  */
#line 4688 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16193 "parser.c"
    break;

  case 245: /* _alphnat_target: _for ALPHANUMERIC  */
#line 4692 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16201 "parser.c"
    break;

  case 246: /* _alphnat_target: _for NATIONAL  */
#line 4696 "../../cobc/parser.y"
  {
	yyval = cb_int0;
  }
#line 16209 "parser.c"
    break;

  case 247: /* _in_alphabet: %empty  */
#line 4703 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16217 "parser.c"
    break;

  case 248: /* _in_alphabet: IN alphabet_name  */
#line 4707 "../../cobc/parser.y"
  {
	/* note: IN is really mandatory here */
	yyval = yyvsp[0];
  }
#line 16226 "parser.c"
    break;

  case 249: /* symbolic_characters_clause: symbolic_collection _in_alphabet  */
#line 4718 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_tree type = CB_PAIR_X (yyvsp[-1]);
		cb_tree chars_list = CB_PAIR_Y (yyvsp[-1]);
		cb_tree alph = yyvsp[0];
		
		/* TODO: at least add a check that $3 and $6 match by type */
		if (type && !alph) {
			cb_error_x (type, _("type does not match alphabet"));
		} else
		if (type) {
			CB_PENDING_X (type, "NATIONAL SYMBOLIC CHARACTER");
		}
		CB_CHAIN_PAIR (current_program->symbolic_char_list, chars_list, alph);
	}
  }
#line 16252 "parser.c"
    break;

  case 250: /* symbolic_collection: SYMBOLIC _characters _alphnat_target symbolic_chars_list  */
#line 4745 "../../cobc/parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-1], yyvsp[0]);
  }
#line 16260 "parser.c"
    break;

  case 251: /* symbolic_chars_list: symbolic_chars_phrase  */
#line 4752 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16268 "parser.c"
    break;

  case 252: /* symbolic_chars_list: symbolic_chars_list symbolic_chars_phrase  */
#line 4756 "../../cobc/parser.y"
  {
	if (yyvsp[0]) {
		yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 16280 "parser.c"
    break;

  case 253: /* symbolic_chars_phrase: char_list _is_are integer_list  */
#line 4767 "../../cobc/parser.y"
  {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length (yyvsp[-2]) != cb_list_length (yyvsp[0])) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		yyval = NULL;
	} else {
		l1 = yyvsp[-2];
		l2 = yyvsp[0];
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		yyval = yyvsp[-2];
	}
  }
#line 16301 "parser.c"
    break;

  case 254: /* char_list: unique_word  */
#line 4787 "../../cobc/parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = NULL;
	} else {
		yyval = CB_LIST_INIT (yyvsp[0]);
	}
  }
#line 16313 "parser.c"
    break;

  case 255: /* char_list: char_list unique_word  */
#line 4795 "../../cobc/parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = yyvsp[-1];
	} else {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	}
  }
#line 16325 "parser.c"
    break;

  case 256: /* integer_list: symbolic_integer  */
#line 4805 "../../cobc/parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16331 "parser.c"
    break;

  case 257: /* integer_list: integer_list symbolic_integer  */
#line 4806 "../../cobc/parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16337 "parser.c"
    break;

  case 258: /* symbolic_constant_clause: SYMBOLIC CONSTANT symbolic_constant_list  */
#line 4815 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	(void)cb_verify (cb_symbolic_constant, "SYMBOLIC CONSTANT");
  }
#line 16351 "parser.c"
    break;

  case 261: /* symbolic_constant: user_entry_name _is literal  */
#line 4833 "../../cobc/parser.y"
  {
	struct cb_field *f;

	f = CB_FIELD (cb_build_constant (yyvsp[-2], yyvsp[0]));
	f->flag_item_78 = 1;
	f->flag_constant = 1;
	f->flag_is_global = 1;
	f->level = 1;
	f->values = yyvsp[0];
	cb_needs_01 = 1;
	/* Ignore return value */
	(void)cb_validate_78_item (f, 0);
  }
#line 16369 "parser.c"
    break;

  case 262: /* class_name_clause: CLASS undefined_word _alphnat_target _is class_item_list _in_alphabet  */
#line 4852 "../../cobc/parser.y"
  {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name (yyvsp[-4], yyvsp[-1]);
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
		/* TODO: at least add a check that $3 and $6 match by type */
		if (yyvsp[-3] && !yyvsp[0]) {
			cb_error_x (yyvsp[-3], _("type does not match alphabet"));
		} else
		if (yyvsp[-3]) {
			CB_PENDING_X (yyvsp[-3], "NATIONAL CLASS");
		}
		if (yyvsp[0]) {
			CB_PENDING_X (yyvsp[0], _("CLASS IS integer IN alphabet-name"));
		}
	}
  }
#line 16401 "parser.c"
    break;

  case 263: /* class_item_list: class_item  */
#line 4882 "../../cobc/parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16407 "parser.c"
    break;

  case 264: /* class_item_list: class_item_list class_item  */
#line 4883 "../../cobc/parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16413 "parser.c"
    break;

  case 265: /* class_item: class_value  */
#line 4888 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16421 "parser.c"
    break;

  case 266: /* class_item: class_value THRU class_value  */
#line 4892 "../../cobc/parser.y"
  {
	if (CB_TREE_CLASS (yyvsp[-2]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[-2]) && CB_LITERAL (yyvsp[-2])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS (yyvsp[0]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[0]) && CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (cb_literal_value (yyvsp[-2]) <= cb_literal_value (yyvsp[0])) {
		yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
	} else {
		yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]);
	}
  }
#line 16441 "parser.c"
    break;

  case 267: /* locale_clause: LOCALE undefined_word _is "Literal"  */
#line 4913 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		cb_tree	l = cb_build_locale_name (yyvsp[-2], yyvsp[0]);
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 16461 "parser.c"
    break;

  case 268: /* @27: %empty  */
#line 4934 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_schema_name (yyvsp[0]);
	}
  }
#line 16478 "parser.c"
    break;

  case 269: /* xml_schema_clause: "XML-SCHEMA" undefined_word @27 schema_definition  */
#line 4947 "../../cobc/parser.y"
  {
	if (yyvsp[-1]) {
		current_program->schema_name_list =
			cb_list_add (current_program->schema_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 16490 "parser.c"
    break;

  case 270: /* schema_definition: literal  */
#line 4958 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = (const char *) CB_LITERAL (yyvsp[0])->data;
	}
  }
#line 16501 "parser.c"
    break;

  case 271: /* schema_definition: "Identifier"  */
#line 4965 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = CB_REFERENCE (yyvsp[0])->word->name;
	}
  }
#line 16512 "parser.c"
    break;

  case 272: /* currency_sign_clause: CURRENCY _sign _is "Literal" _with_pic_symbol  */
#line 4977 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		unsigned int	error_ind = 0;

		/* FIXME: actual allowed (depending on dialect), see FR #246 */
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);

		/* checks of CURRENCY SIGN (being currency string) when separate */
		if (yyvsp[0]) {
			unsigned int	char_seen = 0;
			unsigned char	*s = CB_LITERAL (yyvsp[-1])->data;

			CB_PENDING_X (yyvsp[-1], _("separate currency symbol and currency string"));
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 1;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 1;
			}
		}
		if (error_ind) {
			cb_error_x (yyvsp[-1], _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL (yyvsp[-1])->data);
		}
		if (yyvsp[0]) {
			set_currency_picture_symbol (yyvsp[0]);
		} else {
			if (!error_ind) {
				set_currency_picture_symbol (yyvsp[-1]);
			}
		}
	}
  }
#line 16578 "parser.c"
    break;

  case 273: /* _with_pic_symbol: %empty  */
#line 5043 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16586 "parser.c"
    break;

  case 274: /* _with_pic_symbol: _with "PICTURE SYMBOL" "Literal"  */
#line 5047 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16594 "parser.c"
    break;

  case 275: /* decimal_point_clause: "DECIMAL-POINT" _is COMMA  */
#line 5056 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 16611 "parser.c"
    break;

  case 276: /* numeric_sign_clause: NUMERIC SIGN _is TRAILING SEPARATE  */
#line 5075 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 16626 "parser.c"
    break;

  case 277: /* cursor_clause: CURSOR _is reference  */
#line 5091 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = yyvsp[0];
	}
  }
#line 16642 "parser.c"
    break;

  case 278: /* crt_status_clause: CRT STATUS _is reference  */
#line 5109 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = yyvsp[0];
	}
  }
#line 16658 "parser.c"
    break;

  case 279: /* screen_control: "SCREEN CONTROL" _is reference  */
#line 5127 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 16674 "parser.c"
    break;

  case 280: /* event_status: "EVENT STATUS" _is reference  */
#line 5144 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 16690 "parser.c"
    break;

  case 281: /* $@28: %empty  */
#line 5161 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name ("TOP");
	}
  }
#line 16709 "parser.c"
    break;

  case 282: /* top_clause: TOP $@28 _is undefined_word  */
#line 5176 "../../cobc/parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[0])) {
		cb_define (yyvsp[0], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[0], save_tree);
	}
  }
#line 16721 "parser.c"
    break;

  case 284: /* input_output: "INPUT-OUTPUT"  */
#line 5194 "../../cobc/parser.y"
                           { check_area_a_of ("INPUT-OUTPUT SECTION"); }
#line 16727 "parser.c"
    break;

  case 286: /* _input_output_header: input_output SECTION _dot  */
#line 5197 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 16736 "parser.c"
    break;

  case 288: /* _file_control_header: "FILE-CONTROL" _dot  */
#line 5207 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 16746 "parser.c"
    break;

  case 291: /* $@29: %empty  */
#line 5219 "../../cobc/parser.y"
         { check_non_area_a (yyvsp[0]); }
#line 16752 "parser.c"
    break;

  case 292: /* $@30: %empty  */
#line 5221 "../../cobc/parser.y"
  {
	char	buff[COB_MINI_BUFF];

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE (yyvsp[0])) {
		/* Build new file */
		current_file = build_file (yyvsp[0]);
		current_file->optional = CB_INTEGER (yyvsp[-1])->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else {
		/* Create dummy file */
		snprintf (buff, COB_MINI_BUFF, "SELECT on line %d",
			  cb_source_line);
		current_file = build_file (cb_build_reference (buff));
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);

	}
	key_type = NO_KEY;
  }
#line 16783 "parser.c"
    break;

  case 293: /* file_control_entry: SELECT $@29 flag_optional undefined_word $@30 _select_clauses_or_error  */
#line 5248 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
	if (CB_VALID_TREE (yyvsp[-2])) {
		if (current_file->organization == COB_ORG_INDEXED
		    && key_type == RELATIVE_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RELATIVE KEY clause on INDEXED files"));
		} else if (current_file->organization == COB_ORG_RELATIVE
			   && key_type == RECORD_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RECORD KEY clause on RELATIVE files"));
		}

		validate_file (current_file, yyvsp[-2]);
	}
  }
#line 16804 "parser.c"
    break;

  case 295: /* _select_clauses_or_error: error _dot_or_else_end_of_file_control  */
#line 5269 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 16812 "parser.c"
    break;

  case 297: /* _select_clause_sequence: _select_clause_sequence select_clause  */
#line 5276 "../../cobc/parser.y"
  {
	/* reset context-sensitive words for next clauses */
	cobc_cs_check = CB_CS_SELECT;
  }
#line 16821 "parser.c"
    break;

  case 318: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file literal  */
#line 5327 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with literals"));
	}

	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16835 "parser.c"
    break;

  case 319: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file qualified_word  */
#line 5337 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);

	/* current_file->assign_type is set by _ext_clause */
	if (!ext_dyn_specified) {
		current_file->flag_assign_no_keyword = 1;
	}
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16849 "parser.c"
    break;

  case 320: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file using_or_varying qualified_word  */
#line 5347 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with USING/VARYING"));
	}
        cb_verify (cb_assign_using_variable, "ASSIGN USING/VARYING variable");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16864 "parser.c"
    break;

  case 321: /* assign_clause: ASSIGN _to _ext_clause DISK FROM qualified_word  */
#line 5358 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with DISK FROM"));
	}
	cb_verify (cb_assign_disk_from, _("ASSIGN DISK FROM"));

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16879 "parser.c"
    break;

  case 322: /* assign_clause: ASSIGN _to _ext_clause assign_device  */
#line 5369 "../../cobc/parser.y"
  {
	if (assign_device == CB_ASSIGN_DISPLAY_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	} else if (assign_device == CB_ASSIGN_KEYBOARD_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	} else if (assign_device == CB_ASSIGN_PRINTER_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
	} else if (assign_device == CB_ASSIGN_PRINTER_1_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
	} else if (assign_device == CB_ASSIGN_PRINT_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("LPT1", (size_t)4);
	} else if (assign_device == CB_ASSIGN_LINE_SEQ_DEVICE
		   || assign_device == CB_ASSIGN_GENERAL_DEVICE) {
		current_file->flag_fileid = 1;
	}
  }
#line 16910 "parser.c"
    break;

  case 323: /* _assign_device_or_line_adv_file: %empty  */
#line 5399 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 16918 "parser.c"
    break;

  case 324: /* _assign_device_or_line_adv_file: line_adv_file  */
#line 5403 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 16926 "parser.c"
    break;

  case 326: /* assign_device: general_device_name  */
#line 5411 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_GENERAL_DEVICE;
  }
#line 16934 "parser.c"
    break;

  case 327: /* assign_device: line_seq_device_name  */
#line 5415 "../../cobc/parser.y"
  {
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	assign_device = CB_ASSIGN_LINE_SEQ_DEVICE;
  }
#line 16943 "parser.c"
    break;

  case 328: /* assign_device: DISPLAY  */
#line 5420 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_DISPLAY_DEVICE;
  }
#line 16951 "parser.c"
    break;

  case 329: /* assign_device: KEYBOARD  */
#line 5424 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_KEYBOARD_DEVICE;
  }
#line 16959 "parser.c"
    break;

  case 330: /* assign_device: PRINTER  */
#line 5432 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 16969 "parser.c"
    break;

  case 331: /* assign_device: "PRINTER-1"  */
#line 5438 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_1_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 16979 "parser.c"
    break;

  case 332: /* assign_device: PRINT  */
#line 5444 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_PRINT_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 16989 "parser.c"
    break;

  case 344: /* line_adv_file: LINE ADVANCING _file  */
#line 5471 "../../cobc/parser.y"
  {
	current_file->flag_line_adv = 1;
  }
#line 16997 "parser.c"
    break;

  case 345: /* _ext_clause: %empty  */
#line 5478 "../../cobc/parser.y"
  {
	ext_dyn_specified = 0;
	current_file->assign_type = cb_assign_type_default;
  }
#line 17006 "parser.c"
    break;

  case 346: /* _ext_clause: ext_clause  */
#line 5483 "../../cobc/parser.y"
  {
	ext_dyn_specified = 1;
	cb_verify (cb_assign_ext_dyn, _("ASSIGN EXTERNAL/DYNAMIC"));
  }
#line 17015 "parser.c"
    break;

  case 347: /* ext_clause: EXTERNAL  */
#line 5491 "../../cobc/parser.y"
  {
	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
  }
#line 17023 "parser.c"
    break;

  case 348: /* ext_clause: DYNAMIC  */
#line 5495 "../../cobc/parser.y"
  {
	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
  }
#line 17031 "parser.c"
    break;

  case 351: /* access_mode_clause: ACCESS _mode _is access_mode  */
#line 5509 "../../cobc/parser.y"
  {
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 17039 "parser.c"
    break;

  case 352: /* access_mode: SEQUENTIAL  */
#line 5515 "../../cobc/parser.y"
                        { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 17045 "parser.c"
    break;

  case 353: /* access_mode: DYNAMIC  */
#line 5516 "../../cobc/parser.y"
                        { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 17051 "parser.c"
    break;

  case 354: /* access_mode: RANDOM  */
#line 5517 "../../cobc/parser.y"
                        { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 17057 "parser.c"
    break;

  case 355: /* alternate_record_key_clause: ALTERNATE _record _key _is reference _split_keys flag_duplicates _password_clause _suppress_clause  */
#line 5525 "../../cobc/parser.y"
  {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	cb_tree composite_key;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = yyvsp[-4];
	p->component_list = NULL;
	if (yyvsp[-2]) {
		p->duplicates = CB_INTEGER (yyvsp[-2])->val;
	} else {
		/* note: we may add a compiler configuration here,
		         as at least ICOBOL defaults to WITH DUPLICATES
		         for ALTERNATE keys if not explicit deactivated
		*/
		p->duplicates = 0;
	}
	p->password = yyvsp[-1];
	if (yyvsp[0]) {
		p->tf_suppress = 1;
		p->char_suppress = CB_INTEGER (yyvsp[0])->val;
	} else {
		p->tf_suppress = 0;
	}
	p->next = NULL;

	/* handle split keys */
	if (yyvsp[-3]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field(yyvsp[-4]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			p->key = cb_build_field_reference((struct cb_field *)composite_key, NULL);
			p->component_list = key_component_list;
		}
	}

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 17112 "parser.c"
    break;

  case 356: /* _password_clause: %empty  */
#line 5579 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 17120 "parser.c"
    break;

  case 358: /* $@31: %empty  */
#line 5587 "../../cobc/parser.y"
  {
	CB_PENDING ("PASSWORD clause");
  }
#line 17128 "parser.c"
    break;

  case 359: /* password_clause: PASSWORD $@31 _is reference  */
#line 5591 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 17136 "parser.c"
    break;

  case 360: /* encryption_clause: ENCRYPTION  */
#line 5599 "../../cobc/parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		cb_error (_("%s only valid with ORGANIZATION %s"), "WITH ENCRYPTION", "INDEXED");
	} else {
		CB_PENDING ("WITH ENCRYPTION");
		current_file->password = cb_int0;
	}
  }
#line 17149 "parser.c"
    break;

  case 361: /* _suppress_clause: %empty  */
#line 5611 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 17157 "parser.c"
    break;

  case 362: /* _suppress_clause: SUPPRESS WHEN ALL basic_value  */
#line 5615 "../../cobc/parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 17165 "parser.c"
    break;

  case 363: /* _suppress_clause: SUPPRESS WHEN space_or_zero  */
#line 5619 "../../cobc/parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 17173 "parser.c"
    break;

  case 364: /* collating_sequence_clause: collating_sequence  */
#line 5629 "../../cobc/parser.y"
  {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	current_file->collating_sequence = alphanumeric_collation;
	current_file->collating_sequence_n = national_collation;
	CB_PENDING ("FILE COLLATING SEQUENCE");
  }
#line 17184 "parser.c"
    break;

  case 365: /* $@32: %empty  */
#line 5639 "../../cobc/parser.y"
  {
	alphanumeric_collation = national_collation = default_collation;
  }
#line 17192 "parser.c"
    break;

  case 367: /* coll_sequence_values: _is alphabet_name  */
#line 5647 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17200 "parser.c"
    break;

  case 368: /* coll_sequence_values: _is alphabet_name alphabet_name  */
#line 5651 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17210 "parser.c"
    break;

  case 369: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name  */
#line 5657 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17218 "parser.c"
    break;

  case 370: /* coll_sequence_values: _for NATIONAL _is alphabet_name  */
#line 5661 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17227 "parser.c"
    break;

  case 371: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name _for NATIONAL _is alphabet_name  */
#line 5667 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17237 "parser.c"
    break;

  case 372: /* coll_sequence_values: _for NATIONAL _is alphabet_name _for ALPHANUMERIC _is alphabet_name  */
#line 5674 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 17247 "parser.c"
    break;

  case 373: /* collating_sequence_clause_key: _collating SEQUENCE OF reference _is alphabet_name  */
#line 5683 "../../cobc/parser.y"
  {
	/* note: both entries must be resolved later on
	   and also attached to the correct key later, so just store in a list here: */
	current_file->collating_sequence_keys =
		cb_list_add(current_file->collating_sequence_keys, CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]));
	CB_PENDING ("KEY COLLATING SEQUENCE");
  }
#line 17259 "parser.c"
    break;

  case 374: /* alphabet_name: "Identifier"  */
#line 5694 "../../cobc/parser.y"
  {
	if (CB_ALPHABET_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not an alphabet-name"),
			cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 17273 "parser.c"
    break;

  case 375: /* alphabet_name: "STANDARD-1"  */
#line 5704 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_NATIVE);
  }
#line 17281 "parser.c"
    break;

  case 376: /* alphabet_name: "STANDARD-2"  */
#line 5708 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_ASCII);
  }
#line 17289 "parser.c"
    break;

  case 377: /* alphabet_name: EBCDIC  */
#line 5712 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_EBCDIC);
  }
#line 17297 "parser.c"
    break;

  case 378: /* alphabet_name: ASCII  */
#line 5716 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_ASCII);
  }
#line 17305 "parser.c"
    break;

  case 379: /* file_status_clause: _file_or_sort STATUS _is reference _reference  */
#line 5725 "../../cobc/parser.y"
  {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = yyvsp[-1];
	if (yyvsp[0]) {
		/* Ignore VSAM STATUS field */
		cb_verify (cb_vsam_status, _("VSAM status"));
	}
  }
#line 17318 "parser.c"
    break;

  case 383: /* $@33: %empty  */
#line 5744 "../../cobc/parser.y"
  {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 17326 "parser.c"
    break;

  case 385: /* lock_mode: MANUAL _lock_with  */
#line 5752 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MANUAL;
  }
#line 17334 "parser.c"
    break;

  case 386: /* lock_mode: AUTOMATIC _lock_with  */
#line 5756 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
  }
#line 17342 "parser.c"
    break;

  case 387: /* lock_mode: EXCLUSIVE _with_mass_update  */
#line 5760 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
  }
#line 17350 "parser.c"
    break;

  case 390: /* _lock_with: WITH _lock ON MULTIPLE lock_records _with_rollback  */
#line 5769 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17358 "parser.c"
    break;

  case 391: /* _lock_with: with_rollback  */
#line 5773 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17366 "parser.c"
    break;

  case 394: /* with_rollback: _with ROLLBACK  */
#line 5784 "../../cobc/parser.y"
  {
	CB_PENDING ("WITH ROLLBACK");
  }
#line 17374 "parser.c"
    break;

  case 396: /* _with_mass_update: _with "MASS-UPDATE"  */
#line 5791 "../../cobc/parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
		/* TODO: pass extra flag to fileio */
		CB_PENDING ("WITH MASS-UPDATE");
	} else {
		cb_error (_("%s only valid with ORGANIZATION %s"), "MASS-UPDATE", "INDEXED");
	}
  }
#line 17388 "parser.c"
    break;

  case 399: /* organization: INDEXED  */
#line 5812 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_INDEXED, "INDEXED");
	current_file->organization = COB_ORG_INDEXED;
  }
#line 17398 "parser.c"
    break;

  case 400: /* organization: _record _binary SEQUENTIAL  */
#line 5818 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_SEQUENTIAL, "SEQUENTIAL");
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 17408 "parser.c"
    break;

  case 401: /* organization: RELATIVE  */
#line 5824 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_RELATIVE, "RELATIVE");
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 17418 "parser.c"
    break;

  case 402: /* organization: LINE SEQUENTIAL  */
#line 5830 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_LINE_SEQUENTIAL,
						"LINE SEQUENTIAL");
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 17429 "parser.c"
    break;

  case 403: /* padding_character_clause: PADDING _character _is reference_or_literal  */
#line 5843 "../../cobc/parser.y"
  {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 17438 "parser.c"
    break;

  case 404: /* $@34: %empty  */
#line 5853 "../../cobc/parser.y"
  {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
	current_file->flag_delimiter = 1;
  }
#line 17447 "parser.c"
    break;

  case 406: /* record_delimiter_option: "STANDARD-1"  */
#line 5862 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "STANDARD-1");
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("%s ignored"), "RECORD DELIMITER STANDARD-1");
	}
  }
#line 17462 "parser.c"
    break;

  case 407: /* record_delimiter_option: "LINE-SEQUENTIAL"  */
#line 5873 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with (LINE) SEQUENTIAL files"),
			  "LINE-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("LINE-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 17480 "parser.c"
    break;

  case 408: /* record_delimiter_option: "BINARY-SEQUENTIAL"  */
#line 5887 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "BINARY-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("BINARY-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_SEQUENTIAL;
	}
  }
#line 17497 "parser.c"
    break;

  case 409: /* record_delimiter_option: "Identifier"  */
#line 5900 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER clause only allowed with (LINE) SEQUENTIAL files"));
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("RECORD DELIMITER %s not recognized; will be ignored"), cb_name (yyvsp[0]));
	}
  }
#line 17512 "parser.c"
    break;

  case 410: /* record_key_clause: RECORD _key _is reference _split_keys _password_clause flag_duplicates  */
#line 5916 "../../cobc/parser.y"
  {
	cb_tree composite_key;

	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = yyvsp[-3];
	key_type = RECORD_KEY;

	/* handle split keys */
	if (yyvsp[-2]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field (yyvsp[-3]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			current_file->key = cb_build_field_reference ((struct cb_field *)composite_key, NULL);
			current_file->component_list = key_component_list;
		}
	}
	current_file->password = yyvsp[-1];
	if (yyvsp[0]) {
		/* note: we *may* add a compiler configuration here,
		         as most dialects do not allow this clause
		         on primary keys */
		if (CB_INTEGER (yyvsp[0])->val) {
			/* note: see ACUCOBOL docs for implementation notes, including [RE]WRITE rules
			         and "if the underlying (file) system does not support them OPEN
					 result in (sucessfull) io-status 0M" */
			CB_PENDING (_("DUPLICATES for primary keys"));
		};

	}
  }
#line 17551 "parser.c"
    break;

  case 411: /* _split_keys: %empty  */
#line 5954 "../../cobc/parser.y"
  {
  	yyval = NULL;
  }
#line 17559 "parser.c"
    break;

  case 412: /* _split_keys: source_is split_key_list  */
#line 5958 "../../cobc/parser.y"
  {
  	yyval = cb_int0;
  }
#line 17567 "parser.c"
    break;

  case 415: /* $@35: %empty  */
#line 5969 "../../cobc/parser.y"
  {
	key_component_list = NULL;
  }
#line 17575 "parser.c"
    break;

  case 418: /* split_key: reference  */
#line 5979 "../../cobc/parser.y"
  {
	struct cb_key_component *c;
	struct cb_key_component *comp = cobc_main_malloc (sizeof(struct cb_key_component));
	comp->next = NULL;
	comp->component = yyvsp[0];
	if (key_component_list == NULL) {
		key_component_list = comp;
	} else {
		for (c = key_component_list; c->next != NULL; c = c->next);
		c->next = comp;
	}
  }
#line 17592 "parser.c"
    break;

  case 419: /* relative_key_clause: RELATIVE _key _is reference  */
#line 5997 "../../cobc/parser.y"
  {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = yyvsp[0];
	key_type = RELATIVE_KEY;
  }
#line 17602 "parser.c"
    break;

  case 420: /* reserve_clause: RESERVE no_or_integer _areas  */
#line 6008 "../../cobc/parser.y"
  {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 17610 "parser.c"
    break;

  case 423: /* sharing_clause: SHARING _with sharing_option  */
#line 6022 "../../cobc/parser.y"
  {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = yyvsp[0];
  }
#line 17619 "parser.c"
    break;

  case 424: /* sharing_option: ALL _other  */
#line 6034 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 17625 "parser.c"
    break;

  case 425: /* sharing_option: NO _other  */
#line 6035 "../../cobc/parser.y"
                                { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 17631 "parser.c"
    break;

  case 426: /* sharing_option: READ ONLY  */
#line 6036 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 17637 "parser.c"
    break;

  case 427: /* file_limit_clause: file_limit_or_limits _is_are thru_list  */
#line 6043 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "FILE-LIMIT");
	check_repeated ("FILE-LIMIT", SYN_CLAUSE_13, &check_duplicate);
  }
#line 17646 "parser.c"
    break;

  case 430: /* actual_key_clause: ACTUAL _key _is reference  */
#line 6058 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "ACTUAL KEY");
	check_repeated ("ACTUAL KEY", SYN_CLAUSE_14, &check_duplicate);
  }
#line 17655 "parser.c"
    break;

  case 431: /* nominal_key_clause: NOMINAL _key _is reference  */
#line 6068 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "NOMINAL KEY");
	check_repeated ("NOMINAL KEY", SYN_CLAUSE_15, &check_duplicate);
  }
#line 17664 "parser.c"
    break;

  case 432: /* track_area_clause: "TRACK-AREA" _is reference_or_literal _characters  */
#line 6078 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-AREA");
	check_repeated ("TRACK-AREA", SYN_CLAUSE_16, &check_duplicate);
  }
#line 17673 "parser.c"
    break;

  case 433: /* track_limit_clause: "TRACK-LIMIT" _is integer track_or_tracks  */
#line 6088 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-LIMIT");
	check_repeated ("TRACK-LIMIT", SYN_CLAUSE_17, &check_duplicate);
  }
#line 17682 "parser.c"
    break;

  case 435: /* _i_o_control: i_o_control_header _i_o_control_entries  */
#line 6099 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 17690 "parser.c"
    break;

  case 436: /* i_o_control_header: "I-O-CONTROL" _dot  */
#line 6106 "../../cobc/parser.y"
{
	check_headers_present(COBC_HD_ENVIRONMENT_DIVISION,
				 COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
}
#line 17700 "parser.c"
    break;

  case 439: /* _i_o_control_entries: i_o_control_list error _dot_or_else_end_of_file_control  */
#line 6116 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 17708 "parser.c"
    break;

  case 446: /* same_clause: SAME _same_option _area _for file_name_list  */
#line 6137 "../../cobc/parser.y"
  {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER (yyvsp[-3])->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 17737 "parser.c"
    break;

  case 447: /* _same_option: %empty  */
#line 6164 "../../cobc/parser.y"
                                { yyval = cb_int0; }
#line 17743 "parser.c"
    break;

  case 448: /* _same_option: RECORD  */
#line 6165 "../../cobc/parser.y"
                                { yyval = cb_int1; }
#line 17749 "parser.c"
    break;

  case 449: /* _same_option: SORT  */
#line 6166 "../../cobc/parser.y"
                                { yyval = cb_int2; }
#line 17755 "parser.c"
    break;

  case 450: /* _same_option: "SORT-MERGE"  */
#line 6167 "../../cobc/parser.y"
                                { yyval = cb_int2; }
#line 17761 "parser.c"
    break;

  case 451: /* apply_clause: APPLY COMMIT _on reference_list  */
#line 6174 "../../cobc/parser.y"
  {
	current_program->apply_commit = yyvsp[0];
	CB_PENDING("APPLY COMMIT");
  }
#line 17770 "parser.c"
    break;

  case 452: /* apply_clause: APPLY "LOCK-HOLDING" _on file_name_list  */
#line 6179 "../../cobc/parser.y"
  {
	CB_PENDING ("APPLY LOCK-HOLDING");
  }
#line 17778 "parser.c"
    break;

  case 453: /* apply_clause: APPLY "PRINT-CONTROL" _on file_name_list  */
#line 6183 "../../cobc/parser.y"
  {
	CB_PENDING ("APPLY PRINT-CONTROL");
  }
#line 17786 "parser.c"
    break;

  case 455: /* apply_clause: obsolete_dos_vs_apply_phrase  */
#line 6188 "../../cobc/parser.y"
  {
	cb_verify (CB_OBSOLETE, _("DOS/VS APPLY phrase"));
  }
#line 17794 "parser.c"
    break;

  case 464: /* $@36: %empty  */
#line 6208 "../../cobc/parser.y"
  {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 17803 "parser.c"
    break;

  case 465: /* multiple_file_tape_clause: MULTIPLE $@36 _file _tape _contains multiple_file_list  */
#line 6213 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 17815 "parser.c"
    break;

  case 488: /* $@37: %empty  */
#line 6293 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_WORKING;
  }
#line 17823 "parser.c"
    break;

  case 492: /* data: DATA  */
#line 6308 "../../cobc/parser.y"
           { check_area_a_of ("DATA DIVISION"); }
#line 17829 "parser.c"
    break;

  case 493: /* data_division_header: data DIVISION _dot  */
#line 6311 "../../cobc/parser.y"
  {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 17837 "parser.c"
    break;

  case 494: /* tok_file: "FILE"  */
#line 6318 "../../cobc/parser.y"
                   { check_area_a_of ("FILE SECTION"); }
#line 17843 "parser.c"
    break;

  case 496: /* _file_section_header: tok_file SECTION _dot  */
#line 6321 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 17853 "parser.c"
    break;

  case 499: /* file_description: file_description_entry _record_description_list  */
#line 6335 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			/* Do not keep Record if this is really a report */
			if (!current_file->reports) {
				finalize_file (current_file, CB_FIELD (yyvsp[0]));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 17870 "parser.c"
    break;

  case 500: /* $@38: %empty  */
#line 6353 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE (yyvsp[0])) {
		current_file = NULL;
		YYERROR;
	}
	current_file = CB_FILE (cb_ref (yyvsp[0]));
	current_file->description_entry = yyvsp[0];
	if (CB_VALID_TREE (current_file)) {
		if (yyvsp[-1] == cb_int1) {
			current_file->organization = COB_ORG_SORT;
		}
		/* note: this is a HACK and should be moved */
		if (current_file->flag_finalized) {
			cb_error_x (yyvsp[0], _("duplicate file description for %s"),
				cb_name (CB_TREE (current_file)));
		}
	}
  }
#line 17897 "parser.c"
    break;

  case 502: /* file_description_entry: file_type error _dot_or_else_end_of_file_description  */
#line 6377 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 17905 "parser.c"
    break;

  case 503: /* file_type: FD  */
#line 6384 "../../cobc/parser.y"
  {
	check_area_a_of ("FD");
	yyval = cb_int0;
  }
#line 17914 "parser.c"
    break;

  case 504: /* file_type: SD  */
#line 6389 "../../cobc/parser.y"
  {
	check_area_a_of ("SD");
	yyval = cb_int1;
  }
#line 17923 "parser.c"
    break;

  case 507: /* file_description_clause: _is EXTERNAL  */
#line 6401 "../../cobc/parser.y"
  {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	current_file->flag_external = 1;
  }
#line 17937 "parser.c"
    break;

  case 508: /* file_description_clause: _is GLOBAL  */
#line 6411 "../../cobc/parser.y"
  {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 17956 "parser.c"
    break;

  case 518: /* block_contains_clause: BLOCK _contains integer _to_integer _records_or_characters  */
#line 6441 "../../cobc/parser.y"
  {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 17965 "parser.c"
    break;

  case 522: /* record_clause: RECORD _contains integer _characters  */
#line 6454 "../../cobc/parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (NULL, yyvsp[-1]);
	}
  }
#line 17978 "parser.c"
    break;

  case 523: /* record_clause: RECORD _contains integer TO integer _characters _record_depending  */
#line 6464 "../../cobc/parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (yyvsp[-4], yyvsp[-2]);
		if (yyvsp[0]) {
			cb_verify (cb_record_contains_depending_clause, "RECORD CONTAINS DEPENDING");
			current_file->record_depending = yyvsp[0];
			current_file->flag_check_record_varying_limits =
				current_file->record_min == 0 || current_file->record_max == 0;
		}
	}
  }
#line 17997 "parser.c"
    break;

  case 524: /* record_clause: RECORD _is VARYING _in _size _from_integer _to_integer _characters _record_depending  */
#line 6480 "../../cobc/parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	set_record_size (yyvsp[-3], yyvsp[-2]);
	current_file->record_depending = yyvsp[0];
	current_file->flag_check_record_varying_limits =
		current_file->record_min == 0 || current_file->record_max == 0;
  }
#line 18009 "parser.c"
    break;

  case 525: /* _record_depending: %empty  */
#line 6490 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 18015 "parser.c"
    break;

  case 526: /* _record_depending: DEPENDING _on reference  */
#line 6491 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 18021 "parser.c"
    break;

  case 527: /* _from_integer: %empty  */
#line 6495 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 18027 "parser.c"
    break;

  case 528: /* _from_integer: _from integer  */
#line 6496 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 18033 "parser.c"
    break;

  case 529: /* _to_integer: %empty  */
#line 6500 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 18039 "parser.c"
    break;

  case 530: /* _to_integer: TO integer  */
#line 6501 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 18045 "parser.c"
    break;

  case 531: /* label_records_clause: LABEL records label_option  */
#line 6509 "../../cobc/parser.y"
  {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 18054 "parser.c"
    break;

  case 532: /* value_of_clause: VALUE OF file_id _is valueof_name  */
#line 6520 "../../cobc/parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 18063 "parser.c"
    break;

  case 533: /* value_of_clause: VALUE OF "FILE-ID" _is valueof_name  */
#line 6525 "../../cobc/parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
	}
  }
#line 18075 "parser.c"
    break;

  case 538: /* data_records_clause: DATA records optional_reference_list  */
#line 6548 "../../cobc/parser.y"
  {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 18084 "parser.c"
    break;

  case 539: /* linage_clause: LINAGE _is reference_or_literal _lines _linage_sequence  */
#line 6560 "../../cobc/parser.y"
  {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = yyvsp[-2];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 18103 "parser.c"
    break;

  case 545: /* linage_footing: _with FOOTING _at reference_or_literal  */
#line 6588 "../../cobc/parser.y"
  {
	current_file->latfoot = yyvsp[0];
  }
#line 18111 "parser.c"
    break;

  case 546: /* linage_top: TOP reference_or_literal  */
#line 6595 "../../cobc/parser.y"
  {
	current_file->lattop = yyvsp[0];
  }
#line 18119 "parser.c"
    break;

  case 547: /* linage_bottom: BOTTOM reference_or_literal  */
#line 6602 "../../cobc/parser.y"
  {
	current_file->latbot = yyvsp[0];
  }
#line 18127 "parser.c"
    break;

  case 548: /* recording_mode_clause: RECORDING _mode _is recording_mode  */
#line 6611 "../../cobc/parser.y"
  {
	cobc_cs_check ^= CB_CS_RECORDING;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 18137 "parser.c"
    break;

  case 553: /* recording_mode: u_or_s  */
#line 6624 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 18147 "parser.c"
    break;

  case 556: /* code_set_clause: "CODE-SET" _is alphabet_name _for_sub_records_clause  */
#line 6640 "../../cobc/parser.y"
  {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE (yyvsp[-1])) {
		al = CB_ALPHABET_NAME (cb_ref (yyvsp[-1]));
		/* FIXME: should be set depending on program alphabet */
		switch (al->alphabet_type) {
		case CB_ALPHABET_CUSTOM:
			CB_PENDING ("custom CODE-SET");
			current_file->code_set = al;
			break;
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
			CB_UNFINISHED ("CODE-SET");
			current_file->code_set = al;
			break;
		default:
			if (get_warn_opt_value (cb_warn_additional) != COBC_WARN_DISABLED) {
				cb_note_x (cb_warn_additional, yyvsp[-1], _("ignoring CODE-SET '%s'"),
						  cb_name (yyvsp[-1]));
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

  }
#line 18188 "parser.c"
    break;

  case 558: /* _for_sub_records_clause: FOR reference_list  */
#line 6680 "../../cobc/parser.y"
  {
	  current_file->code_set_items = CB_LIST (yyvsp[0]);
  }
#line 18196 "parser.c"
    break;

  case 559: /* report_clause: report_keyword rep_name_list  */
#line 6689 "../../cobc/parser.y"
  {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = yyvsp[0];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->flag_line_adv = 1;
	}
  }
#line 18212 "parser.c"
    break;

  case 562: /* rep_name_list: undefined_word  */
#line 6709 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 18230 "parser.c"
    break;

  case 563: /* rep_name_list: rep_name_list undefined_word  */
#line 6723 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 18248 "parser.c"
    break;

  case 564: /* communication: COMMUNICATION  */
#line 6740 "../../cobc/parser.y"
                             { check_area_a_of ("COMMUNICATION SECTION"); }
#line 18254 "parser.c"
    break;

  case 566: /* $@39: %empty  */
#line 6743 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define != CB_STD_85
	 && cb_std_define != CB_STD_RM
	 && cb_std_define != CB_STD_GC
	 && !cb_relaxed_syntax_checks) {
		cb_verify (CB_UNCONFORMABLE, "COMMUNICATION SECTION");
	} else if (cb_verify (CB_OBSOLETE, "COMMUNICATION SECTION")) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 18273 "parser.c"
    break;

  case 570: /* communication_description: communication_description_entry _record_description_list  */
#line 6767 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			cb_finalize_cd (current_cd, CB_FIELD (yyvsp[0]));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 18287 "parser.c"
    break;

  case 571: /* cd: CD  */
#line 6780 "../../cobc/parser.y"
       { check_area_a_of ("CD"); }
#line 18293 "parser.c"
    break;

  case 572: /* $@40: %empty  */
#line 6783 "../../cobc/parser.y"
  {
	/* CD internally defines a new file */
	if (CB_VALID_TREE (yyvsp[0])) {
		current_cd = cb_build_cd (yyvsp[0]);

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TO-DO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 18315 "parser.c"
    break;

  case 619: /* working_storage: "WORKING-STORAGE"  */
#line 6890 "../../cobc/parser.y"
                                 { check_area_a_of ("WORKING-STORAGE SECTION"); }
#line 18321 "parser.c"
    break;

  case 621: /* $@41: %empty  */
#line 6894 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 18331 "parser.c"
    break;

  case 622: /* _working_storage_section: working_storage SECTION _dot_or_else_end_of_record_description $@41 _record_description_list  */
#line 6900 "../../cobc/parser.y"
  {
	if (yyvsp[0]) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD (yyvsp[0]));
	}
  }
#line 18341 "parser.c"
    break;

  case 623: /* _record_description_list: %empty  */
#line 6909 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 18349 "parser.c"
    break;

  case 624: /* $@42: %empty  */
#line 6913 "../../cobc/parser.y"
  {
	current_field = NULL;
	control_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 18360 "parser.c"
    break;

  case 625: /* _record_description_list: $@42 record_description_list  */
#line 6920 "../../cobc/parser.y"
  {
	yyval = get_finalized_description_tree ();
  }
#line 18368 "parser.c"
    break;

  case 631: /* $@43: %empty  */
#line 6935 "../../cobc/parser.y"
  {
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		/* finalize last field if target of SAME AS / type-name */
		inherit_external_definition (yyvsp[-1]);
	}
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	save_tree = NULL;
  }
#line 18383 "parser.c"
    break;

  case 632: /* data_description: level_number _entry_name $@43 _data_description_clause_sequence  */
#line 6946 "../../cobc/parser.y"
  {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 18396 "parser.c"
    break;

  case 633: /* data_description: level_number error "."  */
#line 6955 "../../cobc/parser.y"
  {
#if 0 /* works fine without, leads to invalid free otherwise [COB_TREE_DEBUG] */
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-2]);
#endif
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if 0 /* CHECKME - *Why* would we want to change the field here? */
	current_field = cb_get_real_field ();
#endif
  }
#line 18414 "parser.c"
    break;

  case 634: /* level_number: not_const_word "level-number"  */
#line 6972 "../../cobc/parser.y"
  {
	int level = cb_get_level (yyvsp[0]);
	switch (level) {
	case 1:
	case 77:
		check_area_a (yyvsp[0]);
		break;
	default:
		break;
	}
	yyval = yyvsp[0];
  }
#line 18431 "parser.c"
    break;

  case 635: /* level_number: not_const_word "level-number (Area A)"  */
#line 6985 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18439 "parser.c"
    break;

  case 638: /* _entry_name: _filler  */
#line 6997 "../../cobc/parser.y"
  {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18450 "parser.c"
    break;

  case 640: /* user_entry_name: "Identifier"  */
#line 7008 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
	qualifier = yyvsp[0];
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18461 "parser.c"
    break;

  case 641: /* _const_global: %empty  */
#line 7018 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 18469 "parser.c"
    break;

  case 642: /* _const_global: _is GLOBAL  */
#line 7022 "../../cobc/parser.y"
  {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		yyval = NULL;
	} else {
		yyval = cb_null;
	}
  }
#line 18482 "parser.c"
    break;

  case 643: /* lit_or_length: literal  */
#line 7033 "../../cobc/parser.y"
                                        { yyval = yyvsp[0]; }
#line 18488 "parser.c"
    break;

  case 644: /* lit_or_length: length_of_register con_source  */
#line 7034 "../../cobc/parser.y"
                                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 18494 "parser.c"
    break;

  case 645: /* lit_or_length: "BYTE-LENGTH" _of con_source  */
#line 7036 "../../cobc/parser.y"
                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 18500 "parser.c"
    break;

  case 646: /* con_source: identifier_1  */
#line 7041 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18508 "parser.c"
    break;

  case 647: /* con_source: non_numeric_literal  */
#line 7045 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18516 "parser.c"
    break;

  case 648: /* con_source: "BINARY-CHAR"  */
#line 7051 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 18524 "parser.c"
    break;

  case 649: /* con_source: "BINARY-SHORT"  */
#line 7055 "../../cobc/parser.y"
  {
	yyval = cb_int2;
  }
#line 18532 "parser.c"
    break;

  case 650: /* con_source: "BINARY-LONG"  */
#line 7059 "../../cobc/parser.y"
  {
	yyval = cb_int4;
  }
#line 18540 "parser.c"
    break;

  case 651: /* con_source: "BINARY-DOUBLE"  */
#line 7063 "../../cobc/parser.y"
  {
	yyval = cb_int8;
  }
#line 18548 "parser.c"
    break;

  case 652: /* con_source: "BINARY-C-LONG"  */
#line 7067 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(long));
  }
#line 18556 "parser.c"
    break;

  case 653: /* con_source: pointer_len  */
#line 7071 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(void *));
  }
#line 18564 "parser.c"
    break;

  case 654: /* con_source: "COMP-1"  */
#line 7075 "../../cobc/parser.y"
  {
	if (cb_binary_comp_1) {
		yyval = cb_int2;
	} else {
		yyval = cb_int ((int)sizeof(float));
	}
  }
#line 18576 "parser.c"
    break;

  case 655: /* con_source: "FLOAT-SHORT"  */
#line 7083 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(float));
  }
#line 18584 "parser.c"
    break;

  case 656: /* con_source: double_usage  */
#line 7087 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(double));
  }
#line 18592 "parser.c"
    break;

  case 657: /* con_source: long_double  */
#line 7091 "../../cobc/parser.y"
  {
#if 1 /* fixed-sized as in field.c */
	yyval = cb_int (16);
#else
	yyval = cb_int ((int)sizeof(long double));
#endif
  }
#line 18604 "parser.c"
    break;

  case 658: /* con_source: fp32_usage  */
#line 7099 "../../cobc/parser.y"
  {
	yyval = cb_int4;
  }
#line 18612 "parser.c"
    break;

  case 659: /* con_source: fp64_usage  */
#line 7103 "../../cobc/parser.y"
  {
	yyval = cb_int8;
  }
#line 18620 "parser.c"
    break;

  case 660: /* con_source: fp128_usage  */
#line 7107 "../../cobc/parser.y"
  {
	yyval = cb_int16;
  }
#line 18628 "parser.c"
    break;

  case 661: /* con_source: error "."  */
#line 7111 "../../cobc/parser.y"
  {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 18640 "parser.c"
    break;

  case 670: /* renames_entry: "level-number 66" user_entry_name RENAMES not_const_word qualified_word _renames_thru  */
#line 7142 "../../cobc/parser.y"
  {
	cb_tree renames_target = cb_ref (yyvsp[-1]);

	size_t sav = cb_needs_01;
	cb_needs_01 = 0;

	non_const_word = 0;

	if (set_current_field (yyvsp[-5], yyvsp[-4])) {
		/* error in the definition, no further checks possible */
	} else if (renames_target == cb_error_node) {
		/* error in the target, skip further checks */
		current_field->flag_invalid = 1;
	} else {
		cb_tree renames_thru = yyvsp[0];

		current_field->redefines = CB_FIELD (renames_target);
		if (renames_thru) {
			renames_thru = cb_ref (renames_thru);
		}
		if (CB_VALID_TREE (renames_thru)) {
			current_field->rename_thru = CB_FIELD (renames_thru);
		} else {
			/* If there is no THRU clause, RENAMES acts like REDEFINES. */
			current_field->pic = current_field->redefines->pic;
		}

		if (cb_validate_renames_item (current_field, yyvsp[-1], yyvsp[0])) {
			current_field->flag_invalid = 1;
		} else {
			/* ensure the reference was validated as this
			   also calculates the reference' picture and size */
			if (!current_field->redefines->flag_is_verified) {
				cb_validate_field (current_field->redefines);
			}
		}
	}
	cb_needs_01 = sav;
  }
#line 18684 "parser.c"
    break;

  case 671: /* _renames_thru: %empty  */
#line 7185 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 18692 "parser.c"
    break;

  case 672: /* _renames_thru: THRU qualified_word  */
#line 7189 "../../cobc/parser.y"
  {
	yyval = yyvsp[0] == cb_error_node ? NULL : yyvsp[0];
  }
#line 18700 "parser.c"
    break;

  case 673: /* $@44: %empty  */
#line 7196 "../../cobc/parser.y"
  {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 18710 "parser.c"
    break;

  case 674: /* condition_name_entry: "level-number 88" _user_entry_name $@44 value_clause_condition  */
#line 7202 "../../cobc/parser.y"
  {
	cb_validate_88_item (current_field);
  }
#line 18718 "parser.c"
    break;

  case 675: /* _user_entry_name: %empty  */
#line 7209 "../../cobc/parser.y"
  {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18729 "parser.c"
    break;

  case 677: /* constant_entry: level_number user_entry_name CONSTANT _const_global constant_source  */
#line 7220 "../../cobc/parser.y"
  {
	cb_tree x;
	int	level;

	cobc_cs_check = 0;
	level = cb_get_level (yyvsp[-4]);
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-4]);
	if (level != 1) {
		cb_error (_("CONSTANT item not at 01 level"));
	} else if (yyvsp[0]) {
		if (cb_verify (cb_constant_01, "01 CONSTANT")) {
			x = cb_build_constant (yyvsp[-3], yyvsp[0]);
			CB_FIELD (x)->flag_item_78 = 1;
			CB_FIELD (x)->flag_constant = 1;
			CB_FIELD (x)->level = 1;
			CB_FIELD (x)->values = yyvsp[0];
			cb_needs_01 = 1;
			if (yyvsp[-1]) {
				CB_FIELD (x)->flag_is_global = 1;
			}
			/* Ignore return value */
			(void)cb_validate_78_item (CB_FIELD (x), 0);
		}
	}
  }
#line 18760 "parser.c"
    break;

  case 678: /* $@45: %empty  */
#line 7247 "../../cobc/parser.y"
  {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 18770 "parser.c"
    break;

  case 679: /* constant_entry: "level-number 78" user_entry_name $@45 _global_clause VALUE _is constant_78_source  */
#line 7254 "../../cobc/parser.y"
  {
	/* Reset to last non-78 item */
	current_field = cb_validate_78_item (current_field, 0);
  }
#line 18779 "parser.c"
    break;

  case 680: /* constant_source: _as constant_expression_list  */
#line 7262 "../../cobc/parser.y"
  {
	/* this can be a list containing an arithmetic expression */
	if (CB_LIST_P (yyvsp[0]) && !CB_CHAIN (yyvsp[0])) {
		yyval = CB_VALUE (yyvsp[0]);
	} else {
		yyval = yyvsp[0];
	}
  }
#line 18792 "parser.c"
    break;

  case 681: /* constant_source: FROM "Identifier"  */
#line 7271 "../../cobc/parser.y"
  {
	yyval = cb_build_const_from (yyvsp[0]);
  }
#line 18800 "parser.c"
    break;

  case 682: /* constant_78_source: constant_expression_list  */
#line 7278 "../../cobc/parser.y"
  {
	/* this can be a list containing an arithmetic expression */
	if (CB_VALID_TREE (current_field)) {
		if (CB_LIST_P (yyvsp[0]) && !CB_CHAIN (yyvsp[0])) {
			current_field->values = CB_VALUE (yyvsp[0]);
		} else {
			current_field->values = yyvsp[0];
		}
	}
  }
#line 18815 "parser.c"
    break;

  case 683: /* constant_78_source: START _of identifier  */
#line 7289 "../../cobc/parser.y"
  {
	current_field->values = cb_build_const_start (current_field, yyvsp[0]);
  }
#line 18823 "parser.c"
    break;

  case 684: /* constant_78_source: NEXT  */
#line 7293 "../../cobc/parser.y"
  {
	current_field->values = cb_build_const_next (current_field);
  }
#line 18831 "parser.c"
    break;

  case 685: /* constant_expression_list: constant_expression  */
#line 7299 "../../cobc/parser.y"
                                        { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 18837 "parser.c"
    break;

  case 686: /* constant_expression_list: constant_expression_list constant_expression  */
#line 7300 "../../cobc/parser.y"
                                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 18843 "parser.c"
    break;

  case 687: /* constant_expression: lit_or_length  */
#line 7304 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 18849 "parser.c"
    break;

  case 688: /* constant_expression: "("  */
#line 7305 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("(", 1); }
#line 18855 "parser.c"
    break;

  case 689: /* constant_expression: ")"  */
#line 7306 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal (")", 1); }
#line 18861 "parser.c"
    break;

  case 690: /* constant_expression: "+"  */
#line 7307 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("+", 1); }
#line 18867 "parser.c"
    break;

  case 691: /* constant_expression: "-"  */
#line 7308 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("-", 1); }
#line 18873 "parser.c"
    break;

  case 692: /* constant_expression: "*"  */
#line 7309 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("*", 1); }
#line 18879 "parser.c"
    break;

  case 693: /* constant_expression: "/"  */
#line 7310 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("/", 1); }
#line 18885 "parser.c"
    break;

  case 694: /* constant_expression: AND  */
#line 7311 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("&", 1); }
#line 18891 "parser.c"
    break;

  case 695: /* constant_expression: OR  */
#line 7312 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("|", 1); }
#line 18897 "parser.c"
    break;

  case 696: /* constant_expression: "exponentiation operator"  */
#line 7313 "../../cobc/parser.y"
                                { yyval = cb_build_alphanumeric_literal ("^", 1); }
#line 18903 "parser.c"
    break;

  case 699: /* data_description_clause_sequence: data_description_clause  */
#line 7323 "../../cobc/parser.y"
  {
	save_tree = cb_int0;
  }
#line 18911 "parser.c"
    break;

  case 730: /* data_description_clause: data_varying_clause  */
#line 7360 "../../cobc/parser.y"
  {
	CB_PENDING ("VALIDATE");
  }
#line 18919 "parser.c"
    break;

  case 731: /* redefines_clause: REDEFINES identifier_1  */
#line 7370 "../../cobc/parser.y"
  {
	check_repeated ("REDEFINES", SYN_CLAUSE_1, &check_pic_duplicate);
	if (save_tree != NULL) {
		cb_verify_x (yyvsp[0], cb_free_redefines_position,
			     _("REDEFINES clause not following entry-name"));
	}

	current_field->redefines = cb_resolve_redefines (current_field, yyvsp[0]);
	if (current_field->redefines == NULL) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		YYERROR;
	}
  }
#line 18938 "parser.c"
    break;

  case 732: /* like_clause: LIKE identifier_field _length_modifier  */
#line 7391 "../../cobc/parser.y"
  {
	if (!check_repeated ("LIKE", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		setup_external_definition (yyvsp[-1], 0);
		current_field->like_modifier = yyvsp[0];
		CB_PENDING_X (yyvsp[-1], "LIKE clause");
	}
  }
#line 18953 "parser.c"
    break;

  case 733: /* _length_modifier: %empty  */
#line 7404 "../../cobc/parser.y"
                { yyval = cb_int0; }
#line 18959 "parser.c"
    break;

  case 734: /* _length_modifier: length_modifier  */
#line 7405 "../../cobc/parser.y"
                        { yyval = yyvsp[0]; }
#line 18965 "parser.c"
    break;

  case 735: /* length_modifier: "(" nonzero_numeric_literal ")"  */
#line 7409 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
  }
#line 18973 "parser.c"
    break;

  case 736: /* same_as_clause: SAME _as identifier_field  */
#line 7418 "../../cobc/parser.y"
  {
	if (!check_repeated ("SAME AS", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		cb_verify (cb_same_as_clause, _("SAME AS clause"));
		setup_external_definition (yyvsp[0], 0);
	}


  }
#line 18989 "parser.c"
    break;

  case 737: /* typedef_clause: _is TYPEDEF _strong  */
#line 7437 "../../cobc/parser.y"
  {
	if (current_field->flag_is_typedef) {
		emit_duplicate_clause_message ("TYPEDEF");
		YYERROR;
	}
	/* note: no explicit verification as all dialects with this reserved word use it */
	current_field->flag_is_typedef = 1;
	within_typedef_definition = 1;

	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "TYPEDEF");
	}
	if (!qualifier) {
		cb_error (_("%s requires a data name"), "TYPEDEF");
	}
	if (current_storage == CB_STORAGE_SCREEN
	 || current_storage == CB_STORAGE_REPORT) {
		cb_error (_("%s not allowed in %s"), "TYPEDEF",
			enum_explain_storage(current_storage));
	}
  }
#line 19015 "parser.c"
    break;

  case 739: /* _strong: STRONG  */
#line 7462 "../../cobc/parser.y"
  {
	CB_PENDING ("TYPEDEF STRONG");
  }
#line 19023 "parser.c"
    break;

  case 740: /* external_clause: _is EXTERNAL _as_extname  */
#line 7472 "../../cobc/parser.y"
  {
	check_repeated ("EXTERNAL", SYN_CLAUSE_2, &check_pic_duplicate);
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "EXTERNAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_is_global) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "REDEFINES");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	} else {
		current_field->flag_external = 1;
		current_program->flag_has_external = 1;
	}
  }
#line 19051 "parser.c"
    break;

  case 741: /* _as_extname: %empty  */
#line 7499 "../../cobc/parser.y"
  {
	current_field->ename = cb_to_cname (current_field->name);
  }
#line 19059 "parser.c"
    break;

  case 742: /* _as_extname: AS "Literal"  */
#line 7503 "../../cobc/parser.y"
  {
	current_field->ename = cb_to_cname ((const char *)CB_LITERAL (yyvsp[0])->data);
  }
#line 19067 "parser.c"
    break;

  case 745: /* global_clause: _is GLOBAL  */
#line 7516 "../../cobc/parser.y"
  {
	check_repeated ("GLOBAL", SYN_CLAUSE_3, &check_pic_duplicate);
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "GLOBAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "GLOBAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else if (current_storage == CB_STORAGE_LOCAL) {
		cb_error (_("%s not allowed here"), "GLOBAL");
	} else {
		current_field->flag_is_global = 1;
	}
  }
#line 19090 "parser.c"
    break;

  case 746: /* $@46: %empty  */
#line 7540 "../../cobc/parser.y"
  {
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_verify (cb_special_names_clause, "SPECIAL-NAMES clause");
	}
  }
#line 19102 "parser.c"
    break;

  case 748: /* special_names_target: CURSOR  */
#line 7552 "../../cobc/parser.y"
  {
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		current_program->cursor_pos = cb_build_reference (current_field->name);
	}
  }
#line 19114 "parser.c"
    break;

  case 749: /* special_names_target: CRT STATUS  */
#line 7560 "../../cobc/parser.y"
  {
	if (current_program->crt_status) {
		emit_duplicate_clause_message ("CRT STATUS");
	} else {
		current_program->crt_status = cb_build_reference (current_field->name);
	}
  }
#line 19126 "parser.c"
    break;

  case 750: /* special_names_target: "SCREEN CONTROL"  */
#line 7577 "../../cobc/parser.y"
  {
#if 0 /* not yet implemented */
	if (current_program->screen_control) {
		emit_duplicate_clause_message ("SCREEN CONTROL");
	} else {
		CB_PENDING ("SCREEN CONTROL");
	}
#else
	CB_PENDING ("SCREEN CONTROL");
#endif
  }
#line 19142 "parser.c"
    break;

  case 751: /* special_names_target: "EVENT STATUS"  */
#line 7589 "../../cobc/parser.y"
  {
#if 0 /* not yet implemented */
	if (current_program->event_status) {
		emit_duplicate_clause_message ("EVENT STATUS");
	} else {
		CB_PENDING ("EVENT STATUS");
	}
#else
	CB_PENDING ("EVENT STATUS");
#endif
  }
#line 19158 "parser.c"
    break;

  case 752: /* $@47: %empty  */
#line 7606 "../../cobc/parser.y"
  {
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_ ("%s only allowed at 01/77 level"), "SELECT WHEN");
	}
	CB_PENDING ("SELECT WHEN");
  }
#line 19169 "parser.c"
    break;

  case 756: /* format_clause: FORMAT format_choice _data  */
#line 7624 "../../cobc/parser.y"
  {
	CB_PENDING ("FORMAT");
  }
#line 19177 "parser.c"
    break;

  case 757: /* format_choice: BIT  */
#line 7630 "../../cobc/parser.y"
                { yyval = cb_int0; }
#line 19183 "parser.c"
    break;

  case 758: /* format_choice: CHARACTER  */
#line 7631 "../../cobc/parser.y"
                { yyval = cb_int1; }
#line 19189 "parser.c"
    break;

  case 759: /* format_choice: NUMERIC  */
#line 7632 "../../cobc/parser.y"
                { yyval = cb_int2; }
#line 19195 "parser.c"
    break;

  case 760: /* volatile_clause: VOLATILE  */
#line 7639 "../../cobc/parser.y"
  {
	check_repeated ("VOLATILE", SYN_CLAUSE_24, &check_pic_duplicate);
	/* note: there is no reason to check current_storage as we only parse
	         volatile_clause and its parent tokens where applicable,
	         same is true for level 66,78,88 */
	/* missing part: always generate and initialize storage */
	CB_UNFINISHED ("VOLATILE");
	current_field->flag_volatile = 1;
	/* TODO: set VOLATILE flag for all parent fields */
  }
#line 19210 "parser.c"
    break;

  case 761: /* $@48: %empty  */
#line 7656 "../../cobc/parser.y"
  {
	check_repeated ("PICTURE", SYN_CLAUSE_4, &check_pic_duplicate);
	current_field->pic = CB_PICTURE (yyvsp[0]);	/* always returned, invalid picture will have size == 0 */
  }
#line 19219 "parser.c"
    break;

  case 762: /* picture_clause: PICTURE $@48 _pic_locale_format_or_depending_on_or_byte_length  */
#line 7661 "../../cobc/parser.y"
  {
	if ((!current_field->pic || current_field->pic->variable_length) &&
	    !current_field->flag_picture_l) {
		/* Current field with PIC L was not translated */
		cb_error_x (CB_TREE (current_field->pic),
			      _("%s requires DEPENDING clause"),
			      _("variable-length PICTURE"));
	}
  }
#line 19233 "parser.c"
    break;

  case 764: /* _pic_locale_format_or_depending_on_or_byte_length: LOCALE _is_locale_name SIZE _is integer  */
#line 7675 "../../cobc/parser.y"
  {
	/* $2 -> optional locale-name to be used */
	if (  (current_field->pic->category != CB_CATEGORY_NUMERIC
	    && current_field->pic->category != CB_CATEGORY_NUMERIC_EDITED)
	   || strpbrk (current_field->pic->orig, " CRDBL-*")) {
		/* CHECKME: the standard seems to forbid additional ',' */
		cb_error_x (CB_TREE (current_field->pic),
			      _("a locale-format PICTURE string must only consist of '9', '.', '+', 'Z' and the currency-sign"));
	} else {
		/* TODO: check that not we're not within a CONSTANT RECORD */
		CB_PENDING_X (CB_TREE (current_field->pic), "locale-format PICTURE");
	}
  }
#line 19251 "parser.c"
    break;

  case 765: /* _pic_locale_format_or_depending_on_or_byte_length: DEPENDING _on reference  */
#line 7689 "../../cobc/parser.y"
  {
	cb_tree depending = yyvsp[0];
	if (!current_field->pic->variable_length) {
		cb_error_x (yyvsp[0], _("DEPENDING clause needs either an "
				    "OCCURS clause or a variable-length "
				    "PICTURE"));
	} else
	if (current_field->pic->category != CB_CATEGORY_ALPHABETIC
	 && current_field->pic->category != CB_CATEGORY_ALPHANUMERIC) {
		cb_error_x (yyvsp[0], _("only USAGE DISPLAY may specify a "
				    "variable-length PICTURE"));
	} else
	if (current_storage == CB_STORAGE_SCREEN
	 || current_storage == CB_STORAGE_REPORT) {
		cb_error_x (yyvsp[0], _("%s not allowed in %s"),
			      _("variable-length PICTURE"),
			      enum_explain_storage (current_storage));
	} else {
		  /* Implicitly translate `PIC Lc... DEPENDING N` (where
		     `c` may actually only be `X` or `A`) into a group
		     with a single sub-field `PIC c OCCURS 1 TO N`. */
		  const char pic[2] = { current_field->pic->orig[1], 0};
		  struct cb_field * const chld =
			  CB_FIELD (cb_build_field (cb_build_filler ()));
		  chld->pic = cb_build_picture (pic);
		  chld->storage = current_field->storage;
		  chld->depending = depending;
		  chld->flag_occurs = 1;
		  chld->occurs_min = 1;
		  chld->occurs_max = current_field->pic->size - 1;
		  chld->parent = current_field;
		  current_field->children = chld;
		  cobc_parse_free (current_field->pic);
		  current_field->pic = NULL;
	}
	/* Raise this flag in the error cases above, to avoid unrelated
	   warning or error messages upon tentative validation of
	   redefines.  */
	current_field->flag_picture_l = 1;
  }
#line 19296 "parser.c"
    break;

  case 767: /* _is_locale_name: %empty  */
#line 7734 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 19304 "parser.c"
    break;

  case 768: /* _is_locale_name: _is locale_name  */
#line 7738 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 19312 "parser.c"
    break;

  case 769: /* locale_name: "Identifier"  */
#line 7745 "../../cobc/parser.y"
  {
	if (CB_LOCALE_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a locale-name"),	cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 19325 "parser.c"
    break;

  case 770: /* type_to_clause: TYPE _to type_name  */
#line 7759 "../../cobc/parser.y"
  {
	cb_verify (cb_type_to_clause, _("TYPE TO clause"));
	setup_external_definition_type (yyvsp[0]);
  }
#line 19334 "parser.c"
    break;

  case 773: /* usage_clause: USAGE _is "Identifier"  */
#line 7775 "../../cobc/parser.y"
  {
	{
		cb_tree x = cb_try_ref (yyvsp[0]);
		if (!CB_INVALID_TREE (x) && CB_FIELD_P (x) && CB_FIELD (x)->flag_is_typedef) {
			if (!check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate)) {
				if (current_field->external_definition) {
					emit_conflicting_clause_message ("USAGE", "SAME AS / TYPE TO");
				} else {
					cb_verify (cb_usage_type_name, _("USAGE type-name"));
					/* replace usage by type definition */
					check_pic_duplicate &= ~SYN_CLAUSE_5;
					check_repeated ("USAGE/TYPE", SYN_CLAUSE_31, &check_pic_duplicate);
					setup_external_definition (yyvsp[0], 1);
					break;	/* everything done here */
				}
			}
			YYERROR;
		}
	}
	if (is_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not a valid USAGE"), CB_NAME (yyvsp[0]));
	} else if (is_default_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not defined, but is a reserved word in another dialect"),
				CB_NAME (yyvsp[0]));
	} else {
		cb_error_x (yyvsp[0], _("unknown USAGE: %s"), CB_NAME (yyvsp[0]));
	}
	check_and_set_usage (CB_USAGE_ERROR);
	YYERROR;
  }
#line 19369 "parser.c"
    break;

  case 774: /* usage_clause: USAGE _is error  */
#line 7806 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_ERROR);
  }
#line 19377 "parser.c"
    break;

  case 777: /* usage: BINARY  */
#line 7817 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 19385 "parser.c"
    break;

  case 778: /* usage: BIT  */
#line 7821 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_BIT);
	CB_PENDING ("USAGE BIT");
  }
#line 19394 "parser.c"
    break;

  case 779: /* usage: BIT ALIGNED  */
#line 7826 "../../cobc/parser.y"
  {
	/* note: ALIGNED actually is a separate clause but at least
	         for now we simplify it, requesting it after USAGE BIT */
	check_and_set_usage (CB_USAGE_BIT);
	CB_PENDING ("USAGE BIT");
  }
#line 19405 "parser.c"
    break;

  case 780: /* usage: COMP  */
#line 7833 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 19413 "parser.c"
    break;

  case 781: /* usage: "COMP-0"  */
#line 7837 "../../cobc/parser.y"
  {
	/* see FR #310 */
	CB_PENDING ("USAGE COMP-0");
  }
#line 19422 "parser.c"
    break;

  case 782: /* usage: "COMP-1"  */
#line 7842 "../../cobc/parser.y"
  {
	current_field->flag_comp_1 = 1;
	if (cb_binary_comp_1) {
		check_and_set_usage (CB_USAGE_SIGNED_SHORT);
	} else {
		check_and_set_usage (CB_USAGE_FLOAT);
	}
  }
#line 19435 "parser.c"
    break;

  case 783: /* usage: double_usage  */
#line 7851 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_DOUBLE);
  }
#line 19443 "parser.c"
    break;

  case 784: /* usage: long_double  */
#line 7855 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_LONG_DOUBLE);
	CB_UNFINISHED ("FLOAT-EXTENDED");
  }
#line 19452 "parser.c"
    break;

  case 785: /* usage: "COMP-3"  */
#line 7860 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 19460 "parser.c"
    break;

  case 786: /* usage: "COMP-4"  */
#line 7864 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 19468 "parser.c"
    break;

  case 787: /* usage: "COMP-5"  */
#line 7868 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_5);
  }
#line 19476 "parser.c"
    break;

  case 788: /* usage: "COMP-6"  */
#line 7872 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_6);
  }
#line 19484 "parser.c"
    break;

  case 789: /* usage: "COMP-X"  */
#line 7876 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_X);
  }
#line 19492 "parser.c"
    break;

  case 790: /* usage: "COMP-N"  */
#line 7880 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_N);
  }
#line 19500 "parser.c"
    break;

  case 791: /* usage: "FLOAT-SHORT"  */
#line 7884 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_FLOAT);
  }
#line 19508 "parser.c"
    break;

  case 792: /* usage: DISPLAY  */
#line 7888 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_DISPLAY);
  }
#line 19516 "parser.c"
    break;

  case 793: /* usage: INDEX  */
#line 7892 "../../cobc/parser.y"
  {
	/* TODO: second type which is 0-based, depending on dialect option */
	check_and_set_usage (CB_USAGE_INDEX);
  }
#line 19525 "parser.c"
    break;

  case 794: /* usage: "PACKED-DECIMAL"  */
#line 7897 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 19533 "parser.c"
    break;

  case 795: /* usage: POINTER  */
#line 7901 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 19542 "parser.c"
    break;

  case 796: /* usage: "PROGRAM-POINTER"  */
#line 7906 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_PROGRAM_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 19551 "parser.c"
    break;

  case 797: /* usage: HANDLE  */
#line 7911 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL);
  }
#line 19559 "parser.c"
    break;

  case 798: /* usage: HANDLE _of WINDOW  */
#line 7915 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_WINDOW);
  }
#line 19567 "parser.c"
    break;

  case 799: /* usage: HANDLE _of SUBWINDOW  */
#line 7919 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_SUBWINDOW);
  }
#line 19575 "parser.c"
    break;

  case 800: /* usage: HANDLE _of FONT _font_name  */
#line 7923 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_FONT);
	CB_PENDING ("HANDLE OF FONT");
  }
#line 19584 "parser.c"
    break;

  case 801: /* usage: HANDLE _of THREAD  */
#line 7928 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_THREAD);
  }
#line 19592 "parser.c"
    break;

  case 802: /* usage: HANDLE _of MENU  */
#line 7932 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_MENU);
	CB_PENDING ("HANDLE OF MENU");
  }
#line 19601 "parser.c"
    break;

  case 803: /* usage: HANDLE _of VARIANT  */
#line 7937 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_VARIANT);
  }
#line 19609 "parser.c"
    break;

  case 804: /* usage: HANDLE _of "LAYOUT-MANAGER" _layout_name  */
#line 7941 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_LM);
	CB_PENDING ("HANDLE OF LAYOUT-MANAGER");
  }
#line 19618 "parser.c"
    break;

  case 805: /* usage: HANDLE _of control_type_name  */
#line 7946 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL);
	CB_PENDING ("HANDLE OF control-type");
  }
#line 19627 "parser.c"
    break;

  case 806: /* usage: HANDLE _of "Identifier"  */
#line 7951 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL);
	cb_error_x (yyvsp[0], _("unknown HANDLE type: %s"), CB_NAME (yyvsp[0]));
  }
#line 19636 "parser.c"
    break;

  case 807: /* usage: "SIGNED-SHORT"  */
#line 7956 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 19644 "parser.c"
    break;

  case 808: /* usage: "SIGNED-INT"  */
#line 7960 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 19652 "parser.c"
    break;

  case 809: /* usage: "SIGNED-LONG"  */
#line 7964 "../../cobc/parser.y"
  {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 19664 "parser.c"
    break;

  case 810: /* usage: "UNSIGNED-SHORT"  */
#line 7972 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 19672 "parser.c"
    break;

  case 811: /* usage: "UNSIGNED-INT"  */
#line 7976 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 19680 "parser.c"
    break;

  case 812: /* usage: "UNSIGNED-LONG"  */
#line 7980 "../../cobc/parser.y"
  {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 19692 "parser.c"
    break;

  case 813: /* usage: "BINARY-CHAR" _signed  */
#line 7988 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_CHAR);
  }
#line 19700 "parser.c"
    break;

  case 814: /* usage: "BINARY-CHAR" UNSIGNED  */
#line 7992 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_CHAR);
  }
#line 19708 "parser.c"
    break;

  case 815: /* usage: "BINARY-SHORT" _signed  */
#line 7996 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 19716 "parser.c"
    break;

  case 816: /* usage: "BINARY-SHORT" UNSIGNED  */
#line 8000 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 19724 "parser.c"
    break;

  case 817: /* usage: "BINARY-LONG" _signed  */
#line 8004 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 19732 "parser.c"
    break;

  case 818: /* usage: "BINARY-LONG" UNSIGNED  */
#line 8008 "../../cobc/parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 1974