/* A Bison parser, made by GNU Bison 3.7.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30705

/* Bison version string.  */
#define YYBISON_VERSION "3.7.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 28 "parser.y"

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef	HAVE_STRINGS_H
#include <strings.h>
#endif

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"

#define _PARSER_H	/* work around bad Windows SDK header */

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error_always ("%s", x)

#define emit_statement(x) \
do { \
  if (!skip_statements) { \
	CB_ADD_TO_CHAIN (x, current_program->exec_list); \
  } \
}  ONCE_COB

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_JSON		10U
#define TERM_MODIFY		11U
#define TERM_MULTIPLY		12U
#define TERM_PERFORM		13U
#define TERM_READ		14U
#define TERM_RECEIVE		15U
#define TERM_RETURN		16U
#define TERM_REWRITE		17U
#define TERM_SEARCH		18U
#define TERM_START		19U
#define TERM_STRING		20U
#define TERM_SUBTRACT		21U
#define TERM_UNSTRING		22U
#define TERM_WRITE		23U
#define TERM_XML		24U
#define TERM_MAX		25U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitions and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;    /* program in parse/syntax check/codegen */
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
struct cb_statement		*current_statement = NULL;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_force_literal = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;
unsigned int			cobc_in_xml_generate_body = 0;
unsigned int			cobc_in_json_generate_body = 0;
unsigned int			cobc_areacheck = 0;
unsigned int			cobc_in_area_a = 0;

/* Local variables */

enum inspect_rep_keyword {
	INSPECT_REP_DEFAULT,
	INSPECT_REP_ALL,
	INSPECT_REP_LEADING,
	INSPECT_REP_FIRST,
	INSPECT_REP_TRAILING,
};

union examine_keyword {
	/* EXAMINE TALLYING/REPLACING options */
	enum {
		EXAMINE_TAL_ALL,
		EXAMINE_TAL_LEADING,
		EXAMINE_TAL_UNTIL_FIRST,
	} tallying;
	enum {
		EXAMINE_REP_ALL,
		EXAMINE_REP_LEADING,
		EXAMINE_REP_FIRST,
		EXAMINE_REP_UNTIL_FIRST,
	} replacing;
};

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

enum key_clause_type {
	NO_KEY,
	RECORD_KEY,
	RELATIVE_KEY
};

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*control_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;
static struct cb_key_component	*key_component_list;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static const char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		within_typedef_definition;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static enum inspect_rep_keyword	inspect_keyword;
static union examine_keyword	examine_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static enum cb_call_mode	call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;
static enum key_clause_type	key_type;

static int			ext_dyn_specified;
static enum cb_assign_device	assign_device;

static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static unsigned int		exhibit_changed;
static unsigned int		exhibit_named;

static cb_tree			ml_suppress_list;
static cb_tree			xml_encoding;
static int			with_xml_dec;
static int			with_attrs;

static cb_tree			alphanumeric_collation;
static cb_tree			national_collation;

static enum cb_ml_suppress_category	ml_suppress_category;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

static const char		*backup_source_file = NULL;
static int			backup_source_line = 0;

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)
#define	COBC_HD_SOURCE_COMPUTER		(1U << 16)
#define	COBC_HD_OBJECT_COMPUTER		(1U << 17)
#define	COBC_HD_REPOSITORY		(1U << 18)

/* Static functions */

/* Area A enforcement */

static COB_INLINE void
check_area_a (cb_tree word) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check_x (word, _("'%s' should start in Area A"),
					  CB_NAME (word));
	}
}

static COB_INLINE void
check_area_a_of (const char * const item) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check (_("'%s' should start in Area A"), item);
	}
}

static COB_INLINE void
check_non_area_a (cb_tree stmt) {
	if (cobc_in_area_a && cobc_areacheck) {
		if (stmt)
			(void) cb_syntax_check_x (stmt, _("start of statement in Area A"));
		else
			(void) cb_syntax_check (_("start of statement in Area A"));
	}
}

/* Statements */

static void
begin_statement (enum cob_statement statement, const unsigned int term)
{
	if (check_unreached) {
		cb_warning (cb_warn_unreachable,
			_("unreachable statement '%s'"),
			cb_statement_name[statement]);
	}
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (statement);
	CB_TREE (current_statement)->source_file = cb_source_file;
	CB_TREE (current_statement)->source_line = cb_source_line;
	current_statement->flag_in_debug = in_debugging;
	check_non_area_a (CB_TREE (current_statement));
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
}

static void
restore_backup_pos (cb_tree item)
{
	item->source_file = backup_source_file;
	item->source_line = backup_source_line;
}

static void
begin_statement_from_backup_pos (enum cob_statement statement, const unsigned int term)
{
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (statement);
	restore_backup_pos (CB_TREE (current_statement));
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	if (check_unreached) {
		cb_warning_x (cb_warn_unreachable, CB_TREE (current_statement),
			_("unreachable statement '%s'"),
			cb_statement_name[statement]);
	}
}

/* create a new statement with base attributes of current_statement
   and set this as new current_statement */
static void
begin_implicit_statement (void)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (current_statement->statement);
	new_statement->common = current_statement->common;
	new_statement->flag_in_debug = !!in_debugging;
	new_statement->flag_implicit = 1;
	current_statement->body = cb_list_add (current_statement->body,
					    CB_TREE (new_statement));
	current_statement = new_statement;
}

# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
static
void print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

/* functions for storing current position and
   assigning it to a cb_tree after its parsing is finished */
static COB_INLINE
void backup_current_pos (void)
{
	backup_source_file = cb_source_file;
	backup_source_line = cb_source_line;
}

#if 0 /* currently not used */
static COB_INLINE
void set_pos_from_backup (cb_tree x)
{
	x->source_file = backup_source_file;
	x->source_line = backup_source_line;
}
#endif

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention, int override_source_line)
{
	cb_tree		l;
	cb_tree		label;
	cb_tree		entry_conv;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name, 0, cb_fold_call);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	if (override_source_line) {
		label->source_line = override_source_line;
	}
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	cb_validate_parameters_and_returning (current_program, using_list);

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		struct cb_label *check = CB_LABEL (CB_PURPOSE (l));
		if (strcmp (name, check->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR(entry_conv, using_list)));
}

/* Main entry point and the number of its main parameters */
static void
emit_main_entry (struct cb_program *program, cb_tree using_list)
{
	if (using_list) {
		program->num_proc_params = cb_list_length (using_list);
	}

	emit_entry (program->program_id, 0, using_list, NULL, 0);
	if (program->source_name) {
		emit_entry (program->source_name, 1, using_list, NULL, 0);
	}
}

static void
emit_entry_goto (const char *name)
{
	cb_tree		l;
	cb_tree		label;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	CB_LABEL (label)->name = name;
	CB_LABEL (label)->orig_name = name;
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	CB_LABEL (label)->flag_entry_for_goto = 1;
	label->source_line = backup_source_line;	/* CHECKME: is that correct? */
	emit_statement (label);

	for (l = current_program->entry_list_goto; l; l = CB_CHAIN (l)) {
		struct cb_label *real_label = CB_LABEL (CB_VALUE (l));
		if (strcmp (name, real_label->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY FOR GO TO '%s' duplicated"), name);
		}
	}

	if (current_program->entry_list_goto) {
		current_program->entry_list_goto =
			cb_list_add (current_program->entry_list_goto, label);
	} else {
		current_program->entry_list_goto = CB_LIST_INIT (label);
	}
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", cb_statement_name[current_statement->statement]);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SORT file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

/* note: same message in field.c */
static int
emit_duplicate_clause_message (const char *clause)
{
	return cb_syntax_check (_("duplicate %s clause"), clause);
}

static int
check_repeated (const char *clause, const cob_flags_t bitval,
			cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		return emit_duplicate_clause_message (clause);
	}
	*already_seen |= bitval;
	return 0;
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_syntax_check (_("cannot specify both %s and %s"), clause, conflicting)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s is ignored"), clause);
	}
}


static void
error_if_no_page_lines_limit (const char *phrase)
{
	if (!current_report->lines && !current_report->t_lines) {
		cb_error (_("Cannot specify %s without number of lines on page"),
			  phrase);
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage != CB_STORAGE_LINKAGE) {
			cb_error_x (CB_TREE(current_field), _("'%s' is not in LINKAGE SECTION"),
				cb_name (CB_TREE(current_field)));
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_syntax_check (_("TO phrase without DEPENDING phrase"))) {
					cb_note (COBC_WARN_FILLER, 0,
						 _("maximum number of occurrences assumed to be exact number"));
					current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
			}
		} else {
			current_field->occurs_max = 0;
		}
	} else {
		current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _("OCCURS DEPENDING ON without TO phrase"));
		}
	}
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	/* LCOV_EXCL_START */
	default:
		s = _("unknown");
		break;
	/* LCOV_EXCL_STOP */
	}
	if (cb_syntax_check (_("%s header missing"), s)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s header assumed"), s);
	}
}

static void
program_init_without_program_id (void)
{
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
		strlen (demangle_name));
	current_program->program_name = (char *)CB_LITERAL (l)->data;
	current_program->program_id
		= cb_build_program_id (current_program->program_name, 0);
	current_program->prog_type = COB_MODULE_TYPE_PROGRAM;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

/*
  TO-DO: Refactor header checks - have several header_checks: division_header,
  section_header, paragraph_header, sentence_type
*/
static void
set_conf_section_part (const cob_flags_t part)
{
	header_check &= ~COBC_HD_SOURCE_COMPUTER;
	header_check &= ~COBC_HD_OBJECT_COMPUTER;
	header_check &= ~COBC_HD_SPECIAL_NAMES;
	header_check &= ~COBC_HD_REPOSITORY;
	header_check |= part;
}

static const char *
get_conf_section_part_name (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return "SOURCE-COMPUTER";
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return "OBJECT-COMPUTER";
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return "SPECIAL-NAMES";
	} else if (part == COBC_HD_REPOSITORY) {
		return "REPOSITORY";
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static int
get_conf_section_part_order (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return 1;
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return 2;
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return 3;
	} else if (part == COBC_HD_REPOSITORY) {
		return 4;
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static void
check_conf_section_order (const cob_flags_t part)
{
	const cob_flags_t	prev_part
		= header_check & (COBC_HD_SOURCE_COMPUTER
				  | COBC_HD_OBJECT_COMPUTER
				  | COBC_HD_SPECIAL_NAMES
				  | COBC_HD_REPOSITORY);
#define MESSAGE_LEN 100
	char			message[MESSAGE_LEN] = { '\0' };

	if (prev_part == 0) {
		return;
	}

	if (prev_part == part) {
		cb_error (_("duplicate %s"), get_conf_section_part_name (part));
	} else if (get_conf_section_part_order (part) < get_conf_section_part_order (prev_part)) {
		snprintf (message, MESSAGE_LEN, _("%s incorrectly after %s"),
			  get_conf_section_part_name (part),
			  get_conf_section_part_name (prev_part));
		cb_verify (cb_incorrect_conf_sec_order, message);
	}
}

#undef MESSAGE_LEN

static enum cb_handler_type
get_handler_type_from_statement (struct cb_statement *statement)
{
	if (statement->statement == STMT_DISPLAY) {
		return DISPLAY_HANDLER;
	}
	if (statement->statement == STMT_XML_GENERATE
	 || statement->statement == STMT_XML_PARSE) {
		return XML_HANDLER;
	}
	if (statement->statement == STMT_JSON_GENERATE
	 || statement->statement == STMT_JSON_PARSE) {
		return JSON_HANDLER;
	}
#if 0 /* not merged yet */
	if (statement->statement == STMT_DELETE_FILE) {
		return DELETE_FILE_HANDLER;
	}
#endif
	if (statement->statement == STMT_SEND
	 || statement->statement == STMT_RECEIVE) {
		return MCS_HANDLER;
	}
	return NO_HANDLER;
}

static void
build_words_for_nested_programs (void)
{
	cb_tree		x;
	cb_tree		y;

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}

	/* Inherit class names from parent */
	for (x = current_program->class_name_list; x; x = CB_CHAIN(x)) {
		y = cb_build_reference (cb_name(CB_VALUE(x)));
		cb_define (y, CB_VALUE(x));
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = INSPECT_REP_DEFAULT;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_force_literal = 0;
	cobc_in_xml_generate_body = 0;
	cobc_in_json_generate_body = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	cb_tree		l;

	/*
	  Error if we find a program or prototype with the same name as the
	  given program or prototype, respectively.
	*/
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		const struct cb_program	*elt_program = CB_PROGRAM (CB_VALUE (l));
		const char	*elt_name = elt_program->program_name;
		const char	*elt_id = elt_program->orig_program_id;
		/*
		  If we find a program's matching prototype or a prototype's
		  matching definition, nothing needs to be done.
		*/
		if (program->flag_prototype != elt_program->flag_prototype) {
			continue;
		}

		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program name '%s'"),
				    elt_name);
			return;
		} else if (strcmp (prog_id, elt_id) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list, CB_TREE (program));
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == COB_MODULE_TYPE_FUNCTION
		/* CHECKME: That would be valid in a function-definition according to COBOL2014
		  --> How is it intended to work? */
		 && !program->flag_prototype) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_main_entry (program, NULL);
		}
	}
	program->last_source_line = backup_source_line;

	if (program->nested_level == 0
	 || defined_prog_list == NULL) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		if (CB_PROGRAM (l->value)->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = CB_LIST (defined_prog_list);
		while (l) {
			/* The nested_level check is for the pathological case
			   where two nested programs have the same name */
			if (0 == strcmp (program->orig_program_id,
			         CB_PROGRAM (l->value)->orig_program_id)
			    && program->nested_level == CB_PROGRAM (l->value)->nested_level) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const unsigned char type, const int prototype)
{
	const char	*external_name = NULL;

	setup_program_start ();

	/* finish last program/function */
	if (!first_prog) {
		backup_source_file = cb_source_file;
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		if (depth) {
			build_words_for_nested_programs();
		}
		cb_source_file = "register-definition";
		cb_set_intr_when_compiled ();
		cb_build_registers ();
		cb_add_external_defined_registers ();
		cb_source_file = backup_source_file;
	} else {
		first_prog = 0;
	}

	/* set internal name */
	if (CB_LITERAL_P (id)) {
		current_program->program_name = (char *)CB_LITERAL (id)->data;
	} else {
		current_program->program_name = CB_NAME (id);
	}
	stack_progid[depth] = current_program->program_name;
	current_program->prog_type = type;
	current_program->flag_prototype = prototype;

	if (depth != 0 && type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	/* set external name if specified */
	if (as_literal) {
		external_name = (const char *)CB_LITERAL (as_literal)->data;
	} else {
		external_name = current_program->program_name;
	}

	/* build encoded external PROGRAM-ID */
	current_program->program_id
		= cb_build_program_id (external_name, type == COB_MODULE_TYPE_FUNCTION);

	if (type == COB_MODULE_TYPE_PROGRAM) {
		if (!main_flag_set) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* COB_MODULE_TYPE_FUNCTION */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
		cb_define (id, CB_TREE (current_program));
	}

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set currency symbol used in picture (compile time) and - if no currency
   string is explicitly set (which is currently not implemented) - as currency string
   (run time for display and [de-]editing)*/
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("currency symbol must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
#if 0 /* note: MicroFocus also dissalows L (VAX) and G (OSVS) */
	case 'L':
	case 'G':
	case 'l':
	case 'g':
#endif
		cb_error_x (x, _("invalid character '%c' in currency symbol"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const int type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	 && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == COB_MODULE_TYPE_PROGRAM
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == COB_MODULE_TYPE_PROGRAM) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* COB_MODULE_TYPE_FUNCTION */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_record_delimiter_incompatible (const int organization,
					const char *organization_name)
{
	int	is_compatible;

	if (!current_file->flag_delimiter) {
		return;
	}

	if (organization == COB_ORG_LINE_SEQUENTIAL) {
		is_compatible = current_file->organization == COB_ORG_SEQUENTIAL
			|| current_file->organization == COB_ORG_LINE_SEQUENTIAL;
	} else {
		is_compatible = current_file->organization == organization;
	}

	if (!is_compatible) {
		cb_error (_("ORGANIZATION %s is incompatible with RECORD DELIMITER"),
			  organization_name);
	}
}

static int
set_current_field (cb_tree level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);
	/* Free tree associated with level number */
	cobc_parse_free (level);

	if (CB_INVALID_TREE (x)) {
		return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
		if (current_field->level == 1 || current_field->level == 77) {
			within_typedef_definition = 0;
		}
	}

	return 0;
}

static void
setup_external_definition (cb_tree x, const int type)
{
	/* note: syntax checks for conflicting clauses
	         are done in inherit_external_definition */

	if (x != cb_error_node) {
		struct cb_field *f = CB_FIELD (cb_ref (x));

		/* additional checks if the definition isn't provided by type */
		if (type != 1 /* called with SAME AS / LIKE data-name */ ) {
			if (f->level == 88) {
				cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
				x = cb_error_node;
			}
			/* note: the following are not explicit specified but implied with
			   LIKE as ILE-COBOL does not have those sections */
			if (f->storage == CB_STORAGE_SCREEN) {
				cb_error (_("SCREEN item cannot be used here"));
				x = cb_error_node;
			} else if (f->storage == CB_STORAGE_REPORT) {
				cb_error (_("REPORT item cannot be used here"));
				x = cb_error_node;
			}
			if (type == 0) {
				/* rules that apply only to SAME AS */
				if (f->flag_is_typedef) {
					cb_error (_("TYPEDEF item cannot be used here"));
					x = cb_error_node;
				}
			}
		}

		if (current_field->level == 77) {
			if (type != 2 /* called with LIKE */
			 && f->children) {
				cb_error (_("elementary item expected"));
				x = cb_error_node;
			}
		} else {
			struct cb_field *p;
			for (p = current_field; p; p = p->parent) {
				if (p == f) {
					cb_error (_("item may not reference itself"));
					x = cb_error_node;
					break;
				}
			}
			for (p = f->parent; p; p = p->parent) {
				if (p->usage != CB_USAGE_DISPLAY) {
					cb_error (_("item may not be subordinate to any item with USAGE clause"));
				} else if (p->flag_sign_clause) {
					cb_error (_("item may not be subordinate to any item with SIGN clause"));
				} else {
					continue;
				}
				x = cb_error_node;
				break;
			}
		}
	}

	if (x == cb_error_node) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		current_field->external_definition = cb_error_node;
	} else {
		current_field->external_definition = cb_ref (x);
	}
}

static void
setup_external_definition_type (cb_tree x)
{
	if (!check_repeated ("TYPE TO", SYN_CLAUSE_31, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("SAME AS", "TYPE TO");
		}
		setup_external_definition (x, 1);
	}
}

/* verifies that no conflicting clauses are used and
   inherits the definition of the original field specified
   by SAME AS or by type_name */
static void
inherit_external_definition (cb_tree lvl)
{
	/* note: REDEFINES (clause 1) is allowed with RM/COBOL but not COBOL 2002+ */
	static const cob_flags_t	allowed_clauses =
		SYN_CLAUSE_1 | SYN_CLAUSE_2 | SYN_CLAUSE_3 | SYN_CLAUSE_7 | SYN_CLAUSE_12;
	cob_flags_t	tested = check_pic_duplicate & ~(allowed_clauses);
	if (tested != SYN_CLAUSE_30 && tested != SYN_CLAUSE_31
	 && tested != 0 /* USAGE as TYPE TO */) {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		cb_error_x (CB_TREE(current_field), _("illegal combination of %s with other clauses"),
			fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	} else {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		int new_level = lvl ? cb_get_level (lvl) : 0;
		int old_level = current_field->level;
		copy_into_field (fld, current_field);
		if (new_level > 1 && new_level < 66 && new_level > old_level) {
			cb_error_x (lvl, _("entry following %s may not be subordinate to it"),
				fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		}
	}
}

static cb_tree
get_finalized_description_tree (void)
{
	struct cb_field *p;

	/* finalize last field if target of SAME AS / TYPEDEF */
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		inherit_external_definition (NULL);
	}

	/* validate the complete current "block" */
	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	return CB_TREE (description_field);
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
		*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
		   cb_tree timeout, cb_tree prompt, cb_tree size_is)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
}

static void
set_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == CHARACTERS_PHRASE
		 || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between ALL/LEADING/TRAILING words"));
		}
		/* fall through */
	case CHARACTERS_PHRASE:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (! ( previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		     || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

	/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
	/* LCOV_EXCL_STOP */
	}

	previous_tallying_phrase = phrase;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & ( COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		    | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
	        && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static cb_tree
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (x == cb_error_node) {
		return cb_error_node;
	}
	if (!CB_REF_OR_FIELD_P(x)) {
		return x;
	}

	f = CB_FIELD_PTR (x);

	if (f->level == 88) {
#if 0	/* note: we may consider to support the extension (if existing) to
		         reference a condition-name target by the condition-name */
		if (cb_verify (cb_condition_references_data, _("use of condition-name in place of data-name"))) {
			return CB_TREE (f->parent);
		}
#else
		cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
		/* invalidate field to prevent same error in typeck.c (validate_one) */
		/* FIXME: If we really need the additional check here then we missed
		          a call to cb_validate_one() somewhere */
		return cb_error_node;
#endif
	} else {
		return x;
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	 || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *l)
{
	return cb_list_length (CB_TREE(l)) == 1
		&& is_screen_field (l->value);
}

static int
contains_only_screen_fields (struct cb_list *l)
{
	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (!is_screen_field (l->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *l)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (is_screen_field (l->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (struct	cb_list *l, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	/* TODO: Separate CGI DISPLAYs here */
	if (contains_only_screen_fields (l)) {
		if (!contains_one_screen_field (l)
		 || attr_ptr) {
			cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens (l)) {
		cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (struct cb_list *l, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (struct cb_list *l, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	const enum cb_display_type	type =
		deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (CB_TREE(l), _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	const int	is_numeric_literal = CB_NUMERIC_LITERAL_P (x);
	const int	is_field_with_usage_not_display =
		CB_REFERENCE_P (x) && CB_FIELD (cb_ref (x))
		&& CB_FIELD (cb_ref (x))->usage != CB_USAGE_DISPLAY;

	if (is_numeric_literal) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (is_field_with_usage_not_display) {
		cb_error_x (x, _("'%s' is not USAGE DISPLAY"), cb_name (x));
	}
}

static void
check_validate_item (cb_tree x)
{
	struct cb_field	*f;
	enum cb_class	tree_class;

	if (CB_INVALID_TREE(x) || x->tag != CB_TAG_REFERENCE) {
		return;
	}
	x = cb_ref (x);
	if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
		cb_error (_("invalid target for %s"), "VALIDATE");
		return;
	}

	f = CB_FIELD (x);
	tree_class = CB_TREE_CLASS(f);
	if (is_screen_field(x)) {
		cb_error (_("SCREEN item cannot be used here"));
	} else if (f->level == 66) {
		cb_error (_("RENAMES item may not be used here"));
	} else if (f->flag_any_length) {
		cb_error (_("ANY LENGTH item not allowed here"));
	} else if (tree_class == CB_CLASS_INDEX
		|| tree_class == CB_CLASS_OBJECT
		|| tree_class == CB_CLASS_POINTER) {
		cb_error (_("item '%s' has wrong class for VALIDATE"), cb_name (x));
	}
}

static void
error_if_following_every_clause (void)
{
	if (ml_suppress_list
	    && CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list))->target == CB_ML_SUPPRESS_TYPE) {
		cb_error (_("WHEN clause must follow EVERY clause"));
	}
}

static void
prepend_to_ml_suppress_list (cb_tree suppress_entry)
{
	cb_tree	new_list_head = CB_LIST_INIT (suppress_entry);
	cb_list_append (new_list_head, ml_suppress_list);
	ml_suppress_list = new_list_head;
}

static void
add_identifier_to_ml_suppress_conds (cb_tree identifier)
{
	cb_tree suppress_id = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_id)->target = CB_ML_SUPPRESS_IDENTIFIER;
	CB_ML_SUPPRESS (suppress_id)->identifier = identifier;
	prepend_to_ml_suppress_list (suppress_id);
}

static void
add_when_to_ml_suppress_conds (cb_tree when_list)
{
	struct cb_ml_suppress_clause	*last_suppress_clause;
	cb_tree	suppress_all;

	/*
	  If the preceding clause in SUPPRESS was an identifier, the WHEN
	  belongs to the identifier. If EVERY was preceding, the WHEN belongs to
	  the EVERY. Otherwise, the WHEN acts on the entire record.
	*/
	if (ml_suppress_list) {
		last_suppress_clause = CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list));
		if ((last_suppress_clause->target == CB_ML_SUPPRESS_IDENTIFIER
		     || last_suppress_clause->target == CB_ML_SUPPRESS_TYPE)
		    && !last_suppress_clause->when_list) {
			last_suppress_clause->when_list = when_list;
			return;
		}
	}

	suppress_all = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_all)->when_list = when_list;
	prepend_to_ml_suppress_list (suppress_all);
}

static void
add_type_to_ml_suppress_conds (enum cb_ml_suppress_category category,
			       enum cb_ml_type ml_type)
{
	cb_tree	suppress_type = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_type)->target = CB_ML_SUPPRESS_TYPE;
	CB_ML_SUPPRESS (suppress_type)->category = category;
	CB_ML_SUPPRESS (suppress_type)->ml_type = ml_type;
	prepend_to_ml_suppress_list (suppress_type);
}

static void
set_record_size (cb_tree min, cb_tree max)
{
	int record_min, record_max;

	if (min) {
		record_min = cb_get_int (min);
		if (record_min < 0) {
			/* already handled by integer check */
		} else {
			current_file->record_min = record_min;
		}
	} else {
		record_min = 0;
	}
	if (!max) {
		return;
	}

	record_max = cb_get_int (max);
	if (record_max < 0) {
		/* already handled by integer check */
		return;
	} else if (record_max == 0) {
		/* Note: standard COBOL does not allow zero at all, use the related
		         configuration option */
		if (cb_records_mismatch_record_clause >= CB_ERROR) {
			cb_error (_("non-zero value expected"));
		}
		return;
	}
	if (current_file->organization == COB_ORG_INDEXED
	 && record_max > MAX_FD_RECORD_IDX)  {
		cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
			MAX_FD_RECORD_IDX);
		current_file->record_max = MAX_FD_RECORD_IDX;
	} else if (record_max > MAX_FD_RECORD)  {
		cb_error (_("RECORD size exceeds maximum allowed (%d)"),
			MAX_FD_RECORD);
		current_file->record_max = MAX_FD_RECORD;
	} else {
		if (record_max <= record_min)  {
			cb_error (_("RECORD clause invalid"));
		}
		current_file->record_max = record_max;
	}
}


#line 2295 "parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    TOKEN_EOF = 0,                 /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    THREEDIMENSIONAL = 258,        /* "3D"  */
    ABSENT = 259,                  /* ABSENT  */
    ACCEPT = 260,                  /* ACCEPT  */
    ACCESS = 261,                  /* ACCESS  */
    ACTIVEX = 262,                 /* "ACTIVE-X"  */
    ACTIVE_CLASS = 263,            /* "ACTIVE-CLASS"  */
    ACTION = 264,                  /* ACTION  */
    ACTUAL = 265,                  /* ACTUAL  */
    ADD = 266,                     /* ADD  */
    ADDRESS = 267,                 /* ADDRESS  */
    ADJUSTABLE_COLUMNS = 268,      /* "ADJUSTABLE-COLUMNS"  */
    ADVANCING = 269,               /* ADVANCING  */
    AFTER = 270,                   /* AFTER  */
    ALIGNED = 271,                 /* ALIGNED  */
    ALIGNMENT = 272,               /* ALIGNMENT  */
    ALL = 273,                     /* ALL  */
    ALLOCATE = 274,                /* ALLOCATE  */
    ALLOWING = 275,                /* ALLOWING  */
    ALPHABET = 276,                /* ALPHABET  */
    ALPHABETIC = 277,              /* ALPHABETIC  */
    ALPHABETIC_LOWER = 278,        /* "ALPHABETIC-LOWER"  */
    ALPHABETIC_UPPER = 279,        /* "ALPHABETIC-UPPER"  */
    ALPHANUMERIC = 280,            /* ALPHANUMERIC  */
    ALPHANUMERIC_EDITED = 281,     /* "ALPHANUMERIC-EDITED"  */
    ALSO = 282,                    /* ALSO  */
    ALTER = 283,                   /* ALTER  */
    ALTERNATE = 284,               /* ALTERNATE  */
    AND = 285,                     /* AND  */
    ANY = 286,                     /* ANY  */
    APPLY = 287,                   /* APPLY  */
    ARE = 288,                     /* ARE  */
    AREA = 289,                    /* AREA  */
    AREAS = 290,                   /* AREAS  */
    ARGUMENT_NUMBER = 291,         /* "ARGUMENT-NUMBER"  */
    ARGUMENT_VALUE = 292,          /* "ARGUMENT-VALUE"  */
    ARITHMETIC = 293,              /* ARITHMETIC  */
    AS = 294,                      /* AS  */
    ASCENDING = 295,               /* ASCENDING  */
    ASCII = 296,                   /* ASCII  */
    ASSIGN = 297,                  /* ASSIGN  */
    AT = 298,                      /* AT  */
    AT_END = 299,                  /* "AT END"  */
    ATTRIBUTE = 300,               /* ATTRIBUTE  */
    ATTRIBUTES = 301,              /* ATTRIBUTES  */
    AUTHOR = 302,                  /* AUTHOR  */
    AUTO = 303,                    /* AUTO  */
    AUTO_DECIMAL = 304,            /* "AUTO-DECIMAL"  */
    AUTO_SPIN = 305,               /* "AUTO-SPIN"  */
    AUTOMATIC = 306,               /* AUTOMATIC  */
    AWAY_FROM_ZERO = 307,          /* "AWAY-FROM-ZERO"  */
    B_AND = 308,                   /* "B-AND"  */
    B_NOT = 309,                   /* "B-NOT"  */
    B_OR = 310,                    /* "B-OR"  */
    B_XOR = 311,                   /* "B-XOR"  */
    B_SHIFT_L = 312,               /* "B-SHIFT-L"  */
    B_SHIFT_R = 313,               /* "B-SHIFT-R"  */
    B_SHIFT_LC = 314,              /* "B-SHIFT-LC"  */
    B_SHIFT_RC = 315,              /* "B-SHIFT-RC"  */
    BACKGROUND_COLOR = 316,        /* "BACKGROUND-COLOR"  */
    BACKGROUND_HIGH = 317,         /* "BACKGROUND-HIGH"  */
    BACKGROUND_LOW = 318,          /* "BACKGROUND-LOW"  */
    BACKGROUND_STANDARD = 319,     /* "BACKGROUND-STANDARD"  */
    BACKWARD = 320,                /* BACKWARD  */
    BAR = 321,                     /* BAR  */
    BASED = 322,                   /* BASED  */
    BEFORE = 323,                  /* BEFORE  */
    BELL = 324,                    /* BELL  */
    BINARY = 325,                  /* BINARY  */
    BINARY_C_LONG = 326,           /* "BINARY-C-LONG"  */
    BINARY_CHAR = 327,             /* "BINARY-CHAR"  */
    BINARY_DOUBLE = 328,           /* "BINARY-DOUBLE"  */
    BINARY_LONG = 329,             /* "BINARY-LONG"  */
    BINARY_SEQUENTIAL = 330,       /* "BINARY-SEQUENTIAL"  */
    BINARY_SHORT = 331,            /* "BINARY-SHORT"  */
    BIT = 332,                     /* BIT  */
    BITMAP = 333,                  /* BITMAP  */
    BITMAP_END = 334,              /* "BITMAP-END"  */
    BITMAP_HANDLE = 335,           /* "BITMAP-HANDLE"  */
    BITMAP_NUMBER = 336,           /* "BITMAP-NUMBER"  */
    BITMAP_START = 337,            /* "BITMAP-START"  */
    BITMAP_TIMER = 338,            /* "BITMAP-TIMER"  */
    BITMAP_TRAILING = 339,         /* "BITMAP-TRAILING"  */
    BITMAP_TRANSPARENT_COLOR = 340, /* "BITMAP-TRANSPARENT-COLOR"  */
    BITMAP_WIDTH = 341,            /* "BITMAP-WIDTH"  */
    BLANK = 342,                   /* BLANK  */
    BLINK = 343,                   /* BLINK  */
    BLOCK = 344,                   /* BLOCK  */
    BOOLEAN = 345,                 /* BOOLEAN  */
    BOTTOM = 346,                  /* BOTTOM  */
    BOX = 347,                     /* BOX  */
    BOXED = 348,                   /* BOXED  */
    BULK_ADDITION = 349,           /* "BULK-ADDITION"  */
    BUSY = 350,                    /* BUSY  */
    BUTTONS = 351,                 /* BUTTONS  */
    BY = 352,                      /* BY  */
    BYTE_LENGTH = 353,             /* "BYTE-LENGTH"  */
    C = 354,                       /* C  */
    CALENDAR_FONT = 355,           /* "CALENDAR-FONT"  */
    CALL = 356,                    /* CALL  */
    CANCEL = 357,                  /* CANCEL  */
    CANCEL_BUTTON = 358,           /* "CANCEL-BUTTON"  */
    CAPACITY = 359,                /* CAPACITY  */
    CARD_PUNCH = 360,              /* "CARD-PUNCH"  */
    CARD_READER = 361,             /* "CARD-READER"  */
    CASSETTE = 362,                /* CASSETTE  */
    CCOL = 363,                    /* CCOL  */
    CD = 364,                      /* CD  */
    CELL = 365,                    /* CELL  */
    CELL_COLOR = 366,              /* "CELL-COLOR"  */
    CELL_DATA = 367,               /* "CELL-DATA"  */
    CELL_FONT = 368,               /* "CELL-FONT"  */
    CELL_PROTECTION = 369,         /* "CELL-PROTECTION"  */
    CENTER = 370,                  /* CENTER  */
    CENTERED = 371,                /* CENTERED  */
    CENTERED_HEADINGS = 372,       /* "CENTERED-HEADINGS"  */
    CENTURY_DATE = 373,            /* "CENTURY-DATE"  */
    CF = 374,                      /* CF  */
    CH = 375,                      /* CH  */
    CHAINING = 376,                /* CHAINING  */
    CHANGED = 377,                 /* CHANGED  */
    CHARACTER = 378,               /* CHARACTER  */
    CHARACTERS = 379,              /* CHARACTERS  */
    CHECK_BOX = 380,               /* "CHECK-BOX"  */
    CLASS = 381,                   /* CLASS  */
    CLASSIFICATION = 382,          /* CLASSIFICATION  */
    CLASS_NAME = 383,              /* "class-name"  */
    CLEAR_SELECTION = 384,         /* "CLEAR-SELECTION"  */
    CLINE = 385,                   /* CLINE  */
    CLINES = 386,                  /* CLINES  */
    CLOSE = 387,                   /* CLOSE  */
    COBOL = 388,                   /* COBOL  */
    CODE = 389,                    /* CODE  */
    CODE_SET = 390,                /* "CODE-SET"  */
    COLLATING = 391,               /* COLLATING  */
    COL = 392,                     /* COL  */
    COLOR = 393,                   /* COLOR  */
    COLORS = 394,                  /* COLORS  */
    COLS = 395,                    /* COLS  */
    COLUMN = 396,                  /* COLUMN  */
    COLUMN_COLOR = 397,            /* "COLUMN-COLOR"  */
    COLUMN_DIVIDERS = 398,         /* "COLUMN-DIVIDERS"  */
    COLUMN_FONT = 399,             /* "COLUMN-FONT"  */
    COLUMN_HEADINGS = 400,         /* "COLUMN-HEADINGS"  */
    COLUMN_PROTECTION = 401,       /* "COLUMN-PROTECTION"  */
    COLUMNS = 402,                 /* COLUMNS  */
    COMBO_BOX = 403,               /* "COMBO-BOX"  */
    COMMA = 404,                   /* COMMA  */
    COMMAND_LINE = 405,            /* "COMMAND-LINE"  */
    COMMA_DELIM = 406,             /* "comma delimiter"  */
    COMMIT = 407,                  /* COMMIT  */
    COMMON = 408,                  /* COMMON  */
    COMMUNICATION = 409,           /* COMMUNICATION  */
    COMP = 410,                    /* COMP  */
    COMPUTE = 411,                 /* COMPUTE  */
    COMP_0 = 412,                  /* "COMP-0"  */
    COMP_1 = 413,                  /* "COMP-1"  */
    COMP_2 = 414,                  /* "COMP-2"  */
    COMP_3 = 415,                  /* "COMP-3"  */
    COMP_4 = 416,                  /* "COMP-4"  */
    COMP_5 = 417,                  /* "COMP-5"  */
    COMP_6 = 418,                  /* "COMP-6"  */
    COMP_N = 419,                  /* "COMP-N"  */
    COMP_X = 420,                  /* "COMP-X"  */
    CONCATENATE_FUNC = 421,        /* "FUNCTION CONCATENATE"  */
    CONDITION = 422,               /* CONDITION  */
    CONFIGURATION = 423,           /* CONFIGURATION  */
    CONSTANT = 424,                /* CONSTANT  */
    CONTAINS = 425,                /* CONTAINS  */
    CONTENT = 426,                 /* CONTENT  */
    CONTENT_LENGTH_FUNC = 427,     /* "FUNCTION CONTENT-LENGTH"  */
    CONTENT_OF_FUNC = 428,         /* "FUNCTION CONTENT-OF"  */
    CONTINUE = 429,                /* CONTINUE  */
    CONTROL = 430,                 /* CONTROL  */
    CONTROLS = 431,                /* CONTROLS  */
    CONVERSION = 432,              /* CONVERSION  */
    CONVERTING = 433,              /* CONVERTING  */
    COPY = 434,                    /* COPY  */
    COPY_SELECTION = 435,          /* "COPY-SELECTION"  */
    CORE_INDEX = 436,              /* "CORE-INDEX"  */
    CORRESPONDING = 437,           /* CORRESPONDING  */
    COUNT = 438,                   /* COUNT  */
    CRT = 439,                     /* CRT  */
    CRT_UNDER = 440,               /* "CRT-UNDER"  */
    CSIZE = 441,                   /* CSIZE  */
    CURRENCY = 442,                /* CURRENCY  */
    CURRENT_DATE_FUNC = 443,       /* "FUNCTION CURRENT-DATE"  */
    CURSOR = 444,                  /* CURSOR  */
    CURSOR_COL = 445,              /* "CURSOR-COL"  */
    CURSOR_COLOR = 446,            /* "CURSOR-COLOR"  */
    CURSOR_FRAME_WIDTH = 447,      /* "CURSOR-FRAME-WIDTH"  */
    CURSOR_ROW = 448,              /* "CURSOR-ROW"  */
    CURSOR_X = 449,                /* "CURSOR-X"  */
    CURSOR_Y = 450,                /* "CURSOR-Y"  */
    CUSTOM_PRINT_TEMPLATE = 451,   /* "CUSTOM-PRINT-TEMPLATE"  */
    CYCLE = 452,                   /* CYCLE  */
    CYL_INDEX = 453,               /* "CYL-INDEX"  */
    CYL_OVERFLOW = 454,            /* "CYL-OVERFLOW"  */
    DASHED = 455,                  /* DASHED  */
    DATA = 456,                    /* DATA  */
    DATA_COLUMNS = 457,            /* "DATA-COLUMNS"  */
    DATA_TYPES = 458,              /* "DATA-TYPES"  */
    DATE = 459,                    /* DATE  */
    DATE_COMPILED = 460,           /* "DATE-COMPILED"  */
    DATE_ENTRY = 461,              /* "DATE-ENTRY"  */
    DATE_MODIFIED = 462,           /* "DATE-MODIFIED"  */
    DATE_WRITTEN = 463,            /* "DATE-WRITTEN"  */
    DAY = 464,                     /* DAY  */
    DAY_OF_WEEK = 465,             /* "DAY-OF-WEEK"  */
    DE = 466,                      /* DE  */
    DEBUGGING = 467,               /* DEBUGGING  */
    DECIMAL_POINT = 468,           /* "DECIMAL-POINT"  */
    DECLARATIVES = 469,            /* DECLARATIVES  */
    DEFAULT = 470,                 /* DEFAULT  */
    DEFAULT_BUTTON = 471,          /* "DEFAULT-BUTTON"  */
    DEFAULT_FONT = 472,            /* "DEFAULT-FONT"  */
    DELETE = 473,                  /* DELETE  */
    DELIMITED = 474,               /* DELIMITED  */
    DELIMITER = 475,               /* DELIMITER  */
    DEPENDING = 476,               /* DEPENDING  */
    DESCENDING = 477,              /* DESCENDING  */
    DESTINATION = 478,             /* DESTINATION  */
    DESTROY = 479,                 /* DESTROY  */
    DETAIL = 480,                  /* DETAIL  */
    DISABLE = 481,                 /* DISABLE  */
    DISC = 482,                    /* DISC  */
    DISK = 483,                    /* DISK  */
    DISP = 484,                    /* DISP  */
    DISPLAY = 485,                 /* DISPLAY  */
    DISPLAY_COLUMNS = 486,         /* "DISPLAY-COLUMNS"  */
    DISPLAY_FORMAT = 487,          /* "DISPLAY-FORMAT"  */
    DISPLAY_OF_FUNC = 488,         /* "FUNCTION DISPLAY-OF"  */
    DIVIDE = 489,                  /* DIVIDE  */
    DIVIDERS = 490,                /* DIVIDERS  */
    DIVIDER_COLOR = 491,           /* "DIVIDER-COLOR"  */
    DIVISION = 492,                /* DIVISION  */
    DOTDASH = 493,                 /* DOTDASH  */
    DOTTED = 494,                  /* DOTTED  */
    DRAG_COLOR = 495,              /* "DRAG-COLOR"  */
    DROP_DOWN = 496,               /* "DROP-DOWN"  */
    DROP_LIST = 497,               /* "DROP-LIST"  */
    DOWN = 498,                    /* DOWN  */
    DUPLICATES = 499,              /* DUPLICATES  */
    DYNAMIC = 500,                 /* DYNAMIC  */
    EBCDIC = 501,                  /* EBCDIC  */
    EC = 502,                      /* EC  */
    ECHO = 503,                    /* ECHO  */
    EGI = 504,                     /* EGI  */
    EIGHTY_EIGHT = 505,            /* "level-number 88"  */
    ENABLE = 506,                  /* ENABLE  */
    ELEMENT = 507,                 /* ELEMENT  */
    ELSE = 508,                    /* ELSE  */
    EMI = 509,                     /* EMI  */
    ENCRYPTION = 510,              /* ENCRYPTION  */
    ENCODING = 511,                /* ENCODING  */
    END = 512,                     /* END  */
    END_ACCEPT = 513,              /* "END-ACCEPT"  */
    END_ADD = 514,                 /* "END-ADD"  */
    END_CALL = 515,                /* "END-CALL"  */
    END_COMPUTE = 516,             /* "END-COMPUTE"  */
    END_COLOR = 517,               /* "END-COLOR"  */
    END_DELETE = 518,              /* "END-DELETE"  */
    END_DISPLAY = 519,             /* "END-DISPLAY"  */
    END_DIVIDE = 520,              /* "END-DIVIDE"  */
    END_EVALUATE = 521,            /* "END-EVALUATE"  */
    END_FUNCTION = 522,            /* "END FUNCTION"  */
    END_IF = 523,                  /* "END-IF"  */
    END_JSON = 524,                /* "END-JSON"  */
    END_MODIFY = 525,              /* "END-MODIFY"  */
    END_MULTIPLY = 526,            /* "END-MULTIPLY"  */
    END_PERFORM = 527,             /* "END-PERFORM"  */
    END_PROGRAM = 528,             /* "END PROGRAM"  */
    END_READ = 529,                /* "END-READ"  */
    END_RECEIVE = 530,             /* "END-RECEIVE"  */
    END_RETURN = 531,              /* "END-RETURN"  */
    END_REWRITE = 532,             /* "END-REWRITE"  */
    END_SEARCH = 533,              /* "END-SEARCH"  */
    END_SEND = 534,                /* "END-SEND"  */
    END_START = 535,               /* "END-START"  */
    END_STRING = 536,              /* "END-STRING"  */
    END_SUBTRACT = 537,            /* "END-SUBTRACT"  */
    END_UNSTRING = 538,            /* "END-UNSTRING"  */
    END_WRITE = 539,               /* "END-WRITE"  */
    END_XML = 540,                 /* "END-XML"  */
    ENGRAVED = 541,                /* ENGRAVED  */
    ENSURE_VISIBLE = 542,          /* "ENSURE-VISIBLE"  */
    ENTRY = 543,                   /* ENTRY  */
    ENTRY_CONVENTION = 544,        /* "ENTRY-CONVENTION"  */
    ENTRY_FIELD = 545,             /* "ENTRY-FIELD"  */
    ENTRY_REASON = 546,            /* "ENTRY-REASON"  */
    ENVIRONMENT = 547,             /* ENVIRONMENT  */
    ENVIRONMENT_NAME = 548,        /* "ENVIRONMENT-NAME"  */
    ENVIRONMENT_VALUE = 549,       /* "ENVIRONMENT-VALUE"  */
    EOL = 550,                     /* EOL  */
    EOP = 551,                     /* EOP  */
    EOS = 552,                     /* EOS  */
    EQUAL = 553,                   /* EQUAL  */
    ERASE = 554,                   /* ERASE  */
    ERROR = 555,                   /* ERROR  */
    ESCAPE = 556,                  /* ESCAPE  */
    ESCAPE_BUTTON = 557,           /* "ESCAPE-BUTTON"  */
    ESI = 558,                     /* ESI  */
    EVALUATE = 559,                /* EVALUATE  */
    EVENT = 560,                   /* EVENT  */
    EVENT_LIST = 561,              /* "EVENT-LIST"  */
    EVENT_STATUS = 562,            /* "EVENT STATUS"  */
    EVERY = 563,                   /* EVERY  */
    EXAMINE = 564,                 /* EXAMINE  */
    EXCEPTION = 565,               /* EXCEPTION  */
    EXCEPTION_CONDITION = 566,     /* "EXCEPTION CONDITION"  */
    EXCEPTION_VALUE = 567,         /* "EXCEPTION-VALUE"  */
    EXPAND = 568,                  /* EXPAND  */
    EXCLUSIVE = 569,               /* EXCLUSIVE  */
    EXHIBIT = 570,                 /* EXHIBIT  */
    EXIT = 571,                    /* EXIT  */
    EXPONENTIATION = 572,          /* "exponentiation operator"  */
    EXTEND = 573,                  /* EXTEND  */
    EXTENDED_SEARCH = 574,         /* "EXTENDED-SEARCH"  */
    EXTERNAL = 575,                /* EXTERNAL  */
    EXTERNAL_FORM = 576,           /* "EXTERNAL-FORM"  */
    F = 577,                       /* F  */
    FACTORY = 578,                 /* FACTORY  */
    FD = 579,                      /* FD  */
    FH__FCD = 580,                 /* "FH--FCD"  */
    FH__KEYDEF = 581,              /* "FH--KEYDEF"  */
    FILE_CONTROL = 582,            /* "FILE-CONTROL"  */
    FILE_ID = 583,                 /* "FILE-ID"  */
    FILE_LIMIT = 584,              /* "FILE-LIMIT"  */
    FILE_LIMITS = 585,             /* "FILE-LIMITS"  */
    FILE_NAME = 586,               /* "FILE-NAME"  */
    FILE_POS = 587,                /* "FILE-POS"  */
    FILL_COLOR = 588,              /* "FILL-COLOR"  */
    FILL_COLOR2 = 589,             /* "FILL-COLOR2"  */
    FILL_PERCENT = 590,            /* "FILL-PERCENT"  */
    FILLER = 591,                  /* FILLER  */
    FINAL = 592,                   /* FINAL  */
    FINISH_REASON = 593,           /* "FINISH-REASON"  */
    FIRST = 594,                   /* FIRST  */
    FIXED = 595,                   /* FIXED  */
    FIXED_FONT = 596,              /* "FIXED-FONT"  */
    FIXED_WIDTH = 597,             /* "FIXED-WIDTH"  */
    FLAT = 598,                    /* FLAT  */
    FLAT_BUTTONS = 599,            /* "FLAT-BUTTONS"  */
    FLOAT_BINARY_128 = 600,        /* "FLOAT-BINARY-128"  */
    FLOAT_BINARY_32 = 601,         /* "FLOAT-BINARY-32"  */
    FLOAT_BINARY_64 = 602,         /* "FLOAT-BINARY-64"  */
    FLOAT_DECIMAL_16 = 603,        /* "FLOAT-DECIMAL-16"  */
    FLOAT_DECIMAL_34 = 604,        /* "FLOAT-DECIMAL-34"  */
    FLOAT_DECIMAL_7 = 605,         /* "FLOAT-DECIMAL-7"  */
    FLOAT_EXTENDED = 606,          /* "FLOAT-EXTENDED"  */
    FLOAT_LONG = 607,              /* "FLOAT-LONG"  */
    FLOAT_SHORT = 608,             /* "FLOAT-SHORT"  */
    FLOATING = 609,                /* FLOATING  */
    FONT = 610,                    /* FONT  */
    FOOTING = 611,                 /* FOOTING  */
    FOR = 612,                     /* FOR  */
    FOREGROUND_COLOR = 613,        /* "FOREGROUND-COLOR"  */
    FOREVER = 614,                 /* FOREVER  */
    FORMAT = 615,                  /* FORMAT  */
    FORMATTED_DATE_FUNC = 616,     /* "FUNCTION FORMATTED-DATE"  */
    FORMATTED_DATETIME_FUNC = 617, /* "FUNCTION FORMATTED-DATETIME"  */
    FORMATTED_TIME_FUNC = 618,     /* "FUNCTION FORMATTED-TIME"  */
    FRAME = 619,                   /* FRAME  */
    FRAMED = 620,                  /* FRAMED  */
    FREE = 621,                    /* FREE  */
    FROM = 622,                    /* FROM  */
    FROM_CRT = 623,                /* "FROM CRT"  */
    FULL = 624,                    /* FULL  */
    FULL_HEIGHT = 625,             /* "FULL-HEIGHT"  */
    FUNCTION = 626,                /* FUNCTION  */
    FUNCTION_ID = 627,             /* "FUNCTION-ID"  */
    FUNCTION_NAME = 628,           /* "intrinsic function name"  */
    GENERATE = 629,                /* GENERATE  */
    GIVING = 630,                  /* GIVING  */
    GLOBAL = 631,                  /* GLOBAL  */
    GO = 632,                      /* GO  */
    GO_BACK = 633,                 /* "GO-BACK"  */
    GO_FORWARD = 634,              /* "GO-FORWARD"  */
    GO_HOME = 635,                 /* "GO-HOME"  */
    GO_SEARCH = 636,               /* "GO-SEARCH"  */
    GOBACK = 637,                  /* GOBACK  */
    GRAPHICAL = 638,               /* GRAPHICAL  */
    GREATER = 639,                 /* GREATER  */
    GREATER_OR_EQUAL = 640,        /* "GREATER OR EQUAL"  */
    GRID = 641,                    /* GRID  */
    GROUP = 642,                   /* GROUP  */
    GROUP_VALUE = 643,             /* "GROUP-VALUE"  */
    HANDLE = 644,                  /* HANDLE  */
    HAS_CHILDREN = 645,            /* "HAS-CHILDREN"  */
    HEADING = 646,                 /* HEADING  */
    HEADING_COLOR = 647,           /* "HEADING-COLOR"  */
    HEADING_DIVIDER_COLOR = 648,   /* "HEADING-DIVIDER-COLOR"  */
    HEADING_FONT = 649,            /* "HEADING-FONT"  */
    HEAVY = 650,                   /* HEAVY  */
    HEIGHT_IN_CELLS = 651,         /* "HEIGHT-IN-CELLS"  */
    HIDDEN_DATA = 652,             /* "HIDDEN-DATA"  */
    HIGHLIGHT = 653,               /* HIGHLIGHT  */
    HIGH_COLOR = 654,              /* "HIGH-COLOR"  */
    HIGH_VALUE = 655,              /* "HIGH-VALUE"  */
    HOT_TRACK = 656,               /* "HOT-TRACK"  */
    HSCROLL = 657,                 /* HSCROLL  */
    HSCROLL_POS = 658,             /* "HSCROLL-POS"  */
    ICON = 659,                    /* ICON  */
    ID = 660,                      /* ID  */
    IDENTIFIED = 661,              /* IDENTIFIED  */
    IDENTIFICATION = 662,          /* IDENTIFICATION  */
    IF = 663,                      /* IF  */
    IGNORE = 664,                  /* IGNORE  */
    IGNORING = 665,                /* IGNORING  */
    IN = 666,                      /* IN  */
    INDEPENDENT = 667,             /* INDEPENDENT  */
    INDEX = 668,                   /* INDEX  */
    INDEXED = 669,                 /* INDEXED  */
    INDICATE = 670,                /* INDICATE  */
    INITIALIZE = 671,              /* INITIALIZE  */
    INITIALIZED = 672,             /* INITIALIZED  */
    INITIATE = 673,                /* INITIATE  */
    INPUT = 674,                   /* INPUT  */
    INPUT_OUTPUT = 675,            /* "INPUT-OUTPUT"  */
    INQUIRE = 676,                 /* INQUIRE  */
    INSERTION_INDEX = 677,         /* "INSERTION-INDEX"  */
    INSERT_ROWS = 678,             /* "INSERT-ROWS"  */
    INSPECT = 679,                 /* INSPECT  */
    INSTALLATION = 680,            /* INSTALLATION  */
    INTERMEDIATE = 681,            /* INTERMEDIATE  */
    INTO = 682,                    /* INTO  */
    INTRINSIC = 683,               /* INTRINSIC  */
    INVALID = 684,                 /* INVALID  */
    INVALID_KEY = 685,             /* "INVALID KEY"  */
    IS = 686,                      /* IS  */
    ITEM = 687,                    /* ITEM  */
    ITEM_TEXT = 688,               /* "ITEM-TEXT"  */
    ITEM_TO_ADD = 689,             /* "ITEM-TO_ADD"  */
    ITEM_TO_DELETE = 690,          /* "ITEM-TO_DELETE"  */
    ITEM_TO_EMPTY = 691,           /* "ITEM-TO_EMPTY"  */
    ITEM_VALUE = 692,              /* "ITEM-VALUE"  */
    I_O = 693,                     /* "I-O"  */
    I_O_CONTROL = 694,             /* "I-O-CONTROL"  */
    JSON = 695,                    /* JSON  */
    JUSTIFIED = 696,               /* JUSTIFIED  */
    KEPT = 697,                    /* KEPT  */
    KEY = 698,                     /* KEY  */
    KEYBOARD = 699,                /* KEYBOARD  */
    LABEL = 700,                   /* LABEL  */
    LABEL_OFFSET = 701,            /* "LABEL-OFFSET"  */
    LARGE_FONT = 702,              /* "LARGE-FONT"  */
    LARGE_OFFSET = 703,            /* "LARGE-OFFSET"  */
    LAST = 704,                    /* LAST  */
    LAST_ROW = 705,                /* "LAST-ROW"  */
    LAYOUT_DATA = 706,             /* "LAYOUT-DATA"  */
    LAYOUT_MANAGER = 707,          /* "LAYOUT-MANAGER"  */
    LEADING = 708,                 /* LEADING  */
    LEADING_SHIFT = 709,           /* "LEADING-SHIFT"  */
    LEAVE = 710,                   /* LEAVE  */
    LEFT = 711,                    /* LEFT  */
    LEFTLINE = 712,                /* LEFTLINE  */
    LEFT_TEXT = 713,               /* "LEFT-TEXT"  */
    LENGTH = 714,                  /* LENGTH  */
    LENGTH_OF = 715,               /* "LENGTH OF"  */
    LENGTH_FUNC = 716,             /* "FUNCTION LENGTH/BYTE-LENGTH"  */
    LESS = 717,                    /* LESS  */
    LESS_OR_EQUAL = 718,           /* "LESS OR EQUAL"  */
    LEVEL_NUMBER = 719,            /* "level-number"  */
    LIKE = 720,                    /* LIKE  */
    LIMIT = 721,                   /* LIMIT  */
    LIMITS = 722,                  /* LIMITS  */
    LINAGE = 723,                  /* LINAGE  */
    LINAGE_COUNTER = 724,          /* "LINAGE-COUNTER"  */
    LINE = 725,                    /* LINE  */
    LINE_COUNTER = 726,            /* "LINE-COUNTER"  */
    LINE_LIMIT = 727,              /* "LINE LIMIT"  */
    LINE_SEQUENTIAL = 728,         /* "LINE-SEQUENTIAL"  */
    LINES = 729,                   /* LINES  */
    LINES_AT_ROOT = 730,           /* "LINES-AT-ROOT"  */
    LINKAGE = 731,                 /* LINKAGE  */
    LIST_BOX = 732,                /* "LIST-BOX"  */
    LITERAL = 733,                 /* "Literal"  */
    LM_RESIZE = 734,               /* "LM-RESIZE"  */
    LOC = 735,                     /* LOC  */
    LOCALE = 736,                  /* LOCALE  */
    LOCALE_DATE_FUNC = 737,        /* "FUNCTION LOCALE-DATE"  */
    LOCALE_TIME_FUNC = 738,        /* "FUNCTION LOCALE-TIME"  */
    LOCALE_TIME_FROM_FUNC = 739,   /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
    LOCAL_STORAGE = 740,           /* "LOCAL-STORAGE"  */
    LOCK = 741,                    /* LOCK  */
    LOCK_HOLDING = 742,            /* "LOCK-HOLDING"  */
    LONG_DATE = 743,               /* "LONG-DATE"  */
    LOWER = 744,                   /* LOWER  */
    LOWERED = 745,                 /* LOWERED  */
    LOWER_CASE_FUNC = 746,         /* "FUNCTION LOWER-CASE"  */
    LOWLIGHT = 747,                /* LOWLIGHT  */
    LOW_COLOR = 748,               /* "LOW-COLOR"  */
    LOW_VALUE = 749,               /* "LOW-VALUE"  */
    MAGNETIC_TAPE = 750,           /* "MAGNETIC-TAPE"  */
    MANUAL = 751,                  /* MANUAL  */
    MASS_UPDATE = 752,             /* "MASS-UPDATE"  */
    MASTER_INDEX = 753,            /* "MASTER-INDEX"  */
    MAX_LINES = 754,               /* "MAX-LINES"  */
    MAX_PROGRESS = 755,            /* "MAX-PROGRESS"  */
    MAX_TEXT = 756,                /* "MAX-TEXT"  */
    MAX_VAL = 757,                 /* "MAX-VAL"  */
    MEMORY = 758,                  /* MEMORY  */
    MEDIUM_FONT = 759,             /* "MEDIUM-FONT"  */
    MENU = 760,                    /* MENU  */
    MERGE = 761,                   /* MERGE  */
    MESSAGE = 762,                 /* MESSAGE  */
    MINUS = 763,                   /* MINUS  */
    MIN_VAL = 764,                 /* "MIN-VAL"  */
    MNEMONIC_NAME = 765,           /* "Mnemonic name"  */
    MODE = 766,                    /* MODE  */
    MODIFY = 767,                  /* MODIFY  */
    MODULES = 768,                 /* MODULES  */
    MOVE = 769,                    /* MOVE  */
    MULTILINE = 770,               /* MULTILINE  */
    MULTIPLE = 771,                /* MULTIPLE  */
    MULTIPLY = 772,                /* MULTIPLY  */
    NAME = 773,                    /* NAME  */
    NAMED = 774,                   /* NAMED  */
    NAMESPACE = 775,               /* NAMESPACE  */
    NAMESPACE_PREFIX = 776,        /* "NAMESPACE-PREFIX"  */
    NATIONAL = 777,                /* NATIONAL  */
    NATIONAL_EDITED = 778,         /* "NATIONAL-EDITED"  */
    NATIONAL_OF_FUNC = 779,        /* "FUNCTION NATIONAL-OF"  */
    NATIVE = 780,                  /* NATIVE  */
    NAVIGATE_URL = 781,            /* "NAVIGATE-URL"  */
    NEAREST_AWAY_FROM_ZERO = 782,  /* "NEAREST-AWAY-FROM-ZERO"  */
    NEAREST_EVEN = 783,            /* "NEAREST-EVEN"  */
    NEAREST_TOWARD_ZERO = 784,     /* "NEAREST-TOWARD-ZERO"  */
    NEGATIVE = 785,                /* NEGATIVE  */
    NESTED = 786,                  /* NESTED  */
    NEW = 787,                     /* NEW  */
    NEXT = 788,                    /* NEXT  */
    NEXT_ITEM = 789,               /* "NEXT-ITEM"  */
    NEXT_GROUP = 790,              /* "NEXT GROUP"  */
    NEXT_PAGE = 791,               /* "NEXT PAGE"  */
    NO = 792,                      /* NO  */
    NO_ADVANCING = 793,            /* "NO ADVANCING"  */
    NO_AUTOSEL = 794,              /* "NO-AUTOSEL"  */
    NO_AUTO_DEFAULT = 795,         /* "NO-AUTO-DEFAULT"  */
    NO_BOX = 796,                  /* "NO-BOX"  */
    NO_DATA = 797,                 /* "NO DATA"  */
    NO_DIVIDERS = 798,             /* "NO-DIVIDERS"  */
    NO_ECHO = 799,                 /* "NO-ECHO"  */
    NO_F4 = 800,                   /* "NO-F4"  */
    NO_FOCUS = 801,                /* "NO-FOCUS"  */
    NO_GROUP_TAB = 802,            /* "NO-GROUP-TAB"  */
    NO_KEY_LETTER = 803,           /* "NO-KEY-LETTER"  */
    NO_SEARCH = 804,               /* "NO-SEARCH"  */
    NO_UPDOWN = 805,               /* "NO-UPDOWN"  */
    NOMINAL = 806,                 /* NOMINAL  */
    NONE = 807,                    /* NONE  */
    NONNUMERIC = 808,              /* NONNUMERIC  */
    NORMAL = 809,                  /* NORMAL  */
    NOT = 810,                     /* NOT  */
    NOTAB = 811,                   /* NOTAB  */
    NOTHING = 812,                 /* NOTHING  */
    NOTIFY = 813,                  /* NOTIFY  */
    NOTIFY_CHANGE = 814,           /* "NOTIFY-CHANGE"  */
    NOTIFY_DBLCLICK = 815,         /* "NOTIFY-DBLCLICK"  */
    NOTIFY_SELCHANGE = 816,        /* "NOTIFY-SELCHANGE"  */
    NOT_AT_END = 817,              /* "NOT AT END"  */
    NOT_EOP = 818,                 /* "NOT AT EOP"  */
    NOT_ON_ESCAPE = 819,           /* "NOT ON ESCAPE"  */
    NOT_EQUAL = 820,               /* "NOT EQUAL"  */
    NOT_ON_EXCEPTION = 821,        /* "NOT ON EXCEPTION"  */
    NOT_INVALID_KEY = 822,         /* "NOT INVALID KEY"  */
    NOT_ON_OVERFLOW = 823,         /* "NOT ON OVERFLOW"  */
    NOT_SIZE_ERROR = 824,          /* "NOT SIZE ERROR"  */
    NUM_COL_HEADINGS = 825,        /* "NUM-COL-HEADINGS"  */
    NUM_ROWS = 826,                /* "NUM-ROWS"  */
    NUMBER = 827,                  /* NUMBER  */
    NUMBERS = 828,                 /* NUMBERS  */
    NUMERIC = 829,                 /* NUMERIC  */
    NUMERIC_EDITED = 830,          /* "NUMERIC-EDITED"  */
    NUMVALC_FUNC = 831,            /* "FUNCTION NUMVAL-C"  */
    OBJECT = 832,                  /* OBJECT  */
    OBJECT_COMPUTER = 833,         /* "OBJECT-COMPUTER"  */
    OCCURS = 834,                  /* OCCURS  */
    OF = 835,                      /* OF  */
    OFF = 836,                     /* OFF  */
    OK_BUTTON = 837,               /* "OK-BUTTON"  */
    OMITTED = 838,                 /* OMITTED  */
    ON = 839,                      /* ON  */
    ONLY = 840,                    /* ONLY  */
    ON_ESCAPE = 841,               /* "ON ESCAPE"  */
    ON_EXCEPTION = 842,            /* "ON EXCEPTION"  */
    OPEN = 843,                    /* OPEN  */
    OPTIONAL = 844,                /* OPTIONAL  */
    OPTIONS = 845,                 /* OPTIONS  */
    OR = 846,                      /* OR  */
    ORDER = 847,                   /* ORDER  */
    ORGANIZATION = 848,            /* ORGANIZATION  */
    OTHER = 849,                   /* OTHER  */
    OTHERS = 850,                  /* OTHERS  */
    OUTPUT = 851,                  /* OUTPUT  */
    OVERLAP_LEFT = 852,            /* "OVERLAP-LEFT"  */
    OVERLAP_TOP = 853,             /* "OVERLAP-TOP"  */
    OVERLINE = 854,                /* OVERLINE  */
    PACKED_DECIMAL = 855,          /* "PACKED-DECIMAL"  */
    PADDING = 856,                 /* PADDING  */
    PASCAL = 857,                  /* PASCAL  */
    PAGE = 858,                    /* PAGE  */
    PAGE_COUNTER = 859,            /* "PAGE-COUNTER"  */
    PAGE_SETUP = 860,              /* "PAGE-SETUP"  */
    PAGED = 861,                   /* PAGED  */
    PARAGRAPH = 862,               /* PARAGRAPH  */
    PARENT = 863,                  /* PARENT  */
    PARSE = 864,                   /* PARSE  */
    PASSWORD = 865,                /* PASSWORD  */
    PERFORM = 866,                 /* PERFORM  */
    PERMANENT = 867,               /* PERMANENT  */
    PH = 868,                      /* PH  */
    PF = 869,                      /* PF  */
    PHYSICAL = 870,                /* PHYSICAL  */
    PICTURE = 871,                 /* PICTURE  */
    PICTURE_SYMBOL = 872,          /* "PICTURE SYMBOL"  */
    PIXEL = 873,                   /* PIXEL  */
    PLACEMENT = 874,               /* PLACEMENT  */
    PLUS = 875,                    /* PLUS  */
    POINTER = 876,                 /* POINTER  */
    POP_UP = 877,                  /* "POP-UP"  */
    POS = 878,                     /* POS  */
    POSITION = 879,                /* POSITION  */
    POSITION_SHIFT = 880,          /* "POSITION-SHIFT"  */
    POSITIVE = 881,                /* POSITIVE  */
    PRESENT = 882,                 /* PRESENT  */
    PREVIOUS = 883,                /* PREVIOUS  */
    PRINT = 884,                   /* PRINT  */
    PRINT_CONTROL = 885,           /* "PRINT-CONTROL"  */
    PRINT_NO_PROMPT = 886,         /* "PRINT-NO-PROMPT"  */
    PRINT_PREVIEW = 887,           /* "PRINT-PREVIEW"  */
    PRINTER = 888,                 /* PRINTER  */
    PRINTER_1 = 889,               /* "PRINTER-1"  */
    PRINTING = 890,                /* PRINTING  */
    PRIORITY = 891,                /* PRIORITY  */
    PROCEDURE = 892,               /* PROCEDURE  */
    PROCEDURES = 893,              /* PROCEDURES  */
    PROCEED = 894,                 /* PROCEED  */
    PROCESSING = 895,              /* PROCESSING  */
    PROGRAM = 896,                 /* PROGRAM  */
    PROGRAM_ID = 897,              /* "PROGRAM-ID"  */
    PROGRAM_NAME = 898,            /* "program name"  */
    PROGRAM_POINTER = 899,         /* "PROGRAM-POINTER"  */
    PROGRESS = 900,                /* PROGRESS  */
    PROHIBITED = 901,              /* PROHIBITED  */
    PROMPT = 902,                  /* PROMPT  */
    PROPERTIES = 903,              /* PROPERTIES  */
    PROPERTY = 904,                /* PROPERTY  */
    PROTECTED = 905,               /* PROTECTED  */
    PROTOTYPE = 906,               /* PROTOTYPE  */
    PURGE = 907,                   /* PURGE  */
    PUSH_BUTTON = 908,             /* "PUSH-BUTTON"  */
    QUERY_INDEX = 909,             /* "QUERY-INDEX"  */
    QUEUE = 910,                   /* QUEUE  */
    QUOTE = 911,                   /* QUOTE  */
    RADIO_BUTTON = 912,            /* "RADIO-BUTTON"  */
    RAISE = 913,                   /* RAISE  */
    RAISED = 914,                  /* RAISED  */
    RAISING = 915,                 /* RAISING  */
    RANDOM = 916,                  /* RANDOM  */
    RD = 917,                      /* RD  */
    READ = 918,                    /* READ  */
    READERS = 919,                 /* READERS  */
    READ_ONLY = 920,               /* "READ-ONLY"  */
    READY_TRACE = 921,             /* "READY TRACE"  */
    RECEIVE = 922,                 /* RECEIVE  */
    RECEIVED = 923,                /* RECEIVED  */
    RECORD = 924,                  /* RECORD  */
    RECORD_DATA = 925,             /* "RECORD-DATA"  */
    RECORD_OVERFLOW = 926,         /* "RECORD-OVERFLOW"  */
    RECORD_TO_ADD = 927,           /* "RECORD-TO-ADD"  */
    RECORD_TO_DELETE = 928,        /* "RECORD-TO-DELETE"  */
    RECORDING = 929,               /* RECORDING  */
    RECORDS = 930,                 /* RECORDS  */
    RECURSIVE = 931,               /* RECURSIVE  */
    REDEFINES = 932,               /* REDEFINES  */
    REEL = 933,                    /* REEL  */
    REFERENCE = 934,               /* REFERENCE  */
    REFERENCES = 935,              /* REFERENCES  */
    REFRESH = 936,                 /* REFRESH  */
    REGION_COLOR = 937,            /* "REGION-COLOR"  */
    RELATION = 938,                /* RELATION  */
    RELATIVE = 939,                /* RELATIVE  */
    RELEASE = 940,                 /* RELEASE  */
    REMAINDER = 941,               /* REMAINDER  */
    REMARKS = 942,                 /* REMARKS  */
    REMOVAL = 943,                 /* REMOVAL  */
    RENAMES = 944,                 /* RENAMES  */
    REORG_CRITERIA = 945,          /* "REORG-CRITERIA"  */
    REPEATED = 946,                /* REPEATED  */
    REPLACE = 947,                 /* REPLACE  */
    REPLACING = 948,               /* REPLACING  */
    REPORT = 949,                  /* REPORT  */
    REPORTING = 950,               /* REPORTING  */
    REPORTS = 951,                 /* REPORTS  */
    REPOSITORY = 952,              /* REPOSITORY  */
    REQUIRED = 953,                /* REQUIRED  */
    REREAD = 954,                  /* REREAD  */
    RERUN = 955,                   /* RERUN  */
    RESERVE = 956,                 /* RESERVE  */
    RESET = 957,                   /* RESET  */
    RESET_TRACE = 958,             /* "RESET TRACE"  */
    RESET_GRID = 959,              /* "RESET-GRID"  */
    RESET_LIST = 960,              /* "RESET-LIST"  */
    RESET_TABS = 961,              /* "RESET-TABS"  */
    RETRY = 962,                   /* RETRY  */
    RETURN = 963,                  /* RETURN  */
    RETURNING = 964,               /* RETURNING  */
    REVERSE = 965,                 /* REVERSE  */
    REVERSE_FUNC = 966,            /* "FUNCTION REVERSE"  */
    REVERSE_VIDEO = 967,           /* "REVERSE-VIDEO"  */
    REVERSED = 968,                /* REVERSED  */
    REWIND = 969,                  /* REWIND  */
    REWRITE = 970,                 /* REWRITE  */
    RF = 971,                      /* RF  */
    RH = 972,                      /* RH  */
    RIGHT = 973,                   /* RIGHT  */
    RIGHT_ALIGN = 974,             /* "RIGHT-ALIGN"  */
    RIMMED = 975,                  /* RIMMED  */
    ROLLBACK = 976,                /* ROLLBACK  */
    ROUNDED = 977,                 /* ROUNDED  */
    ROUNDING = 978,                /* ROUNDING  */
    ROW_COLOR = 979,               /* "ROW-COLOR"  */
    ROW_COLOR_PATTERN = 980,       /* "ROW-COLOR-PATTERN"  */
    ROW_DIVIDERS = 981,            /* "ROW-DIVIDERS"  */
    ROW_FONT = 982,                /* "ROW-FONT"  */
    ROW_HEADINGS = 983,            /* "ROW-HEADINGS"  */
    ROW_PROTECTION = 984,          /* "ROW-PROTECTION"  */
    RUN = 985,                     /* RUN  */
    S = 986,                       /* S  */
    SAME = 987,                    /* SAME  */
    SAVE_AS = 988,                 /* "SAVE-AS"  */
    SAVE_AS_NO_PROMPT = 989,       /* "SAVE-AS-NO-PROMPT"  */
    SCREEN = 990,                  /* SCREEN  */
    SCREEN_CONTROL = 991,          /* "SCREEN CONTROL"  */
    SCROLL = 992,                  /* SCROLL  */
    SCROLL_BAR = 993,              /* "SCROLL-BAR"  */
    SD = 994,                      /* SD  */
    SEARCH = 995,                  /* SEARCH  */
    SEARCH_OPTIONS = 996,          /* "SEARCH-OPTIONS"  */
    SEARCH_TEXT = 997,             /* "SEARCH-TEXT"  */
    SECONDS = 998,                 /* SECONDS  */
    SECTION = 999,                 /* SECTION  */
    SECURE = 1000,                 /* SECURE  */
    SECURITY = 1001,               /* SECURITY  */
    SEGMENT = 1002,                /* SEGMENT  */
    SEGMENT_LIMIT = 1003,          /* "SEGMENT-LIMIT"  */
    SELECT = 1004,                 /* SELECT  */
    SELECTION_INDEX = 1005,        /* "SELECTION-INDEX"  */
    SELECTION_TEXT = 1006,         /* "SELECTION-TEXT"  */
    SELECT_ALL = 1007,             /* "SELECTION-ALL"  */
    SELF_ACT = 1008,               /* "SELF-ACT"  */
    SEMI_COLON = 1009,             /* "semi-colon"  */
    SEND = 1010,                   /* SEND  */
    SENTENCE = 1011,               /* SENTENCE  */
    SEPARATE = 1012,               /* SEPARATE  */
    SEPARATION = 1013,             /* SEPARATION  */
    SEQUENCE = 1014,               /* SEQUENCE  */
    SEQUENTIAL = 1015,             /* SEQUENTIAL  */
    SET = 1016,                    /* SET  */
    SEVENTY_EIGHT = 1017,          /* "level-number 78"  */
    SHADING = 1018,                /* SHADING  */
    SHADOW = 1019,                 /* SHADOW  */
    SHARING = 1020,                /* SHARING  */
    SHORT_DATE = 1021,             /* "SHORT-DATE"  */
    SHOW_LINES = 1022,             /* "SHOW-LINES"  */
    SHOW_NONE = 1023,              /* "SHOW-NONE"  */
    SHOW_SEL_ALWAYS = 1024,        /* "SHOW-SEL-ALWAYS"  */
    SIGN = 1025,                   /* SIGN  */
    SIGNED = 1026,                 /* SIGNED  */
    SIGNED_INT = 1027,             /* "SIGNED-INT"  */
    SIGNED_LONG = 1028,            /* "SIGNED-LONG"  */
    SIGNED_SHORT = 1029,           /* "SIGNED-SHORT"  */
    SIXTY_SIX = 1030,              /* "level-number 66"  */
    SIZE = 1031,                   /* SIZE  */
    SIZE_ERROR = 1032,             /* "SIZE ERROR"  */
    SMALL_FONT = 1033,             /* "SMALL-FONT"  */
    SORT = 1034,                   /* SORT  */
    SORT_MERGE = 1035,             /* "SORT-MERGE"  */
    SORT_ORDER = 1036,             /* "SORT-ORDER"  */
    SOURCE = 1037,                 /* SOURCE  */
    SOURCE_COMPUTER = 1038,        /* "SOURCE-COMPUTER"  */
    SPACE = 1039,                  /* SPACE  */
    SPECIAL_NAMES = 1040,          /* "SPECIAL-NAMES"  */
    SPINNER = 1041,                /* SPINNER  */
    SQUARE = 1042,                 /* SQUARE  */
    STANDARD = 1043,               /* STANDARD  */
    STANDARD_1 = 1044,             /* "STANDARD-1"  */
    STANDARD_2 = 1045,             /* "STANDARD-2"  */
    STANDARD_BINARY = 1046,        /* "STANDARD-BINARY"  */
    STANDARD_DECIMAL = 1047,       /* "STANDARD-DECIMAL"  */
    START = 1048,                  /* START  */
    START_X = 1049,                /* "START-X"  */
    START_Y = 1050,                /* "START-Y"  */
    STATIC = 1051,                 /* STATIC  */
    STATIC_LIST = 1052,            /* "STATIC-LIST"  */
    STATUS = 1053,                 /* STATUS  */
    STATUS_BAR = 1054,             /* "STATUS-BAR"  */
    STATUS_TEXT = 1055,            /* "STATUS-TEXT"  */
    STDCALL = 1056,                /* STDCALL  */
    STEP = 1057,                   /* STEP  */
    STOP = 1058,                   /* STOP  */
    STRING = 1059,                 /* STRING  */
    STRONG = 1060,                 /* STRONG  */
    STYLE = 1061,                  /* STYLE  */
    SUB_QUEUE_1 = 1062,            /* "SUB-QUEUE-1"  */
    SUB_QUEUE_2 = 1063,            /* "SUB-QUEUE-2"  */
    SUB_QUEUE_3 = 1064,            /* "SUB-QUEUE-3"  */
    SUBSTITUTE_FUNC = 1065,        /* "FUNCTION SUBSTITUTE"  */
    SUBSTITUTE_CASE_FUNC = 1066,   /* "FUNCTION SUBSTITUTE-CASE"  */
    SUBTRACT = 1067,               /* SUBTRACT  */
    SUBWINDOW = 1068,              /* SUBWINDOW  */
    SUM = 1069,                    /* SUM  */
    SUPPRESS = 1070,               /* SUPPRESS  */
    SUPPRESS_XML = 1071,           /* "SUPPRESS"  */
    SYMBOLIC = 1072,               /* SYMBOLIC  */
    SYNCHRONIZED = 1073,           /* SYNCHRONIZED  */
    SYSTEM_DEFAULT = 1074,         /* "SYSTEM-DEFAULT"  */
    SYSTEM_INFO = 1075,            /* "SYSTEM-INFO"  */
    SYSTEM_OFFSET = 1076,          /* "SYSTEM-OFFSET"  */
    TAB = 1077,                    /* TAB  */
    TAB_TO_ADD = 1078,             /* "TAB-TO-ADD"  */
    TAB_TO_DELETE = 1079,          /* "TAB-TO-DELETE"  */
    TABLE = 1080,                  /* TABLE  */
    TALLYING = 1081,               /* TALLYING  */
    TEMPORARY = 1082,              /* TEMPORARY  */
    TAPE = 1083,                   /* TAPE  */
    TERMINAL = 1084,               /* TERMINAL  */
    TERMINATE = 1085,              /* TERMINATE  */
    TERMINAL_INFO = 1086,          /* "TERMINAL-INFO"  */
    TERMINATION_VALUE = 1087,      /* "TERMINATION-VALUE"  */
    TEST = 1088,                   /* TEST  */
    TEXT = 1089,                   /* TEXT  */
    THAN = 1090,                   /* THAN  */
    THEN = 1091,                   /* THEN  */
    THREAD = 1092,                 /* THREAD  */
    THREADS = 1093,                /* THREADS  */
    THRU = 1094,                   /* THRU  */
    THUMB_POSITION = 1095,         /* "THUMB-POSITION"  */
    TILED_HEADINGS = 1096,         /* "TILED-HEADINGS"  */
    TIME = 1097,                   /* TIME  */
    TIME_OUT = 1098,               /* "TIME-OUT"  */
    TIMES = 1099,                  /* TIMES  */
    TITLE = 1100,                  /* TITLE  */
    TITLE_POSITION = 1101,         /* "TITLE-POSITION"  */
    TO = 1102,                     /* TO  */
    TOK_AMPER = 1103,              /* "&"  */
    TOK_CLOSE_PAREN = 1104,        /* ")"  */
    TOK_COLON = 1105,              /* ":"  */
    TOK_DIV = 1106,                /* "/"  */
    TOK_DOT = 1107,                /* "."  */
    TOK_EQUAL = 1108,              /* "="  */
    TOK_EXTERN = 1109,             /* "EXTERN"  */
    TOK_FALSE = 1110,              /* "FALSE"  */
    TOK_FILE = 1111,               /* "FILE"  */
    TOK_GREATER = 1112,            /* ">"  */
    TOK_INITIAL = 1113,            /* "INITIAL"  */
    TOK_LESS = 1114,               /* "<"  */
    TOK_MINUS = 1115,              /* "-"  */
    TOK_MUL = 1116,                /* "*"  */
    TOK_NULL = 1117,               /* "NULL"  */
    TOK_OVERFLOW = 1118,           /* "OVERFLOW"  */
    TOK_OPEN_PAREN = 1119,         /* "("  */
    TOK_PLUS = 1120,               /* "+"  */
    TOK_TRUE = 1121,               /* "TRUE"  */
    TOP = 1122,                    /* TOP  */
    TOWARD_GREATER = 1123,         /* "TOWARD-GREATER"  */
    TOWARD_LESSER = 1124,          /* "TOWARD-LESSER"  */
    TRACK = 1125,                  /* TRACK  */
    TRACKS = 1126,                 /* TRACKS  */
    TRACK_AREA = 1127,             /* "TRACK-AREA"  */
    TRACK_LIMIT = 1128,            /* "TRACK-LIMIT"  */
    TRADITIONAL_FONT = 1129,       /* "TRADITIONAL-FONT"  */
    TRAILING = 1130,               /* TRAILING  */
    TRAILING_SHIFT = 1131,         /* "TRAILING-SHIFT"  */
    TRANSFORM = 1132,              /* TRANSFORM  */
    TRANSPARENT = 1133,            /* TRANSPARENT  */
    TREE_VIEW = 1134,              /* "TREE-VIEW"  */
    TRIM_FUNC = 1135,              /* "FUNCTION TRIM"  */
    TRUNCATION = 1136,             /* TRUNCATION  */
    TYPE = 1137,                   /* TYPE  */
    TYPEDEF = 1138,                /* TYPEDEF  */
    U = 1139,                      /* U  */
    UCS_4 = 1140,                  /* "UCS-4"  */
    UNBOUNDED = 1141,              /* UNBOUNDED  */
    UNDERLINE = 1142,              /* UNDERLINE  */
    UNFRAMED = 1143,               /* UNFRAMED  */
    UNIT = 1144,                   /* UNIT  */
    UNLOCK = 1145,                 /* UNLOCK  */
    UNSIGNED = 1146,               /* UNSIGNED  */
    UNSIGNED_INT = 1147,           /* "UNSIGNED-INT"  */
    UNSIGNED_LONG = 1148,          /* "UNSIGNED-LONG"  */
    UNSIGNED_SHORT = 1149,         /* "UNSIGNED-SHORT"  */
    UNSORTED = 1150,               /* UNSORTED  */
    UNSTRING = 1151,               /* UNSTRING  */
    UNTIL = 1152,                  /* UNTIL  */
    UP = 1153,                     /* UP  */
    UPDATE = 1154,                 /* UPDATE  */
    UPDATERS = 1155,               /* UPDATERS  */
    UPON = 1156,                   /* UPON  */
    UPON_ARGUMENT_NUMBER = 1157,   /* "UPON ARGUMENT-NUMBER"  */
    UPON_COMMAND_LINE = 1158,      /* "UPON COMMAND-LINE"  */
    UPON_ENVIRONMENT_NAME = 1159,  /* "UPON ENVIRONMENT-NAME"  */
    UPON_ENVIRONMENT_VALUE = 1160, /* "UPON ENVIRONMENT-VALUE"  */
    UPPER = 1161,                  /* UPPER  */
    UPPER_CASE_FUNC = 1162,        /* "FUNCTION UPPER-CASE"  */
    USAGE = 1163,                  /* USAGE  */
    USE = 1164,                    /* USE  */
    USE_ALT = 1165,                /* "USE-ALT"  */
    USE_RETURN = 1166,             /* "USE-RETURN"  */
    USE_TAB = 1167,                /* "USE-TAB"  */
    USER = 1168,                   /* USER  */
    USER_DEFAULT = 1169,           /* "USER-DEFAULT"  */
    USER_FUNCTION_NAME = 1170,     /* "user function name"  */
    USING = 1171,                  /* USING  */
    UTF_8 = 1172,                  /* "UTF-8"  */
    UTF_16 = 1173,                 /* "UTF-16"  */
    V = 1174,                      /* V  */
    VALID = 1175,                  /* VALID  */
    VALIDATE = 1176,               /* VALIDATE  */
    VAL_STATUS = 1177,             /* "VAL-STATUS"  */
    VALIDATE_STATUS = 1178,        /* "VALIDATE-STATUS"  */
    VALIDATING = 1179,             /* VALIDATING  */
    VALUE = 1180,                  /* VALUE  */
    VALUE_FORMAT = 1181,           /* "VALUE-FORMAT"  */
    VALUES = 1182,                 /* VALUES  */
    VARIABLE = 1183,               /* VARIABLE  */
    VARIANT = 1184,                /* VARIANT  */
    VARYING = 1185,                /* VARYING  */
    VERTICAL = 1186,               /* VERTICAL  */
    VERY_HEAVY = 1187,             /* "VERY-HEAVY"  */
    VIRTUAL_WIDTH = 1188,          /* "VIRTUAL-WIDTH"  */
    VOLATILE = 1189,               /* VOLATILE  */
    VPADDING = 1190,               /* VPADDING  */
    VSCROLL = 1191,                /* VSCROLL  */
    VSCROLL_BAR = 1192,            /* "VSCROLL-BAR"  */
    VSCROLL_POS = 1193,            /* "VSCROLL-POS"  */
    VTOP = 1194,                   /* VTOP  */
    WAIT = 1195,                   /* WAIT  */
    WEB_BROWSER = 1196,            /* "WEB-BROWSER"  */
    WHEN = 1197,                   /* WHEN  */
    WHEN_COMPILED_FUNC = 1198,     /* "FUNCTION WHEN-COMPILED"  */
    WHEN_XML = 1199,               /* "WHEN"  */
    WIDTH = 1200,                  /* WIDTH  */
    WIDTH_IN_CELLS = 1201,         /* "WIDTH-IN-CELLS"  */
    WINDOW = 1202,                 /* WINDOW  */
    WITH = 1203,                   /* WITH  */
    WORD = 1204,                   /* "Identifier"  */
    WORDS = 1205,                  /* WORDS  */
    WORKING_STORAGE = 1206,        /* "WORKING-STORAGE"  */
    WRAP = 1207,                   /* WRAP  */
    WRITE = 1208,                  /* WRITE  */
    WRITE_ONLY = 1209,             /* "WRITE-ONLY"  */
    WRITE_VERIFY = 1210,           /* "WRITE-VERIFY"  */
    WRITERS = 1211,                /* WRITERS  */
    X = 1212,                      /* X  */
    XML = 1213,                    /* XML  */
    XML_DECLARATION = 1214,        /* "XML-DECLARATION"  */
    XML_SCHEMA = 1215,             /* "XML-SCHEMA"  */
    Y = 1216,                      /* Y  */
    YYYYDDD = 1217,                /* YYYYDDD  */
    YYYYMMDD = 1218,               /* YYYYMMDD  */
    ZERO = 1219,                   /* ZERO  */
    LEVEL_NUMBER_IN_AREA_A = 1220, /* "level-number (Area A)"  */
    WORD_IN_AREA_A = 1221,         /* "Identifier (Area A)"  */
    SHIFT_PREFER = 1222            /* SHIFT_PREFER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_THREEDIMENSIONAL = 3,           /* "3D"  */
  YYSYMBOL_ABSENT = 4,                     /* ABSENT  */
  YYSYMBOL_ACCEPT = 5,                     /* ACCEPT  */
  YYSYMBOL_ACCESS = 6,                     /* ACCESS  */
  YYSYMBOL_ACTIVEX = 7,                    /* "ACTIVE-X"  */
  YYSYMBOL_ACTIVE_CLASS = 8,               /* "ACTIVE-CLASS"  */
  YYSYMBOL_ACTION = 9,                     /* ACTION  */
  YYSYMBOL_ACTUAL = 10,                    /* ACTUAL  */
  YYSYMBOL_ADD = 11,                       /* ADD  */
  YYSYMBOL_ADDRESS = 12,                   /* ADDRESS  */
  YYSYMBOL_ADJUSTABLE_COLUMNS = 13,        /* "ADJUSTABLE-COLUMNS"  */
  YYSYMBOL_ADVANCING = 14,                 /* ADVANCING  */
  YYSYMBOL_AFTER = 15,                     /* AFTER  */
  YYSYMBOL_ALIGNED = 16,                   /* ALIGNED  */
  YYSYMBOL_ALIGNMENT = 17,                 /* ALIGNMENT  */
  YYSYMBOL_ALL = 18,                       /* ALL  */
  YYSYMBOL_ALLOCATE = 19,                  /* ALLOCATE  */
  YYSYMBOL_ALLOWING = 20,                  /* ALLOWING  */
  YYSYMBOL_ALPHABET = 21,                  /* ALPHABET  */
  YYSYMBOL_ALPHABETIC = 22,                /* ALPHABETIC  */
  YYSYMBOL_ALPHABETIC_LOWER = 23,          /* "ALPHABETIC-LOWER"  */
  YYSYMBOL_ALPHABETIC_UPPER = 24,          /* "ALPHABETIC-UPPER"  */
  YYSYMBOL_ALPHANUMERIC = 25,              /* ALPHANUMERIC  */
  YYSYMBOL_ALPHANUMERIC_EDITED = 26,       /* "ALPHANUMERIC-EDITED"  */
  YYSYMBOL_ALSO = 27,                      /* ALSO  */
  YYSYMBOL_ALTER = 28,                     /* ALTER  */
  YYSYMBOL_ALTERNATE = 29,                 /* ALTERNATE  */
  YYSYMBOL_AND = 30,                       /* AND  */
  YYSYMBOL_ANY = 31,                       /* ANY  */
  YYSYMBOL_APPLY = 32,                     /* APPLY  */
  YYSYMBOL_ARE = 33,                       /* ARE  */
  YYSYMBOL_AREA = 34,                      /* AREA  */
  YYSYMBOL_AREAS = 35,                     /* AREAS  */
  YYSYMBOL_ARGUMENT_NUMBER = 36,           /* "ARGUMENT-NUMBER"  */
  YYSYMBOL_ARGUMENT_VALUE = 37,            /* "ARGUMENT-VALUE"  */
  YYSYMBOL_ARITHMETIC = 38,                /* ARITHMETIC  */
  YYSYMBOL_AS = 39,                        /* AS  */
  YYSYMBOL_ASCENDING = 40,                 /* ASCENDING  */
  YYSYMBOL_ASCII = 41,                     /* ASCII  */
  YYSYMBOL_ASSIGN = 42,                    /* ASSIGN  */
  YYSYMBOL_AT = 43,                        /* AT  */
  YYSYMBOL_AT_END = 44,                    /* "AT END"  */
  YYSYMBOL_ATTRIBUTE = 45,                 /* ATTRIBUTE  */
  YYSYMBOL_ATTRIBUTES = 46,                /* ATTRIBUTES  */
  YYSYMBOL_AUTHOR = 47,                    /* AUTHOR  */
  YYSYMBOL_AUTO = 48,                      /* AUTO  */
  YYSYMBOL_AUTO_DECIMAL = 49,              /* "AUTO-DECIMAL"  */
  YYSYMBOL_AUTO_SPIN = 50,                 /* "AUTO-SPIN"  */
  YYSYMBOL_AUTOMATIC = 51,                 /* AUTOMATIC  */
  YYSYMBOL_AWAY_FROM_ZERO = 52,            /* "AWAY-FROM-ZERO"  */
  YYSYMBOL_B_AND = 53,                     /* "B-AND"  */
  YYSYMBOL_B_NOT = 54,                     /* "B-NOT"  */
  YYSYMBOL_B_OR = 55,                      /* "B-OR"  */
  YYSYMBOL_B_XOR = 56,                     /* "B-XOR"  */
  YYSYMBOL_B_SHIFT_L = 57,                 /* "B-SHIFT-L"  */
  YYSYMBOL_B_SHIFT_R = 58,                 /* "B-SHIFT-R"  */
  YYSYMBOL_B_SHIFT_LC = 59,                /* "B-SHIFT-LC"  */
  YYSYMBOL_B_SHIFT_RC = 60,                /* "B-SHIFT-RC"  */
  YYSYMBOL_BACKGROUND_COLOR = 61,          /* "BACKGROUND-COLOR"  */
  YYSYMBOL_BACKGROUND_HIGH = 62,           /* "BACKGROUND-HIGH"  */
  YYSYMBOL_BACKGROUND_LOW = 63,            /* "BACKGROUND-LOW"  */
  YYSYMBOL_BACKGROUND_STANDARD = 64,       /* "BACKGROUND-STANDARD"  */
  YYSYMBOL_BACKWARD = 65,                  /* BACKWARD  */
  YYSYMBOL_BAR = 66,                       /* BAR  */
  YYSYMBOL_BASED = 67,                     /* BASED  */
  YYSYMBOL_BEFORE = 68,                    /* BEFORE  */
  YYSYMBOL_BELL = 69,                      /* BELL  */
  YYSYMBOL_BINARY = 70,                    /* BINARY  */
  YYSYMBOL_BINARY_C_LONG = 71,             /* "BINARY-C-LONG"  */
  YYSYMBOL_BINARY_CHAR = 72,               /* "BINARY-CHAR"  */
  YYSYMBOL_BINARY_DOUBLE = 73,             /* "BINARY-DOUBLE"  */
  YYSYMBOL_BINARY_LONG = 74,               /* "BINARY-LONG"  */
  YYSYMBOL_BINARY_SEQUENTIAL = 75,         /* "BINARY-SEQUENTIAL"  */
  YYSYMBOL_BINARY_SHORT = 76,              /* "BINARY-SHORT"  */
  YYSYMBOL_BIT = 77,                       /* BIT  */
  YYSYMBOL_BITMAP = 78,                    /* BITMAP  */
  YYSYMBOL_BITMAP_END = 79,                /* "BITMAP-END"  */
  YYSYMBOL_BITMAP_HANDLE = 80,             /* "BITMAP-HANDLE"  */
  YYSYMBOL_BITMAP_NUMBER = 81,             /* "BITMAP-NUMBER"  */
  YYSYMBOL_BITMAP_START = 82,              /* "BITMAP-START"  */
  YYSYMBOL_BITMAP_TIMER = 83,              /* "BITMAP-TIMER"  */
  YYSYMBOL_BITMAP_TRAILING = 84,           /* "BITMAP-TRAILING"  */
  YYSYMBOL_BITMAP_TRANSPARENT_COLOR = 85,  /* "BITMAP-TRANSPARENT-COLOR"  */
  YYSYMBOL_BITMAP_WIDTH = 86,              /* "BITMAP-WIDTH"  */
  YYSYMBOL_BLANK = 87,                     /* BLANK  */
  YYSYMBOL_BLINK = 88,                     /* BLINK  */
  YYSYMBOL_BLOCK = 89,                     /* BLOCK  */
  YYSYMBOL_BOOLEAN = 90,                   /* BOOLEAN  */
  YYSYMBOL_BOTTOM = 91,                    /* BOTTOM  */
  YYSYMBOL_BOX = 92,                       /* BOX  */
  YYSYMBOL_BOXED = 93,                     /* BOXED  */
  YYSYMBOL_BULK_ADDITION = 94,             /* "BULK-ADDITION"  */
  YYSYMBOL_BUSY = 95,                      /* BUSY  */
  YYSYMBOL_BUTTONS = 96,                   /* BUTTONS  */
  YYSYMBOL_BY = 97,                        /* BY  */
  YYSYMBOL_BYTE_LENGTH = 98,               /* "BYTE-LENGTH"  */
  YYSYMBOL_C = 99,                         /* C  */
  YYSYMBOL_CALENDAR_FONT = 100,            /* "CALENDAR-FONT"  */
  YYSYMBOL_CALL = 101,                     /* CALL  */
  YYSYMBOL_CANCEL = 102,                   /* CANCEL  */
  YYSYMBOL_CANCEL_BUTTON = 103,            /* "CANCEL-BUTTON"  */
  YYSYMBOL_CAPACITY = 104,                 /* CAPACITY  */
  YYSYMBOL_CARD_PUNCH = 105,               /* "CARD-PUNCH"  */
  YYSYMBOL_CARD_READER = 106,              /* "CARD-READER"  */
  YYSYMBOL_CASSETTE = 107,                 /* CASSETTE  */
  YYSYMBOL_CCOL = 108,                     /* CCOL  */
  YYSYMBOL_CD = 109,                       /* CD  */
  YYSYMBOL_CELL = 110,                     /* CELL  */
  YYSYMBOL_CELL_COLOR = 111,               /* "CELL-COLOR"  */
  YYSYMBOL_CELL_DATA = 112,                /* "CELL-DATA"  */
  YYSYMBOL_CELL_FONT = 113,                /* "CELL-FONT"  */
  YYSYMBOL_CELL_PROTECTION = 114,          /* "CELL-PROTECTION"  */
  YYSYMBOL_CENTER = 115,                   /* CENTER  */
  YYSYMBOL_CENTERED = 116,                 /* CENTERED  */
  YYSYMBOL_CENTERED_HEADINGS = 117,        /* "CENTERED-HEADINGS"  */
  YYSYMBOL_CENTURY_DATE = 118,             /* "CENTURY-DATE"  */
  YYSYMBOL_CF = 119,                       /* CF  */
  YYSYMBOL_CH = 120,                       /* CH  */
  YYSYMBOL_CHAINING = 121,                 /* CHAINING  */
  YYSYMBOL_CHANGED = 122,                  /* CHANGED  */
  YYSYMBOL_CHARACTER = 123,                /* CHARACTER  */
  YYSYMBOL_CHARACTERS = 124,               /* CHARACTERS  */
  YYSYMBOL_CHECK_BOX = 125,                /* "CHECK-BOX"  */
  YYSYMBOL_CLASS = 126,                    /* CLASS  */
  YYSYMBOL_CLASSIFICATION = 127,           /* CLASSIFICATION  */
  YYSYMBOL_CLASS_NAME = 128,               /* "class-name"  */
  YYSYMBOL_CLEAR_SELECTION = 129,          /* "CLEAR-SELECTION"  */
  YYSYMBOL_CLINE = 130,                    /* CLINE  */
  YYSYMBOL_CLINES = 131,                   /* CLINES  */
  YYSYMBOL_CLOSE = 132,                    /* CLOSE  */
  YYSYMBOL_COBOL = 133,                    /* COBOL  */
  YYSYMBOL_CODE = 134,                     /* CODE  */
  YYSYMBOL_CODE_SET = 135,                 /* "CODE-SET"  */
  YYSYMBOL_COLLATING = 136,                /* COLLATING  */
  YYSYMBOL_COL = 137,                      /* COL  */
  YYSYMBOL_COLOR = 138,                    /* COLOR  */
  YYSYMBOL_COLORS = 139,                   /* COLORS  */
  YYSYMBOL_COLS = 140,                     /* COLS  */
  YYSYMBOL_COLUMN = 141,                   /* COLUMN  */
  YYSYMBOL_COLUMN_COLOR = 142,             /* "COLUMN-COLOR"  */
  YYSYMBOL_COLUMN_DIVIDERS = 143,          /* "COLUMN-DIVIDERS"  */
  YYSYMBOL_COLUMN_FONT = 144,              /* "COLUMN-FONT"  */
  YYSYMBOL_COLUMN_HEADINGS = 145,          /* "COLUMN-HEADINGS"  */
  YYSYMBOL_COLUMN_PROTECTION = 146,        /* "COLUMN-PROTECTION"  */
  YYSYMBOL_COLUMNS = 147,                  /* COLUMNS  */
  YYSYMBOL_COMBO_BOX = 148,                /* "COMBO-BOX"  */
  YYSYMBOL_COMMA = 149,                    /* COMMA  */
  YYSYMBOL_COMMAND_LINE = 150,             /* "COMMAND-LINE"  */
  YYSYMBOL_COMMA_DELIM = 151,              /* "comma delimiter"  */
  YYSYMBOL_COMMIT = 152,                   /* COMMIT  */
  YYSYMBOL_COMMON = 153,                   /* COMMON  */
  YYSYMBOL_COMMUNICATION = 154,            /* COMMUNICATION  */
  YYSYMBOL_COMP = 155,                     /* COMP  */
  YYSYMBOL_COMPUTE = 156,                  /* COMPUTE  */
  YYSYMBOL_COMP_0 = 157,                   /* "COMP-0"  */
  YYSYMBOL_COMP_1 = 158,                   /* "COMP-1"  */
  YYSYMBOL_COMP_2 = 159,                   /* "COMP-2"  */
  YYSYMBOL_COMP_3 = 160,                   /* "COMP-3"  */
  YYSYMBOL_COMP_4 = 161,                   /* "COMP-4"  */
  YYSYMBOL_COMP_5 = 162,                   /* "COMP-5"  */
  YYSYMBOL_COMP_6 = 163,                   /* "COMP-6"  */
  YYSYMBOL_COMP_N = 164,                   /* "COMP-N"  */
  YYSYMBOL_COMP_X = 165,                   /* "COMP-X"  */
  YYSYMBOL_CONCATENATE_FUNC = 166,         /* "FUNCTION CONCATENATE"  */
  YYSYMBOL_CONDITION = 167,                /* CONDITION  */
  YYSYMBOL_CONFIGURATION = 168,            /* CONFIGURATION  */
  YYSYMBOL_CONSTANT = 169,                 /* CONSTANT  */
  YYSYMBOL_CONTAINS = 170,                 /* CONTAINS  */
  YYSYMBOL_CONTENT = 171,                  /* CONTENT  */
  YYSYMBOL_CONTENT_LENGTH_FUNC = 172,      /* "FUNCTION CONTENT-LENGTH"  */
  YYSYMBOL_CONTENT_OF_FUNC = 173,          /* "FUNCTION CONTENT-OF"  */
  YYSYMBOL_CONTINUE = 174,                 /* CONTINUE  */
  YYSYMBOL_CONTROL = 175,                  /* CONTROL  */
  YYSYMBOL_CONTROLS = 176,                 /* CONTROLS  */
  YYSYMBOL_CONVERSION = 177,               /* CONVERSION  */
  YYSYMBOL_CONVERTING = 178,               /* CONVERTING  */
  YYSYMBOL_COPY = 179,                     /* COPY  */
  YYSYMBOL_COPY_SELECTION = 180,           /* "COPY-SELECTION"  */
  YYSYMBOL_CORE_INDEX = 181,               /* "CORE-INDEX"  */
  YYSYMBOL_CORRESPONDING = 182,            /* CORRESPONDING  */
  YYSYMBOL_COUNT = 183,                    /* COUNT  */
  YYSYMBOL_CRT = 184,                      /* CRT  */
  YYSYMBOL_CRT_UNDER = 185,                /* "CRT-UNDER"  */
  YYSYMBOL_CSIZE = 186,                    /* CSIZE  */
  YYSYMBOL_CURRENCY = 187,                 /* CURRENCY  */
  YYSYMBOL_CURRENT_DATE_FUNC = 188,        /* "FUNCTION CURRENT-DATE"  */
  YYSYMBOL_CURSOR = 189,                   /* CURSOR  */
  YYSYMBOL_CURSOR_COL = 190,               /* "CURSOR-COL"  */
  YYSYMBOL_CURSOR_COLOR = 191,             /* "CURSOR-COLOR"  */
  YYSYMBOL_CURSOR_FRAME_WIDTH = 192,       /* "CURSOR-FRAME-WIDTH"  */
  YYSYMBOL_CURSOR_ROW = 193,               /* "CURSOR-ROW"  */
  YYSYMBOL_CURSOR_X = 194,                 /* "CURSOR-X"  */
  YYSYMBOL_CURSOR_Y = 195,                 /* "CURSOR-Y"  */
  YYSYMBOL_CUSTOM_PRINT_TEMPLATE = 196,    /* "CUSTOM-PRINT-TEMPLATE"  */
  YYSYMBOL_CYCLE = 197,                    /* CYCLE  */
  YYSYMBOL_CYL_INDEX = 198,                /* "CYL-INDEX"  */
  YYSYMBOL_CYL_OVERFLOW = 199,             /* "CYL-OVERFLOW"  */
  YYSYMBOL_DASHED = 200,                   /* DASHED  */
  YYSYMBOL_DATA = 201,                     /* DATA  */
  YYSYMBOL_DATA_COLUMNS = 202,             /* "DATA-COLUMNS"  */
  YYSYMBOL_DATA_TYPES = 203,               /* "DATA-TYPES"  */
  YYSYMBOL_DATE = 204,                     /* DATE  */
  YYSYMBOL_DATE_COMPILED = 205,            /* "DATE-COMPILED"  */
  YYSYMBOL_DATE_ENTRY = 206,               /* "DATE-ENTRY"  */
  YYSYMBOL_DATE_MODIFIED = 207,            /* "DATE-MODIFIED"  */
  YYSYMBOL_DATE_WRITTEN = 208,             /* "DATE-WRITTEN"  */
  YYSYMBOL_DAY = 209,                      /* DAY  */
  YYSYMBOL_DAY_OF_WEEK = 210,              /* "DAY-OF-WEEK"  */
  YYSYMBOL_DE = 211,                       /* DE  */
  YYSYMBOL_DEBUGGING = 212,                /* DEBUGGING  */
  YYSYMBOL_DECIMAL_POINT = 213,            /* "DECIMAL-POINT"  */
  YYSYMBOL_DECLARATIVES = 214,             /* DECLARATIVES  */
  YYSYMBOL_DEFAULT = 215,                  /* DEFAULT  */
  YYSYMBOL_DEFAULT_BUTTON = 216,           /* "DEFAULT-BUTTON"  */
  YYSYMBOL_DEFAULT_FONT = 217,             /* "DEFAULT-FONT"  */
  YYSYMBOL_DELETE = 218,                   /* DELETE  */
  YYSYMBOL_DELIMITED = 219,                /* DELIMITED  */
  YYSYMBOL_DELIMITER = 220,                /* DELIMITER  */
  YYSYMBOL_DEPENDING = 221,                /* DEPENDING  */
  YYSYMBOL_DESCENDING = 222,               /* DESCENDING  */
  YYSYMBOL_DESTINATION = 223,              /* DESTINATION  */
  YYSYMBOL_DESTROY = 224,                  /* DESTROY  */
  YYSYMBOL_DETAIL = 225,                   /* DETAIL  */
  YYSYMBOL_DISABLE = 226,                  /* DISABLE  */
  YYSYMBOL_DISC = 227,                     /* DISC  */
  YYSYMBOL_DISK = 228,                     /* DISK  */
  YYSYMBOL_DISP = 229,                     /* DISP  */
  YYSYMBOL_DISPLAY = 230,                  /* DISPLAY  */
  YYSYMBOL_DISPLAY_COLUMNS = 231,          /* "DISPLAY-COLUMNS"  */
  YYSYMBOL_DISPLAY_FORMAT = 232,           /* "DISPLAY-FORMAT"  */
  YYSYMBOL_DISPLAY_OF_FUNC = 233,          /* "FUNCTION DISPLAY-OF"  */
  YYSYMBOL_DIVIDE = 234,                   /* DIVIDE  */
  YYSYMBOL_DIVIDERS = 235,                 /* DIVIDERS  */
  YYSYMBOL_DIVIDER_COLOR = 236,            /* "DIVIDER-COLOR"  */
  YYSYMBOL_DIVISION = 237,                 /* DIVISION  */
  YYSYMBOL_DOTDASH = 238,                  /* DOTDASH  */
  YYSYMBOL_DOTTED = 239,                   /* DOTTED  */
  YYSYMBOL_DRAG_COLOR = 240,               /* "DRAG-COLOR"  */
  YYSYMBOL_DROP_DOWN = 241,                /* "DROP-DOWN"  */
  YYSYMBOL_DROP_LIST = 242,                /* "DROP-LIST"  */
  YYSYMBOL_DOWN = 243,                     /* DOWN  */
  YYSYMBOL_DUPLICATES = 244,               /* DUPLICATES  */
  YYSYMBOL_DYNAMIC = 245,                  /* DYNAMIC  */
  YYSYMBOL_EBCDIC = 246,                   /* EBCDIC  */
  YYSYMBOL_EC = 247,                       /* EC  */
  YYSYMBOL_ECHO = 248,                     /* ECHO  */
  YYSYMBOL_EGI = 249,                      /* EGI  */
  YYSYMBOL_EIGHTY_EIGHT = 250,             /* "level-number 88"  */
  YYSYMBOL_ENABLE = 251,                   /* ENABLE  */
  YYSYMBOL_ELEMENT = 252,                  /* ELEMENT  */
  YYSYMBOL_ELSE = 253,                     /* ELSE  */
  YYSYMBOL_EMI = 254,                      /* EMI  */
  YYSYMBOL_ENCRYPTION = 255,               /* ENCRYPTION  */
  YYSYMBOL_ENCODING = 256,                 /* ENCODING  */
  YYSYMBOL_END = 257,                      /* END  */
  YYSYMBOL_END_ACCEPT = 258,               /* "END-ACCEPT"  */
  YYSYMBOL_END_ADD = 259,                  /* "END-ADD"  */
  YYSYMBOL_END_CALL = 260,                 /* "END-CALL"  */
  YYSYMBOL_END_COMPUTE = 261,              /* "END-COMPUTE"  */
  YYSYMBOL_END_COLOR = 262,                /* "END-COLOR"  */
  YYSYMBOL_END_DELETE = 263,               /* "END-DELETE"  */
  YYSYMBOL_END_DISPLAY = 264,              /* "END-DISPLAY"  */
  YYSYMBOL_END_DIVIDE = 265,               /* "END-DIVIDE"  */
  YYSYMBOL_END_EVALUATE = 266,             /* "END-EVALUATE"  */
  YYSYMBOL_END_FUNCTION = 267,             /* "END FUNCTION"  */
  YYSYMBOL_END_IF = 268,                   /* "END-IF"  */
  YYSYMBOL_END_JSON = 269,                 /* "END-JSON"  */
  YYSYMBOL_END_MODIFY = 270,               /* "END-MODIFY"  */
  YYSYMBOL_END_MULTIPLY = 271,             /* "END-MULTIPLY"  */
  YYSYMBOL_END_PERFORM = 272,              /* "END-PERFORM"  */
  YYSYMBOL_END_PROGRAM = 273,              /* "END PROGRAM"  */
  YYSYMBOL_END_READ = 274,                 /* "END-READ"  */
  YYSYMBOL_END_RECEIVE = 275,              /* "END-RECEIVE"  */
  YYSYMBOL_END_RETURN = 276,               /* "END-RETURN"  */
  YYSYMBOL_END_REWRITE = 277,              /* "END-REWRITE"  */
  YYSYMBOL_END_SEARCH = 278,               /* "END-SEARCH"  */
  YYSYMBOL_END_SEND = 279,                 /* "END-SEND"  */
  YYSYMBOL_END_START = 280,                /* "END-START"  */
  YYSYMBOL_END_STRING = 281,               /* "END-STRING"  */
  YYSYMBOL_END_SUBTRACT = 282,             /* "END-SUBTRACT"  */
  YYSYMBOL_END_UNSTRING = 283,             /* "END-UNSTRING"  */
  YYSYMBOL_END_WRITE = 284,                /* "END-WRITE"  */
  YYSYMBOL_END_XML = 285,                  /* "END-XML"  */
  YYSYMBOL_ENGRAVED = 286,                 /* ENGRAVED  */
  YYSYMBOL_ENSURE_VISIBLE = 287,           /* "ENSURE-VISIBLE"  */
  YYSYMBOL_ENTRY = 288,                    /* ENTRY  */
  YYSYMBOL_ENTRY_CONVENTION = 289,         /* "ENTRY-CONVENTION"  */
  YYSYMBOL_ENTRY_FIELD = 290,              /* "ENTRY-FIELD"  */
  YYSYMBOL_ENTRY_REASON = 291,             /* "ENTRY-REASON"  */
  YYSYMBOL_ENVIRONMENT = 292,              /* ENVIRONMENT  */
  YYSYMBOL_ENVIRONMENT_NAME = 293,         /* "ENVIRONMENT-NAME"  */
  YYSYMBOL_ENVIRONMENT_VALUE = 294,        /* "ENVIRONMENT-VALUE"  */
  YYSYMBOL_EOL = 295,                      /* EOL  */
  YYSYMBOL_EOP = 296,                      /* EOP  */
  YYSYMBOL_EOS = 297,                      /* EOS  */
  YYSYMBOL_EQUAL = 298,                    /* EQUAL  */
  YYSYMBOL_ERASE = 299,                    /* ERASE  */
  YYSYMBOL_ERROR = 300,                    /* ERROR  */
  YYSYMBOL_ESCAPE = 301,                   /* ESCAPE  */
  YYSYMBOL_ESCAPE_BUTTON = 302,            /* "ESCAPE-BUTTON"  */
  YYSYMBOL_ESI = 303,                      /* ESI  */
  YYSYMBOL_EVALUATE = 304,                 /* EVALUATE  */
  YYSYMBOL_EVENT = 305,                    /* EVENT  */
  YYSYMBOL_EVENT_LIST = 306,               /* "EVENT-LIST"  */
  YYSYMBOL_EVENT_STATUS = 307,             /* "EVENT STATUS"  */
  YYSYMBOL_EVERY = 308,                    /* EVERY  */
  YYSYMBOL_EXAMINE = 309,                  /* EXAMINE  */
  YYSYMBOL_EXCEPTION = 310,                /* EXCEPTION  */
  YYSYMBOL_EXCEPTION_CONDITION = 311,      /* "EXCEPTION CONDITION"  */
  YYSYMBOL_EXCEPTION_VALUE = 312,          /* "EXCEPTION-VALUE"  */
  YYSYMBOL_EXPAND = 313,                   /* EXPAND  */
  YYSYMBOL_EXCLUSIVE = 314,                /* EXCLUSIVE  */
  YYSYMBOL_EXHIBIT = 315,                  /* EXHIBIT  */
  YYSYMBOL_EXIT = 316,                     /* EXIT  */
  YYSYMBOL_EXPONENTIATION = 317,           /* "exponentiation operator"  */
  YYSYMBOL_EXTEND = 318,                   /* EXTEND  */
  YYSYMBOL_EXTENDED_SEARCH = 319,          /* "EXTENDED-SEARCH"  */
  YYSYMBOL_EXTERNAL = 320,                 /* EXTERNAL  */
  YYSYMBOL_EXTERNAL_FORM = 321,            /* "EXTERNAL-FORM"  */
  YYSYMBOL_F = 322,                        /* F  */
  YYSYMBOL_FACTORY = 323,                  /* FACTORY  */
  YYSYMBOL_FD = 324,                       /* FD  */
  YYSYMBOL_FH__FCD = 325,                  /* "FH--FCD"  */
  YYSYMBOL_FH__KEYDEF = 326,               /* "FH--KEYDEF"  */
  YYSYMBOL_FILE_CONTROL = 327,             /* "FILE-CONTROL"  */
  YYSYMBOL_FILE_ID = 328,                  /* "FILE-ID"  */
  YYSYMBOL_FILE_LIMIT = 329,               /* "FILE-LIMIT"  */
  YYSYMBOL_FILE_LIMITS = 330,              /* "FILE-LIMITS"  */
  YYSYMBOL_FILE_NAME = 331,                /* "FILE-NAME"  */
  YYSYMBOL_FILE_POS = 332,                 /* "FILE-POS"  */
  YYSYMBOL_FILL_COLOR = 333,               /* "FILL-COLOR"  */
  YYSYMBOL_FILL_COLOR2 = 334,              /* "FILL-COLOR2"  */
  YYSYMBOL_FILL_PERCENT = 335,             /* "FILL-PERCENT"  */
  YYSYMBOL_FILLER = 336,                   /* FILLER  */
  YYSYMBOL_FINAL = 337,                    /* FINAL  */
  YYSYMBOL_FINISH_REASON = 338,            /* "FINISH-REASON"  */
  YYSYMBOL_FIRST = 339,                    /* FIRST  */
  YYSYMBOL_FIXED = 340,                    /* FIXED  */
  YYSYMBOL_FIXED_FONT = 341,               /* "FIXED-FONT"  */
  YYSYMBOL_FIXED_WIDTH = 342,              /* "FIXED-WIDTH"  */
  YYSYMBOL_FLAT = 343,                     /* FLAT  */
  YYSYMBOL_FLAT_BUTTONS = 344,             /* "FLAT-BUTTONS"  */
  YYSYMBOL_FLOAT_BINARY_128 = 345,         /* "FLOAT-BINARY-128"  */
  YYSYMBOL_FLOAT_BINARY_32 = 346,          /* "FLOAT-BINARY-32"  */
  YYSYMBOL_FLOAT_BINARY_64 = 347,          /* "FLOAT-BINARY-64"  */
  YYSYMBOL_FLOAT_DECIMAL_16 = 348,         /* "FLOAT-DECIMAL-16"  */
  YYSYMBOL_FLOAT_DECIMAL_34 = 349,         /* "FLOAT-DECIMAL-34"  */
  YYSYMBOL_FLOAT_DECIMAL_7 = 350,          /* "FLOAT-DECIMAL-7"  */
  YYSYMBOL_FLOAT_EXTENDED = 351,           /* "FLOAT-EXTENDED"  */
  YYSYMBOL_FLOAT_LONG = 352,               /* "FLOAT-LONG"  */
  YYSYMBOL_FLOAT_SHORT = 353,              /* "FLOAT-SHORT"  */
  YYSYMBOL_FLOATING = 354,                 /* FLOATING  */
  YYSYMBOL_FONT = 355,                     /* FONT  */
  YYSYMBOL_FOOTING = 356,                  /* FOOTING  */
  YYSYMBOL_FOR = 357,                      /* FOR  */
  YYSYMBOL_FOREGROUND_COLOR = 358,         /* "FOREGROUND-COLOR"  */
  YYSYMBOL_FOREVER = 359,                  /* FOREVER  */
  YYSYMBOL_FORMAT = 360,                   /* FORMAT  */
  YYSYMBOL_FORMATTED_DATE_FUNC = 361,      /* "FUNCTION FORMATTED-DATE"  */
  YYSYMBOL_FORMATTED_DATETIME_FUNC = 362,  /* "FUNCTION FORMATTED-DATETIME"  */
  YYSYMBOL_FORMATTED_TIME_FUNC = 363,      /* "FUNCTION FORMATTED-TIME"  */
  YYSYMBOL_FRAME = 364,                    /* FRAME  */
  YYSYMBOL_FRAMED = 365,                   /* FRAMED  */
  YYSYMBOL_FREE = 366,                     /* FREE  */
  YYSYMBOL_FROM = 367,                     /* FROM  */
  YYSYMBOL_FROM_CRT = 368,                 /* "FROM CRT"  */
  YYSYMBOL_FULL = 369,                     /* FULL  */
  YYSYMBOL_FULL_HEIGHT = 370,              /* "FULL-HEIGHT"  */
  YYSYMBOL_FUNCTION = 371,                 /* FUNCTION  */
  YYSYMBOL_FUNCTION_ID = 372,              /* "FUNCTION-ID"  */
  YYSYMBOL_FUNCTION_NAME = 373,            /* "intrinsic function name"  */
  YYSYMBOL_GENERATE = 374,                 /* GENERATE  */
  YYSYMBOL_GIVING = 375,                   /* GIVING  */
  YYSYMBOL_GLOBAL = 376,                   /* GLOBAL  */
  YYSYMBOL_GO = 377,                       /* GO  */
  YYSYMBOL_GO_BACK = 378,                  /* "GO-BACK"  */
  YYSYMBOL_GO_FORWARD = 379,               /* "GO-FORWARD"  */
  YYSYMBOL_GO_HOME = 380,                  /* "GO-HOME"  */
  YYSYMBOL_GO_SEARCH = 381,                /* "GO-SEARCH"  */
  YYSYMBOL_GOBACK = 382,                   /* GOBACK  */
  YYSYMBOL_GRAPHICAL = 383,                /* GRAPHICAL  */
  YYSYMBOL_GREATER = 384,                  /* GREATER  */
  YYSYMBOL_GREATER_OR_EQUAL = 385,         /* "GREATER OR EQUAL"  */
  YYSYMBOL_GRID = 386,                     /* GRID  */
  YYSYMBOL_GROUP = 387,                    /* GROUP  */
  YYSYMBOL_GROUP_VALUE = 388,              /* "GROUP-VALUE"  */
  YYSYMBOL_HANDLE = 389,                   /* HANDLE  */
  YYSYMBOL_HAS_CHILDREN = 390,             /* "HAS-CHILDREN"  */
  YYSYMBOL_HEADING = 391,                  /* HEADING  */
  YYSYMBOL_HEADING_COLOR = 392,            /* "HEADING-COLOR"  */
  YYSYMBOL_HEADING_DIVIDER_COLOR = 393,    /* "HEADING-DIVIDER-COLOR"  */
  YYSYMBOL_HEADING_FONT = 394,             /* "HEADING-FONT"  */
  YYSYMBOL_HEAVY = 395,                    /* HEAVY  */
  YYSYMBOL_HEIGHT_IN_CELLS = 396,          /* "HEIGHT-IN-CELLS"  */
  YYSYMBOL_HIDDEN_DATA = 397,              /* "HIDDEN-DATA"  */
  YYSYMBOL_HIGHLIGHT = 398,                /* HIGHLIGHT  */
  YYSYMBOL_HIGH_COLOR = 399,               /* "HIGH-COLOR"  */
  YYSYMBOL_HIGH_VALUE = 400,               /* "HIGH-VALUE"  */
  YYSYMBOL_HOT_TRACK = 401,                /* "HOT-TRACK"  */
  YYSYMBOL_HSCROLL = 402,                  /* HSCROLL  */
  YYSYMBOL_HSCROLL_POS = 403,              /* "HSCROLL-POS"  */
  YYSYMBOL_ICON = 404,                     /* ICON  */
  YYSYMBOL_ID = 405,                       /* ID  */
  YYSYMBOL_IDENTIFIED = 406,               /* IDENTIFIED  */
  YYSYMBOL_IDENTIFICATION = 407,           /* IDENTIFICATION  */
  YYSYMBOL_IF = 408,                       /* IF  */
  YYSYMBOL_IGNORE = 409,                   /* IGNORE  */
  YYSYMBOL_IGNORING = 410,                 /* IGNORING  */
  YYSYMBOL_IN = 411,                       /* IN  */
  YYSYMBOL_INDEPENDENT = 412,              /* INDEPENDENT  */
  YYSYMBOL_INDEX = 413,                    /* INDEX  */
  YYSYMBOL_INDEXED = 414,                  /* INDEXED  */
  YYSYMBOL_INDICATE = 415,                 /* INDICATE  */
  YYSYMBOL_INITIALIZE = 416,               /* INITIALIZE  */
  YYSYMBOL_INITIALIZED = 417,              /* INITIALIZED  */
  YYSYMBOL_INITIATE = 418,                 /* INITIATE  */
  YYSYMBOL_INPUT = 419,                    /* INPUT  */
  YYSYMBOL_INPUT_OUTPUT = 420,             /* "INPUT-OUTPUT"  */
  YYSYMBOL_INQUIRE = 421,                  /* INQUIRE  */
  YYSYMBOL_INSERTION_INDEX = 422,          /* "INSERTION-INDEX"  */
  YYSYMBOL_INSERT_ROWS = 423,              /* "INSERT-ROWS"  */
  YYSYMBOL_INSPECT = 424,                  /* INSPECT  */
  YYSYMBOL_INSTALLATION = 425,             /* INSTALLATION  */
  YYSYMBOL_INTERMEDIATE = 426,             /* INTERMEDIATE  */
  YYSYMBOL_INTO = 427,                     /* INTO  */
  YYSYMBOL_INTRINSIC = 428,                /* INTRINSIC  */
  YYSYMBOL_INVALID = 429,                  /* INVALID  */
  YYSYMBOL_INVALID_KEY = 430,              /* "INVALID KEY"  */
  YYSYMBOL_IS = 431,                       /* IS  */
  YYSYMBOL_ITEM = 432,                     /* ITEM  */
  YYSYMBOL_ITEM_TEXT = 433,                /* "ITEM-TEXT"  */
  YYSYMBOL_ITEM_TO_ADD = 434,              /* "ITEM-TO_ADD"  */
  YYSYMBOL_ITEM_TO_DELETE = 435,           /* "ITEM-TO_DELETE"  */
  YYSYMBOL_ITEM_TO_EMPTY = 436,            /* "ITEM-TO_EMPTY"  */
  YYSYMBOL_ITEM_VALUE = 437,               /* "ITEM-VALUE"  */
  YYSYMBOL_I_O = 438,                      /* "I-O"  */
  YYSYMBOL_I_O_CONTROL = 439,              /* "I-O-CONTROL"  */
  YYSYMBOL_JSON = 440,                     /* JSON  */
  YYSYMBOL_JUSTIFIED = 441,                /* JUSTIFIED  */
  YYSYMBOL_KEPT = 442,                     /* KEPT  */
  YYSYMBOL_KEY = 443,                      /* KEY  */
  YYSYMBOL_KEYBOARD = 444,                 /* KEYBOARD  */
  YYSYMBOL_LABEL = 445,                    /* LABEL  */
  YYSYMBOL_LABEL_OFFSET = 446,             /* "LABEL-OFFSET"  */
  YYSYMBOL_LARGE_FONT = 447,               /* "LARGE-FONT"  */
  YYSYMBOL_LARGE_OFFSET = 448,             /* "LARGE-OFFSET"  */
  YYSYMBOL_LAST = 449,                     /* LAST  */
  YYSYMBOL_LAST_ROW = 450,                 /* "LAST-ROW"  */
  YYSYMBOL_LAYOUT_DATA = 451,              /* "LAYOUT-DATA"  */
  YYSYMBOL_LAYOUT_MANAGER = 452,           /* "LAYOUT-MANAGER"  */
  YYSYMBOL_LEADING = 453,                  /* LEADING  */
  YYSYMBOL_LEADING_SHIFT = 454,            /* "LEADING-SHIFT"  */
  YYSYMBOL_LEAVE = 455,                    /* LEAVE  */
  YYSYMBOL_LEFT = 456,                     /* LEFT  */
  YYSYMBOL_LEFTLINE = 457,                 /* LEFTLINE  */
  YYSYMBOL_LEFT_TEXT = 458,                /* "LEFT-TEXT"  */
  YYSYMBOL_LENGTH = 459,                   /* LENGTH  */
  YYSYMBOL_LENGTH_OF = 460,                /* "LENGTH OF"  */
  YYSYMBOL_LENGTH_FUNC = 461,              /* "FUNCTION LENGTH/BYTE-LENGTH"  */
  YYSYMBOL_LESS = 462,                     /* LESS  */
  YYSYMBOL_LESS_OR_EQUAL = 463,            /* "LESS OR EQUAL"  */
  YYSYMBOL_LEVEL_NUMBER = 464,             /* "level-number"  */
  YYSYMBOL_LIKE = 465,                     /* LIKE  */
  YYSYMBOL_LIMIT = 466,                    /* LIMIT  */
  YYSYMBOL_LIMITS = 467,                   /* LIMITS  */
  YYSYMBOL_LINAGE = 468,                   /* LINAGE  */
  YYSYMBOL_LINAGE_COUNTER = 469,           /* "LINAGE-COUNTER"  */
  YYSYMBOL_LINE = 470,                     /* LINE  */
  YYSYMBOL_LINE_COUNTER = 471,             /* "LINE-COUNTER"  */
  YYSYMBOL_LINE_LIMIT = 472,               /* "LINE LIMIT"  */
  YYSYMBOL_LINE_SEQUENTIAL = 473,          /* "LINE-SEQUENTIAL"  */
  YYSYMBOL_LINES = 474,                    /* LINES  */
  YYSYMBOL_LINES_AT_ROOT = 475,            /* "LINES-AT-ROOT"  */
  YYSYMBOL_LINKAGE = 476,                  /* LINKAGE  */
  YYSYMBOL_LIST_BOX = 477,                 /* "LIST-BOX"  */
  YYSYMBOL_LITERAL = 478,                  /* "Literal"  */
  YYSYMBOL_LM_RESIZE = 479,                /* "LM-RESIZE"  */
  YYSYMBOL_LOC = 480,                      /* LOC  */
  YYSYMBOL_LOCALE = 481,                   /* LOCALE  */
  YYSYMBOL_LOCALE_DATE_FUNC = 482,         /* "FUNCTION LOCALE-DATE"  */
  YYSYMBOL_LOCALE_TIME_FUNC = 483,         /* "FUNCTION LOCALE-TIME"  */
  YYSYMBOL_LOCALE_TIME_FROM_FUNC = 484,    /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
  YYSYMBOL_LOCAL_STORAGE = 485,            /* "LOCAL-STORAGE"  */
  YYSYMBOL_LOCK = 486,                     /* LOCK  */
  YYSYMBOL_LOCK_HOLDING = 487,             /* "LOCK-HOLDING"  */
  YYSYMBOL_LONG_DATE = 488,                /* "LONG-DATE"  */
  YYSYMBOL_LOWER = 489,                    /* LOWER  */
  YYSYMBOL_LOWERED = 490,                  /* LOWERED  */
  YYSYMBOL_LOWER_CASE_FUNC = 491,          /* "FUNCTION LOWER-CASE"  */
  YYSYMBOL_LOWLIGHT = 492,                 /* LOWLIGHT  */
  YYSYMBOL_LOW_COLOR = 493,                /* "LOW-COLOR"  */
  YYSYMBOL_LOW_VALUE = 494,                /* "LOW-VALUE"  */
  YYSYMBOL_MAGNETIC_TAPE = 495,            /* "MAGNETIC-TAPE"  */
  YYSYMBOL_MANUAL = 496,                   /* MANUAL  */
  YYSYMBOL_MASS_UPDATE = 497,              /* "MASS-UPDATE"  */
  YYSYMBOL_MASTER_INDEX = 498,             /* "MASTER-INDEX"  */
  YYSYMBOL_MAX_LINES = 499,                /* "MAX-LINES"  */
  YYSYMBOL_MAX_PROGRESS = 500,             /* "MAX-PROGRESS"  */
  YYSYMBOL_MAX_TEXT = 501,                 /* "MAX-TEXT"  */
  YYSYMBOL_MAX_VAL = 502,                  /* "MAX-VAL"  */
  YYSYMBOL_MEMORY = 503,                   /* MEMORY  */
  YYSYMBOL_MEDIUM_FONT = 504,              /* "MEDIUM-FONT"  */
  YYSYMBOL_MENU = 505,                     /* MENU  */
  YYSYMBOL_MERGE = 506,                    /* MERGE  */
  YYSYMBOL_MESSAGE = 507,                  /* MESSAGE  */
  YYSYMBOL_MINUS = 508,                    /* MINUS  */
  YYSYMBOL_MIN_VAL = 509,                  /* "MIN-VAL"  */
  YYSYMBOL_MNEMONIC_NAME = 510,            /* "Mnemonic name"  */
  YYSYMBOL_MODE = 511,                     /* MODE  */
  YYSYMBOL_MODIFY = 512,                   /* MODIFY  */
  YYSYMBOL_MODULES = 513,                  /* MODULES  */
  YYSYMBOL_MOVE = 514,                     /* MOVE  */
  YYSYMBOL_MULTILINE = 515,                /* MULTILINE  */
  YYSYMBOL_MULTIPLE = 516,                 /* MULTIPLE  */
  YYSYMBOL_MULTIPLY = 517,                 /* MULTIPLY  */
  YYSYMBOL_NAME = 518,                     /* NAME  */
  YYSYMBOL_NAMED = 519,                    /* NAMED  */
  YYSYMBOL_NAMESPACE = 520,                /* NAMESPACE  */
  YYSYMBOL_NAMESPACE_PREFIX = 521,         /* "NAMESPACE-PREFIX"  */
  YYSYMBOL_NATIONAL = 522,                 /* NATIONAL  */
  YYSYMBOL_NATIONAL_EDITED = 523,          /* "NATIONAL-EDITED"  */
  YYSYMBOL_NATIONAL_OF_FUNC = 524,         /* "FUNCTION NATIONAL-OF"  */
  YYSYMBOL_NATIVE = 525,                   /* NATIVE  */
  YYSYMBOL_NAVIGATE_URL = 526,             /* "NAVIGATE-URL"  */
  YYSYMBOL_NEAREST_AWAY_FROM_ZERO = 527,   /* "NEAREST-AWAY-FROM-ZERO"  */
  YYSYMBOL_NEAREST_EVEN = 528,             /* "NEAREST-EVEN"  */
  YYSYMBOL_NEAREST_TOWARD_ZERO = 529,      /* "NEAREST-TOWARD-ZERO"  */
  YYSYMBOL_NEGATIVE = 530,                 /* NEGATIVE  */
  YYSYMBOL_NESTED = 531,                   /* NESTED  */
  YYSYMBOL_NEW = 532,                      /* NEW  */
  YYSYMBOL_NEXT = 533,                     /* NEXT  */
  YYSYMBOL_NEXT_ITEM = 534,                /* "NEXT-ITEM"  */
  YYSYMBOL_NEXT_GROUP = 535,               /* "NEXT GROUP"  */
  YYSYMBOL_NEXT_PAGE = 536,                /* "NEXT PAGE"  */
  YYSYMBOL_NO = 537,                       /* NO  */
  YYSYMBOL_NO_ADVANCING = 538,             /* "NO ADVANCING"  */
  YYSYMBOL_NO_AUTOSEL = 539,               /* "NO-AUTOSEL"  */
  YYSYMBOL_NO_AUTO_DEFAULT = 540,          /* "NO-AUTO-DEFAULT"  */
  YYSYMBOL_NO_BOX = 541,                   /* "NO-BOX"  */
  YYSYMBOL_NO_DATA = 542,                  /* "NO DATA"  */
  YYSYMBOL_NO_DIVIDERS = 543,              /* "NO-DIVIDERS"  */
  YYSYMBOL_NO_ECHO = 544,                  /* "NO-ECHO"  */
  YYSYMBOL_NO_F4 = 545,                    /* "NO-F4"  */
  YYSYMBOL_NO_FOCUS = 546,                 /* "NO-FOCUS"  */
  YYSYMBOL_NO_GROUP_TAB = 547,             /* "NO-GROUP-TAB"  */
  YYSYMBOL_NO_KEY_LETTER = 548,            /* "NO-KEY-LETTER"  */
  YYSYMBOL_NO_SEARCH = 549,                /* "NO-SEARCH"  */
  YYSYMBOL_NO_UPDOWN = 550,                /* "NO-UPDOWN"  */
  YYSYMBOL_NOMINAL = 551,                  /* NOMINAL  */
  YYSYMBOL_NONE = 552,                     /* NONE  */
  YYSYMBOL_NONNUMERIC = 553,               /* NONNUMERIC  */
  YYSYMBOL_NORMAL = 554,                   /* NORMAL  */
  YYSYMBOL_NOT = 555,                      /* NOT  */
  YYSYMBOL_NOTAB = 556,                    /* NOTAB  */
  YYSYMBOL_NOTHING = 557,                  /* NOTHING  */
  YYSYMBOL_NOTIFY = 558,                   /* NOTIFY  */
  YYSYMBOL_NOTIFY_CHANGE = 559,            /* "NOTIFY-CHANGE"  */
  YYSYMBOL_NOTIFY_DBLCLICK = 560,          /* "NOTIFY-DBLCLICK"  */
  YYSYMBOL_NOTIFY_SELCHANGE = 561,         /* "NOTIFY-SELCHANGE"  */
  YYSYMBOL_NOT_AT_END = 562,               /* "NOT AT END"  */
  YYSYMBOL_NOT_EOP = 563,                  /* "NOT AT EOP"  */
  YYSYMBOL_NOT_ON_ESCAPE = 564,            /* "NOT ON ESCAPE"  */
  YYSYMBOL_NOT_EQUAL = 565,                /* "NOT EQUAL"  */
  YYSYMBOL_NOT_ON_EXCEPTION = 566,         /* "NOT ON EXCEPTION"  */
  YYSYMBOL_NOT_INVALID_KEY = 567,          /* "NOT INVALID KEY"  */
  YYSYMBOL_NOT_ON_OVERFLOW = 568,          /* "NOT ON OVERFLOW"  */
  YYSYMBOL_NOT_SIZE_ERROR = 569,           /* "NOT SIZE ERROR"  */
  YYSYMBOL_NUM_COL_HEADINGS = 570,         /* "NUM-COL-HEADINGS"  */
  YYSYMBOL_NUM_ROWS = 571,                 /* "NUM-ROWS"  */
  YYSYMBOL_NUMBER = 572,                   /* NUMBER  */
  YYSYMBOL_NUMBERS = 573,                  /* NUMBERS  */
  YYSYMBOL_NUMERIC = 574,                  /* NUMERIC  */
  YYSYMBOL_NUMERIC_EDITED = 575,           /* "NUMERIC-EDITED"  */
  YYSYMBOL_NUMVALC_FUNC = 576,             /* "FUNCTION NUMVAL-C"  */
  YYSYMBOL_OBJECT = 577,                   /* OBJECT  */
  YYSYMBOL_OBJECT_COMPUTER = 578,          /* "OBJECT-COMPUTER"  */
  YYSYMBOL_OCCURS = 579,                   /* OCCURS  */
  YYSYMBOL_OF = 580,                       /* OF  */
  YYSYMBOL_OFF = 581,                      /* OFF  */
  YYSYMBOL_OK_BUTTON = 582,                /* "OK-BUTTON"  */
  YYSYMBOL_OMITTED = 583,                  /* OMITTED  */
  YYSYMBOL_ON = 584,                       /* ON  */
  YYSYMBOL_ONLY = 585,                     /* ONLY  */
  YYSYMBOL_ON_ESCAPE = 586,                /* "ON ESCAPE"  */
  YYSYMBOL_ON_EXCEPTION = 587,             /* "ON EXCEPTION"  */
  YYSYMBOL_OPEN = 588,                     /* OPEN  */
  YYSYMBOL_OPTIONAL = 589,                 /* OPTIONAL  */
  YYSYMBOL_OPTIONS = 590,                  /* OPTIONS  */
  YYSYMBOL_OR = 591,                       /* OR  */
  YYSYMBOL_ORDER = 592,                    /* ORDER  */
  YYSYMBOL_ORGANIZATION = 593,             /* ORGANIZATION  */
  YYSYMBOL_OTHER = 594,                    /* OTHER  */
  YYSYMBOL_OTHERS = 595,                   /* OTHERS  */
  YYSYMBOL_OUTPUT = 596,                   /* OUTPUT  */
  YYSYMBOL_OVERLAP_LEFT = 597,             /* "OVERLAP-LEFT"  */
  YYSYMBOL_OVERLAP_TOP = 598,              /* "OVERLAP-TOP"  */
  YYSYMBOL_OVERLINE = 599,                 /* OVERLINE  */
  YYSYMBOL_PACKED_DECIMAL = 600,           /* "PACKED-DECIMAL"  */
  YYSYMBOL_PADDING = 601,                  /* PADDING  */
  YYSYMBOL_PASCAL = 602,                   /* PASCAL  */
  YYSYMBOL_PAGE = 603,                     /* PAGE  */
  YYSYMBOL_PAGE_COUNTER = 604,             /* "PAGE-COUNTER"  */
  YYSYMBOL_PAGE_SETUP = 605,               /* "PAGE-SETUP"  */
  YYSYMBOL_PAGED = 606,                    /* PAGED  */
  YYSYMBOL_PARAGRAPH = 607,                /* PARAGRAPH  */
  YYSYMBOL_PARENT = 608,                   /* PARENT  */
  YYSYMBOL_PARSE = 609,                    /* PARSE  */
  YYSYMBOL_PASSWORD = 610,                 /* PASSWORD  */
  YYSYMBOL_PERFORM = 611,                  /* PERFORM  */
  YYSYMBOL_PERMANENT = 612,                /* PERMANENT  */
  YYSYMBOL_PH = 613,                       /* PH  */
  YYSYMBOL_PF = 614,                       /* PF  */
  YYSYMBOL_PHYSICAL = 615,                 /* PHYSICAL  */
  YYSYMBOL_PICTURE = 616,                  /* PICTURE  */
  YYSYMBOL_PICTURE_SYMBOL = 617,           /* "PICTURE SYMBOL"  */
  YYSYMBOL_PIXEL = 618,                    /* PIXEL  */
  YYSYMBOL_PLACEMENT = 619,                /* PLACEMENT  */
  YYSYMBOL_PLUS = 620,                     /* PLUS  */
  YYSYMBOL_POINTER = 621,                  /* POINTER  */
  YYSYMBOL_POP_UP = 622,                   /* "POP-UP"  */
  YYSYMBOL_POS = 623,                      /* POS  */
  YYSYMBOL_POSITION = 624,                 /* POSITION  */
  YYSYMBOL_POSITION_SHIFT = 625,           /* "POSITION-SHIFT"  */
  YYSYMBOL_POSITIVE = 626,                 /* POSITIVE  */
  YYSYMBOL_PRESENT = 627,                  /* PRESENT  */
  YYSYMBOL_PREVIOUS = 628,                 /* PREVIOUS  */
  YYSYMBOL_PRINT = 629,                    /* PRINT  */
  YYSYMBOL_PRINT_CONTROL = 630,            /* "PRINT-CONTROL"  */
  YYSYMBOL_PRINT_NO_PROMPT = 631,          /* "PRINT-NO-PROMPT"  */
  YYSYMBOL_PRINT_PREVIEW = 632,            /* "PRINT-PREVIEW"  */
  YYSYMBOL_PRINTER = 633,                  /* PRINTER  */
  YYSYMBOL_PRINTER_1 = 634,                /* "PRINTER-1"  */
  YYSYMBOL_PRINTING = 635,                 /* PRINTING  */
  YYSYMBOL_PRIORITY = 636,                 /* PRIORITY  */
  YYSYMBOL_PROCEDURE = 637,                /* PROCEDURE  */
  YYSYMBOL_PROCEDURES = 638,               /* PROCEDURES  */
  YYSYMBOL_PROCEED = 639,                  /* PROCEED  */
  YYSYMBOL_PROCESSING = 640,               /* PROCESSING  */
  YYSYMBOL_PROGRAM = 641,                  /* PROGRAM  */
  YYSYMBOL_PROGRAM_ID = 642,               /* "PROGRAM-ID"  */
  YYSYMBOL_PROGRAM_NAME = 643,             /* "program name"  */
  YYSYMBOL_PROGRAM_POINTER = 644,          /* "PROGRAM-POINTER"  */
  YYSYMBOL_PROGRESS = 645,                 /* PROGRESS  */
  YYSYMBOL_PROHIBITED = 646,               /* PROHIBITED  */
  YYSYMBOL_PROMPT = 647,                   /* PROMPT  */
  YYSYMBOL_PROPERTIES = 648,               /* PROPERTIES  */
  YYSYMBOL_PROPERTY = 649,                 /* PROPERTY  */
  YYSYMBOL_PROTECTED = 650,                /* PROTECTED  */
  YYSYMBOL_PROTOTYPE = 651,                /* PROTOTYPE  */
  YYSYMBOL_PURGE = 652,                    /* PURGE  */
  YYSYMBOL_PUSH_BUTTON = 653,              /* "PUSH-BUTTON"  */
  YYSYMBOL_QUERY_INDEX = 654,              /* "QUERY-INDEX"  */
  YYSYMBOL_QUEUE = 655,                    /* QUEUE  */
  YYSYMBOL_QUOTE = 656,                    /* QUOTE  */
  YYSYMBOL_RADIO_BUTTON = 657,             /* "RADIO-BUTTON"  */
  YYSYMBOL_RAISE = 658,                    /* RAISE  */
  YYSYMBOL_RAISED = 659,                   /* RAISED  */
  YYSYMBOL_RAISING = 660,                  /* RAISING  */
  YYSYMBOL_RANDOM = 661,                   /* RANDOM  */
  YYSYMBOL_RD = 662,                       /* RD  */
  YYSYMBOL_READ = 663,                     /* READ  */
  YYSYMBOL_READERS = 664,                  /* READERS  */
  YYSYMBOL_READ_ONLY = 665,                /* "READ-ONLY"  */
  YYSYMBOL_READY_TRACE = 666,              /* "READY TRACE"  */
  YYSYMBOL_RECEIVE = 667,                  /* RECEIVE  */
  YYSYMBOL_RECEIVED = 668,                 /* RECEIVED  */
  YYSYMBOL_RECORD = 669,                   /* RECORD  */
  YYSYMBOL_RECORD_DATA = 670,              /* "RECORD-DATA"  */
  YYSYMBOL_RECORD_OVERFLOW = 671,          /* "RECORD-OVERFLOW"  */
  YYSYMBOL_RECORD_TO_ADD = 672,            /* "RECORD-TO-ADD"  */
  YYSYMBOL_RECORD_TO_DELETE = 673,         /* "RECORD-TO-DELETE"  */
  YYSYMBOL_RECORDING = 674,                /* RECORDING  */
  YYSYMBOL_RECORDS = 675,                  /* RECORDS  */
  YYSYMBOL_RECURSIVE = 676,                /* RECURSIVE  */
  YYSYMBOL_REDEFINES = 677,                /* REDEFINES  */
  YYSYMBOL_REEL = 678,                     /* REEL  */
  YYSYMBOL_REFERENCE = 679,                /* REFERENCE  */
  YYSYMBOL_REFERENCES = 680,               /* REFERENCES  */
  YYSYMBOL_REFRESH = 681,                  /* REFRESH  */
  YYSYMBOL_REGION_COLOR = 682,             /* "REGION-COLOR"  */
  YYSYMBOL_RELATION = 683,                 /* RELATION  */
  YYSYMBOL_RELATIVE = 684,                 /* RELATIVE  */
  YYSYMBOL_RELEASE = 685,                  /* RELEASE  */
  YYSYMBOL_REMAINDER = 686,                /* REMAINDER  */
  YYSYMBOL_REMARKS = 687,                  /* REMARKS  */
  YYSYMBOL_REMOVAL = 688,                  /* REMOVAL  */
  YYSYMBOL_RENAMES = 689,                  /* RENAMES  */
  YYSYMBOL_REORG_CRITERIA = 690,           /* "REORG-CRITERIA"  */
  YYSYMBOL_REPEATED = 691,                 /* REPEATED  */
  YYSYMBOL_REPLACE = 692,                  /* REPLACE  */
  YYSYMBOL_REPLACING = 693,                /* REPLACING  */
  YYSYMBOL_REPORT = 694,                   /* REPORT  */
  YYSYMBOL_REPORTING = 695,                /* REPORTING  */
  YYSYMBOL_REPORTS = 696,                  /* REPORTS  */
  YYSYMBOL_REPOSITORY = 697,               /* REPOSITORY  */
  YYSYMBOL_REQUIRED = 698,                 /* REQUIRED  */
  YYSYMBOL_REREAD = 699,                   /* REREAD  */
  YYSYMBOL_RERUN = 700,                    /* RERUN  */
  YYSYMBOL_RESERVE = 701,                  /* RESERVE  */
  YYSYMBOL_RESET = 702,                    /* RESET  */
  YYSYMBOL_RESET_TRACE = 703,              /* "RESET TRACE"  */
  YYSYMBOL_RESET_GRID = 704,               /* "RESET-GRID"  */
  YYSYMBOL_RESET_LIST = 705,               /* "RESET-LIST"  */
  YYSYMBOL_RESET_TABS = 706,               /* "RESET-TABS"  */
  YYSYMBOL_RETRY = 707,                    /* RETRY  */
  YYSYMBOL_RETURN = 708,                   /* RETURN  */
  YYSYMBOL_RETURNING = 709,                /* RETURNING  */
  YYSYMBOL_REVERSE = 710,                  /* REVERSE  */
  YYSYMBOL_REVERSE_FUNC = 711,             /* "FUNCTION REVERSE"  */
  YYSYMBOL_REVERSE_VIDEO = 712,            /* "REVERSE-VIDEO"  */
  YYSYMBOL_REVERSED = 713,                 /* REVERSED  */
  YYSYMBOL_REWIND = 714,                   /* REWIND  */
  YYSYMBOL_REWRITE = 715,                  /* REWRITE  */
  YYSYMBOL_RF = 716,                       /* RF  */
  YYSYMBOL_RH = 717,                       /* RH  */
  YYSYMBOL_RIGHT = 718,                    /* RIGHT  */
  YYSYMBOL_RIGHT_ALIGN = 719,              /* "RIGHT-ALIGN"  */
  YYSYMBOL_RIMMED = 720,                   /* RIMMED  */
  YYSYMBOL_ROLLBACK = 721,                 /* ROLLBACK  */
  YYSYMBOL_ROUNDED = 722,                  /* ROUNDED  */
  YYSYMBOL_ROUNDING = 723,                 /* ROUNDING  */
  YYSYMBOL_ROW_COLOR = 724,                /* "ROW-COLOR"  */
  YYSYMBOL_ROW_COLOR_PATTERN = 725,        /* "ROW-COLOR-PATTERN"  */
  YYSYMBOL_ROW_DIVIDERS = 726,             /* "ROW-DIVIDERS"  */
  YYSYMBOL_ROW_FONT = 727,                 /* "ROW-FONT"  */
  YYSYMBOL_ROW_HEADINGS = 728,             /* "ROW-HEADINGS"  */
  YYSYMBOL_ROW_PROTECTION = 729,           /* "ROW-PROTECTION"  */
  YYSYMBOL_RUN = 730,                      /* RUN  */
  YYSYMBOL_S = 731,                        /* S  */
  YYSYMBOL_SAME = 732,                     /* SAME  */
  YYSYMBOL_SAVE_AS = 733,                  /* "SAVE-AS"  */
  YYSYMBOL_SAVE_AS_NO_PROMPT = 734,        /* "SAVE-AS-NO-PROMPT"  */
  YYSYMBOL_SCREEN = 735,                   /* SCREEN  */
  YYSYMBOL_SCREEN_CONTROL = 736,           /* "SCREEN CONTROL"  */
  YYSYMBOL_SCROLL = 737,                   /* SCROLL  */
  YYSYMBOL_SCROLL_BAR = 738,               /* "SCROLL-BAR"  */
  YYSYMBOL_SD = 739,                       /* SD  */
  YYSYMBOL_SEARCH = 740,                   /* SEARCH  */
  YYSYMBOL_SEARCH_OPTIONS = 741,           /* "SEARCH-OPTIONS"  */
  YYSYMBOL_SEARCH_TEXT = 742,              /* "SEARCH-TEXT"  */
  YYSYMBOL_SECONDS = 743,                  /* SECONDS  */
  YYSYMBOL_SECTION = 744,                  /* SECTION  */
  YYSYMBOL_SECURE = 745,                   /* SECURE  */
  YYSYMBOL_SECURITY = 746,                 /* SECURITY  */
  YYSYMBOL_SEGMENT = 747,                  /* SEGMENT  */
  YYSYMBOL_SEGMENT_LIMIT = 748,            /* "SEGMENT-LIMIT"  */
  YYSYMBOL_SELECT = 749,                   /* SELECT  */
  YYSYMBOL_SELECTION_INDEX = 750,          /* "SELECTION-INDEX"  */
  YYSYMBOL_SELECTION_TEXT = 751,           /* "SELECTION-TEXT"  */
  YYSYMBOL_SELECT_ALL = 752,               /* "SELECTION-ALL"  */
  YYSYMBOL_SELF_ACT = 753,                 /* "SELF-ACT"  */
  YYSYMBOL_SEMI_COLON = 754,               /* "semi-colon"  */
  YYSYMBOL_SEND = 755,                     /* SEND  */
  YYSYMBOL_SENTENCE = 756,                 /* SENTENCE  */
  YYSYMBOL_SEPARATE = 757,                 /* SEPARATE  */
  YYSYMBOL_SEPARATION = 758,               /* SEPARATION  */
  YYSYMBOL_SEQUENCE = 759,                 /* SEQUENCE  */
  YYSYMBOL_SEQUENTIAL = 760,               /* SEQUENTIAL  */
  YYSYMBOL_SET = 761,                      /* SET  */
  YYSYMBOL_SEVENTY_EIGHT = 762,            /* "level-number 78"  */
  YYSYMBOL_SHADING = 763,                  /* SHADING  */
  YYSYMBOL_SHADOW = 764,                   /* SHADOW  */
  YYSYMBOL_SHARING = 765,                  /* SHARING  */
  YYSYMBOL_SHORT_DATE = 766,               /* "SHORT-DATE"  */
  YYSYMBOL_SHOW_LINES = 767,               /* "SHOW-LINES"  */
  YYSYMBOL_SHOW_NONE = 768,                /* "SHOW-NONE"  */
  YYSYMBOL_SHOW_SEL_ALWAYS = 769,          /* "SHOW-SEL-ALWAYS"  */
  YYSYMBOL_SIGN = 770,                     /* SIGN  */
  YYSYMBOL_SIGNED = 771,                   /* SIGNED  */
  YYSYMBOL_SIGNED_INT = 772,               /* "SIGNED-INT"  */
  YYSYMBOL_SIGNED_LONG = 773,              /* "SIGNED-LONG"  */
  YYSYMBOL_SIGNED_SHORT = 774,             /* "SIGNED-SHORT"  */
  YYSYMBOL_SIXTY_SIX = 775,                /* "level-number 66"  */
  YYSYMBOL_SIZE = 776,                     /* SIZE  */
  YYSYMBOL_SIZE_ERROR = 777,               /* "SIZE ERROR"  */
  YYSYMBOL_SMALL_FONT = 778,               /* "SMALL-FONT"  */
  YYSYMBOL_SORT = 779,                     /* SORT  */
  YYSYMBOL_SORT_MERGE = 780,               /* "SORT-MERGE"  */
  YYSYMBOL_SORT_ORDER = 781,               /* "SORT-ORDER"  */
  YYSYMBOL_SOURCE = 782,                   /* SOURCE  */
  YYSYMBOL_SOURCE_COMPUTER = 783,          /* "SOURCE-COMPUTER"  */
  YYSYMBOL_SPACE = 784,                    /* SPACE  */
  YYSYMBOL_SPECIAL_NAMES = 785,            /* "SPECIAL-NAMES"  */
  YYSYMBOL_SPINNER = 786,                  /* SPINNER  */
  YYSYMBOL_SQUARE = 787,                   /* SQUARE  */
  YYSYMBOL_STANDARD = 788,                 /* STANDARD  */
  YYSYMBOL_STANDARD_1 = 789,               /* "STANDARD-1"  */
  YYSYMBOL_STANDARD_2 = 790,               /* "STANDARD-2"  */
  YYSYMBOL_STANDARD_BINARY = 791,          /* "STANDARD-BINARY"  */
  YYSYMBOL_STANDARD_DECIMAL = 792,         /* "STANDARD-DECIMAL"  */
  YYSYMBOL_START = 793,                    /* START  */
  YYSYMBOL_START_X = 794,                  /* "START-X"  */
  YYSYMBOL_START_Y = 795,                  /* "START-Y"  */
  YYSYMBOL_STATIC = 796,                   /* STATIC  */
  YYSYMBOL_STATIC_LIST = 797,              /* "STATIC-LIST"  */
  YYSYMBOL_STATUS = 798,                   /* STATUS  */
  YYSYMBOL_STATUS_BAR = 799,               /* "STATUS-BAR"  */
  YYSYMBOL_STATUS_TEXT = 800,              /* "STATUS-TEXT"  */
  YYSYMBOL_STDCALL = 801,                  /* STDCALL  */
  YYSYMBOL_STEP = 802,                     /* STEP  */
  YYSYMBOL_STOP = 803,                     /* STOP  */
  YYSYMBOL_STRING = 804,                   /* STRING  */
  YYSYMBOL_STRONG = 805,                   /* STRONG  */
  YYSYMBOL_STYLE = 806,                    /* STYLE  */
  YYSYMBOL_SUB_QUEUE_1 = 807,              /* "SUB-QUEUE-1"  */
  YYSYMBOL_SUB_QUEUE_2 = 808,              /* "SUB-QUEUE-2"  */
  YYSYMBOL_SUB_QUEUE_3 = 809,              /* "SUB-QUEUE-3"  */
  YYSYMBOL_SUBSTITUTE_FUNC = 810,          /* "FUNCTION SUBSTITUTE"  */
  YYSYMBOL_SUBSTITUTE_CASE_FUNC = 811,     /* "FUNCTION SUBSTITUTE-CASE"  */
  YYSYMBOL_SUBTRACT = 812,                 /* SUBTRACT  */
  YYSYMBOL_SUBWINDOW = 813,                /* SUBWINDOW  */
  YYSYMBOL_SUM = 814,                      /* SUM  */
  YYSYMBOL_SUPPRESS = 815,                 /* SUPPRESS  */
  YYSYMBOL_SUPPRESS_XML = 816,             /* "SUPPRESS"  */
  YYSYMBOL_SYMBOLIC = 817,                 /* SYMBOLIC  */
  YYSYMBOL_SYNCHRONIZED = 818,             /* SYNCHRONIZED  */
  YYSYMBOL_SYSTEM_DEFAULT = 819,           /* "SYSTEM-DEFAULT"  */
  YYSYMBOL_SYSTEM_INFO = 820,              /* "SYSTEM-INFO"  */
  YYSYMBOL_SYSTEM_OFFSET = 821,            /* "SYSTEM-OFFSET"  */
  YYSYMBOL_TAB = 822,                      /* TAB  */
  YYSYMBOL_TAB_TO_ADD = 823,               /* "TAB-TO-ADD"  */
  YYSYMBOL_TAB_TO_DELETE = 824,            /* "TAB-TO-DELETE"  */
  YYSYMBOL_TABLE = 825,                    /* TABLE  */
  YYSYMBOL_TALLYING = 826,                 /* TALLYING  */
  YYSYMBOL_TEMPORARY = 827,                /* TEMPORARY  */
  YYSYMBOL_TAPE = 828,                     /* TAPE  */
  YYSYMBOL_TERMINAL = 829,                 /* TERMINAL  */
  YYSYMBOL_TERMINATE = 830,                /* TERMINATE  */
  YYSYMBOL_TERMINAL_INFO = 831,            /* "TERMINAL-INFO"  */
  YYSYMBOL_TERMINATION_VALUE = 832,        /* "TERMINATION-VALUE"  */
  YYSYMBOL_TEST = 833,                     /* TEST  */
  YYSYMBOL_TEXT = 834,                     /* TEXT  */
  YYSYMBOL_THAN = 835,                     /* THAN  */
  YYSYMBOL_THEN = 836,                     /* THEN  */
  YYSYMBOL_THREAD = 837,                   /* THREAD  */
  YYSYMBOL_THREADS = 838,                  /* THREADS  */
  YYSYMBOL_THRU = 839,                     /* THRU  */
  YYSYMBOL_THUMB_POSITION = 840,           /* "THUMB-POSITION"  */
  YYSYMBOL_TILED_HEADINGS = 841,           /* "TILED-HEADINGS"  */
  YYSYMBOL_TIME = 842,                     /* TIME  */
  YYSYMBOL_TIME_OUT = 843,                 /* "TIME-OUT"  */
  YYSYMBOL_TIMES = 844,                    /* TIMES  */
  YYSYMBOL_TITLE = 845,                    /* TITLE  */
  YYSYMBOL_TITLE_POSITION = 846,           /* "TITLE-POSITION"  */
  YYSYMBOL_TO = 847,                       /* TO  */
  YYSYMBOL_TOK_AMPER = 848,                /* "&"  */
  YYSYMBOL_TOK_CLOSE_PAREN = 849,          /* ")"  */
  YYSYMBOL_TOK_COLON = 850,                /* ":"  */
  YYSYMBOL_TOK_DIV = 851,                  /* "/"  */
  YYSYMBOL_TOK_DOT = 852,                  /* "."  */
  YYSYMBOL_TOK_EQUAL = 853,                /* "="  */
  YYSYMBOL_TOK_EXTERN = 854,               /* "EXTERN"  */
  YYSYMBOL_TOK_FALSE = 855,                /* "FALSE"  */
  YYSYMBOL_TOK_FILE = 856,                 /* "FILE"  */
  YYSYMBOL_TOK_GREATER = 857,              /* ">"  */
  YYSYMBOL_TOK_INITIAL = 858,              /* "INITIAL"  */
  YYSYMBOL_TOK_LESS = 859,                 /* "<"  */
  YYSYMBOL_TOK_MINUS = 860,                /* "-"  */
  YYSYMBOL_TOK_MUL = 861,                  /* "*"  */
  YYSYMBOL_TOK_NULL = 862,                 /* "NULL"  */
  YYSYMBOL_TOK_OVERFLOW = 863,             /* "OVERFLOW"  */
  YYSYMBOL_TOK_OPEN_PAREN = 864,           /* "("  */
  YYSYMBOL_TOK_PLUS = 865,                 /* "+"  */
  YYSYMBOL_TOK_TRUE = 866,                 /* "TRUE"  */
  YYSYMBOL_TOP = 867,                      /* TOP  */
  YYSYMBOL_TOWARD_GREATER = 868,           /* "TOWARD-GREATER"  */
  YYSYMBOL_TOWARD_LESSER = 869,            /* "TOWARD-LESSER"  */
  YYSYMBOL_TRACK = 870,                    /* TRACK  */
  YYSYMBOL_TRACKS = 871,                   /* TRACKS  */
  YYSYMBOL_TRACK_AREA = 872,               /* "TRACK-AREA"  */
  YYSYMBOL_TRACK_LIMIT = 873,              /* "TRACK-LIMIT"  */
  YYSYMBOL_TRADITIONAL_FONT = 874,         /* "TRADITIONAL-FONT"  */
  YYSYMBOL_TRAILING = 875,                 /* TRAILING  */
  YYSYMBOL_TRAILING_SHIFT = 876,           /* "TRAILING-SHIFT"  */
  YYSYMBOL_TRANSFORM = 877,                /* TRANSFORM  */
  YYSYMBOL_TRANSPARENT = 878,              /* TRANSPARENT  */
  YYSYMBOL_TREE_VIEW = 879,                /* "TREE-VIEW"  */
  YYSYMBOL_TRIM_FUNC = 880,                /* "FUNCTION TRIM"  */
  YYSYMBOL_TRUNCATION = 881,               /* TRUNCATION  */
  YYSYMBOL_TYPE = 882,                     /* TYPE  */
  YYSYMBOL_TYPEDEF = 883,                  /* TYPEDEF  */
  YYSYMBOL_U = 884,                        /* U  */
  YYSYMBOL_UCS_4 = 885,                    /* "UCS-4"  */
  YYSYMBOL_UNBOUNDED = 886,                /* UNBOUNDED  */
  YYSYMBOL_UNDERLINE = 887,                /* UNDERLINE  */
  YYSYMBOL_UNFRAMED = 888,                 /* UNFRAMED  */
  YYSYMBOL_UNIT = 889,                     /* UNIT  */
  YYSYMBOL_UNLOCK = 890,                   /* UNLOCK  */
  YYSYMBOL_UNSIGNED = 891,                 /* UNSIGNED  */
  YYSYMBOL_UNSIGNED_INT = 892,             /* "UNSIGNED-INT"  */
  YYSYMBOL_UNSIGNED_LONG = 893,            /* "UNSIGNED-LONG"  */
  YYSYMBOL_UNSIGNED_SHORT = 894,           /* "UNSIGNED-SHORT"  */
  YYSYMBOL_UNSORTED = 895,                 /* UNSORTED  */
  YYSYMBOL_UNSTRING = 896,                 /* UNSTRING  */
  YYSYMBOL_UNTIL = 897,                    /* UNTIL  */
  YYSYMBOL_UP = 898,                       /* UP  */
  YYSYMBOL_UPDATE = 899,                   /* UPDATE  */
  YYSYMBOL_UPDATERS = 900,                 /* UPDATERS  */
  YYSYMBOL_UPON = 901,                     /* UPON  */
  YYSYMBOL_UPON_ARGUMENT_NUMBER = 902,     /* "UPON ARGUMENT-NUMBER"  */
  YYSYMBOL_UPON_COMMAND_LINE = 903,        /* "UPON COMMAND-LINE"  */
  YYSYMBOL_UPON_ENVIRONMENT_NAME = 904,    /* "UPON ENVIRONMENT-NAME"  */
  YYSYMBOL_UPON_ENVIRONMENT_VALUE = 905,   /* "UPON ENVIRONMENT-VALUE"  */
  YYSYMBOL_UPPER = 906,                    /* UPPER  */
  YYSYMBOL_UPPER_CASE_FUNC = 907,          /* "FUNCTION UPPER-CASE"  */
  YYSYMBOL_USAGE = 908,                    /* USAGE  */
  YYSYMBOL_USE = 909,                      /* USE  */
  YYSYMBOL_USE_ALT = 910,                  /* "USE-ALT"  */
  YYSYMBOL_USE_RETURN = 911,               /* "USE-RETURN"  */
  YYSYMBOL_USE_TAB = 912,                  /* "USE-TAB"  */
  YYSYMBOL_USER = 913,                     /* USER  */
  YYSYMBOL_USER_DEFAULT = 914,             /* "USER-DEFAULT"  */
  YYSYMBOL_USER_FUNCTION_NAME = 915,       /* "user function name"  */
  YYSYMBOL_USING = 916,                    /* USING  */
  YYSYMBOL_UTF_8 = 917,                    /* "UTF-8"  */
  YYSYMBOL_UTF_16 = 918,                   /* "UTF-16"  */
  YYSYMBOL_V = 919,                        /* V  */
  YYSYMBOL_VALID = 920,                    /* VALID  */
  YYSYMBOL_VALIDATE = 921,                 /* VALIDATE  */
  YYSYMBOL_VAL_STATUS = 922,               /* "VAL-STATUS"  */
  YYSYMBOL_VALIDATE_STATUS = 923,          /* "VALIDATE-STATUS"  */
  YYSYMBOL_VALIDATING = 924,               /* VALIDATING  */
  YYSYMBOL_VALUE = 925,                    /* VALUE  */
  YYSYMBOL_VALUE_FORMAT = 926,             /* "VALUE-FORMAT"  */
  YYSYMBOL_VALUES = 927,                   /* VALUES  */
  YYSYMBOL_VARIABLE = 928,                 /* VARIABLE  */
  YYSYMBOL_VARIANT = 929,                  /* VARIANT  */
  YYSYMBOL_VARYING = 930,                  /* VARYING  */
  YYSYMBOL_VERTICAL = 931,                 /* VERTICAL  */
  YYSYMBOL_VERY_HEAVY = 932,               /* "VERY-HEAVY"  */
  YYSYMBOL_VIRTUAL_WIDTH = 933,            /* "VIRTUAL-WIDTH"  */
  YYSYMBOL_VOLATILE = 934,                 /* VOLATILE  */
  YYSYMBOL_VPADDING = 935,                 /* VPADDING  */
  YYSYMBOL_VSCROLL = 936,                  /* VSCROLL  */
  YYSYMBOL_VSCROLL_BAR = 937,              /* "VSCROLL-BAR"  */
  YYSYMBOL_VSCROLL_POS = 938,              /* "VSCROLL-POS"  */
  YYSYMBOL_VTOP = 939,                     /* VTOP  */
  YYSYMBOL_WAIT = 940,                     /* WAIT  */
  YYSYMBOL_WEB_BROWSER = 941,              /* "WEB-BROWSER"  */
  YYSYMBOL_WHEN = 942,                     /* WHEN  */
  YYSYMBOL_WHEN_COMPILED_FUNC = 943,       /* "FUNCTION WHEN-COMPILED"  */
  YYSYMBOL_WHEN_XML = 944,                 /* "WHEN"  */
  YYSYMBOL_WIDTH = 945,                    /* WIDTH  */
  YYSYMBOL_WIDTH_IN_CELLS = 946,           /* "WIDTH-IN-CELLS"  */
  YYSYMBOL_WINDOW = 947,                   /* WINDOW  */
  YYSYMBOL_WITH = 948,                     /* WITH  */
  YYSYMBOL_WORD = 949,                     /* "Identifier"  */
  YYSYMBOL_WORDS = 950,                    /* WORDS  */
  YYSYMBOL_WORKING_STORAGE = 951,          /* "WORKING-STORAGE"  */
  YYSYMBOL_WRAP = 952,                     /* WRAP  */
  YYSYMBOL_WRITE = 953,                    /* WRITE  */
  YYSYMBOL_WRITE_ONLY = 954,               /* "WRITE-ONLY"  */
  YYSYMBOL_WRITE_VERIFY = 955,             /* "WRITE-VERIFY"  */
  YYSYMBOL_WRITERS = 956,                  /* WRITERS  */
  YYSYMBOL_X = 957,                        /* X  */
  YYSYMBOL_XML = 958,                      /* XML  */
  YYSYMBOL_XML_DECLARATION = 959,          /* "XML-DECLARATION"  */
  YYSYMBOL_XML_SCHEMA = 960,               /* "XML-SCHEMA"  */
  YYSYMBOL_Y = 961,                        /* Y  */
  YYSYMBOL_YYYYDDD = 962,                  /* YYYYDDD  */
  YYSYMBOL_YYYYMMDD = 963,                 /* YYYYMMDD  */
  YYSYMBOL_ZERO = 964,                     /* ZERO  */
  YYSYMBOL_LEVEL_NUMBER_IN_AREA_A = 965,   /* "level-number (Area A)"  */
  YYSYMBOL_WORD_IN_AREA_A = 966,           /* "Identifier (Area A)"  */
  YYSYMBOL_SHIFT_PREFER = 967,             /* SHIFT_PREFER  */
  YYSYMBOL_YYACCEPT = 968,                 /* $accept  */
  YYSYMBOL_start = 969,                    /* start  */
  YYSYMBOL_970_1 = 970,                    /* $@1  */
  YYSYMBOL_compilation_group = 971,        /* compilation_group  */
  YYSYMBOL_nested_list = 972,              /* nested_list  */
  YYSYMBOL_973_2 = 973,                    /* $@2  */
  YYSYMBOL_source_element_list = 974,      /* source_element_list  */
  YYSYMBOL_source_element = 975,           /* source_element  */
  YYSYMBOL_simple_prog = 976,              /* simple_prog  */
  YYSYMBOL_977_3 = 977,                    /* $@3  */
  YYSYMBOL_program_definition = 978,       /* program_definition  */
  YYSYMBOL_function_definition = 979,      /* function_definition  */
  YYSYMBOL__end_program_list = 980,        /* _end_program_list  */
  YYSYMBOL_end_program_list = 981,         /* end_program_list  */
  YYSYMBOL_end_program = 982,              /* end_program  */
  YYSYMBOL_983_4 = 983,                    /* $@4  */
  YYSYMBOL_end_function = 984,             /* end_function  */
  YYSYMBOL_985_5 = 985,                    /* $@5  */
  YYSYMBOL_program_prototype = 986,        /* program_prototype  */
  YYSYMBOL_987_6 = 987,                    /* $@6  */
  YYSYMBOL_function_prototype = 988,       /* function_prototype  */
  YYSYMBOL_989_7 = 989,                    /* $@7  */
  YYSYMBOL__prototype_procedure_division_header = 990, /* _prototype_procedure_division_header  */
  YYSYMBOL_991_8 = 991,                    /* $@8  */
  YYSYMBOL_control = 992,                  /* control  */
  YYSYMBOL__control_division = 993,        /* _control_division  */
  YYSYMBOL_994_9 = 994,                    /* $@9  */
  YYSYMBOL__default_section = 995,         /* _default_section  */
  YYSYMBOL_996_10 = 996,                   /* $@10  */
  YYSYMBOL__default_clauses = 997,         /* _default_clauses  */
  YYSYMBOL__default_accept_clause = 998,   /* _default_accept_clause  */
  YYSYMBOL_999_11 = 999,                   /* $@11  */
  YYSYMBOL__default_display_clause = 1000, /* _default_display_clause  */
  YYSYMBOL_1001_12 = 1001,                 /* $@12  */
  YYSYMBOL__program_body = 1002,           /* _program_body  */
  YYSYMBOL_1003_13 = 1003,                 /* $@13  */
  YYSYMBOL_1004_14 = 1004,                 /* $@14  */
  YYSYMBOL__identification_header = 1005,  /* _identification_header  */
  YYSYMBOL_identification_header = 1006,   /* identification_header  */
  YYSYMBOL_1007_15 = 1007,                 /* $@15  */
  YYSYMBOL_identification_or_id = 1008,    /* identification_or_id  */
  YYSYMBOL_program_id_header = 1009,       /* program_id_header  */
  YYSYMBOL_program_id_paragraph = 1010,    /* program_id_paragraph  */
  YYSYMBOL_function_id_header = 1011,      /* function_id_header  */
  YYSYMBOL_function_id_paragraph = 1012,   /* function_id_paragraph  */
  YYSYMBOL_program_id_name = 1013,         /* program_id_name  */
  YYSYMBOL_end_program_name = 1014,        /* end_program_name  */
  YYSYMBOL__as_literal = 1015,             /* _as_literal  */
  YYSYMBOL__program_type = 1016,           /* _program_type  */
  YYSYMBOL_program_type_clause = 1017,     /* program_type_clause  */
  YYSYMBOL_init_or_recurse_and_common = 1018, /* init_or_recurse_and_common  */
  YYSYMBOL_init_or_recurse = 1019,         /* init_or_recurse  */
  YYSYMBOL__options_paragraph = 1020,      /* _options_paragraph  */
  YYSYMBOL__options_clauses = 1021,        /* _options_clauses  */
  YYSYMBOL__arithmetic_clause = 1022,      /* _arithmetic_clause  */
  YYSYMBOL_arithmetic_choice = 1023,       /* arithmetic_choice  */
  YYSYMBOL__default_rounded_clause = 1024, /* _default_rounded_clause  */
  YYSYMBOL__entry_convention_clause = 1025, /* _entry_convention_clause  */
  YYSYMBOL_convention_type = 1026,         /* convention_type  */
  YYSYMBOL__intermediate_rounding_clause = 1027, /* _intermediate_rounding_clause  */
  YYSYMBOL_intermediate_rounding_choice = 1028, /* intermediate_rounding_choice  */
  YYSYMBOL__environment_division = 1029,   /* _environment_division  */
  YYSYMBOL__environment_header = 1030,     /* _environment_header  */
  YYSYMBOL_environment = 1031,             /* environment  */
  YYSYMBOL_environment_header = 1032,      /* environment_header  */
  YYSYMBOL__configuration_section = 1033,  /* _configuration_section  */
  YYSYMBOL__configuration_header = 1034,   /* _configuration_header  */
  YYSYMBOL_configuration = 1035,           /* configuration  */
  YYSYMBOL_configuration_header = 1036,    /* configuration_header  */
  YYSYMBOL__configuration_paragraphs = 1037, /* _configuration_paragraphs  */
  YYSYMBOL_configuration_paragraphs = 1038, /* configuration_paragraphs  */
  YYSYMBOL_configuration_paragraph = 1039, /* configuration_paragraph  */
  YYSYMBOL__source_computer_paragraph = 1040, /* _source_computer_paragraph  */
  YYSYMBOL_source_computer_paragraph = 1041, /* source_computer_paragraph  */
  YYSYMBOL_1042_16 = 1042,                 /* $@16  */
  YYSYMBOL__source_computer_entry = 1043,  /* _source_computer_entry  */
  YYSYMBOL__with_debugging_mode = 1044,    /* _with_debugging_mode  */
  YYSYMBOL_object_computer_paragraph = 1045, /* object_computer_paragraph  */
  YYSYMBOL_1046_17 = 1046,                 /* $@17  */
  YYSYMBOL__object_computer_entry = 1047,  /* _object_computer_entry  */
  YYSYMBOL_object_clauses_list = 1048,     /* object_clauses_list  */
  YYSYMBOL_object_clauses = 1049,          /* object_clauses  */
  YYSYMBOL_object_computer_memory = 1050,  /* object_computer_memory  */
  YYSYMBOL_object_computer_sequence = 1051, /* object_computer_sequence  */
  YYSYMBOL_program_collating_sequence = 1052, /* program_collating_sequence  */
  YYSYMBOL_1053_18 = 1053,                 /* $@18  */
  YYSYMBOL_program_coll_sequence_values = 1054, /* program_coll_sequence_values  */
  YYSYMBOL_object_computer_segment = 1055, /* object_computer_segment  */
  YYSYMBOL_object_computer_class = 1056,   /* object_computer_class  */
  YYSYMBOL_locale_class = 1057,            /* locale_class  */
  YYSYMBOL_computer_words = 1058,          /* computer_words  */
  YYSYMBOL__repository_paragraph = 1059,   /* _repository_paragraph  */
  YYSYMBOL_repository_paragraph = 1060,    /* repository_paragraph  */
  YYSYMBOL_1061_19 = 1061,                 /* $@19  */
  YYSYMBOL__repository_entry = 1062,       /* _repository_entry  */
  YYSYMBOL_repository_list = 1063,         /* repository_list  */
  YYSYMBOL_repository_name = 1064,         /* repository_name  */
  YYSYMBOL_repository_name_list = 1065,    /* repository_name_list  */
  YYSYMBOL_special_names_header = 1066,    /* special_names_header  */
  YYSYMBOL_special_names_sentence = 1067,  /* special_names_sentence  */
  YYSYMBOL_special_name_list = 1068,       /* special_name_list  */
  YYSYMBOL_special_name = 1069,            /* special_name  */
  YYSYMBOL_mnemonic_name_clause = 1070,    /* mnemonic_name_clause  */
  YYSYMBOL_1071_20 = 1071,                 /* $@20  */
  YYSYMBOL_word_or_terminal = 1072,        /* word_or_terminal  */
  YYSYMBOL_mnemonic_choices = 1073,        /* mnemonic_choices  */
  YYSYMBOL__special_name_mnemonic_on_off = 1074, /* _special_name_mnemonic_on_off  */
  YYSYMBOL_on_off_clauses = 1075,          /* on_off_clauses  */
  YYSYMBOL_on_off_clauses_1 = 1076,        /* on_off_clauses_1  */
  YYSYMBOL_alphabet_name_clause = 1077,    /* alphabet_name_clause  */
  YYSYMBOL_1078_21 = 1078,                 /* @21  */
  YYSYMBOL_alphabet_definition = 1079,     /* alphabet_definition  */
  YYSYMBOL_1080_22 = 1080,                 /* @22  */
  YYSYMBOL_1081_23 = 1081,                 /* @23  */
  YYSYMBOL_alphabet_target_alphanumeric = 1082, /* alphabet_target_alphanumeric  */
  YYSYMBOL_alphabet_target_national = 1083, /* alphabet_target_national  */
  YYSYMBOL_alphabet_type_alphanumeric = 1084, /* alphabet_type_alphanumeric  */
  YYSYMBOL_alphabet_type_national = 1085,  /* alphabet_type_national  */
  YYSYMBOL_alphabet_type_common = 1086,    /* alphabet_type_common  */
  YYSYMBOL_alphabet_literal_list = 1087,   /* alphabet_literal_list  */
  YYSYMBOL_alphabet_literal = 1088,        /* alphabet_literal  */
  YYSYMBOL_1089_24 = 1089,                 /* @24  */
  YYSYMBOL_alphabet_also_sequence = 1090,  /* alphabet_also_sequence  */
  YYSYMBOL_alphabet_lits = 1091,           /* alphabet_lits  */
  YYSYMBOL_space_or_zero = 1092,           /* space_or_zero  */
  YYSYMBOL__alphnat_target = 1093,         /* _alphnat_target  */
  YYSYMBOL__in_alphabet = 1094,            /* _in_alphabet  */
  YYSYMBOL_symbolic_characters_clause = 1095, /* symbolic_characters_clause  */
  YYSYMBOL_symbolic_collection = 1096,     /* symbolic_collection  */
  YYSYMBOL_symbolic_chars_list = 1097,     /* symbolic_chars_list  */
  YYSYMBOL_symbolic_chars_phrase = 1098,   /* symbolic_chars_phrase  */
  YYSYMBOL_char_list = 1099,               /* char_list  */
  YYSYMBOL_integer_list = 1100,            /* integer_list  */
  YYSYMBOL_symbolic_constant_clause = 1101, /* symbolic_constant_clause  */
  YYSYMBOL_symbolic_constant_list = 1102,  /* symbolic_constant_list  */
  YYSYMBOL_symbolic_constant = 1103,       /* symbolic_constant  */
  YYSYMBOL_class_name_clause = 1104,       /* class_name_clause  */
  YYSYMBOL_class_item_list = 1105,         /* class_item_list  */
  YYSYMBOL_class_item = 1106,              /* class_item  */
  YYSYMBOL_locale_clause = 1107,           /* locale_clause  */
  YYSYMBOL_xml_schema_clause = 1108,       /* xml_schema_clause  */
  YYSYMBOL_1109_25 = 1109,                 /* @25  */
  YYSYMBOL_schema_definition = 1110,       /* schema_definition  */
  YYSYMBOL_currency_sign_clause = 1111,    /* currency_sign_clause  */
  YYSYMBOL__with_pic_symbol = 1112,        /* _with_pic_symbol  */
  YYSYMBOL_decimal_point_clause = 1113,    /* decimal_point_clause  */
  YYSYMBOL_numeric_sign_clause = 1114,     /* numeric_sign_clause  */
  YYSYMBOL_cursor_clause = 1115,           /* cursor_clause  */
  YYSYMBOL_crt_status_clause = 1116,       /* crt_status_clause  */
  YYSYMBOL_screen_control = 1117,          /* screen_control  */
  YYSYMBOL_event_status = 1118,            /* event_status  */
  YYSYMBOL_top_clause = 1119,              /* top_clause  */
  YYSYMBOL_1120_26 = 1120,                 /* $@26  */
  YYSYMBOL__input_output_section = 1121,   /* _input_output_section  */
  YYSYMBOL_input_output = 1122,            /* input_output  */
  YYSYMBOL__input_output_header = 1123,    /* _input_output_header  */
  YYSYMBOL__file_control_header = 1124,    /* _file_control_header  */
  YYSYMBOL__file_control_sequence = 1125,  /* _file_control_sequence  */
  YYSYMBOL_file_control_entry = 1126,      /* file_control_entry  */
  YYSYMBOL_1127_27 = 1127,                 /* $@27  */
  YYSYMBOL_1128_28 = 1128,                 /* $@28  */
  YYSYMBOL__select_clauses_or_error = 1129, /* _select_clauses_or_error  */
  YYSYMBOL__select_clause_sequence = 1130, /* _select_clause_sequence  */
  YYSYMBOL_select_clause = 1131,           /* select_clause  */
  YYSYMBOL_assign_clause = 1132,           /* assign_clause  */
  YYSYMBOL__assign_device_or_line_adv_file = 1133, /* _assign_device_or_line_adv_file  */
  YYSYMBOL_assign_device = 1134,           /* assign_device  */
  YYSYMBOL_general_device_name = 1135,     /* general_device_name  */
  YYSYMBOL_line_seq_device_name = 1136,    /* line_seq_device_name  */
  YYSYMBOL_line_adv_file = 1137,           /* line_adv_file  */
  YYSYMBOL__ext_clause = 1138,             /* _ext_clause  */
  YYSYMBOL_ext_clause = 1139,              /* ext_clause  */
  YYSYMBOL_assignment_name = 1140,         /* assignment_name  */
  YYSYMBOL_access_mode_clause = 1141,      /* access_mode_clause  */
  YYSYMBOL_access_mode = 1142,             /* access_mode  */
  YYSYMBOL_alternate_record_key_clause = 1143, /* alternate_record_key_clause  */
  YYSYMBOL__password_clause = 1144,        /* _password_clause  */
  YYSYMBOL_password_clause = 1145,         /* password_clause  */
  YYSYMBOL_1146_29 = 1146,                 /* $@29  */
  YYSYMBOL_encryption_clause = 1147,       /* encryption_clause  */
  YYSYMBOL__suppress_clause = 1148,        /* _suppress_clause  */
  YYSYMBOL_collating_sequence_clause = 1149, /* collating_sequence_clause  */
  YYSYMBOL_collating_sequence = 1150,      /* collating_sequence  */
  YYSYMBOL_1151_30 = 1151,                 /* $@30  */
  YYSYMBOL_coll_sequence_values = 1152,    /* coll_sequence_values  */
  YYSYMBOL_collating_sequence_clause_key = 1153, /* collating_sequence_clause_key  */
  YYSYMBOL_alphabet_name = 1154,           /* alphabet_name  */
  YYSYMBOL_file_status_clause = 1155,      /* file_status_clause  */
  YYSYMBOL__file_or_sort = 1156,           /* _file_or_sort  */
  YYSYMBOL_lock_mode_clause = 1157,        /* lock_mode_clause  */
  YYSYMBOL_1158_31 = 1158,                 /* $@31  */
  YYSYMBOL_lock_mode = 1159,               /* lock_mode  */
  YYSYMBOL__lock_with = 1160,              /* _lock_with  */
  YYSYMBOL__with_rollback = 1161,          /* _with_rollback  */
  YYSYMBOL_with_rollback = 1162,           /* with_rollback  */
  YYSYMBOL__with_mass_update = 1163,       /* _with_mass_update  */
  YYSYMBOL_organization_clause = 1164,     /* organization_clause  */
  YYSYMBOL_organization = 1165,            /* organization  */
  YYSYMBOL_padding_character_clause = 1166, /* padding_character_clause  */
  YYSYMBOL_record_delimiter_clause = 1167, /* record_delimiter_clause  */
  YYSYMBOL_1168_32 = 1168,                 /* $@32  */
  YYSYMBOL_record_delimiter_option = 1169, /* record_delimiter_option  */
  YYSYMBOL_record_key_clause = 1170,       /* record_key_clause  */
  YYSYMBOL__split_keys = 1171,             /* _split_keys  */
  YYSYMBOL_source_is = 1172,               /* source_is  */
  YYSYMBOL_split_key_list = 1173,          /* split_key_list  */
  YYSYMBOL_1174_33 = 1174,                 /* $@33  */
  YYSYMBOL_split_key = 1175,               /* split_key  */
  YYSYMBOL_relative_key_clause = 1176,     /* relative_key_clause  */
  YYSYMBOL_reserve_clause = 1177,          /* reserve_clause  */
  YYSYMBOL_no_or_integer = 1178,           /* no_or_integer  */
  YYSYMBOL_sharing_clause = 1179,          /* sharing_clause  */
  YYSYMBOL_sharing_option = 1180,          /* sharing_option  */
  YYSYMBOL_file_limit_clause = 1181,       /* file_limit_clause  */
  YYSYMBOL_thru_list = 1182,               /* thru_list  */
  YYSYMBOL_actual_key_clause = 1183,       /* actual_key_clause  */
  YYSYMBOL_nominal_key_clause = 1184,      /* nominal_key_clause  */
  YYSYMBOL_track_area_clause = 1185,       /* track_area_clause  */
  YYSYMBOL_track_limit_clause = 1186,      /* track_limit_clause  */
  YYSYMBOL__i_o_control = 1187,            /* _i_o_control  */
  YYSYMBOL_i_o_control_header = 1188,      /* i_o_control_header  */
  YYSYMBOL__i_o_control_entries = 1189,    /* _i_o_control_entries  */
  YYSYMBOL_i_o_control_list = 1190,        /* i_o_control_list  */
  YYSYMBOL_i_o_control_clause = 1191,      /* i_o_control_clause  */
  YYSYMBOL_same_clause = 1192,             /* same_clause  */
  YYSYMBOL__same_option = 1193,            /* _same_option  */
  YYSYMBOL_apply_clause = 1194,            /* apply_clause  */
  YYSYMBOL_obsolete_dos_vs_apply_phrase = 1195, /* obsolete_dos_vs_apply_phrase  */
  YYSYMBOL_multiple_file_tape_clause = 1196, /* multiple_file_tape_clause  */
  YYSYMBOL_1197_34 = 1197,                 /* $@34  */
  YYSYMBOL_multiple_file_list = 1198,      /* multiple_file_list  */
  YYSYMBOL_multiple_file = 1199,           /* multiple_file  */
  YYSYMBOL__multiple_file_position = 1200, /* _multiple_file_position  */
  YYSYMBOL_rerun_clause = 1201,            /* rerun_clause  */
  YYSYMBOL__on_assignment = 1202,          /* _on_assignment  */
  YYSYMBOL_rerun_event = 1203,             /* rerun_event  */
  YYSYMBOL__prototype_environment_division = 1204, /* _prototype_environment_division  */
  YYSYMBOL__prototype_special_names_paragraph = 1205, /* _prototype_special_names_paragraph  */
  YYSYMBOL__prototype_special_names_sentence_list = 1206, /* _prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_names_sentence_list = 1207, /* prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_name_list = 1208, /* prototype_special_name_list  */
  YYSYMBOL_prototype_special_name = 1209,  /* prototype_special_name  */
  YYSYMBOL__data_division = 1210,          /* _data_division  */
  YYSYMBOL_1211_35 = 1211,                 /* $@35  */
  YYSYMBOL__data_division_header = 1212,   /* _data_division_header  */
  YYSYMBOL_data = 1213,                    /* data  */
  YYSYMBOL_data_division_header = 1214,    /* data_division_header  */
  YYSYMBOL_tok_file = 1215,                /* tok_file  */
  YYSYMBOL__file_section_header = 1216,    /* _file_section_header  */
  YYSYMBOL__file_description_sequence = 1217, /* _file_description_sequence  */
  YYSYMBOL_file_description = 1218,        /* file_description  */
  YYSYMBOL_file_description_entry = 1219,  /* file_description_entry  */
  YYSYMBOL_1220_36 = 1220,                 /* $@36  */
  YYSYMBOL_file_type = 1221,               /* file_type  */
  YYSYMBOL__file_description_clause_sequence = 1222, /* _file_description_clause_sequence  */
  YYSYMBOL_file_description_clause = 1223, /* file_description_clause  */
  YYSYMBOL_block_contains_clause = 1224,   /* block_contains_clause  */
  YYSYMBOL__records_or_characters = 1225,  /* _records_or_characters  */
  YYSYMBOL_record_clause = 1226,           /* record_clause  */
  YYSYMBOL__record_depending = 1227,       /* _record_depending  */
  YYSYMBOL__from_integer = 1228,           /* _from_integer  */
  YYSYMBOL__to_integer = 1229,             /* _to_integer  */
  YYSYMBOL_label_records_clause = 1230,    /* label_records_clause  */
  YYSYMBOL_value_of_clause = 1231,         /* value_of_clause  */
  YYSYMBOL_file_id = 1232,                 /* file_id  */
  YYSYMBOL_valueof_name = 1233,            /* valueof_name  */
  YYSYMBOL_data_records_clause = 1234,     /* data_records_clause  */
  YYSYMBOL_linage_clause = 1235,           /* linage_clause  */
  YYSYMBOL__linage_sequence = 1236,        /* _linage_sequence  */
  YYSYMBOL_linage_lines = 1237,            /* linage_lines  */
  YYSYMBOL_linage_footing = 1238,          /* linage_footing  */
  YYSYMBOL_linage_top = 1239,              /* linage_top  */
  YYSYMBOL_linage_bottom = 1240,           /* linage_bottom  */
  YYSYMBOL_recording_mode_clause = 1241,   /* recording_mode_clause  */
  YYSYMBOL_recording_mode = 1242,          /* recording_mode  */
  YYSYMBOL_u_or_s = 1243,                  /* u_or_s  */
  YYSYMBOL_code_set_clause = 1244,         /* code_set_clause  */
  YYSYMBOL__for_sub_records_clause = 1245, /* _for_sub_records_clause  */
  YYSYMBOL_report_clause = 1246,           /* report_clause  */
  YYSYMBOL_report_keyword = 1247,          /* report_keyword  */
  YYSYMBOL_rep_name_list = 1248,           /* rep_name_list  */
  YYSYMBOL_communication = 1249,           /* communication  */
  YYSYMBOL__communication_section = 1250,  /* _communication_section  */
  YYSYMBOL_1251_37 = 1251,                 /* $@37  */
  YYSYMBOL__communication_description_sequence = 1252, /* _communication_description_sequence  */
  YYSYMBOL_communication_description = 1253, /* communication_description  */
  YYSYMBOL_cd = 1254,                      /* cd  */
  YYSYMBOL_communication_description_entry = 1255, /* communication_description_entry  */
  YYSYMBOL_1256_38 = 1256,                 /* $@38  */
  YYSYMBOL__communication_description_clause_sequence = 1257, /* _communication_description_clause_sequence  */
  YYSYMBOL_communication_description_clause = 1258, /* communication_description_clause  */
  YYSYMBOL__input_cd_clauses = 1259,       /* _input_cd_clauses  */
  YYSYMBOL_named_input_cd_clauses = 1260,  /* named_input_cd_clauses  */
  YYSYMBOL_named_input_cd_clause = 1261,   /* named_input_cd_clause  */
  YYSYMBOL_unnamed_input_cd_clauses = 1262, /* unnamed_input_cd_clauses  */
  YYSYMBOL__output_cd_clauses = 1263,      /* _output_cd_clauses  */
  YYSYMBOL_output_cd_clauses = 1264,       /* output_cd_clauses  */
  YYSYMBOL_output_cd_clause = 1265,        /* output_cd_clause  */
  YYSYMBOL__i_o_cd_clauses = 1266,         /* _i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clauses = 1267,    /* named_i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clause = 1268,     /* named_i_o_cd_clause  */
  YYSYMBOL_unnamed_i_o_cd_clauses = 1269,  /* unnamed_i_o_cd_clauses  */
  YYSYMBOL_working_storage = 1270,         /* working_storage  */
  YYSYMBOL__working_storage_section = 1271, /* _working_storage_section  */
  YYSYMBOL_1272_39 = 1272,                 /* $@39  */
  YYSYMBOL__record_description_list = 1273, /* _record_description_list  */
  YYSYMBOL_1274_40 = 1274,                 /* $@40  */
  YYSYMBOL_record_description_list = 1275, /* record_description_list  */
  YYSYMBOL_data_description = 1276,        /* data_description  */
  YYSYMBOL_1277_41 = 1277,                 /* $@41  */
  YYSYMBOL_level_number = 1278,            /* level_number  */
  YYSYMBOL__filler = 1279,                 /* _filler  */
  YYSYMBOL__entry_name = 1280,             /* _entry_name  */
  YYSYMBOL_user_entry_name = 1281,         /* user_entry_name  */
  YYSYMBOL__const_global = 1282,           /* _const_global  */
  YYSYMBOL_lit_or_length = 1283,           /* lit_or_length  */
  YYSYMBOL_con_source = 1284,              /* con_source  */
  YYSYMBOL_fp32_usage = 1285,              /* fp32_usage  */
  YYSYMBOL_fp64_usage = 1286,              /* fp64_usage  */
  YYSYMBOL_fp128_usage = 1287,             /* fp128_usage  */
  YYSYMBOL_pointer_len = 1288,             /* pointer_len  */
  YYSYMBOL_renames_entry = 1289,           /* renames_entry  */
  YYSYMBOL__renames_thru = 1290,           /* _renames_thru  */
  YYSYMBOL_condition_name_entry = 1291,    /* condition_name_entry  */
  YYSYMBOL_1292_42 = 1292,                 /* $@42  */
  YYSYMBOL__user_entry_name = 1293,        /* _user_entry_name  */
  YYSYMBOL_constant_entry = 1294,          /* constant_entry  */
  YYSYMBOL_1295_43 = 1295,                 /* $@43  */
  YYSYMBOL_constant_source = 1296,         /* constant_source  */
  YYSYMBOL_constant_78_source = 1297,      /* constant_78_source  */
  YYSYMBOL_constant_expression_list = 1298, /* constant_expression_list  */
  YYSYMBOL_constant_expression = 1299,     /* constant_expression  */
  YYSYMBOL__data_description_clause_sequence = 1300, /* _data_description_clause_sequence  */
  YYSYMBOL_data_description_clause_sequence = 1301, /* data_description_clause_sequence  */
  YYSYMBOL_data_description_clause = 1302, /* data_description_clause  */
  YYSYMBOL_redefines_clause = 1303,        /* redefines_clause  */
  YYSYMBOL_like_clause = 1304,             /* like_clause  */
  YYSYMBOL__length_modifier = 1305,        /* _length_modifier  */
  YYSYMBOL_length_modifier = 1306,         /* length_modifier  */
  YYSYMBOL_same_as_clause = 1307,          /* same_as_clause  */
  YYSYMBOL_typedef_clause = 1308,          /* typedef_clause  */
  YYSYMBOL__strong = 1309,                 /* _strong  */
  YYSYMBOL_external_clause = 1310,         /* external_clause  */
  YYSYMBOL__as_extname = 1311,             /* _as_extname  */
  YYSYMBOL__global_clause = 1312,          /* _global_clause  */
  YYSYMBOL_global_clause = 1313,           /* global_clause  */
  YYSYMBOL_special_names_clause = 1314,    /* special_names_clause  */
  YYSYMBOL_1315_44 = 1315,                 /* $@44  */
  YYSYMBOL_special_names_target = 1316,    /* special_names_target  */
  YYSYMBOL_select_when_clause = 1317,      /* select_when_clause  */
  YYSYMBOL_1318_45 = 1318,                 /* $@45  */
  YYSYMBOL_when_choice = 1319,             /* when_choice  */
  YYSYMBOL_format_clause = 1320,           /* format_clause  */
  YYSYMBOL_format_choice = 1321,           /* format_choice  */
  YYSYMBOL_volatile_clause = 1322,         /* volatile_clause  */
  YYSYMBOL_picture_clause = 1323,          /* picture_clause  */
  YYSYMBOL_1324_46 = 1324,                 /* $@46  */
  YYSYMBOL__pic_locale_format_or_depending_on = 1325, /* _pic_locale_format_or_depending_on  */
  YYSYMBOL__is_locale_name = 1326,         /* _is_locale_name  */
  YYSYMBOL_locale_name = 1327,             /* locale_name  */
  YYSYMBOL_type_to_clause = 1328,          /* type_to_clause  */
  YYSYMBOL_usage_clause = 1329,            /* usage_clause  */
  YYSYMBOL__usage_is = 1330,               /* _usage_is  */
  YYSYMBOL_usage = 1331,                   /* usage  */
  YYSYMBOL_conflict_usage = 1332,          /* conflict_usage  */
  YYSYMBOL__object_reference_type = 1333,  /* _object_reference_type  */
  YYSYMBOL__factory_of = 1334,             /* _factory_of  */
  YYSYMBOL__only = 1335,                   /* _only  */
  YYSYMBOL_double_usage = 1336,            /* double_usage  */
  YYSYMBOL__font_name = 1337,              /* _font_name  */
  YYSYMBOL__layout_name = 1338,            /* _layout_name  */
  YYSYMBOL_sign_clause = 1339,             /* sign_clause  */
  YYSYMBOL_report_occurs_clause = 1340,    /* report_occurs_clause  */
  YYSYMBOL_report_occurs_step = 1341,      /* report_occurs_step  */
  YYSYMBOL_occurs_clause = 1342,           /* occurs_clause  */
  YYSYMBOL__occurs_from_integer = 1343,    /* _occurs_from_integer  */
  YYSYMBOL__occurs_to_integer = 1344,      /* _occurs_to_integer  */
  YYSYMBOL__occurs_integer_to = 1345,      /* _occurs_integer_to  */
  YYSYMBOL__occurs_depending = 1346,       /* _occurs_depending  */
  YYSYMBOL__capacity_in = 1347,            /* _capacity_in  */
  YYSYMBOL__occurs_initialized = 1348,     /* _occurs_initialized  */
  YYSYMBOL__occurs_keys_and_indexed = 1349, /* _occurs_keys_and_indexed  */
  YYSYMBOL_1350_47 = 1350,                 /* $@47  */
  YYSYMBOL_occurs_keys = 1351,             /* occurs_keys  */
  YYSYMBOL_occurs_key_list = 1352,         /* occurs_key_list  */
  YYSYMBOL_occurs_key_field = 1353,        /* occurs_key_field  */
  YYSYMBOL_ascending_or_descending = 1354, /* ascending_or_descending  */
  YYSYMBOL__occurs_indexed = 1355,         /* _occurs_indexed  */
  YYSYMBOL_occurs_indexed = 1356,          /* occurs_indexed  */
  YYSYMBOL_occurs_index_list = 1357,       /* occurs_index_list  */
  YYSYMBOL_occurs_index = 1358,            /* occurs_index  */
  YYSYMBOL_justified_clause = 1359,        /* justified_clause  */
  YYSYMBOL_synchronized_clause = 1360,     /* synchronized_clause  */
  YYSYMBOL__left_or_right = 1361,          /* _left_or_right  */
  YYSYMBOL_blank_clause = 1362,            /* blank_clause  */
  YYSYMBOL_based_clause = 1363,            /* based_clause  */
  YYSYMBOL_value_clause = 1364,            /* value_clause  */
  YYSYMBOL_value_table_item_list = 1365,   /* value_table_item_list  */
  YYSYMBOL_value_table_item = 1366,        /* value_table_item  */
  YYSYMBOL_from_subscripts = 1367,         /* from_subscripts  */
  YYSYMBOL__to_subscripts = 1368,          /* _to_subscripts  */
  YYSYMBOL_from_to_subscripts = 1369,      /* from_to_subscripts  */
  YYSYMBOL__repeated_phrase = 1370,        /* _repeated_phrase  */
  YYSYMBOL_subscripts = 1371,              /* subscripts  */
  YYSYMBOL_value_is_are = 1372,            /* value_is_are  */
  YYSYMBOL_value_item_list = 1373,         /* value_item_list  */
  YYSYMBOL_value_item = 1374,              /* value_item  */
  YYSYMBOL_value_clause_report = 1375,     /* value_clause_report  */
  YYSYMBOL_value_clause_condition = 1376,  /* value_clause_condition  */
  YYSYMBOL_1377_48 = 1377,                 /* $@48  */
  YYSYMBOL_value_item_list_in_alphabet = 1378, /* value_item_list_in_alphabet  */
  YYSYMBOL_value_item_condition_list = 1379, /* value_item_condition_list  */
  YYSYMBOL_value_item_condition = 1380,    /* value_item_condition  */
  YYSYMBOL__false_or_content_validation = 1381, /* _false_or_content_validation  */
  YYSYMBOL_false_is = 1382,                /* false_is  */
  YYSYMBOL_content_validation = 1383,      /* content_validation  */
  YYSYMBOL_valid_or_invalid = 1384,        /* valid_or_invalid  */
  YYSYMBOL__when_condition = 1385,         /* _when_condition  */
  YYSYMBOL_validate_status_clause = 1386,  /* validate_status_clause  */
  YYSYMBOL_when_error_choice = 1387,       /* when_error_choice  */
  YYSYMBOL__on_choice = 1388,              /* _on_choice  */
  YYSYMBOL_default_clause = 1389,          /* default_clause  */
  YYSYMBOL_x_or_none = 1390,               /* x_or_none  */
  YYSYMBOL_class_clause = 1391,            /* class_clause  */
  YYSYMBOL_class_option = 1392,            /* class_option  */
  YYSYMBOL_destination_clause = 1393,      /* destination_clause  */
  YYSYMBOL_present_when_clause = 1394,     /* present_when_clause  */
  YYSYMBOL_invalid_when_clause = 1395,     /* invalid_when_clause  */
  YYSYMBOL_any_length_clause = 1396,       /* any_length_clause  */
  YYSYMBOL_external_form_clause = 1397,    /* external_form_clause  */
  YYSYMBOL_identified_by_clause = 1398,    /* identified_by_clause  */
  YYSYMBOL_local_storage = 1399,           /* local_storage  */
  YYSYMBOL__local_storage_section = 1400,  /* _local_storage_section  */
  YYSYMBOL_1401_49 = 1401,                 /* $@49  */
  YYSYMBOL_linkage = 1402,                 /* linkage  */
  YYSYMBOL__linkage_section = 1403,        /* _linkage_section  */
  YYSYMBOL_1404_50 = 1404,                 /* $@50  */
  YYSYMBOL__report_section = 1405,         /* _report_section  */
  YYSYMBOL_1406_51 = 1406,                 /* $@51  */
  YYSYMBOL_1407_52 = 1407,                 /* $@52  */
  YYSYMBOL__report_description_sequence = 1408, /* _report_description_sequence  */
  YYSYMBOL_report_description = 1409,      /* report_description  */
  YYSYMBOL_1410_53 = 1410,                 /* $@53  */
  YYSYMBOL_1411_54 = 1411,                 /* $@54  */
  YYSYMBOL__report_description_options = 1412, /* _report_description_options  */
  YYSYMBOL_report_description_option = 1413, /* report_description_option  */
  YYSYMBOL_control_clause = 1414,          /* control_clause  */
  YYSYMBOL_control_field_list = 1415,      /* control_field_list  */
  YYSYMBOL_control_final_tag = 1416,       /* control_final_tag  */
  YYSYMBOL_control_identifier_list = 1417, /* control_identifier_list  */
  YYSYMBOL_control_identifier = 1418,      /* control_identifier  */
  YYSYMBOL_page_limit_clause = 1419,       /* page_limit_clause  */
  YYSYMBOL_page_line_column = 1420,        /* page_line_column  */
  YYSYMBOL_page_limit_cols = 1421,         /* page_limit_cols  */
  YYSYMBOL_integer_or_zero_or_ident = 1422, /* integer_or_zero_or_ident  */
  YYSYMBOL__page_heading_list = 1423,      /* _page_heading_list  */
  YYSYMBOL_page_detail = 1424,             /* page_detail  */
  YYSYMBOL_heading_clause = 1425,          /* heading_clause  */
  YYSYMBOL_first_detail = 1426,            /* first_detail  */
  YYSYMBOL_last_heading = 1427,            /* last_heading  */
  YYSYMBOL_last_detail = 1428,             /* last_detail  */
  YYSYMBOL_footing_clause = 1429,          /* footing_clause  */
  YYSYMBOL__report_group_description_list = 1430, /* _report_group_description_list  */
  YYSYMBOL_report_group_description_entry = 1431, /* report_group_description_entry  */
  YYSYMBOL_1432_55 = 1432,                 /* $@55  */
  YYSYMBOL__report_group_options = 1433,   /* _report_group_options  */
  YYSYMBOL_report_group_option = 1434,     /* report_group_option  */
  YYSYMBOL_type_is_clause = 1435,          /* type_is_clause  */
  YYSYMBOL_type_option = 1436,             /* type_option  */
  YYSYMBOL__control_heading_final = 1437,  /* _control_heading_final  */
  YYSYMBOL__or_page = 1438,                /* _or_page  */
  YYSYMBOL__control_footing_final = 1439,  /* _control_footing_final  */
  YYSYMBOL_next_group_clause = 1440,       /* next_group_clause  */
  YYSYMBOL_next_group_plus = 1441,         /* next_group_plus  */
  YYSYMBOL_next_page = 1442,               /* next_page  */
  YYSYMBOL_sum_clause_list = 1443,         /* sum_clause_list  */
  YYSYMBOL__reset_clause = 1444,           /* _reset_clause  */
  YYSYMBOL_data_or_final = 1445,           /* data_or_final  */
  YYSYMBOL_present_when_condition = 1446,  /* present_when_condition  */
  YYSYMBOL_present_absent = 1447,          /* present_absent  */
  YYSYMBOL__page_or_id = 1448,             /* _page_or_id  */
  YYSYMBOL_page_or_ids = 1449,             /* page_or_ids  */
  YYSYMBOL_data_varying_clause = 1450,     /* data_varying_clause  */
  YYSYMBOL_data_varying_list = 1451,       /* data_varying_list  */
  YYSYMBOL_data_varying = 1452,            /* data_varying  */
  YYSYMBOL__var_from = 1453,               /* _var_from  */
  YYSYMBOL__var_by = 1454,                 /* _var_by  */
  YYSYMBOL_line_clause = 1455,             /* line_clause  */
  YYSYMBOL_line_keyword_clause = 1456,     /* line_keyword_clause  */
  YYSYMBOL__line_clause_options = 1457,    /* _line_clause_options  */
  YYSYMBOL_line_clause_option = 1458,      /* line_clause_option  */
  YYSYMBOL_column_clause = 1459,           /* column_clause  */
  YYSYMBOL_col_keyword_clause = 1460,      /* col_keyword_clause  */
  YYSYMBOL__orientation = 1461,            /* _orientation  */
  YYSYMBOL__left_right_center = 1462,      /* _left_right_center  */
  YYSYMBOL_col_or_plus = 1463,             /* col_or_plus  */
  YYSYMBOL_column_integer_list = 1464,     /* column_integer_list  */
  YYSYMBOL_column_integer = 1465,          /* column_integer  */
  YYSYMBOL_source_clause = 1466,           /* source_clause  */
  YYSYMBOL_group_indicate_clause = 1467,   /* group_indicate_clause  */
  YYSYMBOL__screen_section = 1468,         /* _screen_section  */
  YYSYMBOL_1469_56 = 1469,                 /* $@56  */
  YYSYMBOL_1470_57 = 1470,                 /* $@57  */
  YYSYMBOL__screen_description_list = 1471, /* _screen_description_list  */
  YYSYMBOL_screen_description_list = 1472, /* screen_description_list  */
  YYSYMBOL_screen_description = 1473,      /* screen_description  */
  YYSYMBOL_1474_58 = 1474,                 /* $@58  */
  YYSYMBOL_1475_59 = 1475,                 /* $@59  */
  YYSYMBOL_1476_60 = 1476,                 /* $@60  */
  YYSYMBOL__screen_options = 1477,         /* _screen_options  */
  YYSYMBOL_screen_option = 1478,           /* screen_option  */
  YYSYMBOL_screen_value_clause = 1479,     /* screen_value_clause  */
  YYSYMBOL__value_is = 1480,               /* _value_is  */
  YYSYMBOL_control_definition = 1481,      /* control_definition  */
  YYSYMBOL_control_type_name = 1482,       /* control_type_name  */
  YYSYMBOL_control_type = 1483,            /* control_type  */
  YYSYMBOL_control_item = 1484,            /* control_item  */
  YYSYMBOL__control_attributes = 1485,     /* _control_attributes  */
  YYSYMBOL_control_attributes = 1486,      /* control_attributes  */
  YYSYMBOL_control_attribute = 1487,       /* control_attribute  */
  YYSYMBOL_control_style = 1488,           /* control_style  */
  YYSYMBOL_control_property = 1489,        /* control_property  */
  YYSYMBOL_control_style_name = 1490,      /* control_style_name  */
  YYSYMBOL_control_property_name = 1491,   /* control_property_name  */
  YYSYMBOL_control_style_name_generic = 1492, /* control_style_name_generic  */
  YYSYMBOL_control_property_name_generic = 1493, /* control_property_name_generic  */
  YYSYMBOL_control_style_name_label = 1494, /* control_style_name_label  */
  YYSYMBOL_control_property_name_label = 1495, /* control_property_name_label  */
  YYSYMBOL_control_style_name_entry_field = 1496, /* control_style_name_entry_field  */
  YYSYMBOL_control_property_name_entry_field = 1497, /* control_property_name_entry_field  */
  YYSYMBOL_control_style_name_push_button = 1498, /* control_style_name_push_button  */
  YYSYMBOL_control_property_name_push_button = 1499, /* control_property_name_push_button  */
  YYSYMBOL_control_style_name_check_box = 1500, /* control_style_name_check_box  */
  YYSYMBOL_control_property_name_radio_button = 1501, /* control_property_name_radio_button  */
  YYSYMBOL_control_style_name_list_box = 1502, /* control_style_name_list_box  */
  YYSYMBOL_control_property_name_list_box = 1503, /* control_property_name_list_box  */
  YYSYMBOL_control_style_name_combo_box = 1504, /* control_style_name_combo_box  */
  YYSYMBOL_control_style_name_frame = 1505, /* control_style_name_frame  */
  YYSYMBOL_control_property_name_frame = 1506, /* control_property_name_frame  */
  YYSYMBOL_control_style_name_tab_control = 1507, /* control_style_name_tab_control  */
  YYSYMBOL_control_property_name_tab_control = 1508, /* control_property_name_tab_control  */
  YYSYMBOL_control_style_name_bar = 1509,  /* control_style_name_bar  */
  YYSYMBOL_control_property_name_bar = 1510, /* control_property_name_bar  */
  YYSYMBOL_control_property_name_bitmap = 1511, /* control_property_name_bitmap  */
  YYSYMBOL_control_style_name_grid = 1512, /* control_style_name_grid  */
  YYSYMBOL_control_property_name_grid = 1513, /* control_property_name_grid  */
  YYSYMBOL_control_style_name_tree_view = 1514, /* control_style_name_tree_view  */
  YYSYMBOL_control_property_name_tree_view = 1515, /* control_property_name_tree_view  */
  YYSYMBOL_control_property_name_web_browser = 1516, /* control_property_name_web_browser  */
  YYSYMBOL_control_style_name_activex = 1517, /* control_style_name_activex  */
  YYSYMBOL_control_property_name_activex = 1518, /* control_property_name_activex  */
  YYSYMBOL_control_style_name_date_entry = 1519, /* control_style_name_date_entry  */
  YYSYMBOL_control_property_name_date_entry = 1520, /* control_property_name_date_entry  */
  YYSYMBOL_control_style_type = 1521,      /* control_style_type  */
  YYSYMBOL_control_property_type = 1522,   /* control_property_type  */
  YYSYMBOL_changeable_control_properties = 1523, /* changeable_control_properties  */
  YYSYMBOL_changeable_control_property = 1524, /* changeable_control_property  */
  YYSYMBOL_changeable_window_properties = 1525, /* changeable_window_properties  */
  YYSYMBOL_changeable_window_property = 1526, /* changeable_window_property  */
  YYSYMBOL_eol = 1527,                     /* eol  */
  YYSYMBOL_eos = 1528,                     /* eos  */
  YYSYMBOL__plus = 1529,                   /* _plus  */
  YYSYMBOL_plus = 1530,                    /* plus  */
  YYSYMBOL_plus_tokens = 1531,             /* plus_tokens  */
  YYSYMBOL_minus = 1532,                   /* minus  */
  YYSYMBOL_minus_tokens = 1533,            /* minus_tokens  */
  YYSYMBOL_control_size = 1534,            /* control_size  */
  YYSYMBOL_control_size_unit = 1535,       /* control_size_unit  */
  YYSYMBOL__cell = 1536,                   /* _cell  */
  YYSYMBOL_screen_line_number = 1537,      /* screen_line_number  */
  YYSYMBOL__screen_line_plus_minus = 1538, /* _screen_line_plus_minus  */
  YYSYMBOL_screen_col_number = 1539,       /* screen_col_number  */
  YYSYMBOL__screen_col_plus_minus = 1540,  /* _screen_col_plus_minus  */
  YYSYMBOL_screen_occurs_clause = 1541,    /* screen_occurs_clause  */
  YYSYMBOL_screen_global_clause = 1542,    /* screen_global_clause  */
  YYSYMBOL__prototype_data_division = 1543, /* _prototype_data_division  */
  YYSYMBOL__procedure_division = 1544,     /* _procedure_division  */
  YYSYMBOL_procedure_division = 1545,      /* procedure_division  */
  YYSYMBOL_1546_61 = 1546,                 /* $@61  */
  YYSYMBOL_1547_62 = 1547,                 /* $@62  */
  YYSYMBOL_1548_63 = 1548,                 /* $@63  */
  YYSYMBOL_1549_64 = 1549,                 /* $@64  */
  YYSYMBOL_1550_65 = 1550,                 /* $@65  */
  YYSYMBOL__procedure_using_chaining = 1551, /* _procedure_using_chaining  */
  YYSYMBOL_1552_66 = 1552,                 /* $@66  */
  YYSYMBOL_1553_67 = 1553,                 /* $@67  */
  YYSYMBOL_procedure_param_list = 1554,    /* procedure_param_list  */
  YYSYMBOL_procedure_param = 1555,         /* procedure_param  */
  YYSYMBOL__procedure_type = 1556,         /* _procedure_type  */
  YYSYMBOL__size_optional = 1557,          /* _size_optional  */
  YYSYMBOL_using_size_clause = 1558,       /* using_size_clause  */
  YYSYMBOL_size_is_integer = 1559,         /* size_is_integer  */
  YYSYMBOL__acu_size = 1560,               /* _acu_size  */
  YYSYMBOL__procedure_optional = 1561,     /* _procedure_optional  */
  YYSYMBOL__procedure_returning = 1562,    /* _procedure_returning  */
  YYSYMBOL__procedure_declaratives = 1563, /* _procedure_declaratives  */
  YYSYMBOL_1564_68 = 1564,                 /* $@68  */
  YYSYMBOL_1565_69 = 1565,                 /* $@69  */
  YYSYMBOL_1566_70 = 1566,                 /* $@70  */
  YYSYMBOL__procedure_list = 1567,         /* _procedure_list  */
  YYSYMBOL_procedure = 1568,               /* procedure  */
  YYSYMBOL_1569_71 = 1569,                 /* $@71  */
  YYSYMBOL_proc_name = 1570,               /* proc_name  */
  YYSYMBOL_section_header = 1571,          /* section_header  */
  YYSYMBOL_1572_72 = 1572,                 /* $@72  */
  YYSYMBOL__use_statement = 1573,          /* _use_statement  */
  YYSYMBOL_paragraph_header = 1574,        /* paragraph_header  */
  YYSYMBOL_invalid_statement = 1575,       /* invalid_statement  */
  YYSYMBOL__segment = 1576,                /* _segment  */
  YYSYMBOL_statement_list = 1577,          /* statement_list  */
  YYSYMBOL_1578_73 = 1578,                 /* @73  */
  YYSYMBOL_1579_74 = 1579,                 /* @74  */
  YYSYMBOL_statements = 1580,              /* statements  */
  YYSYMBOL_1581_75 = 1581,                 /* $@75  */
  YYSYMBOL_statement = 1582,               /* statement  */
  YYSYMBOL_1583_76 = 1583,                 /* $@76  */
  YYSYMBOL_accept_statement = 1584,        /* accept_statement  */
  YYSYMBOL_1585_77 = 1585,                 /* $@77  */
  YYSYMBOL_accept_body = 1586,             /* accept_body  */
  YYSYMBOL_1587_78 = 1587,                 /* $@78  */
  YYSYMBOL_1588_79 = 1588,                 /* $@79  */
  YYSYMBOL_accp_identifier = 1589,         /* accp_identifier  */
  YYSYMBOL_field_with_pos_specifier = 1590, /* field_with_pos_specifier  */
  YYSYMBOL_1591_80 = 1591,                 /* $@80  */
  YYSYMBOL__pos_specifier = 1592,          /* _pos_specifier  */
  YYSYMBOL_pos_specifier = 1593,           /* pos_specifier  */
  YYSYMBOL_pos_specifier_value = 1594,     /* pos_specifier_value  */
  YYSYMBOL_identifier_or_numeric_literal = 1595, /* identifier_or_numeric_literal  */
  YYSYMBOL__accept_clauses = 1596,         /* _accept_clauses  */
  YYSYMBOL_accept_clauses = 1597,          /* accept_clauses  */
  YYSYMBOL_accept_clause = 1598,           /* accept_clause  */
  YYSYMBOL_accept_from_screen_clauses = 1599, /* accept_from_screen_clauses  */
  YYSYMBOL_accept_from_screen_clause = 1600, /* accept_from_screen_clause  */
  YYSYMBOL_lines_or_number = 1601,         /* lines_or_number  */
  YYSYMBOL_at_line_column = 1602,          /* at_line_column  */
  YYSYMBOL_line_number = 1603,             /* line_number  */
  YYSYMBOL_column_number = 1604,           /* column_number  */
  YYSYMBOL_mode_is_block = 1605,           /* mode_is_block  */
  YYSYMBOL_accp_attr = 1606,               /* accp_attr  */
  YYSYMBOL__key_dest = 1607,               /* _key_dest  */
  YYSYMBOL_key_dest = 1608,                /* key_dest  */
  YYSYMBOL_no_echo = 1609,                 /* no_echo  */
  YYSYMBOL_reverse_video = 1610,           /* reverse_video  */
  YYSYMBOL_update_default = 1611,          /* update_default  */
  YYSYMBOL__end_accept = 1612,             /* _end_accept  */
  YYSYMBOL_add_statement = 1613,           /* add_statement  */
  YYSYMBOL_1614_81 = 1614,                 /* $@81  */
  YYSYMBOL_add_body = 1615,                /* add_body  */
  YYSYMBOL__add_to = 1616,                 /* _add_to  */
  YYSYMBOL__end_add = 1617,                /* _end_add  */
  YYSYMBOL_allocate_statement = 1618,      /* allocate_statement  */
  YYSYMBOL_1619_82 = 1619,                 /* $@82  */
  YYSYMBOL_allocate_body = 1620,           /* allocate_body  */
  YYSYMBOL__loc = 1621,                    /* _loc  */
  YYSYMBOL__allocate_returning = 1622,     /* _allocate_returning  */
  YYSYMBOL_alter_statement = 1623,         /* alter_statement  */
  YYSYMBOL_1624_83 = 1624,                 /* $@83  */
  YYSYMBOL_alter_body = 1625,              /* alter_body  */
  YYSYMBOL_alter_entry = 1626,             /* alter_entry  */
  YYSYMBOL__proceed_to = 1627,             /* _proceed_to  */
  YYSYMBOL_call_statement = 1628,          /* call_statement  */
  YYSYMBOL_1629_84 = 1629,                 /* $@84  */
  YYSYMBOL_call_body = 1630,               /* call_body  */
  YYSYMBOL_1631_85 = 1631,                 /* $@85  */
  YYSYMBOL__conv_linkage = 1632,           /* _conv_linkage  */
  YYSYMBOL_1633_86 = 1633,                 /* $@86  */
  YYSYMBOL_conv_linkage_option = 1634,     /* conv_linkage_option  */
  YYSYMBOL__mnemonic_conv = 1635,          /* _mnemonic_conv  */
  YYSYMBOL_mnemonic_conv = 1636,           /* mnemonic_conv  */
  YYSYMBOL_program_or_prototype = 1637,    /* program_or_prototype  */
  YYSYMBOL__id_or_lit_or_func_as = 1638,   /* _id_or_lit_or_func_as  */
  YYSYMBOL_nested_or_prototype = 1639,     /* nested_or_prototype  */
  YYSYMBOL_call_using = 1640,              /* call_using  */
  YYSYMBOL_1641_87 = 1641,                 /* $@87  */
  YYSYMBOL_call_param_list = 1642,         /* call_param_list  */
  YYSYMBOL_call_param = 1643,              /* call_param  */
  YYSYMBOL__call_type = 1644,              /* _call_type  */
  YYSYMBOL_call_returning = 1645,          /* call_returning  */
  YYSYMBOL_return_give = 1646,             /* return_give  */
  YYSYMBOL_null_or_omitted = 1647,         /* null_or_omitted  */
  YYSYMBOL_call_exception_phrases = 1648,  /* call_exception_phrases  */
  YYSYMBOL__call_on_exception = 1649,      /* _call_on_exception  */
  YYSYMBOL_call_on_exception = 1650,       /* call_on_exception  */
  YYSYMBOL__call_not_on_exception = 1651,  /* _call_not_on_exception  */
  YYSYMBOL_call_not_on_exception = 1652,   /* call_not_on_exception  */
  YYSYMBOL__end_call = 1653,               /* _end_call  */
  YYSYMBOL_cancel_statement = 1654,        /* cancel_statement  */
  YYSYMBOL_1655_88 = 1655,                 /* $@88  */
  YYSYMBOL_cancel_body = 1656,             /* cancel_body  */
  YYSYMBOL_cancel_list = 1657,             /* cancel_list  */
  YYSYMBOL_id_or_lit_or_program_name = 1658, /* id_or_lit_or_program_name  */
  YYSYMBOL_close_statement = 1659,         /* close_statement  */
  YYSYMBOL_1660_89 = 1660,                 /* $@89  */
  YYSYMBOL_close_body = 1661,              /* close_body  */
  YYSYMBOL_close_files = 1662,             /* close_files  */
  YYSYMBOL__close_option = 1663,           /* _close_option  */
  YYSYMBOL_close_window = 1664,            /* close_window  */
  YYSYMBOL_1665_90 = 1665,                 /* $@90  */
  YYSYMBOL__close_display_option = 1666,   /* _close_display_option  */
  YYSYMBOL_compute_statement = 1667,       /* compute_statement  */
  YYSYMBOL_1668_91 = 1668,                 /* $@91  */
  YYSYMBOL_compute_body = 1669,            /* compute_body  */
  YYSYMBOL__end_compute = 1670,            /* _end_compute  */
  YYSYMBOL_commit_statement = 1671,        /* commit_statement  */
  YYSYMBOL_continue_statement = 1672,      /* continue_statement  */
  YYSYMBOL_1673_92 = 1673,                 /* $@92  */
  YYSYMBOL__continue_after_phrase = 1674,  /* _continue_after_phrase  */
  YYSYMBOL_1675_93 = 1675,                 /* $@93  */
  YYSYMBOL_destroy_statement = 1676,       /* destroy_statement  */
  YYSYMBOL_1677_94 = 1677,                 /* $@94  */
  YYSYMBOL_destroy_body = 1678,            /* destroy_body  */
  YYSYMBOL_delete_statement = 1679,        /* delete_statement  */
  YYSYMBOL_1680_95 = 1680,                 /* $@95  */
  YYSYMBOL_delete_body = 1681,             /* delete_body  */
  YYSYMBOL_delete_file_list = 1682,        /* delete_file_list  */
  YYSYMBOL__end_delete = 1683,             /* _end_delete  */
  YYSYMBOL_disable_statement = 1684,       /* disable_statement  */
  YYSYMBOL_1685_96 = 1685,                 /* $@96  */
  YYSYMBOL_enable_disable_handling = 1686, /* enable_disable_handling  */
  YYSYMBOL__enable_disable_key = 1687,     /* _enable_disable_key  */
  YYSYMBOL_communication_mode = 1688,      /* communication_mode  */
  YYSYMBOL_display_statement = 1689,       /* display_statement  */
  YYSYMBOL_1690_97 = 1690,                 /* $@97  */
  YYSYMBOL_display_body = 1691,            /* display_body  */
  YYSYMBOL_screen_or_device_display = 1692, /* screen_or_device_display  */
  YYSYMBOL_display_list = 1693,            /* display_list  */
  YYSYMBOL_display_atom = 1694,            /* display_atom  */
  YYSYMBOL_1695_98 = 1695,                 /* $@98  */
  YYSYMBOL_disp_list = 1696,               /* disp_list  */
  YYSYMBOL__with_display_attr = 1697,      /* _with_display_attr  */
  YYSYMBOL_display_attrs = 1698,           /* display_attrs  */
  YYSYMBOL_display_clauses = 1699,         /* display_clauses  */
  YYSYMBOL_display_clause = 1700,          /* display_clause  */
  YYSYMBOL__display_upon = 1701,           /* _display_upon  */
  YYSYMBOL_display_upon = 1702,            /* display_upon  */
  YYSYMBOL_crt_under = 1703,               /* crt_under  */
  YYSYMBOL_display_erase = 1704,           /* display_erase  */
  YYSYMBOL_1705_99 = 1705,                 /* $@99  */
  YYSYMBOL_display_pos_specifier = 1706,   /* display_pos_specifier  */
  YYSYMBOL_field_or_literal_or_erase_with_pos_specifier = 1707, /* field_or_literal_or_erase_with_pos_specifier  */
  YYSYMBOL_1708_100 = 1708,                /* $@100  */
  YYSYMBOL_field_or_literal_or_erase_list = 1709, /* field_or_literal_or_erase_list  */
  YYSYMBOL_field_or_literal_or_erase = 1710, /* field_or_literal_or_erase  */
  YYSYMBOL_display_message_box = 1711,     /* display_message_box  */
  YYSYMBOL_1712_101 = 1712,                /* $@101  */
  YYSYMBOL__display_message_clauses = 1713, /* _display_message_clauses  */
  YYSYMBOL_display_message_clauses = 1714, /* display_message_clauses  */
  YYSYMBOL_display_message_clause = 1715,  /* display_message_clause  */
  YYSYMBOL_display_window = 1716,          /* display_window  */
  YYSYMBOL_1717_102 = 1717,                /* $@102  */
  YYSYMBOL_1718_103 = 1718,                /* $@103  */
  YYSYMBOL_sub_or_window = 1719,           /* sub_or_window  */
  YYSYMBOL_display_floating_window = 1720, /* display_floating_window  */
  YYSYMBOL_1721_104 = 1721,                /* $@104  */
  YYSYMBOL_1722_105 = 1722,                /* $@105  */
  YYSYMBOL_display_initial_window = 1723,  /* display_initial_window  */
  YYSYMBOL_1724_106 = 1724,                /* $@106  */
  YYSYMBOL_initial_type = 1725,            /* initial_type  */
  YYSYMBOL__graphical = 1726,              /* _graphical  */
  YYSYMBOL__upon_window_handle = 1727,     /* _upon_window_handle  */
  YYSYMBOL_window_handle = 1728,           /* window_handle  */
  YYSYMBOL_display_window_clauses = 1729,  /* display_window_clauses  */
  YYSYMBOL_display_window_clause = 1730,   /* display_window_clause  */
  YYSYMBOL_shadow = 1731,                  /* shadow  */
  YYSYMBOL_boxed = 1732,                   /* boxed  */
  YYSYMBOL__top_or_bottom = 1733,          /* _top_or_bottom  */
  YYSYMBOL__left_or_centered_or_right = 1734, /* _left_or_centered_or_right  */
  YYSYMBOL_no_scroll_wrap = 1735,          /* no_scroll_wrap  */
  YYSYMBOL_pop_up_or_handle = 1736,        /* pop_up_or_handle  */
  YYSYMBOL_pop_up_area = 1737,             /* pop_up_area  */
  YYSYMBOL_handle_is_in = 1738,            /* handle_is_in  */
  YYSYMBOL_disp_attr = 1739,               /* disp_attr  */
  YYSYMBOL__end_display = 1740,            /* _end_display  */
  YYSYMBOL_divide_statement = 1741,        /* divide_statement  */
  YYSYMBOL_1742_107 = 1742,                /* $@107  */
  YYSYMBOL_divide_body = 1743,             /* divide_body  */
  YYSYMBOL__end_divide = 1744,             /* _end_divide  */
  YYSYMBOL_enable_statement = 1745,        /* enable_statement  */
  YYSYMBOL_1746_108 = 1746,                /* $@108  */
  YYSYMBOL_entry = 1747,                   /* entry  */
  YYSYMBOL_entry_statement = 1748,         /* entry_statement  */
  YYSYMBOL_1749_109 = 1749,                /* $@109  */
  YYSYMBOL_1750_110 = 1750,                /* $@110  */
  YYSYMBOL_entry_body = 1751,              /* entry_body  */
  YYSYMBOL_entry_goto_body = 1752,         /* entry_goto_body  */
  YYSYMBOL_evaluate_statement = 1753,      /* evaluate_statement  */
  YYSYMBOL_1754_111 = 1754,                /* $@111  */
  YYSYMBOL_evaluate_body = 1755,           /* evaluate_body  */
  YYSYMBOL_evaluate_subject_list = 1756,   /* evaluate_subject_list  */
  YYSYMBOL_evaluate_subject = 1757,        /* evaluate_subject  */
  YYSYMBOL_evaluate_condition_list = 1758, /* evaluate_condition_list  */
  YYSYMBOL_evaluate_case_list = 1759,      /* evaluate_case_list  */
  YYSYMBOL_evaluate_case = 1760,           /* evaluate_case  */
  YYSYMBOL_evaluate_other = 1761,          /* evaluate_other  */
  YYSYMBOL_evaluate_when_list = 1762,      /* evaluate_when_list  */
  YYSYMBOL_1763_112 = 1763,                /* $@112  */
  YYSYMBOL_1764_113 = 1764,                /* $@113  */
  YYSYMBOL_evaluate_object_list = 1765,    /* evaluate_object_list  */
  YYSYMBOL_evaluate_object = 1766,         /* evaluate_object  */
  YYSYMBOL__evaluate_thru_expr = 1767,     /* _evaluate_thru_expr  */
  YYSYMBOL__end_evaluate = 1768,           /* _end_evaluate  */
  YYSYMBOL_exhibit_statement = 1769,       /* exhibit_statement  */
  YYSYMBOL_1770_114 = 1770,                /* $@114  */
  YYSYMBOL_exhibit_body = 1771,            /* exhibit_body  */
  YYSYMBOL_1772_115 = 1772,                /* $@115  */
  YYSYMBOL__changed = 1773,                /* _changed  */
  YYSYMBOL__named = 1774,                  /* _named  */
  YYSYMBOL_exhibit_target_list = 1775,     /* exhibit_target_list  */
  YYSYMBOL_exhibit_target = 1776,          /* exhibit_target  */
  YYSYMBOL_exit_statement = 1777,          /* exit_statement  */
  YYSYMBOL_1778_116 = 1778,                /* $@116  */
  YYSYMBOL_exit_body = 1779,               /* exit_body  */
  YYSYMBOL_goback_exit_body = 1780,        /* goback_exit_body  */
  YYSYMBOL_free_statement = 1781,          /* free_statement  */
  YYSYMBOL_1782_117 = 1782,                /* $@117  */
  YYSYMBOL_free_body = 1783,               /* free_body  */
  YYSYMBOL_generate_statement = 1784,      /* generate_statement  */
  YYSYMBOL_1785_118 = 1785,                /* $@118  */
  YYSYMBOL_generate_body = 1786,           /* generate_body  */
  YYSYMBOL_goto_statement = 1787,          /* goto_statement  */
  YYSYMBOL_1788_119 = 1788,                /* $@119  */
  YYSYMBOL_go_body = 1789,                 /* go_body  */
  YYSYMBOL_goto_depending = 1790,          /* goto_depending  */
  YYSYMBOL_goback_statement = 1791,        /* goback_statement  */
  YYSYMBOL_1792_120 = 1792,                /* $@120  */
  YYSYMBOL_if_statement = 1793,            /* if_statement  */
  YYSYMBOL_1794_121 = 1794,                /* $@121  */
  YYSYMBOL_if_else_statements = 1795,      /* if_else_statements  */
  YYSYMBOL__if_then = 1796,                /* _if_then  */
  YYSYMBOL_if_true = 1797,                 /* if_true  */
  YYSYMBOL_if_false = 1798,                /* if_false  */
  YYSYMBOL__end_if = 1799,                 /* _end_if  */
  YYSYMBOL_initialize_statement = 1800,    /* initialize_statement  */
  YYSYMBOL_1801_122 = 1801,                /* $@122  */
  YYSYMBOL_initialize_body = 1802,         /* initialize_body  */
  YYSYMBOL__initialize_filler = 1803,      /* _initialize_filler  */
  YYSYMBOL__initialize_value = 1804,       /* _initialize_value  */
  YYSYMBOL__initialize_replacing = 1805,   /* _initialize_replacing  */
  YYSYMBOL_initialize_replacing_list = 1806, /* initialize_replacing_list  */
  YYSYMBOL_initialize_replacing_item = 1807, /* initialize_replacing_item  */
  YYSYMBOL_initialize_category = 1808,     /* initialize_category  */
  YYSYMBOL__initialize_default = 1809,     /* _initialize_default  */
  YYSYMBOL_initiate_statement = 1810,      /* initiate_statement  */
  YYSYMBOL_1811_123 = 1811,                /* $@123  */
  YYSYMBOL_initiate_body = 1812,           /* initiate_body  */
  YYSYMBOL_inquire_statement = 1813,       /* inquire_statement  */
  YYSYMBOL_1814_124 = 1814,                /* $@124  */
  YYSYMBOL_inquire_body = 1815,            /* inquire_body  */
  YYSYMBOL_inspect_statement = 1816,       /* inspect_statement  */
  YYSYMBOL_1817_125 = 1817,                /* $@125  */
  YYSYMBOL_inspect_body = 1818,            /* inspect_body  */
  YYSYMBOL__backward = 1819,               /* _backward  */
  YYSYMBOL_send_identifier = 1820,         /* send_identifier  */
  YYSYMBOL_inspect_format_variant = 1821,  /* inspect_format_variant  */
  YYSYMBOL_examine_statement = 1822,       /* examine_statement  */
  YYSYMBOL_1823_126 = 1823,                /* $@126  */
  YYSYMBOL_examine_format_variant = 1824,  /* examine_format_variant  */
  YYSYMBOL_1825_127 = 1825,                /* $@127  */
  YYSYMBOL_examine_tallying_keyword = 1826, /* examine_tallying_keyword  */
  YYSYMBOL_examine_replacing_keyword = 1827, /* examine_replacing_keyword  */
  YYSYMBOL__examine_tallying_replacing = 1828, /* _examine_tallying_replacing  */
  YYSYMBOL_single_character_value = 1829,  /* single_character_value  */
  YYSYMBOL_inspect_tallying = 1830,        /* inspect_tallying  */
  YYSYMBOL_1831_128 = 1831,                /* $@128  */
  YYSYMBOL_inspect_replacing = 1832,       /* inspect_replacing  */
  YYSYMBOL_inspect_converting = 1833,      /* inspect_converting  */
  YYSYMBOL_tallying_list = 1834,           /* tallying_list  */
  YYSYMBOL_tallying_item = 1835,           /* tallying_item  */
  YYSYMBOL_replacing_list = 1836,          /* replacing_list  */
  YYSYMBOL_replacing_item = 1837,          /* replacing_item  */
  YYSYMBOL_rep_keyword = 1838,             /* rep_keyword  */
  YYSYMBOL_replacing_region = 1839,        /* replacing_region  */
  YYSYMBOL_inspect_region = 1840,          /* inspect_region  */
  YYSYMBOL_inspect_before = 1841,          /* inspect_before  */
  YYSYMBOL_inspect_after = 1842,           /* inspect_after  */
  YYSYMBOL_json = 1843,                    /* json  */
  YYSYMBOL_json_generate_statement = 1844, /* json_generate_statement  */
  YYSYMBOL_1845_129 = 1845,                /* $@129  */
  YYSYMBOL_json_generate_body = 1846,      /* json_generate_body  */
  YYSYMBOL_1847_130 = 1847,                /* $@130  */
  YYSYMBOL_1848_131 = 1848,                /* $@131  */
  YYSYMBOL__json_suppress = 1849,          /* _json_suppress  */
  YYSYMBOL_json_suppress_list = 1850,      /* json_suppress_list  */
  YYSYMBOL_json_suppress_entry = 1851,     /* json_suppress_entry  */
  YYSYMBOL__end_json = 1852,               /* _end_json  */
  YYSYMBOL_json_parse_statement = 1853,    /* json_parse_statement  */
  YYSYMBOL_1854_132 = 1854,                /* $@132  */
  YYSYMBOL_json_parse_body = 1855,         /* json_parse_body  */
  YYSYMBOL__with_detail = 1856,            /* _with_detail  */
  YYSYMBOL_merge_statement = 1857,         /* merge_statement  */
  YYSYMBOL_1858_133 = 1858,                /* $@133  */
  YYSYMBOL_modify_statement = 1859,        /* modify_statement  */
  YYSYMBOL_1860_134 = 1860,                /* $@134  */
  YYSYMBOL_modify_body = 1861,             /* modify_body  */
  YYSYMBOL__end_modify = 1862,             /* _end_modify  */
  YYSYMBOL_move_statement = 1863,          /* move_statement  */
  YYSYMBOL_1864_135 = 1864,                /* $@135  */
  YYSYMBOL_move_body = 1865,               /* move_body  */
  YYSYMBOL_multiply_statement = 1866,      /* multiply_statement  */
  YYSYMBOL_1867_136 = 1867,                /* $@136  */
  YYSYMBOL_multiply_body = 1868,           /* multiply_body  */
  YYSYMBOL__end_multiply = 1869,           /* _end_multiply  */
  YYSYMBOL_open_statement = 1870,          /* open_statement  */
  YYSYMBOL_1871_137 = 1871,                /* $@137  */
  YYSYMBOL_open_body = 1872,               /* open_body  */
  YYSYMBOL_open_file_entry = 1873,         /* open_file_entry  */
  YYSYMBOL__open_exclusive = 1874,         /* _open_exclusive  */
  YYSYMBOL_open_mode = 1875,               /* open_mode  */
  YYSYMBOL__open_sharing = 1876,           /* _open_sharing  */
  YYSYMBOL__open_option = 1877,            /* _open_option  */
  YYSYMBOL_lock_allowing = 1878,           /* lock_allowing  */
  YYSYMBOL_open_lock_option = 1879,        /* open_lock_option  */
  YYSYMBOL_allowing_option = 1880,         /* allowing_option  */
  YYSYMBOL_allowing_all = 1881,            /* allowing_all  */
  YYSYMBOL_open_option_sequential = 1882,  /* open_option_sequential  */
  YYSYMBOL_osvs_input_mode = 1883,         /* osvs_input_mode  */
  YYSYMBOL_perform_statement = 1884,       /* perform_statement  */
  YYSYMBOL_1885_138 = 1885,                /* $@138  */
  YYSYMBOL_perform_body = 1886,            /* perform_body  */
  YYSYMBOL_1887_139 = 1887,                /* $@139  */
  YYSYMBOL_1888_140 = 1888,                /* $@140  */
  YYSYMBOL__end_perform = 1889,            /* _end_perform  */
  YYSYMBOL_end_perform_or_dot = 1890,      /* end_perform_or_dot  */
  YYSYMBOL_perform_procedure = 1891,       /* perform_procedure  */
  YYSYMBOL__perform_option = 1892,         /* _perform_option  */
  YYSYMBOL_perform_test = 1893,            /* perform_test  */
  YYSYMBOL_cond_or_exit = 1894,            /* cond_or_exit  */
  YYSYMBOL_perform_varying_list = 1895,    /* perform_varying_list  */
  YYSYMBOL_perform_varying = 1896,         /* perform_varying  */
  YYSYMBOL__by_phrase = 1897,              /* _by_phrase  */
  YYSYMBOL_purge_statement = 1898,         /* purge_statement  */
  YYSYMBOL_1899_141 = 1899,                /* $@141  */
  YYSYMBOL_raise_statement = 1900,         /* raise_statement  */
  YYSYMBOL_1901_142 = 1901,                /* $@142  */
  YYSYMBOL_raise_body = 1902,              /* raise_body  */
  YYSYMBOL_exception_name = 1903,          /* exception_name  */
  YYSYMBOL_read_statement = 1904,          /* read_statement  */
  YYSYMBOL_1905_143 = 1905,                /* $@143  */
  YYSYMBOL_read_body = 1906,               /* read_body  */
  YYSYMBOL__read_into = 1907,              /* _read_into  */
  YYSYMBOL__lock_phrases = 1908,           /* _lock_phrases  */
  YYSYMBOL_ignoring_lock = 1909,           /* ignoring_lock  */
  YYSYMBOL_advancing_lock_or_retry = 1910, /* advancing_lock_or_retry  */
  YYSYMBOL__retry_phrase = 1911,           /* _retry_phrase  */
  YYSYMBOL_retry_phrase = 1912,            /* retry_phrase  */
  YYSYMBOL_retry_options = 1913,           /* retry_options  */
  YYSYMBOL__extended_with_lock = 1914,     /* _extended_with_lock  */
  YYSYMBOL_extended_with_lock = 1915,      /* extended_with_lock  */
  YYSYMBOL__read_key = 1916,               /* _read_key  */
  YYSYMBOL_read_handler = 1917,            /* read_handler  */
  YYSYMBOL__end_read = 1918,               /* _end_read  */
  YYSYMBOL_ready_statement = 1919,         /* ready_statement  */
  YYSYMBOL_receive_statement = 1920,       /* receive_statement  */
  YYSYMBOL_1921_144 = 1921,                /* $@144  */
  YYSYMBOL_receive_body = 1922,            /* receive_body  */
  YYSYMBOL_message_or_segment = 1923,      /* message_or_segment  */
  YYSYMBOL__data_sentence_phrases = 1924,  /* _data_sentence_phrases  */
  YYSYMBOL__no_data_sentence = 1925,       /* _no_data_sentence  */
  YYSYMBOL_no_data_sentence = 1926,        /* no_data_sentence  */
  YYSYMBOL__with_data_sentence = 1927,     /* _with_data_sentence  */
  YYSYMBOL_with_data_sentence = 1928,      /* with_data_sentence  */
  YYSYMBOL__end_receive = 1929,            /* _end_receive  */
  YYSYMBOL_release_statement = 1930,       /* release_statement  */
  YYSYMBOL_1931_145 = 1931,                /* $@145  */
  YYSYMBOL_release_body = 1932,            /* release_body  */
  YYSYMBOL_reset_statement = 1933,         /* reset_statement  */
  YYSYMBOL_return_statement = 1934,        /* return_statement  */
  YYSYMBOL_1935_146 = 1935,                /* $@146  */
  YYSYMBOL_return_body = 1936,             /* return_body  */
  YYSYMBOL__end_return = 1937,             /* _end_return  */
  YYSYMBOL_rewrite_statement = 1938,       /* rewrite_statement  */
  YYSYMBOL_1939_147 = 1939,                /* $@147  */
  YYSYMBOL_rewrite_body = 1940,            /* rewrite_body  */
  YYSYMBOL__with_lock = 1941,              /* _with_lock  */
  YYSYMBOL_with_lock = 1942,               /* with_lock  */
  YYSYMBOL__end_rewrite = 1943,            /* _end_rewrite  */
  YYSYMBOL_rollback_statement = 1944,      /* rollback_statement  */
  YYSYMBOL_search = 1945,                  /* search  */
  YYSYMBOL_search_statement = 1946,        /* search_statement  */
  YYSYMBOL_1947_148 = 1947,                /* $@148  */
  YYSYMBOL_1948_149 = 1948,                /* $@149  */
  YYSYMBOL_search_body = 1949,             /* search_body  */
  YYSYMBOL_search_all_body = 1950,         /* search_all_body  */
  YYSYMBOL__search_varying = 1951,         /* _search_varying  */
  YYSYMBOL__search_at_end = 1952,          /* _search_at_end  */
  YYSYMBOL_end_pos_token = 1953,           /* end_pos_token  */
  YYSYMBOL_search_whens = 1954,            /* search_whens  */
  YYSYMBOL_search_when = 1955,             /* search_when  */
  YYSYMBOL__end_search = 1956,             /* _end_search  */
  YYSYMBOL_send_statement = 1957,          /* send_statement  */
  YYSYMBOL_1958_150 = 1958,                /* $@150  */
  YYSYMBOL_send_body = 1959,               /* send_body  */
  YYSYMBOL_send_body_mcs = 1960,           /* send_body_mcs  */
  YYSYMBOL_message_tag_data_item = 1961,   /* message_tag_data_item  */
  YYSYMBOL__from_identifier = 1962,        /* _from_identifier  */
  YYSYMBOL_from_identifier = 1963,         /* from_identifier  */
  YYSYMBOL_send_body_cd = 1964,            /* send_body_cd  */
  YYSYMBOL_with_indicator = 1965,          /* with_indicator  */
  YYSYMBOL__replacing_line = 1966,         /* _replacing_line  */
  YYSYMBOL_set_statement = 1967,           /* set_statement  */
  YYSYMBOL_1968_151 = 1968,                /* $@151  */
  YYSYMBOL_set_body = 1969,                /* set_body  */
  YYSYMBOL_on_or_off = 1970,               /* on_or_off  */
  YYSYMBOL_up_or_down = 1971,              /* up_or_down  */
  YYSYMBOL_set_environment = 1972,         /* set_environment  */
  YYSYMBOL_set_attr = 1973,                /* set_attr  */
  YYSYMBOL_set_attr_clause = 1974,         /* set_attr_clause  */
  YYSYMBOL_set_attr_one = 1975,            /* set_attr_one  */
  YYSYMBOL_set_to = 1976,                  /* set_to  */
  YYSYMBOL_set_up_down = 1977,             /* set_up_down  */
  YYSYMBOL_set_to_on_off_sequence = 1978,  /* set_to_on_off_sequence  */
  YYSYMBOL_set_to_on_off = 1979,           /* set_to_on_off  */
  YYSYMBOL_set_to_true_false_sequence = 1980, /* set_to_true_false_sequence  */
  YYSYMBOL_set_to_true_false = 1981,       /* set_to_true_false  */
  YYSYMBOL_set_last_exception_to_off = 1982, /* set_last_exception_to_off  */
  YYSYMBOL_set_thread_priority = 1983,     /* set_thread_priority  */
  YYSYMBOL_sort_statement = 1984,          /* sort_statement  */
  YYSYMBOL_1985_152 = 1985,                /* $@152  */
  YYSYMBOL_sort_body = 1986,               /* sort_body  */
  YYSYMBOL_1987_153 = 1987,                /* @153  */
  YYSYMBOL__sort_key_list = 1988,          /* _sort_key_list  */
  YYSYMBOL__key_sort_list = 1989,          /* _key_sort_list  */
  YYSYMBOL__sort_duplicates = 1990,        /* _sort_duplicates  */
  YYSYMBOL__sort_collating = 1991,         /* _sort_collating  */
  YYSYMBOL_sort_input = 1992,              /* sort_input  */
  YYSYMBOL_sort_output = 1993,             /* sort_output  */
  YYSYMBOL_start_statement = 1994,         /* start_statement  */
  YYSYMBOL_1995_154 = 1995,                /* $@154  */
  YYSYMBOL_start_body = 1996,              /* start_body  */
  YYSYMBOL__sizelen_clause = 1997,         /* _sizelen_clause  */
  YYSYMBOL__start_key = 1998,              /* _start_key  */
  YYSYMBOL_start_op = 1999,                /* start_op  */
  YYSYMBOL_not_equal_op = 2000,            /* not_equal_op  */
  YYSYMBOL__end_start = 2001,              /* _end_start  */
  YYSYMBOL_stop = 2002,                    /* stop  */
  YYSYMBOL_stop_statement = 2003,          /* stop_statement  */
  YYSYMBOL_2004_155 = 2004,                /* $@155  */
  YYSYMBOL_stop_returning = 2005,          /* stop_returning  */
  YYSYMBOL__status_x = 2006,               /* _status_x  */
  YYSYMBOL_stop_argument = 2007,           /* stop_argument  */
  YYSYMBOL_stop_literal = 2008,            /* stop_literal  */
  YYSYMBOL_string_statement = 2009,        /* string_statement  */
  YYSYMBOL_2010_156 = 2010,                /* $@156  */
  YYSYMBOL_string_body = 2011,             /* string_body  */
  YYSYMBOL_string_items = 2012,            /* string_items  */
  YYSYMBOL_2013_157 = 2013,                /* $@157  */
  YYSYMBOL_string_item_list = 2014,        /* string_item_list  */
  YYSYMBOL_string_item = 2015,             /* string_item  */
  YYSYMBOL__string_delimited = 2016,       /* _string_delimited  */
  YYSYMBOL_string_delimiter = 2017,        /* string_delimiter  */
  YYSYMBOL__with_pointer = 2018,           /* _with_pointer  */
  YYSYMBOL__end_string = 2019,             /* _end_string  */
  YYSYMBOL_subtract_statement = 2020,      /* subtract_statement  */
  YYSYMBOL_2021_158 = 2021,                /* $@158  */
  YYSYMBOL_subtract_body = 2022,           /* subtract_body  */
  YYSYMBOL__end_subtract = 2023,           /* _end_subtract  */
  YYSYMBOL_suppress_statement = 2024,      /* suppress_statement  */
  YYSYMBOL_2025_159 = 2025,                /* $@159  */
  YYSYMBOL__printing = 2026,               /* _printing  */
  YYSYMBOL_terminate_statement = 2027,     /* terminate_statement  */
  YYSYMBOL_2028_160 = 2028,                /* $@160  */
  YYSYMBOL_terminate_body = 2029,          /* terminate_body  */
  YYSYMBOL_transform_statement = 2030,     /* transform_statement  */
  YYSYMBOL_2031_161 = 2031,                /* $@161  */
  YYSYMBOL_transform_body = 2032,          /* transform_body  */
  YYSYMBOL_unlock_statement = 2033,        /* unlock_statement  */
  YYSYMBOL_2034_162 = 2034,                /* $@162  */
  YYSYMBOL_unlock_body = 2035,             /* unlock_body  */
  YYSYMBOL_unstring_statement = 2036,      /* unstring_statement  */
  YYSYMBOL_2037_163 = 2037,                /* $@163  */
  YYSYMBOL_unstring_body = 2038,           /* unstring_body  */
  YYSYMBOL__unstring_delimited = 2039,     /* _unstring_delimited  */
  YYSYMBOL_unstring_delimited_list = 2040, /* unstring_delimited_list  */
  YYSYMBOL_unstring_delimited_item = 2041, /* unstring_delimited_item  */
  YYSYMBOL_unstring_into = 2042,           /* unstring_into  */
  YYSYMBOL_unstring_into_item = 2043,      /* unstring_into_item  */
  YYSYMBOL__unstring_into_delimiter = 2044, /* _unstring_into_delimiter  */
  YYSYMBOL__unstring_tallying = 2045,      /* _unstring_tallying  */
  YYSYMBOL__end_unstring = 2046,           /* _end_unstring  */
  YYSYMBOL_validate_statement = 2047,      /* validate_statement  */
  YYSYMBOL_2048_164 = 2048,                /* $@164  */
  YYSYMBOL_validate_fields = 2049,         /* validate_fields  */
  YYSYMBOL_use_statement = 2050,           /* use_statement  */
  YYSYMBOL_2051_165 = 2051,                /* $@165  */
  YYSYMBOL_use_phrase = 2052,              /* use_phrase  */
  YYSYMBOL_use_file_exception = 2053,      /* use_file_exception  */
  YYSYMBOL__use_global = 2054,             /* _use_global  */
  YYSYMBOL_use_file_exception_target = 2055, /* use_file_exception_target  */
  YYSYMBOL_use_for_debugging = 2056,       /* use_for_debugging  */
  YYSYMBOL_debugging_list = 2057,          /* debugging_list  */
  YYSYMBOL_debugging_target = 2058,        /* debugging_target  */
  YYSYMBOL__all_refs = 2059,               /* _all_refs  */
  YYSYMBOL_use_at_start_end = 2060,        /* use_at_start_end  */
  YYSYMBOL_program_start_end = 2061,       /* program_start_end  */
  YYSYMBOL_use_before_reporting = 2062,    /* use_before_reporting  */
  YYSYMBOL_use_after_exception = 2063,     /* use_after_exception  */
  YYSYMBOL_use_exception_list = 2064,      /* use_exception_list  */
  YYSYMBOL_use_exception = 2065,           /* use_exception  */
  YYSYMBOL_use_ex_keyw = 2066,             /* use_ex_keyw  */
  YYSYMBOL_write_statement = 2067,         /* write_statement  */
  YYSYMBOL_2068_166 = 2068,                /* $@166  */
  YYSYMBOL_write_body = 2069,              /* write_body  */
  YYSYMBOL_from_option = 2070,             /* from_option  */
  YYSYMBOL_write_option = 2071,            /* write_option  */
  YYSYMBOL_before_or_after = 2072,         /* before_or_after  */
  YYSYMBOL_write_handler = 2073,           /* write_handler  */
  YYSYMBOL__end_write = 2074,              /* _end_write  */
  YYSYMBOL_xml = 2075,                     /* xml  */
  YYSYMBOL_xml_generate_statement = 2076,  /* xml_generate_statement  */
  YYSYMBOL_2077_167 = 2077,                /* $@167  */
  YYSYMBOL_xml_generate_body = 2078,       /* xml_generate_body  */
  YYSYMBOL_2079_168 = 2079,                /* $@168  */
  YYSYMBOL_2080_169 = 2080,                /* $@169  */
  YYSYMBOL__with_encoding_xml_dec_and_attrs = 2081, /* _with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attrs = 2082, /* with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attr = 2083, /* with_encoding_xml_dec_and_attr  */
  YYSYMBOL_encoding_xml_dec_and_attr = 2084, /* encoding_xml_dec_and_attr  */
  YYSYMBOL__xml_gen_namespace = 2085,      /* _xml_gen_namespace  */
  YYSYMBOL__xml_gen_namespace_prefix = 2086, /* _xml_gen_namespace_prefix  */
  YYSYMBOL__xml_name_of = 2087,            /* _xml_name_of  */
  YYSYMBOL_identifier_name_list = 2088,    /* identifier_name_list  */
  YYSYMBOL_identifier_is_name = 2089,      /* identifier_is_name  */
  YYSYMBOL__json_name_of = 2090,           /* _json_name_of  */
  YYSYMBOL_json_identifier_name_list = 2091, /* json_identifier_name_list  */
  YYSYMBOL_json_identifier_is_name = 2092, /* json_identifier_is_name  */
  YYSYMBOL__type_of = 2093,                /* _type_of  */
  YYSYMBOL_identifier_type_list = 2094,    /* identifier_type_list  */
  YYSYMBOL_identifier_is_type = 2095,      /* identifier_is_type  */
  YYSYMBOL__xml_type = 2096,               /* _xml_type  */
  YYSYMBOL_ml_type = 2097,                 /* ml_type  */
  YYSYMBOL__xml_gen_suppress = 2098,       /* _xml_gen_suppress  */
  YYSYMBOL_xml_suppress_list = 2099,       /* xml_suppress_list  */
  YYSYMBOL_xml_suppress_entry = 2100,      /* xml_suppress_entry  */
  YYSYMBOL_xml_suppress_generic_opt = 2101, /* xml_suppress_generic_opt  */
  YYSYMBOL_xml_suppress_when_list = 2102,  /* xml_suppress_when_list  */
  YYSYMBOL__end_xml = 2103,                /* _end_xml  */
  YYSYMBOL_xml_parse_statement = 2104,     /* xml_parse_statement  */
  YYSYMBOL_2105_170 = 2105,                /* $@170  */
  YYSYMBOL_xml_parse_body = 2106,          /* xml_parse_body  */
  YYSYMBOL_2107_171 = 2107,                /* $@171  */
  YYSYMBOL__with_encoding = 2108,          /* _with_encoding  */
  YYSYMBOL__returning_national = 2109,     /* _returning_national  */
  YYSYMBOL__validating_with = 2110,        /* _validating_with  */
  YYSYMBOL_schema_file_or_record_name = 2111, /* schema_file_or_record_name  */
  YYSYMBOL__accept_exception_phrases = 2112, /* _accept_exception_phrases  */
  YYSYMBOL__accp_on_exception = 2113,      /* _accp_on_exception  */
  YYSYMBOL_accp_on_exception = 2114,       /* accp_on_exception  */
  YYSYMBOL_escape_or_exception = 2115,     /* escape_or_exception  */
  YYSYMBOL__accp_not_on_exception = 2116,  /* _accp_not_on_exception  */
  YYSYMBOL_accp_not_on_exception = 2117,   /* accp_not_on_exception  */
  YYSYMBOL_not_escape_or_not_exception = 2118, /* not_escape_or_not_exception  */
  YYSYMBOL__common_exception_phrases = 2119, /* _common_exception_phrases  */
  YYSYMBOL__common_on_exception = 2120,    /* _common_on_exception  */
  YYSYMBOL_common_on_exception = 2121,     /* common_on_exception  */
  YYSYMBOL__common_not_on_exception = 2122, /* _common_not_on_exception  */
  YYSYMBOL_common_not_on_exception = 2123, /* common_not_on_exception  */
  YYSYMBOL_on_size_error_phrases = 2124,   /* on_size_error_phrases  */
  YYSYMBOL__on_size_error = 2125,          /* _on_size_error  */
  YYSYMBOL_on_size_error = 2126,           /* on_size_error  */
  YYSYMBOL__not_on_size_error = 2127,      /* _not_on_size_error  */
  YYSYMBOL_not_on_size_error = 2128,       /* not_on_size_error  */
  YYSYMBOL__on_overflow_phrases = 2129,    /* _on_overflow_phrases  */
  YYSYMBOL__on_overflow = 2130,            /* _on_overflow  */
  YYSYMBOL_on_overflow = 2131,             /* on_overflow  */
  YYSYMBOL__not_on_overflow = 2132,        /* _not_on_overflow  */
  YYSYMBOL_not_on_overflow = 2133,         /* not_on_overflow  */
  YYSYMBOL_return_at_end = 2134,           /* return_at_end  */
  YYSYMBOL_read_at_end = 2135,             /* read_at_end  */
  YYSYMBOL__at_end_clause = 2136,          /* _at_end_clause  */
  YYSYMBOL_at_end_clause = 2137,           /* at_end_clause  */
  YYSYMBOL__not_at_end_clause = 2138,      /* _not_at_end_clause  */
  YYSYMBOL_not_at_end_clause = 2139,       /* not_at_end_clause  */
  YYSYMBOL_at_eop_clauses = 2140,          /* at_eop_clauses  */
  YYSYMBOL__at_eop_clause = 2141,          /* _at_eop_clause  */
  YYSYMBOL_at_eop_clause = 2142,           /* at_eop_clause  */
  YYSYMBOL__not_at_eop_clause = 2143,      /* _not_at_eop_clause  */
  YYSYMBOL_not_at_eop_clause = 2144,       /* not_at_eop_clause  */
  YYSYMBOL__invalid_key_phrases = 2145,    /* _invalid_key_phrases  */
  YYSYMBOL_invalid_key_phrases = 2146,     /* invalid_key_phrases  */
  YYSYMBOL__invalid_key_sentence = 2147,   /* _invalid_key_sentence  */
  YYSYMBOL_invalid_key_sentence = 2148,    /* invalid_key_sentence  */
  YYSYMBOL__not_invalid_key_sentence = 2149, /* _not_invalid_key_sentence  */
  YYSYMBOL_not_invalid_key_sentence = 2150, /* not_invalid_key_sentence  */
  YYSYMBOL__thread_start = 2151,           /* _thread_start  */
  YYSYMBOL__thread_handle = 2152,          /* _thread_handle  */
  YYSYMBOL_thread_reference_optional = 2153, /* thread_reference_optional  */
  YYSYMBOL__scroll_lines = 2154,           /* _scroll_lines  */
  YYSYMBOL__count_in = 2155,               /* _count_in  */
  YYSYMBOL_condition = 2156,               /* condition  */
  YYSYMBOL_expr = 2157,                    /* expr  */
  YYSYMBOL_partial_expr = 2158,            /* partial_expr  */
  YYSYMBOL_2159_172 = 2159,                /* $@172  */
  YYSYMBOL_expr_tokens = 2160,             /* expr_tokens  */
  YYSYMBOL_expr_token = 2161,              /* expr_token  */
  YYSYMBOL_condition_no_is = 2162,         /* condition_no_is  */
  YYSYMBOL_expr_no_is = 2163,              /* expr_no_is  */
  YYSYMBOL_partial_expr_no_is = 2164,      /* partial_expr_no_is  */
  YYSYMBOL_2165_173 = 2165,                /* $@173  */
  YYSYMBOL_expr_tokens_no_is = 2166,       /* expr_tokens_no_is  */
  YYSYMBOL_expr_token_no_is = 2167,        /* expr_token_no_is  */
  YYSYMBOL__not_expr = 2168,               /* _not_expr  */
  YYSYMBOL_not_expr = 2169,                /* not_expr  */
  YYSYMBOL_condition_or_class = 2170,      /* condition_or_class  */
  YYSYMBOL_eq = 2171,                      /* eq  */
  YYSYMBOL_gt = 2172,                      /* gt  */
  YYSYMBOL_lt = 2173,                      /* lt  */
  YYSYMBOL_ge = 2174,                      /* ge  */
  YYSYMBOL_le = 2175,                      /* le  */
  YYSYMBOL_exp_list = 2176,                /* exp_list  */
  YYSYMBOL__e_sep = 2177,                  /* _e_sep  */
  YYSYMBOL_exp = 2178,                     /* exp  */
  YYSYMBOL_exp_term = 2179,                /* exp_term  */
  YYSYMBOL_exp_factor = 2180,              /* exp_factor  */
  YYSYMBOL_exp_unary = 2181,               /* exp_unary  */
  YYSYMBOL_exp_atom = 2182,                /* exp_atom  */
  YYSYMBOL_line_linage_page_counter = 2183, /* line_linage_page_counter  */
  YYSYMBOL_arithmetic_x_list = 2184,       /* arithmetic_x_list  */
  YYSYMBOL_arithmetic_x = 2185,            /* arithmetic_x  */
  YYSYMBOL_record_name = 2186,             /* record_name  */
  YYSYMBOL_file_or_record_name = 2187,     /* file_or_record_name  */
  YYSYMBOL_table_name = 2188,              /* table_name  */
  YYSYMBOL_file_name_list = 2189,          /* file_name_list  */
  YYSYMBOL_file_file_name_list = 2190,     /* file_file_name_list  */
  YYSYMBOL_file_name = 2191,               /* file_name  */
  YYSYMBOL_cd_name = 2192,                 /* cd_name  */
  YYSYMBOL_report_name = 2193,             /* report_name  */
  YYSYMBOL_mnemonic_name_list = 2194,      /* mnemonic_name_list  */
  YYSYMBOL_mnemonic_name = 2195,           /* mnemonic_name  */
  YYSYMBOL_entry_name_list = 2196,         /* entry_name_list  */
  YYSYMBOL_entry_name = 2197,              /* entry_name  */
  YYSYMBOL_procedure_name_list = 2198,     /* procedure_name_list  */
  YYSYMBOL_procedure_name = 2199,          /* procedure_name  */
  YYSYMBOL_label = 2200,                   /* label  */
  YYSYMBOL_integer_label = 2201,           /* integer_label  */
  YYSYMBOL_reference_list = 2202,          /* reference_list  */
  YYSYMBOL_reference = 2203,               /* reference  */
  YYSYMBOL__reference = 2204,              /* _reference  */
  YYSYMBOL_single_reference_list = 2205,   /* single_reference_list  */
  YYSYMBOL_single_reference = 2206,        /* single_reference  */
  YYSYMBOL_optional_reference_list = 2207, /* optional_reference_list  */
  YYSYMBOL_optional_reference = 2208,      /* optional_reference  */
  YYSYMBOL_reference_or_literal = 2209,    /* reference_or_literal  */
  YYSYMBOL_undefined_word = 2210,          /* undefined_word  */
  YYSYMBOL_unique_word = 2211,             /* unique_word  */
  YYSYMBOL_target_x_list = 2212,           /* target_x_list  */
  YYSYMBOL_target_x = 2213,                /* target_x  */
  YYSYMBOL__x_list = 2214,                 /* _x_list  */
  YYSYMBOL_x_list = 2215,                  /* x_list  */
  YYSYMBOL_x = 2216,                       /* x  */
  YYSYMBOL_call_x = 2217,                  /* call_x  */
  YYSYMBOL_x_common = 2218,                /* x_common  */
  YYSYMBOL_length_of_register = 2219,      /* length_of_register  */
  YYSYMBOL_report_x_list = 2220,           /* report_x_list  */
  YYSYMBOL_expr_x = 2221,                  /* expr_x  */
  YYSYMBOL_arith_x = 2222,                 /* arith_x  */
  YYSYMBOL_arith_nonzero_x = 2223,         /* arith_nonzero_x  */
  YYSYMBOL_numeric_literal = 2224,         /* numeric_literal  */
  YYSYMBOL_non_numeric_literal = 2225,     /* non_numeric_literal  */
  YYSYMBOL_nonzero_numeric_literal = 2226, /* nonzero_numeric_literal  */
  YYSYMBOL_prog_or_entry = 2227,           /* prog_or_entry  */
  YYSYMBOL_alnum_or_id = 2228,             /* alnum_or_id  */
  YYSYMBOL_simple_display_value = 2229,    /* simple_display_value  */
  YYSYMBOL_inspect_from = 2230,            /* inspect_from  */
  YYSYMBOL_inspect_to = 2231,              /* inspect_to  */
  YYSYMBOL_simple_value = 2232,            /* simple_value  */
  YYSYMBOL_simple_all_value = 2233,        /* simple_all_value  */
  YYSYMBOL_id_or_lit = 2234,               /* id_or_lit  */
  YYSYMBOL_id_or_lit_or_func = 2235,       /* id_or_lit_or_func  */
  YYSYMBOL_id_or_lit_or_length_or_func = 2236, /* id_or_lit_or_length_or_func  */
  YYSYMBOL_num_id_or_lit = 2237,           /* num_id_or_lit  */
  YYSYMBOL_positive_id_or_lit = 2238,      /* positive_id_or_lit  */
  YYSYMBOL_pos_num_id_or_lit_or_zero = 2239, /* pos_num_id_or_lit_or_zero  */
  YYSYMBOL_pos_num_id_or_lit = 2240,       /* pos_num_id_or_lit  */
  YYSYMBOL_from_parameter = 2241,          /* from_parameter  */
  YYSYMBOL_sub_identifier = 2242,          /* sub_identifier  */
  YYSYMBOL_table_identifier = 2243,        /* table_identifier  */
  YYSYMBOL_sub_identifier_1 = 2244,        /* sub_identifier_1  */
  YYSYMBOL_display_identifier = 2245,      /* display_identifier  */
  YYSYMBOL_numeric_identifier = 2246,      /* numeric_identifier  */
  YYSYMBOL_identifier_or_file_name = 2247, /* identifier_or_file_name  */
  YYSYMBOL_identifier_field = 2248,        /* identifier_field  */
  YYSYMBOL_type_name = 2249,               /* type_name  */
  YYSYMBOL_identifier = 2250,              /* identifier  */
  YYSYMBOL_identifier_1 = 2251,            /* identifier_1  */
  YYSYMBOL_identifier_list = 2252,         /* identifier_list  */
  YYSYMBOL_validate_for_identifier_list = 2253, /* validate_for_identifier_list  */
  YYSYMBOL_for_identifier = 2254,          /* for_identifier  */
  YYSYMBOL_target_identifier = 2255,       /* target_identifier  */
  YYSYMBOL_target_identifier_1 = 2256,     /* target_identifier_1  */
  YYSYMBOL_target_identifier_single = 2257, /* target_identifier_single  */
  YYSYMBOL_display_identifier_or_alphabet_name = 2258, /* display_identifier_or_alphabet_name  */
  YYSYMBOL_qualified_word = 2259,          /* qualified_word  */
  YYSYMBOL_unqualified_word = 2260,        /* unqualified_word  */
  YYSYMBOL_2261_174 = 2261,                /* $@174  */
  YYSYMBOL_unqualified_word_check = 2262,  /* unqualified_word_check  */
  YYSYMBOL_subref = 2263,                  /* subref  */
  YYSYMBOL_refmod = 2264,                  /* refmod  */
  YYSYMBOL_integer = 2265,                 /* integer  */
  YYSYMBOL_symbolic_integer = 2266,        /* symbolic_integer  */
  YYSYMBOL_unsigned_pos_integer = 2267,    /* unsigned_pos_integer  */
  YYSYMBOL_integer_or_zero = 2268,         /* integer_or_zero  */
  YYSYMBOL_class_value = 2269,             /* class_value  */
  YYSYMBOL_figurative_constant = 2270,     /* figurative_constant  */
  YYSYMBOL_literal = 2271,                 /* literal  */
  YYSYMBOL_basic_literal = 2272,           /* basic_literal  */
  YYSYMBOL_basic_value = 2273,             /* basic_value  */
  YYSYMBOL_zero_spaces_high_low_values = 2274, /* zero_spaces_high_low_values  */
  YYSYMBOL_function = 2275,                /* function  */
  YYSYMBOL_func_no_parm = 2276,            /* func_no_parm  */
  YYSYMBOL_func_one_parm = 2277,           /* func_one_parm  */
  YYSYMBOL_func_multi_parm = 2278,         /* func_multi_parm  */
  YYSYMBOL_func_refmod = 2279,             /* func_refmod  */
  YYSYMBOL_func_args = 2280,               /* func_args  */
  YYSYMBOL_trim_args = 2281,               /* trim_args  */
  YYSYMBOL_length_arg = 2282,              /* length_arg  */
  YYSYMBOL_2283_175 = 2283,                /* $@175  */
  YYSYMBOL_numvalc_args = 2284,            /* numvalc_args  */
  YYSYMBOL_locale_dt_args = 2285,          /* locale_dt_args  */
  YYSYMBOL_formatted_datetime_args = 2286, /* formatted_datetime_args  */
  YYSYMBOL_formatted_time_args = 2287,     /* formatted_time_args  */
  YYSYMBOL_not_const_word = 2288,          /* not_const_word  */
  YYSYMBOL_flag_all = 2289,                /* flag_all  */
  YYSYMBOL_flag_duplicates = 2290,         /* flag_duplicates  */
  YYSYMBOL__flag_initialized = 2291,       /* _flag_initialized  */
  YYSYMBOL__flag_initialized_to = 2292,    /* _flag_initialized_to  */
  YYSYMBOL__to_init_val = 2293,            /* _to_init_val  */
  YYSYMBOL__flag_next = 2294,              /* _flag_next  */
  YYSYMBOL__flag_not = 2295,               /* _flag_not  */
  YYSYMBOL_flag_optional = 2296,           /* flag_optional  */
  YYSYMBOL_flag_rounded = 2297,            /* flag_rounded  */
  YYSYMBOL_round_mode = 2298,              /* round_mode  */
  YYSYMBOL_round_choice = 2299,            /* round_choice  */
  YYSYMBOL_flag_separate = 2300,           /* flag_separate  */
  YYSYMBOL__from_idx_to_idx = 2301,        /* _from_idx_to_idx  */
  YYSYMBOL__dest_index = 2302,             /* _dest_index  */
  YYSYMBOL_error_stmt_recover = 2303,      /* error_stmt_recover  */
  YYSYMBOL_verb = 2304,                    /* verb  */
  YYSYMBOL_scope_terminator = 2305,        /* scope_terminator  */
  YYSYMBOL__dot = 2306,                    /* _dot  */
  YYSYMBOL__dot_or_else_end_of_file_control = 2307, /* _dot_or_else_end_of_file_control  */
  YYSYMBOL_level_number_in_area_a = 2308,  /* level_number_in_area_a  */
  YYSYMBOL__dot_or_else_end_of_file_description = 2309, /* _dot_or_else_end_of_file_description  */
  YYSYMBOL__dot_or_else_end_of_communication_description = 2310, /* _dot_or_else_end_of_communication_description  */
  YYSYMBOL__dot_or_else_end_of_report_description = 2311, /* _dot_or_else_end_of_report_description  */
  YYSYMBOL__dot_or_else_end_of_report_group_description = 2312, /* _dot_or_else_end_of_report_group_description  */
  YYSYMBOL__dot_or_else_end_of_record_description = 2313, /* _dot_or_else_end_of_record_description  */
  YYSYMBOL__file_control_end_delimiter = 2314, /* _file_control_end_delimiter  */
  YYSYMBOL__file_description_end_delimiter = 2315, /* _file_description_end_delimiter  */
  YYSYMBOL__record_description_end_delimiter = 2316, /* _record_description_end_delimiter  */
  YYSYMBOL__dot_or_else_area_a = 2317,     /* _dot_or_else_area_a  */
  YYSYMBOL__advancing = 2318,              /* _advancing  */
  YYSYMBOL__after = 2319,                  /* _after  */
  YYSYMBOL__are = 2320,                    /* _are  */
  YYSYMBOL__area = 2321,                   /* _area  */
  YYSYMBOL__areas = 2322,                  /* _areas  */
  YYSYMBOL__as = 2323,                     /* _as  */
  YYSYMBOL__at = 2324,                     /* _at  */
  YYSYMBOL__before = 2325,                 /* _before  */
  YYSYMBOL__binary = 2326,                 /* _binary  */
  YYSYMBOL__box = 2327,                    /* _box  */
  YYSYMBOL__by = 2328,                     /* _by  */
  YYSYMBOL__character = 2329,              /* _character  */
  YYSYMBOL__characters = 2330,             /* _characters  */
  YYSYMBOL__collating = 2331,              /* _collating  */
  YYSYMBOL__contains = 2332,               /* _contains  */
  YYSYMBOL__controls = 2333,               /* _controls  */
  YYSYMBOL__control = 2334,                /* _control  */
  YYSYMBOL__data = 2335,                   /* _data  */
  YYSYMBOL__end_of = 2336,                 /* _end_of  */
  YYSYMBOL__erase = 2337,                  /* _erase  */
  YYSYMBOL__every = 2338,                  /* _every  */
  YYSYMBOL__file = 2339,                   /* _file  */
  YYSYMBOL__for = 2340,                    /* _for  */
  YYSYMBOL__from = 2341,                   /* _from  */
  YYSYMBOL__in = 2342,                     /* _in  */
  YYSYMBOL__in_equal = 2343,               /* _in_equal  */
  YYSYMBOL__in_order = 2344,               /* _in_order  */
  YYSYMBOL__index = 2345,                  /* _index  */
  YYSYMBOL__indicate = 2346,               /* _indicate  */
  YYSYMBOL__initial = 2347,                /* _initial  */
  YYSYMBOL__into = 2348,                   /* _into  */
  YYSYMBOL__is = 2349,                     /* _is  */
  YYSYMBOL__is_equal = 2350,               /* _is_equal  */
  YYSYMBOL__is_are = 2351,                 /* _is_are  */
  YYSYMBOL__is_are_equal = 2352,           /* _is_are_equal  */
  YYSYMBOL__is_in = 2353,                  /* _is_in  */
  YYSYMBOL__key = 2354,                    /* _key  */
  YYSYMBOL__line = 2355,                   /* _line  */
  YYSYMBOL__line_or_lines = 2356,          /* _line_or_lines  */
  YYSYMBOL__limits = 2357,                 /* _limits  */
  YYSYMBOL__lines = 2358,                  /* _lines  */
  YYSYMBOL__lock = 2359,                   /* _lock  */
  YYSYMBOL__message = 2360,                /* _message  */
  YYSYMBOL__mode = 2361,                   /* _mode  */
  YYSYMBOL__new = 2362,                    /* _new  */
  YYSYMBOL__number = 2363,                 /* _number  */
  YYSYMBOL__number_or_numbers = 2364,      /* _number_or_numbers  */
  YYSYMBOL__of = 2365,                     /* _of  */
  YYSYMBOL__on = 2366,                     /* _on  */
  YYSYMBOL__on_for = 2367,                 /* _on_for  */
  YYSYMBOL__onoff_status = 2368,           /* _onoff_status  */
  YYSYMBOL__other = 2369,                  /* _other  */
  YYSYMBOL__others = 2370,                 /* _others  */
  YYSYMBOL__procedure = 2371,              /* _procedure  */
  YYSYMBOL__program = 2372,                /* _program  */
  YYSYMBOL__protected = 2373,              /* _protected  */
  YYSYMBOL__record = 2374,                 /* _record  */
  YYSYMBOL__records = 2375,                /* _records  */
  YYSYMBOL__right = 2376,                  /* _right  */
  YYSYMBOL__sign = 2377,                   /* _sign  */
  YYSYMBOL__signed = 2378,                 /* _signed  */
  YYSYMBOL__sign_is = 2379,                /* _sign_is  */
  YYSYMBOL__size = 2380,                   /* _size  */
  YYSYMBOL__standard = 2381,               /* _standard  */
  YYSYMBOL__status = 2382,                 /* _status  */
  YYSYMBOL__symbolic = 2383,               /* _symbolic  */
  YYSYMBOL__tape = 2384,                   /* _tape  */
  YYSYMBOL__terminal = 2385,               /* _terminal  */
  YYSYMBOL__then = 2386,                   /* _then  */
  YYSYMBOL__times = 2387,                  /* _times  */
  YYSYMBOL__to = 2388,                     /* _to  */
  YYSYMBOL__up = 2389,                     /* _up  */
  YYSYMBOL__when = 2390,                   /* _when  */
  YYSYMBOL__when_set_to = 2391,            /* _when_set_to  */
  YYSYMBOL__with = 2392,                   /* _with  */
  YYSYMBOL__with_for = 2393,               /* _with_for  */
  YYSYMBOL__exception = 2394,              /* _exception  */
  YYSYMBOL_at_end = 2395,                  /* at_end  */
  YYSYMBOL_on_escape = 2396,               /* on_escape  */
  YYSYMBOL_on_exception = 2397,            /* on_exception  */
  YYSYMBOL_column_or_col = 2398,           /* column_or_col  */
  YYSYMBOL_columns_or_cols = 2399,         /* columns_or_cols  */
  YYSYMBOL_column_or_cols = 2400,          /* column_or_cols  */
  YYSYMBOL_column_or_col_or_position_or_pos = 2401, /* column_or_col_or_position_or_pos  */
  YYSYMBOL_comp_equal = 2402,              /* comp_equal  */
  YYSYMBOL_exception_or_error = 2403,      /* exception_or_error  */
  YYSYMBOL_file_limit_or_limits = 2404,    /* file_limit_or_limits  */
  YYSYMBOL_in_of = 2405,                   /* in_of  */
  YYSYMBOL_label_option = 2406,            /* label_option  */
  YYSYMBOL_line_or_lines = 2407,           /* line_or_lines  */
  YYSYMBOL_lock_records = 2408,            /* lock_records  */
  YYSYMBOL_object_char_or_word_or_modules = 2409, /* object_char_or_word_or_modules  */
  YYSYMBOL_records = 2410,                 /* records  */
  YYSYMBOL_reel_or_unit = 2411,            /* reel_or_unit  */
  YYSYMBOL_size_or_length = 2412,          /* size_or_length  */
  YYSYMBOL_length_of = 2413,               /* length_of  */
  YYSYMBOL_track_or_tracks = 2414,         /* track_or_tracks  */
  YYSYMBOL_using_or_varying = 2415,        /* using_or_varying  */
  YYSYMBOL_detail_keyword = 2416,          /* detail_keyword  */
  YYSYMBOL_ch_keyword = 2417,              /* ch_keyword  */
  YYSYMBOL_cf_keyword = 2418,              /* cf_keyword  */
  YYSYMBOL_ph_keyword = 2419,              /* ph_keyword  */
  YYSYMBOL_pf_keyword = 2420,              /* pf_keyword  */
  YYSYMBOL_rh_keyword = 2421,              /* rh_keyword  */
  YYSYMBOL_rf_keyword = 2422,              /* rf_keyword  */
  YYSYMBOL_control_keyword = 2423          /* control_keyword  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   20486

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  968
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1456
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3467
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4900

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   1222


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  3347,  3347,  3347,  3383,  3384,  3388,  3388,  3398,  3399,
    3403,  3404,  3405,  3406,  3410,  3410,  3422,  3433,  3441,  3445,
    3449,  3450,  3455,  3454,  3468,  3467,  3482,  3480,  3532,  3530,
    3571,  3573,  3573,  3585,  3586,  3589,  3588,  3595,  3597,  3597,
    3605,  3607,  3612,  3614,  3614,  3622,  3624,  3624,  3637,  3641,
    3635,  3653,  3654,  3658,  3658,  3668,  3668,  3672,  3680,  3712,
    3719,  3731,  3742,  3749,  3750,  3757,  3758,  3762,  3763,  3767,
    3771,  3775,  3776,  3783,  3784,  3788,  3792,  3798,  3800,  3808,
    3815,  3817,  3821,  3828,  3832,  3836,  3852,  3855,  3865,  3867,
    3874,  3878,  3882,  3888,  3890,  3897,  3901,  3905,  3909,  3918,
    3923,  3924,  3927,  3929,  3938,  3942,  3943,  3946,  3948,  3958,
    3960,  3964,  3965,  3969,  3970,  3971,  3972,  3973,  3978,  3979,
    3984,  3983,  3994,  3995,  3998,  3999,  4012,  4011,  4025,  4026,
    4027,  4028,  4032,  4033,  4037,  4038,  4039,  4040,  4044,  4052,
    4061,  4060,  4068,  4072,  4078,  4082,  4087,  4094,  4104,  4118,
    4129,  4133,  4137,  4141,  4148,  4149,  4153,  4154,  4159,  4158,
    4171,  4173,  4174,  4181,  4182,  4186,  4190,  4196,  4197,  4204,
    4211,  4216,  4227,  4242,  4245,  4246,  4249,  4253,  4254,  4255,
    4256,  4257,  4258,  4259,  4260,  4261,  4262,  4263,  4264,  4265,
    4266,  4267,  4275,  4274,  4293,  4295,  4298,  4309,  4330,  4338,
    4341,  4342,  4346,  4353,  4368,  4389,  4388,  4413,  4412,  4421,
    4420,  4430,  4432,  4436,  4440,  4441,  4447,  4453,  4459,  4468,
    4469,  4476,  4483,  4493,  4499,  4507,  4517,  4521,  4528,  4532,
    4537,  4536,  4547,  4551,  4558,  4559,  4560,  4561,  4562,  4563,
    4567,  4568,  4573,  4576,  4580,  4588,  4591,  4602,  4628,  4636,
    4640,  4651,  4671,  4679,  4690,  4691,  4698,  4712,  4713,  4717,
    4736,  4767,  4768,  4772,  4776,  4797,  4819,  4818,  4842,  4849,
    4861,  4928,  4931,  4940,  4959,  4975,  4993,  5011,  5028,  5046,
    5045,  5073,  5079,  5080,  5081,  5090,  5091,  5099,  5100,  5104,
    5106,  5104,  5152,  5153,  5159,  5160,  5169,  5170,  5171,  5172,
    5173,  5174,  5175,  5176,  5177,  5178,  5179,  5180,  5181,  5182,
    5183,  5184,  5185,  5186,  5187,  5188,  5211,  5221,  5231,  5242,
    5253,  5284,  5287,  5291,  5295,  5299,  5304,  5308,  5316,  5322,
    5328,  5338,  5339,  5340,  5341,  5345,  5346,  5347,  5348,  5349,
    5350,  5351,  5355,  5363,  5367,  5375,  5379,  5386,  5387,  5393,
    5400,  5401,  5402,  5409,  5464,  5467,  5472,  5471,  5483,  5496,
    5499,  5503,  5513,  5524,  5523,  5531,  5535,  5541,  5545,  5550,
    5557,  5567,  5578,  5593,  5604,  5606,  5607,  5613,  5613,  5620,
    5624,  5628,  5635,  5636,  5637,  5641,  5647,  5648,  5652,  5658,
    5659,  5675,  5676,  5680,  5686,  5692,  5698,  5711,  5722,  5721,
    5730,  5741,  5755,  5768,  5784,  5823,  5826,  5833,  5834,  5838,
    5838,  5842,  5847,  5865,  5876,  5883,  5884,  5890,  5903,  5904,
    5905,  5911,  5919,  5920,  5926,  5936,  5946,  5956,  5966,  5967,
    5974,  5982,  5983,  5984,  5991,  5992,  5996,  5997,  5998,  5999,
    6005,  6033,  6034,  6035,  6036,  6042,  6047,  6051,  6055,  6056,
    6063,  6064,  6065,  6066,  6067,  6068,  6069,  6070,  6077,  6076,
    6092,  6093,  6097,  6100,  6101,  6107,  6111,  6115,  6116,  6120,
    6122,  6123,  6131,  6135,  6136,  6140,  6141,  6145,  6146,  6150,
    6151,  6152,  6162,  6159,  6173,  6174,  6177,  6179,  6187,  6188,
    6189,  6197,  6198,  6202,  6222,  6221,  6245,  6252,  6257,  6264,
    6265,  6269,  6279,  6294,  6295,  6296,  6297,  6298,  6299,  6300,
    6301,  6302,  6309,  6316,  6316,  6316,  6322,  6331,  6347,  6359,
    6360,  6364,  6365,  6369,  6370,  6377,  6388,  6393,  6404,  6405,
    6409,  6410,  6416,  6427,  6445,  6446,  6450,  6451,  6452,  6456,
    6463,  6470,  6479,  6488,  6489,  6490,  6491,  6492,  6501,  6502,
    6508,  6547,  6548,  6557,  6572,  6573,  6577,  6591,  6609,  6610,
    6612,  6611,  6629,  6630,  6634,  6649,  6652,  6651,  6673,  6674,
    6678,  6679,  6680,  6683,  6685,  6686,  6690,  6691,  6695,  6696,
    6697,  6698,  6699,  6700,  6701,  6702,  6703,  6704,  6705,  6709,
    6713,  6715,  6719,  6720,  6724,  6725,  6726,  6727,  6728,  6729,
    6730,  6733,  6735,  6736,  6740,  6741,  6745,  6746,  6747,  6748,
    6749,  6750,  6754,  6759,  6760,  6763,  6761,  6778,  6782,  6782,
    6795,  6796,  6800,  6801,  6802,  6804,  6803,  6823,  6840,  6853,
    6859,  6861,  6865,  6872,  6876,  6887,  6890,  6902,  6903,  6905,
    6909,  6913,  6919,  6923,  6927,  6931,  6935,  6939,  6943,  6951,
    6955,  6959,  6963,  6967,  6971,  6982,  6983,  6987,  6988,  6992,
    6993,  6994,  6998,  6999,  7003,  7047,  7050,  7058,  7057,  7071,
    7077,  7081,  7109,  7108,  7123,  7132,  7139,  7150,  7154,  7161,
    7162,  7166,  7167,  7168,  7169,  7170,  7171,  7172,  7173,  7174,
    7175,  7178,  7180,  7184,  7188,  7192,  7193,  7194,  7195,  7196,
    7197,  7198,  7199,  7200,  7201,  7202,  7203,  7204,  7205,  7206,
    7207,  7208,  7209,  7210,  7211,  7212,  7213,  7214,  7215,  7216,
    7217,  7218,  7219,  7220,  7221,  7231,  7252,  7266,  7267,  7270,
    7279,  7298,  7322,  7323,  7333,  7361,  7364,  7372,  7373,  7377,
    7402,  7401,  7413,  7421,  7438,  7450,  7468,  7467,  7478,  7479,
    7485,  7492,  7493,  7494,  7500,  7518,  7517,  7534,  7536,  7550,
    7595,  7598,  7605,  7619,  7630,  7631,  7632,  7666,  7672,  7673,
    7677,  7681,  7686,  7693,  7697,  7702,  7711,  7715,  7719,  7723,
    7727,  7731,  7735,  7739,  7743,  7747,  7751,  7755,  7760,  7765,
    7769,  7773,  7777,  7782,  7786,  7791,  7795,  7800,  7805,  7810,
    7814,  7818,  7826,  7830,  7834,  7842,  7846,  7850,  7854,  7858,
    7862,  7866,  7870,  7874,  7882,  7890,  7894,  7898,  7902,  7906,
    7910,  7919,  7926,  7928,  7929,  7930,  7933,  7935,  7939,  7940,
    7944,  7945,  7948,  7950,  7951,  7952,  7953,  7954,  7955,  7958,
    7960,  7966,  7973,  7986,  7995,  7996,  8005,  8012,  8024,  8042,
    8043,  8047,  8048,  8052,  8053,  8056,  8057,  8062,  8063,  8070,
    8071,  8077,  8079,  8081,  8080,  8085,  8086,  8090,  8112,  8113,
    8117,  8142,  8143,  8146,  8148,  8152,  8159,  8160,  8165,  8176,
    8187,  8207,  8208,  8209,  8216,  8227,  8254,  8268,  8276,  8287,
    8303,  8304,  8308,  8340,  8344,  8345,  8349,  8356,  8357,  8358,
    8363,  8367,  8375,  8376,  8380,  8381,  8385,  8390,  8400,  8399,
    8407,  8419,  8420,  8424,  8425,  8429,  8431,  8432,  8436,  8447,
    8454,  8455,  8458,  8460,  8469,  8477,  8478,  8482,  8483,  8484,
    8485,  8491,  8498,  8499,  8505,  8512,  8513,  8514,  8515,  8516,
    8517,  8518,  8524,  8535,  8544,  8554,  8563,  8578,  8601,  8620,
    8621,  8623,  8622,  8644,  8645,  8647,  8646,  8662,  8663,  8665,
    8663,  8675,  8676,  8682,  8684,  8682,  8710,  8711,  8712,  8719,
    8725,  8730,  8731,  8737,  8744,  8745,  8746,  8750,  8757,  8758,
    8762,  8772,  8811,  8822,  8823,  8837,  8850,  8851,  8854,  8855,
    8860,  8861,  8862,  8863,  8864,  8865,  8877,  8891,  8905,  8919,
    8933,  8946,  8947,  8952,  8951,  8964,  8975,  8976,  8980,  8981,
    8982,  8983,  8984,  8985,  8986,  8987,  8988,  8989,  8990,  8991,
    8992,  8993,  8994,  8995,  8996,  9000,  9007,  9011,  9015,  9016,
    9017,  9024,  9028,  9036,  9039,  9047,  9057,  9058,  9063,  9066,
    9071,  9075,  9083,  9090,  9099,  9104,  9111,  9112,  9113,  9117,
    9124,  9125,  9126,  9133,  9137,  9144,  9149,  9155,  9162,  9168,
    9178,  9182,  9189,  9191,  9195,  9199,  9203,  9207,  9214,  9215,
    9220,  9257,  9260,  9268,  9271,  9278,  9289,  9290,  9293,  9295,
    9299,  9303,  9317,  9332,  9335,  9337,  9341,  9345,  9349,  9356,
    9378,  9382,  9383,  9387,  9408,  9416,  9425,  9426,  9428,  9426,
    9446,  9447,  9451,  9452,  9456,  9459,  9458,  9509,  9520,  9508,
    9564,  9584,  9586,  9590,  9595,  9600,  9604,  9608,  9613,  9618,
    9623,  9628,  9637,  9641,  9645,  9649,  9653,  9659,  9663,  9668,
    9674,  9678,  9683,  9688,  9693,  9698,  9703,  9708,  9717,  9721,
    9725,  9731,  9735,  9739,  9743,  9747,  9751,  9755,  9759,  9770,
    9775,  9780,  9784,  9785,  9786,  9787,  9788,  9789,  9790,  9791,
    9800,  9805,  9816,  9829,  9830,  9834,  9835,  9842,  9843,  9844,
    9845,  9846,  9847,  9848,  9849,  9850,  9853,  9856,  9857,  9858,
    9859,  9860,  9861,  9868,  9869,  9874,  9875,  9878,  9880,  9884,
    9885,  9889,  9890,  9891,  9895,  9896,  9900,  9901,  9905,  9906,
    9907,  9908,  9909,  9912,  9913,  9914,  9915,  9916,  9918,  9919,
    9921,  9922,  9926,  9927,  9928,  9929,  9931,  9933,  9935,  9936,
    9937,  9938,  9939,  9940,  9941,  9942,  9943,  9949,  9950,  9951,
    9952,  9953,  9954,  9955,  9956,  9957,  9958,  9962,  9963,  9968,
    9969,  9970,  9971,  9972,  9976,  9984,  9985,  9986,  9987,  9988,
    9989,  9990,  9991,  9992,  9993,  9994,  9996,  9998,  9999, 10000,
   10004, 10005, 10006, 10007, 10008, 10009, 10010, 10011, 10012, 10013,
   10018, 10019, 10020, 10021, 10022, 10023, 10024, 10025, 10026, 10027,
   10032, 10033, 10044, 10045, 10069, 10070, 10087, 10090, 10091, 10092,
   10095, 10099, 10100, 10101, 10102, 10103, 10104, 10105, 10106, 10107,
   10108, 10109, 10110, 10111, 10112, 10113, 10114, 10120, 10121, 10122,
   10142, 10143, 10144, 10145, 10146, 10147, 10148, 10149, 10153, 10154,
   10155, 10156, 10157, 10158, 10164, 10165, 10166, 10167, 10168, 10169,
   10170, 10171, 10176, 10178, 10179, 10180, 10185, 10186, 10187, 10191,
   10192, 10193, 10194, 10195, 10196, 10207, 10208, 10209, 10210, 10215,
   10218, 10219, 10220, 10221, 10222, 10224, 10229, 10230, 10231, 10237,
   10238, 10239, 10240, 10241, 10242, 10243, 10244, 10245, 10246, 10250,
   10251, 10252, 10253, 10254, 10255, 10256, 10257, 10258, 10259, 10260,
   10261, 10262, 10263, 10265, 10266, 10267, 10268, 10269, 10270, 10271,
   10272, 10273, 10274, 10275, 10276, 10277, 10278, 10279, 10280, 10281,
   10284, 10285, 10286, 10294, 10295, 10296, 10300, 10301, 10302, 10306,
   10307, 10310, 10311, 10312, 10315, 10324, 10325, 10326, 10327, 10328,
   10329, 10330, 10331, 10332, 10333, 10334, 10335, 10336, 10338, 10339,
   10340, 10341, 10342, 10343, 10344, 10345, 10346, 10347, 10354, 10358,
   10362, 10363, 10364, 10365, 10366, 10367, 10368, 10369, 10375, 10376,
   10377, 10382, 10383, 10388, 10393, 10394, 10398, 10399, 10404, 10405,
   10409, 10410, 10411, 10416, 10417, 10421, 10422, 10426, 10427, 10431,
   10435, 10435, 10439, 10443, 10443, 10447, 10451, 10452, 10456, 10457,
   10461, 10469, 10471, 10475, 10482, 10492, 10495, 10499, 10506, 10518,
   10524, 10526, 10533, 10542, 10546, 10548, 10558, 10583, 10546, 10607,
   10607, 10643, 10647, 10646, 10660, 10659, 10679, 10680, 10685, 10707,
   10709, 10713, 10724, 10726, 10730, 10738, 10747, 10755, 10761, 10765,
   10809, 10811, 10819, 10822, 10835, 10840, 10850, 10885, 10887, 10894,
   10896, 10886, 10927, 10928, 10932, 10933, 10935, 10934, 10953, 10954,
   10965, 10969, 10978, 10977, 11023, 11024, 11028, 11073, 11096, 11099,
   11128, 11134, 11127, 11150, 11150, 11189, 11197, 11198, 11199, 11200,
   11201, 11202, 11203, 11204, 11205, 11206, 11207, 11208, 11209, 11210,
   11211, 11212, 11213, 11214, 11215, 11216, 11217, 11218, 11219, 11220,
   11221, 11222, 11223, 11224, 11225, 11226, 11228, 11229, 11230, 11231,
   11232, 11233, 11234, 11235, 11236, 11237, 11238, 11239, 11240, 11241,
   11242, 11244, 11245, 11246, 11247, 11248, 11249, 11250, 11251, 11252,
   11253, 11254, 11255, 11256, 11257, 11258, 11259, 11260, 11261, 11262,
   11263, 11265, 11264, 11280, 11292, 11291, 11302, 11301, 11336, 11335,
   11346, 11350, 11354, 11360, 11366, 11371, 11376, 11381, 11386, 11392,
   11398, 11402, 11408, 11412, 11417, 11421, 11425, 11429, 11433, 11437,
   11441, 11445, 11459, 11466, 11467, 11474, 11474, 11485, 11487, 11491,
   11495, 11499, 11506, 11510, 11514, 11521, 11522, 11526, 11528, 11532,
   11533, 11537, 11538, 11542, 11546, 11547, 11556, 11557, 11562, 11563,
   11567, 11568, 11572, 11588, 11604, 11617, 11625, 11633, 11640, 11646,
   11652, 11657, 11663, 11668, 11673, 11686, 11691, 11696, 11702, 11708,
   11714, 11721, 11725, 11729, 11733, 11737, 11748, 11753, 11759, 11764,
   11769, 11774, 11780, 11786, 11791, 11797, 11803, 11809, 11816, 11821,
   11826, 11833, 11840, 11846, 11849, 11849, 11853, 11864, 11865, 11866,
   11870, 11871, 11872, 11876, 11877, 11881, 11885, 11904, 11903, 11912,
   11916, 11923, 11927, 11935, 11936, 11940, 11944, 11955, 11954, 11964,
   11968, 11979, 11981, 11994, 11995, 12003, 12002, 12011, 12012, 12016,
   12022, 12022, 12029, 12028, 12045, 12044, 12128, 12132, 12131, 12147,
   12151, 12155, 12163, 12166, 12174, 12182, 12186, 12190, 12194, 12198,
   12217, 12223, 12243, 12247, 12257, 12261, 12266, 12270, 12269, 12286,
   12287, 12292, 12300, 12304, 12326, 12328, 12332, 12345, 12362, 12365,
   12369, 12373, 12378, 12401, 12402, 12406, 12407, 12411, 12415, 12419,
   12430, 12434, 12441, 12445, 12453, 12457, 12464, 12471, 12475, 12486,
   12485, 12497, 12498, 12507, 12511, 12518, 12519, 12529, 12528, 12536,
   12537, 12541, 12548, 12556, 12557, 12558, 12559, 12560, 12565, 12564,
   12576, 12577, 12585, 12584, 12593, 12600, 12604, 12614, 12626, 12625,
   12647, 12650, 12650, 12665, 12664, 12673, 12680, 12691, 12690, 12699,
   12703, 12710, 12717, 12725, 12729, 12740, 12739, 12748, 12751, 12753,
   12759, 12761, 12762, 12763, 12764, 12772, 12771, 12783, 12787, 12791,
   12795, 12799, 12800, 12804, 12805, 12806, 12807, 12808, 12809, 12813,
   12821, 12832, 12833, 12838, 12837, 12884, 12888, 12894, 12896, 12900,
   12901, 12905, 12906, 12910, 12914, 12919, 12923, 12924, 12929, 12932,
   12936, 12940, 12944, 12948, 12955, 12956, 12961, 12960, 12977, 12984,
   12984, 12996, 13000, 13007, 13008, 13009, 13019, 13018, 13036, 13038,
   13042, 13043, 13047, 13051, 13052, 13053, 13054, 13059, 13064, 13058,
   13078, 13079, 13084, 13091, 13083, 13110, 13109, 13132, 13133, 13134,
   13138, 13139, 13144, 13147, 13154, 13167, 13179, 13186, 13187, 13193,
   13194, 13198, 13199, 13200, 13201, 13202, 13203, 13207, 13210, 13214,
   13215, 13216, 13220, 13221, 13222, 13223, 13227, 13228, 13233, 13234,
   13238, 13248, 13264, 13269, 13275, 13281, 13286, 13291, 13297, 13303,
   13309, 13315, 13322, 13326, 13330, 13334, 13338, 13343, 13348, 13353,
   13358, 13364, 13369, 13374, 13381, 13391, 13395, 13406, 13405, 13414,
   13418, 13422, 13426, 13430, 13437, 13441, 13452, 13451, 13461, 13464,
   13463, 13471, 13470, 13480, 13504, 13517, 13516, 13543, 13553, 13554,
   13559, 13570, 13581, 13595, 13603, 13611, 13612, 13617, 13623, 13633,
   13645, 13651, 13661, 13674, 13673, 13685, 13683, 13697, 13698, 13703,
   13778, 13779, 13780, 13781, 13785, 13786, 13790, 13794, 13804, 13803,
   13817, 13816, 13857, 13857, 13858, 13858, 13861, 13870, 13881, 13882,
   13890, 13889, 13901, 13905, 13923, 13937, 13960, 13983, 14004, 14027,
   14031, 14039, 14040, 14050, 14049, 14058, 14069, 14068, 14077, 14092,
   14091, 14104, 14109, 14120, 14124, 14135, 14135, 14150, 14149, 14158,
   14162, 14168, 14175, 14178, 14185, 14191, 14197, 14202, 14214, 14213,
   14221, 14229, 14230, 14234, 14235, 14236, 14241, 14244, 14251, 14255,
   14263, 14270, 14271, 14272, 14273, 14274, 14275, 14276, 14288, 14291,
   14301, 14300, 14308, 14317, 14330, 14329, 14341, 14342, 14349, 14348,
   14357, 14366, 14367, 14371, 14372, 14373, 14377, 14378, 14379, 14380,
   14387, 14386, 14396, 14395, 14445, 14476, 14477, 14478, 14482, 14483,
   14484, 14485, 14489, 14490, 14494, 14501, 14516, 14515, 14536, 14546,
   14554, 14558, 14565, 14570, 14575, 14580, 14585, 14590, 14598, 14599,
   14603, 14608, 14614, 14616, 14617, 14618, 14619, 14623, 14651, 14654,
   14658, 14662, 14666, 14673, 14680, 14688, 14691, 14690, 14704, 14709,
   14702, 14720, 14721, 14725, 14726, 14730, 14738, 14742, 14752, 14751,
   14763, 14774, 14775, 14782, 14781, 14794, 14793, 14806, 14807, 14811,
   14815, 14826, 14825, 14833, 14837, 14848, 14847, 14856, 14860, 14867,
   14871, 14882, 14881, 14890, 14891, 14895, 14923, 14924, 14928, 14929,
   14930, 14931, 14935, 14936, 14940, 14941, 14942, 14946, 14947, 14955,
   14956, 14960, 14961, 14967, 14976, 14977, 14978, 14983, 14984, 14985,
   14989, 14996, 15012, 15013, 15014, 15020, 15019, 15031, 15043, 15040,
   15057, 15054, 15070, 15078, 15085, 15089, 15102, 15108, 15120, 15123,
   15128, 15132, 15146, 15153, 15154, 15158, 15159, 15162, 15163, 15168,
   15211, 15215, 15225, 15224, 15237, 15236, 15244, 15249, 15258, 15273,
   15272, 15282, 15311, 15312, 15316, 15320, 15324, 15328, 15335, 15336,
   15340, 15344, 15347, 15349, 15353, 15362, 15363, 15364, 15368, 15369,
   15373, 15377, 15381, 15389, 15390, 15394, 15395, 15399, 15403, 15413,
   15424, 15423, 15432, 15437, 15438, 15442, 15443, 15444, 15448, 15449,
   15453, 15457, 15458, 15462, 15466, 15470, 15480, 15479, 15487, 15497,
   15508, 15507, 15516, 15523, 15527, 15538, 15537, 15549, 15558, 15561,
   15565, 15569, 15576, 15580, 15590, 15600, 15603, 15602, 15609, 15608,
   15617, 15625, 15634, 15635, 15640, 15643, 15651, 15657, 15661, 15668,
   15676, 15680, 15691, 15690, 15698, 15699, 15705, 15723, 15734, 15736,
   15740, 15759, 15763, 15770, 15771, 15772, 15773, 15776, 15778, 15785,
   15784, 15798, 15799, 15800, 15801, 15802, 15803, 15804, 15805, 15809,
   15810, 15814, 15815, 15821, 15830, 15837, 15838, 15842, 15846, 15850,
   15856, 15862, 15866, 15870, 15874, 15883, 15887, 15891, 15895, 15899,
   15908, 15917, 15918, 15922, 15931, 15932, 15936, 15940, 15949, 15958,
   15970, 15969, 15979, 15977, 16030, 16031, 16048, 16049, 16052, 16053,
   16062, 16065, 16070, 16075, 16085, 16102, 16107, 16117, 16135, 16134,
   16144, 16157, 16160, 16168, 16171, 16176, 16181, 16189, 16190, 16191,
   16192, 16193, 16194, 16203, 16204, 16208, 16212, 16221, 16224, 16223,
   16234, 16241, 16249, 16263, 16270, 16274, 16278, 16286, 16297, 16298,
   16302, 16306, 16313, 16314, 16315, 16316, 16323, 16322, 16331, 16338,
   16338, 16348, 16349, 16353, 16367, 16368, 16373, 16374, 16378, 16379,
   16383, 16387, 16398, 16397, 16406, 16410, 16414, 16418, 16426, 16430,
   16440, 16440, 16452, 16453, 16460, 16459, 16467, 16476, 16489, 16488,
   16496, 16508, 16507, 16515, 16532, 16531, 16541, 16549, 16550, 16555,
   16556, 16561, 16568, 16569, 16574, 16581, 16582, 16586, 16587, 16591,
   16595, 16605, 16604, 16619, 16624, 16636, 16635, 16644, 16645, 16646,
   16647, 16648, 16652, 16680, 16683, 16695, 16705, 16710, 16715, 16720,
   16728, 16768, 16769, 16773, 16833, 16843, 16866, 16867, 16868, 16869,
   16873, 16882, 16888, 16898, 16925, 16929, 16930, 16934, 16940, 16956,
   16957, 16964, 16963, 16975, 16985, 16986, 16991, 16994, 16998, 17002,
   17009, 17010, 17014, 17015, 17016, 17020, 17024, 17032, 17035, 17034,
   17048, 17059, 17046, 17070, 17072, 17076, 17077, 17081, 17085, 17097,
   17106, 17116, 17119, 17129, 17132, 17140, 17143, 17152, 17156, 17163,
   17171, 17174, 17181, 17185, 17192, 17196, 17204, 17207, 17216, 17220,
   17227, 17235, 17238, 17242, 17243, 17244, 17247, 17249, 17257, 17258,
   17262, 17267, 17272, 17279, 17284, 17289, 17297, 17301, 17308, 17312,
   17323, 17322, 17349, 17344, 17364, 17367, 17375, 17376, 17380, 17381,
   17386, 17387, 17403, 17404, 17405, 17415, 17419, 17426, 17434, 17435,
   17439, 17440, 17444, 17452, 17453, 17458, 17459, 17460, 17470, 17474,
   17481, 17489, 17490, 17494, 17504, 17505, 17506, 17516, 17520, 17527,
   17535, 17536, 17540, 17550, 17551, 17552, 17562, 17566, 17573, 17581,
   17582, 17586, 17597, 17598, 17605, 17607, 17616, 17620, 17627, 17635,
   17636, 17640, 17650, 17651, 17661, 17665, 17672, 17680, 17681, 17685,
   17695, 17696, 17700, 17701, 17711, 17715, 17722, 17730, 17731, 17735,
   17746, 17749, 17758, 17761, 17769, 17773, 17782, 17786, 17793, 17794,
   17800, 17805, 17813, 17820, 17820, 17831, 17832, 17836, 17837, 17839,
   17841, 17843, 17844, 17846, 17847, 17848, 17849, 17850, 17852, 17853,
   17854, 17855, 17856, 17857, 17858, 17859, 17860, 17861, 17862, 17866,
   17871, 17879, 17886, 17886, 17897, 17898, 17902, 17903, 17904, 17905,
   17907, 17908, 17910, 17911, 17912, 17913, 17914, 17916, 17917, 17918,
   17919, 17920, 17921, 17922, 17923, 17924, 17925, 17928, 17930, 17934,
   17937, 17939, 17940, 17941, 17942, 17943, 17944, 17946, 17947, 17948,
   17949, 17950, 17954, 17955, 17959, 17960, 17964, 17965, 17969, 17970,
   17974, 17978, 17984, 17988, 17994, 17996, 17997, 18001, 18002, 18003,
   18007, 18008, 18009, 18010, 18011, 18012, 18013, 18014, 18015, 18016,
   18020, 18024, 18028, 18029, 18030, 18031, 18034, 18035, 18045, 18057,
   18066, 18082, 18091, 18107, 18122, 18123, 18128, 18137, 18143, 18153,
   18167, 18192, 18196, 18217, 18221, 18242, 18254, 18268, 18282, 18283,
   18288, 18294, 18295, 18300, 18309, 18311, 18316, 18330, 18331, 18332,
   18339, 18350, 18351, 18355, 18363, 18364, 18368, 18369, 18373, 18385,
   18389, 18396, 18405, 18406, 18412, 18421, 18432, 18449, 18453, 18460,
   18461, 18462, 18469, 18470, 18474, 18478, 18485, 18486, 18490, 18491,
   18495, 18496, 18497, 18498, 18502, 18506, 18510, 18514, 18518, 18539,
   18549, 18553, 18560, 18561, 18562, 18566, 18567, 18568, 18569, 18570,
   18574, 18578, 18585, 18586, 18587, 18588, 18592, 18596, 18603, 18615,
   18627, 18641, 18642, 18646, 18647, 18651, 18658, 18659, 18666, 18667,
   18674, 18675, 18676, 18680, 18681, 18685, 18689, 18693, 18697, 18698,
   18702, 18706, 18707, 18711, 18715, 18716, 18725, 18729, 18734, 18735,
   18741, 18745, 18749, 18753, 18754, 18760, 18764, 18768, 18769, 18773,
   18780, 18790, 18809, 18830, 18849, 18867, 18874, 18881, 18888, 18898,
   18902, 18909, 18913, 18920, 18942, 18955, 18962, 18966, 18970, 18974,
   18980, 18981, 18997, 19023, 19027, 19035, 19035, 19048, 19053, 19061,
   19069, 19073, 19083, 19098, 19120, 19140, 19144, 19151, 19165, 19173,
   19174, 19175, 19176, 19177, 19178, 19182, 19186, 19202, 19206, 19212,
   19212, 19215, 19216, 19217, 19218, 19224, 19228, 19232, 19236, 19240,
   19244, 19249, 19254, 19258, 19262, 19266, 19270, 19274, 19278, 19285,
   19286, 19290, 19291, 19292, 19293, 19297, 19298, 19299, 19300, 19301,
   19305, 19309, 19313, 19320, 19324, 19328, 19335, 19342, 19349, 19359,
   19359, 19375, 19382, 19392, 19399, 19409, 19413, 19426, 19430, 19445,
   19453, 19454, 19458, 19459, 19460, 19464, 19465, 19470, 19473, 19481,
   19484, 19492, 19494, 19495, 19499, 19500, 19504, 19505, 19506, 19511,
   19514, 19527, 19531, 19539, 19543, 19547, 19551, 19555, 19559, 19563,
   19567, 19574, 19575, 19579, 19580, 19590, 19591, 19600, 19604, 19608,
   19612, 19619, 19620, 19621, 19622, 19623, 19624, 19625, 19626, 19627,
   19628, 19629, 19630, 19631, 19632, 19633, 19634, 19635, 19636, 19637,
   19638, 19639, 19640, 19641, 19642, 19643, 19644, 19645, 19646, 19647,
   19648, 19649, 19650, 19651, 19652, 19653, 19654, 19655, 19656, 19657,
   19658, 19659, 19660, 19661, 19662, 19663, 19664, 19665, 19666, 19667,
   19668, 19669, 19670, 19674, 19675, 19676, 19677, 19678, 19679, 19680,
   19681, 19682, 19683, 19684, 19685, 19686, 19687, 19688, 19689, 19690,
   19691, 19692, 19693, 19694, 19695, 19696, 19700, 19701, 19708, 19709,
   19718, 19727, 19728, 19729, 19738, 19741, 19744, 19747, 19748, 19749,
   19758, 19758, 19758, 19758, 19761, 19761, 19761, 19764, 19764, 19764,
   19764, 19765, 19765, 19765, 19768, 19769, 19774, 19786, 19786, 19787,
   19787, 19788, 19788, 19789, 19789, 19790, 19790, 19790, 19791, 19791,
   19792, 19792, 19793, 19793, 19794, 19794, 19795, 19795, 19796, 19796,
   19797, 19797, 19798, 19798, 19799, 19799, 19800, 19800, 19801, 19801,
   19802, 19802, 19803, 19803, 19804, 19804, 19805, 19805, 19806, 19806,
   19807, 19807, 19808, 19808, 19809, 19809, 19810, 19810, 19811, 19811,
   19811, 19812, 19812, 19812, 19813, 19813, 19814, 19814, 19815, 19815,
   19816, 19816, 19817, 19817, 19818, 19818, 19818, 19819, 19819, 19819,
   19820, 19820, 19820, 19820, 19821, 19821, 19821, 19822, 19822, 19823,
   19823, 19824, 19824, 19824, 19825, 19825, 19825, 19826, 19826, 19827,
   19827, 19828, 19828, 19829, 19829, 19830, 19830, 19831, 19831, 19832,
   19832, 19833, 19833, 19834, 19834, 19835, 19835, 19835, 19836, 19836,
   19836, 19836, 19837, 19837, 19838, 19838, 19839, 19839, 19840, 19840,
   19841, 19841, 19842, 19842, 19843, 19843, 19843, 19844, 19844, 19845,
   19845, 19846, 19846, 19847, 19847, 19847, 19848, 19848, 19849, 19849,
   19850, 19850, 19851, 19851, 19852, 19852, 19853, 19853, 19854, 19854,
   19855, 19855, 19856, 19856, 19857, 19857, 19858, 19858, 19859, 19859,
   19860, 19860, 19861, 19861, 19861, 19863, 19863, 19867, 19867, 19868,
   19868, 19869, 19869, 19870, 19870, 19871, 19871, 19872, 19872, 19873,
   19873, 19873, 19873, 19874, 19874, 19875, 19875, 19876, 19876, 19877,
   19877, 19878, 19878, 19879, 19879, 19880, 19880, 19881, 19881, 19881,
   19882, 19882, 19883, 19883, 19884, 19884, 19885, 19885, 19886, 19886,
   19887, 19887, 19890, 19890, 19891, 19891, 19892, 19892, 19893, 19893,
   19894, 19894, 19895, 19895, 19896, 19896, 19897, 19897
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"3D\"", "ABSENT",
  "ACCEPT", "ACCESS", "\"ACTIVE-X\"", "\"ACTIVE-CLASS\"", "ACTION",
  "ACTUAL", "ADD", "ADDRESS", "\"ADJUSTABLE-COLUMNS\"", "ADVANCING",
  "AFTER", "ALIGNED", "ALIGNMENT", "ALL", "ALLOCATE", "ALLOWING",
  "ALPHABET", "ALPHABETIC", "\"ALPHABETIC-LOWER\"", "\"ALPHABETIC-UPPER\"",
  "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"", "ALSO", "ALTER", "ALTERNATE",
  "AND", "ANY", "APPLY", "ARE", "AREA", "AREAS", "\"ARGUMENT-NUMBER\"",
  "\"ARGUMENT-VALUE\"", "ARITHMETIC", "AS", "ASCENDING", "ASCII", "ASSIGN",
  "AT", "\"AT END\"", "ATTRIBUTE", "ATTRIBUTES", "AUTHOR", "AUTO",
  "\"AUTO-DECIMAL\"", "\"AUTO-SPIN\"", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"B-AND\"", "\"B-NOT\"", "\"B-OR\"", "\"B-XOR\"", "\"B-SHIFT-L\"",
  "\"B-SHIFT-R\"", "\"B-SHIFT-LC\"", "\"B-SHIFT-RC\"",
  "\"BACKGROUND-COLOR\"", "\"BACKGROUND-HIGH\"", "\"BACKGROUND-LOW\"",
  "\"BACKGROUND-STANDARD\"", "BACKWARD", "BAR", "BASED", "BEFORE", "BELL",
  "BINARY", "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SEQUENTIAL\"", "\"BINARY-SHORT\"", "BIT",
  "BITMAP", "\"BITMAP-END\"", "\"BITMAP-HANDLE\"", "\"BITMAP-NUMBER\"",
  "\"BITMAP-START\"", "\"BITMAP-TIMER\"", "\"BITMAP-TRAILING\"",
  "\"BITMAP-TRANSPARENT-COLOR\"", "\"BITMAP-WIDTH\"", "BLANK", "BLINK",
  "BLOCK", "BOOLEAN", "BOTTOM", "BOX", "BOXED", "\"BULK-ADDITION\"",
  "BUSY", "BUTTONS", "BY", "\"BYTE-LENGTH\"", "C", "\"CALENDAR-FONT\"",
  "CALL", "CANCEL", "\"CANCEL-BUTTON\"", "CAPACITY", "\"CARD-PUNCH\"",
  "\"CARD-READER\"", "CASSETTE", "CCOL", "CD", "CELL", "\"CELL-COLOR\"",
  "\"CELL-DATA\"", "\"CELL-FONT\"", "\"CELL-PROTECTION\"", "CENTER",
  "CENTERED", "\"CENTERED-HEADINGS\"", "\"CENTURY-DATE\"", "CF", "CH",
  "CHAINING", "CHANGED", "CHARACTER", "CHARACTERS", "\"CHECK-BOX\"",
  "CLASS", "CLASSIFICATION", "\"class-name\"", "\"CLEAR-SELECTION\"",
  "CLINE", "CLINES", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING",
  "COL", "COLOR", "COLORS", "COLS", "COLUMN", "\"COLUMN-COLOR\"",
  "\"COLUMN-DIVIDERS\"", "\"COLUMN-FONT\"", "\"COLUMN-HEADINGS\"",
  "\"COLUMN-PROTECTION\"", "COLUMNS", "\"COMBO-BOX\"", "COMMA",
  "\"COMMAND-LINE\"", "\"comma delimiter\"", "COMMIT", "COMMON",
  "COMMUNICATION", "COMP", "COMPUTE", "\"COMP-0\"", "\"COMP-1\"",
  "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"", "\"COMP-5\"", "\"COMP-6\"",
  "\"COMP-N\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"", "CONDITION",
  "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "\"FUNCTION CONTENT-LENGTH\"", "\"FUNCTION CONTENT-OF\"", "CONTINUE",
  "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "\"COPY-SELECTION\"", "\"CORE-INDEX\"", "CORRESPONDING", "COUNT", "CRT",
  "\"CRT-UNDER\"", "CSIZE", "CURRENCY", "\"FUNCTION CURRENT-DATE\"",
  "CURSOR", "\"CURSOR-COL\"", "\"CURSOR-COLOR\"", "\"CURSOR-FRAME-WIDTH\"",
  "\"CURSOR-ROW\"", "\"CURSOR-X\"", "\"CURSOR-Y\"",
  "\"CUSTOM-PRINT-TEMPLATE\"", "CYCLE", "\"CYL-INDEX\"",
  "\"CYL-OVERFLOW\"", "DASHED", "DATA", "\"DATA-COLUMNS\"",
  "\"DATA-TYPES\"", "DATE", "\"DATE-COMPILED\"", "\"DATE-ENTRY\"",
  "\"DATE-MODIFIED\"", "\"DATE-WRITTEN\"", "DAY", "\"DAY-OF-WEEK\"", "DE",
  "DEBUGGING", "\"DECIMAL-POINT\"", "DECLARATIVES", "DEFAULT",
  "\"DEFAULT-BUTTON\"", "\"DEFAULT-FONT\"", "DELETE", "DELIMITED",
  "DELIMITER", "DEPENDING", "DESCENDING", "DESTINATION", "DESTROY",
  "DETAIL", "DISABLE", "DISC", "DISK", "DISP", "DISPLAY",
  "\"DISPLAY-COLUMNS\"", "\"DISPLAY-FORMAT\"", "\"FUNCTION DISPLAY-OF\"",
  "DIVIDE", "DIVIDERS", "\"DIVIDER-COLOR\"", "DIVISION", "DOTDASH",
  "DOTTED", "\"DRAG-COLOR\"", "\"DROP-DOWN\"", "\"DROP-LIST\"", "DOWN",
  "DUPLICATES", "DYNAMIC", "EBCDIC", "EC", "ECHO", "EGI",
  "\"level-number 88\"", "ENABLE", "ELEMENT", "ELSE", "EMI", "ENCRYPTION",
  "ENCODING", "END", "\"END-ACCEPT\"", "\"END-ADD\"", "\"END-CALL\"",
  "\"END-COMPUTE\"", "\"END-COLOR\"", "\"END-DELETE\"", "\"END-DISPLAY\"",
  "\"END-DIVIDE\"", "\"END-EVALUATE\"", "\"END FUNCTION\"", "\"END-IF\"",
  "\"END-JSON\"", "\"END-MODIFY\"", "\"END-MULTIPLY\"", "\"END-PERFORM\"",
  "\"END PROGRAM\"", "\"END-READ\"", "\"END-RECEIVE\"", "\"END-RETURN\"",
  "\"END-REWRITE\"", "\"END-SEARCH\"", "\"END-SEND\"", "\"END-START\"",
  "\"END-STRING\"", "\"END-SUBTRACT\"", "\"END-UNSTRING\"",
  "\"END-WRITE\"", "\"END-XML\"", "ENGRAVED", "\"ENSURE-VISIBLE\"",
  "ENTRY", "\"ENTRY-CONVENTION\"", "\"ENTRY-FIELD\"", "\"ENTRY-REASON\"",
  "ENVIRONMENT", "\"ENVIRONMENT-NAME\"", "\"ENVIRONMENT-VALUE\"", "EOL",
  "EOP", "EOS", "EQUAL", "ERASE", "ERROR", "ESCAPE", "\"ESCAPE-BUTTON\"",
  "ESI", "EVALUATE", "EVENT", "\"EVENT-LIST\"", "\"EVENT STATUS\"",
  "EVERY", "EXAMINE", "EXCEPTION", "\"EXCEPTION CONDITION\"",
  "\"EXCEPTION-VALUE\"", "EXPAND", "EXCLUSIVE", "EXHIBIT", "EXIT",
  "\"exponentiation operator\"", "EXTEND", "\"EXTENDED-SEARCH\"",
  "EXTERNAL", "\"EXTERNAL-FORM\"", "F", "FACTORY", "FD", "\"FH--FCD\"",
  "\"FH--KEYDEF\"", "\"FILE-CONTROL\"", "\"FILE-ID\"", "\"FILE-LIMIT\"",
  "\"FILE-LIMITS\"", "\"FILE-NAME\"", "\"FILE-POS\"", "\"FILL-COLOR\"",
  "\"FILL-COLOR2\"", "\"FILL-PERCENT\"", "FILLER", "FINAL",
  "\"FINISH-REASON\"", "FIRST", "FIXED", "\"FIXED-FONT\"",
  "\"FIXED-WIDTH\"", "FLAT", "\"FLAT-BUTTONS\"", "\"FLOAT-BINARY-128\"",
  "\"FLOAT-BINARY-32\"", "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"",
  "\"FLOAT-DECIMAL-34\"", "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"",
  "\"FLOAT-LONG\"", "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING",
  "FOR", "\"FOREGROUND-COLOR\"", "FOREVER", "FORMAT",
  "\"FUNCTION FORMATTED-DATE\"", "\"FUNCTION FORMATTED-DATETIME\"",
  "\"FUNCTION FORMATTED-TIME\"", "FRAME", "FRAMED", "FREE", "FROM",
  "\"FROM CRT\"", "FULL", "\"FULL-HEIGHT\"", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "GENERATE", "GIVING", "GLOBAL", "GO",
  "\"GO-BACK\"", "\"GO-FORWARD\"", "\"GO-HOME\"", "\"GO-SEARCH\"",
  "GOBACK", "GRAPHICAL", "GREATER", "\"GREATER OR EQUAL\"", "GRID",
  "GROUP", "\"GROUP-VALUE\"", "HANDLE", "\"HAS-CHILDREN\"", "HEADING",
  "\"HEADING-COLOR\"", "\"HEADING-DIVIDER-COLOR\"", "\"HEADING-FONT\"",
  "HEAVY", "\"HEIGHT-IN-CELLS\"", "\"HIDDEN-DATA\"", "HIGHLIGHT",
  "\"HIGH-COLOR\"", "\"HIGH-VALUE\"", "\"HOT-TRACK\"", "HSCROLL",
  "\"HSCROLL-POS\"", "ICON", "ID", "IDENTIFIED", "IDENTIFICATION", "IF",
  "IGNORE", "IGNORING", "IN", "INDEPENDENT", "INDEX", "INDEXED",
  "INDICATE", "INITIALIZE", "INITIALIZED", "INITIATE", "INPUT",
  "\"INPUT-OUTPUT\"", "INQUIRE", "\"INSERTION-INDEX\"", "\"INSERT-ROWS\"",
  "INSPECT", "INSTALLATION", "INTERMEDIATE", "INTO", "INTRINSIC",
  "INVALID", "\"INVALID KEY\"", "IS", "ITEM", "\"ITEM-TEXT\"",
  "\"ITEM-TO_ADD\"", "\"ITEM-TO_DELETE\"", "\"ITEM-TO_EMPTY\"",
  "\"ITEM-VALUE\"", "\"I-O\"", "\"I-O-CONTROL\"", "JSON", "JUSTIFIED",
  "KEPT", "KEY", "KEYBOARD", "LABEL", "\"LABEL-OFFSET\"", "\"LARGE-FONT\"",
  "\"LARGE-OFFSET\"", "LAST", "\"LAST-ROW\"", "\"LAYOUT-DATA\"",
  "\"LAYOUT-MANAGER\"", "LEADING", "\"LEADING-SHIFT\"", "LEAVE", "LEFT",
  "LEFTLINE", "\"LEFT-TEXT\"", "LENGTH", "\"LENGTH OF\"",
  "\"FUNCTION LENGTH/BYTE-LENGTH\"", "LESS", "\"LESS OR EQUAL\"",
  "\"level-number\"", "LIKE", "LIMIT", "LIMITS", "LINAGE",
  "\"LINAGE-COUNTER\"", "LINE", "\"LINE-COUNTER\"", "\"LINE LIMIT\"",
  "\"LINE-SEQUENTIAL\"", "LINES", "\"LINES-AT-ROOT\"", "LINKAGE",
  "\"LIST-BOX\"", "\"Literal\"", "\"LM-RESIZE\"", "LOC", "LOCALE",
  "\"FUNCTION LOCALE-DATE\"", "\"FUNCTION LOCALE-TIME\"",
  "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"", "\"LOCAL-STORAGE\"", "LOCK",
  "\"LOCK-HOLDING\"", "\"LONG-DATE\"", "LOWER", "LOWERED",
  "\"FUNCTION LOWER-CASE\"", "LOWLIGHT", "\"LOW-COLOR\"", "\"LOW-VALUE\"",
  "\"MAGNETIC-TAPE\"", "MANUAL", "\"MASS-UPDATE\"", "\"MASTER-INDEX\"",
  "\"MAX-LINES\"", "\"MAX-PROGRESS\"", "\"MAX-TEXT\"", "\"MAX-VAL\"",
  "MEMORY", "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE", "MINUS",
  "\"MIN-VAL\"", "\"Mnemonic name\"", "MODE", "MODIFY", "MODULES", "MOVE",
  "MULTILINE", "MULTIPLE", "MULTIPLY", "NAME", "NAMED", "NAMESPACE",
  "\"NAMESPACE-PREFIX\"", "NATIONAL", "\"NATIONAL-EDITED\"",
  "\"FUNCTION NATIONAL-OF\"", "NATIVE", "\"NAVIGATE-URL\"",
  "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEW", "NEXT",
  "\"NEXT-ITEM\"", "\"NEXT GROUP\"", "\"NEXT PAGE\"", "NO",
  "\"NO ADVANCING\"", "\"NO-AUTOSEL\"", "\"NO-AUTO-DEFAULT\"",
  "\"NO-BOX\"", "\"NO DATA\"", "\"NO-DIVIDERS\"", "\"NO-ECHO\"",
  "\"NO-F4\"", "\"NO-FOCUS\"", "\"NO-GROUP-TAB\"", "\"NO-KEY-LETTER\"",
  "\"NO-SEARCH\"", "\"NO-UPDOWN\"", "NOMINAL", "NONE", "NONNUMERIC",
  "NORMAL", "NOT", "NOTAB", "NOTHING", "NOTIFY", "\"NOTIFY-CHANGE\"",
  "\"NOTIFY-DBLCLICK\"", "\"NOTIFY-SELCHANGE\"", "\"NOT AT END\"",
  "\"NOT AT EOP\"", "\"NOT ON ESCAPE\"", "\"NOT EQUAL\"",
  "\"NOT ON EXCEPTION\"", "\"NOT INVALID KEY\"", "\"NOT ON OVERFLOW\"",
  "\"NOT SIZE ERROR\"", "\"NUM-COL-HEADINGS\"", "\"NUM-ROWS\"", "NUMBER",
  "NUMBERS", "NUMERIC", "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"",
  "OBJECT", "\"OBJECT-COMPUTER\"", "OCCURS", "OF", "OFF", "\"OK-BUTTON\"",
  "OMITTED", "ON", "ONLY", "\"ON ESCAPE\"", "\"ON EXCEPTION\"", "OPEN",
  "OPTIONAL", "OPTIONS", "OR", "ORDER", "ORGANIZATION", "OTHER", "OTHERS",
  "OUTPUT", "\"OVERLAP-LEFT\"", "\"OVERLAP-TOP\"", "OVERLINE",
  "\"PACKED-DECIMAL\"", "PADDING", "PASCAL", "PAGE", "\"PAGE-COUNTER\"",
  "\"PAGE-SETUP\"", "PAGED", "PARAGRAPH", "PARENT", "PARSE", "PASSWORD",
  "PERFORM", "PERMANENT", "PH", "PF", "PHYSICAL", "PICTURE",
  "\"PICTURE SYMBOL\"", "PIXEL", "PLACEMENT", "PLUS", "POINTER",
  "\"POP-UP\"", "POS", "POSITION", "\"POSITION-SHIFT\"", "POSITIVE",
  "PRESENT", "PREVIOUS", "PRINT", "\"PRINT-CONTROL\"",
  "\"PRINT-NO-PROMPT\"", "\"PRINT-PREVIEW\"", "PRINTER", "\"PRINTER-1\"",
  "PRINTING", "PRIORITY", "PROCEDURE", "PROCEDURES", "PROCEED",
  "PROCESSING", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROGRESS", "PROHIBITED", "PROMPT", "PROPERTIES",
  "PROPERTY", "PROTECTED", "PROTOTYPE", "PURGE", "\"PUSH-BUTTON\"",
  "\"QUERY-INDEX\"", "QUEUE", "QUOTE", "\"RADIO-BUTTON\"", "RAISE",
  "RAISED", "RAISING", "RANDOM", "RD", "READ", "READERS", "\"READ-ONLY\"",
  "\"READY TRACE\"", "RECEIVE", "RECEIVED", "RECORD", "\"RECORD-DATA\"",
  "\"RECORD-OVERFLOW\"", "\"RECORD-TO-ADD\"", "\"RECORD-TO-DELETE\"",
  "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES", "REEL", "REFERENCE",
  "REFERENCES", "REFRESH", "\"REGION-COLOR\"", "RELATION", "RELATIVE",
  "RELEASE", "REMAINDER", "REMARKS", "REMOVAL", "RENAMES",
  "\"REORG-CRITERIA\"", "REPEATED", "REPLACE", "REPLACING", "REPORT",
  "REPORTING", "REPORTS", "REPOSITORY", "REQUIRED", "REREAD", "RERUN",
  "RESERVE", "RESET", "\"RESET TRACE\"", "\"RESET-GRID\"",
  "\"RESET-LIST\"", "\"RESET-TABS\"", "RETRY", "RETURN", "RETURNING",
  "REVERSE", "\"FUNCTION REVERSE\"", "\"REVERSE-VIDEO\"", "REVERSED",
  "REWIND", "REWRITE", "RF", "RH", "RIGHT", "\"RIGHT-ALIGN\"", "RIMMED",
  "ROLLBACK", "ROUNDED", "ROUNDING", "\"ROW-COLOR\"",
  "\"ROW-COLOR-PATTERN\"", "\"ROW-DIVIDERS\"", "\"ROW-FONT\"",
  "\"ROW-HEADINGS\"", "\"ROW-PROTECTION\"", "RUN", "S", "SAME",
  "\"SAVE-AS\"", "\"SAVE-AS-NO-PROMPT\"", "SCREEN", "\"SCREEN CONTROL\"",
  "SCROLL", "\"SCROLL-BAR\"", "SD", "SEARCH", "\"SEARCH-OPTIONS\"",
  "\"SEARCH-TEXT\"", "SECONDS", "SECTION", "SECURE", "SECURITY", "SEGMENT",
  "\"SEGMENT-LIMIT\"", "SELECT", "\"SELECTION-INDEX\"",
  "\"SELECTION-TEXT\"", "\"SELECTION-ALL\"", "\"SELF-ACT\"",
  "\"semi-colon\"", "SEND", "SENTENCE", "SEPARATE", "SEPARATION",
  "SEQUENCE", "SEQUENTIAL", "SET", "\"level-number 78\"", "SHADING",
  "SHADOW", "SHARING", "\"SHORT-DATE\"", "\"SHOW-LINES\"", "\"SHOW-NONE\"",
  "\"SHOW-SEL-ALWAYS\"", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"level-number 66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"",
  "\"SORT-ORDER\"", "SOURCE", "\"SOURCE-COMPUTER\"", "SPACE",
  "\"SPECIAL-NAMES\"", "SPINNER", "SQUARE", "STANDARD", "\"STANDARD-1\"",
  "\"STANDARD-2\"", "\"STANDARD-BINARY\"", "\"STANDARD-DECIMAL\"", "START",
  "\"START-X\"", "\"START-Y\"", "STATIC", "\"STATIC-LIST\"", "STATUS",
  "\"STATUS-BAR\"", "\"STATUS-TEXT\"", "STDCALL", "STEP", "STOP", "STRING",
  "STRONG", "STYLE", "\"SUB-QUEUE-1\"", "\"SUB-QUEUE-2\"",
  "\"SUB-QUEUE-3\"", "\"FUNCTION SUBSTITUTE\"",
  "\"FUNCTION SUBSTITUTE-CASE\"", "SUBTRACT", "SUBWINDOW", "SUM",
  "SUPPRESS", "\"SUPPRESS\"", "SYMBOLIC", "SYNCHRONIZED",
  "\"SYSTEM-DEFAULT\"", "\"SYSTEM-INFO\"", "\"SYSTEM-OFFSET\"", "TAB",
  "\"TAB-TO-ADD\"", "\"TAB-TO-DELETE\"", "TABLE", "TALLYING", "TEMPORARY",
  "TAPE", "TERMINAL", "TERMINATE", "\"TERMINAL-INFO\"",
  "\"TERMINATION-VALUE\"", "TEST", "TEXT", "THAN", "THEN", "THREAD",
  "THREADS", "THRU", "\"THUMB-POSITION\"", "\"TILED-HEADINGS\"", "TIME",
  "\"TIME-OUT\"", "TIMES", "TITLE", "\"TITLE-POSITION\"", "TO", "\"&\"",
  "\")\"", "\":\"", "\"/\"", "\".\"", "\"=\"", "\"EXTERN\"", "\"FALSE\"",
  "\"FILE\"", "\">\"", "\"INITIAL\"", "\"<\"", "\"-\"", "\"*\"",
  "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"", "\"TRUE\"", "TOP",
  "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "TRACK", "TRACKS",
  "\"TRACK-AREA\"", "\"TRACK-LIMIT\"", "\"TRADITIONAL-FONT\"", "TRAILING",
  "\"TRAILING-SHIFT\"", "TRANSFORM", "TRANSPARENT", "\"TREE-VIEW\"",
  "\"FUNCTION TRIM\"", "TRUNCATION", "TYPE", "TYPEDEF", "U", "\"UCS-4\"",
  "UNBOUNDED", "UNDERLINE", "UNFRAMED", "UNIT", "UNLOCK", "UNSIGNED",
  "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"", "\"UNSIGNED-SHORT\"",
  "UNSORTED", "UNSTRING", "UNTIL", "UP", "UPDATE", "UPDATERS", "UPON",
  "\"UPON ARGUMENT-NUMBER\"", "\"UPON COMMAND-LINE\"",
  "\"UPON ENVIRONMENT-NAME\"", "\"UPON ENVIRONMENT-VALUE\"", "UPPER",
  "\"FUNCTION UPPER-CASE\"", "USAGE", "USE", "\"USE-ALT\"",
  "\"USE-RETURN\"", "\"USE-TAB\"", "USER", "\"USER-DEFAULT\"",
  "\"user function name\"", "USING", "\"UTF-8\"", "\"UTF-16\"", "V",
  "VALID", "VALIDATE", "\"VAL-STATUS\"", "\"VALIDATE-STATUS\"",
  "VALIDATING", "VALUE", "\"VALUE-FORMAT\"", "VALUES", "VARIABLE",
  "VARIANT", "VARYING", "VERTICAL", "\"VERY-HEAVY\"", "\"VIRTUAL-WIDTH\"",
  "VOLATILE", "VPADDING", "VSCROLL", "\"VSCROLL-BAR\"", "\"VSCROLL-POS\"",
  "VTOP", "WAIT", "\"WEB-BROWSER\"", "WHEN", "\"FUNCTION WHEN-COMPILED\"",
  "\"WHEN\"", "WIDTH", "\"WIDTH-IN-CELLS\"", "WINDOW", "WITH",
  "\"Identifier\"", "WORDS", "\"WORKING-STORAGE\"", "WRAP", "WRITE",
  "\"WRITE-ONLY\"", "\"WRITE-VERIFY\"", "WRITERS", "X", "XML",
  "\"XML-DECLARATION\"", "\"XML-SCHEMA\"", "Y", "YYYYDDD", "YYYYMMDD",
  "ZERO", "\"level-number (Area A)\"", "\"Identifier (Area A)\"",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "$@4",
  "end_function", "$@5", "program_prototype", "$@6", "function_prototype",
  "$@7", "_prototype_procedure_division_header", "$@8", "control",
  "_control_division", "$@9", "_default_section", "$@10",
  "_default_clauses", "_default_accept_clause", "$@11",
  "_default_display_clause", "$@12", "_program_body", "$@13", "$@14",
  "_identification_header", "identification_header", "$@15",
  "identification_or_id", "program_id_header", "program_id_paragraph",
  "function_id_header", "function_id_paragraph", "program_id_name",
  "end_program_name", "_as_literal", "_program_type",
  "program_type_clause", "init_or_recurse_and_common", "init_or_recurse",
  "_options_paragraph", "_options_clauses", "_arithmetic_clause",
  "arithmetic_choice", "_default_rounded_clause",
  "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "environment",
  "environment_header", "_configuration_section", "_configuration_header",
  "configuration", "configuration_header", "_configuration_paragraphs",
  "configuration_paragraphs", "configuration_paragraph",
  "_source_computer_paragraph", "source_computer_paragraph", "$@16",
  "_source_computer_entry", "_with_debugging_mode",
  "object_computer_paragraph", "$@17", "_object_computer_entry",
  "object_clauses_list", "object_clauses", "object_computer_memory",
  "object_computer_sequence", "program_collating_sequence", "$@18",
  "program_coll_sequence_values", "object_computer_segment",
  "object_computer_class", "locale_class", "computer_words",
  "_repository_paragraph", "repository_paragraph", "$@19",
  "_repository_entry", "repository_list", "repository_name",
  "repository_name_list", "special_names_header", "special_names_sentence",
  "special_name_list", "special_name", "mnemonic_name_clause", "$@20",
  "word_or_terminal", "mnemonic_choices", "_special_name_mnemonic_on_off",
  "on_off_clauses", "on_off_clauses_1", "alphabet_name_clause", "@21",
  "alphabet_definition", "@22", "@23", "alphabet_target_alphanumeric",
  "alphabet_target_national", "alphabet_type_alphanumeric",
  "alphabet_type_national", "alphabet_type_common",
  "alphabet_literal_list", "alphabet_literal", "@24",
  "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "_alphnat_target", "_in_alphabet", "symbolic_characters_clause",
  "symbolic_collection", "symbolic_chars_list", "symbolic_chars_phrase",
  "char_list", "integer_list", "symbolic_constant_clause",
  "symbolic_constant_list", "symbolic_constant", "class_name_clause",
  "class_item_list", "class_item", "locale_clause", "xml_schema_clause",
  "@25", "schema_definition", "currency_sign_clause", "_with_pic_symbol",
  "decimal_point_clause", "numeric_sign_clause", "cursor_clause",
  "crt_status_clause", "screen_control", "event_status", "top_clause",
  "$@26", "_input_output_section", "input_output", "_input_output_header",
  "_file_control_header", "_file_control_sequence", "file_control_entry",
  "$@27", "$@28", "_select_clauses_or_error", "_select_clause_sequence",
  "select_clause", "assign_clause", "_assign_device_or_line_adv_file",
  "assign_device", "general_device_name", "line_seq_device_name",
  "line_adv_file", "_ext_clause", "ext_clause", "assignment_name",
  "access_mode_clause", "access_mode", "alternate_record_key_clause",
  "_password_clause", "password_clause", "$@29", "encryption_clause",
  "_suppress_clause", "collating_sequence_clause", "collating_sequence",
  "$@30", "coll_sequence_values", "collating_sequence_clause_key",
  "alphabet_name", "file_status_clause", "_file_or_sort",
  "lock_mode_clause", "$@31", "lock_mode", "_lock_with", "_with_rollback",
  "with_rollback", "_with_mass_update", "organization_clause",
  "organization", "padding_character_clause", "record_delimiter_clause",
  "$@32", "record_delimiter_option", "record_key_clause", "_split_keys",
  "source_is", "split_key_list", "$@33", "split_key",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "file_limit_clause", "thru_list",
  "actual_key_clause", "nominal_key_clause", "track_area_clause",
  "track_limit_clause", "_i_o_control", "i_o_control_header",
  "_i_o_control_entries", "i_o_control_list", "i_o_control_clause",
  "same_clause", "_same_option", "apply_clause",
  "obsolete_dos_vs_apply_phrase", "multiple_file_tape_clause", "$@34",
  "multiple_file_list", "multiple_file", "_multiple_file_position",
  "rerun_clause", "_on_assignment", "rerun_event",
  "_prototype_environment_division", "_prototype_special_names_paragraph",
  "_prototype_special_names_sentence_list",
  "prototype_special_names_sentence_list", "prototype_special_name_list",
  "prototype_special_name", "_data_division", "$@35",
  "_data_division_header", "data", "data_division_header", "tok_file",
  "_file_section_header", "_file_description_sequence", "file_description",
  "file_description_entry", "$@36", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "communication", "_communication_section", "$@37",
  "_communication_description_sequence", "communication_description", "cd",
  "communication_description_entry", "$@38",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses", "working_storage",
  "_working_storage_section", "$@39", "_record_description_list", "$@40",
  "record_description_list", "data_description", "$@41", "level_number",
  "_filler", "_entry_name", "user_entry_name", "_const_global",
  "lit_or_length", "con_source", "fp32_usage", "fp64_usage", "fp128_usage",
  "pointer_len", "renames_entry", "_renames_thru", "condition_name_entry",
  "$@42", "_user_entry_name", "constant_entry", "$@43", "constant_source",
  "constant_78_source", "constant_expression_list", "constant_expression",
  "_data_description_clause_sequence", "data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "like_clause",
  "_length_modifier", "length_modifier", "same_as_clause",
  "typedef_clause", "_strong", "external_clause", "_as_extname",
  "_global_clause", "global_clause", "special_names_clause", "$@44",
  "special_names_target", "select_when_clause", "$@45", "when_choice",
  "format_clause", "format_choice", "volatile_clause", "picture_clause",
  "$@46", "_pic_locale_format_or_depending_on", "_is_locale_name",
  "locale_name", "type_to_clause", "usage_clause", "_usage_is", "usage",
  "conflict_usage", "_object_reference_type", "_factory_of", "_only",
  "double_usage", "_font_name", "_layout_name", "sign_clause",
  "report_occurs_clause", "report_occurs_step", "occurs_clause",
  "_occurs_from_integer", "_occurs_to_integer", "_occurs_integer_to",
  "_occurs_depending", "_capacity_in", "_occurs_initialized",
  "_occurs_keys_and_indexed", "$@47", "occurs_keys", "occurs_key_list",
  "occurs_key_field", "ascending_or_descending", "_occurs_indexed",
  "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "_left_or_right",
  "blank_clause", "based_clause", "value_clause", "value_table_item_list",
  "value_table_item", "from_subscripts", "_to_subscripts",
  "from_to_subscripts", "_repeated_phrase", "subscripts", "value_is_are",
  "value_item_list", "value_item", "value_clause_report",
  "value_clause_condition", "$@48", "value_item_list_in_alphabet",
  "value_item_condition_list", "value_item_condition",
  "_false_or_content_validation", "false_is", "content_validation",
  "valid_or_invalid", "_when_condition", "validate_status_clause",
  "when_error_choice", "_on_choice", "default_clause", "x_or_none",
  "class_clause", "class_option", "destination_clause",
  "present_when_clause", "invalid_when_clause", "any_length_clause",
  "external_form_clause", "identified_by_clause", "local_storage",
  "_local_storage_section", "$@49", "linkage", "_linkage_section", "$@50",
  "_report_section", "$@51", "$@52", "_report_description_sequence",
  "report_description", "$@53", "$@54", "_report_description_options",
  "report_description_option", "control_clause", "control_field_list",
  "control_final_tag", "control_identifier_list", "control_identifier",
  "page_limit_clause", "page_line_column", "page_limit_cols",
  "integer_or_zero_or_ident", "_page_heading_list", "page_detail",
  "heading_clause", "first_detail", "last_heading", "last_detail",
  "footing_clause", "_report_group_description_list",
  "report_group_description_entry", "$@55", "_report_group_options",
  "report_group_option", "type_is_clause", "type_option",
  "_control_heading_final", "_or_page", "_control_footing_final",
  "next_group_clause", "next_group_plus", "next_page", "sum_clause_list",
  "_reset_clause", "data_or_final", "present_when_condition",
  "present_absent", "_page_or_id", "page_or_ids", "data_varying_clause",
  "data_varying_list", "data_varying", "_var_from", "_var_by",
  "line_clause", "line_keyword_clause", "_line_clause_options",
  "line_clause_option", "column_clause", "col_keyword_clause",
  "_orientation", "_left_right_center", "col_or_plus",
  "column_integer_list", "column_integer", "source_clause",
  "group_indicate_clause", "_screen_section", "$@56", "$@57",
  "_screen_description_list", "screen_description_list",
  "screen_description", "$@58", "$@59", "$@60", "_screen_options",
  "screen_option", "screen_value_clause", "_value_is",
  "control_definition", "control_type_name", "control_type",
  "control_item", "_control_attributes", "control_attributes",
  "control_attribute", "control_style", "control_property",
  "control_style_name", "control_property_name",
  "control_style_name_generic", "control_property_name_generic",
  "control_style_name_label", "control_property_name_label",
  "control_style_name_entry_field", "control_property_name_entry_field",
  "control_style_name_push_button", "control_property_name_push_button",
  "control_style_name_check_box", "control_property_name_radio_button",
  "control_style_name_list_box", "control_property_name_list_box",
  "control_style_name_combo_box", "control_style_name_frame",
  "control_property_name_frame", "control_style_name_tab_control",
  "control_property_name_tab_control", "control_style_name_bar",
  "control_property_name_bar", "control_property_name_bitmap",
  "control_style_name_grid", "control_property_name_grid",
  "control_style_name_tree_view", "control_property_name_tree_view",
  "control_property_name_web_browser", "control_style_name_activex",
  "control_property_name_activex", "control_style_name_date_entry",
  "control_property_name_date_entry", "control_style_type",
  "control_property_type", "changeable_control_properties",
  "changeable_control_property", "changeable_window_properties",
  "changeable_window_property", "eol", "eos", "_plus", "plus",
  "plus_tokens", "minus", "minus_tokens", "control_size",
  "control_size_unit", "_cell", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause",
  "_prototype_data_division", "_procedure_division", "procedure_division",
  "$@61", "$@62", "$@63", "$@64", "$@65", "_procedure_using_chaining",
  "$@66", "$@67", "procedure_param_list", "procedure_param",
  "_procedure_type", "_size_optional", "using_size_clause",
  "size_is_integer", "_acu_size", "_procedure_optional",
  "_procedure_returning", "_procedure_declaratives", "$@68", "$@69",
  "$@70", "_procedure_list", "procedure", "$@71", "proc_name",
  "section_header", "$@72", "_use_statement", "paragraph_header",
  "invalid_statement", "_segment", "statement_list", "@73", "@74",
  "statements", "$@75", "statement", "$@76", "accept_statement", "$@77",
  "accept_body", "$@78", "$@79", "accp_identifier",
  "field_with_pos_specifier", "$@80", "_pos_specifier", "pos_specifier",
  "pos_specifier_value", "identifier_or_numeric_literal",
  "_accept_clauses", "accept_clauses", "accept_clause",
  "accept_from_screen_clauses", "accept_from_screen_clause",
  "lines_or_number", "at_line_column", "line_number", "column_number",
  "mode_is_block", "accp_attr", "_key_dest", "key_dest", "no_echo",
  "reverse_video", "update_default", "_end_accept", "add_statement",
  "$@81", "add_body", "_add_to", "_end_add", "allocate_statement", "$@82",
  "allocate_body", "_loc", "_allocate_returning", "alter_statement",
  "$@83", "alter_body", "alter_entry", "_proceed_to", "call_statement",
  "$@84", "call_body", "$@85", "_conv_linkage", "$@86",
  "conv_linkage_option", "_mnemonic_conv", "mnemonic_conv",
  "program_or_prototype", "_id_or_lit_or_func_as", "nested_or_prototype",
  "call_using", "$@87", "call_param_list", "call_param", "_call_type",
  "call_returning", "return_give", "null_or_omitted",
  "call_exception_phrases", "_call_on_exception", "call_on_exception",
  "_call_not_on_exception", "call_not_on_exception", "_end_call",
  "cancel_statement", "$@88", "cancel_body", "cancel_list",
  "id_or_lit_or_program_name", "close_statement", "$@89", "close_body",
  "close_files", "_close_option", "close_window", "$@90",
  "_close_display_option", "compute_statement", "$@91", "compute_body",
  "_end_compute", "commit_statement", "continue_statement", "$@92",
  "_continue_after_phrase", "$@93", "destroy_statement", "$@94",
  "destroy_body", "delete_statement", "$@95", "delete_body",
  "delete_file_list", "_end_delete", "disable_statement", "$@96",
  "enable_disable_handling", "_enable_disable_key", "communication_mode",
  "display_statement", "$@97", "display_body", "screen_or_device_display",
  "display_list", "display_atom", "$@98", "disp_list",
  "_with_display_attr", "display_attrs", "display_clauses",
  "display_clause", "_display_upon", "display_upon", "crt_under",
  "display_erase", "$@99", "display_pos_specifier",
  "field_or_literal_or_erase_with_pos_specifier", "$@100",
  "field_or_literal_or_erase_list", "field_or_literal_or_erase",
  "display_message_box", "$@101", "_display_message_clauses",
  "display_message_clauses", "display_message_clause", "display_window",
  "$@102", "$@103", "sub_or_window", "display_floating_window", "$@104",
  "$@105", "display_initial_window", "$@106", "initial_type", "_graphical",
  "_upon_window_handle", "window_handle", "display_window_clauses",
  "display_window_clause", "shadow", "boxed", "_top_or_bottom",
  "_left_or_centered_or_right", "no_scroll_wrap", "pop_up_or_handle",
  "pop_up_area", "handle_is_in", "disp_attr", "_end_display",
  "divide_statement", "$@107", "divide_body", "_end_divide",
  "enable_statement", "$@108", "entry", "entry_statement", "$@109",
  "$@110", "entry_body", "entry_goto_body", "evaluate_statement", "$@111",
  "evaluate_body", "evaluate_subject_list", "evaluate_subject",
  "evaluate_condition_list", "evaluate_case_list", "evaluate_case",
  "evaluate_other", "evaluate_when_list", "$@112", "$@113",
  "evaluate_object_list", "evaluate_object", "_evaluate_thru_expr",
  "_end_evaluate", "exhibit_statement", "$@114", "exhibit_body", "$@115",
  "_changed", "_named", "exhibit_target_list", "exhibit_target",
  "exit_statement", "$@116", "exit_body", "goback_exit_body",
  "free_statement", "$@117", "free_body", "generate_statement", "$@118",
  "generate_body", "goto_statement", "$@119", "go_body", "goto_depending",
  "goback_statement", "$@120", "if_statement", "$@121",
  "if_else_statements", "_if_then", "if_true", "if_false", "_end_if",
  "initialize_statement", "$@122", "initialize_body", "_initialize_filler",
  "_initialize_value", "_initialize_replacing",
  "initialize_replacing_list", "initialize_replacing_item",
  "initialize_category", "_initialize_default", "initiate_statement",
  "$@123", "initiate_body", "inquire_statement", "$@124", "inquire_body",
  "inspect_statement", "$@125", "inspect_body", "_backward",
  "send_identifier", "inspect_format_variant", "examine_statement",
  "$@126", "examine_format_variant", "$@127", "examine_tallying_keyword",
  "examine_replacing_keyword", "_examine_tallying_replacing",
  "single_character_value", "inspect_tallying", "$@128",
  "inspect_replacing", "inspect_converting", "tallying_list",
  "tallying_item", "replacing_list", "replacing_item", "rep_keyword",
  "replacing_region", "inspect_region", "inspect_before", "inspect_after",
  "json", "json_generate_statement", "$@129", "json_generate_body",
  "$@130", "$@131", "_json_suppress", "json_suppress_list",
  "json_suppress_entry", "_end_json", "json_parse_statement", "$@132",
  "json_parse_body", "_with_detail", "merge_statement", "$@133",
  "modify_statement", "$@134", "modify_body", "_end_modify",
  "move_statement", "$@135", "move_body", "multiply_statement", "$@136",
  "multiply_body", "_end_multiply", "open_statement", "$@137", "open_body",
  "open_file_entry", "_open_exclusive", "open_mode", "_open_sharing",
  "_open_option", "lock_allowing", "open_lock_option", "allowing_option",
  "allowing_all", "open_option_sequential", "osvs_input_mode",
  "perform_statement", "$@138", "perform_body", "$@139", "$@140",
  "_end_perform", "end_perform_or_dot", "perform_procedure",
  "_perform_option", "perform_test", "cond_or_exit",
  "perform_varying_list", "perform_varying", "_by_phrase",
  "purge_statement", "$@141", "raise_statement", "$@142", "raise_body",
  "exception_name", "read_statement", "$@143", "read_body", "_read_into",
  "_lock_phrases", "ignoring_lock", "advancing_lock_or_retry",
  "_retry_phrase", "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "_end_read",
  "ready_statement", "receive_statement", "$@144", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "_end_receive", "release_statement", "$@145", "release_body",
  "reset_statement", "return_statement", "$@146", "return_body",
  "_end_return", "rewrite_statement", "$@147", "rewrite_body",
  "_with_lock", "with_lock", "_end_rewrite", "rollback_statement",
  "search", "search_statement", "$@148", "$@149", "search_body",
  "search_all_body", "_search_varying", "_search_at_end", "end_pos_token",
  "search_whens", "search_when", "_end_search", "send_statement", "$@150",
  "send_body", "send_body_mcs", "message_tag_data_item",
  "_from_identifier", "from_identifier", "send_body_cd", "with_indicator",
  "_replacing_line", "set_statement", "$@151", "set_body", "on_or_off",
  "up_or_down", "set_environment", "set_attr", "set_attr_clause",
  "set_attr_one", "set_to", "set_up_down", "set_to_on_off_sequence",
  "set_to_on_off", "set_to_true_false_sequence", "set_to_true_false",
  "set_last_exception_to_off", "set_thread_priority", "sort_statement",
  "$@152", "sort_body", "@153", "_sort_key_list", "_key_sort_list",
  "_sort_duplicates", "_sort_collating", "sort_input", "sort_output",
  "start_statement", "$@154", "start_body", "_sizelen_clause",
  "_start_key", "start_op", "not_equal_op", "_end_start", "stop",
  "stop_statement", "$@155", "stop_returning", "_status_x",
  "stop_argument", "stop_literal", "string_statement", "$@156",
  "string_body", "string_items", "$@157", "string_item_list",
  "string_item", "_string_delimited", "string_delimiter", "_with_pointer",
  "_end_string", "subtract_statement", "$@158", "subtract_body",
  "_end_subtract", "suppress_statement", "$@159", "_printing",
  "terminate_statement", "$@160", "terminate_body", "transform_statement",
  "$@161", "transform_body", "unlock_statement", "$@162", "unlock_body",
  "unstring_statement", "$@163", "unstring_body", "_unstring_delimited",
  "unstring_delimited_list", "unstring_delimited_item", "unstring_into",
  "unstring_into_item", "_unstring_into_delimiter", "_unstring_tallying",
  "_end_unstring", "validate_statement", "$@164", "validate_fields",
  "use_statement", "$@165", "use_phrase", "use_file_exception",
  "_use_global", "use_file_exception_target", "use_for_debugging",
  "debugging_list", "debugging_target", "_all_refs", "use_at_start_end",
  "program_start_end", "use_before_reporting", "use_after_exception",
  "use_exception_list", "use_exception", "use_ex_keyw", "write_statement",
  "$@166", "write_body", "from_option", "write_option", "before_or_after",
  "write_handler", "_end_write", "xml", "xml_generate_statement", "$@167",
  "xml_generate_body", "$@168", "$@169",
  "_with_encoding_xml_dec_and_attrs", "with_encoding_xml_dec_and_attrs",
  "with_encoding_xml_dec_and_attr", "encoding_xml_dec_and_attr",
  "_xml_gen_namespace", "_xml_gen_namespace_prefix", "_xml_name_of",
  "identifier_name_list", "identifier_is_name", "_json_name_of",
  "json_identifier_name_list", "json_identifier_is_name", "_type_of",
  "identifier_type_list", "identifier_is_type", "_xml_type", "ml_type",
  "_xml_gen_suppress", "xml_suppress_list", "xml_suppress_entry",
  "xml_suppress_generic_opt", "xml_suppress_when_list", "_end_xml",
  "xml_parse_statement", "$@170", "xml_parse_body", "$@171",
  "_with_encoding", "_returning_national", "_validating_with",
  "schema_file_or_record_name", "_accept_exception_phrases",
  "_accp_on_exception", "accp_on_exception", "escape_or_exception",
  "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_common_exception_phrases",
  "_common_on_exception", "common_on_exception",
  "_common_not_on_exception", "common_not_on_exception",
  "on_size_error_phrases", "_on_size_error", "on_size_error",
  "_not_on_size_error", "not_on_size_error", "_on_overflow_phrases",
  "_on_overflow", "on_overflow", "_not_on_overflow", "not_on_overflow",
  "return_at_end", "read_at_end", "_at_end_clause", "at_end_clause",
  "_not_at_end_clause", "not_at_end_clause", "at_eop_clauses",
  "_at_eop_clause", "at_eop_clause", "_not_at_eop_clause",
  "not_at_eop_clause", "_invalid_key_phrases", "invalid_key_phrases",
  "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "_count_in", "condition", "expr", "partial_expr", "$@172", "expr_tokens",
  "expr_token", "condition_no_is", "expr_no_is", "partial_expr_no_is",
  "$@173", "expr_tokens_no_is", "expr_token_no_is", "_not_expr",
  "not_expr", "condition_or_class", "eq", "gt", "lt", "ge", "le",
  "exp_list", "_e_sep", "exp", "exp_term", "exp_factor", "exp_unary",
  "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_file_name_list", "file_name", "cd_name",
  "report_name", "mnemonic_name_list", "mnemonic_name", "entry_name_list",
  "entry_name", "procedure_name_list", "procedure_name", "label",
  "integer_label", "reference_list", "reference", "_reference",
  "single_reference_list", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "unique_word", "target_x_list", "target_x", "_x_list", "x_list", "x",
  "call_x", "x_common", "length_of_register", "report_x_list", "expr_x",
  "arith_x", "arith_nonzero_x", "numeric_literal", "non_numeric_literal",
  "nonzero_numeric_literal", "prog_or_entry", "alnum_or_id",
  "simple_display_value", "inspect_from", "inspect_to", "simple_value",
  "simple_all_value", "id_or_lit", "id_or_lit_or_func",
  "id_or_lit_or_length_or_func", "num_id_or_lit", "positive_id_or_lit",
  "pos_num_id_or_lit_or_zero", "pos_num_id_or_lit", "from_parameter",
  "sub_identifier", "table_identifier", "sub_identifier_1",
  "display_identifier", "numeric_identifier", "identifier_or_file_name",
  "identifier_field", "type_name", "identifier", "identifier_1",
  "identifier_list", "validate_for_identifier_list", "for_identifier",
  "target_identifier", "target_identifier_1", "target_identifier_single",
  "display_identifier_or_alphabet_name", "qualified_word",
  "unqualified_word", "$@174", "unqualified_word_check", "subref",
  "refmod", "integer", "symbolic_integer", "unsigned_pos_integer",
  "integer_or_zero", "class_value", "figurative_constant", "literal",
  "basic_literal", "basic_value", "zero_spaces_high_low_values",
  "function", "func_no_parm", "func_one_parm", "func_multi_parm",
  "func_refmod", "func_args", "trim_args", "length_arg", "$@175",
  "numvalc_args", "locale_dt_args", "formatted_datetime_args",
  "formatted_time_args", "not_const_word", "flag_all", "flag_duplicates",
  "_flag_initialized", "_flag_initialized_to", "_to_init_val",
  "_flag_next", "_flag_not", "flag_optional", "flag_rounded", "round_mode",
  "round_choice", "flag_separate", "_from_idx_to_idx", "_dest_index",
  "error_stmt_recover", "verb", "scope_terminator", "_dot",
  "_dot_or_else_end_of_file_control", "level_number_in_area_a",
  "_dot_or_else_end_of_file_description",
  "_dot_or_else_end_of_communication_description",
  "_dot_or_else_end_of_report_description",
  "_dot_or_else_end_of_report_group_description",
  "_dot_or_else_end_of_record_description", "_file_control_end_delimiter",
  "_file_description_end_delimiter", "_record_description_end_delimiter",
  "_dot_or_else_area_a", "_advancing", "_after", "_are", "_area", "_areas",
  "_as", "_at", "_before", "_binary", "_box", "_by", "_character",
  "_characters", "_collating", "_contains", "_controls", "_control",
  "_data", "_end_of", "_erase", "_every", "_file", "_for", "_from", "_in",
  "_in_equal", "_in_order", "_index", "_indicate", "_initial", "_into",
  "_is", "_is_equal", "_is_are", "_is_are_equal", "_is_in", "_key",
  "_line", "_line_or_lines", "_limits", "_lines", "_lock", "_message",
  "_mode", "_new", "_number", "_number_or_numbers", "_of", "_on",
  "_on_for", "_onoff_status", "_other", "_others", "_procedure",
  "_program", "_protected", "_record", "_records", "_right", "_sign",
  "_signed", "_sign_is", "_size", "_standard", "_status", "_symbolic",
  "_tape", "_terminal", "_then", "_times", "_to", "_up", "_when",
  "_when_set_to", "_with", "_with_for", "_exception", "at_end",
  "on_escape", "on_exception", "column_or_col", "columns_or_cols",
  "column_or_cols", "column_or_col_or_position_or_pos", "comp_equal",
  "exception_or_error", "file_limit_or_limits", "in_of", "label_option",
  "line_or_lines", "lock_records", "object_char_or_word_or_modules",
  "records", "reel_or_unit", "size_or_length", "length_of",
  "track_or_tracks", "using_or_varying", "detail_keyword", "ch_keyword",
  "cf_keyword", "ph_keyword", "pf_keyword", "rh_keyword", "rf_keyword",
  "control_keyword", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973,   974,
     975,   976,   977,   978,   979,   980,   981,   982,   983,   984,
     985,   986,   987,   988,   989,   990,   991,   992,   993,   994,
     995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,  1004,
    1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1052,  1053,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,
    1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,
    1175,  1176,  1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    1185,  1186,  1187,  1188,  1189,  1190,  1191,  1192,  1193,  1194,
    1195,  1196,  1197,  1198,  1199,  1200,  1201,  1202,  1203,  1204,
    1205,  1206,  1207,  1208,  1209,  1210,  1211,  1212,  1213,  1214,
    1215,  1216,  1217,  1218,  1219,  1220,  1221,  1222
};
#endif

#define YYPACT_NINF (-4173)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-3435)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -4173,   509,  1846, -4173, -4173, -4173,  1193, -4173,   -98, -4173,
    1261,  2034,   552, -4173,  1222,   780, -4173, -4173,  1499, -4173,
   -4173, -4173, -4173, -4173,    47, -4173, -4173,  1648, -4173, -4173,
    1531,  1715, -4173, -4173, -4173, -4173, -4173, -4173,  1111,   -98,
    1129,   -98,  1813,  1610, -4173,  1901,  1928, -4173,  1726,  3241,
    1442, -4173,   780,  2028,   -42,  1991,   -42,  2058,   780, -4173,
    1638,  1634,  2084, -4173, -4173,  1629,  2165, -4173, -4173, -4173,
    1761,  2171,   164,   164,  1716,  1811,  1610,  1610,  1610,   164,
    1823,   780,   780,  1610,   780,   780,  1723, -4173, -4173, -4173,
     164, -4173,  3241, -4173, -4173, -4173, -4173, -4173, -4173,   195,
   -4173, -4173, -4173, -4173, -4173,  2203, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   780, -4173,
   -4173, -4173, -4173, -4173,  2531, -4173, -4173,  1991, -4173,  2531,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2152,  1610,
    2200,  1182, -4173,  1932, -4173,   780,   780,   780, -4173, -4173,
   -4173, -4173,   259,  1610, -4173,  1610,  1738,  2546,  1738,  1610,
    1610, -4173, -4173,  1738, -4173, -4173, -4173,  1753,   -22,  1610,
   -4173, -4173, -4173, -4173, -4173,  1926,  1778, -4173, -4173,  1992,
    2274,  -111,  1007, -4173,   964,  1007, -4173,  1610,   131,  2050,
     780, -4173, -4173, -4173, -4173,   780,     8, -4173, -4173, -4173,
     -65,   259, -4173,  1610,   305,  1738,  2293,    33, -4173, -4173,
   -4173, -4173,  2298,  1914,   770,    62, -4173,  1845, -4173,  1753,
   -4173,  1610,  1847,   164,   921, -4173, -4173, -4173, -4173, -4173,
    2090,   -66,  1610,   159, -4173, -4173,  1943, -4173,  1947,   295,
   -4173, -4173,   780, -4173,  2150,   780,   391, -4173, -4173, -4173,
   -4173,  1610, -4173,  2565,  6039, 11988, -4173, -4173, -4173,  1855,
   -4173,   113,   165,   780, -4173, -4173, -4173,   263, -4173, -4173,
   -4173,   308,  1673, -4173, -4173, -4173,  -279, -4173, -4173,  1738,
   -4173,  2051, -4173,  2038, -4173,  1610, -4173, -4173,   777, -4173,
   -4173, -4173, -4173, -4173,   771,  2689,  2692,   155,  1881, -4173,
     220, -4173, -4173,    50, -4173,  1158, -4173,  1847, -4173,   143,
   -4173, -4173,  1733, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  1984, -4173,   -66, -4173,  2414,   164,
     164, -4173,  2090,   182, -4173,  -234, -4173,   780, -4173, -4173,
    2205, -4173,  2695, -4173,   780, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  1528, -4173, -4173, 12173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  2492, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173,    39, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173,  2832, -4173, -4173, -4173,
   -4173, -4173,  1601, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,    44, -4173, -4173, -4173, -4173, -4173,  2108,
    2700, -4173,   495,  1139, -4173, -4173, -4173,  1828,  2685, -4173,
    2272,  1631, -4173,   286, -4173, -4173, -4173, -4173, -4173, -4173,
    1610,  1610, -4173, -4173, -4173,  1941, -4173,  2019, -4173, -4173,
   -4173,  2247, -4173, -4173, -4173,  1610,  2387, -4173, -4173, -4173,
   -4173,   815,  1610, -4173, -4173,  2109,  2439, -4173,  2531,  1561,
    2531,  2017, -4173, -4173,  2018,  2660, -4173, -4173, -4173, -4173,
   -4173,  2396, -4173,  1733,   164, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  2645, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,   606, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  -205,  6952, 18656,  -177,   606,   188,
    1695,  1209,  2861,  -385,   174,   -72,  6571, 16269,   -72,  1185,
     217,  2758,  1871,  1209,  1738,  2040,  1167,  9813,  1209,  1936,
      26,  2816,  1738,    26, 11111, 16269,  2132,  2575,  -101,  1942,
     -20,  1950,  1942,  1738,  1950,  1241,  -321,   472,  1738,  1950,
   -4173,  9418,  2255,  1936,  1738,  1950,  4409,  1738,  1241,  2515,
     606, -4173, -4173, -4173,  1738, -4173, -4173, -4173, -4173, -4173,
    1738, -4173, -4173, -4173, -4173, -4173, -4173,  2033, -4173, -4173,
     260,  1237, -4173,  2156,  2416,  1753,  1753,  1753,   630,  1237,
    7544, -4173, -4173, -4173,   219, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  2313, -4173,   164,  2272,  2040,  2040,
    2324,  2272,  2272,  2040,  2272,  2272,  2040,  2272,  2272,  2053,
   -4173,  2598,   803, -4173, -4173, -4173,  2876,   824, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173,  1342,  1869, -4173, -4173,
    1673,  2433,  2387, -4173, -4173,  1124, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  2401, -4173,  2396, -4173, -4173,
   -4173,  1610, -4173,  2061,  1222,  1222, -4173, -4173, -4173, -4173,
   -4173, -4173,  1969, -4173, -4173,  1781,  2661, -4173, 18737,  2054,
    2415,  2554,  2324, -4173, -4173, -4173,  1738, -4173, -4173,  2059,
    2060,  2062, -4173, -4173,  2063,    33,    33,  2064,  2065,  2069,
   -4173, -4173,  2070,    33, -4173, -4173, -4173,  1738,  2073, -4173,
    2062, -4173,  2680, -4173, 12892, -4173, -4173, 10670, -4173, -4173,
   -4173,  2077,  2078,  2079, -4173, 19306, 19306, 18656, 19306, -4173,
      89,   581, -4173,  2627, -4173, -4173, 10670, -4173, -4173,  2529,
    2260,  1984, -4173, -4173,  -177, -4173,  2105, -4173,    33, -4173,
    2696,  -101, -4173, -4173, -4173, -4173,   811, -4173, -4173, -4173,
   -4173, -4173,  1950, -4173,  1556,  2324,  2698, -4173,   151, -4173,
    2238, -4173, -4173,  2033,  1984, -4173, -4173,  1950,  2701,  2302,
    2790, -4173, -4173,  1738,  2143,  2147, -4173, -4173, -4173,  1942,
   -4173,  2594, -4173,  1806,  2887, -4173, -4173, -4173, -4173, -4173,
    2718,  1521, 15326, -4173, -4173, -4173, -4173,  2035,  2054, -4173,
   -4173, -4173, -4173, -4173,  2594, 14793,  1853,  1857,  2807,  2720,
    1254, -4173, -4173, -4173,  2721,   147, -4173, -4173, -4173, 14651,
    -256, -4173, -4173, -4173, -4173, -4173,  2467, -4173, -4173,  2793,
    1167, -4173, -4173, -4173,  1209, -4173, -4173, -4173, -4173, -4173,
    2703, -4173,   -53, -4173, 16269, -4173, -4173,  2157, -4173, -4173,
     503, -4173,  1936, -4173, -4173,  1738, 13683,  1068, -4173,  1165,
   -4173, -4173,   217, -4173, -4173, -4173,  2128, 12910,  1068,  2724,
   16269, -4173,  2148,  2725,  2900, -4173, -4173,  2021, -4173,  1662,
   -4173, -4173, 16508,  2161, -4173, -4173,  2052, -4173, -4173,  2728,
     -63,  2730,   -97, -4173,  2642, -4173,  2734,  2302,  2066,  2735,
   -4173,  2642, 16269, -4173,  2732, -4173,  2650, 10670,  2709, -4173,
   -4173, -4173, -4173, -4173, -4173,  2511, -4173,  1209, -4173, -4173,
   -4173,  2386,  -154, -4173,   280,  2979, -4173,   124, -4173,  2745,
    2048,  2749,  2599, 16269,  1738,  1738,  2750, 15684, -4173, -4173,
    1936, -4173, -4173,  2907, -4173, -4173,  1885, -4173,  2751,  2814,
   -4173, -4173,  1738, -4173,  2752,  2642,  2190,  2562, -4173,  1738,
    1738,  1738,  2763,  2112, -4173,  8371, -4173, 18656,  2179, -4173,
    1738,  1738, -4173,   201, -4173, -4173,  1239, -4173, -4173, -4173,
    6296, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,   780, -4173,  2301,  2570, -4173, -4173, -4173,  2359,
    1237, -4173,  2198, -4173, -4173, -4173,  2882, -4173, -4173,  2846,
   -4173, -4173,  1738,  1738,  2387, -4173,  2387,  1950,  1950,  2387,
    1950,  1950,  1738,  1950,  1950, -4173,  2226, -4173,  1152, -4173,
   -4173, -4173, -4173,  2699, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   925,
   -4173,   204, -4173, -4173, -4173, -4173, -4173, -4173, -4173,    98,
   -4173, -4173, -4173, -4173, -4173, -4173,  2110,   -64, -4173, -4173,
    -390,  1610, -4173,  1531,  1928,  1928, -4173,   106, -4173, -4173,
   18737,   907, -4173, -4173,  1610, -4173, 18737, -4173, -4173, -4173,
    1215,  2219, 19204,    43,  1738, -4173,  2879,  3799,    21,  2227,
   18656, 18656, 17323,  2077, -4173,  2129,  2130, 18656, 18656, 18656,
   10670,  2131,  2230, 10670,  2077, -4173, -4173, 16337,  2710, -4173,
   -4173,  1984, -4173, 18656, -4173, 10670, 18656, -4173, -4173,  1780,
   -4173,  2667, 18656, 18656, 18656, 18656, 18656, 18656, 18656, 18656,
   18656, 18656, 18656, 18656, -4173,  1984, -4173, -4173,  2606, -4173,
    2449,  2613, -4173, -4173,  4409, -4173,  1738,  1556, -4173, -4173,
   -4173,  1463,    36,  1738, -4173, -4173, -4173, -4173, -4173, 18656,
    2582, -4173,  2179, -4173, 18656,   -24, -4173, -4173, -4173, -4173,
    2388, -4173, -4173, -4173, -4173, -4173, -4173,   216,  2035, -4173,
    2149, -4173, 16269, -4173, -4173, -4173, -4173, -4173, -4173,  2532,
      71, -4173, -4173, -4173, 14793,   446,  5232, -4173,  1804,  2196,
    2154,  1521,  1521,  1521,  1521, 15326, -4173, -4173, 16269, 16337,
   -4173, -4173,  1185, -4173, -4173,  2158, -4173,   -12, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  -227, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, 14188, -4173, -4173,
   -4173,  3059,   161, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
    2621,    27,  2792, -4173, -4173, -4173,  2851,  2320,  2770, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,   885, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2387, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   885,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, 13683, -4173,   885,   885,
     885,  1068, -4173,   118,   150, 18656, -4173, -4173,   800, 11305,
   -4173, -4173,   179, 17105,  1068, -4173, -4173,  2262,  1209, -4173,
   -4173, 16337, -4173, -4173, -4173, -4173, -4173,  2342,  2324, -4173,
    1551, -4173,  2723,  2723,  -399,  2271,  1575,  2269, -4173,   692,
   -4173, -4173,  2281, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
    2302, -4173, -4173, -4173, -4173,  2688,   217, -4173, -4173, -4173,
    2690, -4173, -4173, -4173,  2388,  2650, -4173,  1738,  2168,   258,
    2275, -4173, -4173,  1984, -4173,  2276, -4173, -4173,   363,  2279,
    2090, -4173, -4173, 15176, -4173,  3021,  1310,   172, -4173, -4173,
   -4173,  1610, -4173,   838, -4173, -4173,  1738, 16269, -4173,  2908,
    2762,  2764, -4173, -4173, 16337, -4173,  2767, -4173, -4173, -4173,
   -4173, -4173,  3022,  2708, -4173, -4173, -4173,  2178, -4173,  1969,
    2869,  2777,  2869,  2719,  2763,  1660, -4173, -4173,  1738,  1660,
   16269, -4173, -4173,  1339,   394,  1697, 18656, -4173,  2863,  2783,
    2863,   -38, -4173, -4173, -4173,   154,   113, -4173,   780, -4173,
    2407,  2460,  1769,  1301, -4173, -4173, -4173,  7096,  1301,  2982,
    1610,  1937,  1937,  1610,    54,  2152,  1610,  3122,  2576, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   164,
   -4173,  1948,  8592,  1738, -4173,  2272,  2272,  -388,  1950, -4173,
    1950,  2272,  1950,  1950,  2272,  1950,  1950, -4173,  2982,  2324,
    2324,  2482,  1950, -4173, -4173, -4173,   925, -4173, -4173, -4173,
   -4173,    33, -4173, -4173,   679, -4173, -4173,  -390,  2375,  2570,
    2522,  2522,   160, -4173, -4173,  2451,  2291, -4173, -4173, -4173,
   -4173,  3072, -4173, -4173, -4173,  2592, -4173, -4173, -4173, -4173,
    2592,   844, -4173,  1610, -4173, -4173, -4173, -4173, -4173,  1610,
   -4173, -4173,  1610, -4173,  1610, -4173, -4173, -4173, -4173, -4173,
     156, -4173, -4173, -4173,    80, -4173, -4173, -4173, -4173, -4173,
   -4173,    24, -4173, -4173, -4173,  3150, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  2731,  2390,   893, -4173,  3017,  1432, -4173,
   -4173, -4173, -4173, -4173,  2291, -4173, -4173, -4173,  2208,  2211,
   -4173, 10670,  2291,  2733,  2377,  2383,  2610, -4173, -4173, -4173,
   -4173, -4173,  2666, -4173, -4173, -4173, -4173, -4173, -4173,   947,
   -4173,  1738,   404,  1729,  2336,   417,  2337, -4173,   435, -4173,
    -198, 10670, -4173, -4173,   479,  2339,  2340,  2343,   451, -4173,
    1984, -4173,  2344, -4173,  1738,   457,  2345, -4173,  2324,  2821,
    1736, -4173,   413,   392,  1209,  1870,  2349,   492, -4173,  2352,
    2606,   581,   581, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  2387,  2491,  2354,  -177, -4173, -4173,  1409,
    3152,   806, -4173, -4173,  2494,  2521, -4173,  1494,  1610, -4173,
   -4173,  1368, -4173, -4173,  2297,   929, -4173, -4173, -4173,  2768,
   -4173, -4173, 16269, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
     983, -4173, -4173, 10569, -4173, -4173,  3604,   800, -4173, -4173,
   -4173, -4173,   -49, -4173,  1610, -4173,   366,   800, -4173, -4173,
   -4173, -4173,    28,  1610, -4173, -4173, -4173,  5232, -4173, -4173,
    1804, -4173, -4173,  1984,  1738, -4173, -4173, -4173, -4173, -4173,
   -4173,  1521,  2835,  1736,  2837, -4173,  9149,  2619, -4173, -4173,
   -4173, -4173, -4173, -4173,  2257,  3059, -4173, -4173, -4173, -4173,
   -4173,  2040, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  2880,  1667,   166,  2054, -4173,  1180, -4173,
    2272, -4173, -4173, -4173, -4173, -4173,  2954, -4173,  2040, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173,  2530,  2040, -4173, -4173,
   -4173,  1738, -4173, -4173,  1738, -4173,  1738,  1738,  1738, -4173,
    1672,   202, -4173, -4173,  2533, -4173, -4173,   133,  1440,  2980,
   -4173, -4173,   950, -4173, -4173, -4173, -4173, 15713, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173,  1209,  1209,  1736,  2853,  2168,  2388,  1575,  2818, 16584,
      34,  9634,  1738,  -177,  2378, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  2178,  2690,  1738, -4173, -4173, -4173, -4173,
    1738,   504,   998,  2523, -4173,  2178,    51, 10670,  2652,  1477,
     909, -4173,  2324,   947,  2651, -4173, -4173, -4173, 16269,  2090,
    2090,  2090,  2090,  2090,  2090,  2090,  2090,  1310, -4173,   917,
     929,  1027,  -261, -4173,  3022, -4173,  1738,  1738,  1736,  2859,
    1672, -4173,  3217,  1738,  -230, -4173, -4173,  2388,  3222,  2759,
    2322, -4173, -4173,  1738, -4173,  1738, -4173, -4173, -4173,  2303,
   -4173, -4173,  2304, -4173,  2442,  2442, -4173, -4173, -4173, 18656,
   18008,  1697, -4173, -4173,  1738, -4173,  2534,  2988,  2387, -4173,
   -4173, -4173, -4173,   780, -4173,  2512,  1610,  3122,  1234, -4173,
    2328, -4173,  2883,  1738,   972, -4173,  2316,  1610,  1610,  1610,
    1201,  2318,  2543,  1738,  1365, -4173,  2321,  1738,  3225,  2325,
    2838,   -47,  2040,  1610,  1610,  1610,  1424,  2317, -4173, -4173,
   17229, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, 13045, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  1590,   851,   329,  2894, -4173,  2387,  1778,
    1300,  1300,  2323,  -142,   959,  2387,  2341,  1610, -4173, -4173,
   -4173,    58,  1768, -4173, -4173, -4173,   824, -4173,  5992, -4173,
    1950,  1950, -4173, -4173,  2272, -4173,  1950,  1950,  1950,   668,
    1950, -4173,  1950,   925, -4173,  2110,  1610,  1610,  2326, -4173,
    2488, -4173, -4173, -4173,  1991,  2058, -4173, -4173, -4173,  2798,
     168,   168,   740, -4173, -4173, -4173, -4173, -4173, -4173,  2115,
    1738,  1940, -4173, -4173, -4173, -4173, -4173,   907,   907, -4173,
   -4173, -4173, -4173,   907,   907,   844,   907, -4173, -4173, -4173,
    1610,   950, -4173,   950, -4173,   844,  2818,  1610,  2427,   939,
    2803,  2803, -4173, -4173, -4173,  2291, -4173, -4173, -4173, -4173,
   -4173, -4173,   183, -4173, -4173, -4173, -4173,  2238, 18056,  2077,
   18213,  2077, -4173,  2434,  2077, -4173,  1738,  2077,  2077,  2077,
   10670,  2077,  2238,   902,  2077,    21, -4173, -4173, -4173,  2713,
    2507,   820,  2910,  1736, 18566,  2077,  2077,  1100, -4173,  2491,
   -4173,  1209, -4173, -4173, -4173,  2723, -4173, -4173, -4173, -4173,
   -4173,  2755, -4173, -4173, -4173,   391, -4173, -4173, 18656, -4173,
   -4173, -4173, -4173,  2726,  2856,   987,  2196,   788, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   907, -4173,
   -4173,   907, -4173, -4173, -4173, -4173,   989,  3030,   907,   950,
     950,   907, -4173, -4173, -4173,  3012,  3012, -4173,  1209, -4173,
    1209, -4173, -4173, -4173, -4173,  3269, -4173,  2459,    85,  9149,
   -4173, -4173, -4173, -4173, -4173,  3206, -4173, -4173, -4173,  2965,
    1667,  3006, -4173, -4173, -4173,  1738, -4173, -4173, -4173,  3053,
    2382,  1501,   307,  2391, -4173, -4173, -4173, -4173, -4173,  2465,
   -4173, -4173,  1984, -4173,  3220, -4173, -4173, -4173,  1670, -4173,
    1672,  2841, -4173, -4173, -4173,  2561, -4173, -4173,  2733,  1005,
   -4173, -4173, -4173, 16269, -4173,  1209, -4173,  1209,   330,  1950,
   -4173,  1738, -4173, -4173,   153, -4173, -4173, -4173,  3306, -4173,
    2955, -4173, -4173, -4173,   505,  1148, -4173, -4173, -4173,  2765,
    1660, -4173,   929, -4173,  1573,  1738,  2633, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,    19, -4173,
   16269, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173,   256, -4173,  1738, -4173, -4173,  1754, -4173, -4173, -4173,
   18656,  -173,  2712, 15760,  2238,  2238, -4173,  1209,  2483, -4173,
    2738, -4173, 10670, -4173,  3111,  2514, -4173,   998, -4173,  1097,
   -4173, -4173, -4173, -4173,  3154,    17, -4173, -4173,  9813, -4173,
    2304, -4173, 16269, 16269,  1729, -4173,  1792,  3154,  2819,  2418,
   10670,  2495, -4173,  3235,   113, -4173,  2602, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
    2513, -4173, -4173,  1234, -4173,  1610, -4173,  2524, -4173, -4173,
   -4173,  2397,   186, 15923,  1209, -4173, -4173, -4173,  3153, 10514,
   -4173, -4173,  2487, -4173,  3256,  2476,  2517,  1127, 10514, -4173,
   -4173,  1738, -4173, -4173, -4173, -4173, -4173,  2420,  9694,  1209,
    1234,  2506,  3122,  1234,  3004,  2317, -4173, -4173, -4173,   744,
    1221,  1357,  1370,  1460,  3356, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173,  4944, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  3334, -4173,  3022, -4173,  2569,
    2620,  2620,  2429, -4173,  1234, -4173,  2536,  3019, -4173, -4173,
   -4173,  2323, -4173, -4173, -4173, -4173, -4173, -4173,  2905,   122,
    2818,  1141,  1610, -4173, -4173,  1610, -4173, -4173,  2152,  2733,
    2302,  2040, -4173, -4173, -4173, -4173,  2625,  2733,  1610,  3257,
     266,   -58,   883,  2168, -4173, -4173,  1610,  1610, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2583, -4173,  2902,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  2630,  3316,  1300,  1950,  1950,  1950,
    1950,  1950,  1950, -4173,  2766, -4173, -4173,  3364, -4173, -4173,
   -4173, -4173, -4173,  1187,  2705,  3155, -4173, -4173, -4173,    92,
   -4173,   699,  -203,    92, -4173, -4173,   154, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,   987, -4173,  1944, -4173, -4173,  1738,   909, -4173,
   -4173,  2544, -4173, -4173, -4173,  1610,   707, -4173, -4173,  1123,
   -4173, -4173, -4173, -4173,  2077, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  3028, -4173, -4173, -4173,  3025, -4173, -4173, -4173,
   -4173, -4173, -4173,  3029, -4173, -4173,  1799, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  1969,  3166, -4173,  1587, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173,   800,   800,   800,   800,
   16269, -4173,   788, -4173,  5211, -4173, -4173, -4173, -4173,  2324,
   -4173, -4173, -4173, -4173, -4173, -4173,  1903,   907,  2876, -4173,
   -4173, -4173, 19102, -4173, -4173, -4173,   761, -4173, -4173, -4173,
   -4173,  4974, 19102,  1736,  2711,  1736,  2727,  9149, -4173, -4173,
   -4173, -4173, -4173,  3269,  1667, -4173,  2716, -4173,  1100, -4173,
   -4173, -4173, -4173,  1501, -4173,  3153, -4173, -4173,  2040, -4173,
    1100, 10670, -4173, -4173,  3313, -4173,  2191, -4173, -4173,  2841,
   -4173,  2191,  3054,  3055,  -138, -4173, -4173,  2822, -4173, -4173,
   16090,  1736,  2825,  2825,  2831, -4173,  1770, -4173,  3148, -4173,
   -4173, -4173,  1738, 16269,  2272,  2936,  2981, -4173,  1615, -4173,
   -4173, -4173,  1229, -4173, -4173, -4173,  3228,  2881, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  2940, -4173, -4173,  2961, -4173,
    2324,  2324, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  1729,
   -4173, -4173, -4173,  2864,  2571,  1610, -4173, -4173, -4173,  1123,
    3028,  1736,  1100,  3217, -4173,  2818,  3154,  2818,  -173,  1741,
   -4173, -4173,  2153,   108,  2818, -4173,  2915,  3210, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2168,  2800,
   -4173,  2539, -4173, -4173,   164,   113, -4173,   113,   780,  2694,
     835,   325, -4173,  2089,  1738, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  1209, -4173,
   -4173, -4173, -4173, -4173, -4173, 14524,  2963, -4173, -4173,  2818,
    3078,  2605,  2387,  2605,  2272,   119, -4173, -4173, -4173, 10298,
   -4173, -4173, -4173,  2771, -4173, -4173,  2316, -4173, -4173, -4173,
    2973, -4173,  1234,  1234, -4173,  2890, -4173, 19522,  3355, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  5412,  2975, -4173,   987,   981, -4173, -4173,  3257,
   -4173, -4173, -4173,  1234, -4173,  2387,   158,  1738, -4173, -4173,
   -4173, -4173,  2387, -4173,  2038, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,   990,   990,  1610,  1610,  2733,   236, -4173,
    1610,  1852,  1610,  1610,  1610,  1610, -4173,  2432, -4173,   330,
     959,  2387,  1610,  2152,  2875, -4173,  2697,   959,  1950, -4173,
    2387, -4173,   925,  1132,   317, -4173, -4173, -4173, -4173,  1187,
     104, -4173, -4173, -4173,   106, -4173,  1610,  2682,  2867, -4173,
   -4173, -4173, -4173,  3245, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,   909, -4173, -4173, -4173,  3047,  3240, -4173,  2322,
   -4173, -4173, -4173,  3012, 16269, 16269, 16269, 16269, -4173, -4173,
   -4173, -4173, -4173,  1738, -4173,   800, -4173, -4173, -4173, -4173,
    2622,  -317, -4173, -4173,  1209, -4173,  1209, -4173, -4173, -4173,
    3368, -4173,  1128, -4173, -4173, -4173, -4173, -4173,  3373,  3258,
    2191, -4173, -4173,  2191,  1100,  2614,  2614, -4173,  3456,  3406,
   -4173, -4173, -4173,  2839,  1950,  1604,   -64,  1738, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,   205, -4173, -4173, -4173, -4173,
   -4173,  2938, -4173,  1170, -4173, -4173,  2941,  1517, -4173, -4173,
   -4173,  3380,  2993, -4173,  1610,  1149, -4173, -4173,  1332,  2998,
    3002, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173,  1950,  1950, -4173, -4173, -4173, -4173, -4173, -4173,  1738,
   -4173,  3240, -4173, -4173, -4173,  1738, -4173,  1738, -4173, -4173,
   -4173, -4173, -4173,  2926,  3194, -4173, -4173, -4173, -4173, 15128,
   -4173, 12356,    69,  1738,  2915,  2324,  2675, -4173, -4173, -4173,
     197,  1404,  2855, -4173, -4173,  2643, -4173, -4173, -4173, -4173,
     780, -4173,  2739, -4173, -4173, -4173,   723,  2639, -4173,  2324,
   -4173,  1234, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   14524, -4173,  2288, -4173, -4173, -4173,  2647,  2552,  2387,  2655,
   -4173,  3282, -4173,  3285,  1738,  2737,  2558, -4173, -4173, -4173,
     185,  2924,   115,   496, -4173,  3250, -4173,  1877,  -109,  2663,
   -4173, -4173, -4173, 19522, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  1017, -4173, -4173,  3032, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  2729, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  1738,   123,  2907,    84, -4173, -4173, -4173,
   -4173,   419,  1738,  1610, -4173, -4173,  4247, -4173,  1738, -4173,
   -4173,   959, -4173,  1738,  1738, -4173, -4173, -4173, -4173,  2907,
    -388,  1738,  1610,  1738, -4173,   959,  2677, -4173, -4173,  2992,
    3492,   112, -4173, -4173,  2451,  1376,  1610, -4173, -4173,  2574,
   -4173, -4173, -4173, -4173,   909,  3047,  1123,  1119, 19102, -4173,
   -4173, -4173, -4173, -4173,  1738,   800, -4173, -4173,  1123,  1123,
    1667, -4173, -4173, -4173, -4173, 16269, -4173, -4173, -4173,  2191,
   -4173, 16269, 16269, -4173, -4173,  1610,  1950,  1950,  2888, -4173,
   -4173,   710,  1778, -4173, -4173,  2929, -4173, -4173, -4173, -4173,
   -4173, -4173,  2812, -4173, -4173, -4173, -4173,  8276,  2631, -4173,
    1738, -4173, -4173,  2765,  1660, -4173, -4173, -4173, -4173, -4173,
   -4173,  1123, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, 16269, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173,  2675,  1738,  1738,  1521,  3009,   197, -4173,   191,  2581,
   -4173, -4173,  1610,  1686, -4173, -4173, -4173, -4173,  2686, -4173,
   -4173,  2590,  1610,  1738, -4173, -4173, -4173, -4173, -4173, -4173,
    2387,  3117,  2272,  2272,   313, -4173,  1610, -4173, -4173,  2324,
   -4173, -4173,  2244,  1090,  3179, -4173,  3237, -4173,  2973, -4173,
    2605,  3281,  2506, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,   959,   959, -4173, -4173, -4173,
   -4173,  3183,  3320, -4173,  2536,  2387, -4173, -4173, -4173, -4173,
   -4173,  1738, -4173, -4173, -4173, -4173,  3176, -4173, -4173, -4173,
   -4173,  3530, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   899,
    1204, -4173, -4173, -4173, -4173, -4173,   116,  -304, -4173, -4173,
   -4173,  1738,  1286,  1610,  2706,   959,  1610,  1610, -4173,   780,
   -4173, -4173, -4173,  1294,   807,   154, -4173,  2702,   909, -4173,
     -27,   229, -4173, 16269, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173,  -177,  1950,  1610,  1610,  1610,  1778, -4173, -4173, -4173,
   10670, -4173, -4173, -4173, -4173,  9813, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  1738, -4173,  1610,  1738, -4173, -4173, -4173,
    1610,  3033, -4173, -4173, 10670, -4173, -4173, -4173,  -177, -4173,
   -4173, -4173, -4173, -4173, -4173,  2385, -4173, -4173, -4173, -4173,
    2052,  2909,  3341,  2055,  2892,   856, -4173,  9813, -4173,   835,
   -4173, -4173,   313,  1738,  1738,  3022, -4173,  3141, -4173,  1440,
    2733,  1918,  2387, -4173, -4173,  2972, -4173, -4173, -4173,  1738,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173,  3515,  2272, -4173,
    2907, -4173,  -304,  1738,  2053, -4173, -4173, -4173, -4173,  1738,
   -4173, -4173, -4173, -4173, -4173,  1610, -4173,  2950, -4173, -4173,
   -4173,   861,  -189,   861, -4173,  1778,   959, -4173, -4173, -4173,
   -4173, -4173, -4173,  3060, -4173,   270,   909, -4173, -4173, -4173,
   -4173,  2999,   429, -4173,  2324, -4173, -4173, -4173, -4173, -4173,
    1738, -4173, -4173,  -177,  1778,  1778, -4173, -4173,  1984, -4173,
   -4173,  1521, -4173,  1224, -4173, 10670,  2324,  2687, -4173, -4173,
    2877,  2782,  2715,  2052, -4173,    59,  2272, -4173, -4173, -4173,
    -185, -4173, -4173,  8615, -4173, -4173,   856,  2722, -4173, -4173,
   -4173,   313, -4173, -4173, -4173, -4173,  1610,  1440, -4173, -4173,
   -4173,  1738, -4173, -4173,   959,  1738,  3320,    -8, -4173, -4173,
   -4173, -4173, -4173,    -8, -4173,  1738,  1738,   924, -4173, -4173,
    2854, -4173,  3079, -4173, -4173, -4173, -4173, -4173,  2801,   289,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  1738, -4173,
   -4173,  1132,   317, -4173, -4173, -4173,  3057,  1738,  2324,  2772,
    1521,  1738, -4173,  2290,  1950,  2740, -4173, -4173, -4173, -4173,
     180,  1080,  1772,  1936,  2741,  2370,  2742, -4173, -4173,  2326,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2950,   194,
    1610, -4173, -4173, -4173, -4173, -4173,  2995, -4173, -4173,  1610,
   -4173, -4173,  3058,  3557,  1610, -4173,  1738, -4173,  1610,  1738,
     239, -4173, -4173, -4173, -4173, -4173,  2946, -4173,  1950,  1706,
     180, -4173, -4173,    83,  3143,  3144,  3372,  3132, -4173,  1080,
   -4173,  1694,   862, -4173, -4173, -4173,  2480, -4173, -4173,  2326,
   -4173,  2787, -4173,  3353,  1738,   -87,   844,  3384,  1610,  1610,
   10670, -4173,  1158,  1738, -4173,  1610,   521,   814,   239, -4173,
   -4173,  1521, -4173,  2272, -4173, -4173, -4173,  3023,  1738, -4173,
    1610,  3027,  1738,  1610,  1610,  1610,  1610, -4173,  3161,   135,
    3164, -4173,  3156, -4173,  2408, -4173, -4173,  1738,  3429,  1800,
    3171,   137,  3173,  3160, -4173,  1121, -4173, -4173,  1738,  2794,
     321, 17690,   950, -4173, -4173, -4173,  2679, -4173, -4173, -4173,
    2009, -4173, -4173,  1120, -4173, -4173,  1778,  1778, -4173, -4173,
   -4173,   381, -4173, -4173, -4173,   381,   381, -4173, -4173, -4173,
   -4173, -4173, -4173,  3035, -4173, -4173, -4173,   134, -4173, -4173,
    1738,  2387, -4173,  1738,  1738,  1738,  1738,  1610,  1610,  1610,
    1610,  1610, -4173,  1738,  1610,  1610,  1610,  1610,  1610,  1610,
    1610,  1610,  1610,  1610,  1610, -4173,  1738,  1610,  1237,  2824,
   -4173,  1610, -4173, -4173, -4173, -4173,   926, -4173,  2592,  2592,
    1610,   800,   366,  1610,   217, -4173, -4173, -4173, -4173,  2592,
     800, -4173,  3379,  2387, -4173,  3505, -4173, -4173,   800, -4173,
   -4173,  1738, -4173, -4173,  1738,  1610, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  1733, -4173, -4173, -4173, -4173,  3253,  2592,
   -4173, -4173, -4173, 11305,   167,  1120, -4173, -4173,   154, -4173,
   -4173, -4173, -4173, -4173, -4173,   814, -4173, -4173, -4173, -4173,
   -4173,  1950, -4173,  2605, -4173, -4173, -4173, -4173,  1738,  1738,
    1738,  1738,  1738,  1738,  1738,  1738,  1738,  1738,  1738,  1738,
    1738,  1738,  1738,  1738,  1738,  1738,  1738, -4173, -4173,  1300,
    1300,  2136, -4173, -4173, -4173, -4173,  3254,  3497,   -59,   907,
   -4173, -4173, -4173,  1610, -4173,  1610,   907,   950, -4173, -4173,
     907, -4173, -4173,   907,  2605,  1610,   950, -4173, -4173, -4173,
    1984, -4173, -4173, -4173, 11305,  1733, -4173, -4173, -4173, -4173,
   -4173, -4173,  3141, -4173, -4173, -4173, -4173, -4173,  1738, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
    1738, -4173, -4173, -4173,  1300,  1300,   930,   221, -4173,  1610,
   -4173, -4173,  1738,  1738, -4173, -4173, -4173,  1117,  1117, -4173,
   -4173, -4173, -4173, -4173,   227, -4173,   987, -4173, -4173, 17847,
   -4173, -4173, -4173,  1738,  1738, -4173, -4173, -4173, -4173, -4173,
    1888, -4173, -4173, -4173,  8183, -4173,   987,  1738, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173,   907, -4173, -4173,
     907, -4173, -4173, -4173, -4173, -4173,  1738, -4173,  2183,  1070,
    1153, -4173, -4173,   930,  1237, -4173, -4173, -4173, -4173, -4173,
    1738,  2355,  1610,  1610,  2458,  1610, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  2068, -4173, -4173, -4173,  1738, -4173, -4173,
    1610,   930,   930, -4173,  3246,  1610,  1610,   930,  4732,  1738,
     930, -4173, -4173, -4173,   930,   930, -4173, -4173, -4173, -4173,
    3223,  2159,  3122,  1610,  2387, -4173,  1610,  2324,   859, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173,  1234, -4173, -4173, -4173,
   -4173, -4173, -4173,   184, -4173, -4173,   952, -4173,  1105, -4173,
   -4173, -4173, -4173, -4173,  2159,  1738, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  1300, -4173,  1745,  2655, 19522, 19522,  1546,
    1234,  3100,  3100,  2393,  9813, -4173, -4173,   952,   232, -4173,
   -4173, -4173,  2387,   232, -4173,   242, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  2387, -4173,  2605,  2238, 19166, -4173, -4173,
     139,  1879, -4173, -4173,  1882, -4173, -4173, -4173, -4173,  1591,
    1591, -4173, -4173, -4173, -4173, -4173,  1053,  1053,  3100,  3100,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  1300, -4173,
   -4173,  3285, -4173,  2272,  1738, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,     3,   157, -4173, -4173, -4173,  1053,
   -4173, -4173,  3038,  3041, -4173,  2843,    40, -4173,  3056, -4173,
    3056, -4173,  3056, -4173,  3056, -4173, -4173, -4173,  2387, -4173,
   -4173, -4173, -4173,  3045, -4173, -4173, -4173, -4173, -4173, -4173
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,    14,     1,     3,     5,    34,     4,    77,    33,
       0,    51,     0,    15,   100,  3207,    56,    55,    51,     8,
      10,    11,    12,    13,     0,    52,    53,    80,   102,    48,
     105,     0,   101,  3206,    35,     9,    59,    57,     0,    77,
       0,    77,     0,  3302,    78,    86,   484,   107,   283,   109,
       0,   106,  3207,    37,     0,    18,     0,     0,  3207,  3303,
       0,     0,    88,   486,    49,   489,     0,   485,   282,    99,
       0,   285,     0,     0,     0,  3369,  3302,  3302,  3302,     0,
       0,  3207,  3207,  3302,  3207,  3207,  3262,   195,   279,   194,
       0,   104,   110,   111,   113,   114,   117,   115,   116,     0,
     174,   177,   192,   178,   179,   245,   180,   182,   181,   185,
     183,   184,   186,   187,   188,   189,   190,   191,  3207,   103,
      38,    36,    62,    61,    65,    22,    16,    19,    20,    65,
      24,    17,    54,    82,    83,    84,    85,    81,  3333,  3302,
      93,  1499,   488,     0,   491,  3207,  3207,  3207,   287,  2905,
    2904,   205,   242,  3302,  3370,  3302,     0,     0,     0,  3302,
    3302,   126,   158,     0,   120,   172,  3263,     0,  3282,  3302,
     266,   112,   176,   173,   175,  3302,     0,   247,   108,     0,
       0,  3302,     0,    21,  3302,     0,  3334,  3302,     0,     0,
    3207,  1494,    50,  1493,  1553,  3207,   482,   487,   284,   286,
     428,   211,  3283,  3302,     0,     0,     0,  3013,   275,  2893,
     273,   278,     0,     0,   128,   160,   277,   122,   634,   256,
     257,  3302,     0,     0,     0,  3022,  2410,  2409,   193,   199,
     202,  3348,  3302,     0,   372,   246,     0,    66,     0,     0,
      64,    63,  3207,    60,     0,  3207,     0,    90,    92,    91,
      89,  3302,    79,     0,     0,     0,   490,   497,   498,   614,
     492,   617,     0,  3207,   289,   288,   281,   431,   206,   207,
     209,     0,     0,   243,   244,   276,   271,  3429,  3430,     0,
     265,     0,  3261,  3376,  3359,  3302,   154,   127,  3358,   132,
     134,   135,   136,   137,  3358,     0,  3264,     0,     0,   159,
       0,   163,   121,   124,   258,     0,  2906,   248,   249,  3307,
     252,   280,     0,  3032,  3039,  3033,  3031,  3029,  3034,   269,
    3030,   267,  3040,   268,  3035,  3037,  3348,  3351,  3350,     0,
       0,   196,   200,    40,    58,    69,    72,  3207,    76,    75,
    3358,    70,    71,    23,  3207,    25,  3113,  3114,  3115,  3116,
    3117,  3118,  3119,  3120,    87,     0,  1495,  3235,     0,  1624,
    1737,  1747,  1755,  1762,  1819,  1827,  1847,  1842,  1848,  1857,
    1853,  1865,  1875,  2007,  2016,  2018,  2025,  2150,  2058,  2070,
    2083,  2086,  2089,  2095,  2097,  2108,  2130,  2134,  2138,  2195,
    2213,  2215,  2221,  2225,  1621,  2231,  2265,  2292,  2294,  2299,
    2329,  2330,  2346,  2349,  2350,  2355,  2364,  2365,  2382,  2399,
    2440,  2458,  2477,  2496,  2512,  2520,  2524,  3234,  2528,  2531,
    2534,  2551,  2591,  2607,  3236,  1555,  1556,  1557,  1558,  1559,
    1560,  1561,  1562,  1564,  1563,  1565,  1567,  1566,  1568,  1569,
    1570,  1571,  2019,  1572,  1573,  1575,  1576,  1577,  1578,  1579,
    1580,  1581,  1582,  1583,  1584,  1585,  1574,     0,  1586,  1587,
    1588,  1589,  1590,  1591,  1592,  1593,  1594,  1595,  1596,  1597,
    1598,  1599,  1600,  1601,  1602,  1603,  2366,  1604,  1605,  1606,
    1607,  1608,     0,  1609,  1610,  1611,  1612,  1613,  1614,  1615,
    1616,  1617,  1618,     0,  1619,  1620,  1532,  1554,   613,     0,
     559,   493,  3089,     0,  2875,   494,   430,  3106,     0,   458,
    3343,   441,   429,     0,   434,   436,   437,   449,   438,   439,
    3302,  3302,   212,   213,  3027,   245,   261,   263,  3028,  3401,
     270,     0,  3014,   274,  3377,  3302,     0,   131,   133,   129,
     155,  3358,  3302,  3265,   139,     0,     0,   170,    65,     0,
      65,     0,   161,   164,     0,     0,   259,   250,  3309,  3308,
     253,     0,  3036,     0,     0,  3349,   203,   197,   198,   201,
      43,    39,    45,    74,    26,    68,    73,    28,    95,    96,
      97,    98,    94,  1772,  3131,  3132,  3133,  3134,  3135,  3136,
    3137,  3138,  3139,  3140,  3141,  3142,  3143,  3129,  3183,  3184,
    3185,  3186,  3187,  3188,  3189,  3190,  3191,  3192,  3193,  3194,
    3195,  3196,  3197,  3198,  3199,  3200,  3201,  3202,  3203,  3204,
    3205,  3144,  3145,  3147,  3146,  3148,  3149,  3150,  3151,  3152,
    3153,  3154,  3156,  3155,  3157,  3158,  3159,  3160,  3161,  3162,
    3163,  3164,  3165,  3166,  3167,  3168,  3169,  3170,  3171,  3172,
    3173,  3174,  3175,  3176,  3177,  3127,  3178,  3179,  3180,  3181,
    3182,  1623,  3128,  3130,  1655,     0,  3010,     0,  1772,     0,
       0,     0,  1850,     0,     0,  1870,  1919,     0,  1870,  2753,
       0,  2062,  2072,     0,     0,  3392,  2079,     0,     0,     0,
       0,  2141,     0,     0,     0,     0,     0,  2236,  2740,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2499,     0,  2522,     0,     0,     0,     0,     0,     0,     0,
    1772,  2196,  2208,  2368,     0,  2480,  2492,  2495,  2478,  2493,
    2745,  2494,  2481,  2490,  2482,  2491,  2994,  2998,  2608,  2660,
    1553,     0,   558,     0,   950,   669,     0,     0,   619,     0,
       0,   623,   624,   622,     0,  3224,  3226,  3211,  3225,  3210,
    3212,   496,  3213,   499,     0,  3107,     0,  3343,  3392,  3392,
    3341,  3343,  3343,  3392,  3343,  3343,  3392,  3343,  3343,  3280,
    3344,  3278,     0,   442,   443,   444,  3243,     0,  3222,  3221,
    3223,  3220,  3208,   435,   432,  3209,     0,     0,   260,   262,
       0,     0,     0,   148,   130,  3015,   140,   165,   166,   169,
     171,   167,   168,   162,   123,     0,  3023,   251,   254,  3038,
     204,  3302,    46,     0,   469,   469,  1776,  1779,  1778,  1774,
    1775,  1777,  1766,  1773,  1654,  3013,  1735,  1626,  1667,     0,
    3331,  1653,  3341,  3065,  3063,  3066,     0,  3059,  3067,     0,
       0,  3073,  3446,  3447,     0,  2858,  2860,     0,     0,     0,
    3062,  2928,     0,  2862,  3064,  3068,  3069,     0,     0,  3061,
    3073,  3060,  1745,  2922,  1743,  2914,  2917,     0,  2916,  2920,
    2921,  3070,     0,     0,  2929,     0,     0,     0,     0,  1748,
       0,  2839,  2849,  2851,  2855,  2938,     0,  2857,  2935,  3095,
    3011,  2936,  2937,  2890,  1756,  1757,     0,  2886,  2888,  2887,
    1817,  2740,  1822,  2966,  1826,  1820,  1821,  1823,  1825,  2965,
    1838,  1828,  1829,  1830,  1833,  3341,  1845,  3005,     0,  2864,
    3109,  2909,  3004,  3009,  2910,  1851,  1849,     0,  1863,  3362,
    3268,  1854,  2999,  1856,  3386,     0,  1872,  1874,  1866,     0,
    1916,  1950,  1949,  3039,  3256,  1896,  1948,  1941,  1947,  1940,
    2005,  2685,  2912,  1891,  1893,  1883,  1884,  1897,     0,  1885,
    1886,  1937,  1887,  1888,  1950,  1890,     0,  2916,     0,  2014,
       0,  2017,  2032,  2031,  2056,     0,  2028,  2030,  2752,  3302,
       0,  2143,  2144,  2145,  2063,  2059,  2064,  2074,  2078,  2076,
    2079,  2077,  2071,  2084,  2085,  2907,  2087,  2088,  3393,  2090,
    2884,  1804,     0,  1803,     0,  2096,  2751,  2102,  2750,  2109,
    2111,  2877,  2131,  2132,  1186,  1956,     0,     0,  2135,  1185,
    2142,  2139,     0,  2214,  2444,  2986,  2987,  3104,     0,  2219,
       0,  2222,     0,  2229,     0,  1622,  2237,  2232,  2233,     0,
    3287,  2266,  2278,     0,  2876,  2293,     0,  2295,  2297,  2327,
    3101,  2344,     0,  2347,  2594,  2867,  2353,  3362,     0,  2362,
    2868,  2594,     0,  2383,     0,  2385,  2388,     0,     0,  2880,
    2400,  2401,  2402,  2403,  2404,  2405,  2431,  2406,  2434,  2407,
    2408,     0,     0,  2878,     0,     0,  2985,  3009,  2441,  2475,
    2463,  2510,     0,     0,     0,     0,  2518,     0,  2523,  2521,
    2525,  2526,  2529,  3262,  2989,  2532,  3364,  2968,  2549,  2537,
    2967,  2969,  2552,  2553,  2605,  2594,     0,     0,  2020,     0,
       0,     0,  2380,  2372,  2870,  2483,  2744,     0,  2996,  2997,
       0,     0,  1539,     0,  1540,  1533,     0,  1534,  1535,  1538,
       0,  3229,  3227,  3231,  3230,  3228,  3232,  3233,  3217,  3218,
     615,  3219,  3207,   949,     0,   954,   670,   667,   672,     0,
       0,   620,     0,   631,   632,   625,   633,   628,   629,  3302,
    3108,   290,     0,     0,     0,  3342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3281,  3384,  3279,     0,   347,
     466,   348,  3244,  3282,   433,   218,   217,   238,   234,  3015,
     239,   223,   237,   235,   215,   216,   236,   208,   214,   225,
     226,   228,   220,   221,   222,   210,   219,   264,   272,     0,
     151,   153,   152,   149,   150,  2898,     0,  3282,   125,   255,
       0,  3302,    41,   470,  1490,  1490,  1767,  1501,  1736,  1625,
    1667,  3251,  3253,  1672,  3302,  1651,  1668,  1669,  1671,  1673,
       0,     0,  3270,     0,     0,  3332,     0,     0,     0,     0,
       0,     0,     0,  3070,  3079,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3070,  1746,  1738,     0,     0,  2915,
    2923,  2924,  2925,     0,  3045,     0,     0,  2854,  2853,     0,
    2852,  3097,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2939,  2940,  2941,  3096,  1751,  1758,
    1760,     0,  1818,  1763,  1782,  1824,     0,  1833,  3442,  3443,
    1831,     0,  1834,     0,  1846,  1843,  3424,  3423,  2865,     0,
    3111,  2866,  3007,  3008,     0,  2685,  1861,  1864,  1858,  3363,
    2312,  3269,  1855,  3000,  3387,  1871,  1873,  1868,  1897,  1951,
       0,  3257,     0,  2006,  1876,  3412,  1550,  3411,  1881,  2691,
    2688,  1550,  1892,  1889,  2913,  3400,     0,  1918,     0,  1952,
       0,  2685,  2685,  2685,  2685,     0,  2015,  2008,     0,     0,
    2057,  2026,  2753,  2043,  2027,  2034,  2035,  1550,  2769,  2771,
    2774,  2772,  2773,  2775,  2776,  2777,  2778,  2767,  3303,  2809,
    2770,  2762,  2766,  2764,  2765,  2761,  2763,  2754,  2755,  2768,
    2757,     0,     0,  2152,  2151,  2065,  2060,  2075,  2073,  2908,
       0,  2093,  3405,  2081,  2080,  2103,  2104,  2113,     0,  2133,
    1955,  1267,  1296,  1264,  1346,  1281,  1280,  1345,  1347,  1369,
    1348,  1332,  1415,  1449,  1365,  1394,  1368,  1391,  1437,  1340,
    1363,  1359,  1366,  1389,  1435,  1266,  1269,  1376,  1373,  1265,
    1372,  1371,  1421,  1293,  1375,  1294,  1450,  1298,  1358,  1387,
    1384,  1411,  1402,  1439,  1238,  1412,  1422,  1385,  1320,  1322,
    1321,  1388,  1423,  1424,  1425,  1426,  1284,  1285,  1414,  1377,
    1379,  1378,  1383,  1318,  1399,  1292,  1401,  1408,  1409,  1300,
    1302,  1413,  1305,  1244,  1397,  3288,  1343,  1319,  1291,  1261,
    1420,  1260,  1263,  1262,  1418,  1410,  1386,  1370,  1431,  1406,
    1407,  1342,  1428,  1429,  1430,  1419,  1434,     0,  1295,  1396,
    1392,  1395,  1427,  1382,  1393,  1301,  1334,  1364,  1360,  1356,
    1367,  1390,  1432,  1433,  1400,  1303,  1304,  1268,  1436,  1297,
    1341,  1299,  1380,  1381,  1417,  1333,  1335,  1237,  1306,  1323,
    1344,  1416,  1448,  1374,  1357,  1398,  1339,  1362,  1361,  3288,
    1197,  1212,  1213,  1214,  1215,  1216,  1217,  1218,  1219,  1220,
    1221,  1222,  1223,  1224,  1225,  1226,  2136,  1454,  3288,  3288,
    3288,  2137,  1458,     0,  2448,     0,  2988,  3105,  3304,  2217,
    1189,  1191,  3310,     0,  2218,  2220,  2216,     0,     0,  2230,
    2226,     0,  2234,  2241,  2238,  2240,  2239,  2242,  3341,  2280,
    2890,  2971,  2742,  2742,     0,  2276,     0,     0,  2970,  2887,
     637,  2972,     0,  2741,  2298,  2296,  2328,  2300,  3102,  3103,
    3362,  2345,  2331,  2333,  2334,     0,     0,  2348,  2354,  2351,
    2302,  2869,  2363,  2356,  2312,     0,  2384,     0,  3400,  2391,
       0,  2955,  2960,  2961,  2962,     0,  2432,  2435,     0,     0,
       0,  2879,  2412,     0,  2411,     0,     0,  3007,  2476,  2459,
    2465,  3302,  2466,  2461,  2511,  2497,     0,  2500,  2501,  2504,
       0,     0,  2519,  2513,     0,  2527,     0,  3365,  3366,  2533,
    2550,  2535,  3258,     0,  2554,  2606,  2592,  2596,  2021,  1766,
    2206,     0,  2206,     0,  2380,  2374,  2381,  2367,     0,  2374,
       0,  2479,  2485,     0,  2834,  2832,     0,  2995,  2658,     0,
    2658,  2664,  1547,  1542,  1546,     0,   617,   560,  3207,   953,
       0,   957,     0,   737,  3089,   621,   627,   768,   635,  3266,
    3302,     0,     0,  3302,  3266,  3333,  3302,  3241,     0,   500,
     503,   504,   505,   506,   507,   508,   509,   510,   511,     0,
     495,     0,     0,   445,  2891,  3343,  3343,     0,   453,  2871,
     446,  3343,   447,   455,  3343,   448,   457,  3385,  3266,  3341,
    3341,     0,     0,   224,   227,   230,     0,  3437,  3439,  3438,
     138,  3017,  3016,   141,     0,  3015,    44,     0,   118,   954,
      30,    30,     0,  1504,  1502,  1524,  2672,  2975,  1684,  2973,
    2974,     0,  1670,  3420,  3419,  3337,  3422,  3421,  1682,  1683,
    3337,     0,  1688,  3302,  1702,  1703,  1704,  1690,  1692,  3302,
    3271,  1693,  3302,  1734,  3302,  1695,  1698,  1696,  1697,  1699,
       0,  1728,  1729,  1706,  1708,  3361,  1709,  1732,  1730,  1731,
    1700,  3394,  1711,  1701,  1689,  3239,  1713,  1733,  1716,  1674,
    1705,  1710,  1715,     0,     0,     0,  2948,     0,  1662,  1666,
    1665,  1656,  1652,  1647,  2672,  3416,  3415,  1644,  1635,  1637,
    1638,     0,  2672,  3317,     0,     0,     0,  1680,  1628,  1633,
    1632,  1642,     0,  1650,  1630,  1649,  1631,  2952,  2951,     0,
    2927,     0,  2834,  2832,     0,  2834,     0,  3075,  2834,  3057,
       0,     0,  2859,  2861,  2834,     0,     0,     0,  2834,  2932,
    2933,  2934,     0,  2863,     0,  2834,     0,  3058,  3341,  3005,
    2694,  1744,  3009,  2910,     0,     0,     0,  2834,  2856,  3099,
    1751,  2838,  2837,  2842,  2843,  2844,  2845,  2846,  2847,  2848,
    2841,  2840,  2850,     0,  1753,     0,     0,  2889,  1764,     0,
    1780,  1840,  1832,  1837,     0,     0,  2911,  2694,  3302,  3110,
    3006,     0,  1860,  1862,  3282,  2730,  2313,  2314,  1867,     0,
    1917,  1942,  1926,  2693,  1551,  2686,  2692,  2687,  2689,  2690,
       0,  1906,  1905,  1894,  1901,  1903,     0,  3304,  1993,  1994,
    1995,  1982,     0,  1985,  3302,  1986,  3274,  3304,  1989,  1990,
    1996,  1991,  3394,  3302,  1992,  1999,  1997,  1898,  1899,  1925,
    1920,  1921,  1923,  1924,     0,  1938,  1945,  1879,  1880,  1877,
    1878,  2685,     0,  2694,     0,  2029,     0,  2043,  2036,  2033,
    2038,  2039,  2045,  2037,     0,  2808,  2756,  2819,  2820,  2821,
    2810,  3392,  2827,  2830,  2829,  2831,  2823,  2816,  2818,  2817,
    2822,  2824,  2826,  2828,  2758,  2811,  2812,  2813,  2814,  2815,
    2158,  2160,  2159,     0,     0,     0,  1657,  2883,  2093,  2881,
    3343,  2091,  2885,  3406,  2082,  2105,  2106,  1550,  3392,  2121,
    2122,  2124,  2126,  2127,  2123,  2125,  2116,  3392,  2112,  3289,
    3290,     0,  1196,  1453,     0,  1455,     0,     0,     0,  1459,
       0,  2182,  2166,  2140,  2147,  2148,  2149,  2450,     0,     0,
    3305,  3306,     0,  1190,  3312,  3311,  3313,     0,  1232,  1355,
    1316,  1259,  1275,  1326,  1245,  1349,  1324,  1273,  1241,  1354,
    1441,  1351,  1337,  1270,  1338,  1336,  1307,  1309,  1312,  1271,
    1325,  1279,  1328,  1277,  1317,  1314,  1230,  1329,  1350,  1239,
    1283,  1404,  1442,  1253,  1311,  1247,  1254,  1274,  1246,  1330,
    1444,  1331,  1242,  1290,  1445,  1229,  1236,  1256,  1287,  1288,
    1257,  1272,  1233,  1234,  1289,  1227,  1310,  1255,  1240,  1446,
    1313,  1352,  1235,  1440,  1403,  1447,  1405,  1258,  1276,  1308,
    1228,  1353,  1443,  1243,  1278,  1286,  1252,  1438,  1250,  1251,
    1327,  1315,  1248,  1249,  1282,  1231,  1195,  1198,  1199,  1200,
    1201,  1202,  1203,  1204,  1205,  1206,  1207,  1208,  1209,  1210,
    1211,     0,  2223,  2694,     0,  3400,  2312,     0,  3286,  2278,
    2268,     0,     0,     0,     0,   646,   642,   645,   644,   643,
     648,   830,   659,   655,   657,   658,   660,   656,   661,   831,
     649,  2949,   662,   663,   638,   651,   652,   653,   647,   650,
     641,   640,  2279,     0,  2302,     0,  2595,  2982,  2983,  2984,
       0,     0,  2358,     0,  2390,  2596,     0,     0,     0,     0,
       0,  2433,  3341,     0,     0,  2437,  2436,  2428,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2414,  2415,  3104,
    2730,     0,  2508,  2502,  3258,  2503,     0,     0,  2694,     0,
       0,  3259,  3090,     0,  2508,  2601,  2600,  2312,  3237,     0,
    1786,  2207,  2197,     0,  2209,     0,  2369,  3407,  3408,     0,
    2376,  2373,     0,  2484,  3380,  3380,  2835,  2836,  3019,     0,
       0,     0,  2659,  2609,     0,  2661,  2666,     0,  1548,  1537,
     616,   562,   951,  3207,   958,  1096,  3302,  3241,     0,   668,
       0,   738,     0,     0,     0,   885,  3396,  3302,  3302,  3302,
       0,     0,  3367,     0,   853,   755,     0,     0,  3248,     0,
    3374,   881,  3392,  3302,  3302,  3302,  3241,     0,   754,   626,
     768,   693,   695,   698,   696,   697,   699,   701,   700,   716,
     717,   715,   702,   704,   703,     0,   705,   706,   707,   708,
     709,   710,   711,   718,   719,   720,   723,   721,   722,   712,
     713,   714,   724,     0,     0,  3248,     0,  3267,     0,     0,
    3307,  3307,     0,     0,     0,     0,     0,  3302,   554,  3242,
     555,     0,     0,   556,   501,   502,     0,   291,  3362,  2892,
       0,     0,  3448,  3449,  3343,  2872,     0,     0,     0,     0,
       0,   467,   440,     0,   229,     0,  3302,  3302,   142,    47,
       0,   119,  1491,    31,     0,     0,  1770,  1771,  1769,     0,
    1509,  1509,     0,  1496,  3410,  2683,  2684,  3409,  1627,  2680,
    1724,  2675,  1550,  2678,  2679,  1687,  3338,     0,     0,  3024,
    1675,  2976,  2977,     0,     0,     0,     0,  1691,  1727,  1714,
    3302,  2746,  3395,  2746,  3240,     0,  3286,  3302,     0,     0,
       0,     0,  1648,  1634,  1636,  2672,  1645,  3318,  1639,  1640,
    1641,  1681,  3250,  1643,  2954,  2926,  2953,  3109,     0,  3070,
       0,  3070,  3074,     0,  3070,  3080,     0,  3070,  3070,  3070,
       0,  3070,  3109,     0,  3070,     0,  1550,  1550,  1739,  2700,
    2697,  3007,  3008,  2694,     0,  3070,  3070,     0,  3098,  1753,
    1752,     0,  1749,  1761,  1759,  2742,  1784,  1785,  1781,  1783,
    1839,     0,  1836,  1835,  1844,     0,  1852,  2317,     0,  1550,
    1550,  1859,  2731,  2737,  2734,     0,  1952,  1928,  1553,  1914,
    1915,  1912,  1911,  1913,  1910,  1902,  1904,  1907,     0,  1983,
    1984,     0,  1463,  1465,  1987,  1988,     0,     0,     0,  2746,
    2746,     0,  1900,  1922,  1953,  3400,  3400,  1882,     0,  2009,
       0,  2053,  2050,  2052,  2051,  2044,  2047,  2054,  1550,     0,
    2760,  2759,  2825,  2161,  2164,     0,  2165,  2155,  2156,     0,
       0,  3276,  1658,  2092,  2882,     0,  1550,  2107,  2098,  2101,
       0,     0,  2128,     0,  1457,  1456,  1462,  1461,  1460,     0,
    3012,  2956,  2957,  2183,     0,  2185,  2184,  2186,  2168,  2178,
       0,     0,  2146,  2451,  2442,     0,   871,   872,  3317,  3291,
    1194,  1452,  1451,     0,  1192,  2224,  2227,     0,     0,     0,
     639,     0,  2267,  1550,     0,  2285,  2281,  2286,  2282,  2287,
       0,  2277,   654,  2284,  2304,  2335,  2303,  1550,  2352,  2719,
       0,  1550,  2730,  2359,     0,     0,  2397,  2396,  2395,  2394,
    2393,  2413,  2438,  2979,  2439,  2978,  2980,  2981,     0,  2425,
       0,  2430,  2417,  2418,  2419,  2423,  2420,  2424,  2421,  2422,
    2416,  3105,  2474,     0,  2472,  2467,     0,  2460,  3445,  3444,
       0,  2703,     0,     0,  3109,  3109,  2514,     0,     0,  3091,
    2538,  2539,     0,  2542,  2545,  2547,  2543,  2358,  3238,     0,
    2024,  2022,  1787,  2023,  2748,  2211,  2753,  1550,     0,  2370,
    2377,  3381,  2488,  2488,  2833,  3020,     0,  2748,     0,  2668,
       0,     0,  1549,   561,   617,   955,     0,  1097,   483,   902,
     903,   688,   690,   689,   683,   687,   685,   686,   682,   684,
     681,   914,   908,   910,   911,  3302,   739,   665,   945,   946,
    3397,     0,     0,     0,     0,   751,   752,   753,  3272,     0,
    3368,   879,   727,  2992,   857,     0,   851,   757,     0,   725,
    3249,     0,   746,  3375,   882,   883,   880,     0,     0,     0,
       0,     0,  3241,     0,  1071,  1067,  1068,   694,   770,  3371,
    3371,  3371,  3371,  3371,   771,   773,   774,   775,   777,   778,
     779,   780,   782,   781,   784,   817,   815,   816,   818,   819,
     783,   789,   785,   820,   786,   787,   788,   800,   801,   799,
     803,   804,   802,   764,   776,   735,   947,  3258,   740,   732,
    3121,  3121,     0,   671,     0,   636,   523,   551,  3440,  3441,
    2901,   532,  2899,  3432,  3431,   525,  2903,  2902,  3327,  3262,
    3286,     0,  3302,   529,   528,  3302,   557,   293,  3333,  3317,
    3362,  3392,   358,  3427,  3428,   393,     0,  3317,  3302,  3260,
    3317,   395,     0,  3400,   376,   375,  3302,  3302,   295,   296,
     301,   306,   315,   303,   362,   304,   307,     0,   308,     0,
     298,   392,   299,   300,   305,   302,   297,   309,   310,   311,
     312,   313,   314,   292,     0,  3254,  3307,   450,   451,     0,
     454,   456,   459,   460,   463,   468,   465,   231,   232,  3018,
    3015,  3015,   143,   473,   156,     0,    27,    29,  1768,  1505,
    1506,  1512,     0,  1503,  1525,  1526,     0,  2673,  2681,  1550,
    1725,  1726,  2990,  2674,  2676,  2682,  1685,  1686,  1719,  1717,
    1694,  1718,     0,  1721,     0,  1720,  1722,     0,     0,  1661,
    1660,     0,  1664,  1663,  1646,  3302,  1629,  1676,  1678,  2694,
    3086,  3055,  3088,  3056,  3070,  3049,  3084,  3052,  3053,  3054,
    3082,  3051,  3123,  3077,  3078,  3048,  2911,  2702,  2699,  2695,
    2701,  2696,  2698,  3006,  1740,  3071,     0,  3046,  3047,  3100,
    2963,  2964,  1750,  1754,  1766,     0,  3112,     0,  2736,  2739,
    2732,  2738,  2733,  2735,  1869,  1943,  3304,  3304,  3304,  3304,
       0,  1927,  1929,  1930,     0,  2002,  2000,  1464,  1466,  3341,
    2001,  2004,  2003,  1998,  1971,  1968,  3314,     0,  3243,  1967,
    1970,  1961,  1939,  1957,  1963,  1964,  1974,  1965,  1959,  1978,
    1979,     0,  1946,  2694,  2864,  2694,  2864,     0,  2753,  2049,
    2041,  2042,  2040,  2046,     0,  2157,  2162,  3277,     0,  2094,
    2100,  2105,  2114,  2117,  2118,  3272,  3389,  2110,  3392,  2115,
       0,     0,  2179,  2181,     0,  2174,  2188,  2175,  2176,  2167,
    2170,  2188,     0,  2960,  2452,   363,  2446,     0,  3292,  2449,
       0,  2694,  3352,  3352,     0,  2243,  2244,  2743,  2272,  2274,
    2275,  2271,     0,     0,  3343,     0,  2323,  2305,  2318,  2311,
    2307,  2320,     0,  1550,  1550,  2332,  2341,  2338,  2721,  2712,
    2720,  2713,  2718,  2357,  2360,     0,  2386,  2387,  3319,  2392,
    3341,  3341,  2429,  2473,  2464,  2468,  2469,  2470,  2471,  2462,
    1550,  1550,  2498,  2709,  2706,  3302,  2506,  2505,  2507,  2694,
    3123,  2694,     0,  3090,  2541,  3286,  2748,  3286,  2703,  2602,
    2599,  2598,  3321,  1794,  3286,  2198,  2630,     0,  1550,  2375,
    1550,  2378,  2486,  2489,  2487,  3021,  2610,  2667,  3400,     0,
    2665,  1544,   565,   563,     0,   617,   952,   617,  3207,     0,
       0,   915,   912,     0,     0,   664,   884,   936,   937,   938,
     939,   940,   935,   941,   934,   933,   931,   932,   942,  3273,
     750,  2780,   944,  2779,  2781,     0,     0,   726,   728,  3286,
     849,  3390,   854,  3390,  3343,   760,   756,   943,   730,     0,
    2993,   763,   767,     0,   766,   765,  3396,   681,   906,   886,
       0,   893,     0,   887,   890,   897,   904,     0,  1073,  1069,
    3372,   814,   813,   806,   805,   812,   811,   810,   809,   808,
     807,   772,     0,     0,   734,     0,     0,   733,   731,  3260,
     841,   842,   675,   674,   679,     0,   513,     0,   550,  2900,
    3328,   534,     0,   516,  3376,   543,   545,   549,   548,   544,
     546,   542,   547,     0,     0,  3302,  3302,  3317,   343,   396,
    3302,  3362,  3302,  3302,  3302,  3302,   415,  3245,   416,     0,
       0,     0,  3302,  3333,   363,  3255,     0,     0,   452,   461,
       0,   462,     0,   144,   145,   479,   480,   481,   472,   474,
       0,   477,   471,   157,  1501,  1507,  3302,     0,  1522,  1513,
    1518,  1510,  1511,  1527,  2677,  1707,  3433,  3434,  2747,  1723,
    1712,  1659,     0,  1677,  1741,  3050,  3294,  3125,  3072,  1786,
    1841,  2316,  2315,  3400,     0,     0,     0,     0,  1936,  1931,
    3275,  3316,  3315,     0,  1960,  3304,  1958,  1973,  1972,  1975,
       0,     0,  1966,  2011,     0,  2010,     0,  2048,  2055,  2154,
       0,  2153,  1908,  2066,  2068,  2069,  1550,  2119,     0,     0,
    2188,  2958,  2959,  2188,     0,  3298,  3298,  2173,  2189,  2190,
    2171,  2177,  2172,     0,     0,  2455,  3282,  2445,  3293,  1193,
    2228,  3353,   418,   419,   420,     0,  2264,  3404,  2262,  2263,
    2261,  3403,  2235,  2245,  2246,  2248,     0,     0,  2273,  2269,
    2288,  2290,     0,  2308,  3302,  2730,  2306,  2319,     0,     0,
       0,  2322,  2343,  2340,  2336,  2342,  2337,  2339,  2361,  3320,
    2398,     0,     0,  2711,  2708,  2704,  2710,  2705,  2707,     0,
    2516,  3125,  2515,  2530,  2540,     0,  2544,     0,  2536,  1550,
    1550,  2593,  2604,  2727,  2724,  2603,  3322,  3323,  2597,  1788,
    1789,     0,     0,     0,  2630,  3341,  2201,  2212,  2371,  2379,
    2613,     0,     0,  2555,  1543,     0,   566,   564,   956,   959,
    3207,   913,     0,   909,   916,   917,     0,     0,   678,  3341,
     673,   676,   666,  2797,  2799,  2802,  2800,  2801,  2803,  2804,
    2805,  2806,  2796,  2798,  2791,  2795,  2793,  2794,  2790,  2792,
    2783,  2784,     0,  2787,  2786,  2950,     0,     0,     0,   851,
    3391,     0,   852,   855,     0,     0,     0,   749,   747,   748,
     822,   927,     0,  2834,   900,   897,   891,     0,  3392,   894,
     888,   905,  1072,     0,  1070,  1180,  1176,  1177,  1170,  1174,
    1182,  1168,   832,  1175,  1167,   839,  1173,   794,  1169,  1171,
    1172,  1181,   791,   793,  1178,   795,  1179,   790,   798,   797,
     736,   948,     0,   742,   745,   744,   741,  3122,   680,   524,
     515,   514,   512,   552,   533,  3262,   521,   530,   527,   531,
     526,     0,     0,  3302,   346,   345,   321,   344,     0,   395,
     391,     0,   398,     0,     0,  3246,  3247,   414,   417,  3262,
       0,     0,  3302,     0,   394,   421,     0,   464,   233,     0,
       0,     0,   475,   478,  1524,     0,  3302,  1517,  1523,     0,
    1528,  1497,  1679,  3295,     0,  3294,  2694,  1798,  1944,  1935,
    1934,  1932,  1933,  1981,     0,  3304,  1976,  1977,  2694,  2694,
       0,  2061,  1909,  2067,  2099,     0,  2129,  2169,  2180,  2188,
    3299,     0,     0,  2191,  2192,  3302,  2453,     0,     0,  2443,
     364,     0,     0,  2447,  2259,  3354,  2256,  2258,  2257,  2250,
    2255,  2247,     0,  2253,  2251,  2252,  2249,     0,     0,  2310,
       0,  2301,  2326,  2719,  2716,  2325,  2309,  2321,  2426,  2427,
    2509,  2694,  2546,  2548,  2726,  2729,  2722,  2728,  2723,  2725,
    1790,  1791,     0,  1792,  2919,  2918,  2991,  1796,  1795,  1797,
    2749,  2201,     0,     0,  2685,  2621,  2614,  2615,     0,     0,
    2669,  2670,  3302,  2563,  1545,   568,   961,  1098,     0,   921,
     920,   922,  3302,     0,  2785,  2789,  2788,   729,   858,   850,
       0,   859,  3343,  3343,   861,   759,  3302,   762,   761,  3341,
     823,   821,     0,     0,     0,   925,     0,   896,     0,   889,
    3390,     0,     0,   892,  1074,   833,   834,   838,   837,   836,
     835,   792,   840,   796,   743,     0,     0,   535,   536,   537,
     538,     0,   519,  3285,   523,     0,   351,   352,   350,   349,
     424,     0,   335,   336,   337,   331,   332,   326,   338,   339,
     327,     0,   340,   341,   330,   328,   329,   334,   333,     0,
     320,   324,   325,   322,   425,   397,     0,   405,   413,   426,
     427,  2894,     0,  3302,     0,     0,  3302,  3302,   476,  3207,
    1514,  1515,  1519,     0,  1520,     0,  1532,     0,     0,  1742,
    1807,  3300,  1980,     0,  2013,  2012,  2163,  2120,  2187,  2194,
    2193,     0,  2456,  3302,  3302,  3302,   365,  3355,  2254,  2260,
       0,  2291,  2943,  2942,  2944,     0,  2324,  2714,  2715,  2717,
    2517,  1793,  2199,  2631,  2632,  3302,  2202,  2203,  2205,  2210,
    3302,  2625,  2616,  2620,     0,  2619,  2617,  2671,     0,  3251,
    2590,  2589,  2564,  2556,  2557,  3239,  2558,  2559,  2560,  2561,
       0,     0,     0,  3282,   960,  1100,  3399,     0,   919,     0,
     677,   860,   861,     0,     0,  3258,   846,   866,   867,   868,
    3317,   865,     0,   827,   824,   828,   929,   928,   930,     0,
     926,   901,   898,   899,   895,   541,   540,  3250,  3343,   517,
    3262,   522,   405,     0,  3280,  3450,  3451,   317,   316,     0,
     402,   401,   400,   403,   399,  3302,   407,   354,   409,  2895,
     373,   382,   389,   382,   378,     0,     0,   422,  3015,  3015,
      32,  1516,  1508,     0,  1532,  1553,     0,  3126,  1550,  1550,
    1765,  1814,  1810,  1550,  3341,  3301,  1801,  1806,  1805,  1800,
       0,  1962,  2454,     0,     0,     0,   366,  2945,  2946,  2947,
    2289,  2685,  2633,     0,  2204,     0,  3341,  2636,  2618,  2662,
       0,  3378,  2587,  2584,  2585,     0,  3343,   569,   567,  3214,
    3298,   963,   962,     0,  1104,  1099,  1101,     0,   923,   918,
     848,   861,   856,  3015,   862,   869,  3302,     0,   758,   829,
     825,   924,  3001,  3003,     0,     0,   519,  3092,   319,   342,
     318,   408,   356,  3092,   355,   406,     0,  3329,   380,   385,
       0,   381,     0,   379,   371,   423,   146,   147,     0,  1553,
    3124,  1816,  1813,  1808,  1815,  1809,  1811,  1812,     0,  1799,
    2457,   367,   368,  2200,  2635,  2634,  2623,     0,  3341,  2646,
    2685,     0,  3379,     0,     0,  2588,  2586,  2582,  2581,  2580,
       0,   590,     0,     0,     0,  1105,     0,  1102,   847,   875,
     876,   878,  3015,   864,  3002,   539,   520,   518,   354,     0,
    3302,   404,   411,   412,   410,  3330,     0,   388,   390,  3302,
    1529,  1802,     0,     0,  3302,  2622,  2626,  2627,  3302,     0,
       0,  2611,  2663,  2583,  3426,  3425,  3356,  2873,     0,  2576,
    2570,  2571,  2573,  3302,     0,     0,     0,     0,   571,   591,
     592,   573,   601,   964,  1110,  1111,     0,  1103,   877,   870,
    2896,   359,  3094,     0,     0,     0,     0,     0,  3302,  3302,
       0,  2628,     0,  2637,  2638,  3302,     0,     0,  2647,  2648,
    2650,  2685,  3357,  3343,  2874,  2579,  2574,  2577,     0,  2572,
    3302,     0,     0,  3302,  3302,  3302,  3302,   593,     0,  3332,
       0,  3383,     0,   570,   574,   576,   575,     0,     0,     0,
       0,     0,     0,     0,   572,   602,   604,   603,     0,     0,
       0,   768,     0,  1108,  1165,  2897,     0,   353,  3093,   357,
       0,  3435,  3436,   386,  1521,  1530,     0,     0,  2624,  2629,
    2639,     0,  2643,  2645,  2644,  2641,  2641,  2655,  2651,  3043,
    3044,  3041,  3042,  2652,  2656,  2649,  2612,     0,  2578,  2575,
       0,     0,   599,     0,     0,     0,     0,  3302,  3302,  3302,
    3302,  3302,   577,     0,  3302,  3302,  3302,  3302,  3302,  3302,
    3302,  3302,  3302,  3302,  3302,   605,     0,  3302,     0,  3302,
    1134,  3302,  1122,  1123,  1124,  1115,  3396,  1116,  3337,  3337,
    3302,  3304,  3274,  3302,     0,  1139,  1132,  1119,  1133,  3337,
    3304,  1120,     0,     0,  1131,  1141,  1138,  1136,  3304,  1121,
    1135,     0,  1142,  1130,     0,  3302,  1157,  1151,  1155,  1154,
    1152,  1112,  1156,     0,  1158,  1153,  1137,  1125,     0,  3337,
    1166,  1184,  1183,  1187,     0,   386,   383,   387,     0,   369,
     370,  2640,  2654,  2642,  2653,     0,  2569,  2566,  2568,  2567,
    2562,  2565,   594,  3390,   598,   596,   600,   595,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   968,  3215,  3307,
    3307,  3324,   967,   971,   972,  1001,     0,     0,     0,     0,
    1113,  1114,  1147,  3302,  1145,  3302,     0,     0,  1117,  1118,
       0,  1160,  1143,     0,  3390,  3302,     0,  1161,  1159,  1164,
    1162,  1489,  1146,  1111,  1188,     0,   240,   241,   361,   384,
    1531,  2657,   873,   586,   582,   583,   587,   585,     0,   588,
     578,   584,   579,   580,   581,   610,   606,   607,   611,   609,
       0,   608,  3466,  3467,  3307,  3307,     0,   965,   969,  3302,
     977,   973,   975,   976,   978,   980,  1150,  1485,  1481,  1148,
    1128,  1129,  1149,  1144,  1478,  1488,     0,  1127,  1126,   768,
     360,   597,   874,     0,     0,  3325,  3326,  3026,   988,   983,
    3321,   987,  3025,   986,     0,  1002,     0,   974,   979,  1473,
    1470,  1474,  1471,  1486,  1469,  1487,  1472,     0,  1482,  1483,
       0,  1479,  1477,  1475,  1476,  1140,     0,   612,   981,  3322,
    3323,   982,   985,     0,     0,  1003,   633,   970,  1484,  1480,
       0,     0,  3302,  3302,     0,  3302,   989,   990,   991,   992,
     993,   994,   984,     0,  1005,  3216,  1006,     0,  3453,  3452,
    3302,     0,     0,  3455,     0,  3302,  3302,     0,   768,     0,
       0,  1000,   996,  3454,     0,     0,   995,  1061,  3414,  3413,
    3296,  3337,  3241,  3302,     0,  1060,  3302,  3341,  3302,  1011,
    1013,  1012,  1014,  1023,  1015,  1017,     0,  1020,  1007,  1008,
    1009,  1019,  1021,     0,  1024,  1010,  1078,  1016,     0,  1018,
    1022,  1004,  3417,  3418,  3337,     0,   997,   999,   998,  3297,
    1095,  3340,  3339,  3307,  1077,     0,   851,     0,     0,     0,
     907,  3335,  3335,     0,     0,  1080,  1075,  1078,     0,  1468,
    1082,  1090,  1091,     0,  1093,  1084,   589,  1076,  1048,  1046,
    1047,  1042,  1045,     0,  1043,  3390,  3109,  1050,  2930,  3457,
       0,     0,  3459,  3461,     0,  3465,  3463,  1025,  1030,  3345,
    3345,  1027,  1031,  1026,  1032,  3336,  1062,  1062,  3335,  3335,
    1055,  1079,  1081,  1092,  1089,  1088,  1086,  1087,  3307,  1085,
    1044,   855,  1094,  3343,     0,  1049,  2931,  3456,  3460,  3458,
    3464,  3462,  3347,  3346,  1033,  1038,  1066,  1064,  1056,  1062,
    1065,  1058,     0,     0,  1083,   844,     0,  1052,  1036,  1028,
    1036,  1041,  1036,  1029,  1036,  1063,  1057,  1059,     0,   843,
    1054,  1051,  1053,     0,  1035,  1034,  1040,  1039,   845,  1037
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4173, -4173, -4173, -4173, -4173, -4173, -4173,  3631, -4173, -4173,
   -4173, -4173, -4173, -4173,   -83, -4173,  1150, -4173, -4173, -4173,
   -4173, -4173,  1832, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  2683, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  3598,  3471,  1311, -4173, -4173,
   -4173,  3322, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  3644, -4173, -4173, -4173,  2417, -4173,
   -4173,  3567, -4173,  1843, -4173, -4173, -4173, -4173, -4173, -4173,
    3369,   176, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
    3445, -4173,   635, -4173, -4173, -4173,  3370, -4173,  1164, -4173,
   -4173,  3572, -4173, -4173,  -951, -4173, -4173,  3340, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2884, -4173,
    2461, -4173, -4173,  -754, -4173,  3510,  3157, -4173, -4173, -4173,
    3376, -4173, -4173, -4173, -4173,  3460, -4173, -4173,  3159,  2445,
   -4173, -4173, -4173,  2526, -4173,  2547, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173,  -592, -4173, -4173, -4173,
   -4173, -4173,  1210, -4173, -4173, -4173, -2374, -4173, -4173, -4173,
   -4173, -4173,  -436,  -826, -2372, -4173, -4173,   272, -4173, -4173,
   -4173, -4173, -4173,  -408, -4173, -4173, -4173,  -521, -4173, -4173,
   -4173, -4173,   268, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  3186, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173,   678, -4173, -4173, -4173, -4173,  2886, -4173, -4173, -4173,
     252, -3043, -4173, -4173, -4173, -4173,  3658, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  -501,
   -4173,  -238, -4173, -4173, -4173,   293, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  -662, -4173, -4173, -4173,  -606, -4173, -4173,
    -671, -4173, -4173, -4173, -4173, -1632, -4173, -4173,  2967, -4173,
   -3470, -4173, -3460,  -736, -4173, -1031,  1461, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -3605, -4173, -4173, -4173,
     406, -2253, -4173, -4173,  1297, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  1967, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -3056, -4173, -4173, -4173, -4173,
   -1005, -2734, -4173, -4173, -4173, -4173, -4173, -4173,  1289, -4173,
   -4173, -2681, -4173, -4173, -4173, -4173, -3524, -4173, -1124, -4173,
   -4173, -3582, -4173,  -468,  -348, -4173,  1594, -4173, -3792, -4173,
    -536, -2473, -4173, -4173, -2454, -4173, -4173, -4173,   371,  1319,
   -4173,  -186,    52, -4173,  -990, -3232, -2825, -4173, -4173, -4173,
   -4173, -4173,   890, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  1930, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  -885,
   -2190, -4173, -4173,  -940, -1930, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -2136, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -2444, -4173,  -971, -4173,   863, -4173, -4173, -4173, -4173, -1037,
   -4173, -4173, -4173, -4173, -4173, -4173, -1041, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  -424, -4173, -4173, -4173,  -830,
   -4173, -4173, -4173, -4173,  -562, -4173,  3073, -4173,  -748, -1586,
   -4173,  -746, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173,  2172,  2736,   -70,  -705,
    -699, -4173, -2353, -4173,  -863, -4173, -4173, -4173, -4173,  -702,
   -4173,  -731, -4173, -4173, -4173,  2535, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,   328, -4173, -4173,  1268, -1384, -4173, -4173,
     175,   326, -4173, -4173,    11, -4173, -4173, -4173, -4173, -3527,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -1304,
   -4173, -4173,  -158, -4173,  3532, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  -817, -1636, -4173,  2538, -4173,
    2537, -4173,   715, -4173,  -783, -4173, -4173, -1102, -4173, -4173,
     727,  2540, -1255,  1935, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  1836,  1198, -4173, -4173, -4173,  2895, -4173,
   -4173, -4173, -4173, -4173, -1598, -4173, -4173,  -151, -4173, -4173,
   -4173, -4173,   322, -4173, -4173,   198, -4173, -4173, -1105, -4173,
   -4173, -4173,  -342, -4173,  -338, -4173, -4173, -4173, -4173, -4173,
    2893, -4173, -4173, -4173, -4173,  2477, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  3128, -4173,
   -4173, -4173, -4173, -4173,  2425, -4173,  2850, -4173, -4173,  2455,
   -4173, -4173,  1801, -4173,   304, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  1777, -4173, -4173, -4173, -4173,   688, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2847,  1196,
    3131, -2426, -2738, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -1876, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2435,
   -4173, -4173,  2430, -4173, -4173, -4173, -4173,  1157,   661, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   318, -4173,
   -4173, -4173,  2829, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  1734, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
     650, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   651,
    2400, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173,  2810, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -2553, -4173, -4173,  1699, -4173, -4173,   640, -4173,  1135,
   -4173, -4173, -2926,   315,   319, -4173, -4173, -4173, -4173, -4173,
   -4173,   -23, -4173,  -187,  2133, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,  2804, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,   297, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -3557,  1593, -4173, -4173, -4173,   631, -4173,
   -4173, -4173, -4173, -4173,  2844,  2802, -4173, -4173, -4173,  1565,
   -4173, -4173, -4173, -1413,  1116, -4173, -4173,   633, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,   625, -4173,
     627, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,  1057, -2140, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173,  2137, -4173,  1051, -4173,  2163, -4173,
   -4173, -4173, -4173, -4173, -4173,  2207, -4173, -4173, -4173, -4173,
   -4173, -4173,  -141, -4173, -4173, -4173, -4173,  1547, -4173, -4173,
   -4173,  2788, -4173,  2789, -4173, -4173, -4173, -4173,  3169, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,  1055, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173,  2184, -4173, -4173,
    1536, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173,   609, -4173,  1539, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173, -4173,
    -425, -4173, -4173, -4173, -4173, -4173, -4173,  -285, -4173, -4173,
   -4173, -4173,  -591,  1585,  1598, -4173, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -4173,    18, -4173, -4173, -4173, -4173,
   -4173,  -403,   281, -4173,  -137, -4173, -4173,  -446,  -518, -2302,
   -4173, -4173,  -449, -4173, -4173,  2160, -4173, -4173, -4173, -4173,
   -4173, -4173, -4173, -4173, -1600, -4173,  1380, -4173, -4173,  1383,
   -4173, -1275, -4173,  2541, -4173,  2545, -1825, -4173,  1315, -4173,
    1320,   632, -4173,   644, -4173,   652, -4173, -4173, -4173, -2603,
      74, -2184, -4173, -4173,   316, -4173,   320, -2181,   642, -4173,
    1302, -4173,  1304,  3018, -1480,  3226,  -222, -2481, -2215,  -639,
   -1899, -4173, -4173,  2518, -1405, -4173, -4173, -4173, -4173,   277,
   -4173, -1357, -1363, -1058,  1156,  1159,  1161,  1162,  1419, -1797,
    -564,  1478,  1760, -4173,  1925,  -488, -1128,  -643,  -685,  3232,
    2813, -1114, -4173,  -243,  1794,  -707, -4173,  -979, -4173,  1854,
   -4173,  -549, -4173,  2635,   546,  -143, -4173, -4173, -1197, -4173,
    1000, -2139,   -26,  3645,  -610,  -588, -4173,  -561,  -307,    95,
   -3205,   199, -4173, -1139, -3247, -4173,   215, -4173,   121, -4173,
    1650, -1002, -1990, -2870, -2727, -4173,  -672,  2640, -4173, -2289,
   -2434, -2897,     0,  -509,  -690,  -741,  -569, -4173, -2601, -4173,
   -2766, -4173,  3496,  -823, -4173, -4173,  -229, -4173, -2044, -4173,
   -2798,   171, -3725, -4173,  1472,  -778,  -841,  -175,  3158, -3083,
   -4172,  3180,   187,  -223,  3777,  -310,  -552,  3624, -4173, -4173,
   -4173, -1010,  3109, -4173, -4173, -4173, -4173,  1506, -4173, -4173,
    2228, -4173,  -232, -4173, -4173, -4173, -4173,  1654, -4173, -2483,
   -4173,  1369,  1044,   717,   397, -4173, -4173, -4173,   -13,  -691,
    -231,  2811, -4173,  -470,  -737,  -708, -4173, -4173, -4173, -1720,
   -4173,   -62, -2335,   847, -4173,  1537, -2470, -4173, -4173, -4173,
   -1662, -1752, -1097, -1757,   701, -4173, -4173,   816, -4173, -4173,
   -4173,  -105,  -193, -4173, -2090,   973, -4173,   222, -4173, -3271,
   -4173,   -17, -1929, -2404, -4173, -4173, -2546, -4173,  -660, -4173,
   -4173, -4173,  3165, -1675, -2254, -1811,  -770,  -779,  -740,  -824,
    3684,   799, -4173, -4173,  3673, -4173,  -856, -4173, -4173, -4173,
     -76, -4173,   610, -4173,  1651, -2848, -4173, -4173, -4173, -3214,
    -682,  1983,   663, -4173,  -254, -4173, -4173,   922, -4173, -1778,
   -4173, -1262, -4173,  2757, -4173, -4173, -4173,  -675, -4173,  -638,
    -379, -4173,  2263,  1538, -4173, -4173,   269, -4173, -2665,  -761,
   -4173, -4173, -4173, -4173, -4173, -4173
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,     4,     5,     6,    18,    19,     7,     8,
      20,    21,   126,   127,   128,   182,   131,   185,    22,   824,
      23,   825,  2504,  3035,    10,    11,    53,   121,   179,   571,
     572,   821,   823,  1241,    13,    46,   141,    24,    25,    42,
      26,    38,    39,    40,    41,   124,   242,   181,   238,   340,
     341,   342,    14,    44,    45,   137,    62,   140,   250,   190,
     582,    29,    30,    31,  1243,    48,    49,    50,    51,    91,
      92,    93,  2500,    94,   217,   302,   554,    95,   214,   287,
     288,   289,   290,   291,   544,  1237,  1813,   292,   293,  1233,
     294,  3452,    96,   215,   299,   300,   301,   549,    97,    98,
      99,   100,   101,   175,   102,   228,   568,   229,   230,   103,
     201,   268,   520,   521,   269,   270,  1217,  1225,  1218,  1219,
    1220,  2493,  3027,  2674,  4598,   203,   177,   104,   105,   307,
     308,   309,   817,   106,   219,   220,   107,   525,   526,  3445,
     109,   224,   321,  3446,   530,  3447,   112,   113,   114,   115,
     116,   117,   169,    69,    70,    71,   148,   200,   265,   507,
    1782,  2477,  2478,  2988,  2989,  3969,  3970,  3971,  3972,  3973,
    3746,  3747,  1200,  2990,  3949,  2991,  4213,  4214,  4280,  2992,
    4397,  2993,  2713,  3536,  3820,  2995,   235,  2996,  2997,  2998,
    2999,  4124,  4218,  4516,  4219,  4221,  3000,  3001,  3002,  3003,
    3976,  4114,  3004,  4117,  4118,  4215,  4216,  4282,  3005,  3006,
    3427,  3007,  3215,  3008,  3765,  3009,  3010,  3011,  3012,   266,
     267,   512,   513,   514,   515,   786,   516,   517,   518,   779,
    3022,  3023,  3441,   519,   781,  1800,  1244,  3034,  3448,  3449,
    3450,  3451,    64,   259,    65,    66,  1819,   143,   144,   196,
     260,   261,   763,   262,  1179,  1769,  1770,  3732,  1771,  4099,
    3944,  3396,  1772,  1773,  2965,  3738,  1774,  1775,  3734,  3937,
    3938,  3939,  3940,  1776,  3411,  3412,  1777,  3398,  1778,  1779,
    2472,   743,   744,  2381,  2833,  3303,  3304,  3305,  3885,  4063,
    4177,  4373,  4374,  4375,  4376,  4318,  4319,  4320,  4384,  4385,
    4386,  4387,   499,   500,  1746,   501,   502,   748,   749,  1757,
     750,  1174,  1175,   221,  2455,  3357,  2284,  2285,  2286,  2287,
    2288,   751,  3315,   752,  1752,  1167,   753,  1753,  2943,  3640,
    3393,  3358,  2419,  2420,  2421,  2422,  2423,  3337,  3338,  2424,
    2425,  3388,  2426,  3384,  2390,  2427,  2428,  3386,  3726,  2429,
    3349,  3678,  2430,  2868,  2431,  2432,  2877,  3346,  3675,  3908,
    2433,  2434,  2435,  2933,  3355,  3911,  3912,  4200,  2289,  3931,
    3933,  2436,  4753,  4889,  2437,  3669,  3343,  2875,  3904,  3340,
    4072,  4076,  4197,  4077,  4078,  4079,  4080,  4651,  4081,  4269,
    4270,  2438,  2439,  2886,  2440,  2441,  2442,  3363,  3364,  3689,
    3923,  3361,  3690,  3683,  2388,  3365,  3366,  4757,  2389,  3311,
    2852,  2853,  2854,  3633,  3634,  3635,  3891,  4068,  2443,  3681,
    3914,  2444,  3326,  2445,  3324,  2446,  2447,  2448,  2449,  2450,
    2451,  1164,  1165,  2834,  1750,  1751,  3307,  2385,  2836,  3886,
    4064,  4182,  4263,  4390,  4459,  4562,  4563,  4631,  4632,  4633,
    4634,  4564,  4658,  4659,  4660,  4688,  4706,  4707,  4708,  4709,
    4710,  4711,  4627,  4665,  4716,  4728,  4758,  4759,  4827,  4879,
    4894,  4883,  4760,  4811,  4812,  4761,  4855,  4891,  4762,  4763,
    4868,  4869,  2452,  2895,  2896,  3368,  3694,  4765,  4766,  4796,
    4797,  4767,  4768,  4848,  4849,  4800,  4801,  4802,  4769,  4770,
    2838,  3309,  4065,  4185,  4186,  4187,  4325,  4326,  4513,  4391,
    4501,  4502,  4503,  4393,  3719,  4510,  1026,  4593,  1609,  1610,
    1611,  1612,  2236,  1580,  2237,  1581,  2238,  1582,  2239,  1583,
    2240,  1584,  2241,  1585,  2242,  1586,  2243,  2244,  1587,  2245,
    1588,  2246,  1589,  1590,  2247,  1591,  2248,  1592,  1593,  2249,
    1594,  2250,  1595,  2720,  2122,  1596,  1597,  1601,  1602,  2644,
    2645,  4798,  4799,  4674,  4675,  4676,  4643,  4683,  4684,  4574,
    4680,  4572,  4677,  4504,  4505,  1820,   192,   193,   253,   583,
    3046,  3996,   194,  1825,  2511,  2510,  3039,  3040,  3041,  3458,
    3459,  3460,  4132,  3779,  2513,  3781,  3995,  4337,  4518,   740,
    1145,  1745,  1146,  1147,  2378,  3624,  1148,  1149,  2831,  2003,
    2004,  2628,  1150,   255,   425,   696,   426,   664,   836,  1250,
    2562,   837,   838,   839,  2681,  1264,  1887,  1888,  1255,  1256,
    1257,  3076,  3077,  1914,  3151,  1838,  1839,  1259,  1879,  3049,
    3050,  4506,  2036,  1882,  1249,   427,   665,   872,  1288,  1286,
     428,   666,   889,  1974,  2602,   429,   667,   904,   905,  1976,
     430,   668,   910,  2605,  1247,  1822,  2509,   832,   833,  1978,
    1979,  2608,  2813,  3283,  3609,  3610,  3611,  4000,  1014,  4149,
    4140,  4235,  4141,  4233,  4142,  1323,   431,   669,   915,   916,
     917,   432,   670,   921,   922,  1330,   923,  1326,  2610,   433,
     671,   926,  1335,   434,   435,   672,   936,  1344,   436,   674,
     941,   437,   673,   938,  1345,  1348,   438,   675,   948,  1998,
     949,   439,   676,   960,   961,   962,   963,  1375,   964,  1377,
    2037,  2013,  2014,  3801,  2015,  2633,   965,  1358,   966,   967,
     968,  2040,  2041,   969,  2627,  3131,  3132,  3133,   970,  1379,
    2655,   971,   972,  2626,  3483,   973,  2656,   974,  1360,  2045,
    1027,  3152,  3153,  3154,  3155,  3156,  3500,  3157,  3158,  3159,
    3160,  2038,  1364,   440,   677,   979,  1387,   441,   678,   442,
     443,   720,  2349,  1128,  2811,   444,   679,   984,   985,   986,
    1394,  1395,  1396,  2059,  1397,  2056,  2669,  2665,  2666,  3169,
    1391,   445,   681,   995,  2096,   996,  1426,  3512,  3513,   446,
     682,  1002,  1015,   447,   683,  1003,   448,   684,  1006,   449,
     685,  1009,  2101,   450,   686,   451,   687,  2106,  1436,  2107,
    2686,  2688,   452,   688,  1019,  1437,  2116,  2692,  3183,  3184,
    3185,  3187,   453,   689,  1022,   454,   690,  1028,   455,   691,
    1031,  1032,   990,  2133,   456,   680,  1424,  2095,  2680,  2094,
    3511,  2675,  2134,  2711,  2135,  2136,  3199,  3200,  2708,  2709,
    2710,  3193,  3527,  3528,  3529,   457,   458,  1129,  1720,  3614,
    4161,  3874,  4036,  4037,  2352,   459,  1130,  1722,  3286,   460,
     692,   461,   693,  1039,  1616,   462,   694,  1041,   463,   695,
    1043,  1620,   464,   697,  1047,  1048,  1049,  1627,  2256,  3552,
    3553,  3836,  3829,  3830,  3554,  3555,   465,   698,  1051,  2733,
    2734,  3559,  3221,  1632,  1633,  1634,  2736,  2738,  2739,  3838,
     466,   699,   467,   700,  1057,  4172,   468,   701,  1059,  2301,
    3226,  3227,  3228,  1995,  1996,  1997,  3566,  3230,  3565,  3841,
    1647,   469,   470,   702,  1061,  1655,  3235,  3576,  3236,  3574,
    3237,  1652,   471,   703,  1063,   472,   473,   704,  1066,  1659,
     474,   705,  1069,  2752,  2753,  1663,   475,   476,   477,   724,
    1131,  1132,  1724,  1729,  2359,  2817,  2819,  2820,  1727,   478,
     706,  1073,  1074,  3246,  1668,  1669,  1075,  2305,  3249,   479,
     707,  1080,   231,  1685,  1081,  1082,  2327,  2328,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,   480,   708,  1033,  3204,
    1604,  3537,  2137,  2714,  3535,  3819,   481,   709,  1099,  2330,
    1693,  2783,  2784,  1689,   482,   483,  1135,  1731,  3292,   732,
     733,   484,   710,  1101,  1102,  1103,  1697,  1698,  2335,  3267,
    2791,  1695,   485,   711,  1106,  1703,   486,   712,  1109,   487,
     713,  1110,   488,   714,  1112,   489,   715,  1115,   490,   716,
    1118,  1713,  2800,  2801,  2344,  2803,  3276,  3278,  1711,   491,
     717,  1122,  3625,  3883,  4053,  4054,  4055,  4530,  4056,  4310,
    4311,  4358,  4057,  4259,  4058,  4059,  4173,  4174,  4060,   492,
     718,  1124,  1657,  2347,  2348,  3601,  1716,   493,   494,  1140,
    1738,  3620,  4351,  3875,  3876,  3877,  4046,  4041,  4295,  4167,
    4296,  4297,  3616,  4033,  4034,  4249,  4343,  4344,  4522,  4523,
    4301,  4348,  4349,  4418,  4423,  2373,   495,  1141,  1740,  4250,
    2376,  2829,  3299,  3880,  2518,  3053,  2519,  2520,  3047,  2521,
    2522,  1368,  2007,  1369,  2005,  1370,  2588,  3101,  2589,  3099,
    2590,  3262,  3587,  3263,  3585,  3264,  2748,  3842,  4028,  2749,
    3239,  3240,  3602,  3858,  3603,  3856,  3604,  2621,  2622,  3122,
    2623,  3120,  2624,  1052,  2259,   734,  3063,  3285,  1017,  1018,
     988,   989,  1417,  1418,  3332,  3333,  3334,  3335,  3660,  3661,
    2064,  1419,  3663,  2085,  2086,  2087,  2088,  2089,  1734,  2369,
    1923,   891,   892,   893,   894,   873,   928,  1338,  1070,  1071,
    1133,  1788,  4255,  1789,   840,  1023,  1092,  1093,  2098,  2099,
    1431,  1635,   907,   908,  1783,  2957,  4120,  4329,  1234,  2951,
    2952,  2958,   151,   310,  1004,   930,  1373,   975,   875,  3863,
     876,   877,  4817,  1938,   897,  4021,  1889,  2290,  3666,  1919,
    2565,  3201,  2699,  3520,  1671,  3109,   918,  1119,  1637,  1828,
    2530,  2764,  2765,  2296,  1829,  1034,  1096,  1113,  3051,  3865,
    2872,  3351,   878,   736,   943,  4201,  4202,   931,   932,   899,
    2701,   737,  1235,  1236,  1812,  1138,  1139,  1830,   818,  2532,
    4663,   527,   322,   879,   324,   325,  4424,   880,   881,   882,
     883,  1294,  1273,  1946,  1930,  1931,  1942,  1935,  1924,  1926,
     754,  2802,  4278,  1318,  1960,  2598,  1650,  1613,   766,  1341,
    1989,   354,  3390,  3477,  3786,   661,   662,   663,    34,   794,
    1159,   761,  4178,  4557,  4714,  4558,   795,   762,  1161,   496,
    2809,  2545,  2470,  1203,  3757,  2881,  1260,  1261,  3436,  1362,
    3042,   295,   168,   545,  2458,  1352,  1883,  3330,  2646,  3178,
    1198,  1196,   204,  3945,  1053,  2121,  3209,  3784,  4780,  3811,
    4150,  1421,  2142,   561,  2147,  3493,  2558,  3580,  3608,  4626,
    3401,  4286,  4378,   187,  4836,  4573,  4783,  1186,   782,  4864,
     329,  3542,  4018,  4353,   296,  1884,  3015,  1709,  2871,   155,
    3372,  2454,   535,  4253,  2822,  4379,  1798,  1355,  3188,  3671,
    2647,  2543,  2861,  3637,  3161,  3557,  2104,  2751,  2523,  1371,
    4772,  4692,  4774,  4509,  1339,  4306,  3016,   279,  2955,  3468,
    4403,  1810,  2462,  1332,  2790,   884,  2484,  4109,  4720,  4726,
    4830,  4831,  4832,  4833,  4834,  4568
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     232,   323,   562,  1010,   976,  1916,  1111,  1881,   271,  1166,
    1168,  1169,  1803,   208,  1176,   211,  1706,  1095,  1064,   505,
     216,  1631,   531,  2143,  2527,  2379,    60,  1182,   929,  2528,
    1730,  1187,  1188,  1160,  1190,  1191,   254,  1193,  1194,   119,
     987,  1171,  1221,  1221,   183,   132,  2737,   152,  2524,   555,
    2342,  2065,  2840,   159,  1290,  1258,  2948,  2949,  2084,   156,
     157,   158,   275,  1268,   170,  3359,   163,  2009,   161,   162,
    1992,   164,   165,  1314,  1790,  1670,  1792,  1793,  1020,  1795,
    1796,  2893,   556,  1350,  3079,  2947,  1183,  1184,  2638,   326,
    2467,  1189,  1343,  2063,  1192,  1005,  1204,  1094,  2648,  3092,
    1005,  3060,   890,  3300,   874,   178,  2047,  2048,  2049,  2050,
    3202,  3066,  2540,  1681,  2380,  3348,  2524,  2750,   906,  1005,
    3692,  2350,   188,  1035,  2524,  2568,  1282,  3176,  2570,  3673,
    3685,  3687,   197,   198,   199,  2851,   205,  2576,   206,  1035,
    2637,  2580,   212,   213,  1945,  3901,  1333,  3241,  2583,  2787,
    1107,  1378,   223,  2260,   357,  1342,  1956,  2667,   233,  1950,
     149,  2652,  2614,   925,   239,   149,   503,   244,  2731, -2987,
     246,  3470,  3206,   546,  1392,  4881,   558,   252,   895,  2090,
    1275,  1276,   256,   927,  2677,  4595,   272,   570,  1281,  2341,
   -3343,  4110,   940,  -826,  1885,   927,   172,   311,  4309,  4791,
     927,  1024,  1742,   282,   305,  2341,   912,   332,  3317,  3318,
    3319,  1660,  2144,  1301,  3935,   330,    72, -2988, -3400,   927,
    2703,   551,  1807,  3824,  2457,  2537,  1251,  1823,  2659,   343,
    3162,  1805,   345,  1321,   355,   312, -3400,  4043,  3056,  3057,
    3867,  4144, -3400, -3400,  3058,  3059,   166,  3061,  2100,  2548,
     506,  2302,  4792,   819,  2060,  3812,  1343,  1056,  1606,  2506,
   -1500,  2053, -3400,  1929,   247,  2341,  4360,  2541,   536,   543,
   -1498,  2649,   760,  2012,  1947,  3531,  3320,  3684,  4630, -3258,
    1579,  3533,  3730,  1365, -3282,  4194,  1365,   787,  1915,  1816,
    1056,    75,   925,   202,  2552,   508,  2130,  1737,  1035,    75,
    2757,   903,  2556,   566,   567,  2758, -2270,  1917, -3400,  1917,
    1050,  3269,  3270,  -826,  3321,  1439,  4257,    77,   508,  1687,
      59,    73,  4458,  1299,   574,    77,  2704,   209,  1409,   209,
     273,   577,   257,   522,   209,   202, -3363,  4681, -3400,  4438,
    4878,  4451, -3282,   331,  3250,  3251,  3296,   944,  3212,  3135,
    2798,  3170,  3136,  2716,  2759,   906,  1079,  4845,   558,  3140,
   -3400,   803,  3143,  -618,  1701,   327,   945,    59,  2880,  2529,
     980,  1853, -3343, -3317,   263,   925,   209,  4890,   834,    74,
    2715,  1365,    75,   843,    76,  2557,  2962,  1042,  1044,   844,
     845, -3400,  3521,   202, -3400,  3260,  1432,   895,   895,   895,
     895,  1374,  3593,  1705,  2538,   847,  3864,  3773,    77,  2884,
    1653,  4261,   -42,   721,  3496,  3915,  1429,  2573,   738,    36,
    3796,  2639,   978,  3416,  3496,  3219,  4412,   924,  2726,  4400,
     939,  3420,  1429,   297,  3424,  3425,   122,  1422,  4332,    87,
     927,  2953,   338,   346,   277,  1920,  3924,  4044,   335,  1336,
     532,  3943,  4526, -3400,  4152,  -966,  3067,   992,  1060,   528,
    4184,  1067,  1755,  2963,   538,  1221,  1100,  1258,  4271,  4135,
    1648,   937,  1116,  1258,  3521,  -966,  3461,  1678,  4115, -3400,
    1664,  3744,  2482,  2483,   925,    59,  3423,   788,  3323,  1251,
    4190,  4169,    12,  2253,  4882,  4857,  -966,  -966,  2261,  1005,
    2091,  1990,    78,   796,   797,   903,  1429, -2389,  3909,     3,
    1986, -3260, -2389,  2796,    59,   925,   927,   911,   802,  3224,
    3282,  1886, -3388,  1682,   946,   805,  1072, -1500,   547, -3400,
    4733,  2262,   927, -1500,  1717,  2717,  1035, -1498,   820,  4138,
    3691,  2705,  1366, -1498,  4271,  2366,  4290,  4346,  2357,  4116,
      59,   313,  4413,  4527,  2071,  2366,  3745,  3362, -3260,    89,
    1367, -2389, -3284,  1367,   504,  1649,  4412,  1289,  2366,  1127,
    1423,  3243,  4528,  1735,   559,  3782,  2338,  -618,   848,   849,
     850,  4184,  4401, -3250,  1262,    79,  2366, -3250,  4402,  4111,
     851,   297,  2011,    79,  3807,  4183,  4240,  3808,  3202,   927,
    2851,   123,  2366,  3290,  3231,  3920,   927,  4229,  2366,  4268,
    2145,  1808,  3437,   278,  2092,   336,   202,   313,  2498,  2678,
     855,  3509,   856, -3392,   339,  4793,  4842,  1229,  1054,   314,
    2366,  4844, -1500,  4414,  1304,  3797,  1305,  1306,  1307,  1308,
    1309,  1310, -1498,  2366,   929,   315,  2954,  2366,   722,   895,
    1654,  2574,  3916,   739,  3809,  2706,  4145,  3864,  1367, -3400,
    1918,  2642,  1918,  2643,  3946, -1500,   913, -1500,  1289,   529,
    1331,  2885,  2793,  3810,   202, -1498,    79, -1498,   854,  1327,
     313, -1509,  1420,  1177,   264, -3089,  2640,   529,  2492,    37,
    3261,  3394,  4413,  1680,  1346,   314,  2942,  -966,  4846,   857,
     858,   859,  2671,   298,  2496,   826,  4092,  1434,   860,  2557,
     225,   315,   528,  1934,  1934,  1934,  4183,   538,   529,   207,
    3194,  3014,  3462,  4265, -3282,   789,  3521,  4075,  3773,  1955,
    4529,  4333,   328,  1617,   780,  4014, -3286, -2807,  1008,  1365,
    1181,   -67,  3825,  2524,   835,   745,   929,   258,  3868,   855,
    1251,   856,  -966,   987, -3307,   863,   559,   947,   314,   529,
    3322,  2358,  2507,   313,  1077,  1665,  1438, -3035,  3104,    80,
    2667, -3258,   207,  4414,   315,  1987,  2657,  2524,  3534,   509,
    1991, -3282,   895,   895,   895,  -966,  4146, -3258, -2998,   895,
     895,   895,  2575,   862,  2294,  3596,  1699,  -966,  1642,  1949,
    1289,  2002,   509,  2689,  1240,   895,  -966,   316,   895,   992,
    4652,  2131,  4147,  2291,   895,   895,   895,   895,   895,   895,
     895,   895,   895,   895,   895,   895,  2593,   274,  1732,  1640,
     523,   914,   855,  3731,   856,  4091,  4139,   900,   909, -3400,
    2061,   314,   933,  2729, -3250,  4682,  1990, -3258, -3250,  2257,
    1579,   895,  4258,   312,   933,  1007,   895,   315,  3494,   933,
    3691,   298,  3691,  1036,  2138,   896,  2499,  3213, -1509,  3826,
    3404,  3743,   313,   316,  1065,  -618,  1065,  3497,  1097,  1036,
     745,  1733,  2102,  4008,   863, -3302, -2270,  3997,  -618,  1065,
     207, -3317, -3264,   282,   282,  1134,   207, -3260, -3260,  2555,
     282,  1949, -1500,   313, -3260,  4112, -3358,  3636,  4361,  4262,
     529,  2012, -1498,  3071, -3400,  3225, -3250,   312,   347,   348,
     349,  1078,  2542,   790,  -966,   504,  2542,  -242,   864,   207,
    2062,    83,   248,  1628,  2807,   317,   316,  3171,   282,   312,
     529,   855, -3260,   856,  2132, -1541,   337, -3400,   760,  1302,
     314,  4596,   207,  1201,  1303,  3074,  3772,  1254,  -966,  3075,
    4847,  2508,  3843,   510,  3988,   529,   315,   863,   207,  3402,
     207,   338,   855,  1025,   856,   207,   207,  4439,   929,  4452,
    1951,   314,  1079, -1509, -3302,   249,   510,   528,  1137,   207,
    3936, -3400,   207,  3214,  3869,   511,  1262,   315,   529,   540,
     207,   317,  1262,  3126,  1337,  3220,   417,  2964,  2252,  1786,
    1802,  1787,    86,   318,  1791,  -966,  1367, -3258,   511,   316,
    2489,  2490,  1824,  1801,    87,   788, -3363,   865,   866, -3260,
    1005,  2634,  2146, -3258,   -42,   791,  1736,   350,  1036,  1784,
    1785, -1509, -3400,  1806,  1814,  2480,  2481,   173,  1809,  1794,
    3496,  2486,  2494, -1541,  2487,  1877,  -966,  3788,  2093,  2632,
    3394,   929,    88,  2679,   317,  4113,  2747,  1289, -3302, -3250,
   -3250,   529,   552,  1331,  4415,   909,   863,  2707,  -618,   318,
    3947,  2052,  2054,   504,   896,   896,   896,   896,  3231,  1393,
    1429,  4148,   306, -3258, -3089,  4416,  2566,   868,   529,   933,
     207,  4137,  1993,  1999,   548,  3827,   207,   863,   150,  2081,
    1420,  2592,  1142,   150,   504,   320,   827,   895,   312,  4380,
     424,  2016,  1142,   207,   869,  3114,  4794,  1683,   316,   207,
     927,  4597,   870,  1949,  3910,   234,  2495,   207,   792,  1985,
    3728,  1142,   318,  3186,    89,   529,   312,   317,  2367,  1747,
    4045,  2531,  3889,   339, -3388,    90, -3400,  4664,  2367,   316,
     871,  3828,  1781,  1011,   529,  3722,   207,  2629,  2630,  2585,
    3723,  2367,  2371,  -966,  2591,   933,   312, -3250,  1684,  3948,
   -3398,   320, -1492,  4347,  1178,  3595, -3089,  3597,   207,  2367,
     927,   933,  3127,  2357,  3613, -2996,  4657,  3484,  3485,  3486,
    3487,  2497,  3306,  2582,  4695,  2367, -2389, -2389,   828,  1143,
    2309,  2367,  1994,  1008,  4419,  2071,  1949,  3498,  3055,  1143,
    1815,   925,  -323,  1639,  1817,   318,  1144,  3422,  1631,   207,
    2011,  2140,  4015,  2367,  3925,   313,  1144,  1831,  1143,  4230,
     563,  4029,   312,  2368,   320, -3307,  2367,  4006,   895,  3667,
    2367,  1636,   312, -3085,  3474,  1144,   317,   746,   933,   351,
     352,  4086,  4815,   789,  2841,   933, -3087,  3632,  2667,  -966,
     747,  2785,   353,   283,   283,  3385,  1036,  1137,  2865,  2682,
     283,  1199,  3097,  3098,  2572,  3502,  -966,   317,  3724,   913,
      59,  3759,  4139,  3415,   852,   853,  2119, -3400,  3766,   313,
   -3081,  3032,  1134,  4313,  2940,  2761, -3076,  2700,  4420,   730,
   -3400,   929,   207,   314,  2254,  3118,  3119,  4168,   283,  4602,
   -3089,   313,  2529,  3044,  2866,  1207,  3463,   320, -3083,   315,
   -3250, -3250,  1628,   558,   318,  4496,   896,  4121,  3503,  1302,
    3505,  2596,  4131, -3400,  1303,  3917,  1328,  2010,  3344,  3233,
    2139,  1388,  1833,   209,   209,  3093,  1834,  2850,  3926,  2619,
    2685,   225,  2123,   209,  3172,   318,  3017,  3018,     9,  4381,
    4645,  1886,  3020,  3021,    75,  1035,  2317,   314,  4380,  2319,
    4314,  3844,  3180,  1205,  3845,   225,  3540,   225,  3728,  2672,
    1699,  1151,   746,   315,   529,    59,  4570,  2339,  2320,   314,
      77,  2100,   829,  1208,    27,   747,  2358,   830,   225,  1799,
    4285,   284,   284,  4061,  2306,   315,  3207,  1886,   284,  1210,
    3426,   207,  1036,  2363,  3990,  2564,  2690,  2604,   225,  3218,
   -1467,  2858,  1311,  2298,  2291,  2693,   320,  2956,  4246,  2331,
     184,  3090,  1312,  3238,  3590, -3400,  3592,  3242,  4016, -1492,
    4087,   529,   207,   529,   914, -1492,   284,  2469,  1952,  3137,
     831,   790,   927,  3405,  3927,   913,   927,   320,  3737,   896,
     896,   896,  2781,  3347,  4389,  3456,   896,   896,   896,  3499,
    2716,  3406,  2782,  3075, -3400,   240,  2788,  2377,  4795,   202,
    2566,   316,   896,  1079,  1011,   896,  2620,  1013,    15,    -7,
     313,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,  3289,    28,  3370,  3479,  2700,   285,   285,
    1598,  3928,  3130,  2109,  4790,   285,  2110,  2111,   313, -3358,
    3163,  2129,  3165,  2768,  4196, -3400, -2998,  4389,   896,  2311,
    4816,  4818,  1011,   896,  2129,  2485,  2859,  2485, -3433,  2485,
    2485,  2842,  2485,  2485, -1492,   316,  1137,  1329,   313,  3081,
    1952,  3083,   809,   285,  3085,   927,  3794,  3087,  3088,  3089,
    4856,  3091,  4670,   791,  3095,   225,  2264,   316,   314,  2619,
    2873,  1212, -3400,   225,  2879,  3107,  3108, -1492,  1206, -1492,
    3457,  3991,  4429,  4496,   315, -3089,  2795,  3208,  4421,  3211,
    4122,  4851,   909,   755,  -323,  1230,   314,  1079,  3345,   313,
    2874,  3833,  3975,  4408, -3400,  3216,  2631, -1954,   746,   317,
    2766,  3612,   315,   539,   313,  4669,  3984,  4204,  4381,   537,
     225, -3434,    33,  3128,   313,  3371,   314,  3727,  3569,  2364,
    2479,  2725,  4156,  3890,  4866, -3401,  2265,  2266,  2267,  2268,
     241,  2269,   315,  2141, -3282,  3455,  4867,  4497,  2097,  3455,
    4382,  4571,  2717,  1005,  1429,  4819,  4723,   804,    79,  3271,
    3129,  3570,  4749,  3627,  2329,  3628,   792, -3302,   855,  4371,
     856,  1389,  -323,   317,  1736,  1835,    43,   314,  2703,  3045,
    3234, -3382,  2586,   852,   853,  1289,  4383,   318,  -323,    47,
    3280,  1152,   314,   315,  2357,   317,  1008, -3400,  2321,  1213,
    4498,  2747,   314,  1153,  2741,  3244,  2620,  3725,   315,   286,
     540,  4820,  1154,  3253,  3138,  4670,  2941,  2611,   315,  4049,
    2887,   559,    59,  2270,  2271,  2382,  2392,  4670,  2120,  3028,
    2453,  2456,  1207,  2459,  3019,  3464,  2464,  2466,   925,  2468,
    3103,  4224,   207,  2473,   529,   529,   316,  4718,  3762,  2016,
     207,   318,  3096,   927,   927,   927,  3245,  2322,  1035,   149,
    2081,  4719,   225,  4088,  3570,  2867,   756,  3094,  4422,  3078,
    4241,  4242,  4123,   318,   316,  2967,   529,  3013,  3070,   933,
    3545,  2891,  1952,   207,  2704,  3929,  4095,  4096,  2600,   320,
    3274,  2618,  2323,  2789,   896,  2824,  2826,  4244, -3392,  4217,
    4160,   207,    87,   863,   316,  4105,   243,  4672,  3244,   191,
    1208, -3089,  2850,  1209, -1492,  2843,  2533,  1012,  1013,  4106,
    3281,  1365,  2534,  3443,  3444,  2535,  1210,  2536,  1836,  1837,
    2724, -3400,   207,   225,  1599,  2531,  4127,   166,   207,   933,
     927,  2766,  4188,  2766,   225,  2531,   207,  -553,   207,   808,
    -323,   812,  3403,   320, -3402,   316,  4003,  1211,  2860,  3245,
     319,  1827,  3407,  2763,  1155,  1952,  1013, -3331,  4315,   207,
     316,   895,   895,  3550,   317,   320,  3918,  2700,   207,  1216,
     316,  3930,   167,  2365,  4657,   312,   207,  4316, -3282,   207,
    2587,   725,  4404,  -553,    16,  3438,    17,  2841,   207,  2324,
    2935,  2936,   317,  1600,  4317,  4497, -1467,  2358,  4499,  4382,
    2272,  2273,  2274,  2275,  2276,  2277,  2278,  2279,  2280,  3572,
    3573,  1156,    89,  4050,   810,   896,   207,  4500,  4371,   207,
    2606, -1954,   317,  1231,  3679,  1920,   529,  3612,  4862,  1983,
   -3382,  4368,    52,  3124,   209,  4383,  3583,  3584,  -863,  2766,
    2766,  3999,   318,    54, -2876,  3691,  2856,  2722,  4498,  -553,
    4672,  2615,  1157,  4004,  4005,  1628,  4640,  4671,  3662,  3817,
    1623,    56,  4672,  1743,  3618,  4647,  3619,  4225,  -323,   811,
     318,   757,  3370,   317,  4751,   758,  2937,  4051,  1212,  3546,
    1984,  2728,   207,  3834,  2824,  1642,  2824,  2641,   317,  2705,
   -1954,  2771,  1036,  3113,  3835,  3164,  2651,  3166,   317, -3433,
     318,    -6,  2325,  2112,  2113,  3408,  4030,  3130,  1895,  2010,
    3106,  4517,  4519,  4520, -3433,  1896,  1640,  3599,  1232,  4725,
     982,    59, -3400,   202,  4417,  4203,   207,  4752,  2754,   207,
      58,   983,  2607,  2281,  3117,   578,   579, -3400,  2873,  3244,
    3409,  1827,  4052,  2586,   320,  4275,  -323,  1207,   529,  3410,
   -2182,   318,   313,   313,  3475,  2114,  2115,   207,  2792,   726,
     895,  1624,   895,  2844,   929,  2845,   318,  1366,  -553,  1158,
    2792,  1744,   320, -3400,  2846,  2847,   318,  1068,  2848,  2849,
    1625, -3400, -3434,  2039,   759,   927,   895,   312,  1367,  4521,
    3245,  2616,  3373,   927,  3417,  1036,    61, -3434,   529,  2841,
    -323,   933,   320,  2706,  4828,   933,  1213,  3547,  3370,    63,
     895,  1214,  1215,   313,  -323,  2767,   313,  1429,  2072,  2073,
    -863,  3370,  3382,  4517,  -553,  1208,    68,   909, -2182,  4821,
     314,   524, -3400,  -323,   929,  4622,  4623,  4203,   207,  4822,
    4823,  1210,  3210,   133, -2182,  1640,   315,   315,  -323,  3571,
     927,  2619,   927,   320,   580,  4863,  4499,  3288,  2772,  2773,
    2774,  2775,  2776,  2777,  2778,  2779,   118,  1628,   320,  3523,
     207,  4321,   277,  2345,  2842,  4500,  2282,  2326,   320,  -553,
    3818,  4369,   759,  2832,   313,   855,  3525,   856,  1895,  1151,
    4322,   314,  3804,  -553,   314,  1896,  2074,  2075,    -6,  2283,
    4655,  4656,  4143,   225,   933,  3548,  3259,   315,  1302,  2876,
     315,  3370,  -553,  1303,  1328,  4858,  -553,   927,  4860,   927,
    4824,  2514,   997,   120,  2891,  3024,  2346,  3026,  3375,  2485,
    1365,    -6,  4084,    -6,  3328,  4754, -3402,   727,  1626,  3526,
    3879,  3377,  4825,  4826,   125,  2676,  2975, -3402,  2474,  1207,
    4859,  2587,  3571,  4861,  4755,  4134,  1005,   313,  4808,  3631,
    4636,  4809,   314,  2946,  4673,  4678,  4355,  4639, -2876,  3418,
    2959,  4642,  2550,  3078,  4644,  3854,  3855,  2551,   315,  3896,
     783,  3356,   895,  3662,  3600,  2586,  1216, -3400,  2620,   927,
    2067,  2068,  2069, -2998,  3491, -2998, -2998, -2998, -2998, -2998,
   -2998,  3065,  2976,  1212,  2475,   130, -2182, -3250,   316,   316,
    3481,   728,  2315,  4852,  3492,  1046,   852,   853,  2108, -2236,
     863,   313,  2109,  2316,  4356,  2110,  2111,  1208,  4810, -3382,
    1209,  3379,   176,   207,  1302,   314,   138,    59,  4689,  1303,
    3490,   278,  4690,  1210,  4143,  4670,  2767,  2700,  2767,  2839,
    2835,   315,  4085,   139,  3111,  2938,   927, -1107,  2766,  4807,
    2862,  2863,  2864,   764, -2998,   729,  4357,  1690,  4698,   316,
    3465,  4699,   316,  4871,  1211, -3039,  2888,  2889,  2890, -3039,
    2544,   927,   145,  2453,   225,  -553,  2842,  4784,  4838,   581,
     784,   785,   202,  4193,  3466,  4803,  2070,   765,  3467,   524,
    3816,  3036,   933,   933,   933,  4885,   134,  3141,  3142,   135,
     136,  3482,  4813,  3086,   909,   315, -1107,  -553,   730,    16,
   -2236,    17,  -553,  4668,  4874,  1329,  2966,  1302, -1107,  2700,
    2961,  1213,  1303,  4170, -2182,  4445,   317,   317,  1636, -2236,
     316,  4839,  -553,  3252,  -553,  2465,  3755,  3756,  2843,  3549,
    3134,  3581,  3582,  2939,  2767,  2767, -3382,  4668,   998,  3030,
    3031,  1036,   999,  3550,  3562,   142,  3268,  3695,    -6,   313,
    3232,  1691,  4370,  1055,   108, -1107,  1062,  1692,   147,  2488,
    1076, -3382, -3382, -3382,   529,   146,  3519,   226,  1036,   933,
     227,  4371,  1000,  2587,   153,  3293,  3293,   317, -1107,  1152,
     317,  1349,  4701,  3062,   207,  1212,  2517,  1367,  4372,  3508,
    3068,  1153, -2182,   316,   318,   318,  3749,   108,  4837,  4702,
    1154,  3064,  4577,  3064,   108,  2707,  3696,  2370,   852,   853,
     207,  4583,  2124,  2754,  1707, -3400,  3327,  1302,  3697,  4586,
    1708,  3287,  1303,   529,  2857,   731,  4718,   314,   896,   896,
     180,  2126,  2127,  2128,  4703,   110, -1107, -2998,  4723,  4840,
    4719,   154,  4446,   315,  4872,  4873,  2071,  1636,   317,  1302,
    4304, -3331,  2514,   160,  1303,   318,   111,   316,   318,  4039,
    4305,  1365,  4624,  4625,  3674,  3698,  2460,  4447,  4448,  4449,
    4672,  2082,  2461,  2083,   176,  1001,   207, -2236,   110, -2182,
    -553,   207,  3638,  3606,  -553,   110,   189,  3607,  3699,  1958,
    1640,  1216,  4704,  4724, -2182,   209,   320,   320,  3942,   111,
    1302,  3295,   920,   207,   504,  1303,   111,  2360,  3478,  3064,
    3064,  2360,  1302,  1213,   202,  4705,  2617,  1303,  4575,  1302,
   -1107,   317,  3979,   186,  1303,  4368,   318,  1640,  4575,  4718,
    1640,   226,  2072,  2073,   227,   927,   195,   927,  4401,  2515,
    2843,  2516,  4001,  4719,  4402,   207,  3700,   207,  3768,  1922,
    1925,  1928,  1155,  -553,  2386,   210,  2387,   320,  1036,  1036,
     320,  2700,   218,  4012,  1036,  1036,  1036,  1036, -2966, -2966,
   -2966, -2966,  1036,  3721,  1036,  1957,  1036,   150,  3551,   504,
    2594,  1640,    55,   927,    57,   317,  2844,   234,  2845,  3429,
    1302,  2526,  4781,  -553, -1107,  1303,   236,  2846,  2847,   318,
    1429,  2848,  2849,  1357,  4895,   316,  4896,   209,  4897,  1156,
    2074,  2075,   237,   207,  1222,  1381,  1382,  1383,  1384, -2965,
   -2965, -2965, -2965,  4713,   933,  3072,  3073,   896,   320,   896,
    3701,   276,   933,   251,  2485,  2485,   280,  2485,  2485,  3024,
    1961,  1962,  2766,   927,  1936,  1937,  1223,  1224,  3866,   281,
    1157,  4731,  4732,   896,   286,   333,   306,  4736,  4600,   334,
    4776,   344,   356,   318,  4777,  4778,   498,  3428,   533,  1036,
    1297,  1298,  1036,  1300,   534, -1107,   542,   896,  2076,  1036,
    1036,  1036,  1036,  3488,  3374,  3376,  3378,  3380,   543,   933,
     550,   933,   563,  1216,  4231,  4232,  3872,   767,  3313,  4237,
     927,   320,  2112,  2113,  3703,   565,   284, -1107,   576,   719,
     723,  2676,   741,  2077,   742,  2515,   780,  2516,   800,  3195,
    3893,  3798,  2078,  3799,   801,   225,   768,   807,   806,   813,
     814,  2079,   815,   317,   816,   822,   935,  2517,  1367,   895,
     994,  1030,  3639,   769,   770,  1021,  4243,  1008,  1045,  1046,
    1108,  1054,  1126,  2767,  2114,  2115,   933,  1137,   933,   504,
    1162,  1163,  1180,  1289,  1185,   320,  1197,  1158,   312,  1195,
    1202,  1228,  1238,  1242,  2080,  4369,  3561,  1246,  1263,  1248,
    2841,  1267,  1265,  1270,  1271,  3704,  1272,  1274,  1277,  1278,
    4782,  4226,  4227,  1279,  1280,  1759,  3881,  1283,  2844,  1285,
    2845,  1293,  1295,  1296,  1313,  3413,  1317, -1107,  3414,  2846,
    2847,   318,  1320,  2848,  2849,  3515,  1322,  3706, -3400,  1334,
    1340,  3421,  3556,  4782,  1347,  3196,  1351,  3522,   933,  3430,
    3431,  1349,  1354,  2485,  3568,  4302,  1356,  1359,  1151,  1361,
    1036,  1760,  1363,  1376,  1385,  1386,  1425,  1390,  1628,   896,
    1427,  1430,  1605,  1435,  1615,  1618,  1619,  1621,  1643,  4559,
    4560,  1644,  1646,  4206,   771,  1651,  3921,   843,  2143,  1656,
    1658,  1666,  1662,   844,   845,  1661,   927,  1667,   927,  1675,
     759,  1079,  1679, -1107,  1686,  1688,  1696, -1107,  3664,   847,
    1694,   166,  1702,  1712,  1710,   933,  1715,  1718,  4189,  3866,
    1719,  1726,  1728,  1736,  3621,  1748,  1749,  1761,  1754,  3522,
    1756,  1758,  1636,   320,  1797,  1251,   202,  4392,  3472,  1811,
     933,  1841,  1892, -3382,  1963,  1964,  1965,  1966,  1967,  1968,
    1969,  1970,  1971,  1972,  1921,  4330,  4426,  1944,  1932,  1933,
    1943,  2067,  2068,  2069,  1959,  1954,  1973,  1640,  1975,  1636,
    1640,   903,  1636,  1988,  2766,  1994,  2001,  2044,  1366,  2097,
    2057,  2046,  2103,  3144,  2105,  3145,  2118,  2255, -1107,  2251,
    2263, -2998,  2258,  2292,  2293,  2295,   529,  2300,  2318,  2341,
   -2998, -2998,  2307,  2308,  1137, -2998,  2310,  2334, -1969,  2336,
    4083,  2337,  4395,  3708,  2340,  2343,  4507,  3709,  2351,  1640,
    1640,  2081,  1640,  1636,  2353,  2082,  2355,  2083,  2372, -3250,
    2374,  2383,  2457, -3250,  2384,  2469,  2471,  2491,    84,  2503,
    2512,  2525,  4073,  4074,  2526,  2544,  2547,  3672,  2549, -1107,
    1640,  2553,   772,  2554,  2546,  2559,  2557,  3789,  3790,  3791,
    3792,  2560,  2561,   773,  2563,  2569,  2571,  2070,  2577,  2578,
   -3382,  2609,  2579,  2581,  2584,  2485, -2922,  4157,  2595,  2597,
    2601,  2603,   848,   849,   850,   895,  4370,  2842,  2612,  2613,
    2658,  2625,  2660,  2668,   851, -3382, -3382, -3382,  3710,  2673,
    3729,  2670,  2687,  2691,  2719,  4371,  2131,  3735,  2727,  1050,
    2742,  2770,  2755,  2762,  2797,  2799,  2808,  2810,  2812,  1036,
    2821,   313,  4372,  2828,  2830,  2816,  2818,  2837,  3589, -1107,
    3769,  3770,  3895,  2855,  1784,    59,  3760,  2891,  2860,  2856,
    2869,  2870,    72,  2878,  2880,  3767,  2894,  2882,   312,  2883,
    2945,  2960,  2950,    85,  3038, -3015,  3069,    59,  3626,  3711,
    2841,  1886,  2586,  3084,  2587, -2997,  2619,  3139,  1152,  3515,
     313,  1762,  3115,  2620,  3197,  3629,  3167,  2767,  3168,  3556,
    1153,  3522,   854,  3174,  3175,  3177,  3181,  3182,  2766,  1154,
     755, -1107,  3190,  4531,  1763,   774,  3189,  3191,  1036,   314,
    3205,  3222,  3223,   857,   858,   859,  3248,  2747,  3676,  3273,
    3272,  3275,   860,  3265,   933,   315,   933,  3284,  3848,  3849,
    3277,  3297,  3298,  3821,  3302,  2676,  3308,  3301,  1628,   852,
     853,  3336,  3310,  3664,  3329,  4179,   775,  2071,  4205,  3714,
    3339,  3316,  3341,  3314,  3342,  4238,  3878,    73,   314,  3350,
    3360,  3367,  3381,  3383,  3387,   776,  3397,  3389,  3392,  3400,
     282,  3432,   933,  3395,   315,  3419,  3435,  4247,  3433,  3434,
    3440,  3442,  3454,  3471,  4507,  3476,  3480,  3504,  3741,  3742,
   -2927,  3146,    82,  3748, -2995,  3751,  3752,  3753,  3754,  3510,
    3524,  3532, -2990,  3506,  3538,  3761,  3544,   862,  1640,  3541,
    3558,  3716,  3563,  3234,  3564,    74,  3578,  4561,    75,  3233,
      76,  3579,  3260,  3615,  3261,  3617,  4260,  4312,  3630,  3775,
    3622,  3665,   933,  2072,  2073,  3668,  2766,  1176,  3623,  3670,
    3680,  2529,  3693,  3720,    77,  3763,  3778,  3764,  3776,  3780,
    3783,  1155,  1640,  3785,  1640,  3800,  4773,  3795, -1969,  4299,
    3805,  3525,  3810,  3806,  3526, -3401,  3815,  3837,  3832,  3839,
    3941,  2843, -3250,   756,  3846,  3642,  3147,  4312,  3847,  3600,
    3599,  3873,  3882,  3899,  3892,  3884,  3897,   316,  4007,   933,
    3888,  3898,  3900,  3902,  4009,  4010,  3903,  3907,  3913,  1636,
    3922,  3932,  1636,  3906,  3986,  1764,  3985,  3987,  1156,  3822,
    1765,  2074,  2075,  3994,  4017,  4013,  4019,  3934,  4025,  4040,
    4047,  3905,  4067,  4066,  4071,  2873,  4089,  4090,  4093,  4097,
    1766,  4098,  1767,  4103,  4104,  4126,   316,  3840,    78,  4136,
    4175,  4166,   864,  4176,  4181,  4075,  4323,  4199,  4049,  1157,
    4212,  1636,  1636,  4228,  1636,  4138,   896,  2842,   209,  4248,
    4252,  4254,  4251,  2485,  4267,  4287,  4288,  4289,  4294,  4335,
    4338,  3688,  4339,  4352,  3739,  3739,  4363,  4364,  4300,  2076,
    2479,  4366,  1636,  4324,  4327,  4365,  4308,  4398,  4405,  3950,
    3992,   209,  4396,  4428,  4437,  3974,  4431,  4440,   209,  2767,
    3977,  3978,  4444,  4427,  4450,  4441,  4453,  3887,  3981,  4454,
    3983,  4514,  3878,  4457,  2077,   317,  4525,  2538,  4585,  4591,
    4628,  4629,  4835,  2078,  3148, -3250, -3250,  4733,  4779,   777,
     778,  4886,  2079,  1036,  4887,  4888,  2531,  4893,  4899,    35,
     313,   865,   866,  2505,   129,  3037,   245,   573,    32,   171,
    1818,  2501,   303,   541,  3033,  2017,  2018,  2019,  2020,  3453,
     553,   174,   569,  2021,   317,   933,  1158,   933,   222,   304,
    1804,  1226,   798,   557,   799,  2080,  4331,  4223,  2994,  4599,
    4062,  2022,  2023,  3750,  4207,  4284,  4151,  3758,   757,   793,
    3439,  3771,   758,   318,    67,  4277,  4100,  3740,  3823,   852,
     853,  1245,  4442,  4367,  4455,  1170,  3198,  2897,  2730,  3641,
    2391,   868,    79,  4750,  2934,  3672,  3951,  4875,   314,  4273,
   -1969,  4195,  2718,  4328,  3686,  2892,  4094,  3919,  4756,  2844,
    4133,  2845,  2024,  3312,   315,  3982,  4108,  4667,   869,  2502,
    2846,  2847,   318,  4712,  2848,  2849,   870,  4764,  3369,  3993,
    4841,  4843,  4266,  4649,  4394,  4594,  1037,  4578,  2125,  2485,
    4101,  1768,   529,  4579,  1614,  4679,  3149,  4582,  4592,  3043,
    1821,  2025,  3774,  3777,   871,  3989,  3862,   497,  1826,   759,
     207,  3473,  1065,  1832,  3469,  2539,  2599,  3112,  4011,  1319,
    4236,  3787,  1880,  4234,  1982,   320,   981,  3860,  4102,  1325,
    2051,   759,  1372,  2000,  2635,    80,  3802,  2653,  3992,    81,
    3489,  1380,  3125,  2767,  1038,  2058,  3173,  2055,  3507,  1428,
    3803,  3516,  2683,  2712,  3517,  1893,  1894,  2117,  4119,  3530,
    1636,  2843,  1603,  3192,  3814,   209,  1640,  3813,  4032,  4164,
    3831,  1622,  2732,  3560,   320,  2354,  1433, -1969,  1645,  2744,
    3229,  3567,  3577,  3575,  3279,  4048,  2362,  4220,  4222,  4220,
    4180,  3291,  2303,  1676,  2780,  4069,  1677,  1098,  3294,  3150,
    2805,  2333,  3594,  2806,  1636,  4359,  1636,  2356,  4256,  4082,
    2756,  2743,   896,  4341,  4042,  3871,  4162,  4410,  4524,  4425,
    2375,  3054,  3048,  2026,   209,  3102,   316,  4198,  3588,  3100,
    3598,  2008,  2081,   209,  2006,  3586,  2082,  4027,  2083,   209,
    3859,  3605,   209,  3857,   209,   209,  3123,  3121,  4696,  1324,
    4191,  4192,   209,  1091,   209,  2066,   209,  3894,    82,  1895,
    4245,  3688,  3255,  3733,  1725,  3256,  1896,  3257,  3258,  1897,
    1125,  3399,  2684,  4279,   560,  1036,  1977,  4031,  4022,  4279,
     529,  2767,  2027,  2769,  1980,  4581,  4125,  3029,  4788,  4128,
    4129,  2676,  4274,  4601,  4685,  1239,  4130,    83,   735,  1284,
    1227,  4281,  2393,  2786,  3116,  3391,  4715,  3591,  3851,  4565,
    1780,  4771,  2944,  4171,  4697,  3495,  4153,  4154,  4155,  4209,
    4691,  3518,  2028,  1898,  4805,  1266,  4865,  3998,  1899,  1900,
     564,  4307,  3543,   575,  3736,  2650,  2823,  1840,  4163,  3682,
    4715,  4515,  4693,  4165,    84,  2463,    85,  3025,  4829,  3980,
       0,     0,     0,     0,   317,     0,  4020,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4292,  4293,
       0,     0,     0,     0,     0,     0,     0,     0,    86,     0,
       0,     0,  4276,     0,     0,  4354,  2887,     0,     0,     0,
      87,     0,  4283,  4283,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1901,     0,  1902,     0,     0,  2029,     0,  4211,  2844,
    1903,  2845,     0,     0,     0,     0,   209,   209,    88,  1904,
    2846,  2847,   318,  4876,  2848,  2849,     0,     0,     0,  4409,
       0,     0,   209,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4107,     0,  2636,     0,     0,     0,     0,     0,     0,  4220,
       0,     0,   209,     0,     0,     0,   209,     0,     0,     0,
     841,     0,   898,     0,     0,   919,     0,     0,     0,  1036,
     942,     0,   977,     0,     0,     0,   991,     0,     0,  4272,
       0,     0,   909,     0,     0,     0,  1029,     0,     0,  1029,
      89,  4399,     0,     0,     0,     0,  1058,     0,     0,     0,
       0,    90,     0,  2030,     0,  4567,     0,     0,     0,     0,
    1114,     0,  1120,  1123,   320,     0,     0,  4512,  1905,   909,
       0,     0,     0,     0,     0,     0,  1136,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   209,   209,     0,     0,     0,     0,
       0,  2298,     0,     0,     0,     0,  4533,     0,     0,     0,
     933,  4220,     0,  4334,     0,     0,     0,     0,  1636,  1906,
       0,     0,  4336,  1907,  4208,     0,     0,  4340,     0,     0,
    4210,  4342,     0,     0,     0,  4650,     0,     0,  2485,     0,
     902,     0,     0,     0,     0,     0,  4362,   209,     0,   895,
     895,     0,     0,     0,   993,     0,     0,  1036,  4584,  1079,
       0,     0,     0,     0,  1867,     0,  1868,  1869,     0,     0,
       0,  4406,  4407,     0,   909,     0,     0,     0,  4411,   895,
       0,     0,     0,     0,     0,     0,  2031,     0,     0,     0,
    1121,  2032,  1269,  4430,     0,     0,  4433,  4434,  4435,  4436,
       0,     0,  3952,  3953,  3954,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   933,     0,  4508,   209,   209,     0,     0,     0,
    2033,   898,   898,   898,   898,     0,   209,   209,     0,     0,
       0,     0,  2034,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4641,     0,     0,     0,     0,     0,     0,     0,
       0,  4648,   919,     0,     0,     0,     0,     0,     0,     0,
    4538,  4539,  4540,  4541,  4542,     0,     0,  4544,  4545,  4546,
    4547,  4548,  4549,  4550,  4551,  4552,  4553,  4554,     0,  1353,
    4556,     0,  4566,   901,  4569,     0,     0,     0,   934,     0,
       0,  4662,     0,  4576,     0,     0,  4580,     0,     0,     0,
     934,     0,     0,     0,     0,   934,     0,     0,     0,     0,
       0,     0,     0,     0,  3955,  3956,     0,  3957,  4589,     0,
       0,     0,     0,     0,   934,     0,     0,     0,     0,     0,
       0,  2035,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1292,     0,     0,     0,   209,     0,  1036,  1058,   902,
     902,   902,   902,     0,     0,     0,     0,     0,  4662,     0,
    1316,  1440,     0,     0,     0,     0,     0,     0,   991,     0,
       0,     0,     0,  1640,  1908,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4662,  4662,  1638,     0,
       0,     0,  4662,     0,     0,  4662,  4637,     0,  4638,  4662,
    4662,     0,     0,     0,     0,     0,     0,  1640,  4646,  4786,
       0,     0,     0,  1672,     0,   843,     0,     0,     0,     0,
       0,   844,   845,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4804,     0,     0,     0,   847,     0,     0,
    1700,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4814,     0,  4666,     0,     0,     0,     0,     0,  1714,  1909,
       0,     0,     0,  4662,     0,  1721,  1723,  4804,  4662,     0,
    1910,     0,  4508,   898,     0,     0,  1739,  1741,  4850,     0,
       0,  1911,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1291,     0,   993,     0,     0,     0,
       0,     0,   901,   901,   901,   901,  3958,  3959,     0,     0,
       0,     0,     0,  1315,     0,     0,  1641,     0,     0,     0,
       0,     0,     0,     0,     0,  4721,  4722,     0,  4727,     0,
       0,  3960,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1674,     0,  4730,     0,   934,     0,     0,  4734,  4735,
       0,     0,  1912,  4898,     0,     0,     0,  3961,     0,     0,
       0,     0,     0,     0,     0,     0,  4785,     0,     0,  4787,
       0,  4789,     0,     0,     0,     0,  4737,     0,     0,     0,
    1036,     0,  3962,     0,     0,     0,     0,  1036,  1913,     0,
       0,  1036,     0,     0,  1036,     0,     0,     0,     0,  1890,
    1891,   902,     0,     0,     0,     0,   898,   898,   898,     0,
     848,   849,   850,   898,   898,   898,  1939,     0,     0,  1939,
       0,   934,   851,     0,     0,     0,     0,     0,     0,   898,
       0,  1939,   898,     0,     0,     0,     0,   934,   898,   898,
     898,   898,   898,   898,   898,   898,   898,   898,   898,   898,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2396,
    1120,     0,  1981,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   898,     0,     0,     0,     0,
     898,     0,     0,  3963,     0,     0,     0,     0,  1036,     0,
       0,  1036,     0,     0,  1673,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   934,     0,     0,     0,     0,  4738,
     854,   934,  1895,  4739,  2042,     0,  3964,     0,     0,  1896,
    3965,  3966,     0,     0,     0,     0,  1151,  1117,     0,     0,
       0,   857,   858,   859,   902,   902,   902,     0,     0,     0,
     860,   902,   902,   902,  1941,     0,     0,  1941,  3967,     0,
       0,     0,     0,     0,   901,     0,     0,   902,     0,  1941,
     902,     0,     0,     0,     0,     0,   902,   902,   902,   902,
     902,   902,   902,   902,   902,   902,   902,   902,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1121,     0,
       0, -3341,     0,     0,     0,  1636,     0,     0,     0,     0,
       0,     0,     0,   902,     0,     0,     0,     0,   902,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   862,   896,   896,     0,  1636,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3341,     0,     0,     0,     0,     0,   896,     0,     0,     0,
       0,     0, -3341,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2017,  2018,  2019,  2020,     0,
       0,     0,     0,  2021,     0,     0,     0,   901,   901,   901,
       0,     0,     0,     0,   901,   901,   901,  1940,     0,     0,
    1940,  2022,  2023,     0,  1953,     0,     0,     0,     0, -3341,
     901,     0,  1940,   901,     0,  3968,     0,     0,     0,   901,
     901,   901,   901,   901,   901,   901,   901,   901,   901,   901,
     901,     0, -3341,     0,     0,     0,     0,     0,     0,     0,
       0,   898,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2024,     0,     0,     0,   901,     0,     0,  4740,
     864,   901,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3341,  2025,  2297,     0,     0,  2043,     0,     0,     0,     0,
       0,     0,     0,  2304,     0,     0,  1953,     0,     0,     0,
       0,     0,     0,  2402,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3373,     0,     0,     0,     0,
       0,     0,  2332,     0,     0,     0,  1152,     0,     0,     0,
       0,     0,  4741,     0,     0,     0,  4742,     0,  1153,     0,
       0, -1552,   358,     0,     0,     0,   359,  1154,     0,   865,
     866,     0,   360,     0,  2361,     0,     0,     0,     0,   902,
     361,     0,   898,     0, -3341,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -1552,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4743,     0,     0,
       0,     0,     0,  2026,     0,     0,     0,     0,     0,     0,
    2299,     0,     0,     0,     0,     0,     0,     0,     0,   868,
       0,     0,     0,  2017,  2018,  2019,  2020,     0,     0, -3341,
       0,  2021,     0,     0,     0,     0,     0,     0, -3341,     0,
       0,  4744,   363,   364,     0,     0,   869,     0,     0,  2022,
    2023,     0,     0,     0,   870,     0,     0,     0,     0,     0,
       0,     0,  2027,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   365,     0,     0,     0,     0,  2405,     0,
       0,     0,   871,     0,     0,     0,     0,     0,   207,  4745,
     902,     0,     0,   366,     0,     0,     0,   367,     0,  1155,
    2024,     0,  2028,     0,     0,     0,     0,     0,     0,     0,
       0,  1890,   901,     0,     0,   368,     0,     0,     0, -3341,
       0,     0,     0,     0,     0,   934, -3341,  1672,  1953,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2025,
       0,     0, -1552,     0,     0,     0,     0,  2567,     0,  3695,
       0, -3341,     0,     0,     0,     0,  1156,  1939,     0,   369,
       0,     0,     0,     0,     0,   370,     0,   371,     0,     0,
       0,   372,     0,     0,     0,   373,     0,     0,     0, -3341,
       0,     0,     0,     0,     0,   934,     0,     0,     0,     0,
       0,     0,   374,     0, -1552,     0,  2029,  1157, -1552, -1552,
   -1552, -1552, -1552,     0, -1552, -1552, -1552, -1552,  3696, -1552,
   -1552,  1953, -1552, -1552,     0, -1552, -1552, -1552, -1552, -1552,
    3697, -1552, -1552, -1552, -1552, -1552, -1552,     0,     0,   375,
       0,     0,  2410,     0,     0,     0,     0, -1552,     0,     0,
       0,  3501, -1552,   901,  4746,   376,     0,     0,     0,     0,
     377, -1552,     0,     0,  1185,  1674,   378,   379,     0,     0,
       0,  2026,     0,     0,     0,     0,  2042,  3698,     0,     0,
    2654,     0,     0,     0,     0,     0,  4747,     0,     0,     0,
       0,     0,     0,     0,     0,  1941,     0,     0,     0,     0,
    3699,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2030,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,  1158,   381,     0,     0,   382,     0,
    2027,     0,     0,   383,     0,     0,     0, -3341,     0,     0,
       0, -3341,     0,     0,     0,     0,     0, -3373,     0,     0,
       0,     0,     0,     0,  4748,     0,     0,  2694,  3700,   384,
    2695,     0,  2696,  2697,  2698,     0,     0,   385,     0,   386,
    2028,     0,   387,     0,     0,   388,     0,     0,  2721,     0,
    2413, -1552,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   389,     0,     0,     0,     0,     0,  2386,     0,  2387,
       0,     0,  2417,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1673,     0,
       0,     0, -3341,     0,  1867,     0,  1868,  1869,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   759,     0,     0,
       0,     0,  3701,     0,     0,     0,  2031,     0,  1940,     0,
       0,  2032,     0,     0,     0,     0,     0,   390,     0,     0,
       0,     0,     0,   391,  2029,   392,     0,   934,   393,     0,
       0,   934,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3341,   394,     0,     0,     0,     0,     0,
    2033,     0,     0, -1552,     0,  1638,     0, -3341,  2740,     0,
       0,     0,  2034,     0,     0,     0,     0,  3702,     0,     0,
       0,     0,     0, -1552, -1552, -1552,  3703, -1552, -1552, -1552,
   -1552, -3341,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2745,     0,     0,     0,     0,  2746, -1552, -1552,   395,
       0,     0,  2760,  1672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2043,     0,     0,
       0,     0,   396, -3341,     0,     0,     0,     0,     0,     0,
     934,  2030,  2794,     0,     0,     0,     0,     0,     0,  2804,
    2804,     0,     0,     0,     0,     0,     0,     0,     0,  2814,
       0,  2815,     0,     0,     0,     0,     0,  3704,     0,     0,
       0,  2035,     0,   397,  3705,   898,   898,     0,     0,   398,
    2827,     0,     0, -3341,   399,     0,     0,   400,   401,     0,
       0,     0,     0,  1641,     0, -3341,     0,     0,     0,  3706,
       0, -3341,     0, -3341,     0,     0,   402,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2702,     0,     0,
       0,     0,     0,     0,   403,     0,     0,  3707,     0,   404,
       0,     0,     0,     0,     0,     0,   405,     0,     0,     0,
       0,  1674,   406,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1867,     0,  1868,  1869,     0,     0,     0,     0,
       0,   407,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2031,     0,   408,     0,     0,  2032,
       0,     0,   409,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1552,     0,
     410,     0,     0,   902,   902,     0,     0,     0,  2968,     0,
       0,     0,  2969,     0,   411,     0,     0,     0,  2033,     0,
       0,     0,     0,     0,   412,   413,  3052,     0,     0,     0,
    2034,  2970,     0,   414,     0,     0,   415,     0,   934,   934,
     934,     0,     0,     0,  2971,     0,     0,     0,     0,   357,
     358,   416,     0,     0,   359,  1890,     0,     0,     0,     0,
     360,     0,     0,     0,     0,     0,     0,     0,   361,     0,
       0,     0,     0, -1552,   898,  3708,   898,   362,     0,  3709,
       0,     0,     0,     0, -1552,     0,  1939,     0,     0,     0,
       0,     0,     0,     0,  1673,     0,     0,     0,   418,     0,
     898,     0,     0,  3110,     0,     0,     0,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,   420,     0,     0,
       0,     0,     0,     0,   898,   934,     0,  2702,     0,  2035,
       0,   919,     0,     0,     0,     0,     0,     0,   543,     0,
       0,     0,   421,     0,     0,     0,     0,     0,     0,     0,
     363,   364,     0,     0,     0,     0,   901,   901,     0,     0,
    3710,     0,     0, -1552,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   422,     0,     0,     0,     0,   423,
       0,   365,     0,     0,     0,     0,     0, -1552,     0,     0,
       0,  3179,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   366,   902,   788,   902,   367,     0,     0,     0,     0,
       0,     0,     0,     0,  1941,     0,     0,  3203,     0,     0,
       0,  3711,     0,   368,     0,     0,     0,     0,   902,     0,
       0,     0,     0,     0,     0,  3712,     0,  3217,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   902,     0,     0,     0,     0,  2972,     0,  3713,
       0,  3247,     0,     0,     0,     0,     0,   369,     0,     0,
       0,     0,     0,   370,     0,   371,     0,     0,     0,   372,
       0,     0,     0,   373,     0,     0,     0,     0,     0,  3254,
       0,     0,     0,     0,     0,     0,   898,     0,     0,     0,
     374,  3714,     0,     0,     0,     0, -1536,   358,  1672,     0,
       0,   359,     0,     0,     0,     0,     0,   360,     0,     0,
       0,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,  2973,  2974,     0,   362,     0,  1672,   375,     0,     0,
       0,     0,     0,     0,     0,  1674,     0,     0,     0,     0,
       0,  3715,     0,   376,     0,   901,     0,   901,   377,     0,
       0,     0,     0,  3716,   378,   379,     0,  1940,     0,  3717,
       0,  3718,     0,     0,     0,     0,     0,     0,     0,     0,
     934,   901,     0,     0,     0,     0,     0,     0,   934,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   901,     0,   363,   364,     0,
       0,     0,     0,     0,     0,   380,  2975,     0,     0,     0,
       0,     0,     0,   381,   902,     0,   382,     0,     0,     0,
       0,   383,     0,     0,     0,     0,  1674,     0,   365,     0,
       0,   789,     0,     0,     0,   934,     0,   934,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   384,   366,     0,
       0,     0,   367,     0,  1674,   385,     0,   386,     0,     0,
     387,     0,  2976,   388,     0,     0,     0,     0,     0,     0,
     368,     0,     0,     0,     0,     0,     0,     0,  -377,   389,
       0,     0,     0,     0,     0,     0,     0,  2702,  1673,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   934,     0,   934,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   369,     0,     0,     0,     0,     0,
     370,     0,   371,     0,     0,     0,   372,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2977,     0,   390,     0,   374,     0,     0,
       0,   391,     0,   392,     0,     0,   393,     0,   919,     0,
       0,     0,     0,  3052,     0,     0,     0,   901,     0,     0,
       0,     0,   394,     0,   934,     0,     0,     0,     0,  1673,
       0,     0,     0,   842,   375,  2978,     0,     0,     0,   312,
       0,     0,     0,  2979,     0,     0,     0,     0,     0,     0,
     376,     0,     0,     0,     0,   377,     0,  1673,     0,     0,
       0,   378,   379,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   790,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   934,     0,     0,     0,     0,     0,     0,     0,     0,
     396,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2980,   380,     0,     0,     0,   934,     0,     0,     0,
     381,     0,     0,   382,  3514,     0,  2981,     0,   383,     0,
       0,     0,     0,     0,     0,     0,     0,  1672,     0,     0,
       0,   397,     0,  2982,     0,  3203,     0,   398,     0,     0,
       0,     0,   399,     0,   384,   400,   401,     0,     0,     0,
       0,     0,   385,     0,   386,     0,     0,   387,  2740,     0,
     388,     0,     0,     0,   402,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   389,   843,     0,     0,
       0,   791,   403,   844,   845,     0,     0,   404, -3400,     0,
       0, -3264,     0,     0,   405,     0,     0,  2983,     0,   847,
     406,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2984,     0,     0,     0,     0,     0,     0,     0,   407,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -374,     0,     0,     0,   408,     0,     0,     0,     0,     0,
     409,     0,   390,     0,     0,     0,     0,     0,   391,     0,
     392,     0,     0,   393,     0,  1674,     0,     0,   410,     0,
       0,     0,     0,  1674,     0,     0,     0,     0,     0,   394,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   412,   413,   792,     0,     0,     0,  2985,     0,
       0,   414,     0,     0,   415,     0,     0,     0,     0,     0,
       0,     0,     0,   898,  2986,  2987,     0,     0,     0,   416,
     950,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   919,     0,     0,   395,     0,     0,     0,     0,     0,
       0,   417,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   396,     0,     0,
       0,     0,     0,     0,     0,     0,   418,     0,     0,     0,
       0,     0,     0,     0,     0,   951,     0,     0,     0,   419,
       0,     0,   848,   849,   850,   420,     0,     0,     0,     0,
     934,     0,   934,     0,   851,     0,     0,     0,   397,     0,
       0,     0,     0,     0,   398,     0,     0,     0,     0,   399,
     421,     0,   400,   401,   842,     0,     0,     0,  1673,     0,
     312,   313,     0,     0,     0,     0,  1673,     0,     0,     0,
       0,   402,     0,   952,     0,     0,     0,     0,   934,  3793,
       0,   902,   422,     0,     0,     0,     0,   423,     0,   403,
       0,     0,     0,     0,   404,   424,     0,     0,  3514,     0,
       0,   405,     0,     0,     0,     0,     0,   406,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     852,   853,   854,     0,     0,     0,   407,     0,     0,     0,
     855,     0,   856,     0,     0,     0,     0,     0,   934,   953,
       0,   408,     0,   857,   858,   859,     0,   409,     0,     0,
       0,     0,   860,     0,     0,   315,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   410,     0,     0,   954,     0,
       0,   861,     0,     0,     0,  3850,     0,     0,     0,   411,
       0,  3852,     0,  3853,     0,     0,     0,     0,     0,   412,
     413,     0,     0,     0,     0,   934,     0,     0,   414,  3870,
       0,   415,     0,     0,     0,     0,     0,     0,   843,     0,
       0,     0,     0,     0,   844,   845,   416,  2394,     0,     0,
       0,     0,     0,     0,   846,     0,     0,     0,     0,     0,
     847,     0,     0,     0,   901,     0,     0,   862, -1536,     0,
       0,     0,     0,     0,   955,     0,     0,     0,     0,     0,
       0,     0,     0,  2395,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,     0,   863,     0,     0,     0,     0,
       0,     0,     0,  2396,     0,     0,   419,     0,     0,   898,
       0,     0,   420,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   421,     0,     0,
       0,     0,  2397,     0,     0,     0,     0,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   422,
    -691,     0,     0,     0,   423,     0,     0,     0,     0,     0,
       0,     0, -1536,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   934,   864,   934,     0,     0,     0,     0,     0,     0,
    4002,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2398,     0,   848,   849,   850,     0,   902,     0,  2399,
       0,     0,     0,     0,     0,   851,     0,     0,     0,     0,
       0,     0,     0,  4023,     0,     0,  4026,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   313,     0,     0,   317,     0,     0,     0,   956,
       0,     0,     0,     0,     0,     0,     0,     0,  4035,  4038,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   865,   866,     0,   957,     0,     0,     0,     0,  4070,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   852,   853,   854,     0,     0, -3302, -3302,     0,     0,
       0,   855,     0,   856,     0,     0,     0,     0,     0,   958,
     314,     0,     0,   318,   857,   858,   859,     0,     0,     0,
       0,     0,     0,   860,     0,     0,   315,     0,     0,     0,
       0,   868,     0,     0,     0,     0,  2400,     0,     0,     0,
       0,  4024,   861,     0,     0,     0,     0,     0,     0,     0,
     901,     0, -3302,     0,     0,     0,     0,     0,   869,     0,
       0,     0,     0,     0,     0,     0,   870,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3302,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   871,     0,     0,     0,   959,   529,
     207,     0,     0,     0,     0,  2401,     0,    59,   862,  4035,
       0,     0,  4038,     0,     0,   320,     0,  2402,     0,     0,
    1672,     0,     0,     0,     0,  1172,     0,     0,     0, -3373,
       0,     0,     0,     0,     0,     0,   863,     0,     0,     0,
    -691,  2403,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -691,     0,     0,  -630,     0,     0,     0,     0,
       0,  -691,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   316,     0,
       0,  -630,     0,     0,  -630,  -630,  -630,  -630,  -630,     0,
    -630,  -630,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -630,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4159,     0,  4239,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1672,     0,   864,     0,     0,     0,     0,  1674,     0,
    -630,     0,     0,     0,     0,  2404,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -630,  -630,
       0,  -630,  -630,  -630,  -630,  -630,  -630,  -630,  -630,  -630,
       0,     0,  2405,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2406,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -691,  4291,     0,   317,     0,     0,     0,
       0,     0,     0,  4298,     0,     0,     0,  4303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -630,
       0,     0,   865,   866,     0,     0,     0,  -630,     0,     0,
       0,     0,     0,  2407,  -630,     0,     0,   867,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1674,
    -691,     0,  4298,     0,     0,  4345,  4350,  4158,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   318,     0,     0,  4377,  4388,     0,
       0,  1673,     0,     0,     0,     0,     0,     0,  2408,     0,
       0,  -691,   868,     0,     0,     0,  1672,     0,     0,  4345,
       0,     0,     0,     0,  4350,  2409,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4432,   869,
       0,     0,     0,     0,  -630,  -630,  2410,   870,     0,     0,
       0,     0,     0,  4443,     0,     0,     0,     0,     0,     0,
    1173, -3302,     0,     0,  4456,     0,     0,     0,  4511,  -630,
    -630,  -630,  -630,  -630,     0,   871,  -630,  -630,     0,     0,
       0,   207,     0,     0,  -630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2411,     0,   320,     0,     0,     0,
    -630,     0,     0,     0,     0,     0,  4532,     0,     0,  4534,
    4535,  4536,  4537,  -630,     0,     0,     0,     0,     0,  4543,
       0,     0,  1673,     0,     0,     0,     0,     0,  -691,     0,
    -630,     0,  4555,     0,     0,     0,     0,  -630,     0,     0,
       0,     0,     0,     0,  1674,     0,     0,     0,     0,     0,
    2297, -3373,     0,  -630,     0,  -630,     0,     0,  2412, -3302,
       0,     0,     0,     0,     0,  -630,     0,  4587,     0,     0,
    4588,     0,     0,     0,     0,     0,     0,  -630,     0,     0,
       0,     0,     0,     0,  2413,     0,     0,     0,  -630,  -630,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2414,
    -630,  2415,     0,  2416,     0,     0,  2417,     0,     0,  -630,
    2418,     0,     0,     0,  4603,  4604,  4605,  4606,  4607,  4608,
    4609,  4610,  4611,  4612,  4613,  4614,  4615,  4616,  4617,  4618,
    4619,  4620,  4621,     0,     0,     0,     0,     0,     0,     0,
       0,  -691,     0,     0,  4635,     0,  -630,     0,     0,     0,
       0,     0,     0,  3052,     0,     0,     0,     0,     0,     0,
       0,     0,  3052,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2299,     0,
       0,     0,     0,     0,  4653,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4654,  1673,     0,     0,
       0,     0,  4661,  -630,     0,     0,     0,     0,  4635,  4635,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   919,     0,  -630,     0,     0,     0,     0,  4686,
    4687,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -630,     0,   919,  4635,     0,  -630,     0,     0,     0,     0,
       0,  -630,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -630,  4700,     0,  4694,     0,     0,  -630,  -630,  4661,
       0,     0,     0,     0,     0,     0,  4717,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4729,     0,     0,     0,  4661,  4661,     0,
       0,  -630,     0,  4661,     0,  4775,  4661,     0,     0,     0,
    4661,  4661,     0,     0,     0,     0,     0,     0,  -630,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -630,  -630,  -630,  -630,  -630,     0,  -630,
    -630,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -630,  4806,     0,     0,     0,     0,  -630,     0,     0,  -630,
    4590,     0,     0,   898,   898,     0,     0,     0,     0,     0,
       0,     0,     0,  -630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   898,  -630,     0,  -630,  -630,  -630,     0,
    -630,     0,     0,  -630,  -630,     0,     0,     0,     0,  -630,
    -630,     0,  4870,  4870,     0,     0,     0,  -630,  -630,     0,
    -630,  -630,  -630,  -630,  -630,  -630,  -630,  -630,  -630,     0,
    4877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4880,  4884,  -630,     0,     0,  4870,     0,     0,     0,     0,
       0,     0,  4892,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   842,     0,     0,     0,     0,     0,   312,
       0,     0,     0,     0,     0,     0,  -630,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   902,   902,  -630,     0,     0,     0,     0,     0,  -630,
       0,     0,     0,     0,     0,     0,  -630,  -630,     0,     0,
       0,     0,     0,     0,     0,     0,  -630,  -630,  -630,     0,
       0,   902,   843,     0,     0,     0,     0,     0,   844,   845,
       0,     0,  -630,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   847,     0,     0,  -630,     0,  -630,
       0,  -630,     0,     0,  -630,     0,     0,     0,  -630,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   218,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -630,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1173,
       0,     0,     0,     0,     0,     0,     0,     0,  -630,  -630,
    -630,  -630,  -630,     0,     0,  -630,  -630,   843,     0,     0,
       0,     0,     0,   844,   845,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   847,
       0,     0,     0,     0,   901,   901,     0,     0,     0,     0,
    -630,     0,  -630,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2476,   901,     0,  -630,     0,  -294,     0,
       0,     0,  -294,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4264,     0,     0,     0,
       0,  -294,  -630,     0,  -630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -294,     0,  -630,   848,   849,   850,
       0,     0,     0,     0,     0,     0,     0,  -630,     0,   851,
       0,     0,     0,  -630,     0,     0,     0,  -630,     0,  -630,
       0,     0,  -294,  -630,     0,     0,     0,     0,  -630,     0,
       0, -3400,     0,     0,     0,     0,  -630,  -630,  -630,  -630,
       0,  -630,     0,     0,  -630,  -630,  -630,  -630,  -630,  -630,
       0,  -630,  -630,  -630,     0,     0,     0,     0,     0,     0,
       0,     0,  -630,  -630,     0,  -630,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -630,     0,
       0,     0,     0,  -630,     0,     0,     0,     0,  -294,     0,
       0,     0,   848,   849,   850,   852,   853,   854,     0,     0,
    -630,     0,     0,     0,   851,  -630,  1011,     0,     0,     0,
       0,     0,  -630,  -630,  3665,     0,  -630,     0,   857,   858,
     859,     0,  -630,  -630,     0,     0,     0,   860,     0,     0,
    -630,   313,  -630,  -630,  -630,  -630,  -630,  -630,  -630,  -630,
    -630,     0,     0,  -630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -294,     0,     0,     0,     0,     0,  -630,
       0,  -630,     0,     0,  -630,     0,     0,     0,     0,     0,
    -630,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -630,  -630,     0,     0,     0,     0,     0,  -630,     0,     0,
     852,   853,   854,     0,     0,     0,     0,     0,     0,     0,
     855,     0,   856,     0,     0,  -630,     0,  -294,     0,   314,
       0,     0,   862,   857,   858,   859,     0,     0,     0,     0,
       0,     0,   860,     0,     0,   315,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -630,     0,     0,
       0,   861,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -630,     0,     0,     0,     0,
       0,     0,     0,     0,  -630,     0,     0,     0,  -630,     0,
       0,  -294,  -294,     0,     0, -3400,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   862,     0,     0,
       0,  1173,     0,  -630,     0,  -630,  -630,  -630,     0,     0,
    -630,  -630,  -630,  -630,  -630,  -630,     0,  -630,  -630,     0,
       0,     0,     0,  -630,     0,   863,     0,     0,     0,  -630,
       0,     0,  -630,     0,  -630,     0,     0,   864,     0,     0,
       0,  -630,     0,     0,     0,     0,     0,  -630,     0,     0,
       0,  -630,     0,     0,  -630,     0,  -294,     0,     0,     0,
       0,     0,     0,  -630,     0,  -630,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   316,  -630,     0,
       0,  -294,     0,     0,     0,  -630,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -630,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -630,     0,  -630,     0,
    -630,     0,  -294,     0,     0,  -630,     0,     0,  -630,     0,
       0,     0,  -630,     0,     0,  -630,  -630,  -630,  -294,     0,
    1013,     0,   864,     0,     0,  -630,   865,   866,     0,  -630,
       0,  -630,  -630,  -630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -630,  -630,  -630,
    -630,     0,     0,  -630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   218,     0,     0,     0,     0,  -630,     0,     0,
       0,     0,     0,  -294,     0,     0,     0,     0,  -630,     0,
    2661,     0,  -630,     0,     0,   317,   868,     0,     0,  -630,
       0, -2753,     0,     0,     0,     0,     0, -2753,     0,     0,
       0, -2753, -2753, -2753,     0,     0,     0,     0,     0, -2753,
    2662,   865,   866,   869,     0,  -294,     0,     0,     0,     0,
       0,   870,  -630,  -294,  -630,     0,  -630,     0,     0,     0,
       0,     0, -2753, -2753, -2753, -2753, -2753, -2753, -2753, -2753,
       0,     0,     0,     0,  -630,  -630,     0,     0,     0,   871,
       0,     0,     0,     0,     0,   207,     0,     0,     0,  -294,
       0,  -630,     0,   318,     0,     0,  -630,     0,  -630,  -630,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   868,     0,     0,     0,     0,     0,     0,     0,  -630,
       0,  -294,  -630,     0,     0,     0,     0,     0,  -630,     0,
       0,  -630,  -630,     0,     0,     0,  -294, -2753,   869,     0,
       0,     0,     0,     0,     0,     0,   870,     0,     0,     0,
       0,     0,     0,  -294,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -630,   871, -2753,     0,     0,     0,   529,
     207, -2753, -2753,     0,     0,  -630,     0,  -630,  -630,     0,
       0,     0,     0,     0,     0,   320,     0, -2753,     0,     0,
       0,  -294,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -294,  -294,  -630,     0,     0,     0,  -294,     0,     0,
    -630,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -294,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -630,     0,  -630,  -630,  -630,
    -294,  -630,     0,     0,     0,     0,     0,     0,     0,  -630,
       0,     0,     0,  -630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     842,     0,     0,     0,     0,     0,   312,  -630,     0,     0,
       0,     0,     0,     0,  -294,     0,     0, -2753,  -294,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -630,     0,  -294,  -294, -2753,  -630,     0,     0,
       0,     0,     0,  -630,     0,     0,     0,  -630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -630,     0,     0,     0,  -630,     0,     0,     0,     0,     0,
       0,     0,  -630,     0,     0,     0,     0,  -630,  -630,  -630,
   -2753, -2753, -2753,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2753,  -630,     0,     0,     0,     0,     0,     0,
       0,  -630,     0, -2753, -2753,     0,     0,     0,     0,     0,
    -630,     0,     0,     0,     0,     0,     0,     0,     0, -2753,
       0,     0,     0,     0,     0,     0,  -630,     0,     0,     0,
       0,     0,     0,     0,   218,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -630,
   -2753,     0,     0,     0,   843,     0,     0,     0,     0,     0,
     844,   845,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,   847,     0, -2753, -2753,
   -2753, -2753, -2753,     0,     0,     0,     0,     0, -2753,     0,
   -2753,     0,     0,     0,     0,     0,     0, -2753,     0,     0,
       0, -2753, -2753, -2753,     0,  1016,     0,     0,     0,     0,
   -2753,     0,     0, -2753,     0,     0, -2753,     0,     0,     0,
       0,     0, -2753,     0,     0,     0, -2753, -2753, -2753, -2753,
       0,     0,     0,     0, -2753,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2753,
       0,     0,     0,     0,     0,     0,     0, -2753, -2753, -2753,
   -2753, -2753, -2753, -2753, -2753,  3352,     0,     0,     0,     0,
       0,     0,     0,     0, -2753,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2753,     0,     0,     0,     0,     0,
       0,     0,     0, -2753,     0, -2753,     0,     0,     0,     0,
       0,     0, -2753,     0,     0,     0,     0,     0,     0,     0,
   -2753,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2753,     0,     0,     0,     0,     0,     0,
       0,     0, -2753,     0,  -769,  -769,  -769,  -769,  -769,     0,
    -769,  -769,     0,     0,     0, -2753,     0,     0,     0,   848,
     849,   850,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   851,     0,     0,     0,     0,     0,     0,     0,     0,
   -2753,     0,     0,     0,     0, -2753, -2753, -2753,     0,     0,
       0,     0,     0,     0,  1016,     0,     0,     0,   313,     0,
       0,     0, -2753,     0,     0, -2753,     0,     0,     0,     0,
       0, -2753,     0,     0,     0, -2753, -2753, -2753,     0,     0,
       0,     0,     0, -2753,     0,     0,     0,     0,     0,  -769,
       0,  -769,  -769,  -769,  -769,  -769,  -769,  -769,  -769,  -769,
   -2753,     0,     0,     0,     0,     0, -2753, -2753, -2753, -2753,
   -2753, -2753, -2753, -2753,     0,     0,     0,   852,   853,   854,
       0,     0,     0,     0,     0,     0,     0,   855,     0,   856,
       0,     0,     0,     0,     0,     0,   314,     0,     0,     0,
     857,   858,   859,     0,     0,     0,     0,     0,     0,   860,
       0,     0,   315,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -769,     0,     0,     0,   861,     0,
       0,     0, -2753, -2753,     0,     0,     0,     0,     0,     0,
       0, -2753,     0,     0,     0,     0,     0,     0,     0,     0,
    2735, -2753,     0,     0,     0,     0,     0,     0,     0, -2753,
   -2753,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2753,
       0,     0,     0,     0,     0, -2753, -2753,     0,     0,     0,
       0,     0,     0,     0,   862, -2753, -2753, -2753, -2753,     0,
   -2753, -2753, -2753,     0,  2663,     0, -2753, -2753, -2753, -2753,
   -2753, -2753,     0, -2753, -2753,  2664,     0,     0, -2753, -2753,
       0,     0,   863,     0,     0,     0,     0,     0,     0, -2753,
       0,     0,     0,     0, -2753,     0,     0,     0,     0,  -769,
    -769,  -769,  -769,  -769,     0,     0,  -769,  -769,     0,     0,
       0,     0,     0,     0,     0,     0, -2753,     0,     0,     0,
       0,     0,     0,     0, -2753, -2753,     0,     0,     0,     0,
       0,     0,     0,     0,   316,     0,     0,     0,     0,     0,
       0,     0,     0,  -769,     0,     0,     0,     0,     0,     0,
       0,     0, -2753, -2753, -2753, -2753, -2753, -2753, -2753,     0,
       0,     0,     0, -2753,     0, -2753,     0,  -769,     0,     0,
       0, -2753, -2753, -2753,     0,     0, -2753, -2753, -2753,     0,
       0,     0,     0,     0,     0, -2753,     0,     0, -2753,   864,
   -2753,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2753,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2753,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2753, -2753, -2753,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2753,     0,     0, -2753,
       0,     0,     0,     0,     0,     0,     0, -2753, -2753, -2753,
       0,     0,   317,     0,     0,     0,     0,     0, -2753,     0,
   -2753,     0,     0, -2753,     0,     0,  -769, -2753,     0,     0,
       0,     0,     0,     0,     0, -2753,     0,     0,   865,   866,
       0,     0,     0,     0,     0,     0,     0,     0, -2753,     0,
       0,     0,     0,  1105, -2753,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2753,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3353, -2753, -2753, -2753, -2753, -2753,     0,     0,     0,
     318,     0, -2753,     0, -2753,     0,     0,     0,     0,     0,
   -2753, -2753,     0,     0,  -769, -2753, -2753, -2753,   868,  3331,
       0,     0,     0,     0, -2753,     0,     0, -2753,     0,     0,
   -2782,     0,     0,     0,     0,  -769, -2782,     0,     0,     0,
   -2782, -2782, -2782, -2753,     0,   869,     0,     0, -2782,     0,
       0,     0,     0,   870,     0,     0,     0,     0,  -769,     0,
       0,     0,     0, -2753,     0, -2753,     0,     0,     0,     0,
       0, -2782, -2782, -2782, -2782, -2782, -2782, -2782, -2782,     0,
       0,   871,     0,     0,     0,     0,     0,   207, -2753,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2753,     0,
       0,     0,   320,     0,     0,     0,     0, -2753,     0, -2753,
       0,     0,     0,     0,     0,     0, -2753,     0,     0,     0,
       0,     0,     0,     0, -2753,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2753, -2753,     0,
       0,     0,     0,     0,     0,     0, -2782,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2753,
       0,     0,     0,     0, -2753, -2753,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2782,     0,  -769,  -769,  -769, -2753,
   -2782, -2782,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2753,     0, -2753, -2782, -2753,     0,     0,
       0, -2753,     0, -2753, -2753, -2753, -2753,     0, -2753, -2753,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2753,  3331,     0,     0,     0,     0,
       0,     0,     0,     0, -2753,     0, -2782,     0,     0,     0,
       0,     0, -2782,     0,     0,     0, -2782, -2782, -2782,     0,
       0, -2753,     0,     0, -2782,     0,     0,     0,     0, -2753,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2782, -2782, -2782,
   -2782, -2782, -2782, -2782, -2782,     0,     0, -2753,     0,     0,
       0,     0,     0, -2753,     0,     0,  -769,  -769,  -769,     0,
       0,     0,     0,     0,     0,     0, -2782, -2753, -2753,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1251,     0,     0, -2782,     0,     0,     0,     0,
       0,     0,     0, -2753, -2753,     0,     0,     0,     0,     0,
   -3400, -3400, -3400, -3400,     0,     0,     0,     0, -3400,     0,
       0,     0, -2782,  3354,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3400, -3400,     0, -2782,
   -2782, -2782, -2753,     0, -2753,     0, -2753,     0,     0,     0,
   -2753, -2782, -2753, -2753, -2753, -2753,     0, -2753, -2753,     0,
   -2782,     0, -2782, -2782,     0,     0, -2782, -2782,     0,     0,
       0,     0,     0, -2753,     0,     0,     0,     0, -2782,     0,
       0,     0, -2782,     0,     0,     0, -3250, -3400,     0,     0,
   -3250,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2753,     0,     0,     0,     0,     0,     0,     0, -2753,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3400,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2753, -2782, -2782, -2782,
   -2782, -2782, -2753,     0,     0,     0,     0, -2782,     0, -2782,
       0,     0,     0,     0,     0,     0, -2782, -2753,     0,     0,
   -2782, -2782, -2782,     0,     0,     0,     0,     0,     0, -2782,
       0,     0, -2782,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2782,     0,
       0,     0, -2782,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2782,     0,
       0, -2782,     0,     0,     0,     0,   843,     0,     0,     0,
       0,     0,   844,   845,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2782,     0,     0,     0,     0,   847,     0,
       0,     0,     0, -2782,     0,     0,     0,     0, -3400,     0,
       0,     0, -2782,     0, -2782, -2782, -2782, -2782,     0,     0,
       0, -2782,     0,     0,     0,     0,     0, -2782,     0, -2782,
       0,     0,  3677,     0,     0,     0,     0,     0, -2782, -2782,
       0,     0, -2782,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2782,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2782,     0,     0, -3400,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2782,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3400,     0,     0,
       0,     0,     0, -2782, -2782, -2782, -2782, -2782,     0,     0,
       0,     0,     0, -2782,     0, -2782,     0,     0,     0,     0,
       0,     0, -2782,     0,     0,     0, -2782, -2782, -2782,     0,
       0,     0,     0,     0,     0, -2782,     0,     0, -2782, -2782,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2782,     0,     0,     0,     0,     0,
       0,   848,   849,   850,     0,     0,     0,     0,     0, -3250,
       0,     0,     0,   851, -2782,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3400,     0,     0,     0,     0,     0,     0,     0, -2782,
     313,     0,     0,     0,     0,     0,     0,     0,     0, -2782,
    1254,     0, -2782,     0,     0,     0,     0,     0, -2782,     0,
   -2782,     0,     0,     0,     0,     0,     0, -2782,     0,     0,
       0,     0,     0,     0,     0, -2782,     0, -3400, -2782, -2782,
       0,     0,     0,     0,     0,     0,     0,     0, -2782,     0,
       0,     0,     0,   842,     0,     0,     0,     0,     0,   312,
       0,   854,     0,     0,     0,     0,     0,     0,     0,     0,
   -2782,     0,     0,     0,     0,     0,     0, -2782,   314, -2782,
       0, -2782,   857,   858,   859, -2782,     0, -2782, -2782, -2782,
   -2782,   860, -2782, -2782,   315,     0,     0,     0, -3400,     0,
   -2782,     0,     0,     0,     0,     0,     0,     0, -2782,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3250, -3250,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2782,     0,     0,     0,     0,
       0,     0,     0, -2782,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2782,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2782,     0,     0,     0,     0,   862, -2782,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2782,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   843,     0, -3400,
       0, -3400, -3400,   844,   845,     0,     0,     0,     0,     0,
       0,     0,     0,  1040,     0,     0,     0,     0, -2782,   847,
       0, -3400,     0,     0,     0,     0, -3400,     0, -3104,     0,
       0,     0,     0,     0,  1441,     0,     0,     0, -3104,     0,
       0,     0,  1442,     0, -2782, -2782,   316,     0,     0,     0,
       0,     0,     0,     0, -3104,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3400,     0,     0,     0,     0,
       0,     0,     0,     0,  1443, -3104,     0, -3400,     0,     0,
       0,     0,     0, -2782,     0, -2782,     0, -2782,     0,     0,
       0, -2782,     0, -2782, -2782, -2782, -2782,     0, -2782, -2782,
       0,   864,     0, -3104,  1444,  1445,  1446,  1447,  1448,  1449,
    1450,  1451,     0,     0, -2782,     0, -3104, -3104, -3104,     0,
    1452, -3104,     0,     0,     0,  1453,     0,     0, -3104,     0,
       0,     0,     0,     0,     0,     0,  1454,  1455,  1456,  1457,
   -3104, -2782, -3104, -3104,     0,     0,     0,     0,     0, -2782,
       0,     0,     0,     0,  1458,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1459,     0,     0,  1460,  1461,  1462,
   -3104,  1463,     0,     0,   317,     0, -3400, -2782,     0,     0,
       0,     0,     0, -2782,     0,     0,     0,     0,     0,     0,
    2010,     0,   848,   849,   850,     0,     0,     0, -2782,     0,
     865,   866,     0,     0,   851,  1464,     0,     0,     0,     0,
       0,     0,     0,     0,  1465,  1466,  1467,  1468,  1469,  1470,
    1471,  1472,     0,     0,     0, -3104,     0,  1473,  1474,     0,
       0,   313,     0,     0,     0,     0,     0,   529,     0,     0,
       0, -3104,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,  1475,  1476,     0,     0,
    1477,  1478,     0, -3104, -3104,  1479, -3104, -3104,     0,     0,
     868,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1480,     0,     0,
     852,   853,   854,     0,     0,     0,     0,   869,     0,     0,
     855,     0,   856,     0,     0,   870,     0,     0,     0,   314,
       0, -3104,  1481,   857,   858,   859,  1482,     0,     0,     0,
       0,     0,   860,     0,     0,   315,     0, -3104,     0,     0,
       0,  1483,     0,   871,     0,     0,     0,  1484,  1485,   207,
       0,   861,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   320,     0,  1486,  1487,  1488,  1489,
    1490,     0,     0,  1491,     0,     0,     0, -3104, -3104, -3104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3104,     0,     0,     0,     0, -3104,     0,     0,     0,     0,
       0,     0,     0,  1492,  1493,  1494,  1495,   862,     0,     0,
       0,     0,  1496,  1497,     0,  1498,     0,  1499,  1500,  1501,
   -3104, -3104,  1502,     0,  1503,     0, -3104, -3104,  1504,     0,
       0,     0,     0,     0,     0,   863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1505,  1506,     0,
       0,     0,     0,     0,     0,     0,     0,  1507,  1508,  1509,
    1510,  1511,  1512,     0,     0,     0,     0,     0,     0,     0,
       0,  1513,     0,     0,     0,  1514,     0,     0,     0,  1516,
       0, -3104,     0, -3104,     0,     0,     0,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3104, -3104, -3104,     0,     0,  1517,     0,
       0,     0,  1518,     0,  1519,  1520,  1521,  1522,     0,     0,
       0,     0,     0,     0,  1523,     0,     0,     0,     0,     0,
   -3104,     0,   864,     0,     0,     0,     0,     0,     0,     0,
       0,  1524,     0,     0,     0,     0,     0,     0,     0,  1525,
       0,     0,     0,     0, -3104, -3104, -3104,     0, -3104,     0,
   -3104, -3104,     0, -3104, -3104, -3104,     0,     0,     0,     0,
    1607, -3104,     0, -3104, -3104, -3104, -3104,     0,     0,     0,
       0,     0,     0,     0,     0,  1526,  1527,     0,     0, -3104,
       0,     0,     0,     0,     0,     0,     0, -3104,     0,     0,
       0,     0,     0,     0,     0,   317,     0,     0,     0,     0,
       0,     0, -3104, -3104,     0,     0,     0,     0,     0,     0,
    1528, -3104,     0,  1529,     0,     0,     0, -3104,     0,     0,
       0,   865,   866,     0,  1530,     0,     0,     0,     0,     0,
    1531,     0,     0,     0,  1532,     0,  1533,  1534,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1535,     0,     0,  1536,  1537,     0,     0,     0,     0,  1538,
       0,     0,     0,     0, -3104,     0,     0,     0,     0,     0,
   -3104,     0,     0,   318,     0,  1539,     0,  1540,  1541,     0,
       0,     0,     0,     0,     0,     0,  1542,  1543,     0,   358,
       0,   868,     0,   359,     0,     0,     0,     0,     0,   360,
       0,     0,     0,     0,     0,     0,     0,   361,     0,  1544,
    1545,  1546,     0,     0,     0,     0,   362,     0,   869,     0,
       0,     0,     0, -3104, -3104, -3104,   870,     0,     0,  1547,
    1548,  1549,  1550, -3104,  1551,     0,     0,     0,  1552,  1553,
       0,     0,     0,     0,     0,     0,  1554,  1555,     0,     0,
       0,     0,     0,     0,   871,  1556,  1557,  1558, -3104,     0,
     207,     0,     0,  1559,     0,     0,     0,     0,  1560,     0,
       0, -3104, -3104, -3104, -3104,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1561,     0,     0,   363,
     364, -3104, -3104,     0,     0,     0,     0,     0,     0,  1562,
    1563,     0, -3104,     0,     0,  1564,     0,     0,     0,     0,
       0,  1608,     0,     0,     0,     0,     0,     0,     0,     0,
     365,     0,     0,     0,     0,     0,     0,     0,  1565,  1566,
       0,     0, -3104,     0,     0,     0,     0,  1567,     0,     0,
     366,     0,     0,     0,   367,  1568, -3104, -3104,     0,     0,
       0,  1569,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   368,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   584,     0,
       0,  1570,     0, -3104,   585,     0,     0,  1571,     0,     0,
       0,     0,   586, -3104,     0,     0,     0,     0,     0,     0,
   -3104,   587,     0,     0,     0,     0,   369,     0,     0,     0,
       0, -3104,   370,     0,   371, -3104, -3104, -3104,   372,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,  1572,     0,     0,     0,     0, -3104, -3104,  1573,   374,
    1574, -3104, -3104,  1575, -3104,     0,     0,     0,     0,     0,
    1576, -3104,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1577,     0,     0,     0,  1578,     0,     0,     0,
       0,     0,     0,     0,   588,   589,   375,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   376,     0,     0,     0,     0,   377,     0,     0,
       0,     0,     0,   378,   379,   590,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   591,     0,     0,     0,   592,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   593,     0,     0,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   842,     0,
     383,     0,     0,     0,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   594,     0,     0,     0,     0,   384,     0,     0,     0,
       0,     0,     0,   595,   385,     0,   386,   596,     0,   387,
       0,     0,   388,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   597,     0,   389,     0,
       0,   598,   599,   600,   601,     0,   602,   603,   604,   605,
       0,   606,     0,   607,   608,   609,     0,   610,   611,   612,
     613,   614,     0,   615,   616,   617,   618,   619,   620,     0,
       0,   621,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   622,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   623,   624,
       0,     0,     0,     0,   390,     0,     0,     0,     0,     0,
     391,     0,   392,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   394,   843,     0,     0,     0,     0,     0,   844,   845,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   625,
       0,     0,     0,     0,   847,     0,     0,   626,     0,     0,
     627,     0,     0,     0,     0,   628,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,     0,     0,
       0,   629,     0,     0,     0,     0,     0,     0,     0,   630,
       0,   631,     0,     0,   632,     0,     0,   633,     0,   396,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     397,     0,     0,     0,     0,     0,   398,     0,     0,     0,
       0,   399,     0,     0,   400,   401,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   402,     0,     0,     0,     0,     0,   634,
       0,     0,     0,     0,     0,   635,     0,   636,     0,     0,
     637,   403,     0,     0,     0,     0,   404,     0,     0,     0,
       0,     0,     0,   405,     0,     0,   638,     0,     0,   406,
       0,     0,     0,     0,     0,     0,     0,   848,   849,   850,
       0,     0,     0,     0,     0,     0,     0,     0,   407,   851,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,   409,
       0,     0,     0,     0,     0,     0,   313,     0,     0,     0,
       0,   639,     0,     0,     0,     0,     0,   410,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   411,     0,     0,   640,     0,     0,     0,     0,     0,
       0,   412,   413,     0,     0,     0,     0,     0,     0,     0,
     414,     0,     0,   415,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   852,   853,   854,   416,     0,
       0,     0,     0,     0,     0,   855,     0,   856,     0,     0,
       0,     0,     0,     0,   314,     0,   641,     0,   857,   858,
     859,     0,     0,     0,     0,     0,     0,   860,     0,     0,
     315,     0,     0,     0,     0,     0,     0,     0,   642,     0,
       0,     0,     0,     0,     0,   418,   861,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,     0,
       0,   643,     0,     0,   420,     0,     0,     0,   644,     0,
       0,     0,     0,     0,   645,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   842,     0,     0,     0,     0,   421,
     312,     0,     0,   646,     0,     0,     0,     0,     0,  1441,
       0,     0,     0,     0,     0,     0,     0,  1442,     0,     0,
       0,     0,   862,     0,   647,     0,     0,     0,     0,  3861,
       0,   422,     0,     0,     0,     0,   423,     0,     0,     0,
       0,     0,   648,     0,     0,     0,     0,     0,     0,  1443,
     863,     0,     0,     0,     0,     0,   649,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   650,   651,     0,     0,
       0,     0,     0,     0,     0,   652,     0,     0,   653,  1444,
    1445,  1446,  1447,  1448,  1449,  1450,  1451,     0,     0,     0,
       0,     0,     0,   654,     0,  1452,     0,     0,     0,     0,
    1453,     0,   316,     0,     0,     0,     0,     0,     0,     0,
       0,  1454,  1455,  1456,  1457,   655,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1458,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1459,
     656,     0,  1460,  1461,  1462,     0,  1463,     0,   843,     0,
       0,     0,     0,   657,   844,   845,     0,   864,     0,   658,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     847,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1464,     0,     0,     0,     0,     0,     0,     0,     0,  1465,
    1466,  1467,  1468,  1469,  1470,  1471,  1472,     0,     0,     0,
       0,     0,  1473,  1474,     0,  2898,  2899,  2900,  2901,  2902,
       0,  2903,  2904,     0,     0,     0,   659,     0,     0,     0,
       0,   660,  3456,     0,     0,     0,     0,     0,     0,     0,
     317,  1475,  1476,     0,     0,  1477,  1478,     0,     0,     0,
    1479,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   865,   866,     0,     0,
       0,     0,  1480,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1481,     0,     0,
    2905,  1482,  2906,  2907,  2271,  2908,  2909,  2910,  2911,  2912,
    2913,     0,     0,     0,     0,     0,  1483,     0,   318,     0,
       0,     0,  1484,  1485,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   868,     0,     0,     0,
       0,  1486,  1487,  1488,  1489,  1490,     0,  3457,  1491,     0,
       0,     0,     0,   848,   849,   850,     0,     0,     0,     0,
       0,     0,     0,   869,     0,   851,     0,     0,     0,     0,
       0,   870,     0,     0,     0,  2914,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1492,  1493,
    1494,  1495,   313,     0,     0,     0,     0,  1496,  1497,   871,
    1498,     0,  1499,  1500,  1501,   207,     0,  1502,     0,  1503,
       0,     0,     0,  1504,     0,     0,     0,     0,     0,     0,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1505,  1506,     0,     0,     0,     0,     0,     0,
       0,     0,  1507,  1508,  1509,  1510,  1511,  1512,     0,     0,
       0,   852,   853,   854,     0,     0,  1513,     0,     0,     0,
    1514,   855,     0,   856,  1516,     0,     0,     0,     0,     0,
     314,     0,     0,     0,   857,   858,   859,     0,     0,     0,
       0,     0,     0,   860,     0,     0,   315,     0,     0,     0,
    2915,  2916,  2917,  2918,  2919,     0,     0,  2279,  2920,     0,
       0,     0,   861,  1517,     0,     0,     0,  1518,     0,  1519,
    1520,  1521,  1522,     0,     0,     0,     0,     0,     0,  1523,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2921,     0,  1524,     0,     0,     0,
       0,     0,     0,     0,  1525,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2922,     0,
       0,     0,     0,     0,     0,  1607,     0,     0,   862,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1526,  1527,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   863,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1528,     0,     0,  1529,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1530,
       0,     0,     0,     0,     0,  1531,     0,     0,     0,  1532,
       0,  1533,  1534,     0,     0,     0,     0,     0,   316,     0,
       0,     0,     0,     0,     0,  1535,     0,     0,  1536,  1537,
       0,     0,     0,     0,  1538,     0,     0,  2923,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1539,     0,  1540,  1541,     0,     0,     0,     0,     0,     0,
       0,  1542,  1543,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   864,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1544,  1545,  1546,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1547,  1548,  1549,  1550,     0,  1551,
       0,     0,     0,  1552,  1553,  2924,     0,     0,     0,     0,
       0,  1554,  1555,     0,     0,     0,     0,     0,     0,     0,
    1556,  1557,  1558,     0,     0,     0,  2925,     0,  1559,     0,
       0,     0,     0,  1560,     0,     0,   317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2926,
       0,  1561,  1441,     0,     0,     0,     0,     0,     0,     0,
    1442,     0,   865,   866,  1562,  1563,     0,     0,     0,     0,
    1564,     0,     0,     0,     0,     0,  1608,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1443,  1565,  1566,     0,     0,     0,     0,  1287,
       0,     0,  1567,     0,     0,     0,     0,     0,     0,     0,
    1568,     0,     0,     0,   318,     0,  1569,     0,     0,     0,
       0,     0,  1444,  1445,  1446,  1447,  1448,  1449,  1450,  1451,
       0,     0,   868,     0,     0,     0,     0,     0,  1452,     0,
       0,     0,     0,  1453,     0,     0,  1570,     0,     0,     0,
       0,     0,  1571,     0,  1454,  1455,  1456,  1457,     0,   869,
       0,     0,     0,     0,     0,     0,     0,   870,     0,     0,
       0,     0,  1458,     0,     0,     0,     0,  2927,  2928,  2929,
       0,     0,  1459,     0,     0,  1460,  1461,  1462,     0,  1463,
       0,     0,     0,     0,     0,   871,  1572,     0,     0,     0,
       0,   207,     0,  1573,     0,  1574,     0,     0,  1575,     0,
       0,     0,     0,     0,     0,  1576,   320,     0,     0,     0,
       0,     0,     0,  1464,     0,     0,     0,  1577,     0,     0,
       0,  1578,  1465,  1466,  1467,  1468,  1469,  1470,  1471,  1472,
       0,     0,     0,     0,     0,  1473,  1474,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1475,  1476,     0,     0,  1477,  1478,
       0,     0,     0,  1479,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2930,  2931,  2932,
       0,     0,     0,     0,     0,  1480,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1481,     0,     0,     0,  1482,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1483,
       0,     0,     0,     0,     0,  1484,  1485,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1486,  1487,  1488,  1489,  1490,     0,
       0,  1491,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1492,  1493,  1494,  1495,     0,     0,     0,     0,     0,
    1496,  1497,     0,  1498,     0,  1499,  1500,  1501,     0,     0,
    1502,     0,  1503,     0,     0,     0,  1504,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1505,  1506,     0,     0,     0,
       0,     0,     0,     0,     0,  1507,  1508,  1509,  1510,  1511,
    1512,     0,     0,     0,     0,     0,     0,     0,     0,  1513,
       0,     0,     0,  1514,  1515,     0,     0,  1516,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1517,     0,     0,     0,
    1518,     0,  1519,  1520,  1521,  1522,     0,     0,     0,     0,
       0,     0,  1523,     0,     0,     0,     0,     0,     0,     0,
     842,     0,     0,     0,     0,     0,   312,     0,     0,  1524,
   -3302, -3302, -3302,     0,     0,     0,     0,  1525,  1398,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1399,  1400,  1401,  1402,  1403,  1404,  1405,  1406,     0,
       0,     0,     0,  1526,  1527,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1528,     0,
       0,  1529,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1530,     0,     0,     0,     0,     0,  1531,     0,
       0,     0,  1532,     0,  1533,  1534, -3302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1535,     0,
       0,  1536,  1537,     0,     0,     0,     0,  1538,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1539,   843,  1540,  1541,     0,     0,     0,
     844,   845,     0,     0,  1542,  1543,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   847,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1544,  1545,  1546,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1547,  1548,  1549,
    1550,     0,  1551,     0,     0,     0,  1552,  1553,     0,     0,
       0,     0,     0,     0,  1554,  1555,     0,     0,     0,     0,
       0,     0,     0,  1556,  1557,  1558,     0,     0,     0,     0,
       0,  1559,     0,     0,     0,     0,  1560,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1561,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1562,  1563,     0,
       0,     0,     0,  1564,     0,     0, -3302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1407,  1565,  1566,     0,     0,
       0,     0,     0,     0,     0,  1567,     0,     0,     0,     0,
       0,     0,     0,  1568,     0,     0,     0,     0,     0,  1569,
       0,     0,     0,     0,     0,     0,   842,     0,     0,     0,
       0,     0,   312,     0,     0,     0,  2067,  2068,  2069,   848,
     849,   850,     0,     0,  3643,     0,     0,     0,     0,  1570,
       0,   851,     0,     0,     0,  1571,     0,     0,     0,     0,
       0,     0, -3302, -3302,     0,     0,     0,  3644,  3645,  3646,
    3647,  3648,  3649,  3650,  3651,     0,     0,     0,   313,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1572,
       0,     0,     0,     0,     0,     0,  1573,     0,  1574,  1408,
       0,  1575,     0,     0,     0,     0,     0,     0,  1576,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1577,     0,     0,     0,  1578,     0,     0,   852,   853,   854,
   -3302, -3302,  2070,     0,     0,     0,     0,   855,     0,   856,
       0,     0,     0,   842,     0,     0,   314,     0,     0,   312,
     857,   858,   859,     0,     0,     0,     0,     0,     0,   860,
       0,  1398,   315,     0,     0,     0,     0,     0,     0,     0,
     843,     0,     0,     0,     0,     0,   844,   845,   861,     0,
       0,     0,     0,     0,  1399,  1400,  1401,  1402,  1403,  1404,
    1405,  1406,   847,     0,     0,     0,     0,     0, -3302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1409,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3302,     0,     0,     0,     0,     0,     0,
       0,     0, -3302,     0,   862,     0,     0,     0,     0,     0,
       0, -3302,     0,     0,     0,     0,     0,     0,     0,  1410,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   863,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   842,     0,     0,     0,     0,
       0,   312,     0,     0, -3302,     0,     0,   843,     0,     0,
       0,     0,  2071,   844,   845,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1895,     0,     0,   847,
       0,  3652,     0,     0,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1895, -1895, -1895, -1895,     0,     0,
       0,     0, -1895,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1895, -1895,     0,     0,     0,   848,   849,   850,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   851,     0,   864,
       0,     0,     0,     0,     0,     0,     0,     0,  2072,  2073,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,     0,     0,     0,     0,     0,
   -1895, -1895,     0,     0, -1895,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   843,
       0,     0,     0,     0,     0,   844,   845,     0,  1407,     0,
   -1895,     0,   317,     0,     0,     0,     0,     0,     0,     0,
       0,   847,     0,   852,   853,   854,  2074,  2075,     0,     0,
       0,     0,     0,   855,     0,   856,     0,     0,   865,   866,
       0,     0,   314,     0,     0,     0,   857,   858,   859,     0,
       0,     0,   848,   849,   850,   860,     0,     0,   315,     0,
       0,     0,     0,     0,   851,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   861,     0,     0,  1411,     0,  1412,
       0, -3302,     0,     0,     0, -3302,     0, -3302,  1413,  1414,
     318,   313,  1415,  1416,  2076,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   868,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1409,
       0,     0,  1408,     0,     0,     0,     0,     0,     0,  2077,
       0,     0, -1895,     0,     0,   869,     0,     0,  2078,     0,
     862,     0,     0,   870,     0,     0,     0,  2079,     0,     0,
     852,   853,   854,     0,     0,  3653,     0,     0,     0,     0,
     855,     0,   856,     0,     0,     0,     0,     0,   863,   314,
       0,   871,     0,   857,   858,   859,     0,   207,     0,     0,
   -1794,     0,   860,     0,     0,   315, -1794,     0,     0,     0,
    2080, -1895,   320,     0,   848,   849,   850,     0,     0,     0,
       0,   861,     0,     0,     0,     0,   851,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     316,     0,     0,     0,     0,     0,     0,     0,  2312,     0,
       0, -1895,     0,   313,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1409,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2341,     0,   862,     0,     0,
       0,     0,     0,     0,     0,   864,     0,     0,     0,     0,
       0,     0,  1410,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   852,   853,   854,   863,     0,     0,     0,     0,
       0,     0,   855, -1895,   856,     0,     0,     0,     0,     0,
       0,   314,     0,     0,     0,   857,   858,   859,     0,     0,
       0,     0,     0,     0,   860, -1895,     0,   315,     0,     0,
       0,     0,     0,     0, -1794,     0,     0,     0,     0, -3258,
   -1794, -1794,     0,   861, -1895,     0,     0,   316,   317,     0,
       0,     0,     0,     0,     0,     0, -1794,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1895,     0,     0,   865,   866,     0,     0,   842,     0,
       0,     0,   843,     0,   312,     0,     0,     0,   844,   845,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   864,     0,   847,     0,     0,     0,     0,   862,
       0,     0,     0,  3654,     0,  3655,     0,  2081,     0,     0,
       0,  2082,     0,  2083,  3656,  3657,   318,     0,  3658,  3659,
       0,     0, -1895,     0,     0,     0,     0,   863,     0,     0,
       0,     0,     0,     0,   868,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1895, -1895,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   869,     0,     0,     0,   317,     0,     0,     0,   870,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   865,   866,     0,  2313,     0,     0,   871,     0,     0,
       0,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   320, -1794,
   -1794, -1794,   843,     0,     0,     0,     0,     0,   844,   845,
    1411, -1794,  1412, -1895,   864, -1895, -1895,     0,     0,     0,
       0,  1413,  1414,   318,   847,  1415,  1416,     0,     0,     0,
       0,     0,     0,     0,     0, -1895,     0,     0, -1794,     0,
   -1895,   868,     0,     0,     0,     0,     0,   848,   849,   850,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   851,
       0,     0,     0,     0,     0,     0,     0,     0,   869,     0,
       0,     0,     0,     0,     0,     0,   870,     0,     0, -1895,
       0,     0,     0,     0,     0,     0,   313,   317,     0,     0,
       0, -1895,     0,     0,     0,     0,     0, -1794, -1794, -1794,
       0,     0,     0,     0,   871,     0,     0, -1794,     0, -1794,
     207,     0,     0,   865,   866,     0, -1794,     0,     0,     0,
   -1794, -1794, -1794,     0,     0,   320,     0,     0,     0, -1794,
       0,     0, -1794,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   852,   853,   854, -1794,     0,
       0,     0,     0,     0,     0,   855,     0,   856,     0,     0,
       0,     0,     0,     0,   314,   318,     0,     0,   857,   858,
     859,     0,     0,     0,     0,     0,     0,   860,     0,     0,
     315,     0,     0,   868,     0,     0,     0,     0,     0,     0,
   -1895,     0,     0,     0,     0,     0,   861,   848,   849,   850,
       0,     0,     0,     0, -1895,     0,   842,     0,     0,   851,
     869,     0,   312,     0, -1794,     0,     0,     0,   870,     0,
       0, -1794,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   842,   313,     0,     0,     0,
       0,   312, -1794,     0,     0,     0,   871,     0,     0,     0,
       0, -1895,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   862,     0,     0,     0,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   842,     0,     0,     0,     0,     0,   312,     0,
     863,     0,     0,     0, -1794,   852,   853,   854,     0,     0,
       0,     0,     0,     0,     0,   855,     0,   856,     0,     0,
       0,     0,     0,     0,   314,     0,     0, -3258,   857,   858,
     859,     0,     0,     0,     0,     0,     0,   860,     0,     0,
     315,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   316,     0,     0,     0,   861,     0,     0, -1794,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     843,     0,     0,     0,     0,     0,   844,   845,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   847,     0,     0,     0,     0,     0,     0,   843,
       0,     0,     0,     0,     0,   844,   845,   864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   847,   862,     0, -1794,     0,     0,     0,     0,   955,
       0,     0, -1794,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   843,     0,     0,     0,
     863,     0,   844,   845,     0,   842,     0,     0, -1794, -1794,
       0,   312,     0,     0,     0,     0,     0,     0,   847,     0,
       0,     0,  2314,     0,     0,     0,     0,     0,     0,     0,
     317,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   316,     0,     0,     0,   865,   866,     0,     0,
   -1794,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1794,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2315,     0,     0,     0, -1794,     0,   864,   318,     0,
       0,     0,  2316, -1794,     0,   848,   849,   850,     0,     0,
       0,  1704,     0, -3258,     0,     0,   868,   851,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1794,     0,     0,   848,   849,   850, -1794,     0,     0,
       0,     0,     0,   869,   313,     0,   851,     0,     0,   843,
       0,   870, -1794,     0,     0,   844,   845,     0,     0,     0,
       0,     0,   842,     0,     0,     0,     0,     0,   312,     0,
     317,   847,     0,   313,     0,     0,     0,     0,     0,   871,
       0,   848,   849,   850,     0,   207,     0,     0,     0,     0,
       0,     0,     0,   851,     0,     0,   865,   866,     0,     0,
     320,     0,     0,   852,   853,   854,     0,     0,     0,     0,
       0,     0,     0,   855,     0,   856,     0,     0,     0,     0,
     313,     0,   314,     0,     0,     0,   857,   858,   859,     0,
       0,     0,   852,   853,   854,   860,     0,     0,   315,     0,
       0,     0,   855,     0,   856,     0,     0,     0,   318,     0,
       0,   314,     0,     0,   861,   857,   858,   859,     0,     0,
       0,     0,     0,     0,   860,     0,   868,   315,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   852,
     853,   854,     0,   861,     0,     0,     0,     0,     0,   855,
       0,   856,     0,   869,     0,     0,     0,     0,   314,     0,
       0,   870,   857,   858,   859,     0,     0,     0,     0,     0,
       0,   860,     0,     0,   315,     0,   843,     0,     0,     0,
     862,     0,   844,   845,     0,     0,     0,     0,     0,   871,
     861,     0,     0,     0,     0,   207,     0,     0,   847,     0,
       0,   842,     0,     0,   848,   849,   850,   312,   863,   862,
     320,     0,     0,     0,     0,     0,   851,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   863,     0,     0,
       0,     0,     0,   313,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   862,     0,     0,     0,
     316,     0,     0,     0,     0,     0,     0,     0,     0,  1948,
       0,     0,     0,     0,     0,   312,     0,     0,     0,     0,
       0,     0,     0,     0,   863,     0,     0,     0,     0,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   852,   853,   854,     0,     0,     0,     0,     0,
       0,     0,   855,     0,   856,   864,     0,     0,     0,     0,
       0,   314,     0,     0,     0,   857,   858,   859,     0,     0,
       0,     0,     0,     0,   860,     0,   316,   315,     0,     0,
       0,     0,     0,     0,   864,     0,     0,     0,     0,     0,
       0,     0,     0,   861,     0,   843,     0,     0,     0,     0,
       0,   844,   845,     0,     0,     0,     0,     0,     0,     0,
       0,   848,   849,   850,     0,     0,     0,   847,     0,     0,
       0,     0,     0,   851,     0,     0,     0,     0,   317,     0,
       0,   864,     0,     0,     0,  3325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     313,     0,     0,     0,   865,   866,     0,   317,     0,   862,
       0,     0,     0,   843,     0,     0,     0,     0,     0,   844,
     845,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   865,   866,   847,   312,   863,     0,     0,
       0,     0,     0,     0,     0,     0,  3266,     0,     0,     0,
       0,     0,     0,     0,   317,     0,   318,     0,     0,   852,
     853,   854,     0,     0,     0,     0,     0,     0,     0,   855,
       0,   856,     0,     0,   868,     0,     0,     0,   314,     0,
     865,   866,   857,   858,   859,   318,     0,  2723,     0,   316,
       0,   860,     0,     0,   315,     0,     0,     0,     0,     0,
       0,   869,     0,   868,     0,     0,     0,     0,     0,   870,
     861,     0,   312,     0,     0,     0,  1628,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     869,     0,   318,     0,     0,     0,     0,   871,   870,     0,
     848,   849,   850,   207,   864,     0,     0,     0,     0,     0,
     868,     0,   851,     0,     0,     0,     0,     0,   320,     0,
       0,     0,     0,     0,     0,     0,   871,     0,     0,     0,
       0,     0,   207,     0,     0,     0,   862,   869,     0,   313,
       0,     0,     0,     0,   843,   870,     0,   320,     0,     0,
     844,   845,  1628,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   863,     0,   847,     0,   848,   849,
     850,     0,     0,   871,     0,     0,     0,   317,     0,   207,
     851,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   320,     0,     0,     0,   852,   853,
     854,     0,     0,   865,   866,     0,     0,   313,   855,     0,
     856,     0,     0,     0,     0,     0,   316,   314,     0,     0,
     843,   857,   858,   859,     0,     0,   844,   845,     0,     0,
     860,     0,     0,   315,     0,     0,     0,     0,     0,     0,
       0,     0,   847,     0,     0,     0,     0,     0,     0,   861,
       0,     0,     0,     0,     0,   318,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   852,   853,   854,     0,
       0,   864,     0,   868,     0,     0,   855,     0,   856,     0,
       0,     0,     0,     0,     0,   314,     0,     0,     0,   857,
     858,   859,     0,     0,     0,     0,     0,     0,   860,     0,
     869,   315,     0,     0,     0,     0,     0,     0,   870,     0,
       0,     0,     0,     0,     0,   862,     0,   861,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   871,  1629,     0,   848,
     849,   850,   207,   863,   317,     0,     0,     0,     0,     0,
       0,   851,     0,     0,     0,     0,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     865,   866,     0,     0,     0,     0,     0,     0,   313,     0,
       0,     0,     0,   862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3539,
       0,   863,     0,  1629,     0,   848,   849,   850,     0,     0,
       0,     0,   318,     0,     0,     0,     0,   851,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   852,   853,   854,
     868,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     864,     0,     0,     0,   313,     0,  1630,     0,     0,     0,
     857,   858,   859,   316,     0,     0,     0,   869,     0,   860,
       0,     0,   315,     0,     0,   870,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   871,     0,     0,     0,     0,     0,   207,
       0,     0,     0,   852,   853,   854,     0,     0,   864,     0,
       0,     0,     0,   317,   320,     0,     0,     0,     0,     0,
       0,     0,   314,     0,     0,     0,   857,   858,   859,     0,
       0,     0,     0,     0,     0,   860,     0,     0,   315,   865,
     866,     0,     0,     0,   862,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2149,     0,
       0,   317,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   318,     0,     0,  2150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   865,   866,   868,
       0,     0,     0,     0,     0,  2151,     0,     0,     0,     0,
     862,     0,     0,     0,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   869,     0,     0,     0,
       0,     0,     0,  2152,   870,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2153,  2154,  2155,   318,
       0,  2156,     0,     0,     0,     0,     0,     0,  2157,     0,
       0,     0,   871,     0,     0,     0,     0,   868,   207,   864,
    2158,     0,  2159,  2160,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   320,     0,     0,     0,     0,     0,     0,
     316,     0,     0,     0,   869,     0,     0,     0,     0,     0,
    2161,     0,   870,     0,     0,     0,     0,     0,     0,     0,
    2394,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     871,     0,     0,     0,     0,     0,   207,     0,     0,     0,
       0,     0,   317,     0,     0,   864,  2395,     0,     0,     0,
       0,   320,     0,     0,     0,  2162,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2396,     0,   865,   866,
       0,  2163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3400,     0,  2164,  2165,     0,  2166,  2167,     0,     0,
       0,     0,     0,     0,     0,  2397,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,     0,
     318,     0,     0,     0,     0,     0,     0,   885,     0,     0,
       0,     0,     0,  -692,     0,     0,     0,     0,   868,     0,
       0,  2168,     0,     0,   865,   866,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2283,     0,  2169,     0,     0,
       0,     0,     0,     0,     0,   869,     0, -3400,     0,     0,
       0,     0,     0,   870,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2283,     0,
       0,     0,     0,     0,  2398,     0,   318,  2170,  2171,  2172,
       0,   871,  2399,     0,     0,     0,   529,   207,     0,     0,
       0,     0,     0,     0,   868,     0,     0,     0,     0,     0,
    2173,     0,   320,     0,     0,  2174,     0,     0,     0,     0,
       0, -2283,     0,     0,     0,     0,     0,     0,     0,   843,
       0,   869,     0,     0,     0,   844,   845,     0,     0,   870,
    2175,  2176,     0,     0,     0,     0,  2177,  2178,     0,     0,
       0,   847,     0,     0, -2283,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   871,     0,     0,
       0,     0,   529,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   320, -3302,
   -3302,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2179,     0,  2180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2181,     0,     0,     0,     0,     0,     0,     0,     0,  2400,
       0,     0,     0,  2182,  2183,  2184,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3302,     0,     0,     0,     0,
       0,     0,     0,     0,  2186,  2187,  2188,     0,  2189,     0,
    2190,  2191,     0,  2192,  2193,  2194,     0,     0,  2401,     0,
      59,  2195,     0,  2196,  2197,  2198,  2199,     0,     0,     0,
    2402,     0,     0,     0,     0,     0,     0,     0,     0,  2200,
       0,     0, -3373,     0,   848,   849,   850,  2201,     0,     0,
       0,     0,     0,  -692,  2403,     0,   851,     0,     0,     0,
       0,     0,  2202,  2203,     0,  -692,     0,     0,     0,     0,
       0,  2204,     0,     0,  -692,     0,     0,  2205,     0,     0,
       0,     0,     0,   313,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4460,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4461,  4462,  4463,  4464,     0,     0,     0,     0,  4465,
       0,     0,     0,     0,  2206,     0,     0,     0,     0,     0,
    2207,     0,     0,     0,     0,     0,     0,  4466,  4467,     0,
       0,     0,   852,   853,   854,     0,     0,     0,     0,     0,
       0,     0,   855,     0,   856,     0,     0,     0,  4468,     0,
       0,   314,     0,     0,     0,   857,   858,   859,  2404,     0,
       0,     0,     0,     0,   860,     0,     0,   315,     0,     0,
    4469,     0,     0,  2208,  2209,  2210,     0,  1833,  4470,     0,
       0,  1834,     0,  2211,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2405,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2406,     0,  2212,     0,
       0,     0,     0,     0,     0,     0,  -692,     0,     0,     0,
       0,  2213,  2214,  2215,  2216,     0,  4471,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2217,  2218,     0,     0,  4460,     0,     0,     0,   862,
       0,     0,  2219,     0,     0,     0,  2407,     0,  4461,  4462,
    4463,  4464,     0,     0,     0,     0,  4465,     0,     0,     0,
       0,     0,     0,  -692,     0,     0,     0,   863,     0,     0,
       0,     0,  2220,     0,  4466,  4467,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2221,  2222,     0,     0,
       0,     0,     0,     0,     0,  4468,     0,     0,     0,     0,
       0,  2408,     0,     0,  -692,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4469,  2409,   316,
       0,     0,     0,  2223,  1833,  4470,     0,     0,  1834,  4472,
       0,     0,     0,  2224,     0,     0,     0,     0,     0,  2410,
    2225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2226,     0,     0, -3302,  2227,  2228,  2229,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4471,   864,     0,  2230,  2231,     0,     0,
       0,  2232,  2233,     0,  2234,     0,     0,  2411,  4473,     0,
       0,  2235,     0,     0,     0,     0,     0,  4474,     0,  4475,
       0,     0,   885,     0,     0,     0, -3302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4476,     0,     0,     0,
       0,  -692,     0,     0,     0,     0,     0,     0,  4477,     0,
   -1163,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3373,     0,     0,   317,     0,     0,
     885,  2412, -3302,     0,     0,     0,     0,     0,     0,     0,
       0,    59,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2402,     0,   865,   866,     0,     0,  2413,     0,     0,
       0,     0,     0, -3373,     0,     0,  4472,  4478,     0,     0,
       0,     0,  2414,     0,  2415,     0,  2416,     0,     0,  2417,
    4479,     0,     0,  2418,  4480,     0,     0,     0, -1163,     0,
       0,     0,  1927,     0,   843,     0,     0,     0,     0,     0,
     844,   845,  4481,   886, -1163,   318,     0,   887,   888,     0,
       0,     0,     0,     0,  -692,     0,   847,     0,     0,     0,
       0,     0,     0,   868,     0,  4473,     0,     0,     0,     0,
       0,     0,     0,     0,  4474,     0,  4475,     0,     0,     0,
       0,     0,   843, -3302,     0,     0,     0,  4482,   844,   845,
     869,     0,     0,  4476,  1861,     0,     0,     0,   870,     0,
       0,     0,     0,     0,   847,  4477,     0, -1163,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   871,   885,     0,  4483,
       0,  1862,   207,     0,     0,     0,     0,     0,    59,     0,
       0,     0,     0,     0,     0,     0,     0,   320,  2402,  4484,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3373,     0,     0,     0,  4478,     0,  2405,     0,     0,     0,
       0,     0,     0,  1836,  1837,     0,     0,  4479,     0,     0,
       0,  4480,     0,     0,     0, -1163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4485,     0,  4481,
       0, -1163,     0,     0,     0,     0, -1163,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   848,
     849,   850,     0,     0,     0,     0,     0,     0,     0,   843,
       0,   851,     0,     0,  4482,   844,   845,     0,  4486,     0,
       0,  1861,     0,     0,     0,     0,     0,     0,     0,     0,
    1867,   847,  1868,  1869,     0,     0,     0,     0,   313,     0,
       0,     0,     0,     0,     0,     0,     0,   848,   849,   850,
       0,     0,     0,     0,     0,     0,  4483,     0,  1862,   851,
       0,     0,     0,     0,     0,  4487,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4484,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,     0,     0,     0,
    2410,     0,     0,  2405,     0,     0,  4488,   852,   853,   854,
    1836,  1837,     0,     0, -1163,     0,     0,   855,  4489,   856,
       0,     0,     0,     0,     0,     0,   314,     0,     0,     0,
     857,   858,   859,     0,  4485,     0,     0,     0,     0,   860,
       0,     0,   315, -1163,     0,     0,     0,     0,     0,     0,
       0,     0,  4490,     0,     0,   852,   853,   854,     0,     0,
       0,     0,     0,     0,     0,   855,     0,   856,     0,     0,
       0,     0,     0,     0,   314,     0,     0,  4491,   857,   858,
     859,     0, -1106,     0,     0,  4486,     0,   860,  4492,     0,
     315,     0, -1163,     0,     0,     0,     0,  1867,     0,  1868,
    1869,     0,     0,     0,     0, -3373,     0,     0,     0,     0,
       0,     0,     0,     0,   848,   849,   850,  4493,     0,     0,
       0,     0,     0,     0,   862,     0,   851,     0,     0,     0,
       0,     0,  4487,     0,     0,     0,     0,     0,  2413,     0,
       0,     0,     0,     0,     0,     0,  4494,     0,     0,     0,
       0,     0,   863,   313,     0,  4495,     0,  2410,     0,     0,
     885,     0,     0,  4488,     0,     0,     0,     0,     0,     0,
       0, -1163,   862,     0,     0,  4489,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1163,     0,     0,     0,     0,     0,
     863,     0,     0,     0,   316,     0,     0,     0,     0,  4490,
       0,     0,   852,   853,   854,     0,     0,     0,     0,     0,
       0,     0,   855,     0,   856,     0,     0,     0,     0,     0,
       0,   314,     0,     0,  4491,   857,   858,   859,     0, -1109,
       0,     0,     0,     0,   860,  4492,     0,   315,     0, -1163,
     885,     0,   316,     0,     0,     0,     0,     0,     0,   864,
       0,     0, -3373,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   843,     0,  4493,     0,     0,     0,   844,   845,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   847,  2413,     0,     0,     0,     0,
       0,     0,     0,  4494,     0,     0,     0,   864,     0,     0,
       0,     0,  4495,     0,     0,     0,     0,     0,     0,     0,
    1251,     0,     0,     0,     0, -3400,     0,     0,     0,   862,
       0,     0,   317,     0,     0,     0,     0,     0, -3400, -3400,
   -3400, -3400,     0,     0,     0,  1252, -3400,     0,     0,     0,
       0, -1163,     0,     0,     0,     0,     0,   863,   865,   866,
       0,     0,   843,     0,     0, -3400,     0,     0,   844,   845,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,     0,     0,     0,   847,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2825,     0,     0,
       0,     0,     0,     0,     0,     0,   865,   866,   886,   316,
     318,     0,   887,   888, -3250, -3400,     0,  3080, -3250,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   868,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3400,     0, -3400,   869,   886,     0,   318,     0,
     887,   888,     0,   870,   864,     0, -3400,   848,   849,   850,
       0,     0,     0,     0,     0,     0,   868,     0,     0,   851,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   871, -3400,     0,     0,     0,     0,   207,     0,     0,
       0,     0,     0,   869,     0,     0,   313,     0,     0,     0,
       0,   870,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,     0,   871,
       0,     0,     0,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   848,   849,   850,
     320,     0,     0,   865,   866,   852,   853,   854,     0,   851,
       0,     0,     0,     0,  3082,   855,     0,   856,     0,     0,
       0,     0,     0,     0,   314,     0,     0,     0,   857,   858,
     859,     0,     0,     0,     0,     0,   313,   860,     0,     0,
     315,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   886,     0,   318,     0,   887,   888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   868,     0, -3400,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1253, -3400,     0,     0,     0,
       0,     0,     0,     0,     0,   852,   853,   854,     0,     0,
     869,     0,     0,     0,     0,   855,     0,   856,   870,     0,
       0,     0,     0,     0,   314, -3400,     0,     0,   857,   858,
     859,     0,   862,     0,     0,  1251,     0,   860,     0,     0,
     315,     0,     0,     0,     0,     0,   871,     0,     0,     0,
       0,     0,   207, -3400, -3400, -3400, -3400,     0,     0,     0,
     863, -3400,     0,     0,     0,     0,     0,   320,     0,     0,
   -3400,     0,     0,     0,     0,     0,     0,     0,     0, -3400,
   -3400,     0,     0,  3144, -3400,  3145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3250,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1969,     0,
       0,     0,   316,     0,     0,     0, -3400,     0,     0, -3400,
       0,     0,   862,     0,     0,     0,     0,     0,     0, -3250,
   -3400,     0,     0, -3250,     0,     0,     0,     0,  1254,     0,
       0,     0,  1842,     0,     0,     0,     0,     0,     0,     0,
     863,     0,     0,     0,     0,  1843,  1844,  1845,  1846,     0,
       0,     0,     0,  1847, -3400,     0,     0,   864,     0, -3400,
       0, -3400,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1848,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   316,     0,     0,     0,     0,     0, -3400,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   843,     0,     0,     0, -3400,     0,   844,   845,
       0,     0,  1849,     0,     0,     0,     0,     0,     0,     0,
     317,     0,     0,     0,   847,     0,     0,     0,     0,     0,
   -3250, -3250,     0,     0,     0,     0,     0,   864,     0,     0,
       0,     0,     0,     0,     0,     0,   865,   866,     0,  1850,
       0,  1851,     0,     0, -3400,     0,     0, -3400,     0,     0,
       0,     0,     0,  1852,     0,     0,     0,     0,     0,     0,
       0, -3400,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3105,     0,     0,     0,  1853,
       0,     0,     0,     0,     0,     0,   886,     0,   318,     0,
     887,   888,     0,     0,     0, -3400,     0,     0,     0,     0,
     317,     0,     0,     0,     0,     0,   868, -3400,     0, -3400,
   -3400,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3400,     0,     0,     0,     0,     0,   865,   866,     0, -3400,
       0,     0,   843,   869, -3400,     0,     0,     0,   844,   845,
       0,   870, -3400,     0,     0,     0,     0,     0,     0,     0,
       0,  3146,     0,     0,   847,     0,     0,     0,     0,     0,
   -3400,     0,     0,     0,     0,     0,     0,     0,     0,   871,
       0,     0,     0, -3400,     0,   207,   886,     0,   318,     0,
     887,   888,     0,     0,     0, -3400,     0,   848,   849,   850,
     320,     0,     0,     0,     0,     0,   868,     0,     0,   851,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1969, -3400,
       0,     0,  1854,   869,     0,     0,   313,     0,     0,     0,
       0,   870, -3250,  1855,     0,     0,  3147,     0,     0, -3252,
   -3400,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3400,     0,     0,     0,     0,   871,
       0,     0,  1856,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     320,     0,     0,     0, -3400,   852,   853,   854,     0,     0,
       0,     0,     0,     0,     0,   855, -3400,   856,     0, -3400,
       0,     0,     0, -3400,   314,     0,     0,     0,   857,   858,
     859,     0,     0,     0,     0,     0,     0,   860,     0,     0,
     315,  1857,     0,     0,     0,     0,     0,   848,   849,   850,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   851,
       0,     0,     0,     0,     0,   529,     0,     0,   843,     0,
       0,     0,     0,  1858,   844,   845,  1859,     0,     0,     0,
       0, -3400,     0,     0,     0,     0,   313,     0,     0,     0,
     847,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3148, -3250, -3250,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1860,   862,     0,     0,     0,     0,     0,  1861,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   852,   853,   854,     0,     0,
     863,     0,     0,     0,     0,   855,     0,   856,     0,     0,
       0,     0,     0,     0,   314,  1862,     0,     0,   857,   858,
     859,     0,     0,     0,     0,     0,     0,   860,     0,     0,
     315,     0,     0,  1863,     0,     0,     0,     0,     0,     0,
       0,     0, -3400,     0, -3400, -3400,     0,     0,     0,     0,
   -1969,     0,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3400,     0,     0,     0,     0, -3400,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1864,     0,     0,  1865,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3149,     0,  4853,     0,
       0,     0,     0,     0,     0,     0,     0,   864, -3400,     0,
       0,     0,   862,   848,   849,   850,     0,     0,     0,     0,
   -3400,     0,     0,     0,     0,   851,     0,     0,     0,     0,
       0,     0,  1866,     0,     0,     0,     0,     0,     0,     0,
     863,     0,     0,     0,  1867,     0,  1868,  1869,     0,     0,
       0,     0,   313,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1870,     0,     0,     0,
       0,  1871,     0,     0,     0,     0,     0, -1969,     0,  1872,
     317,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   316,     0,     0,     0,     0,     0,     0,  3150,
       0,     0,     0,     0,     0,     0,   865,   866,     0,     0,
   -3360,   852,   853,   854,     0,     0,     0,     0,     0, -3400,
       0,   855,  1873,   856,     0,     0,     0,     0,     0,     0,
     314,     0,     0,     0,   857,   858,   859,     0,     0,     0,
       0,     0,     0,   860,     0,     0,   315,   864,     0,     0,
       0,     0,     0,     0,     0,     0,  1874,     0,   318,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   868,  1875,     0,     0,
     529,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4854,     0,     0,
       0,     0,     0,   869,     0,     0,     0,     0,     0,     0,
       0,   870,     0,     0,     0,     0,     0,     0,     0,     0,
     317,  1876,     0,     0,     0,     0,     0,     0,   862,     0,
       0,     0,     0,  1877,     0,     0,     0,     0,     0,   871,
    1878,     0,     0,     0,     0,   207,   865,   866,     0,     0,
       0,     0,     0,     0,     0,     0,   863,     0,     0,     0,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   318,     0,
     887,     0,     0,     0,     0,     0,     0,     0,   316,     0,
       0,     0,     0,     0,     0,     0,   868,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   869,     0,     0,     0,     0,     0,     0,
       0,   870,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   864,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   871,
       0,     0,     0,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   865,   866,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   318,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   868,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   869,
       0,     0,     0,     0,     0,     0,     0,   870,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   871,     0,     0,     0,     0,
       0,   207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   320
};

static const yytype_int16 yycheck[] =
{
     175,   224,   312,   685,   676,  1267,   713,  1262,   201,   745,
     746,   747,  1209,   156,   750,   158,  1113,   707,   703,   262,
     163,  1052,   276,  1609,  1835,  1745,    43,   767,   671,  1840,
    1135,   771,   772,   741,   774,   775,   194,   777,   778,    52,
     679,   749,   796,   797,   127,    58,  2261,    73,  1826,   303,
    1712,  1408,  2387,    79,   877,   838,  2460,  2461,  1421,    76,
      77,    78,   205,   842,    90,  2890,    83,  1371,    81,    82,
    1345,    84,    85,   896,  1188,  1077,  1190,  1191,   688,  1193,
    1194,  2416,   305,   939,  2567,  2459,   768,   769,  2017,   230,
    1765,   773,   933,  1397,   776,   683,   787,   707,  2027,  2582,
     688,  2535,   666,  2830,   665,   118,  1381,  1382,  1383,  1384,
    2711,  2545,  1864,  1092,  1746,  2881,  1894,  2301,   667,   707,
    3367,  1719,   139,   692,  1902,  1922,   867,  2680,  1925,  3343,
    3362,  3363,   145,   146,   147,  2388,   153,  1934,   155,   708,
    2016,  1938,   159,   160,  1283,  3669,   925,  2750,  1945,  2330,
     711,   968,   169,  1633,     0,   933,  1295,  2056,   175,  1287,
       1,  2037,  1987,    12,   181,     1,     1,   184,  2258,    45,
     187,  3068,  2718,    18,    27,    18,    33,   190,   666,    18,
     855,   856,   195,   671,    18,    18,   203,     5,   863,    97,
      40,    75,    18,     8,   151,   683,     1,   223,    18,    15,
     688,   175,     1,   123,   221,    97,    18,   233,    22,    23,
      24,  1067,    33,   124,    91,   232,    21,    45,   256,   707,
      18,     1,   124,    18,   170,    69,    43,   121,  2053,   242,
    2656,    27,   245,   908,   251,    18,   244,    46,  2527,  2528,
     171,    12,   225,    46,  2533,  2534,   124,  2536,   221,  1885,
     263,  1664,    68,   563,   266,  3526,  1097,   310,  1036,    99,
       0,  1389,   212,  1273,   133,    97,   183,   243,   285,   136,
       0,   243,   503,  1375,  1284,  3201,    90,  3360,   337,   171,
    1026,   419,   124,   310,    25,  4077,   310,     1,  1267,  1240,
     310,   187,    12,   357,  1894,    32,   178,  1138,   867,   187,
     249,   478,  1902,   329,   330,   254,   272,   288,   497,   288,
     411,  2794,  2795,   128,   128,  1022,   257,   213,    32,  1097,
     431,   126,     1,   887,   337,   213,   124,   156,   555,   158,
      25,   344,   324,    25,   163,   357,    70,   110,   617,   204,
     337,   204,    25,   184,   325,   326,  2827,   419,    18,  2638,
    2340,   266,  2641,    40,   303,   904,   510,   115,    33,  2648,
     621,   536,  2651,   250,  1105,   431,   438,   431,    39,   478,
     677,   215,   222,   431,   439,    12,   205,   337,   583,   184,
    2137,   310,   187,   166,   189,   443,   328,   694,   695,   172,
     173,   621,  3190,   357,   244,   568,   449,   885,   886,   887,
     888,   962,  3272,  1110,   248,   188,  3611,  3450,   213,   456,
     507,   596,   230,   374,  3152,   300,  1004,   615,   374,   372,
     737,   470,   676,  2969,  3162,   272,    45,   670,  2253,   516,
     673,  2977,  1020,   371,  2980,  2981,   478,   693,   244,   829,
     928,   583,   676,    52,   411,  1268,  3693,   256,   153,   298,
     279,   367,   318,   256,  4011,   134,  2546,   680,   701,   272,
    4065,   704,  1170,   405,   288,  1219,   709,  1250,  4193,  3996,
     533,   856,   715,  1256,  3272,   154,   679,  1087,   782,   356,
    1071,   245,   870,   871,    12,   431,   220,   201,  2862,    43,
    4072,  4048,   590,  1621,   337,   356,   175,   176,   897,  1087,
     339,  1342,   307,   520,   521,   478,  1094,   249,   323,     0,
    1333,   431,   254,  2338,   431,    12,  1004,   668,   535,    14,
    2809,   478,   215,   243,   596,   542,   847,   267,   373,   537,
     391,   930,  1020,   273,  1125,   222,  1105,   267,   564,   566,
    3365,   339,   566,   273,  4269,   151,   257,   308,    44,   853,
     431,   400,   171,   419,   298,   151,   320,  2892,   478,   949,
     587,   303,   478,   587,   949,   628,    45,   874,   151,   720,
     826,  2752,   438,  1137,   431,  3472,  1704,   464,   361,   362,
     363,  4186,   669,   137,   838,   481,   151,   141,   675,   473,
     373,   371,  1375,   481,  3520,  4065,  4153,  3523,  3199,  1087,
    2853,   643,   151,  2818,  2744,  3688,  1094,  4134,   151,  4191,
     431,   513,  3016,   580,   453,   320,   357,   400,  1815,   453,
     469,  3174,   471,   257,   858,   441,  4798,   802,   949,   478,
     151,  4803,   372,   252,    53,   952,    55,    56,    57,    58,
      59,    60,   372,   151,  1287,   494,   788,   151,   609,  1137,
     747,   849,   537,   609,  3524,   453,   427,  3862,   587,   443,
     641,   295,   641,   297,   245,   405,   478,   407,   975,   948,
     924,   718,  2334,   858,   357,   405,   481,   407,   461,   922,
     400,   589,   989,   464,   749,   464,   735,   948,  1802,   642,
     863,  2944,   171,   847,   937,   478,   367,   376,   456,   482,
     483,   484,  2065,   641,    25,    99,  3920,  1014,   491,   443,
     478,   494,   525,  1277,  1278,  1279,  4186,   541,   948,   949,
    2710,  2478,   925,  4183,   688,   439,  3524,   414,  3771,  1293,
     596,   537,   798,  1040,   584,    25,   837,   964,   847,   310,
     766,   852,   537,  2521,   949,   250,  1389,   739,   679,   469,
      43,   471,   431,  1392,   429,   604,   431,   829,   478,   948,
     574,   257,   602,   400,   292,  1072,  1020,   375,  2593,   574,
    2669,   679,   949,   252,   494,  1339,  2051,  2555,   916,   516,
    1344,   522,  1270,  1271,  1272,   464,   557,   679,   375,  1277,
    1278,  1279,  1931,   576,  1650,  3276,  1103,   476,  1052,  1287,
    1107,  1362,   516,  2107,   821,  1293,   485,   656,  1296,  1032,
    4602,   693,   583,  1636,  1302,  1303,  1304,  1305,  1306,  1307,
    1308,  1309,  1310,  1311,  1312,  1313,  1954,   522,  1135,  1052,
     522,   643,   469,   675,   471,  3918,   863,   666,   667,   336,
     852,   478,   671,  2256,   137,   618,  1687,   679,   141,  1628,
    1596,  1339,   793,    18,   683,   684,  1344,   494,  3147,   688,
    3685,   641,  3687,   692,  1604,   666,  1817,   537,   776,   664,
    2960,  3417,   400,   656,   703,   762,   705,   116,   707,   708,
     250,  1135,  1431,  3809,   604,   949,   852,  3784,   775,   718,
     949,   949,   759,   123,   123,   724,   949,   127,   127,  1901,
     123,  1389,   642,   400,   127,   789,   136,  3311,   825,  4180,
     948,  2013,   642,  2549,   409,   410,   470,    18,   527,   528,
     529,   449,   898,   637,   603,   949,   898,   949,   711,   949,
     942,   736,   801,    98,  2347,   784,   656,   852,   123,    18,
     948,   469,   127,   471,   826,   744,   651,   442,  1179,   860,
     478,   784,   949,   782,   865,  2555,   852,   511,   637,   776,
     718,   801,  3565,   700,   852,   948,   494,   604,   949,   847,
     949,   676,   469,   947,   471,   949,   949,   842,  1621,   842,
    1287,   478,   510,   891,   930,   854,   700,   800,   864,   949,
     867,   486,   949,   663,   925,   732,  1250,   494,   948,   949,
     949,   784,  1256,   215,   853,   852,   852,   949,  1618,  1184,
    1203,  1186,   817,   862,  1189,   694,   587,   925,   732,   656,
    1799,  1800,   916,  1198,   829,   201,   760,   810,   811,   949,
    1618,  2010,   853,   925,   852,   749,   864,   646,   867,  1182,
    1183,   949,   537,   839,  1237,  1785,  1786,   852,   950,  1192,
    3788,  1791,  1806,   852,  1794,   899,   735,  3483,   897,  2010,
    3313,  1704,   867,   897,   784,   949,   562,  1374,   949,   623,
     624,   948,   852,  1327,   553,   904,   604,   875,   965,   862,
     661,  1388,  1389,   949,   885,   886,   887,   888,  3228,   942,
    1678,   862,   949,   925,   464,   574,  1919,   880,   948,   928,
     949,  3998,  1345,  1357,   949,   900,   949,   604,   949,   853,
    1417,  1952,   852,   949,   949,   964,   510,  1605,    18,   257,
     966,  1375,   852,   949,   907,  2605,   942,   847,   656,   949,
    1618,   964,   915,  1621,   949,   949,  1811,   949,   852,  1332,
    3393,   852,   862,   836,   949,   948,    18,   784,   754,  1162,
     959,  1841,   429,   858,   847,   960,   959,  4627,   754,   656,
     943,   956,  1179,   375,   948,   184,   949,   184,   185,  1948,
     189,   754,  1736,   852,  1952,  1004,    18,   470,   898,   760,
     855,   964,     0,   944,   965,  3275,   965,  3277,   949,   754,
    1678,  1020,   404,    44,  3284,   375,   964,  3126,  3127,  3128,
    3129,   522,  2834,  1944,  4664,   754,   948,   949,   602,   949,
     847,   754,   707,   847,   400,   298,  1704,   456,  2522,   949,
    1237,    12,    18,  1052,  1241,   862,   966,  2979,  2259,   949,
    2013,   431,   522,   754,   217,   400,   966,  1254,   949,  4136,
     848,  3844,    18,   849,   964,   920,   754,  3800,  1736,  3339,
     754,  1052,    18,   849,  3079,   966,   784,   762,  1087,   868,
     869,   171,  4786,   439,    30,  1094,   849,   942,  3167,   948,
     775,  2329,   881,   503,   503,  2937,  1105,   864,    77,  2096,
     503,   478,  2586,  2587,   849,  3161,   965,   784,   307,   478,
     431,  3430,   863,  2968,   459,   460,   411,   459,  3437,   400,
     849,  2498,  1131,   223,   453,  2307,   849,  2130,   494,   837,
     503,  1954,   949,   478,  1621,  2619,  2620,  4044,   503,  4533,
     464,   400,   478,   583,   123,   400,  3046,   964,   849,   494,
     623,   624,    98,    33,   862,  4391,  1137,    51,  3163,   860,
    3165,   849,    48,   537,   865,   849,   678,   901,   221,   201,
    1604,    97,   137,  1182,  1183,   453,   141,  2388,   341,   430,
    2100,   478,  1537,  1192,  2668,   862,  2480,  2481,   175,   507,
    4584,   478,  2486,  2487,   187,  1944,  1683,   478,   257,    69,
     300,  3565,  2686,    41,  3565,   478,  3211,   478,  3641,  2071,
    1697,   154,   762,   494,   948,   431,   470,  1704,    88,   478,
     213,   221,   796,   478,   852,   775,   257,   801,   478,   257,
     486,   641,   641,  3883,  1668,   494,   411,   478,   641,   494,
     537,   949,  1251,  1730,    48,   478,  2108,  1976,   478,  2733,
     478,   459,   851,  1656,  2257,  2117,   964,   478,  4165,  1693,
     129,  2580,   861,  2747,  3269,   940,  3271,  2751,  3822,   267,
     360,   948,   949,   948,   643,   273,   641,    33,  1287,   470,
     854,   637,  1950,   322,   447,   478,  1954,   964,   478,  1270,
    1271,  1272,   555,  2878,  4322,   776,  1277,  1278,  1279,   718,
      40,   340,   565,   776,   486,   478,   459,  1741,   536,   357,
    2313,   656,  1293,   510,   375,  1296,   567,   709,   237,     0,
     400,  1302,  1303,  1304,  1305,  1306,  1307,  1308,  1309,  1310,
    1311,  1312,  1313,  2817,   292,   771,  3114,  2340,   748,   748,
     452,   504,  2627,    22,  4756,   748,    25,    26,   400,   759,
    2658,  1601,  2660,  2312,  4080,   537,   844,  4385,  1339,  1680,
    4787,  4788,   375,  1344,  1614,  1788,   574,  1790,   478,  1792,
    1793,   317,  1795,  1796,   372,   656,   864,   889,   400,  2569,
    1389,  2571,     1,   748,  2574,  2053,  3495,  2577,  2578,  2579,
    4817,  2581,   620,   749,  2584,   478,     1,   656,   478,   430,
    2403,   656,   721,   478,  2407,  2595,  2596,   405,   246,   407,
     891,   215,  4358,  4649,   494,   965,  2337,   592,   784,  2727,
     314,  4815,  1431,   464,   400,   481,   478,   510,   481,   400,
     245,    94,  3751,  4340,   776,  2729,   633,   452,   762,   784,
    2310,  3283,   494,   852,   400,   508,  3765,  4097,   507,   852,
     478,   478,   852,   845,   400,   891,   478,  3389,   409,   300,
    1783,  2251,  4016,   920,   591,   721,    71,    72,    73,    74,
     643,    76,   494,   853,   522,  3039,   603,  4391,   478,  3043,
     798,   735,   222,  2251,  2252,   119,   120,   852,   481,  2797,
     882,   442,  4728,  3305,  1691,  3307,   852,   376,   469,   817,
     471,   427,   478,   784,   864,   470,    38,   478,    18,   949,
     542,   829,   569,   459,   460,  2002,   834,   862,   494,   168,
     603,   464,   478,   494,    44,   784,   847,   537,   398,   784,
    4391,   562,   478,   476,  2263,   486,   567,   736,   494,   949,
     949,   175,   485,  2781,   735,   620,   875,  1981,   494,    43,
    2412,   431,   431,   158,   159,  1748,  1753,   620,   853,  2493,
    1757,  1758,   400,  1760,  2484,  3049,  1763,  1764,    12,  1766,
    2591,  4125,   949,  1779,   948,   948,   656,   211,  3433,  2013,
     949,   862,  2585,  2251,  2252,  2253,   537,   457,  2337,     1,
     853,   225,   478,   683,   442,   574,   637,   875,   964,  2562,
    4154,  4155,   496,   862,   656,  2476,   948,  2478,   849,  1618,
      20,   367,  1621,   949,   124,   778,  3935,  3936,  1973,   964,
    2802,  1994,   492,   776,  1605,  2369,  2370,   583,   949,   948,
    4025,   949,   829,   604,   656,   916,   852,   865,   486,   637,
     478,   965,  2853,   481,   642,   591,  1843,   660,   709,   930,
    2809,   310,  1849,  3030,  3031,  1852,   494,  1854,   623,   624,
    2147,   721,   949,   478,   776,  2535,  3985,   124,   949,  1678,
    2338,  2541,  4067,  2543,   478,  2545,   949,    89,   949,   548,
     656,   550,  2959,   964,    94,   656,  3795,   525,   942,   537,
     949,   964,   731,   964,   637,  1704,   709,   183,   798,   949,
     656,  2369,  2370,   713,   784,   964,  3683,  2710,   949,   964,
     656,   874,   169,   554,   964,    18,   949,   817,   212,   949,
     777,   300,  4336,   135,   405,  3019,   407,    30,   949,   599,
     320,   321,   784,   845,   834,  4649,   964,   257,  4391,   798,
     345,   346,   347,   348,   349,   350,   351,   352,   353,  3233,
    3234,   694,   949,   247,   373,  1736,   949,  4391,   817,   949,
     531,   776,   784,   819,  3349,  2768,   948,  3609,   357,   486,
     829,   257,   237,  2625,  1783,   834,  3260,  3261,    40,  2649,
    2650,  3786,   862,   852,   183,  4790,   376,  2142,  4649,   201,
     865,  1988,   735,  3798,  3799,    98,  4577,   860,  3335,   375,
     318,   852,   865,   744,  3288,  4586,  3290,  4126,   784,   428,
     862,   852,   771,   784,  4728,   856,   406,   311,   656,   229,
     537,  2255,   949,   486,  2568,  2259,  2570,  2024,   784,   339,
     845,  2318,  1841,  2601,   497,  2658,  2033,  2660,   784,   949,
     862,   175,   712,   522,   523,   884,  3851,  3132,   140,   901,
    2594,  4403,  4406,  4407,   964,   147,  2259,   296,   914,  4704,
     855,   431,   486,   357,  4346,  4089,   949,  4728,  2302,   949,
     237,   866,   643,   478,  2618,   527,   528,   442,  2881,   486,
     919,   964,   376,   569,   964,  4204,   862,   400,   948,   928,
     400,   862,   400,   400,  3084,   574,   575,   949,  2332,   478,
    2568,   419,  2570,   849,  2727,   851,   862,   566,   320,   852,
    2344,   852,   964,   537,   860,   861,   862,   856,   864,   865,
     438,   486,   949,   299,   965,  2593,  2594,    18,   587,  4411,
     537,   743,   891,  2601,  2970,  1944,   215,   964,   948,    30,
     916,  1950,   964,   453,  4789,  1954,   784,   357,   771,   201,
    2618,   789,   790,   400,   930,  2310,   400,  2725,   384,   385,
     222,   771,  2921,  4515,   376,   478,   420,  1976,   478,   603,
     478,   478,   537,   949,  2797,  4559,  4560,  4201,   949,   613,
     614,   494,  2723,   525,   494,  2388,   494,   494,   964,   940,
    2658,   430,  2660,   964,   646,   584,  4649,  2816,  2319,  2320,
    2321,  2322,  2323,  2324,  2325,  2326,   744,    98,   964,  3191,
     949,   419,   411,    15,   317,  4649,   621,   887,   964,   431,
     596,   507,   965,  2378,   400,   469,    15,   471,   140,   154,
     438,   478,  3516,   445,   478,   147,   462,   463,   372,   644,
    4624,  4625,  4000,   478,  2053,   455,  2790,   494,   860,  2404,
     494,   771,   464,   865,   678,   356,   468,  2725,   356,  2727,
     694,   301,   371,   215,   367,  2488,    68,  2490,   891,  2492,
     310,   405,     8,   407,  2864,  4728,   486,   656,   596,    68,
     856,   891,   716,   717,   273,  2094,   414,   497,   320,   400,
     391,   777,   940,   391,  4728,  3995,  2864,   400,   533,  3310,
    4569,   536,   478,  2458,  4637,  4638,   580,  4576,   507,  2971,
    2465,  4580,   860,  3076,  4583,  3599,  3600,   865,   494,  3662,
     669,  2889,  2790,  3660,   563,   569,   964,   537,   567,  2797,
      22,    23,    24,    53,   411,    55,    56,    57,    58,    59,
      60,  2543,   470,   656,   376,   267,   656,   641,   656,   656,
     743,   730,   855,  4816,   431,   314,   459,   460,    18,   318,
     604,   400,    22,   866,   638,    25,    26,   478,   603,   655,
     481,   891,   411,   949,   860,   478,   722,   431,   470,   865,
    3139,   580,   474,   494,  4142,   620,  2541,  3190,  2543,  2386,
    2383,   494,   128,   289,  2597,   785,  2864,     7,  3068,  4783,
    2397,  2398,  2399,   555,   124,   784,   680,   339,  4677,   656,
    3062,  4680,   656,  4837,   525,   844,  2413,  2414,  2415,   848,
      15,  2889,   237,  2420,   478,   637,   317,  4742,    15,   881,
     779,   780,   357,  4075,   470,  4768,   128,   589,   474,   478,
    3534,  2504,  2251,  2252,  2253,  4869,   788,  2649,  2650,   791,
     792,   844,  4785,  2576,  2263,   494,    66,   669,   837,   405,
     419,   407,   674,  4633,  4848,   889,  2472,   860,    78,  3272,
    2467,   784,   865,    68,   784,   655,   784,   784,  2259,   438,
     656,    68,   694,  2770,   696,  1764,    34,    35,   591,   699,
    2628,  3250,  3251,   883,  2649,  2650,   782,  4667,   607,  2496,
    2497,  2310,   611,   713,  3224,   856,  2793,     7,   642,   400,
    2744,   443,   798,   699,    49,   125,   702,   449,   327,  1798,
     706,   807,   808,   809,   948,   744,  3188,   581,  2337,  2338,
     584,   817,   641,   777,   798,  2822,  2823,   784,   148,   464,
     784,   669,   339,  2540,   949,   656,   586,   587,   834,  3168,
    2547,   476,   862,   656,   862,   862,   684,    92,  4792,   356,
     485,  2541,  4471,  2543,    99,   875,    66,   850,   459,   460,
     949,  4480,  1579,  2807,   669,   940,  2863,   860,    78,  4488,
     675,  2815,   865,   948,  2393,   964,   211,   478,  2369,  2370,
      39,  1598,  1599,  1600,   391,    49,   206,   317,   120,  4794,
     225,   770,   782,   494,  4838,  4839,   298,  2388,   784,   860,
     300,   183,   301,   770,   865,   862,    49,   656,   862,  3874,
     310,   310,   466,   467,  3344,   125,   669,   807,   808,   809,
     865,   857,   675,   859,   411,   744,   949,   596,    92,   949,
     852,   949,   533,   470,   856,    99,   426,   474,   148,   849,
    2853,   964,   449,   175,   964,  2464,   964,   964,  3735,    92,
     860,   849,   947,   949,   949,   865,    99,  1725,   849,  2649,
    2650,  1729,   860,   784,   357,   472,   359,   865,  4469,   860,
     290,   784,  3759,   511,   865,   257,   862,  2890,  4479,   211,
    2893,   581,   384,   385,   584,  3163,   744,  3165,   669,   564,
     591,   566,  3787,   225,   675,   949,   206,   949,  3442,  1270,
    1271,  1272,   637,   925,   925,   149,   927,   964,  2527,  2528,
     964,  3524,   949,  3817,  2533,  2534,  2535,  2536,   902,   903,
     904,   905,  2541,  3385,  2543,  1296,  2545,   949,   948,   949,
     850,  2944,    39,  3211,    41,   784,   849,   949,   851,  2983,
     860,   572,   573,   965,   364,   865,   744,   860,   861,   862,
    3328,   864,   865,   949,  4880,   656,  4882,  2576,  4884,   694,
     462,   463,   478,   949,   885,   902,   903,   904,   905,   902,
     903,   904,   905,  4693,  2593,  2550,  2551,  2568,   964,  2570,
     290,   478,  2601,   723,  3017,  3018,   478,  3020,  3021,  3022,
    1302,  1303,  3472,  3271,  1278,  1279,   917,   918,  3611,   875,
     735,  4721,  4722,  2594,   949,   852,   949,  4727,  4518,   852,
    4730,   651,   237,   862,  4734,  4735,   951,  2982,   757,  2638,
     885,   886,  2641,   888,   776,   445,   127,  2618,   530,  2648,
    2649,  2650,  2651,  3130,  2900,  2901,  2902,  2903,   136,  2658,
     949,  2660,   848,   964,  4138,  4139,  3615,   152,  2855,  4143,
    3328,   964,   522,   523,   364,   431,   641,   477,   153,   357,
      18,  2680,   744,   565,   154,   564,   584,   566,   839,    18,
    3639,  3504,   574,  3506,   617,   478,   181,   428,   759,   852,
     852,   583,   212,   784,   478,   230,    15,   586,   587,  3367,
     122,    65,   793,   198,   199,   949,  4161,   847,   756,   314,
     635,   949,   377,  3068,   574,   575,  2725,   864,  2727,   949,
     744,   485,   589,  3210,   580,   964,   308,   852,    18,   856,
      34,   478,   511,   852,   626,   507,  3223,   948,   864,   258,
      30,   367,   507,   864,   864,   445,   864,   864,   864,   864,
    4741,  4128,  4129,   864,   864,    89,  3621,   864,   849,   259,
     851,   864,   864,   864,   317,  2962,   417,   577,  2965,   860,
     861,   862,   847,   864,   865,  3178,   260,   477,   134,   261,
     722,  2978,  3216,  4774,   263,   124,   176,  3190,  2797,  2986,
    2987,   669,   829,  3216,  3228,  4250,   829,   383,   154,    92,
    2809,   135,   264,   948,   177,   265,   519,   266,    98,  2790,
     197,   288,   864,   836,   270,   847,   271,    97,   837,   175,
     176,   949,   274,  4100,   319,   275,  3688,   166,  4594,   367,
     276,   279,   277,   172,   173,   949,  3504,   367,  3506,   310,
     965,   510,   636,   653,    45,   280,   427,   657,  3335,   188,
     281,   124,   282,   219,   283,  2864,   284,   847,  4069,  3862,
     478,   278,   930,   864,  3298,   744,   476,   201,   689,  3272,
     852,   169,  2853,   964,   828,    43,   357,   577,  3075,   949,
    2889,   842,   183,   655,  1304,  1305,  1306,  1307,  1308,  1309,
    1310,  1311,  1312,  1313,   847,  4272,  4351,   847,   949,   949,
     949,    22,    23,    24,   417,   375,   480,  3310,   639,  2890,
    3313,   478,  2893,   511,  3784,   707,   947,   901,   566,   478,
     942,   947,   310,    91,   253,    93,   336,   765,   738,   847,
     839,   851,   389,   844,   833,   427,   948,   427,    97,    97,
     860,   861,   847,   847,   864,   865,   847,   219,   116,   367,
    3909,   367,  4329,   653,   367,   427,  4391,   657,   269,  3362,
    3363,   853,  3365,  2944,   367,   857,   427,   859,   285,   137,
     367,   744,   170,   141,   694,    33,   580,   675,   783,   637,
     709,    89,  3902,  3903,   572,    15,   776,  3342,   151,   799,
    3393,   963,   487,   962,   443,   798,   443,  3484,  3485,  3486,
    3487,   798,   572,   498,   518,   849,   849,   128,   849,   849,
     782,    39,   849,   849,   849,  3438,   375,  4020,   849,   847,
     709,   847,   361,   362,   363,  3693,   798,   317,   714,   688,
     375,   443,   375,   594,   373,   807,   808,   809,   738,   339,
    3395,   964,   268,   693,   244,   817,   693,  3402,   375,   411,
     852,   580,   709,   581,   375,    18,    14,   478,   916,  3068,
     798,   400,   834,   709,   256,   942,   942,   735,  3265,   879,
    3443,  3444,   964,   925,  3397,   431,  3431,   367,   942,   376,
     942,   718,    21,   942,    39,  3440,   949,   942,    18,   431,
     376,   930,   949,   785,   476,   949,   849,   431,  3304,   799,
      30,   478,   569,   849,   777,   375,   430,   257,   464,  3512,
     400,   445,   537,   567,   453,  3308,    27,  3472,   839,  3553,
     476,  3524,   461,    97,   339,   299,   253,   925,  3998,   485,
     464,   941,   847,  4427,   468,   630,   925,    97,  3147,   478,
     759,    15,   367,   482,   483,   484,   693,   562,  3345,   591,
     847,   220,   491,   621,  3163,   494,  3165,   183,  3581,  3582,
     826,   522,   924,  3536,   109,  3174,   744,   852,    98,   459,
     460,   864,   839,  3660,   201,  4063,   671,   298,  4098,   879,
     104,   964,   886,   839,   847,  4144,  3620,   126,   478,   949,
     864,   367,    16,    39,   805,   690,   357,   757,   949,   474,
     123,   798,  3211,   847,   494,   760,    70,  4166,   486,   759,
     624,    27,   237,   849,  4649,   367,   230,   686,  3415,  3416,
     375,   389,   697,  3420,   375,  3422,  3423,  3424,  3425,   693,
      97,   357,   357,   686,   592,  3432,   585,   576,  3641,   594,
     272,   941,   486,   542,   443,   184,   486,   603,   187,   201,
     189,   470,   568,   518,   863,   225,  4176,  4260,   744,  3456,
     640,   478,  3271,   384,   385,   367,  4136,  4183,   909,   844,
     679,   478,    97,   478,   213,   580,   589,   760,   776,   214,
     413,   637,  3685,   223,  3687,    97,  4728,   845,   456,  4248,
      97,    15,   858,   215,    68,   537,   637,    97,   537,   486,
    3734,   591,   470,   637,   486,  3314,   474,  4310,   486,   563,
     296,   816,   637,  3668,   855,   852,   849,   656,  3805,  3328,
     761,   949,   847,   221,  3811,  3812,   221,   949,   584,  3310,
     847,   479,  3313,   776,   522,   669,   839,    25,   694,  3536,
     674,   462,   463,   949,   595,   637,   714,   798,   897,   520,
     949,  3674,   942,   847,   417,  4358,   357,   300,   257,   356,
     694,   221,   696,   367,    14,   839,   656,  3564,   307,   847,
     641,   518,   711,   212,   662,   414,  4263,   585,    43,   735,
     610,  3362,  3363,   503,  3365,   566,  3367,   317,  3397,   882,
     788,   856,   695,  3816,   852,   721,   497,   776,   521,   584,
     522,   691,    25,   637,  3413,  3414,   443,   443,   816,   530,
    3733,   459,  3393,   852,   852,   223,   856,   244,   214,  3742,
    3775,  3430,   815,   580,   443,  3748,   579,   443,  3437,  3784,
    3753,  3754,   183,  4353,   443,   459,   443,  3630,  3761,   459,
    3763,   942,  3876,   829,   565,   784,   591,   248,   123,   376,
     376,   134,   532,   574,   622,   623,   624,   391,   415,   954,
     955,   603,   583,  3472,   603,   802,  4336,   591,   603,    18,
     400,   810,   811,  1821,    56,  2505,   185,   335,    14,    92,
    1243,  1818,   217,   294,  2500,    61,    62,    63,    64,  3034,
     300,    99,   332,    69,   784,  3504,   852,  3506,   168,   219,
    1219,   797,   525,   307,   525,   626,  4278,  4123,  2478,  4515,
    3883,    87,    88,  3421,  4102,  4216,  4003,  3429,   852,   513,
    3022,  3449,   856,   862,    46,  4206,  3944,  3414,  3537,   459,
     460,   825,  4374,  4319,  4385,   748,   875,  2420,  2257,  3313,
    1753,   880,   481,  4728,  2435,  3900,  3743,  4851,   478,  4197,
     718,  4079,  2138,  4269,  3363,  2416,  3922,  3685,  4728,   849,
    3994,   851,   138,  2853,   494,  3762,  3969,  4632,   907,  1819,
     860,   861,   862,  4693,   864,   865,   915,  4728,  2895,  3776,
    4797,  4802,  4186,  4593,  4326,  4513,   693,  4472,  1596,  4012,
    3945,   925,   948,  4472,  1038,  4638,   764,  4479,  4509,  2511,
    1245,   177,  3454,  3457,   943,  3774,  3611,   255,  1250,   965,
     949,  3076,  3621,  1256,  3067,  1860,  1960,  2599,  3815,   904,
    4142,  3479,  1262,  4141,  1327,   964,   678,  3609,  3951,   916,
    1385,   965,   962,  1358,  2013,   574,  3512,  2040,  3993,   578,
    3132,   974,  2626,  3998,   693,  1395,  2669,  1392,  3167,  1000,
    3512,  3181,  2098,  2134,  3183,    36,    37,  1437,  3981,  3199,
    3641,   591,  1032,  2708,  3529,  3674,  4069,  3528,  3871,  4036,
    3553,  1047,  2259,  3222,   964,  1722,  1012,   845,  1056,  2294,
    2744,  3228,  3237,  3236,  2807,  3882,  1729,  4121,  4122,  4123,
    4063,  2820,  1665,  1085,  2327,  3892,  1087,   708,  2823,   867,
    2344,  1697,  3273,  2344,  3685,  4310,  3687,  1724,  4173,  3906,
    2305,  2293,  3693,  4296,  3876,  3614,  4033,  4343,  4416,  4348,
    1740,  2521,  2519,   299,  3733,  2590,   656,  4082,  3264,  2589,
    3278,  1370,   853,  3742,  1369,  3263,   857,  3843,   859,  3748,
    3604,  3279,  3751,  3603,  3753,  3754,  2624,  2623,  4664,   911,
    4073,  4074,  3761,   707,  3763,  1417,  3765,  3660,   697,   140,
    4163,   691,  2786,  3397,  1131,  2786,   147,  2786,  2786,   150,
     718,  2951,  2098,  4207,   309,  3784,  1321,  3862,  3837,  4213,
     948,  4136,   358,  2313,  1324,  4474,  3983,  2495,  4747,  3986,
    3987,  3800,  4201,  4525,  4646,   817,  3989,   736,   482,   870,
     800,  4213,  1754,  2329,  2615,  2941,  4694,  3270,  3591,  4459,
    1179,  4728,  2455,  4055,  4666,  3148,  4013,  4014,  4015,  4104,
    4660,  3185,   398,   204,  4774,   840,  4830,  3785,   209,   210,
     326,  4254,  3213,   340,  3404,  2032,  2365,  1260,  4035,  3356,
    4728,  4400,  4660,  4040,   783,  1762,   785,  2489,  4789,  3760,
      -1,    -1,    -1,    -1,   784,    -1,  3837,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4241,  4242,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   817,    -1,
      -1,    -1,  4205,    -1,    -1,  4308,  4748,    -1,    -1,    -1,
     829,    -1,  4215,  4216,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   292,    -1,   294,    -1,    -1,   492,    -1,  4115,   849,
     301,   851,    -1,    -1,    -1,    -1,  3935,  3936,   867,   310,
     860,   861,   862,  4853,   864,   865,    -1,    -1,    -1,  4342,
      -1,    -1,  3951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3969,    -1,   538,    -1,    -1,    -1,    -1,    -1,    -1,  4403,
      -1,    -1,  3981,    -1,    -1,    -1,  3985,    -1,    -1,    -1,
     664,    -1,   666,    -1,    -1,   669,    -1,    -1,    -1,  3998,
     674,    -1,   676,    -1,    -1,    -1,   680,    -1,    -1,  4196,
      -1,    -1,  4011,    -1,    -1,    -1,   690,    -1,    -1,   693,
     949,  4334,    -1,    -1,    -1,    -1,   700,    -1,    -1,    -1,
      -1,   960,    -1,   599,    -1,  4459,    -1,    -1,    -1,    -1,
     714,    -1,   716,   717,   964,    -1,    -1,  4392,   419,  4048,
      -1,    -1,    -1,    -1,    -1,    -1,   730,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4073,  4074,    -1,    -1,    -1,    -1,
      -1,  4474,    -1,    -1,    -1,    -1,  4431,    -1,    -1,    -1,
    4089,  4515,    -1,  4280,    -1,    -1,    -1,    -1,  4069,   470,
      -1,    -1,  4289,   474,  4103,    -1,    -1,  4294,    -1,    -1,
    4109,  4298,    -1,    -1,    -1,  4595,    -1,    -1,  4531,    -1,
     666,    -1,    -1,    -1,    -1,    -1,  4313,  4126,    -1,  4787,
    4788,    -1,    -1,    -1,   680,    -1,    -1,  4136,  4483,   510,
      -1,    -1,    -1,    -1,   710,    -1,   712,   713,    -1,    -1,
      -1,  4338,  4339,    -1,  4153,    -1,    -1,    -1,  4345,  4817,
      -1,    -1,    -1,    -1,    -1,    -1,   732,    -1,    -1,    -1,
     716,   737,   846,  4360,    -1,    -1,  4363,  4364,  4365,  4366,
      -1,    -1,   105,   106,   107,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4201,    -1,  4391,  4204,  4205,    -1,    -1,    -1,
     776,   885,   886,   887,   888,    -1,  4215,  4216,    -1,    -1,
      -1,    -1,   788,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4586,   916,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4437,  4438,  4439,  4440,  4441,    -1,    -1,  4444,  4445,  4446,
    4447,  4448,  4449,  4450,  4451,  4452,  4453,  4454,    -1,   943,
    4457,    -1,  4459,   666,  4461,    -1,    -1,    -1,   671,    -1,
      -1,  4626,    -1,  4470,    -1,    -1,  4473,    -1,    -1,    -1,
     683,    -1,    -1,    -1,    -1,   688,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   227,   228,    -1,   230,  4495,    -1,
      -1,    -1,    -1,    -1,   707,    -1,    -1,    -1,    -1,    -1,
      -1,   887,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   877,    -1,    -1,    -1,  4334,    -1,  4336,  1012,   885,
     886,   887,   888,    -1,    -1,    -1,    -1,    -1,  4693,    -1,
     896,  1025,    -1,    -1,    -1,    -1,    -1,    -1,  1032,    -1,
      -1,    -1,    -1,  4756,   735,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4721,  4722,  1052,    -1,
      -1,    -1,  4727,    -1,    -1,  4730,  4573,    -1,  4575,  4734,
    4735,    -1,    -1,    -1,    -1,    -1,    -1,  4790,  4585,  4744,
      -1,    -1,    -1,  1077,    -1,   166,    -1,    -1,    -1,    -1,
      -1,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4768,    -1,    -1,    -1,   188,    -1,    -1,
    1104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4785,    -1,  4629,    -1,    -1,    -1,    -1,    -1,  1122,   820,
      -1,    -1,    -1,  4798,    -1,  1129,  1130,  4802,  4803,    -1,
     831,    -1,  4649,  1137,    -1,    -1,  1140,  1141,  4813,    -1,
      -1,   842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   877,    -1,  1032,    -1,    -1,    -1,
      -1,    -1,   885,   886,   887,   888,   419,   420,    -1,    -1,
      -1,    -1,    -1,   896,    -1,    -1,  1052,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4702,  4703,    -1,  4705,    -1,
      -1,   444,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1077,    -1,  4720,    -1,   928,    -1,    -1,  4725,  4726,
      -1,    -1,   913,  4888,    -1,    -1,    -1,   470,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4743,    -1,    -1,  4746,
      -1,  4748,    -1,    -1,    -1,    -1,     4,    -1,    -1,    -1,
    4569,    -1,   495,    -1,    -1,    -1,    -1,  4576,   949,    -1,
      -1,  4580,    -1,    -1,  4583,    -1,    -1,    -1,    -1,  1263,
    1264,  1137,    -1,    -1,    -1,    -1,  1270,  1271,  1272,    -1,
     361,   362,   363,  1277,  1278,  1279,  1280,    -1,    -1,  1283,
      -1,  1004,   373,    -1,    -1,    -1,    -1,    -1,    -1,  1293,
      -1,  1295,  1296,    -1,    -1,    -1,    -1,  1020,  1302,  1303,
    1304,  1305,  1306,  1307,  1308,  1309,  1310,  1311,  1312,  1313,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
    1324,    -1,  1326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1339,    -1,    -1,    -1,    -1,
    1344,    -1,    -1,   596,    -1,    -1,    -1,    -1,  4677,    -1,
      -1,  4680,    -1,    -1,  1077,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1087,    -1,    -1,    -1,    -1,   137,
     461,  1094,   140,   141,  1378,    -1,   629,    -1,    -1,   147,
     633,   634,    -1,    -1,    -1,    -1,   154,   478,    -1,    -1,
      -1,   482,   483,   484,  1270,  1271,  1272,    -1,    -1,    -1,
     491,  1277,  1278,  1279,  1280,    -1,    -1,  1283,   661,    -1,
      -1,    -1,    -1,    -1,  1137,    -1,    -1,  1293,    -1,  1295,
    1296,    -1,    -1,    -1,    -1,    -1,  1302,  1303,  1304,  1305,
    1306,  1307,  1308,  1309,  1310,  1311,  1312,  1313,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1324,    -1,
      -1,     7,    -1,    -1,    -1,  4756,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1339,    -1,    -1,    -1,    -1,  1344,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   576,  4787,  4788,    -1,  4790,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    -1,    -1,    -1,    -1,  4817,    -1,    -1,    -1,
      -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    61,    62,    63,    64,    -1,
      -1,    -1,    -1,    69,    -1,    -1,    -1,  1270,  1271,  1272,
      -1,    -1,    -1,    -1,  1277,  1278,  1279,  1280,    -1,    -1,
    1283,    87,    88,    -1,  1287,    -1,    -1,    -1,    -1,   125,
    1293,    -1,  1295,  1296,    -1,   828,    -1,    -1,    -1,  1302,
    1303,  1304,  1305,  1306,  1307,  1308,  1309,  1310,  1311,  1312,
    1313,    -1,   148,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,    -1,  1339,    -1,    -1,   387,
     711,  1344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     206,   177,  1656,    -1,    -1,  1378,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1667,    -1,    -1,  1389,    -1,    -1,    -1,
      -1,    -1,    -1,   441,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,
      -1,    -1,  1696,    -1,    -1,    -1,   464,    -1,    -1,    -1,
      -1,    -1,   470,    -1,    -1,    -1,   474,    -1,   476,    -1,
      -1,     0,     1,    -1,    -1,    -1,     5,   485,    -1,   810,
     811,    -1,    11,    -1,  1728,    -1,    -1,    -1,    -1,  1605,
      19,    -1,  1736,    -1,   290,    -1,    -1,    -1,    -1,    28,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   535,    -1,    -1,
      -1,    -1,    -1,   299,    -1,    -1,    -1,    -1,    -1,    -1,
    1656,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,
      -1,    -1,    -1,    61,    62,    63,    64,    -1,    -1,   355,
      -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,
      -1,   579,   101,   102,    -1,    -1,   907,    -1,    -1,    87,
      88,    -1,    -1,    -1,   915,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   616,    -1,
      -1,    -1,   943,    -1,    -1,    -1,    -1,    -1,   949,   627,
    1736,    -1,    -1,   152,    -1,    -1,    -1,   156,    -1,   637,
     138,    -1,   398,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1885,  1605,    -1,    -1,   174,    -1,    -1,    -1,   445,
      -1,    -1,    -1,    -1,    -1,  1618,   452,  1901,  1621,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   177,
      -1,    -1,   201,    -1,    -1,    -1,    -1,  1921,    -1,     7,
      -1,   477,    -1,    -1,    -1,    -1,   694,  1931,    -1,   218,
      -1,    -1,    -1,    -1,    -1,   224,    -1,   226,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,   505,
      -1,    -1,    -1,    -1,    -1,  1678,    -1,    -1,    -1,    -1,
      -1,    -1,   251,    -1,   253,    -1,   492,   735,   257,   258,
     259,   260,   261,    -1,   263,   264,   265,   266,    66,   268,
     269,  1704,   271,   272,    -1,   274,   275,   276,   277,   278,
      78,   280,   281,   282,   283,   284,   285,    -1,    -1,   288,
      -1,    -1,   770,    -1,    -1,    -1,    -1,   296,    -1,    -1,
      -1,   537,   301,  1736,   782,   304,    -1,    -1,    -1,    -1,
     309,   310,    -1,    -1,   580,  1901,   315,   316,    -1,    -1,
      -1,   299,    -1,    -1,    -1,    -1,  2040,   125,    -1,    -1,
    2044,    -1,    -1,    -1,    -1,    -1,   814,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1931,    -1,    -1,    -1,    -1,
     148,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   599,    -1,    -1,    -1,   366,    -1,    -1,
      -1,    -1,    -1,    -1,   852,   374,    -1,    -1,   377,    -1,
     358,    -1,    -1,   382,    -1,    -1,    -1,   653,    -1,    -1,
      -1,   657,    -1,    -1,    -1,    -1,    -1,   875,    -1,    -1,
      -1,    -1,    -1,    -1,   882,    -1,    -1,  2121,   206,   408,
    2124,    -1,  2126,  2127,  2128,    -1,    -1,   416,    -1,   418,
     398,    -1,   421,    -1,    -1,   424,    -1,    -1,  2142,    -1,
     908,   430,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   440,    -1,    -1,    -1,    -1,    -1,   925,    -1,   927,
      -1,    -1,   930,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1901,    -1,
      -1,    -1,   738,    -1,   710,    -1,   712,   713,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   965,    -1,    -1,
      -1,    -1,   290,    -1,    -1,    -1,   732,    -1,  1931,    -1,
      -1,   737,    -1,    -1,    -1,    -1,    -1,   506,    -1,    -1,
      -1,    -1,    -1,   512,   492,   514,    -1,  1950,   517,    -1,
      -1,  1954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   799,   533,    -1,    -1,    -1,    -1,    -1,
     776,    -1,    -1,   542,    -1,  2259,    -1,   813,  2262,    -1,
      -1,    -1,   788,    -1,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,   562,   563,   564,   364,   566,   567,   568,
     569,   837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2295,    -1,    -1,    -1,    -1,  2300,   586,   587,   588,
      -1,    -1,  2306,  2307,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2040,    -1,    -1,
      -1,    -1,   611,   879,    -1,    -1,    -1,    -1,    -1,    -1,
    2053,   599,  2336,    -1,    -1,    -1,    -1,    -1,    -1,  2343,
    2344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2353,
      -1,  2355,    -1,    -1,    -1,    -1,    -1,   445,    -1,    -1,
      -1,   887,    -1,   652,   452,  2369,  2370,    -1,    -1,   658,
    2374,    -1,    -1,   929,   663,    -1,    -1,   666,   667,    -1,
      -1,    -1,    -1,  2259,    -1,   941,    -1,    -1,    -1,   477,
      -1,   947,    -1,   949,    -1,    -1,   685,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2130,    -1,    -1,
      -1,    -1,    -1,    -1,   703,    -1,    -1,   505,    -1,   708,
      -1,    -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,    -1,
      -1,  2307,   721,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   710,    -1,   712,   713,    -1,    -1,    -1,    -1,
      -1,   740,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   732,    -1,   755,    -1,    -1,   737,
      -1,    -1,   761,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,    -1,
     779,    -1,    -1,  2369,  2370,    -1,    -1,    -1,     6,    -1,
      -1,    -1,    10,    -1,   793,    -1,    -1,    -1,   776,    -1,
      -1,    -1,    -1,    -1,   803,   804,  2520,    -1,    -1,    -1,
     788,    29,    -1,   812,    -1,    -1,   815,    -1,  2251,  2252,
    2253,    -1,    -1,    -1,    42,    -1,    -1,    -1,    -1,     0,
       1,   830,    -1,    -1,     5,  2549,    -1,    -1,    -1,    -1,
      11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,
      -1,    -1,    -1,   852,  2568,   653,  2570,    28,    -1,   657,
      -1,    -1,    -1,    -1,   863,    -1,  2580,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2307,    -1,    -1,    -1,   877,    -1,
    2594,    -1,    -1,  2597,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   890,    -1,    -1,    -1,    -1,    -1,   896,    -1,    -1,
      -1,    -1,    -1,    -1,  2618,  2338,    -1,  2340,    -1,   887,
      -1,  2625,    -1,    -1,    -1,    -1,    -1,    -1,   136,    -1,
      -1,    -1,   921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,    -1,    -1,    -1,    -1,  2369,  2370,    -1,    -1,
     738,    -1,    -1,   942,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   953,    -1,    -1,    -1,    -1,   958,
      -1,   132,    -1,    -1,    -1,    -1,    -1,   966,    -1,    -1,
      -1,  2685,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   152,  2568,   201,  2570,   156,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2580,    -1,    -1,  2711,    -1,    -1,
      -1,   799,    -1,   174,    -1,    -1,    -1,    -1,  2594,    -1,
      -1,    -1,    -1,    -1,    -1,   813,    -1,  2731,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2618,    -1,    -1,    -1,    -1,   255,    -1,   837,
      -1,  2755,    -1,    -1,    -1,    -1,    -1,   218,    -1,    -1,
      -1,    -1,    -1,   224,    -1,   226,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,  2783,
      -1,    -1,    -1,    -1,    -1,    -1,  2790,    -1,    -1,    -1,
     251,   879,    -1,    -1,    -1,    -1,     0,     1,  2802,    -1,
      -1,     5,    -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    19,    -1,    -1,    -1,    -1,
      -1,   329,   330,    -1,    28,    -1,  2830,   288,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2711,    -1,    -1,    -1,    -1,
      -1,   929,    -1,   304,    -1,  2568,    -1,  2570,   309,    -1,
      -1,    -1,    -1,   941,   315,   316,    -1,  2580,    -1,   947,
      -1,   949,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2593,  2594,    -1,    -1,    -1,    -1,    -1,    -1,  2601,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2618,    -1,   101,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   366,   414,    -1,    -1,    -1,
      -1,    -1,    -1,   374,  2790,    -1,   377,    -1,    -1,    -1,
      -1,   382,    -1,    -1,    -1,    -1,  2802,    -1,   132,    -1,
      -1,   439,    -1,    -1,    -1,  2658,    -1,  2660,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,   152,    -1,
      -1,    -1,   156,    -1,  2830,   416,    -1,   418,    -1,    -1,
     421,    -1,   470,   424,    -1,    -1,    -1,    -1,    -1,    -1,
     174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   486,   440,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2710,  2711,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2725,    -1,  2727,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   218,    -1,    -1,    -1,    -1,    -1,
     224,    -1,   226,    -1,    -1,    -1,   230,    -1,    -1,    -1,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   551,    -1,   506,    -1,   251,    -1,    -1,
      -1,   512,    -1,   514,    -1,    -1,   517,    -1,  3062,    -1,
      -1,    -1,    -1,  3067,    -1,    -1,    -1,  2790,    -1,    -1,
      -1,    -1,   533,    -1,  2797,    -1,    -1,    -1,    -1,  2802,
      -1,    -1,    -1,    12,   288,   593,    -1,    -1,    -1,    18,
      -1,    -1,    -1,   601,    -1,    -1,    -1,    -1,    -1,    -1,
     304,    -1,    -1,    -1,    -1,   309,    -1,  2830,    -1,    -1,
      -1,   315,   316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   588,    -1,   637,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2864,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     611,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   669,   366,    -1,    -1,    -1,  2889,    -1,    -1,    -1,
     374,    -1,    -1,   377,  3178,    -1,   684,    -1,   382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3191,    -1,    -1,
      -1,   652,    -1,   701,    -1,  3199,    -1,   658,    -1,    -1,
      -1,    -1,   663,    -1,   408,   666,   667,    -1,    -1,    -1,
      -1,    -1,   416,    -1,   418,    -1,    -1,   421,  3222,    -1,
     424,    -1,    -1,    -1,   685,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   440,   166,    -1,    -1,
      -1,   749,   703,   172,   173,    -1,    -1,   708,   177,    -1,
      -1,   759,    -1,    -1,   715,    -1,    -1,   765,    -1,   188,
     721,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   740,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     798,    -1,    -1,    -1,   755,    -1,    -1,    -1,    -1,    -1,
     761,    -1,   506,    -1,    -1,    -1,    -1,    -1,   512,    -1,
     514,    -1,    -1,   517,    -1,  3191,    -1,    -1,   779,    -1,
      -1,    -1,    -1,  3199,    -1,    -1,    -1,    -1,    -1,   533,
      -1,    -1,   793,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   803,   804,   852,    -1,    -1,    -1,   856,    -1,
      -1,   812,    -1,    -1,   815,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3367,   872,   873,    -1,    -1,    -1,   830,
     299,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3385,    -1,    -1,   588,    -1,    -1,    -1,    -1,    -1,
      -1,   852,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   877,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,    -1,    -1,    -1,   890,
      -1,    -1,   361,   362,   363,   896,    -1,    -1,    -1,    -1,
    3163,    -1,  3165,    -1,   373,    -1,    -1,    -1,   652,    -1,
      -1,    -1,    -1,    -1,   658,    -1,    -1,    -1,    -1,   663,
     921,    -1,   666,   667,    12,    -1,    -1,    -1,  3191,    -1,
      18,   400,    -1,    -1,    -1,    -1,  3199,    -1,    -1,    -1,
      -1,   685,    -1,   412,    -1,    -1,    -1,    -1,  3211,  3493,
      -1,  3367,   953,    -1,    -1,    -1,    -1,   958,    -1,   703,
      -1,    -1,    -1,    -1,   708,   966,    -1,    -1,  3512,    -1,
      -1,   715,    -1,    -1,    -1,    -1,    -1,   721,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     459,   460,   461,    -1,    -1,    -1,   740,    -1,    -1,    -1,
     469,    -1,   471,    -1,    -1,    -1,    -1,    -1,  3271,   478,
      -1,   755,    -1,   482,   483,   484,    -1,   761,    -1,    -1,
      -1,    -1,   491,    -1,    -1,   494,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   779,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,  3589,    -1,    -1,    -1,   793,
      -1,  3595,    -1,  3597,    -1,    -1,    -1,    -1,    -1,   803,
     804,    -1,    -1,    -1,    -1,  3328,    -1,    -1,   812,  3613,
      -1,   815,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,   830,    31,    -1,    -1,
      -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,
     188,    -1,    -1,    -1,  3367,    -1,    -1,   576,   852,    -1,
      -1,    -1,    -1,    -1,   583,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   877,    -1,   604,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    -1,    -1,   890,    -1,    -1,  3693,
      -1,    -1,   896,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   921,    -1,    -1,
      -1,    -1,   126,    -1,    -1,    -1,    -1,   656,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   953,
     154,    -1,    -1,    -1,   958,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3504,   711,  3506,    -1,    -1,    -1,    -1,    -1,    -1,
    3794,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   215,    -1,   361,   362,   363,    -1,  3693,    -1,   223,
      -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3837,    -1,    -1,  3840,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,   784,    -1,    -1,    -1,   788,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3872,  3873,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   810,   811,    -1,   813,    -1,    -1,    -1,    -1,  3893,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,   320,   321,    -1,    -1,
      -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,   858,
     478,    -1,    -1,   862,   482,   483,   484,    -1,    -1,    -1,
      -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,    -1,
      -1,   880,    -1,    -1,    -1,    -1,   360,    -1,    -1,    -1,
      -1,  3837,   510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3693,    -1,   376,    -1,    -1,    -1,    -1,    -1,   907,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   915,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   943,    -1,    -1,    -1,   947,   948,
     949,    -1,    -1,    -1,    -1,   429,    -1,   431,   576,  4033,
      -1,    -1,  4036,    -1,    -1,   964,    -1,   441,    -1,    -1,
    4044,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,   453,
      -1,    -1,    -1,    -1,    -1,    -1,   604,    -1,    -1,    -1,
     464,   465,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   476,    -1,    -1,    31,    -1,    -1,    -1,    -1,
      -1,   485,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   656,    -1,
      -1,    67,    -1,    -1,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4020,    -1,  4150,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4165,    -1,   711,    -1,    -1,    -1,    -1,  4044,    -1,
     126,    -1,    -1,    -1,    -1,   579,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,   163,   164,   165,
      -1,    -1,   616,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   637,  4238,    -1,   784,    -1,    -1,    -1,
      -1,    -1,    -1,  4247,    -1,    -1,    -1,  4251,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,
      -1,    -1,   810,   811,    -1,    -1,    -1,   223,    -1,    -1,
      -1,    -1,    -1,   677,   230,    -1,    -1,   825,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4165,
     694,    -1,  4296,    -1,    -1,  4299,  4300,  4020,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   862,    -1,    -1,  4321,  4322,    -1,
      -1,  4044,    -1,    -1,    -1,    -1,    -1,    -1,   732,    -1,
      -1,   735,   880,    -1,    -1,    -1,  4340,    -1,    -1,  4343,
      -1,    -1,    -1,    -1,  4348,   749,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4362,   907,
      -1,    -1,    -1,    -1,   320,   321,   770,   915,    -1,    -1,
      -1,    -1,    -1,  4377,    -1,    -1,    -1,    -1,    -1,    -1,
     336,   785,    -1,    -1,  4388,    -1,    -1,    -1,  4392,   345,
     346,   347,   348,   349,    -1,   943,   352,   353,    -1,    -1,
      -1,   949,    -1,    -1,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   818,    -1,   964,    -1,    -1,    -1,
     376,    -1,    -1,    -1,    -1,    -1,  4430,    -1,    -1,  4433,
    4434,  4435,  4436,   389,    -1,    -1,    -1,    -1,    -1,  4443,
      -1,    -1,  4165,    -1,    -1,    -1,    -1,    -1,   852,    -1,
     406,    -1,  4456,    -1,    -1,    -1,    -1,   413,    -1,    -1,
      -1,    -1,    -1,    -1,  4340,    -1,    -1,    -1,    -1,    -1,
    4474,   875,    -1,   429,    -1,   431,    -1,    -1,   882,   883,
      -1,    -1,    -1,    -1,    -1,   441,    -1,  4491,    -1,    -1,
    4494,    -1,    -1,    -1,    -1,    -1,    -1,   453,    -1,    -1,
      -1,    -1,    -1,    -1,   908,    -1,    -1,    -1,   464,   465,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   923,
     476,   925,    -1,   927,    -1,    -1,   930,    -1,    -1,   485,
     934,    -1,    -1,    -1,  4538,  4539,  4540,  4541,  4542,  4543,
    4544,  4545,  4546,  4547,  4548,  4549,  4550,  4551,  4552,  4553,
    4554,  4555,  4556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   965,    -1,    -1,  4568,    -1,   522,    -1,    -1,    -1,
      -1,    -1,    -1,  4577,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4586,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4474,    -1,
      -1,    -1,    -1,    -1,  4608,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4620,  4340,    -1,    -1,
      -1,    -1,  4626,   579,    -1,    -1,    -1,    -1,  4632,  4633,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4646,    -1,   600,    -1,    -1,    -1,    -1,  4653,
    4654,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     616,    -1,  4666,  4667,    -1,   621,    -1,    -1,    -1,    -1,
      -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   637,  4686,    -1,     1,    -1,    -1,     4,   644,  4693,
      -1,    -1,    -1,    -1,    -1,    -1,  4700,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4717,    -1,    -1,    -1,  4721,  4722,    -1,
      -1,   677,    -1,  4727,    -1,  4729,  4730,    -1,    -1,    -1,
    4734,  4735,    -1,    -1,    -1,    -1,    -1,    -1,   694,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,  4775,    -1,    -1,    -1,    -1,   732,    -1,    -1,   735,
    4503,    -1,    -1,  4787,  4788,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   749,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4817,   770,    -1,   772,   773,   774,    -1,
     137,    -1,    -1,   140,   141,    -1,    -1,    -1,    -1,   785,
     147,    -1,  4836,  4837,    -1,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,   162,   163,   164,   165,    -1,
    4854,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4864,  4865,   818,    -1,    -1,  4869,    -1,    -1,    -1,    -1,
      -1,    -1,  4876,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,    18,
      -1,    -1,    -1,    -1,    -1,    -1,   852,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4787,  4788,   230,    -1,    -1,    -1,    -1,    -1,   875,
      -1,    -1,    -1,    -1,    -1,    -1,   882,   883,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   892,   893,   894,    -1,
      -1,  4817,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
      -1,    -1,   908,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,   923,    -1,   925,
      -1,   927,    -1,    -1,   930,    -1,    -1,    -1,   934,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   965,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,   346,
     347,   348,   349,    -1,    -1,   352,   353,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,
      -1,    -1,    -1,    -1,  4787,  4788,    -1,    -1,    -1,    -1,
     387,    -1,   389,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,  4817,    -1,   413,    -1,     6,    -1,
      -1,    -1,    10,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,
      -1,    29,     7,    -1,   441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    42,    -1,   453,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   464,    -1,   373,
      -1,    -1,    -1,   470,    -1,    -1,    -1,   474,    -1,   476,
      -1,    -1,    70,    48,    -1,    -1,    -1,    -1,   485,    -1,
      -1,   300,    -1,    -1,    -1,    -1,    61,    62,    63,    64,
      -1,    66,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    78,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    88,    -1,   522,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   535,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,   136,    -1,
      -1,    -1,   361,   362,   363,   459,   460,   461,    -1,    -1,
     125,    -1,    -1,    -1,   373,   130,   375,    -1,    -1,    -1,
      -1,    -1,   137,   138,   478,    -1,   141,    -1,   482,   483,
     484,    -1,   579,   148,    -1,    -1,    -1,   491,    -1,    -1,
     155,   400,   157,   158,   159,   160,   161,   162,   163,   164,
     165,    -1,    -1,   600,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,    -1,    -1,   616,
      -1,   186,    -1,    -1,   621,    -1,    -1,    -1,    -1,    -1,
     627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     637,   206,    -1,    -1,    -1,    -1,    -1,   644,    -1,    -1,
     459,   460,   461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     469,    -1,   471,    -1,    -1,   230,    -1,   255,    -1,   478,
      -1,    -1,   576,   482,   483,   484,    -1,    -1,    -1,    -1,
      -1,    -1,   491,    -1,    -1,   494,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   694,    -1,    -1,
      -1,   510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   290,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   299,    -1,    -1,    -1,   735,    -1,
      -1,   329,   330,    -1,    -1,   554,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   576,    -1,    -1,
      -1,   336,    -1,   770,    -1,   772,   773,   774,    -1,    -1,
     345,   346,   347,   348,   349,   782,    -1,   352,   353,    -1,
      -1,    -1,    -1,   358,    -1,   604,    -1,    -1,    -1,   364,
      -1,    -1,   367,    -1,   369,    -1,    -1,   711,    -1,    -1,
      -1,   376,    -1,    -1,    -1,    -1,    -1,   814,    -1,    -1,
      -1,   386,    -1,    -1,   389,    -1,   414,    -1,    -1,    -1,
      -1,    -1,    -1,   398,    -1,   400,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   656,   413,    -1,
      -1,   439,    -1,    -1,    -1,   852,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   431,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   441,    -1,   875,    -1,
     445,    -1,   470,    -1,    -1,   882,    -1,    -1,   453,    -1,
      -1,    -1,   457,    -1,    -1,   892,   893,   894,   486,    -1,
     709,    -1,   711,    -1,    -1,   470,   810,   811,    -1,   474,
      -1,   908,   477,   478,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,   925,   494,
     927,    -1,    -1,   930,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   949,    -1,    -1,    -1,    -1,   522,    -1,    -1,
      -1,    -1,    -1,   551,    -1,    -1,    -1,    -1,   965,    -1,
       1,    -1,   537,    -1,    -1,   784,   880,    -1,    -1,   544,
      -1,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,   810,   811,   907,    -1,   593,    -1,    -1,    -1,    -1,
      -1,   915,   577,   601,   579,    -1,   581,    -1,    -1,    -1,
      -1,    -1,    53,    54,    55,    56,    57,    58,    59,    60,
      -1,    -1,    -1,    -1,   599,   600,    -1,    -1,    -1,   943,
      -1,    -1,    -1,    -1,    -1,   949,    -1,    -1,    -1,   637,
      -1,   616,    -1,   862,    -1,    -1,   621,    -1,   623,   624,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   880,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   644,
      -1,   669,   647,    -1,    -1,    -1,    -1,    -1,   653,    -1,
      -1,   656,   657,    -1,    -1,    -1,   684,   128,   907,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   915,    -1,    -1,    -1,
      -1,    -1,    -1,   701,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   698,   943,   166,    -1,    -1,    -1,   948,
     949,   172,   173,    -1,    -1,   710,    -1,   712,   713,    -1,
      -1,    -1,    -1,    -1,    -1,   964,    -1,   188,    -1,    -1,
      -1,   749,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   759,   760,   738,    -1,    -1,    -1,   765,    -1,    -1,
     745,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   770,    -1,   772,   773,   774,
     798,   776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   784,
      -1,    -1,    -1,   788,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   799,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      12,    -1,    -1,    -1,    -1,    -1,    18,   822,    -1,    -1,
      -1,    -1,    -1,    -1,   852,    -1,    -1,   298,   856,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   847,    -1,   872,   873,   317,   852,    -1,    -1,
      -1,    -1,    -1,   858,    -1,    -1,    -1,   862,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     875,    -1,    -1,    -1,   879,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   887,    -1,    -1,    -1,    -1,   892,   893,   894,
     361,   362,   363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   373,   908,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   916,    -1,   384,   385,    -1,    -1,    -1,    -1,    -1,
     925,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   400,
      -1,    -1,    -1,    -1,    -1,    -1,   941,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   964,
     431,    -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,
     172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,    -1,   188,    -1,   459,   460,
     461,   462,   463,    -1,    -1,    -1,    -1,    -1,   469,    -1,
     471,    -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,   483,   484,    -1,     1,    -1,    -1,    -1,    -1,
     491,    -1,    -1,   494,    -1,    -1,    12,    -1,    -1,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    22,    23,    24,   510,
      -1,    -1,    -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,     1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   555,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   565,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   574,    -1,   576,    -1,    -1,    -1,    -1,
      -1,    -1,   583,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     591,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   604,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   128,    -1,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    -1,    -1,   626,    -1,    -1,    -1,   361,
     362,   363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   373,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,    -1,   656,   172,   173,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,   400,    -1,
      -1,    -1,   188,    -1,    -1,    12,    -1,    -1,    -1,    -1,
      -1,    18,    -1,    -1,    -1,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,   155,
      -1,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     711,    -1,    -1,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    -1,    -1,    -1,   459,   460,   461,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   469,    -1,   471,
      -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,   483,   484,    -1,    -1,    -1,    -1,    -1,    -1,   491,
      -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,   510,    -1,
      -1,    -1,   298,   784,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   128,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     316,   317,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   810,
     811,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   576,   361,   362,   363,   849,    -1,
     851,   188,   853,    -1,   855,    -1,   857,   373,   859,   860,
     861,   862,    -1,   864,   865,   866,    -1,    -1,   384,   385,
      -1,    -1,   604,    -1,    -1,    -1,    -1,    -1,    -1,   880,
      -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,   345,
     346,   347,   348,   349,    -1,    -1,   352,   353,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   915,   431,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   389,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   943,   459,   460,   461,   462,   463,   949,    -1,
      -1,    -1,    -1,   469,    -1,   471,    -1,   413,    -1,    -1,
      -1,   298,   478,   964,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,   494,   711,
     317,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   510,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,   555,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   384,   385,   565,
      -1,    -1,   784,    -1,    -1,    -1,    -1,    -1,   574,    -1,
     576,    -1,    -1,   400,    -1,    -1,   522,   583,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   591,    -1,    -1,   810,   811,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   604,    -1,
      -1,    -1,    -1,   825,   431,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     626,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   577,   459,   460,   461,   462,   463,    -1,    -1,    -1,
     862,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,
     656,   478,    -1,    -1,   600,   482,   483,   484,   880,     1,
      -1,    -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,
      12,    -1,    -1,    -1,    -1,   621,    18,    -1,    -1,    -1,
      22,    23,    24,   510,    -1,   907,    -1,    -1,    30,    -1,
      -1,    -1,    -1,   915,    -1,    -1,    -1,    -1,   644,    -1,
      -1,    -1,    -1,   530,    -1,   711,    -1,    -1,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    -1,
      -1,   943,    -1,    -1,    -1,    -1,    -1,   949,   555,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,    -1,
      -1,    -1,   964,    -1,    -1,    -1,    -1,   574,    -1,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   591,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   604,   784,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   626,
      -1,    -1,    -1,    -1,   810,   811,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    -1,   772,   773,   774,   656,
     172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   849,    -1,   851,   188,   853,    -1,    -1,
      -1,   857,    -1,   859,   860,   861,   862,    -1,   864,   865,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   880,     1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   711,    -1,    12,    -1,    -1,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    22,    23,    24,    -1,
      -1,   907,    -1,    -1,    30,    -1,    -1,    -1,    -1,   915,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,    -1,    -1,   943,    -1,    -1,
      -1,    -1,    -1,   949,    -1,    -1,   892,   893,   894,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   298,   784,   964,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    43,    -1,    -1,   317,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   810,   811,    -1,    -1,    -1,    -1,    -1,
      61,    62,    63,    64,    -1,    -1,    -1,    -1,    69,    -1,
      -1,    -1,   128,   949,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,   361,
     362,   363,   849,    -1,   851,    -1,   853,    -1,    -1,    -1,
     857,   373,   859,   860,   861,   862,    -1,   864,   865,    -1,
     166,    -1,   384,   385,    -1,    -1,   172,   173,    -1,    -1,
      -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,   400,    -1,
      -1,    -1,   188,    -1,    -1,    -1,   137,   138,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     907,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   915,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   177,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   943,   459,   460,   461,
     462,   463,   949,    -1,    -1,    -1,    -1,   469,    -1,   471,
      -1,    -1,    -1,    -1,    -1,    -1,   478,   964,    -1,    -1,
     482,   483,   484,    -1,    -1,    -1,    -1,    -1,    -1,   491,
      -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   510,    -1,
      -1,    -1,   298,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,
      -1,   317,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
      -1,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   555,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,    -1,   565,    -1,    -1,    -1,    -1,   299,    -1,
      -1,    -1,   574,    -1,   576,   361,   362,   363,    -1,    -1,
      -1,   583,    -1,    -1,    -1,    -1,    -1,   373,    -1,   591,
      -1,    -1,   594,    -1,    -1,    -1,    -1,    -1,   384,   385,
      -1,    -1,   604,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   626,    -1,    -1,   358,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   398,    -1,    -1,
      -1,    -1,    -1,   459,   460,   461,   462,   463,    -1,    -1,
      -1,    -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,   494,   711,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   510,    -1,    -1,    -1,    -1,    -1,
      -1,   361,   362,   363,    -1,    -1,    -1,    -1,    -1,   470,
      -1,    -1,    -1,   373,   530,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   555,
     400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,
     511,    -1,   784,    -1,    -1,    -1,    -1,    -1,   574,    -1,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   591,    -1,   538,   810,   811,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   604,    -1,
      -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,    18,
      -1,   461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   849,   478,   851,
      -1,   853,   482,   483,   484,   857,    -1,   859,   860,   861,
     862,   491,   864,   865,   494,    -1,    -1,    -1,   599,    -1,
     656,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   623,   624,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   915,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   711,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   943,    -1,    -1,    -1,    -1,   576,   949,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,   710,
      -1,   712,   713,   172,   173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   784,   188,
      -1,   732,    -1,    -1,    -1,    -1,   737,    -1,     3,    -1,
      -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    13,    -1,
      -1,    -1,    17,    -1,   810,   811,   656,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   776,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    49,    50,    -1,   788,    -1,    -1,
      -1,    -1,    -1,   849,    -1,   851,    -1,   853,    -1,    -1,
      -1,   857,    -1,   859,   860,   861,   862,    -1,   864,   865,
      -1,   711,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    -1,    -1,   880,    -1,    91,    92,    93,    -1,
      95,    96,    -1,    -1,    -1,   100,    -1,    -1,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   907,   117,   118,    -1,    -1,    -1,    -1,    -1,   915,
      -1,    -1,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,
     145,   146,    -1,    -1,   784,    -1,   887,   943,    -1,    -1,
      -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,    -1,    -1,
     901,    -1,   361,   362,   363,    -1,    -1,    -1,   964,    -1,
     810,   811,    -1,    -1,   373,   180,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,    -1,    -1,   200,    -1,   202,   203,    -1,
      -1,   400,    -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,
      -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   862,    -1,    -1,    -1,   231,   232,    -1,    -1,
     235,   236,    -1,   238,   239,   240,   241,   242,    -1,    -1,
     880,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,
     459,   460,   461,    -1,    -1,    -1,    -1,   907,    -1,    -1,
     469,    -1,   471,    -1,    -1,   915,    -1,    -1,    -1,   478,
      -1,   286,   287,   482,   483,   484,   291,    -1,    -1,    -1,
      -1,    -1,   491,    -1,    -1,   494,    -1,   302,    -1,    -1,
      -1,   306,    -1,   943,    -1,    -1,    -1,   312,   313,   949,
      -1,   510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   964,    -1,   331,   332,   333,   334,
     335,    -1,    -1,   338,    -1,    -1,    -1,   342,   343,   344,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     365,    -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   378,   379,   380,   381,   576,    -1,    -1,
      -1,    -1,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,   397,    -1,   399,    -1,   401,   402,   403,    -1,
      -1,    -1,    -1,    -1,    -1,   604,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   422,   423,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   432,   433,   434,
     435,   436,   437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   446,    -1,    -1,    -1,   450,    -1,    -1,    -1,   454,
      -1,   456,    -1,   458,    -1,    -1,    -1,   656,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   488,   489,   490,    -1,    -1,   493,    -1,
      -1,    -1,   497,    -1,   499,   500,   501,   502,    -1,    -1,
      -1,    -1,    -1,    -1,   509,    -1,    -1,    -1,    -1,    -1,
     515,    -1,   711,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   526,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   534,
      -1,    -1,    -1,    -1,   539,   540,   541,    -1,   543,    -1,
     545,   546,    -1,   548,   549,   550,    -1,    -1,    -1,    -1,
     555,   556,    -1,   558,   559,   560,   561,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   570,   571,    -1,    -1,   574,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   582,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   784,    -1,    -1,    -1,    -1,
      -1,    -1,   597,   598,    -1,    -1,    -1,    -1,    -1,    -1,
     605,   606,    -1,   608,    -1,    -1,    -1,   612,    -1,    -1,
      -1,   810,   811,    -1,   619,    -1,    -1,    -1,    -1,    -1,
     625,    -1,    -1,    -1,   629,    -1,   631,   632,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     645,    -1,    -1,   648,   649,    -1,    -1,    -1,    -1,   654,
      -1,    -1,    -1,    -1,   659,    -1,    -1,    -1,    -1,    -1,
     665,    -1,    -1,   862,    -1,   670,    -1,   672,   673,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   681,   682,    -1,     1,
      -1,   880,    -1,     5,    -1,    -1,    -1,    -1,    -1,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,   704,
     705,   706,    -1,    -1,    -1,    -1,    28,    -1,   907,    -1,
      -1,    -1,    -1,   718,   719,   720,   915,    -1,    -1,   724,
     725,   726,   727,   728,   729,    -1,    -1,    -1,   733,   734,
      -1,    -1,    -1,    -1,    -1,    -1,   741,   742,    -1,    -1,
      -1,    -1,    -1,    -1,   943,   750,   751,   752,   753,    -1,
     949,    -1,    -1,   758,    -1,    -1,    -1,    -1,   763,    -1,
      -1,   766,   767,   768,   769,   964,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   781,    -1,    -1,   101,
     102,   786,   787,    -1,    -1,    -1,    -1,    -1,    -1,   794,
     795,    -1,   797,    -1,    -1,   800,    -1,    -1,    -1,    -1,
      -1,   806,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   823,   824,
      -1,    -1,   827,    -1,    -1,    -1,    -1,   832,    -1,    -1,
     152,    -1,    -1,    -1,   156,   840,   841,   842,    -1,    -1,
      -1,   846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,   876,    -1,   878,    11,    -1,    -1,   882,    -1,    -1,
      -1,    -1,    19,   888,    -1,    -1,    -1,    -1,    -1,    -1,
     895,    28,    -1,    -1,    -1,    -1,   218,    -1,    -1,    -1,
      -1,   906,   224,    -1,   226,   910,   911,   912,   230,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   926,    -1,    -1,    -1,    -1,   931,   932,   933,   251,
     935,   936,   937,   938,   939,    -1,    -1,    -1,    -1,    -1,
     945,   946,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   957,    -1,    -1,    -1,   961,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   304,    -1,    -1,    -1,    -1,   309,    -1,    -1,
      -1,    -1,    -1,   315,   316,   132,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   152,    -1,    -1,    -1,   156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   174,    -1,    -1,
      -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   374,    -1,    -1,   377,    -1,    -1,    12,    -1,
     382,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   218,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    -1,   230,   416,    -1,   418,   234,    -1,   421,
      -1,    -1,   424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,   440,    -1,
      -1,   258,   259,   260,   261,    -1,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,    -1,
      -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   304,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   315,   316,
      -1,    -1,    -1,    -1,   506,    -1,    -1,    -1,    -1,    -1,
     512,    -1,   514,    -1,    -1,   517,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   533,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   366,
      -1,    -1,    -1,    -1,   188,    -1,    -1,   374,    -1,    -1,
     377,    -1,    -1,    -1,    -1,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   588,    -1,    -1,    -1,
      -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,
      -1,   418,    -1,    -1,   421,    -1,    -1,   424,    -1,   611,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     652,    -1,    -1,    -1,    -1,    -1,   658,    -1,    -1,    -1,
      -1,   663,    -1,    -1,   666,   667,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   685,    -1,    -1,    -1,    -1,    -1,   506,
      -1,    -1,    -1,    -1,    -1,   512,    -1,   514,    -1,    -1,
     517,   703,    -1,    -1,    -1,    -1,   708,    -1,    -1,    -1,
      -1,    -1,    -1,   715,    -1,    -1,   533,    -1,    -1,   721,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   740,   373,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   755,    -1,    -1,    -1,    -1,    -1,   761,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
      -1,   588,    -1,    -1,    -1,    -1,    -1,   779,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   793,    -1,    -1,   611,    -1,    -1,    -1,    -1,    -1,
      -1,   803,   804,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     812,    -1,    -1,   815,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   459,   460,   461,   830,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,    -1,   663,    -1,   482,   483,
     484,    -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   685,    -1,
      -1,    -1,    -1,    -1,    -1,   877,   510,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   890,    -1,
      -1,   708,    -1,    -1,   896,    -1,    -1,    -1,   715,    -1,
      -1,    -1,    -1,    -1,   721,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,   921,
      18,    -1,    -1,   740,    -1,    -1,    -1,    -1,    -1,     9,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,   576,    -1,   761,    -1,    -1,    -1,    -1,   583,
      -1,   953,    -1,    -1,    -1,    -1,   958,    -1,    -1,    -1,
      -1,    -1,   779,    -1,    -1,    -1,    -1,    -1,    -1,    49,
     604,    -1,    -1,    -1,    -1,    -1,   793,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   803,   804,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   812,    -1,    -1,   815,    79,
      80,    81,    82,    83,    84,    85,    86,    -1,    -1,    -1,
      -1,    -1,    -1,   830,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,   656,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,   852,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,
     877,    -1,   142,   143,   144,    -1,   146,    -1,   166,    -1,
      -1,    -1,    -1,   890,   172,   173,    -1,   711,    -1,   896,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,    -1,    -1,
      -1,    -1,   202,   203,    -1,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    -1,    -1,   953,    -1,    -1,    -1,
      -1,   958,   776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     784,   231,   232,    -1,    -1,   235,   236,    -1,    -1,    -1,
     240,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   810,   811,    -1,    -1,
      -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,    -1,    -1,
     155,   291,   157,   158,   159,   160,   161,   162,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,   306,    -1,   862,    -1,
      -1,    -1,   312,   313,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,
      -1,   331,   332,   333,   334,   335,    -1,   891,   338,    -1,
      -1,    -1,    -1,   361,   362,   363,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   907,    -1,   373,    -1,    -1,    -1,    -1,
      -1,   915,    -1,    -1,    -1,   230,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,   379,
     380,   381,   400,    -1,    -1,    -1,    -1,   387,   388,   943,
     390,    -1,   392,   393,   394,   949,    -1,   397,    -1,   399,
      -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,
     964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   422,   423,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   432,   433,   434,   435,   436,   437,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,   446,    -1,    -1,    -1,
     450,   469,    -1,   471,   454,    -1,    -1,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,    -1,
      -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,    -1,
     345,   346,   347,   348,   349,    -1,    -1,   352,   353,    -1,
      -1,    -1,   510,   493,    -1,    -1,    -1,   497,    -1,   499,
     500,   501,   502,    -1,    -1,    -1,    -1,    -1,    -1,   509,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   389,    -1,   526,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   534,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,
      -1,    -1,    -1,    -1,    -1,   555,    -1,    -1,   576,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     570,   571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   604,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   605,    -1,    -1,   608,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   619,
      -1,    -1,    -1,    -1,    -1,   625,    -1,    -1,    -1,   629,
      -1,   631,   632,    -1,    -1,    -1,    -1,    -1,   656,    -1,
      -1,    -1,    -1,    -1,    -1,   645,    -1,    -1,   648,   649,
      -1,    -1,    -1,    -1,   654,    -1,    -1,   522,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     670,    -1,   672,   673,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   681,   682,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   711,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   704,   705,   706,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   724,   725,   726,   727,    -1,   729,
      -1,    -1,    -1,   733,   734,   600,    -1,    -1,    -1,    -1,
      -1,   741,   742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     750,   751,   752,    -1,    -1,    -1,   621,    -1,   758,    -1,
      -1,    -1,    -1,   763,    -1,    -1,   784,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   644,
      -1,   781,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      17,    -1,   810,   811,   794,   795,    -1,    -1,    -1,    -1,
     800,    -1,    -1,    -1,    -1,    -1,   806,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    49,   823,   824,    -1,    -1,    -1,    -1,   847,
      -1,    -1,   832,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     840,    -1,    -1,    -1,   862,    -1,   846,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      -1,    -1,   880,    -1,    -1,    -1,    -1,    -1,    95,    -1,
      -1,    -1,    -1,   100,    -1,    -1,   876,    -1,    -1,    -1,
      -1,    -1,   882,    -1,   111,   112,   113,   114,    -1,   907,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   915,    -1,    -1,
      -1,    -1,   129,    -1,    -1,    -1,    -1,   772,   773,   774,
      -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,
      -1,    -1,    -1,    -1,    -1,   943,   926,    -1,    -1,    -1,
      -1,   949,    -1,   933,    -1,   935,    -1,    -1,   938,    -1,
      -1,    -1,    -1,    -1,    -1,   945,   964,    -1,    -1,    -1,
      -1,    -1,    -1,   180,    -1,    -1,    -1,   957,    -1,    -1,
      -1,   961,   189,   190,   191,   192,   193,   194,   195,   196,
      -1,    -1,    -1,    -1,    -1,   202,   203,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,   232,    -1,    -1,   235,   236,
      -1,    -1,    -1,   240,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   892,   893,   894,
      -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     287,    -1,    -1,    -1,   291,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   306,
      -1,    -1,    -1,    -1,    -1,   312,   313,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   331,   332,   333,   334,   335,    -1,
      -1,   338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   378,   379,   380,   381,    -1,    -1,    -1,    -1,    -1,
     387,   388,    -1,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,   399,    -1,    -1,    -1,   403,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   422,   423,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   432,   433,   434,   435,   436,
     437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   446,
      -1,    -1,    -1,   450,   451,    -1,    -1,   454,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   493,    -1,    -1,    -1,
     497,    -1,   499,   500,   501,   502,    -1,    -1,    -1,    -1,
      -1,    -1,   509,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      12,    -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,   526,
      22,    23,    24,    -1,    -1,    -1,    -1,   534,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    -1,
      -1,    -1,    -1,   570,   571,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   605,    -1,
      -1,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   619,    -1,    -1,    -1,    -1,    -1,   625,    -1,
      -1,    -1,   629,    -1,   631,   632,   128,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   645,    -1,
      -1,   648,   649,    -1,    -1,    -1,    -1,   654,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   670,   166,   672,   673,    -1,    -1,    -1,
     172,   173,    -1,    -1,   681,   682,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   704,   705,   706,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   724,   725,   726,
     727,    -1,   729,    -1,    -1,    -1,   733,   734,    -1,    -1,
      -1,    -1,    -1,    -1,   741,   742,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   750,   751,   752,    -1,    -1,    -1,    -1,
      -1,   758,    -1,    -1,    -1,    -1,   763,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   781,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   794,   795,    -1,
      -1,    -1,    -1,   800,    -1,    -1,   298,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   317,   823,   824,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   832,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   840,    -1,    -1,    -1,    -1,    -1,   846,
      -1,    -1,    -1,    -1,    -1,    -1,    12,    -1,    -1,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    22,    23,    24,   361,
     362,   363,    -1,    -1,    30,    -1,    -1,    -1,    -1,   876,
      -1,   373,    -1,    -1,    -1,   882,    -1,    -1,    -1,    -1,
      -1,    -1,   384,   385,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,    -1,    -1,    -1,   400,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   926,
      -1,    -1,    -1,    -1,    -1,    -1,   933,    -1,   935,   431,
      -1,   938,    -1,    -1,    -1,    -1,    -1,    -1,   945,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     957,    -1,    -1,    -1,   961,    -1,    -1,   459,   460,   461,
     462,   463,   128,    -1,    -1,    -1,    -1,   469,    -1,   471,
      -1,    -1,    -1,    12,    -1,    -1,   478,    -1,    -1,    18,
     482,   483,   484,    -1,    -1,    -1,    -1,    -1,    -1,   491,
      -1,    30,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,   172,   173,   510,    -1,
      -1,    -1,    -1,    -1,    53,    54,    55,    56,    57,    58,
      59,    60,   188,    -1,    -1,    -1,    -1,    -1,   530,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   555,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   565,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   574,    -1,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   591,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   604,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,
      -1,    18,    -1,    -1,   626,    -1,    -1,   166,    -1,    -1,
      -1,    -1,   298,   172,   173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    43,    -1,    -1,   188,
      -1,   317,    -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,    -1,    -1,
      -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    88,    -1,    -1,    -1,   361,   362,   363,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,   711,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   384,   385,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,
     137,   138,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,    -1,   317,    -1,
     177,    -1,   784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,   459,   460,   461,   462,   463,    -1,    -1,
      -1,    -1,    -1,   469,    -1,   471,    -1,    -1,   810,   811,
      -1,    -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,   361,   362,   363,   491,    -1,    -1,   494,    -1,
      -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   510,    -1,    -1,   849,    -1,   851,
      -1,   853,    -1,    -1,    -1,   857,    -1,   859,   860,   861,
     862,   400,   864,   865,   530,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   555,
      -1,    -1,   431,    -1,    -1,    -1,    -1,    -1,    -1,   565,
      -1,    -1,   299,    -1,    -1,   907,    -1,    -1,   574,    -1,
     576,    -1,    -1,   915,    -1,    -1,    -1,   583,    -1,    -1,
     459,   460,   461,    -1,    -1,   591,    -1,    -1,    -1,    -1,
     469,    -1,   471,    -1,    -1,    -1,    -1,    -1,   604,   478,
      -1,   943,    -1,   482,   483,   484,    -1,   949,    -1,    -1,
      12,    -1,   491,    -1,    -1,   494,    18,    -1,    -1,    -1,
     626,   358,   964,    -1,   361,   362,   363,    -1,    -1,    -1,
      -1,   510,    -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     656,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    12,    -1,
      -1,   398,    -1,   400,    18,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   555,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    -1,   576,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   711,    -1,    -1,    -1,    -1,
      -1,    -1,   591,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   459,   460,   461,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   469,   470,   471,    -1,    -1,    -1,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,
      -1,    -1,    -1,    -1,   491,   492,    -1,   494,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,   171,
     172,   173,    -1,   510,   511,    -1,    -1,   656,   784,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   538,    -1,    -1,   810,   811,    -1,    -1,    12,    -1,
      -1,    -1,   166,    -1,    18,    -1,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   711,    -1,   188,    -1,    -1,    -1,    -1,   576,
      -1,    -1,    -1,   849,    -1,   851,    -1,   853,    -1,    -1,
      -1,   857,    -1,   859,   860,   861,   862,    -1,   864,   865,
      -1,    -1,   599,    -1,    -1,    -1,    -1,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   623,   624,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   907,    -1,    -1,    -1,   784,    -1,    -1,    -1,   915,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   656,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   810,   811,    -1,   288,    -1,    -1,   943,    -1,    -1,
      -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   964,   361,
     362,   363,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
     849,   373,   851,   710,   711,   712,   713,    -1,    -1,    -1,
      -1,   860,   861,   862,   188,   864,   865,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   732,    -1,    -1,   400,    -1,
     737,   880,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   915,    -1,    -1,   776,
      -1,    -1,    -1,    -1,    -1,    -1,   400,   784,    -1,    -1,
      -1,   788,    -1,    -1,    -1,    -1,    -1,   459,   460,   461,
      -1,    -1,    -1,    -1,   943,    -1,    -1,   469,    -1,   471,
     949,    -1,    -1,   810,   811,    -1,   478,    -1,    -1,    -1,
     482,   483,   484,    -1,    -1,   964,    -1,    -1,    -1,   491,
      -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   459,   460,   461,   510,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,   862,    -1,    -1,   482,   483,
     484,    -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,   880,    -1,    -1,    -1,    -1,    -1,    -1,
     887,    -1,    -1,    -1,    -1,    -1,   510,   361,   362,   363,
      -1,    -1,    -1,    -1,   901,    -1,    12,    -1,    -1,   373,
     907,    -1,    18,    -1,   576,    -1,    -1,    -1,   915,    -1,
      -1,   583,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    12,   400,    -1,    -1,    -1,
      -1,    18,   604,    -1,    -1,    -1,   943,    -1,    -1,    -1,
      -1,   948,   949,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   576,    -1,    -1,    -1,    -1,   964,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,
     604,    -1,    -1,    -1,   656,   459,   460,   461,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,   679,   482,   483,
     484,    -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   656,    -1,    -1,    -1,   510,    -1,    -1,   711,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,   711,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,   576,    -1,   776,    -1,    -1,    -1,    -1,   583,
      -1,    -1,   784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
     604,    -1,   172,   173,    -1,    12,    -1,    -1,   810,   811,
      -1,    18,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,   776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   656,    -1,    -1,    -1,   810,   811,    -1,    -1,
     862,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   891,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   855,    -1,    -1,    -1,   907,    -1,   711,   862,    -1,
      -1,    -1,   866,   915,    -1,   361,   362,   363,    -1,    -1,
      -1,   367,    -1,   925,    -1,    -1,   880,   373,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   943,    -1,    -1,   361,   362,   363,   949,    -1,    -1,
      -1,    -1,    -1,   907,   400,    -1,   373,    -1,    -1,   166,
      -1,   915,   964,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,
     784,   188,    -1,   400,    -1,    -1,    -1,    -1,    -1,   943,
      -1,   361,   362,   363,    -1,   949,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   373,    -1,    -1,   810,   811,    -1,    -1,
     964,    -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,
     400,    -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,   459,   460,   461,   491,    -1,    -1,   494,    -1,
      -1,    -1,   469,    -1,   471,    -1,    -1,    -1,   862,    -1,
      -1,   478,    -1,    -1,   510,   482,   483,   484,    -1,    -1,
      -1,    -1,    -1,    -1,   491,    -1,   880,   494,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   459,
     460,   461,    -1,   510,    -1,    -1,    -1,    -1,    -1,   469,
      -1,   471,    -1,   907,    -1,    -1,    -1,    -1,   478,    -1,
      -1,   915,   482,   483,   484,    -1,    -1,    -1,    -1,    -1,
      -1,   491,    -1,    -1,   494,    -1,   166,    -1,    -1,    -1,
     576,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,   943,
     510,    -1,    -1,    -1,    -1,   949,    -1,    -1,   188,    -1,
      -1,    12,    -1,    -1,   361,   362,   363,    18,   604,   576,
     964,    -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   604,    -1,    -1,
      -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   576,    -1,    -1,    -1,
     656,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    12,
      -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   604,    -1,    -1,    -1,    -1,   656,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   469,    -1,   471,   711,    -1,    -1,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,
      -1,    -1,    -1,    -1,   491,    -1,   656,   494,    -1,    -1,
      -1,    -1,    -1,    -1,   711,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   166,    -1,    -1,    -1,    -1,
      -1,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   361,   362,   363,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,    -1,   373,    -1,    -1,    -1,    -1,   784,    -1,
      -1,   711,    -1,    -1,    -1,   552,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     400,    -1,    -1,    -1,   810,   811,    -1,   784,    -1,   576,
      -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,
     173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   810,   811,   188,    18,   604,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   776,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   784,    -1,   862,    -1,    -1,   459,
     460,   461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   469,
      -1,   471,    -1,    -1,   880,    -1,    -1,    -1,   478,    -1,
     810,   811,   482,   483,   484,   862,    -1,   864,    -1,   656,
      -1,   491,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,
      -1,   907,    -1,   880,    -1,    -1,    -1,    -1,    -1,   915,
     510,    -1,    18,    -1,    -1,    -1,    98,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     907,    -1,   862,    -1,    -1,    -1,    -1,   943,   915,    -1,
     361,   362,   363,   949,   711,    -1,    -1,    -1,    -1,    -1,
     880,    -1,   373,    -1,    -1,    -1,    -1,    -1,   964,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   943,    -1,    -1,    -1,
      -1,    -1,   949,    -1,    -1,    -1,   576,   907,    -1,   400,
      -1,    -1,    -1,    -1,   166,   915,    -1,   964,    -1,    -1,
     172,   173,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   604,    -1,   188,    -1,   361,   362,
     363,    -1,    -1,   943,    -1,    -1,    -1,   784,    -1,   949,
     373,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   964,    -1,    -1,    -1,   459,   460,
     461,    -1,    -1,   810,   811,    -1,    -1,   400,   469,    -1,
     471,    -1,    -1,    -1,    -1,    -1,   656,   478,    -1,    -1,
     166,   482,   483,   484,    -1,    -1,   172,   173,    -1,    -1,
     491,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,   510,
      -1,    -1,    -1,    -1,    -1,   862,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   459,   460,   461,    -1,
      -1,   711,    -1,   880,    -1,    -1,   469,    -1,   471,    -1,
      -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
     483,   484,    -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,
     907,   494,    -1,    -1,    -1,    -1,    -1,    -1,   915,    -1,
      -1,    -1,    -1,    -1,    -1,   576,    -1,   510,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   943,   359,    -1,   361,
     362,   363,   949,   604,   784,    -1,    -1,    -1,    -1,    -1,
      -1,   373,    -1,    -1,    -1,    -1,    -1,   964,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     810,   811,    -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,
      -1,    -1,    -1,   576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   656,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   849,
      -1,   604,    -1,   359,    -1,   361,   362,   363,    -1,    -1,
      -1,    -1,   862,    -1,    -1,    -1,    -1,   373,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   459,   460,   461,
     880,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     711,    -1,    -1,    -1,   400,    -1,   478,    -1,    -1,    -1,
     482,   483,   484,   656,    -1,    -1,    -1,   907,    -1,   491,
      -1,    -1,   494,    -1,    -1,   915,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   943,    -1,    -1,    -1,    -1,    -1,   949,
      -1,    -1,    -1,   459,   460,   461,    -1,    -1,   711,    -1,
      -1,    -1,    -1,   784,   964,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,   483,   484,    -1,
      -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,   494,   810,
     811,    -1,    -1,    -1,   576,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,
      -1,   784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   862,    -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   810,   811,   880,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    -1,    -1,    -1,
     576,    -1,    -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,
      -1,    -1,    -1,    78,   915,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    93,   862,
      -1,    96,    -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,   943,    -1,    -1,    -1,    -1,   880,   949,   711,
     115,    -1,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   964,    -1,    -1,    -1,    -1,    -1,    -1,
     656,    -1,    -1,    -1,   907,    -1,    -1,    -1,    -1,    -1,
     145,    -1,   915,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     943,    -1,    -1,    -1,    -1,    -1,   949,    -1,    -1,    -1,
      -1,    -1,   784,    -1,    -1,   711,    67,    -1,    -1,    -1,
      -1,   964,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,   810,   811,
      -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   833,    -1,   238,   239,    -1,   241,   242,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   784,    -1,
     862,    -1,    -1,    -1,    -1,    -1,    -1,    54,    -1,    -1,
      -1,    -1,    -1,   154,    -1,    -1,    -1,    -1,   880,    -1,
      -1,   286,    -1,    -1,   810,   811,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   897,    -1,   302,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   907,    -1,   833,    -1,    -1,
      -1,    -1,    -1,   915,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   930,    -1,
      -1,    -1,    -1,    -1,   215,    -1,   862,   342,   343,   344,
      -1,   943,   223,    -1,    -1,    -1,   948,   949,    -1,    -1,
      -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,    -1,
     365,    -1,   964,    -1,    -1,   370,    -1,    -1,    -1,    -1,
      -1,   897,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,   907,    -1,    -1,    -1,   172,   173,    -1,    -1,   915,
     395,   396,    -1,    -1,    -1,    -1,   401,   402,    -1,    -1,
      -1,   188,    -1,    -1,   930,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   943,    -1,    -1,
      -1,    -1,   948,   949,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   964,   320,
     321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   456,    -1,   458,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   360,
      -1,    -1,    -1,   488,   489,   490,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   406,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   539,   540,   541,    -1,   543,    -1,
     545,   546,    -1,   548,   549,   550,    -1,    -1,   429,    -1,
     431,   556,    -1,   558,   559,   560,   561,    -1,    -1,    -1,
     441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   574,
      -1,    -1,   453,    -1,   361,   362,   363,   582,    -1,    -1,
      -1,    -1,    -1,   464,   465,    -1,   373,    -1,    -1,    -1,
      -1,    -1,   597,   598,    -1,   476,    -1,    -1,    -1,    -1,
      -1,   606,    -1,    -1,   485,    -1,    -1,   612,    -1,    -1,
      -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    61,    62,    63,    64,    -1,    -1,    -1,    -1,    69,
      -1,    -1,    -1,    -1,   659,    -1,    -1,    -1,    -1,    -1,
     665,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,
      -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   469,    -1,   471,    -1,    -1,    -1,   108,    -1,
      -1,   478,    -1,    -1,    -1,   482,   483,   484,   579,    -1,
      -1,    -1,    -1,    -1,   491,    -1,    -1,   494,    -1,    -1,
     130,    -1,    -1,   718,   719,   720,    -1,   137,   138,    -1,
      -1,   141,    -1,   728,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   616,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   627,    -1,   753,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   637,    -1,    -1,    -1,
      -1,   766,   767,   768,   769,    -1,   186,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   786,   787,    -1,    -1,    48,    -1,    -1,    -1,   576,
      -1,    -1,   797,    -1,    -1,    -1,   677,    -1,    61,    62,
      63,    64,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,
      -1,    -1,    -1,   694,    -1,    -1,    -1,   604,    -1,    -1,
      -1,    -1,   827,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   841,   842,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,
      -1,   732,    -1,    -1,   735,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,   749,   656,
      -1,    -1,    -1,   878,   137,   138,    -1,    -1,   141,   299,
      -1,    -1,    -1,   888,    -1,    -1,    -1,    -1,    -1,   770,
     895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   906,    -1,    -1,   785,   910,   911,   912,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   711,    -1,   931,   932,    -1,    -1,
      -1,   936,   937,    -1,   939,    -1,    -1,   818,   358,    -1,
      -1,   946,    -1,    -1,    -1,    -1,    -1,   367,    -1,   369,
      -1,    -1,    54,    -1,    -1,    -1,   376,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   386,    -1,    -1,    -1,
      -1,   852,    -1,    -1,    -1,    -1,    -1,    -1,   398,    -1,
     400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   875,    -1,    -1,   784,    -1,    -1,
      54,   882,   883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   441,    -1,   810,   811,    -1,    -1,   908,    -1,    -1,
      -1,    -1,    -1,   453,    -1,    -1,   299,   457,    -1,    -1,
      -1,    -1,   923,    -1,   925,    -1,   927,    -1,    -1,   930,
     470,    -1,    -1,   934,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   849,    -1,   166,    -1,    -1,    -1,    -1,    -1,
     172,   173,   492,   860,   494,   862,    -1,   864,   865,    -1,
      -1,    -1,    -1,    -1,   965,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,   880,    -1,   358,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,   166,   376,    -1,    -1,    -1,   537,   172,   173,
     907,    -1,    -1,   386,   544,    -1,    -1,    -1,   915,    -1,
      -1,    -1,    -1,    -1,   188,   398,    -1,   400,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   943,    54,    -1,   579,
      -1,   581,   949,    -1,    -1,    -1,    -1,    -1,   431,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   964,   441,   599,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     453,    -1,    -1,    -1,   457,    -1,   616,    -1,    -1,    -1,
      -1,    -1,    -1,   623,   624,    -1,    -1,   470,    -1,    -1,
      -1,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,    -1,   492,
      -1,   494,    -1,    -1,    -1,    -1,   656,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,
     362,   363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,   373,    -1,    -1,   537,   172,   173,    -1,   698,    -1,
      -1,   544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     710,   188,   712,   713,    -1,    -1,    -1,    -1,   400,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    -1,   579,    -1,   581,   373,
      -1,    -1,    -1,    -1,    -1,   745,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   599,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
     770,    -1,    -1,   616,    -1,    -1,   776,   459,   460,   461,
     623,   624,    -1,    -1,   784,    -1,    -1,   469,   788,   471,
      -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,   483,   484,    -1,   647,    -1,    -1,    -1,    -1,   491,
      -1,    -1,   494,   656,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   822,    -1,    -1,   459,   460,   461,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,   847,   482,   483,
     484,    -1,   852,    -1,    -1,   698,    -1,   491,   858,    -1,
     494,    -1,   862,    -1,    -1,    -1,    -1,   710,    -1,   712,
     713,    -1,    -1,    -1,    -1,   875,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   361,   362,   363,   887,    -1,    -1,
      -1,    -1,    -1,    -1,   576,    -1,   373,    -1,    -1,    -1,
      -1,    -1,   745,    -1,    -1,    -1,    -1,    -1,   908,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   916,    -1,    -1,    -1,
      -1,    -1,   604,   400,    -1,   925,    -1,   770,    -1,    -1,
      54,    -1,    -1,   776,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   784,   576,    -1,    -1,   788,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   964,    -1,    -1,    -1,    -1,    -1,
     604,    -1,    -1,    -1,   656,    -1,    -1,    -1,    -1,   822,
      -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   469,    -1,   471,    -1,    -1,    -1,    -1,    -1,
      -1,   478,    -1,    -1,   847,   482,   483,   484,    -1,   852,
      -1,    -1,    -1,    -1,   491,   858,    -1,   494,    -1,   862,
      54,    -1,   656,    -1,    -1,    -1,    -1,    -1,    -1,   711,
      -1,    -1,   875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,   887,    -1,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,   908,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   916,    -1,    -1,    -1,   711,    -1,    -1,
      -1,    -1,   925,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      43,    -1,    -1,    -1,    -1,    48,    -1,    -1,    -1,   576,
      -1,    -1,   784,    -1,    -1,    -1,    -1,    -1,    61,    62,
      63,    64,    -1,    -1,    -1,    68,    69,    -1,    -1,    -1,
      -1,   964,    -1,    -1,    -1,    -1,    -1,   604,   810,   811,
      -1,    -1,   166,    -1,    -1,    88,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     784,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   849,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   810,   811,   860,   656,
     862,    -1,   864,   865,   137,   138,    -1,   821,   141,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   175,    -1,   177,   907,   860,    -1,   862,    -1,
     864,   865,    -1,   915,   711,    -1,   189,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,    -1,   373,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   943,   215,    -1,    -1,    -1,    -1,   949,    -1,    -1,
      -1,    -1,    -1,   907,    -1,    -1,   400,    -1,    -1,    -1,
      -1,   915,   964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   784,    -1,   943,
      -1,    -1,    -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
     964,    -1,    -1,   810,   811,   459,   460,   461,    -1,   373,
      -1,    -1,    -1,    -1,   821,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,   483,
     484,    -1,    -1,    -1,    -1,    -1,   400,   491,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   860,    -1,   862,    -1,   864,   865,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   880,    -1,   358,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   459,   460,   461,    -1,    -1,
     907,    -1,    -1,    -1,    -1,   469,    -1,   471,   915,    -1,
      -1,    -1,    -1,    -1,   478,   398,    -1,    -1,   482,   483,
     484,    -1,   576,    -1,    -1,    43,    -1,   491,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,   943,    -1,    -1,    -1,
      -1,    -1,   949,    61,    62,    63,    64,    -1,    -1,    -1,
     604,    69,    -1,    -1,    -1,    -1,    -1,   964,    -1,    -1,
     443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      88,    -1,    -1,    91,   457,    93,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   470,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,
      -1,    -1,   656,    -1,    -1,    -1,   489,    -1,    -1,   492,
      -1,    -1,   576,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,    -1,    -1,   141,    -1,    -1,    -1,    -1,   511,    -1,
      -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     604,    -1,    -1,    -1,    -1,    61,    62,    63,    64,    -1,
      -1,    -1,    -1,    69,   537,    -1,    -1,   711,    -1,   177,
      -1,   544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,   581,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,   599,    -1,   172,   173,
      -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     784,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
     623,   624,    -1,    -1,    -1,    -1,    -1,   711,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   810,   811,    -1,   175,
      -1,   177,    -1,    -1,   647,    -1,    -1,   650,    -1,    -1,
      -1,    -1,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   299,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   849,    -1,    -1,    -1,   215,
      -1,    -1,    -1,    -1,    -1,    -1,   860,    -1,   862,    -1,
     864,   865,    -1,    -1,    -1,   698,    -1,    -1,    -1,    -1,
     784,    -1,    -1,    -1,    -1,    -1,   880,   710,    -1,   712,
     713,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,    -1,    -1,    -1,    -1,    -1,   810,   811,    -1,   732,
      -1,    -1,   166,   907,   737,    -1,    -1,    -1,   172,   173,
      -1,   915,   745,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   389,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
     398,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   943,
      -1,    -1,    -1,   776,    -1,   949,   860,    -1,   862,    -1,
     864,   865,    -1,    -1,    -1,   788,    -1,   361,   362,   363,
     964,    -1,    -1,    -1,    -1,    -1,   880,    -1,    -1,   373,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   456,   822,
      -1,    -1,   358,   907,    -1,    -1,   400,    -1,    -1,    -1,
      -1,   915,   470,   369,    -1,    -1,   474,    -1,    -1,   842,
     843,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   492,    -1,    -1,    -1,    -1,   943,
      -1,    -1,   398,    -1,    -1,   949,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     964,    -1,    -1,    -1,   887,   459,   460,   461,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   469,   899,   471,    -1,   537,
      -1,    -1,    -1,   906,   478,    -1,    -1,    -1,   482,   483,
     484,    -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,
     494,   457,    -1,    -1,    -1,    -1,    -1,   361,   362,   363,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,
      -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,   166,    -1,
      -1,    -1,    -1,   489,   172,   173,   492,    -1,    -1,    -1,
      -1,   599,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
     188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   622,   623,   624,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   537,   576,    -1,    -1,    -1,    -1,    -1,   544,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   459,   460,   461,    -1,    -1,
     604,    -1,    -1,    -1,    -1,   469,    -1,   471,    -1,    -1,
      -1,    -1,    -1,    -1,   478,   581,    -1,    -1,   482,   483,
     484,    -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,
     494,    -1,    -1,   599,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   710,    -1,   712,   713,    -1,    -1,    -1,    -1,
     718,    -1,   656,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   732,    -1,    -1,    -1,    -1,   737,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   647,    -1,    -1,   650,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   764,    -1,   702,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   711,   776,    -1,
      -1,    -1,   576,   361,   362,   363,    -1,    -1,    -1,    -1,
     788,    -1,    -1,    -1,    -1,   373,    -1,    -1,    -1,    -1,
      -1,    -1,   698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     604,    -1,    -1,    -1,   710,    -1,   712,   713,    -1,    -1,
      -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   732,    -1,    -1,    -1,
      -1,   737,    -1,    -1,    -1,    -1,    -1,   845,    -1,   745,
     784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,    -1,   867,
      -1,    -1,    -1,    -1,    -1,    -1,   810,   811,    -1,    -1,
     776,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,   887,
      -1,   469,   788,   471,    -1,    -1,    -1,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,   483,   484,    -1,    -1,    -1,
      -1,    -1,    -1,   491,    -1,    -1,   494,   711,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   822,    -1,   862,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   880,   843,    -1,    -1,
     948,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   901,    -1,    -1,
      -1,    -1,    -1,   907,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   915,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     784,   887,    -1,    -1,    -1,    -1,    -1,    -1,   576,    -1,
      -1,    -1,    -1,   899,    -1,    -1,    -1,    -1,    -1,   943,
     906,    -1,    -1,    -1,    -1,   949,   810,   811,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   604,    -1,    -1,    -1,
     964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   862,    -1,
     864,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   656,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   907,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   915,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   711,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   943,
      -1,    -1,    -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   784,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   810,   811,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   862,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   880,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   915,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   943,    -1,    -1,    -1,    -1,
      -1,   949,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   964
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   969,   970,     0,   971,   972,   973,   976,   977,   175,
     992,   993,   590,  1002,  1020,   237,   405,   407,   974,   975,
     978,   979,   986,   988,  1005,  1006,  1008,   852,   292,  1029,
    1030,  1031,  1032,   852,  2306,   975,   372,   642,  1009,  1010,
    1011,  1012,  1007,    38,  1021,  1022,  1003,   168,  1033,  1034,
    1035,  1036,   237,   994,   852,  1002,   852,  1002,   237,   431,
    2349,   215,  1024,   201,  1210,  1212,  1213,  1214,   420,  1121,
    1122,  1123,    21,   126,   184,   187,   189,   213,   307,   481,
     574,   578,   697,   736,   783,   785,   817,   829,   867,   949,
     960,  1037,  1038,  1039,  1041,  1045,  1060,  1066,  1067,  1068,
    1069,  1070,  1072,  1077,  1095,  1096,  1101,  1104,  1107,  1108,
    1111,  1113,  1114,  1115,  1116,  1117,  1118,  1119,   744,  2306,
     215,   995,   478,   643,  1013,   273,   980,   981,   982,  1013,
     267,   984,  2306,   525,   788,   791,   792,  1023,   722,   289,
    1025,  1004,   856,  1215,  1216,   237,   744,   327,  1124,     1,
     949,  2210,  2210,   798,   770,  2377,  2349,  2349,  2349,  2210,
     770,  2306,  2306,  2349,  2306,  2306,   124,   169,  2330,  1120,
    2210,  1039,     1,   852,  1069,  1071,   411,  1094,  2306,   996,
      39,  1015,   983,   982,  1015,   985,   511,  2361,  2349,   426,
    1027,   637,  1544,  1545,  1550,   744,  1217,  2306,  2306,  2306,
    1125,  1078,   357,  1093,  2340,  2349,  2349,   949,  2203,  2259,
     149,  2203,  2349,  2349,  1046,  1061,  2203,  1042,   949,  1102,
    1103,  1281,  1093,  2349,  1109,   478,   581,   584,  1073,  1075,
    1076,  1970,  2265,  2349,   949,  1154,   744,   478,  1016,  2349,
     478,   643,  1014,   852,  2349,  1014,  2349,   133,   801,   854,
    1026,   723,  2306,  1546,  1580,  1581,  2306,   324,   739,  1211,
    1218,  1219,  1221,   439,   749,  1126,  1187,  1188,  1079,  1082,
    1083,  2340,  2349,    25,   522,  2203,   478,   411,   580,  2405,
     478,   875,   123,   503,   641,   748,   949,  1047,  1048,  1049,
    1050,  1051,  1055,  1056,  1058,  2329,  2372,   371,   641,  1062,
    1063,  1064,  1043,  1058,  1103,  2349,   949,  1097,  1098,  1099,
    2211,  2210,    18,   400,   478,   494,   656,   784,   862,   949,
     964,  1110,  2270,  2271,  2272,  2273,  1970,   431,   798,  2368,
    2349,   184,  2210,   852,   852,   153,   320,   651,   676,   858,
    1017,  1018,  1019,  2306,   651,  2306,    52,   527,   528,   529,
     646,   868,   869,   881,  2299,  2349,   237,     0,     1,     5,
      11,    19,    28,   101,   102,   132,   152,   156,   174,   218,
     224,   226,   230,   234,   251,   288,   304,   309,   315,   316,
     366,   374,   377,   382,   408,   416,   418,   421,   424,   440,
     506,   512,   514,   517,   533,   588,   611,   652,   658,   663,
     666,   667,   685,   703,   708,   715,   721,   740,   755,   761,
     779,   793,   803,   804,   812,   815,   830,   852,   877,   890,
     896,   921,   953,   958,   966,  1582,  1584,  1613,  1618,  1623,
    1628,  1654,  1659,  1667,  1671,  1672,  1676,  1679,  1684,  1689,
    1741,  1745,  1747,  1748,  1753,  1769,  1777,  1781,  1784,  1787,
    1791,  1793,  1800,  1810,  1813,  1816,  1822,  1843,  1844,  1853,
    1857,  1859,  1863,  1866,  1870,  1884,  1898,  1900,  1904,  1919,
    1920,  1930,  1933,  1934,  1938,  1944,  1945,  1946,  1957,  1967,
    1984,  1994,  2002,  2003,  2009,  2020,  2024,  2027,  2030,  2033,
    2036,  2047,  2067,  2075,  2076,  2104,  2317,  1582,   951,  1270,
    1271,  1273,  1274,     1,   949,  2191,  2306,  1127,    32,   516,
     700,   732,  1189,  1190,  1191,  1192,  1194,  1195,  1196,  1201,
    1080,  1081,    25,   522,   478,  1105,  1106,  2269,  2270,   948,
    1112,  2392,  2259,   757,   776,  2380,  2349,   852,  1049,   852,
     949,  1048,   127,   136,  1052,  2331,    18,   373,   949,  1065,
     949,     1,   852,  1064,  1044,  2392,  2271,  1098,    33,   431,
    2211,  2351,  2273,   848,  2368,   431,  2210,  2210,  1074,  1075,
       5,   997,   998,  1019,  2306,  2372,   153,  2306,   527,   528,
     646,   881,  1028,  1547,     5,    11,    19,    28,   101,   102,
     132,   152,   156,   174,   218,   230,   234,   253,   258,   259,
     260,   261,   263,   264,   265,   266,   268,   270,   271,   272,
     274,   275,   276,   277,   278,   280,   281,   282,   283,   284,
     285,   288,   304,   315,   316,   366,   374,   377,   382,   408,
     416,   418,   421,   424,   506,   512,   514,   517,   533,   588,
     611,   663,   685,   708,   715,   721,   740,   761,   779,   793,
     803,   804,   812,   815,   830,   852,   877,   890,   896,   953,
     958,  2303,  2304,  2305,  1585,  1614,  1619,  1624,  1629,  1655,
    1660,  1668,  1673,  1680,  1677,  1685,  1690,  1742,  1746,  1754,
    1823,  1770,  1778,  1782,  1785,  1788,  1792,  1794,  1801,  1811,
    1814,  1817,  1858,  1860,  1864,  1867,  1583,  1871,  1885,  1899,
    1901,  1905,  1921,  1931,  1935,  1939,  1958,  1968,  1985,  1995,
    2010,  2021,  2025,  2028,  2031,  2034,  2037,  2048,  2068,   357,
    1749,   374,   609,    18,  1947,   300,   478,   656,   730,   784,
     837,   964,  2007,  2008,  2153,  2250,  2251,  2259,   374,   609,
    1567,   744,   154,  1249,  1250,   250,   762,   775,  1275,  1276,
    1278,  1289,  1291,  1294,  2288,   464,   637,   852,   856,   965,
    2308,  2309,  2315,  1220,   555,   589,  2296,   152,   181,   198,
     199,   319,   487,   498,   630,   671,   690,   954,   955,  1197,
     584,  1202,  2366,   669,   779,   780,  1193,     1,   201,   439,
     637,   749,   852,  1191,  2307,  2314,  2349,  2349,  1094,  1106,
     839,   617,  2349,  2265,   852,  2349,   759,   428,  1015,     1,
     373,   428,  1015,   852,   852,   212,   478,  1100,  2266,  2273,
    2210,   999,   230,  1000,   987,   989,    99,   510,   602,   796,
     801,   854,  1635,  1636,   583,   949,  1586,  1589,  1590,  1591,
    2192,  2250,    12,   166,   172,   173,   182,   188,   361,   362,
     363,   373,   459,   460,   461,   469,   471,   482,   483,   484,
     491,   510,   576,   604,   711,   810,   811,   825,   880,   907,
     915,   943,  1615,  2183,  2215,  2216,  2218,  2219,  2250,  2271,
    2275,  2276,  2277,  2278,  2413,    54,   860,   864,   865,  1620,
    2178,  2179,  2180,  2181,  2182,  2183,  2219,  2222,  2250,  2257,
    2259,  2272,  2275,   478,  1625,  1626,  2199,  2200,  2201,  2259,
    1630,  1635,    18,   478,   643,  1656,  1657,  1658,  2234,  2250,
     947,  1661,  1662,  1664,  2191,    12,  1669,  2183,  2184,  2185,
    2213,  2255,  2256,  2259,  2272,    15,  1674,   856,  1681,  2191,
      18,  1678,  2250,  2252,   419,   438,   596,   829,  1686,  1688,
     299,   354,   412,   478,   507,   583,   788,   813,   858,   947,
    1691,  1692,  1693,  1694,  1696,  1704,  1706,  1707,  1708,  1711,
    1716,  1719,  1720,  1723,  1725,  2215,  2234,  2250,  2392,  1743,
    2216,  1686,   855,   866,  1755,  1756,  1757,  2157,  2158,  2159,
    1820,  2250,  2271,  2275,   122,  1771,  1773,   371,   607,   611,
     641,   744,  1779,  1783,  2212,  2213,  1786,  2259,   847,  1789,
    2388,   375,   660,   709,  1646,  1780,     1,  2156,  2157,  1802,
    2212,   949,  1812,  2193,   175,   947,  1484,  1728,  1815,  2250,
      65,  1818,  1819,  1986,  2243,  2244,  2259,  1484,  1728,  1861,
     182,  1865,  2216,  1868,  2216,   756,   314,  1872,  1873,  1874,
     411,  1886,  2151,  2342,   949,  2192,   310,  1902,  2250,  1906,
    2191,  1922,  2192,  1932,  2186,  2259,  1936,  2191,   856,  1940,
    2186,  2187,   847,  1959,  1960,  1964,  2192,   292,   449,   510,
    1969,  1972,  1973,  1976,  1977,  1978,  1979,  1980,  1981,  1982,
    1983,  2153,  2194,  2195,  2212,  2242,  2244,  2259,  1986,  1996,
    2191,  2011,  2012,  2013,   182,   825,  2022,  2215,   635,  2026,
    2029,  2193,  2032,  2245,  2250,  2035,  2191,   478,  2038,  2235,
    2250,  2275,  2049,  2250,  2069,  2187,   377,  1635,  1751,  1845,
    1854,  1948,  1949,  2188,  2259,  2004,  2250,   864,  2263,  2264,
    2077,  2105,   852,   949,   966,  1568,  1570,  1571,  1574,  1575,
    1580,   154,   464,   476,   485,   637,   694,   735,   852,  2308,
    2313,  2316,   744,   485,  1399,  1400,  1281,  1293,  1281,  1281,
    1276,  2313,     1,   336,  1279,  1280,  1281,   464,   965,  1222,
     589,  2210,  2366,  2388,  2388,   580,  2365,  2366,  2366,  2388,
    2366,  2366,  2388,  2366,  2366,   856,  2339,   308,  2338,   478,
    1140,  2259,    34,  2321,  2307,    41,   246,   400,   478,   481,
     494,   525,   656,   784,   789,   790,   964,  1084,  1086,  1087,
    1088,  1091,   885,   917,   918,  1085,  1086,  2269,   478,  2265,
     481,   819,   914,  1057,  2206,  2260,  2261,  1053,   511,  2266,
    2349,  1001,   852,  1032,  1204,  1204,   948,  1632,   258,  1612,
    1587,    43,    68,   368,   511,  1596,  1597,  1598,  1602,  1605,
    2324,  2325,  2392,   864,  1593,   507,  2360,   367,  2365,  2250,
     864,   864,   864,  2280,   864,  2405,  2405,   864,   864,   864,
     864,  2405,  2243,   864,  2280,   259,  1617,   847,  1616,  2216,
    2251,  2272,  2275,   864,  2279,   864,   864,  2182,  2182,  2178,
    2182,   124,   860,   865,    53,    55,    56,    57,    58,    59,
      60,   851,   861,   317,  2251,  2272,  2275,   417,  2291,  1626,
     847,  2405,   260,  1653,  2151,  1658,  1665,  2191,   678,   889,
    1663,  2392,  2411,  2365,   261,  1670,   298,   853,  2185,  2402,
     722,  2297,  2263,  2264,  1675,  1682,  2191,   263,  1683,   669,
    2374,   176,  2333,  2250,   829,  2385,   829,  2192,  1705,   383,
    1726,    92,  2327,   264,  1740,   310,   566,   587,  2119,  2121,
    2123,  2397,  1694,  2214,  2215,  1695,   948,  1697,  1593,  1717,
    1726,   902,   903,   904,   905,   177,   265,  1744,    97,   427,
     266,  1768,    27,   942,  1758,  1759,  1760,  1762,    30,    53,
      54,    55,    56,    57,    58,    59,    60,   317,   431,   555,
     591,   849,   851,   860,   861,   864,   865,  2160,  2161,  2169,
    2216,  2349,   693,   826,  1824,   519,  1774,   197,  1780,  2213,
     288,  2198,   449,  1902,  2216,   836,  1796,  1803,  2392,  2193,
    2250,     9,    17,    49,    79,    80,    81,    82,    83,    84,
      85,    86,    95,   100,   111,   112,   113,   114,   129,   139,
     142,   143,   144,   146,   180,   189,   190,   191,   192,   193,
     194,   195,   196,   202,   203,   231,   232,   235,   236,   240,
     262,   287,   291,   306,   312,   313,   331,   332,   333,   334,
     335,   338,   378,   379,   380,   381,   387,   388,   390,   392,
     393,   394,   397,   399,   403,   422,   423,   432,   433,   434,
     435,   436,   437,   446,   450,   451,   454,   493,   497,   499,
     500,   501,   502,   509,   526,   534,   570,   571,   605,   608,
     619,   625,   629,   631,   632,   645,   648,   649,   654,   670,
     672,   673,   681,   682,   704,   705,   706,   724,   725,   726,
     727,   729,   733,   734,   741,   742,   750,   751,   752,   758,
     763,   781,   794,   795,   800,   823,   824,   832,   840,   846,
     876,   882,   926,   933,   935,   938,   945,   957,   961,  1489,
    1491,  1493,  1495,  1497,  1499,  1501,  1503,  1506,  1508,  1510,
    1511,  1513,  1515,  1516,  1518,  1520,  1523,  1524,   452,   776,
     845,  1525,  1526,  1820,  1988,   864,  2263,   555,   806,  1486,
    1487,  1488,  1489,  2295,  1525,   270,  1862,  2216,   847,   271,
    1869,    97,  1873,   318,   419,   438,   596,  1875,    98,   359,
     478,  1283,  1891,  1892,  1893,  2199,  2219,  2236,  2250,  2259,
    2271,  2275,  2392,   837,   949,  1903,   274,  1918,   533,   628,
    2294,   275,  1929,   507,   747,  1923,   367,  2070,   276,  1937,
    2374,   949,   277,  1943,  2070,  2216,   279,   367,  1962,  1963,
    2229,  2232,  2250,  2272,  2275,   310,  1979,  1981,  2212,   636,
     847,  2195,   243,   847,   898,  1971,    45,  2263,   280,  2001,
     339,   443,   449,  1998,   281,  2019,   427,  2014,  2015,  2216,
    2250,  2243,   282,  2023,   367,  2193,  2330,   669,   675,  2375,
     283,  2046,   219,  2039,  2250,   284,  2074,  2070,   847,   478,
    1846,  2250,  1855,  2250,  1950,  2188,   278,  1956,   930,  1951,
    1646,  2005,  2216,  2392,  2176,  2178,   864,  2264,  2078,  2250,
    2106,  2250,     1,   744,   852,  1569,  1272,  2306,   744,   476,
    1402,  1403,  1292,  1295,   689,  2313,   852,  1277,   169,    89,
     135,   201,   445,   468,   669,   674,   694,   696,   925,  1223,
    1224,  1226,  1230,  1231,  1234,  1235,  1241,  1244,  1246,  1247,
    2309,  2349,  1128,  2202,  2203,  2203,  2265,  2265,  2189,  2191,
    2189,  2265,  2189,  2189,  2203,  2189,  2189,   828,  2384,   257,
    1203,  2265,  2340,  2206,  1088,    27,   839,   124,   513,   950,
    2409,   949,  2262,  1054,  2340,  2349,  1072,  2349,  1036,  1214,
    1543,  1543,  1633,   121,   916,  1551,  1596,   964,  2237,  2242,
    2265,  2349,  1598,   137,   141,   470,   623,   624,  1603,  1604,
    2401,   842,    48,    61,    62,    63,    64,    69,    88,   138,
     175,   177,   189,   215,   358,   369,   398,   457,   489,   492,
     537,   544,   581,   599,   647,   650,   698,   710,   712,   713,
     732,   737,   745,   788,   822,   843,   887,   899,   906,  1606,
    1609,  1610,  1611,  2334,  2373,   151,   478,  1594,  1595,  2224,
    2250,  2250,   183,    36,    37,   140,   147,   150,   204,   209,
     210,   292,   294,   301,   310,   419,   470,   474,   735,   820,
     831,   842,   913,   949,  1601,  2195,  2399,   288,   641,  2227,
    2251,   847,  2176,  2178,  2286,  2176,  2287,   849,  2176,  2279,
    2282,  2283,   949,   949,  2178,  2285,  2285,  2285,  2221,  2250,
    2272,  2275,  2284,   949,   847,  2221,  2281,  2279,    12,  2183,
    2184,  2216,  2259,  2272,   375,  2178,  2221,  2176,   849,   417,
    2292,  2179,  2179,  2180,  2180,  2180,  2180,  2180,  2180,  2180,
    2180,  2180,  2180,   480,  1621,   639,  1627,  2201,  1637,  1638,
    2235,  2250,  1663,   486,   537,  2340,  2251,  2178,   511,  2298,
    2264,  2178,  2119,  2191,   707,  1911,  1912,  1913,  1687,  2392,
    1697,   947,  2215,  1577,  1578,  2122,  2123,  2120,  2121,  1577,
     901,  1602,  1605,  1699,  1700,  1702,  2392,    61,    62,    63,
      64,    69,    87,    88,   138,   177,   299,   358,   398,   492,
     599,   732,   737,   776,   788,   887,  1610,  1698,  1739,   299,
    1709,  1710,  2250,  2272,   901,  1727,   947,  2119,  2119,  2119,
    2119,  1692,  2216,  2184,  2216,  1757,  1763,   942,  1760,  1761,
     266,   852,   942,  1577,  2168,  2169,  2161,    22,    23,    24,
     128,   298,   384,   385,   462,   463,   530,   565,   574,   583,
     626,   853,   857,   859,  2170,  2171,  2172,  2173,  2174,  2175,
      18,   339,   453,   897,  1827,  1825,  1772,   478,  2196,  2197,
     221,  1790,  2199,   310,  2394,   253,  1795,  1797,    18,    22,
      25,    26,   522,   523,   574,   575,  1804,  1808,   336,   411,
     853,  2343,  1522,  2265,  2343,  1524,  2343,  2343,  2343,  1526,
     178,   693,   826,  1821,  1830,  1832,  1833,  1990,  2366,  2392,
     431,   853,  2350,  1487,    33,   431,   853,  2352,     3,    13,
      29,    50,    78,    91,    92,    93,    96,   103,   115,   117,
     118,   145,   200,   216,   238,   239,   241,   242,   286,   302,
     342,   343,   344,   365,   370,   395,   396,   401,   402,   456,
     458,   475,   488,   489,   490,   515,   539,   540,   541,   543,
     545,   546,   548,   549,   550,   556,   558,   559,   560,   561,
     574,   582,   597,   598,   606,   612,   659,   665,   718,   719,
     720,   728,   753,   766,   767,   768,   769,   786,   787,   797,
     827,   841,   842,   878,   888,   895,   906,   910,   911,   912,
     931,   932,   936,   937,   939,   946,  1490,  1492,  1494,  1496,
    1498,  1500,  1502,  1504,  1505,  1507,  1509,  1512,  1514,  1517,
    1519,   847,  2212,  2184,  2216,   765,  1876,  2365,   389,  2152,
    2152,   897,   930,   839,     1,    71,    72,    73,    74,    76,
     158,   159,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   478,   621,   644,  1284,  1285,  1286,  1287,  1288,  1336,
    2225,  2251,   844,   833,  2374,   427,  2241,  2250,  2271,  2275,
     427,  1907,  1911,  1963,  2250,  1965,  2392,   847,   847,   847,
     847,  1970,    12,   288,   776,   855,   866,  2216,    97,    69,
      88,   398,   457,   492,   599,   712,   887,  1974,  1975,  2349,
    1997,  2392,  2250,  2015,   219,  2016,   367,   367,  2184,  2216,
     367,    97,  2328,   427,  2042,    15,    68,  2071,  2072,  1750,
    1632,   269,  1852,   367,  1852,   427,  1956,    44,   257,  1952,
    2395,  2250,  1952,  2216,   300,   554,   151,   754,   849,  2177,
     850,  2178,   285,  2103,   367,  2103,  2108,  2392,  1572,  2317,
    1273,  1251,  2306,   744,   694,  1405,   925,   927,  1372,  1376,
    1312,  1313,  2349,  2288,    31,    67,    87,   126,   215,   223,
     360,   429,   441,   465,   579,   616,   627,   677,   732,   749,
     770,   818,   882,   908,   923,   925,   927,   930,   934,  1300,
    1301,  1302,  1303,  1304,  1307,  1308,  1310,  1313,  1314,  1317,
    1320,  1322,  1323,  1328,  1329,  1330,  1339,  1342,  1359,  1360,
    1362,  1363,  1364,  1386,  1389,  1391,  1393,  1394,  1395,  1396,
    1397,  1398,  1450,  2349,  2379,  1282,  2349,   170,  2332,  2349,
     669,   675,  2410,  2410,  2349,  2332,  2349,  2361,  2349,    33,
    2320,   580,  1248,  2210,   320,   376,     1,  1129,  1130,  2203,
    2366,  2366,   870,   871,  2414,  2191,  2366,  2366,  2332,  2365,
    2365,   675,  2189,  1089,  1091,  2405,    25,   522,  2206,  1072,
    1040,  1041,  1403,   637,   990,   990,    99,   602,   801,  1634,
    1553,  1552,   709,  1562,   301,   564,   566,   586,  2112,  2114,
    2115,  2117,  2118,  2396,  2397,    89,   572,  2363,  2363,   478,
    2238,  2242,  2267,  2349,  2349,  2349,  2349,    69,   248,  1611,
    2329,   243,   898,  2389,    15,  2319,   443,   776,  1594,   151,
     860,   865,  2112,   963,   962,  2229,  2112,   443,  2354,   798,
     798,   572,  1588,   518,   478,  2228,  2251,  2250,  2177,   849,
    2177,   849,   849,   615,   849,  2221,  2177,   849,   849,   849,
    2177,   849,  2243,  2177,   849,  2365,   569,   777,  2124,  2126,
    2128,  2263,  2264,  2184,   850,   849,   849,   847,  2293,  1621,
    2265,   709,  1622,   847,  2199,  1631,   531,   643,  1639,    39,
    1666,  2392,   714,   688,  2124,  2349,   743,   359,  2340,   430,
     567,  2145,  2146,  2148,  2150,   443,  1721,  1712,  1579,   184,
     185,   633,  1072,  1703,  2195,  1700,   538,  1739,  2350,   470,
     735,  2349,   295,   297,  1527,  1528,  2336,  2388,  2350,   243,
    2389,  2349,  1739,  1710,  2250,  1718,  1724,  2119,   375,  2124,
     375,     1,    31,   855,   866,  1765,  1766,  2158,   594,  1764,
     964,  2170,  2388,   339,  1091,  1829,  2259,    18,   453,   897,
    1826,  1592,  1593,  1790,  2197,  2366,  1798,   268,  1799,  1577,
    2388,   693,  1805,  2388,  2250,  2250,  2250,  2250,  2250,  2230,
    2251,  2258,  2272,    18,   124,   339,   453,   875,  1836,  1837,
    1838,  1831,  1832,  1150,  1991,  2331,    40,   222,  1354,   244,
    1521,  2250,  2265,   864,  2216,  2212,  2124,   375,  2392,  1911,
    1284,  2342,  1892,  1887,  1888,   316,  1894,  2156,  1895,  1896,
    2250,  2199,   852,  2072,  1907,  2250,  2250,   562,  2134,  2137,
    2139,  2395,  1941,  1942,  2392,   709,  2071,   249,   254,   303,
    2250,  2229,   581,   964,  2239,  2240,  2242,  2265,  2365,  2228,
     580,  2216,  1970,  1970,  1970,  1970,  1970,  1970,  1970,  1970,
    1975,   555,   565,  1999,  2000,  2171,  2295,  2145,   459,   776,
    2412,  2018,  2392,  2328,  2250,  2243,  2124,   375,  2230,    18,
    2040,  2041,  2289,  2043,  2250,  2018,  2043,  1911,    14,  2318,
     478,  1752,   916,  1640,  2250,  2250,   942,  1953,   942,  1954,
    1955,   798,  2382,  2382,  2178,   849,  2178,  2250,   709,  2109,
     256,  1576,  2265,  1252,  1401,  2306,  1406,   735,  1468,  2349,
    2320,    30,   317,   591,   849,   851,   860,   861,   864,   865,
    1283,  1299,  1378,  1379,  1380,   925,   376,  2259,   459,   574,
     942,  2390,  2349,  2349,  2349,    77,   123,   574,  1321,   942,
     718,  2376,  2248,  2251,   245,  1345,  2265,  1324,   942,  2251,
      39,  2323,   942,   431,   456,   718,  1361,  2388,  2349,  2349,
    2349,   367,  1367,  2320,   949,  1451,  1452,  1302,    70,    71,
      72,    73,    74,    76,    77,   155,   157,   158,   160,   161,
     162,   163,   164,   165,   230,   345,   346,   347,   348,   349,
     353,   389,   413,   522,   600,   621,   644,   772,   773,   774,
     892,   893,   894,  1331,  1336,   320,   321,   406,   785,   883,
     453,   875,   367,  1296,  2323,   376,  2265,  1154,  2351,  2351,
     949,  2207,  2208,   583,   788,  2406,   478,  2203,  2209,  2265,
     930,  2349,   328,   405,   949,  1232,  2210,  2307,     6,    10,
      29,    42,   255,   329,   330,   414,   470,   551,   593,   601,
     669,   684,   701,   765,   779,   856,   872,   873,  1131,  1132,
    1141,  1143,  1147,  1149,  1150,  1153,  1155,  1156,  1157,  1158,
    1164,  1165,  1166,  1167,  1170,  1176,  1177,  1179,  1181,  1183,
    1184,  1185,  1186,  2307,  2331,  2374,  2404,  2189,  2189,  2366,
    2189,  2189,  1198,  1199,  2191,  2411,  2191,  1090,  1091,  2262,
    2349,  2349,  2206,  1066,  1205,   991,   982,   984,   476,  1554,
    1555,  1556,  2328,  1554,   583,   949,  1548,  2116,  2117,  1607,
    1608,  2246,  2250,  2113,  2114,  1577,  2237,  2237,  2237,  2237,
    2238,  2237,  2349,  2154,  2240,  2154,  2238,  2342,  2349,   849,
     849,  1594,  2224,  2224,  2112,   776,  1599,  1600,  1602,  2297,
     821,  2279,   821,  2279,   849,  2279,  2203,  2279,  2279,  2279,
    2221,  2279,  2297,   453,   875,  2279,  2251,  1577,  1577,  2127,
    2128,  2125,  2126,  2264,  2124,   849,  2178,  2279,  2279,  2233,
    2250,  2271,  1622,  2213,  2152,   537,  2299,  2178,  1577,  1577,
    2149,  2150,  2147,  2148,  2234,  1727,   215,   404,   845,   882,
    1646,  1713,  1714,  1715,  1580,  2237,  2237,   470,   735,   257,
    2237,  2154,  2154,  2237,    91,    93,   389,   474,   622,   764,
     867,  1602,  1729,  1730,  1731,  1732,  1733,  1735,  1736,  1737,
    1738,  2392,  1729,  2184,  2185,  2184,  2185,    27,   839,  1767,
     266,   852,  1577,  1765,    97,   339,  1829,   299,  2337,  2250,
    1577,   253,   925,  1806,  1807,  1808,   836,  1809,  2386,   925,
     847,    97,  1837,  1839,  2230,    18,   124,   453,   875,  1834,
    1835,  2229,  2246,  2250,  1987,   759,  2354,   411,   592,  2344,
    2215,  2184,    18,   537,   663,  1180,  2189,  2250,  1577,   272,
     852,  1890,    15,   367,    14,   410,  1908,  1909,  1910,  1912,
    1915,  1942,  2392,   201,   542,  1924,  1926,  1928,  1577,  2138,
    2139,  2137,  1577,  2145,   486,   537,  1961,  2250,   693,  1966,
     325,   326,  2216,  2171,  2250,  2172,  2173,  2174,  2175,  2178,
     568,   863,  2129,  2131,  2133,   621,   776,  2017,  2216,  2297,
    2297,  2184,   847,   591,  2229,   220,  2044,   826,  2045,  1941,
     603,  2195,  2237,  1641,   183,  2155,  1856,  2392,  2157,  1577,
    2156,  1954,  2006,  2216,  2006,   849,  2155,   522,   924,  2110,
    2232,   852,   109,  1253,  1254,  1255,  1273,  1404,   744,  1469,
     839,  1377,  1380,  2349,   839,  1290,   964,    22,    23,    24,
      90,   128,   574,  1154,  1392,   552,  1390,  2216,  2212,   201,
    2335,     1,  2162,  2163,  2164,  2165,   864,  1305,  1306,   104,
    1347,   886,   847,  1344,   221,   481,  1325,  2162,  2248,  1318,
     949,  2249,     1,   577,   949,  1332,  2213,  1283,  1299,  1374,
     864,  1369,  2320,  1365,  1366,  1373,  1374,   367,  1453,  1452,
     771,   891,  2378,   891,  2378,   891,  2378,   891,  2378,   891,
    2378,    16,  2365,    39,  1311,  2328,  1315,   805,  1309,   757,
    2300,  2300,   949,  1298,  1299,   847,  1229,   357,  1245,  2208,
     474,  2358,   847,  2330,  2342,   322,   340,   731,   884,   919,
     928,  1242,  1243,  2349,  2349,  2361,  2354,  2374,  2388,   760,
    2354,  2349,  2329,   220,  2354,  2354,   537,  1178,  2265,  2392,
    2349,  2349,   798,   486,   759,    70,  2326,  2351,  2189,  1199,
     624,  1200,    27,  2206,  2206,  1107,  1111,  1113,  1206,  1207,
    1208,  1209,  1059,  1060,   237,  1555,   776,   891,  1557,  1558,
    1559,   679,   925,  2317,  1577,  2234,   470,   474,  2407,  1608,
    2239,   849,  2349,  1600,  2124,  2279,   367,  2301,   849,  1632,
     230,   743,   844,  1722,  2350,  2350,  2350,  2350,  2216,  1715,
    2365,   411,   431,  2353,  2237,  2321,  1730,   116,   456,   718,
    1734,   537,  1739,  2124,   686,  2124,   686,  1766,  2157,  1829,
     693,  1828,  1775,  1776,  2250,  2271,  1798,  1807,  2335,  2388,
    2231,  2258,  2271,  2229,    97,    15,    68,  1840,  1841,  1842,
    1835,  1840,   357,   419,   916,  1992,  1151,  1989,   592,   849,
    2124,   594,  2369,  2369,   585,    20,   229,   357,   455,   699,
     713,   948,  1877,  1878,  1882,  1883,  2392,  2393,   272,  1889,
    1896,  2216,  2366,   486,   443,  1916,  1914,  1915,  2392,   409,
     442,   940,  1577,  1577,  1927,  1928,  1925,  1926,   486,   470,
    2355,  2365,  2365,  1577,  1577,  2132,  2133,  2130,  2131,  2349,
    2124,  2301,  2124,  2231,  2041,  2342,  2155,  2342,  2129,   296,
     563,  2073,  2140,  2142,  2144,  2146,   470,   474,  2356,  1642,
    1643,  1644,  2328,  2342,  1847,   518,  2090,   225,  1577,  1577,
    2079,  2392,   640,   909,  1573,  2050,  2210,  1273,  1273,  2306,
     744,  1283,   942,  1381,  1382,  1383,  2351,  2391,   533,   793,
    1297,  1298,  2259,    30,    53,    54,    55,    56,    57,    58,
      59,    60,   317,   591,   849,   851,   860,   861,   864,   865,
    2166,  2167,  2169,  2170,  2216,   478,  2226,  2342,   367,  1343,
     844,  2387,  2265,  2387,  2366,  1326,  2349,   594,  1319,  2162,
     679,  1387,  2390,  1371,  2267,  1373,  1366,  1373,   691,  1367,
    1370,  1374,  2222,    97,  1454,     7,    66,    78,   125,   148,
     206,   290,   355,   364,   445,   452,   477,   505,   653,   657,
     738,   799,   813,   837,   879,   929,   941,   947,   949,  1482,
     478,  2234,   184,   189,   307,   736,  1316,  2329,  1299,  2265,
     124,   675,  1225,  2202,  1236,  2265,  2380,   478,  1233,  2259,
    1233,  2349,  2349,  2354,   245,   320,  1138,  1139,  2349,   684,
    1165,  2349,  2349,  2349,  2349,    34,    35,  2322,  1180,  2209,
    2265,  2349,  2361,   580,   760,  1182,  2209,  2265,  1091,  2340,
    2340,  1208,   852,  1209,  1551,  2349,   776,  1559,   589,  1561,
     214,  1563,  2239,   413,  2345,   223,  2302,  1640,  1729,  2216,
    2216,  2216,  2216,  2250,  2350,   845,   737,   952,  2185,  2185,
      97,  1701,  1702,  1776,  1577,    97,   215,  1840,  1840,  2231,
     858,  2347,  2347,  1842,  1841,   637,  2189,   375,   596,  1993,
    1152,  2340,  2349,  2259,    18,   537,   664,   900,   956,  1880,
    1881,  1882,   537,    94,   486,   497,  1879,    97,  1897,   486,
    2349,  1917,  2135,  2137,  2139,  2145,   486,   486,  2191,  2191,
    2250,  2302,  2250,  2250,  1577,  1577,  2143,  2144,  2141,  2142,
    1643,   583,  1558,  2217,  2218,  2247,  2251,   171,   679,   925,
    2250,  2090,  2365,   816,  1849,  2081,  2082,  2083,  2392,   856,
    2111,  2186,   637,  2051,   852,  1256,  1407,  2306,   761,   429,
     920,  1384,   855,  2365,  2167,   964,  2170,   849,   949,  2265,
     847,  1344,   221,   221,  1346,  2203,   776,   949,  1327,   323,
     949,  1333,  1334,   584,  1388,   300,   537,   849,  2177,  1370,
    2267,  2388,   847,  1368,  2222,   217,   341,   447,   504,   778,
     874,  1337,   479,  1338,   798,    91,   867,  1237,  1238,  1239,
    1240,  2392,  2330,   367,  1228,  2341,   245,   661,   760,  1142,
    2203,  2349,   105,   106,   107,   227,   228,   230,   419,   420,
     444,   470,   495,   596,   629,   633,   634,   661,   828,  1133,
    1134,  1135,  1136,  1137,  2203,  2209,  1168,  2203,  2203,  2330,
    2414,  2203,  2349,  2203,  2209,   839,   522,    25,   852,  1562,
      48,   215,  2265,  2349,   949,  1564,  1549,  2239,  2345,  2124,
    1645,  1646,  2250,  2350,  2124,  2124,  1829,  2216,  1840,  2216,
    2216,  2349,  2189,   637,    25,   522,  1154,   595,  2370,   714,
    2219,  2223,  2226,  2250,  2275,   897,  2250,  2138,  2136,  2137,
    2124,  2217,  1849,  2091,  2092,  2250,  1850,  1851,  2250,  2119,
     520,  2085,  2083,    46,   256,   959,  2084,   949,  2349,    43,
     247,   311,   376,  2052,  2053,  2054,  2056,  2060,  2062,  2063,
    2066,  2324,  2340,  1257,  1408,  1470,   847,   942,  1385,  2349,
    2250,   417,  1348,  2366,  2366,   414,  1349,  1351,  1352,  1353,
    1354,  1356,  2349,  2365,     8,   128,   171,   360,   683,   357,
     300,  2267,  2387,   257,  1369,  2209,  2209,   356,   221,  1227,
    1229,  2265,  2203,   367,    14,   916,   930,  2259,  2271,  2415,
      75,   473,   789,   949,  1169,   782,   853,  1171,  1172,  2203,
    2204,    51,   314,   496,  1159,  2349,   839,  2209,  2349,  2349,
    2306,    48,  1560,  2392,  2317,  1567,   847,  2239,   566,   863,
    1648,  1650,  1652,  2397,    12,   427,   557,   583,   862,  1647,
    2348,  2216,  1891,  2349,  2349,  2349,  1154,  2251,  2272,  2275,
    2156,  1848,  2092,  2349,  1851,  2349,   518,  2087,  2232,  1891,
      68,  2319,  1903,  2064,  2065,   641,   212,  1258,  2310,  2313,
    2340,   662,  1409,  1278,  1294,  1471,  1472,  1473,  2156,  1283,
    1349,  2203,  2203,  2328,  1356,  1352,  2354,  1350,  2265,   585,
    1335,  2253,  2254,  2256,  2324,  2366,  2330,  1171,  2259,  2339,
    2259,  2349,   610,  1144,  1145,  1173,  1174,   948,  1160,  1162,
    2392,  1163,  2392,  1160,  1154,  2209,  2206,  2206,   503,  1567,
    2239,  1577,  1577,  1651,  1652,  1649,  1650,  1577,  2365,  2250,
    1891,  1154,  1154,  2119,   583,  2271,  2232,  2365,   882,  2093,
    2107,   695,   788,  2381,   856,  2190,  2065,   257,   793,  2061,
    2366,   596,  2347,  1410,     1,  1280,  1473,   852,  1349,  1357,
    1358,  2260,  2349,  1351,  2254,  2209,  2203,  1227,  2290,  2392,
    1146,  2290,  1175,  2203,  1175,   486,  2359,   721,   497,   776,
     257,  2250,  2340,  2340,   521,  2086,  2088,  2089,  2250,  2365,
     816,  2098,  2119,  2250,   300,   310,  2403,  2191,   856,    18,
    2057,  2058,  2251,   223,   300,   798,   817,   834,  1263,  1264,
    1265,   419,   438,  2193,   852,  1474,  1475,   852,  1358,  2205,
    2206,  1144,   244,   537,  2349,   584,  2349,  1565,   522,    25,
    2349,  2089,  2349,  2094,  2095,  2250,   308,   944,  2099,  2100,
    2250,  2080,   637,  2371,  2191,   580,   638,   680,  2059,  2058,
     183,   825,  2349,   443,   443,   223,   459,  1265,   257,   507,
     798,   817,   834,  1259,  1260,  1261,  1262,  2250,  2360,  2383,
     257,   507,   798,   834,  1266,  1267,  1268,  1269,  2250,  2383,
    1411,  1477,   577,  1481,  1482,  2206,   815,  1148,   244,  2203,
     516,   669,   675,  2408,  2238,   214,  2349,  2349,  2232,  2271,
    2095,  2349,    45,   171,   252,   553,   574,  2097,  2101,   400,
     494,   784,   964,  2102,  2274,  2100,  2119,  2366,   580,  2248,
    2349,   579,  2250,  2349,  2349,  2349,  2349,   443,   204,   842,
     443,   459,  1261,  2250,   183,   655,   782,   807,   808,   809,
     443,   204,   842,   443,   459,  1268,  2250,   829,     1,  1412,
      48,    61,    62,    63,    64,    69,    87,    88,   108,   130,
     138,   186,   299,   358,   367,   369,   386,   398,   457,   470,
     474,   492,   537,   579,   599,   647,   698,   745,   776,   788,
     822,   847,   858,   887,   916,   925,  1323,  1329,  1339,  1359,
    1362,  1478,  1479,  1480,  1541,  1542,  1609,  1610,  2349,  2401,
    1483,  2250,  2265,  1476,   942,  2408,  1161,  1162,  1566,  1154,
    1154,  2097,  2096,  2097,  2096,   591,   318,   419,   438,   596,
    2055,  2189,  2250,  2265,  2250,  2250,  2250,  2250,  2349,  2349,
    2349,  2349,  2349,  2250,  2349,  2349,  2349,  2349,  2349,  2349,
    2349,  2349,  2349,  2349,  2349,  2250,  2349,  2311,  2313,   175,
     176,   603,  1413,  1414,  1419,  2311,  2349,  2392,  2423,  2349,
     470,   735,  1539,  2363,  1537,  2363,  2349,  2350,  1527,  1528,
    2349,  2241,  1537,  2350,  2265,   123,  2350,  2250,  2250,  2349,
    2272,   376,  1539,  1485,  1486,    18,   784,   964,  1092,  1161,
    2317,  2274,  2387,  2250,  2250,  2250,  2250,  2250,  2250,  2250,
    2250,  2250,  2250,  2250,  2250,  2250,  2250,  2250,  2250,  2250,
    2250,  2250,  2351,  2351,   466,   467,  2357,  1430,   376,   134,
     337,  1415,  1416,  1417,  1418,  2250,  2237,  2349,  2349,  2237,
    2246,  2265,  2237,  1534,  2237,  2387,  2349,  2246,  2265,  1477,
    2273,  1355,  1356,  2250,  2250,  2351,  2351,   964,  1420,  1421,
    1422,  2250,  2265,  2268,  1278,  1431,  2349,  1417,  1418,   508,
     620,   860,   865,  1530,  1531,  1532,  1533,  1540,  1530,  1532,
    1538,   110,   618,  1535,  1536,  2234,  2250,  2250,  1423,   470,
     474,  2356,  2399,  2407,     1,  1280,  1281,  2234,  2237,  2237,
    2250,   339,   356,   391,   449,   472,  1424,  1425,  1426,  1427,
    1428,  1429,  1421,  1422,  2312,  2313,  1432,  2250,   211,   225,
    2416,  2349,  2349,   120,   175,  2416,  2417,  2349,  1433,  2250,
    2349,  1422,  1422,   391,  2349,  2349,  1422,     4,   137,   141,
     387,   470,   474,   535,   579,   627,   782,   814,   882,  1323,
    1328,  1329,  1339,  1340,  1359,  1362,  1372,  1375,  1434,  1435,
    1440,  1443,  1446,  1447,  1450,  1455,  1456,  1459,  1460,  1466,
    1467,  2312,  2398,  2399,  2400,  2250,  1422,  1422,  1422,   415,
    2346,   573,  2363,  2364,  2320,  2349,  2265,  2349,  2365,  2349,
    1373,    15,    68,   441,   942,   536,  1457,  1458,  1529,  1530,
    1463,  1464,  1465,  1530,  2265,  2364,  2250,  2351,   533,   536,
     603,  1441,  1442,  1530,  2265,  1344,  2222,  2220,  2222,   119,
     175,   603,   613,   614,   694,   716,   717,  1436,  2416,  2417,
    2418,  2419,  2420,  2421,  2422,   532,  2362,  2362,    15,    68,
    2156,  1457,  2268,  1464,  2268,   115,   456,   718,  1461,  1462,
    2265,  2387,  2297,   702,   901,  1444,  2222,   356,   356,   391,
     356,   391,   357,   584,  2367,  2367,   591,   603,  1448,  1449,
    2250,  1448,  2362,  2362,  2351,  1346,  2366,  2250,   337,  1437,
    2250,    18,   337,  1439,  2250,  1448,   603,   603,   802,  1341,
     337,  1445,  2250,   591,  1438,  1438,  1438,  1438,  2265,   603
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   968,   970,   969,   971,   971,   973,   972,   974,   974,
     975,   975,   975,   975,   977,   976,   978,   979,   980,   980,
     981,   981,   983,   982,   985,   984,   987,   986,   989,   988,
     990,   991,   990,   992,   993,   994,   993,   995,   996,   995,
     997,   997,   998,   999,   998,  1000,  1001,  1000,  1003,  1004,
    1002,  1005,  1005,  1007,  1006,  1008,  1008,  1009,  1010,  1011,
    1012,  1013,  1013,  1014,  1014,  1015,  1015,  1016,  1016,  1017,
    1017,  1017,  1017,  1018,  1018,  1019,  1019,  1020,  1020,  1021,
    1022,  1022,  1023,  1023,  1023,  1023,  1024,  1024,  1025,  1025,
    1026,  1026,  1026,  1027,  1027,  1028,  1028,  1028,  1028,  1029,
    1030,  1030,  1031,  1032,  1033,  1034,  1034,  1035,  1036,  1037,
    1037,  1038,  1038,  1039,  1039,  1039,  1039,  1039,  1040,  1040,
    1042,  1041,  1043,  1043,  1044,  1044,  1046,  1045,  1047,  1047,
    1047,  1047,  1048,  1048,  1049,  1049,  1049,  1049,  1050,  1051,
    1053,  1052,  1054,  1054,  1054,  1054,  1054,  1054,  1055,  1056,
    1057,  1057,  1057,  1057,  1058,  1058,  1059,  1059,  1061,  1060,
    1062,  1062,  1062,  1063,  1063,  1064,  1064,  1064,  1064,  1064,
    1065,  1065,  1066,  1067,  1068,  1068,  1068,  1069,  1069,  1069,
    1069,  1069,  1069,  1069,  1069,  1069,  1069,  1069,  1069,  1069,
    1069,  1069,  1071,  1070,  1072,  1072,  1073,  1073,  1073,  1073,
    1074,  1074,  1075,  1076,  1076,  1078,  1077,  1080,  1079,  1081,
    1079,  1082,  1082,  1083,  1084,  1084,  1084,  1084,  1084,  1085,
    1085,  1085,  1085,  1086,  1086,  1086,  1087,  1087,  1088,  1088,
    1089,  1088,  1090,  1090,  1091,  1091,  1091,  1091,  1091,  1091,
    1092,  1092,  1093,  1093,  1093,  1094,  1094,  1095,  1096,  1097,
    1097,  1098,  1099,  1099,  1100,  1100,  1101,  1102,  1102,  1103,
    1104,  1105,  1105,  1106,  1106,  1107,  1109,  1108,  1110,  1110,
    1111,  1112,  1112,  1113,  1114,  1115,  1116,  1117,  1118,  1120,
    1119,  1121,  1122,  1123,  1123,  1124,  1124,  1125,  1125,  1127,
    1128,  1126,  1129,  1129,  1130,  1130,  1131,  1131,  1131,  1131,
    1131,  1131,  1131,  1131,  1131,  1131,  1131,  1131,  1131,  1131,
    1131,  1131,  1131,  1131,  1131,  1131,  1132,  1132,  1132,  1132,
    1132,  1133,  1133,  1133,  1134,  1134,  1134,  1134,  1134,  1134,
    1134,  1135,  1135,  1135,  1135,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1137,  1138,  1138,  1139,  1139,  1140,  1140,  1141,
    1142,  1142,  1142,  1143,  1144,  1144,  1146,  1145,  1147,  1148,
    1148,  1148,  1149,  1151,  1150,  1152,  1152,  1152,  1152,  1152,
    1152,  1153,  1154,  1155,  1156,  1156,  1156,  1158,  1157,  1159,
    1159,  1159,  1160,  1160,  1160,  1160,  1161,  1161,  1162,  1163,
    1163,  1164,  1164,  1165,  1165,  1165,  1165,  1166,  1168,  1167,
    1169,  1169,  1169,  1169,  1170,  1171,  1171,  1172,  1172,  1174,
    1173,  1173,  1175,  1176,  1177,  1178,  1178,  1179,  1180,  1180,
    1180,  1181,  1182,  1182,  1183,  1184,  1185,  1186,  1187,  1187,
    1188,  1189,  1189,  1189,  1190,  1190,  1191,  1191,  1191,  1191,
    1192,  1193,  1193,  1193,  1193,  1194,  1194,  1194,  1194,  1194,
    1195,  1195,  1195,  1195,  1195,  1195,  1195,  1195,  1197,  1196,
    1198,  1198,  1199,  1200,  1200,  1201,  1202,  1203,  1203,  1204,
    1204,  1204,  1205,  1206,  1206,  1207,  1207,  1208,  1208,  1209,
    1209,  1209,  1211,  1210,  1212,  1212,  1213,  1214,  1215,  1216,
    1216,  1217,  1217,  1218,  1220,  1219,  1219,  1221,  1221,  1222,
    1222,  1223,  1223,  1223,  1223,  1223,  1223,  1223,  1223,  1223,
    1223,  1223,  1224,  1225,  1225,  1225,  1226,  1226,  1226,  1227,
    1227,  1228,  1228,  1229,  1229,  1230,  1231,  1231,  1232,  1232,
    1233,  1233,  1234,  1235,  1236,  1236,  1237,  1237,  1237,  1238,
    1239,  1240,  1241,  1242,  1242,  1242,  1242,  1242,  1243,  1243,
    1244,  1245,  1245,  1246,  1247,  1247,  1248,  1248,  1249,  1250,
    1251,  1250,  1252,  1252,  1253,  1254,  1256,  1255,  1257,  1257,
    1258,  1258,  1258,  1259,  1259,  1259,  1260,  1260,  1261,  1261,
    1261,  1261,  1261,  1261,  1261,  1261,  1261,  1261,  1261,  1262,
    1263,  1263,  1264,  1264,  1265,  1265,  1265,  1265,  1265,  1265,
    1265,  1266,  1266,  1266,  1267,  1267,  1268,  1268,  1268,  1268,
    1268,  1268,  1269,  1270,  1271,  1272,  1271,  1273,  1274,  1273,
    1275,  1275,  1276,  1276,  1276,  1277,  1276,  1276,  1278,  1278,
    1279,  1279,  1280,  1280,  1281,  1282,  1282,  1283,  1283,  1283,
    1284,  1284,  1284,  1284,  1284,  1284,  1284,  1284,  1284,  1284,
    1284,  1284,  1284,  1284,  1284,  1285,  1285,  1286,  1286,  1287,
    1287,  1287,  1288,  1288,  1289,  1290,  1290,  1292,  1291,  1293,
    1293,  1294,  1295,  1294,  1296,  1296,  1297,  1297,  1297,  1298,
    1298,  1299,  1299,  1299,  1299,  1299,  1299,  1299,  1299,  1299,
    1299,  1300,  1300,  1301,  1301,  1302,  1302,  1302,  1302,  1302,
    1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,
    1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,
    1302,  1302,  1302,  1302,  1302,  1303,  1304,  1305,  1305,  1306,
    1307,  1308,  1309,  1309,  1310,  1311,  1311,  1312,  1312,  1313,
    1315,  1314,  1316,  1316,  1316,  1316,  1318,  1317,  1319,  1319,
    1320,  1321,  1321,  1321,  1322,  1324,  1323,  1325,  1325,  1325,
    1326,  1326,  1327,  1328,  1329,  1329,  1329,  1329,  1330,  1330,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1332,  1333,  1333,  1333,  1333,  1334,  1334,  1335,  1335,
    1336,  1336,  1337,  1337,  1337,  1337,  1337,  1337,  1337,  1338,
    1338,  1339,  1339,  1340,  1341,  1341,  1342,  1342,  1342,  1343,
    1343,  1344,  1344,  1345,  1345,  1346,  1346,  1347,  1347,  1348,
    1348,  1349,  1349,  1350,  1349,  1349,  1349,  1351,  1352,  1352,
    1353,  1354,  1354,  1355,  1355,  1356,  1357,  1357,  1358,  1359,
    1360,  1361,  1361,  1361,  1362,  1363,  1364,  1364,  1364,  1364,
    1365,  1365,  1366,  1367,  1368,  1368,  1369,  1370,  1370,  1370,
    1371,  1371,  1372,  1372,  1373,  1373,  1374,  1375,  1377,  1376,
    1378,  1379,  1379,  1380,  1380,  1381,  1381,  1381,  1382,  1383,
    1384,  1384,  1385,  1385,  1386,  1387,  1387,  1388,  1388,  1388,
    1388,  1389,  1390,  1390,  1391,  1392,  1392,  1392,  1392,  1392,
    1392,  1392,  1393,  1394,  1395,  1396,  1396,  1397,  1398,  1399,
    1400,  1401,  1400,  1402,  1403,  1404,  1403,  1405,  1406,  1407,
    1405,  1408,  1408,  1410,  1411,  1409,  1412,  1412,  1412,  1413,
    1413,  1413,  1413,  1414,  1415,  1415,  1415,  1416,  1417,  1417,
    1418,  1419,  1420,  1420,  1420,  1421,  1422,  1422,  1423,  1423,
    1424,  1424,  1424,  1424,  1424,  1424,  1425,  1426,  1427,  1428,
    1429,  1430,  1430,  1432,  1431,  1431,  1433,  1433,  1434,  1434,
    1434,  1434,  1434,  1434,  1434,  1434,  1434,  1434,  1434,  1434,
    1434,  1434,  1434,  1434,  1434,  1435,  1436,  1436,  1436,  1436,
    1436,  1436,  1436,  1437,  1437,  1437,  1438,  1438,  1439,  1439,
    1439,  1439,  1440,  1441,  1441,  1441,  1442,  1442,  1442,  1443,
    1444,  1444,  1444,  1445,  1445,  1446,  1446,  1446,  1446,  1446,
    1447,  1447,  1448,  1448,  1449,  1449,  1449,  1450,  1451,  1451,
    1452,  1453,  1453,  1454,  1454,  1455,  1456,  1456,  1457,  1457,
    1458,  1458,  1459,  1460,  1461,  1461,  1462,  1462,  1462,  1463,
    1463,  1464,  1464,  1465,  1466,  1467,  1468,  1469,  1470,  1468,
    1471,  1471,  1472,  1472,  1473,  1474,  1473,  1475,  1476,  1473,
    1473,  1477,  1477,  1478,  1478,  1478,  1478,  1478,  1478,  1478,
    1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,
    1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,
    1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,
    1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,  1478,
    1478,  1478,  1479,  1480,  1480,  1481,  1481,  1482,  1482,  1482,
    1482,  1482,  1482,  1482,  1482,  1482,  1482,  1482,  1482,  1482,
    1482,  1482,  1482,  1483,  1483,  1484,  1484,  1485,  1485,  1486,
    1486,  1487,  1487,  1487,  1488,  1488,  1489,  1489,  1490,  1490,
    1490,  1490,  1490,  1490,  1490,  1490,  1490,  1490,  1490,  1490,
    1490,  1490,  1491,  1491,  1491,  1491,  1491,  1491,  1491,  1491,
    1491,  1491,  1491,  1491,  1491,  1491,  1491,  1492,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1493,  1493,  1494,
    1494,  1494,  1494,  1494,  1495,  1496,  1496,  1496,  1496,  1496,
    1496,  1496,  1496,  1496,  1496,  1496,  1496,  1496,  1496,  1496,
    1497,  1497,  1497,  1497,  1497,  1497,  1497,  1497,  1497,  1497,
    1498,  1498,  1498,  1498,  1498,  1498,  1498,  1498,  1498,  1498,
    1499,  1499,  1500,  1500,  1501,  1501,  1502,  1502,  1502,  1502,
    1502,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,
    1503,  1503,  1503,  1503,  1503,  1503,  1503,  1504,  1504,  1504,
    1505,  1505,  1505,  1505,  1505,  1505,  1505,  1505,  1506,  1506,
    1506,  1506,  1506,  1506,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1508,  1508,  1508,  1508,  1509,  1509,  1509,  1510,
    1510,  1510,  1510,  1510,  1510,  1511,  1511,  1511,  1511,  1512,
    1512,  1512,  1512,  1512,  1512,  1512,  1513,  1513,  1513,  1513,
    1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,
    1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,
    1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,
    1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,  1513,
    1513,  1513,  1513,  1514,  1514,  1514,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1517,  1518,
    1519,  1519,  1519,  1519,  1519,  1519,  1519,  1519,  1520,  1520,
    1520,  1521,  1521,  1522,  1523,  1523,  1524,  1524,  1525,  1525,
    1526,  1526,  1526,  1527,  1527,  1528,  1528,  1529,  1529,  1530,
    1531,  1531,  1532,  1533,  1533,  1534,  1535,  1535,  1536,  1536,
    1537,  1538,  1538,  1538,  1539,  1540,  1540,  1540,  1541,  1542,
    1543,  1543,  1544,  1544,  1546,  1547,  1548,  1549,  1545,  1550,
    1545,  1551,  1552,  1551,  1553,  1551,  1554,  1554,  1555,  1556,
    1556,  1556,  1557,  1557,  1558,  1558,  1558,  1558,  1558,  1559,
    1560,  1560,  1561,  1561,  1562,  1562,  1562,  1563,  1564,  1565,
    1566,  1563,  1567,  1567,  1568,  1568,  1569,  1568,  1568,  1568,
    1570,  1570,  1572,  1571,  1573,  1573,  1574,  1575,  1576,  1576,
    1578,  1579,  1577,  1581,  1580,  1580,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1583,  1582,  1582,  1585,  1584,  1587,  1586,  1588,  1586,
    1586,  1586,  1586,  1586,  1586,  1586,  1586,  1586,  1586,  1586,
    1586,  1586,  1586,  1586,  1586,  1586,  1586,  1586,  1586,  1586,
    1586,  1586,  1586,  1589,  1589,  1591,  1590,  1592,  1592,  1593,
    1593,  1593,  1594,  1594,  1594,  1595,  1595,  1596,  1596,  1597,
    1597,  1598,  1598,  1598,  1598,  1598,  1599,  1599,  1600,  1600,
    1601,  1601,  1602,  1602,  1602,  1603,  1604,  1605,  1606,  1606,
    1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,
    1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,
    1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,  1606,
    1606,  1606,  1606,  1606,  1607,  1607,  1608,  1609,  1609,  1609,
    1610,  1610,  1610,  1611,  1611,  1612,  1612,  1614,  1613,  1615,
    1615,  1615,  1615,  1616,  1616,  1617,  1617,  1619,  1618,  1620,
    1620,  1621,  1621,  1622,  1622,  1624,  1623,  1625,  1625,  1626,
    1627,  1627,  1629,  1628,  1631,  1630,  1632,  1633,  1632,  1634,
    1634,  1634,  1635,  1635,  1636,  1636,  1636,  1636,  1636,  1636,
    1637,  1637,  1638,  1638,  1639,  1639,  1640,  1641,  1640,  1642,
    1642,  1643,  1643,  1643,  1644,  1644,  1644,  1644,  1645,  1645,
    1645,  1645,  1645,  1646,  1646,  1647,  1647,  1648,  1648,  1648,
    1649,  1649,  1650,  1650,  1651,  1651,  1652,  1653,  1653,  1655,
    1654,  1656,  1656,  1657,  1657,  1658,  1658,  1660,  1659,  1661,
    1661,  1662,  1662,  1663,  1663,  1663,  1663,  1663,  1665,  1664,
    1666,  1666,  1668,  1667,  1669,  1670,  1670,  1671,  1673,  1672,
    1674,  1675,  1674,  1677,  1676,  1678,  1678,  1680,  1679,  1681,
    1681,  1682,  1682,  1683,  1683,  1685,  1684,  1686,  1687,  1687,
    1688,  1688,  1688,  1688,  1688,  1690,  1689,  1691,  1691,  1691,
    1691,  1691,  1691,  1691,  1691,  1691,  1691,  1691,  1691,  1692,
    1692,  1693,  1693,  1695,  1694,  1696,  1696,  1697,  1697,  1698,
    1698,  1699,  1699,  1700,  1700,  1700,  1700,  1700,  1701,  1701,
    1702,  1702,  1702,  1702,  1703,  1703,  1705,  1704,  1706,  1708,
    1707,  1709,  1709,  1710,  1710,  1710,  1712,  1711,  1713,  1713,
    1714,  1714,  1715,  1715,  1715,  1715,  1715,  1717,  1718,  1716,
    1719,  1719,  1721,  1722,  1720,  1724,  1723,  1725,  1725,  1725,
    1726,  1726,  1727,  1727,  1728,  1728,  1728,  1729,  1729,  1730,
    1730,  1730,  1730,  1730,  1730,  1730,  1730,  1731,  1732,  1733,
    1733,  1733,  1734,  1734,  1734,  1734,  1735,  1735,  1736,  1736,
    1737,  1738,  1739,  1739,  1739,  1739,  1739,  1739,  1739,  1739,
    1739,  1739,  1739,  1739,  1739,  1739,  1739,  1739,  1739,  1739,
    1739,  1739,  1739,  1739,  1739,  1740,  1740,  1742,  1741,  1743,
    1743,  1743,  1743,  1743,  1744,  1744,  1746,  1745,  1747,  1749,
    1748,  1750,  1748,  1751,  1752,  1754,  1753,  1755,  1756,  1756,
    1757,  1757,  1757,  1758,  1758,  1759,  1759,  1760,  1760,  1760,
    1761,  1761,  1761,  1763,  1762,  1764,  1762,  1765,  1765,  1766,
    1766,  1766,  1766,  1766,  1767,  1767,  1768,  1768,  1770,  1769,
    1772,  1771,  1773,  1773,  1774,  1774,  1775,  1775,  1776,  1776,
    1778,  1777,  1779,  1779,  1779,  1779,  1779,  1779,  1779,  1780,
    1780,  1780,  1780,  1782,  1781,  1783,  1785,  1784,  1786,  1788,
    1787,  1789,  1789,  1790,  1790,  1792,  1791,  1794,  1793,  1795,
    1795,  1795,  1796,  1796,  1797,  1798,  1799,  1799,  1801,  1800,
    1802,  1803,  1803,  1804,  1804,  1804,  1805,  1805,  1806,  1806,
    1807,  1808,  1808,  1808,  1808,  1808,  1808,  1808,  1809,  1809,
    1811,  1810,  1812,  1812,  1814,  1813,  1815,  1815,  1817,  1816,
    1818,  1819,  1819,  1820,  1820,  1820,  1821,  1821,  1821,  1821,
    1823,  1822,  1825,  1824,  1824,  1826,  1826,  1826,  1827,  1827,
    1827,  1827,  1828,  1828,  1829,  1829,  1831,  1830,  1832,  1833,
    1834,  1834,  1835,  1835,  1835,  1835,  1835,  1835,  1836,  1836,
    1837,  1837,  1838,  1838,  1838,  1838,  1838,  1839,  1840,  1840,
    1840,  1840,  1840,  1841,  1842,  1843,  1845,  1844,  1847,  1848,
    1846,  1849,  1849,  1850,  1850,  1851,  1852,  1852,  1854,  1853,
    1855,  1856,  1856,  1858,  1857,  1860,  1859,  1861,  1861,  1862,
    1862,  1864,  1863,  1865,  1865,  1867,  1866,  1868,  1868,  1869,
    1869,  1871,  1870,  1872,  1872,  1873,  1874,  1874,  1875,  1875,
    1875,  1875,  1876,  1876,  1877,  1877,  1877,  1877,  1877,  1878,
    1878,  1879,  1879,  1879,  1880,  1880,  1880,  1881,  1881,  1881,
    1882,  1882,  1883,  1883,  1883,  1885,  1884,  1886,  1887,  1886,
    1888,  1886,  1889,  1889,  1890,  1890,  1891,  1891,  1892,  1892,
    1892,  1892,  1892,  1893,  1893,  1894,  1894,  1895,  1895,  1896,
    1897,  1897,  1899,  1898,  1901,  1900,  1902,  1902,  1903,  1905,
    1904,  1906,  1907,  1907,  1908,  1908,  1908,  1908,  1909,  1909,
    1910,  1910,  1911,  1911,  1912,  1913,  1913,  1913,  1914,  1914,
    1915,  1915,  1915,  1916,  1916,  1917,  1917,  1918,  1918,  1919,
    1921,  1920,  1922,  1923,  1923,  1924,  1924,  1924,  1925,  1925,
    1926,  1927,  1927,  1928,  1929,  1929,  1931,  1930,  1932,  1933,
    1935,  1934,  1936,  1937,  1937,  1939,  1938,  1940,  1941,  1941,
    1942,  1942,  1943,  1943,  1944,  1945,  1947,  1946,  1948,  1946,
    1949,  1950,  1951,  1951,  1952,  1952,  1953,  1954,  1954,  1955,
    1956,  1956,  1958,  1957,  1959,  1959,  1960,  1961,  1962,  1962,
    1963,  1964,  1964,  1965,  1965,  1965,  1965,  1966,  1966,  1968,
    1967,  1969,  1969,  1969,  1969,  1969,  1969,  1969,  1969,  1970,
    1970,  1971,  1971,  1972,  1973,  1974,  1974,  1975,  1975,  1975,
    1975,  1975,  1975,  1975,  1975,  1976,  1976,  1976,  1976,  1976,
    1977,  1978,  1978,  1979,  1980,  1980,  1981,  1981,  1982,  1983,
    1985,  1984,  1987,  1986,  1988,  1988,  1989,  1989,  1990,  1990,
    1991,  1991,  1992,  1992,  1992,  1993,  1993,  1993,  1995,  1994,
    1996,  1997,  1997,  1998,  1998,  1998,  1998,  1999,  1999,  1999,
    1999,  1999,  1999,  2000,  2000,  2001,  2001,  2002,  2004,  2003,
    2003,  2003,  2003,  2005,  2005,  2005,  2005,  2005,  2006,  2006,
    2007,  2007,  2008,  2008,  2008,  2008,  2010,  2009,  2011,  2013,
    2012,  2014,  2014,  2015,  2016,  2016,  2017,  2017,  2018,  2018,
    2019,  2019,  2021,  2020,  2022,  2022,  2022,  2022,  2023,  2023,
    2025,  2024,  2026,  2026,  2028,  2027,  2029,  2029,  2031,  2030,
    2032,  2034,  2033,  2035,  2037,  2036,  2038,  2039,  2039,  2040,
    2040,  2041,  2042,  2042,  2043,  2044,  2044,  2045,  2045,  2046,
    2046,  2048,  2047,  2049,  2049,  2051,  2050,  2052,  2052,  2052,
    2052,  2052,  2053,  2054,  2054,  2055,  2055,  2055,  2055,  2055,
    2056,  2057,  2057,  2058,  2058,  2058,  2059,  2059,  2059,  2059,
    2060,  2061,  2061,  2062,  2063,  2064,  2064,  2065,  2065,  2066,
    2066,  2068,  2067,  2069,  2070,  2070,  2071,  2071,  2071,  2071,
    2072,  2072,  2073,  2073,  2073,  2074,  2074,  2075,  2077,  2076,
    2079,  2080,  2078,  2081,  2081,  2082,  2082,  2083,  2084,  2084,
    2084,  2085,  2085,  2086,  2086,  2087,  2087,  2088,  2088,  2089,
    2090,  2090,  2091,  2091,  2092,  2092,  2093,  2093,  2094,  2094,
    2095,  2096,  2096,  2097,  2097,  2097,  2098,  2098,  2099,  2099,
    2100,  2100,  2100,  2101,  2101,  2101,  2102,  2102,  2103,  2103,
    2105,  2104,  2107,  2106,  2108,  2108,  2109,  2109,  2110,  2110,
    2111,  2111,  2112,  2112,  2112,  2113,  2113,  2114,  2115,  2115,
    2116,  2116,  2117,  2118,  2118,  2119,  2119,  2119,  2120,  2120,
    2121,  2122,  2122,  2123,  2124,  2124,  2124,  2125,  2125,  2126,
    2127,  2127,  2128,  2129,  2129,  2129,  2130,  2130,  2131,  2132,
    2132,  2133,  2134,  2134,  2135,  2135,  2136,  2136,  2137,  2138,
    2138,  2139,  2140,  2140,  2141,  2141,  2142,  2143,  2143,  2144,
    2145,  2145,  2146,  2146,  2147,  2147,  2148,  2149,  2149,  2150,
    2151,  2151,  2152,  2152,  2153,  2153,  2154,  2154,  2155,  2155,
    2156,  2156,  2157,  2159,  2158,  2160,  2160,  2161,  2161,  2161,
    2161,  2161,  2161,  2161,  2161,  2161,  2161,  2161,  2161,  2161,
    2161,  2161,  2161,  2161,  2161,  2161,  2161,  2161,  2161,  2162,
    2162,  2163,  2165,  2164,  2166,  2166,  2167,  2167,  2167,  2167,
    2167,  2167,  2167,  2167,  2167,  2167,  2167,  2167,  2167,  2167,
    2167,  2167,  2167,  2167,  2167,  2167,  2167,  2168,  2168,  2169,
    2170,  2170,  2170,  2170,  2170,  2170,  2170,  2170,  2170,  2170,
    2170,  2170,  2170,  2170,  2171,  2171,  2172,  2172,  2173,  2173,
    2174,  2175,  2176,  2176,  2177,  2177,  2177,  2178,  2178,  2178,
    2179,  2179,  2179,  2179,  2179,  2179,  2179,  2179,  2179,  2179,
    2180,  2180,  2181,  2181,  2181,  2181,  2182,  2182,  2183,  2183,
    2183,  2183,  2183,  2183,  2184,  2184,  2185,  2186,  2187,  2187,
    2188,  2189,  2189,  2190,  2190,  2191,  2192,  2193,  2194,  2194,
    2195,  2196,  2196,  2197,  2198,  2198,  2199,  2200,  2200,  2200,
    2201,  2202,  2202,  2203,  2204,  2204,  2205,  2205,  2206,  2207,
    2207,  2208,  2209,  2209,  2210,  2210,  2211,  2212,  2212,  2213,
    2213,  2213,  2214,  2214,  2215,  2215,  2216,  2216,  2217,  2217,
    2218,  2218,  2218,  2218,  2218,  2218,  2218,  2218,  2218,  2219,
    2220,  2220,  2221,  2221,  2221,  2222,  2222,  2222,  2222,  2222,
    2222,  2222,  2223,  2223,  2223,  2223,  2223,  2223,  2224,  2225,
    2226,  2227,  2227,  2228,  2228,  2229,  2230,  2230,  2231,  2231,
    2232,  2232,  2232,  2233,  2233,  2234,  2234,  2235,  2235,  2235,
    2236,  2236,  2236,  2237,  2237,  2237,  2238,  2238,  2239,  2239,
    2240,  2240,  2241,  2241,  2241,  2242,  2243,  2244,  2244,  2245,
    2246,  2247,  2248,  2249,  2250,  2251,  2251,  2251,  2251,  2252,
    2252,  2253,  2253,  2254,  2255,  2255,  2256,  2256,  2256,  2256,
    2257,  2257,  2258,  2259,  2259,  2261,  2260,  2262,  2262,  2263,
    2264,  2264,  2265,  2266,  2267,  2268,  2268,  2269,  2269,  2270,
    2270,  2270,  2270,  2270,  2270,  2271,  2271,  2272,  2272,  2273,
    2273,  2274,  2274,  2274,  2274,  2275,  2275,  2275,  2275,  2275,
    2275,  2275,  2275,  2275,  2275,  2275,  2275,  2275,  2275,  2276,
    2276,  2277,  2277,  2277,  2277,  2278,  2278,  2278,  2278,  2278,
    2279,  2279,  2279,  2280,  2280,  2280,  2281,  2281,  2281,  2283,
    2282,  2284,  2284,  2285,  2285,  2286,  2286,  2287,  2287,  2288,
    2289,  2289,  2290,  2290,  2290,  2291,  2291,  2292,  2292,  2293,
    2293,  2294,  2294,  2294,  2295,  2295,  2296,  2296,  2296,  2297,
    2297,  2298,  2298,  2299,  2299,  2299,  2299,  2299,  2299,  2299,
    2299,  2300,  2300,  2301,  2301,  2302,  2302,  2303,  2303,  2303,
    2303,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,
    2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,
    2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,
    2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,
    2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,  2304,
    2304,  2304,  2304,  2305,  2305,  2305,  2305,  2305,  2305,  2305,
    2305,  2305,  2305,  2305,  2305,  2305,  2305,  2305,  2305,  2305,
    2305,  2305,  2305,  2305,  2305,  2305,  2306,  2306,  2307,  2307,
    2308,  2309,  2309,  2309,  2310,  2311,  2312,  2313,  2313,  2313,
    2314,  2314,  2314,  2314,  2315,  2315,  2315,  2316,  2316,  2316,
    2316,  2316,  2316,  2316,  2317,  2317,  2317,  2318,  2318,  2319,
    2319,  2320,  2320,  2321,  2321,  2322,  2322,  2322,  2323,  2323,
    2324,  2324,  2325,  2325,  2326,  2326,  2327,  2327,  2328,  2328,
    2329,  2329,  2330,  2330,  2331,  2331,  2332,  2332,  2333,  2333,
    2334,  2334,  2335,  2335,  2336,  2336,  2337,  2337,  2338,  2338,
    2339,  2339,  2340,  2340,  2341,  2341,  2342,  2342,  2343,  2343,
    2343,  2344,  2344,  2344,  2345,  2345,  2346,  2346,  2347,  2347,
    2348,  2348,  2349,  2349,  2350,  2350,  2350,  2351,  2351,  2351,
    2352,  2352,  2352,  2352,  2353,  2353,  2353,  2354,  2354,  2355,
    2355,  2356,  2356,  2356,  2357,  2357,  2357,  2358,  2358,  2359,
    2359,  2360,  2360,  2361,  2361,  2362,  2362,  2363,  2363,  2364,
    2364,  2365,  2365,  2366,  2366,  2367,  2367,  2367,  2368,  2368,
    2368,  2368,  2369,  2369,  2370,  2370,  2371,  2371,  2372,  2372,
    2373,  2373,  2374,  2374,  2375,  2375,  2375,  2376,  2376,  2377,
    2377,  2378,  2378,  2379,  2379,  2379,  2380,  2380,  2381,  2381,
    2382,  2382,  2383,  2383,  2384,  2384,  2385,  2385,  2386,  2386,
    2387,  2387,  2388,  2388,  2389,  2389,  2390,  2390,  2391,  2391,
    2392,  2392,  2393,  2393,  2393,  2394,  2394,  2395,  2395,  2396,
    2396,  2397,  2397,  2398,  2398,  2399,  2399,  2400,  2400,  2401,
    2401,  2401,  2401,  2402,  2402,  2403,  2403,  2404,  2404,  2405,
    2405,  2406,  2406,  2407,  2407,  2408,  2408,  2409,  2409,  2409,
    2410,  2410,  2411,  2411,  2412,  2412,  2413,  2413,  2414,  2414,
    2415,  2415,  2416,  2416,  2417,  2417,  2418,  2418,  2419,  2419,
    2420,  2420,  2421,  2421,  2422,  2422,  2423,  2423
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     3,     1,     2,
       1,     1,     1,     1,     0,     2,     4,     4,     0,     1,
       1,     2,     0,     4,     0,     4,     0,    13,     0,    13,
       0,     0,     6,     1,     0,     0,     5,     0,     0,     5,
       0,     3,     0,     0,     4,     0,     0,     4,     0,     0,
       6,     0,     1,     0,     4,     1,     1,     1,     6,     1,
       5,     1,     1,     1,     1,     0,     2,     0,     3,     1,
       1,     1,     1,     2,     2,     1,     1,     0,     3,     5,
       0,     3,     1,     1,     1,     1,     0,     5,     0,     3,
       1,     1,     1,     0,     4,     1,     1,     1,     1,     3,
       0,     1,     1,     3,     2,     0,     1,     1,     3,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     0,     1,
       0,     4,     0,     3,     0,     3,     0,     4,     0,     2,
       3,     2,     1,     2,     1,     1,     1,     1,     5,     2,
       0,     4,     2,     3,     4,     4,     8,     8,     3,     4,
       1,     1,     1,     1,     1,     2,     0,     1,     0,     4,
       0,     2,     3,     1,     2,     3,     3,     3,     3,     3,
       1,     2,     2,     2,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     3,     1,     1,     2,     3,     3,     1,
       0,     1,     1,     3,     4,     0,     4,     0,     4,     0,
       4,     0,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     2,     1,     3,
       0,     4,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     2,     0,     2,     2,     4,     1,
       2,     3,     1,     2,     1,     2,     3,     1,     2,     3,
       6,     1,     2,     1,     3,     4,     0,     4,     1,     1,
       5,     0,     3,     3,     5,     3,     4,     3,     3,     0,
       4,     4,     1,     0,     3,     0,     2,     0,     2,     0,
       0,     6,     2,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     5,     6,     6,
       4,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     1,     4,
       1,     1,     1,     9,     0,     1,     0,     4,     1,     0,
       4,     3,     1,     0,     4,     2,     3,     4,     4,     8,
       8,     6,     1,     5,     0,     1,     1,     0,     5,     2,
       2,     2,     0,     5,     6,     1,     0,     1,     2,     0,
       2,     3,     1,     1,     3,     1,     2,     4,     0,     5,
       1,     1,     1,     1,     7,     0,     2,     1,     2,     0,
       2,     2,     1,     4,     3,     1,     1,     3,     2,     2,
       2,     3,     3,     4,     4,     4,     4,     4,     0,     2,
       2,     0,     2,     3,     1,     2,     1,     1,     1,     1,
       5,     0,     1,     1,     1,     4,     4,     4,     4,     1,
       6,     6,     7,     4,     6,     4,     6,     4,     0,     6,
       1,     2,     2,     0,     2,     6,     2,     2,     3,     0,
       1,     5,     2,     0,     1,     2,     3,     1,     2,     1,
       1,     1,     0,    10,     0,     1,     1,     3,     1,     0,
       3,     0,     2,     2,     0,     5,     3,     1,     1,     0,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     0,     1,     1,     4,     7,     9,     0,
       3,     0,     2,     0,     2,     3,     5,     5,     1,     1,
       1,     1,     3,     5,     0,     2,     1,     1,     1,     4,
       2,     2,     4,     1,     1,     1,     1,     1,     1,     1,
       4,     0,     2,     2,     2,     2,     1,     2,     1,     0,
       0,     5,     0,     2,     2,     1,     0,     5,     0,     2,
       4,     3,     4,     0,     1,     1,     1,     2,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,    11,
       0,     1,     1,     2,     4,     4,     4,     6,     4,     3,
       4,     0,     1,     1,     1,     2,     4,     4,     4,     4,
       4,     4,     6,     1,     0,     0,     5,     0,     0,     2,
       2,     3,     1,     1,     1,     0,     4,     3,     2,     2,
       0,     1,     1,     1,     1,     0,     2,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     6,     0,     2,     0,     4,     0,
       1,     5,     0,     7,     2,     2,     1,     3,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     0,     1,     3,
       3,     3,     0,     1,     3,     0,     2,     0,     1,     2,
       0,     4,     1,     2,     1,     1,     0,     4,     1,     1,
       3,     1,     1,     1,     1,     0,     3,     0,     5,     3,
       0,     2,     1,     3,     2,     3,     3,     3,     0,     2,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     4,     3,     3,     3,     4,     3,     3,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     3,     0,     1,     2,     3,     0,     2,     0,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     0,
       1,     3,     3,     6,     0,     2,     6,     8,     7,     0,
       2,     0,     2,     0,     2,     0,     3,     0,     3,     0,
       1,     0,     2,     0,     3,     1,     1,     1,     1,     2,
       4,     1,     1,     0,     1,     3,     1,     2,     1,     2,
       2,     0,     1,     1,     3,     1,     3,     3,     4,     5,
       1,     2,     3,     2,     0,     2,     3,     0,     3,     3,
       1,     3,     2,     2,     1,     2,     1,     2,     0,     4,
       1,     1,     2,     3,     1,     0,     1,     1,     4,     3,
       1,     1,     0,     2,     7,     2,     3,     0,     2,     2,
       2,     3,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     2,     2,     2,     4,     1,
       0,     0,     5,     1,     0,     0,     5,     0,     0,     0,
       6,     0,     2,     0,     0,     7,     0,     2,     2,     2,
       4,     1,     1,     2,     2,     1,     1,     1,     1,     2,
       1,     4,     2,     1,     3,     2,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     3,     3,     4,     4,     4,
       3,     0,     2,     0,     5,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     3,     3,
       1,     1,     1,     0,     2,     2,     0,     2,     0,     2,
       2,     1,     3,     1,     2,     1,     1,     1,     1,     4,
       0,     3,     2,     1,     1,     3,     4,     5,     4,     5,
       1,     1,     0,     2,     1,     1,     1,     2,     1,     2,
       3,     0,     2,     0,     2,     2,     3,     2,     0,     2,
       1,     2,     2,     4,     0,     1,     1,     1,     1,     2,
       1,     1,     2,     1,     4,     2,     0,     0,     0,     6,
       0,     1,     2,     3,     1,     0,     4,     0,     0,     7,
       3,     0,     2,     2,     2,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     1,     1,     2,     3,     2,     2,     2,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     0,     2,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       2,     1,     3,     5,     3,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     3,     1,     2,
       3,     3,     3,     1,     2,     1,     2,     0,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     0,     1,
       4,     0,     1,     1,     4,     0,     1,     1,     3,     2,
       0,     2,     0,     1,     0,     0,     0,     0,    13,     0,
       4,     0,     0,     3,     0,     3,     1,     2,     5,     0,
       2,     2,     0,     1,     3,     3,     4,     2,     1,     3,
       0,     5,     0,     1,     0,     2,     2,     0,     0,     0,
       0,     9,     0,     2,     1,     1,     0,     3,     1,     1,
       1,     1,     0,     6,     0,     2,     2,     2,     0,     1,
       0,     0,     3,     0,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     3,     2,     0,     4,     0,     4,     0,     5,
       3,     3,     3,     3,     4,     3,     4,     3,     3,     4,
       4,     4,     3,     4,     3,     4,     5,     3,     4,     3,
       3,     2,     3,     1,     1,     0,     3,     0,     1,     5,
       4,     4,     1,     3,     3,     1,     1,     0,     1,     1,
       2,     1,     1,     1,     2,     3,     1,     2,     1,     3,
       1,     2,     2,     2,     2,     3,     3,     3,     1,     1,
       1,     2,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     1,     1,
       1,     1,     4,     1,     2,     1,     1,     3,     3,     3,
       3,     3,     3,     4,     0,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     0,     4,     4,
       5,     6,     8,     0,     2,     0,     1,     0,     3,     4,
       5,     0,     2,     0,     2,     0,     3,     1,     2,     4,
       0,     2,     0,     4,     0,     9,     0,     0,     4,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     2,     1,     1,     0,     0,     3,     1,
       2,     2,     2,     3,     0,     2,     2,     2,     0,     3,
       2,     2,     4,     1,     1,     1,     1,     0,     2,     2,
       0,     1,     2,     2,     0,     1,     2,     0,     1,     0,
       3,     1,     1,     1,     2,     1,     1,     0,     3,     1,
       1,     2,     3,     0,     1,     3,     3,     2,     0,     4,
       0,     3,     0,     4,     4,     0,     1,     1,     0,     3,
       0,     0,     4,     0,     3,     2,     1,     0,     4,     4,
       3,     1,     2,     0,     1,     0,     3,     3,     0,     3,
       0,     2,     1,     2,     1,     0,     4,     3,     3,     3,
       3,     2,     4,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     2,     0,     3,     1,     1,     0,     2,     1,
       2,     1,     2,     1,     2,     1,     1,     2,     0,     1,
       2,     2,     2,     2,     1,     1,     0,     3,     2,     0,
       3,     1,     2,     1,     1,     1,     0,     5,     0,     1,
       1,     2,     3,     3,     3,     3,     2,     0,     0,     5,
       1,     1,     0,     0,     7,     0,     5,     1,     1,     1,
       0,     1,     0,     2,     1,     2,     1,     1,     2,     1,
       2,     1,     5,     1,     1,     1,     2,     1,     1,     0,
       1,     1,     1,     1,     0,     1,     3,     3,     1,     1,
       4,     3,     1,     2,     2,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       3,     3,     3,     3,     3,     0,     1,     0,     4,     4,
       6,     6,     8,     8,     0,     1,     0,     3,     1,     0,
       3,     0,     6,     4,     1,     0,     4,     2,     1,     3,
       1,     1,     1,     2,     1,     1,     2,     2,     2,     2,
       3,     3,     3,     0,     3,     0,     4,     1,     3,     2,
       1,     1,     1,     1,     0,     2,     0,     1,     0,     3,
       0,     7,     0,     1,     0,     1,     1,     2,     1,     1,
       0,     3,     0,     2,     1,     2,     1,     1,     1,     0,
       2,     2,     3,     0,     3,     1,     0,     3,     1,     0,
       3,     3,     4,     0,     3,     0,     3,     0,     6,     5,
       3,     2,     0,     1,     0,     0,     0,     1,     0,     3,
       5,     0,     2,     0,     3,     3,     0,     2,     1,     2,
       4,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       0,     3,     1,     2,     0,     3,     2,     2,     0,     3,
       3,     0,     1,     1,     1,     1,     2,     1,     1,     1,
       0,     4,     0,     5,     5,     1,     1,     2,     1,     1,
       1,     2,     0,     3,     1,     1,     0,     3,     2,     5,
       1,     2,     2,     2,     1,     1,     1,     2,     1,     2,
       4,     2,     0,     1,     1,     1,     1,     4,     0,     1,
       1,     2,     2,     3,     3,     1,     0,     5,     0,     0,
       9,     0,     2,     1,     2,     1,     0,     1,     0,     5,
       7,     0,     2,     0,     3,     0,     4,     2,     2,     0,
       1,     0,     3,     3,     4,     0,     4,     4,     6,     0,
       1,     0,     3,     1,     2,     6,     0,     1,     1,     1,
       1,     1,     0,     3,     0,     1,     1,     2,     1,     2,
       2,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     1,     0,     3,     4,     0,     6,
       0,     5,     0,     1,     1,     1,     1,     3,     0,     2,
       1,     3,     3,     0,     3,     1,     1,     1,     3,     6,
       0,     2,     0,     3,     0,     3,     2,     1,     1,     0,
       4,     7,     0,     2,     0,     1,     2,     1,     2,     3,
       3,     1,     0,     1,     1,     4,     4,     2,     0,     1,
       1,     3,     2,     0,     3,     1,     1,     0,     1,     1,
       0,     4,     5,     1,     1,     0,     2,     2,     0,     1,
       2,     0,     1,     2,     0,     1,     0,     3,     2,     1,
       0,     4,     4,     0,     1,     0,     4,     5,     0,     1,
       2,     3,     0,     1,     1,     1,     0,     4,     0,     5,
       4,     5,     0,     2,     0,     3,     0,     1,     2,     3,
       0,     1,     0,     3,     2,     1,     5,     1,     0,     1,
       2,     2,     5,     2,     2,     2,     2,     0,     2,     0,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     3,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     4,     7,     7,     3,     5,
       4,     1,     2,     3,     1,     2,     3,     3,     4,     4,
       0,     3,     0,     7,     0,     5,     0,     2,     0,     3,
       0,     1,     0,     2,     4,     0,     2,     4,     0,     4,
       4,     0,     3,     0,     4,     1,     1,     1,     2,     2,
       2,     2,     1,     2,     1,     0,     1,     1,     0,     4,
       2,     2,     2,     0,     2,     1,     4,     4,     0,     1,
       1,     1,     1,     1,     1,     1,     0,     4,     5,     0,
       2,     1,     2,     2,     0,     3,     1,     1,     0,     4,
       0,     1,     0,     4,     4,     6,     6,     8,     0,     1,
       0,     3,     0,     1,     0,     3,     1,     2,     0,     3,
       6,     0,     3,     2,     0,     4,     6,     0,     3,     1,
       3,     2,     2,     2,     3,     0,     3,     0,     3,     0,
       1,     0,     3,     1,     2,     0,     3,     1,     1,     1,
       1,     1,     7,     0,     1,     1,     1,     1,     1,     1,
       4,     1,     2,     1,     2,     3,     0,     1,     2,     1,
       3,     1,     1,     4,     2,     1,     2,     1,     2,     1,
       1,     0,     4,     6,     0,     2,     0,     4,     3,     3,
       1,     1,     0,     1,     1,     0,     1,     1,     0,     5,
       0,     0,    12,     0,     1,     1,     2,     2,     2,     1,
       1,     0,     4,     0,     3,     0,     3,     1,     2,     3,
       0,     3,     1,     2,     3,     3,     0,     3,     1,     2,
       3,     0,     1,     1,     1,     1,     0,     2,     1,     2,
       1,     2,     2,     2,     2,     1,     1,     3,     0,     1,
       0,     5,     0,    10,     0,     3,     0,     2,     0,     3,
       1,     2,     0,     2,     2,     0,     1,     3,     1,     1,
       0,     1,     2,     1,     1,     0,     2,     2,     0,     1,
       2,     0,     1,     2,     0,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     2,     2,     0,     1,     2,     0,
       1,     2,     2,     2,     2,     2,     0,     1,     2,     0,
       1,     2,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     1,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     2,     0,     3,     2,     1,     0,     2,     0,     3,
       1,     1,     1,     0,     2,     1,     2,     1,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     2,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     0,     1,     1,     3,     3,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       3,     1,     2,     2,     2,     1,     3,     1,     1,     3,
       1,     3,     1,     3,     1,     2,     2,     1,     1,     2,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     2,
       1,     1,     2,     1,     0,     2,     1,     1,     1,     3,
       1,     1,     2,     1,     0,     1,     1,     2,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     3,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     4,     3,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     3,     2,     2,     1,     1,
       2,     1,     2,     1,     1,     1,     3,     2,     2,     1,
       0,     1,     1,     1,     3,     0,     2,     1,     3,     3,
       4,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     2,     5,     5,     5,     5,
       6,     5,     5,     5,     5,     5,     5,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     4,     5,     0,     3,     2,     1,     3,     3,     0,
       2,     1,     3,     1,     3,     1,     3,     1,     3,     0,
       0,     1,     0,     3,     2,     0,     1,     0,     2,     0,
       2,     0,     1,     1,     0,     1,     0,     1,     2,     0,
       2,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     0,     5,     0,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     3,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     1,     2,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     1,     1,
       0,     1,     1,     1,     0,     1,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     2,     2,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     1,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     2,
       1,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     2,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     3,
       0,     1,     0,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     2,     1,     2,     1,
       2,     1,     2,     1,     2,     1,     2,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= TOKEN_EOF)
    {
      yychar = TOKEN_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 3347 "parser.y"
  {
	backup_source_file = cb_source_file;
	clear_initial_values ();
	current_program = NULL;
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;
	current_program = cb_build_program (NULL, 0);
	cb_source_file = "register-definition";
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
	cb_source_file = backup_source_file;
  }
#line 14694 "parser.c"
    break;

  case 3: /* start: $@1 compilation_group  */
#line 3362 "parser.y"
  {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		emit_main_entry (current_program, NULL);
	}
  }
#line 14717 "parser.c"
    break;

  case 6: /* $@2: %empty  */
#line 3388 "parser.y"
  {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 14727 "parser.c"
    break;

  case 14: /* $@3: %empty  */
#line 3410 "parser.y"
  {
	program_init_without_program_id ();
  }
#line 14735 "parser.c"
    break;

  case 15: /* simple_prog: $@3 _program_body  */
#line 3415 "parser.y"
  {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 14744 "parser.c"
    break;

  case 18: /* _end_program_list: %empty  */
#line 3441 "parser.y"
  {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 14753 "parser.c"
    break;

  case 22: /* $@4: %empty  */
#line 3455 "parser.y"
  {
	check_area_a_of ("END PROGRAM");
	backup_current_pos ();
  }
#line 14762 "parser.c"
    break;

  case 23: /* end_program: "END PROGRAM" $@4 end_program_name _dot  */
#line 3460 "parser.y"
  {
	first_nested_program = 0;
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_PROGRAM);
  }
#line 14771 "parser.c"
    break;

  case 24: /* $@5: %empty  */
#line 3468 "parser.y"
  {
	backup_current_pos ();
  }
#line 14779 "parser.c"
    break;

  case 25: /* end_function: "END FUNCTION" $@5 end_program_name _dot  */
#line 3472 "parser.y"
  {
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_FUNCTION);
  }
#line 14787 "parser.c"
    break;

  case 26: /* $@6: %empty  */
#line 3482 "parser.y"
  {
	/* Error if program_id_name is a literal */

	/* Check that previous program was also a prototype */
	if (!current_program->flag_prototype) {
		/* Technically, prototypes must come before all other *source units*.  */
		cb_error (_("prototypes must be come before any program/function definitions"));
	}

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("PROGRAM PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 14826 "parser.c"
    break;

  case 27: /* program_prototype: _identification_header program_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@6 _prototype_environment_division _prototype_data_division _prototype_procedure_division_header end_program  */
#line 3520 "parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 14836 "parser.c"
    break;

  case 28: /* $@7: %empty  */
#line 3532 "parser.y"
  {
	/* Error if program_id_name is a literal */

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("FUNCTION PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 14869 "parser.c"
    break;

  case 29: /* function_prototype: _identification_header function_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@7 _prototype_environment_division _prototype_data_division _prototype_procedure_division_header end_function  */
#line 3564 "parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 14879 "parser.c"
    break;

  case 31: /* $@8: %empty  */
#line 3573 "parser.y"
            { check_area_a_of ("PROCEDURE DIVISION"); }
#line 14885 "parser.c"
    break;

  case 32: /* _prototype_procedure_division_header: PROCEDURE $@8 DIVISION _procedure_using_chaining _procedure_returning _dot  */
#line 3575 "parser.y"
  {
	cb_validate_parameters_and_returning (current_program, yyvsp[-2]);
	current_program->num_proc_params = cb_list_length (yyvsp[-2]);
	/* add pseudo-entry as it contains the actual USING parameters */
	emit_main_entry (current_program, yyvsp[-2]);
  }
#line 14896 "parser.c"
    break;

  case 33: /* control: CONTROL  */
#line 3585 "parser.y"
                 { check_area_a_of ("CONTROL DIVISION"); }
#line 14902 "parser.c"
    break;

  case 35: /* $@9: %empty  */
#line 3589 "parser.y"
  {
	  cb_verify (cb_control_division, "CONTROL DIVISION");
  }
#line 14910 "parser.c"
    break;

  case 38: /* $@10: %empty  */
#line 3597 "parser.y"
          { check_area_a_of ("DEFAULT SECTION"); }
#line 14916 "parser.c"
    break;

  case 39: /* _default_section: DEFAULT $@10 SECTION "." _default_clauses  */
#line 3600 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 14924 "parser.c"
    break;

  case 43: /* $@11: %empty  */
#line 3614 "parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 14930 "parser.c"
    break;

  case 44: /* _default_accept_clause: ACCEPT $@11 _is word_or_terminal  */
#line 3616 "parser.y"
  {
	  CB_PENDING ("ACCEPT statement in DEFAULT SECTION");
	  /* TODO: setup_default_accept ($3); */
  }
#line 14939 "parser.c"
    break;

  case 46: /* $@12: %empty  */
#line 3624 "parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 14945 "parser.c"
    break;

  case 47: /* _default_display_clause: DISPLAY $@12 _is word_or_terminal  */
#line 3626 "parser.y"
  {
	  CB_PENDING ("DISPLAY statement in DEFAULT SECTION");
	  /* TODO: setup_default_display ($3); */
  }
#line 14954 "parser.c"
    break;

  case 48: /* $@13: %empty  */
#line 3637 "parser.y"
  {
	cb_validate_program_environment (current_program);
  }
#line 14962 "parser.c"
    break;

  case 49: /* $@14: %empty  */
#line 3641 "parser.y"
  {
	/* note:
	   we also validate all references we found so far here */
	cb_validate_program_data (current_program);
	within_typedef_definition = 0;
  }
#line 14973 "parser.c"
    break;

  case 53: /* $@15: %empty  */
#line 3658 "parser.y"
                       { check_area_a_of ("IDENTIFICATION DIVISION"); }
#line 14979 "parser.c"
    break;

  case 54: /* identification_header: identification_or_id $@15 DIVISION _dot  */
#line 3660 "parser.y"
  {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 14988 "parser.c"
    break;

  case 57: /* program_id_header: "PROGRAM-ID"  */
#line 3673 "parser.y"
  {
	cobc_in_id = 1;
	save_tree = NULL;
  }
#line 14997 "parser.c"
    break;

  case 58: /* program_id_paragraph: program_id_header "." program_id_name _as_literal _program_type "."  */
#line 3681 "parser.y"
  {
	if (setup_program (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 0)) {
		YYABORT;
	}


	setup_prototype (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 1);

	if (yyvsp[-1]) {
		if (!current_program->nested_level) {
			cb_error (_("COMMON may only be used in a contained program"));
		} else {
			current_program->flag_common = 1;
			cb_add_common_prog (current_program);
		}
	}

	/* TODO: do that more clean, this and above was only moved here
	         to fix a shift/reduce conflict with program prototype */
	if (save_tree == cb_int1) {
		current_program->flag_initial = 1;
	} else if (save_tree == cb_int2) {
		current_program->flag_recursive = 1;
	}

	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15030 "parser.c"
    break;

  case 59: /* function_id_header: "FUNCTION-ID"  */
#line 3713 "parser.y"
  {
	cobc_in_id = 1;
  }
#line 15038 "parser.c"
    break;

  case 60: /* function_id_paragraph: function_id_header "." program_id_name _as_literal "."  */
#line 3720 "parser.y"
  {
	if (setup_program (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 0)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15051 "parser.c"
    break;

  case 61: /* program_id_name: "program name"  */
#line 3732 "parser.y"
  {
	if (CB_REFERENCE_P (yyvsp[0]) && CB_WORD_COUNT (yyvsp[0]) > 0) {
		redefinition_error (yyvsp[0]);
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	yyval = yyvsp[0];
  }
#line 15066 "parser.c"
    break;

  case 62: /* program_id_name: "Literal"  */
#line 3743 "parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15074 "parser.c"
    break;

  case 64: /* end_program_name: "Literal"  */
#line 3751 "parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15082 "parser.c"
    break;

  case 65: /* _as_literal: %empty  */
#line 3757 "parser.y"
                                { yyval = NULL; }
#line 15088 "parser.c"
    break;

  case 66: /* _as_literal: AS "Literal"  */
#line 3758 "parser.y"
                                { yyval = yyvsp[0]; }
#line 15094 "parser.c"
    break;

  case 67: /* _program_type: %empty  */
#line 3762 "parser.y"
                                { yyval = NULL; }
#line 15100 "parser.c"
    break;

  case 68: /* _program_type: _is program_type_clause _program  */
#line 3763 "parser.y"
                                        { yyval = yyvsp[-1]; }
#line 15106 "parser.c"
    break;

  case 69: /* program_type_clause: COMMON  */
#line 3768 "parser.y"
  {
	yyval = cb_int1;
  }
#line 15114 "parser.c"
    break;

  case 70: /* program_type_clause: init_or_recurse_and_common  */
#line 3772 "parser.y"
  {
	yyval = cb_int2;
  }
#line 15122 "parser.c"
    break;

  case 72: /* program_type_clause: EXTERNAL  */
#line 3777 "parser.y"
  {
	CB_PENDING (_("CALL prototypes"));
  }
#line 15130 "parser.c"
    break;

  case 75: /* init_or_recurse: "INITIAL"  */
#line 3789 "parser.y"
  {
	save_tree = cb_int1;
  }
#line 15138 "parser.c"
    break;

  case 76: /* init_or_recurse: RECURSIVE  */
#line 3793 "parser.y"
  {
	save_tree = cb_int2;
  }
#line 15146 "parser.c"
    break;

  case 78: /* _options_paragraph: OPTIONS "." _options_clauses  */
#line 3802 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15154 "parser.c"
    break;

  case 82: /* arithmetic_choice: NATIVE  */
#line 3822 "parser.y"
  {
/* FIXME: the IBM-compatible ARITHMETIC should only be disabled
          for the specified program (and its nested programs)
   note: ibm-strict.conf has no OPTIONS paragraph, but ibm.conf does */
	cb_arithmetic_osvs = 0;
  }
#line 15165 "parser.c"
    break;

  case 83: /* arithmetic_choice: STANDARD  */
#line 3829 "parser.y"
  {
	CB_PENDING ("STANDARD ARITHMETIC");
  }
#line 15173 "parser.c"
    break;

  case 84: /* arithmetic_choice: "STANDARD-BINARY"  */
#line 3833 "parser.y"
  {
	CB_PENDING ("STANDARD-BINARY ARITHMETIC");
  }
#line 15181 "parser.c"
    break;

  case 85: /* arithmetic_choice: "STANDARD-DECIMAL"  */
#line 3837 "parser.y"
  {
	CB_PENDING ("STANDARD-DECIMAL ARITHMETIC");
  }
#line 15189 "parser.c"
    break;

  case 86: /* _default_rounded_clause: %empty  */
#line 3852 "parser.y"
  {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 15197 "parser.c"
    break;

  case 87: /* _default_rounded_clause: DEFAULT ROUNDED _mode _is round_choice  */
#line 3856 "parser.y"
  {
	if (yyvsp[0]) {
		default_rounded_mode = yyvsp[0];
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 15209 "parser.c"
    break;

  case 89: /* _entry_convention_clause: "ENTRY-CONVENTION" _is convention_type  */
#line 3868 "parser.y"
  {
	current_program->entry_convention = yyvsp[0];
  }
#line 15217 "parser.c"
    break;

  case 90: /* convention_type: COBOL  */
#line 3875 "parser.y"
  {
	yyval = cb_int (CB_CONV_COBOL);
  }
#line 15225 "parser.c"
    break;

  case 91: /* convention_type: "EXTERN"  */
#line 3879 "parser.y"
  {
	yyval = cb_int0;
  }
#line 15233 "parser.c"
    break;

  case 92: /* convention_type: STDCALL  */
#line 3883 "parser.y"
  {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 15241 "parser.c"
    break;

  case 94: /* _intermediate_rounding_clause: INTERMEDIATE ROUNDING _is intermediate_rounding_choice  */
#line 3891 "parser.y"
  {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 15249 "parser.c"
    break;

  case 95: /* intermediate_rounding_choice: "NEAREST-AWAY-FROM-ZERO"  */
#line 3898 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 15257 "parser.c"
    break;

  case 96: /* intermediate_rounding_choice: "NEAREST-EVEN"  */
#line 3902 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 15265 "parser.c"
    break;

  case 97: /* intermediate_rounding_choice: PROHIBITED  */
#line 3906 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 15273 "parser.c"
    break;

  case 98: /* intermediate_rounding_choice: TRUNCATION  */
#line 3910 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 15281 "parser.c"
    break;

  case 102: /* environment: ENVIRONMENT  */
#line 3927 "parser.y"
                         { check_area_a_of ("ENVIRONMENT DIVISION"); }
#line 15287 "parser.c"
    break;

  case 103: /* environment_header: environment DIVISION _dot  */
#line 3930 "parser.y"
  {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 15295 "parser.c"
    break;

  case 107: /* configuration: CONFIGURATION  */
#line 3946 "parser.y"
                             { check_area_a_of ("CONFIGURATION SECTION"); }
#line 15301 "parser.c"
    break;

  case 108: /* configuration_header: configuration SECTION _dot  */
#line 3949 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 15313 "parser.c"
    break;

  case 120: /* $@16: %empty  */
#line 3984 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SOURCE_COMPUTER);
	set_conf_section_part (COBC_HD_SOURCE_COMPUTER);
  }
#line 15324 "parser.c"
    break;

  case 125: /* _with_debugging_mode: _with DEBUGGING MODE  */
#line 4000 "parser.y"
  {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 15335 "parser.c"
    break;

  case 126: /* $@17: %empty  */
#line 4012 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_OBJECT_COMPUTER);
	set_conf_section_part (COBC_HD_OBJECT_COMPUTER);
  }
#line 15346 "parser.c"
    break;

  case 127: /* object_computer_paragraph: "OBJECT-COMPUTER" _dot $@17 _object_computer_entry  */
#line 4019 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15354 "parser.c"
    break;

  case 138: /* object_computer_memory: MEMORY _size _is integer object_char_or_word_or_modules  */
#line 4045 "parser.y"
  {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 15362 "parser.c"
    break;

  case 139: /* object_computer_sequence: _program program_collating_sequence  */
#line 4053 "parser.y"
  {
	current_program->collating_sequence = alphanumeric_collation;
	current_program->collating_sequence_n = national_collation;
  }
#line 15371 "parser.c"
    break;

  case 140: /* $@18: %empty  */
#line 4061 "parser.y"
  {
	alphanumeric_collation = national_collation = NULL;
  }
#line 15379 "parser.c"
    break;

  case 142: /* program_coll_sequence_values: _is single_reference  */
#line 4069 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 15387 "parser.c"
    break;

  case 143: /* program_coll_sequence_values: _is single_reference single_reference  */
#line 4073 "parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15397 "parser.c"
    break;

  case 144: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference  */
#line 4079 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 15405 "parser.c"
    break;

  case 145: /* program_coll_sequence_values: _for NATIONAL _is single_reference  */
#line 4083 "parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15414 "parser.c"
    break;

  case 146: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference _for NATIONAL _is single_reference  */
#line 4089 "parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15424 "parser.c"
    break;

  case 147: /* program_coll_sequence_values: _for NATIONAL _is single_reference _for ALPHANUMERIC _is single_reference  */
#line 4096 "parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 15434 "parser.c"
    break;

  case 148: /* object_computer_segment: "SEGMENT-LIMIT" _is integer  */
#line 4105 "parser.y"
  {
	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			yyval = NULL;
		}
	}
	/* Ignore */
  }
#line 15449 "parser.c"
    break;

  case 149: /* object_computer_class: _character CLASSIFICATION _is locale_class  */
#line 4119 "parser.y"
  {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = yyvsp[0];
	}
  }
#line 15461 "parser.c"
    break;

  case 150: /* locale_class: single_reference  */
#line 4130 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 15469 "parser.c"
    break;

  case 151: /* locale_class: LOCALE  */
#line 4134 "parser.y"
  {
	yyval = NULL;
  }
#line 15477 "parser.c"
    break;

  case 152: /* locale_class: "USER-DEFAULT"  */
#line 4138 "parser.y"
  {
	yyval = cb_int1;
  }
#line 15485 "parser.c"
    break;

  case 153: /* locale_class: "SYSTEM-DEFAULT"  */
#line 4142 "parser.y"
  {
	yyval = cb_int1;
  }
#line 15493 "parser.c"
    break;

  case 158: /* $@19: %empty  */
#line 4159 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_REPOSITORY);
	set_conf_section_part (COBC_HD_REPOSITORY);
  }
#line 15504 "parser.c"
    break;

  case 159: /* repository_paragraph: REPOSITORY _dot $@19 _repository_entry  */
#line 4166 "parser.y"
  {
	cobc_in_repository = 0;
  }
#line 15512 "parser.c"
    break;

  case 162: /* _repository_entry: repository_list error "."  */
#line 4175 "parser.y"
  {
	yyerrok;
  }
#line 15520 "parser.c"
    break;

  case 165: /* repository_name: FUNCTION ALL INTRINSIC  */
#line 4187 "parser.y"
  {
	functions_are_all = 1;
  }
#line 15528 "parser.c"
    break;

  case 166: /* repository_name: FUNCTION "Identifier" _as_literal  */
#line 4191 "parser.y"
  {
	if (yyvsp[-1] != cb_error_node) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_FUNCTION, 0);
	}
  }
#line 15538 "parser.c"
    break;

  case 168: /* repository_name: PROGRAM "Identifier" _as_literal  */
#line 4198 "parser.y"
  {
	  if (yyvsp[-1] != cb_error_node
	      && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 0);
	}
  }
#line 15549 "parser.c"
    break;

  case 169: /* repository_name: FUNCTION repository_name_list error  */
#line 4205 "parser.y"
  {
	yyerrok;
  }
#line 15557 "parser.c"
    break;

  case 170: /* repository_name_list: "intrinsic function name"  */
#line 4212 "parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 15566 "parser.c"
    break;

  case 171: /* repository_name_list: repository_name_list "intrinsic function name"  */
#line 4217 "parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 15575 "parser.c"
    break;

  case 172: /* special_names_header: "SPECIAL-NAMES" _dot  */
#line 4228 "parser.y"
  {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SPECIAL_NAMES);
	set_conf_section_part (COBC_HD_SPECIAL_NAMES);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	cobc_cs_check = CB_CS_SPECIAL_NAMES;
  }
#line 15591 "parser.c"
    break;

  case 192: /* $@20: %empty  */
#line 4275 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name with special translation
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name_translated (yyvsp[0]);
	}
  }
#line 15610 "parser.c"
    break;

  case 194: /* word_or_terminal: "Identifier"  */
#line 4293 "parser.y"
           { yyval = yyvsp[0]; }
#line 15616 "parser.c"
    break;

  case 195: /* word_or_terminal: TERMINAL  */
#line 4295 "parser.y"
           { yyval = cb_build_reference("TERMINAL"); }
#line 15622 "parser.c"
    break;

  case 196: /* mnemonic_choices: _is CRT  */
#line 4299 "parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 15636 "parser.c"
    break;

  case 197: /* mnemonic_choices: integer _is undefined_word  */
#line 4310 "parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE (yyvsp[0])) {
			CB_SYSTEM_NAME(save_tree)->value = yyvsp[-2];
			cb_define (yyvsp[0], save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					yyvsp[0], save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (cb_strcasecmp (CB_NAME(yyvsp[0]), "EXTERN" ) == 0
			 || cb_strcasecmp (CB_NAME(yyvsp[0]), "STDCALL") == 0
			 || cb_strcasecmp (CB_NAME(yyvsp[0]), "STATIC" ) == 0
			 || cb_strcasecmp (CB_NAME(yyvsp[0]), "C"      ) == 0
			 || cb_strcasecmp (CB_NAME(yyvsp[0]), "PASCAL" ) == 0) {
				remove_context_sensitivity (CB_NAME(yyvsp[0]), CB_CS_CALL);
			}
		}
	}
  }
#line 15661 "parser.c"
    break;

  case 198: /* mnemonic_choices: _is undefined_word _special_name_mnemonic_on_off  */
#line 4331 "parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[-1])) {
		cb_define (yyvsp[-1], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[-1], save_tree);
	}
  }
#line 15673 "parser.c"
    break;

  case 202: /* on_off_clauses: on_off_clauses_1  */
#line 4347 "parser.y"
  {
	  check_on_off_duplicate = 0;
  }
#line 15681 "parser.c"
    break;

  case 203: /* on_off_clauses_1: on_or_off _onoff_status undefined_word  */
#line 4354 "parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 15700 "parser.c"
    break;

  case 204: /* on_off_clauses_1: on_off_clauses_1 on_or_off _onoff_status undefined_word  */
#line 4369 "parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 15719 "parser.c"
    break;

  case 205: /* @21: %empty  */
#line 4389 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_alphabet_name (yyvsp[0]);
	}
  }
#line 15736 "parser.c"
    break;

  case 206: /* alphabet_name_clause: ALPHABET undefined_word @21 alphabet_definition  */
#line 4402 "parser.y"
  {
	if (yyvsp[-1]) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 15748 "parser.c"
    break;

  case 207: /* @22: %empty  */
#line 4413 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME (yyvsp[-1])->alphabet_target = CB_ALPHABET_ALPHANUMERIC;
	}
  }
#line 15759 "parser.c"
    break;

  case 209: /* @23: %empty  */
#line 4421 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME(yyvsp[-1])->alphabet_target = CB_ALPHABET_NATIONAL;
	}
  }
#line 15770 "parser.c"
    break;

  case 215: /* alphabet_type_alphanumeric: "STANDARD-1"  */
#line 4442 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 15780 "parser.c"
    break;

  case 216: /* alphabet_type_alphanumeric: "STANDARD-2"  */
#line 4448 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 15790 "parser.c"
    break;

  case 217: /* alphabet_type_alphanumeric: EBCDIC  */
#line 4454 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 15800 "parser.c"
    break;

  case 218: /* alphabet_type_alphanumeric: ASCII  */
#line 4460 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 15810 "parser.c"
    break;

  case 220: /* alphabet_type_national: "UCS-4"  */
#line 4470 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UCS-4");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UCS_4;
	}
  }
#line 15821 "parser.c"
    break;

  case 221: /* alphabet_type_national: "UTF-8"  */
#line 4477 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-8");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_8;
	}
  }
#line 15832 "parser.c"
    break;

  case 222: /* alphabet_type_national: "UTF-16"  */
#line 4484 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-16");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_16;
	}
  }
#line 15843 "parser.c"
    break;

  case 223: /* alphabet_type_common: NATIVE  */
#line 4494 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 15853 "parser.c"
    break;

  case 224: /* alphabet_type_common: LOCALE single_reference  */
#line 4500 "parser.y"
  {
	if (yyvsp[(-1) - (2)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->alphabet_type = CB_ALPHABET_LOCALE;
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->custom_list = yyvsp[0];
		CB_PENDING_X (yyvsp[(-1) - (2)], "LOCALE ALPHABET");
	}
  }
#line 15865 "parser.c"
    break;

  case 225: /* alphabet_type_common: alphabet_literal_list  */
#line 4508 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->custom_list = yyvsp[0];
	}
  }
#line 15876 "parser.c"
    break;

  case 226: /* alphabet_literal_list: alphabet_literal  */
#line 4518 "parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 15884 "parser.c"
    break;

  case 227: /* alphabet_literal_list: alphabet_literal_list alphabet_literal  */
#line 4522 "parser.y"
  {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 15892 "parser.c"
    break;

  case 228: /* alphabet_literal: alphabet_lits  */
#line 4529 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 15900 "parser.c"
    break;

  case 229: /* alphabet_literal: alphabet_lits THRU alphabet_lits  */
#line 4533 "parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 15908 "parser.c"
    break;

  case 230: /* @24: %empty  */
#line 4537 "parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[-1]);
  }
#line 15916 "parser.c"
    break;

  case 231: /* alphabet_literal: alphabet_lits ALSO @24 alphabet_also_sequence  */
#line 4541 "parser.y"
  {
	yyval = yyvsp[-1];
  }
#line 15924 "parser.c"
    break;

  case 232: /* alphabet_also_sequence: alphabet_lits  */
#line 4548 "parser.y"
  {
	cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 15932 "parser.c"
    break;

  case 233: /* alphabet_also_sequence: alphabet_also_sequence ALSO alphabet_lits  */
#line 4552 "parser.y"
  {
	cb_list_add (yyvsp[-3], yyvsp[0]);
  }
#line 15940 "parser.c"
    break;

  case 234: /* alphabet_lits: "Literal"  */
#line 4558 "parser.y"
                                { yyval = yyvsp[0]; }
#line 15946 "parser.c"
    break;

  case 235: /* alphabet_lits: SPACE  */
#line 4559 "parser.y"
                                { yyval = cb_space; }
#line 15952 "parser.c"
    break;

  case 236: /* alphabet_lits: ZERO  */
#line 4560 "parser.y"
                                { yyval = cb_zero; }
#line 15958 "parser.c"
    break;

  case 237: /* alphabet_lits: QUOTE  */
#line 4561 "parser.y"
                                { yyval = cb_quote; }
#line 15964 "parser.c"
    break;

  case 238: /* alphabet_lits: "HIGH-VALUE"  */
#line 4562 "parser.y"
                        { yyval = cb_norm_high; /* -> special case, not cb_high */ }
#line 15970 "parser.c"
    break;

  case 239: /* alphabet_lits: "LOW-VALUE"  */
#line 4563 "parser.y"
                                { yyval = cb_norm_low; }
#line 15976 "parser.c"
    break;

  case 240: /* space_or_zero: SPACE  */
#line 4567 "parser.y"
                                { yyval = cb_space; }
#line 15982 "parser.c"
    break;

  case 241: /* space_or_zero: ZERO  */
#line 4568 "parser.y"
                                { yyval = cb_zero; }
#line 15988 "parser.c"
    break;

  case 242: /* _alphnat_target: %empty  */
#line 4573 "parser.y"
  {
	yyval = NULL;
  }
#line 15996 "parser.c"
    break;

  case 243: /* _alphnat_target: _for ALPHANUMERIC  */
#line 4577 "parser.y"
  {
	yyval = NULL;
  }
#line 16004 "parser.c"
    break;

  case 244: /* _alphnat_target: _for NATIONAL  */
#line 4581 "parser.y"
  {
	yyval = cb_int0;
  }
#line 16012 "parser.c"
    break;

  case 245: /* _in_alphabet: %empty  */
#line 4588 "parser.y"
  {
	yyval = NULL;
  }
#line 16020 "parser.c"
    break;

  case 246: /* _in_alphabet: IN alphabet_name  */
#line 4592 "parser.y"
  {
	/* note: IN is really mandatory here */
	yyval = yyvsp[0];
  }
#line 16029 "parser.c"
    break;

  case 247: /* symbolic_characters_clause: symbolic_collection _in_alphabet  */
#line 4603 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_tree type = CB_PAIR_X (yyvsp[-1]);
		cb_tree chars_list = CB_PAIR_Y (yyvsp[-1]);
		cb_tree alph = yyvsp[0];
		
		/* TODO: at least add a check that $3 and $6 match by type */
		if (type && !alph) {
			cb_error_x (type, _("type does not match alphabet"));
		} else
		if (type) {
			CB_PENDING_X (type, "NATIONAL SYMBOLIC CHARACTER");
		}
		CB_CHAIN_PAIR (current_program->symbolic_char_list, chars_list, alph);
	}
  }
#line 16055 "parser.c"
    break;

  case 248: /* symbolic_collection: SYMBOLIC _characters _alphnat_target symbolic_chars_list  */
#line 4630 "parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-1], yyvsp[0]);
  }
#line 16063 "parser.c"
    break;

  case 249: /* symbolic_chars_list: symbolic_chars_phrase  */
#line 4637 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16071 "parser.c"
    break;

  case 250: /* symbolic_chars_list: symbolic_chars_list symbolic_chars_phrase  */
#line 4641 "parser.y"
  {
	if (yyvsp[0]) {
		yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 16083 "parser.c"
    break;

  case 251: /* symbolic_chars_phrase: char_list _is_are integer_list  */
#line 4652 "parser.y"
  {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length (yyvsp[-2]) != cb_list_length (yyvsp[0])) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		yyval = NULL;
	} else {
		l1 = yyvsp[-2];
		l2 = yyvsp[0];
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		yyval = yyvsp[-2];
	}
  }
#line 16104 "parser.c"
    break;

  case 252: /* char_list: unique_word  */
#line 4672 "parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = NULL;
	} else {
		yyval = CB_LIST_INIT (yyvsp[0]);
	}
  }
#line 16116 "parser.c"
    break;

  case 253: /* char_list: char_list unique_word  */
#line 4680 "parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = yyvsp[-1];
	} else {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	}
  }
#line 16128 "parser.c"
    break;

  case 254: /* integer_list: symbolic_integer  */
#line 4690 "parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16134 "parser.c"
    break;

  case 255: /* integer_list: integer_list symbolic_integer  */
#line 4691 "parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16140 "parser.c"
    break;

  case 256: /* symbolic_constant_clause: SYMBOLIC CONSTANT symbolic_constant_list  */
#line 4700 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	(void)cb_verify (cb_symbolic_constant, "SYMBOLIC CONSTANT");
  }
#line 16154 "parser.c"
    break;

  case 259: /* symbolic_constant: user_entry_name _is literal  */
#line 4718 "parser.y"
  {
	struct cb_field *f;

	f = CB_FIELD (cb_build_constant (yyvsp[-2], yyvsp[0]));
	f->flag_item_78 = 1;
	f->flag_constant = 1;
	f->flag_is_global = 1;
	f->level = 1;
	f->values = yyvsp[0];
	cb_needs_01 = 1;
	/* Ignore return value */
	(void)cb_validate_78_item (f, 0);
  }
#line 16172 "parser.c"
    break;

  case 260: /* class_name_clause: CLASS undefined_word _alphnat_target _is class_item_list _in_alphabet  */
#line 4737 "parser.y"
  {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name (yyvsp[-4], yyvsp[-1]);
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
		/* TODO: at least add a check that $3 and $6 match by type */
		if (yyvsp[-3] && !yyvsp[0]) {
			cb_error_x (yyvsp[-3], _("type does not match alphabet"));
		} else
		if (yyvsp[-3]) {
			CB_PENDING_X (yyvsp[-3], "NATIONAL CLASS");
		}
		if (yyvsp[0]) {
			CB_PENDING_X (yyvsp[0], _("CLASS IS integer IN alphabet-name"));
		}
	}
  }
#line 16204 "parser.c"
    break;

  case 261: /* class_item_list: class_item  */
#line 4767 "parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16210 "parser.c"
    break;

  case 262: /* class_item_list: class_item_list class_item  */
#line 4768 "parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16216 "parser.c"
    break;

  case 263: /* class_item: class_value  */
#line 4773 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16224 "parser.c"
    break;

  case 264: /* class_item: class_value THRU class_value  */
#line 4777 "parser.y"
  {
	if (CB_TREE_CLASS (yyvsp[-2]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[-2]) && CB_LITERAL (yyvsp[-2])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS (yyvsp[0]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[0]) && CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (cb_literal_value (yyvsp[-2]) <= cb_literal_value (yyvsp[0])) {
		yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
	} else {
		yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]);
	}
  }
#line 16244 "parser.c"
    break;

  case 265: /* locale_clause: LOCALE undefined_word _is "Literal"  */
#line 4798 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		cb_tree	l = cb_build_locale_name (yyvsp[-2], yyvsp[0]);
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 16264 "parser.c"
    break;

  case 266: /* @25: %empty  */
#line 4819 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_schema_name (yyvsp[0]);
	}
  }
#line 16281 "parser.c"
    break;

  case 267: /* xml_schema_clause: "XML-SCHEMA" undefined_word @25 schema_definition  */
#line 4832 "parser.y"
  {
	if (yyvsp[-1]) {
		current_program->schema_name_list =
			cb_list_add (current_program->schema_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 16293 "parser.c"
    break;

  case 268: /* schema_definition: literal  */
#line 4843 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = (const char *) CB_LITERAL (yyvsp[0])->data;
	}
  }
#line 16304 "parser.c"
    break;

  case 269: /* schema_definition: "Identifier"  */
#line 4850 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = CB_REFERENCE (yyvsp[0])->word->name;
	}
  }
#line 16315 "parser.c"
    break;

  case 270: /* currency_sign_clause: CURRENCY _sign _is "Literal" _with_pic_symbol  */
#line 4862 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		unsigned int	error_ind = 0;

		/* FIXME: actual allowed (depending on dialect), see FR #246 */
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);

		/* checks of CURRENCY SIGN (being currency string) when separate */
		if (yyvsp[0]) {
			unsigned int	char_seen = 0;
			unsigned char	*s = CB_LITERAL (yyvsp[-1])->data;

			CB_PENDING_X (yyvsp[-1], _("separate currency symbol and currency string"));
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 1;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 1;
			}
		}
		if (error_ind) {
			cb_error_x (yyvsp[-1], _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL (yyvsp[-1])->data);
		}
		if (yyvsp[0]) {
			set_currency_picture_symbol (yyvsp[0]);
		} else {
			if (!error_ind) {
				set_currency_picture_symbol (yyvsp[-1]);
			}
		}
	}
  }
#line 16381 "parser.c"
    break;

  case 271: /* _with_pic_symbol: %empty  */
#line 4928 "parser.y"
  {
	yyval = NULL;
  }
#line 16389 "parser.c"
    break;

  case 272: /* _with_pic_symbol: _with "PICTURE SYMBOL" "Literal"  */
#line 4932 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16397 "parser.c"
    break;

  case 273: /* decimal_point_clause: "DECIMAL-POINT" _is COMMA  */
#line 4941 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 16414 "parser.c"
    break;

  case 274: /* numeric_sign_clause: NUMERIC SIGN _is TRAILING SEPARATE  */
#line 4960 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 16429 "parser.c"
    break;

  case 275: /* cursor_clause: CURSOR _is reference  */
#line 4976 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = yyvsp[0];
	}
  }
#line 16445 "parser.c"
    break;

  case 276: /* crt_status_clause: CRT STATUS _is reference  */
#line 4994 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = yyvsp[0];
	}
  }
#line 16461 "parser.c"
    break;

  case 277: /* screen_control: "SCREEN CONTROL" _is reference  */
#line 5012 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 16477 "parser.c"
    break;

  case 278: /* event_status: "EVENT STATUS" _is reference  */
#line 5029 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 16493 "parser.c"
    break;

  case 279: /* $@26: %empty  */
#line 5046 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name ("TOP");
	}
  }
#line 16512 "parser.c"
    break;

  case 280: /* top_clause: TOP $@26 _is undefined_word  */
#line 5061 "parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[0])) {
		cb_define (yyvsp[0], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[0], save_tree);
	}
  }
#line 16524 "parser.c"
    break;

  case 282: /* input_output: "INPUT-OUTPUT"  */
#line 5079 "parser.y"
                           { check_area_a_of ("INPUT-OUTPUT SECTION"); }
#line 16530 "parser.c"
    break;

  case 284: /* _input_output_header: input_output SECTION _dot  */
#line 5082 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 16539 "parser.c"
    break;

  case 286: /* _file_control_header: "FILE-CONTROL" _dot  */
#line 5092 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 16549 "parser.c"
    break;

  case 289: /* $@27: %empty  */
#line 5104 "parser.y"
         { check_non_area_a (yyvsp[0]); }
#line 16555 "parser.c"
    break;

  case 290: /* $@28: %empty  */
#line 5106 "parser.y"
  {
	char	buff[COB_MINI_BUFF];

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE (yyvsp[0])) {
		/* Build new file */
		current_file = build_file (yyvsp[0]);
		current_file->optional = CB_INTEGER (yyvsp[-1])->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else {
		/* Create dummy file */
		snprintf (buff, COB_MINI_BUFF, "SELECT on line %d",
			  cb_source_line);
		current_file = build_file (cb_build_reference (buff));
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);

	}
	key_type = NO_KEY;
  }
#line 16586 "parser.c"
    break;

  case 291: /* file_control_entry: SELECT $@27 flag_optional undefined_word $@28 _select_clauses_or_error  */
#line 5133 "parser.y"
  {
	cobc_cs_check = 0;
	if (CB_VALID_TREE (yyvsp[-2])) {
		if (current_file->organization == COB_ORG_INDEXED
		    && key_type == RELATIVE_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RELATIVE KEY clause on INDEXED files"));
		} else if (current_file->organization == COB_ORG_RELATIVE
			   && key_type == RECORD_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RECORD KEY clause on RELATIVE files"));
		}

		validate_file (current_file, yyvsp[-2]);
	}
  }
#line 16607 "parser.c"
    break;

  case 293: /* _select_clauses_or_error: error _dot_or_else_end_of_file_control  */
#line 5154 "parser.y"
  {
	yyerrok;
  }
#line 16615 "parser.c"
    break;

  case 295: /* _select_clause_sequence: _select_clause_sequence select_clause  */
#line 5161 "parser.y"
  {
	/* reset context-sensitive words for next clauses */
	cobc_cs_check = CB_CS_SELECT;
  }
#line 16624 "parser.c"
    break;

  case 316: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file literal  */
#line 5212 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with literals"));
	}

	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16638 "parser.c"
    break;

  case 317: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file qualified_word  */
#line 5222 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);

	/* current_file->assign_type is set by _ext_clause */
	if (!ext_dyn_specified) {
		current_file->flag_assign_no_keyword = 1;
	}
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16652 "parser.c"
    break;

  case 318: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file using_or_varying qualified_word  */
#line 5232 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with USING/VARYING"));
	}
        cb_verify (cb_assign_using_variable, "ASSIGN USING/VARYING variable");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16667 "parser.c"
    break;

  case 319: /* assign_clause: ASSIGN _to _ext_clause DISK FROM qualified_word  */
#line 5243 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with DISK FROM"));
	}
	cb_verify (cb_assign_disk_from, _("ASSIGN DISK FROM"));

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 16682 "parser.c"
    break;

  case 320: /* assign_clause: ASSIGN _to _ext_clause assign_device  */
#line 5254 "parser.y"
  {
	if (assign_device == CB_ASSIGN_DISPLAY_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	} else if (assign_device == CB_ASSIGN_KEYBOARD_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	} else if (assign_device == CB_ASSIGN_PRINTER_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
	} else if (assign_device == CB_ASSIGN_PRINTER_1_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
	} else if (assign_device == CB_ASSIGN_PRINT_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("LPT1", (size_t)4);
	} else if (assign_device == CB_ASSIGN_LINE_SEQ_DEVICE
		   || assign_device == CB_ASSIGN_GENERAL_DEVICE) {
		current_file->flag_fileid = 1;
	}
  }
#line 16713 "parser.c"
    break;

  case 321: /* _assign_device_or_line_adv_file: %empty  */
#line 5284 "parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 16721 "parser.c"
    break;

  case 322: /* _assign_device_or_line_adv_file: line_adv_file  */
#line 5288 "parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 16729 "parser.c"
    break;

  case 324: /* assign_device: general_device_name  */
#line 5296 "parser.y"
  {
	assign_device = CB_ASSIGN_GENERAL_DEVICE;
  }
#line 16737 "parser.c"
    break;

  case 325: /* assign_device: line_seq_device_name  */
#line 5300 "parser.y"
  {
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	assign_device = CB_ASSIGN_LINE_SEQ_DEVICE;
  }
#line 16746 "parser.c"
    break;

  case 326: /* assign_device: DISPLAY  */
#line 5305 "parser.y"
  {
	assign_device = CB_ASSIGN_DISPLAY_DEVICE;
  }
#line 16754 "parser.c"
    break;

  case 327: /* assign_device: KEYBOARD  */
#line 5309 "parser.y"
  {
	assign_device = CB_ASSIGN_KEYBOARD_DEVICE;
  }
#line 16762 "parser.c"
    break;

  case 328: /* assign_device: PRINTER  */
#line 5317 "parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 16772 "parser.c"
    break;

  case 329: /* assign_device: "PRINTER-1"  */
#line 5323 "parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_1_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 16782 "parser.c"
    break;

  case 330: /* assign_device: PRINT  */
#line 5329 "parser.y"
  {
	assign_device = CB_ASSIGN_PRINT_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 16792 "parser.c"
    break;

  case 342: /* line_adv_file: LINE ADVANCING _file  */
#line 5356 "parser.y"
  {
	current_file->flag_line_adv = 1;
  }
#line 16800 "parser.c"
    break;

  case 343: /* _ext_clause: %empty  */
#line 5363 "parser.y"
  {
	ext_dyn_specified = 0;
	current_file->assign_type = cb_assign_type_default;
  }
#line 16809 "parser.c"
    break;

  case 344: /* _ext_clause: ext_clause  */
#line 5368 "parser.y"
  {
	ext_dyn_specified = 1;
	cb_verify (cb_assign_ext_dyn, _("ASSIGN EXTERNAL/DYNAMIC"));
  }
#line 16818 "parser.c"
    break;

  case 345: /* ext_clause: EXTERNAL  */
#line 5376 "parser.y"
  {
	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
  }
#line 16826 "parser.c"
    break;

  case 346: /* ext_clause: DYNAMIC  */
#line 5380 "parser.y"
  {
	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
  }
#line 16834 "parser.c"
    break;

  case 349: /* access_mode_clause: ACCESS _mode _is access_mode  */
#line 5394 "parser.y"
  {
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 16842 "parser.c"
    break;

  case 350: /* access_mode: SEQUENTIAL  */
#line 5400 "parser.y"
                        { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 16848 "parser.c"
    break;

  case 351: /* access_mode: DYNAMIC  */
#line 5401 "parser.y"
                        { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 16854 "parser.c"
    break;

  case 352: /* access_mode: RANDOM  */
#line 5402 "parser.y"
                        { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 16860 "parser.c"
    break;

  case 353: /* alternate_record_key_clause: ALTERNATE _record _key _is reference _split_keys flag_duplicates _password_clause _suppress_clause  */
#line 5410 "parser.y"
  {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	cb_tree composite_key;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = yyvsp[-4];
	p->component_list = NULL;
	if (yyvsp[-2]) {
		p->duplicates = CB_INTEGER (yyvsp[-2])->val;
	} else {
		/* note: we may add a compiler configuration here,
		         as at least ICOBOL defaults to WITH DUPLICATES
		         for ALTERNATE keys if not explicit deactivated
		*/
		p->duplicates = 0;
	}
	p->password = yyvsp[-1];
	if (yyvsp[0]) {
		p->tf_suppress = 1;
		p->char_suppress = CB_INTEGER (yyvsp[0])->val;
	} else {
		p->tf_suppress = 0;
	}
	p->next = NULL;

	/* handle split keys */
	if (yyvsp[-3]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field(yyvsp[-4]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			p->key = cb_build_field_reference((struct cb_field *)composite_key, NULL);
			p->component_list = key_component_list;
		}
	}

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 16915 "parser.c"
    break;

  case 354: /* _password_clause: %empty  */
#line 5464 "parser.y"
  {
	yyval = NULL;
  }
#line 16923 "parser.c"
    break;

  case 356: /* $@29: %empty  */
#line 5472 "parser.y"
  {
	CB_PENDING ("PASSWORD clause");
  }
#line 16931 "parser.c"
    break;

  case 357: /* password_clause: PASSWORD $@29 _is reference  */
#line 5476 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16939 "parser.c"
    break;

  case 358: /* encryption_clause: ENCRYPTION  */
#line 5484 "parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		cb_error (_("%s only valid with ORGANIZATION %s"), "WITH ENCRYPTION", "INDEXED");
	} else {
		CB_PENDING ("WITH ENCRYPTION");
		current_file->password = cb_int0;
	}
  }
#line 16952 "parser.c"
    break;

  case 359: /* _suppress_clause: %empty  */
#line 5496 "parser.y"
  {
	yyval = NULL;
  }
#line 16960 "parser.c"
    break;

  case 360: /* _suppress_clause: SUPPRESS WHEN ALL basic_value  */
#line 5500 "parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 16968 "parser.c"
    break;

  case 361: /* _suppress_clause: SUPPRESS WHEN space_or_zero  */
#line 5504 "parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 16976 "parser.c"
    break;

  case 362: /* collating_sequence_clause: collating_sequence  */
#line 5514 "parser.y"
  {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	current_file->collating_sequence = alphanumeric_collation;
	current_file->collating_sequence_n = national_collation;
	CB_PENDING ("FILE COLLATING SEQUENCE");
  }
#line 16987 "parser.c"
    break;

  case 363: /* $@30: %empty  */
#line 5524 "parser.y"
  {
	alphanumeric_collation = national_collation = NULL;
  }
#line 16995 "parser.c"
    break;

  case 365: /* coll_sequence_values: _is alphabet_name  */
#line 5532 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17003 "parser.c"
    break;

  case 366: /* coll_sequence_values: _is alphabet_name alphabet_name  */
#line 5536 "parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17013 "parser.c"
    break;

  case 367: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name  */
#line 5542 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17021 "parser.c"
    break;

  case 368: /* coll_sequence_values: _for NATIONAL _is alphabet_name  */
#line 5546 "parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17030 "parser.c"
    break;

  case 369: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name _for NATIONAL _is alphabet_name  */
#line 5552 "parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17040 "parser.c"
    break;

  case 370: /* coll_sequence_values: _for NATIONAL _is alphabet_name _for ALPHANUMERIC _is alphabet_name  */
#line 5559 "parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 17050 "parser.c"
    break;

  case 371: /* collating_sequence_clause_key: _collating SEQUENCE OF reference _is alphabet_name  */
#line 5568 "parser.y"
  {
	/* note: both entries must be resolved later on
	   and also attached to the correct key later, so just store in a list here: */
	current_file->collating_sequence_keys =
		cb_list_add(current_file->collating_sequence_keys, CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]));
	CB_PENDING ("KEY COLLATING SEQUENCE");
  }
#line 17062 "parser.c"
    break;

  case 372: /* alphabet_name: "Identifier"  */
#line 5579 "parser.y"
  {
	if (CB_ALPHABET_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not an alphabet-name"),
			cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 17076 "parser.c"
    break;

  case 373: /* file_status_clause: _file_or_sort STATUS _is reference _reference  */
#line 5594 "parser.y"
  {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = yyvsp[-1];
	if (yyvsp[0]) {
		/* Ignore VSAM STATUS field */
		cb_verify (cb_vsam_status, _("VSAM status"));
	}
  }
#line 17089 "parser.c"
    break;

  case 377: /* $@31: %empty  */
#line 5613 "parser.y"
  {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 17097 "parser.c"
    break;

  case 379: /* lock_mode: MANUAL _lock_with  */
#line 5621 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MANUAL;
  }
#line 17105 "parser.c"
    break;

  case 380: /* lock_mode: AUTOMATIC _lock_with  */
#line 5625 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
  }
#line 17113 "parser.c"
    break;

  case 381: /* lock_mode: EXCLUSIVE _with_mass_update  */
#line 5629 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
  }
#line 17121 "parser.c"
    break;

  case 384: /* _lock_with: WITH _lock ON MULTIPLE lock_records _with_rollback  */
#line 5638 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17129 "parser.c"
    break;

  case 385: /* _lock_with: with_rollback  */
#line 5642 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17137 "parser.c"
    break;

  case 388: /* with_rollback: _with ROLLBACK  */
#line 5653 "parser.y"
  {
	CB_PENDING ("WITH ROLLBACK");
  }
#line 17145 "parser.c"
    break;

  case 390: /* _with_mass_update: _with "MASS-UPDATE"  */
#line 5660 "parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
		/* TODO: pass extra flag to fileio */
		CB_PENDING ("WITH MASS-UPDATE");
	} else {
		cb_error (_("%s only valid with ORGANIZATION %s"), "MASS-UPDATE", "INDEXED");
	}
  }
#line 17159 "parser.c"
    break;

  case 393: /* organization: INDEXED  */
#line 5681 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_INDEXED, "INDEXED");
	current_file->organization = COB_ORG_INDEXED;
  }
#line 17169 "parser.c"
    break;

  case 394: /* organization: _record _binary SEQUENTIAL  */
#line 5687 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_SEQUENTIAL, "SEQUENTIAL");
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 17179 "parser.c"
    break;

  case 395: /* organization: RELATIVE  */
#line 5693 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_RELATIVE, "RELATIVE");
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 17189 "parser.c"
    break;

  case 396: /* organization: LINE SEQUENTIAL  */
#line 5699 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_LINE_SEQUENTIAL,
						"LINE SEQUENTIAL");
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 17200 "parser.c"
    break;

  case 397: /* padding_character_clause: PADDING _character _is reference_or_literal  */
#line 5712 "parser.y"
  {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 17209 "parser.c"
    break;

  case 398: /* $@32: %empty  */
#line 5722 "parser.y"
  {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
	current_file->flag_delimiter = 1;
  }
#line 17218 "parser.c"
    break;

  case 400: /* record_delimiter_option: "STANDARD-1"  */
#line 5731 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "STANDARD-1");
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("%s ignored"), "RECORD DELIMITER STANDARD-1");
	}
  }
#line 17233 "parser.c"
    break;

  case 401: /* record_delimiter_option: "LINE-SEQUENTIAL"  */
#line 5742 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with (LINE) SEQUENTIAL files"),
			  "LINE-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("LINE-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 17251 "parser.c"
    break;

  case 402: /* record_delimiter_option: "BINARY-SEQUENTIAL"  */
#line 5756 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "BINARY-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("BINARY-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_SEQUENTIAL;
	}
  }
#line 17268 "parser.c"
    break;

  case 403: /* record_delimiter_option: "Identifier"  */
#line 5769 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER clause only allowed with (LINE) SEQUENTIAL files"));
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("RECORD DELIMITER %s not recognized; will be ignored"), cb_name (yyvsp[0]));
	}
  }
#line 17283 "parser.c"
    break;

  case 404: /* record_key_clause: RECORD _key _is reference _split_keys _password_clause flag_duplicates  */
#line 5785 "parser.y"
  {
	cb_tree composite_key;

	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = yyvsp[-3];
	key_type = RECORD_KEY;

	/* handle split keys */
	if (yyvsp[-2]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field (yyvsp[-3]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			current_file->key = cb_build_field_reference ((struct cb_field *)composite_key, NULL);
			current_file->component_list = key_component_list;
		}
	}
	current_file->password = yyvsp[-1];
	if (yyvsp[0]) {
		/* note: we *may* add a compiler configuration here,
		         as most dialects do not allow this clause
		         on primary keys */
		if (CB_INTEGER (yyvsp[0])->val) {
			/* note: see ACUCOBOL docs for implementation notes, including [RE]WRITE rules
			         and "if the underlying (file) system does not support them OPEN
					 result in (sucessfull) io-status 0M" */
			CB_PENDING (_("DUPLICATES for primary keys"));
		};

	}
  }
#line 17322 "parser.c"
    break;

  case 405: /* _split_keys: %empty  */
#line 5823 "parser.y"
  {
  	yyval = NULL;
  }
#line 17330 "parser.c"
    break;

  case 406: /* _split_keys: source_is split_key_list  */
#line 5827 "parser.y"
  {
  	yyval = cb_int0;
  }
#line 17338 "parser.c"
    break;

  case 409: /* $@33: %empty  */
#line 5838 "parser.y"
  {
	key_component_list = NULL;
  }
#line 17346 "parser.c"
    break;

  case 412: /* split_key: reference  */
#line 5848 "parser.y"
  {
	struct cb_key_component *c;
	struct cb_key_component *comp = cobc_main_malloc (sizeof(struct cb_key_component));
	comp->next = NULL;
	comp->component = yyvsp[0];
	if (key_component_list == NULL) {
		key_component_list = comp;
	} else {
		for (c = key_component_list; c->next != NULL; c = c->next);
		c->next = comp;
	}
  }
#line 17363 "parser.c"
    break;

  case 413: /* relative_key_clause: RELATIVE _key _is reference  */
#line 5866 "parser.y"
  {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = yyvsp[0];
	key_type = RELATIVE_KEY;
  }
#line 17373 "parser.c"
    break;

  case 414: /* reserve_clause: RESERVE no_or_integer _areas  */
#line 5877 "parser.y"
  {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 17381 "parser.c"
    break;

  case 417: /* sharing_clause: SHARING _with sharing_option  */
#line 5891 "parser.y"
  {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = yyvsp[0];
  }
#line 17390 "parser.c"
    break;

  case 418: /* sharing_option: ALL _other  */
#line 5903 "parser.y"
                                { yyval = NULL; }
#line 17396 "parser.c"
    break;

  case 419: /* sharing_option: NO _other  */
#line 5904 "parser.y"
                                { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 17402 "parser.c"
    break;

  case 420: /* sharing_option: READ ONLY  */
#line 5905 "parser.y"
                                { yyval = NULL; }
#line 17408 "parser.c"
    break;

  case 421: /* file_limit_clause: file_limit_or_limits _is_are thru_list  */
#line 5912 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "FILE-LIMIT");
	check_repeated ("FILE-LIMIT", SYN_CLAUSE_13, &check_duplicate);
  }
#line 17417 "parser.c"
    break;

  case 424: /* actual_key_clause: ACTUAL _key _is reference  */
#line 5927 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "ACTUAL KEY");
	check_repeated ("ACTUAL KEY", SYN_CLAUSE_14, &check_duplicate);
  }
#line 17426 "parser.c"
    break;

  case 425: /* nominal_key_clause: NOMINAL _key _is reference  */
#line 5937 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "NOMINAL KEY");
	check_repeated ("NOMINAL KEY", SYN_CLAUSE_15, &check_duplicate);
  }
#line 17435 "parser.c"
    break;

  case 426: /* track_area_clause: "TRACK-AREA" _is reference_or_literal _characters  */
#line 5947 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-AREA");
	check_repeated ("TRACK-AREA", SYN_CLAUSE_16, &check_duplicate);
  }
#line 17444 "parser.c"
    break;

  case 427: /* track_limit_clause: "TRACK-LIMIT" _is integer track_or_tracks  */
#line 5957 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-LIMIT");
	check_repeated ("TRACK-LIMIT", SYN_CLAUSE_17, &check_duplicate);
  }
#line 17453 "parser.c"
    break;

  case 429: /* _i_o_control: i_o_control_header _i_o_control_entries  */
#line 5968 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 17461 "parser.c"
    break;

  case 430: /* i_o_control_header: "I-O-CONTROL" _dot  */
#line 5975 "parser.y"
{
	check_headers_present(COBC_HD_ENVIRONMENT_DIVISION,
				 COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
}
#line 17471 "parser.c"
    break;

  case 433: /* _i_o_control_entries: i_o_control_list error _dot_or_else_end_of_file_control  */
#line 5985 "parser.y"
  {
	yyerrok;
  }
#line 17479 "parser.c"
    break;

  case 440: /* same_clause: SAME _same_option _area _for file_name_list  */
#line 6006 "parser.y"
  {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER (yyvsp[-3])->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 17508 "parser.c"
    break;

  case 441: /* _same_option: %empty  */
#line 6033 "parser.y"
                                { yyval = cb_int0; }
#line 17514 "parser.c"
    break;

  case 442: /* _same_option: RECORD  */
#line 6034 "parser.y"
                                { yyval = cb_int1; }
#line 17520 "parser.c"
    break;

  case 443: /* _same_option: SORT  */
#line 6035 "parser.y"
                                { yyval = cb_int2; }
#line 17526 "parser.c"
    break;

  case 444: /* _same_option: "SORT-MERGE"  */
#line 6036 "parser.y"
                                { yyval = cb_int2; }
#line 17532 "parser.c"
    break;

  case 445: /* apply_clause: APPLY COMMIT _on reference_list  */
#line 6043 "parser.y"
  {
	current_program->apply_commit = yyvsp[0];
	CB_PENDING("APPLY COMMIT");
  }
#line 17541 "parser.c"
    break;

  case 446: /* apply_clause: APPLY "LOCK-HOLDING" _on file_name_list  */
#line 6048 "parser.y"
  {
	CB_PENDING ("APPLY LOCK-HOLDING");
  }
#line 17549 "parser.c"
    break;

  case 447: /* apply_clause: APPLY "PRINT-CONTROL" _on file_name_list  */
#line 6052 "parser.y"
  {
	CB_PENDING ("APPLY PRINT-CONTROL");
  }
#line 17557 "parser.c"
    break;

  case 449: /* apply_clause: obsolete_dos_vs_apply_phrase  */
#line 6057 "parser.y"
  {
	cb_verify (CB_OBSOLETE, _("DOS/VS APPLY phrase"));
  }
#line 17565 "parser.c"
    break;

  case 458: /* $@34: %empty  */
#line 6077 "parser.y"
  {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 17574 "parser.c"
    break;

  case 459: /* multiple_file_tape_clause: MULTIPLE $@34 _file _tape _contains multiple_file_list  */
#line 6082 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 17586 "parser.c"
    break;

  case 482: /* $@35: %empty  */
#line 6162 "parser.y"
  {
	current_storage = CB_STORAGE_WORKING;
  }
#line 17594 "parser.c"
    break;

  case 486: /* data: DATA  */
#line 6177 "parser.y"
           { check_area_a_of ("DATA DIVISION"); }
#line 17600 "parser.c"
    break;

  case 487: /* data_division_header: data DIVISION _dot  */
#line 6180 "parser.y"
  {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 17608 "parser.c"
    break;

  case 488: /* tok_file: "FILE"  */
#line 6187 "parser.y"
                   { check_area_a_of ("FILE SECTION"); }
#line 17614 "parser.c"
    break;

  case 490: /* _file_section_header: tok_file SECTION _dot  */
#line 6190 "parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 17624 "parser.c"
    break;

  case 493: /* file_description: file_description_entry _record_description_list  */
#line 6204 "parser.y"
  {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			/* Do not keep Record if this is really a report */
			if (!current_file->reports) {
				finalize_file (current_file, CB_FIELD (yyvsp[0]));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 17641 "parser.c"
    break;

  case 494: /* $@36: %empty  */
#line 6222 "parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE (yyvsp[0])) {
		current_file = NULL;
		YYERROR;
	}
	current_file = CB_FILE (cb_ref (yyvsp[0]));
	current_file->description_entry = yyvsp[0];
	if (CB_VALID_TREE (current_file)) {
		if (yyvsp[-1] == cb_int1) {
			current_file->organization = COB_ORG_SORT;
		}
		/* note: this is a HACK and should be moved */
		if (current_file->flag_finalized) {
			cb_error_x (yyvsp[0], _("duplicate file description for %s"),
				cb_name (CB_TREE (current_file)));
		}
	}
  }
#line 17668 "parser.c"
    break;

  case 496: /* file_description_entry: file_type error _dot_or_else_end_of_file_description  */
#line 6246 "parser.y"
  {
	yyerrok;
  }
#line 17676 "parser.c"
    break;

  case 497: /* file_type: FD  */
#line 6253 "parser.y"
  {
	check_area_a_of ("FD");
	yyval = cb_int0;
  }
#line 17685 "parser.c"
    break;

  case 498: /* file_type: SD  */
#line 6258 "parser.y"
  {
	check_area_a_of ("SD");
	yyval = cb_int1;
  }
#line 17694 "parser.c"
    break;

  case 501: /* file_description_clause: _is EXTERNAL  */
#line 6270 "parser.y"
  {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	current_file->flag_external = 1;
  }
#line 17708 "parser.c"
    break;

  case 502: /* file_description_clause: _is GLOBAL  */
#line 6280 "parser.y"
  {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 17727 "parser.c"
    break;

  case 512: /* block_contains_clause: BLOCK _contains integer _to_integer _records_or_characters  */
#line 6310 "parser.y"
  {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 17736 "parser.c"
    break;

  case 516: /* record_clause: RECORD _contains integer _characters  */
#line 6323 "parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (NULL, yyvsp[-1]);
	}
  }
#line 17749 "parser.c"
    break;

  case 517: /* record_clause: RECORD _contains integer TO integer _characters _record_depending  */
#line 6333 "parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (yyvsp[-4], yyvsp[-2]);
		if (yyvsp[0]) {
			cb_verify (cb_record_contains_depending_clause, "RECORD CONTAINS DEPENDING");
			current_file->record_depending = yyvsp[0];
			current_file->flag_check_record_varying_limits =
				current_file->record_min == 0 || current_file->record_max == 0;
		}
	}
  }
#line 17768 "parser.c"
    break;

  case 518: /* record_clause: RECORD _is VARYING _in _size _from_integer _to_integer _characters _record_depending  */
#line 6349 "parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	set_record_size (yyvsp[-3], yyvsp[-2]);
	current_file->record_depending = yyvsp[0];
	current_file->flag_check_record_varying_limits =
		current_file->record_min == 0 || current_file->record_max == 0;
  }
#line 17780 "parser.c"
    break;

  case 519: /* _record_depending: %empty  */
#line 6359 "parser.y"
                                { yyval = NULL; }
#line 17786 "parser.c"
    break;

  case 520: /* _record_depending: DEPENDING _on reference  */
#line 6360 "parser.y"
                                { yyval = yyvsp[0]; }
#line 17792 "parser.c"
    break;

  case 521: /* _from_integer: %empty  */
#line 6364 "parser.y"
                                { yyval = NULL; }
#line 17798 "parser.c"
    break;

  case 522: /* _from_integer: _from integer  */
#line 6365 "parser.y"
                                { yyval = yyvsp[0]; }
#line 17804 "parser.c"
    break;

  case 523: /* _to_integer: %empty  */
#line 6369 "parser.y"
                                { yyval = NULL; }
#line 17810 "parser.c"
    break;

  case 524: /* _to_integer: TO integer  */
#line 6370 "parser.y"
                                { yyval = yyvsp[0]; }
#line 17816 "parser.c"
    break;

  case 525: /* label_records_clause: LABEL records label_option  */
#line 6378 "parser.y"
  {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 17825 "parser.c"
    break;

  case 526: /* value_of_clause: VALUE OF file_id _is valueof_name  */
#line 6389 "parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 17834 "parser.c"
    break;

  case 527: /* value_of_clause: VALUE OF "FILE-ID" _is valueof_name  */
#line 6394 "parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
	}
  }
#line 17846 "parser.c"
    break;

  case 532: /* data_records_clause: DATA records optional_reference_list  */
#line 6417 "parser.y"
  {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 17855 "parser.c"
    break;

  case 533: /* linage_clause: LINAGE _is reference_or_literal _lines _linage_sequence  */
#line 6429 "parser.y"
  {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = yyvsp[-2];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 17874 "parser.c"
    break;

  case 539: /* linage_footing: _with FOOTING _at reference_or_literal  */
#line 6457 "parser.y"
  {
	current_file->latfoot = yyvsp[0];
  }
#line 17882 "parser.c"
    break;

  case 540: /* linage_top: TOP reference_or_literal  */
#line 6464 "parser.y"
  {
	current_file->lattop = yyvsp[0];
  }
#line 17890 "parser.c"
    break;

  case 541: /* linage_bottom: BOTTOM reference_or_literal  */
#line 6471 "parser.y"
  {
	current_file->latbot = yyvsp[0];
  }
#line 17898 "parser.c"
    break;

  case 542: /* recording_mode_clause: RECORDING _mode _is recording_mode  */
#line 6480 "parser.y"
  {
	cobc_cs_check ^= CB_CS_RECORDING;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 17908 "parser.c"
    break;

  case 547: /* recording_mode: u_or_s  */
#line 6493 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 17918 "parser.c"
    break;

  case 550: /* code_set_clause: "CODE-SET" _is alphabet_name _for_sub_records_clause  */
#line 6509 "parser.y"
  {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE (yyvsp[-1])) {
		al = CB_ALPHABET_NAME (cb_ref (yyvsp[-1]));
		/* FIXME: should be set depending on program alphabet */
		switch (al->alphabet_type) {
		case CB_ALPHABET_CUSTOM:
			CB_PENDING ("custom CODE-SET");
			current_file->code_set = al;
			break;
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
			CB_UNFINISHED ("CODE-SET");
			current_file->code_set = al;
			break;
		default:
			if (cb_warn_opt_val[cb_warn_additional] != COBC_WARN_DISABLED) {
				cb_note_x (cb_warn_additional, yyvsp[-1], _("ignoring CODE-SET '%s'"),
						  cb_name (yyvsp[-1]));
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

  }
#line 17959 "parser.c"
    break;

  case 552: /* _for_sub_records_clause: FOR reference_list  */
#line 6549 "parser.y"
  {
	  current_file->code_set_items = CB_LIST (yyvsp[0]);
  }
#line 17967 "parser.c"
    break;

  case 553: /* report_clause: report_keyword rep_name_list  */
#line 6558 "parser.y"
  {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = yyvsp[0];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->flag_line_adv = 1;
	}
  }
#line 17983 "parser.c"
    break;

  case 556: /* rep_name_list: undefined_word  */
#line 6578 "parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 18001 "parser.c"
    break;

  case 557: /* rep_name_list: rep_name_list undefined_word  */
#line 6592 "parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 18019 "parser.c"
    break;

  case 558: /* communication: COMMUNICATION  */
#line 6609 "parser.y"
                             { check_area_a_of ("COMMUNICATION SECTION"); }
#line 18025 "parser.c"
    break;

  case 560: /* $@37: %empty  */
#line 6612 "parser.y"
  {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define != CB_STD_85
	 && cb_std_define != CB_STD_RM
	 && cb_std_define != CB_STD_GC
	 && !cb_relaxed_syntax_checks) {
		cb_verify (CB_UNCONFORMABLE, "COMMUNICATION SECTION");
	} else if (cb_verify (CB_OBSOLETE, "COMMUNICATION SECTION")) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 18044 "parser.c"
    break;

  case 564: /* communication_description: communication_description_entry _record_description_list  */
#line 6636 "parser.y"
  {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			cb_finalize_cd (current_cd, CB_FIELD (yyvsp[0]));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 18058 "parser.c"
    break;

  case 565: /* cd: CD  */
#line 6649 "parser.y"
       { check_area_a_of ("CD"); }
#line 18064 "parser.c"
    break;

  case 566: /* $@38: %empty  */
#line 6652 "parser.y"
  {
	/* CD internally defines a new file */
	if (CB_VALID_TREE (yyvsp[0])) {
		current_cd = cb_build_cd (yyvsp[0]);

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TO-DO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 18086 "parser.c"
    break;

  case 613: /* working_storage: "WORKING-STORAGE"  */
#line 6759 "parser.y"
                                 { check_area_a_of ("WORKING-STORAGE SECTION"); }
#line 18092 "parser.c"
    break;

  case 615: /* $@39: %empty  */
#line 6763 "parser.y"
  {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 18102 "parser.c"
    break;

  case 616: /* _working_storage_section: working_storage SECTION _dot_or_else_end_of_record_description $@39 _record_description_list  */
#line 6769 "parser.y"
  {
	if (yyvsp[0]) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD (yyvsp[0]));
	}
  }
#line 18112 "parser.c"
    break;

  case 617: /* _record_description_list: %empty  */
#line 6778 "parser.y"
  {
	yyval = NULL;
  }
#line 18120 "parser.c"
    break;

  case 618: /* $@40: %empty  */
#line 6782 "parser.y"
  {
	current_field = NULL;
	control_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 18131 "parser.c"
    break;

  case 619: /* _record_description_list: $@40 record_description_list  */
#line 6789 "parser.y"
  {
	yyval = get_finalized_description_tree ();
  }
#line 18139 "parser.c"
    break;

  case 625: /* $@41: %empty  */
#line 6804 "parser.y"
  {
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		/* finalize last field if target of SAME AS / type-name */
		inherit_external_definition (yyvsp[-1]);
	}
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	save_tree = NULL;
  }
#line 18154 "parser.c"
    break;

  case 626: /* data_description: level_number _entry_name $@41 _data_description_clause_sequence  */
#line 6815 "parser.y"
  {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 18167 "parser.c"
    break;

  case 627: /* data_description: level_number error "."  */
#line 6824 "parser.y"
  {
#if 0 /* works fine without, leads to invalid free otherwise [COB_TREE_DEBUG] */
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-2]);
#endif
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if 0 /* CHECKME - *Why* would we want to change the field here? */
	current_field = cb_get_real_field ();
#endif
  }
#line 18185 "parser.c"
    break;

  case 628: /* level_number: not_const_word "level-number"  */
#line 6841 "parser.y"
  {
	int level = cb_get_level (yyvsp[0]);
	switch (level) {
	case 1:
	case 77:
		check_area_a (yyvsp[0]);
		break;
	default:
		break;
	}
	yyval = yyvsp[0];
  }
#line 18202 "parser.c"
    break;

  case 629: /* level_number: not_const_word "level-number (Area A)"  */
#line 6854 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18210 "parser.c"
    break;

  case 632: /* _entry_name: _filler  */
#line 6866 "parser.y"
  {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18221 "parser.c"
    break;

  case 634: /* user_entry_name: "Identifier"  */
#line 6877 "parser.y"
  {
	yyval = yyvsp[0];
	qualifier = yyvsp[0];
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18232 "parser.c"
    break;

  case 635: /* _const_global: %empty  */
#line 6887 "parser.y"
  {
	yyval = NULL;
  }
#line 18240 "parser.c"
    break;

  case 636: /* _const_global: _is GLOBAL  */
#line 6891 "parser.y"
  {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		yyval = NULL;
	} else {
		yyval = cb_null;
	}
  }
#line 18253 "parser.c"
    break;

  case 637: /* lit_or_length: literal  */
#line 6902 "parser.y"
                                        { yyval = yyvsp[0]; }
#line 18259 "parser.c"
    break;

  case 638: /* lit_or_length: length_of_register con_source  */
#line 6903 "parser.y"
                                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 18265 "parser.c"
    break;

  case 639: /* lit_or_length: "BYTE-LENGTH" _of con_source  */
#line 6905 "parser.y"
                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 18271 "parser.c"
    break;

  case 640: /* con_source: identifier_1  */
#line 6910 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18279 "parser.c"
    break;

  case 641: /* con_source: non_numeric_literal  */
#line 6914 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18287 "parser.c"
    break;

  case 642: /* con_source: "BINARY-CHAR"  */
#line 6920 "parser.y"
  {
	yyval = cb_int1;
  }
#line 18295 "parser.c"
    break;

  case 643: /* con_source: "BINARY-SHORT"  */
#line 6924 "parser.y"
  {
	yyval = cb_int2;
  }
#line 18303 "parser.c"
    break;

  case 644: /* con_source: "BINARY-LONG"  */
#line 6928 "parser.y"
  {
	yyval = cb_int4;
  }
#line 18311 "parser.c"
    break;

  case 645: /* con_source: "BINARY-DOUBLE"  */
#line 6932 "parser.y"
  {
	yyval = cb_int8;
  }
#line 18319 "parser.c"
    break;

  case 646: /* con_source: "BINARY-C-LONG"  */
#line 6936 "parser.y"
  {
	yyval = cb_int ((int)sizeof(long));
  }
#line 18327 "parser.c"
    break;

  case 647: /* con_source: pointer_len  */
#line 6940 "parser.y"
  {
	yyval = cb_int ((int)sizeof(void *));
  }
#line 18335 "parser.c"
    break;

  case 648: /* con_source: "COMP-1"  */
#line 6944 "parser.y"
  {
	if (cb_binary_comp_1) {
		yyval = cb_int2;
	} else {
		yyval = cb_int ((int)sizeof(float));
	}
  }
#line 18347 "parser.c"
    break;

  case 649: /* con_source: "FLOAT-SHORT"  */
#line 6952 "parser.y"
  {
	yyval = cb_int ((int)sizeof(float));
  }
#line 18355 "parser.c"
    break;

  case 650: /* con_source: double_usage  */
#line 6956 "parser.y"
  {
	yyval = cb_int ((int)sizeof(double));
  }
#line 18363 "parser.c"
    break;

  case 651: /* con_source: fp32_usage  */
#line 6960 "parser.y"
  {
	yyval = cb_int4;
  }
#line 18371 "parser.c"
    break;

  case 652: /* con_source: fp64_usage  */
#line 6964 "parser.y"
  {
	yyval = cb_int8;
  }
#line 18379 "parser.c"
    break;

  case 653: /* con_source: fp128_usage  */
#line 6968 "parser.y"
  {
	yyval = cb_int16;
  }
#line 18387 "parser.c"
    break;

  case 654: /* con_source: error "."  */
#line 6972 "parser.y"
  {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 18399 "parser.c"
    break;

  case 664: /* renames_entry: "level-number 66" user_entry_name RENAMES not_const_word qualified_word _renames_thru  */
#line 7004 "parser.y"
  {
	cb_tree renames_target = cb_ref (yyvsp[-1]);

	size_t sav = cb_needs_01;
	cb_needs_01 = 0;

	non_const_word = 0;

	if (set_current_field (yyvsp[-5], yyvsp[-4])) {
		/* error in the definition, no further checks possible */
	} else if (renames_target == cb_error_node) {
		/* error in the target, skip further checks */
		current_field->flag_invalid = 1;
	} else {
		cb_tree renames_thru = yyvsp[0];

		current_field->redefines = CB_FIELD (renames_target);
		if (renames_thru) {
			renames_thru = cb_ref (renames_thru);
		}
		if (CB_VALID_TREE (renames_thru)) {
			current_field->rename_thru = CB_FIELD (renames_thru);
		} else {
			/* If there is no THRU clause, RENAMES acts like REDEFINES. */
			current_field->pic = current_field->redefines->pic;
		}

		if (cb_validate_renames_item (current_field, yyvsp[-1], yyvsp[0])) {
			current_field->flag_invalid = 1;
		} else {
			/* ensure the reference was validated as this
			   also calculates the reference' picture and size */
			if (!current_field->redefines->flag_is_verified) {
				cb_validate_field (current_field->redefines);
			}
		}
	}
	cb_needs_01 = sav;
  }
#line 18443 "parser.c"
    break;

  case 665: /* _renames_thru: %empty  */
#line 7047 "parser.y"
  {
	yyval = NULL;
  }
#line 18451 "parser.c"
    break;

  case 666: /* _renames_thru: THRU qualified_word  */
#line 7051 "parser.y"
  {
	yyval = yyvsp[0] == cb_error_node ? NULL : yyvsp[0];
  }
#line 18459 "parser.c"
    break;

  case 667: /* $@42: %empty  */
#line 7058 "parser.y"
  {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 18469 "parser.c"
    break;

  case 668: /* condition_name_entry: "level-number 88" _user_entry_name $@42 value_clause_condition  */
#line 7064 "parser.y"
  {
	cb_validate_88_item (current_field);
  }
#line 18477 "parser.c"
    break;

  case 669: /* _user_entry_name: %empty  */
#line 7071 "parser.y"
  {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18488 "parser.c"
    break;

  case 671: /* constant_entry: level_number user_entry_name CONSTANT _const_global constant_source  */
#line 7082 "parser.y"
  {
	cb_tree x;
	int	level;

	cobc_cs_check = 0;
	level = cb_get_level (yyvsp[-4]);
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-4]);
	if (level != 1) {
		cb_error (_("CONSTANT item not at 01 level"));
	} else if (yyvsp[0]) {
		if (cb_verify (cb_constant_01, "01 CONSTANT")) {
			x = cb_build_constant (yyvsp[-3], yyvsp[0]);
			CB_FIELD (x)->flag_item_78 = 1;
			CB_FIELD (x)->flag_constant = 1;
			CB_FIELD (x)->level = 1;
			CB_FIELD (x)->values = yyvsp[0];
			cb_needs_01 = 1;
			if (yyvsp[-1]) {
				CB_FIELD (x)->flag_is_global = 1;
			}
			/* Ignore return value */
			(void)cb_validate_78_item (CB_FIELD (x), 0);
		}
	}
  }
#line 18519 "parser.c"
    break;

  case 672: /* $@43: %empty  */
#line 7109 "parser.y"
  {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 18529 "parser.c"
    break;

  case 673: /* constant_entry: "level-number 78" user_entry_name $@43 _global_clause VALUE _is constant_78_source  */
#line 7116 "parser.y"
  {
	/* Reset to last non-78 item */
	current_field = cb_validate_78_item (current_field, 0);
  }
#line 18538 "parser.c"
    break;

  case 674: /* constant_source: _as constant_expression_list  */
#line 7124 "parser.y"
  {
	/* this can be a list containing an arithmetic expression */
	if (CB_LIST_P (yyvsp[0]) && !CB_CHAIN (yyvsp[0])) {
		yyval = CB_VALUE (yyvsp[0]);
	} else {
		yyval = yyvsp[0];
	}
  }
#line 18551 "parser.c"
    break;

  case 675: /* constant_source: FROM "Identifier"  */
#line 7133 "parser.y"
  {
	yyval = cb_build_const_from (yyvsp[0]);
  }
#line 18559 "parser.c"
    break;

  case 676: /* constant_78_source: constant_expression_list  */
#line 7140 "parser.y"
  {
	/* this can be a list containing an arithmetic expression */
	if (CB_VALID_TREE (current_field)) {
		if (CB_LIST_P (yyvsp[0]) && !CB_CHAIN (yyvsp[0])) {
			current_field->values = CB_VALUE (yyvsp[0]);
		} else {
			current_field->values = yyvsp[0];
		}
	}
  }
#line 18574 "parser.c"
    break;

  case 677: /* constant_78_source: START _of identifier  */
#line 7151 "parser.y"
  {
	current_field->values = cb_build_const_start (current_field, yyvsp[0]);
  }
#line 18582 "parser.c"
    break;

  case 678: /* constant_78_source: NEXT  */
#line 7155 "parser.y"
  {
	current_field->values = cb_build_const_next (current_field);
  }
#line 18590 "parser.c"
    break;

  case 679: /* constant_expression_list: constant_expression  */
#line 7161 "parser.y"
                                        { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 18596 "parser.c"
    break;

  case 680: /* constant_expression_list: constant_expression_list constant_expression  */
#line 7162 "parser.y"
                                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 18602 "parser.c"
    break;

  case 681: /* constant_expression: lit_or_length  */
#line 7166 "parser.y"
                                { yyval = yyvsp[0]; }
#line 18608 "parser.c"
    break;

  case 682: /* constant_expression: "("  */
#line 7167 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("(", 1); }
#line 18614 "parser.c"
    break;

  case 683: /* constant_expression: ")"  */
#line 7168 "parser.y"
                                { yyval = cb_build_alphanumeric_literal (")", 1); }
#line 18620 "parser.c"
    break;

  case 684: /* constant_expression: "+"  */
#line 7169 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("+", 1); }
#line 18626 "parser.c"
    break;

  case 685: /* constant_expression: "-"  */
#line 7170 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("-", 1); }
#line 18632 "parser.c"
    break;

  case 686: /* constant_expression: "*"  */
#line 7171 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("*", 1); }
#line 18638 "parser.c"
    break;

  case 687: /* constant_expression: "/"  */
#line 7172 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("/", 1); }
#line 18644 "parser.c"
    break;

  case 688: /* constant_expression: AND  */
#line 7173 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("&", 1); }
#line 18650 "parser.c"
    break;

  case 689: /* constant_expression: OR  */
#line 7174 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("|", 1); }
#line 18656 "parser.c"
    break;

  case 690: /* constant_expression: "exponentiation operator"  */
#line 7175 "parser.y"
                                { yyval = cb_build_alphanumeric_literal ("^", 1); }
#line 18662 "parser.c"
    break;

  case 693: /* data_description_clause_sequence: data_description_clause  */
#line 7185 "parser.y"
  {
	save_tree = cb_int0;
  }
#line 18670 "parser.c"
    break;

  case 724: /* data_description_clause: data_varying_clause  */
#line 7222 "parser.y"
  {
	CB_PENDING ("VALIDATE");
  }
#line 18678 "parser.c"
    break;

  case 725: /* redefines_clause: REDEFINES identifier_1  */
#line 7232 "parser.y"
  {
	check_repeated ("REDEFINES", SYN_CLAUSE_1, &check_pic_duplicate);
	if (save_tree != NULL) {
		cb_verify_x (yyvsp[0], cb_free_redefines_position,
			     _("REDEFINES clause not following entry-name"));
	}

	current_field->redefines = cb_resolve_redefines (current_field, yyvsp[0]);
	if (current_field->redefines == NULL) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		YYERROR;
	}
  }
#line 18697 "parser.c"
    break;

  case 726: /* like_clause: LIKE identifier_field _length_modifier  */
#line 7253 "parser.y"
  {
	if (!check_repeated ("LIKE", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		setup_external_definition (yyvsp[-1], 0);
		current_field->like_modifier = yyvsp[0];
		CB_PENDING_X (yyvsp[-1], "LIKE clause");
	}
  }
#line 18712 "parser.c"
    break;

  case 727: /* _length_modifier: %empty  */
#line 7266 "parser.y"
                { yyval = cb_int0; }
#line 18718 "parser.c"
    break;

  case 728: /* _length_modifier: length_modifier  */
#line 7267 "parser.y"
                        { yyval = yyvsp[0]; }
#line 18724 "parser.c"
    break;

  case 729: /* length_modifier: "(" nonzero_numeric_literal ")"  */
#line 7271 "parser.y"
  {
	yyval = yyvsp[-1];
  }
#line 18732 "parser.c"
    break;

  case 730: /* same_as_clause: SAME _as identifier_field  */
#line 7280 "parser.y"
  {
	if (!check_repeated ("SAME AS", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		cb_verify (cb_same_as_clause, _("SAME AS clause"));
		setup_external_definition (yyvsp[0], 0);
	}


  }
#line 18748 "parser.c"
    break;

  case 731: /* typedef_clause: _is TYPEDEF _strong  */
#line 7299 "parser.y"
  {
	if (current_field->flag_is_typedef) {
		emit_duplicate_clause_message ("TYPEDEF");
		YYERROR;
	}
	/* note: no explicit verification as all dialects with this reserved word use it */
	current_field->flag_is_typedef = 1;
	within_typedef_definition = 1;

	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "TYPEDEF");
	}
	if (!qualifier) {
		cb_error (_("%s requires a data name"), "TYPEDEF");
	}
	if (current_storage == CB_STORAGE_SCREEN
	 || current_storage == CB_STORAGE_REPORT) {
		cb_error (_("%s not allowed in %s"), "TYPEDEF",
			enum_explain_storage(current_storage));
	}
  }
#line 18774 "parser.c"
    break;

  case 733: /* _strong: STRONG  */
#line 7324 "parser.y"
  {
	CB_PENDING ("TYPEDEF STRONG");
  }
#line 18782 "parser.c"
    break;

  case 734: /* external_clause: _is EXTERNAL _as_extname  */
#line 7334 "parser.y"
  {
	check_repeated ("EXTERNAL", SYN_CLAUSE_2, &check_pic_duplicate);
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "EXTERNAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_is_global) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "REDEFINES");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	} else {
		current_field->flag_external = 1;
		current_program->flag_has_external = 1;
	}
  }
#line 18810 "parser.c"
    break;

  case 735: /* _as_extname: %empty  */
#line 7361 "parser.y"
  {
	current_field->ename = cb_to_cname (current_field->name);
  }
#line 18818 "parser.c"
    break;

  case 736: /* _as_extname: AS "Literal"  */
#line 7365 "parser.y"
  {
	current_field->ename = cb_to_cname ((const char *)CB_LITERAL (yyvsp[0])->data);
  }
#line 18826 "parser.c"
    break;

  case 739: /* global_clause: _is GLOBAL  */
#line 7378 "parser.y"
  {
	check_repeated ("GLOBAL", SYN_CLAUSE_3, &check_pic_duplicate);
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "GLOBAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "GLOBAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else if (current_storage == CB_STORAGE_LOCAL) {
		cb_error (_("%s not allowed here"), "GLOBAL");
	} else {
		current_field->flag_is_global = 1;
	}
  }
#line 18849 "parser.c"
    break;

  case 740: /* $@44: %empty  */
#line 7402 "parser.y"
  {
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_verify (cb_special_names_clause, "SPECIAL-NAMES clause");
	}
  }
#line 18861 "parser.c"
    break;

  case 742: /* special_names_target: CURSOR  */
#line 7414 "parser.y"
  {
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		current_program->cursor_pos = cb_build_reference (current_field->name);
	}
  }
#line 18873 "parser.c"
    break;

  case 743: /* special_names_target: CRT STATUS  */
#line 7422 "parser.y"
  {
	if (current_program->crt_status) {
		emit_duplicate_clause_message ("CRT STATUS");
	} else {
		current_program->crt_status = cb_build_reference (current_field->name);
	}
  }
#line 18885 "parser.c"
    break;

  case 744: /* special_names_target: "SCREEN CONTROL"  */
#line 7439 "parser.y"
  {
#if 0 /* not yet implemented */
	if (current_program->screen_control) {
		emit_duplicate_clause_message ("SCREEN CONTROL");
	} else {
		CB_PENDING ("SCREEN CONTROL");
	}
#else
	CB_PENDING ("SCREEN CONTROL");
#endif
  }
#line 18901 "parser.c"
    break;

  case 745: /* special_names_target: "EVENT STATUS"  */
#line 7451 "parser.y"
  {
#if 0 /* not yet implemented */
	if (current_program->event_status) {
		emit_duplicate_clause_message ("EVENT STATUS");
	} else {
		CB_PENDING ("EVENT STATUS");
	}
#else
	CB_PENDING ("EVENT STATUS");
#endif
  }
#line 18917 "parser.c"
    break;

  case 746: /* $@45: %empty  */
#line 7468 "parser.y"
  {
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_ ("%s only allowed at 01/77 level"), "SELECT WHEN");
	}
	CB_PENDING ("SELECT WHEN");
  }
#line 18928 "parser.c"
    break;

  case 750: /* format_clause: FORMAT format_choice _data  */
#line 7486 "parser.y"
  {
	CB_PENDING ("FORMAT");
  }
#line 18936 "parser.c"
    break;

  case 751: /* format_choice: BIT  */
#line 7492 "parser.y"
                { yyval = cb_int0; }
#line 18942 "parser.c"
    break;

  case 752: /* format_choice: CHARACTER  */
#line 7493 "parser.y"
                { yyval = cb_int1; }
#line 18948 "parser.c"
    break;

  case 753: /* format_choice: NUMERIC  */
#line 7494 "parser.y"
                { yyval = cb_int2; }
#line 18954 "parser.c"
    break;

  case 754: /* volatile_clause: VOLATILE  */
#line 7501 "parser.y"
  {
	check_repeated ("VOLATILE", SYN_CLAUSE_24, &check_pic_duplicate);
	/* note: there is no reason to check current_storage as we only parse
	         volatile_clause and its parent tokens where applicable,
	         same is true for level 66,78,88 */
	/* missing part: always generate and initialize storage */
	CB_UNFINISHED ("VOLATILE");
	current_field->flag_volatile = 1;
	/* TODO: set VOLATILE flag for all parent fields */
  }
#line 18969 "parser.c"
    break;

  case 755: /* $@46: %empty  */
#line 7518 "parser.y"
  {
	check_repeated ("PICTURE", SYN_CLAUSE_4, &check_pic_duplicate);
	current_field->pic = CB_PICTURE (yyvsp[0]);	/* always returned, invalid picture will have size == 0 */
  }
#line 18978 "parser.c"
    break;

  case 756: /* picture_clause: PICTURE $@46 _pic_locale_format_or_depending_on  */
#line 7523 "parser.y"
  {
	if ((!current_field->pic || current_field->pic->variable_length) &&
	    !current_field->flag_picture_l) {
		/* Current field with PIC L was not translated */
		cb_error_x (CB_TREE (current_field->pic),
			      _("%s requires DEPENDING clause"),
			      _("variable-length PICTURE"));
	}
  }
#line 18992 "parser.c"
    break;

  case 758: /* _pic_locale_format_or_depending_on: LOCALE _is_locale_name SIZE _is integer  */
#line 7537 "parser.y"
  {
	/* $2 -> optional locale-name to be used */
	if (  (current_field->pic->category != CB_CATEGORY_NUMERIC
	    && current_field->pic->category != CB_CATEGORY_NUMERIC_EDITED)
	   || strpbrk (current_field->pic->orig, " CRDBL-*")) {
		/* CHECKME: the standard seems to forbid additional ',' */
		cb_error_x (CB_TREE (current_field->pic),
			      _("a locale-format PICTURE string must only consist of '9', '.', '+', 'Z' and the currency-sign"));
	} else {
		/* TODO: check that not we're not within a CONSTANT RECORD */
		CB_PENDING_X (CB_TREE (current_field->pic), "locale-format PICTURE");
	}
  }
#line 19010 "parser.c"
    break;

  case 759: /* _pic_locale_format_or_depending_on: DEPENDING _on reference  */
#line 7551 "parser.y"
  {
	cb_tree depending = yyvsp[0];
	if (!current_field->pic->variable_length) {
		cb_error_x (yyvsp[0], _("DEPENDING clause needs either an "
				    "OCCURS clause or a variable-length "
				    "PICTURE"));
	} else
	if (current_field->pic->category != CB_CATEGORY_ALPHABETIC
	 && current_field->pic->category != CB_CATEGORY_ALPHANUMERIC) {
		cb_error_x (yyvsp[0], _("only USAGE DISPLAY may specify a "
				    "variable-length PICTURE"));
	} else
	if (current_storage == CB_STORAGE_SCREEN
	 || current_storage == CB_STORAGE_REPORT) {
		cb_error_x (yyvsp[0], _("%s not allowed in %s"),
			      _("variable-length PICTURE"),
			      enum_explain_storage (current_storage));
	} else {
		  /* Implicitly translate `PIC Lc... DEPENDING N` (where
		     `c` may actually only be `X` or `A`) into a group
		     with a single sub-field `PIC c OCCURS 1 TO N`. */
		  const char pic[2] = { current_field->pic->orig[1], 0};
		  struct cb_field * const chld =
			  CB_FIELD (cb_build_field (cb_build_filler ()));
		  chld->pic = cb_build_picture (pic);
		  chld->storage = current_field->storage;
		  chld->depending = depending;
		  chld->flag_occurs = 1;
		  chld->occurs_min = 1;
		  chld->occurs_max = current_field->pic->size - 1;
		  chld->parent = current_field;
		  current_field->children = chld;
		  cobc_parse_free (current_field->pic);
		  current_field->pic = NULL;
	}
	/* Raise this flag in the error cases above, to avoid unrelated
	   warning or error messages upon tentative validation of
	   redefines.  */
	current_field->flag_picture_l = 1;
  }
#line 19055 "parser.c"
    break;

  case 760: /* _is_locale_name: %empty  */
#line 7595 "parser.y"
  {
	yyval = NULL;
  }
#line 19063 "parser.c"
    break;

  case 761: /* _is_locale_name: _is locale_name  */
#line 7599 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 19071 "parser.c"
    break;

  case 762: /* locale_name: "Identifier"  */
#line 7606 "parser.y"
  {
	if (CB_LOCALE_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a locale-name"),	cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 19084 "parser.c"
    break;

  case 763: /* type_to_clause: TYPE _to type_name  */
#line 7620 "parser.y"
  {
	cb_verify (cb_type_to_clause, _("TYPE TO clause"));
	setup_external_definition_type (yyvsp[0]);
  }
#line 19093 "parser.c"
    break;

  case 766: /* usage_clause: USAGE _is "Identifier"  */
#line 7636 "parser.y"
  {
	{
		cb_tree x = cb_try_ref (yyvsp[0]);
		if (!CB_INVALID_TREE (x) && CB_FIELD_P (x) && CB_FIELD (x)->flag_is_typedef) {
			if (!check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate)) {
				if (current_field->external_definition) {
					emit_conflicting_clause_message ("USAGE", "SAME AS / TYPE TO");
				} else {
					cb_verify (cb_usage_type_name, _("USAGE type-name"));
					/* replace usage by type definition */
					check_pic_duplicate &= ~SYN_CLAUSE_5;
					check_repeated ("USAGE/TYPE", SYN_CLAUSE_31, &check_pic_duplicate);
					setup_external_definition (yyvsp[0], 1);
					break;	/* everything done here */
				}
			}
			YYERROR;
		}
	}
	if (is_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not a valid USAGE"), CB_NAME (yyvsp[0]));
	} else if (is_default_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not defined, but is a reserved word in another dialect"),
				CB_NAME (yyvsp[0]));
	} else {
		cb_error_x (yyvsp[0], _("unknown USAGE: %s"), CB_NAME (yyvsp[0]));
	}
	check_and_set_usage (CB_USAGE_ERROR);
	YYERROR;
  }
#line 19128 "parser.c"
    break;

  case 767: /* usage_clause: USAGE _is error  */
#line 7667 "parser.y"
  {
	check_and_set_usage (CB_USAGE_ERROR);
  }
#line 19136 "parser.c"
    break;

  case 770: /* usage: BINARY  */
#line 7678 "parser.y"
  {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 19144 "parser.c"
    break;

  case 771: /* usage: BIT  */
#line 7682 "parser.y"
  {
	check_and_set_usage (CB_USAGE_BIT);
	CB_PENDING ("USAGE BIT");
  }
#line 19153 "parser.c"
    break;

  case 772: /* usage: BIT ALIGNED  */
#line 7687 "parser.y"
  {
	/* note: ALIGNED actually is a separate clause but at least
	         for now we simplify it, requesting it after USAGE BIT */
	check_and_set_usage (CB_USAGE_BIT);
	CB_PENDING ("USAGE BIT");
  }
#line 19164 "parser.c"
    break;

  case 773: /* usage: COMP  */
#line 7694 "parser.y"
  {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 19172 "parser.c"
    break;

  case 774: /* usage: "COMP-0"  */
#line 7698 "parser.y"
  {
	/* see FR #310 */
	CB_PENDING ("USAGE COMP-0");
  }
#line 19181 "parser.c"
    break;

  case 775: /* usage: "COMP-1"  */
#line 7703 "parser.y"
  {
	current_field->flag_comp_1 = 1;
	if (cb_binary_comp_1) {
		check_and_set_usage (CB_USAGE_SIGNED_SHORT);
	} else {
		check_and_set_usage (CB_USAGE_FLOAT);
	}
  }
#line 19194 "parser.c"
    break;

  case 776: /* usage: double_usage  */
#line 7712 "parser.y"
  {
	check_and_set_usage (CB_USAGE_DOUBLE);
  }
#line 19202 "parser.c"
    break;

  case 777: /* usage: "COMP-3"  */
#line 7716 "parser.y"
  {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 19210 "parser.c"
    break;

  case 778: /* usage: "COMP-4"  */
#line 7720 "parser.y"
  {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 19218 "parser.c"
    break;

  case 779: /* usage: "COMP-5"  */
#line 7724 "parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_5);
  }
#line 19226 "parser.c"
    break;

  case 780: /* usage: "COMP-6"  */
#line 7728 "parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_6);
  }
#line 19234 "parser.c"
    break;

  case 781: /* usage: "COMP-X"  */
#line 7732 "parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_X);
  }
#line 19242 "parser.c"
    break;

  case 782: /* usage: "COMP-N"  */
#line 7736 "parser.y"
  {
	check_and_set_usage (CB_USAGE_COMP_N);
  }
#line 19250 "parser.c"
    break;

  case 783: /* usage: "FLOAT-SHORT"  */
#line 7740 "parser.y"
  {
	check_and_set_usage (CB_USAGE_FLOAT);
  }
#line 19258 "parser.c"
    break;

  case 784: /* usage: DISPLAY  */
#line 7744 "parser.y"
  {
	check_and_set_usage (CB_USAGE_DISPLAY);
  }
#line 19266 "parser.c"
    break;

  case 785: /* usage: INDEX  */
#line 7748 "parser.y"
  {
	check_and_set_usage (CB_USAGE_INDEX);
  }
#line 19274 "parser.c"
    break;

  case 786: /* usage: "PACKED-DECIMAL"  */
#line 7752 "parser.y"
  {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 19282 "parser.c"
    break;

  case 787: /* usage: POINTER  */
#line 7756 "parser.y"
  {
	check_and_set_usage (CB_USAGE_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 19291 "parser.c"
    break;

  case 788: /* usage: "PROGRAM-POINTER"  */
#line 7761 "parser.y"
  {
	check_and_set_usage (CB_USAGE_PROGRAM_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 19300 "parser.c"
    break;

  case 789: /* usage: HANDLE  */
#line 7766 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL);
  }
#line 19308 "parser.c"
    break;

  case 790: /* usage: HANDLE _of WINDOW  */
#line 7770 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_WINDOW);
  }
#line 19316 "parser.c"
    break;

  case 791: /* usage: HANDLE _of SUBWINDOW  */
#line 7774 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_SUBWINDOW);
  }
#line 19324 "parser.c"
    break;

  case 792: /* usage: HANDLE _of FONT _font_name  */
#line 7778 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_FONT);
	CB_PENDING ("HANDLE OF FONT");
  }
#line 19333 "parser.c"
    break;

  case 793: /* usage: HANDLE _of THREAD  */
#line 7783 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_THREAD);
  }
#line 19341 "parser.c"
    break;

  case 794: /* usage: HANDLE _of MENU  */
#line 7787 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_MENU);
	CB_PENDING ("HANDLE OF MENU");
  }
#line 19350 "parser.c"
    break;

  case 795: /* usage: HANDLE _of VARIANT  */
#line 7792 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_VARIANT);
  }
#line 19358 "parser.c"
    break;

  case 796: /* usage: HANDLE _of "LAYOUT-MANAGER" _layout_name  */
#line 7796 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL_LM);
	CB_PENDING ("HANDLE OF LAYOUT-MANAGER");
  }
#line 19367 "parser.c"
    break;

  case 797: /* usage: HANDLE _of control_type_name  */
#line 7801 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL);
	CB_PENDING ("HANDLE OF control-type");
  }
#line 19376 "parser.c"
    break;

  case 798: /* usage: HANDLE _of "Identifier"  */
#line 7806 "parser.y"
  {
	check_and_set_usage (CB_USAGE_HNDL);
	cb_error_x (yyvsp[0], _("unknown HANDLE type: %s"), CB_NAME (yyvsp[0]));
  }
#line 19385 "parser.c"
    break;

  case 799: /* usage: "SIGNED-SHORT"  */
#line 7811 "parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 19393 "parser.c"
    break;

  case 800: /* usage: "SIGNED-INT"  */
#line 7815 "parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 19401 "parser.c"
    break;

  case 801: /* usage: "SIGNED-LONG"  */
#line 7819 "parser.y"
  {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 19413 "parser.c"
    break;

  case 802: /* usage: "UNSIGNED-SHORT"  */
#line 7827 "parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 19421 "parser.c"
    break;

  case 803: /* usage: "UNSIGNED-INT"  */
#line 7831 "parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 19429 "parser.c"
    break;

  case 804: /* usage: "UNSIGNED-LONG"  */
#line 7835 "parser.y"
  {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 19441 "parser.c"
    break;

  case 805: /* usage: "BINARY-CHAR" _signed  */
#line 7843 "parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_CHAR);
  }
#line 19449 "parser.c"
    break;

  case 806: /* usage: "BINARY-CHAR" UNSIGNED  */
#line 7847 "parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_CHAR);
  }
#line 19457 "parser.c"
    break;

  case 807: /* usage: "BINARY-SHORT" _signed  */
#line 7851 "parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 19465 "parser.c"
    break;

  case 808: /* usage: "BINARY-SHORT" UNSIGNED  */
#line 7855 "parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 19473 "parser.c"
    break;

  case 809: /* usage: "BINARY-LONG" _signed  */
#line 7859 "parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 19481 "parser.c"
    break;

  case 810: /* usage: "BINARY-LONG" UNSIGNED  */
#line 7863 "parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 19489 "parser.c"
    break;

  case 811: /* usage: "BINARY-DOUBLE" _signed  */
#line 7867 "parser.y"
  {
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
  }
#line 19497 "parser.c"
    break;

  case 812: /* usage: "BINARY-DOUBLE" UNSIGNED  */
#line 7871 "parser.y"
  {
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
  }
#line 19505 "parser.c"
    break;

  case 813: /* usage: "BINARY-C-LONG" _signed  */
#line 7875 "parser.y"
  {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 19517 "parser.c"
    break;

  case 814: /* usage: "BINARY-C-LONG" UNSIGNED  */
#line 7883 "parser.y"
  {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 19529 "parser.c"
    break;

  case 815: /* usage: "FLOAT-BINARY-32"  */
#line 7891 "parser.y"
  {
	check_and_set_usage (CB_USAGE_FP_BIN32);
  }
#line 19537 "parser.c"
    break;

  case 816: /* usage: "FLOAT-BINARY-64"  */
#line 7895 "parser.y"
  {
	check_and_set_usage (CB_USAGE_FP_BIN64);
  }
#line 19545 "parser.c"
    break;

  case 817: /* usage: "FLOAT-BINARY-128"  */
#line 7899 "parser.y"
  {
	check_and_set_usage (CB_USAGE_FP_BIN128);
  }
#line 19553 "parser.c"
    break;

  case 818: /* usage: "FLOAT-DECIMAL-16"  */
#line 7903 "parser.y"
  {
	check_and_set_usage (CB_USAGE_FP_DEC64);
  }
#line 19561 "parser.c"
    break;

  case 819: /* usage: "FLOAT-DECIMAL-34"  */
#line 7907 "parser.y"
  {
	check_and_set_usage (CB_USAGE_FP_DEC128);
  }
#line 19569 "parser.c"
    break;

  case 820: /* usage: NATIONAL  */
#line 7911 "parser.y"
  {
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	CB_UNFINISHED ("USAGE NATIONAL");
  }
#line 19578 "parser.c"
    break;

  case 821: /* conflict_usage: OBJECT REFERENCE _object_reference_type  */
#line 7920 "parser.y"
  {
	check_and_set_usage (CB_USAGE_OBJECT);
	CB_PENDING ("OBJECTS");
  }
#line 19587 "parser.c"
    break;

  case 828: /* _only: %empty  */
#line 7939 "parser.y"
              { yyval = NULL; }
#line 19593 "parser.c"
    break;

  case 829: /* _only: ONLY  */
#line 7940 "parser.y"
         { yyval = cb_int0; }
#line 19599 "parser.c"
    break;

  case 841: /* sign_clause: _sign_is LEADING flag_separate  */
#line 7967 "parser.y"
  {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = (yyvsp[0] ? 1 : 0);
	current_field->flag_sign_leading  = 1;
  }
#line 19610 "parser.c"
    break;

  case 842: /* sign_clause: _sign_is TRAILING flag_separate  */
#line 7974 "parser.y"
  {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = (yyvsp[0] ? 1 : 0);
	current_field->flag_sign_leading  = 0;
  }
#line 19621 "parser.c"
    break;

  case 843: /* report_occurs_clause: OCCURS integer _occurs_to_integer _times _occurs_depending report_occurs_step  */
#line 7988 "parser.y"
  {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-4], yyvsp[-3]);
  }
#line 19631 "parser.c"
    break;

  case 845: /* report_occurs_step: STEP integer  */
#line 7997 "parser.y"
  {
	current_field->step_count = cb_get_int (yyvsp[0]);
  }
#line 19639 "parser.c"
    break;

  case 846: /* occurs_clause: OCCURS integer _occurs_to_integer _times _occurs_depending _occurs_keys_and_indexed  */
#line 8007 "parser.y"
  {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-4], yyvsp[-3]);
  }
#line 19649 "parser.c"
    break;

  case 847: /* occurs_clause: OCCURS _occurs_integer_to UNBOUNDED _times DEPENDING _on reference _occurs_keys_and_indexed  */
#line 8014 "parser.y"
  {
	current_field->flag_unbounded = 1;
	if (current_field->parent) {
		current_field->parent->flag_unbounded = 1;
	}
	current_field->depending = yyvsp[-1];
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-6], cb_int0);
  }
#line 19664 "parser.c"
    break;

  case 848: /* occurs_clause: OCCURS DYNAMIC _capacity_in _occurs_from_integer _occurs_to_integer _occurs_initialized _occurs_keys_and_indexed  */
#line 8026 "parser.y"
  {
	setup_occurs ();
	current_field->occurs_min = yyvsp[-3] ? cb_get_int (yyvsp[-3]) : 0;
	if (yyvsp[-2]) {
		current_field->occurs_max = cb_get_int (yyvsp[-2]);
		if (current_field->occurs_max <= current_field->occurs_min) {
			cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
		}
	} else {
		current_field->occurs_max = 0;
	}
	CB_PENDING ("OCCURS DYNAMIC");
  }
#line 19682 "parser.c"
    break;

  case 849: /* _occurs_from_integer: %empty  */
#line 8042 "parser.y"
                                { yyval = NULL; }
#line 19688 "parser.c"
    break;

  case 850: /* _occurs_from_integer: FROM integer  */
#line 8043 "parser.y"
                                { yyval = yyvsp[0]; }
#line 19694 "parser.c"
    break;

  case 851: /* _occurs_to_integer: %empty  */
#line 8047 "parser.y"
                                { yyval = NULL; }
#line 19700 "parser.c"
    break;

  case 852: /* _occurs_to_integer: TO integer  */
#line 8048 "parser.y"
                                { yyval = yyvsp[0]; }
#line 19706 "parser.c"
    break;

  case 853: /* _occurs_integer_to: %empty  */
#line 8052 "parser.y"
                                { yyval = NULL; }
#line 19712 "parser.c"
    break;

  case 854: /* _occurs_integer_to: integer TO  */
#line 8053 "parser.y"
                                { yyval = yyvsp[-1]; }
#line 19718 "parser.c"
    break;

  case 856: /* _occurs_depending: DEPENDING _on reference  */
#line 8058 "parser.y"
  {
	current_field->depending = yyvsp[0];
  }
#line 19726 "parser.c"
    break;

  case 858: /* _capacity_in: CAPACITY _in "Identifier"  */
#line 8064 "parser.y"
  {
	yyval = cb_build_index (yyvsp[0], cb_zero, 0, current_field);
	CB_FIELD_PTR (yyval)->index_type = CB_STATIC_INT_INDEX;
  }
#line 19735 "parser.c"
    break;

  case 860: /* _occurs_initialized: INITIALIZED  */
#line 8072 "parser.y"
  {
	/* current_field->initialized = 1; */
  }
#line 19743 "parser.c"
    break;

  case 863: /* $@47: %empty  */
#line 8081 "parser.y"
  {
	(void) cb_syntax_check (_("INDEXED should follow ASCENDING/DESCENDING"));
  }
#line 19751 "parser.c"
    break;

  case 867: /* occurs_keys: occurs_key_list  */
#line 8091 "parser.y"
  {
	cb_tree		l;
	struct cb_key	*keys;
	int		i;
	int		nkeys;

	l = yyvsp[0];
	nkeys = cb_list_length (yyvsp[0]);
	keys = cobc_parse_malloc (sizeof (struct cb_key) * nkeys);

	for (i = 0; i < nkeys; i++) {
		keys[i].dir = CB_PURPOSE_INT (l);
		keys[i].key = CB_VALUE (l);
		l = CB_CHAIN (l);
	}
	current_field->keys = keys;
	current_field->nkeys = nkeys;
  }
#line 19774 "parser.c"
    break;

  case 870: /* occurs_key_field: ascending_or_descending _key _is single_reference_list  */
#line 8118 "parser.y"
  {
	cb_tree ref = NULL;
	cb_tree rchain = NULL;
	cb_tree l;

	/* create reference chain all the way up
	   as later fields may have same name */
	if (!within_typedef_definition) {
		rchain = cb_build_full_field_reference (current_field->parent);
	}

	for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = yyvsp[-3];
		ref = CB_VALUE (l);
		if (CB_VALID_TREE(ref)) {
			CB_REFERENCE (ref)->chain = rchain;
		}
	}
	keys_list = cb_list_append (keys_list, yyvsp[0]);
	yyval = keys_list;
  }
#line 19800 "parser.c"
    break;

  case 871: /* ascending_or_descending: ASCENDING  */
#line 8142 "parser.y"
                                { yyval = cb_int (COB_ASCENDING); }
#line 19806 "parser.c"
    break;

  case 872: /* ascending_or_descending: DESCENDING  */
#line 8143 "parser.y"
                                { yyval = cb_int (COB_DESCENDING); }
#line 19812 "parser.c"
    break;

  case 875: /* occurs_indexed: INDEXED _by occurs_index_list  */
#line 8153 "parser.y"
  {
	current_field->index_list = yyvsp[0];
  }
#line 19820 "parser.c"
    break;

  case 876: /* occurs_index_list: occurs_index  */
#line 8159 "parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 19826 "parser.c"
    break;

  case 877: /* occurs_index_list: occurs_index_list occurs_index  */
#line 8161 "parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 19832 "parser.c"
    break;

  case 878: /* occurs_index: unqualified_word  */
#line 8166 "parser.y"
  {
	yyval = cb_build_index (yyvsp[0], cb_int1, 1U, current_field);
	CB_FIELD_PTR (yyval)->index_type = CB_STATIC_INT_INDEX;
  }
#line 19841 "parser.c"
    break;

  case 879: /* justified_clause: JUSTIFIED _right  */
#line 8177 "parser.y"
  {
	check_repeated ("JUSTIFIED", SYN_CLAUSE_8, &check_pic_duplicate);
	current_field->flag_justified = 1;
  }
#line 19850 "parser.c"
    break;

  case 880: /* synchronized_clause: SYNCHRONIZED _left_or_right  */
#line 8188 "parser.y"
  {
	check_repeated ("SYNCHRONIZED", SYN_CLAUSE_9, &check_pic_duplicate);
	if (cb_verify (cb_synchronized_clause, _("SYNCHRONIZED clause"))) {
		current_field->flag_synchronized = 1;
	}
	if (with_attrs && cb_verify (cb_sync_left_right, _("LEFT/RIGHT phrases in SYNCHRONIZED clause"))) {
		if (current_field->flag_synchronized) {
			if (with_attrs == 1) {
				current_field->flag_sync_left = 1;
			} else {
				current_field->flag_sync_right = 1;
			}
		}
		CB_PENDING ("SYNCHRONIZED LEFT/RIGHT");
	}
  }
#line 19871 "parser.c"
    break;

  case 881: /* _left_or_right: %empty  */
#line 8207 "parser.y"
                { with_attrs = 0; }
#line 19877 "parser.c"
    break;

  case 882: /* _left_or_right: LEFT  */
#line 8208 "parser.y"
                { with_attrs = 1; }
#line 19883 "parser.c"
    break;

  case 883: /* _left_or_right: RIGHT  */
#line 8209 "parser.y"
                { with_attrs = -1; }
#line 19889 "parser.c"
    break;

  case 884: /* blank_clause: BLANK _when ZERO  */
#line 8217 "parser.y"
  {
	check_repeated ("BLANK", SYN_CLAUSE_10, &check_pic_duplicate);
	current_field->flag_blank_zero = 1;
  }
#line 19898 "parser.c"
    break;

  case 885: /* based_clause: BASED  */
#line 8228 "parser.y"
  {
	check_repeated ("BASED", SYN_CLAUSE_11, &check_pic_duplicate);
	if (current_storage == CB_STORAGE_FILE) {
		cb_error (_("%s not allowed here"), "BASED");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "BASED");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "BASED");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "REDEFINES");
	} else if (current_field->flag_any_length) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else {
		current_field->flag_item_based = 1;
	}
  }
#line 19923 "parser.c"
    break;

  case 886: /* value_clause: VALUE _is value_item  */
#line 8255 "parser.y"
  {
	check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
	current_field->values = yyvsp[0];
  }
#line 19932 "parser.c"
    break;

  case 887: /* value_clause: VALUES _are value_table_item_list  */
#line 8269 "parser.y"
  {
	/* note: "VALUE _is" would also be correct, but we ignore that
	         because of parser conflicts */
	check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
	current_field->values = yyvsp[0];
  }
#line 19943 "parser.c"
    break;

  case 888: /* value_clause: VALUES _are value_item_list _repeated_phrase  */
#line 8277 "parser.y"
  {	
	/* note: "VALUE _is" would also be correct, but we ignore that
	         because of parser conflicts */
	cb_tree value_table_item = cb_build_table_values (yyvsp[-1], NULL, NULL, yyvsp[0]);
	/* note: this format can actually be specified multiple times,
	         but we expect the part without FROM first */
	check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
	current_field->values = CB_LIST_INIT (value_table_item);
  }
#line 19957 "parser.c"
    break;

  case 889: /* value_clause: VALUES from_subscripts _are value_item_list _repeated_phrase  */
#line 8288 "parser.y"
  {	
	/* note: "VALUE _is" would also be correct, but we ignore that
	         because of parser conflicts */
	cb_tree value_table_item = cb_build_table_values (yyvsp[-1], yyvsp[-3], NULL, yyvsp[0]);
	/* note: this format can actually be specified multiple times */
	if (!current_field->values) {
		check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
		current_field->values = CB_LIST_INIT (value_table_item);
	} else {
		current_field->values = cb_list_add (current_field->values, value_table_item);
	}
  }
#line 19974 "parser.c"
    break;

  case 890: /* value_table_item_list: value_table_item  */
#line 8303 "parser.y"
                                        { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 19980 "parser.c"
    break;

  case 891: /* value_table_item_list: value_table_item_list value_table_item  */
#line 8304 "parser.y"
                                         { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 19986 "parser.c"
    break;

  case 892: /* value_table_item: value_item_list from_subscripts _to_subscripts  */
#line 8309 "parser.y"
{
	/* note: actual matching to amount of subs (OCCURS) is
	         postponed as this phrase can be specified later
			 and/or in a higher level */

	cb_tree to_subs = yyvsp[0];
	if (to_subs) {
		if (cb_list_length (yyvsp[-1]) != cb_list_length (to_subs)) {
			cb_error_x (to_subs, _("amount of entries in FROM and TO must match"));
			to_subs = NULL;
		} else {
			cb_tree f = yyvsp[-1], t = to_subs;
			while (f) {
				int f_idx = cb_get_int (CB_VALUE (f));
				int t_idx = cb_get_int (CB_VALUE (t));
				if (f_idx > t_idx) {
					cb_error_x (yyvsp[-1],
						_("entry in FROM (%d) must be <= entry in TO (%d)"),
						f_idx, t_idx);
					break;
				}
				f = CB_CHAIN (f);
				t = CB_CHAIN (t);
			}
		}
	}
	yyval = cb_build_table_values (yyvsp[-2], yyvsp[-1], yyvsp[0], NULL);
  }
#line 20019 "parser.c"
    break;

  case 893: /* from_subscripts: FROM from_to_subscripts  */
#line 8340 "parser.y"
   