#! /bin/sh
# Copyright (C) 1996-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Test to make sure compiling Vala code really works with recursive make.

required="libtool libtoolize pkg-config valac gcc GNUmake"
. ./defs || Exit 1

mkdir src

cat >> 'configure.ac' << 'END'
AC_PROG_CC
AM_PROG_CC_C_O
AC_PROG_LIBTOOL
AM_PROG_VALAC([0.7.0])
PKG_CHECK_MODULES([GOBJECT], [gobject-2.0 >= 2.4])
AC_CONFIG_FILES([src/Makefile])
AC_OUTPUT
END

cat > 'Makefile.am' <<'END'
SUBDIRS = src
END

cat > 'src/Makefile.am' <<'END'
bin_PROGRAMS = zardoz
zardoz_VALAFLAGS = -H zardoz.h
zardoz_CFLAGS = $(GOBJECT_CFLAGS)
zardoz_LDADD = $(GOBJECT_LIBS)
zardoz_SOURCES = zardoz.vala
END

cat > 'src/zardoz.vala' <<'END'
using GLib;

public class Zardoz {
  public static void main () {
    stdout.printf ("Zardoz!\n");
  }
}
END

libtoolize

$ACLOCAL
$AUTOCONF
$AUTOMAKE -a

./configure || skip_ "configure failure"
$MAKE

# Test rebuild rules.
rm -f src/zardoz.h
$MAKE -C src zardoz.h

$MAKE distcheck
$MAKE distclean
mkdir build
cd build
../configure
$MAKE
$MAKE distcheck

# Test rebuild rules from builddir.
rm -f ../src/zardoz.c
$MAKE
grep 'Zardoz!' ../src/zardoz.c
sed 's/Zardoz!/FooBar!/' ../src/zardoz.c > t
mv -f t ../src/zardoz.c
$MAKE
grep 'FooBar!' ../src/zardoz.c
grep 'Zardoz!' ../src/zardoz.c && Exit 1

:
