#! /bin/sh
# Copyright (C) 2011-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Test to make sure vala support handles from-scratch VPATH builds.
# See automake bug#8753.

required="valac GNUmake"
. ./defs || Exit 1

cat >> configure.ac << 'END'
AC_CONFIG_SRCDIR([hello.vala])
AC_PROG_CC
AM_PROG_VALAC([0.7.3])
AC_OUTPUT
END

cat > Makefile.am <<'END'
bin_PROGRAMS = foo
foo_VALAFLAGS = --profile=posix
foo_SOURCES = hello.vala
END

cat > hello.vala <<'END'
void main ()
{
  stdout.printf ("foofoofoo\n");
}
END

$ACLOCAL  || framework_failure_ "aclocal error"
$AUTOCONF || framework_failure_ "autoconf error"
$AUTOMAKE || framework_failure_ "automake error"

mkdir build
cd build
../configure || Exit 77
$MAKE
grep foofoofoo ../hello.c
$MAKE distcheck

# Rebuild rules work also in VPATH builds.
cat > ../hello.vala <<'END'
int main ()
{
  stdout.printf ("barbarbar\n");
  return 0;
}
END

$MAKE
grep barbarbar ../hello.c

# Rebuild rules are not uselessly triggered.
$MAKE -q
$MAKE -n | grep '\.stamp' && Exit 1

:
