/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import org.apache.catalina.ant.BaseRedirectorHelperTask;
import org.apache.catalina.util.IOTools;
import org.apache.tools.ant.BuildException;

public abstract class AbstractCatalinaTask
extends BaseRedirectorHelperTask {
    private static final String CHARSET = "utf-8";
    protected String charset = "ISO-8859-1";
    protected String password = null;
    protected String url = "http://localhost:8080/manager/text";
    protected String username = null;
    protected boolean ignoreResponseConstraint = false;

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public boolean isIgnoreResponseConstraint() {
        return this.ignoreResponseConstraint;
    }

    public void setIgnoreResponseConstraint(boolean bl) {
        this.ignoreResponseConstraint = bl;
    }

    public void execute() throws BuildException {
        if (this.username == null || this.password == null || this.url == null) {
            throw new BuildException("Must specify all of 'username', 'password', and 'url'");
        }
    }

    public void execute(String string) throws BuildException {
        this.execute(string, null, null, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String string, InputStream inputStream, String string2, long l) throws BuildException {
        URLConnection uRLConnection = null;
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            Object object;
            Authenticator.setDefault(new TaskAuthenticator(this.username, this.password));
            URI uRI = new URI(this.url + string);
            uRI.parseServerAuthority();
            uRLConnection = uRI.toURL().openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            if (inputStream != null) {
                this.preAuthenticate();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestMethod("PUT");
                if (string2 != null) {
                    httpURLConnection.setRequestProperty("Content-Type", string2);
                }
                if (l >= 0L) {
                    httpURLConnection.setRequestProperty("Content-Length", "" + l);
                    httpURLConnection.setFixedLengthStreamingMode(l);
                }
            } else {
                httpURLConnection.setDoOutput(false);
                httpURLConnection.setRequestMethod("GET");
            }
            httpURLConnection.setRequestProperty("User-Agent", "Catalina-Ant-Task/1.0");
            httpURLConnection.connect();
            if (inputStream != null) {
                try {
                    object = httpURLConnection.getOutputStream();
                    try {
                        IOTools.flow((InputStream)inputStream, (OutputStream)object);
                    }
                    finally {
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream(), CHARSET);
            object = new StringBuilder();
            String string3 = null;
            int n2 = 2;
            boolean bl = true;
            while ((n = inputStreamReader.read()) >= 0) {
                if (n == 13 || n == 10) {
                    if (((StringBuilder)object).length() <= 0) continue;
                    String string4 = ((StringBuilder)object).toString();
                    ((StringBuilder)object).setLength(0);
                    if (!this.ignoreResponseConstraint && bl) {
                        if (!string4.startsWith("OK -")) {
                            string3 = string4;
                            n2 = 0;
                        }
                        bl = false;
                    }
                    this.handleOutput(string4, n2);
                    continue;
                }
                ((StringBuilder)object).append((char)n);
            }
            if (((StringBuilder)object).length() > 0) {
                this.handleOutput(((StringBuilder)object).toString(), n2);
            }
            if (string3 != null && this.isFailOnError()) {
                throw new BuildException(string3);
            }
        }
        catch (Exception exception) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)exception);
            }
            this.handleErrorOutput(exception.getMessage());
        }
        finally {
            this.closeRedirector();
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
                inputStreamReader = null;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void preAuthenticate() throws IOException, URISyntaxException {
        URLConnection uRLConnection = null;
        URI uRI = new URI(this.url);
        uRI.parseServerAuthority();
        uRLConnection = uRI.toURL().openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(false);
        httpURLConnection.setRequestMethod("OPTIONS");
        httpURLConnection.setRequestProperty("User-Agent", "Catalina-Ant-Task/1.0");
        httpURLConnection.connect();
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            IOTools.flow((InputStream)inputStream, null);
        }
    }

    private static class TaskAuthenticator
    extends Authenticator {
        private final String user;
        private final String password;

        private TaskAuthenticator(String string, String string2) {
            this.user = string;
            this.password = string2;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

