/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.MathBg;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class EgChar
extends Macro
implements SingleToken {
    private int charCode;

    public EgChar() {
        this(125);
    }

    public EgChar(int n) {
        this.charCode = n;
    }

    public EgChar(TeXParser teXParser) {
        this(teXParser.getEgChar());
    }

    @Override
    public Object clone() {
        return new EgChar(this.charCode);
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public int getCatCode() {
        return 2;
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        throw new TeXSyntaxException(teXParser, "tex.error.unexpected_eg", new Object[0]);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        throw new TeXSyntaxException(teXParser, "tex.error.unexpected_eg", new Object[0]);
    }

    public String show(TeXParser teXParser) throws IOException {
        return String.format("end-group character %s", this.format());
    }

    public boolean matches(BgChar bgChar) {
        return !(bgChar instanceof MathBg);
    }
}

