# frozen_string_literal: true

class RemoveNamespaceIdForeignKeyFromVulnerabilityReads < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  disable_ddl_transaction!

  OLD_CONSTRAINT_NAME = 'fk_4f593f6c62'

  def up
    with_lock_retries do
      remove_foreign_key_if_exists(:vulnerability_reads, column: :namespace_id, on_delete: :cascade,
        name: OLD_CONSTRAINT_NAME)
    end
  end

  def down
    add_concurrent_foreign_key(:vulnerability_reads, :namespaces, column: :namespace_id, on_delete: :cascade,
      name: OLD_CONSTRAINT_NAME)
  end
end
