/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.freeplane.features.icon.IconNotFound;
import org.freeplane.features.icon.MindIcon;

public class IconGroup {
    private final String name;
    private final List<IconGroup> groups;
    private MindIcon groupIcon;
    private final String description;

    public IconGroup(String groupName, MindIcon groupIcon) {
        this(groupName, groupIcon, groupIcon.getTranslatedDescription());
    }

    public IconGroup(MindIcon groupIcon) {
        this(groupIcon.getName(), groupIcon);
    }

    public IconGroup(String name, MindIcon groupIcon, String description) {
        this(name, groupIcon, description, new ArrayList<IconGroup>());
    }

    public void addIcons(Collection<MindIcon> icons) {
        icons.stream().map(IconGroup::new).forEach(this::addGroup);
    }

    public IconGroup(String name, MindIcon groupIcon, String description, List<IconGroup> groups) {
        this.name = name;
        this.groupIcon = groupIcon;
        this.description = description;
        this.groups = groups;
    }

    public String getName() {
        return this.name;
    }

    public List<IconGroup> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public List<MindIcon> getIcons() {
        if (this.isLeaf()) {
            return Collections.singletonList(this.getGroupIcon());
        }
        ArrayList<MindIcon> icons = new ArrayList<MindIcon>();
        this.groups.stream().map(IconGroup::getIcons).forEach(icons::addAll);
        return icons;
    }

    public MindIcon getGroupIcon() {
        if (this.groupIcon == null) {
            this.groupIcon = new IconNotFound("?");
        }
        return this.groupIcon;
    }

    public String getDescription() {
        return this.description;
    }

    public void addGroups(Collection<IconGroup> groups) {
        groups.stream().forEach(this::addGroup);
    }

    public void addGroup(IconGroup group) {
        this.groups.add(group);
        if (this.groupIcon == null) {
            this.groupIcon = group.getGroupIcon();
        }
    }

    public int hashCode() {
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        throw new RuntimeException();
    }

    public String toString() {
        return String.format("icon group [%s]", this.name);
    }

    public boolean isLeaf() {
        return this.groups.isEmpty();
    }
}

